sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/common/thirdparty/base/types/ValueState","sap/ui/webc/common/thirdparty/base/FeaturesRegistry","sap/ui/webc/common/thirdparty/base/Keys","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/util/AriaLabelHelper","sap/ui/webc/common/thirdparty/base/util/Caret","sap/ui/webc/common/thirdparty/icons/decline","sap/ui/webc/common/thirdparty/icons/not-editable","./types/InputType","./Popover","./generated/templates/InputTemplate.lit","./generated/templates/InputPopoverTemplate.lit","./generated/i18n/i18n-defaults","./generated/themes/Input.css","./generated/themes/ResponsivePopoverCommon.css","./generated/themes/ValueStateMessage.css","./generated/themes/Suggestions.css"],function(e,t,s,i,n,o,a,u,r,h,l,g,c,p,d,f,S,v,m,I,_,T){"use strict";function y(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var w=y(e);var E=y(t);var C=y(s);var b=y(n);var P=y(u);const A=new RegExp(/(\+|-)?\d+(\.|,)\d+/);const N={tag:"ui5-input",languageAware:true,managedSlots:true,slots:{icon:{type:HTMLElement},default:{propertyName:"suggestionItems",type:HTMLElement},formSupport:{type:HTMLElement},valueStateMessage:{type:HTMLElement}},properties:{disabled:{type:Boolean},highlight:{type:Boolean},placeholder:{type:String},readonly:{type:Boolean},required:{type:Boolean},type:{type:p,defaultValue:p.Text},value:{type:String},valueState:{type:b,defaultValue:b.None},name:{type:String},showSuggestions:{type:Boolean},maxlength:{type:P},accessibleName:{type:String},accessibleNameRef:{type:String,defaultValue:""},focused:{type:Boolean},_isValueStateFocused:{type:Boolean},open:{type:Boolean},_input:{type:Object},_inputAccInfo:{type:Object},_nativeInputAttributes:{type:Object},_inputWidth:{type:P},_listWidth:{type:P},_isPopoverOpen:{type:Boolean,noAttribute:true},_inputIconFocused:{type:Boolean,noAttribute:true}},events:{change:{},input:{},"suggestion-item-select":{detail:{item:{type:HTMLElement}}},"suggestion-item-preview":{detail:{item:{type:HTMLElement},targetRef:{type:HTMLElement}}},"suggestion-scroll":{detail:{scrollTop:{type:P},scrollContainer:{type:HTMLElement}}}}};class V extends w{static get metadata(){return N}static get render(){return E}static get template(){return f}static get staticAreaTemplate(){return S}static get styles(){return m}static get staticAreaStyles(){return[I,_,T]}constructor(){super();this.hasSuggestionItemSelected=false;this.valueBeforeItemSelection="";this.valueBeforeItemPreview="";this.suggestionSelectionCanceled=false;this._changeFired=false;this.previousValue=undefined;this.firstRendering=true;this.highlightValue="";this.lastConfirmedValue="";this._backspaceKeyDown=false;this.EVENT_CHANGE="change";this.EVENT_INPUT="input";this.EVENT_SUGGESTION_ITEM_SELECT="suggestion-item-select";this.ACTION_ENTER="enter";this.ACTION_USER_INPUT="input";this.suggestionsTexts=[];this._handleResizeBound=this._handleResize.bind(this)}onEnterDOM(){C.register(this,this._handleResizeBound)}onExitDOM(){C.deregister(this,this._handleResizeBound)}onBeforeRendering(){if(this.showSuggestions){this.enableSuggestions();this.suggestionsTexts=this.Suggestions.defaultSlotProperties(this.highlightValue)}this.open=this.open&&(!!this.suggestionItems.length||this._isPhone);const e=o.getFeature("FormSupport");if(e){e.syncNativeHiddenInput(this)}else if(this.name){console.warn(`In order for the "name" property to have effect, you should also: import "@ui5/webcomponents/dist/features/InputElementsFormSupport.js";`)}}async onAfterRendering(){if(this.Suggestions){this.Suggestions.toggle(this.open,{preventFocusRestore:true});this._listWidth=await this.Suggestions._getListWidth()}if(this.shouldDisplayOnlyValueStateMessage){this.openPopover()}else{this.closePopover()}}_onkeydown(e){if(a.isUp(e)){return this._handleUp(e)}if(a.isDown(e)){return this._handleDown(e)}if(a.isSpace(e)){return this._handleSpace(e)}if(a.isTabNext(e)){return this._handleTab(e)}if(a.isEnter(e)){return this._handleEnter(e)}if(a.isEscape(e)){return this._handleEscape(e)}if(a.isBackSpace(e)){this._backspaceKeyDown=true;this._selectedText=window.getSelection().toString()}if(this.showSuggestions){this._clearPopoverFocusAndSelection()}this._keyDown=true}_onkeyup(e){this._keyDown=false;this._backspaceKeyDown=false}_handleUp(e){if(this.Suggestions&&this.Suggestions.isOpened()){this.Suggestions.onUp(e)}}_handleDown(e){if(this.Suggestions&&this.Suggestions.isOpened()){this.Suggestions.onDown(e)}}_handleSpace(e){if(this.Suggestions){this.Suggestions.onSpace(e)}}_handleTab(e){if(this.Suggestions&&this.previousValue!==this.value){this.Suggestions.onTab(e)}}_handleEnter(e){const t=!!(this.Suggestions&&this.Suggestions.onEnter(e));if(!t){this.fireEventByAction(this.ACTION_ENTER);this.lastConfirmedValue=this.value;return}this.focused=true}_handleEscape(){const e=this.showSuggestions&&!!this.Suggestions;const t=e&&this.open;if(!t){this.value=this.lastConfirmedValue?this.lastConfirmedValue:this.previousValue;return}if(e&&t&&this.Suggestions._isItemOnTarget()){this.value=this.valueBeforeItemPreview;this.suggestionSelectionCanceled=true;this.focused=true}if(this._isValueStateFocused){this._isValueStateFocused=false;this.focused=true}this.open=false}async _onfocusin(e){await this.getInputDOMRef();this.focused=true;this.previousValue=this.value;this.valueBeforeItemPreview=this.value;this._inputIconFocused=e.target&&e.target===this.querySelector("[ui5-icon]")}_onfocusout(e){const t=this.Suggestions&&e.relatedTarget&&e.relatedTarget.shadowRoot&&e.relatedTarget.shadowRoot.contains(this.Suggestions.responsivePopover);const s=e.relatedTarget&&e.relatedTarget.shadowRoot&&e.relatedTarget.shadowRoot.querySelector(".ui5-valuestatemessage-root");if(t||s){e.stopImmediatePropagation();return}const i=e.relatedTarget;if(i&&i.classList.contains(this._id)){return}this.closePopover();this._clearPopoverFocusAndSelection();this.previousValue="";this.lastConfirmedValue="";this.focused=false;this.open=false}_clearPopoverFocusAndSelection(){if(!this.showSuggestions||!this.Suggestions){return}this._isValueStateFocused=false;this.hasSuggestionItemSelected=false;this.Suggestions._deselectItems();this.Suggestions._clearItemFocus()}_click(e){if(i.isPhone()&&!this.readonly&&this.Suggestions){this.blur();this.open=true}}_handleChange(e){if(!this._changeFired){this.fireEvent(this.EVENT_CHANGE)}this._changeFired=false}_scroll(e){const t=e.detail;this.fireEvent("suggestion-scroll",{scrollTop:t.scrollTop,scrollContainer:t.targetRef})}async _handleInput(e){const t=await this.getInputDOMRef();const s=this.value&&this.isTypeNumber&&!t.value;this.suggestionSelectionCanceled=false;if(s&&!this._backspaceKeyDown){return}if(s&&this._backspaceKeyDown){if(A.test(this.value)&&this._selectedText!==this.value){const e=this.removeFractionalPart(this.value);this.value=e;this.highlightValue=e;this.valueBeforeItemPreview=e;this.fireEvent(this.EVENT_INPUT);this.fireEvent("value-changed");return}}if(e.target===t){this.focused=true;e.stopImmediatePropagation()}const n=t.value===this.value&&i.isIE()&&!this._keyDown&&!!this.placeholder;!n&&this.fireEventByAction(this.ACTION_USER_INPUT);this.hasSuggestionItemSelected=false;this._isValueStateFocused=false;if(this.Suggestions){this.Suggestions.updateSelectedItemPosition(null);if(!this._isPhone){this.open=!!t.value}}}_handleResize(){this._inputWidth=this.offsetWidth}_closeRespPopover(e){this.Suggestions.close(e)}async _afterOpenPopover(){if(i.isPhone()){(await this.getInputDOMRef()).focus()}}_afterClosePopover(){this.announceSelectedItem();if(i.isPhone()){this.blur();this.focused=false}}isValueStateOpened(){return!!this._isPopoverOpen}async openPopover(){const e=await this._getPopover();if(e){this._isPopoverOpen=true;e.showAt(this)}}async closePopover(){const e=await this._getPopover();e&&e.close()}async _getPopover(){const e=await this.getStaticAreaItemDomRef();return e&&e.querySelector("[ui5-popover]")}enableSuggestions(){if(this.Suggestions){return}const e=o.getFeature("InputSuggestions");if(e){this.Suggestions=new e(this,"suggestionItems",true)}else{throw new Error(`You have to import "@ui5/webcomponents/dist/features/InputSuggestions.js" module to use ui5-input suggestions`)}}selectSuggestion(e,t){if(e.group){return}const s=e.text||e.textContent;const i=t?this.valueBeforeItemSelection!==s:this.value!==s;this.hasSuggestionItemSelected=true;if(i){this.value=s;this.valueBeforeItemSelection=s;this.lastConfirmedValue=s;this.fireEvent(this.EVENT_INPUT);this.fireEvent(this.EVENT_CHANGE);this._changeFired=true}this.valueBeforeItemPreview="";this.suggestionSelectionCanceled=false;this.fireEvent(this.EVENT_SUGGESTION_ITEM_SELECT,{item:e})}previewSuggestion(e){this.valueBeforeItemSelection=this.value;this.updateValueOnPreview(e);this.announceSelectedItem();this._previewItem=e}updateValueOnPreview(e){const t=e.type==="Inactive"||e.group;const s=t?this.valueBeforeItemPreview:e.effectiveTitle||e.textContent;this.value=s}get previewItem(){if(!this._previewItem){return null}return this.getSuggestionByListItem(this._previewItem)}async fireEventByAction(e){await this.getInputDOMRef();if(this.disabled||this.readonly){return}const t=await this.getInputValue();const s=e===this.ACTION_USER_INPUT;const n=await this.getInputDOMRef();const o=n.selectionStart;this.value=t;this.highlightValue=t;this.valueBeforeItemPreview=t;if(i.isSafari()){setTimeout(()=>{n.selectionStart=o;n.selectionEnd=o},0)}if(s){this.fireEvent(this.EVENT_INPUT);this.fireEvent("value-changed");return}const a=this.previousValue!==undefined&&this.previousValue!==this.value;if(i.isIE()&&e===this.ACTION_ENTER&&a){this.fireEvent(this.EVENT_CHANGE)}}async getInputValue(){const e=this.getDomRef();if(e){return(await this.getInputDOMRef()).value}return""}async getInputDOMRef(){if(i.isPhone()&&this.Suggestions){await this.Suggestions._getSuggestionPopover();return this.Suggestions&&this.Suggestions.responsivePopover.querySelector(".ui5-input-inner-phone")}return this.nativeInput}get nativeInput(){return this.getDomRef()&&this.getDomRef().querySelector(`input`)}get nativeInputWidth(){return this.nativeInput&&this.nativeInput.offsetWidth}getLabelableElementId(){return this.getInputId()}getSuggestionByListItem(e){const t=parseInt(e.getAttribute("data-ui5-key"));return this.suggestionItems[t]}isSuggestionsScrollable(){if(!this.Suggestions){return Promise.resolve(false)}return this.Suggestions._isScrollable()}getInputId(){return`${this._id}-inner`}onItemFocused(){}onItemMouseOver(e){const t=e.target;const s=this.getSuggestionByListItem(t);s&&s.fireEvent("mouseover",{item:s,targetRef:t})}onItemMouseOut(e){const t=e.target;const s=this.getSuggestionByListItem(t);s&&s.fireEvent("mouseout",{item:s,targetRef:t})}onItemSelected(e,t){this.selectSuggestion(e,t)}onItemPreviewed(e){this.previewSuggestion(e);this.fireEvent("suggestion-item-preview",{item:this.getSuggestionByListItem(e),targetRef:e})}onOpen(){}onClose(){}valueStateTextMappings(){return{Success:V.i18nBundle.getText(v.VALUE_STATE_SUCCESS),Information:V.i18nBundle.getText(v.VALUE_STATE_INFORMATION),Error:V.i18nBundle.getText(v.VALUE_STATE_ERROR),Warning:V.i18nBundle.getText(v.VALUE_STATE_WARNING)}}announceSelectedItem(){const e=this.shadowRoot.querySelector(`#${this._id}-selectionText`);if(this.Suggestions&&this.Suggestions._isItemOnTarget()){e.textContent=this.itemSelectionAnnounce}else{e.textContent=""}}get _readonly(){return this.readonly&&!this.disabled}get _headerTitleText(){return V.i18nBundle.getText(v.INPUT_SUGGESTIONS_TITLE)}get inputType(){return this.type.toLowerCase()}get isTypeNumber(){return this.type===p.Number}get suggestionsTextId(){return this.showSuggestions?`${this._id}-suggestionsText`:""}get valueStateTextId(){return this.hasValueState?`${this._id}-valueStateDesc`:""}get accInfo(){const e=this.showSuggestions?"true":undefined;const t=this.showSuggestions?"list":undefined;const s=this._inputAccInfo.ariaDescribedBy?`${this.suggestionsTextId} ${this.valueStateTextId} ${this._inputAccInfo.ariaDescribedBy}`.trim():`${this.suggestionsTextId} ${this.valueStateTextId}`.trim();return{input:{ariaRoledescription:this._inputAccInfo&&(this._inputAccInfo.ariaRoledescription||undefined),ariaDescribedBy:s||undefined,ariaInvalid:this.valueState===b.Error?"true":undefined,ariaHasPopup:this._inputAccInfo.ariaHasPopup?this._inputAccInfo.ariaHasPopup:e,ariaAutoComplete:this._inputAccInfo.ariaAutoComplete?this._inputAccInfo.ariaAutoComplete:t,role:this._inputAccInfo&&this._inputAccInfo.role,ariaControls:this._inputAccInfo&&this._inputAccInfo.ariaControls,ariaExpanded:this._inputAccInfo&&this._inputAccInfo.ariaExpanded,ariaDescription:this._inputAccInfo&&this._inputAccInfo.ariaDescription,ariaLabel:this._inputAccInfo&&this._inputAccInfo.ariaLabel||h.getEffectiveAriaLabelText(this)}}}get nativeInputAttributes(){return{min:this.isTypeNumber?this._nativeInputAttributes.min:undefined,max:this.isTypeNumber?this._nativeInputAttributes.max:undefined,step:this.isTypeNumber?this._nativeInputAttributes.step||"any":undefined}}get ariaValueStateHiddenText(){if(!this.hasValueStateMessage){return}if(this.shouldDisplayDefaultValueStateMessage){return this.valueStateText}return this.valueStateMessageText.map(e=>e.textContent).join(" ")}get itemSelectionAnnounce(){return this.Suggestions?this.Suggestions.itemSelectionAnnounce:undefined}get classes(){return{popover:{"ui5-suggestions-popover":!this.isPhone&&this.showSuggestions,"ui5-suggestions-popover-with-value-state-header":!this.isPhone&&this.showSuggestions&&this.hasValueStateMessage},popoverValueState:{"ui5-valuestatemessage-root":true,"ui5-valuestatemessage-header":true,"ui5-valuestatemessage--success":this.valueState===b.Success,"ui5-valuestatemessage--error":this.valueState===b.Error,"ui5-valuestatemessage--warning":this.valueState===b.Warning,"ui5-valuestatemessage--information":this.valueState===b.Information}}}get styles(){const e=parseInt(getComputedStyle(document.documentElement).fontSize);const t={popoverHeader:{"max-width":`${this._inputWidth}px`},suggestionPopoverHeader:{display:this._listWidth===0?"none":"inline-block",width:`${this._listWidth}px`},suggestionsPopover:{"min-width":`${this._inputWidth}px`,"max-width":this._inputWidth/e>40?`${this._inputWidth}px`:"40rem"},innerInput:{}};if(this.nativeInputWidth<48){t.innerInput.padding="0"}return t}get suggestionSeparators(){return"None"}get valueStateMessageText(){return this.getSlottedNodes("valueStateMessage").map(e=>e.cloneNode(true))}get shouldDisplayOnlyValueStateMessage(){return this.hasValueStateMessage&&!this.open&&this.focused}get shouldDisplayDefaultValueStateMessage(){return!this.valueStateMessage.length&&this.hasValueStateMessage}get hasValueState(){return this.valueState!==b.None}get hasValueStateMessage(){return this.hasValueState&&this.valueState!==b.Success&&(!this._inputIconFocused||this._isPhone&&this.Suggestions)}get valueStateText(){return this.valueStateTextMappings()[this.valueState]}get suggestionsText(){return V.i18nBundle.getText(v.INPUT_SUGGESTIONS)}get availableSuggestionsCount(){if(this.showSuggestions&&(this.value||this.Suggestions.isOpened())){switch(this.suggestionsTexts.length){case 0:return V.i18nBundle.getText(v.INPUT_SUGGESTIONS_NO_HIT);case 1:return V.i18nBundle.getText(v.INPUT_SUGGESTIONS_ONE_HIT);default:return V.i18nBundle.getText(v.INPUT_SUGGESTIONS_MORE_HITS,this.suggestionsTexts.length)}}return undefined}get step(){return this.isTypeNumber?"any":undefined}get _isPhone(){return i.isPhone()}get _placeholder(){return this.placeholder}get _valueStateInputIcon(){const e={Error:`<path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" clip-rule="evenodd" d="M10 20C4.47715 20 0 15.5228 0 10C0 4.47715 4.47715 0 10 0C15.5228 0 20 4.47715 20 10C20 15.5228 15.5228 20 10 20ZM7.70711 13.7071C7.31658 14.0976 6.68342 14.0976 6.29289 13.7071C5.90237 13.3166 5.90237 12.6834 6.29289 12.2929L8.58579 10L6.29289 7.70711C5.90237 7.31658 5.90237 6.68342 6.29289 6.29289C6.68342 5.90237 7.31658 5.90237 7.70711 6.29289L10 8.58579L12.2929 6.29289C12.6834 5.90237 13.3166 5.90237 13.7071 6.29289C14.0976 6.68342 14.0976 7.31658 13.7071 7.70711L11.4142 10L13.7071 12.2929C14.0976 12.6834 14.0976 13.3166 13.7071 13.7071C13.3166 14.0976 12.6834 14.0976 12.2929 13.7071L10 11.4142L7.70711 13.7071Z" fill="#EE3939"/>`,Warning:`<path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" clip-rule="evenodd" d="M11.8619 0.49298C11.6823 0.187541 11.3544 0 11 0C10.6456 0 10.3177 0.187541 10.1381 0.49298L0.138066 17.493C-0.0438112 17.8022 -0.0461447 18.1851 0.13195 18.4965C0.310046 18.8079 0.641283 19 1 19H21C21.3587 19 21.69 18.8079 21.868 18.4965C22.0461 18.1851 22.0438 17.8022 21.8619 17.493L11.8619 0.49298ZM11 6C11.5523 6 12 6.44772 12 7V10C12 10.5523 11.5523 11 11 11C10.4477 11 10 10.5523 10 10V7C10 6.44772 10.4477 6 11 6ZM11 16C11.8284 16 12.5 15.3284 12.5 14.5C12.5 13.6716 11.8284 13 11 13C10.1716 13 9.5 13.6716 9.5 14.5C9.5 15.3284 10.1716 16 11 16Z" fill="#F58B00"/>`,Success:`<path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" clip-rule="evenodd" d="M0 10C0 15.5228 4.47715 20 10 20C15.5228 20 20 15.5228 20 10C20 4.47715 15.5228 0 10 0C4.47715 0 0 4.47715 0 10ZM14.7071 6.29289C14.3166 5.90237 13.6834 5.90237 13.2929 6.29289L8 11.5858L6.70711 10.2929C6.31658 9.90237 5.68342 9.90237 5.29289 10.2929C4.90237 10.6834 4.90237 11.3166 5.29289 11.7071L7.29289 13.7071C7.68342 14.0976 8.31658 14.0976 8.70711 13.7071L14.7071 7.70711C15.0976 7.31658 15.0976 6.68342 14.7071 6.29289Z" fill="#36A41D"/>`,Information:`<path xmlns="http://www.w3.org/2000/svg" fill-rule="evenodd" clip-rule="evenodd" d="M3 0C1.34315 0 0 1.34315 0 3V15C0 16.6569 1.34315 18 3 18H15C16.6569 18 18 16.6569 18 15V3C18 1.34315 16.6569 0 15 0H3ZM9 6.5C9.82843 6.5 10.5 5.82843 10.5 5C10.5 4.17157 9.82843 3.5 9 3.5C8.17157 3.5 7.5 4.17157 7.5 5C7.5 5.82843 8.17157 6.5 9 6.5ZM9 8.5C9.55228 8.5 10 8.94772 10 9.5V13.5C10 14.0523 9.55228 14.5 9 14.5C8.44771 14.5 8 14.0523 8 13.5V9.5C8 8.94772 8.44771 8.5 9 8.5Z" fill="#1B90FF"/>`};const t=`\n\t\t<svg xmlns="http://www.w3.org/2000/svg" width="24" height="20" viewBox="0 0 20 20" fill="none">\n\t\t\t${e[this.valueState]};\n\t\t</svg>\n\t\t`;return this.valueState!==b.None?t:""}get _valueStateMessageInputIcon(){const e={Error:"error",Warning:"alert",Success:"sys-enter-2",Information:"information"};return this.valueState!==b.None?e[this.valueState]:""}getCaretPosition(){return l.getCaretPosition(this.nativeInput)}setCaretPosition(e){l.setCaretPosition(this.nativeInput,e)}removeFractionalPart(e){if(e.includes(".")){return e.slice(0,e.indexOf("."))}if(e.includes(",")){return e.slice(0,e.indexOf(","))}return e}static get dependencies(){const e=o.getFeature("InputSuggestions");return[d].concat(e?e.dependencies:[])}static async onDefine(){const e=o.getFeature("InputSuggestions");[V.i18nBundle]=await Promise.all([r.getI18nBundle("@ui5/webcomponents"),e?e.init():Promise.resolve()])}}V.define();return V});