/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","sap/ui/base/ManagedObjectObserver","./BlockBaseMetadata","./BlockBaseRenderer","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log"],function(q,C,a,b,M,B,c,d,D,e,l,f,g,L){"use strict";var S=g.form.SimpleFormLayout;var h=l.BlockBaseFormAdjustment;var j=C.extend("sap.uxap.BlockBase",{metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:h.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},events:{"viewInit":{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},renderer:c},B);j.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;this._oPromisedViews={};this._oViewDestroyObserver=new M(this._onViewDestroy.bind(this));};j.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{L.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};j.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};j.prototype.setParent=function(p,A,s){if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}else{C.prototype.setParent.call(this,p,A,s);}};j.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};j.prototype._applyMapping=function(){if(this._shouldLazyLoad()){L.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var o,k,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}o=this.getModel(s);if(!o){return;}p=o.resolve(E,this.getBindingContext(s));k=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(k&&(k.getPath()!==p))){L.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,o,I);this.setBindingContext(new d(o,p),I);}}},this);}};j.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};j.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};j.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};j.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._selectView(m);}}return this;};j.prototype.setColumnLayout=function(s){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",s);};j.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};j.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){L.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};j.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};j.prototype.createView=function(p,m){if(!this._oPromisedViews[p.id]){this._oPromisedViews[p.id]=new Promise(function(r,i){var o=f.getOwnerComponentFor(this),k=function(){var n=function(){return b.create(p);};if(o){return o.runAsOwner(n);}else{return n();}};k().then(function(v){this._afterViewInstantiated(v,m);r(v);}.bind(this));}.bind(this));}return this._oPromisedViews[p.id];};j.prototype._afterViewInstantiated=function(v,m){var o=v.getController();if(v){if(o){o.oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v);this._oViewDestroyObserver.observe(v,{destroy:true});this.fireEvent("viewInit",{view:v});}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}};j.prototype._notifyForLoadingInMode=function(o,v,m){if(o&&typeof o.onParentBlockModeChange==="function"){o.onParentBlockModeChange(m);}else{L.info("BlockBase ::: could not notify "+v.sViewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}};j.prototype._selectView=function(m){var v,V=this.getId()+"-"+m,s,i;i=function(v){if(v&&this.getAssociation("selectedView")!==V){this.setAssociation("selectedView",v);this._notifyForLoadingInMode(v.getController(),v,m);}}.bind(this);v=this._findView(m);if(v){i(v);return;}s=this.getMetadata().getView(m);s.id=V;this.createView(s,m).then(function(v){i(v);});};j.prototype._findView=function(m){var v=this.getAggregation("_views")||[],V,F;F=v.filter(function(o){return o.data("layoutMode")===m;});if(F.length){return F[0];}V=this.getMetadata().getView(m);F=v.filter(function(o){return V.viewName===o.getViewName();});if(F.length){return F[0];}};j.FORM_ADUSTMENT_OFFSET=16;j._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};j._PARENT_GRID_SIZE=12;j.prototype._computeFormAdjustmentFields=function(F,p){if(F&&p){return F===h.BlockColumns?q.extend({},j._FORM_ADJUSTMENT_CONST,{columns:p}):j._FORM_ADJUSTMENT_CONST;}};j.prototype._applyFormAdjustment=function(){var F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,o;if((F!==h.None)&&v&&p){o=this._computeFormAdjustmentFields(F,p._oLayoutConfig);v.getContent().forEach(function(i){this._adjustForm(i,o);}.bind(this));}};j.prototype._adjustForm=function(F,o){var i,k;if(F.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){F.setLayout(S.ColumnLayout);k=F.getAggregation("form").getLayout();k._iBreakPointTablet-=j.FORM_ADUSTMENT_OFFSET;k._iBreakPointDesktop-=j.FORM_ADUSTMENT_OFFSET;k._iBreakPointLargeDesktop-=j.FORM_ADUSTMENT_OFFSET;F.setLabelSpanL(o.labelSpan.L);F.setEmptySpanL(o.emptySpan.L);this._applyFormAdjustmentFields(o,F);F.setWidth("100%");}else if(F.getMetadata().getName()==="sap.ui.layout.form.Form"){k=F.getLayout();if(k&&k.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){i=k;}else{i=new e();F.setLayout(i);}i._iBreakPointTablet-=j.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=j.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=j.FORM_ADUSTMENT_OFFSET;i.setLabelCellsLarge(o.labelSpan.L);i.setEmptyCellsLarge(o.emptySpan.L);this._applyFormAdjustmentFields(o,i);F.setWidth("100%");}};j.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);};j.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};j.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();if(v===this.getVisible()){return this;}this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};j.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};j.prototype.connectToModels=function(){if(!this._bConnected){L.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._selectView(m);this.updateBindings(true,null);}this.invalidate();}};j.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};j.prototype.updateBindingContext=function(s,i,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,i,m,u);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};j.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};j.prototype.exit=function(){if(this._oViewDestroyObserver){this._oViewDestroyObserver.disconnect();}};j.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};j.prototype._onViewDestroy=function(E){delete this._oPromisedViews[E.object.getId()];};return j;});
