/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Core","sap/m/ScrollBar","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/ui/base/ManagedObject","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","./DynamicPageRenderer","sap/base/Log","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"sap/ui/core/library"],function(l,C,a,S,L,M,R,b,c,D,d,e,f,g,h,P,i,j){"use strict";var k=L.PageBackgroundDesign;var m=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:k.Standard},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{stickySubheaderProvider:{type:"sap.f.IDynamicPageStickyContent",multiple:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false},_scrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{pinnedStateChange:{parameters:{pinned:{type:"boolean"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/DynamicPage.designtime"}});function n(O){if(arguments.length===1){return O&&("length"in O)?O.length>0:!!O;}return Array.prototype.slice.call(arguments).every(function(p){return n(p);});}function o(E){var p;if(!E){return false;}p=E.getBoundingClientRect();return!!(p.width&&p.height);}var A=j.AccessibleLandmarkRole;m.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;m.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;m.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};m.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};m.MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};m.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",HEADER:"_sHeaderResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};m.DIV="div";m.HEADER="header";m.FOOTER="footer";m.HEADER_CONTENT_PADDING_BOTTOM=i.toPx("1rem");m.SHOW_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlShow";m.HIDE_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlHide";m.NAVIGATION_CLASS_NAME="sapFDynamicPageNavigation";m.ARIA_ROLE_DESCRIPTION="DYNAMIC_PAGE_ROLE_DESCRIPTION";m.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._oStickySubheader=null;this._bStickySubheaderInTitleArea=false;this._oScrollHelper=new c(this,this.getId()+"-content",{horizontal:false,vertical:true});this._oScrollHelper.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this));this._oStickyHeaderObserver=null;this._oHeaderObserver=null;this._oSubHeaderAfterRenderingDelegate={onAfterRendering:function(){this._bStickySubheaderInTitleArea=false;this._adjustStickyContent();}};this._setAriaRoleDescription(a.getLibraryResourceBundle("sap.f").getText(m.ARIA_ROLE_DESCRIPTION));};m.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();}this._attachHeaderObserver();this._addStickySubheaderAfterRenderingDelegate();this._detachScrollHandler();this._detachResizeHandlers();this._toggleAdditionalNavigationClass();};m.prototype.onAfterRendering=function(){var s,p;if(this.getPreserveHeaderStateOnScroll()){setTimeout(this._overridePreserveHeaderStateOnScroll.bind(this),0);}this._cacheDomElements();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._updatePinButtonState();this._hidePinButtonIfNotApplicable();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){p=this._getScrollBar().getScrollPosition();this._setScrollPosition(p?p:this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();};m.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}if(this._oStickySubheader){this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);}};m.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};m.prototype.setHeader=function(H){var O=this.getHeader();if(H===O){return this;}if(O){if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.HEADER);O.detachEvent(m.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress);this._bAlreadyAttachedPinPressHandler=false;O.detachEvent(m.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress);this._bAlreadyAttachedHeaderIndicatorPressHandler=false;O.detachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver);O.detachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=false;this._bAlreadyAttachedStickyHeaderObserver=false;this._bAlreadyAttachedHeaderObserver=false;}this.setAggregation("header",H);return this;};m.prototype.setStickySubheaderProvider=function(s){var O,p=this.getStickySubheaderProvider();if(s===p){return this;}O=a.byId(p);if(this._oStickySubheader&&O){O._returnStickyContent();O._setStickySubheaderSticked(false);this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=false;this._oStickySubheader=null;}this.setAssociation("stickySubheaderProvider",s);return this;};m.prototype.setHeaderExpanded=function(H){H=this.validateProperty("headerExpanded",H);if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);this._updatePinButtonState();return this;};m.prototype.setToggleHeaderOnTitleClick=function(t){var H=this.getHeaderExpanded(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this._updateTitleVisualState();this._updateToggleHeaderVisualIndicators();this._updateARIAStates(H);return r;};m.prototype.setFitContent=function(F){var r=this.setProperty("fitContent",F,true);if(n(this.$())){this._updateFitContainer();}return r;};m.prototype.getScrollDelegate=function(){return this._oScrollHelper;};m.prototype._onAfterScrollToElement=function(){var s=this.$wrapper.scrollTop(),w=this._bStickySubheaderInTitleArea;this._toggleHeaderOnScroll();if(this._bStickySubheaderInTitleArea&&!w&&this.$wrapper.scrollTop()===s){this.$wrapper.scrollTop(s-this._getHeight(this._oStickySubheader));}};m.prototype._overridePreserveHeaderStateOnScroll=function(){var O=this._headerBiggerThanAllowedHeight,p;this._headerBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();p=O!==this._headerBiggerThanAllowedHeight;if(!this._headerBiggerThanAllowedHeight||!p){return;}if(this.getHeaderExpanded()){this._moveHeaderToContentArea();}else{this._adjustSnap();}this._updateScrollBar();};m.prototype._toggleFooter=function(s){var F=this.getFooter(),u,p;if(!n(this.$())||!n(F)||!n(this.$footerWrapper)){return;}p=a.getConfiguration().getAnimationMode();u=p!==b.AnimationMode.none&&p!==b.AnimationMode.minimal;if(n(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",s);}if(u){this._toggleFooterAnimation(s,F);}else{this.$footerWrapper.toggleClass("sapUiHidden",!s);}this._updateScrollBar();};m.prototype._toggleFooterAnimation=function(s,F){this.$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));if(s){this.$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(m.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(m.HIDE_FOOTER_CLASS_NAME,!s);};m.prototype._onToggleFooterAnimationEnd=function(F){this.$footerWrapper.off("webkitAnimationEnd animationend");if(F.hasStyleClass(m.HIDE_FOOTER_CLASS_NAME)){this.$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(m.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(m.SHOW_FOOTER_CLASS_NAME);}};m.prototype._toggleHeaderInTabChain=function(t){var p=this.getTitle(),q=this.getHeader();if(!n(p)||!n(q)){return;}q.$().css("visibility",t?"visible":"hidden");};m.prototype._snapHeader=function(p,u){var q=this.getTitle();if(this._bPinned&&!u){h.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}h.debug("DynamicPage :: snapped header",this);if(this._bPinned&&u){this._unPin(u);this._togglePinButtonPressedState(false);}if(n(q)){q._toggleState(false,u);if(p&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!n(this.$titleArea)){h.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass(D.system.phone&&q.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);this._toggleHeaderBackground(true);};m.prototype._expandHeader=function(p,u){var q=this.getTitle();h.debug("DynamicPage :: expand header",this);if(n(q)){q._toggleState(true,u);if(p){this._moveHeaderToTitleArea(true);}}if(!n(this.$titleArea)){h.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass(D.system.phone&&q.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToPin()){this._togglePinButtonVisibility(true);}}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);this._toggleHeaderBackground(false);};m.prototype._toggleHeaderVisibility=function(s,u){var E=this.getHeaderExpanded(),p=this.getTitle(),q=this.getHeader();if(this._bPinned&&!u){h.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(n(p)){p._toggleState(E);}if(n(q)){q.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};m.prototype._toggleHeaderBackground=function(s){this.$headerInContentWrapper.toggleClass("sapFDynamicPageHeaderSolid",s);};m.prototype._moveHeaderToContentArea=function(O){var p=this.getHeader();if(n(p)){p.$().prependTo(this.$headerInContentWrapper);this._bHeaderInTitleArea=false;if(O){this._offsetContentOnMoveHeader();}this.fireEvent("_moveHeader");}};m.prototype._moveHeaderToTitleArea=function(O){var p=this.getHeader();if(n(p)){p.$().prependTo(this.$stickyPlaceholder);this._bHeaderInTitleArea=true;if(O){this._offsetContentOnMoveHeader();}this.fireEvent("_moveHeader");}};m.prototype._offsetContentOnMoveHeader=function(){var O=Math.ceil(this._getHeaderHeight()),p=this._getScrollPosition(),q=this._getScrollBar().getScrollPosition(),N;if(!O){return;}if(!p&&q){N=this._getScrollBar().getScrollPosition();}else{N=this._bHeaderInTitleArea?p-O:p+O;}N=Math.max(N,0);this._setScrollPosition(N,true);};m.prototype._isHeaderPinnable=function(){var H=this.getHeader();return H&&H.getPinnable()&&this.getHeaderExpanded()&&!this.getPreserveHeaderStateOnScroll();};m.prototype._updatePinButtonState=function(){var s=this.getHeaderPinned()&&this._isHeaderPinnable();this._togglePinButtonPressedState(s);if(s){this._pin();}else{this._unPin();}};m.prototype._pin=function(u){if(this._bPinned){return;}this._bPinned=true;if(u){this.setProperty("headerPinned",true,true);this.fireEvent("pinnedStateChange",{pinned:true});}if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapFDynamicPageHeaderPinned");};m.prototype._unPin=function(u){if(!this._bPinned){return;}this._bPinned=false;if(u){this.setProperty("headerPinned",false,true);this.fireEvent("pinnedStateChange",{pinned:false});}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapFDynamicPageHeaderPinned");};m.prototype._togglePinButtonVisibility=function(t){var p=this.getHeader();if(n(p)){p._setShowPinBtn(t);}};m.prototype._togglePinButtonPressedState=function(p){var q=this.getHeader();if(n(q)){q._togglePinButton(p);}};m.prototype._hidePinButtonIfNotApplicable=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}};m.prototype._isHeaderPinnable=function(){var H=this.getHeader();return H&&H.getPinnable()&&this.getHeaderExpanded()&&!this.getPreserveHeaderStateOnScroll();};m.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};m.prototype._getScrollPosition=function(){return n(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};m.prototype._setAriaRoleDescription=function(s){this._sAriaRoleDescription=s;return this;};m.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription;};m.prototype._setScrollPosition=function(N,s){if(!n(this.$wrapper)){return;}if(this._getScrollPosition()===N){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,N);};m.prototype._shouldSnapOnScroll=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};m.prototype._shouldExpandOnScroll=function(){var I=this._needsVerticalScrollBar();return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned&&I;};m.prototype._shouldStickStickyContent=function(){var I,s,p;p=this._getScrollPosition();I=p<this._getSnappingHeight()&&!this._bPinned&&!this.getPreserveHeaderStateOnScroll();s=p===0||I&&this._hasVisibleHeader();return!s;};m.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};m.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};m.prototype._canSnapHeaderOnScroll=function(){return this._getMaxScrollPosition()>this._getSnappingHeight();};m.prototype._getSnappingHeight=function(){var t=this.getTitle(),$=t&&t.$expandWrapper,p=t&&t.$snappedWrapper,q=t&&t.$expandHeadingWrapper,r=t&&t.$snappedHeadingWrapper,E=$&&$.length?$.height():0,s=r&&r.length?r.height():0,u=q&&q.length?q.height():0,v=p&&p.length?p.height():0,w=Math.ceil(this._getHeaderHeight()||E+v+s+u)-m.HEADER_CONTENT_PADDING_BOTTOM;return w>0?w:0;};m.prototype._getMaxScrollPosition=function(){var $,p;if(n(this.$wrapper)){$=this.$wrapper[0];p=Math.max($.clientHeight,Math.ceil($.getBoundingClientRect().height));return $.scrollHeight-p;}return 0;};m.prototype._needsVerticalScrollBar=function(){return Math.floor(this._getMaxScrollPosition())>0;};m.prototype._getOwnHeight=function(){return this._getHeight(this);};m.prototype._getEntireHeaderHeight=function(){var t=0,H=0,p=this.getTitle(),q=this.getHeader();if(n(p)){t=p.$().outerHeight();}if(n(q)){H=q.$().outerHeight();}return t+H;};m.prototype._headerBiggerThanAllowedToPin=function(p){if(!(typeof p==="number"&&!isNaN(parseInt(p)))){p=this._getOwnHeight();}return this._getEntireHeaderHeight()>m.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*p;};m.prototype._headerBiggerThanAllowedToBeFixed=function(){var p=this._getOwnHeight();return this._getEntireHeaderHeight()>m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*p;};m.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),p=this._getOwnHeight();if(p===0){return false;}return D.system.phone?E>=m.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*p:E>=p;};m.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),p=this._bHeaderInTitleArea,$=this._oStickySubheader&&this._oStickySubheader.$();if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();h.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!n(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();if(this._bStickySubheaderInTitleArea&&$.length){H+=$.height();}h.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(p);}h.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};m.prototype._updateScrollBar=function(){var s,p,N;if(!n(this.$wrapper)||(this._getHeight(this)===0)){return;}if(!D.system.desktop){setTimeout(this._updateFitContainer.bind(this),0);return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");p=this._needsVerticalScrollBar();N=this.bHasScrollbar!==p;if(N){s.toggleStyleClass("sapUiHidden",!p);this.toggleStyleClass("sapFDynamicPageWithScroll",p);this.bHasScrollbar=p;}setTimeout(this._updateFitContainer.bind(this),0);};m.prototype._updateFitContainer=function(N){var p=typeof N!=='undefined'?!N:!this._needsVerticalScrollBar(),F=this.getFitContent(),t=F||p;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};m.prototype._updateHeaderARIAState=function(E){var p=this.getHeader();if(n(p)){p._updateARIAState(E);}};m.prototype._updateTitleARIAState=function(E){var p=this.getTitle();if(n(p)){p._updateARIAState(E);}};m.prototype._updateARIAStates=function(E){this._updateHeaderARIAState(E);this._updateTitleARIAState(E);};m.prototype._applyContextualSettings=function(p){var q=p.contextualWidth;this._updateMedia(q);return d.prototype._applyContextualSettings.call(this,p);};m.prototype._updateMedia=function(w){if(!w){return;}if(w<=m.BREAK_POINTS.PHONE){this._updateMediaStyle(m.MEDIA.PHONE);}else if(w<=m.BREAK_POINTS.TABLET){this._updateMediaStyle(m.MEDIA.TABLET);}else if(w<=m.BREAK_POINTS.DESKTOP){this._updateMediaStyle(m.MEDIA.DESKTOP);}else{this._updateMediaStyle(m.MEDIA.DESKTOP_XL);}};m.prototype._updateMediaStyle=function(s){Object.keys(m.MEDIA).forEach(function(p){var E=s===m.MEDIA[p];this.toggleStyleClass(m.MEDIA[p],E);},this);};m.prototype._toggleExpandVisualIndicator=function(t){var p=this.getTitle();if(n(p)){p._toggleExpandButton(t);}};m.prototype._focusExpandVisualIndicator=function(){var p=this.getTitle();if(n(p)){p._focusExpandButton();}};m.prototype._toggleCollapseVisualIndicator=function(t){var p=this.getHeader();if(n(p)){p._toggleCollapseButton(t);}};m.prototype._focusCollapseVisualIndicator=function(){var p=this.getHeader();if(n(p)){p._focusCollapseButton();}};m.prototype._updateToggleHeaderVisualIndicators=function(){var H,p,E,q=this._hasVisibleTitleAndHeader(),r=this.getHeader(),s=false;if(n(r)){s=!!r.getContent().length;}if(!this.getToggleHeaderOnTitleClick()||!q){p=false;E=false;}else{H=this.getHeaderExpanded();p=H;E=D.system.phone&&this.getTitle().getAggregation("snappedTitleOnMobile")?false:!H;}E=E&&s;p=p&&s;this._toggleCollapseVisualIndicator(p);this._toggleExpandVisualIndicator(E);this._updateTitleVisualState();};m.prototype._updateHeaderVisualState=function(H,p){var q=this.getHeader();if(H&&this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._preserveHeaderStateOnScroll()&&q){if(this._headerBiggerThanAllowedToPin(p)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);this._updatePinButtonState();}if(this.getHeaderExpanded()&&this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0);}}else if(this._preserveHeaderStateOnScroll()&&q){this._togglePinButtonVisibility(false);}};m.prototype._updateTitleVisualState=function(){var t=this.getTitle(),T=this._hasVisibleTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapFDynamicPageTitleClickEnabled",T&&!D.system.phone);if(n(t)){t._toggleFocusableState(T);}};m.prototype._scrollBellowCollapseVisualIndicator=function(){var H=this.getHeader(),$,p,v,O;if(n(H)){$=this.getHeader()._getCollapseButton().getDomRef();p=$.getBoundingClientRect().height;v=this.$wrapper[0].getBoundingClientRect().height;O=$.offsetTop+p-v;this._setScrollPosition(O);}};m.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle();return n(t)&&t.getVisible()&&this._hasVisibleHeader();};m.prototype._hasVisibleHeader=function(){var H=this.getHeader();return n(H)&&H.getVisible()&&n(H.getContent());};m.prototype._getHeight=function(p){var $;if(!(p instanceof C)){return 0;}$=p.getDomRef();return $?$.getBoundingClientRect().height:0;};m.prototype._getWidth=function(p){return!(p instanceof C)?0:p.$().outerWidth()||0;};m.prototype._getTitleAreaHeight=function(){return n(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};m.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};m.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};m.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};m.prototype._getScrollBar=function(){if(!n(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};m.prototype._cacheDomElements=function(){var F=this.getFooter();if(n(F)){this.$footer=F.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$headerInContentWrapper=this.$("headerWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this.$stickyPlaceholder=this.$("stickyPlaceholder");this._cacheTitleDom();this._cacheHeaderDom();};m.prototype._cacheTitleDom=function(){var t=this.getTitle();if(n(t)){this.$title=t.$();}};m.prototype._cacheHeaderDom=function(){var H=this.getHeader();if(n(H)){this.$header=H.$();}};m.prototype._adjustSnap=function(){var p,I,q,r,s,t,$=this.$();if(!n($)){return;}if(!o($[0])){return;}p=this.getHeader();I=!this.getHeaderExpanded();if(!p||!I){return;}q=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();r=I&&p.$().hasClass("sapFDynamicPageHeaderHidden");if(q&&r){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);return;}if(!q&&!r){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);return;}if(q){s=this._getScrollPosition();t=this._getSnappingHeight();if(s<t){this._setScrollPosition(t);}}};m.prototype.ontouchmove=function(E){E.setMarked();};m.prototype._onChildControlAfterRendering=function(E){var s=E.srcControl;if(s instanceof e){this._cacheTitleDom();this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(m.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}else if(s instanceof f&&s.getDomRef()!==this.$header.get(0)){this._cacheHeaderDom();this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.HEADER);this._registerResizeHandler(m.RESIZE_HANDLER_ID.HEADER,this.$header[0],this._onChildControlsHeightChange.bind(this));}setTimeout(this._updateScrollBar.bind(this),0);};m.prototype._onChildControlsHeightChange=function(E){var N=this._needsVerticalScrollBar(),H=this.getHeader(),p,O;if(N){this._updateFitContainer(N);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;if(H&&E.target.id===H.getId()){p=E.size.height;O=E.oldSize.height;this._updateHeaderVisualState(p!==O);this._adaptScrollPositionOnHeaderChange(p,O);}};m.prototype._onResize=function(E){var p=this.getTitle(),q=E.size.width,r=E.size.height,H=r!==E.oldSize.height;this._updateHeaderVisualState(H,r);if(n(p)){p._onResize(q);}this._adjustSnap();this._updateScrollBar();this._updateMedia(q);};m.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};m.prototype._toggleHeaderOnScroll=function(){this._adjustStickyContent();if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnapOnScroll()){this._snapHeader(true,true);}else if(this._shouldExpandOnScroll()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var p=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(p);}};m.prototype._adjustStickyContent=function(){if(!this._oStickySubheader){return;}var p,s=this._shouldStickStickyContent(),q,r=this.getStickySubheaderProvider();if(s===this._bStickySubheaderInTitleArea){return;}q=a.byId(r);if(!n(q)){return;}p=document.activeElement;q._setStickySubheaderSticked(s);if(s){this._oStickySubheader.$().appendTo(this.$stickyPlaceholder);}else{q._returnStickyContent();}p.focus();this._bStickySubheaderInTitleArea=s;};m.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};m.prototype._adaptScrollPositionOnHeaderChange=function(N,O){var H=N-O,p=this.getHeader();if(H&&(!this.getHeaderExpanded()&&(p.$().css("visibility")!=="hidden"))&&!this._bHeaderInTitleArea&&this._needsVerticalScrollBar()){this._setScrollPosition(this._getScrollPosition()+H);}};m.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()&&this._hasVisibleTitleAndHeader()){this._titleExpandCollapseWhenAllowed(true);this.getTitle()._focus();}};m.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();};m.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};m.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(n($)){$.addClass("sapFDynamicPageTitleForceHovered");}};m.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(n($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};m.prototype._onTitleMouseOver=m.prototype._onVisualIndicatorMouseOver;m.prototype._onTitleMouseOut=m.prototype._onVisualIndicatorMouseOut;m.prototype._titleExpandCollapseWhenAllowed=function(u){var p,s;if(this._bPinned&&!u){return this;}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,u);this._toggleHeaderVisibility(true,u);}else{this._snapHeader(false,u);this._toggleHeaderVisibility(false,u);}}else if(!this.getHeaderExpanded()){p=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(p,u);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!p){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var q=this._bHeaderInTitleArea;this._snapHeader(q,u);if(!q){s=this._getSnappingHeight();this._setScrollPosition(s?(s+m.HEADER_CONTENT_PADDING_BOTTOM):0);}}};m.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true);}else{this._pin(true);this._restorePinButtonFocus();}};m.prototype._attachResizeHandlers=function(){var p=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(m.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(n(this.$title)){this._registerResizeHandler(m.RESIZE_HANDLER_ID.TITLE,this.$title[0],p);}if(n(this.$header)){this._registerResizeHandler(m.RESIZE_HANDLER_ID.HEADER,this.$header[0],p);}if(n(this.$contentFitContainer)){this._registerResizeHandler(m.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],p);}};m.prototype._registerResizeHandler=function(H,O,p){if(!this[H]){this[H]=R.register(O,p);}};m.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.HEADER);this._deRegisterResizeHandler(m.RESIZE_HANDLER_ID.CONTENT);};m.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};m.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),p=this.getContent(),q={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(n(t)){t.addEventDelegate(q);}if(n(p)){p.addEventDelegate(q);}if(n(H)){H.addEventDelegate(q);}};m.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(n(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(m.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};m.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(n(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(m.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};m.prototype._attachStickyHeaderObserver=function(){var H=this.getHeader();if(n(H)&&!this._bAlreadyAttachedStickyHeaderObserver){if(!this._oStickyHeaderObserver){this._oStickyHeaderObserver=new M(this._adjustStickyContent.bind(this));}this._oStickyHeaderObserver.observe(H,{properties:["visible"]});this._bAlreadyAttachedStickyHeaderObserver=true;}};m.prototype._attachHeaderObserver=function(){var H=this.getHeader();if(n(H)&&!this._bAlreadyAttachedHeaderObserver){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._onHeaderFieldChange.bind(this));}this._oHeaderObserver.observe(H,{aggregations:["content"],properties:["visible","pinnable"]});this._bAlreadyAttachedHeaderObserver=true;}};m.prototype._onHeaderFieldChange=function(E){if((E.type==="property")&&(E.name==="pinnable")){this._updatePinButtonState();return;}this._updateToggleHeaderVisualIndicators();};m.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(n(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(m.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(n(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(m.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};m.prototype._addStickySubheaderAfterRenderingDelegate=function(){var s,p=this.getStickySubheaderProvider(),I;s=a.byId(p);if(n(s)&&!this._bAlreadyAddedStickySubheaderAfterRenderingDelegate){I=s.getMetadata().getInterfaces().indexOf("sap.f.IDynamicPageStickyContent")!==-1;if(I){this._oStickySubheader=s._getStickyContent();this._oStickySubheader.addEventDelegate(this._oSubHeaderAfterRenderingDelegate,this);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=true;this._attachStickyHeaderObserver();}}};m.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(n(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};m.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(n(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(m.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(m.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};m.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};m.prototype._toggleAdditionalNavigationClass=function(){var s=this._bStickySubheaderProviderExists();this.toggleStyleClass(m.NAVIGATION_CLASS_NAME,s);};m.prototype._bStickySubheaderProviderExists=function(){var s=a.byId(this.getStickySubheaderProvider());return!!s&&s.isA("sap.f.IDynamicPageStickyContent");};m.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};m.prototype._formatLandmarkInfo=function(p,s){if(p){var r=p["get"+s+"Role"]()||"",q=p["get"+s+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:q};}return{};};m.prototype._getHeaderTag=function(p){if(p&&p.getHeaderRole()!==A.None){return m.DIV;}return m.HEADER;};m.prototype._getFooterTag=function(p){if(p&&p.getFooterRole()!==A.None){return m.DIV;}return m.FOOTER;};return m;});
