/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer","sap/base/Log","sap/ui/core/HTML","sap/ui/core/Icon","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/InvisibleMessage"],function(l,C,a,M,m,T,b,O,B,I,D,L,H,c,d,K,e){"use strict";var f=l.DynamicPageTitleArea,g=m.ToolbarStyle,h=C.InvisibleMessageMode;var o=sap.ui.getCore();var i=a.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:f.Begin,deprecated:true},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},snappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},expandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},snappedTitleOnMobile:{type:"sap.m.Title",multiple:false},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_snappedTitleOnMobileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"}});function j(v){if(arguments.length===1){return v&&("length"in v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(n){return j(n);});}i.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};i.TOGGLE_HEADER_TEXT_ID=I.getStaticId("sap.f","TOGGLE_HEADER");i.DEFAULT_HEADER_TEXT_ID=I.getStaticId("sap.f","DEFAULT_HEADER_TEXT");i._renderControl=function(n,p){var r;if(!p||!n){return;}r=o.createRenderManager();r.renderControl(p);r.flush(n);r.destroy();};function k(n){return typeof n==="function";}i.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);this._bNavigationActionsInTopArea=false;this._oRB=o.getLibraryResourceBundle("sap.f");this._oObserver=new M(i.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]});this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.f");this._oInvisibleMessage=null;};i.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());this._detachFocusSpanHandlers();};i.prototype.onAfterRendering=function(){this._cacheDomElements();this._attachFocusSpanHandlers();this._toggleState(this._bExpandedState);this._toggleFocusableState(this._bIsFocusable);this._doNavigationActionsLayout();this._updateTopAreaVisibility();if(this._getFocusSpan().is(":focus")){this._addFocusClass();}if(!this._oInvisibleMessage){this._oInvisibleMessage=e.getInstance();}};i.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};i.prototype.setPrimaryArea=function(A){var s=this.getAreaShrinkRatio(),S=this._getShrinkFactorsObject(),n=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",A,true);}if(s!==n){return this.setProperty("primaryArea",A,true);}if(A===f.Begin){this._setShrinkFactors(S.headingAreaShrinkFactor,S.contentAreaShrinkFactor,S.actionsAreaShrinkFactor);}else{this._setShrinkFactors(i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor);}return this.setProperty("primaryArea",A,true);};i.prototype.setAreaShrinkRatio=function(A){A=this.validateProperty("areaShrinkRatio",A);this.setProperty("areaShrinkRatio",A,true);var s=this._getShrinkFactorsObject();if(this.getPrimaryArea()===f.Middle){L.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this);}if(s.headingAreaShrinkFactor>1&&s.contentAreaShrinkFactor>1&&s.actionsAreaShrinkFactor>1){L.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this);}this._setShrinkFactors(s.headingAreaShrinkFactor,s.contentAreaShrinkFactor,s.actionsAreaShrinkFactor);return this;};i.prototype.ontap=function(E){var s=E.srcControl;if(s===this||s===this.getAggregation("_actionsToolbar")||s===this.getAggregation("breadcrumbs")||s===this.getAggregation("snappedTitleOnMobile")){this.fireEvent("_titlePress");}};i.prototype.onmouseover=function(){if(this._bTitleMouseOverFired){return;}this.fireEvent("_titleMouseOver");this._bTitleMouseOverFired=true;};i.prototype.onmouseout=function(E){if(E&&this.getDomRef().contains(E.relatedTarget)){return;}this.fireEvent("_titleMouseOut");this._bTitleMouseOverFired=false;};i.prototype.onkeyup=function(E){if(E&&E.which===K.SPACE&&!E.shiftKey){this.onsapenter(E);}};i.prototype.onsapspace=function(E){if(E.srcControl===this){E.preventDefault();}};i.prototype.onsapenter=function(E){if(E.srcControl===this){this.fireEvent("_titlePress");}};["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(s){i.prototype[s]=function(n){var t=this._getActionsToolbar(),p=s.replace(/Actions?/,"Content"),S=true,r;if(s==="addAction"||s==="insertAction"){if(!this._actionExists(n,"actions")){t[p].apply(t,arguments);this._preProcessAction(n,"actions");}r=this;}else if(s==="removeAction"){this._postProcessAction(n);}else if(s==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this);}else if(s==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);t[p].apply(t,arguments);r=this;}else if(s==="getActions"){S=false;}r=r||t[p].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(s){i.prototype[s]=function(n){var t=this._getNavigationActionsToolbar(),p=s.replace(/NavigationActions?/,"Content"),q=true,r;if(s==="addNavigationAction"||s==="insertNavigationAction"){if(!this._actionExists(n,"navigationActions")){t[p].apply(t,arguments);this._preProcessAction(n,"navigationActions");}r=this;}else if(s==="removeNavigationAction"){this._postProcessAction(n);}else if(s==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);}else if(s==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);t[p].apply(t,arguments);r=this;}else if(s==="getNavigationActions"){q=false;}r=r||t[p].apply(t,arguments);q&&this._updateTopAreaVisibility();return r;};});i.prototype.clone=function(s,n,p){var t=a.prototype.clone.apply(this,arguments),q=true;if(p){q=!!p.cloneChildren;}if(!q){return t;}var r=function(A){if(!this.isBound(A)){var u=this.getMetadata().getAggregation(A);u.get(this).forEach(function(v){u.add(t,v.clone());},this);}}.bind(this);r("actions");r("navigationActions");return t;};i.prototype._actionExists=function(A,s){return this.getMetadata().getAggregation(s).get(this).indexOf(A)>-1;};i.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$topArea=this.$("top");this.$mainArea=this.$("main");this.$middleArea=this.$("content");this.$snappedTitleOnMobileWrapper=this.$("snapped-title-on-mobile-wrapper");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");this._$focusSpan=this.$("focusSpan");};i.prototype._getActionsToolbar=function(){if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new O({id:this.getId()+"-_actionsToolbar",style:g.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_actionsToolbar");};i.prototype._getNavigationActionsToolbar=function(){if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new T({id:this.getId()+"-navActionsToolbar",style:g.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_navActionsToolbar");};i.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new b({id:this.getId()+"-separator"}),true);}return this.getAggregation("_navActionsToolbarSeparator");};i.prototype._toggleFocusableState=function(F){var $;this._bIsFocusable=F;$=this._getFocusSpan();if($){F?$.show():$.hide();}};i.prototype._preProcessAction=function(A,p){if(k(A._fnOriginalGetParent)){return;}this._observeControl(A);A._fnOriginalGetParent=A.getParent;A.getParent=this._fnActionSubstituteParentFunction;A._sOriginalParentAggregationName=A.sParentAggregationName;A.sParentAggregationName=p;};i.prototype._postProcessAction=function(A){if(!k(A._fnOriginalGetParent)){return;}this._unobserveControl(A);A.getParent=A._fnOriginalGetParent;A._fnOriginalGetParent=null;A.sParentAggregationName=A._sOriginalParentAggregationName;A._sOriginalParentAggregationName=null;};i.prototype._observeControl=function(n){this._oObserver.observe(n,{properties:["visible"]});};i.prototype._unobserveControl=function(n){this._oObserver.unobserve(n,{properties:["visible"]});};i.prototype._doNavigationActionsLayout=function(){var r,n,N;if(this.getNavigationActions().length===0){return;}N=this._getNavigationActionsToolbar();r=this._shouldRenderNavigationActionsInTopArea();if(r){n=this.$topNavigationActionsArea[0];}else{n=this.$mainNavigationActionsArea[0];}this._bNavigationActionsInTopArea=r;i._renderControl(n,N);this._updateSeparatorVisibility();};i.prototype._updateTopAreaVisibility=function(n){var N=this._areNavigationActionsInTopArea(),p=this._shouldRenderNavigationActionsInTopArea(n),q=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),r=d.system.phone&&this.getSnappedTitleOnMobile()&&!this._bExpandedState,s=(q||p)&&!r,S=this.getNavigationActions().length>0&&(p^N);this._toggleTopAreaVisibility(s);if(S){this._toggleNavigationActionsPlacement(p);}else{this._updateSeparatorVisibility();}};i.prototype._onResize=function(n){this._updateTopAreaVisibility(n);};i.prototype._toggleNavigationActionsPlacement=function(s){this["_showNavigationActionsIn"+(s?"Top":"Main")+"Area"]();this._updateSeparatorVisibility();};i.prototype._showNavigationActionsInTopArea=function(){var n=this._getNavigationActionsToolbar(),p;if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){p=document.activeElement;this.$topNavigationActionsArea.html(n.$());p&&p.focus();}this._bNavigationActionsInTopArea=true;};i.prototype._showNavigationActionsInMainArea=function(){var n=this._getNavigationActionsToolbar(),p;if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){p=document.activeElement;this.$mainNavigationActionsArea.html(n.$());p&&p.focus();}this._bNavigationActionsInTopArea=false;};i.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea;};i.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator());}};i.prototype._toggleTopAreaVisibility=function(s){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!s);}};i.prototype._shouldShowSeparator=function(){var n,p;if(this._bNavigationActionsInTopArea){return false;}n=this._getVisibleActions().length>0;p=this._getVisibleNavigationActions().length>0;return n&&p;};i.prototype._getVisibleActions=function(){return this.getActions().filter(function(A){return A.getVisible();});};i.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(A){return A.getVisible();});};i.prototype._setShrinkFactors=function(n,p,A){this.$("left-inner").css("flex-shrink",n);this.$("content").css("flex-shrink",p);this.$("mainActions").css("flex-shrink",A);};i.prototype._shouldRenderNavigationActionsInTopArea=function(n){var w,p,q;if(this._getVisibleNavigationActions().length===0){return false;}w=n?n:this._getWidth();p=this._getVisibleActions().length>0;q=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return w<i.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(q||p);};i.prototype._toggleState=function(E,u){var n=this._bExpandedState;this._bExpandedState=E;if(!this.getDomRef()){return;}if(d.system.phone&&this.getSnappedTitleOnMobile()){this.$snappedTitleOnMobileWrapper.toggleClass("sapUiHidden",E);this.$topArea.toggleClass("sapUiHidden",!E);this.$mainArea.toggleClass("sapUiHidden",!E);this.$().toggleClass("sapContrast",!E);}else{if(j(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",E);}if(j(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!E);}if(u&&n!==E){this.fireEvent("stateChange",{isExpanded:E});}}if(j(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",E);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!E);}if(j(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!E);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",E);}};i.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var E=new B({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:this._oRB.getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",E,true);}return this.getAggregation("_expandButton");};i.prototype._getSnappedTitleOnMobileIcon=function(){if(!this.getAggregation("_snappedTitleOnMobileIcon")){var n=new c({id:this.getId()+"-snappedTitleOnMobileIcon",src:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this)});this.setAggregation("_snappedTitleOnMobileIcon",n,true);}return this.getAggregation("_snappedTitleOnMobileIcon");};i.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress");};i.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().$().toggleClass("sapUiHidden",!t);};i.prototype._getShowExpandButton=function(){return this._bShowExpandButton;};i.prototype._setShowExpandButton=function(v){this._bShowExpandButton=!!v;};i.prototype._focusExpandButton=function(){var t=this._getExpandButton().getTooltip()+" "+this._oRB.getText("SNAPPED_HEADER");this._getExpandButton().$().trigger("focus");this._oInvisibleMessage.announce(t,h.Polite);};i.prototype._getWidth=function(){return this.$().outerWidth();};i.prototype.getFocusDomRef=function(){return this._getFocusSpan()[0]||null;};i.prototype._getState=function(){var n=this.getActions().length>0,p=this.getNavigationActions().length>0,q=this.getContent(),s=this.getSnappedContent(),E=this.getExpandedContent(),r=E.length>0,t=s.length>0,S=this._getShrinkFactorsObject(),u=this._getExpandButton(),F=this._getFocusSpan(),v=this.getBreadcrumbs(),w=this.getSnappedTitleOnMobile(),x=this._getSnappedTitleOnMobileIcon(),y=w&&d.system.phone,z=v||p,A=!!(v&&!p),G=p&&!v,J=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(this.getAreaShrinkRatio()===J&&this.getPrimaryArea()===f.Middle){S.headingAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;S.contentAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;S.actionsAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor;}u.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:n,hasNavigationActions:p,content:q,hasContent:q.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:u,focusSpan:F,snappedTitleOnMobileContext:w,snappedTitleOnMobileIcon:x,snappedContent:s,expandedContent:E,hasSnappedContent:t,hasExpandedContent:r,hasSnappedTitleOnMobile:y,hasAdditionalContent:r||(t&&!y),isSnapped:!this._bExpandedState,headingAreaShrinkFactor:S.headingAreaShrinkFactor,contentAreaShrinkFactor:S.contentAreaShrinkFactor,actionsAreaShrinkFactor:S.actionsAreaShrinkFactor,breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:z,hasOnlyBreadcrumbs:A,hasOnlyNavigationActions:G,contentAreaFlexBasis:this._sContentAreaFlexBasis,actionsAreaFlexBasis:this._sActionsAreaFlexBasis,contentAreaHasContent:this._bContentAreaHasContent,actionsAreaHasContent:this._bActionsAreaHasContent,isFocusable:this._bIsFocusable};};i.prototype._getShrinkFactorsObject=function(){var r={},A=this.getAreaShrinkRatio().split(":");r.headingAreaShrinkFactor=parseFloat(A[0]);r.contentAreaShrinkFactor=parseFloat(A[1]);r.actionsAreaShrinkFactor=parseFloat(A[2]);return r;};i.prototype._observeChanges=function(n){var p=n.object,s=n.name;if(p===this){if(s==="content"||s==="_actionsToolbar"){this._observeContentChanges(n);}}else if(s==="visible"){this._updateTopAreaVisibility();}};i.prototype._observeContentChanges=function(n){var p=n.child,s=n.mutation;if(!(p instanceof O)){return;}if(s==="insert"){p.attachEvent("_contentSizeChange",this._onContentSizeChange,this);}else if(s==="remove"){p.detachEvent("_contentSizeChange",this._onContentSizeChange,this);this._setContentAreaFlexBasis(0,p.$().parent());}};i.prototype._onContentSizeChange=function(E){var n=E.getParameter("contentSize");this._setContentAreaFlexBasis(n,E.getSource().$().parent());};i.prototype._setContentAreaFlexBasis=function(n,$){var F,s,A;n=parseInt(n);A=n&&n>1;F=n?n+"px":"auto";s=F!=="auto"?F:undefined;$.css({"flex-basis":F});if($.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaFlexBasis=s;this._bContentAreaHasContent=A;$.toggleClass("sapFDynamicPageTitleMainContentHasContent",A);}else if($.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaFlexBasis=s;this._bActionsAreaHasContent=A;$.toggleClass("sapFDynamicPageTitleMainActionsHasContent",A);}};i.prototype._updateARIAState=function(E){var A=this._getARIALabelReferences(E)||i.DEFAULT_HEADER_TEXT_ID,$=this._getFocusSpan();if($){$.attr("aria-labelledby",A);$.attr("aria-expanded",E);}return this;};i.prototype._getARIALabelReferences=function(E){var r="",t,s,n=this.getHeading()||(E?this.getExpandedHeading():this.getSnappedHeading());if(n){t=n.getTitle&&n.getTitle();if(t&&t.getId){s=t.getId();}r+=s||n.getId();}return r;};i.prototype._focus=function(){this._getFocusSpan().trigger("focus");};i.prototype._getAriaDescribedByReferences=function(){var t=this.getAriaDescribedBy(),s=i.TOGGLE_HEADER_TEXT_ID;if(t.length>0){s+=" "+t.join(" ");}return s;};i.prototype._attachFocusSpanHandlers=function(){this._$focusSpan.on("focusin",this._addFocusClass.bind(this));this._$focusSpan.on("focusout",this._removeFocusClass.bind(this));};i.prototype._detachFocusSpanHandlers=function(){if(this._$focusSpan){this._$focusSpan.off("focusin");this._$focusSpan.off("focusout");}};i.prototype._getFocusSpan=function(){return this._$focusSpan;};i.prototype._addFocusClass=function(){this.$().addClass("sapFDynamicPageTitleFocus");};i.prototype._removeFocusClass=function(){this.$().removeClass("sapFDynamicPageTitleFocus");};return i;});
