/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/delegate/ItemNavigation","sap/ui/events/KeyCodes","sap/base/Log","sap/f/library"],function(I,K,L,l){"use strict";var N=l.NavigationDirection;var G=I.extend("sap.f.delegate.GridItemNavigation",{metadata:{library:"sap.f",properties:{},events:{}}});G.prototype.resetFocusPosition=function(){this._mCurrentPosition=null;};G.prototype.onfocusin=function(e){I.prototype.onfocusin.call(this,e);var m=this._getGridInstance().getNavigationMatrix();if(m&&e.target===this.oDomRef){this._mCurrentPosition=this._findPositionInMatrix(m,this.getItemDomRefs().indexOf(this.iFocusedIndex));}};G.prototype.onsapfocusleave=function(e){I.prototype.onsapfocusleave.call(this,e);if(e.target===this.oDomRef){this.resetFocusPosition();}};G.prototype.ontap=function(e){this.resetFocusPosition();};G.prototype.onsapnext=function(e){this._moveFocus(e);};G.prototype.onsapprevious=function(e){this._moveFocus(e);};G.prototype._moveFocus=function(e){var i=this.getItemDomRefs(),c=e.target,m,s;if(i.indexOf(e.target)===-1){return;}e.preventDefault();m=this._getGridInstance().getNavigationMatrix();if(!m){return;}s=this._findPositionInMatrix(m,c);if(!this._mCurrentPosition){this._mCurrentPosition={column:s.column,row:s.row};}switch(e.keyCode){case K.ARROW_DOWN:this._moveFocusDown(s,m,c,e);break;case K.ARROW_RIGHT:this._moveFocusRight(s,m,c,e);break;case K.ARROW_UP:this._moveFocusUp(s,m,c,e);break;case K.ARROW_LEFT:this._moveFocusLeft(s,m,c,e);break;default:break;}L.info("Grid matrix position: ("+s.row+", "+s.column+")");};G.prototype._moveFocusDown=function(s,m,c,e){var i=this.getItemDomRefs(),n;s.column=this._mCurrentPosition.column;while(s.row<m.length&&(m[s.row][s.column]===c||m[s.row][s.column]===false)){s.row+=1;}if(s.row>=m.length){this._onBorderReached(e);return;}n=m[s.row][s.column];if(n){this._mCurrentPosition=s;this.focusItem(i.indexOf(n),e);}else{this._onBorderReached(e);}};G.prototype._moveFocusRight=function(s,m,c,e){var i=this.getItemDomRefs(),n;s.row=this._mCurrentPosition.row;while(s.column<m[s.row].length&&(m[s.row][s.column]===c||m[s.row][s.column]===false)){s.column+=1;}if(s.column>=m[s.row].length){this._onBorderReached(e);return;}n=m[s.row][s.column];if(n){this._mCurrentPosition=s;this.focusItem(i.indexOf(n),e);}else{this._onBorderReached(e);}};G.prototype._moveFocusUp=function(s,m,c,e){var i=this.getItemDomRefs(),n;s.column=this._mCurrentPosition.column;while(s.row>=0&&(m[s.row][s.column]===c||m[s.row][s.column]===false)){s.row-=1;}if(s.row<0){this._onBorderReached(e);return;}n=m[s.row][s.column];if(n){while(s.row>0&&m[s.row-1][s.column]===n){s.row-=1;}this._mCurrentPosition=s;this.focusItem(i.indexOf(n),e);}else{this._onBorderReached(e);}};G.prototype._moveFocusLeft=function(s,m,c,e){var i=this.getItemDomRefs(),n;s.row=this._mCurrentPosition.row;while(s.column>=0&&(m[s.row][s.column]===c||m[s.row][s.column]===false)){s.column-=1;}if(s.column<0){this._onBorderReached(e);return;}n=m[s.row][s.column];if(n){while(s.column>0&&m[s.row][s.column-1]===n){s.column-=1;}this._mCurrentPosition=s;this.focusItem(i.indexOf(n),e);}else{this._onBorderReached(e);}};G.prototype._findPositionInMatrix=function(m,i){var M=null;m.some(function(a,c){var r=a.indexOf(i);if(r!==-1){M={};M.row=c;M.column=r;return true;}return false;});return M;};G.prototype._onBorderReached=function(e){var d;switch(e.keyCode){case K.ARROW_RIGHT:d=N.Right;break;case K.ARROW_LEFT:d=N.Left;break;case K.ARROW_DOWN:d=N.Down;break;case K.ARROW_UP:d=N.Up;break;}this._getGridInstance().onItemNavigationBorderReached({event:e,row:this._mCurrentPosition.row,column:this._mCurrentPosition.column,direction:d});};G.prototype.focusItemByDirection=function(g,d,r,c){var C,m=g.getNavigationMatrix(),R,i,a;switch(d){case N.Right:i=r;a=-1;R=m[r];if(R){do{C=R[++a];}while(!C);}break;case N.Left:i=r;a=m[0].length;R=m[r];if(R){do{C=R[--a];}while(!C);}if(C){while(a>0&&m[r][a-1]===C){a--;}}break;case N.Down:i=-1;a=c;while(!C&&m[++i]&&m[i][c]!==undefined){C=m[i][c];}break;case N.Up:i=m.length;a=c;while(!C&&m[--i]&&m[i][c]!==undefined){C=m[i][c];}if(C){while(i>0&&m[i-1][c]===C){i--;}}break;default:break;}if(!C){return;}this._mCurrentPosition={column:a,row:i};C.focus();};G.prototype._getGridInstance=function(){return jQuery(this.oDomRef).control(0);};return G;});
