/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/dom/units/Rem","sap/m/library"],function(O,D,R,a,l){"use strict";var b=l.OverflowToolbarPriority;var M=12;var c=function(C){this._oControl=C;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this.sCurrentRange="";this._bAttachedManagedSearchHandler=false;this._oControl._iResizeHandlerId=R.register(this._oControl,this._handleResize.bind(this));this._iMinSearchWidth=a.toPx(M);};c.prototype.onAfterRendering=function(){var p=D.media.getCurrentRange("Std",this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true;}if(p){this._transformTitleControlMobile();}this._handleResize();};c.prototype.exit=function(){if(this._oControl._iResizeHandlerId){R.deregister(this._oControl._iResizeHandlerId);this._oControl._iResizeHandlerId=null;}};c.prototype._handleResize=function(){if(!this._oDomRef){return;}var C=this._oControl.$(),w=C.outerWidth(),o=D.media.getCurrentRange("Std",w),p;this.sCurrentRange=o.name;if(o){p=this.sCurrentRange==="Phone";C.toggleClass("sapFShellBarSizeDesktop",this.sCurrentRange==="Desktop");C.toggleClass("sapFShellBarSizeTablet",this.sCurrentRange==="Tablet");C.toggleClass("sapFShellBarSizePhone",p);}if(this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){setTimeout(this._adaptSearch.bind(this),100);}else{this._oControl._bSearchPlaceHolder=false;}if(this._iPreviousWidth===w){return;}this._iPreviousWidth=w;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oManagedSearch&&!this._oControl._oCopilot){return;}if(p&&!this.bWasInPhoneRange){this._transformToPhoneState();}else if(!p&&this.bWasInPhoneRange){this._transformToRegularState();}};c.prototype._switchOpenStateOnSearch=function(){var s=this._oControl._oManagedSearch;if(!s){return;}if(this.bWasInPhoneRange){this._transformToPhoneState();}else{this._transformToRegularState();}this._oControl.toggleStyleClass("sapFShellBarSearchIsOpen",s.getIsOpen());};c.prototype._transformToPhoneState=function(){var s=this._oControl._oManagedSearch,o=this._oControl._getOverflowToolbar().getContent(),S=this._oControl._oToolbarSpacer;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false);}this._transformTitleControlMobile();if(!this._bControlsLayoutDataCached){this._cacheControlsLayoutData();this._bControlsLayoutDataCached=true;}o.forEach(function(C){if(C===S){return;}C.setLayoutData(new O({priority:b.AlwaysOverflow}));});this.bWasInPhoneRange=true;if(s){s.setPhoneMode(true);if(s.getIsOpen()){this._toggleAllControlsExceptSearch(true);this._bSearchWasOpen=true;}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=false;}}this._oControl.invalidate();};c.prototype._transformToRegularState=function(){var s=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(false);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true);}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText(this._oControl._sTitle).setIcon("");}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText(this._oControl._sTitle);}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true);}}if(this._bControlsLayoutDataCached){this._restoreControlsLayoutData();this._bControlsLayoutDataCached=false;}this.bWasInPhoneRange=false;if(s){s.setPhoneMode(false);this._oControl._bSearchPlaceHolder=false;}this._oControl.invalidate();};c.prototype._transformTitleControlMobile=function(){var C;if(!this._oControl._oHomeIcon){return this.bIsMegaMenuConfigured?this._oControl._oMegaMenu.setText(this._oControl.getTitle()).setIcon(""):false;}C=this.bIsMegaMenuConfigured&&this._oControl._oHomeIcon.getVisible()||!this.bIsMegaMenuConfigured&&!this._oControl._oHomeIcon.getVisible();if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText("").setIcon(this._oControl.getHomeIcon());}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText("");}if(C){this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);this._oControl.invalidate();}};c.prototype._adaptSearch=function(){var s=this._oControl._oManagedSearch,S;if(!s||this.sCurrentRange==="Phone"){return;}S=s.$().width();if(this._oControl._bSearchPlaceHolder){if(S>=this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=false;this._toggleAllControlsExceptSearch(false);}}else if(S<this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=true;this._toggleAllControlsExceptSearch(true);}else if(s.hasStyleClass("sapFShellBarSearchOpenTick")){s.removeStyleClass("sapFShellBarSearchOpenTick");this._adaptSearch();}return this;};c.prototype._toggleAllControlsExceptSearch=function(s){var S=this._oControl._oManagedSearch;this._oControl.toggleStyleClass("sapFShellBarFullSearch",s);S&&S.toggleStyleClass("sapFShellBarSearchFullWidth",s);};c.prototype._cacheControlsLayoutData=function(){var o=this._oControl._getOverflowToolbar().getContent();this._oCachedLayoutData={};o.forEach(function(C){this._oCachedLayoutData[C.getId()]=C.getLayoutData();},this);};c.prototype._restoreControlsLayoutData=function(){var o=this._oControl._getOverflowToolbar().getContent();o.forEach(function(C){var L=this._oCachedLayoutData[C.getId()];if(L){C.setLayoutData(L);}},this);};return c;});
