/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./ComboBoxTextField','./ComboBoxBaseRenderer','./SuggestionsPopover','sap/ui/base/ManagedObjectObserver','sap/ui/core/SeparatorItem','sap/ui/core/InvisibleText','sap/ui/base/ManagedObject','sap/base/Log','./library','sap/ui/Device',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool","sap/ui/core/Core"],function(C,a,S,M,b,I,c,L,l,D,d,K,q,e,f,g,h,j,k,m){"use strict";var P=l.PlacementType;var n=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var o=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false,hidden:true},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},renderer:a});o.prototype.oncompositionend=function(E){C.prototype.oncompositionend.apply(this,arguments);if(!D.browser.firefox){this.handleInputValidation(E,this.isComposingCharacter());}};o.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled();};o.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){j.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false);}this.onItemsLoaded();}};o.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};o.prototype.highlightList=function(v){var i=[];i=this._getList().$().find('.sapMSLIInfo, .sapMSLITitleOnly');h(i,v);};o.prototype._decoratePopupInput=function(i){if(i){this.setTextFieldHandler(i);i.setShowClearIcon(this.getShowClearIcon());}return i;};o.prototype.setTextFieldHandler=function(t){var i=this,T=t._handleEvent;t._handleEvent=function(E){T.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){i._handleEvent(E);}};};o.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};o.prototype.loadItems=function(i,O){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){O=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},O);this.aMessageQueue.push(O);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(O.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function r(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),O.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};o.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,p,N,r;i<this.aMessageQueue.length;i++){p=this.aMessageQueue.shift();i--;r=(i+1)===this.aMessageQueue.length;N=r?null:this.aMessageQueue[i+1];if(typeof p.action==="function"){if((p.name==="input")&&!r&&(N.name==="input")){continue;}p.action.call(this);}}};o.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};o.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};o.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};o.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new I();this._oGroupHeaderInvisibleText.toStatic();}return this._oGroupHeaderInvisibleText;};o.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(i){return!i.getVisible()&&j.getItemByListItem(this.getItems(),i).getEnabled();},this);};o.prototype.getSelectable=function(i){return i._bSelectable;};o.prototype._setItemsShownWithFilter=function(v){this._bItemsShownWithFilter=v;};o.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter;};o.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon;}this._oClearIcon=this.addEndIcon({src:k.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon;};o.prototype.handleClearIconPress=function(E){};o.prototype.onkeyup=function(E){if(!this.getEnabled()||!this.getEditable()){return;}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue());};o.prototype.setValue=function(v){C.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!v);return this;};o.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=m.getLibraryResourceBundle("sap.m");this.setPickerType(D.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var i=new M(function(p){var s=p.mutation;var r=p.child;var E={"remove":"detachEvent","insert":"attachEvent"};var t={"remove":"handleItemRemoval","insert":"handleItemInsertion"};if(!r[E[s]]||!this[t[s]]){return;}r[E[s]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[t[s]](r);}.bind(this));i.observe(this,{aggregations:["items"]});};o.prototype.handleItemRemoval=function(i){};o.prototype.handleItemInsertion=function(i){};o.prototype.setRecreateItems=function(r){this._bRecreateItems=r;};o.prototype.getRecreateItems=function(){return this._bRecreateItems;};o.prototype.onBeforeRendering=function(){var s=this.isOpen(),v=s?this._getSuggestionsPopover()._getValueStateHeader().getText():null,V=s?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;C.prototype.onBeforeRendering.apply(this,arguments);if(s&&((this.getValueStateText()&&v!==this.getValueStateText())||(this.getValueState()!==V)||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState();}if(this.getShowClearIcon()){this._getClearIcon().setVisible(this.shouldShowClearIcon());}else if(this._oClearIcon){this._getClearIcon().setVisible(false);}};o.prototype._handlePopupOpenAndItemsLoad=function(O,i){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(O&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=O;if(this.isPlatformTablet()){this.syncPickerContent();p=this.getPicker();p.setInitialFocus(p);}if(i){p=this.getPicker();p&&p.setInitialFocus(i);}this.open();};o.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null;}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};o.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return;}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};o.prototype.onF4=function(E){E.preventDefault();};o.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};o.prototype.onsaphide=o.prototype.onsapshow;o.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getPicker(),F=r&&r.getFocusDomRef();if(p&&d(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};o.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};o.prototype.addContent=function(p){};o.prototype.getList=function(){L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList();};o.prototype._getList=function(){var i=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!i){return null;}return i;};o.prototype.setPickerType=function(p){this._sPickerType=p;};o.prototype.getPickerType=function(){return this._sPickerType;};o.prototype._updateSuggestionsPopoverValueState=function(){var s=this._getSuggestionsPopover();if(!s){return;}var v=this.getValueState(),N=this.getValueState()!==s._getValueStateHeader().getValueState(),i=this.getFormattedValueStateText(),V=this.getValueStateText(),p=i||N;if(s.isOpen()&&!p){this.setFormattedValueStateText(s._getValueStateHeader().getFormattedText());}s.updateValueState(v,(i||V),this.getShowValueStateMessage());};o.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};o.prototype.onPropertyChange=function(i,p){var N=i.getParameter("newValue"),s=i.getParameter("name"),r="set"+s.charAt(0).toUpperCase()+s.slice(1),t=(p&&p.srcControl)||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&t&&(typeof t[r]==="function")){t[r](N);}};o.prototype.getInputForwardableProperties=function(){return n;};o.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};o.prototype.isPlatformTablet=function(){var N=!D.system.combi,t=D.system.tablet&&N;return t;};o.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};o.prototype._configureList=function(){};o.prototype.createPicker=function(p){var i=this.getAggregation("picker");if(i){return i;}this._oSuggestionPopover=this._createSuggestionsPopover();i=this._oSuggestionPopover.getPopover();this.setAggregation("picker",i,true);this.configPicker(i);return i;};o.prototype.configPicker=function(p){};o.prototype._hasShowSelectedButton=function(){return false;};o.prototype._createSuggestionsPopover=function(){var s=new S(this);s.decorateParent(this);s.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()});this._decoratePopupInput(s.getInput());s.initContent(this.getId());this.forwardEventHandlersToSuggPopover(s);this._configureList(s.getItemsContainer());return s;};o.prototype.forwardEventHandlersToSuggPopover=function(s){s.setOkPressHandler(this._handleOkPress.bind(this));s.setCancelPressHandler(this._handleCancelPress.bind(this));s.setInputLabels(this.getLabels.bind(this));};o.prototype._handleOkPress=function(){var t=this,T=t.getPickerTextField();t.updateDomValue(T.getValue());t.onChange();t.close();};o.prototype._handleCancelPress=function(){this.close();this.revertSelection();};o.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var p=j.getListItem(i);if(p){p.setVisible(s);}};o.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};o.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState();};o.prototype.getPicker=function(){var p=this.getAggregation("picker");if(p&&!p.bIsDestroyed&&!this.bIsDestroyed){return p;}return null;};o.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover;};o.prototype.getValueStateLinks=function(){var H=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",F=H&&this.getPicker().getCustomHeader().getFormattedText(),v=F&&F.getControls();return v||[];};o.prototype.getPickerTextField=function(){var s=this._getSuggestionsPopover();return s?s.getInput():null;};o.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};o.prototype.revertSelection=function(){};o.prototype.hasContent=function(){return this.getItems().length>0;};o.prototype.syncPickerContent=function(){};o.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};o.prototype.getVisibleItems=function(){return j.getVisibleItems(this.getItems());};o.prototype.isItemSelected=function(){};o.prototype.getKeys=function(p){p=p||this.getItems();for(var i=0,r=[];i<p.length;i++){r[i]=p[i].getKey();}return r;};o.prototype.findItem=function(p,v){var s="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,r=this.getItems();i<r.length;i++){if(r[i][s]()===v){return r[i];}}return null;};o.prototype.getItemByText=function(t){return this.findItem("text",t);};o.prototype.clearFilter=function(){this.getItems().forEach(function(i){var p=j.getListItem(i);if(p){p.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};o.prototype.onItemChange=function(i,s){g({item:i.getSource(),propName:i.getParameter("name"),propValue:i.getParameter("newValue")},s);};o.prototype.clearSelection=function(){};o.prototype.setInternalBusyIndicator=function(B){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};o.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};o.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};o.prototype.getFirstItem=function(){return this.getItems()[0]||null;};o.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};o.prototype.getEnabledItems=function(i){return j.getEnabledItems(i||this.getItems());};o.prototype.getItemByKey=function(s){return this.findItem("key",s);};o.prototype.addItemGroup=function(G,H,s){H=H||new b({text:c.escapeSettingsValue(G.text)||c.escapeSettingsValue(G.key)});this.addAggregation("items",H,s);if(this._getList()&&H.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(H));}return H;};o.prototype.isOpen=function(){var p=this.getPicker();return!!(p&&p.isOpen());};o.prototype.close=function(){var p=this.getPicker();if(p){p.close();}return this;};o.prototype.intersectItems=function(i,O){return i.filter(function(p){return O.map(function(r){return r.getId();}).indexOf(p.getId())!==-1;});};o.prototype.showItems=function(F){var i=this.fnFilter,p=function(){if(!this.getItems().length){return;}this.detachLoadItems(p);this.setFilterFunction(F||function(){return true;});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(i);}.bind(this);if(!this.getEnabled()||!this.getEditable()){return;}this._setItemsShownWithFilter(true);this.attachLoadItems(p);this.loadItems(p);};o.prototype.applyShowItemsFilters=function(){};return o;});
