/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize"],function(L,a,l,F,I,B,D,b,A,c,d){"use strict";var e=l.ListType;var f=l.LinkConversion;var g=l.ButtonType;var h=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:c.Circle},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:d.S},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},moreLabel:{type:"string",group:"Data",defaultValue:null},lessLabel:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:f.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});h._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");h._nMaxCharactersMobile=300;h._nMaxCharactersDesktop=500;h._sTextShowMore=h._oRb.getText("TEXT_SHOW_MORE");h._sTextShowLess=h._oRb.getText("TEXT_SHOW_LESS");h.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new B({id:this.getId()+"-actionButton",type:g.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true);};h.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this));};h.prototype._openActionSheet=function(j){var o=this.getAggregation("_actionSheet");var k=this.getActions();var m;if(!(o&&o instanceof j)){o=new j({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",o,true);}o.destroyAggregation("buttons",true);for(var i=0;i<k.length;i++){m=k[i];o.addButton(new B({icon:m.getIcon(),text:m.getText(),visible:m.getVisible(),enabled:m.getEnabled(),press:m.firePress.bind(m,{"item":this})}));}o.openBy(this.getAggregation("_actionButton"));};h.prototype._onBeforeOpenActionSheet=function(i){var o,t;if(D.system.phone){return;}t=sap.ui.getCore().getConfiguration().getTheme();o=i.getSource().getParent();o.removeStyleClass("sapContrast sapContrastPlus");if(t==="sap_belize"){o.addStyleClass("sapContrast");}else if(t==="sap_belize_plus"){o.addStyleClass("sapContrastPlus");}};h.prototype.invalidate=function(){L.prototype.invalidate.apply(this,arguments);var m=h._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",m,true);}};h.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var o=this.getAggregation("_text");o.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);o.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===f.None){o.setHtmlText(this.getText());}else{o.setProperty("htmlText",this.getText(),true);}this._sFullText=o._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();if(this._sShortText){this._sShortText=this._sShortText.replace(/<br>/g," ");}this._bEmptyTagsInShortTextCleared=false;};h.prototype.onAfterRendering=function(){if(document.getElementById(this.getAggregation("_actionButton"))){document.getElementById(this.getAggregation("_actionButton").getId()).setAttribute("aria-haspopup","menu");}if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};h.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this.oAvatar){this.oAvatar.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};h.prototype.ontap=function(E){if(E.srcControl){if((!this.getIconActive()&&this.oAvatar&&E.srcControl.getId()===this.oAvatar.getId())||(!this.getSenderActive()&&this._oLinkControl&&E.srcControl.getId()===this._oLinkControl.getId())||(!this.oAvatar||(E.srcControl.getId()!==this.oAvatar.getId())&&(!this._oLinkControl||(E.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(E.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[E]);}}};h.prototype.onfocusin=function(E){var i=E.srcControl,o=i.getDomRef(),p=this.getParent().getAccessbilityPosition(i);if(i instanceof sap.m.FeedListItem){o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}};h.prototype._getAvatar=function(){var i=this.getIcon();var s=this.getId()+'-icon';this.oAvatar=this.getAggregation("_avatar");this.oAvatar=this.oAvatar||new A(s);this.oAvatar.applySettings({src:i,displayShape:this.getIconDisplayShape(),initials:this.getIconInitials(),displaySize:this.getIconSize(),ariaLabelledBy:this.getSender()});var t=this;if(this.getIconActive()){this.oAvatar.addStyleClass("sapMFeedListItemImage");if(!this.oAvatar.hasListeners("press")){this.oAvatar.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}}else{this.oAvatar.addStyleClass("sapMFeedListItemImageInactive");}this.setAggregation("_avatar",this.oAvatar);return this.oAvatar;};h.prototype._getLinkSender=function(w){if(!this._oLinkControl){var t=this;this._oLinkControl=new a({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+h._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};h.prototype._activeHandlingInheritor=function(){var s=this.getActiveIcon();if(this.oAvatar&&s){this.oAvatar.setSrc(s);}};h.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():I.getIconURI("person-placeholder");if(this.oAvatar){this.oAvatar.setSrc(s);}};h.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(D.system.phone){this._nMaxCollapsedLength=h._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=h._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var C=p.substring(0,this._nMaxCollapsedLength);var n=C.lastIndexOf(" ");if(n>0){C=C.substr(0,n);}if(p.length===this._sFullText.length){t=C;}else{t=this._convertPlainToHtmlText(C);}}return t;};h.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};h.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var i=this.$("threeDots");var m=h._sTextShowMore;var s=h._sTextShowLess;if(this.getMoreLabel()){m=this.getMoreLabel();}if(this.getLessLabel()){s=this.getLessLabel();}if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));i.text(" ... ");this._oLinkExpandCollapse.setText(m);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));i.text("  ");this._oLinkExpandCollapse.setText(s);this._bTextExpanded=true;}};h.prototype._getLinkExpandCollapse=function(){var m=h._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new a({text:m,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};h.prototype._convertHtmlToPlainText=function(i){var r=/(<([^>]+)>)/ig;return i.replace(r,"");};h.prototype._convertPlainToHtmlText=function(j){var s=this._sFullText;var r=/(<([^>]+)>)/ig;var E=s.split(r);var t="";for(var i=0;i<E.length;i++){if(E[i].length===0){continue;}if(j.length>0&&E[i].indexOf(j.trim())!==-1){E[i]=j;}if(/^<.+>$/.test(E[i])){t=t+E[i];E[i+1]="";continue;}if(j.indexOf(E[i].trim())===-1){continue;}else{j=j.replace(E[i],"");}t=t+E[i];}return t;};h.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};h.prototype.setType=function(t){if(this.getType()!==t){if(t===e.Navigation){this.setProperty("type",e.Active);}else{this.setProperty("type",t);}}return this;};return h;});
