/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/Text","sap/m/Title","sap/m/FormattedText","sap/m/Illustration","sap/ui/core/Control","sap/ui/core/Core",'sap/ui/core/library',"sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","./IllustratedMessageRenderer"],function(l,T,a,F,I,C,b,c,R,q,d){"use strict";var e=l.IllustratedMessageSize;var f=l.IllustratedMessageType;var g=c.TextAlign;var h=C.extend("sap.m.IllustratedMessage",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:""},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false},illustrationSize:{type:"sap.m.IllustratedMessageSize",group:"Appearance",defaultValue:e.Auto},illustrationType:{type:"string",group:"Appearance",defaultValue:f.NoSearchResults},title:{type:"string",group:"Misc",defaultValue:""}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_illustration:{type:"sap.m.Illustration",visibility:"hidden",multiple:false},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true}}});h.ORIGINAL_TEXTS={UnableToLoad:"UnableToLoad",UnableToUpload:"UnableToUpload",NoActivities:"NoActivities",BeforeSearch:"BeforeSearch",NoSearchResults:"NoSearchResults",NoEntries:"NoEntries",NoData:"NoData",NoNotifications:"NoNotifications",BalloonSky:"BalloonSky",SuccessScreen:"SuccessScreen",NoMail:"NoMail",NoSavedItems:"NoSavedItems",NoTasks:"NoTasks"};h.FALLBACK_TEXTS={ReloadScreen:h.ORIGINAL_TEXTS.UnableToLoad,Connection:h.ORIGINAL_TEXTS.UnableToLoad,ErrorScreen:h.ORIGINAL_TEXTS.UnableToUpload,EmptyCalendar:h.ORIGINAL_TEXTS.NoActivities,SearchEarth:h.ORIGINAL_TEXTS.BeforeSearch,SearchFolder:h.ORIGINAL_TEXTS.NoSearchResults,EmptyList:h.ORIGINAL_TEXTS.NoEntries,Tent:h.ORIGINAL_TEXTS.NoData,SleepingBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleBalloon:h.ORIGINAL_TEXTS.BalloonSky,SimpleBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleCalendar:h.ORIGINAL_TEXTS.NoActivities,SimpleCheckmark:h.ORIGINAL_TEXTS.SuccessScreen,SimpleConnection:h.ORIGINAL_TEXTS.UnableToLoad,SimpleEmptyDoc:h.ORIGINAL_TEXTS.NoData,SimpleEmptyList:h.ORIGINAL_TEXTS.NoEntries,SimpleError:h.ORIGINAL_TEXTS.UnableToUpload,SimpleMagnifier:h.ORIGINAL_TEXTS.BeforeSearch,SimpleMail:h.ORIGINAL_TEXTS.NoMail,SimpleNoSavedItems:h.ORIGINAL_TEXTS.NoSavedItems,SimpleNotFoundMagnifier:h.ORIGINAL_TEXTS.NoSearchResults,SimpleReload:h.ORIGINAL_TEXTS.UnableToLoad,SimpleTask:h.ORIGINAL_TEXTS.NoTasks};h.PREPENDS={DESCRIPTION:"IllustratedMessage_DESCRIPTION_",TITLE:"IllustratedMessage_TITLE_"};h.BREAK_POINTS={DIALOG:679,SPOT:319,BASE:259};h.MEDIA={BASE:"sapFIllustratedMessage-Base",SPOT:"sapFIllustratedMessage-Spot",DIALOG:"sapFIllustratedMessage-Dialog",SCENE:"sapFIllustratedMessage-Scene"};h.RESIZE_HANDLER_ID={CONTENT:"_sContentResizeHandlerId"};h.prototype.init=function(){this._updateInternalIllustrationSetAndType(this.getIllustrationType());};h.prototype.onBeforeRendering=function(){this._detachResizeHandlers();};h.prototype.onAfterRendering=function(){this._updateDomSize();this._attachResizeHandlers();this._preventWidowWords(this._getTitle().getDomRef());this._preventWidowWords(this._getDescription().getDomRef());};h.prototype.exit=function(){this._detachResizeHandlers();};h.prototype.setIllustrationType=function(v){if(this.getIllustrationType()===v){return this;}this._updateInternalIllustrationSetAndType(v);return this.setProperty("illustrationType",v);};h.prototype._getDefaultDescription=function(){return this._findDefaultText(h.PREPENDS.DESCRIPTION);};h.prototype._getDefaultTitle=function(){return this._findDefaultText(h.PREPENDS.TITLE);};h.prototype._findDefaultText=function(p){var B=this._getResourceBundle();return B.getText(p+this._sIllustrationType,null,true)||B.getText(p+this._sIllustrationType.substr(0,this._sIllustrationType.indexOf('_v')),null,true)||B.getText(p+h.FALLBACK_TEXTS[this._sIllustrationType],null,true);};h.prototype._getDescription=function(){return this.getEnableFormattedText()?this._getFormattedText():this._getText();};h.prototype._getFormattedText=function(){var D=this.getDescription(),o=this.getAggregation("_formattedText");if(!o){o=new F({textAlign:g.Center});this.setAggregation("_formattedText",o);}if(D){o.setHtmlText(D);}else{o.setHtmlText(this._getDefaultDescription());}return o;};h.prototype._getIllustration=function(){var i=this.getAggregation("_illustration");if(!i){i=new I();this.setAggregation("_illustration",i);}return i;};h.prototype._getResourceBundle=function(){return b.getLibraryResourceBundle("sap.m");};h.prototype._getText=function(){var D=this.getDescription(),t=this.getAggregation("_text");if(!t){t=new T({textAlign:g.Center});this.setAggregation("_text",t);}if(D){t.setText(D);}else{t.setText(this._getDefaultDescription());}return t;};h.prototype._getTitle=function(){var t=this.getTitle(),o=this.getAggregation("_title");if(!o){o=new a({wrapping:true});this.setAggregation("_title",o);}if(t){o.setText(t);}else{o.setText(this._getDefaultTitle());}return o;};h.prototype._preventWidowWords=function(D){var $,s,H=window.HTMLElement;if(!(H&&D instanceof H)){return;}$=q(D);s=$.html();s=s.replace(/ ([^ ]*)$/,'&nbsp;$1');$.html(s);};h.prototype._updateDomSize=function(){var D=this.getDomRef(),s;if(D){s=this.getIllustrationSize();if(s===e.Auto){this._updateMedia(D.getBoundingClientRect().width);}else{this._updateMediaStyle(h.MEDIA[s.toUpperCase()]);}}};h.prototype._updateInternalIllustrationSetAndType=function(v){var V=v.split("-");this._sIllustrationSet=V[0];this._sIllustrationType=V[1];};h.prototype._onResize=function(E){var i=E.size.width;this._updateMedia(i);};h.prototype._updateMedia=function(w){if(!w){return;}if(w<=h.BREAK_POINTS.BASE){this._updateMediaStyle(h.MEDIA.BASE);}else if(w<=h.BREAK_POINTS.SPOT){this._updateMediaStyle(h.MEDIA.SPOT);}else if(w<=h.BREAK_POINTS.DIALOG){this._updateMediaStyle(h.MEDIA.DIALOG);}else{this._updateMediaStyle(h.MEDIA.SCENE);}};h.prototype._updateMediaStyle=function(s){Object.keys(h.MEDIA).forEach(function(m){var E=s===h.MEDIA[m],i=m.charAt(0)+m.slice(1).toLowerCase();this.toggleStyleClass(h.MEDIA[m],E);if(E&&s!==h.MEDIA.BASE){this._getIllustration().setSet(this._sIllustrationSet,true).setMedia(i,true).setType(this._sIllustrationType);}},this);};h.prototype._attachResizeHandlers=function(){var i=this.getIllustrationSize();if(this.getDomRef()&&i===e.Auto){this._registerResizeHandler(h.RESIZE_HANDLER_ID.CONTENT,this,this._onResize.bind(this));}};h.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(h.RESIZE_HANDLER_ID.CONTENT);};h.prototype._registerResizeHandler=function(H,o,i){if(!this[H]){this[H]=R.register(o,i);}};h.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};h.prototype.getAccessibilityReferences=function(){return{title:this._getTitle().getId(),description:this._getDescription().getId()};};return h;});
