/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/Core","sap/m/Text","sap/m/Button","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Icon","sap/ui/layout/VerticalLayout","./InstanceManager","sap/ui/core/InvisibleText","sap/ui/core/library","./LightBoxRenderer","sap/m/BusyIndicator","sap/ui/thirdparty/jquery","sap/ui/dom/units/Rem"],function(l,C,P,a,T,B,R,D,I,V,b,c,d,L,e,q,f){"use strict";var g=l.ButtonType;var h=l.LightBoxLoadingStates;var O=d.OpenState;var i=d.TextAlign;var j=C.extend("sap.m.LightBox",{metadata:{library:"sap.m",interfaces:["sap.ui.core.PopupInterface"],aggregations:{imageContent:{type:"sap.m.LightBoxItem",multiple:true,bindable:"bindable"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_verticalLayout:{type:"sap.ui.layout.VerticalLayout",multiple:false,visibility:"hidden"},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},defaultAggregation:"imageContent",events:{},designtime:"sap/m/designtime/LightBox.designtime"}});j.prototype.init=function(){this._createPopup();this._iWidth=0;this._iHeight=0;this._isRendering=true;this._iResizeListenerId=null;this._$lightBox=null;this._oRB=a.getLibraryResourceBundle("sap.m");this.setAggregation("_invisiblePopupText",new c());};j.prototype.onBeforeRendering=function(){var o=this._getImageContent(),n=o._getNativeImage(),s=o.getImageSrc(),S=o._getImageState(),k=this._oRB.getText("LIGHTBOX_ARIA_ENLARGED",[o.getTitle(),o.getSubtitle()]),E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR"),m=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");this._createErrorControls();if(n.getAttribute("src")!==s){n.src=s;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}switch(S){case h.Loading:if(!this._iTimeoutId){this._iTimeoutId=setTimeout(function(){o._setImageState(h.TimeOutError);},10000);}break;case h.Loaded:clearTimeout(this._iTimeoutId);this._calculateSizes(n);break;case h.Error:clearTimeout(this._iTimeoutId);k+=" "+E+" "+m;break;default:break;}if(o){this.getAggregation("_invisiblePopupText").setText(k);}this._isRendering=true;};j.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._iResizeListenerId){this._fnResizeListener=this._onResize.bind(this);D.resize.attachHandler(this._fnResizeListener);this._iResizeListenerId=R.register(this,this._fnResizeListener);}};j.prototype.forceInvalidate=C.prototype.invalidate;j.prototype.invalidate=function(o){var k=this._getImageContent();if(this.isOpen()){if(k&&k.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};j.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnPopupOpened,this);this._oPopup.detachClosed(this._fnPopupClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}b.removeLightBoxInstance(this);};j.prototype.open=function(){var o=this._getImageContent();this._oPopup.setContent(this);if(o&&o.getImageSrc()){this._oPopup.open(300,"center center","center center",document.body,null);b.addLightBoxInstance(this);}return this;};j.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};j.prototype.close=function(){if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}this._oPopup.close();b.removeLightBoxInstance(this);return this;};j.prototype._getCloseButton=function(){var o=this.getAggregation("_closeButton");if(!o){o=new B({id:this.getId()+"-closeButton",text:this._oRB.getText("LIGHTBOX_CLOSE_BUTTON"),type:g.Transparent,press:this.close.bind(this)});this.setAggregation("_closeButton",o,true);}return o;};j.prototype._getBusyIndicator=function(){var o=this.getAggregation("_busy");if(!o){o=new e();this.setAggregation("_busy",o,true);}return o;};j.prototype._imageStateChanged=function(n){var E=n===h.Loaded||n===h.Error;if(E&&!this._isRendering){this.rerender();}};j.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnPopupOpened,this);this._oPopup.attachClosed(this._fnPopupClosed,this);};j.prototype._fnPopupOpened=function(){this._onResize();q("#sap-ui-blocklayer-popup").on("click",function(){this.close();}.bind(this));};j.prototype._fnPopupClosed=function(){q("#sap-ui-blocklayer-popup").off("click");};j.prototype._createErrorControls=function(){var E,s,t,S,o;if(this.getAggregation("_verticalLayout")){return;}if(this._getImageContent()._getImageState()===h.TimeOutError){E=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT");s=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT_DETAILS");}else{E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR");s=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");}t=new T({text:E,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorTitle");S=new T({text:s,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorSubtitle");o=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation("_verticalLayout",new V({content:[o,t,S]}).addStyleClass("sapMLightBoxVerticalLayout"));};j.prototype._onResize=function(){var m=this._calculateOffset()/2+"px",t=m,v=m,M="",k="",o=this._getImageContent(),n=this.getDomRef(),p,r,s=this._calculateOffset();if(o._getImageState()===h.Loaded){this._calculateSizes(o._getNativeImage());p=this._iWidth;r=this._iHeight;this._$lightBox.width(p);this._$lightBox.height(r);}else{p=n.clientWidth;r=n.clientHeight;}if(window.innerWidth>p+s){v="50%";k=Math.round(-p/2);}if(window.innerHeight>r+s){t="50%";M=Math.round(-r/2);}this._$lightBox.css({"top":t,"margin-top":M,"left":v,"margin-left":k});};j.prototype._calculateSizes=function(n){var F=this._calculateFooterHeightInPx(),k=288-F,o=this._getImageContent().getAggregation("_image"),H;this._setImageSize(o,n.naturalWidth,n.naturalHeight);this._calculateAndSetLightBoxSize(o);H=this._pxToNumber(o.getHeight());this.toggleStyleClass("sapMLightBoxMinSize",H<k);this._isBusy=false;};j.prototype._calculateFooterHeightInPx=function(){var k=this.$().parents().hasClass("sapUiSizeCompact"),s=this._getImageContent().getSubtitle(),F=3;if(k&&!s){F-=0.5;}if(s){F+=0.5;}return f.toPx(F);};j.prototype._calculateAndSetLightBoxSize=function(o){var k,m,n=20*16,p=18*16,F=this._calculateFooterHeightInPx();k=this._pxToNumber(o.getHeight());m=this._pxToNumber(o.getWidth());this._iWidth=Math.max(n,m);this._iHeight=Math.max(p,k+F);this._bIsLightBoxBiggerThanMinDimensions=(m>=n)&&(k>=(p-F));};j.prototype._setImageSize=function(o,w,H){var F=this._calculateFooterHeightInPx(),k=this._getDimensions(w,H,F);o.setWidth(k.width+"px");o.setHeight(k.height+"px");};j.prototype._getDimensions=function(k,m,F){var n=20*16,o=18*16,$=q(window),w=$.height(),W=$.width(),M=this._calculateOffset(),A=Math.max(W-M,n),p=Math.max(w-M,o),s;p-=F;if(m<=p){if(k<=A){}else{m*=A/k;k=A;}}else if(k<=A){k*=p/m;m=p;}else{s=Math.max(k/A,m/p);k/=s;m/=s;}return{width:Math.round(k),height:Math.round(m)};};j.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};j.prototype._getImageContent=function(){var k=this.getAggregation("imageContent");return k&&k[0];};j.prototype._calculateOffset=function(){if(D.system.desktop){return 4*16;}if(D.system.tablet){return 2*16;}if(D.system.phone&&D.resize.width>320){return 1*16;}return 0;};j.prototype.onsapescape=function(E){var o=this._oPopup.getOpenState();if(o!==O.CLOSED||o!==O.CLOSING){this.close();E.stopPropagation();}};return j;});
