/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator',"sap/ui/thirdparty/jquery","sap/ui/core/Popup"],function(l,C,B,D,N,L,P,M,U,a,b,E,q,c){"use strict";var d=c.Dock;var e=l.ListType;var f=l.ListMode;var g=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}},renderer:null});E.call(g.prototype);g.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';g.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();g.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';g.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();g.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};g.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};g.prototype.invalidate=function(){};g.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};g.prototype.openBy=function(o,w,s,i,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}if(!s){s=d.BeginTop;}if(!i){i=d.BeginBottom;}if(!O){O="0 -2";}this._getMenu().open(w,o,s,i,o,O);}};g.prototype.close=function(){if(b.system.phone){this._getDialog()&&this._getDialog().close();}else{this._getVisualParent()&&this._getVisualParent().close();}};g.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.addStyleClass("sapUiNoContentPadding");this.setAggregation("_dialog",o,true);o.attachAfterClose(this._menuClosed,this);};g.prototype._getDialog=function(){return this.getAggregation("_dialog");};g.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};g.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};g.prototype._setCustomEnhanceAccStateFunction=function(i){this._fnEnhanceUnifiedMenuAccState=i;};g.prototype._initMenuForItems=function(i,p){var m=new U();m._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};g.prototype._menuClosed=function(){this.fireClosed();};g.prototype._getMenu=function(){return this.getAggregation("_menu");};g.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:h.bind(this)});};function h(){this._getDialog().close();}g.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};g.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};g.prototype._initAllPages=function(){this._initPageForParent(this);};g.prototype._initPageForParent=function(p){var i=p.getItems(),k=p instanceof g,s=k?p.getTitle():p.getText(),o=new L({mode:f.None}),m=new P({title:s,showNavButton:!k,content:o});if(!k){this._setBackButtonTooltipForPageWithParent(p,m);}m.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(m);i.forEach(function(I){this._addListItemFromItem(I,m);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return m;};g.prototype._handleListItemPress=function(o){var i=o.getParameter("listItem"),m=sap.ui.getCore().byId(i.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};g.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var i=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof g?i.getTitle():i.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};g.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:i.getEnabled()?e.Active:e.Inactive,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()});};g.prototype._createVisualMenuItemFromItem=function(I){var u=new a({id:this._generateUnifiedMenuItemId(I.getId()),icon:I.getIcon(),text:I.getText(),startsSection:I.getStartsSection(),tooltip:I.getTooltip(),visible:I.getVisible(),enabled:I.getEnabled()}),i,k=I.getCustomData();for(i=0;i<k.length;i++){I._addCustomData(u,k[i]);}return u;};g.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var k=['aggregationChanged','propertyChanged'];k.forEach(function(s){var n='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[n],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};g.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var k=['aggregationChanged','propertyChanged'];k.forEach(function(s){var n='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[n],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};g.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var k=o.getContent()[0];this._updateListInset(k);}else{this._addVisualMenuItemFromItem(i,o,I);}};g.prototype._updateListInset=function(o){var H=false,I="sapMListIcons",k=o.getItems();for(var i=0;i<k.length;i++){if(k[i].getIcon()){H=true;break;}}if(H){o.addStyleClass(I);}else{o.removeStyleClass(I);}};g.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};g.prototype._generateListItemId=function(m){return m+g.LIST_ITEMS_ID_SUFFIX;};g.prototype._generateUnifiedMenuItemId=function(m){return m+g.UNIFIED_MENU_ITEMS_ID_SUFFIX;};g.prototype._findMenuItemByUnfdMenuItem=function(u){var k=[],o=u,I,m,i;do{k.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{m=k.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===m){if(k.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(k.length);return null;};g.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(j(m.oOpenerRef)){return true;}return false;};function j(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}g.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};g.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};g.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};g.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};g.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};g.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};g.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};g.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};g.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),i=o.getParameter("propertyValue"),t=b.system.phone?g.MENU_LIST_ITEMS_PROPS:g.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,i);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};g.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;case'tooltip':this._onTooltipAggregationChanged(o);break;}};g.prototype._onTooltipAggregationChanged=function(o){var v=o.getSource()._getVisualControl(),m=o.getParameter("methodName"),i=o.getParameter("methodParams"),V;if(!v){return;}V=sap.ui.getCore().byId(v);if(m==="set"){V.setTooltip(i.item);}if(m==="destroy"){V.destroyTooltip();}};g.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),k=o.getParameter("methodParams"),n;if(m==="add"||m==="insert"){if(m==="insert"){n=k.index;}this._addOrInsertItem(I,k.item,n);}if(m==="remove"){this._removeVisualItem(k.item,I);}if(m==="removeall"){for(var i=0;i<k.items.length;i++){this._removeVisualItem(k.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};g.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};g.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};g.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};g.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){g.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return g;});
