/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Tokenizer','./Token','./List','./StandardListItem','./Popover','./GroupHeaderListItem','./CheckBox','./Toolbar','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/typeAhead","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/filterItems","sap/m/inputUtils/itemsVisibilityHandler","sap/m/inputUtils/selectionRange","sap/m/inputUtils/calculateSelectionStart","sap/m/inputUtils/forwardItemPropertiesToToken","sap/m/inputUtils/getTokenByItem","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/Core",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,T,b,L,S,P,G,c,d,l,E,e,f,D,g,h,R,M,j,k,m,t,n,o,p,s,q,r,u,K,v,w,x,y,z,Q){"use strict";var A=l.ListMode;var V=f.ValueState;var O=f.OpenState;var B=l.TokenizerRenderMode;var F=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]},hasSelection:{type:"boolean",visibility:"hidden",defaultValue:false},showSelectAll:{type:"boolean",defaultValue:false}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},changedItems:{type:"sap.ui.core.Item[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}}});e.insertFontFaceStyle();E.apply(F.prototype,[true]);F.prototype.clone=function(i){var H=a.prototype.clone.apply(this,arguments),J=this._getList();if(J){H.syncPickerContent();}return H;};F.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true;}this.syncPickerContent();return a.prototype.open.apply(this,arguments);};F.prototype.onsapend=function(i){if(i.isMarked("forwardFocusToParent")){this.focus();}};F.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart&&this._hasTokens()){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}i.setMarked();};F.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(!this.isOpen()){this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isFocusInTokenizer()&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}return;}setTimeout(this.handleDownEvent.bind(this,i),0);};F.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()||this.isOpen()){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};F.prototype.handleDownEvent=function(i){if(!this.isOpen()){return;}var H=i.srcControl,J=H&&H.getDomRef(),N=j(this.getDomRef(),J),U=this.getPicker().getCustomHeader(),W=U&&U.getDomRef();i.setMarked();i.preventDefault();if(N&&this.getValueState()!=V.None){this._handleFormattedTextNav();return;}if((N||j(W,J))&&this.getShowSelectAll()){this.focusSelectAll();return;}this.focusFirstItemInList();};F.prototype.handleEndEvent=function(i){i.setMarked();i.preventDefault();var H=n.getVisibleItems(this.getItems()),J=H.length&&n.getListItem(H[H.length-1]);J&&J.focus();};F.prototype.handleHomeEvent=function(i){i.setMarked();i.preventDefault();if(this.getValueState()!==V.None){this._handleFormattedTextNav();i.stopPropagation(true);return;}if(this.getShowSelectAll()){this.focusSelectAll();i.stopPropagation(true);return;}this.focusFirstItemInList();};F.prototype.focusFirstItemInList=function(){var i=n.getVisibleItems(this.getItems()),H=i.length&&n.getListItem(i[0]);H&&H.focus();};F.prototype.isFocusInTokenizer=function(){return Q.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement);};F.prototype.onsapshow=function(i){i.preventDefault();this._handleItemToFocus();a.prototype.onsapshow.apply(this,arguments);};F.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();a.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments);};F.prototype._valueStateNavDelegate=function(i,H){return{onsapdown:this.handleDownEvent,onsapup:this.focus,onsapend:this.handleEndEvent,onfocusout:function(J){i.removeStyleClass("sapMFocusable");if(!i.getDomRef().contains(J.relatedTarget)){H.forEach(function(N){N.getDomRef().setAttribute("tabindex","-1");});}},onsapshow:this.close,onsaphide:this.close};};F.prototype._closePickerDelegate={onsaptabnext:function(){this.close();setTimeout(function(){this.closeValueStateMessage();}.bind(this),0);}};F.prototype._formattedTextLinksNav={onsapup:this.focus,onsapdown:this.handleDownEvent};F.prototype._handleFormattedTextNav=function(){var i=this.getPicker().getCustomHeader(),H=this.getValueStateLinks(),J=H?H[H.length-1]:null,N=H?H[0]:null;if(!i.getDomRef()||i.getDomRef()===document.activeElement){return;}if(!this.oValueStateNavDelegate){this.oValueStateNavDelegate=this._valueStateNavDelegate(i,H);i.addEventDelegate(this.oValueStateNavDelegate,this);}i.getDomRef().setAttribute("tabindex","-1");i.addStyleClass("sapMFocusable");i.focus();H.forEach(function(U){U.getDomRef().setAttribute("tabindex","0");U.addEventDelegate(this._formattedTextLinksNav,this);},this);this.oMoveFocusBackToVSHeader=!this.oMoveFocusBackToVSHeader?{onsaptabprevious:function(U){U.preventDefault();i.focus();i.addStyleClass("sapMFocusable");}}:this.oMoveFocusBackToVSHeader;J&&J.addEventDelegate(this._closePickerDelegate,this);N&&N.addEventDelegate(this.oMoveFocusBackToVSHeader,this);};F.prototype.onsaphide=function(i){this.onsapshow(i);};F.prototype._selectItemByKey=function(H){var J,N,U,i,W,X,Y=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(H){H.setMarked();}J=this._getUnselectedItems(Y?"":this.getValue());for(i=0;i<J.length;i++){X=!(J[i].getKey()===undefined||J[i].getKey()===null)&&!J[i].isA("sap.ui.core.SeparatorItem");if(J[i].getText().toUpperCase()===this.getValue().toUpperCase()&&X){U=J[i];W=true;break;}}if(W){N={item:U,id:U.getId(),key:U.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&U.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(n.getListItem(U).isSelected()){this.setValue('');}else{this.setSelection(N);}}}else{this._bPreventValueRemove=true;}if(H){this.close();}};F.prototype.onsapenter=function(i){var H=this.getAggregation("tokenizer");I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}if(!this.getEditable()&&H.getHiddenTokensCount()&&i.target===this.getFocusDomRef()){H._togglePopup(H.getTokensPopup());}};F.prototype.onsaptabnext=function(i){var H=this.getValue();if(H){var J=this._getUnselectedItemsStartingText(H);if(J.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};F.prototype.onsaptabprevious=F.prototype.onsaptabnext;F.prototype.onsapfocusleave=function(i){var H=this.isPlatformTablet(),J=y.byId(i.relatedControlId),N=J&&J.getFocusDomRef(),U=this.getValue(),W=this.getPicker(),X=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!W||!W.getFocusDomRef()||!N||!Q.contains(W.getFocusDomRef(),N))){this.setValue(null);if(U){this.fireChangeEvent("",{value:U});}if(!Q.contains(this.getDomRef(),document.activeElement)){X.setRenderMode(B.Narrow);}}if(W&&N){if(v(W.getFocusDomRef(),N)&&!H&&!this.isPickerDialog()){this.focus();}}};F.prototype.onfocusin=function(i){var H=this.getPicker();var J=false;var N=H&&H.getFocusDomRef();var U=(H&&H.oPopup.getOpenState())||O.CLOSED;var W=U===O.CLOSING||U===O.CLOSED;var X=this.getPickerType()==="Dropdown";var Y=this.getAggregation("tokenizer");if(X){J=N&&Q.contains(N,i.relatedTarget);}if(this.getEditable()&&i.target===this.getDomRef("inner")){Y.setRenderMode(B.Loose);}if(i.target===this.getFocusDomRef()){Y.hasOneTruncatedToken()&&Y.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!W&&J&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&X&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};F.prototype._handleItemTap=function(i){var H=Q(i.target).control(0);if(!H.isA("sap.m.CheckBox")&&!H.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;}};F.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var H=this._getLastSelectedItem();if(H){n.getListItem(H).focus();}}};F.prototype._handleSelectionLiveChange=function(i){if(i.getParameter("selectAll")){return;}var H=i.getParameter("listItem");var J=i.getParameter("listItems");var N=J&&J[J.length-1]||H;var U=this.isPickerDialog()?this.getPickerTextField():this;var W=this._getIsClick()&&!!N;var X=i.getParameter("selected");var Y=n.getItemByListItem(this.getItems(),H);var Z;if(J&&J.length){Z=[];J.forEach(function(_){if(_.getType()==="Active"){Z.push(n.getItemByListItem(this.getItems(),_));}},this);}if(H.getType()==="Inactive"){return;}w(Y,"The corresponding mapped item was not found on "+this);if(!Y){return;}var $={item:Y,items:Z,id:Y.getId(),key:Y.getKey(),selectAll:false,fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(X){this.fireChangeEvent(Y.getText());this.setSelection($);}else{this.fireChangeEvent(Y.getText());this.removeSelection($);}if(this._bCheckBoxClicked){U.setValue(this._sOldInput);if(W&&this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){N.focus();this._setIsClick(false);}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};F.prototype.onkeydown=function(i){var H=this.getEditable(),J=this.getAggregation("tokenizer"),N=J.getTokens().length;a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return;}if((i.ctrlKey||i.metaKey)&&i.which===K.I&&N){i.preventDefault();if(H){this._togglePopover();}else{this._handleIndicatorPress();}return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){J.focus();J.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=Q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=!D.os.android&&(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};F.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var H=i.srcControl,J=this.isPickerDialog(),N=J?this.getPickerTextField():this,U=N.getValueState();if(U===V.Error&&this._bAlreadySelected){N.setValueState(this._sInitialValueState);N.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false;}if(!this.getEnabled()||!this.getEditable()){return;}this.syncPickerContent();this.handleInputValidation(i,this.isComposingCharacter());if(this._bIsPasteEvent){H.updateDomValue(this._sOldValue||i.target.value||"");return;}if(this.isOpen()){setTimeout(this.highlightList.bind(this,this._sOldInput));}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};F.prototype.filterItems=function(i){return o(this,i.items,i.value,true,false,this.fnFilter||m);};F.prototype.onkeyup=function(i){a.prototype.onkeyup.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=Q(this.getFocusDomRef()).cursorPos();};F.prototype._showWrongValueVisualEffect=function(){var i=this._getSuggestionsPopover();var H=this._sInitialValueStateText;var J=this._sInitialValueState;var N=H||this._oRbC.getText("VALUE_STATE_ERROR");var U=this;if(J===V.Error){return;}if(i){i.updateValueState(V.Error,N,true);setTimeout(i.updateValueState.bind(i,U.getValueState(),N,true),1000);}if(!this.isPickerDialog()){this.setValueState(V.Error);this.setValueStateText(this.getValueStateText()||N);setTimeout(this["setValueState"].bind(this,J||V.Error),1000);}this._syncInputWidth(this.getAggregation("tokenizer"));};F.prototype._showAlreadySelectedVisualEffect=function(){var i=this._oRb.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return;}var H=!!this.getSelectedItems().filter(function(J){return J.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;var N=this.getItems().filter(function(J){return J.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;if(H){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText();this.setValueStateText(i);this._bAlreadySelected=true;this.setValueState("Error");return;}else if(N){return;}else{this._showWrongValueVisualEffect();}};F.prototype._hasShowSelectedButton=function(){return true;};F.prototype.forwardEventHandlersToSuggPopover=function(i){a.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);i.setShowSelectedPressHandler(this._filterSelectedItems.bind(this));};F.prototype.configPicker=function(i){var H=this.getRenderer(),J=H.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(H.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(J+"Picker").addStyleClass(J+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};F.prototype._configureList=function(i){var H=10;if(!i){return;}i.setMode(A.MultiSelect);i.setIncludeItemInSelection(true);i.setGrowingThreshold(H);i.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);i.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);this.getShowSelectAll()&&this.createSelectAllHeaderToolbar(i);};F.prototype._decoratePopupInput=function(i){a.prototype._decoratePopupInput.apply(this,arguments);if(!i||!i.isA(["sap.m.InputBase"])){return;}i.attachSubmit(function(H){var J=i.getValue();if(J){this.setValue(J);this._selectItemByKey();this.setValue(this._sOldInput);this.close();}}.bind(this));i.addEventDelegate({onfocusout:this._handleInputFocusOut},this);i.attachChange(this._handleInnerInputChange.bind(this));return i;};F.prototype._handleInnerInputChange=function(i){if(i.getParameter("value")===""){this._sOldInput="";this.clearFilter();}};F.prototype.onBeforeRendering=function(){var i=this.getEditable();var H=this.getAggregation("tokenizer");var J=this.getItems();a.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;H.setEnabled(this.getEnabled());H.setEditable(i);this._updatePopoverBasedOnEditMode(i);if(!J.length){this._clearTokenizer();}if(this._getList()){this.syncPickerContent(true);}this.toggleSelectAllVisibility(this.getShowSelectAll());if(this._sOldInput&&J.length&&this.isOpen()){p(this.getItems(),this.filterItems({value:this._sOldInput,items:J}));setTimeout(this.highlightList.bind(this,this._sOldInput));}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();this.setProperty("hasSelection",!!this.getSelectedItems().length,true);if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText();}if(this.getValueState()!==V.Error){this._sInitialValueState=this.getValueState();}};F.prototype.syncPickerContent=function(i){var H,J,N=this.getPicker();if(!N){N=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();i=true;}if(i){J=this._getList();H=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();J.destroyItems();this._clearTokenizer();this._fillList(H);if(J.getItemNavigation()){this._iFocusedIndex=J.getItemNavigation().getFocusedIndex();}}return N;};F.prototype._registerResizeHandler=function(){w(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};F.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};F.prototype._onResize=function(){var i=this.getAggregation("tokenizer");i.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(i);this._handleNMoreAccessibility();};F.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};F.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var i=this["_onBeforeOpen"+this.getPickerType()];this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this);}};F.prototype.onAfterOpen=function(){var i=this.getFocusDomRef(),H=this.getValueStateLinks();i&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}H.forEach(function(J){J.addDelegate({onAfterRendering:function(){if(this.getFocusDomRef()){this.getFocusDomRef().setAttribute("tabindex","-1");}}},J);});this.closeValueStateMessage();};F.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};F.prototype.onAfterClose=function(){var U=!Q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(U?B.Narrow:B.Loose);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}};F.prototype._onBeforeOpenDialog=function(){};F.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),H=this.getDomRef(),W;if(H&&i){W=(H.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(W);}};F.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton();};F.prototype._filterSelectedItems=function(i,H){var J=i.oSource,N,U,W=this.getPickerTextField()?this.getPickerTextField().getValue():"",X=(J&&J.getPressed&&J.getPressed())||H,Y=n.getVisibleItems(this.getItems()),Z=this.getItems(),$=this.getSelectedItems(),_=null;if(X){Y.forEach(function(a1){U=$.indexOf(a1)>-1?true:false;N=n.getListItem(a1);if(!N){return;}if(N.isA("sap.m.GroupHeaderListItem")){N.setVisible(false);_=N;}else{N.setVisible(U);if(U&&_){_.setVisible(true);}}},this);}else{p(this.getItems(),this.filterItems({value:W,items:Z}));}this.manageSelectAllCheckBoxState();};F.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};F.prototype.setSelection=function(i){var H=this._getList(),N;if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.items||!i.items.length||i.selectAll){N=[i.item];}else{N=i.items;}N.forEach(function(J){if(!i.listItemUpdated&&n.getListItem(J)&&H){H.setSelectedItem(n.getListItem(J),true);}var U=new b({key:J.getKey()});U.setText(J.getText());J.data(n.CSS_CLASS+"Token",U);this.getAggregation("tokenizer").addToken(U);this.addAssociation("selectedItems",J,i.suppressInvalidate);var W=this.getSelectedKeys();var X=this.getKeys([J])[0];if(X===""||W.indexOf(X)===-1){W.push(X);this.setProperty("selectedKeys",W,i.suppressInvalidate);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,changedItems:i.items,selectAll:i.selectAll,selected:true});}},this);if(!this.getProperty("hasSelection")&&this.getSelectedItems().length){this.setProperty("hasSelection",true);}this.setValue('');if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};F.prototype.removeSelection=function(i){var H,J,N;if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.items||!i.items.length||i.selectAll){H=[i.item];}else{H=i.items;}H.forEach(function(U){this.removeAssociation("selectedItems",U,i.suppressInvalidate);J=this.getSelectedKeys();N=J.indexOf(U.getKey());J.splice(N,1);this.setProperty("selectedKeys",J,i.suppressInvalidate);if(!i.listItemUpdated&&n.getListItem(U)){var W=n.getListItem(U);this._getList().setSelectedItem(W,false);}if(!i.tokenUpdated){var X=u(U);U.data(n.CSS_CLASS+"Token",null);this.getAggregation("tokenizer").removeToken(X);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,changedItems:i.items,selectAll:i.selectAll,selected:false});}},this);if(this.getProperty("hasSelection")&&!this.getSelectedItems().length){this.setProperty("hasSelection",false);}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};F.prototype._synchronizeSelectedItemAndKey=function(){var H=this.getSelectedKeys();var J=this.getKeys(this.getSelectedItems());if(!H.length){x.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}for(var i=0,N=null,U=null,W=H.length;i<W;i++){N=H[i];if(J.indexOf(N)>-1){continue;}U=this.getItemByKey(""+N);if(U){this.setSelection({item:U,id:U.getId(),key:U.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}};F.prototype.updateItems=function(i){var H=function(X){return X&&X.getKey&&X.getKey();},J,N=this.getSelectedItems().map(H),U=this.getSelectedKeys();var W=a.prototype.updateItems.apply(this,arguments);N=this.getSelectedItems().map(H).filter(function(X){return N.indexOf(X)>-1;});J=U.concat(N);this.setSelectedKeys(J);return W;};F.prototype._getSelectedItemsOf=function(H){for(var i=0,J=H.length,N=[];i<J;i++){if(n.getListItem(H[i]).isSelected()){N.push(H[i]);}}return N;};F.prototype._getLastSelectedItem=function(){var i=this.getAggregation("tokenizer").getTokens();var H=i.length?i[i.length-1]:null;if(!H){return null;}return this._getItemByToken(H);};F.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var i=y.byId(document.activeElement.id);if(this._getList()&&j(this._getList().getFocusDomRef(),i.getFocusDomRef())){return i;}return null;};F.prototype._getFocusedItem=function(){return n.getItemByListItem(this.getItems(),this._getFocusedListItem());};F.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0;};F.prototype._decorateListItem=function(i){i.addDelegate({onkeydown:function(H){if((H.ctrlKey||H.metaKey)&&H.which==K.A){H.setMarked();H.preventDefault();var J=n.getSelectableItems(this.getItems());var N=this._getSelectedItemsOf(J);if(N.length!==J.length){J.forEach(function(U){this.setSelection({item:U,items:J,selectAll:true,id:U.getId(),key:U.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{J.forEach(function(U){this.removeSelection({item:U,items:J,selectAll:true,id:U.getId(),key:U.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}},onmousedown:function(H){this._setIsClick(true);},onkeyup:function(H){var J=null;if(H.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();J=this._getLastSelectedItem();if(J){n.getListItem(J).focus();}return;}}},true,this);i.addEventDelegate({onsapbackspace:function(H){H.preventDefault();},onsapshow:function(H){H.setMarked();this.close();},onsaphide:function(H){this.onsapshow(H);},onsapenter:function(H){H.setMarked();this.close();},onsaphome:this.handleHomeEvent.bind(this),onsapend:this.handleEndEvent.bind(this),onsapup:function(H){H.setMarked();H.preventDefault();var J=n.getVisibleItems(this.getItems());var N=J[0];var U=Q(document.activeElement).control()[0];if(U!==n.getListItem(N)){return;}if(this.getShowSelectAll()){this.focusSelectAll();}else if(this.getValueState()!==V.None){this._handleFormattedTextNav();}else{this.focus();}H.stopPropagation(true);},onfocusin:function(H){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(H){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(H){var J=this.getAggregation("picker");var N=y.byId(H.relatedControlId);if(J&&N&&v(J.getFocusDomRef(),N.getFocusDomRef())){if(H.srcControl){H.srcControl.focus();}}},onsaptabnext:function(){this.getPicker().close();},onsaptabprevious:function(){this.getPicker().close();}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(H){H.setMark("cancelAutoClose");}});}};F.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,U=this._sOldInput||this._sOldValue||"";i.updateDomValue(U);this._bIsPasteEvent=null;};F.prototype.onItemChange=function(i){var H=a.prototype.onItemChange.call(this,i,this.getShowSecondaryValues());var J=i.getParameters();r({item:i.getSource(),propName:J.name,propValue:J.newValue});return H;};F.prototype._handleIndicatorPress=function(){var i,H=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();i=this.getPicker();i.open();}else{H._togglePopup(H.getTokensPopup());}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}};F.prototype._togglePopover=function(){var i=this.getPicker();if(!i){i=this.syncPickerContent(true);}if(i.isOpen()){i.close();}else{i.open();}};F.prototype._createTokenizer=function(){var i=new T({renderMode:B.Narrow}).attachTokenDelete(this._handleTokenDelete,this);i.getTokensPopup().attachAfterOpen(function(){if(i.hasOneTruncatedToken()){i.setFirstTokenTruncated(false);}}).attachAfterClose(function(){var H=i.getTokens();if(H.length===1&&!H[0].getTruncated()){i.setFirstTokenTruncated(true);}});i.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return i;};F.prototype._onAfterRenderingTokenizer=function(){var i=this.getAggregation("tokenizer");if(this.getEditable()){i.addStyleClass("sapMTokenizerIndicatorDisabled");}else{i.removeStyleClass("sapMTokenizerIndicatorDisabled");}setTimeout(this._syncInputWidth.bind(this,i),0);setTimeout(this._handleNMoreAccessibility.bind(this),0);setTimeout(i["scrollToEnd"].bind(i),0);};F.prototype._handleTokenDelete=function(i){var H=i.getParameter("tokens");var J=this.getSelectedItems();this._removeSelection(H);if(J.length!==n.getSelectableItems(this.getItems())){!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("");}};F.prototype._removeSelection=function(i){var H=this.getAggregation("tokenizer");i.forEach(function(J){var N=(J&&this._getItemByToken(J));if(!this.getEditable()||!this.getEnabled()||!N||!this.isItemSelected(N)||!N.getEnabled()||!J.getEditable()){return;}this.removeSelection({item:N,id:N.getId(),key:N.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});J.destroy();if(this.getSelectedItems().length>0){var i=H.getTokens();i[i.length-1].focus();}else{this.focus();}},this);};F.prototype.onAfterRenderingList=function(){var i=document.activeElement===this.getFocusDomRef();var H=this._getList();var J=H?H.getVisibleItems():[];if(this.getEditable()&&!i&&J[this._iFocusedIndex]){J[this._iFocusedIndex].focus();this._iFocusedIndex=null;}this.manageSelectAllCheckBoxState();};F.prototype.onFocusinList=function(){var i=this._getList();if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){i.getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}this._getSuggestionsPopover().updateListDataAttributes(i);};F.prototype.onAfterRendering=function(){var i=this.getAggregation("tokenizer");a.prototype.onAfterRendering.apply(this,arguments);this._registerResizeHandler();setTimeout(function(){i.setMaxWidth(this._calculateSpaceForTokenizer());}.bind(this),0);};F.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRb.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText);}a.prototype.onfocusout.apply(this,arguments);};F.prototype.onpaste=function(i){var H;var J=false;var N=this.getSelectedItems();if(window.clipboardData){H=window.clipboardData.getData("Text");}else{H=i.originalEvent.clipboardData.getData('text/plain');}var U=H.split(/\r\n|\r|\n/g);if(U&&U.length>0){n.getSelectableItems(this.getItems()).filter(function(W){return N.indexOf(W)===-1;}).forEach(function(W){if(U.indexOf(W.getText())>-1){J=true;this.setSelection({item:W,id:W.getId(),key:W.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}if(J){i.stopPropagation();i.preventDefault();}};F.prototype.onsapbackspace=function(i){var H=this.getAggregation("tokenizer");var J=H.getTokens();var N=J.filter(function(U){return U.getSelected();});if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}if(N.length>0){this._removeAllTokens();return;}if(document.activeElement===this.getFocusDomRef()){J[J.length-1]&&J[J.length-1].focus();}i.preventDefault();};F.prototype._removeAllTokens=function(){var i=this.getAggregation("tokenizer");var H=i.getTokens().filter(function(J){return J.getSelected();});if(!H.length){return;}this._removeSelection(H);this.fireChangeEvent("");this.invalidate();};F.prototype.onsapdelete=F.prototype.onsapbackspace;F.prototype.onsapnext=function(i){var H=this.getAggregation("tokenizer");if(i.isMarked()){return;}var J=Q(document.activeElement).control()[0];if(!J){return;}if(J===H||H.$().find(J.$()).length>0&&this.getEditable()){H.scrollToEnd();this.focus();}};F.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!k(this.getFocusDomRef())){if(i.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}};F.prototype.onclick=function(i){var H=this.getEditable(),J=this.getEnabled(),N=i.target.className.indexOf("sapMTokenizerIndicator")>-1;if(H&&J&&N){i.preventDefault();this._handleIndicatorPress();}};F.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var H=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&H.contains(i.target)){this.open();}};F.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};F.prototype._getItemsStartingWithPerTerm=function(i,H){var J=[],N=H?n.getEnabledItems(this.getItems()):n.getSelectableItems(this.getItems()),U=this.fnFilter?this.fnFilter:m;N.forEach(function(W){if(U(i,W)){J.push(W);}},this);return J;};F.prototype._getItemsStartingWith=function(i,H){var J=[],N=H?n.getEnabledItems(this.getItems()):n.getSelectableItems(this.getItems());N.forEach(function(U){if(typeof i==="string"&&i!==""&&U.getText().toLowerCase().startsWith(i.toLowerCase())){J.push(U);}},this);return J;};F.prototype._getUnselectedItemsStartingText=function(i){var H=[];this._getUnselectedItems().forEach(function(J){if(typeof i==="string"&&i!==""&&J.getText().toLowerCase().startsWith(i.toLowerCase())){H.push(J);}},this);return H;};F.prototype.getCursorPosition=function(){return this._$input.cursorPos();};F.prototype._selectPreviousItemsOf=function(i){var H;do{H=true;var J=this._getPreviousVisibleItemOf(i);if(J){var N=n.getListItem(J);if(N){H=n.getListItem(J).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=J;}while(!H);};F.prototype._getNextVisibleItemOf=function(i){var H=n.getSelectableItems(this.getItems());var J=H.indexOf(i)+1;if(J<=0||J>H.length-1){return null;}return H[J];};F.prototype._getPreviousVisibleItemOf=function(i){var H=n.getSelectableItems(this.getItems());var J=H.indexOf(i)-1;if(J<0){return null;}return H[J];};F.prototype._getNextUnselectedItemOf=function(i){var H=this._getUnselectedItems();var J=H.indexOf(i)+1;if(J<=0||J>H.length-1){return null;}return H[J];};F.prototype._getPreviousUnselectedItemOf=function(i){var H=this._getUnselectedItems();var J=H.indexOf(i)-1;if(J<0){return null;}return H[J];};F.prototype._getNextTraversalItem=function(){var i=this.getValue();var H=i?this._getItemsStartingWithPerTerm(i):[];var J=this._getUnselectedItems();if(H.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(H.length&&H[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(H[0]);}return H.length?H[0]:J[0];};F.prototype._getPreviousTraversalItem=function(){var i=this.getValue();var H=i?this._getItemsStartingWithPerTerm(i):[];if(H.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(H.length&&H[H.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(H[H.length-1]);}if(H.length){return H[H.length-1];}else{var J=this._getUnselectedItems();if(J.length>0){return J[J.length-1];}else{return null;}}};F.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){x.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(H){if(!(H instanceof g)&&(typeof H!=="string")){x.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof H==="string"){H=y.byId(H);}this.setSelection({item:H?H:null,id:H?H.getId():"",key:H?H.getKey():"",suppressInvalidate:true});},this);return this;};F.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=y.byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};F.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=y.byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};F.prototype.removeAllSelectedItems=function(){var i=[];var H=this.getAssociation("selectedItems",[]);H.forEach(function(J){var N=this.removeSelectedItem(J);if(N){i.push(N.getId());}},this);return i;};F.prototype.removeSelectedKeys=function(i){var H,J=[];if(!i||!i.length||!Array.isArray(i)){return J;}i.forEach(function(N){H=this.getItemByKey(N);if(H){this.removeSelection({item:H?H:null,id:H?H.getId():"",key:H?H.getKey():"",fireChangeEvent:false,suppressInvalidate:true});J.push(H);}},this);return J;};F.prototype.setSelectedKeys=function(i){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems();}this.addSelectedKeys(i);this._bInitialSelectedKeysSettersCompleted=true;return this;};F.prototype.addSelectedKeys=function(i){var H,J=[];i=this.validateProperty("selectedKeys",i);i.forEach(function(N){var U=this.getItemByKey(N);if(U){this.addSelectedItem(U);}else if(N!=null){J.push(N);}},this);if(J.length>0){H=this.getProperty("selectedKeys").filter(function(N){return J.indexOf(N)===-1;});J=H.concat(J);this.setProperty("selectedKeys",J,true);}return this;};F.prototype._getUnselectedItems=function(){var i=Q(n.getSelectableItems(this.getItems())).not(this.getSelectedItems()).get();if(!this.isOpen()){return i.filter(function(H){return!H.isA("sap.ui.core.SeparatorItem");});}return i;};F.prototype.getSelectedItems=function(){var i=[],H=this.getAssociation("selectedItems")||[];H.forEach(function(J){var N=y.byId(J);if(N){i.push(N);}},this);return i;};F.prototype.getWidth=function(){return this.getProperty("width")||"100%";};F.prototype._updatePopoverBasedOnEditMode=function(i){var H=this._getList(),J=this._getSuggestionsPopover();if(H&&i!==this._bPrevEditable&&i){J.addContent(H);}this._bPrevEditable=i;};F.prototype._mapItemToListItem=function(i){var H,J,N,U=this.getRenderer();if(!i){return null;}H=n.createListItemFromCoreItem(i,this.getShowSecondaryValues());this._decorateListItem(H);if(i.isA("sap.ui.core.SeparatorItem")){return H;}J=U.CSS_CLASS_MULTICOMBOBOX+"Item";N=(this.isItemSelected(i))?J+"Selected":"";H.addStyleClass(J+" "+N);if(N){var W=new b({key:i.getKey()});W.setText(i.getText());i.data(n.CSS_CLASS+"Token",W);this.getAggregation("tokenizer").addToken(W,true);}this.setSelectable(i,i.getEnabled());return H;};F.prototype.setSelectable=function(i,H){a.prototype.setSelectable.call(this,i,H);var J=u(i);if(J){J.setVisible(H);}};F.prototype._fillList=function(){var H=this._getList();var J=this.getEditable()?this.getItems():this.getSelectedItems();if(!H){return;}H.destroyItems();if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(W){if(W.srcControl.isSelected()){W.setMarked();}}};}for(var i=0,N,U=J.length;i<U;i++){N=this._mapItemToListItem(J[i]);N.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this._getList().addAggregation("items",N,true);if(this.isItemSelected(J[i])){this._getList().setSelectedItem(N,true);}}};F.prototype.handleInputValidation=function(i,H){var J=i.target.value,N=this.isValueValid(J),U,W,X;var Y=i.srcControl;if(!N&&J!==""&&!H){this._handleFieldValidationState(Y);return;}X=this._getItemsStartingWith(J,true);if(!H||this._bIsPasteEvent){this._handleTypeAhead(J,X,Y);}U=this.getItems();if(this.isPickerDialog()){W=this.getFilterSelectedButton();if(W!=null&&W.getPressed()){W.setPressed(false);}}p(this.getItems(),this.filterItems({value:J,items:U}));this.manageSelectAllCheckBoxState();this._sOldInput=J;if((!this.getValue()||!N)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};F.prototype.isValueValid=function(i){var H=this._getItemsStartingWith(i,true);var J=this._getItemsStartingWithPerTerm(i,true);return H.length||J.length;};F.prototype._handleTypeAhead=function(i,H,J){var N,U;if(!this._bDoTypeAhead){return;}N=this.getSelectedItems();U=H.filter(function(W){return N.indexOf(W)===-1;});t(i,J,U);};F.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");i.setProperty("effectiveShowClearIcon",false);}if(this._iOldCursorPos){Q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};F.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbC=y.getLibraryResourceBundle("sap.ui.core");this._fillList();};F.prototype.handleItemRemoval=function(i){this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});};F.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};F.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens();};F.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}this._oRbC=null;this._oListItemEnterEventDelegate=null;this.oValueStateNavDelegate=null;this._sInitialValueState=null;};F.prototype.destroyItems=function(){this.setProperty("selectedKeys",[]);this._clearTokenizer();return this.destroyAggregation("items");};F.prototype._getItemByToken=function(i){return n.getItemBy(this.getItems(),i,"Token");};F.prototype._getItemByValue=function(H){var J=n.getSelectableItems(this.getItems());for(var i=0;i<J.length;i++){if(J[i].getText().toLowerCase()===H.toLowerCase()){return J[i];}}};F.prototype._handleItemToFocus=function(){if(this.isOpen()){return;}this.syncPickerContent();var i,H,J=y.byId(document.activeElement.id),N=this.getSelectedItems(),U=n.getSelectableItems(this.getItems()),W=this._getList(),X=W&&W.getItemNavigation(),Y=this.getValue(),Z=this.getPicker();if(J&&J.isA("sap.m.Token")){H=this._getItemByToken(J);}else if(Y){H=this._getItemByValue(Y);}if(!H){H=N.length?n.getItemByListItem(this.getItems(),this._getList().getSelectedItems()[0]):U[0];}i=n.getVisibleItems(this.getItems()).indexOf(H);if(X){X.setSelectedIndex(i);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=i;}if(!H){Z.setInitialFocus(this);}else{Z.setInitialFocus(W);}};F.prototype.getAccessibilityInfo=function(){var i=this.getSelectedItems().map(function(J){return J.getText();}).join(" ");var H=a.prototype.getAccessibilityInfo.apply(this,arguments);H.type=y.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");H.description=(this.getValueDescriptionInfo()+" "+i).trim();return H;};F.prototype.getValueDescriptionInfo=function(){if(this.getValue()){return this.getValue();}return this._hasTokens()?"":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_EMPTY");};F.prototype._setIsClick=function(i){this._bIsClick=i;};F.prototype._getIsClick=function(){return this._bIsClick;};F.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i,H=this.getDomRef().getBoundingClientRect().width,J=this._calculateIconsSpace(),N=this.$().find(".sapMInputBaseInner"),U=["min-width","padding-right","padding-left"],W=U.reduce(function(X,Y){return X+(parseInt(N.css(Y))||0);},0);i=H-(J+W);i=i<0?0:i;return i+"px";}else{return null;}};F.prototype._syncInputWidth=function(i){var H=this.getDomRef('inner'),J,N;if(!H||(i&&!i.getDomRef())){return;}N=parseFloat(i.getDomRef().getBoundingClientRect().width.toFixed(2));J=this._calculateIconsSpace();H.style.width='calc(100% - '+parseFloat(J+N)+"px)";};F.prototype._handleNMoreAccessibility=function(){var i=z.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),H=this.getAggregation("tokenizer"),J=this.getFocusDomRef(),N=(J&&J.getAttribute("aria-describedby")),U=N?N.split(" "):[],W=U.indexOf(i),X=this.getEnabled(),Y=!this.getEditable()&&H&&H.getHiddenTokensCount();if(Y&&W===-1){U.push(i);X&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(W!==-1&&!Y){U.splice(W,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(J&&U.length){J.setAttribute("aria-describedby",U.join(" ").trim());}};F.prototype.applyShowItemsFilters=function(){this.syncPickerContent();p(this.getItems(),this.filterItems({value:this.getValue()||"_",items:this.getItems()}));this.manageSelectAllCheckBoxState();};F.prototype.showItems=function(i){var H=true,J=this.fnFilter;if(typeof i==="function"){this.syncPickerContent();this.setFilterFunction(i||function(){return true;});H=this.filterItems({value:this.getValue()||"_",items:this.getItems()}).items.length>0;this.setFilterFunction(J);}if(H){a.prototype.showItems.apply(this,arguments);}};F.prototype.createSelectAllHeaderToolbar=function(i){i=i||this._getList();if(!i||i.getHeaderToolbar()){return;}var H=new c({select:function(J){var N=J.getSource(),U=n.getSelectableItems(this.getItems()),W=this._getSelectedItemsOf(U);if(J.getParameter("selected")){var X=U.filter(function(Y){return W.indexOf(Y)===-1;});X.forEach(function(Y){this.setSelection({item:Y,items:X,selectAll:true,id:Y.getId(),key:Y.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{W.forEach(function(Y){this.removeSelection({item:Y,items:W,selectAll:true,id:Y.getId(),key:Y.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}N.focus();}.bind(this)});H.addEventDelegate(this._selectAllDelegate(),this);i.setHeaderToolbar(new d({content:H}).addStyleClass("sapMMultiComboBoxSelectAll")).setSticky(["HeaderToolbar"]);this.attachSelectionChange(this.manageSelectAllCheckBoxState.bind(this));};F.prototype.manageSelectAllCheckBoxState=function(){var i=this.getSelectAllCheckbox();if(!i){return;}var H=this.getItems(),J=this.getSelectedItems(),N=n.getSelectableItems(H).filter(function(U){return J.indexOf(U)>-1;}).length===n.getSelectableItems(H).length;i.setText(this._oRb.getText("MULTICOMBOBOX_SELECT_ALL_CHECKBOX",[J.length,n.getAllSelectableItems(H).length])).setSelected(N);};F.prototype.getSelectAllToolbar=function(){var i=this._getList();return i&&i.getHeaderToolbar();};F.prototype.getSelectAllCheckbox=function(){var i=this.getSelectAllToolbar();return i&&i.getContent()[0];};F.prototype._selectAllDelegate=function(){return{onsapdown:this.handleDownEvent,onsapup:function(i){i.preventDefault();if(this.getValueState()!==V.None){this._handleFormattedTextNav();return;}this.getFocusDomRef().focus();},onsaphome:this.handleHomeEvent,onsapend:this.handleEndEvent,onfocusin:function(){var i=this.getRenderer(),H=this.getSelectAllToolbar();H&&H.addStyleClass(i.CSS_CLASS_MULTICOMBOBOX+"SelectAllFocused");},onfocusout:function(){var i=this.getRenderer(),H=this.getSelectAllToolbar();H&&H.removeStyleClass(i.CSS_CLASS_MULTICOMBOBOX+"SelectAllFocused");},onsapshow:this.close,onsaphide:this.close};};F.prototype.focusSelectAll=function(){var i=this.getSelectAllCheckbox();i&&i.focus();};F.prototype.toggleSelectAllVisibility=function(i){var H=this.getSelectAllToolbar();if(H){H.setVisible(i);return;}i&&this.createSelectAllHeaderToolbar();};F.prototype.handleClearIconPress=function(){if(!(this.getEnabled()&&this.getEditable())){return;}if(this.getValue()!==""){this.setValue("");this._sOldInput="";this.setProperty("effectiveShowClearIcon",false);}};return F;});
