/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./library','sap/ui/core/EnabledPropagator','./DialogRenderer','sap/ui/core/library','sap/ui/Device','./Bar','./Button','./Title','sap/m/OverflowToolbarLayoutData','sap/ui/base/ManagedObjectObserver',"sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isEmptyObject"],function(D,l,E,a,c,b,B,d,T,O,M,q,L,e){"use strict";var f=l.OverflowToolbarPriority;var g=l.ListType;var P=l.P13nPanelType;var h=l.ListMode;var j=c.MessageType;var k=l.ButtonType;var m=l.BackgroundDesign;var N;var n;var p={apiVersion:2,render:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var s=C.getVisiblePanel();if(i&&s){r.openStart("div",i);r.openEnd();r.renderControl(s);r.close("div");}}};var o=D.extend("sap.m.P13nDialog",{metadata:{deprecated:true,library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},renderer:p});E.apply(o.prototype,[true]);o.prototype.init=function(i){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._bTabBarUsed=true;this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]});};o.prototype.setShowResetEnabled=function(i){return this.setProperty("showResetEnabled",i,true);};o.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new B(this.getId()+"-phoneHeader",{contentLeft:new d(this.getId()+"-backToList",{visible:false,type:k.Back,press:function(){t._backToList();}}),contentMiddle:new T(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};o.prototype._showValidationDialog=function(C,F,v){var w=[];var i=[];this._prepareMessages(F,v,w,i);var t=this;return new Promise(function(r){sap.ui.require(["sap/m/MessageBox"],function(s){var u="";if(i.length){i.forEach(function(x,I,y){u=(y.length>1?"• ":"")+x.messageText+"\n"+u;});s.show(u,{icon:s.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[s.Action.CLOSE],styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(x,I,y){u=(y.length>1?"• ":"")+x.messageText+"\n"+u;});u=u+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");s.show(u,{icon:s.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),s.Action.IGNORE],onClose:function(A){if(A===s.Action.IGNORE){C();}},styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}r();});});};o.prototype._prepareMessages=function(F,v,w,r){if(!F.length&&!v.length){return;}F.forEach(function(s){switch(s){case P.filter:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:L.error("Panel type '"+s+"' is not supported jet.");}});var u=v.filter(function(s,I,t){for(var i=++I;i<t.length;i++){if(s.messageText===t[i].messageText){return false;}}return true;});u.forEach(function(i){if(i.messageType===j.Warning){w.push(i);}else if(i.messageType===j.Error){r.push(i);}});};o.prototype._mapPanelToNavigationItem=function(i){if(!i){return null;}return b.system.phone?new n(i.getId()+"-navItem",{type:g.Navigation,title:i.getTitle()}):new n(i.getId()+"-navItem",{text:i.getTitle()});};o.prototype._switchPanel=function(i){var r=this._getPanelByNavigationItem(i);this.setVerticalScrolling(r.getVerticalScrolling());if(b.system.phone){var s=this._getNavigationControl();if(s){s.setVisible(false);r.beforeNavigationTo();r.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(r.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(t){if(t===r){t.beforeNavigationTo();t.setVisible(true);}else{t.setVisible(false);}},this);}this.invalidate();this.rerender();};o.prototype._backToList=function(){var i=this._getNavigationControl();if(i){i.setVisible(true);var r=this.getVisiblePanel();r.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};o.prototype.getVisiblePanel=function(){var i=null;this.getPanels().some(function(r){if(r.getVisible()){i=r;return true;}});return i;};o.prototype._getVisiblePanelID=function(){var i=this.getVisiblePanel();if(i){return this.getId()+"-panel_"+i.getId();}return null;};o.prototype._getPanelByNavigationItem=function(r){for(var i=0,s=this.getPanels(),t=s.length;i<t;i++){if(this._getNavigationItemByPanel(s[i])===r){return s[i];}}return null;};o.prototype._getNavigationItemByPanel=function(i){return i?i.data("sapMP13nDialogNavigationItem"):null;};o.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var $=q(document.getElementById(i));$.appendTo(q(C));}};o.prototype._updateDialogTitle=function(){var i=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&i){switch(i.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=i.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};o.prototype._registerValidationListener=function(i,C){if(this.getPanels().indexOf(i)&&C&&this._mValidationListener[i.getType()]===undefined){this._mValidationListener[i.getType()]=C;}};o.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!e(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var s in t._mValidationListener){var C=t._mValidationListener[s];C(r[s]||[]);}});}};o.prototype._distributeValidationResult=function(r){var i={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(i[t]===undefined){i[t]=[];}i[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return i;};o.prototype._createOKButton=function(){var t=this;return new d(this.getId()+"-ok",{type:k.Emphasized,text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.setBusy(true);var i=t._getPayloadOfPanels();var F=function(){t.setBusy(false);t.fireOk({payload:i});};var r=[];var C=function(){t.getPanels().forEach(function(s){if(r.indexOf(s.getType())>-1){s.onAfterNavigationFrom();}});F();};t.getPanels().forEach(function(s){if(!s.onBeforeNavigationFrom()){r.push(s.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(i).then(function(v){if(r.length||v.length){t.setBusy(false);t._showValidationDialog(C,r,v);}else{F();}});}else{if(r.length||v.length){t.setBusy(false);t._showValidationDialog(C,r,v);}else{F();}}}});};o.prototype._createCancelButton=function(){var t=this;return new d(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.fireCancel();}});};o.prototype._createResetButton=function(){var t=this;return new d(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new O({priority:f.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){sap.ui.getCore().byId(t.getId()+"-ok").focus();t.setShowResetEnabled(false);var i={};t.getPanels().forEach(function(r){i[r.getType()]=r.getResetPayload();});t.fireReset({payload:i});}});};o.prototype._getPayloadOfPanels=function(){var i={};this.getPanels().forEach(function(r){i[r.getType()]=r.getOkPayload();});return i;};o.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._bTabBarUsed=false;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null;};o.prototype._isInstanceOf=function(i,s){var C=sap.ui.require(s);return i&&typeof C==='function'&&(i instanceof C);};function _(C){if(this._isInstanceOf(C.object,"sap/m/P13nDialog")){var i;switch(C.name){case"panels":var r=C.child?[C.child]:C.children;r.forEach(function(s){switch(C.mutation){case"insert":this._mVisibleNavigationItems[s.sId]=s.getVisible();s.setVisible(false);s.beforeNavigationTo();this._oObserver.observe(s,{properties:["title"]});s.setValidationExecutor(q.proxy(this._callValidationExecutor,this));s.setValidationListener(q.proxy(this._registerValidationListener,this));break;case"remove":delete this._mVisibleNavigationItems[s.sId];this._oObserver.unobserve(s);s.setValidationExecutor();s.setValidationListener();break;default:L.error("Mutation '"+C.mutation+"' is not supported jet.");}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog();}else{this._oNavigationControlsPromise.then(function(){this._updateDialog();}.bind(this));}break;case"showReset":i=this.getButtons();if(i.length>1){i[2].setVisible(C.current);}break;case"showResetEnabled":i=this.getButtons();if(i.length>1){i[2].setEnabled(C.current);i[2].invalidate();}break;default:L.error("The property or aggregation '"+C.name+"' has not been registered.");}}else if(this._isInstanceOf(C.object,"sap/m/P13nPanel")){if(C.name==="title"){var I=this._getNavigationItemByPanel(C.object);if(I){if(b.system.phone){I.setTitle(C.current);}else{I.setText(C.current);}}}}}o.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};o.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var i in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[i]?C+1:C;}return C;};o.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};o.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};o.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};o.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new N(this.getId()+"-navigationItems",{mode:h.None,itemPress:function(i){this._switchPanel(i.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new B(this.getId()+"-navigationBar",{contentLeft:new N(this.getId()+"-navigationItems",{backgroundDesign:m.Transparent,expandable:false,select:function(i){this._switchPanel(i.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};o.prototype._updateDialog=function(){var i=this._getNavigationControl();i.destroyItems();var I=this._determineInitialVisiblePanel();this.getPanels().forEach(function(r){var s=this._mapPanelToNavigationItem(r);r.data("sapMP13nDialogNavigationItem",s);i.addItem(s);var v=b.system.phone?this._mVisibleNavigationItems[r.sId]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[r.sId]&&I===r.sId;r.setVisible(v);if(v){this.setVerticalScrolling(r.getVerticalScrolling());}s.setVisible(this._mVisibleNavigationItems[r.sId]);if(v&&i.setSelectedItem){i.setSelectedItem(s);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};o.prototype._determineInitialVisiblePanel=function(){if(this.getInitialVisiblePanelType()){for(var i=0;i<this.getPanels().length;i++){if(this.getPanels()[i].getType()==this.getInitialVisiblePanelType()){return this.getPanels()[i].sId;}}}var I;this.getPanels().some(function(r){if(this._mVisibleNavigationItems[r.sId]){I=r.sId;return true;}}.bind(this));return I;};o.prototype._requestRequiredNavigationControls=function(){var s=b.system.phone?"sap/m/List":"sap/m/IconTabBar";var i=b.system.phone?"sap/m/StandardListItem":"sap/m/IconTabFilter";N=sap.ui.require(s);n=sap.ui.require(i);if(N&&n){this._bNavigationControlsPromiseResolved=true;return Promise.resolve();}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(r){sap.ui.require([s,i],function(t,u){N=t;n=u;this._bNavigationControlsPromiseResolved=true;return r();}.bind(this));}.bind(this));}return this._oNavigationControlsPromise;};return o;});
