/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/layout/form/SimpleForm","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/m/Avatar","sap/m/Page","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/Link","sap/m/Text","sap/m/Label","sap/m/HBox","sap/ui/core/Icon","sap/ui/core/Title","sap/ui/core/CustomData","sap/ui/core/library","sap/ui/layout/library","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./QuickViewPageRenderer","sap/base/Log","sap/base/security/encodeURL","sap/ui/dom/jquery/Focusable"],function(l,C,a,I,S,V,H,A,P,B,b,T,L,c,d,e,f,g,h,i,m,D,R,Q,n,o){"use strict";var U=l.URLHelper;var p=m.form.SimpleFormLayout;var q=i.TitleLevel;var r=l.QuickViewGroupElementType;var s=l.ButtonType;var t=l.AvatarShape;var u=C.getLibraryResourceBundle('sap.m');var v=a.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:"",deprecated:true},fallbackIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"},avatar:{type:"sap.m.Avatar",multiple:false,bindable:"bindable"}}},renderer:Q});v.prototype.init=function(){var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};v.prototype.exit=function(){if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};v.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};v.prototype.getPageContent=function(){return this._mPageContent;};v.prototype.setNavContext=function(j){this._mNavContext=j;};v.prototype.getNavContext=function(){return this._mNavContext;};v.prototype.setPageTitleControl=function(j){this._oPageTitle=j;};v.prototype.getPageTitleControl=function(){return this._oPageTitle;};v.prototype._createPage=function(){var j=this._createPageContent();var N=this.getNavContext();var k;if(this._oPage){k=this._oPage;k.destroyContent();k.setCustomHeader(new b());}else{k=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new b()});k.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(this.getHeader()===""&&N.quickView.getPages().length===1&&!D.system.phone){k.setShowHeader(false);k.addStyleClass('sapMQuickViewPageWithoutHeader');}if(j.header){k.addContent(j.header);}k.addContent(j.form);var w=k.getCustomHeader();w.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){w.addContentLeft(new B({type:s.Back,tooltip:u.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&D.system.phone){w.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}k.addStyleClass('sapMQuickViewPage');return k;};v.prototype.onAfterRenderingPage=function(){var j=this.getParent(),k=j instanceof a&&j.isA('sap.m.QuickView');if(k&&!this._oPage.$().firstFocusableDomRef()){this._oPage.$('cont').attr('tabindex',0);}if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};v.prototype._createPageContent=function(){var F=this._createForm();var j=this._getPageHeaderContent();var k=this.getPageTitleControl();if(j&&k){F.addAriaLabelledBy(k);}this._mPageContent={form:F,header:j};return this._mPageContent;};v.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:p.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};v.prototype._getPageHeaderContent=function(){var j=this._getAvatar(),k=new V(),w=new H(),x=this.getIcon(),y=this.getTitle(),z=this.getDescription(),E=this.getTitleUrl();if(!j&&!x&&!y&&!z){return null;}if(j){w.addContent(j);}var F;if(E){F=new L({text:y,href:E,target:"_blank"});}else if(this.getCrossAppNavCallback()){F=new L({text:y});F.attachPress(this._crossApplicationNavigation.bind(this));}else{F=new T({text:y,level:q.H3});}this.setPageTitleControl(F);var G=new c({text:z});k.addContent(F);k.addContent(G);w.addContent(k);return w;};v.prototype._renderGroup=function(G,F){var E=G.getAggregation("elements");var j,w,x;if(G.getHeading()){F.addContent(new g({text:G.getHeading(),level:q.H4}));}if(!E){return;}var N=this.getNavContext();for(var k=0;k<E.length;k++){j=E[k];if(!j.getVisible()){continue;}x=new d({text:j.getLabel()});var y;if(N){y=N.quickViewId;}w=j._getGroupElementValue(y);F.addContent(x);if(!w){F.addContent(new c({text:""}));continue;}x.setLabelFor(w.getId());if(j.getType()==r.pageLink){w.attachPress(this._attachPressLink(this));}if(j.getType()==r.mobile&&!D.system.desktop){var z=new f({src:I.getIconURI("post"),tooltip:u.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new h({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var J=new e({items:[w,z]});F.addContent(J);}else{F.addContent(w);}}};v.prototype._crossApplicationNavigation=function(){if(this.getCrossAppNavCallback()&&this.oCrossAppNavigator){var j=this.getCrossAppNavCallback();if(typeof j=="function"){var k=j();var w=this.oCrossAppNavigator.hrefForExternal({target:{semanticObject:k.target.semanticObject,action:k.target.action},params:k.params});U.redirect(w);}}else if(this.getTitleUrl()){U.redirect(this.getTitleUrl(),true);}};v.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};v.prototype._attachPressLink=function(j){var N=j.getNavContext();return function(E){E.preventDefault();var k=this.getCustomData()[0].getValue();if(N.navContainer&&k){N.quickView._setNavOrigin(this);N.navContainer.to(k);}};};v.prototype._mobilePress=function(){var j="sms://"+o(this.getCustomData()[0].getValue());window.location.replace(j);};v.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._adjustContainerHeight();N.quickView._restoreFocus();}};["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){v.prototype[F]=function(){var j=a.prototype[F].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return j;}return this;};});v.prototype.setProperty=function(){a.prototype.setProperty.apply(this,arguments);this._updatePage();return this;};v.prototype.getQuickViewBase=function(){var j=this.getParent();if(j&&j.isA("sap.m.QuickViewBase")){return j;}return null;};v.prototype._getAvatar=function(){var j=null,k=this.getIcon();if(this.getAvatar()){j=this.getAvatar().clone(null,null,{cloneBindings:false,cloneChildren:true});this._checkAvatarProperties(j);}else if(k){j=new A({displayShape:t.Square,fallbackIcon:this.getFallbackIcon(),src:k});}if(j){if(this.getTitleUrl()&&!j.hasListeners("press")){j.attachPress(this._crossApplicationNavigation.bind(this));}j.addStyleClass("sapMQuickViewThumbnail");}return j;};v.prototype._checkAvatarProperties=function(j){var k=j.getMetadata().getPropertyDefaults();if(j.getDisplaySize()!==k["displaySize"]){n.warning("'displaySize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getCustomDisplaySize()!==k["customDisplaySize"]){n.warning("'customDisplaySize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getCustomFontSize()!==k["customFontSize"]){n.warning("'customFontSize' property of avatar shouldn't be used in sap.m.QuickViewPage");}if(j.getDetailBox()){n.warning("'detailBox' aggregation of avatar shouldn't be used in sap.m.QuickViewPage");}};return v;});
