/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'./Button','./Dialog','./List','./SearchField','./library','./SelectDialogBase','sap/ui/core/InvisibleText','sap/ui/Device','sap/m/Toolbar','sap/m/Text','sap/m/BusyIndicator','sap/m/Bar','sap/m/Title',"sap/base/Log"],function(q,B,D,L,S,l,a,I,b,T,c,d,e,f,g){"use strict";var h=l.ListMode;var i=l.ButtonType;var j=l.TitleAlignment;var k=a.extend("sap.m.SelectDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},noDataText:{type:"string",group:"Appearance",defaultValue:null},multiSelect:{type:"boolean",group:"Dimension",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:null},growing:{type:"boolean",group:"Behavior",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:false},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showClearButton:{type:"boolean",group:"Behavior",defaultValue:false},confirmButtonText:{type:"string",group:"Appearance"},draggable:{type:"boolean",group:"Behavior",defaultValue:false},resizable:{type:"boolean",group:"Behavior",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:j.Auto}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",forwarding:{idSuffix:"-list",aggregation:"items",forwardBinding:true}},_dialog:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{confirm:{parameters:{selectedItem:{type:"sap.m.StandardListItem"},selectedItems:{type:"sap.m.StandardListItem[]"},selectedContexts:{type:"object[]"}}},search:{parameters:{value:{type:"string"},itemsBinding:{type:"any"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{value:{type:"string"},itemsBinding:{type:"any"}}},cancel:{}}},renderer:{apiVersion:2,render:function(){}}});k.prototype.init=function(){var t=this,m=0;this._bAppendedToUIArea=false;this._bInitBusy=false;this._bFirstRender=true;this._bAfterCloseAttached=false;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oList=new L(this.getId()+"-list",{growing:t.getGrowing(),growingScrollToLoad:t.getGrowing(),mode:h.SingleSelectMaster,sticky:[l.Sticky.InfoToolbar],infoToolbar:new T({visible:false,active:false,content:[new c({text:this._oRb.getText("TABLESELECTDIALOG_SELECTEDITEMS",[0])})]}),selectionChange:this._selectionChange.bind(this),updateStarted:this._updateStarted.bind(this),updateFinished:this._updateFinished.bind(this)});this._oList.getInfoToolbar().addEventDelegate({onAfterRendering:function(){t._oList.getInfoToolbar().$().attr('aria-live','polite');}});this._list=this._oList;this._oBusyIndicator=new d(this.getId()+"-busyIndicator").addStyleClass("sapMSelectDialogBusyIndicator",true);this._oSearchField=new S(this.getId()+"-searchField",{width:"100%",ariaLabelledBy:I.getStaticId("sap.m","SELECTDIALOG_SEARCH"),liveChange:function(E){var v=E.getSource().getValue(),n=(v?300:0);clearTimeout(m);if(n){m=setTimeout(function(){t._executeSearch(v,false,"liveChange");},n);}else{t._executeSearch(v,false,"liveChange");}},search:function(E){var v=E.getSource().getValue(),n=E.getParameters().clearButtonPressed;t._executeSearch(v,n,"search");}});this._searchField=this._oSearchField;this._oSubHeader=new e(this.getId()+"-subHeader",{contentMiddle:[this._oSearchField]});var C=new e(this.getId()+"-dialog-header",{titleAlignment:this.getTitleAlignment(),contentMiddle:[new f(this.getId()+"-dialog-title",{level:"H2"})]});this._oDialog=new D(this.getId()+"-dialog",{customHeader:C,titleAlignment:this.getTitleAlignment(),stretch:b.system.phone,contentHeight:"2000px",subHeader:this._oSubHeader,content:[this._oBusyIndicator,this._oList],leftButton:this._getCancelButton(),draggable:this.getDraggable()&&b.system.desktop,resizable:this.getResizable()&&b.system.desktop,escapeHandler:function(p){t._onCancel();p.resolve();}}).addStyleClass("sapMSelectDialog");this._dialog=this._oDialog;this.setAggregation("_dialog",this._oDialog);this._sSearchFieldValue="";this._iListUpdateRequested=0;};k.prototype.setGrowing=function(v){this._oList.setGrowing(v);this._oList.setGrowingScrollToLoad(v);this.setProperty("growing",v,true);return this;};k.prototype.setDraggable=function(v){this._setInteractionProperty(v,"draggable",this._oDialog.setDraggable);return this;};k.prototype.setResizable=function(v){this._setInteractionProperty(v,"resizable",this._oDialog.setResizable);return this;};k.prototype._setInteractionProperty=function(v,p,C){this.setProperty(p,v,true);if(!b.system.desktop&&v){g.warning(p+" property works only on desktop devices!");return;}if(b.system.desktop&&this._oDialog){C.call(this._oDialog,v);}};k.prototype.setBusy=function(){this._oDialog.setBusy.apply(this._oDialog,arguments);return this;};k.prototype.getBusy=function(){return this._oDialog.getBusy.apply(this._oDialog,arguments);};k.prototype.setBusyIndicatorDelay=function(v){this._oList.setBusyIndicatorDelay(v);this._oDialog.setBusyIndicatorDelay(v);this.setProperty("busyIndicatorDelay",v,true);return this;};k.prototype.exit=function(){this._oList=null;this._oSearchField=null;this._oSubHeader=null;this._oClearButton=null;this._oBusyIndicator=null;this._sSearchFieldValue=null;this._iListUpdateRequested=0;this._bInitBusy=false;this._bFirstRender=false;if(this._bAppendedToUIArea){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(this,true);}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}if(this._oOkButton){this._oOkButton.destroy();this._oOkButton=null;}this._oSelectedItem=null;this._aSelectedItems=null;this._list=null;this._searchField=null;this._dialog=null;};k.prototype.onAfterRendering=function(){if(this._bInitBusy&&this._bFirstRender){this._setBusy(true);this._bInitBusy=false;}return this;};k.prototype.invalidate=function(){if(this._oDialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._oDialog.invalidate(arguments);}else{a.prototype.invalidate.apply(this,arguments);}return this;};k.prototype.open=function(s){if((!this.getParent()||!this.getUIArea())&&!this._bAppendedToUIArea){var o=sap.ui.getCore().getStaticAreaRef();o=sap.ui.getCore().getUIArea(o);o.addContent(this,true);this._bAppendedToUIArea=true;}this._oSearchField.setValue(s);this._sSearchFieldValue=s||"";this._setInitialFocus();this._oDialog.open();if(this._bInitBusy){this._setBusy(true);}this._updateSelectionIndicator();this._aInitiallySelectedContextPaths=this._oList.getSelectedContextPaths();return this;};k.prototype.setGrowingThreshold=function(v){this._oList.setGrowingThreshold(v);this.setProperty("growingThreshold",v,true);return this;};k.prototype.setMultiSelect=function(m){this.setProperty("multiSelect",m,true);if(m){this._oList.setMode(h.MultiSelect);this._oList.setIncludeItemInSelection(true);this._oDialog.setEndButton(this._getCancelButton());this._oDialog.setBeginButton(this._getOkButton());}else{this._oList.setMode(h.SingleSelectMaster);this._oDialog.setEndButton(this._getCancelButton());this._oDialog.destroyBeginButton();delete this._oOkButton;}return this;};k.prototype.setTitle=function(t){this.setProperty("title",t,true);this._oDialog.getCustomHeader().getAggregation("contentMiddle")[0].setText(t);return this;};k.prototype.setTitleAlignment=function(A){this.setProperty("titleAlignment",A,true);if(this._oDialog){this._oDialog.setTitleAlignment(A);}return this;};k.prototype.setConfirmButtonText=function(t){this.setProperty("confirmButtonText",t,true);this._oOkButton&&this._oOkButton.setText(t||this._oRb.getText("SELECT_CONFIRM_BUTTON"));return this;};k.prototype.setNoDataText=function(n){this._oList.setNoDataText(n);return this;};k.prototype.getNoDataText=function(){return this._oList.getNoDataText();};k.prototype.getContentWidth=function(){return this._oDialog.getContentWidth();};k.prototype.setContentWidth=function(w){this._oDialog.setContentWidth(w);return this;};k.prototype.getContentHeight=function(){return this._oDialog.getContentHeight();};k.prototype.setShowClearButton=function(v){this.setProperty("showClearButton",v,true);if(v){var C=this._oDialog.getCustomHeader();C.addContentRight(this._getClearButton());}if(this._oClearButton){this._oClearButton.setVisible(v);}return this;};k.prototype.setContentHeight=function(H){this._oDialog.setContentHeight(H);return this;};k.prototype.addStyleClass=function(){this._oDialog.addStyleClass.apply(this._oDialog,arguments);return this;};k.prototype.removeStyleClass=function(){this._oDialog.removeStyleClass.apply(this._oDialog,arguments);return this;};k.prototype.toggleStyleClass=function(){this._oDialog.toggleStyleClass.apply(this._oDialog,arguments);return this;};k.prototype.hasStyleClass=function(){return this._oDialog.hasStyleClass.apply(this._oDialog,arguments);};k.prototype.getDomRef=function(){if(this._oDialog){return this._oDialog.getDomRef.apply(this._oDialog,arguments);}else{return null;}};k.prototype.clearSelection=function(){this._removeSelection();this._updateSelectionIndicator();this._oDialog.focus();return this;};k.prototype.setModel=function(m,M){this._setBusy(false);this._bInitBusy=false;this._iListUpdateRequested+=1;this._oList.setModel(m,M);a.prototype.setModel.apply(this,arguments);this._updateSelectionIndicator();return this;};k.prototype.setBindingContext=function(C,m){this._oList.setBindingContext(C,m);a.prototype.setBindingContext.apply(this,arguments);return this;};k.prototype._executeSearch=function(v,C,E){var o=this._oList,m=(o?o.getBinding("items"):undefined),s=(this._sSearchFieldValue!==v);if(this._oDialog.isOpen()&&((s&&E==="liveChange")||E==="search")){this._sSearchFieldValue=v;if(m){this._iListUpdateRequested+=1;if(E==="search"){this.fireSearch({value:v,itemsBinding:m,clearButtonPressed:C});}else if(E==="liveChange"){this.fireLiveChange({value:v,itemsBinding:m});}}else{if(E==="search"){this.fireSearch({value:v,clearButtonPressed:C});}else if(E==="liveChange"){this.fireLiveChange({value:v});}}}return this;};k.prototype._setBusy=function(m){if(this._iListUpdateRequested){if(m){this._oList.addStyleClass('sapMSelectDialogListHide');this._oBusyIndicator.$().css('display','inline-block');}else{this._oList.removeStyleClass('sapMSelectDialogListHide');this._oBusyIndicator.$().css('display','none');}}};k.prototype._updateStarted=function(E){this.fireUpdateStarted(E.getParameters());if(this.getModel()&&this.getModel()instanceof sap.ui.model.odata.ODataModel){if(this._oDialog.isOpen()&&this._iListUpdateRequested){this._setBusy(true);}else{this._bInitBusy=true;}}};k.prototype._updateFinished=function(E){this.fireUpdateFinished(E.getParameters());this._updateSelectionIndicator();if(this.getModel()&&this.getModel()instanceof sap.ui.model.odata.ODataModel){this._setBusy(false);this._bInitBusy=false;}this._iListUpdateRequested=0;this._oList.getItems().forEach(function(o){o.addEventDelegate(this._getListItemsEventDelegates());},this);};k.prototype._getOkButton=function(){var t=this,o=null;o=function(){t._sSearchFieldValue=null;var m=t._oList.getBinding("items");if(m&&m.aFilters&&m.aFilters.length){t._oList.setGrowing(false);m.filter([]);t._oList.setGrowing(t.getGrowing());}t._oSelectedItem=t._oList.getSelectedItem();t._aSelectedItems=t._oList.getSelectedItems();t._oDialog.detachAfterClose(o);t._fireConfirmAndUpdateSelection();};if(!this._oOkButton){this._oOkButton=new B(this.getId()+"-ok",{type:i.Emphasized,text:this.getConfirmButtonText()||this._oRb.getText("SELECT_CONFIRM_BUTTON"),press:function(){t._oDialog.attachAfterClose(o);t._oDialog.close();}});}return this._oOkButton;};k.prototype._getCancelButton=function(){var t=this;if(!this._oCancelButton){this._oCancelButton=new B(this.getId()+"-cancel",{text:this._oRb.getText("MSGBOX_CANCEL"),press:function(E){t._onCancel();}});}return this._oCancelButton;};k.prototype._getClearButton=function(){if(!this._oClearButton){this._oClearButton=new B(this.getId()+"-clear",{text:this._oRb.getText("SELECTDIALOG_CLEARBUTTON"),press:this.clearSelection.bind(this)});}return this._oClearButton;};k.prototype._onCancel=function(E){var t=this,A=null;A=function(){t._oSelectedItem=null;t._aSelectedItems=[];t._sSearchFieldValue=null;t._oDialog.detachAfterClose(A);t._resetSelection();t.fireCancel();};this._oDialog.attachAfterClose(A);this._oDialog.close();};k.prototype._updateSelectionIndicator=function(){var s=this._oList.getSelectedContextPaths(true).length,o=this._oList.getInfoToolbar(),v=!!s&&this.getMultiSelect();if(this.getShowClearButton()&&this._oClearButton){this._oClearButton.setEnabled(s>0);}if(o.getVisible()!==v){o.setVisible(v);if(v){this._oDialog.addAriaLabelledBy(o);o.rerender();}else{this._oDialog.removeAriaLabelledBy(o);}}o.getContent()[0].setText(this._oRb.getText("TABLESELECTDIALOG_SELECTEDITEMS",[s]));};k.prototype._fireConfirmAndUpdateSelection=function(){var p={selectedItem:this._oSelectedItem,selectedItems:this._aSelectedItems};Object.defineProperty(p,"selectedContexts",{get:this._oList.getSelectedContexts.bind(this._oList,true)});this.fireConfirm(p);this._updateSelection();};k.prototype._selectionChange=function(E){if(E.getParameters){this.fireSelectionChange(E.getParameters());}if(!this._oDialog){return;}if(this.getMultiSelect()){this._updateSelectionIndicator();return;}if(!this._bAfterCloseAttached){this._oDialog.attachEventOnce("afterClose",this._resetAfterClose,this);this._bAfterCloseAttached=true;}this._oDialog.close();};k.prototype._resetAfterClose=function(){this._oSelectedItem=this._oList.getSelectedItem();this._aSelectedItems=this._oList.getSelectedItems();this._bAfterCloseAttached=false;this._fireConfirmAndUpdateSelection();};k.prototype._updateSelection=function(){if(!this.getRememberSelections()&&!this.bIsDestroyed){this._removeSelection();}};k.prototype._removeSelection=function(){this._oList.removeSelections(true);delete this._oSelectedItem;delete this._aSelectedItems;};k.prototype._resetSelection=function(){if(!this.bIsDestroyed){this._oList.removeSelections(true);this._oList.setSelectedContextPaths(this._aInitiallySelectedContextPaths);this._oList.getItems().forEach(function(o){var p=o.getBindingContextPath();if(p&&this._aInitiallySelectedContextPaths.indexOf(p)>-1){o.setSelected(true);}},this);}};k.prototype._getListItemsEventDelegates=function(){var E=function(o){var m=q(o.target).closest(".sapMLIB").control()[0];if(m._eventHandledByControl){return;}if(o&&o.isDefaultPrevented&&o.isMarked&&(o.isDefaultPrevented()||o.isMarked("preventSelectionChange"))){return;}if(o&&o.srcControl.isA("sap.m.GroupHeaderListItem")){return;}this._selectionChange(o);}.bind(this);return{ontap:E,onsapselect:E};};return k;});
