/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/library','sap/m/ShellRenderer',"sap/ui/util/Mobile","sap/base/Log","sap/ui/core/theming/Parameters"],function(l,C,a,c,S,M,L,T){"use strict";var b=c.TitleLevel;var d=a.extend("sap.m.Shell",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},logo:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showLogout:{type:"boolean",group:"Behavior",defaultValue:true},headerRightText:{type:"string",group:"Data",defaultValue:null},appWidthLimited:{type:"boolean",group:"Appearance",defaultValue:true},backgroundColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},homeIcon:{type:"object",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:b.H1}},defaultAggregation:"app",aggregations:{app:{type:"sap.ui.core.Control",multiple:false}},events:{logout:{}}}});d.prototype.init=function(){C.attachThemeChanged(function(){var $=this.$("hdr"),i=this._getImageSrc();if($.length&&i){this._getImage().setSrc(i);this._getImage().rerender();}},this);M.init({statusBar:"default",hideBrowser:true});};d.prototype.onBeforeRendering=function(){var i=this._getImageSrc();if(i){this._getImage().setSrc(i);}};d.prototype.onAfterRendering=function(){var r=this.getDomRef().parentNode;if(r&&!r._sapui5_heightFixed){r._sapui5_heightFixed=true;while(r&&r!==document.documentElement){if(r.getAttribute("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}}this.$("content").css("height","");};d.prototype.exit=function(){if(this.oImg){this.oImg.destroy();}};d.prototype.ontap=function(e){if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapMShellHeaderLogout")>-1){this.fireLogout();}};d.prototype.setTitle=function(t){this.$("hdrTxt").text(t);this.setProperty("title",t,true);return this;};d.prototype.setHeaderRightText=function(t){this.setProperty("headerRightText",t,true);if(!t){t="";}this.$("hdrRightTxt").text(t).css("display",(t?"inline":"none"));return this;};d.prototype.setAppWidthLimited=function(e){this.$().toggleClass("sapMShellAppWidthLimited",e);this.setProperty("appWidthLimited",e,true);return this;};d.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){L.warning("Invalid value "+o+" for Shell.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};d.prototype.setHomeIcon=function(i){this.setProperty("homeIcon",i,true);M.setIcons(i);return this;};d.prototype._getImage=function(){if(!this.oImg){this.oImg=new sap.m.Image(this.getId()+"-logo",{decorative:false,alt:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SHELL_ARIA_LOGO")});this.oImg.addStyleClass("sapMShellLogoImg");}return this.oImg;};d.prototype._getImageSrc=function(){return this.getLogo()?this.getLogo():T._getThemeImage();};return d;});
