/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./PlanningCalendarHeader','./SegmentedButtonItem',"./SinglePlanningCalendarWeekView",'./SinglePlanningCalendarGrid','./SinglePlanningCalendarMonthGrid','./SinglePlanningCalendarRenderer','sap/base/Log','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/format/DateFormat','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/library','sap/ui/base/ManagedObjectObserver',"sap/ui/thirdparty/jquery"],function(l,P,S,a,b,c,d,L,C,I,R,D,e,f,g,h,u,M,q){"use strict";var j=l.PlanningCalendarStickyMode;var H="_sHeaderResizeHandlerId";var k=4;var m="--item";var n=C.extend("sap.m.SinglePlanningCalendar",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:""},startDate:{type:"object",group:"Data"},startHour:{type:"int",group:"Data",defaultValue:0},endHour:{type:"int",group:"Data",defaultValue:24},fullDay:{type:"boolean",group:"Data",defaultValue:true},stickyMode:{type:"sap.m.PlanningCalendarStickyMode",group:"Behavior",defaultValue:j.None},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsResize:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsCreate:{type:"boolean",group:"Misc",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1}},aggregations:{actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action",forwarding:{getter:"_getHeader",aggregation:"actions"}},appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",forwarding:{getter:"_getCurrentGrid",aggregation:"appointments"}},views:{type:"sap.m.SinglePlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate",forwarding:{getter:"_getCurrentGrid",aggregation:"specialDates"}},_header:{type:"sap.m.PlanningCalendarHeader",multiple:false,visibility:"hidden"},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_mvgrid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{selectedView:{type:"sap.m.SinglePlanningCalendarView",multiple:false},legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}},appointmentResize:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"}}},appointmentCreate:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},headerDateSelect:{parameters:{date:{type:"object"}}},startDateChange:{parameters:{date:{type:"object"}}},cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},moreLinkPress:{parameters:{date:{type:"object"}}},viewChange:{}}}});n.prototype.init=function(){var o=this.getId();this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oDefaultView=new a({key:"DEFAULT_INNER_WEEK_VIEW_CREATED_FROM_CONTROL",title:""});this.setAssociation("selectedView",this._oDefaultView);this.setAggregation("_header",this._createHeader());this.setAggregation("_grid",new b(o+"-Grid"));this.setAggregation("_mvgrid",new c(o+"-GridMV"));this._attachHeaderEvents();this._attachGridEvents();this._attachDelegates();this.setStartDate(new Date());};n.prototype.onBeforeRendering=function(){this._toggleStickyClasses();};n.prototype.onAfterRendering=function(){var o=this._getHeader();this._adjustColumnHeadersTopOffset();this.toggleStyleClass("sapMSinglePCActionsHidden",!o._getActionsToolbar().getVisible());this._registerResizeHandler(H,o,this._onHeaderResize.bind(this));};n.prototype.exit=function(){if(this._oDefaultView){this._oDefaultView.destroy();this._oDefaultView=null;}if(this._afterRenderFocusCell){this.removeDelegate(this._afterRenderFocusCell);this._afterRenderFocusCell=null;}this._deRegisterResizeHandler(H);};n.prototype._onHeaderResize=function(E){if(E.oldSize.height===E.size.height){return this;}this.toggleStyleClass("sapMSinglePCActionsHidden",!this._getHeader()._getActionsToolbar().getVisible());this._adjustColumnHeadersTopOffset();return this;};n.prototype.setTitle=function(t){this._getHeader().setTitle(t);return this.setProperty("title",t);};n.prototype.setStartDate=function(o){this.setProperty("startDate",o);this._alignColumns();return this;};n.prototype.setStartHour=function(i){this.getAggregation("_grid").setStartHour(i);this.setProperty("startHour",i);return this;};n.prototype.setEndHour=function(i){this.getAggregation("_grid").setEndHour(i);this.setProperty("endHour",i);return this;};n.prototype.setFullDay=function(F){this.getAggregation("_grid").setFullDay(F);this.setProperty("fullDay",F);return this;};n.prototype.setEnableAppointmentsDragAndDrop=function(E){this.getAggregation("_grid").setEnableAppointmentsDragAndDrop(E);this.getAggregation("_mvgrid").setEnableAppointmentsDragAndDrop(E);return this.setProperty("enableAppointmentsDragAndDrop",E,true);};n.prototype.setEnableAppointmentsResize=function(E){this.getAggregation("_grid").setEnableAppointmentsResize(E);return this.setProperty("enableAppointmentsResize",E,true);};n.prototype.setEnableAppointmentsCreate=function(E){this.getAggregation("_grid").setEnableAppointmentsCreate(E);return this.setProperty("enableAppointmentsCreate",E,true);};n.prototype._toggleStickyClasses=function(){var s=this.getStickyMode();this.toggleStyleClass("sapMSinglePCStickyAll",s===j.All);this.toggleStyleClass("sapMSinglePCStickyNavBarAndColHeaders",s===j.NavBarAndColHeaders);return this;};n.prototype._adjustColumnHeadersTopOffset=function(){var s=this.getStickyMode(),G=this.getAggregation("_grid"),o=G&&G._getColumnHeaders(),t;if(!o||!o.getDomRef()){return this;}switch(s){case j.All:t=this._getHeader().$().outerHeight();break;case j.NavBarAndColHeaders:t=this._getHeader()._getNavigationToolbar().$().outerHeight();break;default:t="auto";break;}o.$().css("top",t);o._setTopPosition(t);return this;};n.prototype.addView=function(v){var V,o=this._getHeader(),s=v.getId()+m,i;if(!v){return this;}if(this._isViewKeyExisting(v.getKey())){L.error("There is an existing view with the same key.",this);return this;}this.addAggregation("views",v);V=o._getOrCreateViewSwitch();i=new S(s,{key:v.getKey(),text:v.getTitle()});V.addItem(i);this._observeViewTitle(v);if(this._getSelectedView().getKey()===this._oDefaultView.getKey()){this.setAssociation("selectedView",v);}this._alignView();if(this.getViews().length>k){o._convertViewSwitchToSelect();}return this;};n.prototype.insertView=function(v,p){var V,o=this._getHeader(),s=v.getId()+m,i;if(!v){return this;}if(this._isViewKeyExisting(v.getKey())){L.error("There is an existing view with the same key.",this);return this;}this.insertAggregation("views",v,p);V=o._getOrCreateViewSwitch();i=new S(s,{key:v.getKey(),text:v.getTitle()});V.insertItem(i,p);this._observeViewTitle(v);if(this._getSelectedView().getKey()===this._oDefaultView.getKey()){this.setAssociation("selectedView",v);}this._alignView();if(this.getViews().length>k){o._convertViewSwitchToSelect();}return this;};n.prototype.removeView=function(v){if(!v){return this;}var o=this._getHeader(),V=o._getOrCreateViewSwitch(),p=V.getItems(),r=this._getSelectedView(),s=v.getKey(),t,i;if(this.getViews().length===1){this._disconnectAndDestroyViewsObserver();}else{this._oViewsObserver.unobserve(v,{properties:["title"]});}for(i=0;i<p.length;i++){t=p[i];if(t.getKey()===s){V.removeItem(t);break;}}this.removeAggregation("views",v);if(s===r.getKey()){this.setAssociation("selectedView",this.getViews()[0]||this._oDefaultView);}this._alignView();if(this.getViews().length<=k){o._convertViewSwitchToSegmentedButton();}return this;};n.prototype.removeAllViews=function(){var v=this._getHeader()._getOrCreateViewSwitch();this._disconnectAndDestroyViewsObserver();v.removeAllItems();this.setAssociation("selectedView",this._oDefaultView);this._alignView();return this.removeAllAggregation("views");};n.prototype.destroyViews=function(){var v=this._getHeader()._getOrCreateViewSwitch();this._disconnectAndDestroyViewsObserver();v.destroyItems();this.setAssociation("selectedView",this._oDefaultView);this._alignView();return this.destroyAggregation("views");};n.prototype._viewsObserverCallbackFunction=function(o){sap.ui.getCore().byId(o.object.getId()+m).setText(o.current);};n.prototype._getViewsObserver=function(){if(!this._oViewsObserver){this._oViewsObserver=new M(this._viewsObserverCallbackFunction);}return this._oViewsObserver;};n.prototype._observeViewTitle=function(v){this._getViewsObserver().observe(v,{properties:["title"]});};n.prototype._disconnectAndDestroyViewsObserver=function(){if(this._oViewsObserver){this._oViewsObserver.disconnect();this._oViewsObserver.destroy();this._oViewsObserver=null;}};n.prototype.setSelectedView=function(v){if(typeof v==="string"){v=this._getViewById(v);}else if(v.isA("sap.m.SinglePlanningCalendarView")&&!this._isViewKeyExisting(v.getKey())){v=null;}if(!v){L.error("There is no such view.",this);return this;}this._setupNewView(v);this._getHeader()._getOrCreateViewSwitch().setSelectedKey(v.getKey());return this;};n.prototype.getSelectedAppointments=function(){return this.getAggregation("_grid").getSelectedAppointments();};n.prototype.setLegend=function(v){var o,s,i;this.setAssociation("legend",v);this.getAggregation("_grid").setAssociation("legend",v);this.getAggregation("_mvgrid").setAssociation("legend",v);s=this.getLegend();if(s){this.getAggregation("_grid")._sLegendId=s;this.getAggregation("_mvgrid")._sLegendId=s;i=sap.ui.getCore().byId(s);}if(i){o=new M(function(p){this.invalidate();}.bind(this));o.observe(i,{destroy:true});}return this;};n.prototype.setFirstDayOfWeek=function(F){if(F<-1||F>6){L.error(""+F+" is not a valid value to the property firstDayOfWeek. Valid values are from -1 to 6.");return;}this.setProperty("firstDayOfWeek",F);this.getViews().forEach(function(v){v.setFirstDayOfWeek(F);});var o=this._getHeader(),p=o.getAggregation("_calendarPicker")?o.getAggregation("_calendarPicker"):o._oPopup.getContent()[0],s=this._getSelectedView(),i=this.getStartDate()||new Date(),r=s.calculateStartDate(new Date(i.getTime())),t=this.getAggregation("_mvgrid");this.setStartDate(r);t.setFirstDayOfWeek(F);p.setFirstDayOfWeek(F);return this;};n.prototype._alignView=function(){this._switchViewButtonVisibility();this._alignColumns();return this;};n.prototype._createHeader=function(){var o=new P(this.getId()+"-Header");o.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","SPC_ACTIONS_TOOLBAR"));o.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","SPC_NAVIGATION_TOOLBAR"));return o;};n.prototype._isViewKeyExisting=function(K){return this.getViews().some(function(v){return v.getKey()===K;});};n.prototype.getViewByKey=function(K){var v=this.getViews(),i;for(i=0;i<v.length;i++){if(v[i].getKey()===K){return v[i];}}return null;};n.prototype._getViewById=function(s){var v=this.getViews(),i;for(i=0;i<v.length;i++){if(v[i].getId()===s){return v[i];}}return null;};n.prototype._getSelectedView=function(){var s,v=this.getViews(),o=sap.ui.getCore().byId(this.getAssociation("selectedView")).getKey();for(var i=0;i<v.length;i++){if(o===v[i].getKey()){s=v[i];break;}}return s||this._oDefaultView;};n.prototype._switchViewButtonVisibility=function(){var s=this._getHeader()._getOrCreateViewSwitch(),v=s.getItems().length>1;s.setProperty("visible",v);return this;};n.prototype._attachHeaderEvents=function(){var o=this._getHeader();o.attachEvent("viewChange",this._handleViewChange,this);o.attachEvent("pressPrevious",this._handlePressArrow,this);o.attachEvent("pressToday",this._handlePressToday,this);o.attachEvent("pressNext",this._handlePressArrow,this);o.attachEvent("dateSelect",this._handleCalendarPickerDateSelect,this);return this;};n.prototype._attachDelegates=function(){this._afterRenderFocusCell={onAfterRendering:function(){if(this._sGridCellFocusSelector){q(this._sGridCellFocusSelector).trigger("focus");this._sGridCellFocusSelector=null;}}.bind(this)};this.getAggregation("_grid").addDelegate(this._afterRenderFocusCell);this.getAggregation("_mvgrid").addDelegate(this._afterRenderFocusCell);};n.prototype._attachGridEvents=function(){var G=this.getAggregation("_grid"),o=this.getAggregation("_mvgrid");var i=function(E){this.fireHeaderDateSelect({date:E.getSource()._oDate.toLocalJSDate()});};var p=function(E){this.fireAppointmentSelect({appointment:E.getParameter("appointment"),appointments:E.getParameter("appointments")});};var r=function(E){this.fireAppointmentDrop({appointment:E.getParameter("appointment"),startDate:E.getParameter("startDate"),endDate:E.getParameter("endDate"),copy:E.getParameter("copy")});};var s=function(E){this.fireAppointmentResize({appointment:E.getParameter("appointment"),startDate:E.getParameter("startDate"),endDate:E.getParameter("endDate")});};var t=function(E){this.fireAppointmentCreate({startDate:E.getParameter("startDate"),endDate:E.getParameter("endDate")});};var v=function(E){this.fireEvent("cellPress",{startDate:E.getParameter("startDate"),endDate:E.getParameter("endDate")});};var w=function(E){this.fireEvent("moreLinkPress",{date:E.getParameter("date")});};var x=function(E){var G=this.getAggregation("_grid"),F=G._getDateFormatter(),N=this._getSelectedView().getScrollEntityCount()-G._getColumns()+1,z=new Date(E.getParameter("startDate")),A=E.getParameter("fullDay"),B=this.getStartDate();if(E.getParameter("next")){z.setDate(z.getDate()+N);B=new Date(B.setDate(B.getDate()+this._getSelectedView().getScrollEntityCount()));this.setStartDate(B);}else{z.setDate(z.getDate()-N);B=new Date(B.setDate(B.getDate()-this._getSelectedView().getScrollEntityCount()));this.setStartDate(B);}this._sGridCellFocusSelector=A?"[data-sap-start-date='"+F.format(z)+"'].sapMSinglePCBlockersColumn":"[data-sap-start-date='"+F.format(z)+"'].sapMSinglePCRow";};var y=function(E){var z=new Date(E.getParameter("startDate")),A=e.fromLocalJSDate(z),N;A.setDate(A.getDate()+E.getParameter("offset"));N=A.toLocalJSDate();this.setStartDate(N);this._sGridCellFocusSelector="[sap-ui-date='"+A.valueOf()+"'].sapMSPCMonthDay";};G._getColumnHeaders().attachEvent("select",i,this);G.attachEvent("appointmentSelect",p,this);o.attachEvent("appointmentSelect",p,this);G.attachEvent("appointmentDrop",r,this);o.attachEvent("appointmentDrop",r,this);G.attachEvent("appointmentResize",s,this);G.attachEvent("appointmentCreate",t,this);G.attachEvent("cellPress",v,this);o.attachEvent("cellPress",v,this);o.attachEvent("moreLinkPress",w,this);G.attachEvent("borderReached",x,this);o.attachEvent("borderReached",y,this);return this;};n.prototype._handleViewChange=function(E){var N=E.getParameter("item").getProperty("key"),o=this.getViewByKey(N);this._setupNewView(o);this.fireViewChange();};n.prototype._handlePressArrow=function(E){this._applyArrowsLogic(E.getId()==="pressPrevious");this._adjustColumnHeadersTopOffset();};n.prototype._handlePressToday=function(){var s=this._getSelectedView().calculateStartDate(new Date());this.setStartDate(s);this.fireStartDateChange({date:s});this._adjustColumnHeadersTopOffset();};n.prototype._setupNewView=function(v){var p=this._getCurrentGrid();this.setAssociation("selectedView",v);this._transferAggregations(p);this._alignColumns();this._adjustColumnHeadersTopOffset();};n.prototype._transferAggregations=function(p){var N=this._getCurrentGrid(),A,s,i;if(p.getId()!==N.getId()){A=p.removeAllAggregation("appointments",true);for(i=0;i<A.length;i++){N.addAggregation("appointments",A[i],true);}s=p.removeAllAggregation("specialDates",true);for(i=0;i<s.length;i++){N.addAggregation("specialDates",s[i],true);}}};n.prototype._handleCalendarPickerDateSelect=function(){var s=this._getHeader().getStartDate(),o;o=this._getSelectedView().calculateStartDate(new Date(s.getTime()));this.setStartDate(o);if(!this._getSelectedView().isA("sap.m.SinglePlanningCalendarMonthView")){this.getAggregation("_grid")._getColumnHeaders().setDate(s);}this.fireStartDateChange({date:o});this._adjustColumnHeadersTopOffset();};n.prototype._updateCalendarPickerSelection=function(){var r=this._getFirstAndLastRangeDate(),o=this._getHeader(),i=o.getAggregation("_calendarPicker")?o.getAggregation("_calendarPicker"):o._oPopup.getContent()[0],s;s=new g({startDate:r.oStartDate.toLocalJSDate(),endDate:r.oEndDate.toLocalJSDate()});i.removeAllSelectedDates();i.addSelectedDate(s);};n.prototype._formatPickerText=function(){var r=this._getFirstAndLastRangeDate(),s=r.oStartDate.toLocalJSDate(),E=r.oEndDate.toLocalJSDate(),F,o;if(this._getSelectedView().isA("sap.m.SinglePlanningCalendarMonthView")){F=D.getDateInstance({format:"yMMMM"});o=F.format(s);}else{F=D.getDateInstance({format:"yMMMMd"});o=F.format(s);if(s.getTime()!==E.getTime()){o+=" - "+F.format(E);}}return o;};n.prototype._applyArrowsLogic=function(B){var o=e.fromLocalJSDate(this.getStartDate()||new Date()),O=B?-1:1,N=this._getSelectedView().getScrollEntityCount(this.getStartDate(),O),s;if(B){N*=-1;}o.setDate(o.getDate()+N);s=o.toLocalJSDate();this.setStartDate(s);this.fireStartDateChange({date:s});};n.prototype._getFirstAndLastRangeDate=function(){var s=this._getSelectedView(),o=this._getHeader().getStartDate()||new Date(),i=s.getEntityCount()-1,p,r;p=e.fromLocalJSDate(s.calculateStartDate(new Date(o.getTime())));r=new e(p);r.setDate(p.getDate()+i);return{oStartDate:p,oEndDate:r};};n.prototype._alignColumns=function(){var o=this._getHeader(),G=this.getAggregation("_grid"),i=this.getAggregation("_mvgrid"),v=this._getSelectedView(),p=this.getStartDate()||new Date(),V=v.calculateStartDate(new Date(p.getTime())),r=e.fromLocalJSDate(V);o.setStartDate(V);o.setPickerText(this._formatPickerText(r));this._updateCalendarPickerSelection();G.setStartDate(V);i.setStartDate(V);G._setColumns(v.getEntityCount());this._setColumnHeaderVisibility();};n.prototype._setColumnHeaderVisibility=function(){var v;if(this._getSelectedView().isA("sap.m.SinglePlanningCalendarMonthView")){return;}v=!this._getSelectedView().isA("sap.m.SinglePlanningCalendarDayView");this.getAggregation("_grid")._getColumnHeaders().setVisible(v);this.toggleStyleClass("sapMSinglePCHiddenColHeaders",!v);};n.prototype._getHeader=function(){return this.getAggregation("_header");};n.prototype._getCurrentGrid=function(){if(this._getSelectedView().isA("sap.m.SinglePlanningCalendarMonthView")){return this.getAggregation("_mvgrid");}else{return this.getAggregation("_grid");}};n.prototype._registerResizeHandler=function(s,o,i){if(!this[s]){this[s]=R.register(o,i);}return this;};n.prototype._deRegisterResizeHandler=function(s){if(this[s]){R.deregister(this[s]);this[s]=null;}return this;};n.prototype._getSpecialDates=function(){var s=this.getSpecialDates();for(var i=0;i<s.length;i++){var N=s[i].getSecondaryType()===u.CalendarDayType.NonWorking&&s[i].getType()!==u.CalendarDayType.NonWorking;if(N){var o=new h();o.setType(u.CalendarDayType.NonWorking);o.setStartDate(s[i].getStartDate());if(s[i].getEndDate()){o.setEndDate(s[i].getEndDate());}s.push(o);}}return s;};return n;});
