/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/m/GenericTile','sap/ui/Device','sap/ui/core/Icon','./SlideTileRenderer',"sap/ui/events/KeyCodes","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery"],function(l,C,G,D,I,S,K,P,q){"use strict";var a=l.GenericTileScope;var T=l.TileSizeBehavior;var b=C.extend("sap.m.SlideTile",{metadata:{library:"sap.m",properties:{displayTime:{type:"int",group:"Appearance",defaultValue:5000},transitionTime:{type:"int",group:"Appearance",defaultValue:500},scope:{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:"Display"},sizeBehavior:{type:"sap.m.TileSizeBehavior",defaultValue:T.Responsive},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"tiles",aggregations:{tiles:{type:"sap.m.GenericTile",multiple:true,singularName:"tile",bindable:"bindable"},_pausePlayIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{parameters:{scope:{type:"sap.m.GenericTileScope"},action:{type:"string"},domRef:{type:"any"}}}}}});b.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setAggregation("_pausePlayIcon",new I({id:this.getId()+"-pause-play-icon",src:"sap-icon://media-pause",color:"#ffffff",size:"1rem",noTabStop:true}),true);};b.prototype.onBeforeRendering=function(){G.prototype._initScopeContent.call(this,"sapMST");var A=this.getScope()===a.Actions;for(var i=0;i<this.getTiles().length;i++){this.getTiles()[i].showActionsView(A);}if(this._iCurrentTile>=0){this._iLastTile=this._iCurrentTile;}this._bNeedInvalidate=false;this._stopAnimation();this._sWidth=this._sHeight=undefined;this._iCurrentTile=this._iPreviousTile=undefined;};b.prototype.onAfterRendering=function(){this._setupResizeClassHandler();var c=this.getTiles().length,s=this.getScope();this._removeGTFocus();this._iCurrAnimationTime=0;this._bAnimationPause=false;if(this._iLastTile>=0&&c>1){this._scrollToTile(this._iLastTile);}else{this._scrollToNextTile();}if(c>1&&s===a.Display){this._startAnimation();}if(s===a.Actions&&this._iCurrentTile>=0&&this._hasNewsContent(this._iCurrentTile)){this.addStyleClass("sapMSTDarkBackground");}var o;for(var i=0;i<this.getTiles().length;i++){var d=this.getTiles()[this._iCurrentTile];if(d&&d._isNavigateActionEnabled()){d._oNavigateAction._bExcludeFromTabChain=false;d._oNavigateAction.invalidate();}o=document.querySelector('span[id$="tileIndicator-'+i+'"]');if(o){o.addEventListener("click",function(e){var f=e.currentTarget.id,g=parseInt(f.substring(f.lastIndexOf("-")+1)),h=this._iCurrentTile>g;if(this._iCurrentTile!==g){this._scrollToNextTile(this._bAnimationPause,h,g);}}.bind(this));}}};b.prototype.exit=function(){this._stopAnimation();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};b.prototype.ontap=function(e){var s=this.getScope();this.$().trigger("focus");if(s===a.Actions){var p=this._getEventParams(e);this.firePress(p);e.preventDefault();}};b.prototype.ontouchstart=function(e){if(this.getScope()===a.Display){if(q(e.target).hasClass("sapMSTIconClickTapArea")){this.addStyleClass("sapMSTIconPressed");}else{this.addStyleClass("sapMSTHvr");}}};b.prototype.ontouchend=function(e){this.removeStyleClass("sapMSTHvr");};b.prototype.ontouchcancel=function(e){if(this.hasStyleClass("sapMSTIconPressed")){this.removeStyleClass("sapMSTIconPressed");}else{this.removeStyleClass("sapMSTHvr");}};b.prototype.onkeydown=function(e){if(this.getScope()===a.Display){if(P.events.sapenter.fnCheck(e)){var g=this.getTiles()[this._iCurrentTile];g.onkeydown(e);}}};b.prototype.onkeyup=function(e){var p;if(this.getScope()===a.Display){if(P.events.sapenter.fnCheck(e)){var g=this.getTiles()[this._iCurrentTile];g.onkeyup(e);return;}if(P.events.sapspace.fnCheck(e)){this._toggleAnimation();}if(e.which===K.B&&this._bAnimationPause){this._scrollToNextTile(true,true);}if(e.which===K.F&&this._bAnimationPause){this._scrollToNextTile(true,false);}}else if(this.getScope()===a.Actions){if(P.events.sapselect.fnCheck(e)){this.firePress(this._getEventParams(e));e.preventDefault();}else if(P.events.sapdelete.fnCheck(e)||P.events.sapbackspace.fnCheck(e)){p={scope:this.getScope(),action:G._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};this.firePress(p);e.preventDefault();}}};b.prototype.onsapspace=function(e){e.preventDefault();};b.prototype.onmouseup=function(e){if(this.getScope()===a.Display){if(this.hasStyleClass("sapMSTIconPressed")){this._toggleAnimation();this.removeStyleClass("sapMSTIconPressed");}}};b.prototype.onmousedown=function(e){if(q(e.target).hasClass("sapMSTIconClickTapArea")){this.addStyleClass("sapMSTIconPressed");}};b.prototype.setScope=function(v){if(this.getScope()!==v){if(v===a.Actions){this.setProperty("scope",v,true);this._bNeedInvalidate=true;this._stopAnimation(this._bNeedInvalidate);}else{this.setProperty("scope",v);}this._setTilePressState();}return this;};b.prototype._setupResizeClassHandler=function(){var c=function(){if(this.getSizeBehavior()===T.Small||window.matchMedia("(max-width: 374px)").matches){this.$().addClass("sapMTileSmallPhone");}else{this.$().removeClass("sapMTileSmallPhone");}}.bind(this);q(window).on("resize",c);c();};b.prototype._isFocusInsideST=function(){return this.$()[0]===document.activeElement||this.$().find(document.activeElement).length;};b.prototype._removeGTFocus=function(){for(var i=0;i<this.getTiles().length;i++){this.getTiles()[i].$().removeAttr("tabindex");}};b.prototype._toggleAnimation=function(){if(this.getTiles().length>1){if(this._bAnimationPause){this._startAnimation();}else{this._stopAnimation();}}this._updatePausePlayIcon();};b.prototype._stopAnimation=function(n){this._iCurrAnimationTime+=Date.now()-this._iStartTime;clearTimeout(this._sTimerId);if(this._iCurrentTile!=undefined){var w=this.$("wrapper-"+this._iCurrentTile);w.stop();}if(this._iPreviousTile!=undefined){var W=this.$("wrapper-"+this._iPreviousTile);W.stop();}this._bAnimationPause=true;if(this._iCurrAnimationTime>this.getDisplayTime()){this._scrollToNextTile(true);}else{if(this.getTiles()[this._iCurrentTile]){this._setAriaDescriptor();}if(n){this.invalidate();}}};b.prototype._startAnimation=function(){var d=this.getDisplayTime()-this._iCurrAnimationTime;clearTimeout(this._sTimerId);this._sTimerId=setTimeout(function(){this._scrollToNextTile();}.bind(this),d);this._iStartTime=Date.now();this._bAnimationPause=false;};b.prototype._scrollToTile=function(t){if(t>=0){var w=this.$("wrapper-"+t);var d=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";this._changeSizeTo(t);w.css(d,"0rem");this._iCurrentTile=t;if(this.getTiles()[t]){this._setAriaDescriptor();}this._updateTilesIndicator();}};b.prototype._scrollToNextTile=function(p,c,n){var t=this._iCurrAnimationTime-this.getDisplayTime(),f,N,w,W,s,d,e,g,h,o;t=this.getTransitionTime()-(t>0?t:0);f=t===this.getTransitionTime();if(f){if(c){N=this._getPreviousTileIndex(this._iCurrentTile);}else{N=this._getNextTileIndex(this._iCurrentTile);}this._iPreviousTile=this._iCurrentTile;this._iCurrentTile=N;}if(n>=0){this._iCurrentTile=n;}W=this.$("wrapper-"+this._iCurrentTile);h=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";var i=this.getTiles()[this._iCurrentTile];if(i&&i._isNavigateActionEnabled()){i._oNavigateAction._bExcludeFromTabChain=false;i._oNavigateAction.invalidate();}if(this._iPreviousTile!=undefined){var j=this.getTiles()[this._iPreviousTile];if(j&&j._isNavigateActionEnabled()){j._oNavigateAction._bExcludeFromTabChain=true;j._oNavigateAction.invalidate();}w=this.$("wrapper-"+this._iPreviousTile);s=w.css("width");d=parseFloat(W.css("width"));e=parseFloat(s);g=e<d;if(g){this._changeSizeTo(this._iCurrentTile);}if(f){W.css(h,s);}o={};if(c){o[h]=s;}else{o[h]="-"+s;}w.animate(o,{duration:t,done:function(){if(!g){this._changeSizeTo(this._iCurrentTile);}w.css(h,"");}.bind(this)});if(c){o[h]="-"+s;W.animate(o,0);}o[h]="0rem";W.animate(o,{duration:t,done:function(){this._iCurrAnimationTime=0;if(this._bNeedInvalidate){this.invalidate();}if(!p){this._startAnimation();}}.bind(this)});}else{this._changeSizeTo(this._iCurrentTile);W.css(h,"0rem");}if(this.getTiles()[this._iCurrentTile]){this._setAriaDescriptor();}this._updateTilesIndicator();};b.prototype._setAriaDescriptor=function(){var t,s,c,o;s=this.getScope();c=this.getTiles();o=c[this._iCurrentTile];t=o._getAriaText().replace(/\s/g," ");if(s===a.Actions){t=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+"\n"+t;}else if(c.length>1&&s===a.Display){t+="\n"+this._oRb.getText("SLIDETILE_MULTIPLE_CONTENT")+"\n"+this._oRb.getText("SLIDETILE_TOGGLE_SLIDING");if(this._bAnimationPause){t+="\n"+this._oRb.getText("SLIDETILE_SCROLL_BACK")+"\n"+this._oRb.getText("SLIDETILE_SCROLL_FORWARD");}}t+="\n"+this._oRb.getText("SLIDETILE_ACTIVATE");this.$().attr("aria-label",t);};b.prototype._changeSizeTo=function(t){var o=this.getTiles()[t];if(!o){return;}if(this._sFrameType){this.$().removeClass(this._sFrameType);}if(this._sSize){this.$().removeClass(this._sSize);}this.$().addClass(o.getFrameType()).addClass(o.getSize());this._sFrameType=o.getFrameType();this._sSize=o.getSize();};b.prototype._getPreviousTileIndex=function(t){if(t>0){return t-1;}else{return this.getTiles().length-1;}};b.prototype._getNextTileIndex=function(t){if(t+1<this.getTiles().length){return t+1;}else{return 0;}};b.prototype._updateTilesIndicator=function(){var $;for(var i=0;i<this.getTiles().length;i++){$=this.$("tileIndicator-"+i);if(i===this._iCurrentTile){$.addClass("sapMSTActive");}else{$.removeClass("sapMSTActive");}}};b.prototype._updatePausePlayIcon=function(){if(this._bAnimationPause){this.getAggregation("_pausePlayIcon").setSrc("sap-icon://media-play");this.$().removeClass("sapMSTPauseIcon");}else{this.getAggregation("_pausePlayIcon").setSrc("sap-icon://media-pause");this.$().addClass("sapMSTPauseIcon");}};b.prototype._setTilePressState=function(){var t=this.getTiles(),c=this.getScope()===a.Display;for(var i=0;i<t.length;i++){t[i].setPressEnabled(c);}};b.prototype._hasNewsContent=function(t){var c=this.getTiles()[t].getTileContent();for(var i=0;i<c.length;i++){if(c[i]._getContentType()==="News"){return true;}}return false;};b.prototype._getEventParams=G.prototype._getEventParams;return b;});
