/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/library','sap/ui/core/Control','./TileContentRenderer'],function(l,C,a,T){"use strict";var P=C.Priority;var b=a.extend("sap.m.TileContent",{metadata:{library:"sap.m",properties:{"footer":{type:"string",group:"Appearance",defaultValue:null},"footerColor":{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},"size":{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto",deprecated:true},"unit":{type:"string",group:"Data",defaultValue:null},"disabled":{type:"boolean",group:"Behavior",defaultValue:false},"frameType":{type:"sap.m.FrameType",group:"Appearance",defaultValue:"Auto"},"priority":{type:"sap.ui.core.Priority",group:"Misc",defaultValue:P.None}},defaultAggregation:"content",aggregations:{"content":{type:"sap.ui.core.Control",multiple:false,bindable:"bindable"}}}});b.prototype.init=function(){this._bRenderFooter=true;this._bRenderContent=true;};b.prototype.onBeforeRendering=function(){if(this.getContent()&&this._oDelegate){if(this.getDisabled()){this.getContent().addDelegate(this._oDelegate);}else{this.getContent().removeDelegate(this._oDelegate);}}};b.prototype.onAfterRendering=function(){var c=this.getContent();if(c){var t=this.$();var d=t.find("*");var s=t.attr("title")||"";var e=c.getTooltip_AsString()||"";if(s===e){s="";}var i='';d.toArray().forEach(function(f){if(f.title){i=i.concat(f.title+" ");}});if(i.trim()!==0){e=e+" "+i;}if(e&&e.trim().length!==0){if(this._getFooterText().trim()!==0){e=e+"\n"+this._getFooterText();}s.trim().length!==0?t.attr("title",s+"\n"+e):t.attr("title",e);}d.removeAttr("title").off("mouseenter");}};b.prototype._getContentType=function(){if(this.getContent()){var c=this.getContent().getMetadata().getName();if(c==="sap.m.NewsContent"||c==="sap.suite.ui.commons.NewsContent"){return"News";}}};b.prototype._getFooterText=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var f=this.getFooter();var u=this.getUnit();if(u){if(f){if(sap.ui.getCore().getConfiguration().getRTL()){return r.getText('TILECONTENT_FOOTER_TEXT',[f,u]);}else{return r.getText('TILECONTENT_FOOTER_TEXT',[u,f]);}}else{return u;}}else{return f;}};b.prototype.getAltText=function(){var A="";var i=true;var c=this.getContent();if(c){if(c.getAltText){A+=c.getAltText();i=false;}else if(c.getTooltip_AsString()){A+=c.getTooltip_AsString();i=false;}}if(this.getUnit()){A+=(i?"":"\n")+this.getUnit();i=false;}if(this.getFooter()){A+=(i?"":"\n")+this.getFooter();}return A;};b.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var A="";if(typeof t==="string"||t instanceof String){return t;}A=this.getAltText();return A?A:"";};b.prototype.setRenderFooter=function(v){this._bRenderFooter=v;return this;};b.prototype.setRenderContent=function(v){this._bRenderContent=v;return this;};b.prototype._getPriorityText=function(p){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');return r.getText('ACTION_PRIORITY_'+p.toUpperCase());};return b;});
