/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/Control","sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/core/format/DateFormat","sap/ui/core/LocaleData","sap/ui/core/Locale","./library","./Button",'./TimePickerInternalsRenderer'],function(c,C,S,O,D,L,a,l,B,T){"use strict";var b=1,d=l.ButtonType,e=c.CalendarType;var f=C.extend("sap.m.TimePickerInternals",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},displayFormat:{name:"displayFormat",type:"string",group:"Appearance"},minutesStep:{type:"int",group:"Misc",defaultValue:b},secondsStep:{type:"int",group:"Misc",defaultValue:b},value:{type:"string",group:"Data",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},support2400:{type:"boolean",group:"Misc",defaultValue:false},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_buttonAmPm:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"},_nowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});f.prototype.init=function(){var o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),g=L.getInstance(o),p=g.getDayPeriods("abbreviated"),h=g.getTimePattern("medium");this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sAM=p[0];this._sPM=p[1];this._kbdBuffer="";this.setDisplayFormat(h);this._setTimeValues();this._sMinutes;this._sSeconds;this._clickAttached;this._setAriaLabel(this._oResourceBundle.getText("TIMEPICKER_CLOCK_DIAL_LABEL"));this._setAriaRoleDescription(this._oResourceBundle.getText("TIMEPICKER_INPUTS_ROLE_DESCRIPTION"));};f.prototype.exit=function(){this._destroyControls();this.destroyAggregation("_texts");if(this._oNowButton){this._oNowButton.destroy();this._oNowButton=null;}};f.prototype.setDisplayFormat=function(F){this.setProperty("displayFormat",F,true);this._destroyControls();this._createControls();return this;};f.prototype.setLocaleId=function(g){var o,p;g=this.validateProperty("localeId",g);this.setProperty("localeId",g,true);if(g){o=new a(g);p=L.getInstance(o).getDayPeriods("abbreviated");this._sAM=p[0];this._sPM=p[1];this._destroyControls();this._createControls();}return this;};f.prototype.setSupport2400=function(g){this.setProperty("support2400",g,true);this._destroyControls();this._createControls();return this;};f.prototype.setMinutesStep=function(v){this.setProperty("minutesStep",v,true);this._destroyControls();this._createControls();return this;};f.prototype.setSecondsStep=function(v){this.setProperty("secondsStep",v,true);this._destroyControls();this._createControls();return this;};f.prototype.setShowCurrentTimeButton=function(g){this._getCurrentTimeButton().setVisible(g);return this.setProperty("showCurrentTimeButton",g);};f.prototype._destroyControls=function(){};f.prototype._createControls=function(){};f.prototype._setTimeValues=function(o,h){};f.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};f.prototype._getDisplayFormatPattern=function(){var p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};f.prototype._getValueFormatPattern=function(){var p=this._getBoundValueTypePattern()||this.getValueFormat()||"medium";if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};f.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(p);};f.prototype._getFormatButton=function(){return this.getAggregation("_buttonAmPm");};f.prototype._parseValue=function(v){return this._getFormatter().parse(v);};f.prototype._getFormatter=function(){var p=this._getBoundValueTypePattern(),r=false,o=this.getBinding("value"),g;if(o&&o.oType&&o.oType.oOutputFormat){r=!!o.oType.oOutputFormat.oFormatOptions.relative;g=o.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){p=this.getValueFormat()||"medium";g=e.Gregorian;}if(!g){g=sap.ui.getCore().getConfiguration().getCalendarType();}return this._getFormatterInstance(p,r,g);};f.prototype._getBoundValueTypePattern=function(){var o=this.getBinding("value"),g=o&&o.getType&&o.getType();if(g instanceof S){return g.getOutputPattern();}if(g instanceof O&&g.oFormat){return g.oFormat.oFormatOptions.pattern;}return undefined;};f.prototype._getFormatterInstance=function(p,r,g,h){var F;if(this._checkStyle(p)){F=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:g});}else{F=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:g});}return F;};f.prototype._getFormatInstance=function(A,g){return D.getTimeInstance(A);};f.prototype._formatValue=function(o){if(o){return this._getFormatter().format(o);}return"";};f.prototype._getTimeSeparators=function(g){var F=sap.ui.core.format.DateFormat.getInstance({pattern:g}).aFormatArray,h=[],p,i;for(i=0;i<F.length;i++){if(F[i].type!=="text"){if(p){h.push("");}else{p=true;}}else{h.push(F[i].value);p=false;}}return h;};f.prototype._isFormatSupport24=function(){var F=this._getDisplayFormatPattern();return F.indexOf("HH")!==-1||F.indexOf("H")!==-1;};f.prototype._formatNumberToString=function(n,p,m,r){var N;if(p&&n<10){N="0"+n;}else if(n===m&&r!==""){N=r;}else{N=n.toString();}return N;};f.prototype._setAriaLabel=function(A){this._sAriaLabel=A;return this;};f.prototype._getAriaLabel=function(){return this._sAriaLabel;};f.prototype._setAriaRoleDescription=function(A){this._sAriaRoleDescription=A;return this;};f.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription;};f._replaceZeroHoursWith24=function(v,i,I){var h=2,g=i;if(i===-1){h=1;g=I;}return v.substr(0,g)+"24"+v.substr(g+h);};f._replace24HoursWithZero=function(v,i,I){var h=2,g=i;if(i===-1){h=1;g=I;}return v.substr(0,g)+s(0,h)+v.substr(g+2);};f._isHoursValue24=function(v,i,I){if(i===-1&&I===-1){return false;}var g=i;if(i===-1){g=I;}return v.substr(g,2)==="24";};f.prototype._getCurrentTimeButton=function(){if(!this._oNowButton){this._oNowButton=new B(this.getId()+"-now",{icon:"sap-icon://present",tooltip:this._oResourceBundle.getText("TIMEPICKER_TOOLTIP_NOW"),type:d.Transparent,visible:false,press:function(){this._setTimeValues(new Date());}.bind(this)}).addStyleClass("sapMTPNow");}return this._oNowButton;};function s(g,h){var r="";for(var i=0;i<h;i++){r+=g;}return r;}return f;});
