/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./TimePickerSliderRenderer','sap/ui/core/IconPool','sap/ui/Device',"sap/ui/events/KeyCodes","sap/m/Button","sap/ui/thirdparty/jquery"],function(C,T,I,D,K,B,q){"use strict";var a=C.extend("sap.m.TimePickerSlider",{metadata:{library:"sap.m",properties:{selectedValue:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.m.VisibleItem",multiple:true,singularName:"item"},_arrowUp:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{expanded:{},collapsed:{}}},renderer:T});var S=sap.ui.getCore().getConfiguration().getAnimation()?200:0;var M=50;var L=32;var A=32;a.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._bEnabled=true;if(D.system.desktop){this._fnHandleTypeValues=t.call(this);}this._initArrows();};a.prototype.exit=function(){this._detachEvents();var s=this._getSliderContainerDomRef();if(s){s.stop();}if(this._intervalId){clearInterval(this._intervalId);this._intervalId=null;}};a.prototype.onBeforeRendering=function(){this._detachEvents();};a.prototype.onAfterRendering=function(){if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}this._attachEvents();};a.prototype.onThemeChanged=function(e){this.invalidate();};a.prototype.fireTap=function(e){var s,i,d;if(!this.getIsExpanded()){if(D.system.desktop){this.focus();}else{this.setIsExpanded(true);}}else{s=e.srcElement||e.originalTarget;if(s&&s.tagName.toLowerCase()==="li"){i=q(s).text();d=F.call(this,i);this._iClickedIndex=Array.prototype.slice.call(s.parentElement.children).indexOf(s);this._bOneTimeValueSelectionAnimation=true;this.setSelectedValue(d);this._fireSelectedValueChange(d);}else{this._addSelectionStyle();this.focus();}}};a.prototype.setSelectedValue=function(v){var i=f(this._getVisibleItems(),function(E){return E.getKey()===v;}),d=this,e,s,g,h;if(i===-1){return this;}if(this.getDomRef()){s=this._getSliderContainerDomRef();g=this._getItemHeightInPx();h=this._getContentRepeat();if(i*g>=this._selectionOffset){e=this._getVisibleItems().length*Math.floor(h/2)+i;}else{e=this._getVisibleItems().length*Math.ceil(h/2)+i;}if(this._bOneTimeValueSelectionAnimation){s.scrollTop((e-this._iClickedIndex+this._iSelectedItemIndex)*g-this._selectionOffset);this._animatingSnap=true;s.animate({scrollTop:e*g-this._selectionOffset},S,'linear',function(){s.clearQueue();d._animatingSnap=false;d._bOneTimeValueSelectionAnimation=false;});}else{s.scrollTop(e*g-this._selectionOffset);}this._removeSelectionStyle();this._iSelectedItemIndex=e;this._addSelectionStyle();}return this.setProperty("selectedValue",v,true);};a.prototype.setIsExpanded=function(v,s){this.setProperty("isExpanded",v,true);if(!this.getDomRef()){return this;}var $=this.$();if(v){$.addClass("sapMTPSliderExpanded");if(D.system.phone){setTimeout(function(){this._updateDynamicLayout(v);if(!s){this.fireExpanded({ctrl:this});}}.bind(this),0);}else{this._updateDynamicLayout(v);if(!s){this.fireExpanded({ctrl:this});}}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null&&this._animatingTargetIndex!==undefined){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}$.removeClass("sapMTPSliderExpanded");this._updateMargins(v);if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}if(!s){this.fireCollapsed({ctrl:this});}}return this;};a.prototype.onfocusin=function(e){if(D.system.desktop&&!this.getIsExpanded()){this.setIsExpanded(true);}};a.prototype.onfocusout=function(e){var s=e.relatedTarget?e.relatedTarget.id:null,d=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(s&&d.indexOf(s)!==-1){return;}if(D.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false);}};a.prototype._onmousewheel=function(e){var O,d,w;e.preventDefault();e.stopPropagation();if(!this.getIsExpanded()||this._intervalId){return false;}O=e.originalEvent;d=O.detail?(-O.detail>0):(O.wheelDelta>0);w=O.detail?(-O.detail/3):(O.wheelDelta/120);if(!w){return false;}this._handleWheelScroll(d,w);};a.prototype._handleWheelScroll=function(d,w){var r=d?Math.ceil:Math.floor,R;if(!this._aWheelDeltas){this._aWheelDeltas=[];}this._aWheelDeltas.push(w);if(!this._bWheelScrolling){this._bWheelScrolling=true;this._intervalId=setInterval(function(){if(!this._aWheelDeltas.length){clearInterval(this._intervalId);this._intervalId=null;this._bWheelScrolling=false;}else{R=this._aWheelDeltas[0];this._aWheelDeltas=[];R=r(R);if(R){this._offsetSlider(R);}}}.bind(this),150);}return false;};a.prototype.onsappageup=function(e){if(this.getIsExpanded()){var i=this._getVisibleItems()[0],v=i.getKey();this.setSelectedValue(v);this._fireSelectedValueChange(v);}};a.prototype.onsappagedown=function(e){if(this.getIsExpanded()){var l=this._getVisibleItems()[this._getVisibleItems().length-1],v=l.getKey();this.setSelectedValue(v);this._fireSelectedValueChange(v);}};a.prototype.onsapup=function(e){if(this.getIsExpanded()){this._offsetValue(-1);}};a.prototype.onsapdown=function(e){if(this.getIsExpanded()){this._offsetValue(1);}};a.prototype.onkeydown=function(e){var k=e.which||e.keyCode,d=K;if(k>=d.NUMPAD_0&&k<=d.NUMPAD_9){k=this._convertNumPadToNumKeyCode(k);}if((k>=d.A&&k<=d.Z)||(k>=d.DIGIT_0&&k<=d.DIGIT_9)){this._fnHandleTypeValues(e.timeStamp,k);}};a.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMTimePickerSlider");};a.prototype._getContentRepeat=function(){var i;if(this.getIsCyclic()){i=Math.ceil(M/this._getVisibleItems().length);i=Math.max(i,3);}else{i=1;}return i;};a.prototype._getItemHeightInPx=function(){return this.$("content").find("li:not(.TPSliderItemHidden)")[0].getBoundingClientRect().height;};a.prototype._updateSelectionFrameLayout=function(){var $,i,d,e,s=this.$().offset(),g=s?s.top:0,h=this.$().parents(".sapMTimePickerContainer").offset(),j=h?h.top:0;if(this.getDomRef()){e=this._getItemHeightInPx();$=this.$().find(".sapMTPPickerSelectionFrame");d=g-j;i=(this.$().height()-e+L)/2+d;$.css("top",i);if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}}};a.prototype._updateStepAndValue=function(n,s){var v=0,$,i;for(i=0;i<this.getItems().length;i++){if(i%s!==0&&i!==n){this.getItems()[i].setVisible(false);}else{this.getItems()[i].setVisible(true);v++;}}if(v>2&&v<13&&this.getDomRef()){$=this.$().find(".sapMTimePickerSlider");$.className="";q($).addClass("sapMTimePickerSlider SliderValues"+v.toString());}this.setIsCyclic(v>2);this.setSelectedValue(n.toString());};a.prototype._updateMargins=function(i){var d=this._getItemHeightInPx(),$,v,V,e,g,h,m,j;if(this.getDomRef()){d=this._getItemHeightInPx();$=this.$().find(".SliderValues3,.SliderValues4,.SliderValues5,.SliderValues6,.SliderValues7,.SliderValues8,.SliderValues9,.SliderValues10,.SliderValues11,.SliderValues12");if(!$.length){return;}if(i){v=this._getVisibleItems().length;V=d*Math.floor(v/2);e=d*Math.ceil(v/2);h=this.$().parents().hasClass('sapUiSizeCompact')?A:0;g=(this.$().height()-d+L)/2;m=g-V-L-h;j=this.$().height()-g-e-h;m=Math.max(m,0);j=Math.max(j,0);}else{m=0;j=0;}$.css("margin-top",m);$.css("margin-bottom",j);}};a.prototype._updateDynamicLayout=function(i){this._updateMargins(i);this._updateSelectionFrameLayout();};a.prototype._getSelectionFrameTopOffset=function(){var $=this._getSliderContainerDomRef().find(".sapMTPPickerSelectionFrame"),d=$.offset();return d.top;};a.prototype._animateScroll=function(s){var $=this._getSliderContainerDomRef(),p=$.scrollTop(),d=25,e=$.height(),g=this.$("content").height(),i=200,h=e+i,j=this._getContentRepeat(),k=this.getIsCyclic(),l=0.9,m=0.05,n=this;this._intervalId=setInterval(function(){n._animating=true;p=p-s*d;if(k){p=n._getUpdatedCycleScrollTop(e,g,p,h,j);}else{if(p>n._maxScrollTop){p=n._maxScrollTop;s=0;}if(p<n._minScrollTop){p=n._minScrollTop;s=0;}}$.scrollTop(p);s*=l;if(Math.abs(s)<m){var r=n._getItemHeightInPx();var O=n._selectionOffset?(n._selectionOffset%r):0;var u=Math.round((p+O)/r)*r-O;clearInterval(n._intervalId);n._intervalId=null;n._animating=null;n._iSelectedIndex=Math.round((p+n._selectionOffset)/r);n._animatingSnap=true;$.animate({scrollTop:u},S,'linear',function(){$.clearQueue();n._animatingSnap=false;if($.css("visibility")==="visible"){n._scrollerSnapped(n._iSelectedIndex);}});}},d);};a.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}};a.prototype._startDrag=function(p){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[];}this._dragSession.pageY=p;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop();};a.prototype._doDrag=function(p,d){if(this._dragSession){this._dragSession.offsetY=p-this._dragSession.pageY;this._dragSession.positions.push({pageY:p,timeStamp:d});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10);}if(this._bIsDrag){this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY);}}};a.prototype._endDrag=function(p,d){if(this._dragSession){var O,e;for(var i=this._dragSession.positions.length-1;i>=0;i--){O=d-this._dragSession.positions[i].timeStamp;e=p-this._dragSession.positions[i].pageY;if(O>100){break;}}var s=(e/O);if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}this._dragSession=null;this._animateScroll(s);}};a.prototype._afterExpandCollapse=function(){var s=this.getSelectedValue(),d=this._getSelectionFrameTopOffset(),$=this._getSliderContainerDomRef(),e=$.offset(),i,l,g,h;this._selectionOffset=d-e.top;if(!this.getIsCyclic()){l=this.$("content");h=this._getItemHeightInPx();g=this.$().height();if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=d-e.top;this._maxScrollTop=h*(this._getVisibleItems().length-1);i=$.height();this._marginBottom=i-this._marginTop-h;if(this._marginBottom<0){this._marginBottom=g-this._marginTop-h;}l.css("margin-top",this._marginTop);l.css("margin-bottom",this._marginBottom);}else{this._marginBottom=g-h;l.css("margin-top",0);l.css("margin-bottom",this._marginBottom);}this._selectionOffset=0;}if(!this.getIsExpanded()){this._selectionOffset=0;}this.$().attr('aria-expanded',this.getIsExpanded());this.setSelectedValue(s);};a.prototype._getUpdatedCycleScrollTop=function(i,d,e,g,h){var j=d-e-i;while(j<g){e=e-d/h;j=d-e-i;}while(e<g){e=e+d/h;}return e;};a.prototype._scrollerSnapped=function(i){var s=i,d=this._getVisibleItems().length,n;while(s>=d){s=s-d;}if(!this.getIsCyclic()){s=i;}n=this._getVisibleItems()[s].getKey();this.setSelectedValue(n);this._fireSelectedValueChange(n);};a.prototype._updateScroll=function(){var s=this.getSelectedValue();if(s!==this._getVisibleItems()[0].getKey()&&this._getSliderContainerDomRef().scrollTop()+(this._selectionOffset?this._selectionOffset:0)===0){this.setSelectedValue(s);this._fireSelectedValueChange(s);}};a.prototype._addSelectionStyle=function(){var $=this.$("content").find("li:not(.TPSliderItemHidden)"),s=$.eq(this._iSelectedItemIndex).text(),d,e;if(!s){return;}e=s;if(e&&e.length>1&&e.indexOf('0')===0){e=e.substring(1);}$.eq(this._iSelectedItemIndex).addClass("sapMTimePickerItemSelected");d=this.getDomRef("valDescription");if(d.innerHTML!==e){d.innerHTML=e;}};a.prototype._removeSelectionStyle=function(){var $=this.$("content").find("li:not(.TPSliderItemHidden)");$.eq(this._iSelectedItemIndex).removeClass("sapMTimePickerItemSelected");};a.prototype._attachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(D.system.combi){e.addEventListener("touchstart",q.proxy(o,this),false);e.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);e.addEventListener("mousedown",q.proxy(o,this),false);document.addEventListener("mousemove",q.proxy(b,this),false);document.addEventListener("mouseup",q.proxy(c,this),false);}else{if(D.system.phone||D.system.tablet){e.addEventListener("touchstart",q.proxy(o,this),false);e.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);}else{e.addEventListener("mousedown",q.proxy(o,this),false);document.addEventListener("mousemove",q.proxy(b,this),false);document.addEventListener("mouseup",q.proxy(c,this),false);}}};a.prototype._detachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(e==null){return;}if(D.system.combi){e.removeEventListener("touchstart",q.proxy(o,this),false);e.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);e.removeEventListener("mousedown",q.proxy(o,this),false);document.removeEventListener("mousemove",q.proxy(b,this),false);document.removeEventListener("mouseup",q.proxy(c,this),false);}else{if(D.system.phone||D.system.tablet){e.removeEventListener("touchstart",q.proxy(o,this),false);e.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);}else{e.removeEventListener("mousedown",q.proxy(o,this),false);document.removeEventListener("mousemove",q.proxy(b,this),false);document.removeEventListener("mouseup",q.proxy(c,this),false);}}};a.prototype._offsetValue=function(i){var s=this._getSliderContainerDomRef(),d,e=this._getItemHeightInPx(),g,h,j=this.getIsCyclic(),k=this;this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}h=this._iSelectedItemIndex+i;d=s.scrollTop();g=d+i*e;if(!j){if(h<0||h>=this._getVisibleItems().length){return;}if(g>this._maxScrollTop){g=this._maxScrollTop;}if(g<this._minScrollTop){g=this._minScrollTop;}}this._animatingSnap=true;this._animatingTargetIndex=h;s.animate({scrollTop:g},S,'linear',function(){s.clearQueue();k._animatingSnap=false;k._animatingTargetIndex=null;if(s.css("visibility")==="visible"){k._scrollerSnapped(h);}});};a.prototype._offsetSlider=function(O){var s=this._getSliderContainerDomRef().scrollTop(),d=this,$=d._getSliderContainerDomRef().height(),e=d.$("content").height(),i=200,g=$+i,h=d._getContentRepeat(),j=d.getIsCyclic(),k=d._getItemHeightInPx();s=s-O*k;if(j){s=d._getUpdatedCycleScrollTop($,e,s,g,h);}else{if(s>d._maxScrollTop){s=d._maxScrollTop;}if(s<d._minScrollTop){s=d._minScrollTop;}}d._getSliderContainerDomRef().scrollTop(s);d._iSelectedIndex=Math.round((s+d._selectionOffset)/k);d._scrollerSnapped(d._iSelectedIndex);};a.prototype._initArrows=function(){var d=this,e,g,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");e=new B({icon:I.getIconURI("slim-arrow-up"),press:function(E){d._offsetValue(-1);},tooltip:r.getText("TIMEPICKER_TOOLTIP_UP"),type:'Transparent'});e.addEventDelegate({onAfterRendering:function(){e.$().attr("tabindex",-1);}});this.setAggregation("_arrowUp",e);g=new B({icon:I.getIconURI("slim-arrow-down"),press:function(E){d._offsetValue(1);},tooltip:r.getText("TIMEPICKER_TOOLTIP_DOWN"),type:'Transparent'});g.addStyleClass("sapMTimePickerItemArrowDown");g.addEventDelegate({onAfterRendering:function(){g.$().attr("tabindex",-1);}});this.setAggregation("_arrowDown",g);};a.prototype._convertNumPadToNumKeyCode=function(k){var d=K;if(k>=d.NUMPAD_0&&k<=d.NUMPAD_9){k-=48;}return k;};function f(d,p){if(d==null){throw new TypeError('findIndex called with null or undefined array');}if(typeof p!=='function'){throw new TypeError('predicate must be a function');}var l=d.length;var e=arguments[1];var v;for(var i=0;i<l;i++){v=d[i];if(p.call(e,v,i,d)){return i;}}return-1;}var o=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._stopAnimation();this._startDrag(p);if(!D.system.desktop){e.preventDefault();}this._mousedown=true;};var b=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var d=this._dragSession.positions.some(function(g){return Math.abs(g.pageY-p)>5;});if(d){this._bIsDrag=true;}}this._doDrag(p,e.timeStamp);this._mousedown=true;};var c=function(e){var p=e.changedTouches&&e.changedTouches.length?e.changedTouches[0].pageY:e.pageY;if(this._bIsDrag===false){this.fireTap(e);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(p,e.timeStamp);this._mousedown=false;};var F=function(s){var i=this._getVisibleItems();var d=f(i,function(e){return e.getText()===s;});return i[d]?i[d].getKey():'';};var t=function(){var l=-1,i=-1,w=1000,s="",d=function(e,k){var m;if(l+w<e){s="";}else{if(i!==-1){clearTimeout(i);i=-1;}}s+=String.fromCharCode(k).toLowerCase();m=this._getVisibleItems().filter(function(g){return g.getKey().indexOf(s)===0;});if(m.length>1){i=setTimeout(function(){this.setSelectedValue(s);s="";i=-1;}.bind(this),w);}else if(m.length===1){this.setSelectedValue(m[0].getKey());s="";}else{s="";}l=e;};return d;};a.prototype._getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};a.prototype._setEnabled=function(e){this._bEnabled=e;if(e){this.$().removeClass("sapMTPDisabled");this.$().attr("tabindex",0);}else{this.$().addClass("sapMTPDisabled");this.$().attr("tabindex",-1);}return this;};a.prototype._getEnabled=function(e){return this._bEnabled;};a.prototype._fireSelectedValueChange=function(v){this.fireEvent("_selectedValueChange",{value:v});};return a;});
