/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/m/Button','sap/m/List','sap/m/StandardListItem','sap/m/ResponsivePopover','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','./TokenizerRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/EnabledPropagator","sap/ui/core/theming/Parameters","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/scrollLeftRTL"],function(l,B,L,S,R,C,c,d,D,I,e,T,f,K,g,E,P,q,s){"use strict";var h="sapUiNoContentPadding";var j=l.TokenizerRenderMode;var k=l.PlacementType;var m=l.ListMode;var n=l.ButtonType;var o=c.extend("sap.m.Tokenizer",{metadata:{library:"sap.m",properties:{editable:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},renderMode:{type:"string",group:"Misc",defaultValue:j.Loose},hiddenTokensCount:{type:"int",group:"Misc",defaultValue:0,visibility:"hidden"}},defaultAggregation:"tokens",aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tokenChange:{deprecated:true,parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{deprecated:true,allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenDelete:{parameters:{tokens:{type:"sap.m.Token[]"},keyCode:{type:"number"}}}}}});var r=C.getLibraryResourceBundle("sap.m");E.apply(o.prototype,[true]);o.prototype.init=function(){this.allowTextSelection(false);this._oTokensWidthMap={};this._oIndicator=null;this._oScroller=new d(this,this.getId()+"-scrollContainer",{horizontal:true,vertical:false,nonTouchScrolling:true});this._fFontSizeRatio=1.0;if(C.getConfiguration().getAccessibility()){var a=new I({text:r.getText("TOKENIZER_ARIA_NO_TOKENS")});this.setAggregation("_tokensInfo",a);}this.attachEvent("delete",function(b){var t=b.getSource();var i=this.getSelectedTokens();this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:t,tokens:i.length?i:[t],addedTokens:[],removedTokens:i.length?i:[t]});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:i.length?i:[t]});this.fireEvent("tokenDelete",{tokens:[t]});},this);};o.prototype._handleNMoreIndicatorPress=function(){this._togglePopup(this.getTokensPopup());};o.prototype._getTokensList=function(){if(!this._oTokensList){this._oTokensList=new L({width:"auto",mode:m.Delete}).attachDelete(this._handleListItemDelete,this);}return this._oTokensList;};o.prototype._setPopoverMode=function(M){var a={},p=this.getTokensPopup();switch(M){case m.Delete:a={showArrow:false,placement:k.VerticalPreferredBottom};break;default:a={showArrow:true,placement:k.Auto};break;}p.setShowArrow(a.showArrow);p.setPlacement(a.placement);this._getTokensList().setMode(M);};o.prototype._fillTokensList=function(a,F){a.destroyItems();F=F?F:function(){return true;};this.getTokens().filter(F).forEach(function(t){a.addItem(this._mapTokenToListItem(t));},this);};o.prototype._handleListItemDelete=function(a){var b=a.getParameter("listItem");var i=b&&b.data("tokenId");var t;t=this.getTokens().filter(function(p){return(p.getId()===i)&&p.getEditable();})[0];if(t){this.fireTokenUpdate({addedTokens:[],removedTokens:[t],type:o.TokenUpdateType.Removed});this.fireTokenDelete({tokens:[t]});this._adjustTokensVisibility();}};o.prototype.getTokensPopup=function(){if(this._oPopup){return this._oPopup;}this._oPopup=new R({showArrow:false,showHeader:D.system.phone,placement:k.Auto,offsetX:0,offsetY:3,horizontalScrolling:false,title:this._getDialogTitle(),content:this._getTokensList()}).attachBeforeOpen(function(){var w=this.getEditable()?120:32,p=this._oPopup,G=function(){var a=this.getDomRef()&&this.getDomRef().parentElement;var b="Cozy";if(!a){return b;}if(a.closest(".sapUiSizeCompact")!==null||document.body.classList.contains("sapUiSizeCompact")){b="Compact";}return b;}.bind(this),i=new Promise(function(a){P.get({name:["_sap_m_Tokenizer_FontSizeRatio"+G()],callback:function(F){var b=parseFloat(F);if(isNaN(b)){a(this._fFontSizeRatio);return;}a(b);}.bind(this)});}.bind(this));if(p.getContent&&!p.getContent().length){p.addContent(this._getTokensList());}this._fillTokensList(this._getTokensList());w+=Object.keys(this._oTokensWidthMap).map(function(a){return this._oTokensWidthMap[a];},this).sort(function(a,b){return a-b;}).pop()||0;i.then(function(a){w+=Math.ceil(w*(1-a));p.setContentWidth(w+"px");});},this);this.addDependent(this._oPopup);this._oPopup.addStyleClass(h);this._oPopup.addStyleClass("sapMTokenizerTokensPopup");if(D.system.phone){this._oPopup.setEndButton(new B({text:r.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),type:n.Emphasized,press:function(){this._oPopup.close();}.bind(this)}));}return this._oPopup;};o.prototype._getDialogTitle=function(){var a=C.getLibraryResourceBundle("sap.m");var b=this.getAriaLabelledBy().map(function(i){return C.byId(i);});return b.length?b[0].getText():a.getText("COMBOBOX_PICKER_TITLE");};o.prototype._togglePopup=function(p){var O,a=this.getDomRef(),b=p.isOpen(),i=this.getEditable();this._setPopoverMode(i?m.Delete:m.None);if(b){p.close();}else{O=i||this.hasOneTruncatedToken()?a:this._oIndicator[0];O=O&&O.className.indexOf("sapUiHidden")===-1?O:a;p.openBy(O||a);}};o.prototype._mapTokenToListItem=function(t){if(!t){return null;}var a=new S({selected:true}).data("tokenId",t.getId());a.setTitle(t.getText());return a;};o.prototype._getPixelWidth=function(){var M=this.getMaxWidth(),t,a=this.getDomRef(),p;if(!a){return;}p=parseInt(this.$().css("padding-left"));if(M.indexOf("px")===-1){t=a.clientWidth;}else{t=parseInt(this.getMaxWidth());}return t-p;};o.prototype._adjustTokensVisibility=function(){if(!this.getDomRef()){return;}var t=this._getPixelWidth(),a=this._getVisibleTokens().reverse(),i=a.length,b,F,p,u=-1;a.some(function(v,w){t=t-this._oTokensWidthMap[v.getId()];if(t<0){u=w;return true;}else{F=t;}},this);if(i===1&&u!==-1){this.setFirstTokenTruncated(true);return;}else if(i===1&&a[0].getTruncated()){this.setFirstTokenTruncated(false);}if(u>-1){for(p=0;p<i;p++){if(p>=u){a[p].addStyleClass("sapMHiddenToken");}else{a[p].removeStyleClass("sapMHiddenToken");}}this._handleNMoreIndicator(i-u);b=this._oIndicator.width();if(b>=F){u=u-1;this._handleNMoreIndicator(i-u);a[u].addStyleClass("sapMHiddenToken");}this._setHiddenTokensCount(i-u);}else{this._setHiddenTokensCount(0);this._showAllTokens();}};o.prototype.setFirstTokenTruncated=function(v){var t=this.getTokens()[0];t&&t.setTruncated(v);if(v){this.addStyleClass("sapMTokenizerOneLongToken");}else{this.removeStyleClass("sapMTokenizerOneLongToken");this.scrollToEnd();}return this;};o.prototype.hasOneTruncatedToken=function(){return this.getTokens().length===1&&this.getTokens()[0].getTruncated();};o.prototype._handleNMoreIndicator=function(H){if(!this.getDomRef()){return this;}if(H){var a="MULTIINPUT_SHOW_MORE_TOKENS";if(H===this._getVisibleTokens().length){if(H===1){a="TOKENIZER_SHOW_ALL_ITEM";}else{a="TOKENIZER_SHOW_ALL_ITEMS";}}this._oIndicator.html(r.getText(a,H));}return this;};o.prototype._getVisibleTokens=function(){return this.getTokens().filter(function(t){return t.getVisible();});};o.prototype._showAllTokens=function(){this._getVisibleTokens().forEach(function(t){t.removeStyleClass("sapMHiddenToken");});};o.prototype.getScrollDelegate=function(){return this._oScroller;};o.prototype.scrollToEnd=function(){var a=this.getDomRef(),b=C.getConfiguration().getRTL(),i,p;if(!this.getDomRef()){return;}p=this.$().find(".sapMTokenizerScrollContainer")[0];i=p.scrollWidth;if(b){i*=-1;}a.scrollLeft=i;};o.prototype._registerResizeHandler=function(){if(!this._sResizeHandlerId){this._sResizeHandlerId=e.register(this.getDomRef(),this._handleResize.bind(this));}};o.prototype._handleResize=function(){this._useCollapsedMode(this.getRenderMode());this.scrollToEnd();};o.prototype.setPixelWidth=function(a){if(typeof a!=="number"){g.warning("Tokenizer.setPixelWidth called with invalid parameter. Expected parameter of type number.");return;}this.setWidth(a+"px");if(this._oScroller){this._oScroller.refresh();}};o.prototype.scrollToStart=function(){var a=this.getDomRef();if(!a){return;}a.scrollLeft=0;};o.prototype.getScrollWidth=function(){if(!this.getDomRef()){return 0;}return this.$().children(".sapMTokenizerScrollContainer")[0].scrollWidth;};o.prototype.onBeforeRendering=function(){var t=this.getTokens();if(t.length!==1){this.setFirstTokenTruncated(false);}t.forEach(function(a,i){a.setProperty("editableParent",this.getEditable()&&this.getEnabled(),true);a.setProperty("posinset",i+1,true);a.setProperty("setsize",t.length,true);},this);this._setTokensAria();};o.prototype.onAfterRendering=function(){var a=this.getRenderMode();this._oIndicator=this.$().find(".sapMTokenizerIndicator");if(C.isThemeApplied()){this._storeTokensSizes();}this._useCollapsedMode(a);this._registerResizeHandler();if(a===j.Loose){this.scrollToEnd();}};o.prototype.onThemeChanged=function(){this._storeTokensSizes();this._useCollapsedMode(this.getRenderMode());};o.prototype._storeTokensSizes=function(){var t=this.getTokens();t.forEach(function(a){if(a.getDomRef()&&!a.$().hasClass("sapMHiddenToken")&&!a.getTruncated()){this._oTokensWidthMap[a.getId()]=a.$().outerWidth(true);}},this);};o.prototype._useCollapsedMode=function(a){var t=this._getVisibleTokens();if(!t.length){return;}if(a===j.Narrow){this._adjustTokensVisibility();}else{this._setHiddenTokensCount(0);this._showAllTokens();}};o.prototype.onsapfocusleave=function(a){if(document.activeElement===this.getDomRef()||!this._checkFocus()){this._changeAllTokensSelection(false);this._oSelectionOrigin=null;}};o.prototype.onsapbackspace=function(a){var b=this.getSelectedTokens();var F=this.getTokens().filter(function(t){return t.getFocusDomRef()===document.activeElement;})[0];var i=b.length?b:[F];a.preventDefault();return this.fireTokenDelete({tokens:i,keyCode:a.which});};o.prototype.onsapdelete=o.prototype.onsapbackspace;o.prototype.onkeydown=function(a){var b;if(!this.getEnabled()){return;}if(a.which===K.TAB){this._changeAllTokensSelection(false);}if((a.ctrlKey||a.metaKey)&&a.which===K.A){b=this.getSelectedTokens().length<this._getVisibleTokens().length;if(this._getVisibleTokens().length>0){this.focus();this._changeAllTokensSelection(b);a.preventDefault();a.stopPropagation();}}if((a.ctrlKey||a.metaKey)&&(a.which===K.C||a.which===K.INSERT)){this._copy();}if(((a.ctrlKey||a.metaKey)&&a.which===K.X)||(a.shiftKey&&a.which===K.DELETE)){if(this.getEditable()){this._cut();}else{this._copy();}}};o.prototype.onsappreviousmodifiers=function(a){this.onsapprevious(a);};o.prototype.onsapnextmodifiers=function(a){this.onsapnext(a);};o.prototype.onsaphomemodifiers=function(a){this._selectRange(false);};o.prototype.onsapendmodifiers=function(a){this._selectRange(true);};o.prototype._selectRange=function(F){var a={},t=this._getVisibleTokens(),b=q(document.activeElement).control()[0],p=t.indexOf(b);if(!b||!b.isA("sap.m.Token")){return;}if(F){a.start=p;a.end=t.length-1;}else{a.start=0;a.end=p;}if(a.start<a.end){for(var i=a.start;i<=a.end;i++){t[i].setSelected(true);}}};o.prototype._copy=function(){this._fillClipboard("copy");};o.prototype._fillClipboard=function(a){var b=this.getSelectedTokens();var t=b.map(function(p){return p.getText();}).join("\r\n");var i=function(p){if(p.clipboardData){p.clipboardData.setData('text/plain',t);}else{p.originalEvent.clipboardData.setData('text/plain',t);}p.preventDefault();};document.addEventListener(a,i);document.execCommand(a);document.removeEventListener(a,i);};o.prototype._cut=function(){var a=this.getSelectedTokens();this._fillClipboard("cut");this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:a,tokens:a,addedTokens:[],removedTokens:a});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:a});this.fireTokenDelete({tokens:a});};o.prototype._ensureTokenVisible=function(t){if(!t||!t.getDomRef()||!this.getDomRef()){return;}var i=this.$().offset().left,a=this.$().width(),b=t.$().offset().left,p=C.getConfiguration().getRTL(),u=p?parseInt(t.$().css("margin-left")):parseInt(t.$().css("margin-right")),v=parseInt(t.$().css("border-left-width"))+parseInt(t.$().css("border-right-width")),w=t.$().width()+u+v,x=p?this.$().scrollLeftRTL():this.$().scrollLeft(),y=x-i+b,z=x+(b-i+w-a);if(this._getVisibleTokens().indexOf(t)===0){this.$().scrollLeft(0);return;}if(b<i){p?this.$().scrollLeftRTL(y):this.$().scrollLeft(y);}if(b-i+w>a){p?this.$().scrollLeftRTL(z):this.$().scrollLeft(z);}};o.prototype.ontap=function(a){var b=a.shiftKey,p=(a.ctrlKey||a.metaKey),t=a.getMark("tokenTap"),u=a.getMark("tokenDeletePress"),v=this._getVisibleTokens(),F,w,x,M,y;if(u||!t||(!b&&p)){this._oSelectionOrigin=null;return;}if(!b){this._oSelectionOrigin=t;this._changeAllTokensSelection(false,t,true);}F=t;if(this._oSelectionOrigin){F=this._oSelectionOrigin;}else{this._oSelectionOrigin=F;}if(t&&this.hasOneTruncatedToken()){this._handleNMoreIndicatorPress();return;}w=this.indexOfToken(F);x=this.indexOfToken(t);M=Math.min(w,x);y=Math.max(w,x);v.forEach(function(z,i){if(i>=M&&i<=y){z.setSelected(true);}else if(!p){z.setSelected(false);}});};o.prototype.onsapprevious=function(a){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var b=F?t.indexOf(F):-1;if(b===0){a.setMarked("forwardFocusToParent");return;}var p,u;if(b>0){p=t[b-1];this._ensureTokenVisible(p);p.focus();}else{p=t[t.length-1];this._ensureTokenVisible(p);p.focus({preventScroll:true});}if(a.shiftKey){u=t[b];p.setSelected(true);u.setSelected(true);}a.setMarked();a.preventDefault();};o.prototype.onsapnext=function(a){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var b=F?t.indexOf(F):-1;var N=t[b+1];this._ensureTokenVisible(N);if(b<i-1){var p=t[b];N.focus();if(a.shiftKey){N.setSelected(true);p.setSelected(true);}}else{a.setMarked("forwardFocusToParent");return;}a.setMarked();a.preventDefault();};o.prototype.addValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};o.prototype.removeValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};o.prototype.removeAllValidators=function(){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};o.prototype.addValidateToken=function(p){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};o.prototype._parseString=function(a){return a.split(/\r\n|\r|\n/g);};o.prototype._checkFocus=function(){return this.getDomRef()&&f(this.getDomRef(),document.activeElement);};o.prototype.selectAllTokens=function(b){if(b===undefined){b=true;}this._changeAllTokensSelection(b);return this;};o.prototype._changeAllTokensSelection=function(b,t,a){var i=this._getVisibleTokens();i.filter(function(p){return p!==t;}).forEach(function(p){p.setSelected(b);});if(!a){this._doSelect();}return this;};o.prototype.getSelectedTokens=function(){return this._getVisibleTokens().filter(function(t){return t.getSelected();});};o.prototype.onsaphome=function(a){var A=this.getTokens().filter(function(t){return t.getDomRef()&&!t.getDomRef().classList.contains("sapMHiddenToken");});A.length&&A[0].focus();this.scrollToStart();a.preventDefault();};o.prototype.onsapend=function(a){var t=this._getVisibleTokens(),b=t[t.length-1];if(b.getDomRef()!==document.activeElement){b.focus();this.scrollToEnd();a.stopPropagation();}else{a.setMarked("forwardFocusToParent");}a.preventDefault();};o.prototype.onclick=function(a){var F;if(!this.getEnabled()){return;}F=!this.hasStyleClass("sapMTokenizerIndicatorDisabled")&&a.target.classList.contains("sapMTokenizerIndicator");if(F){this._handleNMoreIndicatorPress();}};o.prototype.ontouchstart=function(a){a.setMarked();if(D.browser.chrome&&window.getSelection()){window.getSelection().removeAllRanges();}};o.prototype.exit=function(){this._deregisterResizeHandler();if(this._oTokensList){this._oTokensList.destroy();this._oTokensList=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}this._oTokensWidthMap=null;this._oIndicator=null;this._aTokenValidators=null;};o.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){e.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}};o.prototype._setTokensAria=function(){var t=this._getVisibleTokens().length;var i;var a="";var b="";var p={0:"TOKENIZER_ARIA_NO_TOKENS",1:"TOKENIZER_ARIA_CONTAIN_ONE_TOKEN"};if(C.getConfiguration().getAccessibility()){i=this.getAggregation("_tokensInfo");b=p[t]?p[t]:"TOKENIZER_ARIA_CONTAIN_SEVERAL_TOKENS";a=r.getText(b,t);i.setText(a);}};o.prototype._doSelect=function(){if(this._checkFocus()&&this._bCopyToClipboardSupport){var F=document.activeElement;var a=window.getSelection();a.removeAllRanges();if(this.getSelectedTokens().length){var b=document.createRange();b.selectNodeContents(this.getDomRef("clip"));a.addRange(b);}if(window.clipboardData&&F.id===this.getId()+"-clip"&&this.getDomRef()){this.getDomRef().focus();}}};o.prototype._setHiddenTokensCount=function(i){i=this.validateProperty("hiddenTokensCount",i);return this.setProperty("hiddenTokensCount",i);};o.prototype.getHiddenTokensCount=function(){return this.getProperty("hiddenTokensCount");};o.prototype.getTokensInfoId=function(){return this.getAggregation("_tokensInfo").getId();};o.prototype._handleBackspace=function(i,F){var t=this.getTokens();if(t[i-1]){return t[i-1].focus();}return F();};o.prototype._handleDelete=function(i,F){var t=this.getTokens();if(t[i+1]){return t[i+1].focus();}return F();};o.prototype.focusToken=function(i,O,F){var t=this.getTokens();var b=O.keyCode;var a=O.keyCode===K.BACKSPACE;if(t.length===0){return;}if(!b){return;}if(a){return this._handleBackspace(i,F);}return this._handleDelete(i,F);};o.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};o.TokenUpdateType={Added:"added",Removed:"removed"};return o;});
