/*!
* OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool','./Toolbar','./CheckBox','./SearchField','./List','./StandardListItem','./Dialog','./Button','./ToggleButton','./Title','./NavContainer','./Bar','./SegmentedButton','./Page','./ViewSettingsItem','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','sap/ui/base/EventProvider','sap/ui/Device','sap/ui/core/InvisibleText','./ViewSettingsDialogRenderer',"sap/m/GroupHeaderListItem","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,I,T,a,S,L,b,D,B,c,d,N,e,f,P,V,M,g,E,h,m,n,G,o,q){"use strict";var p=l.ListMode;var r=l.ListType;var s=l.StringFilterOperator;var t=l.TitleAlignment;var u=l.ButtonType;var v="-list-item";var w=C.extend("sap.m.ViewSettingsDialog",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Behavior",defaultValue:null},sortDescending:{type:"boolean",group:"Behavior",defaultValue:false},groupDescending:{type:"boolean",group:"Behavior",defaultValue:false},filterSearchOperator:{type:"sap.m.StringFilterOperator",group:"Behavior",defaultValue:s.StartsWith},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:t.Auto}},aggregations:{sortItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"sortItem",bindable:"bindable"},groupItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"groupItem",bindable:"bindable"},filterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"filterItem",bindable:"bindable"},presetFilterItems:{type:"sap.m.ViewSettingsItem",multiple:true,singularName:"presetFilterItem",bindable:"bindable"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{selectedSortItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedGroupItem:{type:"sap.m.ViewSettingsItem",multiple:false},selectedPresetFilterItem:{type:"sap.m.ViewSettingsItem",multiple:false}},events:{confirm:{parameters:{sortItem:{type:"sap.m.ViewSettingsItem"},sortDescending:{type:"boolean"},groupItem:{type:"sap.m.ViewSettingsItem"},groupDescending:{type:"boolean"},presetFilterItem:{type:"sap.m.ViewSettingsItem"},filterItems:{type:"sap.m.ViewSettingsItem[]"},filterKeys:{type:"object",deprecated:true},filterCompoundKeys:{type:"object"},filterString:{type:"string"}}},cancel:{},resetFilters:{},reset:{},filterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}}});w.prototype.init=function(){var j=this.getId();this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sDialogWidth="350px";this._sDialogHeight="434px";this._bAppendedToUIArea=false;this._showSubHeader=false;this._filterDetailList=undefined;this._vContentPage=-1;this._oContentItem=null;this._oPreviousState={};this._sCustomTabsButtonsIdPrefix='-custom-button-';this._sTitleLabelId=j+"-title";this._sFilterDetailTitleLabelId=j+"-detailtitle";this._oFiltersSelectedOnly={};this._oKeylessFilters={};this._aggregationToListItems("sortItems",{text:{listProp:"title"},selected:{}},{tooltip:{}},{type:r.Active},{mode:p.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(k){var U=k.getParameter('listItem'),W=this.getSortItems(),X=this._getVSItem(U),i;X.setProperty('selected',k.getParameter('selected'),true,false);this.setAssociation('selectedSortItem',X,true);for(i=0;i<W.length;i++){if(X!==W[i]){W[i].setProperty('selected',false,true,false);}}this._checkResetStatus();}.bind(this)});};w.prototype.exit=function(){this._rb=null;this._sDialogWidth=null;this._sDialogHeight=null;this._bAppendedToUIArea=null;this._showSubHeader=null;this._vContentPage=null;this._oContentItem=null;this._oPreviousState=null;this._sortContent=null;this._groupContent=null;this._filterContent=null;this._sCustomTabsButtonsIdPrefix=null;this._fnFilterSearchCallback=null;this._oKeylessFilters=null;if(this._bAppendedToUIArea&&this._dialog){var i=sap.ui.getCore().getStaticAreaRef();i=sap.ui.getCore().getUIArea(i);i.removeContent(this._dialog,true);}if(this._dialog){this._dialog.destroy();this._dialog=null;}if(this._navContainer){this._navContainer.destroy();this._navContainer=null;}if(this._titleLabel){this._titleLabel.destroy();this._titleLabel=null;}if(this._page1){this._page1.destroy();this._page1=null;}if(this._header){this._header.destroy();this._header=null;}if(this._resetButton){this._resetButton.destroy();this._resetButton=null;}if(this._subHeader){this._subHeader.destroy();this._subHeader=null;}if(this._segmentedButton){this._segmentedButton.destroy();this._segmentedButton=null;}if(this._sortButton){this._sortButton.destroy();this._sortButton=null;}if(this._groupButton){this._groupButton.destroy();this._groupButton=null;}if(this._filterButton){this._filterButton.destroy();this._filterButton=null;}if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._ariaSortListInvisibleText){this._ariaSortListInvisibleText.destroy();this._ariaSortListInvisibleText=null;}if(this._sortOrderList){this._sortOrderList.destroy();this._sortOrderList=null;this._ariaSortOrderInvisibleText.destroy();this._ariaSortOrderInvisibleText=null;}if(this._oGroupingNoneItem){this._oGroupingNoneItem.destroy();this._oGroupingNoneItem=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;this._ariaGroupListInvisibleText.destroy();this._ariaGroupListInvisibleText=null;}if(this._groupOrderList){this._groupOrderList.destroy();this._groupOrderList=null;this._ariaGroupOrderInvisibleText.destroy();this._ariaGroupOrderInvisibleText=null;}if(this._presetFilterList){this._presetFilterList.destroy();this._presetFilterList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._ariaFilterByInvisibleText){this._ariaFilterByInvisibleText.destroy();this._ariaFilterByInvisibleText=null;}if(this._page2){this._page2.destroy();this._page2=null;}if(this._detailTitleLabel){this._detailTitleLabel.destroy();this._detailTitleLabel=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._oStringFilter){this._oStringFilter=null;}if(this._oSelectedFilterKeys){this._oSelectedFilterKeys=null;}};w.prototype._aggregationToListItems=function(i,j,k,U,W){var X=this._getListType(i),Y="_"+X+"List";if(!this.mToList){this.mToList={};}this.mToList[X]={"itemPropertyMap":j,"itemAggregationMap":k,"listItemOptions":U,"listOptions":W,"listName":Y};};w.prototype._getListType=function(i){return i.replace('Items','');};w.prototype._createList=function(i){var j=this.getId()+"-"+i+"list",k=new L(j,this.mToList[i].listOptions),U=this._createGroupHeaderItem(i);k.addItem(U);this[this.mToList[i].listName]=k;return k;};w.prototype._createGroupHeaderItem=function(i){return new G({title:this._rb.getText("VIEWSETTINGS_"+i.toUpperCase()+"_OBJECT")});};w.prototype._getList=function(i){if(!this.mToList||!this.mToList[i]){return;}return this[this.mToList[i].listName];};w.prototype._createListItem=function(i,j){var k=this.mToList[i].listItemOptions,U=this.mToList[i].itemPropertyMap,W=this.mToList[i].itemAggregationMap,X,Y;for(var Z in U){if(U.hasOwnProperty(Z)){X=U[Z].listProp||Z;k[X]=this._createListItemPropertyValue(i,Z,j);}}for(var $ in W){if(W.hasOwnProperty($)){k[$]=j.getAggregation($);}}Y=new b(k).data('item',j);return Y;};w.prototype._createListItemPropertyValue=function(i,j,k){var U=k.getMetadata().getAllProperties()[j].get(k),W=this.mToList[i].itemPropertyMap[j].fn;return W?W(U):U;};w.prototype._getListItem=function(i,j){var k=this._getList(i).getItems().filter(function(U){return U.data('item')===j;});return k.length?k[0]:null;};w.prototype._getVSItem=function(i){return i.data('item');};w.prototype.addCustomTab=function(i){var j=i.getId();if(j==='sort'||j==='filter'||j==='group'){throw'Id "'+j+'" is reserved and cannot be used as custom tab id.';}this.addAggregation('customTabs',i);return this;};w.prototype.invalidate=function(){if(this._dialog&&(!arguments[0]||arguments[0]&&arguments[0].getId()!==this.getId()+"-dialog")){this._dialog.invalidate(arguments);}};w.prototype.addStyleClass=function(){var i=this._getDialog();i.addStyleClass.apply(i,arguments);return this;};w.prototype.removeStyleClass=function(){var i=this._getDialog();i.removeStyleClass.apply(i,arguments);return this;};w.prototype.toggleStyleClass=function(){var i=this._getDialog();i.toggleStyleClass.apply(i,arguments);return this;};w.prototype.hasStyleClass=function(){var i=this._getDialog();return i.hasStyleClass.apply(i,arguments);};w.prototype.getDomRef=function(){if(this._dialog){return this._dialog.getDomRef.apply(this._dialog,arguments);}else{return null;}};w.prototype.setTitle=function(i){this._getTitleLabel().setText(i);this.setProperty("title",i);return this;};w.prototype.setTitleAlignment=function(i){this.setProperty("titleAlignment",i);if(this._page1){this._page1.setTitleAlignment(i);}if(this._page2){this._page2.setTitleAlignment(i);}return this;};w.prototype.addAggregation=function(i,j,k){C.prototype.addAggregation.apply(this,arguments);var U=this._getListType(i);if(this.mToList[U]){var W=this._createListItem(U,j);var X=this._getList(U);if(!X){X=this._createList(U);}else if(!X.getItems().length){X.addItem(this._createGroupHeaderItem(U));}X.addItem(W);this._attachItemPropertyChange(U,j);}else{this._attachItemEventHandlers(i,j);}if(i==="filterItems"){this._observeItem(j);}return this;};w.prototype.insertAggregation=function(i,j,k,U){C.prototype.insertAggregation.apply(this,arguments);var W=this._getListType(i);if(this.mToList[W]){var X=this._createListItem(W,j);var Y=this._getList(W);if(!Y){Y=this._createList(W);Y.insertItem(X,k);}else if(!Y.getItems().length){Y.addItem(this._createGroupHeaderItem(W));Y.insertItem(X,k+1);}else{Y.insertItem(X,k);}this._attachItemPropertyChange(W,j);}else{this._attachItemEventHandlers(i,j);}if(i==="filterItems"){this._observeItem(j);}return this;};w.prototype.removeAggregation=function(i,j,k){F.call(this,i,j);var U=C.prototype.removeAggregation.apply(this,arguments);var W=this._getListType(i);if(this.mToList[W]){var X=this._getListItem(W,U);var Y=this._getList(W);var Z=Y.removeItem(X);Z.destroy();this._detachItemPropertyChange(U);}if(i==="filterItems"){this._unobserveItem(U);if(!this.getFilterItems().length){this._disconnectAndDestroyFilterItemsObserver();}}return U;};w.prototype.removeAllAggregation=function(i,j){F.call(this);var k=C.prototype.removeAllAggregation.apply(this,arguments);var U=this._getListType(i);if(this.mToList[U]){var W=this._getList(U);if(W){var X=W.removeAllItems();X.forEach(function(Y){Y.destroy();});}k.forEach(function(Y){this._detachItemPropertyChange(Y);},this);}if(i==="filterItems"){this._disconnectAndDestroyFilterItemsObserver();}return k;};w.prototype.destroyAggregation=function(i,j){F.call(this);C.prototype.destroyAggregation.apply(this,arguments);var k=this._getListType(i);if(this.mToList[k]){var U=this._getList(k);if(U){U.destroyItems();}}if(i==="filterItems"){this._disconnectAndDestroyFilterItemsObserver();}return this;};w.prototype._detachItemPropertyChange=function(i){delete E.getEventList(i)["itemPropertyChanged"];};w.prototype._attachItemPropertyChange=function(i,j){j.attachEvent('itemPropertyChanged',function _(k){var U,W,X,Y,Z,$;U=this._getListItem(i,j);W=k.getParameter('propertyKey');if(!this.mToList[i].itemPropertyMap[W]){return;}X=this.mToList[i].itemPropertyMap[W].listProp||W;Y=k.getParameter('propertyValue');Z=this.mToList[i].itemPropertyMap[W].fn;$=Z?Z(Y):Y;U.getMetadata().getAllProperties()[X].set(U,$);},this);};w.prototype._getFilterItemsObserver=function(){if(!this._oFilterItemsObserver){this._oFilterItemsObserver=new g(function(){if(this._oSelectedFilterKeys){this.setSelectedFilterCompoundKeys(this._oSelectedFilterKeys);}}.bind(this));}return this._oFilterItemsObserver;};w.prototype._observeItem=function(i){this._getFilterItemsObserver().observe(i,{aggregations:["items"]});};w.prototype._unobserveItem=function(i){this._getFilterItemsObserver().unobserve(i,{aggregations:["items"]});};w.prototype._disconnectAndDestroyFilterItemsObserver=function(){if(this._oFilterItemsObserver){this._oFilterItemsObserver.disconnect();this._oFilterItemsObserver.destroy();this._oFilterItemsObserver=null;}};w.prototype._attachItemEventHandlers=function(i,j){if(i!=='groupItems'&&i!=='filterItems'){return this;}var k=i.replace('Items','');k=k.charAt(0).toUpperCase()+k.slice(1);j.attachEvent('itemPropertyChanged',function(i,U){if(i==='filterItems'&&U.getParameter('changedItem').getParent().getMetadata().getName()==='sap.m.ViewSettingsFilterItem'){if(U.getParameter('propertyKey')!=='selected'){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}else{if(this._filterDetailList){var W=this._filterDetailList.getItems();W.forEach(function(X){if(X.data('item').getId()===U.getParameter('changedItem').getId()){X.setSelected(U.getParameter('propertyValue'));}});this._updateSelectAllCheckBoxState();}}this._updateFilterCounters();}else{if(typeof this['_init'+k+'Content']==='function'){this['_init'+k+'Content']();}if(typeof this['_init'+k+'Items']==='function'){if(U.getParameter("propertyKey")==="selected"&&U.getParameter("propertyValue")===true){this.setAssociation("selectedGroupItem",U.getParameter("changedItem"),true);}this['_init'+k+'Items']();}}}.bind(this,i));j.attachEvent('filterDetailItemsAggregationChange',function(U){if(this._vContentPage===3&&this._oContentItem){this._setFilterDetailTitle(this._oContentItem);this._initFilterDetailItems(this._oContentItem);}}.bind(this));return this;};w.prototype._setFilterDetailTitle=function(i){var j=this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")+" "+i.getText();this._getDetailTitleLabel().setText(j);this._toggleDialogTitle(this._sFilterDetailTitleLabelId);};w.prototype._toggleDialogTitle=function(i){var j=this._getDialog(),k=j.getAriaLabelledBy(),U=[this._sTitleLabelId,this._sFilterDetailTitleLabelId];if(U.indexOf(i)===-1&&k.indexOf(i)>-1){return this;}for(var W in U){j.removeAriaLabelledBy(U[W]);}j.addAriaLabelledBy(i);return this;};w.prototype.updateAggregation=function(i){C.prototype.updateAggregation.apply(this,arguments);if(i!=='groupItems'&&i!=='filterItems'){return this;}var j=i.replace('Items','');j=j.charAt(0).toUpperCase()+j.slice(1);if(typeof this['_init'+j+'Content']==='function'){this['_init'+j+'Content']();}if(typeof this['_init'+j+'Items']==='function'){this['_init'+j+'Items']();}};w.prototype.addSortItem=function(i){this.addAggregation("sortItems",i);if(i.getSelected()){this.setSelectedSortItem(i);}return this;};w.prototype.addGroupItem=function(i){this.addAggregation("groupItems",i);if(i.getSelected()){this.setSelectedGroupItem(i);}return this;};w.prototype.addPresetFilterItem=function(i){this.addAggregation("presetFilterItems",i);if(i.getSelected()){this.setSelectedPresetFilterItem(i);}return this;};w.prototype.setSelectedSortItem=function(j){var k=this.getSortItems(),i=0,U=z(j,k,"Could not set selected sort item. Item is not found: '"+j+"'");if(!U||A(U)){for(i=0;i<k.length;i++){if(!U||k[i].getId()!==U.getId()){k[i].setProperty('selected',false,true);}}if(U&&U.getProperty('selected')!==true){U.setProperty('selected',true,true);}if(this._getDialog().isOpen()){this._updateListSelection(this._sortList,U);}this.setAssociation("selectedSortItem",U,true);}return this;};w.prototype.setSelectedGroupItem=function(j){var k=this.getGroupItems(),i=0,U=z(j,k,"Could not set selected group item. Item is not found: '"+j+"'");if(!U&&!j){U=this._oGroupingNoneItem;}if(A(U)){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}U.setProperty('selected',true,true);if(this._getDialog().isOpen()){this._updateListSelection(this._groupList,U);}this.setAssociation("selectedGroupItem",U,true);}return this;};w.prototype.setSelectedPresetFilterItem=function(j){var k=this.getPresetFilterItems(),i=0,U=z(j,k,"Could not set selected preset filter item. Item is not found: '"+j+"'");if(A(U)||U===null){for(i=0;i<k.length;i++){k[i].setProperty('selected',false,true);}if(U!==null){U.setProperty('selected',true,true);}this._clearSelectedFilters();this.setAssociation("selectedPresetFilterItem",U,true);}return this;};w.prototype.open=function(i){if(!this.getParent()&&!this._bAppendedToUIArea){var j=sap.ui.getCore().getStaticAreaRef();j=sap.ui.getCore().getUIArea(j);j.addContent(this._getDialog(),true);this._bAppendedToUIArea=true;}if(i&&this._vContentPage===3){setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this._getPage1().getId(),"show"),0);}this._initDialogContent(i);this._oPreviousState={sortItem:sap.ui.getCore().byId(this.getSelectedSortItem()),sortDescending:this.getSortDescending(),groupItem:sap.ui.getCore().byId(this.getSelectedGroupItem()),groupDescending:this.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(this.getSelectedPresetFilterItem()),filterKeys:this.getSelectedFilterKeys(),filterCompoundKeys:this.getSelectedFilterCompoundKeys(),navPage:this._getNavContainer().getCurrentPage(),contentPage:this._vContentPage,contentItem:this._oContentItem};if(!this._oInitialState){this._oInitialState={sortItem:this.getSelectedSortItem(),sortDescending:this.getSortDescending(),groupItem:this.getSelectedGroupItem(),groupDescending:this.getGroupDescending(),presetFilterItem:this.getSelectedPresetFilterItem()};}if(h.system.desktop){this._getDialog().attachEventOnce("afterOpen",function(){var k=this._getNavContainer().getCurrentPage(),$;if(k){$=k.$("cont").firstFocusableDomRef();if($){if(q($).hasClass('sapMListUl')){var U=q($).find('.sapMLIB');U.length&&U[0].focus();return;}$.focus();}}},this);}this._checkResetStatus();this._getDialog().open();return this;};w.prototype.getSelectedFilterItems=function(){var k=[],U=this.getFilterItems(),W,X=true,i=0,j;for(;i<U.length;i++){if(U[i]instanceof sap.m.ViewSettingsCustomItem){if(U[i].getSelected()){k.push(U[i]);}}else if(U[i]instanceof sap.m.ViewSettingsFilterItem){W=U[i].getItems();X=U[i].getMultiSelect();for(j=0;j<W.length;j++){if(W[j].getSelected()){k.push(W[j]);if(!X){break;}}}}}return k;};w.prototype.getSelectedFilterString=function(){var k="",U,W=this.getSelectedPresetFilterItem(),X=this.getFilterItems(),Y,Z=true,i=0,j;if(W){k=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+sap.ui.getCore().byId(W).getText());}else{for(;i<X.length;i++){if(X[i]instanceof sap.m.ViewSettingsCustomItem){if(X[i].getSelected()){k+=X[i].getText()+", ";}}else if(X[i]instanceof sap.m.ViewSettingsFilterItem){Y=X[i].getItems();Z=X[i].getMultiSelect();U="";for(j=0;j<Y.length;j++){if(Y[j].getSelected()){U+=Y[j].getText()+", ";if(!Z){break;}}}U=U.substring(0,U.length-2);if(U){U=" ("+U+")";k+=X[i].getText()+U+", ";}}}k=k.substring(0,k.length-2);if(k){k=this._rb.getText("VIEWSETTINGS_FILTERTEXT").concat(" "+k);}}return k;};w.prototype.getSelectedFilterKeys=function(){var j={},k=this.getSelectedFilterItems(),i=0;for(;i<k.length;i++){j[k[i].getKey()]=k[i].getSelected();}return j;};w.prototype.getSelectedFilterCompoundKeys=function(){var j={},k=this.getSelectedFilterItems(),i,U,W,X;this._oKeylessFilters={};for(i=0;i<k.length;i++){X=k[i];if(X instanceof sap.m.ViewSettingsCustomItem){U=X.getKey();j[U]=X.getSelected();}else{U=X.getKey();W=X.getParent().getKey();if(!j[W]){j[W]={};}j[W][U]=X.getSelected();if(U===""){if(!this._oKeylessFilters[W]){this._oKeylessFilters[W]={};}this._oKeylessFilters[W][X.getText()]=true;}}}return j;};w.prototype.setSelectedFilterKeys=function(U){var W=this.getFilterItems(),X={},Y,Z,i,j,k;if(Object.keys(U).length){this._clearPresetFilter();}for(var $ in U){Y=null;if(U.hasOwnProperty($)){for(i=0;i<W.length;i++){if(W[i]instanceof sap.m.ViewSettingsCustomItem){if(W[i].getKey()===$){Y=W[i];W[i].setProperty('selected',U[$],true);}}else if(W[i]instanceof sap.m.ViewSettingsFilterItem){X=W[i].getItems();Z=W[i].getMultiSelect();for(j=0;j<X.length;j++){if(X[j].getKey()===$){Y=X[j];if(!Z){for(k=0;k<X.length;k++){X[k].setProperty('selected',false,true);}}break;}}}if(Y){break;}}if(Y===null){o.warning('Cannot set state for key "'+$+'" because there is no filter with these keys');continue;}Y.setProperty('selected',U[$],true);}}return this;};w.prototype.setSelectedFilterCompoundKeys=function(i){var j=this.getFilterItems(),k,U,W,X,Y,Z,$,_,a1,b1;this._oSelectedFilterKeys=i;if(Object.keys(i).length){this._clearPresetFilter();for(k in i){X=null;for(b1=0;b1<j.length;b1++){U=j[b1].getKey();if(U===k){X=j[b1];break;}}if(X instanceof sap.m.ViewSettingsCustomItem){X.setProperty('selected',i[k],true);}else if(X instanceof sap.m.ViewSettingsFilterItem){Y=i[k];Z=X.getItems();$=X.getMultiSelect();a1=false;for(b1=0;b1<Z.length;b1++){U=Z[b1].getKey();W=Z[b1].getText();if((U!==""&&Y[U])||(U===""&&this._oKeylessFilters[k]&&this._oKeylessFilters[k][W])){_=a1?false:Y[U];}else{_=false;}Z[b1].setProperty("selected",_,true);if(_&&!$){a1=true;}}}}}return this;};w.prototype._checkForInnerCustomItems=function(j){for(var i=0;i<j.length;i++){if(j[i].isA("sap.m.ViewSettingsCustomItem")){return true;}}return false;};w.prototype._checkForCustomItems=function(){var i=this.getSortItems(),j=this.getGroupItems(),k=this.getFilterItems(),U=this.getPresetFilterItems();return this.getAggregation("customTabs").length||i.length&&this._checkForInnerCustomItems(i)||j.length&&this._checkForInnerCustomItems(j)||k.length&&this._checkForInnerCustomItems(k)||U.length&&this._checkForInnerCustomItems(U);};w.prototype._checkResetStatus=function(){var i=false,j=this.getSelectedFilterItems();if(this._checkForCustomItems()){i=true;}else{if(this._oInitialState){if(j.length>0){i=true;}if(this._oInitialState.sortItem!==this.getSelectedSortItem()||this._oInitialState.sortDescending!==this.getSortDescending()){i=true;}if((this._oInitialState.groupItem&&this._oInitialState.groupItem!==this.getSelectedGroupItem())||this._oInitialState.groupDescending!==this.getGroupDescending()){i=true;}if(this._oInitialState.presetFilterItem!==undefined&&this.getSelectedPresetFilterItem()!==null){i=true;}}}if(this._resetButton){this._resetButton.setEnabled(i);}if(this._detailResetButton){this._detailResetButton.setEnabled(i);}};w.prototype._globalReset=function(){this.clearFilters();this.setSelectedSortItem(sap.ui.getCore().byId(this._oInitialState.sortItem));this.setSortDescending(this._oInitialState.sortDescending);this._updateListSelection(this._sortOrderList,this._oInitialState.sortDescending);this._oInitialState.groupItem!==undefined&&this.setSelectedGroupItem(sap.ui.getCore().byId(this._oInitialState.groupItem));this.setGroupDescending(this._oInitialState.groupDescending);this._updateListSelection(this._groupOrderList,this._oInitialState.groupDescending);this._checkResetStatus();this.fireReset();};w.prototype._getDialog=function(){var i=this;if(this._dialog===undefined){this._dialog=new D(this.getId()+"-dialog",{ariaLabelledBy:this._sTitleLabelId,showHeader:false,stretch:h.system.phone,verticalScrolling:true,horizontalScrolling:false,contentWidth:this._sDialogWidth,contentHeight:this._sDialogHeight,content:this._getNavContainer(),titleAlignment:this.getTitleAlignment(),beginButton:new B(this.getId()+"-acceptbutton",{text:this._rb.getText("VIEWSETTINGS_ACCEPT"),type:u.Emphasized}).attachPress(this._onConfirm,this),endButton:new B(this.getId()+"-cancelbutton",{text:this._rb.getText("VIEWSETTINGS_CANCEL")}).attachPress(this._onCancel,this)}).addStyleClass("sapMVSD");this.addDependent(this._dialog);var j=this._dialog.onsapescape;this._dialog.onsapescape=function(k){if(j){j.call(i._dialog,k);}i._onCancel();};this._dialog.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){i._pressBackButton();}};}return this._dialog;};w.prototype._getNavContainer=function(){if(this._navContainer===undefined){this._navContainer=new N(this.getId()+'-navcontainer',{pages:[]});}return this._navContainer;};w.prototype._getTitleLabel=function(){if(this._titleLabel===undefined){this._titleLabel=new d(this._sTitleLabelId,{text:this._rb.getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._titleLabel;};w.prototype._getResetButton=function(){if(!this._resetButton){this._resetButton=new B(this.getId()+"-resetbutton",{press:function(){this._globalReset();}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")});}return this._resetButton;};w.prototype._getDetailResetButton=function(){if(this._detailResetButton===undefined){this._detailResetButton=new B(this.getId()+"-detailresetbutton",{press:function(){this._globalReset();}.bind(this),text:this._rb.getText("VIEWSETTINGS_RESET")});}return this._detailResetButton;};w.prototype._getDetailTitleLabel=function(){if(this._detailTitleLabel===undefined){this._detailTitleLabel=new d(this.getId()+"-detailtitle",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY")}).addStyleClass("sapMVSDTitle");}return this._detailTitleLabel;};w.prototype._getHeader=function(){if(this._header===undefined){this._header=new e({titleAlignment:this.getTitleAlignment(),contentMiddle:[this._getTitleLabel()]}).addStyleClass("sapMVSDBar");}return this._header;};w.prototype._getSubHeader=function(){if(this._subHeader===undefined){this._subHeader=new e({contentLeft:[this._getSegmentedButton()]}).addStyleClass("sapMVSDBar");}return this._subHeader;};w.prototype._getSegmentedButton=function(){var j=this,k=this.getCustomTabs(),U=k.length,i=0;if(this._segmentedButton===undefined){this._segmentedButton=new f({select:function(W){var X=W.getParameter('id');if(X===j.getId()+"-sortbutton"){j._switchToPage(0);}else if(X===j.getId()+"-groupbutton"){j._switchToPage(1);}else if(X===j.getId()+"-filterbutton"){j._switchToPage(2);}else{for(i=0;i<U;i++){var Y=k[i],Z=j.getId()+j._sCustomTabsButtonsIdPrefix+Y.getId();if(!j._isEmptyTab(Y)&&X===Z){j._switchToPage(Y.getId());break;}}}o.info('press event segmented: '+W.getParameter('id'));}}).addStyleClass("sapMVSDSeg");this._segmentedButton._bPreventWidthRecalculationOnAfterRendering=true;}return this._segmentedButton;};w.prototype._getSortButton=function(){if(this._sortButton===undefined){this._sortButton=new B(this.getId()+"-sortbutton",{icon:I.getIconURI("sort"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});}return this._sortButton;};w.prototype._getGroupButton=function(){if(this._groupButton===undefined){this._groupButton=new B(this.getId()+"-groupbutton",{icon:I.getIconURI("group-2"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});}return this._groupButton;};w.prototype._getFilterButton=function(){if(this._filterButton===undefined){this._filterButton=new B(this.getId()+"-filterbutton",{icon:I.getIconURI("filter"),tooltip:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});}return this._filterButton;};w.prototype._getPage1=function(i){if(this._page1===undefined&&!i){this._page1=new P(this.getId()+'-page1',{title:this._rb.getText("VIEWSETTINGS_TITLE"),titleAlignment:this.getTitleAlignment(),customHeader:this._getHeader()});this._getNavContainer().addPage(this._page1);}return this._page1;};w.prototype._getPage2=function(){var i,j,k,U=this.getTitleAlignment();if(this._page2===undefined){j=new B(this.getId()+"-backbutton",{icon:I.getIconURI("nav-back"),press:[this._pressBackButton,this]});k=this._getDetailResetButton();i=new e({titleAlignment:U,contentLeft:[j],contentMiddle:[this._getDetailTitleLabel()],contentRight:[k]}).addStyleClass("sapMVSDBar");this._page2=new P(this.getId()+'-page2',{title:this._rb.getText("VIEWSETTINGS_TITLE_FILTERBY"),titleAlignment:U,customHeader:i});this._getNavContainer().addPage(this._page2);}return this._page2;};w.prototype._initFilterDetailItems=function(k){if(!(k instanceof sap.m.ViewSettingsFilterItem)){return;}var U;var W=k.getMultiSelect();var X=k.getItems();var Y=this;if(this._filterDetailList){this._filterDetailList.destroy();}this._getPage2().removeAllAggregation('content');this._filterDetailList=new L({mode:(W?p.MultiSelect:p.SingleSelectLeft),includeItemInSelection:true,selectionChange:function(Z){var $,_=Z.getParameter("listItems"),a1,i=0,b1;Y._clearPresetFilter();if(W){this._updateSelectAllCheckBoxState();}if(_.length>1&&W){a1=k.getItems();for(;i<a1.length;i++){for(var j=0;j<_.length;j++){if(a1[i].getKey()===_[j].getCustomData()[0].getValue().getKey()){a1[i].setProperty('selected',_[j].getSelected(),true);}}}}else{$=Z.getParameter("listItem").data("item");if(!k.getMultiSelect()){a1=k.getItems();for(;i<a1.length;i++){if(a1[i].getId()!==$.getId()){a1[i].setProperty('selected',false,true);}}}b1=Z.getParameter("listItem").getSelected();if($.getProperty('selected')!==b1){$.setProperty('selected',b1,true);}}this._checkResetStatus();}.bind(this),ariaLabelledBy:this._sFilterDetailTitleLabelId});for(var i=0;i<X.length;i++){U=new b({title:M.escapeSettingsValue(X[i].getText()),type:r.Active,selected:X[i].getSelected(),tooltip:X[i].getTooltip()}).data("item",X[i]);this._filterDetailList.addItem(U);}this._filterSearchField=this._getFilterSearchField(this._filterDetailList);this._showOnlySelectedButton=this._getShowOnlySelectedButton();this._searchBar=new T({content:[this._filterSearchField.addStyleClass('sapMVSDFilterSearchField').addStyleClass('sapMTBShrinkItem'),this._showOnlySelectedButton]});this._getPage2().addContent(this._searchBar);this._getPage2().getCustomHeader().addStyleClass('sapMVSDBarWithSearch');if(W){this._selectAllCheckBox=this._createSelectAllCheckbox(X,this._filterDetailList);if(this._filterDetailList.getItems().length===0){this._selectAllCheckBox.setEnabled(false);}this._filterDetailList.setHeaderToolbar(new T({content:[this._selectAllCheckBox]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}this._setFilterDetailItemsVisibility(this._filterDetailList,true);this._getPage2().addContent(this._filterDetailList);};w.prototype._initSortContent=function(){if(this._sortContent){return;}this._vContentPage=-1;this._ariaSortOrderInvisibleText=new m(this.getId()+"-sortOrderLabel",{text:this._rb.getText("VIEWSETTINGS_SORT_DIRECTION")});this._sortOrderList=new L(this.getId()+"-sortorderlist",{mode:p.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(i){this.setProperty('sortDescending',i.getParameter("listItem").data("item"),true);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaSortOrderInvisibleText});this._sortOrderList.addItem(new G({title:this._rb.getText("VIEWSETTINGS_SORT_BY")}));this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._sortOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaSortListInvisibleText=new m(this.getId()+"-sortListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_SORT")});this._sortList.addAriaLabelledBy(this._ariaSortListInvisibleText);this._sortContent=[this._ariaSortOrderInvisibleText,this._sortOrderList,this._ariaSortListInvisibleText,this._sortList];};w.prototype._initGroupItems=function(){var i,j,k=this.getGroupItems(),U=this._rb.getText("VIEWSETTINGS_GROUP_OBJECT");this._groupList.destroyItems();if(k.length){this._groupList.addItem(new G({title:U}));k.forEach(function(W){i=new b({id:W.getId()+v,title:M.escapeSettingsValue(W.getText()),type:r.Active,selected:W.getSelected(),tooltip:W.getTooltip()}).data("item",W);this._groupList.addItem(i);},this);if(!this._oGroupingNoneItem||this._oGroupingNoneItem.bIsDestroyed){j=!!this.getSelectedGroupItem();this._oGroupingNoneItem=new V({text:this._rb.getText("VIEWSETTINGS_NONE_ITEM"),selected:!j,itemPropertyChanged:function(){this._initGroupContent();this._initGroupItems();}.bind(this)});!j&&this.setAssociation("selectedGroupItem",this._oGroupingNoneItem,true);}i=new b({id:this._oGroupingNoneItem.getId()+v,title:this._oGroupingNoneItem.getText(),type:r.Active,selected:this._oGroupingNoneItem.getSelected()}).data("item",this._oGroupingNoneItem);this._groupList.addItem(i);}};w.prototype._initGroupContent=function(){var i=this._rb.getText("VIEWSETTINGS_GROUP_BY");if(this._groupContent){return;}this._vContentPage=-1;this._ariaGroupOrderInvisibleText=new m(this.getId()+"-groupOrderLabel",{text:this._rb.getText("VIEWSETTINGS_GROUP_DIRECTION")});this._groupOrderList=new L(this.getId()+"-grouporderlist",{mode:p.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){this.setProperty('groupDescending',j.getParameter("listItem").data("item"),true);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaGroupOrderInvisibleText});this._groupOrderList.addItem(new G({title:i}));this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_ASCENDING_ITEM")}).data("item",false).setSelected(true));this._groupOrderList.addItem(new b({title:this._rb.getText("VIEWSETTINGS_DESCENDING_ITEM")}).data("item",true));this._ariaGroupListInvisibleText=new m(this.getId()+"-groupListLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_GROUP")});this._groupList=new L(this.getId()+"-grouplist",{mode:p.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(j){var k=j.getParameter("listItem").data("item");this.setSelectedGroupItem(k);this._checkResetStatus();}.bind(this),ariaLabelledBy:this._ariaGroupListInvisibleText});this._groupContent=[this._ariaGroupOrderInvisibleText,this._groupOrderList,this._ariaGroupListInvisibleText,this._groupList];};w.prototype._initFilterItems=function(){var i,j,k,U=this,W=this._rb.getText("VIEWSETTINGS_FILTER_BY");this._presetFilterList.destroyItems();i=this.getPresetFilterItems();if(i.length){i.forEach(function(X){k=new b({id:X.getId()+v,title:M.escapeSettingsValue(X.getText()),type:r.Active,selected:X.getSelected(),tooltip:X.getTooltip()}).data("item",X);this._presetFilterList.addItem(k);},this);}if(i.length){k=new b({id:this._presetFilterList.getId()+"-none"+v,title:this._rb.getText("VIEWSETTINGS_NONE_ITEM_FILTER"),selected:!!this.getSelectedPresetFilterItem()});this._presetFilterList.addItem(k);}this._filterList.destroyItems();j=this.getFilterItems();this._filterList.addItem(new G({title:W}));if(j.length){j.forEach(function(X){k=new b({id:X.getId()+v,title:M.escapeSettingsValue(X.getText()),type:r.Active,tooltip:X.getTooltip(),press:(function(X){return function(Y){if(U._navContainer.getCurrentPage().getId()!==U.getId()+'-page2'){U._switchToPage(3,X);U._prevSelectedFilterItem=this;setTimeout(U._navContainer["to"].bind(U._navContainer,U.getId()+'-page2',"slide"),0);}if(h.system.desktop&&U._filterDetailList&&U._filterDetailList.getItems()[0]){U._getNavContainer().attachEventOnce("afterNavigate",function(){U._filterDetailList.getItems()[0].focus();});}};}(X))}).data("item",X);this._filterList.addItem(k);},this);}};w.prototype._initFilterContent=function(){if(this._filterContent){return;}this._vContentPage=-1;this._ariaFilterByInvisibleText=new m(this.getId()+"-filterByLabel",{text:this._rb.getText("VIEWSETTINGS_TITLE_FILTER")});this._presetFilterList=new L(this.getId()+"-predefinedfilterlist",{mode:p.SingleSelectLeft,includeItemInSelection:true,selectionChange:function(i){var j=i.getParameter("listItem").data("item");if(j){j.setProperty('selected',i.getParameter("listItem").getSelected(),true);}this.setAssociation("selectedPresetFilterItem",j,true);this._clearSelectedFilters();this._checkResetStatus();}.bind(this)});this._filterList=new L(this.getId()+"-filterlist",{ariaLabelledBy:this._ariaFilterByInvisibleText});this._filterContent=[this._ariaFilterByInvisibleText,this._presetFilterList,this._filterList];};w.prototype._initDialogContent=function(i){var j=!!this.getSortItems().length,k=!!this.getGroupItems().length,U=!!this.getPresetFilterItems().length,W=!!this.getFilterItems().length;if(j){this._initSortContent();}if(k){this._initGroupContent();this._initGroupItems();}if(U||W){this._initFilterContent();this._initFilterItems();}this._updateDialogState(i);this._updateListSelections();};w.prototype._getTabButton=function(i,j){var k=j+i.getId(),U=sap.ui.getCore().byId(k);if(U){return U;}else{return new B({id:k,icon:i.getIcon(),tooltip:i.getTooltip()});}};w.prototype._updateDialogState=function(i){var j=!!this.getSortItems().length,k=!!this.getGroupItems().length,U=!!this.getPresetFilterItems().length,W=!!this.getFilterItems().length,X=!!this.getCustomTabs().length,Y=this._getSegmentedButton(),Z=null,$=false,_={"sort":0,"group":1,"filter":2};Y.removeAllButtons();if(this._filterContent){this._presetFilterList.setVisible(true);this._filterList.setVisible(true);}if(j){Y.addButton(this._getSortButton());}if(U||W){Y.addButton(this._getFilterButton());if(!U){this._presetFilterList.setVisible(false);}if(!W){this._filterList.setVisible(false);}}if(k){Y.addButton(this._getGroupButton());}if(X){this.getCustomTabs().forEach(function(b1){if(!this._isEmptyTab(b1)){var c1=this.getId()+this._sCustomTabsButtonsIdPrefix,d1=this._getTabButton(b1,c1);Y.addButton(d1);}}.bind(this));}this._showSubHeader=this._hasSubHeader();if(i===undefined&&this._vContentPage!==-1){i=this._vContentPage;switch(i){case 0:i='sort';break;case 1:i='group';break;case 2:i='filter';break;}}if(i===this._vContentPage&&this._vContentPage===3){this._vContentPage=-1;this._switchToPage(3,this._oContentItem);}else{i=this._determineValidPageId(i);for(var a1 in _){if(i===a1){$=true;Z=this.getId()+'-'+i+'button';i=_[a1];break;}}if(!$){Z=this.getId()+this._sCustomTabsButtonsIdPrefix+i;}this._getSegmentedButton().setSelectedButton(Z);this._switchToPage(i);if(this._getNavContainer().getCurrentPage()!==this._getPage1()){this._getNavContainer().to(this._getPage1().getId());}}};w.prototype._determineValidPageId=function(i){var j='sort',k=false,U=[];U=this._fetchValidPagesIds();if(U.length){j=U[0];}else{o.warning('No available pages to load - missing items.');}if(!i){i=j;}else{U.filter(function(W){if(W===i){k=true;return false;}return true;});if(!k){i=j;}}return i;};w.prototype._fetchValidPagesIds=function(){var i,j=this.getCustomTabs(),k=j.length,U=[];var W=['sort','filter','group'];W.forEach(function(Y){if(this._isValidPredefinedPageId(Y)){U.push(Y);}},this);for(i=0;i<k;i++){var X=j[i];if(!this._isEmptyTab(X)){U.push(X.getId());}}return U;};w.prototype._isEmptyTab=function(i){return!(i.getContent().length||this._vContentPage===i.getId()&&this._getPage1().getContent().length);};w.prototype._isValidPredefinedPageId=function(i){if(!i){o.warning('Missing mandatory parameter.');return false;}var j=false;switch(i){case'sort':j=!!this.getSortItems().length;break;case'filter':j=!!this.getFilterItems().length||!!this.getPresetFilterItems().length;break;case'group':j=!!this.getGroupItems().length;break;}return j;};w.prototype._pressBackButton=function(){var i=this;if(this._vContentPage===3){this._updateFilterCounters();this._getNavContainer().attachEvent("afterNavigate",function(){if(i._prevSelectedFilterItem){i._prevSelectedFilterItem.focus();}});setTimeout(this._getNavContainer()['back'].bind(this._getNavContainer()),0);this._switchToPage(2);this._segmentedButton.setSelectedButton(this._filterButton);}};w.prototype.setModel=function(i,j){if(this._vContentPage===3&&this._oContentItem){x.call(this);}return C.prototype.setModel.call(this,i,j);};w.prototype.removeFilterItem=function(i){var j="";if(this._vContentPage===3&&this._oContentItem){if(typeof(i)==="object"){j=i.getId();}else if(typeof(i)==="string"){j=i;}else if(typeof(i)==="number"){j=this.getFilterItems()[i].getId();}if(this._oContentItem.getId()===j){x.call(this);}}return this.removeAggregation('filterItems',i);};w.prototype.removeAllFilterItems=function(){if(this._vContentPage===3&&this._oContentItem){x.call(this);}return this.removeAllAggregation('filterItems');};w.prototype.setFilterSearchCallback=function(i){this._fnFilterSearchCallback=i;return this;};w.prototype._switchToPage=function(W,j){var i=0,k=this._getTitleLabel(),U=this._getHeader(),X=this._getSubHeader();this._checkResetStatus();this._getPage2().getCustomHeader().removeStyleClass('sapMVSDBarWithSearch');if(H.call(this)){F.call(this);}U.removeAllContentRight();X.removeAllContentRight();this._vContentPage=W;this._oContentItem=j;if(W!==3){this._getPage1().removeAllAggregation("content",true);this._addResetButtonToPage1();}else if(W===3){this._getPage2().removeAllAggregation("content",true);}if(this.getTitle()){k.setText(this.getTitle());}else{k.setText(this._rb.getText("VIEWSETTINGS_TITLE"));}this._toggleDialogTitle(this._sTitleLabelId);switch(W){case 1:if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_GROUP"));}for(;i<this._groupContent.length;i++){this._getPage1().addContent(this._groupContent[i]);}break;case 2:if(!this._showSubHeader&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_FILTER"));}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();for(;i<this._filterContent.length;i++){this._getPage1().addContent(this._filterContent[i]);}break;case 3:this._setFilterDetailTitle(j);if(j instanceof sap.m.ViewSettingsCustomItem&&j.getCustomControl()){this._clearPresetFilter();this._getPage2().addContent(j.getCustomControl());}else if(j instanceof sap.m.ViewSettingsFilterItem&&j.getItems()){this._initFilterDetailItems(j);}break;case 0:if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(this._rb.getText("VIEWSETTINGS_TITLE_SORT"));}if(this._sortContent){for(;i<this._sortContent.length;i++){this._getPage1().addContent(this._sortContent[i]);}}break;default:this._getPage1().removeAllAggregation("content",true);var Y="VIEWSETTINGS_TITLE";var Z=this.getCustomTabs();if(Z.length<2){Y=Z[0].getTitle();}if(!this._getPage1().getSubHeader()&&!this.getTitle()){k.setText(Y);}Z.forEach(function($){if($.getId()===W){$.getContent().forEach(function(_){this._getPage1().addContent(_);},this);}},this);break;}if(W===3){this.fireFilterDetailPageOpened({parentFilterItem:j});}};w.prototype._createSelectAllCheckbox=function(i,j){var k=false;if(i&&i.length!==0){k=i.every(function(W){return W.getSelected();});}var U=new a({text:this._rb.getText("COLUMNSPANEL_SELECT_ALL"),selected:k,select:function(W){var X=W.getParameter('selected');j.getItems().filter(function(Y){return Y.getVisible();}).forEach(function(Y){var Z=Y.data("item");Z.setSelected(X);});this._checkResetStatus();}.bind(this)});return U;};w.prototype._updateSelectAllCheckBoxState=function(){var i=false,j=this._filterDetailList.getItems(),k=[];if(!this._selectAllCheckBox){return;}if(j&&j.length!==0){k=j.filter(function(U){return U.getVisible();});}if(k.length!==0){this._selectAllCheckBox.setEnabled(true);i=k.every(function(U){return U.getSelected();});}else{this._selectAllCheckBox.setEnabled(false);}this._selectAllCheckBox.setSelected(i);};w.prototype._visibilityBySearchField=function(i){var j=this._filterSearchField.getValue(),k=this._getStringFilter(),U=k(j,i.getTitle());return U;};w.prototype._visibilityByToggleButton=function(i){var j=this._showOnlySelectedButton.getPressed()?i.getSelected():true;return j;};w.prototype._getFilterSearchField=function(i){var j=new S({liveChange:function(){this._setFilterDetailItemsVisibility(i);}.bind(this)});return j;};w.prototype._setFilterDetailItemsVisibility=function(i,j){i.getItems().forEach(function(k){k.setVisible(this._visibilityByToggleButton(k)&&(j||this._visibilityBySearchField(k)));}.bind(this));this._updateSelectAllCheckBoxState();};w.prototype._getShowOnlySelectedButton=function(){var i=this._oContentItem&&this._oFiltersSelectedOnly[this._oContentItem.getId()]?true:false,j=new c({icon:I.getIconURI("multi-select"),tooltip:this._rb.getText("SHOW_SELECTED_ONLY"),type:u.Transparent,pressed:i,press:function(){var k=this._showOnlySelectedButton.getPressed(),U=this._oContentItem.getId();if(k){this._oFiltersSelectedOnly[U]=true;}else{delete this._oFiltersSelectedOnly[U];}this._setFilterDetailItemsVisibility(this._filterDetailList);}.bind(this)});return j;};w.prototype._getStringFilter=function(){if(this._fnFilterSearchCallback){return this._fnFilterSearchCallback;}if(!this._oStringFilter||this._oStringFilter.sOperator!==this.getFilterSearchOperator()){this._oStringFilter=new J(this.getFilterSearchOperator());}return this._oStringFilter.filter.bind(this._oStringFilter);};w.prototype._updateListSelections=function(){this._updateListSelection(this._sortList,sap.ui.getCore().byId(this.getSelectedSortItem()));this._updateListSelection(this._sortOrderList,this.getSortDescending());this._updateListSelection(this._groupList,sap.ui.getCore().byId(this.getSelectedGroupItem()));this._updateListSelection(this._groupOrderList,this.getGroupDescending());this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));this._updateFilterCounters();};w.prototype._updateListSelection=function(j,k){var U,i=0,W;if(!j){return false;}U=j.getItems();j.removeSelections();for(;i<U.length;i++){W=U[i].isA("sap.m.GroupHeaderListItem");if(!W&&(U[i].data("item")===k||U[i].data("item")===null)){j.setSelectedItem(U[i],(k&&k.getSelected?k.getSelected():true));return true;}}return false;};w.prototype._updateFilterCounters=function(){var k=(this._filterList?this._filterList.getItems():[]),U,W,X=0,i=0,j;for(;i<k.length;i++){U=k[i].data("item");X=0;if(U){if(U instanceof sap.m.ViewSettingsCustomItem){X=U.getFilterCount();}else if(U instanceof sap.m.ViewSettingsFilterItem){X=0;W=U.getItems();for(j=0;j<W.length;j++){if(W[j].getSelected()){X++;}}}}k[i].setCounter(X);}};w.prototype._clearSelectedFilters=function(){var k=this.getFilterItems(),U,i=0,j;for(;i<k.length;i++){if(k[i]instanceof sap.m.ViewSettingsFilterItem){U=k[i].getItems();for(j=0;j<U.length;j++){U[j].setProperty('selected',false,true);}}k[i].setProperty('selected',false,true);}if(this._vContentPage===2&&this._getDialog().isOpen()){this._updateFilterCounters();}};w.prototype._clearPresetFilter=function(){if(this.getSelectedPresetFilterItem()){this.setSelectedPresetFilterItem(null);}};w.prototype._calculateNumberOfPages=function(){var i=0,j=!!this.getSortItems().length,k=!!this.getGroupItems().length,U=!!this.getPresetFilterItems().length,W=!!this.getFilterItems().length;if(j){i++;}if(U||W){i++;}if(k){i++;}this.getCustomTabs().forEach(function(X){if(!this._isEmptyTab(X)){i++;}},this);return i;};w.prototype._hasSubHeader=function(){return!(this._calculateNumberOfPages()<2);};function x(){this._vContentPage=2;this._oContentItem=null;this._navContainer.to(this._getPage1().getId(),"show");}function y(j,k){var i,U;for(i=0;i<j.length;i++){if(j[i].getKey()===k){U=j[i];break;}}return U;}function z(i,j,k){var U;if(typeof i==="string"){U=y(j,i);if(!U){o.error(k);}}else{U=i;}return U;}function A(i){return i&&i instanceof sap.m.ViewSettingsItem;}w.prototype._onConfirm=function(i){var j=this._getDialog(),k=this,U=function(){var W,X,Y=k.getSelectedGroupItem();if(!k._oGroupingNoneItem||Y!=k._oGroupingNoneItem.getId()){X=sap.ui.getCore().byId(Y);}k._toggleDialogTitle(k._sTitleLabelId);W={sortItem:sap.ui.getCore().byId(k.getSelectedSortItem()),sortDescending:k.getSortDescending(),groupItem:X,groupDescending:k.getGroupDescending(),presetFilterItem:sap.ui.getCore().byId(k.getSelectedPresetFilterItem()),filterItems:k.getSelectedFilterItems(),filterKeys:k.getSelectedFilterKeys(),filterCompoundKeys:k.getSelectedFilterCompoundKeys(),filterString:k.getSelectedFilterString()};k._dialog.detachAfterClose(U);k.fireConfirm(W);};j.attachAfterClose(U);j.close();};w.prototype._onCancel=function(i){var j=this,k=this._getDialog(),U=function(){j._toggleDialogTitle(j._sTitleLabelId);j.setSelectedSortItem(j._oPreviousState.sortItem);j.setSortDescending(j._oPreviousState.sortDescending);j.setSelectedGroupItem(j._oPreviousState.groupItem);j.setGroupDescending(j._oPreviousState.groupDescending);j.setSelectedPresetFilterItem(j._oPreviousState.presetFilterItem);j._clearSelectedFilters();j.setSelectedFilterCompoundKeys(j._oPreviousState.filterCompoundKeys);if(j._navContainer.getCurrentPage()!==j._oPreviousState.navPage){setTimeout(j._navContainer["to"].bind(j._navContainer,j._oPreviousState.navPage.getId(),"show"),0);}j._switchToPage(j._oPreviousState.contentPage,j._oPreviousState.contentItem);j._dialog.detachAfterClose(U);j.fireCancel();};k.attachAfterClose(U);k.close();};w.prototype.clearFilters=function(){this._clearSelectedFilters();this._clearPresetFilter();this.fireResetFilters();this._updateFilterCounters();if(this._vContentPage===3){setTimeout(this._getNavContainer()['to'].bind(this._getNavContainer(),this._getPage1().getId()),0);this._switchToPage(2);this._getSegmentedButton().setSelectedButton(this._getFilterButton());}this._updateListSelection(this._presetFilterList,sap.ui.getCore().byId(this.getSelectedPresetFilterItem()));return this;};w.prototype._addResetButtonToPage1=function(){var i=this._getHeader(),j=this._getSubHeader(),k=this._getResetButton();if(this._showSubHeader){if(!this._getPage1().getSubHeader()){this._getPage1().setSubHeader(j);}}else{if(this._getPage1().getSubHeader()){this._getPage1().setSubHeader();}}i.addContentRight(k);};w.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};function F(i,j){if(!this._getPage1(true)){return;}if(i==='customTabs'&&j){if(j.getMetadata().getName()===this.getMetadata().getManagedAggregation(i).type&&this._vContentPage===j.getId()){var k=this._getPage1().getContent();k.forEach(function(U){j.addAggregation('content',U,true);});}}else if(!i&&!j){var k=this._getPage1().getContent();this.getCustomTabs().forEach(function(j){if(this._vContentPage===j.getId()){k.forEach(function(U){j.addAggregation('content',U,true);});}},this);}}function H(){var i=[-1,0,1,2,3];return(this._getPage1().getContent().length&&i.indexOf(this._vContentPage)===-1);}w.prototype.setBusy=function(i){this._getDialog().setBusy(i);return this;};var J=function(i){this.sOperator=i||s.StartsWith;switch(this.sOperator){case s.Equals:this.fnOperator=K;break;case s.Contains:this.fnOperator=O;break;case s.StartsWith:this.fnOperator=Q;break;case s.AnyWordStartsWith:this.fnOperator=R;break;default:o.warning("Unknown string compare operator. Use values from sap.m.StringFilterOperator. Default operator should be used.");this.fnOperator=O;break;}};J.prototype.filter=function(i,j){if(!i){return true;}if(!j){return false;}j=j.toLowerCase();i=i.toLowerCase();return this.fnOperator(i,j);};function K(i,j){return j===i;}function O(i,j){return j.indexOf(i)>-1;}function Q(i,j){return j.indexOf(i)===0;}function R(i,j){var k=new RegExp(".*\\b"+i+".*");return k.test(j);}return w;});
