/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/m/ActionSheet","sap/ui/core/InvisibleText","./WizardProgressNavigatorRenderer","./Button","sap/ui/thirdparty/jquery"],function(l,C,R,I,D,A,a,W,B,q){"use strict";var b=C.extend("sap.m.WizardProgressNavigator",{metadata:{properties:{stepCount:{type:"int",group:"Data",defaultValue:3},stepTitles:{type:"string[]",group:"Appearance",defaultValue:[]},stepIcons:{type:"sap.ui.core.URI[]",group:"Appearance",defaultValue:[]},varyingStepCount:{type:"boolean",group:"Appearance",defaultValue:false}},events:{stepChanged:{parameters:{current:{type:"int"}}}}}});b.CONSTANTS={MINIMUM_STEPS:3,MAXIMUM_STEPS:8,MIN_STEP_WIDTH_NO_TITLE:64,MIN_STEP_WIDTH_WITH_TITLE:200};b.TEXT={STEP:"WIZARD_PROG_NAV_STEP_TITLE",OPTIONAL_STEP:"WIZARD_STEP_OPTIONAL_STEP_TEXT"};b.prototype.init=function(){this._iCurrentStep=1;this._iActiveStep=1;this._aCachedSteps=[];this._aStepOptionalIndication=[];this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oActionSheet=new A();this._createStepNavigation();};b.prototype.onBeforeRendering=function(){if(this.getStepCount()!==this.getStepIcons().filter(String).length){this.setStepIcons([]);}if(this.getStepCount()!==this.getStepTitles().filter(String).length){this.setStepTitles([]);}};b.prototype.onAfterRendering=function(){var $,z=this._iActiveStep-1,Z=this._iCurrentStep-1;this._cacheDOMElements();this._updateStepZIndex();this._updateStepNavigation(z);this._updateStepActiveAttribute(z);this._removeStepAriaDisabledAttribute(z);this._updateStepCurrentAttribute(Z);this._updateStepAriaCurrentAttribute(Z);this._updateOpenSteps();R.register(this.getDomRef(),this._updateOpenSteps.bind(this));if(D.os.name===D.os.OS.IOS){$=this.$().find(".sapMWizardProgressNavStep").css("display","block");setTimeout($["css"].bind($,"display",""),0);}};b.prototype.ontap=function(e){if(this._isGroupAtStart(e.target)){return this._showActionSheet(e.target,true);}if(this._isGroupAtEnd(e.target)){return this._showActionSheet(e.target,false);}if(!this._isOpenStep(e.target)||!this._isActiveStep(this._getStepNumber(e.target))){return;}this._updateCurrentStep(this._getStepNumber(e.target));this.fireStepChanged({current:this._getStepNumber(e.target)});};b.prototype.onsapspace=function(e){if(this._onEnter){this._onEnter(e,this._oStepNavigation.getFocusedIndex());}this.ontap(e);};b.prototype.onsapenter=b.prototype.onsapspace;b.prototype.exit=function(){R.deregisterAllForControl(this.getId());this.removeDelegate(this._oStepNavigation);this._oStepNavigation.destroy();this._oStepNavigation=null;if(this._oActionSheetInvisibleText){this._oActionSheetInvisibleText.destroy();this._oActionSheetInvisibleText=null;}this._oActionSheet.destroy();this._oActionSheet=null;this._iCurrentStep=null;this._iActiveStep=null;this._aCachedSteps=null;this._aStepOptionalIndication=null;};b.prototype.getCurrentStep=function(){return this._iCurrentStep;};b.prototype.getProgress=function(){return this._iActiveStep;};b.prototype.previousStep=function(){var c=this.getCurrentStep();if(c<2){return this;}return this._moveToStep(c-1);};b.prototype.nextStep=function(){return this._moveToStep(this.getCurrentStep()+1);};b.prototype.incrementProgress=function(){return this._moveToStep(this.getProgress()+1);};b.prototype.discardProgress=function(i){if(i<=0||i>this._iActiveStep){return this;}this._updateCurrentStep(i,this._iCurrentStep);this._updateStepActiveAttribute(i-1,this._iActiveStep-1);this._addStepAriaDisabledAttribute(i-1);this._updateStepNavigation(i-1);this._iCurrentStep=i;this._iActiveStep=i;};b.prototype._setOnEnter=function(c){this._onEnter=c;};b.prototype._createStepNavigation=function(){var t=this;this._oStepNavigation=new I();this._oStepNavigation.setCycling(false);this._oStepNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this._oStepNavigation.attachEvent("AfterFocus",function(p){var e=p.mParameters.oEvent;if(!e||!e.relatedTarget||q(e.relatedTarget).hasClass(W.CLASSES.STEP)){return;}t._oStepNavigation.focusItem(t._iCurrentStep-1);});this.addDelegate(this._oStepNavigation);};b.prototype._cacheDOMElements=function(){var d=this.getDomRef();this._aCachedSteps=d.querySelectorAll("."+W.CLASSES.STEP);};b.prototype._updateStepZIndex=function(){var z=this._iCurrentStep-1,s=this._aCachedSteps.length,Z=b.CONSTANTS.MAXIMUM_STEPS;for(var i=0;i<s;i++){if(i<=z){this._aCachedSteps[i].style.zIndex=0;}else{this._aCachedSteps[i].style.zIndex=Z;Z-=1;}}};b.prototype._updateStepNavigation=function(c){var n=this.getDomRef(),f=[];for(var i=0;i<=c;i++){if(this._aCachedSteps[i]){f.push(this._aCachedSteps[i]);}}this._oStepNavigation.setRootDomRef(n);this._oStepNavigation.setItemDomRefs(f);this._oStepNavigation.setPageSize(c);this._oStepNavigation.setFocusedIndex(c);};b.prototype._updateStepActiveAttribute=function(n,o){if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.ACTIVE_STEP);}if(this._aCachedSteps[n]){this._aCachedSteps[n].setAttribute(W.ATTRIBUTES.ACTIVE_STEP,true);}};b.prototype._updateStepCurrentAttribute=function(n,o){if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.CURRENT_STEP);}if(this._aCachedSteps[n]){this._aCachedSteps[n].setAttribute(W.ATTRIBUTES.CURRENT_STEP,true);}};b.prototype._addStepAriaDisabledAttribute=function(c){var s=this._aCachedSteps.length,S;for(var i=c+1;i<s;i++){S=this._aCachedSteps[i];S.setAttribute(W.ATTRIBUTES.ARIA_DISABLED,true);}};b.prototype._removeStepAriaDisabledAttribute=function(i){if(this._aCachedSteps[i]){this._aCachedSteps[i].removeAttribute(W.ATTRIBUTES.ARIA_DISABLED);}};b.prototype._updateStepAriaCurrentAttribute=function(n,o){var s=this._aCachedSteps[n];if(o!==undefined&&this._aCachedSteps[o]){this._aCachedSteps[o].removeAttribute(W.ATTRIBUTES.ARIA_CURRENT);}if(s){s.setAttribute(W.ATTRIBUTES.ARIA_CURRENT,true);}};b.prototype._updateStepAriaLabelAttribute=function(i){var s=this._aCachedSteps[i];var S=this._isActiveStep(i)?"ACTIVE":"INACTIVE";var c=this._aStepOptionalIndication[i]?this._oResourceBundle.getText("WIZARD_STEP_OPTIONAL_STEP_TEXT"):"";var v=this._oResourceBundle.getText("WIZARD_STEP_"+S+"_LABEL",[i+1,this.getStepTitles()[i],c]);if(s){s.setAttribute(W.ATTRIBUTES.ARIA_LABEL,v);}};b.prototype._moveToStep=function(n){var s=this.getStepCount(),o=this.getCurrentStep();if(n>s){return this;}if(n>this._iActiveStep){this._updateActiveStep(n);}return this._updateCurrentStep(n,o);};b.prototype._updateActiveStep=function(n,o){var z=n-1,Z=(o||this._iActiveStep)-1;this._iActiveStep=n;this._updateStepNavigation(z);this._removeStepAriaDisabledAttribute(z);this._updateStepActiveAttribute(z,Z);this._updateStepAriaLabelAttribute(z);};b.prototype._updateCurrentStep=function(n,o){var z=n-1,Z=(o||this.getCurrentStep())-1;this._iCurrentStep=n;this._updateStepZIndex();this._updateOpenSteps();this._updateStepCurrentAttribute(z,Z);this._updateStepAriaCurrentAttribute(z,Z);return this;};b.prototype._updateOpenSteps=function(){var w=this.$().width(),c=this._iCurrentStep-1,d=0,e=true,s=this.getStepTitles().length?Math.floor(w/b.CONSTANTS.MIN_STEP_WIDTH_WITH_TITLE):Math.floor(w/b.CONSTANTS.MIN_STEP_WIDTH_NO_TITLE);if(!this._aCachedSteps){return;}[].forEach.call(this._aCachedSteps,function(f){f.setAttribute(W.ATTRIBUTES.OPEN_STEP,false);f.setAttribute(W.ATTRIBUTES.OPEN_STEP_PREV,false);f.setAttribute(W.ATTRIBUTES.OPEN_STEP_NEXT,false);});if(this._aCachedSteps[c]){this._aCachedSteps[c].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);}for(var i=1;i<s;i++){if(e){d+=1;}if(e&&this._aCachedSteps[c+d]){this._aCachedSteps[c+d].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);e=!e;}else if(!e&&this._aCachedSteps[c-d]){this._aCachedSteps[c-d].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);e=!e;}else if(this._aCachedSteps[c+d+1]){d+=1;this._aCachedSteps[c+d].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);e=true;}else if(this._aCachedSteps[c-d]){this._aCachedSteps[c-d].setAttribute(W.ATTRIBUTES.OPEN_STEP,true);d+=1;e=false;}}for(i=0;i<this._aCachedSteps.length;i++){if(this._aCachedSteps[i].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="true"&&this._aCachedSteps[i-1]&&this._aCachedSteps[i-1].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="false"){this._aCachedSteps[i-1].setAttribute(W.ATTRIBUTES.OPEN_STEP_PREV,true);}if(this._aCachedSteps[i].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="false"&&this._aCachedSteps[i-1]&&this._aCachedSteps[i-1].getAttribute(W.ATTRIBUTES.OPEN_STEP)=="true"){this._aCachedSteps[i].setAttribute(W.ATTRIBUTES.OPEN_STEP_NEXT,true);break;}}};b.prototype._isGroupAtStart=function(d){var $=q(d).closest("."+W.CLASSES.STEP);var s=this._getStepNumber($);return $.attr(W.ATTRIBUTES.OPEN_STEP_PREV)==="true"&&s>1;};b.prototype._isGroupAtEnd=function(d){var $=q(d).closest("."+W.CLASSES.STEP);var s=this._getStepNumber($);return $.attr(W.ATTRIBUTES.OPEN_STEP_NEXT)==="true"&&s<this._aCachedSteps.length;};b.prototype._showActionSheet=function(d,c){var f=c?0:this._getStepNumber(d)-1;var t=c?this._getStepNumber(d):this._aCachedSteps.length;var s,S,e,T,o,g,h;this._oActionSheetInvisibleText=new a({text:this._oResourceBundle.getText("WIZARD_STEPS")}).toStatic();this._oActionSheet.removeAllButtons();for(var i=f;i<t;i++){s=this.getStepIcons()[i];S=(i+1)+".";o=this._aCachedSteps[i].querySelector(".sapMWizardProgressNavStepTitle");e=o&&o.textContent;T=S+" "+e;this._oActionSheet.addButton(new B({width:"200px",text:T,icon:s,enabled:this._iActiveStep>=(i+1),press:function(j){this._moveToStep(j);this.fireStepChanged({current:j});}.bind(this,i+1)}));}this._oActionSheet.openBy(d);h=this._oActionSheetInvisibleText.getId();g=this._oActionSheet.getParent();if(g&&g.getAriaLabelledBy().indexOf(h)===-1){g.addAriaLabelledBy(h);}};b.prototype._isOpenStep=function(d){var $=q(d).closest("."+W.CLASSES.STEP);return $.attr(W.ATTRIBUTES.OPEN_STEP)==="true"||($.attr(W.ATTRIBUTES.OPEN_STEP)==="false"&&$.attr(W.ATTRIBUTES.OPEN_STEP_PREV)==="true")||($.attr(W.ATTRIBUTES.OPEN_STEP)==="false"&&$.attr(W.ATTRIBUTES.OPEN_STEP_NEXT)==="true");};b.prototype._isActiveStep=function(s){return s<=this._iActiveStep;};b.prototype._getStepNumber=function(d){var $=q(d).closest("."+W.CLASSES.STEP).attr(W.ATTRIBUTES.STEP);return parseInt($);};return b;});
