/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PluginBase","sap/ui/core/Core","sap/ui/core/InvisibleText","sap/ui/Device","sap/m/ColumnPopoverActionItem","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Aria"],function(P,C,I,D,a,q){"use strict";var b=P.extend("sap.m.plugins.ColumnResizer",{metadata:{library:"sap.m",properties:{},events:{columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.core.Element"},width:{type:"sap.ui.core.CSSSize"}}}}}});var s={};var r=false;var c="sapMPluginsColumnResizer";var R=C.getConfiguration().getRTL();var B=R?"right":"left";var e=R?"left":"right";var d=R?-1:1;b.getPlugin=P.getPlugin;b.prototype.init=function(){this._iHoveredColumnIndex=-1;this._aPositions=[];this._oHandle=null;};b.prototype.onActivate=function(o){o.addEventDelegate(this,this);if(o.isActive()){this.onAfterRendering();}};b.prototype.onDeactivate=function(o){o.removeEventDelegate(this,this);this.onBeforeRendering();this._oHandle=null;};b.prototype.onBeforeRendering=function(){if(this._$Container){this._$Container.removeClass(c+"Container").off("."+c);this._$Container.find(this.getConfig("resizable")).removeClass(c+"Resizable");this._updateAriaDescribedBy("remove");}};b.prototype.onAfterRendering=function(){this._$Container=this.getControl().$(this.getConfig("container"));D.system.desktop&&this._$Container.on("mousemove."+c,this._onmousemove.bind(this));this._$Container.addClass(c+"Container").on("mouseleave."+c,this._onmouseleave.bind(this));this._aResizables=this._$Container.find(this.getConfig("resizable")).addClass(c+"Resizable").get();this._updateAriaDescribedBy("add");this._invalidatePositions();};b.prototype._updateAriaDescribedBy=function(A){this._aResizables.forEach(function(o){var f=q(o).control(0,true);var F=f&&f.getFocusDomRef();q(F)[A+"AriaDescribedBy"](I.getStaticId("sap.m","COLUMNRESIZER_RESIZABLE"));});};b.prototype.ontouchstart=function(E){if(this.getConfig("allowTouchResizing")&&q(E.target).closest(this._aResizables)[0]){this._onmousemove(E);}else if(this._iHoveredColumnIndex==-1&&this._oHandle&&this._oHandle.style[B]){this._onmousemove(E);if(this._iHoveredColumnIndex==-1){this._oHandle.style[B]="";this._oAlternateHandle.style[B]="";}}r=(this._iHoveredColumnIndex>-1);if(!r){return;}this._startResizeSession(this._iHoveredColumnIndex);s.iTouchStartX=E.targetTouches[0].clientX;s.fHandleX=parseFloat(this._oHandle.style[B]);this._$Container.addClass(c+"Resizing");q(document).on("touchend."+c+" mouseup."+c,this._ontouchend.bind(this));};b.prototype.ontouchmove=function(E){if(!r){return;}this._setSessionDistanceX((E.targetTouches[0].clientX-s.iTouchStartX));this._oHandle.style[B]=s.fHandleX+s.iDistanceX+"px";};b.prototype._onmousemove=function(E){if(r){return;}this._setPositions();var i=E.targetTouches?E.targetTouches[0].clientX:E.clientX;var h=this._getHoveredColumnIndex(i);this._displayHandle(h);};b.prototype._onmouseleave=function(){this._invalidatePositions();};b.prototype._ontouchend=function(){this._setColumnWidth();this._cancelResizing(true);};b.prototype.onsapescape=function(){if(r){this._cancelResizing();}};b.prototype.onsaprightmodifiers=function(E){this._onLeftRightModifiersKeyDown(E,16);};b.prototype.onsapleftmodifiers=function(E){this._onLeftRightModifiersKeyDown(E,-16);};b.prototype.ondblclick=function(E){var i=E.clientX,h=this._getHoveredColumnIndex(i);if(h==-1){return;}this._startResizeSession(h);this._setSessionDistanceX(this._calculateAutoColumnDistanceX());this._setColumnWidth();this._endResizeSession();};b.prototype._getHoveredColumnIndex=function(i){return this._aPositions.findIndex(function(p){return Math.abs(p-i)<=(this._oAlternateHandle||window.matchMedia("(hover:none)").matches?20:3);},this);};b.prototype._calculateAutoColumnDistanceX=function(){var $=this.getConfig("columnRelatedCells",this._$Container,s.oCurrentColumn.getId());if(!$||!$.length){return;}var h=q("<div></div>").addClass(c+"SizeDetector").addClass(this.getConfig("cellPaddingStyleClass"));var f=$.children().clone().removeAttr("id");this._$Container.append(h);var w=Math.round(h.append(f)[0].getBoundingClientRect().width);var i=w-s.fCurrentColumnWidth;h.remove();return i;};b.prototype._invalidatePositions=function(){window.setTimeout(function(){this._bPositionsInvalid=true;}.bind(this));};b.prototype._displayHandle=function(i,m){if(this._iHoveredColumnIndex==i){return;}if(!this._oHandle){this._oHandle=document.createElement("div");this._oHandle.className=c+"Handle";if(m||window.matchMedia("(hover:none)").matches){var o=document.createElement("div");o.className=c+"HandleCircle";o.style.top=this._aResizables[i].offsetHeight-8+"px";this._oHandle.appendChild(o);this._oAlternateHandle=this._oHandle.cloneNode(true);}}if(this._$Container[0]!==this._oHandle.parentNode){this._$Container.append(this._oHandle);if(m){this._$Container.append(this._oAlternateHandle);}}this._oHandle.style[B]=(i>-1)?(this._aPositions[i]-this._fContainerX)*d+"px":"";if(m){this._oAlternateHandle.style[B]=(--i>-1)?(this._aPositions[i]-this._fContainerX)*d+"px":"";}else{if(this._oAlternateHandle){this._oAlternateHandle.style[B]="";}this._iHoveredColumnIndex=i;}};b.prototype._cancelResizing=function(f){this._$Container.removeClass(c+"Resizing");if(s.iDistanceX||!f){this._oHandle.style[B]="";}else{setTimeout(function(){this._oHandle.style[B]="";}.bind(this),300);}this._iHoveredColumnIndex=-1;q(document).off("."+c);this._endResizeSession();r=false;};b.prototype._getColumnMinWidth=function(o){return o?48:0;};b.prototype._startResizeSession=function(i){s.$CurrentColumn=q(this._aResizables[i]);s.oCurrentColumn=s.$CurrentColumn.control(0,true);s.fCurrentColumnWidth=s.$CurrentColumn.width();s.iMaxDecrease=this._getColumnMinWidth(s.oCurrentColumn)-s.fCurrentColumnWidth;s.iEmptySpace=this.getConfig("emptySpace",this.getControl());if(s.iEmptySpace!=-1){s.$NextColumn=q(this._aResizables[i+1]);s.oNextColumn=s.$NextColumn.control(0,true);s.fNextColumnWidth=s.$NextColumn.width()||0;s.iMaxIncrease=s.iEmptySpace+s.fNextColumnWidth-this._getColumnMinWidth(s.oNextColumn);}else{s.iMaxIncrease=window.innerWidth;}};b.prototype._setSessionDistanceX=function(i){s.iDistanceX=((i>0)?Math.min(i,s.iMaxIncrease):Math.max(i,s.iMaxDecrease))*d;};b.prototype._setColumnWidth=function(){if(!s.iDistanceX){return;}var w=s.fCurrentColumnWidth+s.iDistanceX+"px";if(!this._fireColumnResize(s.oCurrentColumn,w)){return;}s.oCurrentColumn.setWidth(w);if(s.oNextColumn&&(s.iEmptySpace<3||s.iDistanceX>s.iEmptySpace)){w=s.fNextColumnWidth-s.iDistanceX+s.iEmptySpace+"px";if(this._fireColumnResize(s.oNextColumn,w)){s.oNextColumn.setWidth(w);}}this.getConfig("fixAutoWidthColumns")&&this._aResizables.forEach(function(o){var $=q(o),f=$.control(0,true),w=f.getWidth();if(w&&w.toLowerCase()!="auto"){return;}w=$.css("width");if(w&&this._fireColumnResize(f,w)){f.setWidth(w);}},this);};b.prototype._fireColumnResize=function(o,w){return this.fireColumnResize({column:o,width:w});};b.prototype._onLeftRightModifiersKeyDown=function(E,i){if(!E.shiftKey||E.ctrlKey||E.metaKey||E.altKey||b.detectTextSelection(E.target)){return;}var o=q(E.target).closest(this._aResizables)[0],f=this._aResizables.indexOf(o);if(f===-1){return;}this._startResizeSession(f);this._setSessionDistanceX(i);this._setColumnWidth();this._endResizeSession();};b.detectTextSelection=function(o){var S=window.getSelection(),t=S.toString().replace("/n","");return t&&q.contains(o,S.focusNode);};b.prototype._endResizeSession=function(){s={};};b.prototype._setPositions=function(){if(!this._bPositionsInvalid){return this._aPositions;}this._bPositionsInvalid=false;this._fContainerX=this._$Container[0].getBoundingClientRect()[B];this._aPositions=this._aResizables.map(function(o,i,p){return o.getBoundingClientRect()[e]-(++i==p.length?1.25*d:0);},this);};b.prototype.startResizing=function(o){var i=this._aResizables.indexOf(o);this._setPositions();this._displayHandle(i,true);};b.prototype.getColumnResizeButton=function(o){if(!o||!window.matchMedia("(hover:none)").matches){return;}return new a({text:C.getLibraryResourceBundle("sap.m").getText("COLUMNRESIZER_RESIZE_BUTTON"),icon:"sap-icon://resize-horizontal",press:this.startResizing.bind(this,o.getDomRef())});};P.setConfigs({"sap.m.Table":{container:"listUl",resizable:".sapMListTblHeaderCell:not([aria-hidden=true])",focusable:".sapMColumnHeaderFocusable",cellPaddingStyleClass:"sapMListTblCell",fixAutoWidthColumns:true,onActivate:function(t){this._vOrigFixedLayout=t.getFixedLayout();if(!t.bActiveHeaders){t.bFocusableHeaders=true;this.allowTouchResizing=window.matchMedia("(hover:none)").matches;}t.setFixedLayout("Strict");},onDeactivate:function(t){t.bFocusableHeaders=false;t.setFixedLayout(this._vOrigFixedLayout);if(this._vOrigFixedLayout=="Strict"){t.rerender();}delete this._vOrigFixedLayout;delete this.allowTouchResizing;},emptySpace:function(t){var o=t.getDomRef("tblHeadDummyCell");return o?o.clientWidth:0;},columnRelatedCells:function($,f){return $.find(".sapMListTblCell[data-sap-ui-column='"+f+"']");}}},b);return b;});
