/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/ResponsivePopover","sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/library","sap/ui/core/Control","sap/ui/core/Core","sap/ui/thirdparty/jquery","sap/base/strings/capitalize","sap/m/p13n/AbstractContainerItem","sap/m/p13n/Container","sap/m/table/ColumnMenuRenderer"],function(R,B,T,a,l,C,b,q,c,A,d,e){"use strict";var f=C.extend("sap.m.table.ColumnMenu",{metadata:{library:"sap.m",interfaces:["sap.ui.core.IColumnHeaderMenu"],aggregations:{quickActions:{type:"sap.m.table.QuickActionBase"},items:{type:"sap.m.table.ItemBase"},_quickActions:{type:"sap.m.table.QuickActionBase",visibility:"hidden"},_items:{type:"sap.m.table.ItemBase",visibility:"hidden"}}}});var D="$default";var g=sap.ui.core.aria.HasPopup.Dialog;f.prototype.applySettings=function(s){if(s){this._addAllToPrivateAggregation(s,"_quickActions");this._addAllToPrivateAggregation(s,"_items");}C.prototype.applySettings.apply(this,arguments);};f.prototype.openBy=function(o){if(!this.getParent()){b.getUIArea(b.getStaticAreaRef()).addContent(this,true);}this._initPopover();if(!this._oItemsContainer){this._initItemsContainer();}this._oPopover.openBy(o);};f.prototype.getAriaHasPopupType=function(){return g;};f.prototype.close=function(){this._previousView=null;if(this._oPopover){this._oPopover.close();}};f.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._oPopover){delete this._oPopover;}if(this._oItemsContainer){delete this._oItemsContainer;}};f.prototype._addAllToPrivateAggregation=function(s,i){if(s[i]){s[i].forEach(function(I){this.addAggregation(i,I);}.bind(this));delete s[i];}};f.prototype._initPopover=function(){if(this._oPopover){return;}this._oPopover=new R({showArrow:false,showHeader:false,placement:l.PlacementType.Bottom,content:new h({control:this,height:true}),contentWidth:"500px",horizontalScrolling:false,verticalScrolling:false,afterClose:[this.close,this]});this.addDependent(this._oPopover);this._oPopover.addEventDelegate({"onAfterRendering":this._focusItem},this);if(this.getItems().length==0&&!this.getAggregation("_items")){this._oPopover.attachAfterOpen(this._focusInitialQuickAction.bind(this));}};f.prototype._initItemsContainer=function(){var i=(this.getAggregation("_items")||[]).reduce(function(I,o){return I.concat(o.getEffectiveItems());},[]);var j=this.getItems().reduce(function(I,o){return I.concat(o.getEffectiveItems());},[]);if(!this._oItemsContainer){this._createItemsContainer();}i.forEach(function(o,I){this._addView(o);I==0&&this._oItemsContainer.addSeparator();}.bind(this));j.forEach(function(o,I){this._addView(o);I==0&&this._oItemsContainer.addSeparator();}.bind(this));};var h=C.extend("sap.m.table.AssociativeControl",{metadata:{"final":true,properties:{height:{type:"boolean",defaultValue:false}},associations:{control:{type:"sap.ui.core.Control"}}},renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);o.getHeight()&&r.style("height","100%");r.openEnd();r.renderControl(sap.ui.getCore().byId(o.getControl()));r.close("div");}}});f.prototype._addView=function(o){var i=new A({content:new h({control:o.getContent(),height:true}),key:o.getId(),text:o.getLabel(),icon:o.getIcon()});this._oItemsContainer.addView(i);this._setItemVisibility(o,o.getVisible());};f.prototype._createItemsContainer=function(){var o=this;this._oBtnCancel=new B({text:this._getResourceText("table.COLUMNMENU_CANCEL"),press:function(){var k=o._oItemsContainer.getCurrentViewKey();if(o._fireEvent(b.byId(k),"cancel")){o.close();o.exit();}}});this._oBtnOk=new B({text:this._getResourceText("table.COLUMNMENU_CONFIRM"),press:function(){var k=o._oItemsContainer.getCurrentViewKey();if(o._fireEvent(b.byId(k),"confirm")){o.close();}}});o._oItemsContainer=new d({listLayout:true,defaultView:D,footer:new T({content:[new a(),this._oBtnOk,this._oBtnCancel]}),beforeViewSwitch:function(E){var p=E.getParameters();if(p.target!=="$default"){var i=o._oItemsContainer.getView(p.target);var j=o._getItemFromContainerItem(i);if(j&&j.firePress&&!o._fireEvent(j,"press")){E.preventDefault();return;}}},afterViewSwitch:function(E){var p=E.getParameters();this.oLayout.setShowFooter(p.target!=="$default");o._previousView=p.source;if(p.target!=="$default"){var i=o._oItemsContainer.getView(p.target);if(i){var I=o._getItemFromContainerItem(i);o._updateButtonState(I);}else{var i=o._oItemsContainer.getView(p.target);var I=o._getItemFromContainerItem(i);I&&I.focus();this._oPopover&&this._oPopover.invalidate();}}}});o._oItemsContainer.getHeader().addContentRight(new B({text:this._getResourceText("table.COLUMNMENU_RESET"),press:function(){o._fireEvent(b.byId(o._oItemsContainer.getCurrentViewKey()),"reset",false);}}));this._oPopover.addDependent(o._oItemsContainer);o.addDependent(o._oItemsContainer);};f.prototype._fireEvent=function(o,E,i){var H=o["on"+c(E)];if(i!==false){var j=q.Event(E);H.call(o,j);return!j.isDefaultPrevented();}else{H.call(o);return true;}};f.prototype._getResourceText=function(t,v){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.m");return t?this.oResourceBundle.getText(t,v):this.oResourceBundle;};f.prototype._getItemFromContainerItem=function(o){var i=this.getAggregation("_items")&&this.getAggregation("_items").find(function(j){return j.getId()==o.getKey();});if(!i){i=this.getAggregation("items")&&this.getAggregation("items").find(function(j){return j.getId()==o.getKey();});}return i;};f.prototype._updateButtonState=function(i){this._oItemsContainer.getHeader().getContentRight()[0].setEnabled(i.getButtonSettings()["reset"]["enabled"]);this._oItemsContainer.getHeader().getContentRight()[0].setVisible(i.getButtonSettings()["reset"]["visible"]);this._oBtnOk.setVisible(i.getButtonSettings()["confirm"]["visible"]);this._oBtnCancel.setVisible(i.getButtonSettings()["cancel"]["visible"]);};f.prototype._focusItem=function(){if(this._previousView==D){this._oItemsContainer._getNavBackBtn().focus();}else{var i=this._oItemsContainer._getNavigationList().getItems().find(function(i){return i.getVisible()&&i._key===this._previousView;}.bind(this));i&&i.focus();}};f.prototype._focusInitialQuickAction=function(){if(this.getItems().length==0&&!this.getAggregation("_items")){var Q=[];if(this.getAggregation("_quickActions")){Q=this.getAggregation("_quickActions")[0].getEffectiveQuickActions();}else if(this.getQuickActions().length>0){Q=this.getQuickActions()[0].getEffectiveQuickActions();}Q.length>0&&Q[0].getContent().focus();}};f.prototype._setItemVisibility=function(i,v){var L=this._oItemsContainer._getNavigationList().getItems();var o=L.find(function(o){return o._key==i.getId();});o&&o.setVisible(v);};return f;});
