/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.base.Interface
sap.ui.define(['sap/ui/base/Object'], function(BaseObject) {
	"use strict";

	/**
	 * Constructs a facade for the given object, containing only the named methods.
	 *
	 * For each method named in <code>aMethods</code>, a wrapper function will be added to the facade.
	 * When called, the wrapper function calls the method with the same name in the original <code>oObject</code>,
	 * passing all its call parameters to it without modification. A return value of the original method will
	 * be returned to the caller. Before returning it, values of type <code>sap.ui.base.Object</code> will be
	 * replaced by their facades, calling {@link sap.ui.base.Object#getInterface getInterface} on them.
	 *
	 * It is possible to create different facades exposing different sets of methods for the same object,
	 * but as <code>getInterface</code> can only return one of those interfaces, the special handling of the
	 * return values doesn't support multiple facades per object.
	 *
	 *
	 * @class A class whose instances act as a facade for other objects.
	 *
	 * <b>Note:</b> If a class returns a facade in its constructor, only the defined functions will be visible,
	 * no internals of the class can be accessed.
	 *
	 * @author Malte Wedel, Daniel Brinkmann
	 * @version 1.98.0
	 * @param {sap.ui.base.Object} oObject
	 *   Object for which a facade should be created
	 * @param {string[]} aMethods
	 *   Names of the methods, that should be available in the new facade
	 * @public
	 * @alias sap.ui.base.Interface
	 */
	var Interface = BaseObject._Interface;

	return Interface;

}, /* bExport= */ true);
