/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','./Object','../model/BindingMode','../model/StaticBinding','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ParseException','../model/Type','../model/ValidateException',"sap/ui/base/SyncPromise","sap/ui/util/ActivityDetection","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/base/util/extend","sap/base/util/isEmptyObject"],function(B,D,E,M,c,d,S,C,e,F,P,T,V,f,A,O,L,g,h,j,u,k,m){"use strict";var I;var o=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,s,a){var t=this;E.call(this);if(typeof i!=='string'&&i!==undefined){a=s;s=i;i=s&&s.id;}if(!i){i=this.getMetadata().uid();}else{var b=o._fnIdPreprocessor;i=(b?b.call(this,i):i);var l=I||(I=D.getType("sap.ui.core.ID"));if(!l.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=o._oEmptyPropagatedProperties;this.mSkipPropagation={};this._bIsOwnerActive=true;this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=o._defaultContextualSettings;this._sOwnerId=o._sOwnerId;(function(){var n=false;if(t.register){t.register();}try{if(t._initCompositeSupport){t._initCompositeSupport(s);}if(t.init){t.init();}t.applySettings(s,a);n=true;}finally{if(!n&&t.deregister){t.deregister();}}}());}},M);var U=Symbol("ui5object");o.create=function(v,K,s){if(!v||v instanceof o||typeof v!=="object"||v instanceof String){return v;}function a(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return O.get(t);}}var b=a(v.Type)||a(K&&K.type);if(typeof b==="function"){return new b(v,s);}var i="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";L.fatal(i);throw new Error(i);};o._fnIdPreprocessor=null;o._fnSettingsPreprocessor=null;o.runWithPreprocessors=function(a,b,t){g(typeof a==="function","fn must be a function");g(!b||typeof b==="object","oPreprocessors must be an object");var i={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};b=b||{};this._fnIdPreprocessor=b.id;this._fnSettingsPreprocessor=b.settings;try{return a.call(t);}finally{this._fnIdPreprocessor=i.id;this._fnSettingsPreprocessor=i.settings;}};o.prototype.applySettings=function(s,a){if(!s||m(s)){return this;}var t=this,b=this.getMetadata(),v=b.getJSONKeys(),n=o.create,r=o._fnSettingsPreprocessor,K,w,x;function y(J){for(var i=0,N=J.length;i<N;i++){var Q=J[i];if(Array.isArray(Q)){y(Q);}else{t[x._sMutator](n(Q,x,a));}}}function z(J){t[x._sMutator](J[0],J[1],J[2]);}function G(J){var N=D.getType(J),Q=N&&N.getPrimitiveType().getName();return Q==="object"||Q==="any";}r&&r.call(this,s);if(s.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(s.metadataContexts,s);}if(s.models){if(typeof s.models!=="object"){throw new Error("models must be a simple object");}if(c.isA(s.models,"sap.ui.model.Model")){this.setModel(s.models);}else{for(K in s.models){this.setModel(s.models[K],K==="undefined"?undefined:K);}}}if(s.bindingContexts){if(typeof s.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(s.bindingContexts instanceof e){this.setBindingContext(s.bindingContexts);}else{for(K in s.bindingContexts){this.setBindingContext(s.bindingContexts[K],K==="undefined"?undefined:K);}}}if(s.objectBindings){if(typeof s.objectBindings!=="string"&&typeof s.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof s.objectBindings==="string"||s.objectBindings.path){this.bindObject(s.objectBindings);}else{for(K in s.objectBindings){s.objectBindings[K].model=K==="undefined"?undefined:K;this.bindObject(s.objectBindings[K]);}}}for(K in s){w=s[K];if((x=v[K])!==undefined){var H;switch(x._iKind){case 0:H=this.extractBindingInfo(w,a,!G(x.type));if(H&&typeof H==="object"){this.bindProperty(K,H);}else{this[x._sMutator](typeof H==="string"?H:w);}break;case 1:H=x.altTypes&&this.extractBindingInfo(w,a,!x.altTypes.some(G));if(H&&typeof H==="object"){this.bindProperty(K,H);}else{if(Array.isArray(w)){if(w.length>1){L.error("Tried to add an array of controls to a single aggregation");}w=w[0];}this[x._sMutator](n(typeof H==="string"?H:w,x,a));}break;case 2:H=this.extractBindingInfo(w,a);if(H&&typeof H==="object"){this.bindAggregation(K,H);}else{w=typeof H==="string"?H:w;if(w){if(Array.isArray(w)){y(w);}else{t[x._sMutator](n(w,x,a));}}}break;case 3:this[x._sMutator](w);break;case 4:if(w){if(Array.isArray(w)){for(var i=0,l=w.length;i<l;i++){this[x._sMutator](w[i]);}}else{this[x._sMutator](w);}}break;case 5:if(typeof w=="function"){this[x._sMutator](w);}else if(Array.isArray(w[0])&&(w.length<=1||Array.isArray(w[1]))){w.forEach(z);}else{z(w);}break;case-1:break;default:break;}}else{g(false,"ManagedObject.apply: encountered unknown setting '"+K+"' for class '"+b.getName()+"' (value:'"+w+"')");}}return this;};o.escapeSettingsValue=function(v){return(typeof v==="string")?o.bindingParser.escape(v):v;};o.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};o.prototype.getId=function(){return this.sId;};o.prototype.setProperty=function(s,v,b){var a=this.mProperties[s];v=this.validateProperty(s,v);if(j(a,v)){this.mProperties[s]=v;return this;}if(b){A.refresh();}this.mProperties[s]=v;if(!b&&!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(s,v,a);v=this.mProperties[s];if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":s,"oldValue":a,"newValue":v});}if(this._observer){this._observer.propertyChange(this,s,a,v);}return this;};o.prototype.getProperty=function(s){var v=this.mProperties[s],a=this.getMetadata().getManagedProperty(s),t;if(!a){throw new Error("Property \""+s+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}if(a.byValue){v=h(v);}return v;};o.prototype.validateProperty=function(s,v){var a=this.getMetadata().getManagedProperty(s),t;if(!a){throw new Error("Property \""+s+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=a.getDefaultValue();}else if(t instanceof D){if(t.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(t.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+s+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \""+s+"\" of "+this);}}if(a.byValue){v=h(v);}if(t&&t.normalize&&typeof t.normalize==="function"){v=t.normalize(v);}return v;};o.prototype.isPropertyInitial=function(s){return!Object.prototype.hasOwnProperty.call(this.mProperties,s)&&!this.isBound(s);};o.prototype.resetProperty=function(s){if(this.mProperties.hasOwnProperty(s)){var a=this.getMetadata().getManagedProperty(s);a.set(this,null);if(this.mProperties[s]===a.getDefaultValue()){delete this.mProperties[s];}}return this;};o.prototype.getOriginInfo=function(s){var v=this.mProperties[s];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};o.prototype.setAssociation=function(a,i,s){if(i instanceof o){i=i.getId();}else if(i!=null&&typeof i!=="string"){g(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this;}if(this.mAssociations[a]===i){return this;}if(s){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};o.prototype.getAssociation=function(a,b){var r=this.mAssociations[a];if(!r){r=this.mAssociations[a]=b||null;}else{if(typeof r.length==='number'&&!(r.propertyIsEnumerable('length'))){return r.slice();}return r;}return r;};o.prototype.addAssociation=function(a,i,s){if(i instanceof o){i=i.getId();}else if(typeof i!=="string"){g(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this;}if(s){this.iSuppressInvalidate++;}var b=this.mAssociations[a];if(!b){b=this.mAssociations[a]=[i];}else{b.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};o.prototype.removeAssociation=function(a,v,s){var b=this.mAssociations[a];var l=null;if(!b){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(v)=="object"&&v.getId){v=v.getId();}if(typeof(v)=="string"){for(var i=0;i<b.length;i++){if(b[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=b.length){L.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+v);}else{l=b[v];b.splice(v,1);if(this._observer){this._observer.associationChange(this,a,"remove",l);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return l;};o.prototype.removeAllAssociation=function(a,s){var i=this.mAssociations[a];if(!i){return[];}delete this.mAssociations[a];if(!i.length){return i;}if(s){this.iSuppressInvalidate++;}if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return i;};o.prototype.validateAggregation=function(a,b,l,n){var r=this.getMetadata(),s=r.getManagedAggregation(a),t,v,i,w;if(!s){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(s.multiple!==l){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(s.multiple?"0..n":"0..1")+")");}var x=r.getAggregationForwarder(a);if(x&&!n){x.getTarget(this).validateAggregation(x.targetAggregationName,b,l);}if(!s.multiple&&!b){return b;}if(b instanceof c&&b.isA(s.type)){return b;}t=s.altTypes;if(t&&t.length){if(b==null){return b;}for(i=0;i<t.length;i++){v=D.getType(t[i]);if(v instanceof D){if(v.isValid(b)){return b;}}}}v=O.get(s.type);if(typeof v==="function"&&b instanceof v){return b;}w="\""+b+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(s.type)){g(false,w);return b;}else{throw new Error(w);}};o.prototype.setAggregation=function(a,b,s){var i=this.getMetadata().getAggregationForwarder(a);if(i){b=this.validateAggregation(a,b,false,true);return i.set(this,b);}var l=this.mAggregations[a];if(l===b){return this;}b=this.validateAggregation(a,b,false);if(s){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(l instanceof o){l.setParent(null);}else{if(this._observer!=null&&l!=null){this._observer.aggregationChange(this,a,"remove",l);}}this.mAggregations[a]=b;if(b instanceof o){b.setParent(this,a,s);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&b!=null){this._observer.aggregationChange(this,a,"insert",b);}}if(s){this.iSuppressInvalidate--;}return this;};o.prototype.getAggregation=function(a,b){var i=this.getMetadata().getAggregationForwarder(a);if(i){return i.get(this);}var l=this.mAggregations[a];if(!l){l=this.mAggregations[a]=b||null;}if(l){if(typeof l.length==='number'&&!(l.propertyIsEnumerable('length'))){return l.slice();}return l;}else{return null;}};o.prototype.indexOfAggregation=function(a,b){var l=this.getMetadata().getAggregationForwarder(a);if(l){return l.indexOf(this,b);}var n=this.mAggregations[a];if(n){if(n.length==undefined){return-2;}for(var i=0;i<n.length;i++){if(n[i]==b){return i;}}}return-1;};o.prototype.insertAggregation=function(a,b,l,s){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var n=this.getMetadata().getAggregationForwarder(a);if(n){return n.insert(this,b,l);}var r=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(l<0){i=0;}else if(l>r.length){i=r.length;}else{i=l;}if(i!==l){L.warning("ManagedObject.insertAggregation: index '"+l+"' out of range [0,"+r.length+"], forced to "+i);}r.splice(i,0,b);b.setParent(this,a,s);return this;};o.prototype.addAggregation=function(a,b,s){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var i=this.getMetadata().getAggregationForwarder(a);if(i){return i.add(this,b);}var l=this.mAggregations[a];if(!l){l=this.mAggregations[a]=[b];}else{l.push(b);}b.setParent(this,a,s);return this;};o.prototype.removeAggregation=function(a,v,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.remove(this,v);}var l=this.mAggregations[a],n=null,i;if(!l){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(v)=="string"){for(i=0;i<l.length;i++){if(l[i]&&l[i].getId()===v){v=i;break;}}}if(typeof(v)=="object"){for(i=0;i<l.length;i++){if(l[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=l.length){L.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+v);}else{n=l[v];l.splice(v,1);n.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return n;};o.prototype.removeAllAggregation=function(a,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.removeAll(this);}var l=this.mAggregations[a];if(!l){return[];}delete this.mAggregations[a];if(!l.length){return l;}if(s){this.iSuppressInvalidate++;}for(var i=0;i<l.length;i++){l[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return l;};o.prototype.destroyAggregation=function(a,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.destroy(this);}var l=this.mAggregations[a],i,n;if(!l){return this;}delete this.mAggregations[a];if(Array.isArray(l)&&!l.length){return this;}if(s){this.iSuppressInvalidate++;}if(l instanceof o){l.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",l);}}else if(Array.isArray(l)){for(i=l.length-1;i>=0;i--){n=l[i];if(n){n.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",n);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};o.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};o.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof o){i=i||this.oParent.isInvalidateSuppressed();}return i;};o.prototype._removeChild=function(a,s,b){if(!s){L.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(b){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(s,a);var l=this.getMetadata().getAggregation(s);if(i==-2){if(l&&this[l._sMutator]){this[l._sMutator](null);}else{this.setAggregation(s,null,b);}}else if(i>-1){if(l&&this[l._sRemoveMutator]){this[l._sRemoveMutator](i);}else{this.removeAggregation(s,i,b);}}if(b){this.iSuppressInvalidate--;}}};function p(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}o.prototype.setParent=function(a,s,b){g(a==null||a instanceof o,"oParent either must be null, undefined or a ManagedObject");var i;if(!a){if(this.oParent){i=this._observer||this.oParent._observer;if(i){i.parentChange(this,this.sParentAggregationName,"unset",this.oParent);}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos;}}this.oParent=null;this.sParentAggregationName=null;var l=o._oEmptyPropagatedProperties;if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this));}}this._oContextualSettings=o._defaultContextualSettings;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this));}A.refresh();return;}if(p(a,this)){throw new Error("Cycle detected: new parent '"+a+"' is already a descendant of (or equal to) '"+this+"'");}if(b){A.refresh();this.iSuppressInvalidate++;}var n=this.getParent();if(n){n._removeChild(this,this.sParentAggregationName);}this.oParent=a;this.sParentAggregationName=s;if(!a.mSkipPropagation[s]){var l=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():a._getPropertiesToPropagate();if(l!==this.oPropagatedProperties){this.oPropagatedProperties=l;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}}this._applyContextualSettings(a._oContextualSettings);if(a&&!this.isInvalidateSuppressed()){a.invalidate(this);}if(b){this.iSuppressInvalidate--;}i=this._observer||this.oParent._observer;if(i){i.parentChange(this,s,"set",this.oParent);}return this;};o.prototype._applyContextualSettings=function(a){a=a||o._defaultContextualSettings;if(this._oContextualSettings!==a){this._oContextualSettings=a;this._propagateContextualSettings();if(this._bIsOwnerActive){this._onContextualSettingsChanged();}}};o.prototype._onContextualSettingsChanged=function(){};o.prototype._propagateContextualSettings=function(){var s=this._oContextualSettings,a,b,i;for(a in this.mAggregations){b=this.mAggregations[a];if(b instanceof o){b._applyContextualSettings(s);}else if(b instanceof Array){for(i=0;i<b.length;i++){if(b[i]instanceof o){b[i]._applyContextualSettings(s);}}}}};o.prototype._getContextualSettings=function(){return this._oContextualSettings;};o.prototype.getParent=function(){return this.oParent;};o.prototype.destroy=function(s){var n;if(this.bIsDestroyed){return;}var t=this;this._bIsBeingDestroyed=true;if(s){this.iSuppressInvalidate++;}for(n in this.mBindingInfos){if(this.mBindingInfos[n].factory){this._detachAggregationBindingHandlers(n);}else{this._detachPropertyBindingHandlers(n);}}for(n in this.mObjectBindingInfos){this._detachObjectBindingHandlers(n);}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var a in this.mAggregations){this.destroyAggregation(a,s);}if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,s);}delete this.oParent;for(n in this.mBindingInfos){if(this.mBindingInfos[n].factory){this.unbindAggregation(n,true);}else{this.unbindProperty(n,true);}}for(n in this.mObjectBindingInfos){this.unbindObject(n,true);}if(s){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}if(this.aAPIParentInfos){this.aAPIParentInfos=null;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+t.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};o.bindingParser=B.simpleParser;o.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};o.prototype.extractBindingInfo=function(v,s,b){if(v&&typeof v==="object"){if(v.Type){return undefined;}else if(v[U]){delete v[U];}else if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts||(b&&v.value!=undefined)){if(v.template){v.template=o.create(v.template);}return v;}}if(typeof v==="string"){return o.bindingParser(v,s,true);}};o.prototype.getBindingInfo=function(n){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){return a.getTarget(this).getBindingInfo(a.targetAggregationName);}return this.mBindingInfos[n];};o.prototype.bindObject=function(b){var s,a,i;if(typeof b=="string"){a=b;b={path:a,parameters:arguments[1]};}else{a=b.path;}i=a.indexOf(">");if(i>0){b.model=a.substr(0,i);b.path=a.substr(i+1);}s=b.model;if(this.mObjectBindingInfos[s]){this.unbindObject(s,true);}this.mObjectBindingInfos[s]=b;if(this.getModel(s)){this._bindObject(b);}return this;};o.prototype._bindObject=function(b){var a,i,s,l,t=this;var n=function(v){t.setElementBindingContext(a.getBoundContext(),s);};var r=function(v){var w=a.getDataState();if(!w){return;}if(t.refreshDataState){t.refreshDataState('',w);}};s=b.model;l=this.getModel(s);i=this.getBindingContext(s);a=l.bindContext(b.path,i,b.parameters);if(b.suspended){a.suspend(true);}a.attachChange(n);b.binding=a;b.modelChangeHandler=n;b.dataStateChangeHandler=r;a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(r);}a.initialize();};o.prototype._detachObjectBindingHandlers=function(s){var b=this.mObjectBindingInfos[s];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}}}};o.prototype.unbindObject=function(s,a){var b=this.mObjectBindingInfos[s];if(b){if(b.binding){if(!this._bIsBeingDestroyed){this._detachObjectBindingHandlers(s);}b.binding.destroy();}delete this.mObjectBindingInfos[s];delete this.mElementBindingContexts[s];if(!a){this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}}return this;};o.prototype.bindContext=function(s){return this.bindObject(s);};o.prototype.unbindContext=function(s){return this.unbindObject(s);};o.prototype.bindProperty=function(n,b,a,l){var s,r=true,t=this.getMetadata().getPropertyLikeSetting(n);if(!t){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:a instanceof T?a:undefined,mode:l}],formatter:typeof a==='function'?a:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode,value:b.value};delete b.path;delete b.targetType;delete b.mode;delete b.model;delete b.value;}for(var i=0;i<b.parts.length;i++){var v=b.parts[i];if(typeof v=="string"){v={path:v};b.parts[i]=v;}if(v.path!==undefined){s=v.path.indexOf(">");if(s>0){v.model=v.path.substr(0,s);v.path=v.path.substr(s+1);}}if(b.formatter&&v.mode!=d.OneWay&&v.mode!=d.OneTime){v.mode=d.OneWay;}if(v.value===undefined&&!this.getModel(v.model)){r=false;}}b.skipPropertyUpdate=0;b.skipModelUpdate=0;if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(r){this._bindProperty(n,b);}return this;};o.prototype._bindProperty=function(n,b){var a,i,l,s,r=d.TwoWay,t,v,w=this.getMetadata().getPropertyLikeSetting(n),x=w._iKind===0?w.type:w.altTypes[0],y=this,z=[],G=function(J){y.updateProperty(n);var K=l.getDataState();if(K){var N=K.getControlMessages();if(N&&N.length>0){var Q=sap.ui.getCore().getMessageManager();K.setControlMessages([]);if(N){Q.removeMessages(N);}}K.setInvalidValue(undefined);}if(l.getBindingMode()===d.OneTime&&l.isResolved()){l.detachChange(G);if(this.refreshDataState){l.detachAggregatedDataStateChange(H);}l.detachEvents(b.events);}},H=function(){var J=l.getDataState();if(!J){return;}if(y.refreshDataState){y.refreshDataState(n,J);}};b.parts.forEach(function(J){i=y.getBindingContext(J.model);a=y.getModel(J.model);t=J.type;if(typeof t=="string"){v=O.get(t);if(typeof v!=="function"){throw new Error("Cannot find type \""+t+"\" used in control \""+y.getId()+"\"!");}t=new v(J.formatOptions,J.constraints);}if(J.value!==undefined){l=new S(J.value);}else{l=a.bindProperty(J.path,i,J.parameters||b.parameters);}l.setType(t,J.targetType||x);l.setFormatter(J.formatter);if(J.suspended){l.suspend(true);}s=J.mode||(a&&a.getDefaultBindingMode())||d.TwoWay;l.setBindingMode(s);if(s!==d.TwoWay){r=d.OneWay;}z.push(l);});if(z.length>1||(b.formatter&&b.formatter.textFragments)){t=b.type;if(typeof t=="string"){v=O.get(t);t=new v(b.formatOptions,b.constraints);}l=new C(z,b.useRawValues,b.useInternalValues);l.setType(t,b.targetType||x);l.setBindingMode(b.mode||r);}else{l=z[0];}l.attachChange(G);if(this.refreshDataState){l.attachAggregatedDataStateChange(H);}if(typeof b.formatter==="function"){l.setFormatter(b.formatter.bind(this));}b.binding=l;b.modelChangeHandler=G;b.dataStateChangeHandler=H;l.attachEvents(b.events);l.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};o.prototype._detachPropertyBindingHandlers=function(n){var b=this.mBindingInfos[n],a;if(b){a=b.binding;if(a){a.detachChange(b.modelChangeHandler);a.detachEvents(b.events);if(this.refreshDataState&&this._bIsBeingDestroyed){a.detachAggregatedDataStateChange(b.dataStateChangeHandler);}}}};o.prototype.unbindProperty=function(n,s){var b=this.mBindingInfos[n],a;if(b){a=b.binding;if(a){if(!this._bIsBeingDestroyed){this._detachPropertyBindingHandlers(n);}a.destroy();if(this.refreshDataState&&!this._bIsBeingDestroyed){a.detachAggregatedDataStateChange(b.dataStateChangeHandler);}}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!s){this.resetProperty(n);}}return this;};o.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],a=b.binding,i=this.getMetadata().getPropertyLikeSetting(n),t=this;function l(r){if(r instanceof F){t.fireFormatError({element:t,property:n,type:a.getType(),newValue:a.getValue(),oldValue:t[i._sGetter](),exception:r,message:r.message},false,true);L.error("FormatException in property '"+n+"' of '"+t+"': "+r.message+"\nHint: single properties referenced in composite bindings and within binding expressions are automatically converted "+"into the type of the bound control property, unless a different 'targetType' is specified. targetType:'any' may avoid "+"the conversion and lead to the expected behavior.");b.skipModelUpdate++;t.resetProperty(n);b.skipModelUpdate--;}else{throw r;}}if(b.skipPropertyUpdate){return;}f.resolve().then(function(){return a.getExternalValue();}).then(function(v){b.skipModelUpdate++;t[i._sMutator](v);b.skipModelUpdate--;}).catch(function(r){l(r);}).unwrap();};o.prototype.updateModelProperty=function(n,v,a){var b,i,t=this;function l(s){var w={element:t,property:n,type:i.getType(),newValue:v,oldValue:a,exception:s,message:s.message};if(s instanceof P){t.fireParseError(w,false,true);}else if(s instanceof V){t.fireValidationError(w,false,true);}else{throw s;}}function r(){var s={element:t,property:n,type:i.getType(),newValue:v,oldValue:a};if(i.hasValidation()){t.fireValidationSuccess(s,false,true);}}if(this.isBound(n)){var b=this.mBindingInfos[n],i=b.binding;if(b.skipModelUpdate||(i&&i.isSuspended())){return;}if(i&&i.getBindingMode()==d.TwoWay){b.skipPropertyUpdate++;f.resolve(v).then(function(v){return i.setExternalValue(v);}).then(function(){b.skipPropertyUpdate--;return i.getExternalValue();}).then(function(s){if(v!=s){t.updateProperty(n);}r();}).catch(function(s){b.skipPropertyUpdate--;l(s);}).unwrap();}}};var q=1;o.prototype.bindAggregation=function(n,b){var s,t,a,i,l=this.getMetadata(),r=l.getAggregation(n);if(!r){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!r.multiple){L.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){s=arguments[1];t=arguments[2];a=arguments[3];i=arguments[4];b={path:s,sorter:a,filters:i};if(t instanceof o){b.template=t;}else if(typeof t==="function"){b.factory=t;}}var v=l.getAggregationForwarder(n);if(v&&v.forwardBinding){v.getTarget(this).bindAggregation(v.targetAggregationName,b);return this;}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(r._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){L.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=q;}b.factory=function(x){return b.template.clone(x);};}var w=b.path.indexOf(">");if(w>0){b.model=b.path.substr(0,w);b.path=b.path.substr(w+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};o.prototype._bindAggregation=function(n,b){var t=this,a,i=this.getMetadata().getAggregation(n),l=function(w){var x=o._sOwnerId;try{o._sOwnerId=t._sOwnerId;i.update(t,w.getParameter("reason"),{detailedReason:w.getParameter("detailedReason")});}finally{o._sOwnerId=x;}},r=function(w){i.refresh(t,w.getParameter("reason"));},s=function(w){var x=a.getDataState();if(!x){return;}if(t.refreshDataState){t.refreshDataState(n,x);}};var v=this.getModel(b.model);if(this.isTreeBinding(n)){a=v.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{a=v.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){g(!this.oExtendedChangeDetectionConfig||!this.oExtendedChangeDetectionConfig.symbol,"symbol function must not be set by controls");a.enableExtendedChangeDetection(!b.template,b.key,this.oExtendedChangeDetectionConfig);}}if(b.suspended){a.suspend(true);}b.binding=a;b.modelChangeHandler=l;b.modelRefreshHandler=r;b.dataStateChangeHandler=s;a.attachChange(l);a.attachRefresh(r);a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(s);}a.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};o.prototype._detachAggregationBindingHandlers=function(n){var b=this.mBindingInfos[n];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachRefresh(b.modelRefreshHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}}}};o.prototype.unbindAggregation=function(n,s){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){a.getTarget(this).unbindAggregation(a.targetAggregationName,s);return this;}var b=this.mBindingInfos[n],i=this.getMetadata().getAggregation(n);if(b){if(b.binding){if(!this._bIsBeingDestroyed){this._detachAggregationBindingHandlers(n);}b.binding.destroy();}if(b.template){if(!b.templateShareable&&b.template.destroy){b.template.destroy();}if(b.templateShareable===q){b.template._sapui_candidateForDestroy=true;}}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!s){this[i._sDestructor]();}}return this;};o.prototype.updateAggregation=function(n,s,a){var b=this.mBindingInfos[n],l=b.binding,r=b.factory,t=this.getMetadata().getAggregation(n),G,v,w,x=t._sMutator+"Group",y=this;function z(i,Q){if(y.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+Q;}}function H(Q,w,R,W){var X=Q[t._sGetter]()||[],Y,Z;if(X.length>w.length){for(var i=w.length;i<X.length;i++){Z=X[i];Q[t._sRemoveMutator](Z);Z.destroy("KeepDom");}}for(var i=0;i<w.length;i++){Y=w[i];Z=X[i];if(R){R(Y);}if(Z){Z.setBindingContext(Y,b.model);}else{Z=r(z(Q,i),Y);Z.setBindingContext(Y,b.model);Q[t._sMutator](Z);}if(W){W(Y,Z);}}}function J(Q,w){var R=w.diff,W=Q[t._sGetter]()||[],X,Y,Z,i;if(!R||W.length===0){H(Q,w);return;}for(i=0;i<R.length;i++){X=R[i];switch(X.type){case"insert":Z=w[X.index];Y=r(z(Q,X.index),Z);Y.setBindingContext(Z,b.model);Q[t._sInsertMutator](Y,X.index);break;case"delete":Y=Q[t._sRemoveMutator](X.index);Y.destroy("KeepDom");break;default:L.error("Unknown diff type \""+X.type+"\"");}}W=Q[t._sGetter]()||[];for(i=0;i<W.length;i++){W[i].setBindingContext(w[i],b.model);}}function K(i){var Q=l.getGroup(i);if(Q.key!==G){var R;if(b.groupHeaderFactory){R=b.groupHeaderFactory(Q);}y[x](Q,R);G=Q.key;}}function N(i,Q){H(i,Q,null,function(R,W){N(W,l.getNodeContexts(R));});}if(c.isA(l,"sap.ui.model.ListBinding")){w=l.getContexts(b.startIndex,b.length);v=l.isGrouped()&&y[x];if(v||l.bWasGrouped){this[t._sDestructor]();H(this,w,v?K:undefined);}else if(this.bUseExtendedChangeDetection){J(this,w);}else{if(!b.template){this[t._sDestructor]();}H(this,w);}l.bWasGrouped=v;}else if(c.isA(l,"sap.ui.model.TreeBinding")){if(!b.template){this[t._sDestructor]();}N(this,l.getRootContexts());}};o.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding;a.getContexts(b.startIndex,b.length);};o.prototype.propagateMessages=function(n,a){L.warning("Message for "+this+", Property "+n);};o.prototype.isTreeBinding=function(n){return false;};o.prototype.updateBindings=function(b,s){var t=this,n,a,l;function r(l){var y=l.parts,i;if(y){if(y.length==1){return(b||y[0].model==s)&&!l.binding.updateRequired(t.getModel(y[0].model));}else{for(i=0;i<y.length;i++){if((b||y[i].model==s)&&!l.binding.aBindings[i].updateRequired(t.getModel(y[i].model))){return true;}}}}else{return(b||l.model==s)&&!l.binding.updateRequired(t.getModel(l.model));}}function v(l){var y=l.parts,i;if(y){for(i=0;i<y.length;i++){if(!t.getModel(y[i].model)&&y[i].value===undefined){return false;}}return true;}else{return!!t.getModel(l.model);}}function w(l){var i=l.binding;if(t.refreshDataState){t.refreshDataState(n,i.getDataState());}i.detachChange(l.modelChangeHandler);if(l.modelRefreshHandler){i.detachRefresh(l.modelRefreshHandler);}i.detachEvents(l.events);i.destroy();delete l.binding;delete l.modelChangeHandler;delete l.dataStateChangeHandler;delete l.modelRefreshHandler;}for(n in this.mObjectBindingInfos){l=this.mObjectBindingInfos[n];a=v(l);if(l.binding&&r(l)){w(l);if(!a){delete this.mElementBindingContexts[n];}}if(!l.binding&&a){this._bindObject(l);}}for(n in this.mBindingInfos){l=this.mBindingInfos[n];if(l.binding&&r(l)){if(this._observer){var x=l.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",l,x);}w(l);}if(!l.binding&&v(l)){if(l.factory){this._bindAggregation(n,l);}else{this._bindProperty(n,l);}}}};o.prototype.isBound=function(n){return!!this.getBindingInfo(n);};o.prototype.getObjectBinding=function(s){return this.mObjectBindingInfos[s]&&this.mObjectBindingInfos[s].binding;};o.prototype.getEventingParent=function(){return this.oParent;};o.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};o.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};o.prototype.setBindingContext=function(a,s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");var b=this.oBindingContexts[s];if(e.hasChanged(b,a)){if(a===undefined){delete this.oBindingContexts[s];}else{this.oBindingContexts[s]=a;}this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};o.prototype.setElementBindingContext=function(a,s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");var b=this.mElementBindingContexts[s];if(e.hasChanged(b,a)){if(a===undefined){delete this.mElementBindingContexts[s];}else{this.mElementBindingContexts[s]=a;}this.updateBindingContext(true,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};o.prototype.updateBindingContext=function(s,a,b){var i,l={},n,r,N,t,v;function w(y){return v[y].model==n&&v[y].value===undefined;}if(b){for(n in this.oModels){if(this.oModels.hasOwnProperty(n)){l[n]=n;}}for(n in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(n)){l[n]=n;}}}else{l[a]=a;}for(n in l){if(l.hasOwnProperty(n)){n=n==="undefined"?undefined:n;i=this.getModel(n);t=this.mObjectBindingInfos[n];if(i&&t&&!s){if(!t.binding){this._bindObject(t);}else{r=this._getBindingContext(n);if(e.hasChanged(t.binding.getContext(),r)){t.binding.setContext(r);}}continue;}r=this.getBindingContext(n);for(N in this.mBindingInfos){var t=this.mBindingInfos[N],x=t.binding;v=t.parts;if(!x){continue;}if(x instanceof C){x.setContext(r,{fnIsBindingRelevant:w});}else if(t.factory){if(t.model==n){x.setContext(r);}}else if(w(0)){x.setContext(r);}}}}};o.prototype.getBindingContext=function(s){var a=this.getModel(s),b=this.mElementBindingContexts[s];if(b&&!a){return b;}else if(b&&a&&b.getModel()===a){return b;}else if(b===null){return b;}else{return this._getBindingContext(s);}};o.prototype._getBindingContext=function(s){var a=this.getModel(s),b=this.oBindingContexts[s],i=this.oPropagatedProperties.oBindingContexts[s];if(b&&!a){return this.oBindingContexts[s];}else if(b&&a&&b.getModel()===a){return this.oBindingContexts[s];}else if(b===null){return b;}else if(i&&a&&i.getModel()!==a){return undefined;}else{return i;}};o.prototype.setModel=function(a,n){g(a==null||c.isA(a,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");g(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");if(!a&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(a&&a!==this.oModels[n]){this.oModels[n]=a;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};o.prototype.addPropagationListener=function(l){g(typeof l==='function',"listener must be a function");this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};o.prototype.removePropagationListener=function(l){g(typeof l==='function',"listener must be a function");var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};o.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};o.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};o._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};function _(a,b){return!b.aAPIParentInfos||b.aAPIParentInfos[0].parent===a;}o.prototype.propagateProperties=function(n){var a=this._getPropertiesToPropagate(),b=n===true,l=n===false,N=b?undefined:n,s,r,i,t=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(s in t){if(this.mSkipPropagation[s]){continue;}r=t[s];if(r instanceof o){if(_(this,r)){this._propagateProperties(n,r,a,b,N,l);}}else if(r instanceof Array){for(i=0;i<r.length;i++){if(r[i]instanceof o){if(_(this,r[i])){this._propagateProperties(n,r[i],a,b,N,l);}}}}}};o.prototype._propagateProperties=function(n,a,b,i,N,l){if(!b){b=this._getPropertiesToPropagate();i=n===true;l=n===false;N=i?undefined:n;}if(a.oPropagatedProperties!==b){a.oPropagatedProperties=b;if(l!==true){a.updateBindings(i,N);a.updateBindingContext(false,N,i);}a.propagateProperties(n);if(l||i){a._callPropagationListener();}a.fireModelContextChange();}};o.prototype._getPropertiesToPropagate=function(){var n=m(this.oModels),N=m(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=m(this.mElementBindingContexts);function i(r,s,t,v){return r?s:k({},s,t,v);}function l(r,s,t){return r?s:s.concat(t);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:i(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:i((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:l(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};o.prototype.getModel=function(s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");return this.oModels[s]||this.oPropagatedProperties.oModels[s];};o.prototype.getOwnModels=function(){return this.oModels;};o.prototype.hasModel=function(){return!(m(this.oModels)&&m(this.oPropagatedProperties.oModels));};o.prototype.clone=function(s,l,a){var b=true,n=true;if(a){b=!!a.cloneChildren;n=!!a.cloneBindings;}if(!s){s=M.uid("clone")||u();}if(!l&&b){l=this.findAggregatedObjects(true,null,true).map(function($){return $.getId();});l.push(this.getId());}var r=this.getMetadata(),t=r._oClass,v=this.getId()+"-"+s,w={},x,y=this.mProperties,K,N,z,G=o.bindingParser.escape,i,H;var J=Object.keys(y);var Q;i=J.length;while(i>0){K=J[--i];x=r.getProperty(K);if(x&&!(this.isBound(K)&&n)){if(typeof y[K]==="string"){w[K]=G(y[K]);}else{Q=x.byValue?h(y[K]):y[K];if(Q&&typeof Q==="object"&&!Object.isFrozen(Q)){Q[U]=true;}w[K]=Q;}}}w["models"]=this.oModels;w["bindingContexts"]=this.oBindingContexts;if(b){var R=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(N in R){var W=R[N];if(r.hasAggregation(N)&&!(this.isBound(N)&&n)){if(W instanceof o){w[N]=W.clone(s,l);}else if(Array.isArray(W)){w[N]=[];for(var i=0;i<W.length;i++){w[N].push(W[i].clone(s,l));}}else{w[N]=typeof W==="string"?G(W):W;}}}for(N in this.mAssociations){if(!r.hasAssociation(N)){continue;}var X=this.mAssociations[N];if(Array.isArray(X)){X=X.slice(0);for(var i=0;i<X.length;i++){if(l.indexOf(X[i])>=0){X[i]+="-"+s;}}}else if(l.indexOf(X)>=0){X+="-"+s;}w[N]=X;}}z=new t(v,w);function Y($,N,z,a1){var b1=$.mBindingInfos[N];b1=b1||$.getBindingInfo(N);var c1=Object.assign({},b1);if(!b1.templateShareable&&b1.template&&b1.template.clone){c1.template=b1.template.clone(s,l);delete c1.factory;}else if(b1.templateShareable===q){b1.templateShareable=c1.templateShareable=true;L.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+$.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete c1.binding;delete c1.modelChangeHandler;delete c1.dataStateChangeHandler;delete c1.modelRefreshHandler;if(b1.factory||b1.template){z.bindAggregation(a1,c1);}else{z.bindProperty(a1,c1);}}for(N in this.mObjectBindingInfos){z.mObjectBindingInfos[N]=Object.assign({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){z.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(n){for(N in this.mBindingInfos){Y(this,N,z,N);}}if(o._supportInfo){o._supportInfo.addSupportInfo(z.getId(),o._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(z);}if(this.mForwardedAggregations){for(N in this.mForwardedAggregations){var Z=z.getMetadata().getAggregationForwarder(N);if(Z){H=Z.getTarget(z,true);if(Z.forwardBinding&&this.isBound(N)){Y(this,N,H,Z.targetAggregationName);}}}}return z;};o._handleLocalizationChange=function(a){var b,n,l,i;if(a===1){for(n in this.oModels){b=this.oModels[n];if(b&&b._handleLocalizationChange){b._handleLocalizationChange();}}}else if(a===2){for(n in this.mBindingInfos){l=this.mBindingInfos[n];var r=l.parts;if(r){for(i=0;i<r.length;i++){if(l.type&&l.type._handleLocalizationChange){l.type._handleLocalizationChange();}}if(l.modelChangeHandler){l.modelChangeHandler();}}}}};o.prototype.findAggregatedObjects=function(r,b,l){var s=[];if(b&&typeof b!=="function"){b=null;}function t(v){var a,i,n;if(l){for(n in v.mBindingInfos){a=v.mBindingInfos[n].template;if(a){if(!b||b(a)){s.push(a);}if(r){t(a);}}}}for(n in v.mAggregations){a=v.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!b||b(a[i])){s.push(a[i]);}if(r){t(a[i]);}}}else if(a instanceof o){if(!b||b(a)){s.push(a);}if(r){t(a);}}}}t(this);return s;};o.prototype.onOwnerDeactivation=function(){this._bIsOwnerActive=false;};o.prototype.onOwnerActivation=function(){this._bIsOwnerActive=true;this._onContextualSettingsChanged();};o.prototype.isDestroyStarted=function(){return!!this._bIsBeingDestroyed;};o.prototype.isDestroyed=function(){return!!this.bIsDestroyed;};o._defaultContextualSettings={};return o;});
