ace.define("ace/mode/ruby_highlight_rules",[],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var c=e.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"};e.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"};e.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'};e.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"};var a=e.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"};var b=e.constantNumericBinary={token:"constant.numeric",regex:/\b(0[bB][01](?:[01]|_(?=[01]))*)\b/};var d=e.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/};var f=e.constantNumericDecimal={token:"constant.numeric",regex:/\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/};var g=e.constantNumericRational={token:"constant.numeric",regex:/\b([\d]+(?:[./][\d]+)?ri?)\b/};var h=e.constantNumericComplex={token:"constant.numeric",regex:/\b([\d]i)\b/};var i=e.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"};var j=e.instanceVariable={token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"};var R=function(){var k=("abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|"+"assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|"+"assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|"+"assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|"+"assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|"+"assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|"+"attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|"+"caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|"+"exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|"+"gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|"+"link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|"+"p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|"+"raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|"+"set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|"+"throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|"+"render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|"+"content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|"+"fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|"+"time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|"+"select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|"+"file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|"+"protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|"+"send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|"+"validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|"+"validates_inclusion_of|validates_numericality_of|validates_with|validates_each|"+"authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|"+"filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|"+"translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|"+"cache|expire_fragment|expire_cache_for|observe|cache_sweeper|"+"has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|"+"private_class_method|remove_method|undef_method");var l=("alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|"+"__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|"+"redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend");var n=("true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|"+"RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION");var p=("$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|"+"$!|root_url|flash|session|cookies|params|request|response|logger|self");var q=this.$keywords=this.createKeywordMapper({"keyword":l,"constant.language":n,"variable.language":p,"support.function":k,"invalid.deprecated":"debugger"},"identifier");var s="\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})";var t={"(":")","[":"]","{":"}","<":">","^":"^","|":"|","%":"%"};this.$rules={"start":[{token:"comment",regex:"#.*$"},{token:"comment.multiline",regex:"^=begin(?=$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:/[/](?=.*\/)/,next:"regex"},[{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(")/,push:[{token:"constant.language.escape",regex:s},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:s},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:["constant.other.symbol.ruby","string.start"],regex:/(:)?(')/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/%[qwx]([(\[<{^|%])/,onMatch:function(v,u,w){if(w.length)w=[];var x=v[v.length-1];w.unshift(x,u);this.next="qStateWithoutInterpolation";return this.token;}},{token:"string.start",regex:/%[QWX]?([(\[<{^|%])/,onMatch:function(v,u,w){if(w.length)w=[];var x=v[v.length-1];w.unshift(x,u);this.next="qStateWithInterpolation";return this.token;}},{token:"constant.other.symbol.ruby",regex:/%[si]([(\[<{^|%])/,onMatch:function(v,u,w){if(w.length)w=[];var x=v[v.length-1];w.unshift(x,u);this.next="sStateWithoutInterpolation";return this.token;}},{token:"constant.other.symbol.ruby",regex:/%[SI]([(\[<{^|%])/,onMatch:function(v,u,w){if(w.length)w=[];var x=v[v.length-1];w.unshift(x,u);this.next="sStateWithInterpolation";return this.token;}},{token:"string.regexp",regex:/%[r]([(\[<{^|%])/,onMatch:function(v,u,w){if(w.length)w=[];var x=v[v.length-1];w.unshift(x,u);this.next="rState";return this.token;}}],{token:"punctuation",regex:"::"},j,{token:"variable.global",regex:"[$][a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]*"},{token:["punctuation.operator","support.function"],regex:/(\.)([a-zA-Z_\d]+)(?=\()/},{token:["punctuation.operator","identifier"],regex:/(\.)([a-zA-Z_][a-zA-Z_\d]*)/},{token:"string.character",regex:"\\B\\?(?:"+s+"|\\S)"},{token:"punctuation.operator",regex:/\?(?=.+:)/},g,h,c,a,i,b,d,f,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:q,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(v,u,w){var x=(v[2]=='-'||v[2]=='~')?"indentedHeredoc":"heredoc";var y=v.split(this.splitRegex);w.push(x,y[3]);return[{type:"constant",value:y[1]},{type:"string",value:y[2]},{type:"support.class",value:y[3]},{type:"string",value:y[4]}];},regex:"(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(v,u,w){if(v===w[1]){w.shift();w.shift();this.next=w[0]||"start";return"support.class";}this.next="";return"string";},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(v,u,w){if(v===w[1]){w.shift();w.shift();this.next=w[0]||"start";return"support.class";}this.next="";return"string";},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(u,v){if(v[0]==="heredoc"||v[0]==="indentedHeredoc")return v[0];return u;}},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]",onMatch:function(v,u,w){this.next='';if(v=="}"&&w.length>1&&w[1]!="start"){w.shift();this.next=w.shift();}return this.token;}},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:/[?:,;.]/}],"comment":[{token:"comment.multiline",regex:"^=end(?=$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}],"qStateWithInterpolation":[{token:"string.start",regex:/[(\[<{]/,onMatch:function(v,u,w){if(w.length&&v===w[0]){w.unshift(v,u);return this.token;}return"string";}},{token:"constant.language.escape",regex:s},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(v,u,w){if(w.length&&v===t[w[0]]){w.shift();this.next=w.shift();return this.token;}this.next='';return"string";}},{defaultToken:"string"}],"qStateWithoutInterpolation":[{token:"string.start",regex:/[(\[<{]/,onMatch:function(v,u,w){if(w.length&&v===w[0]){w.unshift(v,u);return this.token;}return"string";}},{token:"constant.language.escape",regex:/\\['\\]/},{token:"constant.language.escape",regex:/\\./},{token:"string.end",regex:/[)\]>}^|%]/,onMatch:function(v,u,w){if(w.length&&v===t[w[0]]){w.shift();this.next=w.shift();return this.token;}this.next='';return"string";}},{defaultToken:"string"}],"sStateWithoutInterpolation":[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(v,u,w){if(w.length&&v===w[0]){w.unshift(v,u);return this.token;}return"constant.other.symbol.ruby";}},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(v,u,w){if(w.length&&v===t[w[0]]){w.shift();this.next=w.shift();return this.token;}this.next='';return"constant.other.symbol.ruby";}},{defaultToken:"constant.other.symbol.ruby"}],"sStateWithInterpolation":[{token:"constant.other.symbol.ruby",regex:/[(\[<{]/,onMatch:function(v,u,w){if(w.length&&v===w[0]){w.unshift(v,u);return this.token;}return"constant.other.symbol.ruby";}},{token:"constant.language.escape",regex:s},{token:"constant.language.escape",regex:/\\./},{token:"paren.start",regex:/#{/,push:"start"},{token:"constant.other.symbol.ruby",regex:/[)\]>}^|%]/,onMatch:function(v,u,w){if(w.length&&v===t[w[0]]){w.shift();this.next=w.shift();return this.token;}this.next='';return"constant.other.symbol.ruby";}},{defaultToken:"constant.other.symbol.ruby"}],"rState":[{token:"string.regexp",regex:/[(\[<{]/,onMatch:function(v,u,w){if(w.length&&v===w[0]){w.unshift(v,u);return this.token;}return"constant.language.escape";}},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.regexp",regex:/\//},{token:"string.regexp",regex:/[)\]>}^|%][imxouesn]*/,onMatch:function(v,u,w){if(w.length&&v[0]===t[w[0]]){w.shift();this.next=w.shift();return this.token;}this.next='';return"constant.language.escape";}},{include:"regex"},{defaultToken:"string.regexp"}],"regex":[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"constant.language.escape",regex:/\\[AGbBzZ]/},{token:"constant.language.escape",regex:/\\g<[a-zA-Z0-9]*>/},{token:["constant.language.escape","regexp.keyword","constant.language.escape"],regex:/(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/},{token:["constant.language.escape","invalid","constant.language.escape"],regex:/(\\p{\^?)([^/]*)(})/},{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:/[/][imxouesn]*/,next:"start"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"regexp.keyword",regex:/\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/},{token:"constant.language.escape",regex:/\[\^?/,push:"regex_character_class"},{defaultToken:"string.regexp"}],"regex_character_class":[{token:"regexp.keyword",regex:/\\[wWdDhHsS]/},{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:/&?&?\[\^?/,push:"regex_character_class"},{token:"constant.language.escape",regex:"]",next:"pop"},{token:"constant.language.escape",regex:"-"},{defaultToken:"string.regexp.characterclass"}]};this.normalizeRules();};o.inherits(R,T);e.RubyHighlightRules=R;});ace.define("ace/mode/matching_brace_outdent",[],function(r,e,m){"use strict";var R=r("../range").Range;var M=function(){};(function(){this.checkOutdent=function(l,i){if(!/^\s+$/.test(l))return false;return/^\s*\}/.test(i);};this.autoOutdent=function(d,a){var l=d.getLine(a);var b=l.match(/^(\s*\})/);if(!b)return 0;var c=b[1].length;var o=d.findMatchingBracket({row:a,column:c});if(!o||o.row==a)return 0;var i=this.$getIndent(d.getLine(o.row));d.replace(new R(a,0,a,c-1),i);};this.$getIndent=function(l){return l.match(/^\s*/)[0];};}).call(M.prototype);e.MatchingBraceOutdent=M;});ace.define("ace/mode/folding/ruby",[],function(r,e,m){"use strict";var o=r("../../lib/oop");var B=r("./fold_mode").FoldMode;var R=r("../../range").Range;var T=r("../../token_iterator").TokenIterator;var F=e.FoldMode=function(){};o.inherits(F,B);(function(){this.indentKeywords={"class":1,"def":1,"module":1,"do":1,"unless":1,"if":1,"while":1,"for":1,"until":1,"begin":1,"else":0,"elsif":0,"rescue":0,"ensure":0,"when":0,"end":-1,"case":1,"=begin":1,"=end":-1};this.foldingStartMarker=/(?:\s|^)(def|do|while|class|unless|module|if|for|until|begin|else|elsif|case|rescue|ensure|when)\b|({\s*$)|(=begin)/;this.foldingStopMarker=/(=end(?=$|\s.*$))|(^\s*})|\b(end)\b/;this.getFoldWidget=function(s,f,a){var l=s.getLine(a);var i=this.foldingStartMarker.test(l);var b=this.foldingStopMarker.test(l);if(i&&!b){var c=l.match(this.foldingStartMarker);if(c[1]){if(c[1]=="if"||c[1]=="else"||c[1]=="while"||c[1]=="until"||c[1]=="unless"){if(c[1]=="else"&&/^\s*else\s*$/.test(l)===false){return;}if(/^\s*(?:if|else|while|until|unless)\s*/.test(l)===false){return;}}if(c[1]=="when"){if(/\sthen\s/.test(l)===true){return;}}if(s.getTokenAt(a,c.index+2).type==="keyword")return"start";}else if(c[3]){if(s.getTokenAt(a,c.index+1).type==="comment.multiline")return"start";}else{return"start";}}if(f!="markbeginend"||!b||i&&b)return"";var c=l.match(this.foldingStopMarker);if(c[3]==="end"){if(s.getTokenAt(a,c.index+1).type==="keyword")return"end";}else if(c[1]){if(s.getTokenAt(a,c.index+1).type==="comment.multiline")return"end";}else return"end";};this.getFoldWidgetRange=function(s,f,a){var l=s.doc.getLine(a);var b=this.foldingStartMarker.exec(l);if(b){if(b[1]||b[3])return this.rubyBlock(s,a,b.index+2);return this.openingBracketBlock(s,"{",a,b.index);}var b=this.foldingStopMarker.exec(l);if(b){if(b[3]==="end"){if(s.getTokenAt(a,b.index+1).type==="keyword")return this.rubyBlock(s,a,b.index+1);}if(b[1]==="=end"){if(s.getTokenAt(a,b.index+1).type==="comment.multiline")return this.rubyBlock(s,a,b.index+1);}return this.closingBracketBlock(s,"}",a,b.index+b[0].length);}};this.rubyBlock=function(s,a,c,t){var b=new T(s,a,c);var d=b.getCurrentToken();if(!d||(d.type!="keyword"&&d.type!="comment.multiline"))return;var v=d.value;var l=s.getLine(a);switch(d.value){case"if":case"unless":case"while":case"until":var g=new RegExp("^\\s*"+d.value);if(!g.test(l)){return;}var f=this.indentKeywords[v];break;case"when":if(/\sthen\s/.test(l)){return;}case"elsif":case"rescue":case"ensure":var f=1;break;case"else":var g=new RegExp("^\\s*"+d.value+"\\s*$");if(!g.test(l)){return;}var f=1;break;default:var f=this.indentKeywords[v];break;}var h=[v];if(!f)return;var j=f===-1?s.getLine(a-1).length:s.getLine(a).length;var k=a;var n=[];n.push(b.getCurrentTokenRange());b.step=f===-1?b.stepBackward:b.stepForward;if(d.type=="comment.multiline"){while(d=b.step()){if(d.type!=="comment.multiline")continue;if(f==1){j=6;if(d.value=="=end"){break;}}else{if(d.value=="=begin"){break;}}}}else{while(d=b.step()){var p=false;if(d.type!=="keyword")continue;var q=f*this.indentKeywords[d.value];l=s.getLine(b.getCurrentTokenRow());switch(d.value){case"do":for(var i=b.$tokenIndex-1;i>=0;i--){var u=b.$rowTokens[i];if(u&&(u.value=="while"||u.value=="until"||u.value=="for")){q=0;break;}}break;case"else":var g=new RegExp("^\\s*"+d.value+"\\s*$");if(!g.test(l)||v=="case"){q=0;p=true;}break;case"if":case"unless":case"while":case"until":var g=new RegExp("^\\s*"+d.value);if(!g.test(l)){q=0;p=true;}break;case"when":if(/\sthen\s/.test(l)||v=="case"){q=0;p=true;}break;}if(q>0){h.unshift(d.value);}else if(q<=0&&p===false){h.shift();if(!h.length){if((v=="while"||v=="until"||v=="for")&&d.value!="do"){break;}if(d.value=="do"&&f==-1&&q!=0)break;if(d.value!="do")break;}if(q===0){h.unshift(d.value);}}}}if(!d)return null;if(t){n.push(b.getCurrentTokenRange());return n;}var a=b.getCurrentTokenRow();if(f===-1){if(d.type==="comment.multiline"){var w=6;}else{var w=s.getLine(a).length;}return new R(a,w,k-1,j);}else return new R(k,j,a-1,s.getLine(a-1).length);};}).call(F.prototype);});ace.define("ace/mode/ruby",[],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var R=r("./ruby_highlight_rules").RubyHighlightRules;var M=r("./matching_brace_outdent").MatchingBraceOutdent;var a=r("../range").Range;var C=r("./behaviour/cstyle").CstyleBehaviour;var F=r("./folding/ruby").FoldMode;var b=function(){this.HighlightRules=R;this.$outdent=new M();this.$behaviour=new C();this.foldingRules=new F();this.indentKeywords=this.foldingRules.indentKeywords;};o.inherits(b,T);(function(){this.lineCommentStart="#";this.getNextLineIndent=function(s,l,t){var i=this.$getIndent(l);var c=this.getTokenizer().getLineTokens(l,s);var d=c.tokens;if(d.length&&d[d.length-1].type=="comment"){return i;}if(s=="start"){var f=l.match(/^.*[\{\(\[]\s*$/);var g=l.match(/^\s*(class|def|module)\s.*$/);var h=l.match(/.*do(\s*|\s+\|.*\|\s*)$/);var j=l.match(/^\s*(if|else|when|elsif|unless|while|for|begin|rescue|ensure)\s*/);if(f||g||h||j){i+=t;}}return i;};this.checkOutdent=function(s,l,i){return/^\s+(end|else|rescue|ensure)$/.test(l+i)||this.$outdent.checkOutdent(l,i);};this.autoOutdent=function(s,c,d){var l=c.getLine(d);if(/}/.test(l))return this.$outdent.autoOutdent(c,d);var i=this.$getIndent(l);var p=c.getLine(d-1);var f=this.$getIndent(p);var t=c.getTabString();if(f.length<=i.length){if(i.slice(-t.length)==t)c.remove(new a(d,i.length-t.length,d,i.length));}};this.getMatching=function(s,c,d){if(c==undefined){var p=s.selection.lead;d=p.column;c=p.row;}var f=s.getTokenAt(c,d);if(f&&f.value in this.indentKeywords)return this.foldingRules.rubyBlock(s,c,d,true);};this.$id="ace/mode/ruby";this.snippetFileId="ace/snippets/ruby";}).call(b.prototype);e.Mode=b;});(function(){ace.require(["ace/mode/ruby"],function(m){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=m;}});})();
