/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/base/util/extend','sap/ui/base/Object','./CalendarType','./Locale','sap/base/assert','sap/base/util/LoaderExtensions'],function(e,B,C,L,a,b){"use strict";var c=B.extend("sap.ui.core.LocaleData",{constructor:function(o){this.oLocale=o;B.apply(this);this.mData=h(o);},_get:function(){return this._getDeep(this.mData,arguments);},_getMerged:function(){return this._get.apply(this,arguments);},_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},getOrientation:function(){return this._get("orientation");},getCurrentLanguageName:function(){var o=this.getLanguages();var s;var i=this.oLocale.getModernLanguage();var S=this.oLocale.getScript();if(i==="sr"&&S==="Latn"){i="sh";S=null;}if(this.oLocale.getRegion()){s=o[i+"_"+this.oLocale.getRegion()];}if(!s&&S){s=o[i+"_"+S];}if(!s){s=o[i];}return s;},getLanguages:function(){return this._get("languages");},getScripts:function(){return this._get("scripts");},getTerritories:function(){return this._get("territories");},getMonths:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","format",w);},getMonthsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"months","stand-alone",w);},getDays:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(g(s),"days","format",w);},getDaysStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(g(s),"days","stand-alone",w);},getQuarters:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","format",w);},getQuartersStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"quarters","stand-alone",w);},getDayPeriods:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","format",w);},getDayPeriodsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(g(s),"dayPeriods","stand-alone",w);},getDatePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateFormats",s);},getTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"timeFormats",s);},getDateTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(g(i),"dateTimeFormats",s);},getCombinedDateTimePattern:function(D,t,s){a(D=="short"||D=="medium"||D=="long"||D=="full","sStyle must be short, medium, long or full");a(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(D,s),j=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return i.replace("{0}",T).replace("{1}",j);},getCustomDateTimePattern:function(s,i){var A=this._get(g(i),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,i);},getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),j,n,D,o,p;if(i){j=i.split("-");n=j[0];D=j[1];o=I[n];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},getCombinedIntervalPattern:function(p,s){var i=this._get(g(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},getCustomIntervalPattern:function(s,G,i){var A=this._get(g(i),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,i,G);},_getFormatPattern:function(s,A,i,D){var p,P,I;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}I=A[s];p=I&&I[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(K){return p[K];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,i,D);}if(P&&P.length===1){return P[0];}return P;},_createFormatPattern:function(s,A,j,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,n,S,G,P,q,r,u,v=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,w,i;if(D){if(typeof D==="string"){u=d[D]?d[D].group:"";if(u){w=m[u].index>t[t.length-1].index;}r=D;}else{w=true;if(t[0].symbol==="y"&&o&&o.pattern.G){S=d["G"];G=m[S.group];t.splice(0,0,{symbol:"G",group:S.group,match:S.match,index:G.index,field:G.field,length:1});}for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){w=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){r=T.symbol;break;}}if((r=="h"||r=="K")&&D.DayPeriod){r="a";}}if(w){return[this.getCustomDateTimePattern(s,j)];}if(o&&o.missingTokens.length===0){P=o.pattern[r];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){n=this._get(g(j),"dateTimeFormats","availableFormats");if(v.test(s)&&"ahHkKjJms".indexOf(r)>=0){P=this._getMixedFormatPattern(s,n,j,D);}else{q=this._getFormatPattern(s,n,j);P=this.getCombinedIntervalPattern(q,j);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(v.test(s)){p=[this._getMixedFormatPattern(s,A,j)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,j);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=d[S];G=m[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},_findBestMatch:function(t,s,A){var T,j,o,n,p,D,q,F,r,u,v={distance:10000,firstDiffPos:-1};for(var w in A){if(w==="intervalFormatFallback"||w.indexOf("B")>-1){continue;}T=this._parseSkeletonFormat(w);D=0;j=[];q=true;if(t.length<T.length){continue;}p=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];n=T[p];if(F===t.length){F=i;}if(n){r=d[o.symbol];u=d[n.symbol];if(o.symbol===n.symbol){if(o.length===n.length){if(F===i){F=t.length;}}else{if(o.length<r.numericCeiling?n.length<u.numericCeiling:n.length>=u.numericCeiling){D+=Math.abs(o.length-n.length);}else{D+=5;}}p++;continue;}else{if(o.match==n.match){D+=Math.abs(o.length-n.length)+10;p++;continue;}}}j.push(o);D+=50-i;}if(p<T.length){q=false;}if(q&&(D<v.distance||(D===v.distance&&F>v.firstDiffPos))){v.distance=D;v.firstDiffPos=F;v.missingTokens=j;v.pattern=A[w];v.patternTokens=T;}}if(v.pattern){return v;}},_expandFields:function(p,P,t){var s=(typeof p==="string");var n;if(s){n=[p];}else{n=p;}var r=n.map(function(o){var G={},q={},R="",Q=false,i=0,S,u,v,N,w,x,y,z;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){q[T.group]=T;});while(i<o.length){z=o.charAt(i);if(Q){R+=z;if(z=="'"){Q=false;}}else{y=d[z];if(y&&G[y.group]&&q[y.group]){w=G[y.group];x=q[y.group];S=w.length;v=x.length;u=1;while(o.charAt(i+1)==z){i++;u++;}if(S===v||((S<y.numericCeiling)?(u>=y.numericCeiling):(u<y.numericCeiling))){N=u;}else{N=Math.max(u,S);}for(var j=0;j<N;j++){R+=z;}}else{R+=z;if(z=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},_appendItems:function(p,j,s){var A=this._get(g(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,n,o;j.forEach(function(t){n=A[t.group];D="'"+this.getDisplayName(t.field)+"'";o="";for(var i=0;i<t.length;i++){o+=t.symbol;}p[I]=n.replace(/\{0\}/,P).replace(/\{1\}/,o).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},_getMixedFormatPattern:function(s,A,i,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,j=/MMMM|LLLL/,n=/MMM|LLL/,o=/E|e|c/,R,p,t,S,q,T,u,v;R=r.exec(s);p=R[1];t=R[2];q=this._getFormatPattern(p,A,i);if(D){T=this.getCustomIntervalPattern(t,D,i);}else{T=this._getFormatPattern(t,A,i);}if(j.test(p)){S=o.test(p)?"full":"long";}else if(n.test(p)){S="medium";}else{S="short";}u=this.getDateTimePattern(S,i);v=u.replace(/\{1\}/,q).replace(/\{0\}/,T);return v;},getNumberSymbol:function(t){a(t=="decimal"||t=="group"||t=="plusSign"||t=="minusSign"||t=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+t);},getLenientNumberSymbols:function(t){a(t=="plusSign"||t=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[t];},getDecimalPattern:function(){return this._get("decimalFormat").standard;},getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},getPercentPattern:function(){return this._get("percentFormat").standard;},getMiscPattern:function(n){a(n=="approximately"||n=="atLeast"||n=="atMost"||n=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[n];},getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},getWeekendStart:function(){return this._get("weekData-weekendStart");},getWeekendEnd:function(){return this._get("weekData-weekendEnd");},getCustomCurrencyCodes:function(){var i=this._get("currency")||{},j={};Object.keys(i).forEach(function(s){j[s]=s;});return j;},getCurrencyDigits:function(s){var i=this._get("currency");if(i){if(i[s]&&i[s].hasOwnProperty("digits")){return i[s].digits;}else if(i["DEFAULT"]&&i["DEFAULT"].hasOwnProperty("digits")){return i["DEFAULT"].digits;}}var D=this._get("currencyDigits",s);if(D==null){D=this._get("currencyDigits","DEFAULT");if(D==null){D=2;}}return D;},getCurrencySymbol:function(s){var o=this.getCurrencySymbols();return(o&&o[s])||s;},getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),i;for(i in o){if(o[i]===s){return i;}}return s;},getCurrencySymbols:function(){var i=this._get("currency"),j={},I;for(var s in i){I=i[s].isoCode;if(i[s].symbol){j[s]=i[s].symbol;}else if(I){j[s]=this._get("currencySymbols")[I];}}return Object.assign({},this._get("currencySymbols"),j);},getUnitDisplayName:function(u){var U=this.getUnitFormat(u);return(U&&U["displayName"])||"";},getRelativePatterns:function(s,S){if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(j){o=this._get("dateFields",j+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14));p.push({scale:j,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(K){p.push({scale:j,sign:i,pattern:t["relativeTimePattern-count-"+K]});});}}}.bind(this));return p;},getRelativePattern:function(s,D,F,S){var p,t,K,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");K=s+"-"+S;if(D===0||D===-2||D===2){p=this._get("dateFields",K,"relative-type-"+D);}if(!p){t=this._get("dateFields",K,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},getDisplayName:function(t,s){a(t=="second"||t=="minute"||t=="hour"||t=="zone"||t=="day"||t=="weekday"||t=="week"||t=="month"||t=="quarter"||t=="year"||t=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(s===undefined){s="wide";}a(s==="wide"||s==="short"||s==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var S=["era","weekday","zone"],K=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",K,"displayName");},getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},getCurrencyFormat:function(s,n,p){var F;var o=this._get("currencyFormat-"+s);if(!o){if(s==="sap-short"){throw new Error("Failed to get CLDR data for property \"currencyFormat-sap-short\"");}o=this._get("currencyFormat-short");}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},getListFormat:function(t,s){var F=this._get("listPattern-"+(t||"standard")+"-"+(s||"wide"));if(F){return F;}return{};},getResolvedUnitFormat:function(u){u=this.getUnitFromMapping(u)||u;return this.getUnitFormat(u);},getUnitFormat:function(u){return this._get("units","short",u);},getUnitFormats:function(){return this._getMerged("units","short");},getUnitFromMapping:function(s){return this._get("unitMappings",s);},getEras:function(w,s){a(w=="wide"||w=="abbreviated"||w=="narrow","sWidth must be wide, abbreviate or narrow");var E=this._get(g(s),"era-"+w),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},getCalendarWeek:function(s,w){a(s=="wide"||s=="narrow","sStyle must be wide or narrow");var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),K="date.week.calendarweek."+s;return o.getText(K,w);},firstDayStartsFirstWeek:function(){return this._get("weekData-algorithm")==="FIRSTDAY_STARTS_FIRSTWEEK";},getPreferredCalendarType:function(){var s=this._get("calendarPreference"),j=s?s.split(" "):[],n,t,i;for(i=0;i<j.length;i++){n=j[i].split("-")[0];for(t in C){if(n===t.toLowerCase()){return t;}}}return C.Gregorian;},getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},getPluralCategories:function(){var p=this._get("plurals"),i=Object.keys(p);i.push("other");return i;},getPluralCategory:function(n){var p=this._get("plurals");if(typeof n==="number"){n=n.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(n)){return s;}}return"other";},_parsePluralRule:function(r){var O="or",j="and",n="%",p="=",q="!=",s="n",t="i",u="f",v="t",w="v",x="w",R="..",S=",";var i=0,T;T=r.split(" ");function y(o){if(T[i]===o){i++;return true;}return false;}function z(){var o=T[i];i++;return o;}function A(){var J,I;J=D();if(y(O)){I=A();return function(o){return J(o)||I(o);};}return J;}function D(){var J,K;J=E();if(y(j)){K=D();return function(o){return J(o)&&K(o);};}return J;}function E(){var J,K,N;J=F();if(y(p)){N=true;}else if(y(q)){N=false;}else{throw new Error("Expected '=' or '!='");}K=H();if(N){return function(o){return K(o).indexOf(J(o))>=0;};}else{return function(o){return K(o).indexOf(J(o))===-1;};}}function F(){var J;J=G();if(y(n)){var K=parseInt(z());return function(o){return J(o)%K;};}return J;}function G(){if(y(s)){return function(o){return o.n;};}else if(y(t)){return function(o){return o.i;};}else if(y(u)){return function(o){return o.f;};}else if(y(v)){return function(o){return o.t;};}else if(y(w)){return function(o){return o.v;};}else if(y(x)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+z());}}function H(){var V=[],J=z(),P=J.split(S),K,N,Q;P.forEach(function(o){K=o.split(R);if(K.length===1){V.push(parseInt(o));}else{N=parseInt(K[0]);Q=parseInt(K[1]);for(var i=N;i<=Q;i++){V.push(i);}}});return function(o){return V;};}var I=A();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var J=V.indexOf("."),K,N,P,o;if(J===-1){K=V;N="";P="";}else{K=V.substr(0,J);N=V.substr(J+1);P=N.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(K),v:N.length,w:P.length,f:parseInt(N),t:parseInt(P)};return I(o);};}});var m={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var d={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"iw":"he","ji":"yi"};var f=(function(){var j=L._cldrLocales,r={},i;if(j){for(i=0;i<j.length;i++){r[j[i]]=true;}}return r;}());var l={};function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}function h(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function i(n,p){var q,v,t;if(!p){return;}for(q in p){if(p.hasOwnProperty(q)){v=n[q];t=p[q];if(v===undefined){n[q]=t;}else if(v===null){delete n[q];}else if(typeof v==='object'&&typeof t==='object'){i(v,t);}}}}function j(I){if(!l[I]&&(!f||f[I]===true)){var n=l[I]=b.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(n&&n.__fallbackLocale){i(n,j(n.__fallbackLocale));delete n.__fallbackLocale;}}return l[I];}s=(s&&M[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}if(s==="sh"||(s==="sr"&&S==="Latn")){s="sr_Latn";}var I=s+"_"+r;if(s&&r){D=j(I);}if(!D&&s){D=j(s);}l[I]=D||j("en");return l[I];}var k=c.extend("sap.ui.core.CustomLocaleData",{constructor:function(o){c.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},_get:function(){var A=Array.prototype.slice.call(arguments),s,K;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}K=A.join("-");var v=this.mCustomData[K];if(v==null){v=this._getDeep(this.mCustomData,arguments);if(v==null){v=this._getDeep(this.mData,arguments);}}return v;},_getMerged:function(){var D=this._getDeep(this.mData,arguments);var i=this._getDeep(this.mCustomData,arguments);return e({},D,i);}});c.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new k(o):new c(o);};return c;});
