/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/date/UniversalDate','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/assert'],function(U,L,a,b){"use strict";function c(u){b(u instanceof U,"method accepts only instances of UniversalDate");return u.createDate(u.constructor,[u.getJSDate()]);}var d={};d.getRange=function(D,u,B,e){if(e===undefined){e=true;}if(isNaN(D)){throw new TypeError("duration is NaN, but is "+D);}D=Math.trunc(D);var s=d.resetStartTime(B==undefined?null:B),E;if(e){switch(u){case"DAY":break;case"WEEK":s=d.getWeekStartDate(s);break;case"MONTH":s=d.getMonthStartDate(s);break;case"QUARTER":s=d.getQuarterStartDate(s);break;case"YEAR":s=d.getYearStartDate(s);break;default:throw new TypeError("invalid unit "+u);}}switch(u){case"DAY":if(D>0){s.setDate(s.getDate()+1);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+D);break;case"WEEK":if(D>0){s.setDate(s.getDate()+7);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+(D*7));break;case"MONTH":if(D>0){s.setMonth(s.getMonth()+1);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+D);break;case"QUARTER":if(D>0){s.setMonth(s.getMonth()+3);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+(D*3));break;case"YEAR":if(D>0){s.setFullYear(s.getFullYear()+1);}E=c(s);D=D==0?1:D;E.setFullYear(s.getFullYear()+D);break;default:throw new TypeError("invalid unit "+u);}if(E.getTime()<s.getTime()){E=[s,s=E][0];}E.setDate(E.getDate()-1);return[d.resetStartTime(s),d.resetEndTime(E)];};d.getWeekStartDate=function(u,l){var o=l?new L(l):sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),e=a.getInstance(o),f=e.getFirstDayOfWeek();u=u?c(u):c(d.createNewUniversalDate());u.setDate(u.getDate()-u.getDay()+f);return d.resetStartTime(u);};d.getWeekLastDate=function(u,l){var e=d.getWeekStartDate(u,l);e.setDate(e.getDate()+6);return d.resetStartTime(e);};d.getMonthStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setDate(1);return d.resetStartTime(u);};d.getMonthEndDate=function(u){var e=d.getMonthStartDate(u);e.setMonth(e.getMonth()+1);e.setDate(0);return d.resetStartTime(e);};d.getQuarterStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(3*Math.floor(u.getMonth()/3));u.setDate(1);return d.resetStartTime(u);};d.getQuarterEndDate=function(u){var e=d.getQuarterStartDate(u);e.setMonth(e.getMonth()+3);e.setDate(0);return d.resetStartTime(e);};d.getYearStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(0);u.setDate(1);return d.resetStartTime(u);};d.getYearEndDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setFullYear(u.getFullYear()+1);u.setMonth(0);u.setDate(0);return d.resetStartTime(u);};d.resetStartTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(0,0,0,0);return u;};d.resetEndTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(23,59,59,999);return u;};d.createNewUniversalDate=function(){return new U();};d.ranges={lastDays:function(D){return d.getRange(-D,"DAY");},yesterday:function(){return d.getRange(-1,"DAY");},today:function(){return d.getRange(0,"DAY");},tomorrow:function(){return d.getRange(1,"DAY");},nextDays:function(D){return d.getRange(D,"DAY");},lastWeeks:function(w){return d.getRange(-w,"WEEK");},lastWeek:function(){return d.getRange(-1,"WEEK");},currentWeek:function(){return d.getRange(0,"WEEK");},firstDayOfWeek:function(){var s=d.getWeekStartDate();return[s,d.resetEndTime(s)];},lastDayOfWeek:function(){var e=d.getWeekLastDate();return[e,d.resetEndTime(e)];},nextWeek:function(){return d.getRange(1,"WEEK");},nextWeeks:function(w){return d.getRange(w,"WEEK");},lastMonths:function(m){return d.getRange(-m,"MONTH");},lastMonth:function(){return d.getRange(-1,"MONTH");},currentMonth:function(){return d.getRange(0,"MONTH");},firstDayOfMonth:function(){var s=d.getMonthStartDate();return[s,d.resetEndTime(s)];},lastDayOfMonth:function(){var e=d.getMonthEndDate();return[e,d.resetEndTime(e)];},nextMonth:function(){return d.getRange(1,"MONTH");},nextMonths:function(m){return d.getRange(m,"MONTH");},lastQuarters:function(q){return d.getRange(-q,"QUARTER");},lastQuarter:function(){return d.getRange(-1,"QUARTER");},firstDayOfQuarter:function(){var s=d.getQuarterStartDate();return[s,d.resetEndTime(s)];},lastDayOfQuarter:function(){var e=d.getQuarterEndDate();return[e,d.resetEndTime(e)];},currentQuarter:function(){return d.getRange(0,"QUARTER");},nextQuarter:function(){return d.getRange(1,"QUARTER");},nextQuarters:function(q){return d.getRange(q,"QUARTER");},quarter:function(q){if(q<=2){return d.getRange(q-1,"QUARTER",d.getYearStartDate());}else{var r=d.getRange(q-2,"QUARTER",d.getYearStartDate());var s=r[1];s.setMilliseconds(1000);return d.getRange(0,"QUARTER",s);}},lastYears:function(y){return d.getRange(-y,"YEAR");},lastYear:function(){return d.getRange(-1,"YEAR");},firstDayOfYear:function(){var s=d.getYearStartDate();return[s,d.resetEndTime(s)];},lastDayOfYear:function(){var e=d.getYearEndDate();return[e,d.resetEndTime(e)];},currentYear:function(){return d.getRange(0,"YEAR");},nextYear:function(){return d.getRange(1,"YEAR");},nextYears:function(y){return d.getRange(y,"YEAR");},yearToDate:function(){var t=d.createNewUniversalDate();return[d.getYearStartDate(t),d.resetEndTime(t)];},dateToYear:function(){var t=d.createNewUniversalDate();return[d.resetStartTime(t),d.resetEndTime(d.getYearEndDate(t))];}};return d;});
