/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','./MessageProcessor','sap/base/util/uid','sap/base/Log'],function(B,M,u,L){"use strict";var m={"Error":0,"Warning":1,"Success":2,"Information":3,"None":4};var a=B.extend("sap.ui.core.message.Message",{constructor:function(p){B.apply(this,arguments);p=p||{};this.id=p.id?p.id:u();this.message=p.message;this.description=p.description;this.descriptionUrl=p.descriptionUrl;this.additionalText=p.additionalText;this.setType(p.type||sap.ui.core.MessageType.None);this.code=p.code;this.aTargets=[];if(p.target!==undefined){this.aTargets=Array.isArray(p.target)?p.target.slice():[p.target];}Object.defineProperty(this,"target",{get:this.getTarget,set:this.setTarget,enumerable:true});this.processor=p.processor;this.persistent=p.persistent||false;this.technical=p.technical||false;this.technicalDetails=p.technicalDetails;this.references=p.references||{};this.validation=!!p.validation;this.date=p.date||Date.now();this.controlIds=[];if(Array.isArray(p.fullTarget)){this.aFullTargets=p.fullTarget.length?p.fullTarget.slice():[""];}else{this.aFullTargets=[p.fullTarget||""];}Object.defineProperty(this,"fullTarget",{get:function(){return this.aFullTargets[0];},set:function(f){this.aFullTargets[0]=f;},enumerable:true});}});a.prototype.getId=function(){return this.id;};a.prototype.setMessage=function(s){this.message=s;};a.prototype.getMessage=function(){return this.message;};a.prototype.getControlId=function(){return this.controlIds[this.controlIds.length-1];};a.prototype.addControlId=function(c){if(this.controlIds.indexOf(c)==-1){this.controlIds=this.controlIds.slice();this.controlIds.push(c);}};a.prototype.removeControlId=function(c){var i=this.controlIds.indexOf(c);if(i!=-1){this.controlIds=this.controlIds.slice();this.controlIds.splice(i,1);}};a.prototype.getControlIds=function(){return this.controlIds;};a.prototype.setDescription=function(d){this.description=d;};a.prototype.getDescription=function(){return this.description;};a.prototype.setAdditionalText=function(A){this.additionalText=A;};a.prototype.getAdditionalText=function(){return this.additionalText;};a.prototype.getDescriptionUrl=function(){return this.descriptionUrl;};a.prototype.setDescriptionUrl=function(d){this.descriptionUrl=d;};a.prototype.setType=function(t){if(t in sap.ui.core.MessageType){this.type=t;}else{L.error("MessageType must be of type sap.ui.core.MessageType");}};a.prototype.getType=function(){return this.type;};a.prototype.setTarget=function(t){this.aTargets[0]=t;};a.prototype.getTarget=function(){return this.aTargets[0];};a.prototype.setTargets=function(n){this.aTargets=n.slice();};a.prototype.getTargets=function(){return this.aTargets.slice();};a.prototype.setMessageProcessor=function(o){if(o instanceof M){this.processor=o;}else{L.error("MessageProcessor must be an instance of sap.ui.core.message.MessageProcessor");}};a.prototype.getMessageProcessor=function(){return this.processor;};a.prototype.setCode=function(c){this.code=c;};a.prototype.getCode=function(){return this.code;};a.prototype.setPersistent=function(p){this.persistent=p;};a.prototype.getPersistent=function(){return this.persistent;};a.prototype.setTechnical=function(t){this.technical=t;};a.prototype.getTechnical=function(){return this.technical;};a.prototype.setTechnicalDetails=function(t){this.technicalDetails=t;};a.prototype.getTechnicalDetails=function(){return this.technicalDetails;};a.prototype.addReference=function(i,p){if(!i){return;}if(!this.references[i]){this.references[i]={properties:{}};}if(!this.references[i].properties[p]){this.references[i].properties[p]=true;}};a.prototype.removeReference=function(i,p){if(!i){return;}if(i in this.references){if(!p){delete this.references[i];}else if(this.references[i].properties[p]){delete this.references[i].properties[p];}}};a.prototype.setDate=function(d){this.date=d;};a.prototype.getDate=function(){return this.date;};a.compare=function(o,b){return m[o.type]-m[b.type];};return a;});
