/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/core/IconPool','sap/ui/core/Core','sap/m/library','sap/m/Popover','sap/m/Text','sap/ui/layout/form/SimpleForm','sap/m/Button','sap/m/Label','sap/m/Link','sap/ui/core/HTML','sap/ui/core/Title',"sap/ui/thirdparty/jquery"],function(M,I,C,m,P,T,S,B,L,a,H,b,q){'use strict';var c=m.PlacementType;var d=M.extend("sap.ui.core.support.controls.InteractionTree",{metadata:{library:"sap.ui.core"},constructor:function(){this.start=0;this.end=1;}});d.expandIcon='sap-icon://navigation-right-arrow';d.collapseIcon='sap-icon://navigation-down-arrow';d.prototype.setInteractions=function(i){this.interactions=i;this.start=0;this.end=1;this.updateRanges();};d.prototype.setRange=function(s,e){this.start=s;this.end=e;this.updateRanges();this.update();};d.prototype.updateRanges=function(){var i=this.interactions;if(!i||!i.length){return;}this.startTime=i[0].start;this.endTime=i[i.length-1].end;var r=this.endTime-this.startTime;this.actualStartTime=this.startTime+this.start*r;this.actualEndTime=this.startTime+this.end*r;this.timeRange=this.actualEndTime-this.actualStartTime;};d.prototype.update=function(){if(!this.parent){return;}q(this.parent).find('#'+this.getId()).remove();this.renderAt(this.parent);};d.prototype.renderAt=function(p){this.parent=p;var r=C.createRenderManager();this.render(r);r.flush(p,true);r.destroy();this.attachEvents();this.attachInteractionDetailsPopover();this.attachRequestDetailsPopover();};d.prototype.render=function(r){r.openStart("div",this.getId()).class("sapUiInteractionTreeContainer").class("sapUiSizeCompact").openEnd();r.openStart("div").class("sapUiInteractionGridLinesContainer").openEnd().close("div");r.openStart("ul").class("sapUiInteractionTree").openEnd();this.renderHeaders(r);var e,f=this.interactions;if(!f||!f.length){return;}for(var i=0;i<f.length;i++){e=f[i];this.renderInteraction(r,e,i);}r.close("ul");r.close("div");};d.prototype.attachEvents=function(){var t=this,i=q('.sapUiInteractionTreeContainer .sapUiInteractionTree');this.gridContainer=q('.sapUiInteractionTreeContainer .sapUiInteractionGridLinesContainer');this.gridContainerWidth=0;i.on('click',function(e){var $=q(e.target);if($.hasClass('sapUiInteractionLeft')){t.handleInteractionClick($);}});this.gridContainer.on("resize",function(e){t.updateGridLines();});q(window).on("resize",function(e){t.updateGridLines();});t.updateGridLines();};d.prototype.updateGridLines=function(){var g=this.gridContainer,r=this.timeRange,w=this.gridContainer.width(),e=C.createRenderManager();if(this.gridContainerWidth===w){return;}e.openStart("div").style("left",this.getPosition(w,r,0)+6+"px").class("sapUiInteractionGridLineIntervalText").openEnd().text(this.formatGridLineDuration(0)).close("div");var f=this.calculateInterval(w,r);for(var i=f;i<r;i+=f){var p=this.getPosition(w,r,i);if(i+f<r){e.openStart("div").style("left",p+6+"px").class("sapUiInteractionGridLineIntervalText").openEnd().text(this.formatGridLineDuration(i)).close("div");}e.openStart("div").style("left",p+"px").class("sapUiInteractionGridLine").openEnd().close("div");}g.empty();e.flush(g[0],true);e.destroy();this.gridContainerWidth=w;};d.prototype.calculateInterval=function(w,r){var e=4;var f=Math.max(w*e/200.0,1.0);var g=r/f;var h=Math.pow(10,Math.floor(Math.log(g)/Math.LN10));var j=[10,5,2,1];for(var i=0;i<j.length;i++){var k=j[i];var l=h*k;if(f<(r/l)){break;}g=l;}return g;};d.prototype.getPosition=function(w,r,v){var p=w/r*v;return p;};d.prototype.handleInteractionClick=function($){var e=$.find('.sapUiInteractionTreeIcon');if(!e.length){return;}var f=e.attr('expanded')=='true';var g=e.parent();e.remove();var r=C.createRenderManager();this.renderIcon(r,!f);r.flush(g[0],false,true);r.destroy();var h=g.parent().parent();h.toggleClass('sapUiInteractionItemExpanded');var i=parseInt(h.attr('data-interaction-index'));this.interactions[i].isExpanded=!f;var j=h.find('ul');var k=f?'slideUp':'slideDown';j.stop(true,true)[k]('fast',function(){j.toggleClass('sapUiHiddenUiInteractionItems');});};d.prototype.renderHeaders=function(r){r.openStart("li").openEnd();r.openStart("div").class("sapUiInteractionTreeItem").class("sapUiInteractionItemDiv").class("sapUiInteractionHeader").openEnd();r.openStart("div").class("sapUiInteractionTreeItemLeft").openEnd();r.openStart("div").openEnd();r.openStart("span").class("sapUiInteractionItemComponentText").openEnd().text("Component").close("span");r.voidStart("br").voidEnd();r.openStart("span").class("sapUiInteractionItemTriggerText").openEnd().text("Trigger").close("span");r.close("div");r.close("div");r.openStart("div").class("sapUiInteractionTreeItemRight").openEnd().close("div");r.close("div");r.close("li");};d.prototype.isInteractionVisible=function(i){var s=i.start;var e=i.end;if(this.actualStartTime>e||this.actualEndTime<s){return false;}if(this.actualStartTime<s+i.duration&&this.actualEndTime>s){return true;}return this.hasVisibleRequests(i);};d.prototype.hasVisibleRequests=function(e){var r,s,f,g=e.requests;for(var i=0;i<g.length;i++){r=g[i];s=r.fetchStartOffset+r.startTime;f=r.fetchStartOffset+r.startTime+this.getRequestDuration(r);if(this.actualStartTime<f&&this.actualEndTime>s){return true;}}return false;};d.prototype.renderInteraction=function(r,e,f){var g,h=e.requests;if(!this.isInteractionVisible(e)){return;}r.openStart("li").attr("data-interaction-index",f);if(e.isExpanded){r.class('sapUiInteractionItemExpanded');}r.openEnd();this.renderInteractionDiv(r,e);r.openStart("ul");r.class("sapUiInteractionItem");if(!e.isExpanded){r.class("sapUiHiddenUiInteractionItems");}r.openEnd();for(var i=0;i<h.length;i++){g=h[i];this.renderRequest(r,e,g,i);}r.close("ul");r.close("li");};d.prototype.renderInteractionDiv=function(r,i){r.openStart("div");r.class("sapUiInteractionTreeItem");r.class("sapUiInteractionItemDiv");r.openEnd();r.openStart("div").class("sapUiInteractionLeft").class("sapUiInteractionTreeItemLeft").openEnd();r.openStart("div").openEnd();r.openStart("span").class("sapUiInteractionItemComponentText").openEnd();r.text((i.component!=="undetermined")?i.component:'Initial Loading');r.close("span");r.voidStart("br").voidEnd();r.openStart("span").class("sapUiInteractionItemTriggerText").openEnd().text(i.trigger+" / "+i.event).close("span");r.close("div");if(i.requests.length){this.renderIcon(r,i.isExpanded);}if(i.sapStatistics.length&&i.requests.length){r.openStart("div").class("sapUiInteractionHeaderIcon").openEnd();r.voidStart("img").class("sapUiInteractionSvgImage").attr("src","HeaderIcon.svg").voidEnd();r.close("div");}r.close("div");r.openStart("div").class("sapUiInteractionTreeItemRight").openEnd();var e=Math.round(i.start+i.duration);this.renderInteractionPart(r,i.start,e,'sapUiInteractionBlue');r.close("div");r.close("div");};d.prototype.renderInteractionPart=function(r,s,e,f){if(this.actualStartTime>e||this.actualEndTime<s){return;}e=Math.min(e,this.actualEndTime);s=Math.max(s,this.actualStartTime);var l=100/this.timeRange*(s-this.actualStartTime);var g=100/this.timeRange*(e-this.actualStartTime);var w=g-l;r.openStart("span").style("margin-left",l+"%").style("width",w+"%").class("sapUiInteractionTimeframe").class("sapUiInteractionTimeInteractionFrame").class(f).openEnd().close("span");};d.prototype.renderRequest=function(r,i,e,f){var g=e.fetchStartOffset;var s=g+e.startTime;var h=g+e.startTime+this.getRequestDuration(e);if(this.actualStartTime>h||this.actualEndTime<s){return;}r.openStart("li").attr("data-request-index",f).class("sapUiInteractionTreeItem").class("sapUiInteractionRequest").openEnd();r.openStart("div").class("sapUiInteractionTreeItemLeft").class("sapUiInteractionRequestLeft").openEnd();var j=e.initiatorType||e.entryType;var k=this.getRequestColorClass(j);r.openStart("span").class("sapUiInteractionRequestIcon").class(k).openEnd().close("span");r.openStart("span").class("sapUiInteractionItemEntryTypeText").openEnd().text(j).close("span");if(this.getRequestSapStatistics(i,e)){r.openStart("div").class("sapUiInteractionRequestHeaderIcon").openEnd();r.voidStart("img").class("sapUiInteractionSvgImage").attr("src","HeaderIcon.svg").voidEnd();r.close("div");}r.close("div");r.openStart("div").class("sapUiInteractionTreeItemRight").openEnd();var l=this.getRequestRequestStart(e)+g;var n=this.getRequestResponseStart(e)+g;this.renderRequestPart(r,s,l,k+'70');this.renderRequestPart(r,l,n,k);this.renderRequestPart(r,n,h,k+'70');r.close("div");r.close("li");};d.prototype.getRequestSapStatistics=function(i,r){var s,e=i.sapStatistics;for(var j=0;j<e.length;j++){if(e[j].timing&&r.startTime===e[j].timing.startTime){s=e[j];return s;}}return false;};d.prototype.getRequestColorClass=function(r){var e;switch(r){case'xmlhttprequest':e='sapUiPurple';break;case'OData':e='sapUiRed';break;case'link':case'css':e='sapUiAccent1';break;default:e='sapUiAccent8';break;}return e;};d.prototype.attachRequestDetailsPopover=function(){var s,e,p,f,g,h,n,j,k,l,o,t,r,u,v,w,x;var y=this;var z=q('.sapUiInteractionRequest.sapUiInteractionTreeItem .sapUiInteractionTreeItemRight');if(z.length){var A=G();for(var i=0;i<z.length;i++){z[i].addEventListener('click',function(K){E.call(this);D.call(this);var N=q(this).children()[0];A.openBy(N);F.call(this);});}}function D(){var $=q(this);var K=$.parents('li[data-request-index]');var N=$.parents('li[data-interaction-index]');var O=parseInt(N.attr('data-interaction-index'));var Q=parseInt(K.attr('data-request-index'));var R=y.interactions[O];var U=R.requests[Q];if(!R||!U){return;}var V=y.getRequestSapStatistics(R,U);if(V){if(!o.getParent()){s.addContent(o);s.addContent(t);s.addContent(r);s.addContent(u);s.addContent(v);s.addContent(w);s.addContent(x);}var W=V.statistics;r.setText(y.formatDuration(parseFloat(W.substring(W.indexOf("total=")+"total=".length,W.indexOf(",")))));W=W.substring(W.indexOf(",")+1);v.setText(y.formatDuration(parseFloat(W.substring(W.indexOf("fw=")+"fw=".length,W.indexOf(",")))));W=W.substring(W.indexOf(",")+1);x.setText(y.formatDuration(parseFloat(W.substring(W.indexOf("app=")+"app=".length,W.indexOf(",")))));}else if(o.getParent()){s.removeContent(o);s.removeContent(t);s.removeContent(r);s.removeContent(u);s.removeContent(v);s.removeContent(w);s.removeContent(x);}}function E(){var K=y.getRequestFromElement(q(this));g.setText(K.initiatorType||'');h.setText(K.entryType||'');n.setText(K.name);n.setHref(K.name);var N=y.getRequestDuration(K);var O=K.fetchStartOffset+K.startTime;var Q=O+N;j.setText(y.formatTime(O));k.setText(y.formatTime(Q));l.setText(y.formatDuration(N));}function F(){var K=C.createRenderManager();var N=y.getRequestFromElement(q(this));var O=N.fetchStartOffset;var Q=y.getRequestDuration(N);var R=O+N.startTime;var U=R+Q;var V=y.getRequestRequestStart(N)+O;var W=y.getRequestResponseStart(N)+O;var X=V-R;var Y=W-V;var Z=U-W;var $=Math.floor(100*Y/Q);var _=Math.floor(100*Z/Q);var a1=Math.floor(100*X/Q);K.openStart("div").class("sapUiInteractionTitle").openEnd();[['PREPROCESSING',y.formatDuration(X)],['SERVER',y.formatDuration(Y)],['CLIENT',y.formatDuration(Z)]].forEach(function(e1){K.openStart("span").class("sapUiInteractionTitleSection").openEnd();K.openStart("div").class("sapUiInteractionTitleText").openEnd().text(e1[0]).close("div");K.openStart("div").class("sapUiInteractionTitleSubText").openEnd().text(e1[1]).close("div");K.close("span");});K.close("div");K.flush(q(".sapUiSupportPopoverTitle")[0],true);K.destroy();var b1=N.initiatorType||N.entryType;var c1=y.getRequestColorClass(b1);var d1=c1+'70';K=C.createRenderManager();K.openStart("div").class("sapUiSupportIntProgressBarParent").openEnd();K.openStart("span").class("sapUiSupportIntProgressBar").class(d1).style("width","calc("+a1+"% - 1px)").openEnd().close("span");K.openStart("span").class("sapUiSupportIntProgressBarSeparator").openEnd().close("span");K.openStart("span").class("sapUiSupportIntProgressBar").class(c1).style("width","calc("+$+"% - 1px)").openEnd().close("span");K.openStart("span").class("sapUiSupportIntProgressBarSeparator").openEnd().close("span");K.openStart("span").class("sapUiSupportIntProgressBar").class(d1).style("width","calc("+_+"% - 1px)").openEnd().close("span");K.close("div");K.flush(q(".sapUiSupportPopoverProgressBar")[0],true);K.destroy();}function G(){var A=new P({placement:c.Auto,contentWidth:"400px",showHeader:false,showArrow:true,verticalScrolling:true,horizontalScrolling:false,content:[J()]}).addStyleClass('sapUiSupportPopover');A.attachAfterOpen(function(K){K.getSource().$().trigger("focus");});return A;}function J(){e=new H({content:'<div class="sapUiSupportPopoverTitle"></div>',preferDOM:false});p=new H({content:'<div class="sapUiSupportPopoverProgressBar"></div>',preferDOM:false});f=new B({icon:I.getIconURI("decline"),type:"Transparent",press:function(){A.close();}}).addStyleClass("sapUiSupportReqPopoverCloseButton");f.setTooltip("Close");g=new T().addStyleClass("sapUiSupportIntRequestText");h=new T().addStyleClass("sapUiSupportIntRequestText");n=new a({target:"_blank",wrapping:true}).addStyleClass("sapUiSupportIntRequestLink");j=new T().addStyleClass("sapUiSupportIntRequestText");k=new T().addStyleClass("sapUiSupportIntRequestText");l=new T().addStyleClass("sapUiSupportIntRequestText");o=new b({text:"SAP STATISTICS FOR ODATA CALLS"});t=new L({text:"Gateway Total"}).addStyleClass("sapUiSupportIntRequestLabel");r=new T().addStyleClass("sapUiSupportIntRequestText");u=new L({text:"Framework"}).addStyleClass("sapUiSupportIntRequestLabel");v=new T().addStyleClass("sapUiSupportIntRequestText");w=new L({text:"Application"}).addStyleClass("sapUiSupportIntRequestLabel");x=new T().addStyleClass("sapUiSupportIntRequestText");s=new S({maxContainerCols:2,minWidth:400,labelMinWidth:100,editable:false,layout:"ResponsiveGridLayout",labelSpanM:3,emptySpanM:0,columnsM:1,breakpointM:0,content:[new b({text:"REQUEST DATA"}),new L({text:"Initiator Type"}).addStyleClass("sapUiSupportIntRequestLabel"),g,new L({text:"Entry Type"}).addStyleClass("sapUiSupportIntRequestLabel"),h,new L({text:"Name"}).addStyleClass("sapUiSupportIntRequestLabel"),n,new L({text:"Start Time"}).addStyleClass("sapUiSupportIntRequestLabel"),j,new L({text:"End Time"}).addStyleClass("sapUiSupportIntRequestLabel"),k,new L({text:"Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),l]});return[e,p,f,s];}};d.prototype.getRequestFromElement=function($){var e=$.parents('li[data-request-index]');var f=$.parents('li[data-interaction-index]');var i=parseInt(f.attr('data-interaction-index'));var r=parseInt(e.attr('data-request-index'));var g=this.interactions[i].requests[r];return g;};d.prototype.attachInteractionDetailsPopover=function(){var s,e,f,p,r,g,h,j,k;var t=this;var l=q('.sapUiInteractionItemDiv.sapUiInteractionTreeItem .sapUiInteractionTreeItemRight');if(l.length){var o=u();for(var i=0;i<l.length;i++){l[i].addEventListener('click',function(w){n.call(this);var x=q(this).children()[0];o.openBy(x);});}}function n(){var $=q(this).parent().parent();var w=parseInt($.attr('data-interaction-index'));var x=t.interactions[w];if(!x){return;}f.setText(t.formatDuration(x.duration));p.setText(t.formatDuration(x.duration-x.roundtrip));r.setText(t.formatDuration(x.requestTime));g.setText(t.formatDuration(x.roundtrip));h.setText(x.bytesReceived);j.setText(x.requests.length);k.setText(t.formatTime(x.start));}function u(){var o=new P({placement:c.Auto,contentWidth:"350px",showHeader:false,showArrow:true,verticalScrolling:true,horizontalScrolling:false,content:[v()]}).addStyleClass('sapUiSupportPopover');o.attachAfterOpen(function(E){E.getSource().$().trigger("focus");});return o;}function v(){e=new B({icon:I.getIconURI("decline"),type:"Transparent",press:function(){o.close();}}).addStyleClass("sapUiSupportIntPopoverCloseButton");e.setTooltip("Close");f=new T().addStyleClass("sapUiSupportIntRequestText");p=new T().addStyleClass("sapUiSupportIntRequestText");r=new T().addStyleClass("sapUiSupportIntRequestText");g=new T().addStyleClass("sapUiSupportIntRequestText");h=new T().addStyleClass("sapUiSupportIntRequestText");j=new T().addStyleClass("sapUiSupportIntRequestText");k=new T().addStyleClass("sapUiSupportIntRequestText");s=new S({maxContainerCols:2,minWidth:400,labelMinWidth:100,editable:false,layout:"ResponsiveGridLayout",labelSpanM:7,emptySpanM:0,columnsM:1,breakpointM:0,content:[new b({text:"INTERACTION DATA"}),new L({text:"Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),f,new L({text:"Client Processing Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),p,new L({text:"Total Requests Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),r,new L({text:"Roundtrip Duration"}).addStyleClass("sapUiSupportIntRequestLabel"),g,new L({text:"Bytes Received"}).addStyleClass("sapUiSupportIntRequestLabel"),h,new L({text:"Request Count"}).addStyleClass("sapUiSupportIntRequestLabel"),j,new L({text:"Start Time"}).addStyleClass("sapUiSupportIntRequestLabel"),k]}).addStyleClass("sapUiSupportIntPopoverForm");return[e,s];}};d.prototype.renderRequestPart=function(r,s,e,f){if(this.actualStartTime>e||this.actualEndTime<s){return;}e=Math.min(e,this.actualEndTime);s=Math.max(s,this.actualStartTime);var l=100/this.timeRange*(s-this.actualStartTime);var g=100/this.timeRange*(e-this.actualStartTime);var w=g-l;r.openStart("span").style("margin-left",l+"%").style("width",w+"%").class("sapUiInteractionTimeframe").class("sapUiInteractionTimeRequestFrame").class(f).openEnd().close("span");};d.prototype.getRequestDuration=function(r){if(r.duration>0){return r.duration;}var e=r.responseStart||r.requestStart||r.fetchStart;return e-r.startTime;};d.prototype.getRequestRequestStart=function(r){if(r.requestStart>0){return r.requestStart;}return r.fetchStart||r.startTime;};d.prototype.getRequestResponseStart=function(r){if(r.responseStart>0){return r.responseStart;}return r.requestStart||r.fetchStart||r.startTime;};d.prototype.pad0=function(i,w){return("000"+String(i)).slice(-w);};d.prototype.formatGridLineDuration=function(e){var o=this.actualStartTime-this.startTime;e+=o;return e>100?(e/1000).toFixed(2)+' s':e.toFixed(0)+' ms';};d.prototype.formatDuration=function(e){e=Math.max(e,0);if(e<3){return e.toFixed(2)+' ms';}return e>=1000?(e/1000).toFixed(3)+' s':e.toFixed(0)+' ms';};d.prototype.formatTime=function(n){var N=new Date(n);return this.pad0(N.getHours(),2)+":"+this.pad0(N.getMinutes(),2)+":"+this.pad0(N.getSeconds(),2)+"."+this.pad0(N.getMilliseconds(),3);};d.prototype.renderIcon=function(r,e){var i=e?d.collapseIcon:d.expandIcon;r.openStart("span").attr("aria-hidden","true").attr("expanded",e).class("sapUiIcon").class("sapUiInteractionTreeIcon");if(f&&!f.suppressMirroring){r.class("sapUiIconMirrorInRTL");}var f=I.getIconInfo(i);if(f){r.attr("data-sap-ui-icon-content",f.content);r.style("font-family","SAP-icons");}r.openEnd().close("span");};return d;});
