/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/BindingParser","./BaseTreeModifier","./XmlTreeModifier","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/base/util/merge","sap/ui/core/Fragment"],function(B,a,X,O,b,m,F){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return Promise.resolve(c.getVisible());}else{return Promise.reject(new Error("Provided control instance has no getVisible method"));}},setStashed:function(c,s){s=!!s;if(c.unstash){if(c.isStashed()===true&&s===false){c=c.unstash();}if(c.setVisible){this.setVisible(c,!s);}return c;}else{throw new Error("Provided control instance has no unstash method");}},getStashed:function(c){if(c.isStashed){if(c.isStashed()){return Promise.resolve(true);}return this.getVisible(c).then(function(i){return!i;});}return Promise.reject(new Error("Provided control instance has no isStashed method"));},bindProperty:function(c,p,v){c.bindProperty(p,v);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var M=c.getMetadata().getPropertyLikeSetting(p);var o;var e;this.unbindProperty(c,p);try{o=B.complexParser(P,undefined,true);}catch(d){e=true;}if(M){if(this._isSerializable(P)){if(o&&typeof o==="object"||e){P=this._escapeCurlyBracketsInString(P);}var s=M._sMutator;c[s](P);}else{throw new TypeError("Value cannot be stringified","sap.ui.core.util.reflection.JsControlTreeModifier");}}},getProperty:function(c,p){var M=c.getMetadata().getPropertyLikeSetting(p);var P;if(M){var s=M._sGetter;P=c[s]();}return Promise.resolve(P);},isPropertyInitial:function(c,p){return c.isPropertyInitial(p);},setPropertyBinding:function(c,p,P){this.unbindProperty(c,p);var s={};s[p]=P;return c.applySettings(s);},getPropertyBinding:function(c,p){return c.getBindingInfo(p);},createAndAddCustomData:function(c,C,v,A){return this.createControl("sap.ui.core.CustomData",A).then(function(o){this.setProperty(o,"key",C);this.setProperty(o,"value",v);return this.insertAggregation(c,"customData",o,0);}.bind(this));},createControl:function(c,A,v,s,S){c=c.replace(/\./g,"/");if(this.bySelector(s,A)){var e="Can't create a control with duplicated ID "+(s.id||s);return Promise.reject(e);}var p;var C=sap.ui.require(c);if(C){p=Promise.resolve(C);}else{p=new Promise(function(r,R){sap.ui.require([c],function(C){r(C);},function(){R(new Error("Required control '"+c+"' couldn't be created asynchronously"));});});}return p.then(function(d){var i=this.getControlIdBySelector(s,A);return new d(i,S);}.bind(this));},applySettings:function(c,s){return Promise.resolve(c.applySettings(s));},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent&&c.getParent();},getControlMetadata:function(c){return Promise.resolve(c&&c.getMetadata());},getControlType:function(c){return c&&c.getMetadata().getName();},setAssociation:function(p,n,i){var M=p.getMetadata().getAssociation(n);M.set(p,i);},getAssociation:function(p,n){var M=p.getMetadata().getAssociation(n);return M.get(p);},getAllAggregations:function(p){return Promise.resolve(p.getMetadata().getAllAggregations());},getAggregation:function(p,n){return this.findAggregation(p,n).then(function(A){if(A){return p[A._sGetter]();}return undefined;});},insertAggregation:function(p,n,o,i){if(n==="customData"){return p.insertAggregation(n,o,i,true);}return this.findAggregation(p,n).then(function(A){if(A){if(A.multiple){var I=i||0;p[A._sInsertMutator](o,I);}else{p[A._sMutator](o);}}});},removeAggregation:function(c,n,o){if(n==="customData"){c.removeAggregation(n,o,true);return Promise.resolve();}return this.findAggregation(c,n).then(function(A){if(A){c[A._sRemoveMutator](o);}});},removeAllAggregation:function(c,n){if(n==="customData"){c.removeAllAggregation(n,true);return Promise.resolve();}return this.findAggregation(c,n).then(function(A){if(A){c[A._sRemoveAllMutator]();}});},getBindingTemplate:function(c,A){var o=c.getBindingInfo(A);return Promise.resolve(o&&o.template);},updateAggregation:function(c,A){return this.findAggregation(c,A).then(function(o){if(o&&c.getBinding(A)){c[o._sDestructor]();c.updateAggregation(A);}});},findIndexInParentAggregation:function(c){var p=this.getParent(c);if(!p){return Promise.resolve(-1);}return this.getParentAggregationName(c).then(function(P){return this.getAggregation(p,P);}.bind(this)).then(function(C){if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}});},getParentAggregationName:function(c){return Promise.resolve(c.sParentAggregationName);},findAggregation:function(c,A){return new Promise(function(r,d){if(c){if(c.getMetadata){var M=c.getMetadata();var o=M.getAllAggregations();if(o){r(o[A]);return;}}}r();});},validateType:function(c,A,p,f){var t=A.type;return this.getAggregation(p,A.name).then(function(o){if(A.multiple===false&&o&&o.length>0){return false;}return c.isA(t);});},instantiateFragment:function(f,n,v){var o=b.parse(f);return this._checkAndPrefixIdsInFragment(o,n).then(function(o){return F.load({definition:o,sId:v&&v.getId(),controller:v.getController()});}).then(function(N){if(N&&!Array.isArray(N)){N=[N];}return N||[];});},templateControlFragment:function(f,p,v){return a._templateFragment(f,p).then(function(o){var c=(v&&v.getController())||undefined;return F.load({definition:o,controller:c});});},destroy:function(c,s){c.destroy(s);},_getFlexCustomData:function(c,t){var C=typeof c==="object"&&typeof c.data==="function"&&c.data("sap-ui-custom-settings");return O.get(["sap.ui.fl",t],C);},attachEvent:function(o,e,f,d){return new Promise(function(r,R){var c=O.get(f);if(typeof c!=="function"){R(new Error("Can't attach event because the event handler function is not found or not a function."));}r(o.attachEvent(e,d,c));});},detachEvent:function(o,e,f){return new Promise(function(r,R){var c=O.get(f);if(typeof c!=="function"){R(new Error("Can't attach event because the event handler function is not found or not a function."));}r(o.detachEvent(e,c));});},bindAggregation:function(c,A,o){return Promise.resolve(c.bindAggregation(A,o));},unbindAggregation:function(c,A){return Promise.resolve(c.unbindAggregation(A));},getExtensionPointInfo:function(e,v){var V=(v._xContent)?v._xContent:v;return X.getExtensionPointInfo(e,V).then(function(E){if(E){E.index--;E.parent=E.parent&&this._byId(v.createId(E.parent.getAttribute("id")));E.defaultContent=E.defaultContent.map(function(n){var i=v.createId(n.getAttribute("id"));return this._byId(i);}.bind(this)).filter(function(c){return!!c;});}return E;}.bind(this));}};return m({},a,J);},true);
