/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ControlObserver","sap/ui/dt/ManagedObjectObserver","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/DOMUtil","sap/ui/dt/Util","sap/ui/core/Control","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/base/util/restricted/_intersection","sap/base/util/restricted/_max"],function(O,a,b,C,M,E,c,D,U,d,q,L,i,m,_,e){"use strict";var S="sapUiDtOverlayScrollContainer";var f=O.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},aggregations:{aggregationBindingTemplateOverlays:{type:"sap.ui.dt.Overlay",multiple:true,defaultValue:[]}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"},ignoreEnterKeyUpOnce:{type:"boolean",defaultValue:false}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}});f.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this.attachEvent("elementModified",function(o){var p=o.getParameters();var n=p.name;if(p.type==="propertyChanged"){if(n==="visible"){this.setRelevantOverlays([]);}}else if(n){this.setRelevantOverlays([]);}},this);this._initMutationObserver();this._initControlObserver();}.bind(this));};f.prototype._updateScrollContainer=function(p){if(this.getShouldBeDestroyed()||this.bIsDestroyed){return;}var I=p.index;var o=this.getScrollContainerById(I);var n=this.getScrollContainers(true)[I];var A=[].concat(n.aggregations);var g=o.find(">:not(.sapUiDtDummyScrollContainer)").toArray();g.forEach(function(j){var s=j.getAttribute("data-sap-ui-dt-aggregation");if(n.aggregations.includes(s)){A.splice(A.indexOf(s),1);}else{o.get(0).removeChild(j);D.appendChild(this.getChildrenDomRef(),j);}}.bind(this));A.forEach(function(s){var j=this.getAggregationOverlay(s).getDomRef();this.getChildrenDomRef().removeChild(j);D.appendChild(o.get(0),j);}.bind(this));};f.prototype._onRootChanged=function(o){var r=o.getParameter("value");this._subscribeToMutationObserver(r);};f.prototype._initMutationObserver=function(){this._subscribeToMutationObserver(this.isRoot());this.attachEvent("isRootChanged",this._onRootChanged,this);};f.prototype._subscribeToMutationObserver=function(I){var o=O.getMutationObserver();var $=this.getAssociatedDomRef();this._sObservableNodeId=$&&$.get(0)&&$.get(0).id;if(this._sObservableNodeId){o.registerHandler(this._sObservableNodeId,this._domChangedCallback.bind(this),I);}else if(I){L.error("sap.ui.dt.ElementOverlay#_subscribeToMutationObserver: please provide a root control with proper domRef and id to ensure that RTA is working properly");}};f.prototype._unsubscribeFromMutationObserver=function(){if(this._sObservableNodeId){var o=O.getMutationObserver();o.deregisterHandler(this._sObservableNodeId);delete this._sObservableNodeId;}};f.prototype._initControlObserver=function(){if(this.getElement()instanceof d){this._oObserver=new C({target:this.getElement(),aggregations:this.getAggregationNames()});}else{this._oObserver=new M({target:this.getElement(),aggregations:this.getAggregationNames()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};f.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};f.prototype._getAttributes=function(){return m({},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),draggable:this.getMovable()});};f.prototype.render=function(){this.addStyleClass("sapUiDtElementOverlay");return O.prototype.render.apply(this,arguments);};f.prototype.exit=function(){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};f.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(g){var o=this.getElement();if(!o||o.bIsDestroyed){throw U.createError("ElementOverlay#loadDesignTimeMetadata","Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(g);}.bind(this)).catch(function(v){throw U.propagateError(v,"ElementOverlay#loadDesignTimeMetadata",U.printf("Can't load designtime metadata data for overlay with id='{1}', element id='{2}': {3}",this.getId(),this.getAssociation("element"),U.wrapError(v).message));}.bind(this));};f.prototype._setPosition=function(t,g,p,F){O.prototype._setPosition.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var j=this.getScrollContainerById(I);if($.length){var o=$.get(0);var k=D.getGeometry(o);this._setSize(j,k);O.prototype._setPosition.call(this,j,k,this.$());this._handleOverflowScroll(k,j,this,F);this._setZIndex(k,j);}else{j.css("display","none");}},this);};f.prototype._applySizes=function(){return O.prototype._applySizes.apply(this,arguments).then(function(){this._sortChildren(this.getChildrenDomRef());if(!this.bIsDestroyed){this.getScrollContainers().forEach(function(s,I){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||q();var g=this.getScrollContainerById(I);if($.length){this._sortChildren(g.get(0));}},this);}}.bind(this));};f.prototype._sortChildren=function(o){function g(l,n){var G=D.getGeometry(l);var p=D.getGeometry(n);var P=G&&G.position;var r=p&&p.position;if(P&&r){var B=P.top+G.size.height;var t=r.top+p.size.height;if(P.top<r.top){if(B>=t&&r.left<P.left){return 1;}return-1;}else if(P.top===r.top){if(P.left===r.left){if(G.size.height<p.size.height||G.size.width<p.size.width){return-1;}else if(G.size.height>p.size.height||G.size.width>p.size.width){return 1;}return 0;}else if(P.left<r.left){return-1;}return 1;}else if(B<=t&&r.left>P.left){return-1;}return 1;}return 0;}var j=q(o).find(">:not(.sapUiDtDummyScrollContainer)").toArray();var s=j.slice().sort(g);var k=j.some(function(l,I){return l!==s[I];});if(k){s.forEach(function(l){D.appendChild(o,l);});}};f.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{L.error("sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?");}}else{L.error("sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy");}}else{L.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};f.prototype.setDesignTimeMetadata=function(v){var o=this.getDesignTimeMetadata();var g;if(typeof v==="function"){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(v);}else{o.setData(v(m({},o.getData())));return;}}else if(v instanceof E){o=v;}else if(i(v)){g=v;var j;while(j=this._aMetadataEnhancers.shift()){g=j.call(this,g);}o=new E({data:g});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};f.prototype.getScrollContainers=function(I){return this.getDesignTimeMetadata().getScrollContainers(this.getElement(),I,this._updateScrollContainer.bind(this));};f.prototype._renderChildren=function(){var g=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,I){var $=q("<div></div>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":I});if(s.aggregations){_(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var j=g.indexOf(o.$());o.setScrollContainerId(I);$.append(g[j]);g.splice(j,1);},this);}g.push($);},this);return g;};f.prototype.getScrollContainerById=function(I){return q(this.getChildrenDomRef()).find(">."+S+'[data-sap-ui-dt-scrollcontainerindex="'+I+'"]');};f.prototype.getAssociatedDomRef=function(){var o=this.getDesignTimeMetadata();var v=o.getDomRef();var g=o.getAssociatedDomRef(this.getElement(),v);if(!g){g=c.getDomRef(this.getElement());}if(g){return q(g);}return undefined;};f.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};f.prototype.setSelected=function(s){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);var A=b.getClosestBoundControl(this);if(A.overlayId){var B=a.getOverlay(A.overlayId);h(A,B);}this.fireSelectionChange({selected:s});}return this;};function h(A,o,s){s=s===undefined?A.stack.length-1:s;var g=A.stack[s];var l=s===0;var t=A.stack.length===1;if(g){o.getChildren().forEach(function(j){if(j.getAggregationName()===g.aggregation){j.getChildren().some(function(k,I){if(l&&t){k.toggleStyleClass("sapUiDtOverlayHighlighted");}else if(l&&I===g.index){k.toggleStyleClass("sapUiDtOverlayHighlighted");return true;}else if(!l){h(A,k,s-1);}return undefined;});}});}}f.prototype.setMovable=function(g){g=!!g;if(this.getMovable()!==g){this.toggleStyleClass("sapUiDtOverlayMovable",g);this.setProperty("movable",g);this.fireMovableChange({movable:g});this.$()[g?"attr":"removeAttr"]("draggable",g);}return this;};f.prototype.setEditable=function(g){g=!!g;if(this.getEditable()!==g){this.toggleStyleClass("sapUiDtOverlayEditable",g);this.setProperty("editable",g);this.fireEditableChange({editable:g});}return this;};f.prototype.getAggregationNames=function(){var o=this.getElement();var g=this.getDesignTimeMetadata();var A=o.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(g.getAggregations())).filter(function(s,I,j){return(I===j.indexOf(s)&&!g.isAggregationIgnored(o,s));});};f.prototype._onChildAdded=function(o){var A=o.getSource();if(this.isRendered()&&!A.isRendered()){var t=(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):q(this.getChildrenDomRef()));t.append(A.render());}};f.prototype.addChild=function(A){A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};f.prototype._onElementModified=function(o){if(o.getParameters().type==="afterRendering"){this._subscribeToMutationObserver(this.isRoot());this._oScrollbarSynchronizers.forEach(function(s){s.refreshListeners();});}this.fireElementModified(o.getParameters());};f.prototype._domChangedCallback=function(p){p.targetOverlay=this;if(this.isReady()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.fireApplyStylesRequired(p);delete this._iApplyStylesRequest;}.bind(this));}};f.prototype._onElementDestroyed=function(o){var s=o.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};f.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};f.prototype.getAggregationOverlay=function(A,s){var g="get"+(s||"Children");return this[g]().filter(function(o){return o.getAggregationName()===A;}).pop();};f.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}return undefined;};f.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};f.prototype.isSelected=function(){return this.getSelected();};f.prototype.isSelectable=function(){return this.getSelectable();};f.prototype.isMovable=function(){return this.getMovable();};f.prototype.isEditable=function(){return this.getEditable();};f.prototype._getElementInstanceVisible=function(){var o=this.getElement();if(o){var g=this.getGeometry();return g&&g.visible;}return false;};f.prototype.getElementVisibility=function(){var o=this.getElement();if(o instanceof sap.ui.core.Control){return o.getVisible();}var g=this.getDesignTimeMetadata();var j=g&&g.getData().isVisible;if(!j){return undefined;}return j(this.getElement());};f.prototype.isElementVisible=function(){var o=this.getElement();var v=false;var g=this.getDesignTimeMetadata();var j=g.getData();if(g.isIgnored(o)){v=false;}else if(typeof j.isVisible==="function"){v=j.isVisible(o);}else{var G=this.getGeometry(true);if(G){v=G.visible;}else if(o instanceof d){v=!!o.getDomRef()&&o.getVisible();}}return v;};f.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};f.prototype.getRelevantContainer=function(F){var o=this.getDesignTimeMetadata();if(o&&o.getData().relevantContainer){return o.getData().relevantContainer;}else if(F){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};f.prototype._hasSameSize=function(s,t){var g=this.getScrollContainers();var j;if(g.length){j=e(g.map(function(k,I){var G=D.getGeometry(this.getScrollContainerById(I).get(0));return G.size[t];},this));}else{j=this.getGeometry().size[t];}return s.size[t]===j;};return f;});
