/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/write/_internal/Storage","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/base/util/includes","sap/base/util/merge","sap/base/util/restricted/_union","sap/base/util/UriParameters","sap/base/Log","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/condenser/Condenser"],function(D,S,C,L,V,U,a,b,c,A,d,J,e,f,M,i,m,u,g,h,j,F,k){"use strict";var l=function(x){this._mComponent=x;this._mChanges=D.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=m({},this._mChanges);if(!this._mComponent||!this._mComponent.name){h.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};function n(x,y){var z;if(y instanceof C){z=y;this._mChangesEntries[z.getFileName()]=z;}else{if(!this._mChangesEntries[y.fileName]){this._mChangesEntries[y.fileName]=new C(y);}z=this._mChangesEntries[y.fileName];z.setState(C.states.PERSISTED);}return z;}l.prototype.getComponentName=function(){return this._mComponent.name;};l.prototype.getCacheKey=function(x){return b.getCacheKey(this._mComponent,x);};l.prototype._preconditionsFulfilled=function(x){var y=x instanceof C?x.getDefinition():x;function z(){if((y.fileType==="ctrl_variant")||(y.fileType==="ctrl_variant_change")||(y.fileType==="ctrl_variant_management_change")){return y.variantManagementReference||y.variantReference||(y.selector&&y.selector.id);}}return y.fileType==="change"||z();};l.prototype.getChangesForComponent=function(P,I){return U.getUShellService("URLParsing").then(function(x){this._oUShellURLParsingService=x;return b.getChangesFillingCache(this._mComponent,P,I);}.bind(this)).then(function(P,W){var x=m({},W);var y=P&&P.component&&U.getAppComponentForControl(P.component);var H=S.isStorageResponseFilled(x.changes);if(!H){return[];}var z=x.changes.changes;if(!this._oMessagebundle&&x.messagebundle&&y){if(!y.getModel("i18nFlexVendor")){if(z.some(function(Q){return Q.layer===L.VENDOR;})){this._oMessagebundle=x.messagebundle;var B=new f(this._oMessagebundle);y.setModel(B,"i18nFlexVendor");}}}var E=P&&P.currentLayer;var G=!(P&&P.ignoreMaxLayerParameter);var K=function(){return true;};if(E){z=a.filterChangeOrChangeDefinitionsByCurrentLayer(z,E);}else if(a.isLayerFilteringRequired(this._oUShellURLParsingService)&&G){K=this._filterChangeForMaxLayer.bind(this);z=z.filter(K);}else if(this._bHasChangesOverMaxLayer&&!G){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}var N=x.changes&&P&&P.includeCtrlVariants;var O=this._getAllCtrlVariantChanges(x,N,K);z=z.concat(O);return this._checkAndGetChangeInstances(z,x);}.bind(this,P));};l.prototype._checkAndGetChangeInstances=function(x,y){return x.filter(this._preconditionsFulfilled).map(n.bind(this,y));};l.prototype._filterChangeForMaxLayer=function(x){if(a.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(x),this._oUShellURLParsingService)){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};l.prototype._getLayerFromChangeOrChangeContent=function(x){var y;if(x instanceof V||x instanceof C){y=x.getLayer();}else{y=x.layer;}return y;};l.prototype._getAllCtrlVariantChanges=function(x,I,y){if(!I){return j.getInitialChanges({reference:this._mComponent.name});}return["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"].reduce(function(R,z){if(x.changes[z]){return R.concat(x.changes[z]);}return R;},[]).filter(y);};l.prototype.loadChangesMapForComponent=function(x){return this.getChangesForComponent({component:x}).then(y.bind(this));function y(z){M.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=D.createEmptyDependencyMap();z.forEach(this.addChangeAndUpdateDependencies.bind(this,x));this._mChangesInitial=m({},this._mChanges);M.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this);}};l.prototype.checkForOpenDependenciesForControl=function(x,y){return D.checkForOpenDependenciesForControl(this._mChanges,J.getControlIdBySelector(x,y),y);};function o(x){var I=m({},this._mChangesInitial.mDependencies);return I[x.getId()];}function p(I,N,x,y){var z;var B=[];I.controlsDependencies.forEach(function(E){if(!J.bySelector(E,x)){z=J.getControlIdBySelector(E,x);B.push(E);this._mChanges.mControlsWithDependencies[z]=this._mChanges.mControlsWithDependencies[z]||[];if(!i(this._mChanges.mControlsWithDependencies[z],y.getId())){this._mChanges.mControlsWithDependencies[z].push(y.getId());}}}.bind(this));I.dependencies=N;I.controlsDependencies=B;if(N.length||B.length){this._mChanges.mDependencies[y.getId()]=I;}}l.prototype.copyDependenciesFromInitialChangesMapSync=function(x,y,z){var I=o.call(this,x);if(I){var N=[];I.dependencies.forEach(function(B){if(y(B)){this._mChanges.mDependentChangesOnMe[B]=this._mChanges.mDependentChangesOnMe[B]||[];this._mChanges.mDependentChangesOnMe[B].push(x.getId());N.push(B);}}.bind(this));p.call(this,I,N,z,x);}return this._mChanges;};l.prototype.copyDependenciesFromInitialChangesMap=function(x,y,z){var I=o.call(this,x);if(I){var N=[];return I.dependencies.reduce(function(P,B){return P.then(function(){return y(B);}).then(function(E){if(E){this._mChanges.mDependentChangesOnMe[B]=this._mChanges.mDependentChangesOnMe[B]||[];this._mChanges.mDependentChangesOnMe[B].push(x.getId());N.push(B);}}.bind(this));}.bind(this),Promise.resolve()).then(function(){p.call(this,I,N,z,x);return this._mChanges;}.bind(this));}return Promise.resolve(this._mChanges);};l.prototype.addChangeAndUpdateDependencies=function(x,y,R){y.setInitialApplyState();if(R){D.insertChange(y,this._mChanges,R);}D.addChangeAndUpdateDependencies(y,x,this._mChanges);};l.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(x,y){D.addRuntimeChangeAndUpdateDependencies(y,x,this._mChanges,this._mChangesInitial);};l.prototype.getChangesMapForComponent=function(){return this._mChanges;};l.prototype.getAllUIChanges=function(P){var x=u(this.getChangesMapForComponent().aChanges,P.includeDirtyChanges&&this.getDirtyChanges()).filter(function(y){return(Boolean(y)&&y.getFileType()==="change"&&a.compareAgainstCurrentLayer(y.getLayer(),P.layer)===0);});return x;};l.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated;};l.prototype.changesHavingCorrectViewPrefix=function(P,x){var y=P.modifier;var z=P.appComponent;var B=x.getSelector();if(!B||!P){return false;}if(B.viewSelector){var E=y.getControlIdBySelector(B.viewSelector,z);return E===P.viewId;}var G=B.id;if(G){var H;if(x.getSelector().idIsLocal){if(z){H=z.getLocalId(P.viewId);}}else{H=P.viewId;}var I=0;var K;do{I=G.indexOf("--",I);K=G.slice(0,I);I++;}while(K!==H&&I>0);return K===H;}return false;};l.prototype.getChangesForView=function(P){return this.getChangesForComponent(P).then(function(x){return x.filter(this.changesHavingCorrectViewPrefix.bind(this,P));}.bind(this));};l.prototype.addChange=function(x,y){var z=this.addDirtyChange(x);this._addRunTimeCreatedChangeAndUpdateDependencies(y,z);this._mChangesEntries[z.getFileName()]=z;this._addPropagationListener(y);return z;};l.prototype.addDirtyChange=function(x){var N;if(x instanceof C||x instanceof V){N=x;}else{N=new C(x);}if(this._aDirtyChanges.indexOf(N)===-1){this._aDirtyChanges.push(N);}return N;};l.prototype._addPropagationListener=function(x){var y=U.getAppComponentForControl(x);if(y instanceof e){var z=function(P){return!P._bIsSapUiFlFlexControllerApplyChangesOnControl;};var N=y.getPropagationListeners().every(z);if(N){var B=sap.ui.require("sap/ui/fl/FlexControllerFactory");var E=B.create(this.getComponentName());var P=A.applyAllChangesForControl.bind(A,this.getChangesMapForComponent.bind(this),y,E);P._bIsSapUiFlFlexControllerApplyChangesOnControl=true;y.addPropagationListener(P);}}};l.prototype._deleteNotSavedChanges=function(x,y,z){x.filter(function(B){return!y.some(function(E){return B.getId()===E.getId();});}).forEach(function(B){if(z){this.removeChange(B);b.deleteChange(this._mComponent,B.getDefinition());}else{this.deleteChange(B);}}.bind(this));};function q(x,y){var P=x.map(function(B){return B[y]();});var z=P.filter(function(B,I,P){return P.indexOf(B)===I;});return z.length===1;}function s(x,y){var z=false;if(!x||y.length<2){return false;}if(!q(y,"getLayer")){return false;}var B=y[0].getLayer();if(B==="CUSTOMER"||B==="USER"){z=true;}var E=g.fromURL(window.location.href);if(E.has("sap-ui-xx-condense-changes")){z=E.get("sap-ui-xx-condense-changes")==="true";}return z;}function r(x){var E=c.getInstanceOrUndef()&&c.getInstanceOrUndef().isCondensingEnabled();if(E&&!q(x,"getNamespace")){E=false;}return E;}function t(x,y,z,B){this._massUpdateCacheAndDirtyState(y,z);this._deleteNotSavedChanges(x,y,B);}function v(x){if(!x.length){return[];}var y=x[0].getLayer();var P=this._mChanges.aChanges.filter(function(z){return z.getState()===C.states.PERSISTED&&a.compareAgainstCurrentLayer(z.getLayer(),y)===0;});return P.concat(x);}l.prototype.saveDirtyChanges=function(x,y,z,P){var B=z||this._aDirtyChanges;var R=v.call(this,B);var I=(r(R)&&s(x,R));var E=I?R:B;var G=E.slice(0);var H=B.slice(0);var K=this._getRequests(B);var N=this._getStates(B);if(N.length===1&&K.length===1&&N[0]===C.states.NEW){var O=Promise.resolve(G);if(s(x,G)){O=k.condense(x,G);}return O.then(function(Q){var T=K[0];var W=B[0].getDefinition().layer;if(I){return d.condense({allChanges:E,condensedChanges:Q,layer:W,transport:T,isLegacyVariant:false,parentVersion:P}).then(function(X){t.call(this,E,Q,y,true);return X;}.bind(this));}if(Q.length){return d.write({layer:W,flexObjects:this._prepareDirtyChanges(Q),transport:T,isLegacyVariant:false,parentVersion:P}).then(function(X){t.call(this,E,Q,y);return X;}.bind(this));}this._deleteNotSavedChanges(E,Q);}.bind(this));}return this.saveSequenceOfDirtyChanges(H,y,P);};l.prototype.saveSequenceOfDirtyChanges=function(x,y,P){var z;if(P){var N=x.filter(function(B){return B.getState()===C.states.NEW;});z=[].concat(N).shift();}return x.reduce(function(B,E){return B.then(this._performSingleSaveAction(E,z,P)).then(this._updateCacheAndDirtyState.bind(this,E,y));}.bind(this),Promise.resolve());};l.prototype._performSingleSaveAction=function(x,y,P){return function(){switch(x.getState()){case C.states.NEW:if(P!==undefined){P=x===y?P:sap.ui.fl.Versions.Draft;}return d.write({layer:x.getLayer(),flexObjects:[x.getDefinition()],transport:x.getRequest(),parentVersion:P});case C.states.DELETED:return d.remove({flexObject:x.getDefinition(),layer:x.getLayer(),transport:x.getRequest()});}};};l.prototype._updateCacheAndDirtyState=function(x,y){if(!y){if(U.isChangeRelatedToVariants(x)){j.updateVariantsState({reference:this._mComponent.name,changeToBeAddedOrDeleted:x});}else{switch(x.getState()){case C.states.NEW:x.setState(C.states.PERSISTED);b.addChange(this._mComponent,x.getDefinition());break;case C.states.DELETED:b.deleteChange(this._mComponent,x.getDefinition());break;case C.states.DIRTY:x.setState(C.states.PERSISTED);b.updateChange(this._mComponent,x.getDefinition());break;}}}this._aDirtyChanges=this._aDirtyChanges.filter(function(E){return x.getId()!==E.getId();});};l.prototype._massUpdateCacheAndDirtyState=function(x,y){x.forEach(function(z){this._updateCacheAndDirtyState(z,y);},this);};l.prototype._getRequests=function(x){var R=[];x.forEach(function(y){var z=y.getRequest();if(R.indexOf(z)===-1){R.push(z);}});return R;};l.prototype._getStates=function(x){var y=[];x.forEach(function(z){var B=z.getState();if(y.indexOf(B)===-1){y.push(B);}});return y;};l.prototype._prepareDirtyChanges=function(x){var y=[];x.forEach(function(z){y.push(z.getDefinition());});return y;};l.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};l.prototype.deleteChange=function(x,R){var y=this._aDirtyChanges.indexOf(x);if(y>-1){if(x.getState()===C.states.DELETED){return;}this._aDirtyChanges.splice(y,1);this._deleteChangeInMap(x,R);return;}x.markForDeletion();this.addDirtyChange(x);this._deleteChangeInMap(x,R);};l.prototype.removeChange=function(x){var y=this._aDirtyChanges.indexOf(x);if(y>-1){this._aDirtyChanges.splice(y,1);}this._deleteChangeInMap(x);};l.prototype._deleteChangeInMap=function(x,R){var y=x.getId();D.removeChangeFromMap(this._mChanges,y);D.removeChangeFromDependencies(R?this._mChangesInitial:this._mChanges,y);};function w(x,O){return(O.getRequest()==="$TMP"||O.getRequest()==="")&&O.getLayer()===x;}l.prototype.transportAllUIChanges=function(R,x,y,z){return Promise.all([this.getChangesForComponent({currentLayer:y,includeCtrlVariants:true}),F.getCompVariantsMap(this.getComponentName())]).then(function(B){var E=B[0];var G=B[1];var H=[];for(var P in G){for(var I in G[P].byId){H.push(G[P].byId[I]);}}E=E.concat(H.filter(w.bind(this,y)));return d.publish({transportDialogSettings:{rootControl:R,styleClass:x},layer:y,reference:this.getComponentName(),localChanges:E,appVariantDescriptors:z});}.bind(this));};l.prototype._getChangesFromMapByNames=function(N){return this._mChanges.aChanges.filter(function(x){return N.indexOf(x.getFileName())!==-1;});};l.prototype.removeDirtyChanges=function(x,y,z,G,B){var E=[].concat(x);var H=this._aDirtyChanges;var I=H.filter(function(K){var N=true;if(!E.includes(K.getLayer())){return false;}if(G&&K.getDefinition().support.generator!==G){return false;}if(z){var O=K.getSelector();N=z.getId()===J.getControlIdBySelector(O,y);}if(B){N=N&&B.indexOf(K.getChangeType())!==-1;}return N;});I.forEach(function(K){var N=H.indexOf(K);H.splice(N,1);});return Promise.resolve(I);};l.prototype.resetChanges=function(x,G,y,z){var B=y&&y.length>0;var E=z&&z.length>0;return this.getChangesForComponent({currentLayer:x,includeCtrlVariants:true}).then(function(H){var P={reference:this.getComponentName(),layer:x,changes:H};if(G){P.generator=G;}if(B){P.selectorIds=y;}if(E){P.changeTypes=z;}return d.reset(P);}.bind(this)).then(function(R){var H=[];if(y||z){var N=[];if(R&&R.response&&R.response.length>0){R.response.forEach(function(I){N.push(I.fileName);});}b.removeChanges(this._mComponent,N);H=this._getChangesFromMapByNames(N);}return H;}.bind(this));};l.prototype.getResetAndPublishInfo=function(P){return d.getFlexInfo(P);};return l;});
