/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/Context","sap/ui/model/PropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid",'sap/base/Log',"sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/ToggleButton","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox",'sap/m/HBox',"sap/ui/events/KeyCodes","sap/ui/core/library","sap/m/library","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(C,P,J,F,a,D,I,b,c,H,G,L,S,R,d,f,T,B,g,h,i,j,k,l,m,n,o,p,q,r,s,O,t,u,V,v,K,w,x,y,z){"use strict";var A=x.OverflowToolbarPriority;var E=x.ButtonType;var M=x.PlacementType;var N=x.PopinDisplay;var Q=x.ScreenSize;var U=w.ValueState;var W=w.TextAlign;var X=b.extend("sap.ui.fl.variants.VariantManagement",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false},displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:""}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},cancel:{},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,Y){e.openStart("div",Y).class("sapUiFlVarMngmt").openEnd();e.renderControl(Y.oVariantLayout);e.close("div");}}});X.INNER_MODEL_NAME="$sapUiFlVariants";X.MAX_NAME_LEN=100;X.COLUMN_FAV_IDX=0;X.COLUMN_NAME_IDX=1;X.prototype.init=function(){this._sModelName=y.VARIANT_MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I();this.oVariantText=new q(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(Y){var Z="";if(Y){Z=this.getSelectedVariantText(Y);this._setInvisibleText(Z,this.getModified());}return Z;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");this.oVariantText.addStyleClass("sapMTitleStyleH4");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new T(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(Y){var Z=this.getCurrentVariantKey();if(Z){this._setInvisibleText(this.getSelectedVariantText(Z),Y);}return((Y===null)||(Y===undefined))?false:Y;}.bind(this)}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantPopoverTrigger=new l(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:E.Transparent,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT")});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");e.setVisible(false);this.oVariantModifiedText=e;this.oVariantInvisibleText.toStatic();this.addDependent(this.oVariantLayout);this._fRegisteredApplyAutomaticallyOnStandardVariant=null;};X.prototype.registerApplyAutomaticallyOnStandardVariant=function(e){this._fRegisteredApplyAutomaticallyOnStandardVariant=e;return this;};X.prototype.getApplyAutomaticallyOnVariant=function(e){var Y=e.executeOnSelect;if(this._fRegisteredApplyAutomaticallyOnStandardVariant&&this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&(e.key===this.getStandardVariantKey())){try{Y=this._fRegisteredApplyAutomaticallyOnStandardVariant(e);}catch(Z){L.error("callback for determination of apply automatically on standard variant failed");}}return Y;};X.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]};};X.prototype.getTitle=function(){return this.oVariantText;};X.prototype._setInvisibleText=function(e,Y){var Z;if(e){if(Y){Z="VARIANT_MANAGEMENT_SEL_VARIANT_MOD";}else{Z="VARIANT_MANAGEMENT_SEL_VARIANT";}this.oVariantInvisibleText.setText(this._oRb.getText(Z,[e]));}};X.prototype._createInnerModel=function(){var e=new J({showExecuteOnSelection:false,showSetAsDefault:true,showPublic:false,showContexts:false,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(e,X.INNER_MODEL_NAME);this._bindProperties();this._updateInnerModelWithSettingsInfo();};X.prototype._bindProperties=function(){this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:X.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:X.INNER_MODEL_NAME});};X.prototype._updateInnerModelWithSettingsInfo=function(){z.getInstance().then(function(e){this.getModel(X.INNER_MODEL_NAME).setProperty("/showSaveAs",e.isVariantPersonalizationEnabled());this.getModel(X.INNER_MODEL_NAME).setProperty("/showPublic",e.isPublicFlVariantEnabled());}.bind(this));};X.prototype._getShowPublic=function(){var e=this.getModel(X.INNER_MODEL_NAME);if(e){return e.getProperty("/showPublic");}return false;};X.prototype._setShowPublic=function(e){var Y=this.getModel(X.INNER_MODEL_NAME);if(Y){Y.setProperty("/showPublic",e);}};X.prototype._getShowContexts=function(){var e=this.getModel(X.INNER_MODEL_NAME);if(e){return e.getProperty("/showContexts");}return false;};X.prototype._setShowContexts=function(e){var Y=this.getModel(X.INNER_MODEL_NAME);if(Y){Y.setProperty("/showContexts",e);}};X.prototype._getShowExecuteOnSelection=function(){var e=this.getModel(X.INNER_MODEL_NAME);if(e){return e.getProperty("/showExecuteOnSelection");}return false;};X.prototype._setShowExecuteOnSelection=function(e){var Y=this.getModel(X.INNER_MODEL_NAME);if(Y){Y.setProperty("/showExecuteOnSelection",e);}};X.prototype.setExecuteOnSelection=function(e){var Y=this.getModel(this._sModelName);if(Y&&this.oContext){Y.setProperty(this.oContext+"/executeOnSelection",e);}};X.prototype.getOriginalDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/originalDefaultVariant");}return null;};X.prototype.setDefaultVariantKey=function(e){var Y=this.getModel(this._sModelName);if(Y&&this.oContext){Y.setProperty(this.oContext+"/defaultVariant",e);}};X.prototype.getDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/defaultVariant");}return null;};X.prototype.setCurrentVariantKey=function(e){var Y=this.getModel(this._sModelName);if(Y&&this.oContext){Y.setProperty(this.oContext+"/currentVariant",e);}return this;};X.prototype.getCurrentVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/currentVariant");}return null;};X.prototype._assignPopoverTitle=function(){var e;var Y;var Z=this.getModel(this._sModelName);if(Z&&this.oContext){e=Z.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){Y=this.getModel(X.INNER_MODEL_NAME);if(Y){Y.setProperty("/popoverTitle",e);}}};X.prototype.getVariants=function(){return this._getItems();};X.prototype.setModified=function(e){var Y=this.getModel(this._sModelName);if(Y&&this.oContext){Y.setProperty(this.oContext+"/modified",e);}};X.prototype.getModified=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/modified");}return false;};X.prototype.getSelectedVariantText=function(e){var Y=this._getItemByKey(e);if(Y){return Y.title;}return"";};X.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};X.prototype.getShowFavorites=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/showFavorites");}return false;};X.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};X.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};X.prototype._getDeletedItems=function(){return this._aDeletedItems;};X.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(Y){if(!Y.hasOwnProperty("visible")){return true;}return Y.visible;});}return e;};X.prototype._getItemByKey=function(e){var Y=null;var Z=this._getItems();Z.some(function($){if($.key===e){Y=$;}return(Y!==null);});return Y;};X.prototype._rebindControl=function(){this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(e){var Y="";if(e){Y=this.getSelectedVariantText(e);this._setInvisibleText(Y,this.getModified());}return Y;}.bind(this)});this.oVariantModifiedText.unbindProperty("visible");this.oVariantModifiedText.bindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(e){var Y=this.getCurrentVariantKey();if(Y){this._setInvisibleText(this.getSelectedVariantText(Y),e);}return((e===null)||(e===undefined))?false:e;}.bind(this)});};X.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();return this;};X.prototype._setBindingContext=function(){var e;var Y;if(!this.oContext){e=this.getModel(this._sModelName);if(e){Y=this._getLocalId(e);if(Y){this.oContext=new C(e,"/"+Y);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&e.registerToModel){e.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(e);this.fireInitialized();}}}};X.prototype._getLocalId=function(e){if(this.getModelName()&&(this._sModelName!==y.VARIANT_MODEL_NAME)){return this.getId();}return e.getVariantManagementReferenceForControl(this);};X.prototype._setModel=function(){this._setBindingContext();};X.prototype._registerPropertyChanges=function(e){var Y=new P(e,this.oContext+"/showExecuteOnSelection");Y.attachChange(function(Z){if(Z&&Z.oSource&&Z.oSource.oModel&&Z.oSource.sPath){var $=Z.oSource.oModel.getProperty(Z.oSource.sPath);if($!==undefined){this._setShowExecuteOnSelection($);}}}.bind(this));Y=new P(e,this.oContext+"/variantsEditable");Y.attachChange(function(Z){if(Z&&Z.oSource&&Z.oSource.oModel&&Z.oSource.sPath){var $;var _=Z.oSource.oModel.getProperty(Z.oSource.sPath);$=this.getModel(X.INNER_MODEL_NAME);if($&&(_!==undefined)){$.setProperty("/editable",_);}}}.bind(this));};X.prototype._obtainControl=function(e){if(e&&e.target&&e.target.id){var Y=e.target.id;var Z=Y.indexOf("-inner");if(Z>0){Y=Y.substring(0,Z);}return sap.ui.getCore().byId(Y);}return null;};X.prototype.handleOpenCloseVariantPopover=function(e){if(!this.bPopoverOpen){this._oCtrlRef=this._obtainControl(e);this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};X.prototype.getFocusDomRef=function(){return this.oVariantPopoverTrigger.getFocusDomRef();};X.prototype.onclick=function(e){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover(e);};X.prototype.onkeyup=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._oCtrlRef=this._obtainControl(e);this._openVariantList();}};X.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};X.prototype._openInErrorState=function(){var Y;if(!this.oErrorVariantPopOver){Y=new V({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new c({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new q({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new T({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});Y.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new r(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:X.INNER_MODEL_NAME},contentWidth:"400px",placement:M.VerticalPreferredBottom,content:[new h(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[Y]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};X.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new k(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new u({priority:A.Low})});this.oVariantSaveBtn=new k(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),visible:{path:"modified",model:this._sModelName,formatter:function(Y){return Y;}},type:E.Emphasized,layoutData:new u({priority:A.Low})});this.oVariantSaveAsBtn=new k(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new u({priority:A.Low}),visible:{path:"/showSaveAs",model:X.INNER_MODEL_NAME}});this._oVariantList=new s(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(Y){var Z=null;if(Y&&Y.getParameters()){var $=Y.getParameters().item;if($){Z=$.getKey();}}if(Z){this.setCurrentVariantKey(Z);this.fireEvent("select",{key:Z});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(Y){this._triggerSearch(Y,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new h(this.getId()+"-selpage",{subHeader:new i({content:[this._oSearchField]}),content:[this._oVariantList],footer:new t({content:[new j(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:X.INNER_MODEL_NAME}});this.oVariantPopOver=new r(this.getId()+"-popover",{title:{path:"/popoverTitle",model:X.INNER_MODEL_NAME},titleAlignment:"Auto",contentWidth:"400px",placement:M.VerticalPreferredBottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;this.oVariantPopoverTrigger.setPressed(true);}.bind(this),afterClose:function(){this.oVariantPopoverTrigger.setPressed(false);if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};X.prototype.showSaveButton=function(e){if(e===false){this.oVariantSaveAsBtn.setType(E.Emphasized);this.oVariantSaveBtn.setVisible(false);}else{this.oVariantSaveAsBtn.setType(E.Default);this.oVariantSaveBtn.setVisible(true);}};X.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9);this.showSaveButton(false);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.showSaveButton(true);}}var Y=this._oCtrlRef?this._oCtrlRef:this.oVariantLayout;this._oCtrlRef=null;this.oVariantPopOver.openBy(Y);};X.prototype._triggerSearch=function(e,Y){if(!e){return;}var Z=e.getParameters();if(!Z){return;}var $=Z.newValue?Z.newValue:"";var _=new F({path:"title",operator:a.Contains,value1:$});Y.getBinding("items").filter(this._getFilters(_));};X.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new o(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName);}.bind(this)});var e=new p(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")});e.setLabelFor(this.oInputName);e.addStyleClass("sapUiFlVarMngmtSaveDialogLabel");this.oDefault=new m(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:X.INNER_MODEL_NAME},width:"100%"});this.oPublic=new m(this.getId()+"-public",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASPUBLIC"),visible:{path:"/showPublic",model:X.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new m(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:X.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new o(this.getId()+"-key",{liveChange:function(){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new p(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new k(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:E.Emphasized,press:function(){if(!this._bSaveOngoing){this._checkVariantNameConstraints(this.oInputName);if(this.oInputName.getValueState()==="Error"){this.oInputName.focus();return;}this._bSaveOngoing=true;this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}}.bind(this),enabled:true});var Y=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){Y.addContent(this.oDefault);}Y.addContent(this.oPublic);if(this._getShowExecuteOnSelection()){Y.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new n(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),afterClose:function(){this._bSaveOngoing=false;if(this._sStyleClass){this._setShowPublic(this._bShowPublic);this.oSaveAsDialog.removeStyleClass(this._sStyleClass);if(this._oRolesComponentContainer){this.oSaveAsDialog.removeContent(this._oRolesComponentContainer);}this._sStyleClass=undefined;this._oRolesComponentContainer=null;}}.bind(this),beginButton:this.oSaveSave,endButton:new k(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:this._cancelPressed.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,Y],stretch:D.system.phone});this.oSaveAsDialog.isPopupAdaptationAllowed=function(){return false;};this.oSaveAsDialog.addStyleClass("sapUiContentPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};X.prototype._cancelPressed=function(){this._bSaveCanceled=true;this.fireCancel();this.oSaveAsDialog.close();};X.prototype._getSelectedContexts=function(){return this._oRolesComponentContainer.getComponentInstance().getSelectedContexts();};X.prototype._setSelectedContexts=function(e){if(!e){e={role:[]};}this._oRolesComponentContainer.getComponentInstance().setSelectedContexts(e);};X.prototype._isInErrorContexts=function(){return this._oRolesComponentContainer.getComponentInstance().hasErrorsAndShowErrorMessage();};X.prototype._determineRolesSpecificText=function(e,Y){if(!e){e={role:[]};}if(e&&Y){Y.setText(this._oRb.getText((e.role&&e.role.length>0)?"VARIANT_MANAGEMENT_VISIBILITY_RESTRICTED":"VARIANT_MANAGEMENT_VISIBILITY_NON_RESTRICTED"));}};X.prototype._checkAndAddRolesContainerToManageDialog=function(){if(this._oRolesComponentContainer&&this._oRolesDialog){var e=null;this._oRolesDialog.getContent().some(function(Y){if(Y===this._oRolesComponentContainer){e=Y;return true;}return false;}.bind(this));if(!e){this._oRolesDialog.addContent(this._oRolesComponentContainer);}}};X.prototype._createRolesDialog=function(){if(!this._oRolesDialog){this._oRolesDialog=new n(this.getId()+"-roledialog",{draggable:true,resizable:true,contentWidth:"40%",title:this._oRb.getText("VARIANT_MANAGEMENT_SELECTROLES_DIALOG"),beginButton:new k(this.getId()+"-rolesave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:E.Emphasized,press:function(){if(!this._checkAndCreateContextInfoChanges(this._oCurrentContextsKey,this._oTextControl)){return;}this._oRolesDialog.close();}.bind(this)}),endButton:new k(this.getId()+"-rolecancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._oRolesDialog.close();}.bind(this)}),content:[this._oRolesComponentContainer],stretch:D.system.phone});this._oRolesDialog.setParent(this);this._oRolesDialog.addStyleClass("sapUiContentPadding");this._oRolesDialog.addStyleClass(this._sStyleClass);this._oRolesDialog.isPopupAdaptationAllowed=function(){return false;};}this._checkAndAddRolesContainerToManageDialog();};X.prototype._openRolesDialog=function(e,Y){this._createRolesDialog();this._oCurrentContextsKey=e.key;this._oTextControl=Y;this._setSelectedContexts(e.contexts);this._oRolesDialog.open();};X.prototype._checkAndCreateContextInfoChanges=function(e,Y){if(e){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){var Z=this._getSelectedContexts();var $=this._getItemByKey(e);if($){$.contexts=Z;this._determineRolesSpecificText(Z,Y);}}else{return false;}}catch(_){return false;}}return true;}return false;};X.prototype._checkAndAddRolesContainerToSaveAsDialog=function(){if(this._oRolesComponentContainer&&this.oSaveAsDialog){var e=null;this.oSaveAsDialog.getContent().some(function(Y){if(Y===this._oRolesComponentContainer){e=Y;return true;}return false;}.bind(this));this._setSelectedContexts({role:[]});if(!e){this.oSaveAsDialog.addContent(this._oRolesComponentContainer);}}};X.prototype.openSaveAsDialogForKeyUser=function(e,Y){this._openSaveAsDialog(true);this.oSaveAsDialog.addStyleClass(e);this._sStyleClass=e;this._bShowPublic=this._getShowPublic();this._setShowPublic(false);if(Y){Promise.all([Y]).then(function(Z){this._oRolesComponentContainer=Z[0];this._checkAndAddRolesContainerToSaveAsDialog();this.oSaveAsDialog.open();}.bind(this));}else{this.oSaveAsDialog.open();}};X.prototype._openSaveAsDialog=function(e){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oInputName.setEnabled(true);this.oInputName.setValueState(U.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oPublic.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(U.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}if(!e){this.oSaveAsDialog.open();}};X.prototype._handleVariantSaveAs=function(e){var Y=null;var Z=e.trim();var $=this.oInputManualKey.getValue().trim();if(Z===""){this.oInputName.setValueState(U.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if($===""){this.oInputManualKey.setValueState(U.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}Y=$;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(Y);}this.setModified(false);this.fireSave({key:Y,name:Z,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected(),"public":this._sStyleClass?undefined:this.oPublic.getSelected(),contexts:this._sStyleClass?this._getContextInfoChanges():undefined});};X.prototype._getContextInfoChanges=function(){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){return this._getSelectedContexts();}}catch(e){return null;}}return null;};X.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var Y=false;if(this.getDefaultVariantKey()===e.key){Y=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:Y});this.setModified(false);};X.prototype.openManagementDialog=function(e,Y,Z){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}if(Y){this._sStyleClass=Y;this._bShowPublic=this._getShowPublic();this._setShowPublic(false);}if(Z){Promise.all([Z]).then(function($){this._oRolesComponentContainer=$[0];this._setShowContexts(!!this._oRolesComponentContainer);this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass);}}.bind(this));}else{this._setShowContexts(false);this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass);}}};X.prototype._triggerSearchInManageDialog=function(e,Y){if(!e){return;}var Z=e.getParameters();if(!Z){return;}var $=Z.newValue?Z.newValue:"";var _=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:a.Contains,value1:$}),new F({path:"author",operator:a.Contains,value1:$})],and:false})];Y.getBinding("items").filter(_);this._bDeleteOccured=true;};X.prototype.getManageDialog=function(){return this.oManagementDialog;};X.prototype._createManagementDialog=function(){if(!this.oManagementDialog||this.oManagementDialog.bIsDestroyed){this.oManagementTable=new g(this.getId()+"-managementTable",{contextualWidth:"Auto",fixedLayout:false,growing:true,columns:[new f({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"16rem"}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTTYPE"),wrappingType:"Hyphenated"}),visible:{path:"/showPublic",model:X.INNER_MODEL_NAME},demandPopin:true,popinDisplay:N.Inline,minScreenWidth:Q.Tablet}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT"),wrappingType:"Hyphenated"}),hAlign:W.Center,demandPopin:true,popinDisplay:N.Block,minScreenWidth:Q.Tablet,visible:{path:"/showSetAsDefault",model:X.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),wrappingType:"Hyphenated"}),hAlign:this.getDisplayTextForExecuteOnSelectionForStandardVariant()?W.Begin:W.Center,demandPopin:true,popinDisplay:N.Block,minScreenWidth:Q.Tablet,visible:{path:"/showExecuteOnSelection",model:X.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY"),wrappingType:"Hyphenated"}),width:"8rem",demandPopin:true,popinDisplay:N.Inline,minScreenWidth:Q.Tablet,visible:{path:"/showContexts",model:X.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),demandPopin:true,popinDisplay:N.Block,minScreenWidth:Q.Tablet}),new f({hAlign:W.Center}),new f({visible:false})]});this.oManagementSave=new k(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),enabled:true,type:E.Emphasized,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new k(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._resumeManagementTableBinding();this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new n(this.getId()+"-managementdialog",{contentWidth:"64%",resizable:true,draggable:true,title:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG"),beginButton:this.oManagementSave,endButton:this.oManagementCancel,afterClose:function(){if(this._sStyleClass){this._setShowPublic(this._bShowPublic);this.oManagementDialog.removeStyleClass(this._sStyleClass);this._sStyleClass=undefined;this._oRolesComponentContainer=null;}}.bind(this),content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(Y){this._triggerSearchInManageDialog(Y,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentMiddle:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};X.prototype._setFavoriteIcon=function(e,Y){if(e){e.setSrc(Y?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(Y?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));e.setAlt(this._oRb.getText(Y?"VARIANT_MANAGEMENT_FAV_DEL_ACC":"VARIANT_MANAGEMENT_FAV_ADD_ACC"));}};X.prototype._templateFactoryManagementDialog=function(e,Y){var Z=null;var $;var _;var a1;var b1;var c1;var d1=Y.getObject();if(!d1){return undefined;}var e1=function(o1){this._checkVariantNameConstraints(o1.oSource,o1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var f1=function(o1){this._handleManageTitleChanged(o1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var g1=function(o1){this._handleManageDefaultVariantChange(o1.oSource,o1.oSource.getBindingContext(this._sModelName).getObject(),o1.getParameters().selected);}.bind(this);var h1=function(o1){this._handleManageExecuteOnSelectionChanged(o1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var i1=function(o1){this._handleManageDeletePressed(o1.oSource.getBindingContext(this._sModelName).getObject());var p1=o1.oSource.getParent();if(p1){p1.setVisible(false);}this._reCheckVariantNameConstraints();}.bind(this);var j1=function(o1){this._handleManageFavoriteChanged(o1.oSource,o1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var k1=function(o1){var d1=o1.oSource.getBindingContext(this._sModelName).getObject();this._openRolesDialog(d1,o1.oSource.getParent().getItems()[0]);}.bind(this);if(d1.rename){a1=new o({liveChange:e1,change:f1,value:'{'+this._sModelName+">title}"});}else{a1=new O({title:'{'+this._sModelName+">title}"});if(Z){a1.setTooltip(Z);}}$=new k({icon:"sap-icon://decline",enabled:true,type:E.Transparent,press:i1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:d1.remove});this._assignColumnInfoForDeleteButton($);_=this.oContext.getPath();var l1=new c({src:{path:"favorite",model:this._sModelName,formatter:function(o1){return o1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(o1){return this._oRb.getText(o1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:j1});if((this.getStandardVariantKey()===d1.key)||(this.getDefaultVariantKey()===d1.key)){l1.addStyleClass("sapUiFlVarMngmtFavNonInteractiveColor");}else{l1.addStyleClass("sapUiFlVarMngmtFavColor");}if(this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&(this.getStandardVariantKey()===d1.key)){b1=new m({wrapping:true,text:this.getDisplayTextForExecuteOnSelectionForStandardVariant(),select:h1,selected:'{'+this._sModelName+">executeOnSelect}"});}else{b1=new m({text:"",select:h1,selected:'{'+this._sModelName+">executeOnSelect}"});}if(this._sStyleClass&&(d1.key!==this.getStandardVariantKey())){var m1=new T({wrapping:false});this._determineRolesSpecificText(d1.contexts,m1);var n1=new c({src:"sap-icon://edit",press:k1});n1.addStyleClass("sapUiFlVarMngmtRolesEdit");n1.setTooltip(this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY_ICON_TT"));c1=new v({items:[m1,n1]});}else{c1=new T();}return new d({cells:[l1,a1,new T({text:{path:"sharing",model:this._sModelName,formatter:function(o1){return this._oRb.getText(o1==="private"?"VARIANT_MANAGEMENT_PRIVATE":"VARIANT_MANAGEMENT_PUBLIC");}.bind(this)},textAlign:"Center"}),new R({groupName:this.getId(),select:g1,selected:{path:_+"/defaultVariant",model:this._sModelName,formatter:function(o1){return d1.key===o1;}}}),b1,c1,new T({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),$,new T({text:'{'+this._sModelName+">key}"})]});};X.prototype._openManagementDialog=function(){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._suspendManagementTableBinding();this._clearDeletedItems();this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}this.oManagementDialog.open();};X.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};X.prototype._toggleIconActivityState=function(e,Y,Z){if(!e){return;}if(Y.key===this.getStandardVariantKey()){return;}if(Z&&e.hasStyleClass("sapUiFlVarMngmtFavColor")){e.removeStyleClass("sapUiFlVarMngmtFavColor");e.addStyleClass("sapUiFlVarMngmtFavNonInteractiveColor");}else if(e.hasStyleClass("sapUiFlVarMngmtFavNonInteractiveColor")){e.removeStyleClass("sapUiFlVarMngmtFavNonInteractiveColor");e.addStyleClass("sapUiFlVarMngmtFavColor");}};X.prototype._handleManageDefaultVariantChange=function(e,Y,Z){var $=Y.key;if(e){var _=e.getParent().getCells()[X.COLUMN_FAV_IDX];if(Z){if(this.getShowFavorites()&&!Y.favorite){Y.favorite=true;this._setFavoriteIcon(_,true);}this.setDefaultVariantKey($);}this._toggleIconActivityState(_,Y,Z);}};X.prototype._handleManageCancelPressed=function(){var e;var Y;this._getDeletedItems().forEach(function(Z){Z.visible=true;});this._getItems().forEach(function(Z){Z.title=Z.originalTitle;Z.favorite=Z.originalFavorite;Z.executeOnSelection=Z.originalExecuteOnSelection;Z.contexts=Z.originalContexts;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}Y=this.getModel(this._sModelName);if(Y){Y.checkUpdate();}};X.prototype._handleManageFavoriteChanged=function(e,Y){if(this.getStandardVariantKey()===Y.key){return;}if((this.getDefaultVariantKey()===Y.key)&&Y.favorite){return;}Y.favorite=!Y.favorite;this._setFavoriteIcon(e,Y.favorite);};X.prototype._getRowForKey=function(e){var Y=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(Z){if(e===Z.getCells()[0].getBindingContext(this._sModelName).getObject().key){Y=Z;}return Y!==null;}.bind(this));}return Y;};X.prototype._handleManageDeletePressed=function(e){var Y;var Z=e.key;if(this.getStandardVariantKey()===Z){return;}e.visible=false;this._addDeletedItem(e);if((Z===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());if(this.getShowFavorites()){var $=this._getItemByKey(this.getStandardVariantKey());if($&&!$.favorite){var _=this._getRowForKey(this.getStandardVariantKey());if(_){$.favorite=true;this._setFavoriteIcon(_.getCells()[X.COLUMN_FAV_IDX],true);}}}}Y=this.getModel(this._sModelName);if(Y){Y.checkUpdate();}this.oManagementCancel.focus();};X.prototype._handleManageExecuteOnSelectionChanged=function(){};X.prototype._handleManageTitleChanged=function(){};X.prototype._handleManageSavePressed=function(){if(this._anyInErrorState(this.oManagementTable)){return;}this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var Y=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(Y);this.fireEvent("select",{key:Y});return true;}return false;}.bind(this));this.fireManage();this._resumeManagementTableBinding();this.oManagementDialog.close();};X.prototype._resumeManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.resume();}}};X.prototype._suspendManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.suspend();}}};X.prototype._anyInErrorState=function(e){var Y;var Z;var $=false;if(e){Y=e.getItems();Y.some(function(_){Z=_.getCells()[X.COLUMN_NAME_IDX];if(Z&&Z.getValueState&&(Z.getValueState()===U.Error)){$=true;}return $;});}return $;};X.prototype._getFilters=function(e){var Y=[];if(e){Y.push(e);}Y.push(this._getVisibleFilter());if(this.getShowFavorites()){Y.push(this._getFilterFavorites());}return Y;};X.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:a.EQ,value1:true});};X.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:a.EQ,value1:true});};X.prototype._verifyVariantNameConstraints=function(e,Y){if(!e){return;}var Z=e.getValue();Z=Z.trim();if(!this._checkIsDuplicate(Z,Y)){if(Z===""){e.setValueState(U.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(Z.indexOf('{')>-1){e.setValueState(U.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(Z.length>X.MAX_NAME_LEN){e.setValueState(U.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[X.MAX_NAME_LEN]));}else{e.setValueState(U.None);e.setValueStateText(null);}}else{e.setValueState(U.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}};X.prototype._checkVariantNameConstraints=function(e,Y){this._verifyVariantNameConstraints(e,Y);if(this.oManagementDialog&&this.oManagementDialog.isOpen()){this._reCheckVariantNameConstraints();}};X.prototype._reCheckVariantNameConstraints=function(){var e;var Y=false;if(this.oManagementTable){e=this.oManagementTable.getItems();e.some(function(Z){var $=Z.getBindingContext(this._sModelName).getObject();if($&&$.visible){var _=Z.getCells()[X.COLUMN_NAME_IDX];if(_&&_.getValueState&&(_.getValueState()===U.Error)){this._verifyVariantNameConstraints(_,$.key);if(_.getValueState()===U.Error){Y=true;}}}return Y;}.bind(this));}return Y;};X.prototype._checkIsDuplicate=function(e,Y){if(this.oManagementDialog&&this.oManagementDialog.isOpen()){return this._checkIsDuplicateInManageTable(e,Y);}return this._checkIsDuplicateInModel(e,Y);};X.prototype._checkIsDuplicateInModel=function(e,Y){var Z=false;var $=this._getItems();var _=e.toLowerCase();$.some(function(a1){if(a1.title.toLowerCase()===_){if(Y&&(Y===a1.key)){return false;}Z=true;}return Z;});return Z;};X.prototype._checkIsDuplicateInManageTable=function(e,Y){var Z;var $=false;var _=e.toLowerCase();if(this.oManagementTable){Z=this.oManagementTable.getItems();Z.some(function(a1){var b1;var c1=a1.getBindingContext(this._sModelName).getObject();if(c1&&c1.visible){var d1=a1.getCells()[X.COLUMN_NAME_IDX];if(d1&&(c1.key!==Y)){if(d1.isA("sap.m.Input")){b1=d1.getValue().toLowerCase();}else{b1=d1.getTitle().toLowerCase();}if(b1===_){$=true;}}}return $;}.bind(this));}return $;};X.prototype.exit=function(){var e;if(this.oVariantInvisibleText){this.oVariantInvisibleText.destroy(true);this.oVariantInvisibleText=undefined;}if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oPublic&&!this.oPublic._bIsBeingDestroyed){this.oPublic.destroy();}this.oPublic=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantModifiedText=undefined;this.oVariantPopoverTrigger=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;e=this.getModel(X.INNER_MODEL_NAME);if(e){e.destroy();}this._oRolesComponentContainer=null;this._sStyleClass=null;this._fRegisteredApplyAutomaticallyOnStandardVariant=null;};return X;});
