/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/m/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip"],function(B,L,o,l,a,O,b,c,d,M,e,f,A){"use strict";var g=l.AvatarSize;var h=l.AvatarColor;var j=l.ListType;var k=l.ListSeparators;var m=b.CardActionArea;var E=l.EmptyIndicatorMode;var n="_legendColorsLoad";var p=B.extend("sap.ui.integration.cards.ListContent",{metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:L});p.prototype.init=function(){B.prototype.init.apply(this,arguments);var q=this._getList();var t=this;this.setAggregation("_content",q);q.attachUpdateFinished(function(){if(t._iVisibleItems){var I=q.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});};p.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};p.prototype.loadDependencies=function(C){if(!this.isSkeleton()&&C.get("/sap.card/content/item/chart")){return M.loadDependencies();}return Promise.resolve();};p.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);C=this.getParsedConfiguration();if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C);}return this;};p.prototype.getStaticConfiguration=function(){var i=this.getInnerList().getItems(),C=this.getParsedConfiguration(),H=i[0]&&i[0].isA("sap.m.GroupHeaderListItem"),r=[],R=[],q;i.forEach(function(I){if(I.isA("sap.m.GroupHeaderListItem")){if(q){R.push(q);}r=[];q={title:I.getTitle(),items:r};}else{r.push(d.resolveValue(C.item,this,I.getBindingContext().getPath()));}}.bind(this));if(q){R.push(q);}var s={};if(H){s.groups=R;}else{s.items=r;}return s;};p.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getParsedConfiguration().item);};p.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false});}return this._oList;};p.prototype._setItem=function(C){var i=C.item,q=this._getList(),I=this.isSkeleton(),s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=g.S;}else{s.iconSize=g.XS;}s.iconSize=i.icon.size||s.iconSize;s.iconBackgroundColor=i.icon.backgroundColor||(i.icon.text?undefined:h.Transparent);}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType;}if(i.attributes){i.attributes.forEach(function(t){s.attributes.push(new O({text:t.value,state:t.state,emptyIndicatorMode:E.On}));});}if(!I){if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}if(i.actionsStrip){s.actionsStrip=A.create(this.getCardInstance(),i.actionsStrip);q.setShowSeparators(k.All);}else{q.setShowSeparators(k.None);}}this._oItemTemplate=new f(s);this._oActions.attach({area:m.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:j.Navigation,disabledPropertyValue:j.Inactive});var G=C.group;if(G){this._oSorter=this._getGroupSorter(G);}var r={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",q,r);};p.prototype._createChartAndAddLegend=function(C){var i=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var q=new e({chart:i.getChart(),colorsLoad:function(){this.fireEvent(n);}.bind(this)});q.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",q);this.awaitEvent(n);}return i;};p.prototype._setStaticItems=function(i){var q=this._getList();i.forEach(function(I){var r=new f({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){r.setType("Navigation");if(I.action.url){r.attachPress(function(){o(I.action.url,I.target||"_blank");});}}q.addItem(r);});this.fireEvent("_actionContentReady");};p.prototype.getInnerList=function(){return this._getList();};return p;});
