/*!
* OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./BaseContent","./ObjectContentRenderer","sap/ui/integration/library","sap/m/library","sap/m/FlexItemData","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/m/ObjectStatus","sap/base/Log","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/Utils","sap/f/cards/NumericIndicators","sap/f/cards/NumericSideIndicator"],function(B,O,l,L,F,H,V,T,a,A,b,c,d,e,R,f,g,h,U,N,j){"use strict";var k=L.AvatarSize;var m=L.AvatarColor;var n=L.FlexRendertype;var o=l.CardActionArea;var p=B.extend("sap.ui.integration.cards.ObjectContent",{metadata:{library:"sap.ui.integration"},renderer:O});p.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};p.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);C=this.getParsedConfiguration();if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};p.prototype._getRootContainer=function(){var r=this.getAggregation("_content");if(!r){r=new V({renderType:n.Bare});this.setAggregation("_content",r);this._sResizeListenerId=R.register(r,this._onResize.bind(this));}return r;};p.prototype._addGroups=function(C){var q=this._getRootContainer(),r,s=true,G=C.groups||[];G.forEach(function(t,i){var u=this._createGroup(t);if(t.alignment==="Stretch"){u.setLayoutData(new F({growFactor:1}));if(i===G.length-1){u.addStyleClass("sapFCardObjectGroupLastInColumn");}q.addItem(u);s=true;}else{if(s){r=this._createAFLayout();q.addItem(r);s=false;}r.addContent(u);}},this);this._oActions.attach({area:o.Content,actions:C.actions,control:this});};p.prototype._createGroup=function(G){var v;if(typeof G.visible=="string"){v=!U.hasFalsyValueAsString(G.visible);}else{v=G.visible;}var i=new V({visible:v,renderType:n.Bare}).addStyleClass("sapFCardObjectGroup");if(G.title){i.addItem(new a({text:G.title}).addStyleClass("sapFCardObjectItemTitle"));i.addStyleClass("sapFCardObjectGroupWithTitle");}G.items.forEach(function(I){this._createGroupItems(I).forEach(i.addItem,i);},this);return i;};p.prototype._createGroupItems=function(i){var v=i.label,q,r,C;if(typeof i.visible=="string"){r=!U.hasFalsyValueAsString(i.visible);}else{r=i.visible;}if(v){v=h.formattedProperty(v,function(u){return u&&u[u.length-1]===":"?u:u+":";});q=new c({text:v,visible:r}).addStyleClass("sapFCardObjectItemLabel");}C=this._createItem(i,r,q);if(C){C.addStyleClass("sapFCardObjectItemValue");}if(i.icon){var s=new V({renderType:n.Bare,items:[q,C]});var t=new H({visible:r,renderType:n.Bare,items:[this._createGroupItemAvatar(i.icon),s]}).addStyleClass("sapFCardObjectItemLabel");return[t];}else{return[q,C];}};p.prototype._createGroupItemAvatar=function(i){var s=h.formattedProperty(i.src,function(v){return this._oIconFormatter.formatSrc(v);}.bind(this));var q=new A({displaySize:i.size||k.XS,src:s,initials:i.text,displayShape:i.shape,tooltip:i.alt,backgroundColor:i.backgroundColor||(i.text?undefined:m.Transparent)}).addStyleClass("sapFCardObjectItemAvatar sapFCardIcon");return q;};p.prototype._createItem=function(i,v,q){var C,r=i.value,s;switch(i.type){case"NumericData":C=this._createNumericDataItem(i);break;case"Status":C=this._createStatusItem(i,v);break;case"link":e.warning("Usage of Object Group Item property 'type' with value 'link' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");C=new b({href:i.url||r,text:r,target:i.target||'_blank',visible:h.reuse(v)});break;case"email":e.warning("Usage of Object Group Item property 'type' with value 'email' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");var t=[];if(i.value){t.push(i.value);}if(i.emailSubject){t.push(i.emailSubject);}s=h.formattedProperty(t,function(u,E){if(E){return"mailto:"+u+"?subject="+E;}else{return"mailto:"+u;}});C=new b({href:s,text:r,visible:h.reuse(v)});break;case"phone":e.warning("Usage of Object Group Item property 'type' with value 'phone' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");s=h.formattedProperty(r,function(u){return"tel:"+u;});C=new b({href:s,text:r,visible:h.reuse(v)});break;default:C=this._createTextItem(i,v,q);}return C;};p.prototype._createNumericDataItem=function(i){var v=new V();var q=new N({number:i.mainIndicator.number,numberSize:i.mainIndicator.size,scale:i.mainIndicator.unit,trend:i.mainIndicator.trend,state:i.mainIndicator.state}).addStyleClass("sapUiIntOCNumericIndicators");v.addItem(q);if(i.sideIndicators){i.sideIndicators.forEach(function(I){q.addSideIndicator(new j({title:I.title,number:I.number,unit:I.unit,state:I.state}));});}if(i.details){v.addItem(new T({text:i.details,maxLines:1}).addStyleClass("sapUiIntOCNumericIndicatorsDetails"));}return v;};p.prototype._createStatusItem=function(i,v){var C=new d({text:i.value,visible:h.reuse(v),state:i.state});return C;};p.prototype._createTextItem=function(i,v,q){var r=i.value,C;if(r&&i.actions){C=new b({text:r,visible:h.reuse(v)});if(q){C.addAriaLabelledBy(q);}else{e.warning("Missing label for Object group item with actions.",null,"sap.ui.integration.widgets.Card");}this._oActions.attach({area:o.ContentItemDetail,actions:i.actions,control:this,actionControl:C,enabledPropertyName:"enabled"});}else if(r){C=new T({text:r,visible:h.reuse(v),maxLines:i.maxLines});}return C;};p.prototype._createAFLayout=function(){var i=new f();i.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},i);return i;};p.prototype._onResize=function(E){if(E.size.width===E.oldSize.width){return;}var I=this._getRootContainer().getItems();I.forEach(function(q,i){if(q.isA("sap.ui.layout.AlignedFlowLayout")){this._onAlignedFlowLayoutResize(q,E,i===I.length-1);}}.bind(this));};p.prototype._onAlignedFlowLayoutResize=function(i,E,q){var M=i.getMinItemWidth(),r,s=i.getContent().filter(function(v){return v.getVisible();}).length;if(M.lastIndexOf("rem")!==-1){r=g.toPx(M);}else if(M.lastIndexOf("px")!==-1){r=parseFloat(M);}var C=Math.floor(E.size.width/r);if(C>s){C=s;}var t=C-1,u=Math.ceil(s/C);i.getContent().forEach(function(I,v){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(t===v&&t<s){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");t+=C;}if(q&&v+1>(u-1)*C){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};return p;});
