/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/integration/cards/actions/CustomAction","sap/ui/integration/cards/actions/DateChangeAction","sap/ui/integration/cards/actions/MonthChangeAction","sap/ui/integration/cards/actions/SubmitAction","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/util/BindingResolver","sap/base/strings/capitalize"],function(l,L,M,C,D,a,S,N,B,c){"use strict";function _(s){if(s&&typeof s==="object"){return s.name;}return s;}var A=l.CardActionArea,b=l.CardActionType;var d=M.extend("sap.ui.integration.cards.actions.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});d.prototype.attach=function(o){var e=o.control,s=o.area;o.actionControl=o.actionControl||o.control;o.enabledPropertyValue=o.enabledPropertyValue||true;o.disabledPropertyValue=o.disabledPropertyValue||false;o.eventName=o.eventName||"press";if(!o.actions){this._fireActionReady(e,s);return;}var f=o.actions[0];if(f&&f.type){o.action=f;this._attachAction(o);}else{this._fireActionReady(e,s);}};d.prototype._attachAction=function(o){var e=o.action,s=o.area,f=o.control,g=o.actionControl,E=o.enabledPropertyName,v=o.enabledPropertyValue,h=o.disabledPropertyValue,i=true,j=this._isSingleAction(s),k=true;if(E){i=false;if(e.service&&!j){this._setControlEnabledStateUsingService(e,f,g,E,v,h);}else{this._setControlEnabledState(e,g,E,v,h);}}if(e.service&&j){this._getSingleActionEnabledState(e,f).then(function(m){if(m){this._attachEventListener(o);}this._fireActionReady(f,s);}.bind(this));return;}if(i){k=e.enabled!==false&&e.enabled!=="false";}if(k){this._attachEventListener(o);}this._fireActionReady(f,s);};d.prototype._setControlEnabledStateUsingService=function(o,e,f,p,E,v){var g=M.bindingParser("{path:''}");g.formatter=function(V){var h=this.getBindingContext(),P,m;if(h){P=h.getPath();}m=B.resolveValue(o.parameters,e,P);if(V.__resolved){if(!V.__enabled||V.__enabled==="false"){return v;}return E;}if(!V.__promise){V.__promise=true;e._oServiceManager.getService(_(o.service)).then(function(n){if(n){n.enabled({parameters:m}).then(function(i){V.__resolved=true;V.__enabled=i;e.getModel().checkUpdate(true);}).catch(function(){V.__resolved=true;V.__enabled=false;});}else{V.__resolved=true;V.__enabled=false;}});}return v;};f.bindProperty(p,g);};d.prototype._setControlEnabledState=function(o,e,p,E,v){var f,V;if(typeof o.enabled==="object"){f=o.enabled;f.formatter=function(g){if(!g||g==="false"){return v;}return E;};}if(f){e.bindProperty(p,f);}else{V=(o.enabled===false||o.enabled==="false")?v:E;e.setProperty(p,V);}};d.prototype._getSingleActionEnabledState=function(o,e){var f=e.getBindingContext(),p,P;if(f){P=f.getPath();}p=B.resolveValue(o.parameters,e,P);return new Promise(function(r){e._oServiceManager.getService(_(o.service)).then(function(n){if(n){n.enabled({parameters:p}).then(function(E){r(E);}).catch(function(){r(false);});}else{r(false);}}).catch(function(){r(false);});});};d.prototype._fireActionReady=function(o,s){var h=s===A.Header;var e=h?"_actionHeaderReady":"_actionContentReady";o.fireEvent(e);};d.prototype._resolveBindingPath=function(e){var o=e.getSource().getBindingContext(),p;if(this.getBindingPathResolver()){p=this.getBindingPathResolver()(e);}else if(o){p=o.getPath();}return p;};d.prototype._handleServiceAction=function(E,o,f){var s=E.getSource();var p=this._resolveBindingPath(E);f._oServiceManager.getService(_(o.service)).then(function(e){if(e){e.navigate({parameters:B.resolveValue(o.parameters,s,p)});}}).catch(function(e){L.error("Navigation service unavailable",e);}).finally(function(){this._processAction(s,o,p);}.bind(this));};d.prototype._attachEventListener=function(o){var e=o.action;o.actionControl["attach"+c(o.eventName)](function(E){var s=E.getSource();if(e.service){this._handleServiceAction(E,e,o.control);}else{this._processAction(s,e,this._resolveBindingPath(E));}}.bind(this));};d.prototype._processAction=function(s,o,p){var h=this._getHostInstance(),e=this.getCard();d.fireAction({card:e,host:h,action:o,parameters:B.resolveValue(o.parameters,s,p),source:s});};d.prototype._getHostInstance=function(){var o=this.getCard();if(o){return o.getHostInstance();}return null;};d.prototype.fireAction=function(s,t,p){d.fireAction({card:this.getCard(),host:this._getHostInstance(),action:{type:t},parameters:p,source:s});};d.fireAction=function(m){var h=m.host,o=m.card,e=o.getAggregation("_extension"),p=m.parameters||{},f={type:m.action.type,card:o,actionSource:m.source,parameters:p},g=Object.assign({},f,{manifestParameters:p}),i=o.fireAction(g);if(!i){return false;}if(h){i=h.fireAction(f);}if(!i){return false;}if(e){i=e.fireAction(f);}if(i){var H=d._createHandler(m);if(H){H.execute();H.destroy();}}return i;};d.prototype._isSingleAction=function(s){return[A.Header,A.Content,A.ContentItemDetail,A.ActionsStrip].indexOf(s)>-1;};d._createHandler=function(m){var e=null;switch(m.action.type){case b.Custom:e=C;break;case b.DateChange:e=D;break;case b.MonthChange:e=a;break;case b.Navigation:e=N;break;case b.Submit:e=S;break;default:L.error("Unknown action type '"+m.action.type+"'. Expected one of "+Object.values(b).join(", "),null,"sap.ui.integration.widgets.Card");}if(e){return new e({config:m.action,parameters:m.parameters,actionHandler:m.card.getManifestEntry("/sap.card/configuration/actionHandlers/"+m.action.type.toLowerCase()),card:m.card,source:m.source});}return null;};return d;});
