//@ui5-bundle sap/ui/integration/designtime/library-preload.designtime.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/BaseEditor',["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/values","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_flatten","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/base/util/restricted/_castArray","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(c,P,V,a,r,O,h,b,C,R,d,f,g,i,v,j,k,l,_,m,n,o,p,q,s,t,J,u,L,w){"use strict";var x="customProperty--";
var B=C.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{
metadata:{library:"sap.ui.integration",properties:{"json":{type:"object"},"config":{type:"object",defaultValue:{"i18n":["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},"designtimeMetadata":{type:"object"},"layout":{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},configChange:{parameters:{config:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},
constructor:function(){this._oSetConfigPromise=Promise.resolve();this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);C.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(e){var D=e.getParameter("json");this._oDataModel.setData(this._prepareData(D));this._checkReady();},this);},
renderer:function(e,D){var E=D.getContent();e.openStart("div",D);e.openEnd();if(E.length){E.forEach(function(F){e.renderControl(F);});}else{D.getPropertyEditorsSync().forEach(function(F){e.renderControl(F);});}e.close("div");}
});
B.prototype.init=function(){};
B.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy();};
B.prototype._prepareData=function(e){var D=g(e);f(this._mObservableConfig,function(E,F){var G=F.path;if(G[0]==="/"){G=G.substr(1);}if(typeof d.get(G.split("/"),D)==="undefined"&&typeof F.defaultValue!=="undefined"){d.set(G.split("/"),g(F.defaultValue),D);}});return D;};
B.prototype.setJson=function(D){var E;if(typeof D==="string"){try{E=JSON.parse(D);}catch(e){L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified");}}else if(k(D)){E=o({},D);}else{L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()");}if(E&&JSON.stringify(this.getProperty("json"))!==JSON.stringify(E)){this.setProperty("json",E);this.fireJsonChange({json:E});}};
B.prototype.setPreventInitialization=function(e){this._bPreventInitialization=e;};
B.prototype.setConfig=function(e,I){this._bIsDefaultConfig=I;e=e||{};this._oSetConfigPromise=this._oSetConfigPromise.then(this._registerPropertyEditorTypes.bind(this,e.propertyEditors)).then(this._setConfig.bind(this,e,I));return this._oSetConfigPromise;};
B.prototype._registerPropertyEditorTypes=function(e){P.deregisterAllTypes();return P.registerTypes(e||{});};
B.prototype._setConfig=function(e,I,D){this._initValidators(e.validators||{});var T={propertyEditors:{},properties:{}};var N=y(T,e);if(this._oSpecificConfig){N=I?this._oSpecificConfig:A(N,this._oSpecificConfig,D);}N.i18n=q(N.i18n&&t(N.i18n),this.getMetadata().getProperty("config").getDefaultValue().i18n);this.setProperty("config",N,false);this.fireConfigChange({config:g(N)});this.initialize();};
B.prototype.addConfig=function(e,I){this._bIsDefaultConfig=I;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){e=y(this.getConfig(),e);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(D){this._setConfig(e,I,D);}.bind(this));return this._oSetConfigPromise;};
function y(T,e){var D=o({},T,e);D.i18n=[].concat(T.i18n||[],e.i18n||[]);return D;}
B.prototype._addSpecificConfig=function(S){var e;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){this._oSpecificConfig=S;e=o({},this.getConfig());e.propertyEditors=z(e,S);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(D){this._setConfig(e,this._bIsDefaultConfig,D);}.bind(this));return this._oSetConfigPromise;};
function z(e,S){var D={};var E=e.propertyEditors||{};var F=S.propertyEditors||{};q(Object.keys(E),Object.keys(F)).forEach(function(G){D[G]=F[G]||E[G];});return D;}
function A(e,S,D){e.i18n=q(e.i18n,S.i18n);var N=Object.assign({},e,p(S,["properties","i18n","propertyEditors"]),p(e,["properties","i18n","propertyEditors"]));N.properties={};f(e.properties,function(E,F){var G=e.propertyEditors[F.type]&&e.propertyEditors[F.type].split("/").join(".");var H=G&&D[G].configMetadata;if(H&&S.properties[E]){f(F,function(K,T){var I;var M=H[K]&&H[K].mergeStrategy;if(M){if(M==="mostRestrictiveWins"){var Q=H[K].mostRestrictiveValue||false;if(T===Q){I=Q;}else{I=S.properties[E][K];}}else if(M==="intersection"){I=_(T,S.properties[E][K]);}}else{I=T;}N.properties[E]=N.properties[E]||{};N.properties[E][K]=I;});}});return N;}
B.prototype.setDesigntimeMetadata=function(D,I){var N=g(D,15);if(!i(N,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",N);this._oDesigntimeMetadataModel.setData(N);if(!I){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(N)});}}};
B.prototype._formatExportedDesigntimeMetadata=function(M){var F={};var e=function(D,E){Object.keys(D).forEach(function(K){var G=D[K];if(K==="__value"){F[E.join("/")]=G;}else if(k(G)){e(G,[].concat(E,K));}});};e(M||{},[]);return F;};
B.prototype._initValidators=function(e){V.deregisterAllValidators();V.registerValidators(e);V.ready().then(function(){this._bValidatorsReady=true;this._checkReady();}.bind(this));};
B.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(e){e();});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oConfigObserver){this._oConfigObserver.destroy();}f(this._mPropertyEditors,function(e,D){D.forEach(function(E){this.deregisterPropertyEditor(E,e);},this);}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy();}};
B.prototype.initialize=function(){if(!this._bPreventInitialization){this._initialize();}};
B.prototype._initialize=function(){this._reset();var e=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return;}if(e){this._oConfigObserver=new O();this._loadI18nBundles(e.i18n).then(function(D){this._oI18nModel=this._createI18nModel(D);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var E=this._getContextPath();if(E){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(E),"context");}var F=r(e.properties,{"i18n":this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(F));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var G=this.getContent();if(G.length===0||G.length===1&&G[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject());}this._bInitFinished=true;this._checkReady();}.bind(this));}};
B.prototype._onConfigChange=function(e){var D=e.getParameter("changes").reduce(function(F,G){var H=g(G);H.path=H.path.split("/");H.propertyKey=H.path.shift();if(!F[H.propertyKey]){F[H.propertyKey]=[];}F[H.propertyKey].push(H);return F;},{});var E=Object.keys(D).reduce(function(F,G){var H=(this.getPropertyEditorsByNameSync(G)||[]).map(function(K){return{editor:K,propertyName:G};});F=F.concat(H);return F;}.bind(this),[]);var I=E.filter(function(F){return!this._oRootWrapper||!j(this._oRootWrapper._aEditorWrappers,F.editor);}.bind(this));I.forEach(function(F){var G=F.propertyName;var H=e.getSource().getObject();var K=p(g(H[G]),"value");var N=false;var Q=D[G]||[];Q.forEach(function(S){if(S.path[0]==="value"){F.editor.setValue(S.value);}else{d.set(S.path,S.value,K);N=true;}});if(N){F.editor.setConfig(K);}});if(I.length<E.length){var M=g(this._oRootWrapper.getConfig()).map(function(F){var G=D[F.__propertyName]||[];G.forEach(function(H){d.set(H.path,H.value,F);});return F;});this._oRootWrapper.setConfig(M);}};
B.prototype._createModel=function(){var M=new J();M.setDefaultBindingMode("OneWay");return M;};
B.prototype.getI18nProperty=function(N,e){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(N,e);}return N;};
B.prototype._loadI18nBundles=function(e){return this._createPromise(function(D,E){Promise.all(e.map(function(I){return new Promise(function(D,F){u.create({url:sap.ui.require.toUrl(I),async:true}).then(D,F);});})).then(D,E);});};
B.prototype._createI18nModel=function(e){var D=e.slice();var I=new R({bundle:D.shift()});I.setDefaultBindingMode("OneWay");D.forEach(function(E){I.enhance(E);});return I;};
B.prototype._prepareConfig=function(e){var D={};f(e,function(K,E){D[K]=Object.assign({},this._preparePropertyConfig(E),{__propertyName:K});}.bind(this));return D;};
B.prototype._preparePropertyConfig=function(e){var D=this._getContextPath();if(D&&!D.endsWith("/")){D=D+"/";}var E=e.path;if(!E.startsWith("/")&&D){E=D+E;}return Object.assign({},e,{path:E,value:"{"+E+"}",designtime:"{designtimeMetadata>"+E+"}"});};
B.prototype._createEditors=function(e){var D=d.get(["layout",this.getLayout()],this.getConfig());if(k(D)||Array.isArray(D)){D=r(D,{"i18n":this._oI18nModel});}this._oRootWrapper=new a({config:v(e),layout:this.getLayout(),layoutConfig:D});this.addContent(this._oRootWrapper);return(Promise.all(v(this._mPropertyEditors).reduce(function(E,F){return E.concat(F);},[]).map(function(E){return E.ready();})).then(this._checkReady.bind(this)));};
B.prototype._getRegistrationKey=function(e,K){if(typeof K!=="string"){if(e.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!e.getConfig()&&!e.getBindingInfo("config")&&e.getPropertyName()){K=e.getPropertyName();}else{K=x+e.getId();}}return K;};
B.prototype._addCustomProperty=function(K,e){var D=Object.assign({},this._mObservableConfig);D[K]=this._preparePropertyConfig(e);this._mObservableConfig=D;this._oConfigObserver.setObject(D);};
B.prototype._removeCustomProperty=function(K){var e=p(this._mObservableConfig,K);this._mObservableConfig=e;this._oConfigObserver.setObject(e);};
B.prototype.registerPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var D=Array.isArray(this._mPropertyEditors[K])?this._mPropertyEditors[K]:[];this._mPropertyEditors[K]=D.concat(e);if(K.startsWith(x)){this._addCustomProperty(K,e.getConfig());}var E=d.get([K],this._oConfigObserver.getObject()).value;e.setValue(E);e.attachValueChange(this._onValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);e.attachReady(this._checkReady,this);e.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()});}.bind(this));};
B.prototype.deregisterPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var D=this._mPropertyEditors[K];if(K.startsWith(x)){this._removeCustomProperty(K);}e.detachValueChange(this._onValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(D)){this._mPropertyEditors[K]=D.filter(function(I){return e!==I;});if(this._mPropertyEditors[K].length===0){delete this._mPropertyEditors[K];}}};
B.prototype._setReady=function(e){var D=this._bIsReady;this._bIsReady=e;if(D!==true&&e===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()});}};
B.prototype._checkReady=function(){var e=this.getContent().filter(function(E){return(E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"));});e.forEach(function(E){if(!sap.ui.base.EventProvider.hasListener(E,"ready",this._checkReady,this)){E.attachReady(this._checkReady,this);}},this);var D=[].concat(e,this.getPropertyEditorsSync());var I=(this._bInitFinished&&this._bValidatorsReady&&D.every(function(E){return E.isReady();}));this._setReady(I);};
B.prototype.isReady=function(){return this._bIsReady;};
B.prototype.ready=function(){return new Promise(function(e){if(this.isReady()){e();}else{this.attachEventOnce("propertyEditorsReady",e);}}.bind(this));};
B.prototype.hasError=function(){return m(Object.values(this._mPropertyEditors||{})).some(function(e){return e.hasError();});};
B.prototype._createPromise=function(e){var D=c(e);this._aCancelHandlers.push(D.cancel);var E=function(F,G){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==F;});return G;}.bind(this,D.cancel);return D.promise.then(E,E);};
B.prototype.getPropertyConfigByName=function(e){return p(d.get([e],this._oConfigObserver.getObject()),"value");};
B.prototype.getPropertyEditorsByName=function(e){return new Promise(function(D){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",D);}else{D();}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(e);}.bind(this));};
B.prototype.getPropertyEditorsByNameSync=function(e){var D=this._mPropertyEditors[e];return Array.isArray(D)&&D.slice()||null;};
B.prototype.getPropertyEditorsByTag=function(T){return new Promise(function(e){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",e);}else{e();}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(T);}.bind(this));};
B.prototype.getConfigsByTag=function(T){var e=this.getConfig().properties;return Object.keys(e).filter(function(D){return h(e[D],T);}).map(function(D){return e[D];});};
B.prototype.getPropertyEditorsByTagSync=function(T){return this.getPropertyEditorsSync().filter(function(e){return h(e.getConfig(),T);});};
B.prototype.getPropertyEditorsSync=function(){return v(this._mPropertyEditors).reduce(function(e,D){return e.concat(D);},[]).sort(function(e,D){return parseInt(e.getId().match(/\d+$/))-parseInt(D.getId().match(/\d+$/));});};
B.prototype.getJson=function(){return o({},this.getProperty("json"));};
B.prototype.getDesigntimeMetadata=function(){return o({},this.getProperty("designtimeMetadata"));};
B.prototype._getContextPath=function(){var e=this.getConfig();var D=e&&e.context||null;if(D&&D[0]!=="/"){D="/"+D;}return D;};
B.prototype._onValueChange=function(e){var D=e.getSource();var E=e.getParameter("path");var F=this.getJson()||{};var G=e.getParameter("value");if(E[0]==="/"){E=E.substr(1);}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+E+"'");}var H=E.split("/");d.set(H,G,F);if(typeof G==="undefined"||i(G,D.getRuntimeConfig().defaultValue)||Array.isArray(G)&&G.length===0||k(G)&&l(G)){w(F,H);}this.setJson(F);};
B.prototype._onDesigntimeMetadataChange=function(e){var D=e.getParameter("path");var E=this.getDesigntimeMetadata()||{};var F=e.getParameter("value");if(D[0]==="/"){D=D.substr(1);}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+D+"'");}var G=D.split("/");d.set(G,F,E);b(E);this.setDesigntimeMetadata(E);};
return B;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditor',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone"],function(C,f,c,e,P,_,a,d,b){"use strict";var g="config";var h="propertyName";
var i=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{
metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
constructor:function(){C.prototype.constructor.apply(this,e(arguments,function(v,p){return(p==="config"&&P.hasType(v.type));}));if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(E){if(this._sCreatedBy){this._removePropertyEditor(E.getParameter("previousEditor"));}this._initPropertyEditor();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var o=E.getParameter("config");var n=this.getAggregation("propertyEditor");if(this._fnCancelInit||!n||!p||!o||p.type!==o.type||p.path!==o.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor();}else{n.setConfig(o);if(o.visible!==false&&p.visible===false){n.setValue(this.getValue());}}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===h){this._removePropertyEditor(this.getEditor());}if(this._sCreatedBy!==g){this._initPropertyEditor();}});this._initPropertyEditor();},
renderer:function(r,o){r.openStart("div",o);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();r.renderControl(o.getAggregation("propertyEditor"));r.close("div");}
});
i.prototype.init=function(){Promise.resolve().then(function(){this.fireInit();}.bind(this));};
i.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
i.prototype._prepareConfig=function(o){var B=this.getEditor();var E=(o.type&&B)?(B.getConfig().propertyEditorConfigs||{})[o.type]:{};return _({},E,o);};
i.prototype.setConfig=function(m){var p=this.getConfig();var n=m&&_({},{designtime:undefined},this._prepareConfig(m));if(!d(p,n)){this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
i.prototype.setPropertyName=function(p){var s=this.getPropertyName();if(s!==p){this.setProperty("propertyName",p);this.firePropertyNameChange({previousPropertyName:s,propertyName:p});}};
i.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});this.setConfig(this.getConfig());}};
i.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());C.prototype.destroy.apply(this,arguments);};
i.prototype._cleanupCancelledInit=function(p){p.destroy();};
i.prototype._removePropertyEditor=function(E){var p=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}if(p){this.setAggregation("propertyEditor",null);p.detachReady(this._onPropertyEditorReady,this);p.detachValidationErrorChange(this._onPropertyEditorError,this);p.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null});}if(E&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){E.deregisterPropertyEditor(this,this._mConfig.__propertyName);}};
i.prototype.isReady=function(){var n=this.getAggregation("propertyEditor");return n&&n.isReady()||false;};
i.prototype.hasError=function(){var n=this.getAggregation("propertyEditor");return n&&n.hasError();};
i.prototype.ready=function(){return new Promise(function(r){var j=function(n){n.ready().then(r);};var n=this.getAggregation("propertyEditor");if(n){j(n);}else{var w=function(E){var n=E.getParameter("propertyEditor");if(n){this.detachPropertyEditorChange(w,this);j(n);}};this.attachPropertyEditorChange(w,this);}}.bind(this));};
i.prototype._onPropertyEditorReady=function(){this.fireReady();};
i.prototype._onPropertyEditorError=function(E){this.fireValidationErrorChange({hasError:E.getParameter("hasError")});};
i.prototype._initPropertyEditor=function(){if(!this.getEditor()){return;}if(this.getConfig()||(!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor())){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var s=this.getConfig()?g:h;var p=c(function(r,R){P.create(this._mConfig.type).then(r).catch(R);}.bind(this));this._fnCancelInit=p.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName);}p.promise.then(function(o){o.setModel(this.getEditor().getModel("i18n"),"i18n");o.setConfig(a(_({},this._mConfig),"__propertyName"));o.attachBeforeValueChange(function(E){this.fireBeforeValueChange(a(E.getParameters(),"id"));},this);o.attachValueChange(function(E){this.setValue(E.getParameter("value"));this.fireValueChange(a(E.getParameters(),"id"));},this);o.attachDesigntimeMetadataChange(function(E){this.fireDesigntimeMetadataChange(a(E.getParameters(),"id"));},this);o.setValue(this.getValue(),true);this._sCreatedBy=s;this.setAggregation("propertyEditor",o);var r=this.getRenderLabel();if(r!==undefined){o.setRenderLabel(r);}o.attachReady(this._onPropertyEditorReady,this);if(o.isReady()){this.fireReady();}o.attachValidationErrorChange(this._onPropertyEditorError,this);if(o.hasError()){this.fireValidationErrorChange({hasError:true});}this.firePropertyEditorChange({propertyEditor:o});delete this._fnCancelInit;}.bind(this));}};
i.prototype._isAbsolutePath=function(p){return p&&p.startsWith("/");};
i.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
i.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
i.prototype.setRenderLabel=function(r){this.setProperty("renderLabel",r);var n=this.getAggregation("propertyEditor");if(n){n.setRenderLabel(r);}};
i.prototype.getContent=function(){var n=this.getAggregation("propertyEditor");return n&&n.getContent();};
i.prototype.setValue=function(v){this.setProperty("value",v);var n=this.getAggregation("propertyEditor");if(n){n.setValue(v,true);}};
i.prototype.getRuntimeConfig=function(){return this._mConfig;};
i.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}};
i.prototype.getFocusDomRef=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getFocusDomRef();}};
i.prototype.getIdForLabel=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getIdForLabel();}};
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditors',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(C,f,c,i,S,_,a,d,b,F,J,M){"use strict";var e="config";var g="tags";var l={"list":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},"form":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};
var P=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{
metadata:{library:"sap.ui.integration",properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
_bLayoutReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;C.prototype.constructor.apply(this,arguments);var m=new J();this.setModel(m);if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var h=E.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(p)||!Array.isArray(h)||p.length!==h.length){this._removePropertyEditors();this._initPropertyEditors();}else if(this._sCreatedBy){this._evaluateViewRecreation(p,h);}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors();}if(this._sCreatedBy!==e){this._initPropertyEditors();}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout());}},
renderer:function(r,o){r.openStart("div",o);r.openEnd();r.renderControl(o.getContent());r.close("div");}
});
P.prototype.init=function(){this.attachLayoutChange(function(E){var p=E.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(p));var L=E.getParameter("layout");this._initLayout(L);},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit();}.bind(this));};
P.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}this._removeStylesheet(this._getLayoutPath(this.getLayout()));C.prototype.destroy.apply(this,arguments);};
P.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
P.prototype._loadModule=function(s){return new Promise(function(r,R){sap.ui.require([s],r,R);});};
P.prototype._loadStylesheet=function(s){this._bCssRequested=true;return S.add(s);};
P.prototype._removeStylesheet=function(s){if(this._bCssRequested){S.remove(s);delete this._bCssRequested;}};
P.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
P.prototype.setConfig=function(m){var p=this.getConfig();if(!Array.isArray(p)||!Array.isArray(m)||JSON.stringify(p)!==JSON.stringify(m)){var n=b(m);this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
P.prototype.setTags=function(t){var p=this.getTags();var r=t;if(typeof t==="string"){r=t.split(",").sort().join(",");}if(p!==r){this.setProperty("tags",r);this.fireTagsChange({previousTags:p,tags:r});}};
P.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};
P.prototype._removePropertyEditors=function(){var p=this.removeAllAssociation("propertyEditors").map(function(s){return sap.ui.getCore().byId(s);});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(p.length){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:[]});}};
P.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||(!this.getBindingInfo("config")&&this.getTags()))&&this._bLayoutReady){var E=this.getEditor();var h;if(this.getConfig()){h=this.getConfig();this._sCreatedBy=e;}else{var t=this.getTags().split(",");h=E.getConfigsByTag(t);this._sCreatedBy=g;}var p=(this._getPropertyEditors()||[]).slice();this._updateViewModel(h);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:(this._getPropertyEditors()||[]).slice()});}.bind(this));}this._checkReadyState();};
P.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
P.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
P.prototype.setLayout=function(L){var p=this.getLayout();if(p!==L){this.setProperty("layout",L);this.fireLayoutChange({previousLayout:p,layout:L});}};
P.prototype.setLayoutConfig=function(L){var p=this.getLayoutConfig();if(!d(p,L)){this.setProperty("layoutConfig",L);this.fireLayoutConfigChange({previousLayoutConfig:p,layoutConfig:L});}};
P.prototype._getLayoutConfig=function(){var L=this.getLayoutConfig();var r=this.getRenderLabels();var R;if(typeof r==="boolean"){R={renderLabels:r};}var D=l[this.getLayout()]&&l[this.getLayout()].defaultConfig||{};return Object.assign({},D,L,R);};
P.prototype._getLayoutPath=function(L){return l.hasOwnProperty(L)?l[L].module:L;};
P.prototype._initLayout=function(L){this.destroyContent();var p=this._getLayoutPath(L);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors();}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}var m=c(function(r,R){this._loadStylesheet(p);Promise.all([this._loadFragment(p),this._loadModule(p)]).then(r,R);}.bind(this));m.promise.then(function(r){delete this._fnCancelLayoutLoading;var o=r[0];var h=r[1];this._prepareData=h.prepareData;this._aUpdateDependencies=h.updateDependencies||[];this.setContent(o);this._bLayoutReady=true;this._initPropertyEditors();}.bind(this));this._fnCancelLayoutLoading=m.cancel;};
P.prototype._evaluateViewRecreation=function(p,h){var r=this._getPropertyEditors()||[];if(p.length!==h.length||h.length!==r.length||h.some(function(o,I){return this._aUpdateDependencies.some(function(D){return p[I][D]!==o[D];});}.bind(this))){this._updateViewModel(h);}else{r.map(function(o,I){var j=h[I];o.setConfig(a(b(j),"value"));if(j.hasOwnProperty("value")){o.setValue(j.value);}});}};
P.prototype._updateViewModel=function(h){var D=this._prepareData(h,this._getLayoutConfig());this._iExpectedWrapperCount=D.count;if(this._iExpectedWrapperCount>0){this._checkReadyState();}this.getModel().setData(D);};
P.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
P.prototype.isReady=function(){return!!this._bIsReady;};
P.prototype.hasError=function(){return this._aEditorWrappers.some(function(w){return w.hasError();});};
P.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
P.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bLayoutReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
P.prototype.wrapperInit=function(E){var w=E.getSource();if(i(w,this)){return;}if(!w.getEditor()){w.setEditor(this.getEditor());}this._aEditorWrappers.push(w);this.addAssociation("propertyEditors",w);w.attachReady(function(){this._setReady(false);this._checkReadyState();}.bind(this));w.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()});}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){this._aEditorWrappers=this._aEditorWrappers.filter(function(o){return o!==m.object;});this.removeAssociation("propertyEditors",m.object);}.bind(this));}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
P.prototype._getPropertyEditors=function(){var p=(this.getAssociation("propertyEditors")||[]).map(function(I){return sap.ui.getCore().byId(I);});return p.length&&p||null;};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/layout/Form',["sap/ui/integration/designtime/baseEditor/util/hasTag","sap/base/util/restricted/_omit"],function(h,_){"use strict";var d={labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false};
function c(P){return{label:P.label,value:P.value,config:_(P,["label","value"])};}
function g(C,t){var r=[];var i=0;while(i<C.length){var m=C[i];if(h(m,t)){r.push(m);C.splice(i,1);}else{i++;}}return r;}
function a(C,P){var i=C.findIndex(function(m){return m.__propertyName===P;});if(i>-1){return C.splice(i,1)[0];}}
function b(C){return C.some(function(G){return typeof G.config.visible==="boolean"?G.config.visible:true;});}
function p(P,l){l=l||{};var C=P.slice();var G=l.groups||[];var r=l.responsiveGridLayout||d;var R=l.renderLabels!==false;var v={responsiveGridLayout:r};if(!R){C=C.map(function(m){return _(m,"label");});}if(G.length>0){v.groups=G.map(function(m){var i=[];m.items.forEach(function(I){switch(I.type){case"tag":i=i.concat(g(C,I.value).map(function(f){return c(f);}));break;case"propertyName":var e=a(C,I.value);if(e){i=i.concat(c(e));}break;}});return{label:m.label,items:i,visible:b(i)};});}else{var i=C.splice(0,C.length).map(c);v.groups=[{items:i,visible:b(i)}];}v.groups=v.groups.filter(function(m){return m.items.length>0;});v.count=P.length-C.length;return v;}
return{prepareData:p,updateDependencies:["visible","tags"]};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor',["sap/ui/core/Control","./../util/isTemplate","sap/ui/model/json/JSONModel","sap/m/Label","sap/ui/core/Fragment","sap/base/util/restricted/_omit","sap/ui/base/ManagedObjectObserver","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/base/util/restricted/_CancelablePromise","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/values","sap/base/util/each","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata"],function(C,i,J,L,F,_,M,P,c,a,d,b,e,v,f,V,B,g){"use strict";
var h=C.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",{
metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{"renderLabel":{type:"boolean",defaultValue:true},"value":{type:"any"},"config":{type:"object"}},aggregations:{"_label":{type:"sap.m.Label",visibility:"hidden",multiple:false},"content":{type:"sap.ui.core.Control",multiple:false}},events:{beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},fragmentChange:{parameters:{previousFragment:{type:"string"},fragment:{type:"string"}}},ready:{},init:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},
xmlFragment:null,
_currentXmlFragment:null,
_bFragmentReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._currentXmlFragment=this.xmlFragment;C.prototype.constructor.apply(this,arguments);this._oDefaultModel=new J({value:this.getValue(),config:this.getConfig(),displayValue:this._formatValue(this.getValue())});this._oDefaultModel.setDefaultBindingMode("OneWay");this.setBindingContext(this._oDefaultModel.getContext("/"));this.setModel(this._oDefaultModel);this.bindProperty("visible","config/visible");this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;this.attachBeforeValueChange(function(E){this._iExpectedWrapperCount=this.getExpectedWrapperCount(E.getParameter("nextValue"));},this);this.attachValueChange(function(E){var m=E.getParameter("value");this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{value:m,displayValue:this._formatValue(m)}));this._checkReadyState();},this);this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var m=E.getParameter("config");if(p&&m&&!b(p.validators,m.validators)){this._validate(this.getValue());}this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{config:m}));},this);this.asyncInit().then(function(){this._bInitFinished=true;this.fireInit();this._checkReadyState();}.bind(this));if(this.getFragment()){this._initFragment(this.getFragment());}},
renderer:function(r,p){r.openStart("div",p);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();if(p.getRenderLabel()&&p.getLabel()){r.openStart("div");r.openEnd();r.renderControl(p.getLabel());r.close("div");}r.renderControl(p.getContent());r.close("div");}
});
h.prototype.init=function(){this.attachFragmentChange(function(E){if(this.getContent()){this.getContent().destroy();}var s=E.getParameter("fragment");this._initFragment(s);},this);};
h.prototype.asyncInit=function(){return Promise.resolve();};
h.prototype.onFragmentReady=function(){};
h.prototype.setValue=function(m,s){var n=this.getValue();var p=this.getConfig()||{};var N=m;if(p.type==="integer"&&Number.isInteger(Number(m))){N=parseInt(m);}if(p.visible===false){return;}if(typeof N==="undefined"&&typeof p.defaultValue!=="undefined"){N=d(p.defaultValue);}this._validate(N,function(r){if((r||s)&&!b(N,n)){this.fireBeforeValueChange({path:p.path,value:n,nextValue:N});this.setProperty("value",N);this.fireValueChange({path:p.path,previousValue:n,value:N});}this.setHasOwnError(!r);}.bind(this));};
h.prototype.setDesigntimeMetadata=function(m){var n=this.getDesigntimeMetadata();var N=m;g(N);var p=this.getConfig();if(!b(n,N)){this.fireDesigntimeMetadataChange({path:p.path,previousValue:n,value:N});}};
h.prototype.getDesigntimeMetadata=function(){return(this.getConfig()||{}).designtime||{};};
h.prototype.setDesigntimeMetadataValue=function(m){this.setDesigntimeMetadata(Object.assign({},this.getConfig().designtime,{__value:m}));};
h.prototype.getNestedDesigntimeMetadata=function(K){var D=(this.getConfig()||{}).designtime||{};return D[K];};
h.prototype.getNestedDesigntimeMetadataValue=function(K){return(this.getNestedDesigntimeMetadata(K)||{}).__value||{};};
h.prototype.getDesigntimeMetadataValue=function(){var D=(this.getConfig()||{}).designtime||{};return D.__value||{};};
h.prototype._getValidators=function(){var p=this.getConfig().validators||{};return v(Object.assign({},this.getDefaultValidators(),p)).filter(function(m){return m.isEnabled!==false;});};
h.prototype.getDefaultValidators=function(){return{};};
h.prototype._validate=function(m,n){var E=[];var p=this._getValidators();p=p.map(function(r){var s=V.hasValidator(r.type)?V.getValidator(r.type):this.getDefaultValidatorModules()[r.type];if(!s){throw new Error("Unknown validator: "+r.type);}var t={};var u=r.errorMessage||s.errorMessage;var w=[];var x=u;if(e(u)){w=u.placeholders(r.config);x=u.message;}Object.keys(r.config||{}).forEach(function(y){var z=r.config[y];if(typeof z==="function"){z=z(this);}t[y]=z;}.bind(this));return{validator:s,config:t,errorMessage:this.getI18nProperty(x,w),type:r.type};}.bind(this));var q=function(){var r=E.length===0;this.setInputState(!r,E[0]);if(typeof n==="function"){n(r);}}.bind(this);p.forEach(function(r){if(!r.validator.validate(m,r.config)){E.push(r.errorMessage);}});q();};
h.prototype.setInputState=function(H,E){this._sErrorMessage=H&&E;if(this.isReady()){this._setInputState();}};
h.prototype._setInputState=function(){var I=this.getContent();if(!I||!I.setValueState){return;}var E=this._sErrorMessage;if(E){I.setValueState("Error");I.setValueStateText(E);}else{I.setValueState("None");}};
h.prototype.getDefaultValidatorModules=function(){return B;};
h.prototype._formatValue=function(m){return this.formatValue(d(m));};
h.prototype.formatValue=function(m){return m;};
h.prototype.getExpectedWrapperCount=function(){return 0;};
h.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bFragmentReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
h.prototype.wrapperInit=function(E){if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){var O=m.object;switch(m.type){case'destroy':this._aEditorWrappers=this._aEditorWrappers.filter(function(n){return n!==O;});this._checkReadyState();this._checkForError();break;case'parent':k(O).forEach(function(w){if(!i(w,this)){this._registerWrapper(w);}else{o(this._oWrapperObserver,w);}}.bind(this));this._oWrapperObserver.unobserve(O);break;default:return;}}.bind(this));}var w=E.getSource();if(i(w,this)){o(this._oWrapperObserver,w);return;}this._registerWrapper(w);};
function o(w,W){var r=j(W);if(!w.isObserved(r,{parent:true})){w.observe(r,{parent:true});}}
function j(E){var p=E.getParent();return p?j(p):E;}
function k(E){return l(E)?[E]:E.findAggregatedObjects(true,function(E){return l(E);});}
function l(E){return E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor");}
h.prototype._registerWrapper=function(w){this._aEditorWrappers.push(w);w.attachReady(function(E){this._setReady(false);this._checkReadyState();}.bind(this));w.attachValidationErrorChange(this._checkForError.bind(this));if(w.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")){w.attachPropertyEditorChange(function(E){var p=E.getParameter("propertyEditor");if(!p){this._setReady(false);}},this);}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
h.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
h.prototype.isReady=function(){return!!this._bIsReady;};
h.prototype.setHasOwnError=function(H){this._bHasOwnError=H;this._checkForError();};
h.prototype._checkForError=function(){var H=this.hasError();if(H!==this._bHasError){this._bHasError=H;this.fireValidationErrorChange({hasError:H});}};
h.prototype.hasError=function(){return!!this._bHasOwnError||this._aEditorWrappers.some(function(w){return w.hasError();});};
h.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
h.prototype.setFragment=function(s,G){if(this._currentXmlFragment!==s){var p=this._currentXmlFragment;this._currentXmlFragment=s;if(typeof G==='function'){this.getExpectedWrapperCount=G;}this.fireFragmentChange({previousFragment:p,fragment:s});}};
h.prototype.getFragment=function(){return this._currentXmlFragment;};
h.prototype._initFragment=function(s){this._setReady(false);this._bFragmentReady=false;if(this._oFragmentPromise){this._oFragmentPromise.cancel();}var m=new a(function(r,R,n){n.shouldReject=false;this._loadFragment(s).then(r,R);}.bind(this));this._oFragmentPromise=m;return m.then(function(n){if(m.isCanceled){n.destroy();return;}this._bFragmentReady=true;this.setContent(n);this.onFragmentReady();this._setInputState();this._checkReadyState();}.bind(this));};
h.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
h.prototype.clone=function(){this.destroyContent();return C.prototype.clone.apply(this,arguments);};
h.prototype.exit=function(){this._oDefaultModel.destroy();if(this._oConfigBinding){this._oConfigBinding.destroy();}if(this._oWrapperObserver){this._oWrapperObserver.destroy();}if(this._oFragmentPromise){this._oFragmentPromise.cancel();}};
h.configMetadata={visible:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.FALLBACK_TYPE"}};
h.prototype.setConfig=function(m){var p=this.getConfig();var D={};var n=P.getByClassName(this.getMetadata().getName()).configMetadata;f(n,function(s,q){D[s]=q.defaultValue;});var N=Object.assign({},D,m);N=this.onBeforeConfigChange(N);if(!b(p,N)){this.setProperty("config",N);this.fireConfigChange({previousConfig:p,config:N});}};
h.prototype.onBeforeConfigChange=function(m){return m;};
h.prototype.getI18nProperty=function(n,p){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(n,p);}return n;};
h.prototype.getLabel=function(){var m=this.getAggregation("_label");if(!m){m=new L({text:"{config/label}",design:"Bold"});this.setAggregation("_label",m);}return m;};
h.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}};
h.prototype.getFocusDomRef=function(){var m=this.getContent();if(m&&m.isA("sap.ui.core.IFormContent")){return m.getFocusDomRef();}};
h.prototype.getIdForLabel=function(){var m=this.getContent();if(m&&m.isA("sap.ui.core.IFormContent")){return m.getIdForLabel();}};
return h;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory',["sap/base/util/includes","sap/base/util/values"],function(i,v){"use strict";var P={};var l={};var p={};
P.registerTypes=function(t){Object.keys(t).forEach(function(s){if(!l[s]){l[s]=new Promise(function(r,a){sap.ui.require([t[s]],r,a);}).then(function(o){p[o.getMetadata().getName()]=o;return o;});}});return Promise.all(v(l)).then(function(){return p;});};
P.deregisterType=function(t){if(l[t]){delete l[t];}};
P.deregisterAllTypes=function(){l={};};
P.create=function(s){return new Promise(function(r,a){if(!s){a("No editor type was specified in the property configuration.");return;}if(!l[s]){a("Editor type was not registered");return;}l[s].then(function(b){return r(new b());}).catch(function(e){return a(e);});});};
P.getByClassName=function(t){return p[t];};
P.getTypes=function(){return Object.assign({},l);};
P.hasType=function(s){return i(Object.keys(P.getTypes()),s);};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/unset","sap/base/util/restricted/_isNil","sap/base/strings/formatMessage","sap/base/util/isEmptyObject"],function(B,d,a,O,J,_,r,u,b,f,i){"use strict";
var A=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",
metadata:{library:"sap.ui.integration",properties:{value:{type:"any"}}},
renderer:B.getMetadata().getRenderer().render
});
A.configMetadata=Object.assign({},B.configMetadata,{allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},collapsibleItems:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},showItemLabel:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},template:{defaultValue:{}},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ARRAY"}});
A.prototype.init=function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");};
A.prototype.setValue=function(v){v=Array.isArray(v)?v:[];B.prototype.setValue.call(this,v);this._handleValueChange(this.getValue());};
A.prototype._handleValueChange=function(v){var c=this.getConfig();var I=[];(v||[]).forEach(function(V,e){var o=d(V);var D=this.getNestedDesigntimeMetadata(e);var m={itemLabel:c.itemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL"),index:e,total:v.length,properties:Object.keys(c.template).map(function(k){var t=c.template[k];var P=e+"/"+t.path;var g=O.get(P.split("/"),v);if(typeof g==="undefined"){O.set(t.path.split('/'),d(t.defaultValue),o);}return _({},t,{path:P,value:g,designtime:(D||{})[k]});},this)};var p=new J(o);m.properties=r(m.properties,{"":p},{"":p.getContext("/")},["template","value","itemLabel"]);m.itemLabel=r({itemLabel:m.itemLabel},{"":p},{"":p.getContext("/")}).itemLabel||f(this.getI18nProperty("BASE_EDITOR.ARRAY.NEW_ITEM_LABEL"),[c.addItemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL")]);p.destroy();I.push(m);},this);this._itemsModel.setData(I);};
A.prototype.onBeforeConfigChange=function(c){if(!c.collapsibleItems){this.setFragment("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditorPlain");}return c;};
A.prototype.getExpectedWrapperCount=function(v){return v.length;};
A.prototype._removeItem=function(e){var I=e.getSource().data("index");var v=(this.getValue()||[]).slice();v.splice(I,1);this.setValue(v);};
A.prototype._addItem=function(){var c=this.getConfig();var v=(this.getValue()||[]).slice();var D={};Object.keys(c.template).forEach(function(k){var p=c.template[k];if(p.type==="array"){D[k]=[];}});v.push(D);this.setValue(v);};
A.prototype._moveUp=function(e){var I=e.getSource().data("index");if(I>0){var v=this.getValue().slice();var R=v.splice(I,1)[0];v.splice(I-1,0,R);this.setValue(v);}};
A.prototype._moveDown=function(e){var I=e.getSource().data("index");var v=this.getValue().slice();if(I<v.length-1){var R=v.splice(I,1)[0];v.splice(I+1,0,R);this.setValue(v);}};
A.prototype._propertyEditorsChange=function(e){e.getParameter("previousPropertyEditors").forEach(function(p){p.detachValueChange(this._onPropertyValueChange,this);p.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);e.getParameter("propertyEditors").forEach(function(p){p.attachValueChange(this._onPropertyValueChange,this);p.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);};
A.prototype._onPropertyValueChange=function(e){var p=e.getSource();var E=d(this.getValue()||[]);var P=e.getParameter("path");var c=P.split("/");var v=e.getParameter("value");O.set(c,v,E);if(typeof v==="undefined"||a(v,p.getConfig().defaultValue)){u(E,c,c.length-2);}this.setValue(E);};
A.prototype._onDesigntimeMetadataChange=function(e){var n={};O.set(e.getParameter("path").split("/"),e.getParameter("value"),n);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());};
A.prototype._isNewItem=function(m){return(m&&m.properties||[]).every(function(o){var v=o.value;return b(v)||Array.isArray(v)&&v.length===0||i(v);});};
A.prototype.formatAddItemText=function(s,I,F){return f(s,[I||F]);};
return A;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isBoolean:{type:"isBoolean"}});};
a.prototype._onChange=function(){var c=this.getContent();var v=c.getSelectedKey()||c.getValue();if(v==="false"){v=false;}else if(v==="true"){v=true;}this.setValue(v);};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.BOOLEAN"}});return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/format/DateFormat"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isDate:{type:"isDate",config:{formatterInstance:function(){var d=(this.getConfig()||{}).pattern;var c=d?{pattern:d}:undefined;return this.getFormatterInstance(c);}.bind(this)}}});};
a.prototype.formatValue=function(v){var d=this._parse(v);return this._format(d,true)||v;};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.DATE"},pattern:{defaultValue:"YYYY-MM-dd'T'HH:mm:ss.SSS'Z'"},utc:{defaultValue:false}});
a.prototype.onFragmentReady=function(){var d=this.getContent();d.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}};};
a.prototype._onChange=function(e){var v=e.getParameter("newValue");var d=this._parse(v,true);var s=this._format(d)||v;this.setValue(s);};
a.prototype._parse=function(v,u){if(v==null||v===""){return v;}var U=(this.getConfig()||{}).utc!==false;if(u){return this.getFormatterInstance().parse(v,U);}var d=(this.getConfig()||{}).pattern;if(d){var o=this.getFormatterInstance({pattern:d});return o.parse(v,U);}return undefined;};
a.prototype._format=function(d,u){if(!this._isValidDate(d)){return undefined;}var U=(this.getConfig()||{}).utc!==false;if(u){return this.getFormatterInstance().format(d,U);}var s=(this.getConfig()||{}).pattern;if(s){var o=this.getFormatterInstance({pattern:s});return o.format(d,U);}return undefined;};
a.prototype._isValidDate=function(d){return d&&!isNaN(d.getTime());};
a.prototype.getFormatterInstance=function(o){return D.getDateInstance(o||{pattern:"YYYY-MM-dd"});};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(B,D,a){"use strict";
var b=D.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
b.prototype.getFormatterInstance=function(o){return a.getDateTimeInstance(o||{pattern:"YYYY-MM-dd'T'HH:mm:ss.SSSSZ"});};
b.configMetadata=Object.assign({},D.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.DATETIME"},utc:{defaultValue:true}});return b;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var E=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",{
metadata:{library:"sap.ui.integration",deprecated:true},
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",
renderer:B.getMetadata().getRenderer().render
});
E.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
E.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().enum;}},isEnabled:!c.allowCustomValues}});};
E.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
return E;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/groupEditor/GroupEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var G=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.groupEditor.GroupEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.groupEditor.GroupEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
G.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.GROUP"}});
G.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
return G;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/ListItem","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/core/IconPool","sap/ui/base/BindingParser","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","./IsInIconPool.validator"],function(B,L,F,J,a,b,I,c,i,d){"use strict";var o=null;
var e=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
e.configMetadata=Object.assign({},B.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.SIMPLEICON"}});
e.prototype.onFragmentReady=function(){var f=this.getContent();this._oIconModel=this._getIconModel();f.setModel(this._oIconModel,"icons");f.bindAggregation("suggestionItems","icons>/",new L({text:"{icons>path}",additionalText:"{icons>name}"}));};
e.prototype._getIconModel=function(){if(!o){o=new J(I.getIconNames().map(function(n){return{name:n,path:"sap-icon://"+n};}));}return o;};
e.prototype._onChange=function(E){var s=E.getParameter("value");this.setValue(s);};
e.prototype._onSuggestionItemSelected=function(E){this.setValue(E.getParameter("selectedItem").getText());};
e.prototype._getDefaultSearchValue=function(s){try{var p=c.complexParser(s);return p?"":s;}catch(E){return s;}};
e.prototype._handleValueHelp=function(E){var v=E.getSource().getValue();if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditorDialog",controller:this}).then(function(D){this._oDialog=D;this.addDependent(this._oDialog);this._oDialog.setModel(this._oIconModel);this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return this._oDialog;}.bind(this));}else{this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return Promise.resolve(this._oDialog);}};
e.prototype.handleSearch=function(E){var v=E.getParameter("value");this._filter(v);};
e.prototype._filter=function(v){var f=new a("path",b.Contains,v);var g=this._oDialog.getBinding("items");g.filter([f]);};
e.prototype.handleClose=function(E){var s=E.getParameter("selectedItem");if(s){this.setValue(s.getIcon());}E.getSource().getBinding("items").filter([]);};
e.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding"},isInIconPool:{type:"isInIconPool"}});};
e.prototype.getDefaultValidatorModules=function(){return Object.assign({},B.prototype.getDefaultValidatorModules.apply(this,arguments),{isInIconPool:d});};
return e;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IsInIconPool.validator',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil","sap/ui/core/IconPool"],function(I,_,a){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_ICON",validate:function(v){return _(v)||(typeof v==="string"&&a.isIconURI(v)&&!!a.getIconInfo(v))||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","sap/ui/core/format/NumberFormat"],function(B,N,a){"use strict";
var I=N.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.integerEditor.IntegerEditor",{
invalidInputError:"BASE_EDITOR.INTEGER.INVALID_BINDING_OR_INTEGER",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
I.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isInteger:{type:"isInteger"}});};
I.configMetadata=Object.assign({},N.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.INTEGER"}});
I.prototype.validateNumber=function(v){return N.prototype.validateNumber.call(this,v)&&Number.isInteger(v);};
I.prototype.getFormatterInstance=function(){return a.getIntegerInstance();};
return I;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment"],function(B,F){"use strict";
var J=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",
metadata:{library:"sap.ui.integration"},
_onLiveChange:function(){var i=this.getContent();var j=this._parseJson(i.getValue());if(j instanceof Error){this.setHasOwnError(true);i.setValueState("Error");i.setValueStateText("Error: "+j);}else{i.setValueState("None");this.setValue(j);}},
_parseJson:function(j){try{var p=JSON.parse(j);return p;}catch(e){return e;}},
_openJsonEditor:function(){if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditorDialog",controller:this}).then(function(d){this._oDialog=d;this._oErrorMsg=this._oDialog.getContent()[0];this._oEditor=this._oDialog.getContent()[1];this._oEditor.getInternalEditorInstance().getSession().on("changeAnnotation",this.onShowError.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor.getInternalEditorInstance().focus();this._oEditor.getInternalEditorInstance().navigateFileEnd();},this);this._oDialog.attachAfterClose(function(){this._oDialog.close();this._oDialog.destroy();this._oDialog=null;},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog;}.bind(this));}else{this._openDialog();return Promise.resolve(this._oDialog);}},
_openDialog:function(){var i=this.getContent().getValue();try{var c=JSON.stringify(JSON.parse(i),0,"\t");this._oEditor.setValue(c);}catch(e){this._oEditor.setValue(i);}this._oDialog.open();},
onClose:function(){this._oCode=null;this._oDialog.close();},
onBeautify:function(){try{var b=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(b);}catch(e){}},
onLiveChange:function(e){try{this._oCode=JSON.parse(e.getParameter("value"));this._oDialog.getBeginButton().setEnabled(true);}catch(a){this._oDialog.getBeginButton().setEnabled(false);}},
onShowError:function(){var e=(this._oEditor.getInternalEditorInstance().getSession().getAnnotations()||[]).map(function(E){return"Line "+String(E.row)+": "+E.text;}).join("\n");this._oErrorMsg.setText(e);this._oErrorMsg.setVisible(!!e);},
onSave:function(){var i=this.getContent();if(this._oCode){this.setValue(this._oCode);i.setValueState("None");i.setValue(JSON.stringify(this._oCode));}this._oDialog.close();},
renderer:B.getMetadata().getRenderer().render
});
J.configMetadata=Object.assign({},B.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.JSON"}});return J;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(B,I){"use strict";
var L=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
L.prototype.onFragmentReady=function(){this.attachValueChange(function(){this.getContent().setValue("");}.bind(this));};
L.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isUniqueList:{type:"isUniqueList"},isStringList:{type:"isStringList"}});};
L.configMetadata=Object.assign({},B.configMetadata);
L.prototype._onTokenUpdate=function(e){this._setTokens(e.getParameter("addedTokens").map(function(t){return t.getText();}),e.getParameter("removedTokens").map(function(t){return t.getText();}));};
L.prototype._onTokenSubmission=function(e){this._setTokens([e.getParameter("value")],[]);};
L.prototype._onLiveChange=function(e){var v=e.getParameter("newValue");this._validateInput(v);};
L.prototype._setTokens=function(a,r){var v=(this.getValue()||[]).filter(function(t){return r.indexOf(t)<0;});var n=v.concat(a);this.setValue(n);};
L.prototype._validateInput=function(t){this.setInputState(!I.validate(t),this.getI18nProperty(I.errorMessage));};
return L;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/isPlainObject","sap/base/util/includes","sap/base/strings/formatMessage"],function(B,P,d,c,J,_,e,i,f,g){"use strict";
var M=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",
metadata:{library:"sap.ui.integration"},
init:function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");this._supportedTypesModel=new J([]);this._supportedTypesModel.setDefaultBindingMode("OneWay");this.setModel(this._supportedTypesModel,"supportedTypes");this.attachModelContextChange(function(){if(this.getModel("i18n")){this._setSupportedTypesModel();}},this);this.attachConfigChange(this._setSupportedTypesModel,this);this._mTypes={};},
setValue:function(v){v=i(v)?v:{};var p=this._getPositions(v);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),Object.keys(p).reduce(function(n,k){n[k]={__value:{position:p[k]}};return n;},{})));B.prototype.setValue.call(this,v);var I=this._processValue(v);I=I.sort(function(V,o){return p[V.key]-p[o.key];}).map(function(o,a){o.index=a;o.total=I.length;return o;});this._itemsModel.setData(I);},
_processValue:function(v){return Object.keys(v).map(function(k){var F=this._prepareInputValue(v[k],k);this._mTypes[k]=F.type;var I={key:k,value:F,designtime:this.getNestedDesigntimeMetadata(k)};return this.getConfig().includeInvalidEntries||this._isValidItem(I,d(v[k]))?I:undefined;},this).filter(Boolean);},
_getPositions:function(v){var k=Object.keys(v);var E=k.map(function(K){var a=this.getNestedDesigntimeMetadataValue(K).position;return a>=0?a:-1;}.bind(this));var n=E.reduce(function(a,b){return Math.max(a,b);},-1);var p={};E.forEach(function(a,b){p[k[b]]=a>=0?a:++n;});return p;},
_prepareInputValue:function(v,k){var F=this.processInputValue(d(v),k);if(!F.type){F.type=this._mTypes[k]||this._getDesigntimeMetadataValue(k).type||this._getDefaultType(F.value);}return F;},
_getDesigntimeMetadataValue:function(k){var D=(this.getConfig()||{}).designtime||{};var o=D[k]||{};return o.__value||{};},
_isValidItem:function(I){var t=I.value.type;return t&&f(this._getAllowedTypes(),t);},
_getDefaultType:function(v){var D=this.getConfig().defaultType;if(D){return D;}var a=this._getAllowedTypes();var t=typeof v;var C=f(a,t)?t:undefined;if(!C&&f(a,"string")){C="string";}return C;},
_getAllowedTypes:function(){var C=this.getConfig();return((C&&C.allowedTypes)||M.configMetadata.allowedTypes.defaultValue);},
_setSupportedTypesModel:function(){var a=this._getAllowedTypes();var r=P.getTypes();Promise.all(a.map(function(t){return(r[t]||Promise.resolve(B)).then(function(E){return{key:t,editor:E};});})).then(function(E){var I=E.map(function(o){var l=o.editor.configMetadata.typeLabel.defaultValue;return{key:o.key,title:this.getI18nProperty(l)};}.bind(this));this._supportedTypesModel.setData(I);}.bind(this));},
formatItemConfig:function(C){var k=C.key;var t=C.value.type;var v=C.value.value;if(t==="boolean"){v=C.value.value!==false;}var D=(C.designtime||{}).__value;var o=this.getConfig();return[{label:this.getI18nProperty("BASE_EDITOR.MAP.KEY"),path:"key",value:k,type:"string",enabled:o.allowKeyChange,itemKey:k,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}]},{label:this.getI18nProperty("BASE_EDITOR.MAP.TYPE"),path:"type",value:t,type:"select",items:this._supportedTypesModel.getData(),visible:o.allowTypeChange,itemKey:k,allowBindings:false},{label:this.getI18nProperty("BASE_EDITOR.MAP.VALUE"),path:"value",value:v,type:t&&f(this._getAllowedTypes(),t)?t:this._getDefaultType(v),visible:t!=="group"&&t!=="separator",itemKey:k,designtime:(D||{}).value}];},
getExpectedWrapperCount:function(v){return this._processValue(v).length;},
processInputValue:function(v){return{value:v};},
processOutputValue:function(v){return v.value;},
_onRemoveElement:function(E){var k=E.getSource().getBindingContext("itemsModel").getObject().key;var v=this.getValue();this.setValue(e(v,k));var n=d(this.getDesigntimeMetadata());delete n[k];this.setDesigntimeMetadata(n);},
_onAddElement:function(){var p=_({},this.getValue());var k=this._getUniqueKey(p);p[k]=this.processOutputValue(this._getItemTemplate());this.setValue(p);},
_moveUp:function(E){var I=E.getSource().data("index");if(I>0){var v=this._itemsModel.getData();this._swapPositions(v[I].key,v[I-1].key);}},
_moveDown:function(E){var I=E.getSource().data("index");var v=this._itemsModel.getData();if(I<v.length-1){this._swapPositions(v[I].key,v[I+1].key);}},
_swapPositions:function(k,K){var n={};n[k]={__value:{position:this.getNestedDesigntimeMetadataValue(K).position}};n[K]={__value:{position:this.getNestedDesigntimeMetadataValue(k).position}};this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());},
_getItemTemplate:function(){return{value:"",type:"string"};},
_isNewItem:function(I){return c(I.value,this._prepareInputValue(this.processOutputValue(this._getItemTemplate())));},
_getUniqueKey:function(p){var k="key";var I=0;while(p.hasOwnProperty(k)){k="key"+ ++I;}return k;},
_propertyEditorsChange:function(E){var p=E.getParameter("previousPropertyEditors");var a=E.getParameter("propertyEditors");if(Array.isArray(p)){p.forEach(function(o){o.detachValueChange(this._onItemChange,this);o.detachDesigntimeMetadataChange(this._onDesigntimeValueChange,this);},this);}if(Array.isArray(a)){a.forEach(function(o){o.attachValueChange(this._onItemChange,this);o.attachDesigntimeMetadataChange(this._onDesigntimeValueChange,this);},this);}},
_onItemChange:function(E){var k=E.getSource().getConfig().itemKey;var C=E.getParameter("path");var h=this.getItemChangeHandlers()[C];if(typeof h!=='function'){h=this._onFieldChange;}h.call(this,k,E);},
_onDesigntimeValueChange:function(E){var k=E.getSource().getConfig().itemKey;var C=E.getParameter("path");if(C!=="value"){return;}this._onDesigntimeChange(k,E);},
_onDesigntimeChange:function(k,E){var D=_({},this.getConfig().designtime);var n={__value:{}};n.__value[E.getParameter("path")]=E.getParameter("value");D[k]=_({},D[k],n);this.setDesigntimeMetadata(D);this.setValue(this.getValue());},
getItemChangeHandlers:function(){return{"key":this._onKeyChange,"type":this._onTypeChange};},
_onKeyChange:function(o,E){if(E.getParameter("previousValue")===undefined){return;}var a=_({},this.getValue());var n=E.getParameter("value");if(n!==o){var N={};Object.keys(a).forEach(function(I){var s=I===o?n:I;N[s]=a[I];});if(N[n]&&N[n].type!=="group"&&N[n].type!=="separator"&&N[n].manifestpath&&N[n].manifestpath.startsWith("/sap.card/configuration/parameters/")){N[n].manifestpath="/sap.card/configuration/parameters/"+n+"/value";}this._mTypes[n]=this._mTypes[o];delete this._mTypes[o];this.setValue(N);var D=_({},this.getConfig().designtime);if(D.hasOwnProperty(o)){D[n]=D[o];if(D[n].__value&&D[n].__value.type&&D[n].__value.type!=="group"&&D[n].__value.type!=="separator"&&D[n].__value.manifestpath){D[n].__value.manifestpath=D[n].__value.manifestpath.replace(o,n);}delete D[o];this.setDesigntimeMetadata(D);}}},
_onTypeChange:function(k,E){if(E.getParameter("previousValue")===undefined){return;}var o=_({},this.getValue());var n=E.getParameter("value");var O=E.getParameter("previousValue");if(n!==O){var I=this.processInputValue(o[k]);I.type=n;o[k]=this.processOutputValue(I);if(n==="simpleicon"){o[k].visualization={"type":"IconSelect","settings":{"value":"{currentSettings>value}","editable":"{currentSettings>editable}"}};}else{delete o[k].visualization;}if(n!=="array"&&n!=="string"){delete o[k].values;}this._mTypes[k]=n;this.setValue(o);var D=_({},this.getConfig().designtime);if(D.hasOwnProperty(k)){if(n==="simpleicon"){D[k].__value.visualization={"type":"IconSelect","settings":{"value":"{currentSettings>value}","editable":"{currentSettings>editable}"}};}else{delete D[k].__value.visualization;}if(n!=="array"&&n!=="string"){delete D[k].__value.values;}D[k].__value.type=n;this.setDesigntimeMetadata(D);}}},
_onFieldChange:function(k,E){var o=_({},this.getValue());var p=E.getParameter("path");var v=E.getParameter("value");var I=this.processInputValue(o[k]);I[p]=v;o[k]=this.processOutputValue(I);this.setValue(o);},
formatAddItemText:function(a,I){var s=this.getI18nProperty(I);return g(a,[s]);},
renderer:B.getMetadata().getRenderer().render
});
M.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowTypeChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowedTypes:{defaultValue:["string"],mergeStrategy:"intersection"},defaultType:{defaultValue:null},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},includeInvalidEntries:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},addItemLabelI18n:{defaultValue:"BASE_EDITOR.MAP.DEFAULT_TYPE"}});return M;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/multiSelectEditor/MultiSelectEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var M=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.multiSelectEditor.MultiSelectEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.multiSelectEditor.MultiSelectEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
M.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
M.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().items.map(function(I){return I.key;});}},isEnabled:!c.allowCustomValues}});};
M.prototype._onSelectionFinish=function(e){var s=e.getParameter("selectedItems");s=s.map(function(S){return S.getKey();});this.setValue(s);};
return M;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/base/util/restricted/_isNil","sap/ui/core/format/NumberFormat"],function(B,i,_,N){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",
metadata:{library:"sap.ui.integration"},
invalidInputError:"BASE_EDITOR.NUMBER.INVALID_BINDING_OR_NUMBER",
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isNumber:{type:"isNumber"}});};
a.configMetadata=Object.assign({},B.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.NUMBER"}});
a.prototype.formatValue=function(v){if(_(v)||i(v,false)){return v;}var n=parseFloat(v);if(!this.validateNumber(n)){return v;}return this.getFormatterInstance().format(n);};
a.prototype._onLiveChange=function(e){var n=this._parseLocalized(e.getParameter("newValue"));B.prototype.setValue.call(this,n);};
a.prototype.validateNumber=function(v){return!isNaN(v);};
a.prototype.getFormatterInstance=function(){return N.getFloatInstance();};
a.prototype._parseLocalized=function(v){if(!v||i(v,false)){return v;}var n=this.getFormatterInstance().parse(v);return n;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().items.map(function(I){return I.key;});}},isEnabled:!c.allowCustomValues}});};
S.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
S.prototype._getItemTitle=function(v){var I=this.getConfig()&&this.getConfig().items||[];var s=I.find(function(o){return o.key===v;});return(s||{}).title||v;};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/separatorEditor/SeparatorEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.separatorEditor.SeparatorEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.separatorEditor.SeparatorEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.SEPARATOR"}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.STRING"},enabled:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
S.prototype.setValue=function(v){if(!_(v)&&!i(v)){arguments[0]=v.toString();}B.prototype.setValue.apply(this,arguments);};
S.prototype._onLiveChange=function(){var I=this.getContent();this.setValue(I.getValue());};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/textAreaEditor/TextAreaEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var T=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.textAreaEditor.TextAreaEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.textAreaEditor.TextAreaEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
T.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
T.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
T.prototype.formatValue=function(v){v=JSON.stringify(v,null,"\t");if(typeof v==="object"&&!v.length){v=v.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(s){return s.substring(3,s.length-3);});}return v;};
T.prototype._onLiveChange=function(){var t=this.getContent();var v=t.getValue();if(!v||v===""){this.setValue(V);}else{try{var V=JSON.parse(v);this.setValue(V);}catch(e){t.setValueState("Error");t.setValueStateText(this.getI18nProperty("BASE_EDITOR.VALIDATOR.NOT_A_JSONOBJECT"));}}};
return T;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules',["sap/ui/integration/designtime/baseEditor/validator/NotABinding","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey","sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey","sap/ui/integration/designtime/baseEditor/validator/IsNumber","sap/ui/integration/designtime/baseEditor/validator/IsInteger","sap/ui/integration/designtime/baseEditor/validator/IsBoolean","sap/ui/integration/designtime/baseEditor/validator/IsDate","sap/ui/integration/designtime/baseEditor/validator/IsStringList","sap/ui/integration/designtime/baseEditor/validator/IsUniqueList","sap/ui/integration/designtime/baseEditor/validator/MaxLength","sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(N,I,a,b,c,d,e,f,g,h,M,i){"use strict";return{"notABinding":N,"isValidBinding":I,"isSelectedKey":a,"isUniqueKey":b,"isNumber":c,"isInteger":d,"isBoolean":e,"isDate":f,"isUniqueList":h,"isStringList":g,"maxLength":M,"pattern":i};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/StylesheetManager',["sap/ui/dom/includeStylesheet","sap/base/util/uid"],function(i,u){"use strict";var S="SUCCESS";var a="FAIL";var b="PENDING";var s={};
function l(F){var C={id:u(),status:b,counter:1};var p=new Promise(function(r,R){i(F,C.id,r,R);}).then(function(){var C=s[F];if(C.counter===0){d(F);}else{f(F,S);}}).catch(function(){f(F,a);return Promise.reject("File not found or some other network issue happened.");});C.promise=p;s=Object.assign({},s);s[F]=C;return C.promise;}
function d(F){var m=Object.assign({},s);var C=m[F];var E=document.getElementById(C.id);if(E&&E.parentNode){E.parentNode.removeChild(E);}delete m[F];s=m;}
function c(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter++;s=Object.assign({},s,D);return s[F];}
function e(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter--;s=Object.assign({},s,D);return s[F];}
function f(F,h){var D={};D[F]=Object.assign({},s[F]);D[F].status=h;s=Object.assign({},s,D);return s[F];}
function g(m){return sap.ui.require.toUrl(m)+".css";}
return{add:function(m){var F=g(m);var h=s[F];if(h){c(F);return h.promise;}return l(F);},remove:function(m){var F=g(m);var C=s[F];if(C){var U=e(F);if(U.counter===0&&U.status===S){d(F);}}}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding',["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/includes","sap/base/util/deepEqual"],function(M,d,O,i,B,a,b){"use strict";
var c=M.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{
metadata:{library:"sap.ui.integration",properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},
_originalObject:null
});
c.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={};};
c.prototype.exit=function(){this._cleanup();};
c.prototype.setObject=function(o){this._setOriginalObject(o);this._init();return this;};
c.prototype._setObject=function(o){var C=d(o,50);return this.setProperty("object",C);};
c.prototype._setOriginalObject=function(o){this._originalObject=d(o,50);};
c.prototype._getOriginalObject=function(){return this._originalObject;};
c.prototype.setModel=function(m,n){var e=false;var E=Object.keys(this.oModels||{}).find(function(s){if(this.oModels[s]===m){e=true;return true;}return false;}.bind(this));this._oModelMap[n]=e?this._oModelMap[E]:n;var r=M.prototype.setModel.apply(this,arguments);this._init();return r;};
c.prototype.setBindingContext=function(){var r=M.prototype.setBindingContext.apply(this,arguments);this._init();return r;};
c.prototype._init=function(){this._cleanup();var o=this._getOriginalObject();if(o){this._setObject(o);this._createPropertyBindings(o);}};
c.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(k){var o=this._mSimpleBindings[k].binding;o.getModel().removeBinding(o);o.destroy();}.bind(this));}this._mSimpleBindings={};};
c.prototype._createPropertyBindings=function(o,p){Object.keys(o).filter(function(k){return!this.isIgnored(k);},this).forEach(function(k){var C=p?p+"/"+k:k;if(typeof o[k]==="string"){var e=B.complexParser(o[k]);if(e){if(e.parts){if(!e.parts.find(function(P){return!this.getModel(P.model);}.bind(this))){e.parts.forEach(function(P){this._createSimpleBinding(P,C,e);}.bind(this));}else{return;}}else if(this.getModel(e.model)){this._createSimpleBinding(e,C,e);}else{return;}this._updateValue([{path:C,bindingInfo:e}]);}}else if(o[k]&&(i(o[k])||Array.isArray(o[k]))){this._createPropertyBindings(o[k],C);}},this);};
c.prototype._updateValue=function(v){var C=[];v.forEach(function(u){var o=this.getObject();var p=u.path.split("/");var k=p.pop();if(p.length){o=O.get(p,o);}this.bindProperty("_value",d(u.bindingInfo));var V=d(this.getProperty("_value"));this.unbindProperty("_value");if(V!==o[k]&&(k!=="value"||!(o.value===undefined&&b(V,o.defaultValue)))){o[k]=V;C.push({path:u.path,value:V});}}.bind(this));if(C.length){this.fireChange({changes:C});}};
c.prototype._createSimpleBinding=function(s,C,o){var e=this.getBindingContext(s.model);var m=this._oModelMap[s.model];var f=this.oModels[s.model];var A=f.resolve(s.path,e);var h=m+">"+A;var g=this._mSimpleBindings[h];if(!g){g=this.getModel(s.model).bindProperty(s.path,e);this._mSimpleBindings[h]={binding:g,properties:[]};g.attachChange(function(){this._updateValue(this._mSimpleBindings[h].properties);}.bind(this));}this._mSimpleBindings[h].properties.push({path:C,bindingInfo:o});return g;};
c.prototype.addToIgnore=function(k){this._aIgnoreList=this._aIgnoreList.concat(k);this._init();};
c.prototype.removeFromIgnore=function(k){this._aIgnoreList=this._aIgnoreList.filter(function(I){return I!==k;});this._init();};
c.prototype.isIgnored=function(k){return a(this._aIgnoreList,k);};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding',["sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding"],function(O){"use strict";return function(j,m,c,i){var o=new O();c=c||{};i=i||[];i.forEach(function(p){o.addToIgnore(p);});Object.keys(m).forEach(function(k){o.setModel(m[k],k===""?undefined:k);});Object.keys(c).forEach(function(k){o.setBindingContext(c[k],k===""?undefined:k);});o.setObject(j);var r=o.getObject();o.destroy();return r;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata',["sap/base/util/restricted/_isNil","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(_,e,i,a){"use strict";
function c(o){e(o,function(k,v){if(i(v)){c(v);}if(_(v)||Array.isArray(v)&&v.length===0||i(v)&&a(v)){delete o[k];}});}
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/createPromise',function(){"use strict";return function(f){var c=false;var C;var a;var b;var p=new Promise(function(r,R){f(function(){if(!c){r.apply(this,arguments);}else if(a){a.apply(this,arguments);}},function(){if(!c){R.apply(this,arguments);}else if(b){b.apply(this,arguments);}});});return{promise:p,cancel:function(){c=true;if(!C){C=new Promise(function(r,R){a=r;b=R;});}return C;}};};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/escapeParameter',["sap/base/util/isPlainObject","sap/base/util/each"],function(i,e){"use strict";return function(a,v){v=v||function(){return true;};var A=Array.from(a);var s=typeof A[0]!=="string"&&A[0]!==undefined?0:1;if(i(A[s])){var S=Object.assign({},A[s]);e(S,function(k,V){if(i(V)&&v(V,k)){S[k]=Object.assign({},V,{ui5object:true});}});A[s]=S;}return A;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/findClosestInstance',function(){"use strict";return function(c,C){function f(c){if(c){if(c.isA(C)){return c;}else{return f(c.getParent());}}}return f(c);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/hasTag',["sap/base/util/restricted/_intersection"],function(_){"use strict";return function h(c,t){var T=[].concat(t);return(Array.isArray(c.tags)&&_(T,c.tags).length===T.length);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isTemplate',function(){"use strict";
function i(c,a){var p=c.sParentAggregationName;var P=c.getParent();if(a&&P===a){return false;}if(P&&p){var b=P.getBindingInfo(p);if(b&&c instanceof b.template.getMetadata().getClass()){return false;}else{return i(P,a);}}return true;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isValidBindingString',["sap/ui/base/BindingParser"],function(B){"use strict";
function i(I,a){var p;try{var e=I.replace(/{{([^{]*)}}/g,function(f,s){if(i(s)){return"${}";}throw"Invalid binding string";});p=B.complexParser(e);}catch(E){return false;}return a!==false?true:!!p;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/unset',["sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(O,i,a){"use strict";
function u(o,p,m){var c=p.slice(0,-1);var C=c.length>0?O.get(c,o):o;var k=p[p.length-1];if(Array.isArray(C)){C.splice(k,1);}else{delete C[k];}return(c.length>0&&!(m<=0)&&((Array.isArray(C)&&C.length===0)||(i(C)&&a(C)))?u(o,c,m?m-1:undefined):o);}
return u;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsBoolean',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_BOOLEAN",validate:function(v){return _(v)||typeof v==="boolean"||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsDate',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_DATE",validate:function(d,c){var f=c.formatterInstance;var D=(f&&f.parse(d))||new Date(d);return d===undefined||I.validate(d,{allowPlainStrings:false})||(D&&!isNaN(new Date(D).getTime()));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsInteger',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_INTEGER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||(!isNaN(v)&&Number.isInteger(v));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsNumber',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_NUMBER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||!isNaN(v);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){var m=c.modifiers||"";var r=new RegExp(c.pattern,m);var e=c.exactMatch!==false;if(v===undefined){return true;}var i;if(e){var M=v.match(r);i=M&&v===M[0];}else{i=r.test(v);}return i||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_CUSTOM_VALUE",validate:function(v,c){if(Array.isArray(v)){var a=true;if(v.length>0){for(var i=0;i<v.length;i++){if(!(v[i]===undefined||(c.keys||[]).includes(v[i])||I.validate(v[i],{allowPlainStrings:false}))){a=false;break;}}}return a;}else{return v===undefined||(c.keys||[]).includes(v)||I.validate(v,{allowPlainStrings:false});}}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsStringList',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:I.errorMessage,validate:function(v){return v===undefined||v.every(function(i){return I.validate(i);});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey',["sap/base/util/includes"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_KEY",validate:function(v,c){return(c.currentKey===undefined||!i(c.keys,v)||v===undefined||v===c.currentKey);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueList',["sap/base/util/restricted/_uniq"],function(_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_ENTRY",validate:function(v){return v===undefined||v.length===_(v).length;}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsValidBinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_BINDING",validate:function(v,c){var a=(c||{}).allowPlainStrings!==false;return v===undefined||v===""||i(v.toString(),a);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/MaxLength',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:{message:"BASE_EDITOR.VALIDATOR.MAX_LENGTH",placeholders:function(c){return[c.maxLength];}},validate:function(v,c){return _(v)||(typeof v==="string"&&v.length<=c.maxLength)||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/NotABinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_BINDING",validate:function(v){return!i(v,false);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry',["sap/base/util/includes","sap/base/util/values","sap/base/util/restricted/_CancelablePromise"],function(i,v,_){"use strict";var V={};var o={};var l={};
V.registerValidators=function(n){Object.keys(n).forEach(function(N){if(!this.hasValidator(N)){l[N]=new _(function(r,a,b){b(function(){delete l[N];});b.shouldReject=false;sap.ui.require([n[N]],r,a);});l[N].then(function(a){o[N]=a;delete l[N];});}}.bind(this));};
V.ready=function(){return Promise.all(v(l));};
V.deregisterValidator=function(n){if(o[n]){delete o[n];}if(l[n]){l[n].cancel();}};
V.deregisterAllValidators=function(){Object.keys(l).forEach(function(n){this.deregisterValidator(n);}.bind(this));o={};};
V.getValidator=function(n){var a=o[n];if(!a){throw new Error("Validator "+n+" was not registered.");}return a;};
V.hasValidator=function(n){return i(Object.keys(o),n);};
V.isRegistered=function(n){return i(Object.keys(l),n);};
return V;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/BASEditor',["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","./CardEditor","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/Designtime","sap/ui/integration/util/CardMerger","sap/base/util/LoaderExtensions","sap/base/Log"],function(C,_,a,m,d,b,O,c,B,D,e,L,f){"use strict";var g="";g=L.loadResource("sap/ui/integration/designtime/cardEditor/ConfigurationTemplate.js",{dataType:"text",failOnError:false,async:false});
var h=c.extend("sap.ui.integration.designtime.cardEditor.BASEditor",{
metadata:{library:"sap.ui.integration",events:{configurationChange:{},createConfiguration:{},error:{},designtimeInited:{}}},
renderer:c.getMetadata().getRenderer()
});
h.prototype.getManifest=function(){return this._oCurrent.manifest;};
h.prototype.getConfigurationClass=function(){return this._oCurrent.configurationclass;};
h.prototype.getConfiguration=function(){return this._oCurrent.configuration;};
h.prototype.getConfigurationString=function(){return this._oCurrent.configurationstring;};
h.prototype._generateDesigntimeJSConfig=function(){var M=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());var J=this.getJson();if(this._eventTimeout){clearTimeout(this._eventTimeout);this._eventTimeout=null;}this._eventTimeout=setTimeout(function(){var E={form:{items:{}}};var l=m(E,this._oDesigntimeJSConfig);var N={};var I=[];var p;if(!O.get(["sap.card","configuration"],J)){O.set(["sap.card","configuration"],{"parameters":{}},J);}else if(!O.get(["sap.card","configuration","parameters"],J)){O.set(["sap.card","configuration","parameters"],{},J);}var P=O.get(["sap.card","configuration","parameters"],J);if(J){var q=O.get(["sap.card","configuration","parameters"],this._oDesigntimeMetadataModel.getData());if(b(P,{})&&!q){this._oDesigntimeJSConfig.form.items={};this._oCurrent={configuration:this._cleanConfig(this._oDesigntimeJSConfig),manifest:this._cleanJson(),configurationclass:this._fnDesigntime,configurationstring:this._cleanConfig(this._oDesigntimeJSConfig,true)};this.fireConfigurationChange(this._oCurrent);return;}var r=Object.keys(P);for(var n in l.form.items){p=m({},l.form.items[n]);if(!P[n]){if(q[n]){if(p.type==="group"||p.type==="separater"){P[n]={};}else if(p.manifestpath&&!p.manifestpath.startsWith("/sap.card/configuration/parameters")){var s=p.manifestpath;if(s.startsWith("/")){s=s.substring(1);}var v=O.get(s.split("/"),J)||"";P[n]={value:v};}}else{delete l.form.items[n];continue;}}else if(p.manifestpath&&!p.manifestpath.startsWith("/sap.card/configuration/parameters")){var s=p.manifestpath;if(s.startsWith("/")){s=s.substring(1);}var u=s.split("/");var v=O.get(u,J);var w=O.get(u,this._oInitialJson);if(!_(v,w)){P[n].value=v;}else{O.set(u,P[n].value,J);}}var x=r.indexOf(n);if(x>-1){r.splice(x,1);}var V;if(P[n].visualization){V=P[n].visualization;}var y;if(P[n].values){y=P[n].values;}l.form.items[n]=m(p,P[n]);if(!q[n].__value.visualization){delete l.form.items[n].visualization;}else if(V){l.form.items[n].visualization=V;V=null;}if(!q[n].__value.values){delete l.form.items[n].values;}else if(y){l.form.items[n].values=y;y=null;}if(p.type==="group"||p.type==="separator"){delete l.form.items[n].manifestpath;}else if(!l.form.items[n].manifestpath){q[n].manifestpath="/sap.card/configuration/parameters/"+n+"/value";q[n].__value.manifestpath="/sap.card/configuration/parameters/"+n+"/value";l.form.items[n].manifestpath="/sap.card/configuration/parameters/"+n+"/value";}}if(r.length>0){for(var i=0;i<r.length;i++){var z=r[i];var A=P[z];var F="string";if(A.type){F=A.type;}else if(q[z]&&q[z].__value){F=q[z].__value.type;}l.form.items[z]={manifestpath:"/sap.card/configuration/parameters/"+z+"/value",type:F,label:A.label,translatable:false,editable:A.editable,visible:A.visible};}P[z]=m(l.form.items[z],P[z]);}}if(M){if(l){for(var n in M){var G=M[n];var K=n.substring(n.lastIndexOf("/")+1);if(!n.startsWith("sap.card/configuration/parameters")){continue;}var H=l.form.items[K]||{};var V;if(H.visualization){V=H.visualization;}var y;if(H.values){y=H.values;}p=m(H,P[K]);if(G.hasOwnProperty("label")){p.label=G.label;}if(G.hasOwnProperty("position")){p.position=G.position;}if(p.editable==="false"){p.editable=false;}else if(p.editable==="true"){p.editable=false;}if(p.visible==="false"){p.visible=false;}else if(p.visible==="true"){p.visible=false;}if(p.type==="group"||p.type==="separator"){delete p.manifestpath;}if(V){p.visualization=V;V=null;}if(y){p.values=y;y=null;}p.__key=K;I[p.position]=p;}for(var i=0;i<I.length;i++){p=I[i];if(!p){continue;}N[p.__key]=p;delete p.__key;delete p.position;}l.form.items=N;}}this._oDesigntimeJSConfig=l;var Q=this._cleanConfig(this._oDesigntimeJSConfig);this._fnDesigntime=function(o){return new D(o);}.bind(this,Q);this._oCurrent={configuration:Q,manifest:this._cleanJson(J),configurationclass:this._fnDesigntime,configurationstring:this._cleanConfig(this._oDesigntimeJSConfig,true)};this._oDataModel.setData(this._prepareData(J));this.fireConfigurationChange(this._oCurrent);this._oInitialJson=J;}.bind(this),500);};
h.prototype.init=function(){c.prototype.init.apply(this,arguments);this._oCurrent={configuration:null,manifest:null,configurationclass:null};};
h.prototype._applyDefaultValue=function(i){if(i.value===undefined||i.value===null){switch(i.type){case"boolean":i.value=false;break;case"integer":case"number":i.value=0;break;case"string[]":i.value=[];break;default:i.value="";}}};
h.prototype.getJson=function(i){if(i===true){return this._cleanJson();}else{return B.prototype.getJson.apply(this,arguments);}};
h.prototype._cleanJson=function(J,i){J=J||this.getJson();var s=k(O.get(["sap.card","configuration","editor"],J)||"");if(s===""){s=k(O.get(["sap.card","designtime"],J)||"");}if(!s){O.set(["sap.card","designtime"],"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate",J);}J=d(J);var i=i!==false;if(i){var p=O.get(["sap.card","configuration","parameters"],J);for(var n in p){var P=p[n];if(P&&(P.type==="group"||P.type==="separator")){delete p[n];continue;}if(this._oDesigntimeJSConfig&&this._oDesigntimeJSConfig.form&&this._oDesigntimeJSConfig.form.items){var o=this._oDesigntimeJSConfig.form.items[n]||{};if(o.type==="group"||o.type==="separator"){delete p[n];continue;}if(o.manifestpath&&!o.manifestpath.startsWith("/sap.card/configuration/parameters")){var l=o.manifestpath;if(l.startsWith("/")){l=l.substring(1);}if(o.type==="simpleicon"){o.type="string";}if(o.type==="string[]"){o.type="array";}O.set(l.split("/"),o.value,J);delete p[n];continue;}}p[n]={value:p[n].value};}}if(this._i18n){O.set(["sap.app","i18n"],this._i18n,J);}return J;};
h.prototype._cleanConfig=function(o,S){var o=m({},o);for(var n in o.form.items){var i=o.form.items[n];if(i.type==="simpleicon"){if(!i.visualization){i.visualization={"type":"IconSelect","settings":{"value":"{currentSettings>value}","editable":"{currentSettings>editable}"}};}i.type="string";}if(i.type==="array"){i.type="string[]";}if(i.type!=="string[]"&&i.type!="string"){delete i.values;}delete i.value;}if(S){var l=JSON.stringify(o,null,"\t");l=l.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(s){return s.substring(3,s.length-3);});return l;}return o;};
h.prototype._generateMetadataFromJSConfig=function(o){var M={};if(o){this._oDesigntimeJSConfig=m(this._oDesigntimeJSConfig,o);}if(this._oDesigntimeJSConfig){var I=this._oDesigntimeJSConfig.form.items;var i=0;for(var n in I){var p="sap.card/configuration/parameters/"+n,P=p.split("/"),l;M[p]=m({},I[n]);l=M[p];l.position=i++;if(l.visualization){if(l.visualization.type==="IconSelect"){l.type="simpleicon";}}if(l.type==="string[]"){l.type="array";}if(l.manifestpath&&(!l.manifestpath.startsWith("/sap.card/configuration/parameters/")||!O.get(P,this._oInitialJson))){O.set(P,l,this._oInitialJson);}if(!l.hasOwnProperty("type")){this.fireError({"name":"Designtime Error","detail":{"message":"Type of parameter "+n+" not exist"}});}else if(l.type===""){this.fireError({"name":"Designtime Error","detail":{"message":"Type of parameter "+n+" is Invalid"}});}if(l.type!=="group"&&l.type!=="separator"){if(!l.hasOwnProperty("value")){var q=l.manifestpath.substring(1).split("/"),v=O.get(q,this._oInitialJson);if(v!==undefined){l.value=v;}else{this._applyDefaultValue(l);}}else{this._applyDefaultValue(l);}if(O.get(P,this._oInitialJson)){if(O.get(P,this._oInitialJson).value===undefined){O.get(P,this._oInitialJson).value=l.value;}}}}}return M;};
h.prototype.setJson=function(J){if(!this._i18n){this._i18n=O.get(["sap.app","i18n"],J);}B.prototype.setJson.apply(this,arguments);if(!this.__generateDesigntimeJSConfigAttached){this.attachDesigntimeMetadataChange(this._generateDesigntimeJSConfig.bind(this));this.attachJsonChange(this._generateDesigntimeJSConfig.bind(this));this.__generateDesigntimeJSConfigAttached=true;}var J=this.getJson();var s=O.get(["sap.app","id"],J);if(this._bDesigntimeInit&&this._bCardId!==s){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel();}delete this._bCardId;delete this._bDesigntimeInit;}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bCardId=s;var T;var i=k(O.get(["sap.card","configuration","editor"],J)||"");if(i===""){i=k(O.get(["sap.card","designtime"],J)||"");}if(!i){var l=g;O.set(["sap.card","designtime"],"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate",J);T="sap/ui/integration/designtime/cardEditor/ConfigurationTemplate";this.fireCreateConfiguration({file:"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate.js",content:l,manifest:this._cleanJson(J,false)});return;}var n=k(this.getBaseUrl()||""),p={},S=null,q=null,N=null,F=null;if(i&&i.indexOf("cardEditor/ConfigurationTemplate")>0){T=i;q=t(i);N=s.replace(/\./g,"/")+"/"+q;p[N]=q;p[N+"js"]=q.substring(0,q.lastIndexOf("/"));F=q.replace(p[N+"js"]+"/","");}else if(n&&i){S=k(n);q=t(i);var r=S+"/"+q;N=s.replace(/\./g,"/")+"/"+q;p[N]=r;p[N+"js"]=r.substring(0,r.lastIndexOf("/"));F=r.replace(p[N+"js"]+"/","");}if(n&&i){sap.ui.loader.config({paths:p});var u=this;this._oDesigntimePromise=new C(function(R){var U=N+"js"+"/"+F+".js";if(T){U=T+".js";}sap.ui.loader._.loadJSResourceAsync(U).then(function(o){if(!o){u.fireError({"name":"Designtime Error","detail":{"message":"Invalid file format"}});}else if(o){var v=new o();u._oDesigntimeJSConfig=v.getSettings();u._fnDesigntime=o;var M=u._generateMetadataFromJSConfig();o=v.getMetadata().getClass();R(M);}}).catch(function(o){f.error(o);u.fireError({"name":"Designtime Error","detail":o});});});this._oDesigntimePromise.then(function(M){this.setPreventInitialization(false);var o=M;o=e.mergeCardDesigntimeMetadata(o,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=o;this.setDesigntimeMetadata(j(o),true);this._bDesigntimeInit=true;this.fireDesigntimeInited();}.bind(this));}else{this.setPreventInitialization(false);}}};
h.prototype.initialize=function(){if(!this._bDesigntimeInit){this.attachEventOnce("designtimeInited",this.initialize);return;}if(!this._bPreventInitialization){this._initialize();}};
h.prototype.getConfigurationTemplate=function(){return g;};
h.prototype.updateDesigntimeMetadata=function(o,i){var l=this._generateMetadataFromJSConfig(o);this._oInitialDesigntimeMetadata=l;this.setDesigntimeMetadata(j(l),i);};
h.prototype.setDestinations=function(o){if(Array.isArray(o)&&o.length>0){var i=this.getConfig();if(!i.properties){i.properties={destinations:{}};}else if(!i.properties.destinations){i.properties.destinations={};}i.properties.destinations.allowedValues=o;this.setConfig(i);}};
function j(F){var o={};Object.keys(F).forEach(function(p){O.set(p.split("/"),{__value:d(F[p])},o);});return o;}
function k(p){return p.trim().replace(/\/*$/,"");}
function t(p){return p.replace(/^\.\//,"");}
return h;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/CardEditor',["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/restricted/_castArray","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/util/CardMerger","sap/ui/thirdparty/jquery","./config/index"],function(C,_,a,b,d,e,m,c,O,i,B,f,q,D){"use strict";
var g=B.extend("sap.ui.integration.designtime.cardEditor.CardEditor",{
metadata:{library:"sap.ui.integration",properties:{layout:{type:"string",defaultValue:"form"},designtimeChanges:{type:"array",defaultValue:[]},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},"config":{type:"object",defaultValue:{"i18n":[].concat(B.getMetadata().getProperty("config").getDefaultValue().i18n,"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties")}}}},
constructor:function(p){p=p||{};B.prototype.constructor.apply(this,arguments);this.setPreventInitialization(true);if(!p["config"]){this.addConfig(D,true);}},
renderer:B.getMetadata().getRenderer()
});
function h(o,n,N,K,v){if(!o[n]){o[n]={};}if(!o[n][N]){o[n][N]={};}o[n][N][K]=v;}
function j(J,I){var n="sap.card";var o=O.get([n,"configuration"],J);var p=O.get([n,"configuration"],I);if(d(o,p)){return undefined;}var r={};e(o,function(u,v){e(v,function(N,S){if(!p[u][N]){r[u]=r[u]||{};r[u][N]=S;}else{e(S,function(K,V){if(p[u][N][K]!==V){h(r,u,N,K,V);}});}});});return{configuration:r};}
g.prototype.init=function(){B.prototype.init.apply(this,arguments);this.attachJsonChange(function(E){if(!this._oInitialJson){this._oInitialJson=E.getParameter("json");}},this);};
g.prototype.setJson=function(){B.prototype.setJson.apply(this,arguments);var J=this.getJson();var n=O.get(["sap.app","id"],J);if(this._bDesigntimeInit&&this._bCardId!==n){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel();}delete this._bCardId;delete this._bDesigntimeInit;}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bDesigntimeInit=true;this._bCardId=n;var o=s(O.get(["sap.card","configuration","editor"],J)||"");if(o===""){o=s(O.get(["sap.card","designtime"],J)||"");}var p=s(this.getBaseUrl()||"");if(p&&o){var P={};var S=s(p);var r=t(o);var u=S+"/"+r;var N=n.replace(/\./g,"/")+"/"+r;P[N]=u;sap.ui.loader.config({paths:P});var E=N+"/editor.config";var I=N+"/i18n/i18n.properties";var v=u+"/metadata.json";this._oDesigntimePromise=new C(function(R){Promise.all([new Promise(function(w){sap.ui.require([E],w,function(){w({});});}),new Promise(function(w){q.getJSON(v).done(w).fail(function(){w({});});})]).then(R);});this._oDesigntimePromise.then(function(w){this.setPreventInitialization(false);var x=w[1];x=f.mergeCardDesigntimeMetadata(x,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=x;this.setDesigntimeMetadata(k(x),true);var y=w[0];if(i(y)){this.addConfig({"i18n":I});}else{y=m({},y);y.i18n=y.i18n?b(y.i18n):[];y.i18n.push(I);this._addSpecificConfig(y);}}.bind(this));}else{this.setPreventInitialization(false);this.addConfig({});}}};
g.prototype.setDesigntimeChanges=function(n){if(this._oInitialDesigntimeMetadata){throw Error("Designtime Changes can only be set initially");}this.setProperty("designtimeChanges",n);};
function k(F){var o={};Object.keys(F).forEach(function(p){O.set(p.split("/"),{__value:c(F[p])},o);});return o;}
function s(p){return p.trim().replace(/\/*$/,"");}
function t(p){return p.replace(/^\.\//,"");}
g.prototype.getChanges=function(p){return Promise.all([this.getDeltaChangeDefinition(p).catch(function(){return;}),this.getDesigntimeChangeDefinition(p).catch(function(){return;})]).then(function(n){if(n[0]===undefined&&n[1]===undefined){return Promise.reject("No changes");}return{runtimeChange:n[0],designtimeChange:n[1]};});};
function l(p){return new Promise(function(r){sap.ui.require(["sap/ui/fl/Change"],function(n){var o=n.createInitialFileContent(p);o.creation=new Date().toISOString();r(o);});});}
g.prototype.getDesigntimeChangeDefinition=function(p){var n=[];var o=Object.assign({},this._oInitialDesigntimeMetadata);var N=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());e(N,function(K,v){if(o.hasOwnProperty(K)){if(!_(o[K],v)){n.push({propertyPath:K,operation:"UPDATE",propertyValue:v});}delete o[K];}else{n.push({propertyPath:K,operation:"INSERT",propertyValue:v});}});e(o,function(K){n.push({propertyPath:K,operation:"DELETE"});});if(!n.length){return Promise.reject("No Change");}this._oInitialDesigntimeMetadata=N;var r=this.getJson();var P=m({},a(p,["oldValue","newValue"]));P.content={entityPropertyChange:n};P.changeType="appdescr_card_designtime";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],r);return l(P);};
g.prototype.getDeltaChangeDefinition=function(p){var o=this.getJson();var P=m({},p);P.content=j(o,this._oInitialJson);if(!P.content){return Promise.reject("No Change");}this._oInitialJson=o;P.changeType="appdescr_card";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],o);return l(P);};
return g;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditor',["sap/ui/integration/designtime/baseEditor/PropertyEditor"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditors',["sap/ui/integration/designtime/baseEditor/PropertyEditors"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateActionConfig',["sap/base/util/restricted/_merge"],function(_){"use strict";return function(c){return _({},{"label":"{i18n>CARD_EDITOR.ACTIONS}","type":"array","itemLabel":"{type}","addItemLabel":"{i18n>CARD_EDITOR.ACTION}","template":{"enabled":{"label":"{i18n>CARD_EDITOR.ACTION.ENABLED}","type":"boolean","defaultValue":true,"path":"enabled"},"type":{"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"Navigation"}],"path":"type","visible":"{= !!${enabled}}"},"service":{"label":"{i18n>CARD_EDITOR.ACTION.SERVICE}","type":"string","path":"service","visible":false},"parameters":{"label":"{i18n>CARD_EDITOR.PARAMETERS}","type":"map","allowedTypes":["string","number","boolean"],"path":"parameters","visible":"{= !!${enabled}}"},"url":{"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= !!${enabled} && ${type} === 'Navigation'}"},"target":{"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${enabled} && ${type} === 'Navigation' && !!${url}}"}}},c);};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_omit","sap/base/util/restricted/_merge","sap/base/util/deepClone","sap/ui/integration/cards/filters/DateRangeFilter"],function(B,_,a,d,D){"use strict";
var C=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",{
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
C.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},keyLabel:{defaultValue:"{i18n>CARD_EDITOR.COMPLEX_MAP.KEY}"}});
C.prototype.getExpectedWrapperCount=function(){return 1;};
C.prototype.onFragmentReady=function(){this._oNestedArrayEditor=this.getContent();this._oNestedArrayEditor.attachValueChange(function(e){var p=e.getParameter("previousValue")||[];var v=d(e.getParameter("value")||[]);var n={};var b=this.getDesigntimeProperties();v=v.map(function(V,i){if(typeof V.key==="undefined"){var k="key";var c=0;var f=function(E){return E.key===k;};while(v.some(f)){k="key"+ ++c;}V.key=k;}var o={};b.forEach(function(P){o[P]=d(V[P]);});n[V.key]={__value:o};return _(V,b);});var N=this._processOutputValue(v);p.forEach(function(P){var o=P.key;if(o!==undefined&&!N.hasOwnProperty(o)){n[o]=null;}});this.setValue(N);this.setDesigntimeMetadata(a({},this.getConfig().designtime,n));},this);};
C.prototype._processInputValue=function(v){var b=this.getDesigntimeProperties();if(!v){v={};}var f=Object.keys(v).map(function(k){var F=d(v[k]);F.key=k;var c=this.getNestedDesigntimeMetadataValue(k);b.forEach(function(p){F[p]=c[p];});return F;}.bind(this));if(this.getConfig().type==="filters"){for(var i=0;i<f.length;i++){if(!f[i].options){var o=this._getDefaultFilterOptions();f[i].options=o;}if(f[i].type===undefined){f[i].selectedOptions=[];}if(f[i].type==="Select"){f[i].sValue=f[i].value;delete f[i].value;f[i].selectedOptions=[];}else if(f[i].type==="DateRange"){if(!f[i].value){f[i].value={option:'today',values:[]};}f[i].dValue=f[i].value;delete f[i].value;var s=[];for(var j=0;j<f[i].options.length;j++){s.push({key:f[i].options[j],title:f[i].options[j]});}f[i].selectedOptions=s;}}}return f;};
C.prototype.getDesigntimeProperties=function(){return[];};
C.prototype.onBeforeConfigChange=function(c){var t={};if(c["allowKeyChange"]){t={key:{label:c["keyLabel"],type:"string",path:"key",validators:{uniqueKey:{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}}}};}var A=a({},{template:t,allowSorting:false},c,{type:"array",path:""});this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedConfig:A}));return c;};
C.prototype.setValue=function(v){var f=this._processInputValue(v);this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedValue:f}));B.prototype.setValue.call(this,v);};
C.prototype._processOutputValue=function(v){if(this.getConfig().type==="filters"){for(var i=0;i<v.length;i++){if(v[i].type==="Select"){v[i].value=v[i].sValue;delete v[i].sValue;}else if(v[i].type==="DateRange"&&v[i].selectedOptions){v[i].value=v[i].dValue;delete v[i].dValue;delete v[i].selectedOptions;}}}var f={};v.forEach(function(V){f[V.key]=_(V,"key");});return f;};
C.prototype._getDefaultFilterOptions=function(){var b=new D();var o=b._getDefaultOptions();return o;};
return C;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge"],function(B,C,_){"use strict";
var D=C.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.destinationsEditor.DestinationsEditor",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
D.configMetadata=Object.assign({},C.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});
D.prototype.onBeforeConfigChange=function(c){var o={};if(c["allowKeyChange"]){o={template:{label:{label:this.getI18nProperty("CARD_EDITOR.LABEL"),type:"string",path:"label"},name:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.NAME"),type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:true,allowBindings:false},defaultUrl:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.DEFAULT_URL"),type:"string",path:"defaultUrl"}}};}else{o={collapsibleItems:false,showItemLabel:false,template:{name:{label:"{= ${label} || ${key}}",type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:false,allowBindings:false}}};}var a=_({},o,c);return C.prototype.onBeforeConfigChange.call(this,a);};
return D;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/filtersEditor/FiltersEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge","sap/ui/integration/cards/filters/DateRangeFilter"],function(B,C,_,D){"use strict";
var F=C.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.filtersEditor.FiltersEditor",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
F.configMetadata=Object.assign({},C.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});
F.prototype.onBeforeConfigChange=function(c){var o={};if(c["allowKeyChange"]){o={template:{key:{label:this.getI18nProperty("CARD_EDITOR.FILTER.KEY"),path:"key",type:"string",enabled:c.allowKeyChange,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}]},type:{label:this.getI18nProperty("CARD_EDITOR.FILTER.TYPE"),path:"type",type:"select",items:(c["allowedTypes"]||[]).map(function(k){return{key:k};}),allowCustomValues:true,allowBindings:false},label:{label:this.getI18nProperty("CARD_EDITOR.FILTER.LABEL"),path:"label",type:"string"},description:{label:this.getI18nProperty("CARD_EDITOR.FILTER.DESCRIPTION"),type:"string",path:"description",allowCustomValues:true,allowBindings:false},value:{label:this.getI18nProperty("CARD_EDITOR.FILTER.VALUE"),path:"sValue",type:"string",visible:"{= ${type} === 'Select'}"},itemPath:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.PATH"),path:"item/path",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemTemplateKey:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.TEMPLATE.KEY"),path:"item/template/key",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemTemplateTitle:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.TEMPLATE.TITLE"),path:"item/template/title",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemData:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.DATA"),path:"data",type:"json",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},items:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEMS"),path:"items",type:"json",visible:"{= ${type} === 'Select'}",enabled:"{= ${item/template/key} === undefined || ${item/template/key} === ''}"},dateRangeOptions:{label:this.getI18nProperty("CARD_EDITOR.FILTER.OPTIONS"),path:"options",type:"multiSelect",items:this.getAllDateRangeOptions(),visible:"{= ${type} === 'DateRange'}"},dateRangeValueOption:{label:this.getI18nProperty("CARD_EDITOR.FILTER.VALUE.OPTION"),path:"dValue/option",type:"select",items:"{selectedOptions}",visible:"{= ${type} === 'DateRange'}"},dateRangeValues:{label:this.getI18nProperty("CARD_EDITOR.FILTER.VALUE.VALUES"),path:"dValue/values",type:"textArea",visible:"{= ${type} === 'DateRange'}"}}};}else{o={collapsibleItems:false,showItemLabel:false,template:{type:{label:this.getI18nProperty("CARD_EDITOR.FILTER.TYPE"),type:"select",path:"type",items:(c["allowedTypes"]||[]).map(function(k){return{key:k};}),allowCustomValues:false,allowBindings:false}}};}var a=_({},o,c);return C.prototype.onBeforeConfigChange.call(this,a);};
F.prototype.getAllDateRangeOptions=function(){var d=new D();var o=d.getOptions();var a=[];for(var k in o){if(o.hasOwnProperty(k)){a.push({key:o[k],title:o[k]});}}return a;};
return F;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment",'sap/ui/unified/ColorPickerPopover','sap/ui/unified/library',"sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(B,i,F,C,U,J,d,a,b,_,I){"use strict";
var c=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{
metadata:{library:"sap.ui.integration"},
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",
renderer:B.getMetadata().getRenderer().render
});
c.configMetadata=Object.assign({},B.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ICON"}});var o={config:{type:"simpleicon"},key:"src"};var t={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var p={config:{type:"string"},key:"src"};var D={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var e=U.ColorPickerMode;var f=U.ColorPickerDisplayMode;
c.prototype.init=function(){this._oIconModel=new J(d(D));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new J({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:o});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new J({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var h=d(this._oConfigsModel.getData());h.selectConfig.items=[{"key":"icon","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{"key":"text","title":this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{"key":"picture","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(h);var j=d(this._oSettingsModel.getData());j.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(j);}},this);};
c.prototype.getExpectedWrapperCount=function(){return 2;};
c.prototype.setValue=function(v){var n=b(v)?undefined:v;B.prototype.setValue.call(this,n);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),v,{type:this.getDesigntimeMetadataValue().type||g(v)}));};
function g(v){if(a(v)){if(v.src){if(v.backgroundColor||v.color||(I.isIconURI(v.src)&&I.getIconInfo(v.src))||i(v.src,false)){return"icon";}else{return"picture";}}else if(v.text){return"text";}}return D.type;}
c.prototype._prepareValue=function(k,h){return h[k];};
c.prototype._onTypeChange=function(E){var h;var T=E.getSource().getValue();switch(T){case"icon":h=o;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":h=t;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":h=p;this._oSettingsModel.setProperty("/altVisible",true);break;}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:h}));this.setDesigntimeMetadataValue({type:T});this.setValue(this._processOutputValue(this._oIconModel.getData()));};
c.prototype._updateValue=function(E){var k=this._oConfigsModel.getData().valueConfig.key;var n={};n[k]=E.getSource().getValue();var N=Object.assign({},this._oIconModel.getData(),n);this.setValue(this._processOutputValue(N));};
c.prototype._handleSettings=function(){this._oOldData=d(this.getModel("icon").getData());if(!this._oSettingsDialog){return F.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(h){this._oDialogModel=new J(this._oOldData);this._oSettingsDialog=h;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog;}.bind(this));}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog);}};
c.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()));};
c.prototype._onSettingsCancel=function(){this._oSettingsDialog.close();};
c.prototype._processOutputValue=function(v){var T=this.getDesigntimeMetadataValue().type;var O=["type"];Object.keys(v).forEach(function(k){if(!v[k]||v[k]===D[k]){O.push(k);}});switch(T){case"icon":O.push("text");if(!v["src"]){O.push("shape","alt","backgroundColor","color");}break;case"picture":O.push("text","backgroundColor","color");if(!v["src"]){O.push("shape","alt");}break;case"text":O.push("src","alt");if(!v["text"]){O.push("shape","backgroundColor","color");}break;}return _(v,O);};
c.prototype._openColorPickerPopup=function(E){this._inputId=E.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new C("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:f.Simplified,mode:e.HSL,change:this._handleColorPickerChange.bind(this)});}this.oColorPickerSimplifiedPopover.openBy(E.getSource());};
c.prototype._handleColorPickerChange=function(E){var h=sap.ui.getCore().byId(this._inputId);h.setValue(E.getParameter("hex"));h.setValueState("None");this._inputId="";};
c.prototype.getFocusDomRef=function(){var h=this.getContent();if(h){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef();}};
c.prototype.getIdForLabel=function(){var h=this.getContent();if(h){return this.getContent().getItems()[0].getContent()[0].getIdForLabel();}};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","sap/base/util/includes","sap/base/util/restricted/_merge","sap/base/util/deepEqual"],function(B,M,i,_,d){"use strict";
var P=M.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersEditor",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
P.configMetadata=Object.assign({},M.configMetadata,{allowLabelChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
P.prototype.getBoolenValue=function(v,V,D){if(typeof v==="boolean"){return v;}if(typeof V==="boolean"){return V;}return D;};
P.prototype.formatItemConfig=function(c){var m=M.prototype.formatItemConfig.apply(this,arguments);var k=c.key;var t=c.value.type;var I=this.getNestedDesigntimeMetadataValue(k);var v=this.getBoolenValue(c.value.visible,I.visible,true);var V=this.getBoolenValue(c.value.visibleToUser,I.visibleToUser,true);var e=this.getBoolenValue(c.value.editable,I.editable,true);var E=this.getBoolenValue(c.value.editableToUser,I.editableToUser,true);var r=this.getBoolenValue(c.value.required,I.required,false);var b=this.getBoolenValue(c.value.expanded,I.expanded,true);var s=c.value.manifestpath||I.manifestpath||"";var D=c.value.description||I.description||"";var T=this.getBoolenValue(c.value.translatable,I.translatable,false);var a=this.getBoolenValue(c.value.allowSettings,I.allowSettings,true);var A=this.getBoolenValue(c.value.allowDynamicValues,I.allowDynamicValues,false);var o=c.value.visualization||I.visualization;var f=c.value.values||I.values;var l=c.value.label||I.label;var p=c.value.placeholder||I.placeholder||"";var g=c.value.validations||I.validations;var h=c.value.hint||I.hint||"";var F=c.value.formatter||I.formatter;var L=c.value.layout||I.layout;m[2].visible=!(t==="group"||t==="array"||t==="separator");m.push({label:this.getI18nProperty("CARD_EDITOR.LABEL"),path:"label",value:l,placeholder:l?undefined:k,visible:t!=="separator",type:"string",enabled:this.getConfig().allowLabelChange,itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.DESCRIPTION"),path:"description",value:D,allowBindings:true,visible:t!=="group"&&t!=="separator",type:"string",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.HINT"),path:"hint",value:h,allowBindings:true,enabled:true,visible:t!=="separator",type:"string",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.FORMATTER"),path:"formatter",value:F,allowBindings:true,enabled:true,visible:t==="date"||t==="datetime"||t==="number"||t==="integer",type:"textArea",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.PLACEHOLDER"),path:"placeholder",value:p,allowBindings:true,visible:t==="string",type:"string",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.MANIFESTPATH"),path:"manifestpath",value:s,allowBindings:true,visible:t!=="group"&&t!=="separator",type:"string",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISIBLE"),path:"visible",value:v,allowBindings:true,type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISIBLETOUSER"),path:"visibleToUser",value:V,allowBindings:true,type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EDITABLE"),path:"editable",allowBindings:true,value:e,enabled:true,visible:t!=="group"&&t!=="separator",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EDITABLETOUSER"),path:"editableToUser",allowBindings:true,value:E,enabled:true,visible:t!=="group"&&t!=="separator",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.REQUIRED"),path:"required",allowBindings:true,value:r,visible:t==="string"||t==="number"||t==="integer",enabled:true,type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EXPANDED"),path:"expanded",allowBindings:true,value:b,enabled:true,visible:t==="group",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.TRANSLATABLE"),path:"translatable",value:T,enabled:true,visible:t!=="separator",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.ALLOWDYNAMICVALUES"),path:"allowDynamicValues",allowBindings:true,enabled:true,value:A,visible:t!=="group"&&t!=="separator",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.ALLOWSETTINGS"),path:"allowSettings",allowBindings:true,value:a,visible:t!=="group"&&t!=="separator",type:"boolean",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISUALIZATION"),path:"visualization",allowBindings:true,value:o,visible:t!=="group"&&t!=="separator",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISUALIZATION.PLACEHOLDER"),type:"textArea",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALIDATIONS"),path:"validations",allowBindings:true,value:g,visible:t==="string"||t==="number"||t==="integer",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALIDATIONS.PLACEHOLDER"),type:"textArea",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALUES"),path:"values",allowBindings:true,value:f,visible:t==="string"||t==="array",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALUES.PLACEHOLDER"),type:"textArea",itemKey:k},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.LAYOUT"),path:"layout",allowBindings:true,value:L,visible:t!=="group"&&t!=="separator",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.LAYOUT.PLACEHOLDER"),type:"textArea",itemKey:k});return m;};
P.prototype.processInputValue=function(v){return v;};
P.prototype.processOutputValue=function(v){return v;};
P.prototype._configItemsFormatter=function(I){return Array.isArray(I)?I.map(function(o){var a=this.getNestedDesigntimeMetadataValue(o.key);var c=_({},o.value,a);if(!c.label){c.label=o.key;}c.itemKey=o.key;c.path="value";c.designtime=this.getNestedDesigntimeMetadata(o.key);return c;}.bind(this)):[];};
P.prototype.getItemChangeHandlers=function(){return Object.assign({},M.prototype.getItemChangeHandlers.apply(this,arguments),{label:this._onDesigntimeChange});};
P.prototype.onBeforeConfigChange=function(c){if(!c.allowTypeChange&&!c.allowKeyChange){this.setFragment("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersConfigurationEditor",function(){return 1;});}return c;};
P.prototype._isValidItem=function(I,o){var t=o.type;var v=o.value;var a=this._getAllowedTypes();return(t&&i(a,t)||typeof v==="string"&&i(a,"string"));};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/util/CommonPatterns',function(){"use strict";return{email:new RegExp(/^(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*:(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)(?:,\s*(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>))*)?;\s*)$/).source};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList',["sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){return(v||[]).every(function(V){return I.validate(V,c);});}};});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardEditor',["sap/ui/integration/editor/Editor","sap/ui/core/Core","sap/ui/integration/widgets/Card","sap/ui/integration/editor/Merger","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/ui/model/resource/ResourceModel"],function(E,C,a,M,J,m,R){"use strict";var r=C.getLibraryResourceBundle("sap.ui.integration");
var b=E.extend("sap.ui.integration.designtime.editor.CardEditor",{
metadata:{library:"sap.ui.integration",properties:{card:{type:"any",defaultValue:null}},aggregations:{_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"}}},
renderer:E.getMetadata().getRenderer().render
});
b.prototype.hasPreview=function(){var p=this.getAggregation("_preview");if(p&&p.getSettings()&&p.getSettings().preview&&p.getSettings().preview.modes==="None"){return false;}return true;};
b.prototype.setCard=function(c,s){if(c===this.getProperty("card")){return this;}if(this._oEditorCard){this._oEditorCard.destroy();}this.setProperty("card",c,s);if(typeof c==="string"){try{c=JSON.parse(c);}catch(e){var i=C.byId(c);if(!i){var d=document.getElementById(c);if(d&&d.tagName&&d.tagName==="ui-integration-card"){i=d._getControl();}}c=i;}}if(c&&c.isA&&c.isA("sap.ui.integration.widgets.Card")){c={manifest:c.getManifest(),manifestChanges:c.getManifestChanges(),host:c.getHost(),baseUrl:c.getBaseUrl()};}if(typeof c==="object"){this._oEditorCard=new a(c);this._oEditorCard.onBeforeRendering();this._oEditorCard.attachEventOnce("_cardReady",function(){this.setJson(c,s);}.bind(this));}};
b.prototype.createManifest=function(i,s){this._isManifestReady=false;if(this._oEditorManifest){this._oEditorManifest.destroy();}this.destroyAggregation("_extension");var c=M.layers[this.getMode()];this._oEditorManifest=this._oEditorCard._oCardManifest;this._registerManifestModulePath();this._oInitialManifestModel=new J(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,s);var o=this._oEditorManifest._oManifest.getRawJson();var _=m({},o);this._beforeManifestModel=new J(_);if(c<M.layers["translation"]&&this._currentLayerManifestChanges){o=M.mergeDelta(o,[this._currentLayerManifestChanges]);}this._manifestModel=new J(o);this._isManifestReady=true;this.fireManifestReady();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){var r=this._oEditorManifest.getResourceBundle();var d=new R({bundle:r});this.setModel(d,"i18n");this._oResourceBundle=r;}else{this._loadDefaultTranslations();}return this._loadExtension().then(function(){this._initInternal();}.bind(this));};
b.prototype._initPreview=function(){var s=this._oDesigntimeInstance.getSettings()||{};s.preview=s.preview||{};s.preview.position=this.getPreviewPosition();return new Promise(function(c,d){sap.ui.require(["sap/ui/integration/designtime/editor/CardPreview"],function(P){var p=new P({settings:s,card:this._oEditorCard});this.setAggregation("_preview",p);c();}.bind(this));}.bind(this));};
b.prototype._loadExtension=function(){return new Promise(function(c,d){var e=this._oEditorCard.getAggregation("_extension");this.setAggregation("_extension",e);c();}.bind(this));};
b.prototype._mergeContextData=function(c){var d={};d["empty"]=b._contextEntries.empty;for(var n in c){d[n]=c[n];}d["card.internal"]=b._contextEntries["card.internal"];return d;};
b._contextEntries={empty:{label:r.getText("CARDEDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:r.getText("CARDEDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"card.internal":{label:r.getText("CARDEDITOR_CONTEXT_CARD_INTERNAL_VAL"),todayIso:{type:"string",label:r.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),description:r.getText("CARDEDITOR_CONTEXT_CARD_TODAY_DESC"),tags:[],placeholder:r.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:r.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),description:r.getText("CARDEDITOR_CONTEXT_CARD_NOW_DESC"),tags:[],placeholder:r.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:r.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),description:r.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:r.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardPreview',["sap/ui/core/Control","sap/m/HBox","sap/m/Image","sap/m/ToggleButton","sap/ui/integration/widgets/Card","sap/ui/core/Core","sap/ui/dom/includeStylesheet","sap/ui/integration/util/CardMerger"],function(C,H,I,T,a,c,i,d){"use strict";
var e=C.extend("sap.ui.integration.designtime.editor.CardPreview",{
metadata:{library:"sap.ui.integration",properties:{settings:{type:"any"},card:{type:"object"}},aggregations:{cardPreview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){if(o._getCurrentMode()==="None"){r.openStart("div",o);r.openEnd();return;}r.openStart("div",o);r.addClass("sapUiIntegrationDTPreview");if(f()){r.addClass("sapUiIntegrationDTPreviewDark");}if(o.getSettings().preview.position&&(o.getSettings().preview.position==="top"||o.getSettings().preview.position==="bottom")){var l=c.getConfiguration().getLanguage().replaceAll('_','-');if(l.startsWith("ar")||l.startsWith("he")){r.addClass("sapUiIntegrationDTPreviewMarginForAlignTopAndBottomSpec");}else{r.addClass("sapUiIntegrationDTPreviewMarginForAlignTopAndBottom");}}r.openEnd();r.openStart("div");r.addClass("before");r.writeAttribute("tabindex","-1");r.writeAttributeEscaped("id",o.getId()+"-before");r.addStyle("z-index",o.getParent()._iZIndex+1);r.openEnd();r.close("div");r.renderControl(o._getCardPreview());r.openStart("div");r.writeAttribute("tabindex","-1");r.writeAttributeEscaped("id",o.getId()+"-after");r.openEnd();r.close("div");if(o._getModes().indexOf("Live")>-1&&o._getModes().indexOf("Abstract")>-1){r.renderControl(o._getModeToggleButton());}}
});
e.prototype.init=function(){this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");c.attachThemeChanged(function(){if(this.getDomRef()){if(f()){this.getDomRef().classList.add("sapUiIntegrationDTPreviewDark");}else{this.getDomRef().classList.remove("sapUiIntegrationDTPreviewDark");}}else{this.update();}}.bind(this));};
e.prototype.destroy=function(){if(this._oModeToggleButton){this._oModeToggleButton.destroy();}if(this._oCardPreview){this._oCardPreview.destroy();}if(this._oImagePlaceholder){this._oImagePlaceholder.destroy();}if(this._oCardPlaceholder){this._oCardPlaceholder.destroy();}C.prototype.destroy.apply(this,arguments);};
e.prototype.onAfterRendering=function(){var p=this.getAggregation("cardPreview"),m=this._getModes();if(m.indexOf("Live")>-1&&p&&p.getDomRef()&&p.getDomRef().getElementsByClassName("sapVizFrame")){window.setTimeout(function(){try{var v=p.getDomRef().getElementsByClassName("sapVizFrame")[0].id;var V=c.byId(v);if(V.getVizProperties()&&V.getVizProperties().legendGroup.layout.position==="bottom"&&V.getVizProperties().legendGroup.layout.alignment==="center"){p.getDomRef().getElementsByClassName("v-m-legend")[0].transform.baseVal[0].matrix.e=110;}}catch(b){}},500);}};
e.prototype._getCardPreview=function(){var p=null;if(this._getCurrentMode()==="Abstract"){if(this.getSettings().preview.src){p=this._getImagePlaceholder();}else{p=this._getCardPlaceholderPreview();}}else if(this._getCurrentMode()==="Live"){p=this._getCardRealPreview();}if(p){this.setAggregation("cardPreview",p);if(!this.getSettings().preview||this.getSettings().preview.scaled!==false){p.removeStyleClass("sapUiIntegrationDTPreviewScale");p.removeStyleClass("sapUiIntegrationDTPreviewScaleSpec");var l=c.getConfiguration().getLanguage().replaceAll('_','-');if(l.startsWith("ar")||l.startsWith("he")){p.addStyleClass("sapUiIntegrationDTPreviewScaleSpec");}else{p.addStyleClass("sapUiIntegrationDTPreviewScale");}}else{p.addStyleClass("sapUiIntegrationDTPreviewNoScale");}}return p;};
e.prototype._getCardPlaceholderPreview=function(){var o=this.getCard(),p;function _(s,x){return o.getManifestEntry(s)?x||"{bound}":null;}var h=null;if(o.getManifestEntry("/sap.card/header")){var t=o.getManifestEntry("/sap.card/header/type");if(t&&t.toUpperCase()==="NUMERIC"){h={"title":_("/sap.card/header/title"),"type":"Numeric","subTitle":_("/sap.card/header/subTitle"),"unitOfMeasurement":_("/sap.card/header/unitOfMeasurement"),"mainIndicator":_("/sap.card/header/mainIndicator",{"number":"{bound}","unit":"{bound}","trend":"{bound}","state":"{bound}"}),"details":_("/sap.card/header/details"),"sideIndicators":[_("/sap.card/header/sideIndicators/0",{"title":"Deviation","number":"{bound}","unit":"{bound}"}),_("/sap.card/header/sideIndicators/1",{"title":"Target","number":"{bound}","unit":"{bound}"})]};}else{h={"title":_("/sap.card/header/title"),"subTitle":_("/sap.card/header/subTitle"),"status":_("/sap.card/header/status"),"icon":_("/sap.card/header/icon",{"src":"{bound}"})};}}var b=this.getParent().getCurrentSettings();p={"sap.app":{"type":"card","id":o.getManifestEntry("/sap.app/id")+".abstractPreview"},"sap.card":{"type":o.getManifestEntry("/sap.card/type")==="List"?"List":"Component","header":h,"content":{"maxItems":Math.min(b["/sap.card/content/maxItems"]||6,6),"item":{"title":{"value":_("/sap.card/content/item/value")},"icon":_("/sap.card/content/item/icon",{"src":"{bound}"}),"description":_("/sap.card/content/item/description"),"info":{"value":_("/sap.card/content/item/info")}}}}};if(!this._oCardPlaceholder){this._oCardPlaceholder=new a();this._oCardPlaceholder._setPreviewMode(true);}this._oCardPlaceholder.setManifest(p);this._oCardPlaceholder.refresh();return this._oCardPlaceholder;};
e.prototype.getTransformContentInfo=function(){return{transformStyle:"scale3d(0.4, 0.4, 1)",transformFactor:0.4,transformOriginStyle:"0 0",widthStyle:"500px",heightStyle:"600px",zIndex:this.getParent()._iZIndex};};
e.prototype._getCardRealPreview=function(){if(!this._oCardPreview){this._oCardPreview=new a();this._oCardPreview.setBaseUrl(this.getCard().getBaseUrl());}this._initalChanges=this._initalChanges||this._oCardPreview.getManifestChanges()||[];var b=this._initalChanges.concat([this.getParent().getCurrentSettings()]);this._oCardPreview.setManifestChanges(b);this._oCardPreview.setManifest(this.getCard()._oCardManifest._oManifest.getRawJson());this._oCardPreview.setHost(this.getCard().getHost());this._oCardPreview.refresh();this._oCardPreview.editor=this._oCardPreview.editor||{};this._oCardPreview.preview=this._oCardPreview.editor.preview=this;return this._oCardPreview;};
e.prototype._getImagePlaceholder=function(){var s=this.getSettings();if(s.preview.src){if(!this._oImagePlaceholder){var h=new H();h.addStyleClass("sapFCard");h.setWidth("500px");var b=this.getCard().getBaseUrl();if(!b&&typeof this.getCard().getManifest()==="string"){b=this.getCard().getManifest();b=b.substring(0,b.lastIndexOf("/")+1);}var g=b+"/"+s.preview.src;var o=new I({src:g});o.addStyleClass("sapUiIntegrationDTPreviewImg");o.setWidth("500px");o.setHeight("600px");h.addItem(o);this._oImagePlaceholder=h;}}return this._oImagePlaceholder;};
e.prototype._getModes=function(){var s=this.getSettings();s.preview=s.preview||{};s.preview.modes=s.preview.modes||"Abstract";return s.preview.modes;};
e.prototype._getCurrentMode=function(){var m=this._getModes();if(!this._currentMode){switch(m){case"AbstractLive":case"Abstract":this._currentMode="Abstract";break;case"LiveAbstract":case"Live":this._currentMode="Live";break;default:this._currentMode="None";}}return this._currentMode;};
e.prototype._toggleCurrentMode=function(){var m=this._getModes();if(m.indexOf("Live")>-1&&m.indexOf("Abstract")>-1){this._currentMode=this._getCurrentMode()==="Abstract"?"Live":"Abstract";}};
e.prototype._getModeToggleButton=function(){var b=c.getLibraryResourceBundle("sap.ui.integration");if(!this._oModeToggleButton){this._oModeToggleButton=new T();this._oModeToggleButton.setTooltip();this._oModeToggleButton.attachPress(function(){this._toggleCurrentMode();this.update();}.bind(this));}this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewButton");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewButtonSpec");var l=c.getConfiguration().getLanguage().replaceAll('_','-');if(l.startsWith("ar")||l.startsWith("he")){this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewButtonSpec");}else{this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewButton");}var t=this._oModeToggleButton,g=this._getCurrentMode();if(g==="None"){t.setVisible(false);}if(g==="Abstract"){t.setIcon("sap-icon://media-play");t.setPressed(false);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_LIVEPREVIEW"));}else if(g==="Live"){t.setIcon("sap-icon://media-pause");t.setPressed(true);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_SAMPLEPREVIEW"));}return this._oModeToggleButton;};
e.prototype.update=function(){this.invalidate();};
function f(h){h=h||window.getComputedStyle(document.body).backgroundColor;var m=/rgb\((\d+).*?(\d+).*?(\d+)\)/.exec(h);if(!m){return false;}var r=parseInt(m[1]),g=parseInt(m[2]),b=parseInt(m[3]),y=(r*299+g*587+b*114)/1000;return(y<=128);}
e.prototype.onsaptabnext=function(E){if(E.target===this.getDomRef("before")){this.getDomRef("after").focus();}};
e.prototype.onsaptabprevious=function(E){if(E.target===this.getDomRef("after")){this.getDomRef("before").focus();}};
e.init=function(){var s=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardPreview".replace(/\./g,"/")+".css");i(s);this.init=function(){};};
e.init();return e;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @function
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateDataConfig',function(){"use strict";return function(t,r,a){var d={"DataRequestUrl":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.URL}","type":"string","defaultValue":"","path":r+"data/request/url"},"DataRequestMode":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.MODE}","type":"select","items":[{"key":"no-cors"},{"key":"same-origin"},{"key":"cors"}],"defaultValue":"cors","path":r+"data/request/mode","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestMethod":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.METHOD}","type":"select","items":[{"key":"GET"},{"key":"POST"}],"defaultValue":"GET","path":r+"data/request/method","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.PARAMETERS}","type":"map","path":r+"data/request/parameters","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestHeaders":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.HEADERS}","type":"map","path":r+"data/request/headers","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestWithCredentials":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.WITHCREDENTIALS}","type":"boolean","defaultValue":false,"path":r+"data/request/withCredentials","visible":"{= !!${context>"+r+"data/request/url} }"},"DataJson":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.JSON}","type":"json","path":r+"data/json","visible":"{= !${context>"+r+"data/request/url} }"},"DataPath":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.PATH}","type":"string","path":r+"data/path","validators":{"dataPathPattern":{"type":"pattern","config":{"pattern":"^[a-zA-Z0-9_\\.\\-/|\\@\\#]*$"}}}},"DataServiceName":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.NAME}","type":"string","path":r+"data/service/name","visible":false},"DataServiceParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.PARAMETERS}","type":"map","path":r+"data/service/parameters","visible":false},"DataUpdateInterval":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.UPDATEINTERVAL}","type":"number","path":r+"data/updateInterval"}};var g={};Object.keys(d).forEach(function(k){g[a+k]=d[k];});return g;};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/AppConfig',function(){"use strict";return{"appId":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.ID}","type":"string","maxLength":70,"path":"/sap.app/id"},"appVersion":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.VERSION}","type":"string","path":"/sap.app/applicationVersion/version"},"appTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"/sap.app/title"},"appSubTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"/sap.app/subTitle"},"appShortTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.SHORTTITLE}","type":"string","path":"/sap.app/shortTitle"},"appInfo":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.INFO}","type":"string","path":"/sap.app/info"},"appIcon":{"tags":["app"],"label":"{i18n>CARD_EDITOR.ICON}","type":"simpleicon","path":"/sap.ui/icons/icon"},"appDescription":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.DESCRIPTION}","type":"string","path":"/sap.app/description"},"appI18n":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.I18N}","type":"string","path":"/sap.app/i18n","defaultValue":"i18n/i18n.properties"},"appTagKeywords":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.KEYWORDS}","type":"list","path":"/sap.app/tags/keywords"},"appTagTechnicalAttributes":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.TECHNICALATTRIBUTES}","type":"list","path":"/sap.app/tags/technicalAttributes","validators":{"technicalAttributesPattern":{"type":"patternList","config":{"pattern":"^[A-Z0-9_\\-\\/]+$"}}}},"mobile":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.MOBILE}","type":"boolean","defaultValue":"","path":"/sap.platform.mobilecards/compatible"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/HeaderConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"headerType":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERTYPE}","path":"header/type","type":"select","items":[{"key":"Default","title":"{i18n>CARD_EDITOR.HEADERTYPE.DEFAULT}"},{"key":"Numeric","title":"{i18n>CARD_EDITOR.HEADERTYPE.NUMERIC}"}],"defaultValue":"Default"},"headerPosition":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERPOSITION}","path":"headerPosition","type":"select","items":[{"key":"Top","title":"{i18n>CARD_EDITOR.HEADERPOSITION.TOP}"},{"key":"Bottom","title":"{i18n>CARD_EDITOR.HEADERPOSITION.BOTTOM}"}],"defaultValue":"Top"},"title":{"tags":["header"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"header/title"},"subTitle":{"tags":["header"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"header/subTitle"},"actions":g({"tags":["header"],"path":"header/actions","maxItems":1}),"statusText":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.STATUS}","type":"string","path":"header/status/text"},"icon":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"header/icon","visible":"{= ${context>header/type} !== 'Numeric' }"},"unitOfMeasurement":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.UOM}","type":"string","path":"header/unitOfMeasurement","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorNumber":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"header/mainIndicator/number","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorUnit":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.UNIT}","type":"string","path":"header/mainIndicator/unit","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorTrend":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND}","type":"select","items":[{"key":"Down","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.DOWN}"},{"key":"None","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.NONE}"},{"key":"Up","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.UP}"}],"allowBinding":true,"path":"header/mainIndicator/trend","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorState":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE}","type":"select","items":[{"key":"Critical","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.CRITICAL}"},{"key":"Error","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.ERROR}"},{"key":"Good","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.GOOD}"},{"key":"Neutral","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.NEUTRAL}"}],"allowBinding":true,"path":"header/mainIndicator/state","visible":"{= ${context>header/type} === 'Numeric' }"},"details":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.DETAILS}","type":"string","path":"header/details","visible":"{= ${context>header/type} === 'Numeric' }"},"sideIndicators":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.SIDE_INDICATORS}","path":"header/sideIndicators","type":"array","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.SIDE_INDICATOR}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"number":{"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"number"},"unit":{"label":"{i18n>CARD_EDITOR.SIDE_INDICATOR.UNIT}","type":"string","path":"unit"}},"maxItems":2,"visible":"{= ${context>header/type} === 'Numeric' }"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ListCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"listMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'List' }"},"listItemTitle":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"content/item/title","visible":"{= ${context>type} === 'List' }"},"listItemDescription":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.DESCRIPTION}","type":"string","path":"content/item/description","visible":"{= ${context>type} === 'List' }"},"listItemInfoValue":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.VALUE}","type":"string","path":"content/item/info/value","visible":"{= ${context>type} === 'List' }"},"listItemInfoState":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/info/state","visible":"{= ${context>type} === 'List' }"},"listItemHighlight":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.HIGHLIGHT}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/highlight","visible":"{= ${context>type} === 'List' }"},"listItemIcon":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.ICON}","type":"simpleicon","path":"content/item/icon/src","visible":"{= ${context>type} === 'List' }"},"listItemActions":g({"tags":["content","listItem"],"path":"content/item/actions","maxItems":1,"visible":"{= ${context>type} === 'List' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig","sap/ui/integration/designtime/cardEditor/util/CommonPatterns"],function(g,C){"use strict";return{"objectGroups":{"tags":["content"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUPS}","type":"array","path":"content/groups","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"items":{"tags":["content","objectGroup"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEMS}","type":"array","path":"items","itemLabel":"{label}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM}","template":{"icon":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon"},"label":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL}","type":"string","path":"label"},"value":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.VALUE}","type":"string","path":"value","validators":{"emailPattern":{"type":"pattern","config":{"pattern":C.email,"modifiers":"i"},"errorMessage":"CARD_EDITOR.VALIDATOR.INVALID_EMAIL","isEnabled":"{= ${type} === 'email'}"}}},"type":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"phone","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.PHONE}"},{"key":"email","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.EMAIL}"},{"key":"link","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.LINK}"},{"key":"text","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.TEXT}"}],"defaultValue":"text","path":"type"},"url":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= ${type} === 'link'}"},"target":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= ${type} === 'link' && !!${url}}"},"emailSubject":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.EMAILSUBJECT}","type":"string","path":"emailSubject","visible":"{= ${type} === 'email'}"}}}},"visible":"{= ${context>type} === 'Object' }"},"objectActions":g({"tags":["content"],"path":"content/actions","maxItems":1,"visible":"{= ${context>type} === 'Object' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/TableCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"tableMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'Table' }"},"tableRowColumns":{"tags":["content","tableRow"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMNS}","type":"array","path":"content/row/columns","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN}","template":{"title":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"width":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.WIDTH}","type":"string","path":"width"},"value":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.VALUE}","type":"string","path":"value"},"icon":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon","visible":false},"state":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"state"},"url":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url"},"target":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${url}}"},"identifier":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.IDENTIFIER}","type":"boolean","defaultValue":false,"path":"identifier"},"progressIndicatorState":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"progressIndicator/state"},"progressIndicatorPercent":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.PERCENT}","type":"number","path":"progressIndicator/percent"},"progressIndicatorText":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.TEXT}","type":"string","path":"progressIndicator/text"}},"visible":"{= ${context>type} === 'Table' }"},"tableRowActions":g({"tags":["content","tableRow"],"path":"content/row/actions","maxItems":1,"visible":"{= ${context>type} === 'Table' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/index',["sap/ui/integration/designtime/cardEditor/config/AppConfig","sap/ui/integration/designtime/cardEditor/config/HeaderConfig","sap/ui/integration/designtime/cardEditor/config/ListCardConfig","sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig","sap/ui/integration/designtime/cardEditor/config/TableCardConfig","sap/ui/integration/designtime/cardEditor/config/generateDataConfig"],function(A,H,L,O,T,g){"use strict";return{"context":"sap.card","layout":{"form":{"groups":[{"label":"{i18n>CARD_EDITOR.GROUP.METADATA}","items":[{type:"tag",value:"app"}]},{"label":"{i18n>CARD_EDITOR.GROUP.GENERALCONFIGURATION}","items":[{type:"tag",value:"general"}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATA}","items":[{type:"propertyName",value:"appDataSources"},{type:"tag",value:["data","general-data"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATAHEADER}","items":[{type:"tag",value:["data","header"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATACONTENT}","items":[{type:"tag",value:["data","content"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.HEADER}","items":[{type:"tag",value:"header"}]},{"label":"{i18n>CARD_EDITOR.GROUP.CONTENT}","items":[{type:"tag",value:"content"}]}]}},"properties":Object.assign({},A,{"type":{"tags":["general"],"label":"{i18n>CARD_EDITOR.TYPE}","type":"select","items":sap.ui.version.includes('SNAPSHOT')&&!window.location.host.includes("openui5nightly")?[{"key":"List"},{"key":"Analytical"},{"key":"Table"},{"key":"Object"},{"key":"Timeline"},{"key":"Component"},{"key":"Calendar"},{"key":"AdaptiveCard"}]:[{"key":"List"},{"key":"Table"},{"key":"Object"}],"path":"type"},"parameters":{"tags":["general"],"label":"{i18n>CARD_EDITOR.PARAMETERS}","path":"configuration/parameters","type":"parameters","allowedTypes":["string","number","boolean","integer","array","date","datetime","simpleicon","group","separator"]},"destinations":{"tags":["general"],"label":"{i18n>CARD_EDITOR.DESTINATIONS}","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.DESTINATION}","path":"configuration/destinations","type":"destinations","allowedValues":["Northwind","JAM"]},"filters":{"tags":["general"],"label":"{i18n>CARD_EDITOR.FILTERS}","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.FILTER}","path":"configuration/filters","type":"filters","allowedTypes":["Select","DateRange"]}},H,L,O,T,g(["general-data"],"","card"),g(["header"],"header/","header"),g(["content"],"content/","content")),"propertyEditors":{"enum":"sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor","select":"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor","multiSelect":"sap/ui/integration/designtime/baseEditor/propertyEditor/multiSelectEditor/MultiSelectEditor","string":"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor","simpleicon":"sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor","array":"sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor","parameters":"sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor","boolean":"sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor","number":"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","integer":"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor","json":"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor","map":"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","list":"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor","datetime":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor","date":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","group":"sap/ui/integration/designtime/baseEditor/propertyEditor/groupEditor/GroupEditor","separator":"sap/ui/integration/designtime/baseEditor/propertyEditor/separatorEditor/SeparatorEditor","textArea":"sap/ui/integration/designtime/baseEditor/propertyEditor/textAreaEditor/TextAreaEditor","icon":"sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor","complexMap":"sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","destinations":"sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor","filters":"sap/ui/integration/designtime/cardEditor/propertyEditor/filtersEditor/FiltersEditor"},"validators":{"patternList":"sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList"},"i18n":"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties"};});
// add your copyright here
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/ConfigurationTemplate',["sap/ui/integration/Designtime"],function(D){"use strict";return function(){return new D({"form":{"items":{}},"preview":{"modes":"Abstract"}});};});
//# sourceMappingURL=library-preload.designtime.js.map