/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["ui5loader","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/Title","sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/integration/editor/EditorResourceBundles","sap/ui/thirdparty/URI","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/base/util/includes","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(u,C,c,M,d,f,g,I,D,J,U,h,p,L,T,P,H,V,q,R,r,t,v,w,x,E,y,A,B,F,O,G,K,S,N,Q,W,X,Y,Z,$,_){"use strict";var a1=r.prototype.init;r.prototype.init=function(){a1.apply(this,arguments);var a=this.oPopup._applyPosition,b=this;this.oPopup._applyPosition=function(){var e=b.close;b.close=function(){};a.apply(this,arguments);b.close=e;};};function b1(s){if(s&&s.nodeType!==1){return 0;}var z=parseInt(window.getComputedStyle(s).getPropertyValue('z-index'));if(isNaN(z)){return b1(s.parentNode);}return z+1;}var c1=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,d1=/\{\{parameters\.([^\}\}]+)/g,e1=5000,f1=c.getLibraryResourceBundle("sap.ui.integration"),g1="__strip0";var h1=C.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{ready:{},manifestReady:{}}},renderer:function(o,a){var b=a.getAggregation("_preview");var s=a.getMode()!=="translation"&&a.hasPreview();var e=a.getPreviewPosition();if(s&&(e==="top"||e==="bottom")){o.openStart("div");o.writeElementData(a);o.openEnd();if(a.isReady()&&e==="top"){o.renderControl(b);o.close("div");}}o.openStart("div");o.addClass("sapUiIntegrationEditor");if(s&&e==="left"){o.writeElementData(a);o.openEnd();if(a.isReady()){o.renderControl(b);o.close("div");}}else if(s&&(e==="bottom"||e==="top")){o.openEnd();}else{o.writeElementData(a);o.openEnd();}if(a.isReady()){o.openStart("div");o.addClass("sapUiIntegrationEditorForm");if(a.getMode()!=="translation"){o.addClass("settingsButtonSpace");}o.openEnd();if(a.getMode()!=="translation"){o.renderControl(a.getAggregation("_messageStrip"));}var j=a.getAggregation("_formContent");if(j){var k;var l;var m;var z=[];var i1;var j1=function(){if(z.length>0){var D1=2-z.length;for(var n=0;n<D1;n++){z.push(new V());}k.addContent(new $({alignItems:"Start",justifyContent:"SpaceBetween",items:z}));z=[];}};for(var i=0;i<j.length;i++){var k1=j[i];if(a.getMode()!=="translation"){if(k1.isA("sap.m.Panel")){if(k){j1();if(k.getContent().length>0){o.renderControl(k);}}k=k1;k.addStyleClass("sapUiIntegrationEditorItem");if(i===j.length-1){j1();if(k.getContent().length>0){o.renderControl(k);}}continue;}if(k1.isA("sap.m.FormattedText")){k.addContent(k1.addStyleClass("sapUiIntegrationEditorHint"));if(i===j.length-1){j1();if(k.getContent().length>0){o.renderControl(k);}}continue;}var l1=k1._layout;if(k1.isA("sap.m.Label")){k1.addStyleClass("sapUiIntegrationEditorItemLabel");if(l1&&!f(l1,{})){if(l1.alignment&&l1.alignment.label==="end"){k1.setTextAlign("End");}m=k1;}else{if(k1._cols===2||(k1._cols===1&&z.length===2)){j1();}k.addContent(k1);}}else if(k1.isA("sap.m.ToolbarSpacer")){j1();if(k1._hasLine){k1.addStyleClass("sapUiIntegrationEditorSpacerWithLine");}else{k1.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine");}k.addContent(k1);}else{var m1=k1.getConfiguration(),n1=new H(),o1=0.1,p1=0,q1;if(k1._descriptionIcon){n1.addItem(k1._descriptionIcon);o1+=0.9;}var r1=c.byId(k1.getAssociation("_messageIcon"));if(k1.getAssociation("_messageIcon")&&r1){n1.addItem(r1);o1+=1.2;}if(k1._settingsButton){k1._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");p1=2;}var s1=new Z({growFactor:10,maxWidth:"calc(100% - "+p1+"rem)"});var t1=new Z({maxWidth:"calc(100% - "+o1+"rem)"});if(m){var u1,v1,w1="50%";if(l1&&l1["label-width"]){w1=l1["label-width"];}var x1=parseInt(w1);var y1=100-x1;if(k1._cols===2){x1=x1-0.5;y1=y1-0.5;}if(l1.alignment&&l1.alignment.field==="end"){k1.addStyleClass("sapUiIntegrationEditorFieldAlignEnd");}if(l1.alignment&&l1.alignment.label==="end"){m.setLayoutData(new Z({maxWidth:"calc(100% - "+o1+"rem)",minWidth:"calc(100% - "+o1+"rem)"}));}else{m.setLayoutData(t1);}if(n1.getItems().length>0){m.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");q1=new H({items:[m,n1]});}else{q1=m;}if(l1&&l1.position&&l1.position==="field-label"){q1.setLayoutData(s1);v1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[q1,k1._settingsButton]});v1.setLayoutData(new Z({growFactor:x1,maxWidth:x1+"%"}));k1.setLayoutData(new Z({growFactor:y1,maxWidth:y1+"%"}));u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[k1,v1]});}else{k1.setLayoutData(s1);v1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[k1,k1._settingsButton]});q1.setLayoutData(new Z({growFactor:x1,maxWidth:x1+"%"}));v1.setLayoutData(new Z({growFactor:y1,maxWidth:y1+"%"}));u1=new H({alignItems:"Start",justifyContent:"SpaceBetween",items:[q1,v1]});}if(k1._cols===1){if(z.length===2){j1();}if(m1.hint){var z1=a._createHint(m1.hint);var A1=new V({items:[u1,z1.addStyleClass("sapUiIntegrationEditorHint")]});A1.addStyleClass("col1");z.push(A1);}else{u1.addStyleClass("col1");z.push(u1);}}else{j1();k.addContent(u1);}m=null;}else{var B1=k.getContent().pop();B1.setLayoutData(t1);if(n1.getItems().length>0){B1.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");q1=new H({items:[B1,n1]});}else{q1=B1;}q1.setLayoutData(s1);var C1=new $({alignItems:"Start",justifyContent:"SpaceBetween",items:[q1,k1._settingsButton]});if(k1._cols===1){var A1=new V({items:[C1,k1]});if(m1.hint){var z1=a._createHint(m1.hint);A1.addItem(z1.addStyleClass("sapUiIntegrationEditorHint"));}A1.addStyleClass("col1");z.push(A1);}else{k.addContent(C1);k.addContent(k1);}}}if(i===j.length-1){j1();if(k.getContent().length>0){o.renderControl(k);}}}else{if(i===0){l=k1;o.renderControl(l);l.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue;}if(k1.isA("sap.m.Panel")){if(k&&k.getContent().length>0){l.addContent(k);}k=k1;k.addStyleClass("sapUiIntegrationEditorTranslationSubPanel");continue;}if(k1.isA("sap.m.ToolbarSpacer")){continue;}if(k1.isA("sap.m.FormattedText")){continue;}if(k1.isA("sap.m.Label")){k.addContent(k1);continue;}if(k1.isOrigLangField){i1=k1;continue;}i1.addStyleClass("sapUiIntegrationFieldTranslationText");var u1=new H({items:[i1,k1]}).addStyleClass("notWrappingRow");k.addContent(u1);if(i===j.length-1){l.addContent(k);}}}}o.close("div");if(s&&e==="right"){o.renderControl(b);}}o.close("div");if(a.isReady()&&s&&e==="bottom"){o.renderControl(b);o.close("div");}}});h1.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};this.setAggregation("_messageStrip",new K({showIcon:false}));this.setLanguage(c.getConfiguration().getLanguage());this._oLimitedInterface=new I(this,["getParameters","resolveDestination","request","getModel"]);};h1.prototype.getParameters=function(){if(!this._isManifestReady){v.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}var o=this._oEditorManifest.getProcessedParameters(),a={},k;for(k in o){a[k]=o[k].value;}return a;};h1.prototype.resolveDestination=function(k){return this._oDestinations.getUrl(k);};h1.prototype.isReady=function(){return this._ready;};h1.prototype.hasPreview=function(){var o=this.getAggregation("_preview");if(o&&o.visible!==false){return true;}return false;};h1.prototype.flattenData=function(o,s,a,b){b=b||"";a=a||[];if(typeof o==="object"){if(!o[s]){for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}else{if(o.type){a.push({path:o.pathvalue||b.substring(1),value:o.pathvalue||"{context>"+b.substring(1)+"/value}",object:o});}else{a.push({path:b.substring(1),object:o});for(var n in o){this.flattenData(o[n],s,a,b+"/"+n);}}}}return a;};h1.prototype.setJson=function(i,s){this._ready=false;if(f(i,this._preIdOrSettings)){return this;}this._preIdOrSettings=d(i,500);if(typeof i==="string"){try{i=JSON.parse(i);}catch(e){}}if(typeof i==="object"){if(i.manifestChanges){this._filterManifestChangesByLayer(i);}if(this._manifestModel){return;}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}if(i.host){this.setProperty("host",i.host);}if(i.baseUrl){this.setProperty("baseUrl",i.baseUrl);}this._appliedLayerManifestChanges=i.manifestChanges;this.createManifest(i,s);}};h1.prototype.createManifest=function(i,s){var b=this.getBaseUrl();var o={},m=i.manifest;this._isManifestReady=false;if(typeof m==="string"){o.manifestUrl=m;m=null;}if(this._oEditorManifest){this._oEditorManifest.destroy();}this.destroyAggregation("_extension");var a=X.layers[this.getMode()];this._oEditorManifest=new W(this.getSection(),m,b,i.manifestChanges);this._oEditorManifest.load(o).then(function(){this._registerManifestModulePath();this._oInitialManifestModel=new J(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,s);var e=this._oEditorManifest.oJson;var j=g({},e);this._beforeManifestModel=new J(j);if(a<X.layers["translation"]&&this._currentLayerManifestChanges){e=X.mergeDelta(e,[this._currentLayerManifestChanges],this.getSection());}this._manifestModel=new J(e);this._isManifestReady=true;this.fireManifestReady();var k=this._oEditorManifest.get("/sap.app/i18n");var l=this.getBaseUrl()+k;if(k&&E.getResourceBundleURL()!==l){E.setResourceBundleURL(l);}this._loadDefaultTranslations();this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle());}return this._loadExtension().then(function(){this._initInternal();}.bind(this));}.bind(this));};h1.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return;}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){B.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/");}else{v.error("sap.app/id entry in the manifest is mandatory");}};h1.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var f1=c.getLibraryResourceBundle("sap.ui.integration");var o=new Q({bundle:f1});this.setModel(o,"i18n");this._oResourceBundle=f1;this._defaultTranslationsLoaded=true;};h1.prototype._enhanceI18nModel=function(f1){var o=this.getModel("i18n");if(o.getResourceBundle().oUrlInfo.url!==f1.oUrlInfo.url){o.enhance(f1);this._oResourceBundle=o.getResourceBundle();}};h1.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension");if(!e){v.info("Extension is not defined in manifest, do not load it.");return new Promise(function(a,b){a();});}var s=this._sAppId.replace(/\./g,"/")+"/"+e;return new Promise(function(a,b){sap.ui.require([s],function(i){var o=new i();o._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",o);a();}.bind(this),function(i){v.error("Failed to load "+e+". Check if the path is correct. Reason: "+i);b(i);});}.bind(this));};h1.prototype.request=function(o){return this._oDataProviderFactory.create({request:o}).setAllowCustomDataType(true).getData();};h1.prototype.initDestinations=function(a){var o=this.getHostInstance();if(a&&!o){v.error("Host with id '"+a+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor");}if(this._oDestinations){this._oDestinations.setHost(o);}else{var s=this.getConfigurationPath();this._oDestinations=new h(o,this._manifestModel.getProperty(s+"/destinations"));}};h1.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}var e=this.getAggregation("_extension");this._oDataProviderFactory=new p({destinations:this._oDestinations,extension:e,editor:this});};h1.prototype.getRuntimeUrl=function(s){var a=this._sAppId,b,e=s&&s.trim().replace(/^\//,"");if(a===null){v.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null;}if(!a||s.startsWith("http://")||s.startsWith("https://")||s.startsWith("//")){return s;}b=a.replace(/\./g,"/");return sap.ui.require.toUrl(b)+"/"+e;};h1.prototype.getBindingNamespaces=function(){var n={},e=this.getAggregation("_extension");if(e){n.extension={formatters:e.getFormatters()};}return n;};h1.prototype.getHostInstance=function(){var s=this.getHost();if(!s){return null;}return c.byId(s);};h1.prototype.setLanguage=function(s,b){if(!s||typeof s!=="string"){return this;}this._language=s.replaceAll('_','-');if(this.getLanguage()!=s){this._loadDefaultTranslations();}this.setProperty("language",s,b);if(!h1._languages[this._language]){this._language=this._language.split("-")[0];}if(!h1._languages[this._language]){v.warning("The language: "+s+" is currently unknown, some UI controls might show "+s+" instead of the language name.");}return this;};h1.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=b1(this.getDomRef());w.setInitialZIndex(this._iZIndex);}};h1.prototype._filterManifestChangesByLayer=function(m){var a=[],b=this,o={},e={":layer":X.layers[this.getMode()]},i=X.layers[b.getMode()];m.manifestChanges.forEach(function(j){var l=j.hasOwnProperty(":layer")?j[":layer"]:1000;if(l===X.layers["translation"]){var k=b._language;if(k===""){k=c.getConfiguration().getLanguage().replaceAll('_','-');}var n={"texts":{}};n.texts[k]={};Object.keys(j).forEach(function(s){if(s.charAt(0)==="/"){n.texts[k][s]=j[s];}else{n[s]=j[s];}});j=n;}if(l<i){a.push(j);o=g(o,j);}else if(l===i){e=j;}});m.manifestChanges=a;this._currentLayerManifestChanges=e;this._beforeLayerManifestChanges=o;};h1.prototype._initInternal=function(){var a=this;var s=a.getConfigurationPath();var b=a._oEditorManifest.get(s+"/editor");if(!b){b=a._oEditorManifest.get("/"+a.getSection()+"/designtime");}var o=a._manifestModel.getProperty(s),e,i=a.getDesigntime();if(i){if(typeof i==="function"){e=new Promise(function(j,k){var l=new i();a._applyDesigntimeDefaults(l.getSettings());j(l);});}else if(typeof i==="object"){e=new Promise(function(j,k){sap.ui.require(["sap/ui/integration/Designtime"],function(D){var l=D.extend("test.Designtime");l.prototype.create=function(){return i;};var m=new l();a._applyDesigntimeDefaults(m.getSettings());j(m);});});}}else if(b){e=a.loadDesigntime().then(function(j){a._applyDesigntimeDefaults(j.getSettings());return j;});}else{e=Promise.resolve(a._createParameterDesigntime(o));}e.then(function(j){a._oDesigntimeInstance=j;a.initDestinations();a.initDataProviderFactory();if(a.getMode()==="admin"||a.getMode()==="all"){a._addDestinationSettings(o,a._oDesigntimeInstance);}a._settingsModel=new J(a._oDesigntimeInstance.getSettings());a.setModel(a._settingsModel,"currentSettings");a.setModel(a._settingsModel,"items");return a._loadValueContextInDesigntime();}).then(function(){a._applyDesigntimeLayers();return a._requestExtensionData();}).then(function(){a._requireFields().then(function(){a._startEditor();});});};h1.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oEditorManifest){return new Promise(function(a,b){this.attachManifestReady(function(){this.loadDesigntime().then(a,b);}.bind(this));}.bind(this));}if(!this._sAppId){return Promise.reject("App id not maintained");}return new Promise(function(a,b){var s=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!s){s=this._oEditorManifest.get("/"+this.getSection()+"/designtime");}var e=this._sAppId.replace(/\./g,"/")+"/"+s;if(e){sap.ui.require([e],function(o){o=new o();o._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=o;a(o);}.bind(this));}.bind(this),function(){b({error:e+" not found"});});}else{b();}}.bind(this));};h1.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration";};h1.prototype.getCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={},a;if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable&&i.visible){if(this.getMode()!=="translation"){if(i.translatable&&!i._changed&&i._translatedPlaceholder&&!this._currentLayerManifestChanges[i.manifestpath]){continue;}else{if(i.valueItems){m[i.manifestpath.substring(0,i.manifestpath.lastIndexOf("/"))+"/valueItems"]=i.valueItems;}if(i.type!=="string"||!i.translatable){m[i.manifestpath]=i.value;}}}else if(i.translatable&&i.value){m[i.manifestpath]=i.value;}if(i._next&&(this.getAllowSettings())){var b=typeof(i.visibleToUser)==="undefined"?true:i.visibleToUser;var e=typeof(i.editableToUser)==="undefined"?true:i.editableToUser;if(i._next.visible===!b){a=a||{};a[i._settingspath+"/visible"]=i._next.visible;}if(i._next.editable===!e){a=a||{};a[i._settingspath+"/editable"]=i._next.editable;}if(i._next.pageAdminValues){a=a||{};a[i._settingspath+"/pageAdminValues"]=i._next.pageAdminValues;}if(typeof i._next.allowDynamicValues==="boolean"&&this.getAllowDynamicValues()){a=a||{};a[i._settingspath+"/allowDynamicValues"]=i._next.allowDynamicValues;}}}}}if(s.texts){m.texts={};for(var l in s.texts){m.texts[l]={};for(var j in s.texts[l]){m.texts[l][j]=s.texts[l][j];}}}if(this.getMode()!=="translation"){m[":multipleLanguage"]=true;}m[":layer"]=X.layers[this.getMode()];m[":errors"]=this.checkCurrentSettings()[":errors"];if(a){m[":designtime"]=a;}return m;};h1.prototype.checkCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),m={};if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable){if((i.isValid||i.required)&&!(this.getMode()==="translation"&&i.translatable)){if(i.isValid){m[i.manifestpath]=i.isValid(i);}m[i.manifestpath]=true;var a=i.value;var b=i.type;if(b==="string"&&a===""){m[i.manifestpath]=a;}if((b==="date"||b==="datetime")&&isNaN(Date.parse(a))){m[i.manifestpath]=a;}if(b==="integer"){if(isNaN(parseInt(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}if(b==="number"){if(isNaN(parseFloat(a))){m[i.manifestpath]=a;}else if(a<i.min||a>i.max){m[i.manifestpath]=a;}}}}}m[":layer"]=X.layers[this.getMode()];}m[":errors"]=Object.values(m).indexOf(false)>-1;return m;};h1.prototype._createContextModel=function(){var b=this.getHostInstance(),e=new J({}),i=new J([]);this.setModel(e,"context");this.setModel(i,"contextflat");e._aPendingPromises=[];i._getPathObject=function(s){var a=this.getData().filter(function(o){if(o.path===s){return true;}});return a.length?a[0]:null;};i._getValueObject=function(s){var a=this.getData()||[];a=a.filter(function(o){if(o.value===s||o.object.value===s){return true;}});return a.length?a[0]:null;};var j=new Promise(function(a,k){if(b&&b.getContext){var l=false;setTimeout(function(){if(l){return;}v.error("Editor context could not be determined with "+e1+".");l=true;a({});},e1);b.getContext().then(function(o){if(l){v.error("Editor context returned after more than "+e1+". Context is ignored.");}l=true;a(o||{});});}else{a({});}});j.then(function(o){var a=this._mergeContextData(o);e.setData(a);i.setData(this.flattenData(a,"label"));}.bind(this));e.getProperty=function(s,o){if(s&&!s.startsWith("/")&&!o){s="/"+s;}var a=this.resolve(s,o),k;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a];}this._mValues[a]=undefined;k=U.timeoutPromise(b.getContextValue(a.substring(1)));k=k.then(function(l){this._mValues[a]=l;this.checkUpdate();}.bind(this)).catch(function(l){this._mValues[a]=null;this.checkUpdate();v.error("Path "+a+" could not be resolved. Reason: "+l);}.bind(this));this._aPendingPromises.push(k);return undefined;}else{return J.prototype.getProperty.apply(this,arguments);}};};h1.prototype._mergeContextData=function(o){var a={};a["empty"]=h1._contextEntries.empty;for(var n in o){a[n]=o[n];}a["editor.internal"]=h1._contextEntries["editor.internal"];return a;};h1.prototype._loadValueContextInDesigntime=function(){var o=this.getModel("context");var s=this._oDesigntimeInstance.getSettings();var i;if(s&&s.form&&s.form.items){i=JSON.stringify(s.form.items);}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var b=i.match(a);var e;if(b&&b.length>0){b=b.filter(function(j){return j.endsWith("value}");});e=b.map(function(j){return j.substring("{context>".length,j.length-1);});e.forEach(function(j){o.getProperty(j);});return Promise.all(o._aPendingPromises).then(function(){o._aPendingPromises=[];});}}return Promise.resolve();};h1.fieldMap={"string":"sap/ui/integration/editor/fields/StringField","integer":"sap/ui/integration/editor/fields/IntegerField","number":"sap/ui/integration/editor/fields/NumberField","boolean":"sap/ui/integration/editor/fields/BooleanField","date":"sap/ui/integration/editor/fields/DateField","datetime":"sap/ui/integration/editor/fields/DateTimeField","string[]":"sap/ui/integration/editor/fields/ListField","destination":"sap/ui/integration/editor/fields/DestinationField"};h1.Fields=null;h1.prototype._requireFields=function(){if(h1.Fields){return Promise.resolve();}return new Promise(function(a){sap.ui.require(Object.values(h1.fieldMap),function(){h1.Fields={};for(var n in h1.fieldMap){h1.Fields[n]=arguments[Object.keys(h1.fieldMap).indexOf(n)];}a();});});};h1.prototype._createDescription=function(o){var a=new q({src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.addStyleClass("sapUiIntegrationEditorDescriptionIcon");a.onmouseover=function(a){this._getPopover().getContent()[0].applySettings({text:o.description});this._getPopover().openBy(a);a.addDependent(this._getPopover());}.bind(this,a);a.onmouseout=function(a){this._getPopover().close();a.removeDependent(this._getPopover());}.bind(this,a);return a;};h1.prototype._createMessageIcon=function(o){var a=o.getConfiguration();var m=new q({src:"sap-icon://message-information",size:"12px",visible:a.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});m.onmouseover=function(o){o._showMessage();}.bind(this,o);m.onmouseout=function(o){o._hideMessage();}.bind(this,o);m.addStyleClass("sapUiIntegrationEditorMessageIcon");return m;};h1.prototype._createLabel=function(o){var l=new L({text:o.label,tooltip:o.tooltip||o.label,required:o.required&&o.editable||false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});l._cols=o.cols||2;if(o.layout){l._layout=o.layout;}l._sOriginalType=o.type;return l;};h1.prototype._createSettingsButton=function(o){var a=o.getConfiguration();var s=new _({icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(e){this._openSettingsDialog(200,e.oSource,o);}.bind(this),visible:a.visible,objectBindings:{currentSettings:{path:"currentSettings>"+a._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return s;};h1.prototype._getSettingsPanel=function(o){if(!o._oSettingsPanel){o._oSettingsPanel=new Y();}return o._oSettingsPanel;};h1.prototype._openSettingsDialog=function(i,s,o){var a=this._getSettingsPanel(o);window.setTimeout(function(){a.setConfiguration(o.getConfiguration());var b=this.getAggregation("_preview");a.open(s,s,b,o.getHost(),o,o._applySettings.bind(o),o._cancelSettings.bind(o));}.bind(this),i||600);};h1.prototype._getPopover=function(){if(this._oPopover){return this._oPopover;}var o=new t({text:""});o.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new R({showHeader:false,content:[o]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover;};h1.prototype._createField=function(o){var a=new h1.Fields[o.type]({configuration:o,mode:this.getMode(),host:this.getHostInstance(),objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},visible:o.visible});this._aFieldReadyPromise.push(a._readyPromise.then(function(){if(o.require||o.validation||(o.validations&&o.validations.length>0)||(o.values&&o.values.data&&!o.values.data.json)){var m=this._createMessageIcon(a);a.setAssociation("_messageIcon",m);}if(o.description&&this.getMode()!=="translation"){a._descriptionIcon=this._createDescription(o);}if(o._changeDynamicValues){a._settingsButton=this._createSettingsButton(a);a._applyButtonStyles();}}.bind(this)));var b=this._settingsModel.bindProperty(o._settingspath+"/value");b.attachChange(function(){if(!this._bIgnoreUpdates){o._changed=true;if(o._dependentFields&&o._dependentFields.length>0){this._updateEditor(o._dependentFields);}this._updatePreview();}}.bind(this));if(a.isFilterBackend()){var s=this._settingsModel.bindProperty(o._settingspath+"/suggestValue");s.attachChange(function(){var e=g({},o);e._cancel=false;this._addValueListModel(e,a);}.bind(this));}if(o.values){if(o.type==="string[]"&&a.isFilterBackend()&&o.visualization&&o.visualization.type==="MultiInput"){a.setModel(new J({}),undefined);}else{this._addValueListModel(o,a);}}this._createDependentFields(o,a);a._cols=o.cols||2;if(o.layout){a._layout=o.layout;}a._oDataProviderFactory=this._oDataProviderFactory;a.setAssociation("_messageStrip",this.getAggregation("_messageStrip"));a._previewPostion=this.getPreviewPosition();return a;};h1.prototype._updateEditor=function(a){if(this._ready){if(a.length===0){return;}for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=true;}if(!this._oDataProviderFactory){return;}this._bIgnoreUpdates=true;for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=false;this._addValueListModel(o.config,o.field,500*i);}this._bIgnoreUpdates=false;}};h1.prototype._updatePreview=function(){var o=this.getAggregation("_preview");if(o&&o.update){o.update();}};h1.prototype._requestData=function(o,a){var b=this._oDataProviderFactory.create(o.values.data);b.bindObject({path:"items>/form/items"});b.bindObject({path:"currentSettings>"+o._settingspath});b.bindObject({path:"context>/"});var e=b.getData();e.then(function(m){if(o._cancel){o._values=[];this._settingsModel.setProperty(o._settingspath+"/_loading",false);return;}var s=o.values.data.path,z,i1=[];if(s&&s!=="/"){if(s.startsWith("/")){s=s.substring(1);}if(s.endsWith("/")){s=s.substring(0,s.length-1);}z=s.split("/");i1=O.get(z,m);}else{i1=m;}if(this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){var j1=o.pageAdminValues,k1=o.value,l1=o.valueItems,m1=[],n1=[],o1=[];this.prepareFieldsInKey(o);if(j1.length>0){for(var i=0;i<j1.length;i++){for(var j=0;j<i1.length;j++){var p1=this.getKeyFromItem(i1[j]);if(j1[i]===p1){m1.push(i1[j]);}}if(Array.isArray(k1)){for(var k=0;k<k1.length;k++){if(j1[i]===k1[k]){n1.push(k1[k]);}}for(var l=0;l<l1.length;l++){var q1=this.getKeyFromItem(l1[l]);if(j1[i]===q1){o1.push(l1[l]);}}}}if(n1.length>0){o.value=[];o.value=n1;}if(o1.length>0){o.valueItems=[];o.valueItems=o1;}}if(o.values.data.path&&o.values.data.path!=="/"){delete m[z];O.set(z,m1,m);}else{m=[];m=m1;}}var r1=a.getConfiguration();if(o.type==="string[]"){var s1=o.values.data.path;if(s1&&s1!=="/"){if(s1.startsWith("/")){s1=s1.substring(1);}if(s1.endsWith("/")){s1=s1.substring(0,s1.length-1);}var z=s1.split("/");var t1=O.get(z,m);if(Array.isArray(t1)){for(var n in t1){var u1=a.getKeyFromItem(t1[n]);if(Array.isArray(r1.value)&&r1.value.length>0&&N(r1.value,u1)){t1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{t1[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}O.set(z,t1,m);}}else if(Array.isArray(m)){for(var n in m){var u1=a.getKeyFromItem(m[n]);if(Array.isArray(r1.value)&&r1.value.length>0&&N(r1.value,u1)){m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED");}else{m[n].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED");}}}}o._values=m;var v1=a.getModel();v1.setData(m);v1.checkUpdate(true);v1.firePropertyChange();this._settingsModel.setProperty(o._settingspath+"/_loading",false);a._hideValueState(true,true);}.bind(this)).catch(function(i){this._settingsModel.setProperty(o._settingspath+"/_loading",false);var s=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){s=i[0];var j=i[1];if(j){var k;if(j.responseJSON){k=j.responseJSON.error;}else if(j.responseText){if(U.isJson(j.responseText)){k=JSON.parse(j.responseText).error;}else{s=j.responseText;}}if(k){s=(k.code||k.errorCode||j.status)+": "+k.message;}}}else if(typeof(i)==="string"){s=i;}var l=a.getModel();l.firePropertyChange();a._showValueState("error",s,true);}.bind(this));};h1.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){v.info("Extension is not defined or created, do not load data of it.");return new Promise(function(k,l){k();});}var b=false;var o={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var s;if(a){b=true;s=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");o={"extension":a};if(s){o.path=s;}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){b=true;s=this._oEditorManifest.get("/"+this.getSection()+"/data/path");o={"extension":a};if(s){o.path=s;}}}if(!b){v.info("Extension data is not defined in manifest, do not load data of it.");return new Promise(function(k,l){k();});}var i=this._oDataProviderFactory.create(o);var j=i.getData();return j.then(function(k){var l=e.getModel();if(!l){l=new J(k||{});e.setModel(l,undefined);}else{l.setData(k);}l.checkUpdate(true);}).catch(function(k){var l=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(k)&&k.length>0){l=k[0];var m=k[1];if(m){var n;if(m.responseJSON){n=m.responseJSON.error;}else if(m.responseText){if(U.isJson(m.responseText)){n=JSON.parse(m.responseText).error;}else{l=m.responseText;}}if(n){l=(n.code||n.errorCode||m.status)+": "+n.message;}}}else if(typeof(k)==="string"){l=k;}v.error("Request extension data failed, "+l);}.bind(this));};h1.prototype._addValueListModel=function(o,a,n){if(o.values){var b;if(o.values.data){if(this._oDataProviderFactory){b=a.getModel();if(!b){b=new J({});a.setModel(b,undefined);}this._settingsModel.setProperty(o._settingspath+"/_loading",true);if(!n){this._requestData(o,a);}else{setTimeout(function(){this._requestData(o,a);}.bind(this),n);}}a.bindObject({path:o.values.data.path||"/"});}else if(this.getAggregation("_extension")){b=this.getAggregation("_extension").getModel();if(b&&this.getMode()==="content"&&o.pageAdminValues&&o.pageAdminValues.length>0){this.prepareFieldsInKey(o);var e=o.values.path;if(e.length>1){e=e.substring(1);}var i=O.get([e],b.getData()),k=o.pageAdminValues,l=[];for(var m=0;m<k.length;m++){for(var j=0;j<i.length;j++){var s=this.getKeyFromItem(i[j]);if(k[m]===s){l.push(i[j]);}}}delete i[e];O.set(e,l,i);b.setData(i);}a.bindObject({path:o.values.path||"/"});a.setModel(b,undefined);}}};h1.prototype._createDependentFields=function(o,a){if(o.values){var s=JSON.stringify(o.values.data);if(s){var b=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,e=s.match(b);if(e){for(var i=0;i<e.length;i++){var j="/value";var k=this.getConfigurationPath();if(e[i].indexOf("destinations.")===0||e[i].indexOf("parameters.")===0){if(e[i].indexOf("destinations.")===0){j="/name";}k=k+e[i].replace(".","/")+"/"+j;}else if(e[i].indexOf("{items>")===0){k=k+"/parameters/"+e[i].slice(7,-1);}var l=this._mItemsByPaths[k];if(l){if(l._settingspath===o._settingspath){o=g({},o);}l._dependentFields=l._dependentFields||[];l._dependentFields.push({field:a,config:o});}}}}}};h1.prototype.getBeforeLayerChange=function(k){if(!this._beforeLayerManifestChanges){this._beforeLayerManifestChanges={};}return this._beforeLayerManifestChanges[k];};h1.prototype.getTranslationValueInTexts=function(l,k){var s="/texts/"+l;var o=this._settingsModel.getProperty(s)||{};return o[k];};h1.prototype._addItem=function(o){var m=this.getMode();if(this.getAllowDynamicValues()===false||!o.allowDynamicValues){o.allowDynamicValues=false;}if(this.getAllowSettings()===false){o.allowSettings=false;}o.__cols=o.cols||2;if(o.visible===false||(!o.translatable&&m==="translation"&&o.type!=="group")){return;}if(o.type==="group"){var a=new P({headerText:o.label,visible:o.visible,expandable:o.expandable!==false,expanded:o.expanded!==false,width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(k1){var l1=k1.getSource();if(!k1.mParameters.expand&&l1.getParent().getAggregation("_messageStrip")!==null){g1=l1.getParent().getAggregation("_messageStrip").getId();}if(k1.mParameters.expand){var m1=c.byId(g1);l1.addContent(m1);l1.focus();}}});this.addAggregation("_formContent",a);a._cols=o.cols||2;if(o.hint){this._addHint(o.hint);}var b={onAfterRendering:function(){var k1=document.getElementById(a.getId());k1.setAttribute("aria-label",o.label);}};a.addEventDelegate(b);return;}if(o.type==="separator"){var s=new S();this.addAggregation("_formContent",s);return;}var n=null;var l=c.getConfiguration().getLanguage().replaceAll('_','-');if(m==="translation"){if((typeof o.value==="string"&&o.value.indexOf("{")===0)||typeof o.values!=="undefined"){return;}o._language={value:o.value};o.cols=1;delete o.values;var e=d(o,500);e._settingspath+="/_language";e.editable=false;e.required=false;if(!h1._languages[l]&&l.indexOf("-")>-1){l=l.substring(0,l.indexOf("-"));}if(h1._languages[l]){var i=this.getTranslationValueInTexts(l,o.manifestpath);if(i){e.value=i;}}if(!e.value){e.value="-";}var j=this._createLabel(e);this.addAggregation("_formContent",j);var k=this._createField(e);k.isOrigLangField=true;this.addAggregation("_formContent",k);o.editable=o.visible=o.translatable;l=this._language;if(!this.getBeforeLayerChange(o.manifestpath)){o.value=o._translatedValue||"";}var i=this.getTranslationValueInTexts(l,o.manifestpath);if(i){o.value=i;}o.label=o._translatedLabel||"";o.required=false;var z=this._createField(o);this.addAggregation("_formContent",z);}else{n=this._createLabel(o);this.addAggregation("_formContent",n);var i1=this.getBeforeLayerChange(o.manifestpath);if(i1){o._beforeLayerChange=i1;}if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges[o.manifestpath]){o.value=this._currentLayerManifestChanges[o.manifestpath];o._beforeLayerChange=o.value;}l=this._language;var i=this.getTranslationValueInTexts(l,o.manifestpath);if(i){o.value=i;}var j1=this._createField(o);this.addAggregation("_formContent",j1);}if(o.hint&&(!o.cols||o.cols===2)){this._addHint(o.hint);}o.cols=o.__cols;delete o.__cols;};h1.prototype._createHint=function(s){s=s.replace(/<a href/g,"<a target='blank' href");var o=new G({htmlText:s});return o;};h1.prototype._addHint=function(s){var o=this._createHint(s);this.addAggregation("_formContent",o);};h1.prototype._getCurrentLanguageSpecificText=function(k){var l=this._language;if(this._oTranslationBundle){var s=this._oTranslationBundle.getText(k,[],true);if(s===undefined){return"";}return s;}if(!l){return"";}var i=this._oEditorManifest.get("/sap.app/i18n");if(!i){return"";}if(typeof i==="string"){var a=[l];if(l.indexOf("-")>-1){a.push(l.substring(0,l.indexOf("-")));}if(!N(a,"en")){a.push("en");}this._oTranslationBundle=x.create({url:this.getBaseUrl()+i,async:false,locale:l,supportedLocales:a,fallbackLocale:"en"});return this._getCurrentLanguageSpecificText(k);}};h1.prototype._startEditor=function(){var o=this.getAggregation("_formContent");if(o&&o.length>0){this.destroyAggregation("_formContent");}var s=this._settingsModel.getProperty("/");var i;if(s.form&&s.form.items){i=s.form.items;var l=this._language||this.getLanguage()||c.getConfiguration().getLanguage().replaceAll('_','-');if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+h1._languages[l]});}var a=false;for(var m in i){var b=i[m];if(b.type==="group"){break;}else if(b.visible){a=true;break;}}if(a){this._addItem({type:"group",translatable:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS")});}this._mItemsByPaths={};for(var n in i){var b=i[n];if(b){b.label=b.label||n;var e;if(b.manifestpath){this._mItemsByPaths[b.manifestpath]=b;if(this.getMode()!=="translation"){e=this._currentLayerManifestChanges[b.manifestpath];}}b._changed=e!==undefined&&this.getMode()!=="translation";if(b.values){b.translatable=false;}b._beforeValue=this._getManifestBeforelValue(b.manifestpath);if(b.type==="string"){b._translatedDefaultPlaceholder=this._getManifestDefaultValue(b.manifestpath);var j=null,k=b._translatedDefaultPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}if(j){b.translatable=true;}else if(b.translatable&&this.getMode()==="translation"&&!this.getBeforeLayerChange(b.manifestpath)){b._translatedValue=b._translatedDefaultPlaceholder;b.value=b._translatedValue;}}b._translatedPlaceholder=b._beforeValue;k=b._translatedPlaceholder;if(k){if(this._isValueWithParameterSyntax(k)){b.translatable=false;}if(this._isValueWithHandlebarsTranslation(k)){j=k.substring(2,k.length-2);}else if(k.startsWith("{i18n>")){j=k.substring(6,k.length-1);}}var z=this.getTranslationValueInTexts(l,b.manifestpath);if(j){b._translatedValue=this.getModel("i18n").getResourceBundle().getText(j);if(b._changed){b.value=e;}else if(b.value===b._translatedDefaultPlaceholder){b.value=b._translatedValue;}if(this.getMode()==="translation"){var i1=this._getCurrentLanguageSpecificText(j);if(i1!==""){b._translatedValue=i1;}}else if(z){b.value=z;}}else if(this.getMode()!=="translation"&&b.translatable&&z){b.value=z;}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(b.label)){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(2,b.label.length-2),true);}else if(b.label&&b.label.startsWith("{i18n>")){b._translatedLabel=this._getCurrentLanguageSpecificText(b.label.substring(6,b.label.length-1),true);}}}else if(b.type==="string[]"){var j1=b.manifestpath.substring(0,b.manifestpath.lastIndexOf("/"))+"/valueItems";var k1=this._manifestModel.getProperty(j1);if(k1){b.valueItems=k1;}var l1=b.manifestpath.substring(0,b.manifestpath.lastIndexOf("/"))+"/valueTokens";var m1=this._manifestModel.getProperty(l1);if(m1){b.valueTokens=m1;}}if(b.label&&this._isValueWithHandlebarsTranslation(b.label)){var n1=b.label.substring(2,b.label.length-2);if(n1){b.label=this.getModel("i18n").getResourceBundle().getText(n1);}}}}}for(var n in i){var b=i[n];this._addItem(b);}if(this.getMode()!=="translation"){Promise.resolve(this._initPreview()).then(function(){Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}.bind(this));}else{Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}};h1.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}var o=this.getAggregation("_preview");if(o&&o.destroy){o.destroy();}var m=c.byId(g1);if(m){m.destroy();}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;C.prototype.destroy.apply(this,arguments);};h1.prototype._initPreview=function(){return new Promise(function(a,b){a();});};h1.prototype._applyDesigntimeDefaults=function(s){s=s||{};s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items||s.form.items;for(var n in i){var o=i[n];if(o.manifestpath){o.value=this._manifestModel.getProperty(o.manifestpath);}if(o.visible===undefined||o.visible===null){o.visible=true;}if(o.editable===undefined||o.editable===null){o.editable=true;}if(this.getMode()!=="admin"){if(o.visibleToUser!==undefined){o.visible=o.visibleToUser;}if(o.editableToUser!==undefined){o.editable=o.editableToUser;}}if(typeof o.translatable!=="boolean"){o.translatable=false;}if(!o.label){o.label=n;}if(!o.type||o.type==="enum"){o.type="string";}if(o.value===undefined||o.value===null){switch(o.type){case"boolean":o.value=false;break;case"integer":case"number":o.value=0;break;case"string[]":o.value=[];break;default:o.value="";}}if(o.type==="group"){if(o.visible===undefined||o.value===null){o.visible=true;}}o._settingspath="/form/items/"+n;}};h1.prototype._applyDesigntimeLayers=function(s){var o={};if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var i=0;i<this._appliedLayerManifestChanges.length;i++){var a=this._appliedLayerManifestChanges[i][":designtime"];if(a){var k=Object.keys(a);for(var j=0;j<k.length;j++){this._settingsModel.setProperty(k[j],a[k[j]]);}}var b=this._appliedLayerManifestChanges[i]["texts"];if(b){o=g(o,b);}}}if(this._currentLayerManifestChanges){var a=this._currentLayerManifestChanges[":designtime"];if(a){var k=Object.keys(a);for(var j=0;j<k.length;j++){var e=k[j],n=e.substring(0,e.lastIndexOf("/")+1)+"_next";if(!this._settingsModel.getProperty(n)){this._settingsModel.setProperty(n,{});}var n=e.substring(0,e.lastIndexOf("/")+1)+"_next",l=e.substring(e.lastIndexOf("/")+1);this._settingsModel.setProperty(n+"/"+l,a[k[j]]);}}var m=this._currentLayerManifestChanges["texts"];if(m){o=g(o,m);}}if(!f(o,{})){this._settingsModel.setProperty("/texts",o);}};h1.prototype._createParameterDesigntime=function(o){var s={},b=this.getConfigurationPath()+"/parameters",m=this.getMode();if(o&&o.parameters){s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items;Object.keys(o.parameters).forEach(function(n){i[n]=g({manifestpath:b+"/"+n+"/value",editable:(m!=="translation"),_settingspath:"/form/items/"+n},o.parameters[n]);var a=i[n];if(!a.type){a.type="string";}if(!a.hasOwnProperty("visible")){a.visible=true;}});}return new D(s);};h1.prototype._addDestinationSettings=function(o){var s=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";s.form=s.form||{};s.form.items=s.form.items||{};if(s&&o&&o.destinations){if(!s.form.items["destination.group"]){s.form.items["destination.group"]={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",visible:true};}var j=s.form.items,k=this.getHostInstance();Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]=g({manifestpath:i+"/"+n+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:o.destinations[n].name,defaultValue:o.destinations[n].defaultUrl,_settingspath:"/form/items/"+[n+".destinaton"],_values:[],_destinationName:n},o.destinations[n]);if(typeof j[n+".destinaton"].label==="undefined"){j[n+".destinaton"].label=n;}if(k){j[n+".destinaton"]._loading=true;}});var l=false;if(k){this.getHostInstance().getDestinations().then(function(a){l=true;Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=a;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(){return this.getHostInstance().getDestinations();}.bind(this)).then(function(b){if(l){return;}Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._values=b;j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));}.bind(this)).catch(function(e){Object.keys(o.destinations).forEach(function(n){j[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);}.bind(this));v.error("Can not get destinations list from '"+k.getId()+"'.");}.bind(this));}}};h1.prototype._getManifestDefaultValue=function(s){return this._oInitialManifestModel.getProperty(s);};h1.prototype._getManifestBeforelValue=function(s){return this._beforeManifestModel.getProperty(s);};h1.prototype._isValueWithHandlebarsTranslation=function(a){if(typeof a==="string"){return!!a.match(c1);}return false;};h1.prototype._isValueWithParameterSyntax=function(a){if(typeof a==="string"){return!!a.match(d1);}return false;};h1._contextEntries={empty:{label:f1.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:f1.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:f1.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:f1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:f1.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:f1.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:f1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:f1.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:f1.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:f1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:f1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:f1.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};h1._languages={};h1._appendThemeVars=function(){var a=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var m=F.get({name:a,callback:function(b){}});if(m){for(var n in m){document.body.style.setProperty("--"+n,m[n]);}}};h1.prototype.prepareFieldsInKey=function(o){this._sKeySeparator=o.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#";}var k=o.values.item.key;this._aFields=k.split(this._sKeySeparator);for(var n in this._aFields){if(this._aFields[n].startsWith("{")){this._aFields[n]=this._aFields[n].substring(1);}if(this._aFields[n].endsWith("}")){this._aFields[n]=this._aFields[n].substring(0,this._aFields[n].length-1);}}};h1.prototype.getKeyFromItem=function(i){var s="";this._aFields.forEach(function(a){s+=i[a].toString()+this._sKeySeparator;}.bind(this));if(s.endsWith(this._sKeySeparator)){s=s.substring(0,s.length-this._sKeySeparator.length);}return s;};h1.init=function(){this.init=function(){};h1._appendThemeVars();c.attachThemeChanged(function(){h1._appendThemeVars();});var s=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");A(s);B.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(o){h1._languages=o;});};h1.init();return h1;});
