/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Button","sap/m/FormattedText","sap/m/MultiInput","sap/m/Token","sap/ui/core/Core","sap/ui/integration/util/BindingHelper","sap/ui/core/ListItem","sap/base/util/ObjectPath","sap/ui/integration/util/Utils","sap/base/util/deepEqual","sap/m/MessageToast"],function(C,B,F,M,T,a,c,L,O,U,d,e){"use strict";var r=a.getLibraryResourceBundle("sap.ui.integration"),s="sap/ui/integration/editor/fields/viz";var g=C.extend("sap.ui.integration.editor.fields.BaseField",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{_messageIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"}},events:{afterInit:{}}},renderer:function(R,o){var f=o.getAggregation("_field"),D=o._getDynamicField();R.openStart("div");R.addClass("sapUiIntegrationEditorItemField");if(f&&f.getWidth){}if(!o.getVisible()){R.addStyle("display","none");}R.writeElementData(o);R.openEnd();if(o.getVisible()){R.openStart("span");R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationEditorEditor");if(o._hasDynamicValue()){R.addStyle("width","1px");R.addStyle("opacity","0");}else{R.addStyle("width","100%");}R.openEnd();R.renderControl(f);R.close("span");R.close("span");if(o._hasDynamicValue()){R.openStart("span");R.addClass("sapUiIntegrationEditorSettings");R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationEditorSettingsField");R.addStyle("width","100%");R.addStyle("opacity","1");R.openEnd();R.renderControl(D);R.close("span");}R.openStart("div");R.writeAttribute("id",o.getId()+"-ms");R.addStyle("height","0");R.openEnd();R.close("div");}R.close("div");}});g.prototype.init=function(){this._readyPromise=new Promise(function(b){this._fieldResolver=b;}.bind(this));};g.prototype.getMessagestrip=function(){var m=this.getAssociation("_messageStrip");return a.byId(m);};g.prototype.getMessageIcon=function(){var m=this.getAssociation("_messageIcon");return a.byId(m);};g.prototype._removeValidationMessage=function(){var f=this.control,m=f.getParent().getMessageIcon();if(m){m.setVisible(false);}if(f.getEnabled()){f.setEnabled(false);}};g.prototype.setConfiguration=function(o,S){if(r&&r.sLocale!==a.getConfiguration().getLanguage()){r=a.getLibraryResourceBundle("sap.ui.integration");}if(o!==this.getConfiguration()){this._sanitizeValidationSettings(o);this.setProperty("configuration",o,S);if(o){Promise.resolve().then(function(){this.initEditor(o);}.bind(this));}}return this;};g.prototype._sanitizeValidationSettings=function(o){o.validations=o.validations||[];if(o.validation&&o.validations&&Array.isArray(o.validations)){o.validations.push(o.validation);delete o.validation;}if(o.validation&&!o.validations){o.validations=[o.validation];delete o.validation;}if(o.required){o.validations.unshift({"required":true,"type":"error"});}};g.prototype._triggerValidation=function(v){if(d(v,this._preChangedValue)&&this._messageFrom==="validation"){return;}this._preChangedValue=v;var o=this.getConfiguration();var b=false;if(o.required){b=true;}else if(o.type==="string"&&v){b=true;}else if((o.type==="integer"||o.type==="number")&&!isNaN(v)){if(v!==""){b=true;}}else if(o.type==="boolean"){b=true;}else if(o.type==="string[]"&&Array.isArray(v)){b=true;}if(o.validations&&Array.isArray(o.validations)&&b){for(var i=0;i<o.validations.length;i++){if(!this._handleValidation(o.validations[i],v)){return false;}}this._hideValueState();}return true;};g.validations={string:{maxLength:function(v,m){return v.length<=m;},maxLengthTxt:"EDITOR_VAL_MAXLENGTH",minLength:function(v,m){return v.length>=m;},minLengthTxt:"EDITOR_VAL_MINLENGTH",pattern:function(v,b){var p=new RegExp(b);return p.test(v);},patternTxt:"EDITOR_VAL_NOMATCH",required:function(v,b){return b&&!!v;},requiredTxt:"EDITOR_VAL_TEXTREQ",validateTxt:"EDITOR_VAL_NOMATCH"},"string[]":{maxLength:function(v,m){return Array.isArray(v)&&v.length<=m;},maxLengthTxt:"EDITOR_VAL_LISTMAXLENGTH",minLength:function(v,m){return Array.isArray(v)&&v.length>=m;},minLengthTxt:"EDITOR_VAL_LISTMINLENGTH",required:function(v,b){return Array.isArray(v)&&v.length>0;},requiredTxt:"EDITOR_VAL_LISTREQ"},integer:{maximum:function(v,b,f){if(f.exclusiveMaximum){f._txt="maximumExclusiveTxt";return v<b;}return v<=b;},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(v,b,f){if(f.exclusiveMinimum){f._txt="minimumExclusiveTxt";return v>b;}return v>=b;},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MIN_E",multipleOf:function(v,b){return(v%b)===0;},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(v,b){return!isNaN(v)&&v!=="";},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},number:{maximum:function(v,b,f){if(f.exclusiveMaximum){f._txt="maximumExclusiveTxt";return v<b;}return v<=b;},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(v,b,f){if(f.exclusiveMinimum){f._txt="minimumExclusiveTxt";return v>b;}return v>=b;},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MAX_E",multipleOf:function(v,b){return(v%b)===0;},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(v,b){return!isNaN(v)&&v!=="";},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"}};g.prototype._requestData=function(R){var f=this.control.getParent();var o=f.getConfiguration();var D=f._oDataProviderFactory.create(R.data);f.getModel("currentSettings").setProperty(o._settingspath+"/_loading",true);var p=D.getData();return p.then(function(b){f.getModel("currentSettings").setProperty(o._settingspath+"/_loading",false);var P=R.data.path||"/";if(P.startsWith("/")){P=P.substring(1);}if(P.endsWith("/")){P=P.substring(0,P.length-1);}var h=P.split("/");var i=O.get(h,b);return i;});};g.prototype._handleValidation=function(S,v){var o=this.getConfiguration(),V=g.validations[o.type];var f=function(n,D){var E;if(typeof S.message==="function"){E=S.message(v,o,D);}else{E=S.message;}if(!E){if(S._txt){E=r.getText(V[S._txt],[S[n]]);}else{E=r.getText(V[n+"Txt"],[S[n]]);}}this._showValueState(S.type||"error",E);}.bind(this);if(S["validate"]){var b={control:this.getAggregation("_field"),requestData:this._requestData,removeValidationMessage:this._removeValidationMessage};var h=S["validate"];Promise.resolve(h(v,o,b)).then(function(j){var I=j.isValid;if(typeof I==="undefined"){I=j;}var D=j.data?j.data:undefined;if(!I){f("validate",D);return false;}else{this._hideValueState(true,false);return true;}}.bind(this));}else{for(var n in S){if(V){var i=V[n];S._txt="";if(i){if(!i(v,S[n],S)){f(n);return false;}}}}}return true;};g.prototype.onAfterRendering=function(){this._applyMessage();var m=this.getMessagestrip();if(m&&m.getDomRef()){m.getDomRef().style.opacity="0";}};g.prototype._applyMessage=function(){var i=a.byId(this.getAssociation("_messageIcon"));if(this.getAssociation("_messageIcon")&&i){var I=i.getDomRef();if(I){I.classList.remove("error");I.classList.remove("warning");I.classList.remove("success");if(this._message){I.classList.add(this._message.type);}}}};g.prototype._showValueState=function(t,m,f){var o=this.getAggregation("_field"),E=t.substring(0,1).toUpperCase()+t.substring(1);this._message={"enum":E,"type":t,"message":m,"atControl":false};this._messageFrom="validation";if(f){this._messageFrom="request";}var b=this.getMessagestrip();if(o&&o.setValueState){this._message.atControl=true;if(o.setShowValueStateMessage){o.setShowValueStateMessage(false);}o.setValueState(E);o.setValueStateText(m);}else if(b&&b.getVisible()&&o.getMetadata().getName()!=="sap.m.Switch"){this._showMessage();}this._applyMessage();};g.prototype._hideValueState=function(f,t){if(!this.getParent()){return;}var m=this.getMessagestrip();if(this._message){if((f&&this._messageFrom==="request")||(!f&&this._messageFrom==="validation")){var o=this.getAggregation("_field");this._message={"enum":"Success","type":"success","message":"Corrected","atControl":this._message.atControl};this._messageFrom="validation";if(f){this._messageFrom="request";}if(this._messageto){clearTimeout(this._messageto);}this._messageto=setTimeout(function(){this._messageto=null;this._applyMessage();if(!this._message&&o.setValueState){o.setValueState("None");}}.bind(this),1500);this._applyMessage();if(m){if(m.getDomRef()){m.getDomRef().style.opacity="0";}m.onAfterRendering=null;}if(o.setValueState){o.setValueState("Success");}if(o.setValueStateText){o.setValueStateText("");}this._message=null;}if(!this._message&&f&&t){this._triggerValidation(this.getConfiguration().value);}}};g.prototype.onfocusin=function(E){if(E&&E.target.classList.contains("sapMBtn")){return;}this._showMessage();};g.prototype.onfocusout=function(E){this._hideMessage();};g.prototype._showMessage=function(){if(!this.getParent()){return;}var m=this.getMessagestrip();if(this._message&&m){m.applySettings({type:this._message.enum,text:this._message.message});var t=this;m.onAfterRendering=function(){m.getDomRef().style.zIndex="1";m.getDomRef().style.opacity="1";t.getDomRef("ms")&&t.getDomRef("ms").appendChild(m.getDomRef());var f=t.getAggregation("_field");if(t._message&&!t._message.atControl){m.getDomRef().style.marginTop="0";m.getDomRef().style.marginLeft="0";}var w=f.getDomRef().offsetWidth-5;if(w<100){w=f.getParent().getDomRef().offsetWidth-35;}m.getDomRef().style.width=w+"px";};m.rerender();}};g.prototype._hideMessage=function(){var m=this.getMessagestrip();var f=this.getAggregation("_field"),b=f.getDomRef()&&f.getDomRef().contains(window.document.activeElement);if(m){if(!b&&m.getDomRef()){m.getDomRef().style.opacity="0";m.getDomRef().style.zIndex="-1";}m.onAfterRendering=null;}};g.prototype.initEditor=function(o){var b;this.initVisualization&&this.initVisualization(o);if(this._visualization.editor){b=this._visualization.editor;}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=s+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:o.editable};}sap.ui.require([this._visualization.type],function(f){this._visualization.type=f;this.initEditor(o);}.bind(this));return;}b=new this._visualization.type(this._visualization.settings||{});}if(b instanceof C){this.setAggregation("_field",b);if(b.attachChange){b.attachChange(function(E){if(E.mParameters.value===""){var o=this.getConfiguration();if(o.type==="string[]"){this._triggerValidation(o.value);}else{this._triggerValidation(E.getParameter("value"));}}}.bind(this));}var h=this.getModel("currentSettings").bindProperty("value",this.getBindingContext("currentSettings"));h.attachChange(function(){this._triggerValidation(o.value);}.bind(this));this._triggerValidation(o.value);}var m=this.getMode();o.allowSettings=o.allowSettings||o.allowSettings!==false&&m==="admin";o.allowDynamicValues=o.allowDynamicValues||o.allowDynamicValues!==false;o._changeDynamicValues=o.visible&&o.editable&&(o.allowDynamicValues||o.allowSettings)&&m!=="translation";if(o._changeDynamicValues){this._getDynamicField();}this._applySettings(o);this.fireAfterInit();};g.prototype.initVisualization=function(){};g.prototype._hasDynamicValue=function(){var v=this._getCurrentProperty("value");var D=typeof v==="string"&&(v.indexOf("{context>")===0||v.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",D);return D;};g.prototype._hasSettings=function(){var o=this.getConfiguration();if(o._next){var v=o.hasOwnProperty("visibleToUser")?o.visibleToUser:true;var E=o.hasOwnProperty("editableToUser")?o.editableToUser:true;var b=o._next.visible===false?false:o._next.editable;var A=o.hasOwnProperty("allowDynamicValues")?o.allowDynamicValues:true;o._hasSettings=(o._next.visible===!v||b===!E||o._next.allowDynamicValues===!A);}else{o._hasSettings=false;if(o.hasOwnProperty("editableToUser")||o.hasOwnProperty("visibleToUser")){o._next={};}if(o.hasOwnProperty("editableToUser")){o._next.editable=o.editableToUser;}if(o.hasOwnProperty("visibleToUser")){o._next.visible=o.visibleToUser;}}return o._hasSettings;};g.prototype._getDynamicField=function(){var f=this.getAggregation("_dynamicField");if(!f){var f=new M({showValueHelp:false});this.setAggregation("_dynamicField",f);}return f;};g.prototype._hideDynamicField=function(){var D=this._getDynamicField(),f=this.getAggregation("_field");if(D.getDomRef()){var S=D.getDomRef().parentNode.style;S.width="1px";S.opacity=0;S=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="visible";S.width="100%";S.opacity=1;}};g.prototype._showDynamicField=function(){var D=this._getDynamicField(),f=this.getAggregation("_field");if(D.getDomRef()){var S=D.getDomRef().parentNode.style;S.width="100%";S.opacity=1;S=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="hidden";S.width="1px";S.opacity=0;}};g.prototype._setCurrentProperty=function(p,v){if(this._getCurrentProperty(p)!==v){this.getModel("currentSettings").setProperty(p,v,this.getBindingContext("currentSettings"));}};g.prototype._getCurrentProperty=function(p){return this.getModel("currentSettings").getProperty(p,this.getBindingContext("currentSettings"));};g.prototype._applySettings=function(D){var b=this._getDynamicField(),o=this.getModel("contextflat")._getValueObject(D.value);b.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){b.setEnabled(false);}if(o&&o.path!=="empty"){if(o.object.value&&o.object.value.indexOf("{{")==0){this._setCurrentProperty("value",o.object.value);}else{this._setCurrentProperty("value",o.value);}b.addToken(new T({text:o.object.label,"delete":function(){this._setCurrentProperty("value","");if(!this._hasDynamicValue()){this._hideDynamicField();}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus();}.bind(this),100);}.bind(this)}));}else{this._setCurrentProperty("value",D.value);this._setCurrentProperty("_changed",D._changed);this._hideDynamicField();}this._setCurrentProperty("_next",D._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}else{this._showDynamicField();}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null;};g.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}};g.prototype._applyButtonStyles=function(){if(!this._settingsButton){return;}if(!this._hasDynamicValue()){this._settingsButton.removeStyleClass("dynamicvalue");}else{this._settingsButton.addStyleClass("dynamicvalue");}if(!this._hasSettings()){this._settingsButton.removeStyleClass("settings");}else{this._settingsButton.addStyleClass("settings");}};g.prototype.isFilterBackend=function(){var o=this.getConfiguration();var i=false;if(o&&o.values&&o.values.data){if(o.values.data.request&&o.values.data.request.parameters&&o.values.data.request.parameters.$filter&&o.values.data.request.parameters.$filter.indexOf("{currentSettings>suggestValue}")>-1){i=true;}else if(o.values.data.request&&o.values.data.request.url&&o.values.data.request.url.indexOf("{currentSettings>suggestValue}")>-1){i=true;}}return i;};g.prototype.formatListItem=function(i){var I=new L();for(var k in i){I.bindProperty(k,c.createBindingInfos(i[k]));}return I;};return g;});
