/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/integration/util/DataProviderFactory","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/base/util/LoaderExtensions","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/CardObserver"],function(C,F,A,I,q,a,b,S,L,m,d,D,H,c,T,J,O,R,f,g,h,l,i,j,k,n,o,B,p,r,s,t){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",CSRF_TOKENS:"/sap.card/configuration/csrfTokens",FILTERS:"/sap.card/configuration/filters"};var u=["parameters","filters","form","context","i18n"];var v=["visibleItems","allItems"];var w=l.cards.HeaderPosition;var x=i.CardDataMode;var y="Card is destroyed!";var z=i.CardArea;var E=h.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:x.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.integration.cards.filters.FilterBar",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{}},associations:{host:{}}},renderer:C});E.prototype.init=function(){h.prototype.init.call(this);this.setAggregation("_loadingProvider",new k());this.setModel(new J());this.setModel(new J(),"parameters");this.setModel(new J(),"filters");this.setModel(new J(),"form");this.setModel(new f(),"context");this._oContentFactory=new o(this);this._oCardObserver=new t(this);this._bFirstRendering=true;this._aFundamentalErrors=[];if(this.getProperty("dataMode")===x.Auto){this._oCardObserver.createObserver(this);}this._oLimitedInterface=new I(this,["getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders"]);};E.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};E.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};E.prototype.onBeforeRendering=function(){if(this.getDataMode()!==x.Active){return;}this.startManifestProcessing();};E.prototype.onAfterRendering=function(){var e=this.getDomRef();if(this.getDataMode()===x.Auto&&this._bFirstRendering){this._oCardObserver.oObserver.observe(e);}this._bFirstRendering=false;};E.prototype.startManifestProcessing=function(){if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var e=this.getManifest();if(!e){this.destroyManifest();}else{this.createManifest(e,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu();};E.prototype.setManifest=function(V){this.setProperty("manifest",V);this.destroyActionDefinitions();this._bApplyManifest=true;return this;};E.prototype.setManifestChanges=function(V){this.setProperty("manifestChanges",V);this._bApplyManifest=true;return this;};E.prototype.setParameters=function(V){this.setProperty("parameters",V);this._bApplyParameters=true;return this;};E.prototype.setParameter=function(K,V){var P=this.getParameters()||{};P[K]=V;this.setParameters(P);return this;};E.prototype.setHost=function(e){this.setAssociation("host",e);var G=this.getHostInstance();if(e&&!G){L.error("Host with id '"+e+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this;}this.getModel("context").setHost(G);if(this._oDestinations){this._oDestinations.setHost(G);}if(this._oDataProviderFactory){this._oDataProviderFactory.setHost(G);}if(G&&G.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching");}else{this.removeStyleClass("sapFCardExperimentalCaching");}return this;};E.prototype.createManifest=function(G,K){var N={};this._isManifestReady=false;if(typeof G==="string"){N.manifestUrl=G;G=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this.destroyAggregation("_extension");this._oCardManifest=new b("sap.card",G,K,this.getManifestChanges());this._oCardManifest.load(N).then(function(){if(this.bIsDestroyed){throw new Error(y);}this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(this._applyManifest.bind(this)).catch(function(e){if(e.message!==y){this._applyManifest();return;}this._logFundamentalError(e.message);}.bind(this));};E.prototype._loadExtension=function(){var e=this._oCardManifest.get("/sap.card/extension");if(!e){return null;}var G=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+e;return new Promise(function(K,N){sap.ui.require([G],function(P){var Q=new P();Q._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",Q);K();}.bind(this),function(P){this._logFundamentalError("Failed to load "+e+". Check if the path is correct. Reason: "+P);N(P);});}.bind(this));};E.prototype._logFundamentalError=function(e){L.error(e);this._aFundamentalErrors.push(e);};E.prototype.getFundamentalErrors=function(){return this._aFundamentalErrors;};E.prototype._applyManifest=function(){var e=this._oCardManifest;if(!e.get("/sap.card")){this._logFundamentalError("There must be a 'sap.card' section in the manifest.");}if(e&&e.getResourceBundle()){this._enhanceI18nModel(e.getResourceBundle());}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._resolveContextParams().then(function(G){this._oContextParameters=G;this._applyManifestWithParams();}.bind(this));return;}this._applyManifestWithParams();};E.prototype._applyManifestWithParams=function(){var e=this._oCardManifest,P=this._getContextAndRuntimeParams();e.processParameters(P);this._prepareToApplyManifestSettings();this._applyManifestSettings();};E.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var e=a.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(e);this._defaultTranslationsLoaded=true;this._oIntegrationRb=e;};E.prototype._enhanceI18nModel=function(e){var G=this.getModel("i18n");if(G){if(G.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){G.enhance(e);}return;}G=new R({bundle:e});this.setModel(G,"i18n");};E.prototype._hasContextParams=function(){var e=this._oCardManifest.get(M.PARAMS),K,V;for(K in e){V=e[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){return true;}}return false;};E.prototype._resolveContextParams=function(){var e=this.getModel("context"),G=this._oCardManifest.get(M.PARAMS),K={},N,V;for(N in G){V=G[N].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){K[N]=V;}}B.resolveValue(K,this,"/");return e.waitForPendingProperties().then(function(){return B.resolveValue(K,this,"/");}.bind(this));};E.prototype._getContextAndRuntimeParams=function(){var e=this._oContextParameters||{},G=this.getParameters()||{};return m(e,G);};E.prototype._awaitEvent=function(e){this._aReadyPromises.push(new Promise(function(G){this.attachEventOnce(e,function(){G();});}.bind(this)));};E.prototype.isReady=function(){return this._bReady;};E.prototype.refresh=function(){if(this.getDataMode()===x.Active){this._bApplyManifest=true;this.invalidate();}};E.prototype.refreshData=function(){var e=this.getCardHeader(),G=this.getCardContent(),K=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate();}if(e){e.refreshData();}if(G&&G.isA("sap.ui.integration.cards.BaseContent")){G.refreshData();}else{this.destroyAggregation("_content");this._applyContentManifestSettings();}if(K){K.refreshData();}};E.prototype._refreshActionsMenu=function(){var e=this.getCardHeader(),G=this.getHostInstance(),K=this.getAggregation("_extension"),N=[];if(!e){return;}if(G){N=N.concat(G.getActions()||[]);}if(K){N=N.concat(K.getActions()||[]);}if(d(N,this._getActionsToolbar()._aActions)){return;}this._getActionsToolbar().initializeContent(this);};E.prototype.exit=function(){h.prototype.exit.call(this);this.destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oContentFactory=null;this._bFirstRendering=null;if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null;}};E.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this.destroyAggregation("_footer");this._aReadyPromises=null;this.getModel("filters").setData({});this.getModel("parameters").setData({});this._oContextParameters=null;this._deregisterCustomModels();};E.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){g.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl()||"/");}else{this._logFundamentalError("Card sap.app/id entry in the manifest is mandatory");}};E.prototype.getManifest=function(){var V=this.getProperty("manifest");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};E.prototype.getParameters=function(){var V=this.getProperty("parameters");if(V&&typeof V==="object"){return q.extend(true,{},V);}return V;};E.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},K;for(K in P){e[K]=P[K].value;}return e;};E.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};E.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return this._oCardManifest.getInitialJson();};E.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};E.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};E.prototype.showMessage=function(e,G){var K=this.getCardContent();if(!K||!K.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}K.showMessage(e,G);};E.prototype.getTranslatedText=function(K,e,G){var N=this.getModel("i18n"),P;if(!N){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}P=N.getResourceBundle();return P.getText(K,e,G);};E.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){L.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null;}return this._oDataProviderFactory;};E.prototype.getRuntimeUrl=function(U){var e=this._sAppId,G,K=U&&U.trim().replace(/^\//,"");if(e===null){L.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}if(!e||U.startsWith("http://")||U.startsWith("https://")||U.startsWith("//")){return U;}G=e.replace(/\./g,"/");return sap.ui.require.toUrl(G)+"/"+K;};E.prototype._prepareToApplyManifestSettings=function(){var e=this._oCardManifest.get(M.APP_TYPE),G=this.getAggregation("_extension");if(e&&e!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new j(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new p({destinations:this._oDestinations,card:this});this._oDataProviderFactory=new D({host:this.getHostInstance(),destinations:this._oDestinations,extension:G,csrfTokensConfig:this._oCardManifest.get(M.CSRF_TOKENS),card:this});this._registerCustomModels();if(G){G.onCardReady();}};E.prototype._applyManifestSettings=function(){this._setParametersModelData();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();this._applyFooterManifestSettings();this.fireManifestApplied();};E.prototype._setParametersModelData=function(){var e={},G=this.getCombinedParameters(),K;for(K in G){if(v.indexOf(K)>=0){L.warning("The parameter name '"+K+"' is reserved for cards. Can not be used for creating custom parameter.");}else{e[K]={value:G[K]};}}this.getModel("parameters").setData(e);};E.prototype._applyDataManifestSettings=function(){var e=this._oCardManifest.get(M.DATA),G;if(!e){this.fireEvent("_cardReady");return;}this.bindObject(e.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(e,this._oServiceManager);this.getAggregation("_loadingProvider").setDataProvider(this._oDataProvider);if(e.name){G=this.getModel(e.name);}else if(this._oDataProvider){G=new O();this.setModel(G);}if(!G){this.fireEvent("_cardReady");return;}G.attachEvent("change",function(){if(this._createContentPromise){this._createContentPromise.then(function(K){K.onDataChanged();this.onDataRequestComplete();}.bind(this));}else{this.onDataRequestComplete();}}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._showLoadingPlaceholders();}.bind(this));this._oDataProvider.attachDataChanged(function(K){G.setData(K.getParameter("data"));});this._oDataProvider.attachError(function(K){this._handleError("Data service unavailable. "+K.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}else{this.fireEvent("_cardReady");}};E.prototype._applyServiceManifestSettings=function(){var e=this._oCardManifest.get(M.SERVICES);if(!e){return;}if(!this._oServiceManager){this._oServiceManager=new S(e,this);}};E.prototype.getCardHeader=function(){return this.getAggregation("_header");};E.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||w.Top;};E.prototype.getCardContent=function(){return this.getAggregation("_content");};E.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new A();this._oActionsToolbar.setCard(this);}return this._oActionsToolbar;};E.prototype._applyHeaderManifestSettings=function(){var e=this.createHeader();this.destroyAggregation("_header");if(!e){this.fireEvent("_headerReady");return;}e.attachEvent("_error",function(G){this._handleError(G.getParameter("message"));}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady");}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};E.prototype._applyFilterBarManifestSettings=function(){var e=this.createFilterBar();this.destroyAggregation("_filterBar");if(!e){this.fireEvent("_filterBarReady");return;}e.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady");}.bind(this));this.setAggregation("_filterBar",e);};E.prototype._applyFooterManifestSettings=function(){var e=this.createFooter();this.destroyAggregation("_footer");if(e){this.setAggregation("_footer",e);}};E.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null;}return a.byId(e);};E.prototype._applyContentManifestSettings=function(){var e=this._oCardManifest.get(M.TYPE),G=this.getContentManifest(),K=e+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(K);if(!G){this.fireEvent("_contentReady");return;}this._setTemporaryContent(e,G);if(this._bIsPreviewMode){this.fireEvent("_contentReady");return;}this._createContentPromise=this.createContent({cardType:e,contentManifest:G,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(N){this._setCardContent(N);return N;}.bind(this));this._createContentPromise.catch(function(N){if(N){this._handleError(N);}}.bind(this));};E.prototype.createHeader=function(){var e=this._oCardManifest.get(M.HEADER),G=new n(this);return G.create(e,this._getActionsToolbar());};E.prototype.createFilterBar=function(){var e=this._oCardManifest.get(M.FILTERS),G=new r(this);return G.create(e,this.getModel("filters"));};E.prototype.createFooter=function(){var e=this._oCardManifest.get(M.FOOTER);if(!e){return null;}return F.create(this,e);};E.prototype.getContentManifest=function(){var e=this._oCardManifest.get(M.TYPE),G=e&&e.toLowerCase()==="component",K=this._oCardManifest.get(M.CONTENT),N=!!K;if(N&&!e){this._logFundamentalError("Card type property is mandatory!");return null;}if(!N&&!G){return null;}if(G){K=m(K,{componentManifest:this._oCardManifest.getJson()});}return K;};E.prototype.createContent=function(e){e.cardManifest=this._oCardManifest;return this._oContentFactory.create(e);};E.prototype._setCardContent=function(e){if(this._bShowContentLoadingPlaceholders){e.showLoadingPlaceholders();this._bShowContentLoadingPlaceholders=false;}e.attachEvent("_error",function(G){this._handleError(G.getParameter("logMessage"),G.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",e);if(e.isReady()){this.fireEvent("_contentReady");}else{e.attachReady(function(){this.fireEvent("_contentReady");}.bind(this));}};E.prototype._setTemporaryContent=function(e,G){var K=this._getTemporaryContent(e,G),P=this.getAggregation("_content");if(P&&P!==K){P.destroy();}this.setAggregation("_content",K);};E.prototype._preserveMinHeightInContent=function(e){e.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var G=this._oCardManifest.get(M.TYPE),K=this._oCardManifest.get(M.CONTENT),N=this._oContentFactory.getClass(G),P;if(!N){return;}P=N.getMetadata().getRenderer().getMinHeight(K,e);if(this.getHeight()==="auto"){e.$().css({"min-height":P});}}},this);};E.prototype._destroyPreviousContent=function(e){if(e&&!e.hasStyleClass("sapFCardErrorContent")){e.destroy();if(e===this._oTemporaryContent){this._oTemporaryContent=null;}}};E.prototype._createError=function(e){return new H({justifyContent:"Center",alignItems:"Center",items:[new c({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:e})]}).addStyleClass("sapFCardErrorContent");};E.prototype._handleError=function(e,G){this._loadDefaultTranslations();L.error(e,null,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:e});var K=G||this._oIntegrationRb.getText("CARD_DATA_LOAD_ERROR"),N=this._createError(K),P=this._oCardManifest.get(M.CONTENT);if(P){this._destroyPreviousContent(this.getCardContent());this._preserveMinHeightInContent(N);this.setAggregation("_content",N);this.fireEvent("_contentReady");}else{this.getCardHeader().setAggregation("_error",N);}};E.prototype._getTemporaryContent=function(e,G){var K=this.getAggregation("_loadingProvider");if(!this._oTemporaryContent&&K){this._oTemporaryContent=K.createContentPlaceholder(G,e);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var N=this._oContentFactory.getClass(e).getMetadata().getRenderer().getMinHeight(G,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":N});}}},this);}return this._oTemporaryContent;};E.prototype.setDataMode=function(e){if(this._oDataProviderFactory&&e===x.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",e,true);if(this.getProperty("dataMode")===x.Active){this.refresh();}if(this.getProperty("dataMode")===x.Auto){this._oCardObserver.createObserver(this);if(!this._bFirstRendering){this._oCardObserver.oObserver.observe(this.getDomRef());}}return this;};E.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(G,K){this.attachManifestReady(function(){this.loadDesigntime().then(G,K);}.bind(this));}.bind(this));}var e=this._oCardManifest.get("/sap.app/id");if(!e){return Promise.reject("App id not maintained");}return new Promise(function(G,K){var N=this._oCardManifest.get("/sap.card/configuration/editor");if(N===undefined){N=this._oCardManifest.get("/sap.card/designtime");}var P=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+N;if(P){sap.ui.require([P],function(Q){Q=new Q();Q._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=Q;G(Q);}.bind(this));}.bind(this),function(){K({error:P+" not found"});});}else{K();}}.bind(this));};E.prototype.showLoadingPlaceholders=function(e){var G;switch(e){case z.Header:G=this.getCardHeader();if(G){G.showLoadingPlaceholders();}break;case z.Filters:G=this.getAggregation("_filterBar");if(G){G.showLoadingPlaceholders();}break;case z.Content:if(this._createContentPromise){this._createContentPromise.then(function(K){K.showLoadingPlaceholders();});}else{this._bShowContentLoadingPlaceholders=true;}break;default:this.showLoadingPlaceholders(z.Header);this.showLoadingPlaceholders(z.Filters);this.showLoadingPlaceholders(z.Content);this.getAggregation("_loadingProvider").setLoading(true);}return this;};E.prototype.hideLoadingPlaceholders=function(e){var G;switch(e){case z.Header:G=this.getCardHeader();if(G){G.hideLoadingPlaceholders();}break;case z.Filters:G=this.getAggregation("_filterBar");if(G){G.hideLoadingPlaceholders();}break;case z.Content:if(this._createContentPromise){this._createContentPromise.then(function(K){K.hideLoadingPlaceholders();});}else{this._bShowContentLoadingPlaceholders=false;}break;default:this.hideLoadingPlaceholders(z.Header);this.hideLoadingPlaceholders(z.Filters);this.hideLoadingPlaceholders(z.Content);this.getAggregation("_loadingProvider").setLoading(false);}return this;};E.prototype.isLoading=function(){var e=this.getAggregation("_loadingProvider");return e?e.getLoading():false;};E.prototype.getFocusDomRef=function(){var e=this.getCardHeader();if(e&&e.getDomRef()){return e.getDomRef();}return this.getDomRef();};E.prototype._showLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(true);};E.prototype.onDataRequestComplete=function(){var e=this.getCardContent();this.fireEvent("_cardReady");this.hideLoadingPlaceholders(z.Header);this.hideLoadingPlaceholders(z.Filters);if(e&&e.isA("sap.ui.integration.cards.BaseContent")&&e.isReady()){this.hideLoadingPlaceholders(z.Content);}this.getAggregation("_loadingProvider").setLoading(false);};E.prototype.request=function(e){return this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true).getData();};E.prototype.triggerAction=function(e){s.fireAction({card:this,host:this.getHostInstance(),action:e,parameters:e.parameters,source:this});};E.prototype._setPreviewMode=function(e){this._bIsPreviewMode=e;if(e){this.addStyleClass("sapFCardPreview");}else{this.removeStyleClass("sapFCardPreview");}this._bApplyManifest=true;this.invalidate();};E.prototype.getBindingNamespaces=function(){var N={},e=this.getAggregation("_extension");if(e){N.extension={formatters:e.getFormatters()};}return N;};E.prototype._registerCustomModels=function(){var e=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[];}this._deregisterCustomModels();e.forEach(function(G){var K=G&&G.name;if(!K){return;}if(u.indexOf(K)>-1){L.error("The model name (data section name) '"+K+"' is reserved for cards. Can not be used for creating a custom model.");return;}if(this._aCustomModels.indexOf(K)>-1){L.error("The model name (data section name) '"+K+"' is already used.");return;}this.setModel(new O(),K);this._aCustomModels.push(K);}.bind(this));};E.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return;}this._aCustomModels.forEach(function(e){this.getModel(e).destroy();this.setModel(null,e);}.bind(this));this._aCustomModels=[];};E.prototype._fireConfigurationChange=function(e){var G=this.getHostInstance();if(!this._bReady){return;}this.fireConfigurationChange({changes:e});if(G){G.fireCardConfigurationChange({card:this,changes:e});}};E.prototype.isSkeleton=function(){return false;};return E;});
