/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/RenderManager','./SplitterRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/layout/SplitterLayoutData"],function(C,l,c,R,a,S,L,q,b){"use strict";var O=c.Orientation;var r=16;var d=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"},renderer:S});d.prototype.init=function(){this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=function(E){this._delayedResize(0);}.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._initOrientationProperties();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();};d.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};d.prototype.onBeforeRendering=function(){this._initOrientationProperties();};d.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._resize();};d.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};d.prototype.resetContentAreasSizes=function(){var f=this._getContentAreas();for(var i=0;i<f.length;i++){f[i].getLayoutData().setSize("auto");}};d.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};d.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var f=this;sap.ui.getCore().attachInit(function(){f._resizeHandlerId=R.register(f,f._resizeCallback);});this._delayedResize();};d.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};d.prototype.enableLiveResize=function(){this._liveResize=true;this.removeStyleClass("sapUiLoSplitterAnimated");};d.prototype.disableLiveResize=function(){this._liveResize=false;this.addStyleClass("sapUiLoSplitterAnimated");};d.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};d.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};d.prototype.onLayoutDataChange=function(){this._delayedResize();};d.prototype.ontouchstart=function(E){if(this._ignoreTouch){return;}var t=this._getBar(E.target);if(!t){return;}if(!E.changedTouches||!E.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(E.changedTouches[0],t,true);};d.prototype.onmousedown=function(E){if(this._ignoreMouse){return;}var t=this._getBar(E.target);if(!t){return;}this._ignoreTouch=true;this._onBarMoveStart(E,t);this._oLastDOMclicked=t;};d.prototype._onBarMoveStart=function(E,B,t){var I=this.getId();this.disableAutoResize(true);var p=E[this._moveCord];var f=parseInt(B.id.substr((I+"-splitbar-").length));var $=q(B);var m=this.getCalculatedSizes();var g=this._bHorizontal?$.outerWidth():$.outerHeight();var h=this._getContentAreas();var o=h[f].getLayoutData();var j=h[f+1].getLayoutData();if(!o.getResizable()||!j.getResizable()){e(t);return;}var k=0-g;for(var i=0;i<=f;++i){k+=m[i]+g;}this._move={start:p,relStart:k,barNum:f,$bar:$,c1Size:m[f],c1MinSize:o.getMinSize(),c2Size:m[f+1],c2MinSize:j.getMinSize()};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move.$bar.css("visibility","hidden");this._onBarMove(E);};d.prototype._onBarMove=function(E){if(E.preventDefault&&!(E.changedTouches)){E.preventDefault();}var o=E;if(E.changedTouches&&E.changedTouches[0]){o=o.changedTouches[0];}var p=o[this._moveCord];var D=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){D=-D;}var f=this._move.c1Size+D;var g=this._move.c2Size-D;var i=(f>=0&&g>=0&&f>=this._move.c1MinSize&&g>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+D);if(this._liveResize){var m=(this._move["start"]-o[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};d.prototype._onBarMoveEnd=function(E){this._ignoreMouse=false;this._ignoreTouch=false;var o=E;if(E.changedTouches&&E.changedTouches[0]){o=o.changedTouches[0];}var p=o[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move.$bar.css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.$bar){this._move.$bar.trigger("focus");}};d.prototype._resizeContents=function(i,p,f){if(isNaN(p)){L.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var g=this._getContentAreas();var o=g[i].getLayoutData();var h=g[i+1].getLayoutData();var s=o.getSize();var j=h.getSize();var $=this.$("content-"+i);var k=this.$("content-"+(i+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var m=o.getMinSize();var M=h.getMinSize();var D;if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&j!=="auto"){h.setSize(N+"px");}else if(s!=="auto"&&j==="auto"){o.setSize(n+"px");}else{o.setSize(n+"px");h.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");k.css(this._sizeType,N+"px");}};d.prototype._delayedResize=function(D){if(D===undefined){D=0;}if(this.getDomRef()){clearTimeout(this._resizeTimeout);this._resizeTimeout=setTimeout(this._resize.bind(this),D);}};d.prototype._resizeBars=function(f){var i,B,s=this._bHorizontal?this.$().innerHeight():this.$().innerWidth();for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};d.prototype._resize=function(){var D=this.getDomRef();if(!D||a.getPreserveAreaRef().contains(D)||D.scrollHeight===0||D.scrollWidth===0){return;}var i=0,B;var f=this._getContentAreas();this._resizeBars(f);var o=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var g=true;for(i=0;i<f.length;++i){var $=this.$("content-"+i);var h=f[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var j=h.getLayoutData();var k=j&&j.getResizable();if(i>0){var m=k&&g;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!m);B.attr("tabindex",m&&this._keyboardEnabled?"0":"-1");}g=k;}this._resizeBars(f);if(_(o,n)){this.fireResize({oldSizes:o,newSizes:n});}};d.prototype._getTotalSize=function(){return this._bHorizontal?this.$().innerWidth():this.$().innerHeight();};d.prototype._calcAvailableContentSize=function(){return this._getTotalSize()-this._calcBarsSize();};d.prototype._calcBarsSize=function(){var s=0,B=this._getContentAreas().length-1;for(var i=0;i<B;i++){s+=this._bHorizontal?this.$("splitbar-"+i).outerWidth():this.$("splitbar-"+i).outerHeight();}return s;};d.prototype._recalculateSizes=function(){var i,A,f,m;var s=[];var g=this._getContentAreas();var h=this._calcAvailableContentSize();var j=[];var k=[];var p=[];this._calculatedSizes=[];for(i=0;i<g.length;++i){s.push(g[i].getLayoutData().getSize());}for(i=0;i<s.length;++i){var n=s[i];var o;if(n.indexOf("rem")>-1){o=parseFloat(n)*r;h-=o;this._calculatedSizes[i]=o;}else if(n.indexOf("px")>-1){o=parseInt(n);h-=o;this._calculatedSizes[i]=o;}else if(n.indexOf("%")>-1){p.push(i);}else if(n==="auto"){if(g[i].getLayoutData().getMinSize()!==0){k.push(i);}else{j.push(i);}}else{L.error("Illegal size value: "+s[i]);}}var w=false;if(h<0){w=true;h=0;}h=this._calcPercentBasedSizes(p,h);if(h<0){w=true;h=0;}var t=Math.floor(h/(k.length+j.length),0);for(i=0;i<k.length;++i){A=t;f=k[i];m=g[f].getLayoutData().getMinSize();if(A>h){A=h;}if(A<m){A=m;}this._calculatedSizes[f]=A;h-=A;}if(h<0){w=true;h=0;}var u=j.length;t=Math.floor(h/u,0);for(i=0;i<u;++i){f=j[i];this._calculatedSizes[f]=t;h-=t;}if(w){this._logConstraintsViolated();}};d.prototype._calcPercentBasedSizes=function(p,f){var g=this._getContentAreas(),A=this._calcAvailableContentSize();for(var i=0;i<p.length;++i){var h=p[i];var j=parseFloat(g[h].getLayoutData().getSize())/100*A;var m=g[h].getLayoutData().getMinSize();if(j<m){j=m;}this._calculatedSizes[h]=j;f-=j;}return f;};d.prototype._logConstraintsViolated=function(){L.warning("The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.",null,"sap.ui.layout.Splitter");};d.prototype._initOrientationProperties=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}};d.prototype._onKeyboardResize=function(t,s,E){var B=this.getId()+"-splitbar-";if(!E||!E.target||!E.target.id||E.target.id.indexOf(B)!==0){return;}var i=999999;var f=parseInt(E.target.id.substr(B.length));var m=this.getCalculatedSizes();this._move.c1Size=m[f];this._move.c2Size=m[f+1];var g=0;switch(t){case"inc":g=s;break;case"incMore":g=s*10;break;case"dec":g=0-s;break;case"decMore":g=0-s*10;break;case"max":g=i;break;case"min":g=0-i;break;default:L.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(f,g,true);};d.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};d.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};d.prototype._getBar=function(t){var B=t,i=this.getId();if(B.classList.contains("sapUiLoSplitterBarGripIcon")){B=t.parentElement;}if(B.classList.contains("sapUiLoSplitterBarDecorationBefore")||B.classList.contains("sapUiLoSplitterBarDecorationAfter")||B.classList.contains("sapUiLoSplitterBarGrip")){B=B.parentElement;}if(!B.id||B.id.indexOf(i+"-splitbar")!==0){return null;}return B;};function _(s,f){if(s===f){return false;}if(!s||!f||s.length===undefined||f.length===undefined){return true;}if(s.length!=f.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==f[i]){return true;}}return false;}function e(t){var p=function(E){if(!t){E.preventDefault();}};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}d.prototype._ensureLayoutData=function(o){var f=o.getLayoutData();if(f&&(!f.getResizable||!f.getSize||!f.getMinSize)){L.warning("Content \""+o.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");f=null;}if(!f){o.setLayoutData(new b());}};d.prototype.invalidate=function(o){var f=(o&&this.indexOfContentArea(o)!=-1)||(o&&o instanceof sap.ui.core.CustomData&&o.getWriteToDom())||(o===undefined);if(f){C.prototype.invalidate.apply(this,arguments);}};d.prototype.addContentArea=function(o){this._ensureLayoutData(o);return this.addAggregation("contentAreas",o);};d.prototype.insertContentArea=function(o,i){this._ensureLayoutData(o);return this.insertAggregation("contentAreas",o,i);};d.prototype._getContentAreas=function(){return this.getContentAreas();};return d;});
