/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['sap/ui/model/FilterOperator','sap/ui/model/Filter','sap/ui/model/ValidateException','sap/base/Log','sap/base/util/merge','sap/ui/mdc/enum/FieldDisplay','./Operator','./RangeOperator','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/core/date/UniversalDate','sap/ui/core/date/UniversalDateUtils','sap/ui/core/format/DateFormat','sap/ui/model/json/JSONModel','sap/ui/model/type/Integer'],function(M,F,V,L,m,a,O,R,B,C,U,b,D,J,I){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var c={_mOperators:{equal:new O({name:"EQ",alias:"DATE",filterOperator:M.EQ,tokenParse:"^=([^=].*)$",tokenFormat:"{1} ({0})",valueTypes:[O.ValueType.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(f,t,s,h){s=s||a.DescriptionValue;var g=this.valueTypes.length;var v=f.values;var T=(f&&f.validated===C.Validated)||v.length===2||h?"":"=";var j=T+this.displayFormats[s];if(!v[1]){j=T+this.displayFormats["Value"];g=1;}for(var i=0;i<g;i++){var r,k=v[i];if(k===null||k===undefined){k="";}if(i==0&&t&&(typeof t.formatValue==="function")){r=t.formatValue(k,"string");}else{r=k;}j=r==null?null:j.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}return j;},parse:function(t,T,s,f){s=s||a.DescriptionValue;var r=O.prototype.parse.apply(this,[t,T,s,f]);if(f&&(!r||r[0]===null||r[0]===undefined)&&s!==a.Value){s=a.Value;r=O.prototype.parse.apply(this,[t,T,s,f]);}if(r&&(r[1]===null||r[1]===undefined)&&s===a.Value){r=[r[0]];}return r;},getValues:function(t,s,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){var h;var T=this.displayFormats[s];var k=T.indexOf("{0}");var i=T.indexOf("{1}");var K;var j;if(g){h=g[1];}else if(f){h=t;}if(k>=0&&i>=0){if(h.lastIndexOf("(")>0&&(h.lastIndexOf(")")===h.length-1||h.lastIndexOf(")")===-1)){var E=h.length;if(h[E-1]===")"){E--;}var l=h.substring(0,h.lastIndexOf("("));if(l[l.length-1]===" "){l=l.substring(0,l.length-1);}var n=h.substring(h.lastIndexOf("(")+1,E);if(k<i){K=l;j=n;}else{K=n;j=l;}}else if(k<i){K=h;}else{j=h;}}else if(k>=0){K=h;}else{j=h;}v=[K];if(i>=0){v.push(j);}}return v;},isEmpty:function(f,t){var i=false;var v=f.values[0];if((v===null||v===undefined||v==="")&&!f.values[1]){i=true;}return i;},getCheckValue:function(f){return{value:f.values[0]};},checkValidated:function(f){if(f.values.length===2&&f.values[0]!==undefined&&f.values[1]!==null&&f.values[1]!==undefined){f.validated=C.Validated;}else{f.validated=C.NotValidated;}},validateInput:true}),between:new O({name:"BT",alias:"DATERANGE",filterOperator:M.BT,tokenParse:"^([^!].*)\\.\\.\\.(.+)$",tokenFormat:"{0}...{1}",valueTypes:[O.ValueType.Self,O.ValueType.Self],validate:function(v,t){if(v.length===2){if(d(v[0])&&d(v[1])){return;}else if((d(v[0])||d(v[1]))){throw new V(o.getText("operator.between.validate.missingValue"));}else if(v[0]===v[1]){throw new V(o.getText("operator.between.validate.sameValues"));}}O.prototype.validate.apply(this,[v,t]);}}),notBetween:new O({name:"NOTBT",filterOperator:M.NB,tokenParse:"^!(.+)\\.\\.\\.(.+)$",tokenFormat:"!({0}...{1})",valueTypes:[O.ValueType.Self,O.ValueType.Self],exclude:true,validate:function(v,t){c._mOperators.between.validate(v,t);}}),lessThan:new O({name:"LT",filterOperator:M.LT,tokenParse:"^<([^=].*)$",tokenFormat:"<{0}",valueTypes:[O.ValueType.Self]}),notLessThan:new O({name:"NOTLT",filterOperator:M.GE,tokenParse:"^!<([^=].*)$",tokenFormat:"!(<{0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterThan:new O({name:"GT",filterOperator:M.GT,tokenParse:"^>([^=].*)$",tokenFormat:">{0}",valueTypes:[O.ValueType.Self]}),notGreaterThan:new O({name:"NOTGT",filterOperator:M.LE,tokenParse:"^!>([^=].*)$",tokenFormat:"!(>{0})",valueTypes:[O.ValueType.Self],exclude:true}),lessEqual:new O({name:"LE",alias:"TO",filterOperator:M.LE,tokenParse:"^<=(.+)$",tokenFormat:"<={0}",valueTypes:[O.ValueType.Self]}),notLessEqual:new O({name:"NOTLE",filterOperator:M.GT,tokenParse:"^!<=(.+)$",tokenFormat:"!(<={0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterEqual:new O({name:"GE",alias:"FROM",filterOperator:M.GE,tokenParse:"^>=(.+)$",tokenFormat:">={0}",valueTypes:[O.ValueType.Self]}),notGreaterEqual:new O({name:"NOTGE",filterOperator:M.LT,tokenParse:"^!>=(.+)$",tokenFormat:"!(>={0})",valueTypes:[O.ValueType.Self],exclude:true}),startsWith:new O({name:"StartsWith",filterOperator:M.StartsWith,tokenParse:"^([^!\\*]+.*)\\*$",tokenFormat:"{0}*",valueTypes:[O.ValueType.SelfNoParse]}),notStartsWith:new O({name:"NotStartsWith",filterOperator:M.NotStartsWith,tokenParse:"^!([^\\*].*)\\*$",tokenFormat:"!({0}*)",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),endsWith:new O({name:"EndsWith",filterOperator:M.EndsWith,tokenParse:"^\\*(.*[^\\*])$",tokenFormat:"*{0}",valueTypes:[O.ValueType.SelfNoParse]}),notEndsWith:new O({name:"NotEndsWith",filterOperator:M.NotEndsWith,tokenParse:"^!\\*(.*[^\\*])$",tokenFormat:"!(*{0})",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),contains:new O({name:"Contains",filterOperator:M.Contains,tokenParse:"^\\*(.*)\\*$",tokenFormat:"*{0}*",valueTypes:[O.ValueType.SelfNoParse]}),notContains:new O({name:"NotContains",filterOperator:M.NotContains,tokenParse:"^!\\*(.*)\\*$",tokenFormat:"!(*{0}*)",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),notEqual:new O({name:"NE",filterOperator:M.NE,tokenParse:"^!=(.+)$",tokenFormat:"!(={0})",valueTypes:[O.ValueType.Self],exclude:true}),empty:new O({name:"Empty",filterOperator:M.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",valueTypes:[],getModelFilter:function(f,s,t,g){var i=false;if(t){var r=t.parseValue("","string");try{t.validateValue(r);i=r===null;}catch(E){i=false;}}if(i){return new F({filters:[new F({path:s,operator:M.EQ,value1:""}),new F({path:s,operator:M.EQ,value1:null})],and:false});}else{return new F({path:s,operator:this.filterOperator,value1:""});}}}),notEmpty:new O({name:"NotEmpty",filterOperator:M.NE,tokenParse:"^!<#tokenText#>$",tokenFormat:"!(<#tokenText#>)",valueTypes:[],exclude:true,getModelFilter:function(f,s,t,g){var i=false;if(t){var r=t.parseValue("","string");try{t.validateValue(r);i=r===null;}catch(E){i=false;}}if(i){return new F({filters:[new F({path:s,operator:M.NE,value1:""}),new F({path:s,operator:M.NE,value1:null})],and:true});}else{return new F({path:s,operator:this.filterOperator,value1:""});}}}),yesterday:new R({name:"YESTERDAY",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.yesterday();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),today:new R({name:"TODAY",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.today();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),tomorrow:new R({name:"TOMORROW",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.tomorrow();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),lastDays:new R({name:"LASTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastDays(i);}}),todayFromTo:new R({alias:"TODAYXYDAYS",name:"TODAYFROMTO",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",calcRange:function(x,y){var s=x>=0?b.ranges.lastDays(x)[0]:b.ranges.nextDays(-x)[1];var E=y>=0?b.ranges.nextDays(y)[1]:b.ranges.lastDays(-y)[0];if(s.oDate.getTime()>E.oDate.getTime()){E=[s,s=E][0];}return[b.resetStartTime(s),b.resetEndTime(E)];}}),nextDays:new R({name:"NEXTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextDays(i);}}),lastWeek:new R({name:"LASTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastWeek();}}),thisWeek:new R({alias:"CURRENTWEEK",name:"THISWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentWeek();}}),nextWeek:new R({name:"NEXTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextWeek();}}),lastWeeks:new R({name:"LASTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastWeeks(i);}}),nextWeeks:new R({name:"NEXTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextWeeks(i);}}),lastMonth:new R({name:"LASTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastMonth();}}),thisMonth:new R({alias:"CURRENTMONTH",name:"THISMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentMonth();}}),nextMonth:new R({name:"NEXTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextMonth();}}),lastMonths:new R({name:"LASTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastMonths(i);}}),nextMonths:new R({name:"NEXTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextMonths(i);}}),lastQuarter:new R({name:"LASTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastQuarter();}}),thisQuarter:new R({alias:"CURRENTQUARTER",name:"THISQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentQuarter();}}),nextQuarter:new R({name:"NEXTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextQuarter();}}),lastQuarters:new R({name:"LASTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastQuarters(i);}}),nextQuarters:new R({name:"NEXTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextQuarters(i);}}),quarter1:new R({alias:"FIRSTQUARTER",name:"QUARTER1",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(1);}}),quarter2:new R({alias:"SECONDQUARTER",name:"QUARTER2",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(2);}}),quarter3:new R({alias:"THIRDQUARTER",name:"QUARTER3",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(3);}}),quarter4:new R({alias:"FOURTHQUARTER",name:"QUARTER4",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(4);}}),lastYear:new R({name:"LASTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastYear();}}),thisYear:new R({alias:"CURRENTYEAR",name:"THISYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentYear();}}),nextYear:new R({name:"NEXTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextYear();}}),lastYears:new R({name:"LASTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastYears(i);}}),nextYears:new R({name:"NEXTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextYears(i);}}),specificMonth:new R({name:"SPECIFICMONTH",valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:["(.+)"],additionalInfo:"",defaultValues:function(){var f=new U();return[f.getMonth()];},calcRange:function(i){var f=new U();f.setMonth(i);f=b.getMonthStartDate(f);return b.getRange(0,"MONTH",f);},format:function(f,t,s,h){var v=f.values[0];var T=this.tokenFormat;var r=e.apply(this)[v];if(h){return r;}else{return r==null?null:T.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),r);}},getValues:function(t,s,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){v=[];for(var i=0;i<this.valueTypes.length;i++){var h;if(g){h=g[i+1];}else if((f&&t)){h=t;}v.push(h);}return[e.apply(this).indexOf(v[0])];}return null;},createControl:function(t,p,f,s,g){var h=function(){if(!this._aMonthsItems){var q=e.apply(this);this._aMonthsItems=[];for(var i=0;i<12;i++){this._aMonthsItems.push({text:q[i],key:i});}}return this._aMonthsItems;}.bind(this);var j=sap.ui.require("sap/ui/mdc/field/ListFieldHelp");var k=sap.ui.require("sap/ui/core/ListItem");var l=sap.ui.require("sap/ui/mdc/Field");if(!j||!k||!l){L.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null;}if(!this._oListFieldHelp){this._oListFieldHelp=new j({id:"LFHForSpecificMonth",items:{path:"$items>/",template:new k({text:{path:"$items>text"},key:{path:"$items>key"}}),templateShareable:false}}).setModel(new J(h()),"$items");}var n=new l(s,{value:{path:p,type:t,mode:'TwoWay',targetType:'raw'},additionalValue:{path:p,formatter:function(v){return this._oListFieldHelp.getTextForKey(v);}.bind(this),mode:'OneWay'},display:'Description',width:"100%",fieldHelp:"LFHForSpecificMonth"});return n;}}),yearToDate:new R({name:"YEARTODATE",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.yearToDate();}})},_mDefaultOpsForType:{},addOperator:function(f){c._mOperators[f.name]=f;},addOperators:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){c.addOperator(g);});},removeOperators:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){c.removeOperator(g);});},removeOperator:function(v){if(typeof v==="string"){delete c._mOperators[v];}else{delete c._mOperators[v.name];}},setOperatorsForType:function(t,f,v){if(!Array.isArray(f)){f=[f];}if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={};}c._mDefaultOpsForType[t].operators=[];f.forEach(function(g){c.addOperatorForType(t,g);});if(v){c.setDefaultOperatorForType(t,v);}},setDefaultOperatorForType:function(t,v){if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={};}if(typeof v==="string"){v=c.getOperator(v);}c._mDefaultOpsForType[t].defaultOperator=v;},addOperatorForType:function(t,v){c.insertOperatorForType(t,v);},insertOperatorForType:function(t,v,i){if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={operators:[]};}i=i===undefined?c._mDefaultOpsForType[t].operators.length:i;if(typeof v==="string"){v=c.getOperator(v);}c._mDefaultOpsForType[t].operators.splice(i,0,v);},removeOperatorForType:function(t,v){var n;if(typeof v==="string"){n=v;}else{n=v.name;}for(var i=0;i<c._mDefaultOpsForType[t].operators.length;i++){if(c._mDefaultOpsForType[t].operators[i].name===n){c._mDefaultOpsForType[t].operators.splice(i,1);return;}}},getOperatorsForType:function(t){var f=[];for(var i=0;i<c._mDefaultOpsForType[t].operators.length;i++){f.push(c._mDefaultOpsForType[t].operators[i].name);}return f;},getDefaultOperator:function(t){return c._mDefaultOpsForType[t].defaultOperator||c._mOperators.equal;},getMatchingOperators:function(f,v){var g=[];for(var i=0;i<f.length;i++){var h=this.getOperator(f[i]);if(h){g.push(h);}}return _.call(this,g,v);},getOperator:function(s){for(var n in c._mOperators){var f=c._mOperators[n];if(f.name===s){return f;}}for(var n in c._mOperators){var f=c._mOperators[n];if(f.alias===s){return f;}}return undefined;},getEQOperator:function(f){if(f){for(var i=0;i<f.length;i++){var g=this.getOperator(f[i]);if(g&&g.validateInput&&!g.exclude&&g.valueTypes[0]&&g.valueTypes[0]!==O.ValueType.Static){return g;}}}return c._mOperators.equal;},onlyEQ:function(f){if(f.length===1&&f[0]==="EQ"){return true;}else{return false;}},checkConditionsEmpty:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){var h=this.getOperator(g.operator);if(h){g.isEmpty=h.isEmpty(g);}}.bind(this));},updateConditionsValues:function(f){if(!Array.isArray(f)){f=[f];}for(var i=0;i<f.length;i++){this.updateConditionValues(f[i]);}},updateConditionValues:function(f){var g=this.getOperator(f.operator);if(g&&f.validated!==C.Validated){var v=g.valueTypes.length;if(g.valueTypes.length===2&&g.valueTypes[1]===null&&(f.values.length<2||f.values[1]===null||f.values[1]===undefined)){v=v-1;}if(g.valueTypes[0]==="static"){f.values=[];}else{while(f.values.length!=v){if(f.values.length<v){f.values.push(null);}if(f.values.length>v){f.values=f.values.slice(0,f.values.length-1);}}}}},indexOfCondition:function(f,g){var h=-1;for(var i=0;i<g.length;i++){if(this.compareConditions(f,g[i])){h=i;break;}}return h;},compareConditions:function(f,g){var E=false;if(f.operator===g.operator){var h=this.getOperator(f.operator);if(h){E=h.compareConditions(f,g);}}return E;},compareConditionsArray:function(f,g){var E=false;if(f.length===g.length){E=true;for(var i=0;i<f.length;i++){if(!this.compareConditions(f[i],g[i])){E=false;break;}}}return E;},checkConditionValidated:function(f){var g=this.getOperator(f.operator);if(!f.validated&&g&&g.checkValidated){g.checkValidated(f);}}};c.setOperatorsForType(B.String,[c._mOperators.contains,c._mOperators.equal,c._mOperators.between,c._mOperators.startsWith,c._mOperators.endsWith,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.empty,c._mOperators.notContains,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notStartsWith,c._mOperators.notEndsWith,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual,c._mOperators.notEmpty],c._mOperators.equal);c.setOperatorsForType(B.Date,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual,c._mOperators.today,c._mOperators.yesterday,c._mOperators.tomorrow,c._mOperators.todayFromTo,c._mOperators.lastDays,c._mOperators.nextDays,c._mOperators.thisWeek,c._mOperators.lastWeek,c._mOperators.lastWeeks,c._mOperators.nextWeek,c._mOperators.nextWeeks,c._mOperators.specificMonth,c._mOperators.thisMonth,c._mOperators.lastMonth,c._mOperators.lastMonths,c._mOperators.nextMonth,c._mOperators.nextMonths,c._mOperators.thisQuarter,c._mOperators.lastQuarter,c._mOperators.lastQuarters,c._mOperators.nextQuarter,c._mOperators.nextQuarters,c._mOperators.quarter1,c._mOperators.quarter2,c._mOperators.quarter3,c._mOperators.quarter4,c._mOperators.thisYear,c._mOperators.lastYear,c._mOperators.lastYears,c._mOperators.nextYear,c._mOperators.nextYears,c._mOperators.yearToDate]);c.setOperatorsForType(B.DateTime,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Numeric,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Time,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Boolean,[c._mOperators.equal,c._mOperators.notEqual]);function _(f,v){var r=[];for(var i=0;i<f.length;i++){var g=f[i];if(g&&g.test&&g.test(v)){r.push(g);}}return r;}function d(v){return v===null||v===undefined||v==="";}function e(){if(!this._aMonths){var f=new U(),g=D.getDateInstance({pattern:"LLLL"});f.setDate(15);f.setMonth(0);var h=[];for(var i=0;i<12;i++){h.push(g.format(f));f.setMonth(f.getMonth()+1);}this._aMonths=h;}return this._aMonths;}return c;},true);
