/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/m/DynamicDateOption','sap/m/DynamicDateValueHelpUIType','sap/m/Input','sap/m/DatePicker','sap/ui/mdc/condition/Operator','sap/ui/mdc/util/DateUtil','sap/ui/model/json/JSONModel','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/core/library'],function(D,a,I,b,O,c,J,F,P,V,d){"use strict";var e=d.ValueState;var f=D.extend("sap.ui.mdc.condition.OperatorDynamicDateOption",{metadata:{library:"sap.ui.mdc",properties:{operator:{type:"object"},type:{type:"object"}}}});f.prototype.exit=function(){if(this._oModel){this._oModel.destroy();this._oModel=undefined;this._mChangeHandler=undefined;}if(this._aUITypes){for(var i=0;i<this._aUITypes.length;i++){this._aUITypes[i].destroy();}this._aUITypes=undefined;}};f.prototype.validateProperty=function(p,v){if(p==="operator"&&v&&(typeof v!=="object"||!v.isA||!v.isA("sap.ui.mdc.condition.Operator"))){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+"sap.ui.mdc.condition.Operator for property \""+p+"\" of "+this);}else if(p==="type"&&v&&(typeof v!=="object"||!v.isA||!v.isA("sap.ui.model.Type"))){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+"sap.ui.model.Type for property \""+p+"\" of "+this);}return D.prototype.validateProperty.apply(this,arguments);};f.prototype.getKey=function(){var o=this.getOperator();return o.name;};f.prototype.isRange=function(){var o=this.getOperator();return o.isA("sap.ui.mdc.condition.RangeOperator");};f.prototype.getText=function(C){var o=this.getOperator();return o.longText;};f.prototype.getValueHelpUITypes=function(C){if(!this._aUITypes){var o=this.getOperator();var t=this.getType();this._aUITypes=[];for(var i=0;i<o.valueTypes.length;i++){var T=o.valueTypes[i];if(T===O.ValueType.Self){this._aUITypes.push(new a({type:"date"}));}else if(T===O.ValueType.Static){continue;}else{t=o._createLocalType(T,t);if(t.isA("sap.ui.model.type.Integer")||t.isA("sap.ui.model.odata.type.Int")){this._aUITypes.push(new a({type:"int"}));}else{this._aUITypes.push(new a({type:"custom"}));}}}}return this._aUITypes;};f.prototype.createValueHelpUI=function(C,g){var v=C.getValue();var o=this.getOperator();var t=this.getType();var k=this.getKey();var s=C.getId();if(!v||v.operator!==k){v={operator:k,values:[]};if(o.valueDefaults){v.values=o.valueDefaults;}}_.call(this,C);if(!C.aControlsByParameters){C.aControlsByParameters={};}C.aControlsByParameters[k]=[];var h=function(E){g(this);}.bind(this);for(var i=0;i<o.valueTypes.length;i++){var T=o.valueTypes[i];var j;if(!C.aControlsByParameters[k][i]){if(o.createControl){if(!this._oModel){h=function(E){var r=E.getParameter("path");var u=r.split("/");var s=u[0]||u[1];if(this._mChangeHandler&&this._mChangeHandler[s]){this._mChangeHandler[s](this);}}.bind(this);this._oModel=new J();this._oModel.attachPropertyChange({},h,this);this._mChangeHandler={};}var m=this._oModel.getData();m[s]={value0:v&&v.values[0],value1:v&&v.values[1]};this._mChangeHandler[s]=g;if(T!==O.ValueType.Self){t=o._createLocalType(T,t);}var l=o.createControl(t,"internal>/"+s+"/value"+i,i,s+"-"+i);l.setModel(this._oModel,"internal");C.aControlsByParameters[k].push(l);}else if(T===O.ValueType.Self){if(v&&v.values[i]){j=c.typeToUniversalDate(v.values[i],t);j=c.utcToLocal(j);}var n=t.getFormatOptions();var p=new b(s+"-"+i,{dateValue:j,displayFormat:n.style||n.pattern,displayFormatType:n.calendarType,change:h});C.aControlsByParameters[k].push(p);}else if(typeof T==="object"){var q=new I(s+"-"+i,{value:v&&v.values[i],change:h});C.aControlsByParameters[k].push(q);}}}return C.aControlsByParameters[k];};f.prototype.validateValueHelpUI=function(C){var k=this.getKey();var o=this.getOperator();var t=this.getType();var g;var v=true;var s=e.None;var h;var i=0;try{g=this.getValueHelpOutput(C);for(i=0;i<g.values.length;i++){var j=g.values[i];if(j===undefined||j===null){v=false;}}o.validate(g.values,t);}catch(E){v=false;s=e.Error;h=E.message;if(E&&!(E instanceof P)&&!(E instanceof V)){throw E;}}if(!o.createControl){for(i=0;i<C.aControlsByParameters[k].length;i++){var l=C.aControlsByParameters[k][i];if(l.setValueState){l.setValueState(s);l.setValueStateText(h);}}}return v;};f.prototype.getValueHelpOutput=function(C){var k=this.getKey();var r={operator:k,values:[]};var o=this.getOperator();var t=this.getType();var s=C.getId();for(var i=0;i<o.valueTypes.length;i++){var g=C.aControlsByParameters[k][i];if(g){var v;if(o.createControl){v=this._oModel?this._oModel.getProperty("/"+s+"/value"+i):null;}else if(o.valueTypes[i]===O.ValueType.Self){if(!g.isValidValue()){throw new P();}v=g.getDateValue();if(v){v=c.localToUtc(v);v=c.universalDateToType(v,t);}}else{v=g.getValue();t=o._createLocalType(o.valueTypes[i],t);v=t.parseValue(v,"string");}r.values.push(v);}}return r;};f.prototype.getGroupHeader=function(){var o=this.getOperator();if(o.group&&o.group.text){return o.group.text;}return D.prototype.getGroupHeader.apply(this,arguments);};f.prototype.getGroup=function(){var o=this.getOperator();if(o.group){return o.group.id;}return D.prototype.getGroup.apply(this,arguments);};f.prototype.toDates=function(v){var o=this.getOperator();var t=this.getType();var r;var i=0;if(o.isA("sap.ui.mdc.condition.RangeOperator")){r=o._getRange(v&&v.values,t);for(i=0;i<r.length;i++){r[i]=c.typeToUniversalDate(r[i],t);r[i]=c.utcToLocal(r[i]);}}else if(o.valueTypes[0]===O.ValueType.Self){r=v.values;for(i=0;i<r.length;i++){if(r[i]){r[i]=c.typeToUniversalDate(r[i],t);r[i]=c.utcToLocal(r[i]);}}if(r.length===1){r.push(r[0]);}}else if([O.ValueType.Self,O.ValueType.Static].indexOf(o.valueTypes[0])===-1){throw new Error("Cannot convert to date, use RangeOperator");}return r;};f.prototype.format=function(v){var o=this.getOperator();var t=this.getType();return o.format(v,t);};f.prototype.parse=function(v){var o=this.getOperator();var t=this.getType();if(v&&o.parse(v)){var r={};r.operator=this.getKey();r.values=o.parse(v,t);return r;}};f.prototype.enhanceFormattedValue=function(s,A){return false;};function _(C){var k=this.getKey();if(C&&C.aControlsByParameters&&C.aControlsByParameters[k]){for(var i=0;i<C.aControlsByParameters[k].length;i++){var u=C.aControlsByParameters[k][i];if(!u.bIsDestroyed){u.destroy();}}delete C.aControlsByParameters[k];}}return f;});
