//@ui5-bundle sap/ui/mdc/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/ActionToolbar',["sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/OverflowToolbarPriority","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator","sap/ui/mdc/enum/ActionToolbarActionAlignment","sap/ui/mdc/p13n/subcontroller/ActionToolbarController","sap/ui/mdc/p13n/Engine"],function(O,a,b,T,c,A,d,E){"use strict";
var e=O.extend("sap.ui.mdc.ActionToolbar",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbar.designtime",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.mdc.actiontoolbar.ActionToolbarAction",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},
renderer:a
});
var f=["begin","between","actions","end"];var g=function(){var C={canOverflow:true,getCustomImportance:function(){return b.NeverOverflow;}};return C;};
e.prototype.init=function(){O.prototype.init.apply(this,arguments);this._oBeginSeparator=new c({visible:false});this._oBeginSeparator.getOverflowToolbarConfig=g;this._oEndActionsBeginSeparator=new c({visible:false});this._oEndActionsBeginSeparator.getOverflowToolbarConfig=g;this._oEndActionsEndSeparator=new c({visible:false});this._oEndActionsEndSeparator.getOverflowToolbarConfig=g;this._oSpacer=new T();this.setUseAsHeader(true);E.getInstance().registerAdaptation(this,{controller:{actionsKey:d}});};
e.prototype.exit=function(){O.prototype.exit.apply(this,arguments);if(this._oBeginSeparator){this._oBeginSeparator.destroy();}if(this._oEndActionsBeginSeparator){this._oEndActionsBeginSeparator.destroy();}if(this._oEndActionsEndSeparator){this._oEndActionsEndSeparator.destroy();}if(this._oSpacer){this._oSpacer.destroy();}};
e.prototype.addAggregation=function(s,C){if(s==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.");}var h=arguments;if(f.includes(s)){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);if(C){this._moveControlInSuitableCollection(C,this._getControlPriority(C));}this._informNewFlexibleContentAdded(C);var v=this._callToolbarMethod("addAggregation",h);this._updateSeparators();return v;}return O.prototype.addAggregation.apply(this,arguments);};
e.prototype.destroyAggregation=function(s){if(s==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.");}if(f.includes(s)){var C=this.removeAllAggregation(s);for(var i=0;i<C.length;i++){C[i].destroy();}this._updateSeparators();return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
e.prototype.insertAggregation=function(s,C,i){if(s==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.");}if(f.includes(s)){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);if(C){this._moveControlInSuitableCollection(C,this._getControlPriority(C));}this._informNewFlexibleContentAdded(C);var v=this._callToolbarMethod("insertAggregation",arguments);this._updateSeparators();return v;}return O.prototype.insertAggregation.apply(this,arguments);};
e.prototype.removeAllAggregation=function(s){if(s==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.");}return O.prototype.removeAllAggregation.apply(this,arguments);};
e.prototype.removeAggregation=function(s,o){if(s==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.");}if(f.includes(s)){var C=this._callToolbarMethod("removeAggregation",arguments);if(C){this._getPopover().removeAssociatedContent(C.getId());}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(C);this._removeContentFromControlsCollections(C);this._updateSeparators();return C;}return O.prototype.removeAggregation.apply(this,arguments);};
e.prototype.setUseAsHeader=function(h){this.setProperty("useAsHeader",h,true);this.toggleStyleClass("sapMTBHeader-CTX",!!h);return this;};
e.prototype.getEndActionsBegin=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:A.Begin});};
e.prototype.getEndActionsEnd=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:A.End});};
e.prototype.getActionsWithLayoutInformation=function(l){return this.getActions().filter(function(o){var h=o.getLayoutInformation();return h.aggregationName===l.aggregationName&&h.alignment===l.alignment;});};
e.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);this._updateSeparators();};
e.prototype._onContentPropertyChangedOverflowToolbar=function(o){if(this._bIsBeingDestroyed){return;}O.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(o.getParameter("name")==="visible"||o.getParameter("name")==="width"&&o.getSource()!=this._oBeginSeparator){this._updateSeparators();}};
e.prototype._hasVisible=function(h){var p=this.getAggregation("_popover")?this.getAggregation("_popover")._getAllContent():[];var v=h.filter(function(C){return p.indexOf(C)===-1;});return v.some(function(C){var H=C.getWidth?C.getWidth()!=="0px":true;return C.getVisible()&&H;});};
e.prototype._updateSeparators=function(){var h=this._hasVisible(this.getEnd());if(this._oBeginSeparator){var H=this._hasVisible(this.getBegin());var i=this._hasVisible(this.getBetween());this._oBeginSeparator.setVisible(H&&i);}if(this._oEndActionsBeginSeparator){var j=this._hasVisible(this.getEndActionsBegin());this._oEndActionsBeginSeparator.setVisible(h&&j);}if(this._oEndActionsEndSeparator){var k=this._hasVisible(this.getEndActionsEnd());this._oEndActionsEndSeparator.setVisible(h&&k);}};
e.prototype.indexOfContent=function(o){return this.getContent().indexOf(o);};
e.prototype.getContent=function(){var C=this.getBegin();C.push(this._oBeginSeparator);C=C.concat(this.getBetween());C.push(this._oSpacer);C=C.concat(this.getEndActionsBegin());C.push(this._oEndActionsBeginSeparator);C=C.concat(this.getEnd());C.push(this._oEndActionsEndSeparator);C=C.concat(this.getEndActionsEnd());return C;};
e.prototype.getCurrentState=function(){var h=[],i;this.getActions().forEach(function(o,I){i=o&&o.getId();if(o.getVisible()){h.push({name:i,alignment:o.getLayoutInformation().alignment});}});return{items:h};};
e.prototype.initPropertyHelper=function(){return Promise.resolve({getProperties:function(){var i=[];this.getActions().forEach(function(o){i.push({name:o.getId(),alignment:o.getLayoutInformation().alignment,label:o.getLabel(),visible:true});});return i;}.bind(this)});};
return e;});
sap.ui.predefine('sap/ui/mdc/ChartDelegate',["sap/ui/mdc/AggregationBaseDelegate"],function(A){"use strict";var C=Object.assign({},A);
C.zoomIn=function(v){};
C.zoomOut=function(v){};
C.getZoomState=function(){};
C.getInnerChartSelectionHandler=function(){};
C.setLegendVisible=function(v){};
C.getSorterForItem=function(m,s){};
C.insertItemToInnerChart=function(m,i){};
C.removeItemFromInnerChart=function(m){};
C.addItem=function(p,m,P,r){};
C.removeItem=function(p,m){return Promise.resolve(true);};
C.initializeInnerChart=function(m){};
C.createInitialChartContent=function(m){};
C.getInnerChart=function(){};
C.getChartTypeInfo=function(){};
C.getChartTypeLayoutConfig=function(){};
C.getAvailableChartTypes=function(){};
C.getDrillStack=function(){};
C.getSortedDimensions=function(m){};
C.getDrillableItems=function(m){};
C.setChartType=function(c){};
C.createInnerChartContent=function(m,c){};
C.rebindChart=function(m,b){};
C.rebind=function(m,b){};
C.getInnerChartBound=function(){};
C.updateBindingInfo=function(m,b){};
C.setChartTooltipVisibility=function(f){};
C.getInternalChartNameFromPropertyNameAndKind=function(n,k,m){};
C.getPropertyFromNameAndKind=function(n,k,m){};
C.initPropertyHelper=function(m){return Promise.resolve(true);};
C.fetchProperties=function(m){};
return C;});
sap.ui.predefine('sap/ui/mdc/Delegate',[],function(){"use strict";var D=function(){};
D.retrieveAllMetadata=function(m,d){return[];};
D.retrieveAggregationItem=function(a,m){return null;};
D.preConfiguration=function(n,v){return n;};
D.getNavigationTargets=function(f){return[];};
return D;});
sap.ui.predefine('sap/ui/mdc/FilterBar',['sap/ui/mdc/p13n/subcontroller/FilterController','sap/ui/mdc/p13n/subcontroller/AdaptFiltersController',"sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer",'sap/m/library','sap/m/Button',"sap/ui/mdc/p13n/StateUtil","sap/base/util/merge","sap/ui/mdc/filterbar/p13n/AdaptationFilterBar","sap/ui/core/library"],function(F,A,a,b,c,d,l,B,S,m,e,C){"use strict";var H=C.aria.HasPopup;
var f=c.extend("sap.ui.mdc.FilterBar",{
metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},p13nMode:{type:"sap.ui.mdc.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false},_p13nModeValue:{type:"boolean",visibility:"hidden",defaultValue:false}}},
renderer:d
});
var g=l.ButtonType;
f.prototype._createInnerLayout=function(){this._cLayoutItem=b;this._oFilterBarLayout=new a();this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons();};
f.prototype.setP13nMode=function(M){var o=this.getP13nMode();this.setProperty("p13nMode",M||[],false);var r={};r.controller={};M&&M.forEach(function(s){if(!o||o.indexOf(s)<0){this._setP13nMode(s,true);}if(s=="Item"){r.controller["Item"]=A;}if(s=="Value"){r.controller["Filter"]=F;}}.bind(this));o&&o.forEach(function(s){if(!M||M.indexOf(s)<0){this._setP13nMode(s,false);}}.bind(this));this.getEngine().registerAdaptation(this,r);return this;};
f.prototype._setP13nMode=function(M,v){switch(M){case"Item":this._setP13nModeItem(v);break;case"Value":this._setP13nModeValue(v);break;}};
f.prototype.setFilterConditions=function(v,s){F.checkConditionOperatorSanity(v);if(this._oP13nFB){this._oP13nFB.setFilterConditions(m({},v));}this.setProperty("filterConditions",v,s);return this;};
f.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem");};
f.prototype._setP13nModeItem=function(v){this._oModel.setProperty("/_p13nModeItem",v,true);};
f.prototype._getP13nModeValue=function(){return this._oModel.getProperty("/_p13nModeValue");};
f.prototype._setP13nModeValue=function(v){this._oModel.setProperty("/_p13nModeValue",v,false);this._bPersistValues=v;};
f.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new B(this.getId()+"-btnAdapt",{type:g.Transparent,text:"{"+c.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setAriaHasPopup(H.ListBox);this._btnAdapt.setModel(this._oModel,c.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:'/showAdaptFiltersButton',model:c.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:c.INNER_MODEL_NAME}],formatter:function(v,V){return v&&V;}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,c.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:'/showGoButton',model:c.INNER_MODEL_NAME},{path:"/liveMode",model:c.INNER_MODEL_NAME}],formatter:function(v,V){return v&&((this._isPhone())?true:!V);}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnAdapt);}};
f.prototype.retrieveInbuiltFilter=function(){var i=c.prototype.retrieveInbuiltFilter.apply(this,arguments);return i.then(function(I){I._bPersistValues=this._bPersistValues;return I;}.bind(this));};
f.prototype.onAdaptFilters=function(E){return this._retrieveMetadata().then(function(){return this.getEngine().uimanager.show(this,"Item",this._btnAdapt);}.bind(this));};
f.prototype.getCurrentState=function(){var s=c.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete s.items;}return s;};
c.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField();};
return f;});
sap.ui.predefine('sap/ui/mdc/FilterBarDelegate',["sap/ui/mdc/AggregationBaseDelegate"],function(A){"use strict";var F=Object.assign({},A);
F.addItem=function(p,f,P){return Promise.resolve(null);};
F.removeItem=function(p,f,P){return Promise.resolve(true);};
return F;});
sap.ui.predefine('sap/ui/mdc/Link',["sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library"],function(F,q,B,J,L,S,P,a,b,C,l){"use strict";var R=l.form.SimpleFormLayout.ResponsiveGridLayout;
var c=F.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});
c.prototype.applySettings=function(){F.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};
c.prototype.init=function(){var m=new J({contentTitle:undefined,linkItems:[]});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._bLinkItemsFetched=false;this._aLinkItems=[];this._oLinkType=null;F.prototype.init.apply(this,arguments);};
c.prototype.isTriggerable=function(){return this.retrieveLinkType().then(function(o){var r=o.runtimeType;var i=o.initialType?o.initialType:o;if(r&&r instanceof Promise){r.then(function(d){if(!this._oLinkType||d.linkType!==this._oLinkType.linkType){this._oLinkType=d;this.fireDataUpdate();}}.bind(this));}return this._oLinkType?this._oLinkType.type>0:i.type>0;}.bind(this));};
c.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(function(o){return o?o.href:null;});};
c.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(function(d){this.addDependent(d);return d?{target:d.getTarget(),href:d.getHref()}:null;}.bind(this));};
c.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(function(o){if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink;}var d=o.initialType?o.initialType:o;if(this._linkTypeHasDirectLink(d)){return d.directLink;}return null;}.bind(this));};
c.prototype._linkTypeHasDirectLink=function(o){return o&&o.type===1&&o.directLink;};
c.prototype.getContent=function(g){var o=this.retrieveLinkItems();var A=this.retrieveAdditionalContent();return Promise.all([o,A]).then(function(v){var d=v[0];var e=v[1];return new Promise(function(r){sap.ui.require(['sap/ui/fl/Utils','sap/ui/fl/apply/api/FlexRuntimeInfoAPI'],function(U,f){this._setConvertedLinkItems(d);var m=this._getInternalModel().getProperty("/linkItems");var M=this._getInternalModel().getProperty("/baselineLinkItems");var p=!e.length&&!m.length?this._getNoContent():e;var h=new P(this._createPanelId(U,f),{enablePersonalization:this.getEnablePersonalization(),items:M.map(function(i){return new a(i.key,{text:i.text,description:i.description,href:i.href,target:i.target,icon:i.icon,visible:true});}),additionalContent:p,beforeSelectionDialogOpen:function(){if(g&&g()){g().setModal(true);}},afterSelectionDialogClose:function(){if(g&&g()){g().setModal(false);}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});h.setModel(new J({metadata:q.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:q.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");return r(h);}.bind(this));}.bind(this));}.bind(this));};
c.prototype._setConvertedLinkItems=function(d){var m=this._getInternalModel();var M=d.map(function(o){if(!o.getKey()){S.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+o.getId()+". The mandatory 'key' property should be defined due to personalization reasons.");}return{key:o.getKey(),text:o.getText(),description:o.getDescription(),href:o.getHref(),target:o.getTarget(),icon:o.getIcon(),initiallyVisible:o.getInitiallyVisible(),visible:false};});m.setProperty("/linkItems/",M);var e=M.filter(function(o){return o.initiallyVisible;});m.setProperty("/baselineLinkItems/",e);};
c.prototype._getNoContent=function(){var s=new b({layout:R,content:[new C({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});s.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return s;};
c.prototype._createPanelId=function(U,d){var f;if(this.getParent()){f=this.getParent();}var o=typeof this.getSourceControl()==="string"?sap.ui.getCore().byId(this.getSourceControl()):this.getSourceControl();if(!o){this.setSourceControl(f);o=f;}if(!d.isFlexSupported({element:this})||!d.isFlexSupported({element:o})){S.error("Invalid component. The mandatory 'sourceControl' association should be assigned to the app component due to personalization reasons.");return this.getId()+"-idInfoPanel";}var A=U.getAppComponentForControl(o)||U.getAppComponentForControl(f);return A.createId("idInfoPanel");};
c.retrieveAllMetadata=function(p){if(!p.getModel||!p.getModel("$sapuimdcLink")){return[];}var m=p.getModel("$sapuimdcLink");return m.getProperty("/metadata").map(function(M){return{id:M.key,text:M.text,description:M.description,href:M.href,target:M.target,visible:M.visible};});};
c.retrieveBaseline=function(p){if(!p.getModel||!p.getModel("$sapuimdcLink")){return[];}var m=p.getModel("$sapuimdcLink");return m.getProperty("/baseline").map(function(M){return{id:M.key,visible:true};});};
c.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog;}if(S.getLevel()>=S.Level.INFO){this._oInfoLog=new L();this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog;}}return undefined;};
c.prototype._getContextObject=function(o){return o?o.getObject(o.getPath()):undefined;};
c.prototype.retrieveAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());return this.getControlDelegate().fetchAdditionalContent(p,this).then(function(A){return A;});}.bind(this));}S.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([]);};
c.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());return this.getControlDelegate().fetchLinkType(p,this);}.bind(this));}S.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null);};
c.prototype.retrieveLinkItems=function(){var p=Object.assign({},this.getPayload());var o=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(function(u){return this.getControlDelegate().modifyLinkItems(p,o,u).then(function(d){return d;});}.bind(this));};
c.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems);}else{this.oUseDelegateItemsPromise=this._useDelegateItems();return this.oUseDelegateItemsPromise.then(function(){return Promise.resolve(this._aLinkItems);}.bind(this));}};
c.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(function(){var p=Object.assign({},this.getPayload());var o=this._getControlBindingContext();var i=this._getInfoLog();return new Promise(function(r){this.getControlDelegate().fetchLinkItems(p,o,i).then(function(d){this._setLinkItems(d===null?[]:d);this._bLinkItemsFetched=d!==null;r();}.bind(this));}.bind(this));}.bind(this));}S.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve();};
c.prototype._setLinkItems=function(d){var e=d.filter(function(o){return o.getParent()===null;});e.forEach(function(o){this.addDependent(o);}.bind(this));this._aLinkItems=d;};
c.prototype._beforeNavigationCallback=function(e){if(this.awaitControlDelegate()){var p=Object.assign({},this.getPayload());return this.getControlDelegate().beforeNavigationCallback(p,e);}S.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve();};
c.prototype._getControlBindingContext=function(){var o=typeof this.getSourceControl()==="string"?sap.ui.getCore().byId(this.getSourceControl()):this.getSourceControl();return o&&o.getBindingContext()||this.getBindingContext();};
c.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink");};
return c;});
sap.ui.predefine('sap/ui/mdc/LinkDelegate',['sap/ui/mdc/BaseDelegate'],function(B){"use strict";var L=Object.assign({},B,{fetchLinkItems:function(p,b,i){return Promise.resolve(null);},fetchLinkType:function(p,l){return Promise.resolve({initialType:{type:2,directLink:undefined},runtimeType:null});},fetchAdditionalContent:function(p,l){return Promise.resolve([]);},modifyLinkItems:function(p,b,l){return Promise.resolve(l);},beforeNavigationCallback:function(p,e){return Promise.resolve(true);}});return L;});
sap.ui.predefine('sap/ui/mdc/Table',["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/ResponsiveTableType","./table/PropertyHelper","./mixin/FilterIntegrationMixin","./library","sap/m/Text","sap/m/Title","sap/m/ColumnHeaderPopover","sap/m/OverflowToolbar","sap/m/library","sap/ui/core/Core","sap/ui/core/format/NumberFormat","sap/ui/core/dnd/DragDropInfo","sap/ui/core/Item","sap/ui/core/format/ListFormat","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/model/Sorter","sap/ui/dom/containsOrEquals","sap/base/strings/capitalize","sap/base/util/deepEqual","sap/base/util/Deferred","sap/ui/core/InvisibleMessage","sap/ui/core/InvisibleText","sap/ui/mdc/p13n/subcontroller/ColumnController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/GroupController","sap/ui/mdc/p13n/subcontroller/AggregateController","sap/m/ColumnPopoverSelectListItem","sap/m/ColumnPopoverActionItem","sap/ui/mdc/p13n/subcontroller/ColumnWidthController","sap/ui/mdc/actiontoolbar/ActionToolbarAction"],function(C,A,T,G,R,P,F,l,a,b,c,O,M,d,N,D,I,L,e,K,S,f,g,h,i,j,k,m,n,o,p,q,r,s,t,u){"use strict";var v=l.SelectionMode;var w=l.TableType;var x=l.RowAction;var y=M.ToolbarDesign;var z=M.ToolbarStyle;var B=l.MultiSelectMode;var E=e.TitleLevel;var H=new window.WeakMap();var J=function(e1){if(!H.has(e1)){H.set(e1,{oFilterInfoBar:null});}return H.get(e1);};
function Q(e1,f1){sap.ui.require(["sap/m/MessageToast"],function(g1){var h1=d.getLibraryResourceBundle("sap.ui.mdc");g1.show(h1.getText(e1,f1));});}
var U=C.extend("sap.ui.mdc.Table",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},rowAction:{type:"sap.ui.mdc.RowAction[]",defaultValue:[]},p13nMode:{type:"sap.ui.mdc.TableP13nMode[]",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:E.Auto},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},header:{type:"string",group:"Misc",defaultValue:null},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},selectionMode:{type:"sap.ui.mdc.SelectionMode",defaultValue:v.None},showRowCount:{type:"boolean",group:"Misc",defaultValue:true},threshold:{type:"int",group:"Appearance",defaultValue:-1},noDataText:{type:"string"},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},groupConditions:{type:"object"},aggregateConditions:{type:"object"},enableExport:{type:"boolean",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100},enableColumnResize:{type:"boolean",group:"Behavior",defaultValue:true},showPasteButton:{type:"boolean",group:"Behavior",defaultValue:false},enablePaste:{type:"boolean",group:"Behavior",defaultValue:true},multiSelectMode:{type:"sap.ui.mdc.MultiSelectMode",group:"Behavior",defaultValue:B.Default},enableAutoColumnWidth:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false},dataStateIndicator:{type:"sap.m.plugins.DataStateIndicator",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{bindingContext:{type:"sap.ui.model.Context"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},beforeExport:{parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"}}},paste:{parameters:{data:{type:"string[][]"}}}}},
constructor:function(){this._oTableReady=new i();this._oFullInitialize=new i();C.apply(this,arguments);this.bCreated=true;this._doOneTimeOperations();this._initializeContent();},
renderer:{apiVersion:2,render:function(e1,f1){e1.openStart("div",f1);e1.class("sapUiMdcTable");e1.style("height",f1.getHeight());e1.style("width",f1.getWidth());e1.openEnd();e1.renderControl(f1.getAggregation("_content"));e1.close("div");}}
});
var V=["variant","quickFilter"];F.call(U.prototype);V.forEach(function(e1){var f1=g(e1),g1="_o"+f1,h1="get"+f1,i1="set"+f1,j1="destroy"+f1;U.prototype[h1]=function(){return this[g1];};U.prototype[j1]=function(){var k1=this[g1];this[i1]();if(k1){k1.destroy();}return this;};U.prototype[i1]=function(k1){this.validateAggregation(e1,k1,false);var l1=this._createToolbar(),m1=k1!==this[g1];if(!k1||m1){l1.removeBetween((this[h1]()));this[g1]=k1;}if(m1&&k1){this._setToolbarBetween(l1);}return this;};});
U.prototype.init=function(){C.prototype.init.apply(this,arguments);this._bForceRebind=true;this._updateAdaptation(this.getP13nMode());this.mSkipPropagation={rowSettings:true};};
U.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.initControlDelegate();};
U.prototype._setToolbarBetween=function(e1){[this._oVariant,this._oQuickFilter].forEach(function(f1){if(f1){e1.addBetween(f1);}});};
U.prototype.initialized=function(){return this._oTableReady.promise;};
U.prototype._fullyInitialized=function(){return this._oFullInitialize.promise;};
U.prototype.getDataStateIndicatorPluginOwner=function(e1){return this._oTable||this._oFullInitialize.promise;};
U.prototype.setDataStateIndicator=function(e1){this._handleDataStateEvents(this.getDataStateIndicator(),"detach");this.setAggregation("dataStateIndicator",e1,true);this._handleDataStateEvents(this.getDataStateIndicator(),"attach");return this;};
U.prototype._handleDataStateEvents=function(e1,f1){if(e1){e1[f1+"ApplyFilter"](this._onApplyMessageFilter,this);e1[f1+"ClearFilter"](this._onClearMessageFilter,this);e1[f1+"Event"]("filterInfoPress",d1,this);}};
U.prototype._onApplyMessageFilter=function(e1){this._oMessageFilter=e1.getParameter("filter");e1.preventDefault();this._rebind();};
U.prototype._onClearMessageFilter=function(e1){this._oMessageFilter=null;e1.preventDefault();this._rebind();};
U.prototype._getStringType=function(e1){var f1,g1=f1=e1||this.getType();if(!g1){f1=w.Table;}else if(typeof g1==="object"){if(g1.isA("sap.ui.mdc.table.ResponsiveTableType")){f1=w.ResponsiveTable;}else{f1=w.Table;}}return f1;};
U.prototype._isOfType=function(e1){return this._getStringType()===e1;};
U.prototype._updateTypeSettings=function(){var e1=this.getType();if(e1&&typeof e1==="object"){e1.updateTableSettings();}else{if(e1==="ResponsiveTable"){e1=R;}else{e1=G;}e1.updateDefault(this._oTable);}};
U.prototype.scrollToIndex=function(e1){return new Promise(function(f1,g1){if(!this._oTable){return g1();}if(typeof e1!=="number"){return g1("The iIndex parameter has to be a number");}if(this._isOfType(w.ResponsiveTable)){this._oTable.scrollToIndex(e1).then(f1).catch(g1);}else{if(e1===-1){e1=this._getRowCount(false);}if(this._oTable._setFirstVisibleRowIndex(e1)){this._oTable.attachEventOnce("rowsUpdated",function(){f1();});}else{f1();}}}.bind(this));};
U.prototype.focusRow=function(e1,f1){return this.scrollToIndex(e1).then(function(){return this._oTable._setFocus(e1,f1);}.bind(this));};
U.prototype.setType=function(e1){var f1=this._getStringType(e1);var g1=this._getStringType();this.setAggregation("type",e1,true);if(f1===g1&&this._oTable){this._updateTypeSettings();return this;}if(this.bCreated){if(this._oTable){if(g1==="ResponsiveTable"){this._oTable.setHeaderToolbar();}else{this._oTable.removeExtension(this._oToolbar);}this._oTable.destroy("KeepDom");this._oTable=null;this._bTableExists=false;}else{this._onAfterTableCreated();this._onAfterFullInitialization();}if(this._oTemplate){this._oTemplate.destroy();this._oTemplate=null;}this._oTableReady=new i();this._oFullInitialize=new i();this._bFullyInitialized=false;this._initializeContent();}return this;};
U.prototype.setRowSettings=function(e1){this.setAggregation("rowSettings",e1,true);if(this._oTable){if(this._isOfType(w.ResponsiveTable)){R.updateRowSettings(this._oTemplate,e1);}else{G.updateRowSettings(this._oTable,e1);}this._bForceRebind=true;this._rebind();}return this;};
U.prototype.setHeaderLevel=function(e1){if(this.getHeaderLevel()===e1){return this;}this.setProperty("headerLevel",e1,true);this._oTitle&&this._oTitle.setLevel(e1);return this;};
U.prototype.focus=function(e1){var f1=this.getDomRef();if(this._oTable&&f1&&!f(f1,document.activeElement)){this._oTable.focus();}};
U.prototype.setBusy=function(e1){this.setProperty('busy',e1,true);if(this._oTable){this._oTable.setBusy(e1);}return this;};
U.prototype.setBusyIndicatorDelay=function(e1){this.setProperty('busyIndicatorDelay',e1,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(e1);}return this;};
U.prototype.setSelectionMode=function(e1){var f1=this.getSelectionMode();this.setProperty("selectionMode",e1,true);if(this._oTable&&f1!=this.getSelectionMode()){this._updateSelectionBehavior();}return this;};
U.prototype.setMultiSelectMode=function(e1){var f1=this.getMultiSelectMode();this.setProperty("multiSelectMode",e1,true);if(this._oTable&&f1!=this.getMultiSelectMode()){this._updateMultiSelectMode();}return this;};
U.prototype.setRowAction=function(e1){var f1=this.getRowAction();this.setProperty("rowAction",e1,true);if(!h(f1.sort(),this.getRowAction().sort())){this._updateRowAction();}return this;};
U.prototype.setCreationRow=function(e1){this.setAggregation("creationRow",e1,true);if(e1){e1.update();}return this;};
U.prototype.setEnableColumnResize=function(e1){var f1=this.getEnableColumnResize();this.setProperty("enableColumnResize",e1,true);if(this.getEnableColumnResize()!==f1){this._updateColumnResizer();this._updateAdaptation(this.getP13nMode());}return this;};
U.prototype._onModifications=function(){if(!this._oTable){return;}var e1=this.getCurrentState().xConfig;var f1=e1.aggregations&&e1.aggregations.columns;this.getColumns().forEach(function(g1,h1){var i1=f1&&f1[g1.getDataProperty()]&&f1[g1.getDataProperty()].width;var j1=this._oTable.getColumns()[h1];if(!i1&&j1.getWidth()!==g1.getWidth()){j1.setWidth(g1.getWidth());}else if(i1&&i1!==j1.getWidth()){j1.setWidth(i1);}},this);};
U.prototype.setP13nMode=function(e1){var f1=this.getP13nMode();var g1=null;if(e1&&e1.length>1){g1=[];var h1=e1.reduce(function(i1,j1,k1){i1[j1]=true;return i1;},{});if(h1.Column){g1.push("Column");}if(h1.Sort){g1.push("Sort");}if(h1.Filter){g1.push("Filter");}if(h1.Group){g1.push("Group");}if(h1.Aggregate){g1.push("Aggregate");}}else{g1=e1;}this.setProperty("p13nMode",g1,true);this._updateAdaptation(this.getP13nMode());if(!h(f1.sort(),this.getP13nMode().sort())){W(this);}return this;};
U.prototype._updateAdaptation=function(e1){var f1={controller:{}};var g1={Column:m,Sort:n,Group:p,Filter:o,Aggregate:q,ColumnWidth:t};e1.forEach(function(h1){var i1=h1;f1.controller[i1]=g1[h1];});if(this.getEnableColumnResize()){f1.controller["ColumnWidth"]=g1["ColumnWidth"];}this.getEngine().registerAdaptation(this,f1);};
function W(e1){if(e1._oToolbar){e1._oToolbar.destroyEnd();e1._getP13nButtons().forEach(function(g1){e1._oToolbar.addEnd(g1);});}if(e1._oTable){var f1=e1._oTable.getDragDropConfig()[0];if(f1){f1.setEnabled(e1.getP13nMode().indexOf("Column")>-1);}}if(e1.isFilteringEnabled()){Y(e1);}X(e1);}
U.prototype.setFilterConditions=function(e1){this.setProperty("filterConditions",e1,true);var f1=this.getInbuiltFilter();if(f1){f1.setFilterConditions(e1);}X(this);return this;};
function X(e1){var f1=$(e1);var g1=_(e1);var h1=a1(e1);if(!f1){return;}if(h1.length===0||!e1.isFilteringEnabled()){var i1=f1.getDomRef();if(i1&&i1.contains(document.activeElement)){e1.focus();}f1.setVisible(false);e1._oTable.removeAriaLabelledBy(g1);return;}e1._fullyInitialized().then(function(){var j1=e1.getPropertyHelper();var k1=h1.map(function(o1){return j1.hasProperty(o1)?j1.getProperty(o1).label:"";});var l1=d.getLibraryResourceBundle("sap.ui.mdc");var m1=L.getInstance();var n1=l1.getText("table.FILTER_INFO",m1.format(k1));if(!f1.getVisible()){f1.setVisible(true);e1._oTable.addAriaLabelledBy(g1);}g1.setText(n1);});}
function Y(e1){if(!e1._oTable){return;}var f1=$(e1);if(!f1){f1=Z(e1);}if(e1._bMobileTable){if(e1._oTable.getInfoToolbar()!==f1){e1._oTable.setInfoToolbar(f1);}}else if(e1._oTable.indexOfExtension(f1)===-1){e1._oTable.insertExtension(f1,1);}if(f1.getVisible()){e1._oTable.addAriaLabelledBy(_(e1));}}
function Z(e1){var f1=e1.getId()+"-filterInfoBar";var g1=J(e1).oFilterInfoBar;if(g1&&!g1.bIsDestroyed){g1.destroy();}g1=new O({id:f1,active:true,design:y.Info,visible:false,content:[new a({id:f1+"-text",wrapping:false})],press:[d1,e1]});g1.focus=function(){if(this.getDomRef()){O.prototype.focus.apply(this,arguments);}else{e1.focus();}};J(e1).oFilterInfoBar=g1;X(e1);return g1;}
function $(e1){var f1=J(e1).oFilterInfoBar;if(f1&&(f1.bIsDestroyed||f1.bIsBeingDestroyed)){return null;}return J(e1).oFilterInfoBar;}
function _(e1){var f1=$(e1);return f1?f1.getContent()[0]:null;}
U.prototype.setThreshold=function(e1){this.setProperty("threshold",e1,true);if(!this._oTable){return this;}e1=this.getThreshold()>-1?this.getThreshold():undefined;if(this._bMobileTable){this._oTable.setGrowingThreshold(e1);}else{this._oTable.setThreshold(e1);}return this;};
U.prototype._onFilterProvided=function(e1){this._updateInnerTableNoDataText();};
U.prototype._onFilterRemoved=function(e1){this._updateInnerTableNoDataText();};
U.prototype._onFiltersChanged=function(e1){if(this.isTableBound()&&e1.getParameter("conditionsBased")){this._oTable.setShowOverlay(true);}};
U.prototype._onFilterSearch=function(e1){this._bIgnoreChange=true;this._bAnnounceTableUpdate=true;};
U.prototype.setNoDataText=function(e1){this.setProperty("noDataText",e1,true);this._updateInnerTableNoDataText();return this;};
U.prototype._updateInnerTableNoDataText=function(){if(!this._oTable){return;}var e1=this._getNoDataText();if(this._bMobileTable){this._oTable.setNoDataText(e1);}else{this._oTable.setNoData(e1);}};
U.prototype._getNoDataText=function(){var e1=this.getNoDataText();if(e1){return e1;}var f1=d.getLibraryResourceBundle("sap.ui.mdc");if(!this.isTableBound()){if(this.getFilter()){return f1.getText("table.NO_DATA_WITH_FILTERBAR");}return f1.getText("table.NO_DATA");}return f1.getText("table.NO_RESULTS");};
U.prototype._updateRowAction=function(){if(!this._oTable){return;}var e1=this.getRowAction().indexOf(x.Navigation)>-1;var f1=this._bMobileTable?R:G;f1.updateRowAction(this,e1,this._bMobileTable?undefined:this._onRowActionPress);};
U.prototype._initializeContent=function(){var e1,f1=this._getStringType();if(this._isOfType(w.ResponsiveTable)){e1=R;}else{e1=G;}var g1=[this.awaitControlDelegate(),e1.loadTableModules()];if(this.isFilteringEnabled()){g1.push(this.retrieveInbuiltFilter());}Promise.all(g1).then(function(){if(this.bIsDestroyed){return;}var h1=this.getControlDelegate();if(h1.preInit){this._pDelegatePreInit=h1.preInit(this);}if(!this._bTableExists&&f1===this._getStringType()){this._bMobileTable=f1==="ResponsiveTable";this._createContent();this._bTableExists=true;}}.bind(this)).catch(function(h1){this._onAfterTableCreated();throw h1;}.bind(this));};
U.prototype._doOneTimeOperations=function(){if(!this.bColumnsOrdered){this.bColumnsOrdered=true;this._orderColumns();}};
U.prototype._onAfterTableCreated=function(e1){this._oTableReady[e1?"resolve":"reject"](this);};
U.prototype._onAfterFullInitialization=function(e1){this._oFullInitialize[e1?"resolve":"reject"](this);};
U.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateColumnResizer();this._updateRowAction();this.getColumns().forEach(this._insertInnerColumn,this);this.setAggregation("_content",this._oTable);this._onAfterTableCreated(true);var e1=this.initialized().then(function(){this.initPropertyHelper(P);var f1=this.getCreationRow();if(f1){f1.update();}if(this.getAutoBindOnInit()){this.rebind();}return this.awaitPropertyHelper();}.bind(this));Promise.all([e1,this._pDelegatePreInit]).then(function(){delete this._pDelegatePreInit;this._bFullyInitialized=true;this._onAfterFullInitialization(true);}.bind(this)).catch(function(f1){this._onAfterFullInitialization();throw f1;}.bind(this));};
U.prototype.setHeader=function(e1){this.setProperty("header",e1,true);this._updateHeaderText();this._updateExportState(true);return this;};
U.prototype.setHeaderVisible=function(e1){this.setProperty("headerVisible",e1,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px");}return this;};
U.prototype.setShowRowCount=function(e1){this.setProperty("showRowCount",e1,true);this._updateHeaderText();return this;};
U.prototype.setEnableExport=function(e1){if(e1!==this.getEnableExport()){this.setProperty("enableExport",e1,true);if(e1&&!this._oExportButton&&this._oToolbar){this._oToolbar.addEnd(this._getExportButton());}else if(this._oExportButton){this._oExportButton.setVisible(e1);}}return this;};
U.prototype.setShowPasteButton=function(e1){if((e1=!!e1)==this.getShowPasteButton()){return this;}this.setProperty("showPasteButton",e1,true);if(e1&&!this._oPasteButton&&this._oToolbar){this._oToolbar.insertEnd(this._getPasteButton(),0);this._oPasteButton.setEnabled(this.getEnablePaste());}else if(this._oPasteButton){this._oPasteButton.setVisible(e1);this._oPasteButton.setEnabled(this.getEnablePaste());}return this;};
U.prototype.setEnablePaste=function(e1){this.setProperty("enablePaste",e1,true);if(this._oPasteButton){this._oPasteButton.setEnabled(this.getEnablePaste());}return this;};
U.prototype._createToolbar=function(){if(this.isDestroyStarted()||this.isDestroyed()){return;}if(!this._oToolbar){this._oTitle=new b(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel()});this._oToolbar=new A(this.getId()+"-toolbar",{design:y.Transparent,style:this._isOfType(w.ResponsiveTable)?z.Standard:z.Clear,begin:[this._oTitle],end:[this._getPasteButton(),this._getP13nButtons(),this._getExportButton()]});}return this._oToolbar;};
U.prototype._getVisibleProperties=function(){var e1=[],f1;this.getColumns().forEach(function(g1,h1){f1=g1&&g1.getDataProperty();if(f1){e1.push({name:f1});}});return e1;};
U.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[];};
U.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[];};
U.prototype._getGroupedProperties=function(){return this.getGroupConditions()?this.getGroupConditions().groupLevels:[];};
U.prototype._getAggregatedProperties=function(){return this.getAggregateConditions()?this.getAggregateConditions():{};};
U.prototype._getXConfig=function(){return this.getEngine().readXConfig(this);};
function a1(e1){var f1=e1.getFilterConditions();return Object.keys(f1).filter(function(g1){return f1[g1].length>0;});}
U.prototype.getCurrentState=function(){var e1={};var f1=this.getP13nMode();if(f1.indexOf("Column")>-1){e1.items=this._getVisibleProperties();}if(this.isSortingEnabled()){e1.sorters=this._getSortedProperties();}if(this.isFilteringEnabled()){e1.filter=this.getFilterConditions();}if(this.isGroupingEnabled()){e1.groupLevels=this._getGroupedProperties();}if(this.isAggregationEnabled()){e1.aggregations=this._getAggregatedProperties();}if(this.getEnableColumnResize()){e1.xConfig=this._getXConfig();}return e1;};
U.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1;};
U.prototype.isSortingEnabled=function(){return this.getP13nMode().indexOf("Sort")>-1;};
U.prototype.isGroupingEnabled=function(){return this.getP13nMode().indexOf("Group")>-1;};
U.prototype.isAggregationEnabled=function(){return this.getP13nMode().indexOf("Aggregate")>-1;};
U.prototype._getP13nButtons=function(){var e1=this.getP13nMode();var f1=[];var g1=e1.length===1&&e1[0]==="Aggregate";if(e1.length>0&&!g1){f1.push(T.createSettingsButton(this.getId(),[c1,this]));}return f1;};
U.prototype._getPasteButton=function(){if(this.getShowPasteButton()){if(!this._oPasteButton){this._oPasteButton=T.createPasteButton(this.getId());}return this._oPasteButton;}};
U.prototype._getExportButton=function(){if(!this.getEnableExport()){return null;}var e1={fileName:this.getHeader()};if(!this._cachedExportSettings){this._cachedExportSettings=e1;}if(!this._oExportButton){this._oExportButton=T.createExportButton(this.getId(),{"default":[function(){this._onExport(e1);},this],"exportAs":[this._onExportAs,this]});}this._updateExportState();return this._oExportButton;};
U.prototype._updateExportState=function(e1){if(this._oExportButton){this._oExportButton.setEnabled(this._getRowCount(false)>0);if(e1&&this._cachedExportSettings){this._cachedExportSettings.fileName=this.getHeader();}}};
U.prototype._createExportColumnConfiguration=function(e1){var f1=e1&&e1.splitCells;var g1=this.getColumns();return this._fullyInitialized().then(function(){var h1=this.getPropertyHelper();var i1=[];g1.forEach(function(j1){var k1=h1.getColumnExportSettings(j1,f1);i1=i1.concat(k1);},this);return[i1,h1];}.bind(this));};
U.prototype._onExport=function(e1){var f1=this;return this._createExportColumnConfiguration(e1).then(function(g1){var h1=g1[0];var i1=g1[1];if(!h1||!h1.length){sap.ui.require(["sap/m/MessageBox"],function(l1){l1.error(d.getLibraryResourceBundle("sap.ui.mdc").getText("table.NO_COLS_EXPORT"),{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":""});}.bind(f1));return;}var j1=f1._getRowBinding();var k1={workbook:{columns:h1},dataSource:j1,fileType:e1.selectedFileType=="pdf"?"PDF":"XLSX",fileName:e1?e1.fileName:f1.getHeader()};f1._loadExportLibrary().then(function(){sap.ui.require(["sap/ui/export/ExportUtils"],function(l1){var m1=Promise.resolve();if(e1.includeFilterSettings){m1=l1.parseFilterConfiguration(j1,function(n1){return i1.hasProperty(n1)?i1.getProperty(n1).label:null;}).then(function(n1){if(n1){k1.workbook.context={metaSheetName:n1.name,metainfo:[n1]};}});}m1.then(function(){var n1={splitCells:false,includeFilterSettings:false};if(e1){n1.splitCells=e1.splitCells;n1.includeFilterSettings=e1.includeFilterSettings;}l1.getExportInstance(k1).then(function(o1){o1.attachBeforeExport(function(p1){var q1=p1.getParameter("exportSettings");f1.fireBeforeExport({exportSettings:q1,userExportSettings:n1});},f1);o1.build().finally(function(){o1.destroy();});});});});});});};
U.prototype._onExportAs=function(e1){var f1=this;this._loadExportLibrary().then(function(){sap.ui.require(['sap/ui/export/ExportUtils'],function(g1){var h1=new URL(window.location.href).search.indexOf("sap-ui-xx-enablePDFExport=true")>-1;g1.getExportSettingsViaDialog(f1._cachedExportSettings,f1,undefined,h1).then(function(i1){f1._cachedExportSettings=i1;f1._onExport(i1);});});});};
U.prototype._loadExportLibrary=function(){if(!this._oExportLibLoadPromise){this._oExportLibLoadPromise=d.loadLibrary("sap.ui.export",true);}return this._oExportLibLoadPromise;};
U.prototype.onkeydown=function(e1){if(e1.isMarked()){return;}if((e1.metaKey||e1.ctrlKey)&&e1.shiftKey&&e1.which===K.E){if(this.getEnableExport()&&this._oExportButton&&this._oExportButton.getEnabled()){this._onExportAs();e1.setMarked();e1.preventDefault();}}if((e1.metaKey||e1.ctrlKey)&&e1.which===K.COMMA){var f1=d.byId(this.getId()+"-settings");if(f1&&f1.getEnabled()&&f1.getVisible()){f1.firePress();e1.setMarked();e1.preventDefault();}}};
U.prototype._createTable=function(){var e1=this.getThreshold()>-1?this.getThreshold():undefined;var f1=this.getRowSettings()?this.getRowSettings().getAllSettings():{};if(this._bMobileTable){this._oTable=R.createTable(this.getId()+"-innerTable",{autoPopinMode:true,contextualWidth:"Auto",growing:true,sticky:["ColumnHeaders","HeaderToolbar","InfoToolbar"],itemPress:[this._onItemPress,this],selectionChange:[this._onSelectionChange,this],growingThreshold:e1,noDataText:this._getNoDataText(),headerToolbar:this._oToolbar,ariaLabelledBy:[this._oTitle]});this._oTemplate=R.createTemplate(this.getId()+"-innerTableRow",f1);this._createColumn=U.prototype._createMobileColumn;this._sAggregation="items";this._oTable.bindRows=this._oTable.bindItems;this._oTable.bActiveHeaders=true;this._oTable.attachEvent("columnPress",this._onResponsiveTableColumnPress,this);}else{this._oTable=G.createTable(this.getId()+"-innerTable",{enableBusyIndicator:true,enableColumnReordering:false,threshold:e1,cellClick:[this._onCellClick,this],noData:this._getNoDataText(),extension:[this._oToolbar],ariaLabelledBy:[this._oTitle],plugins:[G.createMultiSelectionPlugin(this,[this._onRowSelectionChange,this])],columnSelect:[this._onGridTableColumnPress,this],rowSettingsTemplate:f1});this._createColumn=U.prototype._createColumn;this._sAggregation="rows";}this._updateTypeSettings();this._updateSelectionBehavior();this._updateMultiSelectMode();var g1=new D({sourceAggregation:"columns",targetAggregation:"columns",dropPosition:"Between",enabled:this.getP13nMode().indexOf("Column")>-1,drop:[this._onColumnRearrange,this]});g1.bIgnoreMetadataCheck=true;this._oTable.addDragDropConfig(g1);this._oTable.setBusyIndicatorDelay(this.getBusyIndicatorDelay());this._oTable.attachPaste(this._onInnerTablePaste,this);if(this.isFilteringEnabled()){Y(this);}};
U.prototype._updateColumnResizer=function(){if(!this._oTable){return;}var e1=this.getEnableColumnResize();var f1=this._bMobileTable?R:G;if(e1){f1.enableColumnResizer(this,this._oTable);}else{f1.disableColumnResizer(this,this._oTable);}var g1=this.getColumns();g1.forEach(function(h1){h1.updateColumnResizing(e1);},this);};
U.prototype._updateSelectionBehavior=function(){var e1=this._bMobileTable?R:G;e1.updateSelection(this);};
U.prototype._updateMultiSelectMode=function(){if(this._bMobileTable){R.updateMultiSelectMode(this);}};
U.prototype._onColumnRearrange=function(e1){var f1=e1.getParameter("draggedControl");var g1=e1.getParameter("droppedControl");if(f1===g1){return;}var h1=e1.getParameter("dropPosition");var i1=this._oTable.indexOfColumn(f1);var j1=this._oTable.indexOfColumn(g1);var k1=j1+(h1=="Before"?0:1)+(i1<j1?-1:0);T.moveColumn(this,i1,k1);};
U.prototype._onColumnPress=function(e1){if(this._bSuppressOpenMenu){return;}var f1=e1.getParent(),g1=f1.indexOfColumn(e1),h1=this.getColumns()[g1],i1=this._bMobileTable&&this.getEnableColumnResize();this._fullyInitialized().then(function(){var j1=d.getLibraryResourceBundle("sap.ui.mdc");var k1=this.getPropertyHelper().getProperty(h1.getDataProperty());if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this.isSortingEnabled()&&k1){var l1=[];var m1=[];k1.getSortableProperties().forEach(function(k1){l1.push(new I({text:k1.label,key:k1.name}));m1.push(new I({text:k1.label,key:k1.name}));});if(l1.length>0){this._oPopover=new c({items:[new r({items:l1,label:j1.getText("table.SETTINGS_ASCENDING"),icon:"sap-icon://sort-ascending",action:[false,this._onCustomSort,this]}),new r({items:m1,label:j1.getText("table.SETTINGS_DESCENDING"),icon:"sap-icon://sort-descending",action:[true,this._onCustomSort,this]})]});e1.addDependent(this._oPopover);}}var n1=this.getControlDelegate();var o1=(n1.addColumnMenuItems&&n1.addColumnMenuItems(this,h1))||[];if(this.isFilteringEnabled()&&k1&&k1.getFilterableProperties().length>0){o1.unshift(new r({label:j1.getText("table.SETTINGS_FILTER"),icon:"sap-icon://filter",action:[d1,this]}));}if(i1){var p1=R.startColumnResize(this._oTable,e1);p1&&o1.push(p1);}o1.forEach(function(q1){this._createPopover(q1,e1);},this);if(this._oPopover){this._oPopover.openBy(e1);this._oPopover.getAggregation("_popover").attachAfterClose(function(){this._bSuppressOpenMenu=false;},this);this._bSuppressOpenMenu=true;}}.bind(this));};
U.prototype._createPopover=function(e1,f1){if(this._oPopover){this._oPopover.addItem(e1);}else{this._oPopover=new c({items:e1});f1.addDependent(this._oPopover);}};
U.prototype._onCustomSort=function(e1,f1){var g1=e1.getParameter("property");T.createSort(this,g1,f1,true);};
U.prototype._onColumnResize=function(e1){var f1=e1.getParameter("column");var g1=e1.getParameter("width");var h1=this._oTable.indexOfColumn(f1);var i1=this.getColumns()[h1];var j1=i1.getDataProperty();T.createColumnWidth(this,j1,g1);};
U.prototype._onCustomGroup=function(e1){T.createGroup(this,e1);};
U.prototype._onCustomAggregate=function(e1){T.createAggregation(this,e1);};
U.prototype._setColumnWidth=function(e1){if(!this.getEnableAutoColumnWidth()||e1.getWidth()||e1.isBound("width")){return;}var f1=this._oPropertyHelper;if(f1){f1.setColumnWidth(e1);}else{this.awaitPropertyHelper().then(this._setColumnWidth.bind(this,e1));}};
U.prototype._insertInnerColumn=function(e1,f1){if(!this._oTable){return;}this._setColumnWidth(e1);var g1=this._createColumn(e1);b1(this,e1,g1,f1);this._bForceRebind=true;if(f1===undefined){this._oTable.addColumn(g1);}else{this._oTable.insertColumn(g1,f1);}};
U.prototype._orderColumns=function(){var e1,f1=[],g1=this.getColumns();g1.forEach(function(h1){e1=h1.getInitialIndex();if(e1>-1){f1.push({index:e1,column:this.removeColumn(h1)});}},this);f1.sort(function(h1,i1){return h1-i1;});f1.forEach(function(h1){this.insertColumn(h1.column,h1.index);},this);};
function b1(e1,f1,g1,h1){var i1=f1.getTemplate(true);if(!e1._bMobileTable){var j1=f1.getCreationTemplate(true);[i1,j1].forEach(function(k1){if(!k1){return;}if(k1.setWrapping){k1.setWrapping(false);}if(k1.setRenderWhitespace){k1.setRenderWhitespace(false);}});g1.setTemplate(i1);g1.setCreationTemplate(j1);}else if(h1>=0){e1._oTemplate.insertCell(i1,h1);e1._oTable.getItems().forEach(function(k1){k1.insertAggregation("cells",new k(),h1,true);});}else{e1._oTemplate.addCell(i1);}}
U.prototype._createColumn=function(e1){return G.createColumn(e1.getId()+"-innerColumn",{width:e1.getWidth(),minWidth:Math.round(e1.getMinWidth()*parseFloat(M.BaseFontSize)),hAlign:e1.getHAlign(),label:e1.getColumnHeaderControl(this._bMobileTable,this.getEnableColumnResize()),resizable:this.getEnableColumnResize(),autoResizable:this.getEnableColumnResize()});};
U.prototype._createMobileColumn=function(e1){return R.createColumn(e1.getId()+"-innerColumn",{width:e1.getWidth(),autoPopinWidth:e1.getMinWidth(),hAlign:e1.getHAlign(),header:e1.getColumnHeaderControl(this._bMobileTable,this.getEnableColumnResize()),importance:e1.getImportance(),popinDisplay:"Inline"});};
U.prototype.moveColumn=function(e1,f1){var g1;this.removeAggregation("columns",e1,true);this.insertAggregation("columns",e1,f1,true);if(this._oTable){g1=this._oTable.removeColumn(e1.getId()+"-innerColumn");this._oTable.insertColumn(g1,f1);if(this._bMobileTable){this._updateColumnTemplate(e1,f1);}}};
U.prototype.removeColumn=function(e1){e1=this.removeAggregation("columns",e1,true);if(this._oTable){var f1=this._oTable.removeColumn(e1.getId()+"-innerColumn");f1.destroy("KeepDom");if(this._bMobileTable){this._updateColumnTemplate(e1,-1);}this._onModifications();}return e1;};
U.prototype.addColumn=function(e1){this.addAggregation("columns",e1,true);this._insertInnerColumn(e1);return this;};
U.prototype.insertColumn=function(e1,f1){this.insertAggregation("columns",e1,f1,true);this._insertInnerColumn(e1,f1);this._onModifications();return this;};
U.prototype._updateColumnTemplate=function(e1,f1){var g1,h1;if(this._oTemplate){g1=e1.getTemplate(true);h1=this._oTemplate.indexOfCell(g1);U._removeItemCell(this._oTemplate,h1,f1);}if(h1>-1){this._oTable.getItems().forEach(function(i1){if(i1.removeCell){U._removeItemCell(i1,h1,f1);}});}};
U._removeItemCell=function(e1,f1,g1){var h1=e1.removeCell(f1);if(h1){if(g1>-1){e1.insertCell(h1,g1);}else{h1.destroy();}}};
U.prototype._onItemPress=function(e1){this.fireRowPress({bindingContext:e1.getParameter("listItem").getBindingContext()});};
U.prototype._onSelectionChange=function(e1){var f1=e1.getParameter("selectAll");this.fireSelectionChange({bindingContext:e1.getParameter("listItem").getBindingContext(),selected:e1.getParameter("selected"),selectAll:f1});if(f1){var g1=this.getRowBinding();if(g1&&this._oTable){var h1=g1.getLength();var i1=this._oTable.getItems().length;var j1=g1.isLengthFinal();if(i1!=h1||!j1){Q("table.SELECTION_LIMIT_MESSAGE",[i1]);}}}};
U.prototype._onResponsiveTableColumnPress=function(e1){this._onColumnPress(e1.getParameter("column"));};
U.prototype._onCellClick=function(e1){this.fireRowPress({bindingContext:e1.getParameter("rowBindingContext")});};
U.prototype._onRowActionPress=function(e1){var f1=e1.getParameter("row");this.fireRowPress({bindingContext:f1.getBindingContext()});};
U.prototype._onRowSelectionChange=function(e1){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({bindingContext:e1.getParameter("rowContext"),selected:e1.getSource().isIndexSelected(e1.getParameter("rowIndex")),selectAll:e1.getParameter("selectAll")});}};
U.prototype._onGridTableColumnPress=function(e1){e1.preventDefault();this._onColumnPress(e1.getParameter("column"));};
U.prototype.getSelectedContexts=function(){if(this._oTable){if(this._bMobileTable){return this._oTable.getSelectedContexts();}var e1=this._oTable.getPlugins()[0].getSelectedIndices();return e1.map(function(f1){return this._oTable.getContextByIndex(f1);},this);}return[];};
U.prototype.clearSelection=function(){if(this._oTable){if(this._bMobileTable){this._oTable.removeSelections(true);}else{this._bSelectionChangedByAPI=true;this._oTable.getPlugins()[0].clearSelection();this._bSelectionChangedByAPI=false;}}};
U.prototype._registerInnerFilter=function(e1){e1.attachSearch(function(){this._rebind();},this);};
U.prototype.isTableBound=function(){return this._oTable?this._oTable.isBound(this._bMobileTable?"items":"rows"):false;};
U.prototype.bindRows=function(){if(!this.bDelegateInitialized||!this._oTable){return;}var e1={};this.getControlDelegate().updateBindingInfo(this,e1,e1);if(e1.path){this._oTable.setShowOverlay(false);if(this._bMobileTable&&this._oTemplate){e1.template=this._oTemplate;}else{delete e1.template;}U._addBindingListener(e1,"dataRequested",this._onDataRequested.bind(this));U._addBindingListener(e1,"dataReceived",this._onDataReceived.bind(this));U._addBindingListener(e1,"change",this._onBindingChange.bind(this));this._updateColumnsBeforeBinding(e1);this.getControlDelegate().updateBinding(this,e1,this._bForceRebind?null:this.getRowBinding());this._updateInnerTableNoDataText();this._bForceRebind=false;}};
U.prototype._onDataRequested=function(){this._bIgnoreChange=true;};
U.prototype._onDataReceived=function(){this._bIgnoreChange=false;this._updateHeaderText();this._updateExportState();};
U.prototype._onBindingChange=function(){if(this._bIgnoreChange){return;}this._updateHeaderText();};
U.prototype._updateHeaderText=function(){var e1,f1;if(!this._oNumberFormatInstance){this._oNumberFormatInstance=N.getFloatInstance();}if(this._oTitle&&this.getHeader()){e1=this.getHeader();if(this.getShowRowCount()){f1=this._getRowCount(true);if(f1>0){var g1=this._oNumberFormatInstance.format(f1);e1+=" ("+g1+")";}}this._oTitle.setText(e1);}if(!this._bIgnoreChange&&this._bAnnounceTableUpdate){this._bAnnounceTableUpdate=false;this._announceTableUpdate(f1);}};
U.prototype._announceTableUpdate=function(e1){var f1=j.getInstance();if(f1){var g1=d.getLibraryResourceBundle("sap.ui.mdc");var h1=this.getHeader();if(e1===undefined&&this._getRowCount(false)>0){f1.announce(g1.getText("table.ANNOUNCEMENT_TABLE_UPDATED",[h1]));}else if(e1>1){f1.announce(g1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_MULT",[h1,e1]));}else if(e1===1){f1.announce(g1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_SING",[h1,e1]));}else{f1.announce(g1.getText("table.ANNOUNCEMENT_TABLE_UPDATED_NOITEMS",[h1]));}}};
U.prototype._updateColumnsBeforeBinding=function(e1){var f1=[].concat(e1.sorter||[]);var g1=this.getColumns();var h1=this._bMobileTable;var i1=this.getPropertyHelper();g1.forEach(function(j1){var k1=d.byId(j1.getId()+"-innerColumn");var l1=i1.getProperty(j1.getDataProperty());var m1=l1?l1.getSortableProperties().map(function(l1){return l1.path;}):[];if(m1.length>0){var n1=f1.find(function(n1){return m1.indexOf(n1.sPath)>-1;});var o1=n1&&n1.bDescending?"Descending":"Ascending";if(h1){k1.setSortIndicator(n1?o1:"None");}else{k1.setSorted(!!n1).setSortOrder(o1);}}});};
U.prototype._getRowCount=function(e1){var f1=this._getRowBinding();if(!f1){return e1?undefined:0;}var g1;if(!e1){g1=f1.getLength();}else{if(typeof f1.getCount==='function'){g1=f1.getCount();}else if(f1.isLengthFinal()){g1=f1.getLength();}}if(g1<0||g1==="0"){g1=0;}return g1;};
U.prototype.getRowBinding=function(){return this._getRowBinding();};
U.prototype._getRowBinding=function(){if(this._oTable){return this._oTable.getBinding(this._sAggregation);}};
U._addBindingListener=function(e1,f1,g1){if(!e1.events){e1.events={};}if(!e1.events[f1]){e1.events[f1]=g1;}else{var h1=e1.events[f1];e1.events[f1]=function(){g1.apply(this,arguments);h1.apply(this,arguments);};}};
U.prototype.rebindTable=function(){this._rebind();};
U.prototype._rebind=function(){if(this._bFullyInitialized){this.bindRows();}else{this._fullyInitialized().then(this._rebind.bind(this));}};
function c1(e1){T.showPanel(this,"Columns",e1.getSource());}
function d1(e1){T.showPanel(this,"Filter",e1.getSource());}
U.prototype._getSorters=function(){var e1=this.getSortConditions()?this.getSortConditions().sorters:[];var f1=[],g1=this.getPropertyHelper();e1.forEach(function(h1){if(g1.hasProperty(h1.name)){var i1=g1.getProperty(h1.name).path;f1.push(new S(i1,h1.descending));}});return f1;};
U.prototype._onInnerTablePaste=function(e1){if(!this.getEnablePaste()){return;}this.firePaste({data:e1.getParameter("data")});};
U.prototype.exit=function(){if(this._oTemplate){this._oTemplate.destroy();}this._oTemplate=null;this._oTable=null;if(this._oToolbar&&!this._bTableExists){this._oToolbar.destroy();}this._oToolbar=null;this._oTitle=null;this._oNumberFormatInstance=null;V.forEach(function(e1){var f1=g(e1),g1="_o"+f1;this[g1]=null;},this);this._oTableReady=null;this._oFullInitialize=null;this._oPasteButton=null;C.prototype.exit.apply(this,arguments);};
U.prototype.addAction=function(e1){if(e1.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){e1=new u(e1.getId()+"-action",{action:e1});}return C.prototype.addAggregation.apply(this,["actions",e1]);};
return U;});
sap.ui.predefine('sap/ui/mdc/TableDelegate',["sap/ui/mdc/AggregationBaseDelegate","sap/ui/core/library","sap/ui/core/Core"],function(A,c,C){"use strict";var T=Object.assign({},A);
T.updateBindingInfo=function(m,b){b.parameters={};if(m._oMessageFilter){b.filters=[m._oMessageFilter];}else{b.filters=[];}b.sorter=m._getSorters();};
T.updateBinding=function(m,b,B){this.rebindTable(m,b);};
T.validateState=function(o,s,k){if(k=="Filter"&&o._oMessageFilter){var r=C.getLibraryResourceBundle("sap.ui.mdc");return{validation:c.MessageType.Information,message:r.getText("table.PERSONALIZATION_DIALOG_FILTER_MESSAGESTRIP")};}return A.validateState.apply(this,arguments);};
T.rebindTable=function(m,b){this.rebind.apply(this,arguments);};
T.rebind=function(m,b){if(m._oTable){m._oTable.bindRows(b);}};
T.getFilterDelegate=function(){return{addItem:function(p,t){return Promise.resolve(null);}};};
return T;});
sap.ui.predefine('sap/ui/mdc/ValueHelp',['sap/ui/mdc/Element','sap/ui/mdc/mixin/PromiseMixin','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/FilterConverter','sap/ui/mdc/enum/SelectType','sap/ui/mdc/enum/OutParameterMode','sap/ui/mdc/enum/ConditionValidated','sap/ui/model/Context','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/base/util/merge','sap/base/util/deepEqual'],function(E,P,C,F,a,S,O,b,c,d,e,M,f,m,g){"use strict";
var V=E.extend("sap.ui.mdc.ValueHelp",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ValueHelpDelegate"}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true},_config:{type:"object",defaultValue:{},visibility:"hidden"},_valid:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"},_inConditions:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"},_outParameters:{type:"string[]",defaultValue:[],byValue:true,visibility:"hidden"}},aggregations:{dialog:{type:"sap.ui.mdc.valuehelp.IDialogContainer",multiple:false},typeahead:{type:"sap.ui.mdc.valuehelp.ITypeaheadContainer",multiple:false},inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},disconnect:{},closed:{},navigated:{parameters:{bLeaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}},switchToValueHelp:{}},defaultProperty:"filterValue"}});
V.prototype.init=function(){E.prototype.init.apply(this,arguments);this._oObserver=new f(r.bind(this));this._oObserver.observe(this,{aggregations:["inParameters","outParameters","typeahead","dialog"]});this.setBindingContext(null);this._oConditions={};};
V.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}};
V.prototype.invalidate=function(i){return;};
V.prototype.connect=function(i,j){if(this._oControl&&this._oControl!==i){this.close();this.setFilterValue("");this.setConditions([]);this.fireDisconnect();}this._oControl=i;this.setProperty("_config",j,true);A.call(this);return this;};
V.prototype.getControl=function(){return this._oControl;};
V.prototype.getDomRef=function(){var T=this.getTypeahead();var i=this.getDialog();if(T&&(T.isOpen()||T.isOpening())){return T.getDomRef();}else if(i&&(i.isOpen()||i.isOpening())){return i.getDomRef();}};
V.prototype.getAriaAttributes=function(i){var T=this.getTypeahead();var j=this.getDialog();if(!j&&T&&T.getUseAsValueHelp()){j=T;}var K=T&&T.isOpen();var L=j&&j.isOpen();var N=T&&T.getAriaAttributes(i);var Q=j&&j.getAriaAttributes(i);var R;var U;var W;var X;if(K){R=N.contentId;}else if(L){R=Q.contentId;}U=(T&&N.ariaHasPopup)||(j&&Q.ariaHasPopup);W=(T&&N.role)||(j&&Q.role);X=(T&&N.roleDescription)||(j&&Q.roleDescription);return{contentId:R,ariaHasPopup:U,role:W,roleDescription:X,valueHelpEnabled:!!j||!!T&&!!T.getUseAsValueHelp()};};
V.prototype._retrieveDelegateContent=function(i){return this._retrievePromise("delegateContent--"+i.getId(),function(){var j=this._getControlDelegatePromise();return j.then(function(K){return K.retrieveContent(this.getPayload(),i);}.bind(this));}.bind(this));};
V.prototype._getControlDelegatePromise=function(i){return this._retrievePromise("delegate",this.initControlDelegate.bind(this));};
V.prototype.open=function(T){var i=T?this.getTypeahead():J.call(this);var j=T?this.getDialog():this.getTypeahead();if(j&&i!==j&&(j.isOpen()||j.isOpening())){j.close();}if(i&&!i.isOpen()&&!i.isOpening()){this._removePromise("delegateContent"+"--"+i.getId());i.open(this._retrieveDelegateContent(i,true));}};
function _(i){var j=i.getParameter("container");this._removePromise("delegateContent"+"--"+j.getId());this._retrieveDelegateContent(j);}
function h(i){this.fireSwitchToValueHelp();}
V.prototype.close=function(){var T=this.getTypeahead();var i=this.getDialog();if(T&&T.isOpen()){T.close();}if(i&&i.isOpen()){i.close();}};
V.prototype.toggleOpen=function(T){var i=this.getTypeahead();var j=this.getDialog();if(!T&&!j&&i&&i.getUseAsValueHelp()){j=i;}var K=i&&i.isOpen();var L=j&&j.isOpen();if((T&&K)||(!T&&L)){this.close();}else if((T&&i)||(!T&&j)){this.open(T);}};
V.prototype.isOpen=function(){var T=this.getTypeahead();var i=this.getDialog();return(T&&T.isOpen())||(i&&i.isOpen());};
V.prototype.skipOpening=function(){var T=this.getTypeahead();var i=this.getDialog();if(T&&T.isOpening()){T.close();}if(i&&i.isOpening()){i.close();}};
V.prototype.initBeforeOpen=function(T){};
V.prototype.isTypeaheadSupported=function(){var T=this.getTypeahead();if(T){return this._retrieveDelegateContent(T).then(function(){return!!T&&T.isTypeaheadSupported();});}else{return Promise.resolve(false);}};
V.prototype.shouldOpenOnClick=function(){var i=J.call(this);if(i){return i.shouldOpenOnClick();}return false;};
V.prototype.isFocusInHelp=function(){var i=J.call(this);return i&&i.isFocusInHelp();};
V.prototype.removeFocus=function(){var T=this.getTypeahead();if(T){T.removeFocus();}};
V.prototype.navigate=function(i){var T=this.getTypeahead();if(T){var j=function(){if(T.shouldOpenOnNavigate()&&!T.isOpening()&&!T.isOpen()){return T.open(true).then(function(){T.navigate(i);});}return T.navigate(i);};var N=this._retrievePromise("navigate");var K=N&&!N.isSettled()&&N.getInternalPromise();this._addPromise("navigate",K?K.then(j):this._retrieveDelegateContent(T).then(j));}};
V.prototype.getTextForKey=function(K,i,j,L,N,Q){return this.getItemForValue({parsedValue:K,value:K,inParameters:i,outParameters:j,bindingContext:L,conditionModel:N,conditionModelName:Q,checkKey:true,exception:d,caseSensitive:true});};
V.prototype.getKeyForText=function(T,i){return this.getItemForValue({value:T,inParameters:i,checkDescription:true,exception:e,caseSensitive:true});};
V.prototype.getItemForValue=function(i){var T=this.getTypeahead();if(T){var j=["getItemForValue",i.parsedValue||i.value,JSON.stringify(i.oInParameters),i.oBindingContext&&i.oBindingContext.getPath()];var K=j.join("_");return this._retrievePromise(K,function(){return this._retrieveDelegateContent(T).then(function(){var L=B.call(this,this.getInParameters(),i.bindingContext,i.conditionModel,i.conditionModelName);return G.call(this,L).then(function(){i.inParameters=H.call(this,i.inParameters,this.getInParameters(),L,i.bindingContext);i.outParameters=null;i.caseSensitive=i.hasOwnProperty("caseSensitive")?i.caseSensitive:false;return T.getItemForValue(i).then(function(N){D.call(this,L);if(N){if(N.inParameters){N.inParameters=y.call(this,N.inParameters,this.getInParameters());}if(N.outParameters){N.outParameters=y.call(this,N.outParameters,this.getOutParameters());}}return N;}.bind(this));}.bind(this));}.bind(this));}.bind(this));}else{return Promise.reject("No Typeahead");}};
V.prototype.isValidationSupported=function(){var T=this.getTypeahead();return T&&T.isValidationSupported();};
V.prototype.onControlChange=function(){if(this.bIsDestroyed){return;}var K=this.getOutParameters();A.call(this);var L=B.call(this,K);G.call(this,L).then(function(){var N=this.getConditions();for(var j=0;j<K.length;j++){var Q=K[j];var R=Q.getValue();var U=Q.getUseConditions();var T=true;if(Q.getMode()===O.WhenEmpty){if(U){T=!R||(Array.isArray(R)&&R.length===0);}else{T=!R;}}if(T){var W;var X;if(U){if(!Array.isArray(R)){throw new Error("Value on OutParameter must be an array "+Q);}W=m([],R);}else{W=R;}if(!Q.getHelpPath()){if(U){X=C.createCondition("EQ",[Q.getFixedValue()],undefined,undefined,b.Validated);if(F.indexOfCondition(X,W)<0){W.push(X);}}else{W=Q.getFixedValue();}}else{for(var i=0;i<N.length;i++){var Y=N[i];if(Y.outParameters){for(var Z in Y.outParameters){if(Q.getFieldPath()===Z){if(U){X=C.createCondition("EQ",[Y.outParameters[Z]],undefined,undefined,b.Validated);if(F.indexOfCondition(X,W)<0){W.push(X);}}else{W=Y.outParameters[Z];}}}}}}if(U){F.checkConditionsEmpty(W);}Q.setValue(W);}}}.bind(this));};
V.prototype.getIcon=function(){var T=this.getTypeahead();var i=this.getDialog();if(i){return i.getValueHelpIcon();}else if(T){return T.getValueHelpIcon();}};
V.prototype.getMaxConditions=function(){var i=this.getProperty("_config");return(i&&i.maxConditions)||-1;};
V.prototype.getDisplay=function(){};
V.prototype.getDataType=function(){};
V.prototype.valueHelpEnabled=function(){var T=this.getTypeahead();var i=this.getDialog();if(i){return true;}else{return T&&T.getUseAsValueHelp();}};
function k(i){var j=z.call(this,i.getParameter("condition"));this.fireNavigated({condition:j,itemId:i.getParameter("itemId"),leaveFocus:i.getParameter("leaveFocus")});}
function l(K){var L=this.getMaxConditions()===1;var T=K.getParameter("type");var N=K.getParameter("conditions")||[];var Q;if(L){N=N.slice(0,1);}if(T===S.Set||T===S.Add){Q=T===S.Set||L?[]:this.getConditions();for(var i=0;i<N.length;i++){var R=z.call(this,N[i]);Q.push(R);}}else if(T===S.Remove){Q=L?[]:this.getConditions();for(var j=0;j<N.length;j++){var U=z.call(this,N[j]);var W=F.indexOfCondition(U,Q);if(W>=0){Q.splice(W,1);}}}if(Q){this.setProperty("conditions",Q,true);}}
function n(i){if(this.getProperty("_valid")){var j=this.getMaxConditions()===1;var K=i.getParameter("close");var L=typeof K!=='undefined'?K:j;var N=this.getConditions();var Q=!j&&!i.getSource().isMultiSelect();if(L){this.close();}N=C._removeEmptyConditions(N);N=C._removeInitialFlags(N);F.updateConditionsValues(N);this.fireSelect({conditions:N,add:Q,close:L});}}
function o(i){this.close();}
function p(i){}
function q(i){var j=i.getSource();this._removePromise("delegateContent--"+j.getId());this._removePromise("navigate");this.fireClosed();}
function r(i){if(["typeahead","dialog"].indexOf(i.name)!==-1){var j=i.child;var K=i.mutation==="insert";var L=K?j.attachEvent.bind(j):j.detachEvent.bind(j);L("select",l,this);L("requestDelegateContent",_,this);L("confirm",n,this);L("cancel",o,this);L("opened",p,this);L("closed",q,this);if(j.attachRequestSwitchToDialog){L("requestSwitchToDialog",h,this);}if(j.attachNavigated){L("navigated",k,this);}if(K){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}j.setModel(this._oManagedObjectModel,"$valueHelp");}}if(i.object==this){if(i.name==="inParameters"){s.call(this,i.child,i.mutation);}if(i.name==="outParameters"){v.call(this,i.child,i.mutation);}}else if(i.object.isA("sap.ui.mdc.field.OutParameter")){if(i.name==="helpPath"){w.call(this,i.current,i.old);}}else if(i.object.isA("sap.ui.mdc.field.InParameter")){if(i.name==="value"){t.call(this,i.object.getHelpPath(),i.current,i.object.getUseConditions(),i.object.getInitialValueFilterEmpty());}if(i.name==="helpPath"){u.call(this,i.current,i.old,i.object.getValue(),i.object.getUseConditions(),i.object.getInitialValueFilterEmpty());}}}
function s(i,j){var K=i.getHelpPath();if(j==="remove"){this._oObserver.unobserve(i);var L=this.getProperty("_inConditions");delete L[K];this.setProperty("_inConditions",L,true);}else{this._oObserver.observe(i,{properties:["value","helpPath"]});t.call(this,K,i.getValue(),i.getUseConditions(),i.getInitialValueFilterEmpty());}}
function t(j,K,U,L){var N=this.getProperty("_inConditions");var Q;N[j]=[];if(U){if(Array.isArray(K)){for(var i=0;i<K.length;i++){Q=m({},K[i]);if(Q.inParameters){Q.inParameters=x.call(this,Q.inParameters,this.getInParameters());}if(Q.outParameters){Q.outParameters=x.call(this,Q.outParameters,this.getOutParameters());}N[j].push(Q);}}}else{if(!K&&L){Q=C.createCondition("Empty",[]);Q.isEmpty=false;}else if(K!==null){Q=C.createItemCondition(K);Q.validated=b.Validated;}if(Q){N[j].push(Q);}}this.setProperty("_inConditions",N,true);}
function u(i,j,K,U,L){var N=this.getProperty("_inConditions");delete N[j];this.setProperty("_inConditions",N,true);t.call(this,i,K,U,L);}
function v(i,j){var K=i.getHelpPath();var L=this.getProperty("_outParameters");var N=L.indexOf(K);if(j==="remove"){this._oObserver.unobserve(i);if(N>-1){L.splice(N,1);}}else{this._oObserver.observe(i,{properties:["helpPath"]});if(N===-1){L.push(K);}}this.setProperty("_outParameters",L,true);}
function w(i,j){var K=this.getProperty("_outParameters");var L=K.indexOf(j);if(L>-1){K[L]=i;}this.setProperty("_outParameters",K,true);}
function x(j,K){var L;if(K.length>0){for(var N in j){for(var i=0;i<K.length;i++){var Q=K[i];var R="conditions/"+Q.getHelpPath();var T=Q.getFieldPath();if(T&&(T===N||T==="conditions/"+N)&&R){if(!L){L={};}L[R]=j[N];}}}}return L;}
function y(j,K){if(!j||K.length===0){return null;}var L={};for(var i=0;i<K.length;i++){var N=K[i];var Q=N.getHelpPath();var R=N.getFieldPath();if(Q&&R){for(var T in j){if([Q,R].indexOf(T)>=0){L[R]=j[T];break;}}}else if(!Q&&R&&N.getFixedValue){L[R]=N.getFixedValue();}}return L;}
function z(i){i=m({},i);if(i.inParameters){i.inParameters=y.call(this,i.inParameters,this.getInParameters());}if(i.outParameters){i.outParameters=y.call(this,i.outParameters,this.getOutParameters());}return i;}
function A(){var i=this._oControl?this._oControl.getBindingContext():null;this.setBindingContext(i);var j=this.getProperty("_config");if(j&&j.conditionModel&&this.getModel(j.conditionModelName)!==j.conditionModel){this.setModel(j.conditionModel,j.conditionModelName);}}
function B(j,K,L,N){var Q=[];var R=false;var T;if(K){T=this.oBindingContexts[undefined];if(K&&c.hasChanged(T,K)){R=true;}}for(var i=0;i<j.length;i++){var U=j[i];var W=U.getBinding("value");if(U.getUseConditions()&&L){var X=this.getModel(N);if(X!==L){W=L.bindProperty("/"+U.getFieldPath());W._bValueHelp=true;Q.push(W);}}else if(W){var Y=W.getPath();var Z=W.getContext();if(R&&W.isRelative()&&(Z===T||(!Z&&T))){if(K.getProperty(Y)===undefined){var $=W.getModel();W=$.bindProperty(Y,K);W._bValueHelp=true;Q.push(W);}}else if((!Z&&W.isRelative())||(Z&&Z.getProperty(Y)===undefined)||W.getValue()===undefined||(Z&&!g(U.validateProperty("value",Z.getProperty(Y)),U.getValue()))){Q.push(W);}}}return Q;}
function D(j){for(var i=0;i<j.length;i++){if(j[i]._bValueHelp){j[i].destroy();}}}
function G(i){var j=this._getControlDelegatePromise();return j.then(function(K){if(i.length===0){return null;}return K.checkBindingsPending(this.getPayload(),i);}.bind(this));}
function H(K,L,N,Q){if(L.length===0){return null;}var R={};var T;var U;var W;var X;var i=0;if(K){for(var Y in K){for(i=0;i<L.length;i++){U=L[i];W=U.getHelpPath();X=U.getFieldPath();if(X&&W&&(X===Y||X==="conditions/"+Y)){R[W]=[];T=C.createItemCondition(K[Y]);T.validated=b.Validated;R[W].push(T);}}}}else{var Z=this.getBindingContext();for(i=0;i<L.length;i++){U=L[i];W=U.getHelpPath();if(W){var $=U.getValue();var a1=U.getUseConditions();var b1=U.getInitialValueFilterEmpty();var j=0;if((N&&N.length>0)||Q){var c1=U.getBinding("value");var d1=false;if(c1||a1){X=U.getFieldPath();for(j=0;j<N.length;j++){if((c1&&c1.getPath()===N[j].getPath())||(a1&&N[j].getPath()==="/"+X)){$=N[j].getValue();d1=true;break;}}if(!d1&&!a1&&Q&&c1&&c1.isRelative()&&(!c1.getContext()||(c1.getContext()!==Q&&c1.getContext()===Z))){$=Q.getProperty(c1.getPath());}}}R[W]=[];if(a1){for(j=0;j<$.length;j++){T=m({},$[j]);if(T.inParameters){T.inParameters=x.call(this,T.inParameters,this.getInParameters());}if(T.outParameters){T.outParameters=x.call(this,T.outParameters,this.getOutParameters());}R[W].push(T);}}else{if(!$&&b1){T=C.createCondition("Empty",[]);T.isEmpty=false;}else if($){T=C.createItemCondition($);T.validated=b.Validated;}if(T){R[W].push(T);}}T=undefined;}}}var e1=I.call(this,R);var f1=a.createFilters(R,e1);return f1;}
function I(j){var K=this.getInParameters();var L={};var N;for(N in j){var T;for(var i=0;i<K.length;i++){var Q=K[i];if(Q.getHelpPath()===N){T=Q.getDataType();break;}}L[N]={type:T};}return L;}
function J(){var i=this.getDialog();if(!i){var T=this.getTypeahead();if(T&&T.getUseAsValueHelp()){i=T;}}return i;}
P.call(V.prototype);return V;});
sap.ui.predefine('sap/ui/mdc/ValueHelpDelegate',["sap/ui/mdc/BaseDelegate","sap/ui/model/FilterType"],function(B,F){"use strict";var V=Object.assign({},B);
V.retrieveContent=function(p,c){return Promise.resolve();};
V.isSearchSupported=function(p,l){return false;};
V.executeSearch=function(p,l,s){return Promise.resolve();};
V.adjustSearch=function(p,t,s){return s;};
V.executeFilter=function(p,l,f,r){if(l.isA("sap.ui.model.json.JSONListBinding")){l.filter(f,F.Application);return Promise.resolve(l);}else{var R;var c=function(){R(l);};l.attachEventOnce("dataReceived",c);l.initialize();l.filter(f,F.Application);l.getContexts(0,r);return new Promise(function(a,b){R=a;});}};
V.checkBindingsPending=function(p,b){return null;};
V.checkListBindingPending=function(p,l,L){return false;};
return V;});
sap.ui.predefine('sap/ui/mdc/actiontoolbar/ActionToolbarAction',["sap/ui/core/Control","sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer","sap/ui/mdc/enum/ActionToolbarActionAlignment"],function(C,A,a){"use strict";
var b=C.extend("sap.ui.mdc.actiontoolbar.ActionToolbarAction",{metadata:{library:"sap.ui.mdc",interfaces:["sap.m.IOverflowToolbarContent"],properties:{layoutInformation:{type:"object",defaultValue:{aggregationName:"end",alignment:a.Begin}}},defaultAggregation:"action",aggregations:{action:{type:"sap.ui.core.Control",multiple:false}},renderer:A}});
b.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true};c.onBeforeEnterOverflow=this._onBeforeEnterOverflow.bind(this);c.onAfterExitOverflow=this._onAfterExitOverflow.bind(this);return c;};
b.prototype._onBeforeEnterOverflow=function(){if(this.getParent()){this.getParent()._updateSeparators();}};
b.prototype._onAfterExitOverflow=function(){if(this.getParent()){this.getParent()._updateSeparators();}};
b.prototype.getLabel=function(){var o=this.getAction();return o&&o.getText?o.getText():this.getId();};
return b;});
sap.ui.predefine('sap/ui/mdc/chart/ChartSettings',[],function(){"use strict";var C={showPanel:function(c,p,s,P){C["showUI"+p](c,s);},showUIChart:function(c,s){c.getEngine().uimanager.show(c,"Item");},showUISort:function(c,s){c.getEngine().uimanager.show(c,"Sort");}};return C;});
sap.ui.predefine('sap/ui/mdc/chart/ChartTypeButton',["sap/m/OverflowToolbarButton","sap/m/ButtonRenderer","sap/ui/base/ManagedObjectObserver","sap/ui/core/library","sap/m/PlacementType"],function(O,B,M,C,P){"use strict";var H=C.aria.HasPopup;var R,L,a,S,b,I,D,r;
var c=O.extend("sap.ui.mdc.chart.ChartTypeButton",{
metadata:{library:"sap.ui.mdc"},
constructor:function(m){if(!m){O.apply(this);return;}this.oMDCChartModel=m.getManagedObjectModel();var s={type:"Transparent",press:function(e){this.displayChartTypes(e.getSource(),m);}.bind(this),id:m.getId()+"-btnChartType",icon:'{$chart>/getChartTypeInfo/icon}',tooltip:'{$chart>/getChartTypeInfo/text}',text:'{$chart>/getChartTypeInfo/text}',ariaHasPopup:H.ListBox};this.oMDCChart=m;O.apply(this,[s]);this.setModel(this.oMDCChartModel,"$chart");this._oObserver=new M(function(){this.oMDCChartModel.checkUpdate(true);}.bind(this));this._oObserver.observe(this.oMDCChart,{aggregations:["items"],properties:["chartType"]});},
renderer:B
});
c.mMatchingIcon={"bar":"sap-icon://horizontal-bar-chart","bullet":"sap-icon://horizontal-bullet-chart","bubble":"sap-icon://bubble-chart","column":"sap-icon://vertical-bar-chart","combination":"sap-icon://business-objects-experience","dual_bar":"sap-icon://horizontal-bar-chart","dual_column":"sap-icon://vertical-bar-chart","dual_combination":"sap-icon://business-objects-experience","dual_horizontal_combination":"sap-icon://business-objects-experience","dual_horizontal_stacked_combination":"sap-icon://business-objects-experience","dual_line":"sap-icon://line-chart","dual_stacked_bar":"sap-icon://full-stacked-chart","dual_stacked_column":"sap-icon://vertical-stacked-chart","dual_stacked_combination":"sap-icon://business-objects-experience","donut":"sap-icon://donut-chart","heatmap":"sap-icon://heatmap-chart","horizontal_stacked_combination":"sap-icon://business-objects-experience","line":"sap-icon://line-chart","pie":"sap-icon://pie-chart","scatter":"sap-icon://scatter-chart","stacked_bar":"sap-icon://full-stacked-chart","stacked_column":"sap-icon://vertical-stacked-chart","stacked_combination":"sap-icon://business-objects-experience","treemap":"sap-icon://Chart-Tree-Map","vertical_bullet":"sap-icon://vertical-bullet-chart","100_dual_stacked_bar":"sap-icon://full-stacked-chart","100_dual_stacked_column":"sap-icon://vertical-stacked-chart","100_stacked_bar":"sap-icon://full-stacked-chart","100_stacked_column":"sap-icon://full-stacked-column-chart","waterfall":"sap-icon://vertical-waterfall-chart","horizontal_waterfall":"sap-icon://horizontal-waterfall-chart"};
c.prototype.displayChartTypes=function(o,m){if(!m||!o){return;}if(!this.oReadyPromise){this.oReadyPromise=new Promise(function(d){if(R){d(true);}else{sap.ui.require(["sap/m/ResponsivePopover","sap/m/List","sap/m/Bar","sap/m/SearchField","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/ui/Device"],function(e,f,g,h,i,j,k){R=e;L=f;a=g;S=h;b=i;I=j;D=k;if(!r){sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc",true).then(function(l){r=l;d(true);});}else{d(true);}});}});}this.oReadyPromise.then(function(){this.oPopover=this._createPopover(o,m);this.oPopover.attachAfterClose(function(){this.oPopover.destroy();}.bind(this));return this.oPopover.openBy(o);}.bind(this));};
c.prototype._createPopover=function(o,m){var i=new b({title:"{$chart>text}",icon:"{$chart>icon}",selected:"{$chart>selected}"});var l=new L({mode:"SingleSelectMaster",items:{path:"$chart>/getAvailableChartTypes",template:i},selectionChange:function(E){if(E&&E.mParameters&&E.mParameters.listItem){var f=E.mParameters.listItem.getBinding("title");if(f){var g=f.getContext();if(g){var h=g.getObject();if(h&&h.key){sap.ui.require(["sap/ui/mdc/p13n/FlexUtil","sap/ui/mdc/flexibility/Chart.flexibility"],function(F,j){var k=[];k.push(j["setChartType"].changeHandler.createChange({control:m,chartType:h.key}));F.handleChanges(k);});}}}}p.close();}});var s=new a();var d=new S({placeholder:r.getText("chart.CHART_TYPE_SEARCH")});d.attachLiveChange(function(E){if(m){this._triggerSearchInPopover(E,l);}}.bind(this));s.addContentRight(d);var p=new R({id:m.getId()+"-btnChartTypePopover",placement:P.VerticalPreferredBottom,subHeader:s,contentWidth:"25rem"});p.setModel(this.oMDCChartModel,"$chart");if(D.system.desktop){var e=new I({text:r.getText("chart.CHART_TYPELIST_TEXT")});p.setShowHeader(false);p.addContent(e);p.addAriaLabelledBy(e);}else{p.setTitle(r.getText("chart.CHART_TYPELIST_TEXT"));}p.addContent(l);if(l.getItems().length<7){s.setVisible(false);}return p;};
c.prototype._triggerSearchInPopover=function(e,l){var p,i,t,T,v,d;if(!e||!l){return;}p=e.getParameters();if(!p){return;}v=p.newValue?p.newValue.toLowerCase():"";d=l.getItems();for(i=0;i<d.length;i++){T=d[i].getTooltip();t=d[i].getTitle();if((t&&(t.toLowerCase().indexOf(v)>-1))||(T&&(T.toLowerCase().indexOf(v)>-1))){d[i].setVisible(true);}else{d[i].setVisible(false);}}};
c.prototype.exit=function(){O.prototype.exit.apply(this,arguments);if(this.oPopover){this.oPopover.destroy();this.oPopover=null;}};
return c;});
sap.ui.predefine('sap/ui/mdc/chart/PropertyHelper',["../util/PropertyHelper"],function(P){"use strict";
var a=P.extend("sap.ui.mdc.chart.PropertyHelper");
a.prototype.prepareProperty=function(p){P.prototype.prepareProperty.apply(this,arguments);p.isAggregatable=function(){if(p){return p.isComplex()?false:p.aggregatable;}};};
a.prototype.getAllAggregatableProperties=function(){return this.getProperties().filter(function(p){return p.isAggregatable();});};
return a;});
sap.ui.predefine('sap/ui/mdc/field/BoolFieldHelp',['sap/ui/mdc/library','sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/base/ManagedObjectObserver','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/json/JSONModel'],function(l,F,C,M,a,P,J){"use strict";var L;var S;var m;var b;
var B=F.extend("sap.ui.mdc.field.BoolFieldHelp",{metadata:{library:"sap.ui.mdc"}});
B.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(d.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions"]});this._oModel=new J({"type":"","items":[{"key":true,"text":"true"},{"key":false,"text":"false"}]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
B._init=function(){F._init.apply(this,arguments);L=undefined;S=undefined;m=undefined;b=undefined;};
B.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._oModel.destroy();this._oModel=undefined;};
B.prototype.connect=function(o){F.prototype.connect.apply(this,arguments);n.call(this);return this;};
B.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if((!L||!S||!m)&&!this._bListRequested){L=sap.ui.require("sap/m/List");S=sap.ui.require("sap/m/StandardListItem");m=sap.ui.require("sap/m/library");b=sap.ui.require("sap/ui/model/Filter");if(!L||!S||!m){sap.ui.require(["sap/m/List","sap/m/StandardListItem","sap/m/library","sap/ui/model/Filter"],c.bind(this));this._bListRequested=true;}}if(p){var o=this._getField();if(o){p.setInitialFocus(o);}_.call(this);}return p;};
function _(){if(!this._oList&&L&&S&&m&&!this._bListRequested){var i=new S(this.getId()+"-item",{type:m.ListType.Active,title:"{text}"}).addStyleClass("sapMComboBoxNonInteractiveItem");this._oList=new L(this.getId()+"-List",{width:"100%",showNoData:false,mode:m.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"/items",template:i},itemPress:e.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");this._oList.setModel(this._oModel);f.call(this,this.getFilterValue());g.call(this);this._setContent(this._oList);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);this._iStep=null;}}}
function c(i,s,o,p){L=i;S=s;m=o;b=p;this._bListRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
B.prototype.open=function(s){var p=this.getAggregation("_popover");if(p){var o=this._getField();p.setInitialFocus(o);}F.prototype.open.apply(this,arguments);return this;};
B.prototype._handleAfterClose=function(E){if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;f.call(this);}this._oList.removeStyleClass("sapMListFocus");F.prototype._handleAfterClose.apply(this,arguments);};
function d(o){if(o.name==="conditions"){h.call(this,o.current);}if(o.name==="filterValue"){if(this._oList){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{f.call(this,o.current);}}}}
B.prototype.openByTyping=function(){return true;};
B.prototype.removeFocus=function(){if(this._oList){this._oList.removeStyleClass("sapMListFocus");}};
B.prototype.navigate=function(s){var p=this._getPopover();if(!p||!this._oList){this._bNavigate=true;this._iStep=s;return;}this._oList.addStyleClass("sapMListFocus");var o=this._oList.getSelectedItem();var i=this._oList.getItems();var I=i.length;var q=0;var r=false;if(o){q=this._oList.indexOfItem(o);q=q+s;if(q<0){q=0;r=true;}else if(q>=I-1){q=I-1;}}else if(s>=0){q=s-1;}else{q=I+s;}var t=i[q];if(t){if(!p.isOpen()){this.open();}if(t!==o){t.setSelected(true);var K=j.call(this,t);var u=k.call(this,K);this.setProperty("conditions",[u],true);this.fireNavigate({value:t.getTitle(),key:K,condition:u,itemId:t.getId()});}else if(r){this.fireNavigate({key:undefined,value:undefined,condition:undefined,itemId:undefined,leaveFocus:r});}}};
B.prototype._getTextOrKey=function(v,K,o,I,O,N,p,s){if(v===null||v===undefined||v===""){return null;}else if(!v&&!K){return null;}var q=this._oModel.getData()["items"];for(var i=0;i<q.length;i++){var r=q[i];if(K){if(r["key"]===v){return r["text"];}}else if(r["text"]===v){return r["key"];}}var E=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);if(K){throw new a(E);}else{throw new P(E);}};
function e(E){var i=E.getParameter("listItem");var s=i.getSelected();if(s){var K=j.call(this,i);var o=k.call(this,K);this.setProperty("conditions",[o],true);this.close();this.fireSelect({conditions:[o],add:true,close:true});}}
function f(t){var o=this._oList.getBinding("items");if(t){var i=new b({path:"text",operator:"StartsWith",value1:t});o.filter(i);}else{o.filter();}this._oList.invalidate();g.call(this);}
function g(){if(this._oList){var o=this.getConditions();var s;var t;var I=this._oList.getItems();var O=this._getOperator();if(o.length>0&&(o[0].operator===O.name)){s=o[0].values[0];t=this.getTextForKey(s);}for(var i=0;i<I.length;i++){var p=I[i];if(p.getTitle()===t){p.setSelected(true);}else{p.setSelected(false);}}}}
function h(i){g.call(this);}
function j(i){var o=i.getBindingContext();var D=o&&o.getObject();if(D){return D["key"];}}
function k(K){var o;var t=this.getTextForKey(K);if(t){o=this._createCondition(K,t);}return o;}
function n(){if(this._oField&&this._oField._getFormatOptions){var t=this._oField._getFormatOptions().valueType;var D=this._oModel.getData();if(t&&D["type"]!==t.getMetadata().getName()){D["type"]=t.getMetadata().getName();var I=D["items"];for(var i=0;i<I.length;i++){var o=I[i];o["text"]=t.formatValue(o["key"],"string");}}}}
return B;});
sap.ui.predefine('sap/ui/mdc/field/ConditionFieldHelp',['sap/m/library','sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/base/ManagedObjectObserver'],function(m,F,C,M){"use strict";var B=m.ButtonType;var D;var T;var a;var b;var c;var d;
var e=F.extend("sap.ui.mdc.field.ConditionFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},label:{type:"string",group:"Appearance",defaultValue:""},_enableOK:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"}}}});
e.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(g.bind(this));this._oObserver.observe(this,{properties:["title"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
e._init=function(){F._init.apply(this,arguments);D=undefined;b=undefined;};
e.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;};
e.prototype.getIcon=function(){return"sap-icon://value-help";};
e.prototype.isFocusInHelp=function(){return true;};
e.prototype.openByTyping=function(){return false;};
e.prototype.getAriaHasPopup=function(){return"dialog";};
e.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if((!D||!T||!a||!b||!c||!d)&&!this._bModulesRequested){D=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");T=sap.ui.require("sap/m/Toolbar");a=sap.ui.require("sap/m/ToolbarSpacer");b=sap.ui.require("sap/m/Button");c=sap.ui.require("sap/ui/model/base/ManagedObjectModel");d=sap.ui.require("sap/ui/mdc/condition/FilterOperatorUtil");if(!D||!T||!a||!b||!c){sap.ui.require(["sap/ui/mdc/field/DefineConditionPanel","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/condition/FilterOperatorUtil"],f.bind(this));this._bModulesRequested=true;}}if(p){p.setShowArrow(true);p.setTitle(this.getTitle());p.setShowHeader(true);p.setTitleAlignment("Center");p.setContentWidth("500px");p.setResizable(false);_.call(this);}return p;};
function _(){if(!this._oDefineConditionPanel&&D&&T&&a&&b&&c&&d&&!this._bModulesRequested){this._oManagedObjectModel=new c(this);this._oDefineConditionPanel=new D(this.getId()+"-DCP",{conditions:{path:"$help>/conditions"},formatOptions:h.call(this),label:"{$help>/label}",inputOK:"{$help>/_enableOK}"}).setModel(this._oManagedObjectModel,"$help");this._setContent(this._oDefineConditionPanel);var o=new b(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$help>/_enableOK}",type:B.Emphasized,press:i.bind(this)});var k=new b(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:j.bind(this)});var t=new T(this.getId()+"-TB",{content:[new a(this.getId()+"-Spacer"),o,k]}).setModel(this._oManagedObjectModel,"$help");var p=this.getAggregation("_popover");if(p){p.setFooter(t);}}}
function f(k,t,l,n,o,p){D=k;T=t;a=l;b=n;c=o;d=p;this._bModulesRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
e.prototype.open=function(s){F.prototype.open.apply(this,arguments);var p=this.getAggregation("_popover");if(p&&this._oDefineConditionPanel){this._oDefineConditionPanel.setFormatOptions(h.call(this));this._oDefineConditionPanel.getBinding("conditions").resume();}return this;};
e.prototype._handleAfterClose=function(E){this._oDefineConditionPanel.getBinding("conditions").suspend();setTimeout(function(){this._oDefineConditionPanel.cleanUp();this.setProperty("_enableOK",true,true);}.bind(this),0);F.prototype._handleAfterClose.apply(this,arguments);};
e.prototype._getControlForSuggestion=function(){var o=F.prototype._getControlForSuggestion.apply(this,arguments);var I=o.getAggregation("_endIcon",[]);if(I.length===1){o=I[0];}return o;};
function g(o){if(o.name==="title"){var p=this.getAggregation("_popover");if(p){p.setTitle(this.getTitel());}}}
e.prototype.isValidationSupported=function(){return false;};
e.prototype.getItemForValue=function(v,p,I,o,k,l,n,q){return{key:p,description:undefined};};
function h(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}}
function i(E){this.close();var k=this.getConditions();k=C._removeEmptyConditions(k);k=C._removeInitialFlags(k);d.updateConditionsValues(k);this.setProperty("conditions",k,true);this.fireSelect({conditions:k,add:false,close:true});}
function j(E){this.close();}
return e;});
sap.ui.predefine('sap/ui/mdc/field/CustomFieldHelp',['sap/ui/mdc/field/FieldHelpBase'],function(F){"use strict";
var C=F.extend("sap.ui.mdc.field.CustomFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content",events:{beforeOpen:{}}}});
C.prototype._createPopover=function(){var p=F.prototype._createPopover.apply(this,arguments);if(p){p._getAllContent=function(){var f=this.getParent();if(f){var c=[];c.push(f.getContent());return c;}else{return this.getContent();}};}return p;};
C.prototype.fireSelectEvent=function(c){this.close();this.fireSelect({conditions:c});};
C.prototype.open=function(s){this.fireBeforeOpen();F.prototype.open.apply(this,arguments);};
return C;});
sap.ui.predefine('sap/ui/mdc/field/CustomFieldInfo',['sap/ui/mdc/field/FieldInfoBase','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/base/ManagedObjectObserver'],function(F,C,I,M){"use strict";
var a=F.extend("sap.ui.mdc.field.CustomFieldInfo",{metadata:{library:"sap.ui.mdc",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"content"}});
a._oBox=undefined;
a.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{aggregations:["content"]});};
a.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oMyBox){this._oMyBox.destroy();this._oMyBox=undefined;}};
a.prototype.isTriggerable=function(){return Promise.resolve(!!this.getAggregation("content"));};
a.prototype.getTriggerHref=function(){return Promise.resolve(null);};
a.prototype.getDirectLinkHrefAndTarget=function(){return Promise.resolve(null);};
a.prototype.getContent=function(){if(!a._oBox){a._oBox=C.extend("sap.ui.mdc.field.CustomFieldInfoBox",{metadata:{},renderer:function(r,b){var c=b._oInfo.getAggregation("content");r.write("<div");r.writeControlData(b);r.write(">");if(c){r.renderControl(c);}r.write("</div>");}});}if(!this._oMyBox||this._oMyBox._bIsBeingDestroyed){this._oMyBox=new a._oBox(this.getId()+"-box");this._oMyBox._oInfo=this;}return Promise.resolve(this._oMyBox);};
function _(c){if(c.object==this&&!this._bIsBeingDestroyed){if(c.name=="content"){this.fireDataUpdate();}}}
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldBaseDelegate',['sap/ui/mdc/BaseDelegate','sap/ui/mdc/odata/TypeUtil'],function(B,T){"use strict";var F=Object.assign({},B);
F.getDataTypeClass=function(p,t){return T.getDataTypeClassName(t);};
F.getBaseType=function(p,t,f,c){return T.getBaseType(t,f,c);};
F.initializeTypeFromBinding=function(p,t,v){return{};};
F.initializeInternalUnitType=function(p,t,o){};
F.enhanceValueForUnit=function(p,v,t){return v;};
F.isInputValidationEnabled=function(p,f){if(f&&f.isValidationSupported()){return true;}else{return false;}};
F.isInvalidInputAllowed=function(p,f){if(f){return!f.getValidateInput();}else{return true;}};
F.getItemForValue=function(p,f,c){if(f){return f.getItemForValue(c);}};
F.getDescription=function(p,f,k,i,o,b,c,C){if(f){return f.getTextForKey(k,i,o,b,c,C);}};
F.getDefaultFieldHelpBaseDelegate=function(p){return{name:"sap/ui/mdc/field/FieldHelpBaseDelegate",payload:{}};};
F.getDefaultFieldValueHelpDelegate=function(p){return{name:"sap/ui/mdc/field/FieldValueHelpDelegate",payload:{}};};
F.getTypeUtil=function(p){return T;};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldHelpBase',['sap/ui/mdc/Element','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/base/Log','sap/base/util/merge','sap/ui/base/SyncPromise','sap/ui/model/FormatException','sap/ui/model/ParseException'],function(E,F,O,C,a,L,m,S,b,P){"use strict";var c;var l;
var d=E.extend("sap.ui.mdc.field.FieldHelpBase",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldHelpBaseDelegate"}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},navigate:{parameters:{value:{type:"any"},key:{type:"any"},condition:{type:"object"},itemId:{type:"string"},leaveFocus:{type:"boolean"}}},dataUpdate:{},disconnect:{},open:{suggestion:{type:"boolean"}},afterClose:{},switchToValueHelp:{}},defaultProperty:"filterValue"}});
d._init=function(){c=undefined;l=undefined;};
d.prototype.init=function(){E.prototype.init.apply(this,arguments);this._oTextOrKeyPromises={};};
d.prototype.invalidate=function(o){if(o){var p=this.getAggregation("_popover");if(p&&o===p){if(o.bOutput&&!this._bIsBeingDestroyed){var n=this.getParent();if(n){n.invalidate(this);}}return;}}};
d.prototype.setFilterValue=function(s){this.setProperty("filterValue",s,true);return this;};
d.prototype.connect=function(o){if(this._oField&&this._oField!==o){var p=this.getAggregation("_popover");if(p){p._oPreviousFocus=null;}this.close();this.setFilterValue("");this.setConditions([]);this.fireDisconnect();}this._oField=o;k.call(this,o);return this;};
d.prototype._getField=function(){if(this._oField){return this._oField;}else{return this.getParent();}};
d.prototype._getOperator=function(){if(!this._oOperator){this._oOperator=F.getEQOperator();}return this._oOperator;};
d.prototype._createCondition=function(K,D,I,o){var n=this._getOperator();var v=[K];if(n.valueTypes.length>1&&n.valueTypes[1]!==O.ValueType.Static&&D!==null&&D!==undefined){v.push(D);}return C.createCondition(n.name,v,I,o,a.Validated);};
d.prototype._getControlForSuggestion=function(){var o=this._getField();if(o.getControlForSuggestion){return o.getControlForSuggestion();}else{return o;}};
d.prototype.getFieldPath=function(){var s="";if(this._oField&&this._oField.getFieldPath){s=this._oField.getFieldPath();}return s||"Help";};
d.prototype.getDomRef=function(){var p=this.getAggregation("_popover");if(p){return p.getDomRef();}else{return E.prototype.getDomRef.apply(this,arguments);}};
d.prototype.getContentId=function(){var p=this.getAggregation("_popover");if(p){var n=p._getAllContent();if(n.length===1){return n[0].getId();}}};
d.prototype.getAriaHasPopup=function(){return"listbox";};
d.prototype.getRoleDescription=function(M){return null;};
d.prototype.getValueHelpEnabled=function(){return true;};
d.prototype.open=function(s){var o=this._getField();if(o){var p=this._getPopover();if(p&&!this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;if(!p.isOpen()){if(!this.isFocusInHelp()){p.setInitialFocus(this._getControlForSuggestion());}p.setFieldGroupIds(o.getFieldGroupIds());var n=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var q=this._fireOpen(!!s,n);if(q){if(p._getAllContent().length>0){p.openBy(this._getControlForSuggestion());}else{this._bOpenIfContent=true;}}else{this._bOpenAfterPromise=true;}}}else{this._bOpen=true;this._bSuggestion=s;}}else{L.warning("FieldHelp not assigned to field -> can not be opened.",this);}};
d.prototype.close=function(){var p=this.getAggregation("_popover");if(p&&p.isOpen()){var n=p.oPopup.getOpenState();if(n!=="CLOSED"&&n!=="CLOSING"){this._bClosing=true;p.close();}}else{delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}this._bReopen=false;};
d.prototype.toggleOpen=function(s){var p=this.getAggregation("_popover");if(p){if(p.isOpen()){var n=p.oPopup.getOpenState();if(n!=="CLOSED"&&n!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(s);}}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{this.open(s);}};
d.prototype.isOpen=function(n){if(n&&this._bClosing){return false;}var I=false;var p=this.getAggregation("_popover");if(p){I=p.isOpen();}return I;};
d.prototype.skipOpening=function(){if(this._bOpenIfContent){delete this._bOpenIfContent;}if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;}};
d.prototype.initBeforeOpen=function(s){if(this._bOpenAfterPromise){return;}var B=function(){this._bBeforeOpenPending=false;if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(s);}}.bind(this);var n=this._callContentRequest(s,B);if(!n){this._bBeforeOpenPending=true;}};
d.prototype._createPopover=function(){var p;if((!c||!l)&&!this._bPopoverRequested){c=sap.ui.require("sap/m/Popover");l=sap.ui.require("sap/m/library");if(!c||!l){sap.ui.require(["sap/m/Popover","sap/m/library"],_.bind(this));this._bPopoverRequested=true;}}if(c&&l&&!this._bPopoverRequested){p=new c(this.getId()+"-pop",{contentHeight:"auto",placement:l.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,afterOpen:this._handleAfterOpen.bind(this),afterClose:this._handleAfterClose.bind(this)}).addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");p.isPopupAdaptationAllowed=function(){return false;};this.setAggregation("_popover",p,true);if(this._oContent){this._setContent(this._oContent);}}return p;};
function _(p,n){c=p;l=n;this._bPopoverRequested=false;if(!this._bIsBeingDestroyed){this._createPopover();if(this._bOpen){this.open(this._bSuggestion);}}}
d.prototype._getPopover=function(){var p=this.getAggregation("_popover");if(!p){p=this._createPopover();}return p;};
d.prototype._handleAfterOpen=function(o){};
d.prototype._handleAfterClose=function(o){this._bClosing=false;if(this._bReopen){this._bReopen=false;this.open();}this.fireAfterClose();};
d.prototype.openByTyping=function(){return false;};
d.prototype.openByClick=function(){return false;};
d.prototype.isFocusInHelp=function(){return!this.openByTyping();};
d.prototype.removeFocus=function(){};
d.prototype.navigate=function(s){};
d.prototype.getTextForKey=function(K,I,o,B,n,s){return e.call(this,K,B,I,o,false,n,s,true);};
function e(K,B,I,o,n,p,s,q){return h.call(this,true,K,B,I,o,n,p,s,undefined,false,q);}
d.prototype.getKeyForText=function(t,B,o,s){return f.call(this,t,B,false,o,s,true);};
function f(t,B,n,o,s,p){return h.call(this,false,t,B,undefined,undefined,n,o,s,undefined,false,p);}
d.prototype._getTextOrKey=function(v,K,B,I,o,n,p,s,q,r,t){if(K){return"";}else{return undefined;}};
d.prototype._isTextOrKeyRequestSupported=function(){return false;};
d.prototype.isValidationSupported=function(){return this.isUsableForValidation();};
d.prototype.getItemForValue=function(v,p,I,o,B,n,q,r,s,t){if(typeof v!=="object"||!v.hasOwnProperty("value")){v={value:v,parsedValue:p,inParameters:I,outParameters:o,bindingContext:B,checkKeyFirst:n,checkKey:q,checkDescription:r,conditionModel:s,conditionModelName:t};}if(v&&typeof v==="object"&&v.hasOwnProperty("value")){return g.call(this,v.value,v.parsedValue,v.inParameters,v.outParameters,v.bindingContext,v.checkKeyFirst&&v.checkKey,v.checkKey,v.checkDescription,v.conditionModel,v.conditionModelName);}else{return g.call(this,v,p,I,o,B,n&&q,q,r,s,t);}};
function g(v,p,I,o,B,n,q,r,s,t){return S.resolve().then(function(){if(q&&r){return h.call(this,true,v,B,I,o,false,s,t,p,true,false);}else if(q){return e.call(this,p,B,I,o,false,s,t,false);}else if(r){return f.call(this,v,B,false,s,t,false);}}.bind(this)).then(function(R){if(R){if(typeof R==="object"){return R;}else if(q){return{key:p,description:R};}else{return{key:R,description:v};}}else{return undefined;}}).catch(function(u){throw u;}).unwrap();}
d.prototype.isUsableForValidation=function(){return true;};
d.prototype.onFieldChange=function(){};
d.prototype._setContent=function(o){var p=this.getAggregation("_popover");if(p){p.removeAllContent();p.addContent(o);this._oContent=undefined;if(this._bOpenIfContent){var n=this._getField();if(n){p.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else{this._oContent=o;}return this;};
d.prototype.getIcon=function(){return"sap-icon://slim-arrow-down";};
d.prototype.getUIArea=function(){var u=E.prototype.getUIArea.apply(this,arguments);if(!u){if(this._oField){u=this._oField.getUIArea();}}return u;};
d.prototype.getScrollDelegate=function(){var p=this.getAggregation("_popover");if(p){return p.getScrollDelegate();}else{return undefined;}};
d.prototype._fireOpen=function(s,n){if(this._bBeforeOpenPending){return false;}var o=this._callContentRequest(s,n);if(o){this.fireOpen({suggestion:s});}return o;};
d.prototype._callContentRequest=function(s,n){if(!this._bNoContentRequest){if(this._oContentRequestPromise){this._oContentRequestPromise.then(function(){this._bNoContentRequest=true;n();this._bNoContentRequest=false;}.bind(this));return false;}if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}if(this.bDelegateInitialized){var p=this._getContenRequestProperties(s);var o=this.getControlDelegate().contentRequest(this.getPayload(),this,s,p);if(o instanceof Promise){this._oContentRequestPromise=o;o.then(function(){this._oContentRequestPromise=undefined;this._bNoContentRequest=true;n();this._bNoContentRequest=false;}.bind(this));return false;}}else{this.awaitControlDelegate().then(function(){if(this._callContentRequest(s,n)){n();}}.bind(this));return false;}}return true;};
d.prototype._getContenRequestProperties=function(s){return null;};
function h(K,v,B,I,o,n,p,s,q,r,t){var u=JSON.stringify(I);var w=B&&B.getPath();if(this._oTextOrKeyPromises[K]&&this._oTextOrKeyPromises[K][v]&&this._oTextOrKeyPromises[K][v][u]&&this._oTextOrKeyPromises[K][v][u][w]){return this._oTextOrKeyPromises[K][v][u][w].promise;}var x=function(){i.call(this);}.bind(this);var y=this._callContentRequest(true,x);if(!y){if(!this._oTextOrKeyPromises[K]){this._oTextOrKeyPromises[K]={};}if(!this._oTextOrKeyPromises[K][v]){this._oTextOrKeyPromises[K][v]={};}if(!this._oTextOrKeyPromises[K][v][u]){this._oTextOrKeyPromises[K][v][u]={};}if(!this._oTextOrKeyPromises[K][v][u][w]){this._oTextOrKeyPromises[K][v][u][w]={};}this._oTextOrKeyPromises[K][v][u][w].promise=new Promise(function(R,z){this._oTextOrKeyPromises[K][v][u][w].resolve=R;this._oTextOrKeyPromises[K][v][u][w].reject=z;this._oTextOrKeyPromises[K][v][u][w].key=K;this._oTextOrKeyPromises[K][v][u][w].value=v;this._oTextOrKeyPromises[K][v][u][w].inParameters=I?m({},I):undefined;this._oTextOrKeyPromises[K][v][u][w].outParameters=o?m({},o):undefined;this._oTextOrKeyPromises[K][v][u][w].bindingContext=B;this._oTextOrKeyPromises[K][v][u][w].noRequest=n;this._oTextOrKeyPromises[K][v][u][w].conditionModel=p;this._oTextOrKeyPromises[K][v][u][w].conditionModelName=s;this._oTextOrKeyPromises[K][v][u][w].parsedValue=q;this._oTextOrKeyPromises[K][v][u][w].keyAndDescription=r;this._oTextOrKeyPromises[K][v][u][w].caseSensitive=t;}.bind(this));return this._oTextOrKeyPromises[K][v][u][w].promise;}return this._getTextOrKey(v,K,B,I,o,n,p,s,q,r,t);}
function i(){for(var K in this._oTextOrKeyPromises){for(var v in this._oTextOrKeyPromises[K]){for(var I in this._oTextOrKeyPromises[K][v]){for(var s in this._oTextOrKeyPromises[K][v][I]){j.call(this,this._oTextOrKeyPromises[K][v][I][s]);delete this._oTextOrKeyPromises[K][v][I][s];}}}}}
function j(t){var M=t.value;var n=t.key;var I=t.inParameters;var o=t.outParameters;var B=t.bindingContext;var N=t.noRequest;var r=t.resolve;var R=t.reject;var p=t.conditionModel;var s=t.conditionModelName;var v=t.parsedValue;var K=t.keyAndDescription;var q=t.caseSensitive;S.resolve().then(function(){return this._getTextOrKey(M,n,B,I,o,N,p,s,v,K,q);}.bind(this)).then(function(u){r(u);}).catch(function(u){R(u);}).unwrap();}
function k(o){this._oOperator=undefined;if(o&&o._getOperators){this._oOperator=F.getEQOperator(o._getOperators());}}
d.prototype.isTypeaheadSupported=function(){return this.openByTyping();};
d.prototype.shouldOpenOnClick=function(){return this.openByClick();};
d.prototype.onControlChange=function(){return this.onFieldChange();};
d.prototype.getAriaAttributes=function(M){return{contentId:this.getContentId(),ariaHasPopup:this.getAriaHasPopup(),role:"combobox",roleDescription:this.getRoleDescription(M),valueHelpEnabled:this.getValueHelpEnabled()};};
d.prototype.attachEvent=function(s,D,n,o){if(s==="navigated"){return E.prototype.attachEvent.apply(this,["navigate",D,n,o]);}else{return E.prototype.attachEvent.apply(this,arguments);}};
d.prototype.detachEvent=function(s,n,o){if(s==="navigated"){return E.prototype.detachEvent.apply(this,["navigate",n,o]);}else{return E.prototype.detachEvent.apply(this,arguments);}};
return d;});
sap.ui.predefine('sap/ui/mdc/field/FieldHelpBaseDelegate',[],function(){"use strict";var F={contentRequest:function(p,f,s,P){}};return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInfoBase',['sap/ui/Device','sap/ui/mdc/Element','sap/m/library','sap/m/ResponsivePopover'],function(D,E,m,R){"use strict";var P=m.PlacementType;
var F=E.extend("sap.ui.mdc.field.FieldInfoBase",{metadata:{library:"sap.ui.mdc",events:{dataUpdate:{},popoverAfterOpen:{}}}});
F.prototype.isTriggerable=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method isTriggerable must be redefined");};
F.prototype.getTriggerHref=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getTriggerHref must be redefined");};
F.prototype.getDirectLinkHrefAndTarget=function(){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getDirectLinkHrefAndTarget must be redefined");};
F.prototype.open=function(c){var p=this.getParent();if(!p){throw new Error("sap.ui.mdc.field.FieldInfoBase: popover can not be open because the control is undefined");}if(this._oPopover&&this._oPopover.isOpen()){return Promise.resolve();}return this.createPopover().then(function(o){this._oPopover=o;this.addDependent(this._oPopover);this._oPopover.openBy(c||p);this._oPopover.attachAfterOpen(function(){this.firePopoverAfterOpen();}.bind(this));}.bind(this));};
F.prototype.getContent=function(g){throw new Error("sap.ui.mdc.field.FieldInfoBase: method getContent must be redefined");};
F.prototype.getSourceControl=function(){return this.getParent();};
F.prototype.createPopover=function(){var p;return this.getContent(function(){return p;}).then(function(o){p=new R(this.getId()+"-popover",{contentWidth:"380px",horizontalScrolling:false,showHeader:D.system.phone,placement:P.Auto,content:[o],afterClose:function(){if(this._oPopover){this._oPopover.destroy();}}.bind(this)});sap.ui.require(['sap/ui/fl/apply/api/FlexRuntimeInfoAPI'],function(a){if(a.isFlexSupported({element:o})){a.waitForChanges({element:o}).then(function(){p.addAriaLabelledBy(o.getContentTitle?o.getContentTitle():"");});}else if(o){p.addAriaLabelledBy(o.getContentTitle?o.getContentTitle():"");}});return p;}.bind(this));};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInput',['sap/m/Input','sap/ui/mdc/field/FieldInputRenderer'],function(I,F){"use strict";
var a=I.extend("sap.ui.mdc.field.FieldInput",{
metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},
renderer:F
});
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldMultiInput',['sap/m/MultiInput','sap/ui/mdc/field/FieldMultiInputRenderer'],function(M,F){"use strict";
var a=M.extend("sap.ui.mdc.field.FieldMultiInput",{
metadata:{library:"sap.ui.mdc",properties:{ariaAttributes:{type:"object",defaultValue:{},byValue:true}}},
renderer:F
});
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelp',['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/OutParameterMode','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/condition/FilterConverter','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/ObjectPath','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/resource/ResourceModel','sap/ui/model/Context','sap/ui/Device','sap/m/library','sap/ui/core/library',"sap/ui/mdc/util/loadModules","sap/ui/events/KeyCodes"],function(F,C,a,O,b,c,M,S,d,e,m,R,f,D,g,h,l,K){"use strict";var k;var B;var V;var n;var o;var p;var q;var r;var I;var s=g.ButtonType;var t=h.OpenState;
var u=F.extend("sap.ui.mdc.field.FieldValueHelp",{metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/field/FieldValueHelpDelegate"}},filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},showConditionPanel:{type:"boolean",defaultValue:false},title:{type:"string",group:"Appearance",defaultValue:""},noDialog:{type:"boolean",group:"Appearance",defaultValue:false},caseSensitive:{type:"boolean",defaultValue:true},_enableOK:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},suggestContent:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},dialogContent:{type:"sap.ui.mdc.field.FieldValueHelpContentWrapperBase",multiple:false},filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false},inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false,visibility:"hidden"},collectiveSearchItems:{type:"sap.ui.core.Item",multiple:true,singularName:"collectiveSearchItem"}},defaultAggregation:"content",events:{dataRequested:{}}}});
u._init=function(){F._init.apply(this,arguments);k=undefined;B=undefined;V=undefined;n=undefined;o=undefined;};
u.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(v.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","showConditionPanel","filterFields"],aggregations:["content","suggestContent","dialogContent","filterBar","_filterBar","inParameters","collectiveSearchItems"]});this.setBindingContext(null);this._oConditions={};};
u.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}this._oObserver.disconnect();this._oObserver=undefined;delete this._oConditions;if(this._iUpdateTimer){clearTimeout(this._iUpdateTimer);this._iUpdateTimer=null;}if(this._iFilterTimer){clearTimeout(this._iFilterTimer);this._iFilterTimer=null;}if(this._iSearchFieldTimer){clearTimeout(this._iSearchFieldTimer);this._iSearchFieldTimer=null;}if(this._oCollectiveSearchSelect){this._oCollectiveSearchSelect.destroy();delete this._oCollectiveSearchSelect;}if(this._oResourceBundleM){this._oResourceBundleM=null;}if(this._oResourceBundle){this._oResourceBundle=null;}};
u.prototype.invalidate=function(i){if(i){var j=F1.call(this,true);var G1=F1.call(this,false);var H1=this.getAggregation("_dialog");if((j&&i===j)||(G1&&i===G1)){var I1=this.getAggregation("_popover");if(H1&&H1.isOpen()){var J1=H1.getContent()[0];J1.invalidate(i);}else if(I1&&I1.isOpen()){I1.invalidate(i);}return;}var K1=this._getFilterBar();if((H1&&i===H1)||(K1&&i===K1)){if(i.bOutput&&!this._bIsBeingDestroyed){var L1=this.getParent();if(L1){L1.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};
u.prototype.connect=function(i){F.prototype.connect.apply(this,arguments);A1.call(this);r1.call(this,this.getShowConditionPanel());return this;};
u.prototype.getIcon=function(){if(this.getNoDialog()){return"sap-icon://slim-arrow-down";}else{return"sap-icon://value-help";}};
u.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);var j=function(H1){this.fireSwitchToValueHelp();}.bind(this);if(i){i.addDelegate({onsapshow:j});var G1=F1.call(this,true);if(G1){S.resolve(G1.initialize(true)).then(function(){if(G1.enableShowAllItems()){l(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(function(H1){var B=H1[0];var I1=H1[1];var J1=H1[2];var K1=B1.apply(this);var L1=new B(this.getId()+"-showAllItems",{text:K1.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:j});var M1=[new J1(this.getId()+"-Spacer")].concat(L1);var N1=new I1(this.getId()+"-TB",{content:M1,visible:!G1.getAllItemsShown()}).setModel(this._oFooterModel,"$config");i.setFooter(N1);}.bind(this));}}.bind(this));}i._getAllContent=function(){var H1=this.getParent();var I1=[];if(H1){var J1=z1.call(H1);if(J1){I1.push(J1);}}return I1;};if(this._bNavigate){this.navigate(this._iStep);}}return i;};
u.prototype._handleAfterOpen=function(i){F.prototype._handleAfterOpen.apply(this,arguments);var j=F1.call(this,true);if(j){j.fieldHelpOpen(true);}};
u.prototype.open=function(i){if(this.getNoDialog()&&!i){i=true;}A1.call(this);if(this._bOpenAfterPromise){this._bSuggestion=i;return;}var j=F1.call(this,i);var G1=function(){if(this._bOpenAfterPromise){delete this._bOpenAfterPromise;this.open(this._bSuggestion);delete this._bSuggestion;}}.bind(this);var H1=this._bOpen?this._callContentRequest(!!i,G1):this._fireOpen(!!i,G1);delete this._bOpen;if(!H1){this._bSuggestion=i;if(i){this._getPopover();}else{m1.call(this);}this._bOpenAfterPromise=true;return;}this._bOpenHandled=true;j=F1.call(this,i);if(j&&j.getFilterEnabled()&&!this._bNavigateRunning){this._bApplyFilter=false;if(!j.isSuspended()||i||this.getFilterValue()){this._bApplyFilter=true;}u1.call(this);}if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;P.call(this,this.getFilterValue());}if(i){if(!j){this._bOpenIfContent=true;}else{j.fieldHelpOpen(i);if(!this.getFilterValue()&&!this._bNavigateRunning){e1.call(this,true);}F.prototype.open.apply(this,[i]);}}else{var I1=this.getAggregation("_popover");if(I1){if(I1.isOpen()){this.close();this._bSwitchToDialog=true;}I1.$().remove();}var J1=m1.call(this);if(J1){y1.call(this);E1.call(this,true);t1.call(this);J1.setFieldGroupIds(this._oField.getFieldGroupIds());var K1=J1.getContent()[0];K1.setShowTokenizer(this.getMaxConditions()!==1&&!!j);K1.setFormatOptions(this._getFormatOptions());K1.bindProperty("conditions",{path:"$help>/conditions"});if(j){j.fieldHelpOpen(false);L.call(this);}this._aOldConditions=this.getConditions();J1.open();this._bDialogOpen=true;}else{this._bOpen=true;}}this._bOpenHandled=false;return;};
u.prototype.toggleOpen=function(i){if(this.getNoDialog()&&!i){i=true;}if(i){F.prototype.toggleOpen.apply(this,[i]);}else if(this._bOpen||this._bOpenIfContent||this._bOpenAfterPromise){delete this._bOpen;delete this._bSuggestion;delete this._bOpenIfContent;delete this._bOpenAfterPromise;}else{var j=m1.call(this);if(j){if(j.isOpen()){var G1=j.oPopup.getOpenState();if(G1!=="CLOSED"&&G1!=="CLOSING"){this.close();}else{this._bReopen=true;}}else{this.open(i);}}else{this.open(i);}}};
u.prototype.close=function(){if(!this._bDialogOpen){F.prototype.close.apply(this,arguments);}else{var i=this.getAggregation("_dialog");if(i){this._bClosing=true;i.close();var j=i.getContent()[0];j.unbindProperty("conditions",true);if(j._oDefineConditionPanel){j._oDefineConditionPanel.cleanUp();}}this._bReopen=false;this._bSwitchToDialog=false;delete this._bOpen;delete this._bOpenAfterPromise;}};
u.prototype.isOpen=function(i){var j=F.prototype.isOpen.apply(this,arguments);if(!j&&(!i||!this._bClosing)){var G1=this.getAggregation("_dialog");if(G1){j=G1.isOpen();}}return j;};
u.prototype.getDomRef=function(){if(!this._bDialogOpen){return F.prototype.getDomRef.apply(this,arguments);}else{var i=this.getAggregation("_dialog");if(i){return i.getDomRef();}}};
function _(){var i=this._getFilterBar();var j;if(i){j=i.getInternalConditions();}else{j=this._oConditions;}var G1=false;for(var H1 in j){if(j[H1].length>0){x1.call(this,H1);G1=true;}}if(G1){e1.call(this,true);}}
u.prototype._handleAfterClose=function(i){var j=this.getAggregation("_dialog");var G1=!j||i.getSource()!==j;var H1=F1.call(this,G1);if(H1){if(!H1.getAsyncKeyText()){_.call(this);}H1.fieldHelpClose();}if(!this.isOpen()){this._bApplyFilter=false;}this._bNavigateRunning=false;F.prototype._handleAfterClose.apply(this,arguments);};
function v(i){if(i.object==this){var j;if(i.name==="content"){l1.call(this,i.mutation,i.child,i.name);}if(i.name==="suggestContent"){l1.call(this,i.mutation,i.child,i.name);}if(i.name==="dialogContent"){l1.call(this,i.mutation,i.child,i.name);}if(i.name==="filterBar"){if(i.mutation==="insert"&&this.getAggregation("_filterBar")){this.destroyAggregation("_filterBar");delete this._oSearchField;}s1.call(this,i.mutation,i.child,false);}if(i.name==="_filterBar"){s1.call(this,i.mutation,i.child,true);}if(i.name==="conditions"){J.call(this,i.current);}if(i.name==="filterValue"){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{P.call(this,i.current);}}if(i.name==="showConditionPanel"){r1.call(this,i.current);}if(i.name==="filterFields"){j=this.getAggregation("_dialog");if(j){if(j.isOpen()){if(i.current){y1.call(this);}else if(this.getAggregation("_filterBar")){this.destroyAggregation("_filterBar");}}}}if(i.name==="inParameters"){Q.call(this,i.child,i.mutation);}if(i.name==="collectiveSearchItems"){E1.call(this,false);}}else if(i.object.isA("sap.ui.mdc.field.InParameter")){if(i.name==="value"){W.call(this,i.object.getHelpPath(),i.current,i.old,i.object.getUseConditions(),i.object.getInitialValueFilterEmpty());}if(i.name==="helpPath"){X.call(this,i.current,i.old,i.object.getValue(),i.object.getUseConditions(),i.object.getInitialValueFilterEmpty());}}}
u.prototype.openByTyping=function(){if(!this._bDetermineSearchSupportedCalled&&!this.isOpen()&&!this._bOpen&&!this._bOpenIfContent&&!this._bOpenAfterPromise){if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}if(this.bDelegateInitialized){return w.call(this);}else{this._bDetermineSearchSupportedCalled=true;return this.awaitControlDelegate().then(function(){return w.call(this);}.bind(this));}}return!!this.getFilterFields();};
function w(){this.fireOpen({suggestion:true});this._bDetermineSearchSupportedCalled=true;var i=this.getControlDelegate().determineSearchSupported(this.getPayload(),this);if(i instanceof Promise){return i.then(function(){return!!this.getFilterFields();}.bind(this));}else{return!!this.getFilterFields();}}
u.prototype.isFocusInHelp=function(){if(!this.getNoDialog()){var i=this.getAggregation("_dialog");if((i&&i.isOpen())||(this._bDialogRequested&&this._bOpen)||(this._bOpenAfterPromise&&!this._bSuggestion)){return true;}}if(this._bFocusPopover){return true;}return false;};
u.prototype.removeFocus=function(){var i=F1.call(this,true);if(i){i.removeFocus();}};
u.prototype.navigate=function(i){var j=F1.call(this,true);var G1=this.getAggregation("_popover");A1.call(this);if(!G1||!G1.isOpen()){var H1=function(){this.navigate(i);}.bind(this);var I1=this._bNavigate?this._callContentRequest(true,H1):this._fireOpen(true,H1);if(!I1){j=F1.call(this,true);this._bNavigate=false;this._iStep=null;if(j){this._getPopover();}return;}}this._bNavigate=false;this._iStep=null;j=F1.call(this,true);if(j){G1=this._getPopover();this._bApplyFilter=true;this._bNavigateRunning=true;u1.call(this);e1.call(this,true);}if(!G1){this._bNavigate=true;this._iStep=i;return;}if(j){j.navigate(i,G1.isOpen());}};
function x(i){var j=this._getPopover();var G1=i.getParameter("disableFocus");var H1=i.getParameter("key");var I1=i.getParameter("description");var J1=i.getParameter("inParameters");var K1=i.getParameter("outParameters");var L1=i.getParameter("leave");var M1=i.getParameter("itemId");var N1;if(L1){this.fireNavigate({key:undefined,value:undefined,condition:undefined,itemId:undefined,leaveFocus:L1});return;}if(H1===undefined&&!G1){this._bFocusPopover=true;}if(!j.isOpen()){this._bOpenHandled=true;this.open(true);this._bOpenHandled=false;}this._bNavigateRunning=false;if(H1===undefined){this._bFocusPopover=false;return;}if(J1){J1=Z.call(this,J1);}if(K1){K1=$.call(this,K1);}N1=this._createCondition(H1,I1,J1,K1);this.setProperty("conditions",[N1],true);this.fireNavigate({value:I1,key:H1,condition:N1,itemId:M1,leaveFocus:L1});}
u.prototype._getTextOrKey=function(i,j,G1,H1,I1,J1,K1,L1,M1,N1,O1){var P1="";var Q1=F1.call(this,true);if(Q1){var R1=Q1.getListBinding();if(!R1){this.fireDataRequested();}if(G1&&!G1.getModel()){return null;}O1=O1||this.getCaseSensitive();var S1=this.oBindingContexts[undefined];var T1=this.getInParameters();var U1=false;if(G1&&f.hasChanged(S1,G1)){U1=true;}var V1=y.call(this,T1,U1,G1,S1,K1,L1);P1=S.resolve().then(function(){return A.call(this,V1);}.bind(this)).then(function(){return S.resolve().then(function(){if(G1&&!G1.getModel()){return null;}else if(N1){return Q1.getKeyAndText(M1,i,d1.call(this,H1,T1,false,V1,G1,true),d1.call(this,I1,this.getOutParameters(),true,undefined,undefined,true),O1);}else if(j){return Q1.getTextForKey(i,d1.call(this,H1,T1,false,V1,G1,true),d1.call(this,I1,this.getOutParameters(),true,undefined,undefined,true),J1,O1);}else{return Q1.getKeyForText(i,d1.call(this,undefined,T1,false,V1,G1,true),J1,O1);}}.bind(this)).then(function(P1){z.call(this,V1,U1);return E.call(this,P1);}.bind(this)).unwrap();}.bind(this)).unwrap();}return P1;};
function y(j,G1,H1,I1,J1,K1){var L1=[];for(var i=0;i<j.length;i++){var M1=j[i];var N1=M1.getBinding("value");if(M1.getUseConditions()&&J1){var O1=this.getModel(K1);if(O1!==J1){L1.push(J1.bindProperty("/"+M1.getFieldPath()));}}else if(N1){var P1=N1.getPath();var Q1=N1.getContext();if(G1&&N1.isRelative()&&(Q1===I1||(!Q1&&I1))){if(H1.getProperty(P1)===undefined){var R1=N1.getModel();L1.push(R1.bindProperty(P1,H1));}}else if((!Q1&&N1.isRelative())||(Q1&&Q1.getProperty(P1)===undefined)||N1.getValue()===undefined||(Q1&&!e(M1.validateProperty("value",Q1.getProperty(P1)),M1.getValue()))){L1.push(N1);}}}return L1;}
function z(j,G1){if(!G1){return;}for(var i=0;i<j.length;i++){j[i].destroy();}}
function A(i){if(i.length===0){return null;}if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}if(this.bDelegateInitialized){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}else{return this.awaitControlDelegate().then(function(){return this.getControlDelegate().checkBindingsPending(this.getPayload(),i);}.bind(this));}}
function E(i){if(i&&typeof i==="object"){i=m({},i);if(i.inParameters){i.inParameters=Z.call(this,i.inParameters);}if(i.outParameters){i.outParameters=$.call(this,i.outParameters);}}return i;}
u.prototype._isTextOrKeyRequestSupported=function(){var i=F1.call(this,true);return!!i;};
u.prototype.isUsableForValidation=function(){var i=F1.call(this,true);return!!i;};
function G(G1){var H1=G1.getParameter("selectedItems");var I1=G1.getParameter("itemPress");var J1;var K1=this.getConditions();var L1;var i=0;var j=0;var M1=false;var N1=this.getMaxConditions();var O1=this._getOperator();for(i=K1.length-1;i>=0;i--){L1=K1[i];L1.inParameters=b1.call(this,L1.inParameters);L1.outParameters=c1.call(this,L1.outParameters);if(L1.operator===O1.name&&L1.validated===b.Validated){M1=false;for(j=0;j<H1.length;j++){J1=H1[j];if(L1.values[0]===J1.key&&(!L1.inParameters||!J1.inParameters||e(L1.inParameters,J1.inParameters))&&(!L1.outParameters||!J1.outParameters||e(L1.outParameters,J1.outParameters))){M1=true;if(L1.values[1]!==J1.description&&J1.description){if(L1.values.length===1){L1.values.push(J1.description);}else{L1.values[1]=J1.description;}}break;}}if(!M1){K1.splice(i,1);}}}for(i=0;i<H1.length;i++){J1=H1[i];M1=false;for(j=0;j<K1.length;j++){L1=K1[j];if(L1.operator===O1.name&&L1.validated===b.Validated&&L1.values[0]===J1.key&&(!L1.inParameters||e(L1.inParameters,J1.inParameters))&&(!L1.outParameters||e(L1.outParameters,J1.outParameters))){M1=true;L1.inParameters=J1.inParameters;L1.outParameters=J1.outParameters;break;}}if(!M1){L1=this._createCondition(J1.key,J1.description,J1.inParameters,J1.outParameters);K1.push(L1);}}if(N1>0&&K1.length>N1){K1.splice(0,K1.length-N1);}for(i=0;i<K1.length;i++){L1=K1[i];if(L1.inParameters){L1.inParameters=Z.call(this,L1.inParameters);}else{delete L1.inParameters;}if(L1.outParameters){L1.outParameters=$.call(this,L1.outParameters);}else{delete L1.outParameters;}}if(this._bDialogOpen){this.setProperty("conditions",K1,true);}else{var P1=false;var Q1=false;if(this.getMaxConditions()===1||I1){this.close();Q1=true;}if(this.getMaxConditions()===1){P1=true;}this.setProperty("conditions",K1,true);this.fireSelect({conditions:K1,add:P1,close:Q1});}}
function H(i){var j=i.getParameter("contentChange");var G1=i.getSource();var H1;if(G1.enableShowAllItems()){H1=this.getAggregation("_popover");var I1=H1&&H1.getFooter();if(I1){I1.setVisible(!G1.getAllItemsShown());}}if(j){H1=H1||this.getAggregation("_popover");var J1=this.getAggregation("_dialog");if(H1&&this._bOpenIfContent){G1=F1.call(this,true);if(G1){var K1=this._getField();if(K1){G1.fieldHelpOpen(true);H1.openBy(this._getControlForSuggestion());e1.call(this);}this._bOpenIfContent=false;}}else if(J1){G1=F1.call(this,false);if(G1){var L1=J1.getContent()[0];k1.call(this,L1,G1.getDialogContent());if(!this._bApplyFilter&&!this._bClosing&&(this.isOpen()||this._bOpen)&&!G1.isSuspended()){this._bApplyFilter=true;}}}}if(!G1||!G1.getAsyncKeyText()){this.fireDataUpdate();}}
function J(j){var G1=false;for(var i=0;i<j.length;i++){var H1=j[i];if(!H1.validated){a.checkConditionValidated(H1);G1=true;}}if(G1){this.setConditions(j);}else{L.call(this);}}
function L(){if(!this._oField){return;}N.call(this,F1.call(this,true));N.call(this,F1.call(this,false));}
function N(j){if(j){var G1=this._getOperator();var H1=this.getConditions();var I1=[];for(var i=0;i<H1.length;i++){var J1=H1[i];if(J1.operator===G1.name&&J1.validated===b.Validated){I1.push({key:J1.values[0],description:J1.values[1],inParameters:b1.call(this,J1.inParameters),outParameters:c1.call(this,J1.outParameters)});}}if(!e(I1,j.getSelectedItems())){j.setSelectedItems(I1);}}}
function P(i){var j=this.getFilterFields();if(!j){return;}var G1=v1.call(this,j);var H1=G1.length>0?G1[0].values[0]:"";if(i===H1){return;}x1.call(this,j);i=i.trim();if(i){this._bOwnFilterChange=false;var I1=C.createCondition("StartsWith",[i],undefined,undefined,b.NotValidated);w1.call(this,j,I1);}e1.call(this,true);}
function Q(i,j){var G1=i.getHelpPath();var H1=false;if(j==="remove"){this._oObserver.unobserve(i);if(this._getField()&&this.isOpen()){H1=U.call(this,G1);}}else{this._oObserver.observe(i,{properties:true});if(this._getField()&&this.isOpen()){var I1=i.getValue();var J1=i.getUseConditions();var K1=i.getInitialValueFilterEmpty();H1=U.call(this,G1);H1=T.call(this,G1,I1,J1,K1)||H1;L.call(this);}}e1.call(this,true);}
function T(j,G1,H1,I1){var J1;var K1=false;if(j&&(G1||(I1&&!H1))){if(H1){if(Array.isArray(G1)){for(var i=0;i<G1.length;i++){J1=m({},G1[i]);if(J1.inParameters){J1.inParameters=b1.call(this,J1.inParameters,true);}if(J1.outParameters){J1.outParameters=c1.call(this,J1.outParameters,false,true);}w1.call(this,j,J1);K1=true;}}}else{if(!G1&&I1){J1=C.createCondition("Empty",[]);J1.isEmpty=false;}else{J1=C.createItemCondition(G1);J1.validated=b.Validated;}w1.call(this,j,J1);K1=true;}}return K1;}
function U(i){var j=false;if(i&&v1.call(this,i).length>0){x1.call(this,i);j=true;}return j;}
function W(i,j,G1,H1,I1){if(this._bNoInOutFilterUpdate){return;}if(!this._iUpdateTimer){this._iUpdateTimer=setTimeout(function(){this._iUpdateTimer=undefined;this.fireDataUpdate();}.bind(this),0);}if(!this._getField()||!this.isOpen()){return;}var J1=false;J1=U.call(this,i);J1=T.call(this,i,j,H1,I1)||J1;L.call(this);e1.call(this,true);}
function X(i,j,G1,H1,I1){if(!this._getField()||!this.isOpen()){return;}var J1=false;J1=U.call(this,j);J1=T.call(this,i,G1,H1,I1)||J1;e1.call(this,true);}
function Y(){var j=this.getInParameters();var G1=false;for(var i=0;i<j.length;i++){var H1=j[i];var I1=H1.getHelpPath();var J1=H1.getValue();var K1=H1.getUseConditions();var L1=H1.getInitialValueFilterEmpty();G1=U.call(this,I1)||G1;G1=T.call(this,I1,J1,K1,L1)||G1;}if(G1||(this._bApplyFilter&&this._bPendingFilterUpdate)){this._bPendingFilterUpdate=false;e1.call(this,true);}}
u.prototype.onFieldChange=function(){var G1=this.getOutParameters();A1.call(this);var H1=y.call(this,G1,false);S.resolve().then(function(){return A.call(this,H1);}.bind(this)).then(function(){if(this.bIsDestroyed){return;}var I1=this.getConditions();for(var i=0;i<I1.length;i++){var J1=I1[i];if(J1.outParameters){for(var K1 in J1.outParameters){for(var j=0;j<G1.length;j++){var L1=G1[j];var M1=L1.getValue();var N1=L1.getUseConditions();var O1=true;if(L1.getMode()===O.WhenEmpty){if(N1){O1=!M1||(Array.isArray(M1)&&M1.length===0);}else{O1=!M1;}}if(O1){if(N1){var P1;if(!L1.getHelpPath()){P1=C.createCondition("EQ",[L1.getFixedValue()],undefined,undefined,b.NotValidated);}else if(L1.getFieldPath()===K1){P1=C.createCondition("EQ",[J1.outParameters[K1]],undefined,undefined,b.Validated);}else{continue;}if(!M1){M1=[];}if(!Array.isArray(M1)){throw new Error("Value on OutParameter must be an array "+L1);}if(a.indexOfCondition(P1,M1)<0){P1.validated=b.Validated;M1.push(P1);L1.setValue(M1);}}else if(!L1.getHelpPath()){L1.setValue(L1.getFixedValue());}else if(L1.getFieldPath()===K1){L1.setValue(J1.outParameters[K1]);}}}}}}}.bind(this)).unwrap();};
function Z(i){return a1.call(this,i,this.getInParameters());}
function $(i){return a1.call(this,i,this.getOutParameters());}
function a1(j,G1){if(!j||G1.length===0){return null;}var H1={};for(var i=0;i<G1.length;i++){var I1=G1[i];var J1=I1.getHelpPath();var K1=I1.getFieldPath();if(J1&&K1){for(var L1 in j){if(J1===L1){H1[K1]=j[L1];break;}}}else if(!J1&&K1&&I1.getFixedValue){H1[K1]=I1.getFixedValue();}}return H1;}
function b1(i,j){return d1.call(this,i,this.getInParameters(),false,undefined,undefined,false,j);}
function c1(i,j,G1){return d1.call(this,i,this.getOutParameters(),j,undefined,undefined,false,G1);}
function d1(G1,H1,I1,J1,K1,L1,M1){var N1;var O1;var P1;var Q1;var i=0;var R1;if(H1.length>0){if(!G1){if(!I1){var S1=this.getBindingContext();for(i=0;i<H1.length;i++){O1=H1[i];P1=M1?"conditions/"+O1.getHelpPath():O1.getHelpPath();var T1=O1.getValue();var U1=O1.getUseConditions();var V1=O1.getInitialValueFilterEmpty();var j=0;if(J1||K1){var W1=O1.getBinding("value");var X1=false;if(W1||U1){Q1=O1.getFieldPath();for(j=0;j<J1.length;j++){if((W1&&W1.getPath()===J1[j].getPath())||(U1&&J1[j].getPath()==="/"+Q1)){T1=J1[j].getValue();X1=true;break;}}if(!X1&&!U1&&K1&&W1&&W1.isRelative()&&(!W1.getContext()||(W1.getContext()!==K1&&W1.getContext()===S1))){T1=K1.getProperty(W1.getPath());}}}if(P1){if(!N1){N1={};}if(L1){N1[P1]=[];if(U1){for(j=0;j<T1.length;j++){R1=m({},T1[j]);if(R1.inParameters){R1.inParameters=b1.call(this,R1.inParameters,true);}if(R1.outParameters){R1.outParameters=c1.call(this,R1.outParameters,false,true);}N1[P1].push(R1);}}else{if(!T1&&V1){R1=C.createCondition("Empty",[]);R1.isEmpty=false;}else if(T1){R1=C.createItemCondition(T1);R1.validated=b.Validated;}if(R1){N1[P1].push(R1);}}R1=undefined;}else{if(U1){if(T1&&T1.length>0){N1[P1]=T1[0].values[0];}}else{N1[P1]=T1;}}}}}}else{for(var Y1 in G1){for(i=0;i<H1.length;i++){O1=H1[i];P1=M1?"conditions/"+O1.getHelpPath():O1.getHelpPath();Q1=O1.getFieldPath();if(Q1&&(Q1===Y1||Q1==="conditions/"+Y1)&&P1){if(!N1){N1={};}if(L1){N1[P1]=[];R1=C.createItemCondition(G1[Y1]);R1.validated=b.Validated;N1[P1].push(R1);}else{N1[P1]=G1[Y1];}}}}}if(L1){var Z1=this._getTypesForConditions(N1);var $1=c.createFilters(N1,Z1);N1=$1;}}return N1;}
function e1(i){if(i){if(!this._iFilterTimer){this._iFilterTimer=setTimeout(function(){this._iFilterTimer=undefined;e1.call(this);}.bind(this),0);}return;}else if(this._iFilterTimer){clearTimeout(this._iFilterTimer);this._iFilterTimer=undefined;}if((!this.isOpen()&&!this._bNavigateRunning&&!this._bOpen)||(this._bClosing&&!this._bSwitchToDialog)||!this._bApplyFilter){this._bPendingFilterUpdate=true;return;}if(this._bFilterWaitingForBinding){return;}var j=this.getInParameters();var G1=y.call(this,j,false);var H1=A.call(this,G1);if(H1 instanceof Promise){H1.then(function(){this._bFilterWaitingForBinding=false;e1.call(this,true);}.bind(this));this._bFilterWaitingForBinding=true;return;}var I1=this.getAggregation("_dialog");var J1=(!I1||!I1.isOpen())&&!(this._bClosing&&this._bSwitchToDialog);var K1=F1.call(this,J1);if(K1){var L1=this._getFilterBar();var M1;if(L1){M1=L1.getInternalConditions();}else{M1=this._oConditions;}var N1=this._getTypesForConditions(M1);var O1=c.createFilters(M1,N1,undefined,this.getCaseSensitive());var P1=[];var Q1=M1["$search"];var R1;if(O1){P1.push(O1);}if(Q1&&Q1.length>0){R1=Q1[0].values[0];}K1.applyFilters(P1,R1,L1);}}
u.prototype._getTypesForConditions=function(j){var G1=this.getFilterBar();var H1=this.getInParameters();var I1;var J1;if(G1){I1=c.createConditionTypesMapFromFilterBar(j,G1);}else{I1={};for(J1 in j){I1[J1]={type:null};}}for(J1 in I1){if(!I1[J1].type){for(var i=0;i<H1.length;i++){var K1=H1[i];if(K1.getHelpPath()===J1){I1[J1].type=K1.getDataType();break;}}}}return I1;};
u.prototype.getMaxConditions=function(){if(this._oField&&this._oField.getMaxConditionsForHelp){return this._oField.getMaxConditionsForHelp();}else if(this._oField&&this._oField.getMaxConditions){return this._oField.getMaxConditions();}else{return 1;}};
u.prototype.getDisplay=function(){if(this._oField&&this._oField.getDisplay){return this._oField.getDisplay();}};
u.prototype.getRequired=function(){if(this._oField&&this._oField.getRequired){return this._oField.getRequired();}else{return false;}};
u.prototype.getDataType=function(){if(this._oField.getDataType){return this._oField.getDataType();}else{return"sap.ui.model.type.String";}};
u.prototype._getFormatOptions=function(){if(this._oField&&this._oField._getFormatOptions){return this._oField._getFormatOptions();}else{return{};}};
u.prototype._getKeyPath=function(){var i=this.getKeyPath();if(!i&&this._oField&&this._oField.getFieldPath&&this._oField.getFieldPath()){i=this._oField.getFieldPath();}return i;};
u.prototype._getFilterBar=function(){var i=this.getFilterBar();if(!i){i=this.getAggregation("_filterBar");}return i;};
u.prototype.clone=function(j,G1){var H1=[this.getContent(),this.getSuggestContent(),this.getDialogContent()];var I1=this.getFilterBar();var i=0;var J1;for(i=0;i<H1.length;i++){J1=H1[i];if(J1){J1.detachEvent("navigate",x,this);J1.detachEvent("selectionChange",G,this);J1.detachEvent("dataUpdate",H,this);}}if(I1){I1.detachEvent("search",t1,this);}var K1=F.prototype.clone.apply(this,arguments);for(i=0;i<H1.length;i++){J1=H1[i];if(J1){J1.attachEvent("navigate",x,this);J1.attachEvent("selectionChange",G,this);J1.attachEvent("dataUpdate",H,this);}}if(I1){I1.attachEvent("search",t1,this);}return K1;};
function f1(){var i;if((!k||!B||!V||!n||!o||!p||!q||!r||!I)&&!this._bDialogRequested){k=sap.ui.require("sap/m/Dialog");B=sap.ui.require("sap/m/Button");V=sap.ui.require("sap/ui/mdc/field/ValueHelpPanel");n=sap.ui.require("sap/ui/mdc/field/DefineConditionPanel");o=sap.ui.require("sap/ui/model/base/ManagedObjectModel");p=sap.ui.require("sap/ui/mdc/filterbar/vh/FilterBar");q=sap.ui.require("sap/ui/mdc/FilterField");r=sap.ui.require("sap/ui/mdc/filterbar/vh/CollectiveSearchSelect");I=sap.ui.require("sap/ui/core/Item");if(!k||!B||!V||!n||!o||!p||!q||!r||!I){sap.ui.require(["sap/m/Dialog","sap/m/Button","sap/ui/mdc/field/ValueHelpPanel","sap/ui/mdc/field/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/filterbar/vh/FilterBar","sap/ui/mdc/FilterField","sap/ui/mdc/filterbar/vh/CollectiveSearchSelect","sap/ui/core/Item"],i1.bind(this));this._bDialogRequested=true;}}if(k&&B&&V&&n&&o&&p&&q&&r&&I&&!this._bDialogRequested){if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}var j=new B(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$help>/_enableOK}",type:s.Emphasized,press:n1.bind(this)});var G1=new B(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:o1.bind(this)});this._oManagedObjectModel=new o(this);var H1=j1.call(this);i=new k(this.getId()+"-dialog",{contentHeight:g1(),contentWidth:h1(),horizontalScrolling:false,verticalScrolling:false,title:"{$help>/title}",stretch:D.system.phone,resizable:true,draggable:true,content:[H1],afterOpen:p1.bind(this),afterClose:q1.bind(this),buttons:[j,G1]}).setModel(this._oManagedObjectModel,"$help");i.isPopupAdaptationAllowed=function(){return false;};i.addStyleClass("sapMdcValueHelpTitle");this.setAggregation("_dialog",i,true);this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");r1.call(this,this.getShowConditionPanel());}return i;}
function g1(){if(D.system.desktop){return"700px";}if(D.system.tablet){return D.orientation.landscape?"600px":"600px";}}
function h1(){if(D.system.desktop){return"1080px";}if(D.system.tablet){return D.orientation.landscape?"920px":"600px";}}
function i1(i,j,G1,H1,I1,J1,K1,L1,M1){k=i;B=j;V=G1;n=H1;o=I1;p=J1;q=K1;r=L1;I=M1;this._bDialogRequested=false;if(!this._bIsBeingDestroyed){f1.call(this);if(this._bOpen){this.open();}}}
function j1(){var i=F1.call(this,false);var j=this._getFilterBar();var G1=new V(this.getId()+"-VHP",{height:"100%",showFilterbar:!!j,formatOptions:this._getFormatOptions(),inputOK:"{$help>/_enableOK}"});G1.setModel(this._oManagedObjectModel,"$help");if(i){i.initialize(false);k1.call(this,G1,i.getDialogContent());}if(j){G1.setFilterbar(j);}return G1;}
function k1(i,j){i.setTable(j);}
function l1(i,j,G1){var H1=this.getAggregation("_popover");var I1=this.getAggregation("_dialog");if(i==="remove"){j.detachEvent("navigate",x,this);j.detachEvent("selectionChange",G,this);j.detachEvent("dataUpdate",H,this);j=undefined;}else{j.attachEvent("navigate",x,this);j.attachEvent("selectionChange",G,this);j.attachEvent("dataUpdate",H,this);L.call(this);}this.fireDataUpdate();if(this._bNavigate){this.navigate(this._iStep);}else if(H1){H1.invalidate();var J1=this.getFilterValue();if(J1){P.call(this,J1);}Y.call(this);if(j&&this._bOpenIfContent){j.initialize(true);var K1=this._getField();if(K1){j.fieldHelpOpen(true);H1.openBy(this._getControlForSuggestion());}this._bOpenIfContent=false;}}else if(j&&this._bOpenIfContent){this._bOpenIfContent=false;this.open(true);}if(I1&&G1!=="suggestContent"&&!(G1==="content"&&this.getDialogContent())){if(j){j.initialize(false);var L1=I1.getContent()[0];L1.setShowTokenizer(this.getMaxConditions()!==1);k1.call(this,L1,j.getDialogContent());if(I1.isOpen()||this._bOpen){j.fieldHelpOpen(false);}}}}
function m1(){var i=this.getAggregation("_dialog");if(!i){i=f1.call(this);}return i;}
function n1(i){this.close();var j=this.getConditions();j=C._removeEmptyConditions(j);j=C._removeInitialFlags(j);a.updateConditionsValues(j);this.setProperty("conditions",j,true);this._bOK=true;}
function o1(i){this.close();this.setProperty("conditions",this._aOldConditions,true);}
function p1(i){this._bSwitchToDialog=false;}
function q1(i){var j=this.getConditions();this._bDialogOpen=false;this._aOldConditions=undefined;this._handleAfterClose(i);if(this._bOK){this.fireSelect({conditions:j,add:false,close:true});}this._bOK=undefined;this.setProperty("_enableOK",true,true);}
function r1(i){var j=this.getAggregation("_dialog");if(j&&this._oField){var G1=j.getContent()[0];if(i){if(!G1._oDefineConditionPanel){var H1=new n(this.getId()+"-DCP",{label:"{$help>/title}"});G1.setDefineConditions(H1);}}else{G1.setDefineConditions();}}}
function s1(i,j,G1){if(i==="remove"){j.detachEvent("search",t1,this);if(!G1){var H1=j.getBasicSearchField();if(H1&&H1._bCreadedByFVH){j.setBasicSearchField();}if(j.getCollectiveSearch&&j.getCollectiveSearch()){j.setCollectiveSearch();}}j=undefined;}else{j.attachEvent("search",t1,this);E1.call(this,false);}var I1=this.getAggregation("_dialog");if(I1){var J1=I1.getContent()[0];J1.setFilterbar(j);J1.setShowFilterbar(!!j);if(this.isOpen()){u1.call(this);if(!G1||i==="remove"){y1.call(this,i==="remove");}}}}
function t1(i){var j=this._getFilterBar();if(j){var G1=this.getFilterFields();if(G1&&!this._bUpdateFilterAfterClose){var H1=v1.call(this,G1);var I1=H1.length>0?H1[0].values[0]:"";if(I1!==this.getFilterValue()){this.setProperty("filterValue",I1,true);}}if(this._bApplyFilter||(!this._bApplyFilter&&(i||j.getLiveMode()))){this._bApplyFilter=true;e1.call(this,true);}}}
function u1(){var i=this._getFilterBar();if(i){i.setInternalConditions({});}P.call(this,this.getFilterValue());Y.call(this);}
function v1(i){var j=this._getFilterBar();var G1;if(j){G1=j.getInternalConditions();}else{G1=this._oConditions;}return G1[i]||[];}
function w1(i,j){var G1=this._getFilterBar();var H1;if(G1){H1=G1.getInternalConditions();}else{H1=this._oConditions;}if(!H1[i]){H1[i]=[];}H1[i].push(j);if(G1){G1.setInternalConditions(H1);}}
function x1(i){var j=this._getFilterBar();var G1;if(j){G1=j.getInternalConditions();}else{G1=this._oConditions;}if(G1[i]&&G1[i].length>0){G1[i]=[];}if(j){G1=j.setInternalConditions(G1);}}
function y1(i){if(i){if(!this._iSearchFieldTimer){this._iSearchFieldTimer=setTimeout(function(){this._iSearchFieldTimer=undefined;y1.call(this,false);}.bind(this),0);}return;}else if(this._iSearchFieldTimer){clearTimeout(this._iSearchFieldTimer);this._iSearchFieldTimer=null;}var j=this.getFilterFields();var G1=F1.call(this,false);if(j&&G1){var H1=this._getFilterBar();if(!H1){H1=new p(this.getId()+"-FB",{liveMode:!G1.isSuspended(),showGoButton:false});H1.setInternalConditions(this._oConditions);this._oConditions={};this.setAggregation("_filterBar",H1,true);}if(!H1.getBasicSearchField()){if(!this._oSearchField){this._oSearchField=new q(this.getId()+"-search",{conditions:"{$filters>/conditions/"+j+"}",placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"});this._oSearchField._bCreadedByFVH=true;}else{this._oSearchField.setConditions([]);}H1.setBasicSearchField(this._oSearchField);}}if(this._oSearchField&&!this._oSearchField.getParent()){this._oSearchField.destroy();delete this._oSearchField;}}
function z1(){var i=F1.call(this,true);if(i){return i.getSuggestionContent();}}
function A1(){var i=this._oField?this._oField.getBindingContext():null;this.setBindingContext(i);var j=this._getFormatOptions();if(j.conditionModel&&this.getModel(j.conditionModelName)!==j.conditionModel){this.setModel(j.conditionModel,j.conditionModelName);}}
function B1(){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM;}
u.prototype.getScrollDelegate=function(){var i=this.getAggregation("_dialog");if(i&&(i.isOpen()||i.oPopup.getOpenState()===t.OPENING)){var j=F1.call(this,false);var G1=j&&j.getDialogContent();if(G1&&G1.getScrollDelegate){return G1.getScrollDelegate();}else{return undefined;}}else{return F.prototype.getScrollDelegate.apply(this,arguments);}};
u.prototype._fireOpen=function(i){if(!this._bOpenHandled){return F.prototype._fireOpen.apply(this,arguments);}return true;};
u.prototype.getRoleDescription=function(i){if(!i||i===1){return null;}else if(!F1.call(this,false)&&this.getShowConditionPanel()&&!this.getNoDialog()){return null;}else{var j=B1.apply(this);return j.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");}};
u.prototype.getAriaHasPopup=function(){if(this.getNoDialog()){return"listbox";}else if(this.getShowConditionPanel()){return"dialog";}else{return"listbox";}};
u.prototype.getValueHelpEnabled=function(){if(this.getNoDialog()){return false;}else{return true;}};
u.prototype._getContenRequestProperties=function(i){var j={};var G1=this.getCollectiveSearchItems();if(G1.length>0){var H1=this.getAggregation("_dialog");if(H1&&H1.isOpen()&&this._oCollectiveSearchSelect){var I1=this._oCollectiveSearchSelect.getSelectedItemKey();j.collectiveSearchKey=I1;}else{j.collectiveSearchKey=G1[0].getKey();}}return j;};
function C1(){if(!this._oCollectiveSearchSelect){var i=new I(this.getId()+"-collSearchItem",{key:"{$help>key}",text:"{$help>text}",enabled:"{$help>enabled}",textDirection:"{$help>textDirection}"});this._oCollectiveSearchSelect=new r(this.getId()+"-collSearch",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$help>/collectiveSearchItems",template:i},select:D1.bind(this)}).setModel(this._oManagedObjectModel,"$help");}return this._oCollectiveSearchSelect;}
function D1(i){var j=function(){e1.call(this,true);}.bind(this);this.setProperty("filterValue","",true);var G1=this._callContentRequest(false,j);if(G1){j();}}
function E1(i){var j=this.getAggregation("_dialog");var G1=this._getFilterBar();if(j&&G1){var H1=this.getCollectiveSearchItems();if(H1.length<=1){if(G1.getCollectiveSearch&&G1.getCollectiveSearch()){G1.setCollectiveSearch();}}else{if(G1.getCollectiveSearch&&!G1.getCollectiveSearch()){G1.setCollectiveSearch(C1.call(this));}if(i&&this._oCollectiveSearchSelect){this._oCollectiveSearchSelect.setSelectedItemKey(H1[0].getKey());}}}}
function F1(i){var j;if(i){j=this.getSuggestContent();}else{j=this.getDialogContent();}if(!j){j=this.getContent();}return j;}
return u;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpContentWrapperBase',['sap/ui/core/Element'],function(E){"use strict";
var F=E.extend("sap.ui.mdc.field.FieldValueHelpContentWrapperBase",{metadata:{library:"sap.ui.mdc",properties:{selectedItems:{type:"object[]",defaultValue:[]}},defaultProperty:"selectedItems",events:{navigate:{parameters:{key:{type:"any"},description:{type:"string"},leave:{type:"boolean"},disableFocus:{type:"boolean"},itemId:{type:"string"}}},selectionChange:{parameters:{selectedItems:{type:"object[]"},itemPress:{type:"boolean"}}},dataUpdate:{parameters:{contentChange:{type:"boolean"}}}}}});
F.prototype.init=function(){};
F.prototype.exit=function(){this.dispose();};
F.prototype.initialize=function(s){return this;};
F.prototype.dispose=function(s){};
F.prototype.setSelectedItems=function(s){this.setProperty("selectedItems",s,true);return this;};
F.prototype.getDialogContent=function(){return undefined;};
F.prototype.getSuggestionContent=function(){return undefined;};
F.prototype.fieldHelpOpen=function(s){this._bSuggestion=s;return this;};
F.prototype.fieldHelpClose=function(){delete this._bSuggestion;return this;};
F.prototype.removeFocus=function(){return this;};
F.prototype.getFilterEnabled=function(){return true;};
F.prototype.navigate=function(s){};
F.prototype.getTextForKey=function(k,i,o,n,c){return"";};
F.prototype.getKeyForText=function(t,i,n,c){return undefined;};
F.prototype.getKeyAndText=function(k,t,i,o,c){return undefined;};
F.prototype.getListBinding=function(){return undefined;};
F.prototype.getAsyncKeyText=function(){return false;};
F.prototype.applyFilters=function(f,s){};
F.prototype.isSuspended=function(){return false;};
F.prototype.enableShowAllItems=function(){return false;};
F.prototype.getAllItemsShown=function(){return false;};
F.prototype._getFieldHelp=function(){var f=this.getParent();if(!f||!f.isA("sap.ui.mdc.field.FieldValueHelp")){throw new Error(this.getId()+" must be assigned to a sap.ui.mdc.field.FieldValueHelp");}return f;};
F.prototype._getKeyPath=function(){var f=this._getFieldHelp();return f._getKeyPath();};
F.prototype._getDescriptionPath=function(){var f=this._getFieldHelp();return f.getDescriptionPath();};
F.prototype._getInParameters=function(){var f=this._getFieldHelp();var h=[];if(f){h=_(f.getInParameters());}return h;};
F.prototype._getOutParameters=function(){var f=this._getFieldHelp();var h=[];if(f){h=_(f.getOutParameters());}return h;};
function _(p){var h=[];for(var i=0;i<p.length;i++){var P=p[i];var H=P.getHelpPath();if(H){h.push(H);}}return h;}
F.prototype._getMaxConditions=function(){var f=this._getFieldHelp();return f.getMaxConditions();};
F.prototype._getDelegate=function(){var f=this._getFieldHelp();return{delegate:f.getControlDelegate(),payload:f.getPayload()};};
F.prototype.getScrollDelegate=function(){var f=this._getFieldHelp();return f.getScrollDelegate&&f.getScrollDelegate();};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpDelegate',['sap/ui/mdc/field/FieldHelpBaseDelegate','sap/ui/model/FilterType'],function(F,a){"use strict";var b=Object.assign({},F);
b.determineSearchSupported=function(p,f){};
b.isSearchSupported=function(p,l){return false;};
b.executeSearch=function(p,l,s){};
b.adjustSearch=function(p,t,s){return s;};
b.executeFilter=function(p,l,f,c,r){if(l.isA("sap.ui.model.json.JSONListBinding")){l.filter(f,a.Application);c();}else{l.attachEventOnce("dataReceived",c);l.initialize();l.filter(f,a.Application);l.getContexts(0,r);}};
b.checkBindingsPending=function(p,B){return null;};
b.checkListBindingPending=function(p,l){if(l&&(l.isSuspended()||l.getLength()===0)){return false;}return true;};
return b;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpMTableWrapper',['sap/ui/mdc/field/FieldValueHelpTableWrapperBase','sap/ui/model/ChangeReason','sap/base/strings/capitalize','sap/m/library',"sap/ui/mdc/util/loadModules"],function(F,C,c,l,a){"use strict";var L=l.ListMode;var S=l.Sticky;var b;
var d=F.extend("sap.ui.mdc.field.FieldValueHelpMTableWrapper",{metadata:{library:"sap.ui.mdc",aggregations:{table:{type:"sap.m.Table",multiple:false}},defaultAggregation:"table"}});
d._init=function(){b=undefined;};
d.prototype.exit=function(){F.prototype.exit.apply(this,arguments);};
d.prototype.initialize=function(s){if(s||this._oScrollContainer){return this._bTableResolved?this:this._oTablePromise;}if(!b){a("sap/m/ScrollContainer").then(function(m){if(!this._bIsBeingDestroyed){b=m[0];this.initialize();this.fireDataUpdate({contentChange:true});}}.bind(this));return this;}this._oScrollContainer=new b(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){var e=[];var t=this._oWrapper&&this._oWrapper.getTable();if(t){e.push(t);}return e;};return this;};
d.prototype.dispose=function(){if(this._oScrollContainer){this._oScrollContainer.destroy();delete this._oScrollContainer;}};
d.prototype.getDialogContent=function(){return this._oScrollContainer;};
d.prototype.getSuggestionContent=function(){return this._getWrappedTable();};
d.prototype.fieldHelpOpen=function(s){F.prototype.fieldHelpOpen.apply(this,arguments);var t=this._getWrappedTable();if(t){if(s){var o=t.getSelectedItem();if(o){this._handleScrolling(o);}}}return this;};
d.prototype.getListBinding=function(){var t=this._getWrappedTable();return t&&t.getBinding("items");};
d.prototype._getListBindingInfo=function(){var t=this._getWrappedTable();return t&&t.getBindingInfo("items");};
d.prototype.isSuspended=function(){var o=this.getListBinding();if(!o){return true;}return o.isSuspended();};
d.prototype._handleEvents=function(A){var t=this._getWrappedTable();if(t){var e=(A?t.attachEvent:t.detachEvent).bind(t);e("itemPress",this._handleItemPress,this);e("selectionChange",this._handleSelectionChange,this);e("updateFinished",this._handleUpdateFinished,this);}};
d.prototype._adjustTable=function(s,n){F.prototype._adjustTable.apply(this,arguments);var t=this._getWrappedTable();if(t&&this.getParent()){t.setRememberSelections(false);if(s){if(this._getMaxConditions()===1){t.setMode(L.SingleSelectMaster);}else{t.setMode(L.MultiSelect);}}else if(this._getMaxConditions()===1){t.setMode(L.SingleSelectLeft);}else{t.setMode(L.MultiSelect);}var e=t.getSticky();if(!e||e.length===0){t.setSticky([S.ColumnHeaders]);}}};
var _=function(B){if(B){this._handleModelContextChange();return true;}};
d.prototype._handleTableChanged=function(m,t){if(m==="insert"){this._adjustTable(true);if(!_.call(this,this.getListBinding())){this._oObserver.observe(t,{bindings:["items"]});}}else{this._oObserver.unobserve(t);}F.prototype._handleTableChanged.call(this,m,t);};
d.prototype._observeChanges=function(o,n){if(o.name==="items"&&o.mutation==="ready"){_.call(this,o.bindingInfo.binding);}F.prototype._observeChanges.apply(this,arguments);};
d.prototype._handleItemPress=function(e){var i=e.getParameter("listItem");if(!this._bSuggestion||this._getMaxConditions()!==1){i.setSelected(!i.getSelected());}this._fireSelectionChange(true);};
d.prototype._handleSelectionChange=function(e,f){if(!this._bSuggestion||this._getMaxConditions()!==1||f){this._fireSelectionChange.call(this,false);}};
d.prototype._handleUpdateFinished=function(e){if(!this.getParent()){return;}this._updateSelectedItems();if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}this.fireDataUpdate({contentChange:false});};
d.prototype._getTableItems=function(s,n){var t=this._getWrappedTable();if(t){return s?t.getSelectedItems():t.getItems();}};
d.prototype._modifyTableSelection=function(i,I,s,e){if(I.getSelected()!==s){I.setSelected(s);}};
d.prototype._handleTableEvent=function(e){if(!this._bSuggestion){return;}var t=this._getWrappedTable();var i=jQuery(e.target).control(0);switch(e.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(t.indexOfItem(i)===0){this.fireNavigate({key:undefined,description:undefined,leave:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true);}}break;default:break;}};
d.prototype._handleScrolling=function(i){var s=this.getScrollDelegate();if(s){var t=this._getWrappedTable();var I=!isNaN(i)?i:t.indexOfItem(i);t.scrollToIndex(I).catch(function(e){});return true;}};
d.prototype.enableShowAllItems=function(){var t=this._getWrappedTable();var B=t&&t.getBindingInfo("items");return B&&!!B.length;};
d.prototype.getAllItemsShown=function(){var B=this.getListBinding();return B&&(!B.getLength()||B.bLengthFinal);};
return d;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpMdcTableWrapper',['sap/ui/mdc/field/FieldValueHelpTableWrapperBase',"sap/ui/mdc/util/loadModules","sap/base/util/deepEqual","sap/ui/mdc/library","sap/ui/mdc/enum/PersistenceMode","sap/ui/mdc/p13n/Engine",'sap/ui/mdc/condition/FilterConverter'],function(F,l,d,a,P,E,b){"use strict";var S=a.SelectionMode;var _={"Table":"sap/ui/mdc/field/FieldValueHelpUITableWrapper","ResponsiveTable":"sap/ui/mdc/field/FieldValueHelpMTableWrapper"};
var c=F.extend("sap.ui.mdc.field.FieldValueHelpMdcTableWrapper",{metadata:{library:"sap.ui.mdc",aggregations:{table:{type:"sap.ui.mdc.Table",multiple:false}},defaultAggregation:"table"}});
c.prototype.init=function(){F.prototype.init.apply(this,arguments);this.OInnerWrapperClass=null;};
c.prototype.setParent=function(p,A){if(p){E.getInstance().defaultProviderRegistry.attach(p,P.Transient);}F.prototype.setParent.apply(this,arguments);};
c.prototype._getStringType=function(){var t=this.getTable();var T,o=T=t&&t.getType();if(!o){T="Table";}else if(typeof o==="object"){if(o.isA("sap.ui.mdc.table.ResponsiveTableType")){T="ResponsiveTable";}else{T="Table";}}return T;};
c.prototype.fieldHelpOpen=function(s){var t=this.getTable();if(t){if(this.OInnerWrapperClass){return this.OInnerWrapperClass.prototype.fieldHelpOpen.call(this,s);}}return this;};
c.prototype._updateInnerWrapperClass=function(){var t=this._getStringType();var M=_[t];if(M&&this._sInnerWrapperType!==t){this._sInnerWrapperType=t;if(this.OInnerWrapperClass){this.OInnerWrapperClass.prototype.dispose.apply(this);this.OInnerWrapperClass=null;}this._oInnerWrapperClassPromise=l(M).then(function(f){this.OInnerWrapperClass=f[0];this.OInnerWrapperClass.prototype.initialize.apply(this);}.bind(this));}};
c.prototype._adjustTable=function(s){var t=this.getTable();if(t){var p=this.getParent();if(p){t.setHeight("100%");t.setSelectionMode(this._getMaxConditions()===1?S.Single:S.Multi);var f=this._getFieldHelp();var o=f._getFilterBar();var g=o&&t.getFilter()!==o.getId();if(g){t.setFilter(o);}}if(this.OInnerWrapperClass){this.OInnerWrapperClass.prototype._adjustTable.call(this,s);}}};
c.prototype.exit=function(){var p=this.getParent();if(p){E.getInstance().defaultProviderRegistry.detach(p);}this._oCurrentConditions=null;this._bSuggestion=null;if(this._oInnerWrapperClassPromise){this._oInnerWrapperClassPromise=null;}if(this.OInnerWrapperClass){this.OInnerWrapperClass.prototype.dispose.apply(this);this.OInnerWrapperClass=null;}this._sInnerWrapperType=null;this._bSearchTriggered=null;F.prototype.exit.apply(this,arguments);};
c.prototype.isSuspended=function(){var t=this.getTable();var L=this.getListBinding();return L?L.isSuspended():t&&!t.getAutoBindOnInit();};
c.prototype.getListBinding=function(){var t=this.getTable();return t&&t.getRowBinding();};
var m={onmouseover:function(o){var i=jQuery(o.target).control(0);if(i&&i.isA("sap.m.ColumnListItem")){i.setType("Active");}}};var e=function(t,A){if(A){t.addDelegate(m,true,this);return;}t.removeDelegate(m);};
c.prototype._handleTableChanged=function(M,t){var i;if(M==="insert"){this._updateInnerWrapperClass();e.call(this,t,true);i=this._getWrappedTable();if(i){this._handleInnerTableChanged("insert",i);}this._oObserver.observe(t,{aggregations:["_content"]});}else{e.call(this,t);i=t._oTable;if(i){this._handleInnerTableChanged(M,i);}this._oObserver.unobserve(t);}};
c.prototype._handleToolbarExtensions=function(i){if(i.mAggregations["extension"]&&i.mAggregations["extension"].length){i.getAggregation("extension").forEach(function(o){o.setVisible(false);});}if(i.mAggregations["headerToolbar"]){var t=i.getAggregation("headerToolbar");t.setVisible(false);}};
c.prototype._handleInnerTableChanged=function(M,i){if(M==="insert"){this._updateInnerWrapperClass();this._handleToolbarExtensions(i);this._oObserver.observe(i,{bindings:["rows"]});}this._oInnerWrapperClassPromise.then(function(){this.OInnerWrapperClass.prototype._handleTableChanged.call(this,M,i);this.getTable().initialized().then(function(){this.fireDataUpdate({contentChange:true});}.bind(this));}.bind(this));};
c.prototype.applyFilters=function(f,s,o){var t=this.getTable();if(t&&o){var L=this.getListBinding();var g=L&&L.isSuspended();var h=this._getFieldHelp();if(L&&!g&&!this._bSearchTriggered){var i=o.getSearch()||"";var B=L.mParameters.$search||"";var C=o.getConditions();var j=h._getTypesForConditions(C);var k=C&&j&&b.createFilters(C,j,undefined,h.getCaseSensitive());var n=k?[].concat(k):[];var p=L.aApplicationFilters.reduce(function(R,u){return R.concat(u._bMultiFilter?u.aFilters:u);},[]);var q=!d(n,p);var r=i!==B;var T=t._oTable&&t._oTable.getShowOverlay&&t._oTable.getShowOverlay();if(q||r||T){this._handleScrolling();o.triggerSearch();this._bSearchTriggered=true;}}if(g){L.resume();}if(!L&&t.getAutoBindOnInit()){this._oTablePromise.then(function(){if(!this._bIsBeingDestroyed){this.applyFilters(f,s,o);}}.bind(this));}}};
c.prototype._observeChanges=function(C,n){if(C.name==="_content"){this._handleInnerTableChanged(C.mutation,C.child);}if(this.OInnerWrapperClass){this.OInnerWrapperClass.prototype._observeChanges.call(this,C,true);}else{F.prototype._observeChanges.call(this,C,true);}};
c.prototype._handleUpdateFinished=function(o){this._bSearchTriggered=false;return this.OInnerWrapperClass.prototype._handleUpdateFinished.apply(this,arguments);};
c.prototype._handleEvents=function(o){if(this.OInnerWrapperClass){return this.OInnerWrapperClass.prototype._handleEvents.apply(this,arguments);}};
c.prototype._handleItemPress=function(o){return this.OInnerWrapperClass.prototype._handleItemPress.apply(this,arguments);};
c.prototype._handleSelectionChange=function(o){var i=this._isTableReady();return this._bIsModifyingTableSelection||!i||this._bBusy?undefined:this._fireSelectionChange.call(this,false);};
c.prototype._getTableItems=function(s,n){return this.OInnerWrapperClass.prototype._getTableItems.apply(this,arguments);};
c.prototype._modifyTableSelection=function(i,I,s,f){return this.OInnerWrapperClass.prototype._modifyTableSelection.apply(this,arguments);};
c.prototype._getDataFromItem=function(i,I,o){return this.OInnerWrapperClass.prototype._getDataFromItem.apply(this,arguments);};
c.prototype._handleTableEvent=function(o){return this.OInnerWrapperClass.prototype._handleTableEvent.apply(this,arguments);};
c.prototype._isTableReady=function(){var t=this._getWrappedTable();if(t&&t._bInvalid){return false;}return F.prototype._isTableReady.apply(this,arguments);};
c.prototype._getWrappedTable=function(){var t=this.getTable();return t&&t._oTable;};
c.prototype._handleScrolling=function(){return this.OInnerWrapperClass.prototype._handleScrolling.apply(this,arguments);};
c.prototype.getDialogContent=function(){if(this.OInnerWrapperClass){return this.OInnerWrapperClass.prototype.getDialogContent.apply(this,arguments);}};
c.prototype.initialize=function(){if(this.OInnerWrapperClass){return this.OInnerWrapperClass.prototype.initialize.apply(this,arguments);}};
c.prototype.getSuggestionContent=function(){return this.getTable();};
return c;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpTableWrapperBase',['sap/ui/mdc/field/FieldValueHelpContentWrapperBase','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/FilterType','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/base/ManagedObjectObserver','sap/base/strings/capitalize','sap/m/library','sap/base/util/deepEqual','sap/base/Log','sap/ui/base/SyncPromise'],function(F,C,a,b,P,c,d,e,M,f,l,g,L,S){"use strict";
var h=F.extend("sap.ui.mdc.field.FieldValueHelpTableWrapperBase",{metadata:{library:"sap.ui.mdc",aggregations:{table:{type:"sap.ui.core.Control",multiple:false}},defaultAggregation:"table"}});
h.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["selectedItems"],aggregations:["table"]});this._bTableResolved=false;this._oTablePromise=new Promise(function(r){this._oTablePromiseResolve=r;}.bind(this));this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oPromises={};this._oTableDelegate={onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};};
h.prototype.exit=function(){this._sTableWidth=null;this._oObserver.disconnect();this._oObserver=undefined;if(this._oTableModificationPromise){this._oTableModificationPromise=null;}delete this._oTablePromise;delete this._oTablePromiseResolve;delete this._bTableResolved;F.prototype.exit.apply(this,arguments);};
h.prototype.invalidate=function(O){if(O){var t=this._getWrappedTable();if(t&&O===t){if(O.bOutput&&!this._bIsBeingDestroyed){var i=this.getParent();if(i){i.invalidate(this);}}return;}}F.prototype.invalidate.apply(this,arguments);};
h.prototype.getDialogContent=function(){return this._getWrappedTable();};
h.prototype.getSuggestionContent=function(){return this._getWrappedTable();};
h.prototype.fieldHelpOpen=function(s){F.prototype.fieldHelpOpen.apply(this,arguments);var t=this._getWrappedTable();if(t){this._adjustTable(s);this._updateSelectedItems();}return this;};
h.prototype.fieldHelpClose=function(){F.prototype.fieldHelpClose.apply(this,arguments);var t=this._getWrappedTable();if(t){t.removeStyleClass("sapMListFocus");}return this;};
h.prototype.removeFocus=function(){F.prototype.removeFocus.apply(this,arguments);var t=this._getWrappedTable();if(t){t.removeStyleClass("sapMListFocus");}return this;};
h.prototype.navigate=function(s,i){var t=this._getWrappedTable();if(!this._isTableReady(t)){if(t&&!this._bTableResolved&&!this._bNavigationDelayed){this._bNavigationDelayed=true;this._oTablePromise.then(function(){this.fireNavigate({disableFocus:true});this._bNavigationDelayed=false;}.bind(this));}this._bNavigate=true;this._iStep=s;return;}var j=this.getSelectedItems();var k=j&&j[0];var T=k&&this._getTableItemByKey(k.key);if(this._getMaxConditions()!==1){this._bShouldRebind=false;this.fireNavigate();t.focus();return;}t.addStyleClass("sapMListFocus");var I=this._getTableItems();var q=I.length;var r=0;var u=false;if(T){r=I.indexOf(T);r=r+s;}else if(s>=0){r=s-1;}else{r=q+s;}var v;if(r<0){r=0;v=true;u=true;}else if(r>=q-1){r=q-1;v=false;}else{v=s>=0;}while(I[r]&&I[r].isA("sap.m.GroupHeaderListItem")){if(v){r++;}else{r--;}}var w=I[r];if(w){var V=this._getDataFromItem(w);var x=w===T;if(!x){this._modifyTableSelection(I,w,true,undefined,true);}S.resolve(this._handleScrolling(w)).then(function(y){var R=w.getId&&w.getId();if(x){if(!this.getParent().isOpen()){this.fireNavigate({key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters,itemId:R,leave:u});}else if(u){this.fireNavigate({key:undefined,value:undefined,condition:undefined,itemId:undefined,leave:u});}return;}this._bNoTableUpdate=true;this.setSelectedItems([{key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters}]);this._bNoTableUpdate=false;if(!R&&w.isA("sap.ui.model.Context")){var z=this._getTableItems(false,true).find(function(A){return A.getBindingContext()===w;});R=z&&z.getId();}if(R){this.fireNavigate({key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters,itemId:R,leave:u});}else{this.fireNavigate({disableFocus:true});}}.bind(this));}};
h.prototype.getTextForKey=function(k,i,O,N,j){return _.call(this,[k],["key"],i,O,N,j);};
h.prototype.getKeyForText=function(t,i,N,j){return _.call(this,[t],["description"],i,undefined,N,j);};
h.prototype.getKeyAndText=function(k,t,i,O,j){return _.call(this,[k,t],["key","description"],i,O,false,j);};
function _(v,i,I,O,N,j){if((v[0]===null||v[0]===undefined||(i[0]==="description"&&v[0]===""))&&(v.length===1||!v[1])){return null;}return p.call(this).then(function(r){var E=i.length>1||i[0]==="description"?P:b;var G=[i[0]==="description"?this._getDescriptionPath:this._getKeyPath];if(i.length>1){G.push(i[1]==="description"?this._getDescriptionPath:this._getKeyPath);}if(r&&this._getKeyPath()){var k=this._getTableItems();var R=m.call(this,v,k,G,I,O,E,j);if(R){return R;}}if(N){throw new E(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v[0]]));}else{return this.loadData(G,v,I,O,E,j);}}.bind(this)).unwrap();}
function m(v,I,G,j,O,E,k){var i=0;var q=[];for(i=0;i<G.length;i++){q.push(G[i].call(this));if(!q[i]){throw new Error("path for filter missing");}}var r=function(w,x){var B=w.isA("sap.ui.model.Context")?w:w.getBindingContext();return B.getProperty(x);};var s;var t=[];for(i=0;i<v.length;i++){t.push(new a({path:q[i],operator:d.EQ,value1:v[i],caseSensitive:k}));}if(t.length===1){s=t[0];}else{s=new a({filters:t,and:false});}if(j||O){t=[s];if(j){t.push(j);}if(O){t.push(O);}s=new a({filters:t,and:true});}var u=e.apply(I,s,r);if(u.length===1){var V=this._getDataFromItem(u[0]);return{key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters};}else if(u.length>1){if(!k){return m.call(this,v,I,G,j,O,E,true);}throw n.call(this,E,true,v[0]);}}
h.prototype.loadData=function(G,v,I,O,E,k){var s="";var i=0;for(i=0;i<G.length;i++){s=s+G[i].call(this);}if(this._oPromises[s]&&this._oPromises[s][v[0]]){return this._oPromises[s][v[0]];}if(!this._oPromises[s]){this._oPromises[s]={};}this._oPromises[s][v[0]]=new Promise(function(r,R){this._oTablePromise.then(function(t){var q=s;s="";for(i=0;i<G.length;i++){s=s+G[i].call(this);}if(!s){R(new Error("missing FieldPath"));return;}if(s!==q){if(!this._oPromises[s]){this._oPromises[s]={};}this._oPromises[s][v[0]]=this._oPromises[q][v[0]];delete this._oPromises[q][v[0]];}var u=this.getListBinding();var w=u.getModel();var x=u.getPath();var y;var B=u.getContext();var z=[];for(i=0;i<G.length;i++){z.push(new a({path:G[i].call(this),operator:d.EQ,value1:v[i],caseSensitive:k}));}if(z.length===1){y=z[0];}else{y=new a({filters:z,and:false});}z=[];if(I){z.push(I);}if(O){if(I){var A=O.aFilters?O.aFilters:[O];var D=I.aFilters?I.aFilters:[I];for(i=0;i<A.length;i++){var H=A[i];var J=false;for(var j=0;j<D.length;j++){var K=D[j];if(K.sPath===H.sPath&&K.oValue1===H.oValue1&&K.oValue2===H.oValue2){J=true;break;}}if(!J){z.push(H);}}}else{z.push(O);}}if(z.length>0){z.push(y);y=new a({filters:z,and:true});}try{var N=w.bindList(x,B);var Q=function(){var V=N.getContexts();if(V.length===1){var W=this._getDataFromContext(V[0]);var X={key:W.key,description:W.description,inParameters:W.inParameters,outParameters:W.outParameters};r(X);}else if(v[0]===""&&V.length===0){r(null);}else{var Y=n.call(this,E,V.length>1,v[0]);R(Y);}setTimeout(function(){N.destroy();},0);delete this._oPromises[s][v[0]];};var T=this._getDelegate();if(T.delegate){T.delegate.executeFilter(T.payload,N,y,Q.bind(this),2);}}catch(U){R(U);}}.bind(this));}.bind(this));return this._oPromises[s][v[0]];};
function n(E,N,v){var s;if(N){s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[v]);}else{s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);}var i=new E(s);i._bNotUnique=N;return i;}
h.prototype.getAsyncKeyText=function(){return true;};
h.prototype.applyFilters=function(i,s,j){var k=this.getListBinding();var D=this._getDelegate();if(!k){this._oTablePromise.then(function(t){if(!this._bIsBeingDestroyed){this.applyFilters(i,s,j);}}.bind(this));return;}var u=true;var q;try{q=k.getFilterInfo();}catch(r){L.info("ValueHelp-Filter: getFilterInfo threw error");}if(!i){i=[];}if(i.length===0&&!q){u=false;}if(D.delegate&&D.delegate.isSearchSupported(D.payload,k)){if(!k.isSuspended()&&u){k.suspend();}s=D.delegate.adjustSearch(D.payload,this._bSuggestion,s);D.delegate.executeSearch(D.payload,k,s);L.info("ValueHelp-Search: "+s);}if(u){k.filter(i,c.Application);L.info("ValueHelp-Filter: "+o.call(this,i));}if(k.isSuspended()){k.resume();}};
h.prototype.isSuspended=function(){var i=this.getListBinding();if(!i){return true;}return i.isSuspended();};
function o(i){var r;if(!i){return"";}if(Array.isArray(i)){r="";i.forEach(function(i,I,j){r+=o.call(this,i);if(j.length-1!=I){r+=" or ";}},this);return"("+r+")";}else if(i._bMultiFilter){r="";var A=i.bAnd;i.aFilters.forEach(function(i,I,j){r+=o.call(this,i);if(j.length-1!=I){r+=A?" and ":" or ";}},this);return"("+r+")";}else{r=i.sPath+" "+i.sOperator+" '"+i.oValue1+"'";if(i.sOperator==="BT"){r+="...'"+i.oValue2+"'";}return r;}}
h.prototype.clone=function(i,j){this._handleEvents();var k=F.prototype.clone.apply(this,arguments);this._handleEvents(true);return k;};
h.prototype._observeChanges=function(i){if(i.name==="table"){this._handleTableChanged.call(this,i.mutation,i.child);}if(i.name==="selectedItems"){this._updateSelectedItems.call(this);}};
h.prototype._handleTableChanged=function(s,t){if(s==="remove"){this._handleEvents();t.removeDelegate(this._oTableDelegate);t.removeStyleClass("sapMComboBoxList");t=undefined;this._oTablePromise=new Promise(function(r){this._oTablePromiseResolve=function(){r();this._bTableResolved=true;};}.bind(this));}else{this._handleEvents(true);t.addDelegate(this._oTableDelegate,true,this);this._updateSelectedItems();if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}t.addStyleClass("sapMComboBoxList");}this.fireDataUpdate({contentChange:true});};
h.prototype._handleModelContextChange=function(E){var t=this._getWrappedTable();if(this.getListBinding()){this._oTablePromiseResolve(t);}};
h.prototype._adjustTable=function(s){var t=this.getTable();if(t&&this.getParent()){if(s){if(this._sTableWidth){t.setWidth(this._sTableWidth);}}else if(t.getWidth()!=="100%"){this._sTableWidth=t.getWidth();t.setWidth("100%");}}};
h.prototype._fireSelectionChange=function(I){var q=[];var t=this._getWrappedTable();if(t){var s=this.getSelectedItems();var T;var v;if(s.length>0){var r=this._getTableItems();for(var k in r){T=r[k];v=this._getDataFromItem(T);if(!v){throw new Error("Key of item cannot be determined"+this);}for(var j=s.length-1;j>=0;j--){var u=s[j];if(u.key===v.key&&(!v.inParameters||!u.inParameters||g(u.inParameters,v.inParameters))&&(!v.outParameters||!u.outParameters||g(u.outParameters,v.outParameters))){s.splice(j,1);break;}}if(!s.length){break;}}}if(s.length>0){q=s;}s=this._getTableItems(true);for(var i=0;i<s.length;i++){T=s[i];v=this._getDataFromItem(T);if(!v){throw new Error("Key of item cannot be determined"+this);}q.push({key:v.key,description:v.description,inParameters:v.inParameters,outParameters:v.outParameters});}}this._bNoTableUpdate=true;this.setSelectedItems(q);this._bNoTableUpdate=false;this.fireSelectionChange({selectedItems:q,itemPress:I});};
h.prototype._handleUpdateFinished=function(E){if(!this.getParent()){return;}this._updateSelectedItems.call(this);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}if(E.getParameter("reason")!==f(C.Filter)){this.fireDataUpdate({contentChange:false});}};
h.prototype._handleBusyStateChanged=function(E){this._bBusy=E.getParameter("busy");};
h.prototype._updateSelectedItems=function(){if(this._bNoTableUpdate){return;}var t=[];var T=this._getWrappedTable();if(this._isTableReady(T)&&this._getKeyPath()){var s=this.getSelectedItems();var k=this._getTableItems();var u=false;this._bIsModifyingTableSelection=true;for(var j=0;j<k.length;j++){var q=k[j];if(q){var r=false;if(s.length>0){var v=this._getDataFromItem(q);for(var i=0;i<s.length;i++){var w=s[i];if(v.key===w.key&&(!v.inParameters||!w.inParameters||g(w.inParameters,v.inParameters))&&(!v.outParameters||!w.outParameters||g(w.outParameters,v.outParameters))){r=true;if(v.description!==w.description){w.description=v.description;u=true;}break;}}}t.push(this._modifyTableSelection(k,q,r,j));}}if(u){this._bNoTableUpdate=true;this.setSelectedItems(s);this._bNoTableUpdate=false;}this._oTableModificationPromise=Promise.all(t).then(function(){this._bIsModifyingTableSelection=false;}.bind(this));}};
h.prototype._getDataFromItem=function(i,I,O){var B=i.isA("sap.ui.model.Context")?i:i.getBindingContext();return B&&this._getDataFromContext.call(this,B,I,O);};
h.prototype._getDataFromContext=function(B,I,O){var k=this._getKeyPath();var D=this._getDescriptionPath();var K;var s;if(!k){throw new Error("KeyPath missing");}if(!I){I=this._getInParameters();}if(!O){O=this._getOutParameters();}var j=I.length>0?{}:null;var q=O.length>0?{}:null;var r;if(B){K=k?B.getProperty(k):undefined;s=D?B.getProperty(D):undefined;var i=0;for(i=0;i<I.length;i++){r=I[i];j[r]=B.getProperty(r);}for(i=0;i<O.length;i++){r=O[i];q[r]=B.getProperty(r);}}if(K===null||K===undefined){return false;}return{key:K,description:s,inParameters:j,outParameters:q};};
h.prototype._isTableReady=function(){var t=this._getWrappedTable();var i=t&&this.getListBinding();if(!t||!i){return false;}if(i&&(i.isSuspended()||i.getLength()===0)){return false;}return true;};
function p(){return S.resolve().then(function(){var i=this.getListBinding();var j=this._getListBindingInfo();var D=this._getDelegate();if(i&&D.delegate){return D.delegate.checkListBindingPending(D.payload,i,j);}else{return false;}}.bind(this)).catch(function(E){throw E;});}
h.prototype._handleItemPress=function(E){};
h.prototype._handleSelectionChange=function(E,i){};
h.prototype._getTableItems=function(s,N){return[];};
h.prototype._getTableItemByKey=function(k,N){var i=this._getTableItems(undefined,N);return i&&i.find(function(I){var D=this._getDataFromItem(I);return D.key===k;}.bind(this));};
h.prototype._handleTableEvent=function(E){};
h.prototype._modifyTableSelection=function(i,I,s,j,k){};
h.prototype._getWrappedTable=function(){return this.getTable();};
h.prototype._handleEvents=function(A){};
h.prototype._handleScrolling=function(i){};
h.prototype.getListBinding=function(){};
h.prototype._getListBindingInfo=function(){};
return h;});
sap.ui.predefine('sap/ui/mdc/field/FieldValueHelpUITableWrapper',['sap/ui/mdc/field/FieldValueHelpTableWrapperBase','sap/ui/model/ChangeReason','sap/base/strings/capitalize',"sap/ui/table/library"],function(F,C,c,l){"use strict";var V=l.VisibleRowCountMode;var S=l.SelectionMode;var a=l.SelectionBehavior;
var b=F.extend("sap.ui.mdc.field.FieldValueHelpUITableWrapper",{metadata:{library:"sap.ui.mdc",aggregations:{table:{type:"sap.ui.table.Table",multiple:false}},defaultAggregation:"table"}});
b.prototype.fieldHelpOpen=function(s){F.prototype.fieldHelpOpen.apply(this,arguments);var t=this._getWrappedTable();if(t&&s){var e=this._getTableItems(true);var o=e&&e[0];this._handleScrolling(o);}return this;};
b.prototype.getListBinding=function(){var t=this._getWrappedTable();return t&&t.getBinding("rows");};
b.prototype.isSuspended=function(){var L=this.getListBinding();if(!L){return true;}return L.isSuspended();};
var _=function(t){t=t||this._getWrappedTable();var s=t.getPlugins().find(function(p){return p.isA("sap.ui.table.plugins.SelectionPlugin");});return s||t;};var d=function(B){if(B){this._handleModelContextChange();return true;}};
b.prototype._handleTableChanged=function(m,t){if(m==="insert"){this._adjustTable(true);var h=d.call(this,this.getListBinding());this._oObserver.observe(t,{aggregations:["plugins"],bindings:[!h&&"rows"]});var s=_.call(this,t);if(s&&s!==t){s.attachEvent("selectionChange",this._handleSelectionChange,this);}}else{this._oObserver.unobserve(t);}F.prototype._handleTableChanged.call(this,m,t);};
b.prototype._observeChanges=function(o,n){if(o.name==="rows"&&o.mutation==="ready"){d.call(this,o.bindingInfo.binding);}if(!n&&o.name==="plugins"&&o.child.isA("sap.ui.table.plugins.SelectionPlugin")){var p=(o.mutation==="insert"?o.child.attachEvent:o.child.detachEvent).bind(o.child);p("selectionChange",this._handleSelectionChange,this);}F.prototype._observeChanges.apply(this,arguments);};
b.prototype._handleEvents=function(A){var t=this._getWrappedTable();if(t){var e=(A?t.attachEvent:t.detachEvent).bind(t);e("cellClick",this._handleItemPress,this);e("rowSelectionChange",this._handleSelectionChange,this);e("rowsUpdated",this._handleUpdateFinished,this);e("busyStateChanged",this._handleBusyStateChanged,this);var r=this.getListBinding();if(r){var E=(A?r.attachEvent:r.detachEvent).bind(r);E("change",this._handleUpdateFinished,this);}}};
b.prototype._adjustTable=function(s){F.prototype._adjustTable.apply(this,arguments);var t=this._getWrappedTable();var p=this.getParent();if(t){var r=t.getRowMode();if(!r){t.setVisibleRowCountMode(s?V.Fixed:V.Auto);t.setMinAutoRowCount(3);}else if(r.isA("sap.ui.table.rowmodes.AutoRowMode")){r.setMinRowCount(3);}if(p){var o=_.call(this);var e=function(m,B){t.setSelectionBehavior(B);o.setSelectionMode(m);};var f=this._getMaxConditions()===1;var g=f?S.Single:S.MultiToggle;var h=f?a.RowOnly:a.Row;e(g,h);}}};
b.prototype._handleSelectionChange=function(e){var u=e.getParameter("userInteraction");if(u||(this._bSuggestion&&this._getMaxConditions()!==1)){this._fireSelectionChange.call(this,false);}};
b.prototype._handleUpdateFinished=function(e){if(!this.getParent()){return;}this._updateSelectedItems();if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);}if(!e||e.getParameter("reason")!==c(C.Filter)){this.fireDataUpdate({contentChange:false});}};
b.prototype._getTableItems=function(s,n){var t=this._getWrappedTable();if(!t){return[];}var r;var o,e,f;if(s){o=_.call(this,t);e=o.getSelectedIndices();f=e.reduce(function(r,i){var g=t.getContextByIndex(i);return g?r.concat(g):r;},[]);}if(!n){var B=t.getBinding();r=s?f:B&&(B.aContexts||(B.aIndices&&B.aIndices.map(function(i){return t.getContextByIndex(i);}))||B.getContexts());}else{r=t.getRows().filter(function(R){var g=R.getBindingContext();return g&&g.getObject();});if(s){r=r.filter(function(R){return f.indexOf(R.getBindingContext())>=0;});}}return r;};
b.prototype._modifyTableSelection=function(i,I,s,e,f){e=typeof e!=='undefined'?e:i.indexOf(I);if(e>=0){var o=_.call(this);var g=o.getSelectedIndices().indexOf(e)>=0;if(s&&!g){return this._getMaxConditions()===1?o.setSelectedIndex(e):o.addSelectionInterval(e,e);}else if(!s&&g){return o.removeSelectionInterval(e,e);}}};
b.prototype._handleTableEvent=function(e){if(!this._bSuggestion){return;}var i=jQuery(e.target).control(0);switch(e.type){case"sapprevious":if(i.isA("sap.ui.table.Row")){if(this._getTableItems(false,true).indexOf(i)===0){this.fireNavigate({key:undefined,description:undefined,leave:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true);}}break;case"sapnext":if(i.isA("sap.ui.table.Column")&&this._getMaxConditions()===1){i=this._getTableItems(false,true)[0];if(i){var v=this._getDataFromItem(i);if(v){this.fireNavigate({key:v.key,description:v.description,inParameters:v.inParameters,outParameters:v.outParameters,itemId:i.getId()});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true);}}}break;default:break;}};
b.prototype._handleScrolling=function(i){var t=this._getWrappedTable();var I=!isNaN(i)&&i;var f=t.getFirstVisibleRow();if(!I&&i){var o=i.isA("sap.ui.table.Row")&&i.getBindingContext();if(!o&&i.isA("sap.ui.model.Context")){o=i;}I=this._getTableItems().indexOf(o);}if(typeof I==="undefined"||I<0){I=f-1;}if(I>=0&&I!=f){t.setFirstVisibleRow(I);return Promise.resolve();}};
b.prototype._handleItemPress=function(e){};
return b;});
sap.ui.predefine('sap/ui/mdc/field/InParameter',['sap/ui/core/Element'],function(E){"use strict";
var I=E.extend("sap.ui.mdc.field.InParameter",{metadata:{library:"sap.ui.mdc",properties:{value:{type:"any",byValue:true,defaultValue:null},helpPath:{type:"string"},initialValueFilterEmpty:{type:"boolean",defaultValue:false}},defaultProperty:"value"}});
I.prototype.init=function(){this.attachEvent("modelContextChange",_,this);};
I.prototype.exit=function(){};
I.prototype.bindProperty=function(n,b){if(n==="value"&&!b.formatter){b.targetType="raw";}E.prototype.bindProperty.apply(this,arguments);};
I.prototype.getFieldPath=function(){var b=this.getBinding("value");var p;if(b){p=b.getPath();}else{var B=this.getBindingInfo("value");if(B){if(B.path){p=B.path;}else if(B.parts&&B.parts.length===1){p=B.parts[0].path;}}}if(p&&p.startsWith("/")){p=p.slice(1);}if(!p){p=this.getHelpPath();}return p;};
function _(e){var b=this.getBinding("value");this._bBound=false;this._bConditionModel=false;if(b){this._bBound=true;var m=b.getModel();if(m&&m.isA("sap.ui.mdc.condition.ConditionModel")){this._bConditionModel=true;}}}
I.prototype.getUseConditions=function(){var u=false;if(this._bConditionModel){u=true;}else if(!this._bBound){var b=this.getBindingInfo("value");if(b){var p;if(b.path){p=b.path;}else if(b.parts&&b.parts.length===1){p=b.parts[0].path;}if(p.startsWith("/conditions/")){u=true;}}else{var v=this.getValue();if(Array.isArray(v)&&(v.length===0||v[0].hasOwnProperty("operator"))){u=true;}}}return u;};
I.prototype.getDataType=function(){var t;if(!this.getUseConditions()){var b=this.getBinding("value");if(b){t=b.getType();}}return t;};
return I;});
sap.ui.predefine('sap/ui/mdc/field/ListFieldHelp',['sap/ui/mdc/field/FieldHelpBase','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/library'],function(F,C,a,b,P,M,c,l){"use strict";var L;var D;var m;var d;var S;
var e=F.extend("sap.ui.mdc.field.ListFieldHelp",{metadata:{library:"sap.ui.mdc",properties:{filterList:{type:"boolean",group:"Appearance",defaultValue:true},useFirstMatch:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"}},defaultAggregation:"items"}});
e._init=function(){F._init.apply(this,arguments);L=undefined;D=undefined;m=undefined;d=undefined;};
e.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oManagedObjectModel=new M(this);this._oObserver=new c(h.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions"],aggregations:["items"],bindings:["items"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
e.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;if(this._iDataUpdateTimer){clearTimeout(this._iDataUpdateTimer);this._iDataUpdateTimer=null;}};
e.prototype._createPopover=function(){var i=F.prototype._createPopover.apply(this,arguments);if((!L||!D||!m)&&!this._bListRequested){L=sap.ui.require("sap/m/List");D=sap.ui.require("sap/m/DisplayListItem");m=sap.ui.require("sap/m/library");d=sap.ui.require("sap/ui/model/Filter");S=sap.ui.require("sap/ui/model/Sorter");if(!L||!D||!m){sap.ui.require(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter"],g.bind(this));this._bListRequested=true;}}if(i){_.call(this);}return i;};
function _(){if(!this._oList&&L&&D&&m&&!this._bListRequested){var B=this.getBindingInfo("items");this._oList=new L(this.getId()+"-List",{width:"100%",showNoData:false,mode:m.ListMode.SingleSelectMaster,rememberSelections:false,itemPress:k.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");this._oList.setModel(this._oManagedObjectModel,"$field");this._oList.bindElement({path:"/",model:"$field"});f.call(this,B);this._setContent(this._oList);if(this._bNavigate){this._bNavigate=false;this.navigate(this._iStep);this._iStep=null;}}}
function f(B){if(this._oList){this._oList.unbindAggregation("items");var i=new D(this.getId()+"-item",{type:m.ListType.Active,label:"{$field>text}",value:"{$field>additionalText}",valueTextDirection:"{$field>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");var v=new d("text",p.bind(this));var U=false;if(B&&B.template&&B.template.isA("sap.ui.mdc.field.ListFieldHelpItem")){U=true;}else{var I=this.getItems();if(I.length>0&&I[0].isA("sap.ui.mdc.field.ListFieldHelpItem")){U=true;}}var w=U&&new S("groupKey",false,r.bind(this));this._oList.bindAggregation("items",{path:"$field>items",template:i,filters:v,sorter:w,templateShareable:false});s.call(this);}}
function g(i,v,w,x,y){L=i;D=v;m=w;d=x;S=y;this._bListRequested=false;if(!this._bIsBeingDestroyed){_.call(this);}}
e.prototype.open=function(i){F.prototype.open.apply(this,arguments);var v=this._getPopover();var w=this._getControlForSuggestion();if(v&&w){var W=(w.$().outerWidth()/parseFloat(m.BaseFontSize))+"rem";v.setContentMinWidth(W);}};
e.prototype._handleAfterClose=function(E){if(this._bUpdateFilterAfterClose){this._bUpdateFilterAfterClose=false;o.call(this);}this._oList.removeStyleClass("sapMListFocus");F.prototype._handleAfterClose.apply(this,arguments);};
function h(i){if(i.object===this){if(i.name==="items"){if(i.type==="binding"){if(i.mutation==="prepare"){f.call(this,i.bindingInfo);}}else{if(i.mutation==="insert"){this._oObserver.observe(i.child,{properties:true});}else{this._oObserver.unobserve(i.child);}j.call(this);}}if(i.name==="conditions"){if(!this._bConditionUpdate){s.call(this);}}if(i.name==="filterValue"){if(this._oList){if(this._bClosing){this._bUpdateFilterAfterClose=true;}else{o.call(this);}}}}else{j.call(this);}}
function j(){if(!this._iDataUpdateTimer){this._iDataUpdateTimer=setTimeout(function(){this._iDataUpdateTimer=null;this.fireDataUpdate();}.bind(this),0);}}
e.prototype.openByTyping=function(){return true;};
e.prototype.openByClick=function(){return!this.getFilterList();};
e.prototype.getValueHelpEnabled=function(){return false;};
e.prototype.removeFocus=function(){if(this._oList){this._oList.removeStyleClass("sapMListFocus");}};
e.prototype.navigate=function(v){var w=this._getPopover();if(!w||!this._oList){this._bNavigate=true;this._iStep=v;return;}this._oList.addStyleClass("sapMListFocus");var x=this._oList.getSelectedItem();var I=this._oList.getItems();var y=I.length;var z=0;var A=this.getFilterList();var B=this.getFilterValue();var E=false;if(!A&&!x){var i=0;if(v>=0){for(i=0;i<I.length;i++){if(I[i].getLabel&&q.call(this,I[i].getLabel(),B)){z=i;break;}}}else{for(i=I.length-1;i>=0;i--){if(I[i].getLabel&&q.call(this,I[i].getLabel(),B)){z=i;break;}}}}else if(x){z=this._oList.indexOfItem(x);z=z+v;}else if(v>=0){z=v-1;}else{z=y+v;}var G;if(z<0){z=0;G=true;E=true;}else if(z>=y-1){z=y-1;G=false;}else{G=v>=0;}while(I[z]&&I[z].isA("sap.m.GroupHeaderListItem")){if(G){z++;}else{z--;}}var H=I[z];if(H){if(H!==x){var O=n.call(this,H);var K=t.call(this,O);H.setSelected(true);var J=u.call(this,K,H.getLabel());if(!w.isOpen()){this.open();}this._oList.scrollToIndex(z);this.fireNavigate({key:K,value:H.getLabel(),condition:J,itemId:H.getId(),leaveFocus:false});}else if(E){this.fireNavigate({key:undefined,value:undefined,condition:undefined,itemId:undefined,leaveFocus:E});}}};
e.prototype._getTextOrKey=function(v,K,B,I,O,N,w,x,y,z){if(v===null||v===undefined){return null;}else if(!v&&!K){return null;}var A=this.getItems();var E;var i=0;for(i=0;i<A.length;i++){E=A[i];if(z){if(t.call(this,E)===y||E.getText()===v){return{key:t.call(this,E),description:E.getText()};}}else if(K){if(t.call(this,E)===v){return E.getText();}}else if(E.getText()===v){return t.call(this,E);}}if(K&&v===""){return null;}if((!K||z)&&this.getUseFirstMatch()){for(i=0;i<A.length;i++){E=A[i];var T=E.getText();if(q.call(this,T,v)){return{key:t.call(this,E),description:T};}}}var G=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);if(K&&!z){throw new b(G);}else{throw new P(G);}};
function k(E){var i=E.getParameter("listItem");var v=i.getSelected();if(v){var O=n.call(this,i);var K=t.call(this,O);u.call(this,K,i.getLabel());this.close();this.fireSelect({conditions:this.getConditions(),add:true,close:true});}}
function n(i){var v=i.getBindingContextPath();return this._oManagedObjectModel.getProperty(v);}
function o(){var B=this._oList.getBinding("items");B.update();this._oList.updateItems();this._oList.invalidate();s.call(this);}
function p(T){var i=this.getFilterList();return!i||q.call(this,T,this.getFilterValue());}
function q(T,i){return!i||(typeof i==="string"&&T.toLowerCase().startsWith(i.toLowerCase()));}
function r(i){var K=i.getProperty('groupKey');var T=i.getProperty('groupText');return{key:K,text:T};}
function s(){if(this._oList){var v=this.getConditions();var w;var x=this.getFilterValue();var U=this.getUseFirstMatch();var y=false;var O=this._getOperator();if(v.length>0&&(v[0].validated===a.Validated||v[0].operator===O.name)){w=v[0].values[0];}var I=this._oList.getItems();for(var i=0;i<I.length;i++){var z=I[i];if(z.isA("sap.m.DisplayListItem")){var A=n.call(this,z);if(v.length>0&&t.call(this,A)===w){z.setSelected(true);}else if(v.length===0&&U&&x&&!y&&q.call(this,z.getLabel(),x)){z.setSelected(true);y=true;}else{z.setSelected(false);}}}}}
function t(i){var B=i.getBinding("key");if(B){return B.getInternalValue();}else{return i.getKey();}}
function u(K,v){this._bConditionUpdate=true;var i=this._createCondition(K,v);this.setProperty("conditions",[i],true);this._bConditionUpdate=false;return i;}
return e;});
sap.ui.predefine('sap/ui/mdc/field/MultiValueFieldDelegate',['sap/ui/mdc/field/FieldBaseDelegate'],function(F){"use strict";var M=Object.assign({},F);
M.updateItems=function(p,c,m){};
return M;});
sap.ui.predefine('sap/ui/mdc/field/MultiValueFieldItem',['sap/ui/core/Element'],function(E){"use strict";
var M=E.extend("sap.ui.mdc.field.MultiValueFieldItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"any",byValue:true},description:{type:"string"}},defaultProperty:"key"}});
M.prototype.bindProperty=function(n,b){if(n==="key"&&!b.formatter){b.targetType="raw";}E.prototype.bindProperty.apply(this,arguments);};
return M;});
sap.ui.predefine('sap/ui/mdc/field/OutParameter',['sap/ui/mdc/field/InParameter','sap/ui/mdc/enum/OutParameterMode'],function(I,O){"use strict";
var a=I.extend("sap.ui.mdc.field.OutParameter",{metadata:{library:"sap.ui.mdc",properties:{fixedValue:{type:"any",defaultValue:null},mode:{type:"sap.ui.mdc.enum.OutParameterMode",defaultValue:O.Always}},defaultProperty:"value"}});
return a;});
sap.ui.predefine('sap/ui/mdc/field/content/BooleanContent',["sap/ui/mdc/field/content/DefaultContent"],function(D){"use strict";var B=Object.assign({},D,{getDisplayMultiValue:function(){return[null];},getDisplayMultiLine:function(){return[null];},getEditMultiValue:function(){return[null];},getEditMultiLine:function(){return[null];},getUseDefaultFieldHelp:function(){return{name:"bool",oneOperatorSingle:true,oneOperatorMulti:true,single:true,multi:true};},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiValue not defined!");},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createEditMultiLine not defined!");},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiValue not defined!");},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.BooleanContent - createDisplayMultiLine not defined!");}});return B;});
sap.ui.predefine('sap/ui/mdc/field/content/DateContent',["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/enum/BaseType","sap/ui/mdc/util/DateUtil","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Operator","sap/ui/core/library"],function(D,B,a,F,O,c){"use strict";var C=c.CalendarType;var S;var b;var d;var e=Object.assign({},D,{getEditMultiLine:function(){return[null];},getEdit:function(){return["sap/m/DynamicDateRange","sap/ui/mdc/condition/OperatorDynamicDateOption","sap/ui/mdc/field/DynamicDateRangeConditionsType","sap/m/StandardDynamicDateRangeKeys","sap/m/DynamicDateUtil","sap/m/DynamicDateFormat"];},getEditOperator:function(){return{"EQ":{name:"sap/m/DatePicker",create:this._createDatePickerControl},"BT":{name:"sap/m/DateRangeSelection",create:this._createDateRangePickerControl}};},getEditForHelp:function(){return D.getEdit.apply(this,arguments);},getUseDefaultFieldHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:true,single:false,multi:true};},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateContent - createEditMultiLine not defined!");},_createDatePickerControl:function(o,f,i){var g=f[0];var h=o.getConditionsType();o.setHideOperator(true);this._adjustDataTypeForDate(o);var j=new g(i,{value:{path:"$field>/conditions",type:h},displayFormat:o.getDisplayFormat(),valueFormat:o.getValueFormat(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:o.getHandleContentChange()});if(j.setDisplayFormatType){j.setDisplayFormatType(o.getCalendarType());}j._setPreferUserInteraction(true);o.setAriaLabelledBy(j);o.setBoundProperty("value");return[j];},_createDateRangePickerControl:function(o,f,i){var g=f[0];var h=o.getConditionsType();this._adjustDataTypeForDate(o);var j=new g(i,{value:{path:"$field>/conditions",type:h},displayFormat:o.getDisplayFormat(),valueFormat:o.getValueFormat(),delimiter:"...",displayFormatType:o.getCalendarType(),placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",change:o.getHandleContentChange()});j._setPreferUserInteraction(true);o.setAriaLabelledBy(j);o.setBoundProperty("value");return[j];},_adjustDataTypeForDate:function(o){var t=o.retrieveDataType();var f=t.getFormatOptions();this._getDatePattern(o,f);if(!f||f.style||!f.pattern||f.pattern!==o.getValueFormat()||!f.calendarType||f.calendarType!==C.Gregorian){o.setDateOriginalType(o.getDataType());o.setDataType(a.createInternalType(t,o.getValueFormat()));o.updateConditionType();}},_getDatePattern:function(o,f){var s=o.getField().getBaseType();switch(s){case B.Date:o.setValueFormat("yyyy-MM-dd");break;case B.DateTime:o.setValueFormat("yyyy-MM-dd'T'HH:mm:ss");break;case B.Time:o.setValueFormat("HH:mm:ss");break;default:return;}o.setDisplayFormat("medium");if(f){if(f.style){o.setDisplayFormat(f.style);}else if(f.pattern){o.setDisplayFormat(f.pattern);}if(f.calendarType){o.setCalendarType(f.calendarType);}}},createEdit:function(o,f,i){var g=f[0];var h=f[1];var j=f[2];if(!S||!b||!d){S=f[3];b=f[4];d=f[5];}var k=o.getConditionsType(false,j);var v;if(o.getField().getMetadata().hasProperty("operators")){var G=function(m){return this._getDateRangeOptions(m,o,h);}.bind(this);v={path:"$field>/operators",formatter:G};}else{v=this._getDateRangeOptions(undefined,o,h);}var l=new g(i,{value:{path:"$field>/conditions",type:k},formatter:this._getDateRangeFormatter(o),placeholder:"{$field>/placeholder}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:o.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",tooltip:"{$field>/tooltip}",options:v,change:o.getHandleContentChange()});o.setBoundProperty("value");o.setAriaLabelledBy(g);return[l];},createEditForHelp:function(o,f,i){return D.createEdit.apply(this,arguments);},_getDateRangeOptions:function(o,f,g){if(!o||o.length===0){o=f.getField()._getOperators();}var h=[];for(var i=0;i<o.length;i++){var s=o[i];var j=this._getDateRangeOption(s,f,g);if(j){h.push(j);}}return h;},_getDateRangeOption:function(o,f,g){var h=F.getOperator(o);var s=h.name;if(!S[s]){s=h.alias||s;}if(S[s]){return s;}else if(h){if(!b.getOption(s)){var t=f.retrieveDataType();var v=[];for(var j=0;j<h.valueTypes.length;j++){if(h.valueTypes[j]&&h.valueTypes[j]!==O.ValueType.Static){v.push("custom");}}b.addOption(new g({key:s,operator:h,type:t,valueTypes:v}));}return s;}},_getDateRangeFormatter:function(o){var t=o.retrieveDataType();var f=t.getFormatOptions();var g={};if(f.style){g.date={style:f.style};}else if(f.pattern){g.date={pattern:f.pattern};}return d.getInstance(g);}});return e;});
sap.ui.predefine('sap/ui/mdc/field/content/DateTimeContent',["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent"],function(D,a){"use strict";var b=Object.assign({},a,{getEditOperator:function(){return{"EQ":{name:"sap/m/DateTimePicker",create:this._createDatePickerControl}};},getEdit:function(){return D.getEdit.apply(this,arguments);},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.DateTimeContent - createEditMultiLine not defined!");},createEdit:function(c,C,i){return D.createEdit.apply(this,arguments);}});return b;});
sap.ui.predefine('sap/ui/mdc/field/content/DefaultContent',["sap/m/library","sap/ui/mdc/enum/ContentMode"],function(l,C){"use strict";var E=l.EmptyIndicatorMode;var D={getDisplay:function(){return["sap/m/Text"];},getDisplayMultiValue:function(){return this.getDisplayMultiLine();},getDisplayMultiLine:function(){return["sap/m/ExpandableText"];},getEdit:function(){return["sap/ui/mdc/field/FieldInput"];},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/m/Token"];},getEditMultiLine:function(){return["sap/m/TextArea"];},getEditOperator:function(){return[null];},getEditForHelp:function(){return this.getEdit();},getUseDefaultEnterHandler:function(){return true;},getUseDefaultFieldHelp:function(){return{name:"defineConditions",oneOperatorSingle:false,oneOperatorMulti:false,single:true,multi:true};},getControlNames:function(c,o){var a;switch(c){case C.Display:a=this.getDisplay();break;case C.DisplayMultiValue:a=this.getDisplayMultiValue();break;case C.DisplayMultiLine:a=this.getDisplayMultiLine();break;case C.EditMultiValue:a=this.getEditMultiValue();break;case C.EditMultiLine:a=this.getEditMultiLine();break;case C.EditOperator:if(this.getEditOperator()){a=this.getEditOperator()[o]?this.getEditOperator()[o].name:[null];}else{a=[null];}break;case C.EditForHelp:a=this.getEditForHelp();break;default:a=this.getEdit();}if(a){return Array.isArray(a)?a:[a];}throw new Error("No control defined for content mode "+c);},create:function(c,s,o,a,i){switch(s){case C.Display:return this.createDisplay(c,a,i);case C.DisplayMultiValue:return this.createDisplayMultiValue(c,a,i);case C.DisplayMultiLine:return this.createDisplayMultiLine(c,a,i);case C.EditMultiValue:return this.createEditMultiValue(c,a,i);case C.EditMultiLine:return this.createEditMultiLine(c,a,i);case C.EditOperator:if(this.getEditOperator()){return this.getEditOperator()[o]?this.getEditOperator()[o].create.call(this,c,a,i):[null];}return[null];case C.EditForHelp:return this.createEditForHelp(c,a,i);default:return this.createEdit(c,a,i);}},createEdit:function(c,a,i){var I=a[0];var o=c.getConditionsType();var b=new I(i,{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",valueHelpIconSrc:c.getFieldHelpIcon(),showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",autocomplete:false,change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange(),valueHelpRequest:c.getHandleValueHelpRequest()});b._setPreferUserInteraction(true);c.setBoundProperty("value");c.setAriaLabelledBy(b);return[b];},createEditMultiValue:function(c,a,i){var I=a[0];var T=a[1];var o=c.getConditionType();var t=new T(i+"-token",{text:{path:'$field>',type:o}});var m=new I(i,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",valueHelpIconSrc:c.getFieldHelpIcon(),ariaAttributes:"{$field>/_ariaAttributes}",width:"100%",tooltip:"{$field>/tooltip}",tokens:{path:"$field>/conditions",template:t},dependents:[t],autocomplete:false,showSuggestion:false,change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange(),tokenUpdate:c.getHandleTokenUpdate(),valueHelpRequest:c.getHandleValueHelpRequest()});m._setPreferUserInteraction(true);c.setAriaLabelledBy(m);return[m];},createEditMultiLine:function(c,a,i){var T=a[0];var o=c.getConditionsType();var t=new T(i,{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",width:"100%",rows:4,tooltip:"{$field>/tooltip}",change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange()});t._setPreferUserInteraction(true);c.setBoundProperty("value");c.setAriaLabelledBy(t);return[t];},createDisplay:function(c,a,i){var T=a[0];var o=c.getConditionsType();var t=new T(i,{text:{path:"$field>/conditions",type:o},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",wrapping:"{$field>/multipleLines}",width:"100%",tooltip:"{$field>/tooltip}",emptyIndicatorMode:E.Auto});c.setBoundProperty("text");return[t];},createDisplayMultiLine:function(c,a,i){var b=a[0];var o=c.getConditionsType();var e=new b(i,{text:{path:"$field>/conditions",type:o},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",emptyIndicatorMode:E.Auto});c.setBoundProperty("text");return[e];},createDisplayMultiValue:function(c,a,i){return this.createDisplayMultiLine(c,a,i);},createEditForHelp:function(c,a,i){return this.createEdit(c,a,i);}};return D;});
sap.ui.predefine('sap/ui/mdc/field/content/LinkContent',["sap/ui/mdc/field/content/DefaultContent"],function(D){"use strict";var L=Object.assign({},D,{getDisplay:function(){return["sap/m/Link"];},getDisplayMultiValue:function(){return[null];},getDisplayMultiLine:function(){return["sap/m/Link"];},getUseDefaultFieldHelp:function(){return false;},createDisplay:function(c,C,i){var a=C[0];var o=c.getConditionsType();var l=new a(i,{text:{path:"$field>/conditions",type:o},textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",tooltip:"{$field>/tooltip}",press:c.getHandleContentPress(),wrapping:true});var f=c.getField().getFieldInfo();if(f){f.getDirectLinkHrefAndTarget().then(function(b){c.getMetadata()._oClass._updateLink(l,b);});}c.setAriaLabelledBy(l);c.setBoundProperty("text");return[l];},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.LinkContent - createDisplayMultiValue not defined!");},createDisplayMultiLine:function(c,C,i){return L.createDisplay(c,C,i);}});return L;});
sap.ui.predefine('sap/ui/mdc/field/content/SearchContent',["sap/ui/mdc/field/content/DefaultContent","sap/ui/model/BindingMode"],function(D,B){"use strict";var S=Object.assign({},D,{getDisplayMultiValue:function(){return[null];},getDisplayMultiLine:function(){return[null];},getEdit:function(){return["sap/m/SearchField"];},getEditMultiValue:function(){return[null];},getEditMultiLine:function(){return[null];},getEditForHelp:function(){return[null];},getUseDefaultEnterHandler:function(){return false;},getUseDefaultFieldHelp:function(){return false;},createEdit:function(c,C,i){var a=C[0];var o=c.getConditionsType();c.setHideOperator(true);c.updateConditionType();var b=new a(i,{value:{path:"$field>/conditions",type:o,mode:B.OneWay},placeholder:"{$field>/placeholder}",width:"100%",tooltip:"{$field>/tooltip}",search:c.getHandleEnter(),change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange()});c.setAriaLabelledBy(b);c.setBoundProperty("value");return[b];},createEditMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiValue not defined!");},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditMultiLine not defined!");},createDisplayMultiValue:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiValue not defined!");},createDisplayMultiLine:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createDisplayMultiLine not defined!");},createEditForHelp:function(){throw new Error("sap.ui.mdc.field.content.SearchContent - createEditForHelp not defined!");}});return S;});
sap.ui.predefine('sap/ui/mdc/field/content/TimeContent',["sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/DateContent"],function(D,a){"use strict";var T=Object.assign({},a,{getEditOperator:function(){return{"EQ":{name:"sap/m/TimePicker",create:this._createDatePickerControl}};},getEdit:function(){return D.getEdit.apply(this,arguments);},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.TimeContent - createEditMultiLine not defined!");},createEdit:function(c,C,i){return D.createEdit.apply(this,arguments);}});return T;});
sap.ui.predefine('sap/ui/mdc/field/content/UnitContent',["sap/ui/mdc/field/content/DefaultContent","sap/ui/model/Filter","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/mdc/enum/EditMode"],function(D,F,i,m,O,E){"use strict";var U=Object.assign({},D,{getEdit:function(){return["sap/ui/mdc/field/FieldInput","sap/ui/core/InvisibleText"];},getEditMultiValue:function(){return["sap/ui/mdc/field/FieldMultiInput","sap/ui/mdc/field/FieldInput","sap/m/Token","sap/ui/core/InvisibleText"];},getEditMultiLine:function(){return[null];},getUseDefaultFieldHelp:function(){return false;},createEdit:function(c,C,I){c.setIsMeasure(true);var a=C[0];var b=C[1];var o=c.getConditionsType();this._adjustDataTypeForUnit(c);var s=b.getStaticId("sap.ui.mdc","field.NUMBER");var d=[];var e=new a(I,{value:{path:"$field>/conditions",type:o},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",valueHelpIconSrc:"sap-icon://slim-arrow-down",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:[c.getField().getId()],ariaDescribedBy:[s],change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange()});e._setPreferUserInteraction(true);c.setAriaLabelledBy(e);d.push(e);d=this._addUnitControl(c,d,I,a,b);c.setBoundProperty("value");return d;},createEditMultiValue:function(c,C,I){c.setIsMeasure(true);var M=C[0];var T=C[2];var a=C[1];var b=C[3];var o=c.getConditionType();this._adjustDataTypeForUnit(c);var d=[];var t=new T(I+"-token",{text:{path:'$field>',type:o}});var f=new F({path:"values",test:function(v){if(!Array.isArray(v[0])||v[0][0]){return true;}else{return false;}}});var s=b.getStaticId("sap.ui.mdc","field.NUMBER");var e=new M(I,{placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditable},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueStateText:"{$field>/valueStateText}",showValueHelp:false,width:"70%",tooltip:"{$field>/tooltip}",fieldGroupIds:[c.getField().getId()],ariaDescribedBy:[s],tokens:{path:"$field>/conditions",template:t,filters:[f]},dependents:[t],change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange(),tokenUpdate:c.getHandleTokenUpdate()});e._setPreferUserInteraction(true);c.setAriaLabelledBy(e);d.push(e);d=this._addUnitControl(c,d,I,a,b);c.setBoundProperty("value");return d;},createEditMultiLine:function(){throw new Error("sap.ui.mdc.field.content.UnitContent - createEditMultiLine not defined!");},_addUnitControl:function(c,C,I,a,b){var u=c.getUnitConditionsType();if(c.getField().getEditMode()===E.EditableDisplay){C[0].bindProperty("description",{path:"$field>/conditions",type:u});C[0].setWidth("100%");C[0].setFieldWidth("70%");}else{var s;var t=c.getUnitOriginalType();var n=t&&t.getMetadata().getName();if(n&&n.indexOf("Currency")>=0){s=b.getStaticId("sap.ui.mdc","field.CURRENCY");}else{s=b.getStaticId("sap.ui.mdc","field.UNIT");}var o=new a(I+"-unit",{value:{path:"$field>/conditions",type:u},placeholder:"{$field>/placeholder}",textAlign:"{$field>/textAlign}",textDirection:"{$field>/textDirection}",required:"{$field>/required}",editable:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEditableUnit},enabled:{path:"$field>/editMode",formatter:c.getMetadata()._oClass._getEnabled},valueState:"{$field>/valueState}",valueHelpIconSrc:c.getFieldHelpIcon(),valueStateText:"{$field>/valueStateText}",showValueHelp:"{$field>/_fieldHelpEnabled}",ariaAttributes:"{$field>/_ariaAttributes}",width:"30%",tooltip:"{$field>/tooltip}",autocomplete:false,fieldGroupIds:[c.getField().getId()],ariaDescribedBy:[s],change:c.getHandleContentChange(),liveChange:c.getHandleContentLiveChange(),valueHelpRequest:c.getHandleValueHelpRequest()});o._setPreferUserInteraction(true);c.setAriaLabelledBy(o);C.push(o);}return C;},_adjustDataTypeForUnit:function(c){var f=c.getField();var t=c.retrieveDataType();var n=t.getMetadata().getName();var o=t.getFormatOptions();var C=i(t.getConstraints())?undefined:t.getConstraints();var s=!o||!o.hasOwnProperty("showMeasure")||o.showMeasure;var S=!o||!o.hasOwnProperty("showNumber")||o.showNumber;if(s&&S){o=m({},o);o.showMeasure=false;o.showNumber=true;o.strictParsing=true;var T=O.get(n);c.setUnitOriginalType(c.getDataType());c.setDataType(new T(o,C));f.getControlDelegate().initializeInternalUnitType(f.getPayload(),c.getDataType(),c.getFieldTypeInitialization());o=m({},o);o.showMeasure=true;o.showNumber=false;o.strictParsing=true;T=O.get(n);c.setUnitType(new T(o,C));f.getControlDelegate().initializeInternalUnitType(f.getPayload(),c.getUnitType(),c.getFieldTypeInitialization());c.updateConditionType();}}});return U;});
sap.ui.predefine('sap/ui/mdc/filterbar/FilterBarBase',['sap/ui/mdc/p13n/subcontroller/FilterController','sap/ui/core/library','sap/ui/Device','sap/ui/mdc/Control','sap/base/Log','sap/base/util/merge','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/condition/ConditionModel','sap/ui/mdc/condition/Condition','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/condition/ConditionConverter',"sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/m/library","sap/m/Button",'sap/m/MessageBox',"sap/ui/core/ShortcutHintsMixin"],function(F,c,D,C,L,m,M,a,b,d,I,e,f,P,g,l,B,h,S){"use strict";var V=c.ValueState;
var j=C.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},propertyInfo:{type:"object",defaultValue:[]},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{conditions:{type:"object"}},filtersChanged:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}});
var k=l.ButtonType;j.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";j.CONDITION_MODEL_NAME="$filters";var E={NoError:-1,RequiredHasNoValue:0,FieldInErrorState:1,AsyncValidation:2};
j.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new a(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this._bPersistValues=false;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(r){this._fResolveInitialFiltersApplied=r;}.bind(this));this._bIgnoreChanges=false;this._bSearchTriggered=false;this._bIgnoreQueuing=false;};
j.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._bPersistValues=false;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true);};
j.prototype._isPhone=function(){return(D.system.phone)?true:false;};
j.prototype._isLiveMode=function(){if(this._isPhone()){return false;}return this.getLiveMode();};
j.prototype._getConditionModel=function(){return this._oConditionModel;};
j.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:k.Emphasized});S.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this);}return this._btnSearch;};
j.prototype.getConditionModelName=function(){return this._getConditionModelName();};
j.prototype._getConditionModelName=function(){return j.CONDITION_MODEL_NAME;};
j.prototype._createConditionModel=function(){this._oConditionModel=new b();this.setModel(this._oConditionModel,this._getConditionModelName());};
j.prototype.applySettings=function(s,o){this._applySettings(s,o);this._initControlDelegate();};
j.prototype._applySettings=function(s,o){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this);};
j.prototype._initControlDelegate=function(){this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions();}}.bind(this));};
j.prototype._waitForMetadata=function(){return this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};
j.prototype.setIgnoreQueuing=function(v){this._bIgnoreQueuing=v;};
j.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing;};
j.prototype.setSuspendSelection=function(v){this.setProperty("suspendSelection",v);if(!v){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch();}this._bSearchTriggered=false;this.setIgnoreQueuing(false);}return this;};
j.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,j.INNER_MODEL_NAME);return this;};
j.prototype.getCurrentState=function(){var i={};var s={};if(this._bPersistValues){var n=m({},this.getFilterConditions());for(var K in n){if(this._getPropertyByName(K)){i[K]=n[K];}}s.filter=i;}var o=this.getFilterItems();var p=[];o.forEach(function(q,r){p.push({name:q.getFieldPath()});});s.items=p;return s;};
j.prototype.getAssignedFilterNames=function(){var n,i=null,o=this._getConditionModel();if(o){i=[];var p=o.getConditions("$search");if(p&&p.length>0){i.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}this._getNonHiddenPropertyInfoSet().forEach(function(q){n=I.getPropertyKey(q);var p=o.getConditions(n);if(p&&p.length>0){i.push(q.label||n);}});}return i;};
j.prototype._getAssignedFiltersText=function(){var t={};t.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());t.filtersTextExpanded=this._getAssignedFiltersExpandedText();return t;};
j.prototype._getAssignedFiltersExpandedText=function(){var n=0,i=0,o=this._getConditionModel();if(o){var A=o.getAllConditions();for(var s in A){var p=this._getPropertyByName(s);if(p&&!p.hiddenFilter&&(A[s].length>0)){++n;if(!(((s==="$search")&&this.getAggregation("basicSearchField"))||this._getFilterField(s))){++i;}}}}if(!n&&!i){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");}if(!i){if(n===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[n]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[n]);}if((n===1)){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[n,i]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[n,i]);};
j.prototype._getAssignedFiltersCollapsedText=function(n){var A;n=n||[];if(n.length){A=Object.keys(n).map(function(i){return n[i];}).join(", ");if(n.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[n.length,A]);}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[n.length,A]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};
j.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText();};
j.prototype._reportModelChange=function(t,i){this._handleAssignedFilterNames(false,i);if(this.getLiveMode()||t){this.triggerSearch();}};
j.prototype._isPersistenceSupported=function(o){return this.getEngine().isModificationSupported(this);};
j.prototype._hasPropertyInfo=function(s){var p=this.getPropertyInfo();var n=p.findIndex(function(o){return o.name===s;});return(n>=0);};
j.prototype._getPropertyByName=function(n){return f.getPropertyByKey(this.getPropertyInfoSet(),n);};
j.prototype.getPropertyInfoSet=function(){var t,p=[];if(this._hasPropertyHelper()){return this.getPropertyHelper().getProperties();}var n=this.getPropertyInfo();if(n&&(n.length>0)){t=this.getTypeUtil();for(var i=0;i<n.length;i++){var o=n[i];if(o){var T=t.getTypeConfig(o.dataType,o.formatOptions,o.constraints);p.push({name:o.name,typeConfig:T,maxConditions:o.maxConditions,constraints:o.constraints,formatOptions:o.formatOptions,required:o.required,caseSensitive:o.caseSensitive,display:o.display});}}}return p;};
j.prototype._hasPropertyHelper=function(){try{this.getPropertyHelper();return true;}catch(i){return false;}};
j.prototype._createPropertyInfoChange=function(p){return{changeSpecificData:{changeType:"addPropertyInfo",content:{name:p.name,dataType:p.typeConfig.className,maxConditions:p.maxConditions,constraints:p.constraints,formatOption:p.formatOptions,required:p.required,caseSensitive:p.caseSensitive,display:p.display}},selectorElement:this};};
j.prototype.createPropertyInfoChanges=function(s){var p,o,i=[];if(!this._hasPropertyInfo(s)){p=this._getPropertyByName(s);if(p){o=this._createPropertyInfoChange(p);i.push(o);}}return i;};
j.prototype._addConditionChange=function(o,s){var i=this.getEngine().createChanges({control:this,key:"Filter",state:o});if(!this._aCollectedChangePromises){this._aCollectedChangePromises=[];}this._aCollectedChangePromises.push(i);};
j.prototype._handleConditionModelPropertyChange=function(o){var A=function(s,i){var O={};O[s]=this._stringifyConditions(s,m([],i));this._cleanupConditions(O[s]);this._addConditionChange(O,s);}.bind(this);if(!this._bIgnoreChanges){var p=o.getParameter("path");if(p.indexOf("/conditions/")===0){var s=p.substring("/conditions/".length);if(this._bPersistValues&&this._isPersistenceSupported()){var i=o.getParameter("value");if(this._hasPropertyHelper()||this._getPropertyByName(s)){A(s,i);}else{this._retrieveMetadata().then(function(){A(s,i);});}}else{this._reportModelChange(false);}}}};
j.prototype._toExternal=function(p,o){var i=m({},o);i=e.toString(i,p.typeConfig,this.getTypeUtil());this._cleanupCondition(i);this._convertInOutParameters(o,i,"inParameters",e.toString);this._convertInOutParameters(o,i,"outParameters",e.toString);return i;};
j.prototype._toInternal=function(p,o){var i=m({},o);i=e.toType(i,p.typeConfig,this.getTypeUtil());this._convertInOutParameters(o,i,"inParameters",e.toType);this._convertInOutParameters(o,i,"outParameters",e.toType);return i;};
j.prototype._convertInOutParameters=function(o,i,p,n){if(o[p]&&(Object.keys(o[p]).length>0)){Object.keys(o[p]).forEach(function(K){var N=K.startsWith("conditions/")?K.slice(11):K;var q=this._getPropertyByName(N);if(q){var O=d.createCondition("EQ",[o[p][K]]);var v=n(O,q.typeConfig,this.getTypeUtil());if(!i[p]){i[p]={};}if(!K.startsWith("conditions/")){delete i[p][K];K="conditions/"+N;}i[p][K]=v.values[0];}else{L.error("mdc.FilterBar._convertInOutParameters: could not find property info for "+N);}}.bind(this));}};
j.prototype._cleanupCondition=function(o){if(o){if(o.hasOwnProperty("isEmpty")){delete o.isEmpty;}}};
j.prototype._cleanupConditions=function(i){if(i){i.forEach(function(o){this._cleanupCondition(o);},this);}};
j.prototype._stringifyCondition=function(p,o){var r=o;if(o&&o.values){if(o.values.length>0){r=this._toExternal(p,o);}else{r=m({},o);this._cleanupCondition(r);}}return r;};
j.prototype._stringifyConditions=function(s,i){var p=this._getPropertyByName(s);var r=i;if(p&&i){r=[];i.forEach(function(o){r.push(this._stringifyCondition(p,o));},this);}return r;};
j.prototype._handleAssignedFilterNames=function(i,n){if(this._bIsBeingDestroyed){return;}if(!i){if(this._btnAdapt){var o=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(o.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",o.length),false);}}var t=this._getAssignedFiltersText();var O={conditionsBased:(!i&&!n),filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this.fireFiltersChanged(O);};
j.prototype.onReset=function(o){this._getConditionModel().oConditionModel.removeAllConditions();};
j.prototype.onSearch=function(o){if(!this._bSearchPressed){this._bSearchPressed=true;this.triggerSearch().then(function(){this._bSearchPressed=false;}.bind(this),function(){this._bSearchPressed=false;}.bind(this));}};
j.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve();}return this.validate();};
j.prototype.validate=function(s){var i=!s;return this.initialized().then(function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise(function(r,o){this._fResolvedSearchPromise=r;this._fRejectedSearchPromise=o;}.bind(this));var n=function(){this._validate(i);this._oValidationPromise=null;};setTimeout(n.bind(this),0);}return this._oValidationPromise;}.bind(this));};
j.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null;}};
j.prototype._getRequiredFieldsWithoutValues=function(){var r=[];this._getRequiredPropertyNames().forEach(function(n){var i=this._getConditionModel().getConditions(n);if(!i||i.length===0){r.push(n);}}.bind(this));return r;};
j.prototype._checkAsyncValidation=function(){var r=E.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){r=E.AsyncValidation;}return r;};
j.prototype._checkRequiredFields=function(){var r=E.NoError;var R=this._getRequiredFieldsWithoutValues();R.forEach(function(n){var o=this._getFilterField(n);if(o){if(o.getValueState()===V.None){o.setValueState(V.Error);o.setValueStateText(this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING"));}}else{L.error("Mandatory filter field '"+n+"' not visible on FilterBarBase has no value.");}r=E.RequiredHasNoValue;}.bind(this));return r;};
j.prototype._checkFieldsInErrorState=function(){var r=E.NoError;this._getNonRequiredPropertyNames().some(function(n){var o=this._getFilterField(n);if(o&&(o.getValueState()!==V.None)){r=E.FieldInErrorState;}return r!==E.NoError;}.bind(this));return r;};
j.prototype._handleFilterItemSubmit=function(o){var p=o.getParameter("promise");if(p){p.then(function(){if(this._aCollectedChangePromises&&this._aCollectedChangePromises.length>0){var i=this._aCollectedChangePromises.slice();Promise.all(i).then(function(){this.triggerSearch();}.bind(this));}else{this.triggerSearch();}}.bind(this)).catch(function(i){L.error(i);});}};
j.prototype._handleFilterItemChanges=function(o){if(this._bIgnoreChanges){return;}var i=o.oSource;if(i.getRequired()&&(i.getValueState()===V.Error)&&o.getParameter("valid")){i.setValueState(V.None);return;}if(!this._aFIChanges){this._aFIChanges=[];}this._aFIChanges.push({name:i.getFieldPath(),promise:o.getParameter("promise")});};
j.prototype._checkFilters=function(){var r=this._checkAsyncValidation();if(r!==E.NoError){return r;}r=this._checkRequiredFields();if(r!==E.NoError){return r;}r=this._checkFieldsInErrorState();if(r!==E.NoError){return r;}return r;};
j.prototype._setFocusOnFirstErroneousField=function(){var o=null;this.getFilterItems().some(function(i){if(i.getValueState()!==V.None){o=i;setTimeout(i["focus"].bind(i),0);}return o!=null;});return o;};
j.prototype._handleAsyncValidation=function(i){if(this._aFIChanges&&(this._aFIChanges.length>0)){var n=this._aFIChanges.slice();this._aFIChanges=null;var o=[];n.forEach(function(N){o.push(N.promise);});Promise.all(o).then(function(p){p.forEach(function(q,r){var s=this._getFilterField(n[r].name);if(s&&s.getRequired()&&(s.getValueState()===V.Error)){s.setValueState(V.None);}},this);this._validate(i);}.bind(this),function(p){this._validate(i);}.bind(this));}};
j.prototype._waitForChangeAppliance=function(i){var n=this._aCollectedChangePromises.slice();this._aCollectedChangePromises=null;Promise.all(n).then(function(o){this._validate(i);}.bind(this),function(o){this._validate(i);}.bind(this));};
j.prototype._validate=function(i){var s,r;var n=function(){if(i){this.fireSearch();}}.bind(this);var o=function(){this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;}.bind(this);if(this.bIsDestroyed){o();return;}r=this._checkFilters();if(r===E.AsyncValidation){this._handleAsyncValidation(i);return;}if(this._aCollectedChangePromises&&(this._aCollectedChangePromises.length>0)){this._waitForChangeAppliance(i);return;}if(r===E.NoError){if(this._isChangeApplying()){this._oFlexPromise.then(function(){n();this._fResolvedSearchPromise();o();}.bind(this));}else{n();this._fResolvedSearchPromise();o();}}else{if(r===E.RequiredHasNoValue){s=this._oRb.getText("filterbar.REQUIRED_CONDITION_MISSING");}else{s=this._oRb.getText("filterbar.VALIDATION_ERROR");}if(this.getShowMessages()&&!this._isLiveMode()){try{h.error(s,{styleClass:(this.$()&&this.$().closest(".sapUiSizeCompact").length)?"sapUiSizeCompact":"",onClose:this._setFocusOnFirstErroneousField.bind(this)});}catch(x){L.error(x.message);}}else{L.warning("search was not triggered. "+s);}this._fRejectedSearchPromise();o();}};
j.prototype.setInternalConditions=function(i){var o=this._getConditionModel();if(o){o.setConditions(i);}};
j.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true);};
j.prototype.hasProperty=function(n){return this._getPropertyByName(n);};
j.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]);};
j.prototype.initialized=function(){return this.waitForInitialization();};
j.prototype._getModelConditions=function(o,i,K){var n={};if(o){var A=m({},o.getAllConditions());for(var s in A){if(A[s]&&(K||A[s].length>0)){n[s]=A[s];if(!i){this._cleanupConditions(n[s]);var p=this._stringifyConditions(s,n[s]);n[s]=p;}}}}return n;};
var _=function(p){var t=p.typeConfig.typeInstance;var o=t.getConstraints();return t.getMetadata().getName()==="sap.ui.model.odata.type.String"&&o&&o.isDigitSequence&&o.maxLength?function(i){return this._toExternal(p,i,this.getTypeUtil());}.bind(this):undefined;};
j.prototype._isPathKnown=function(s,x){var K,n;if(!this._getPropertyByName(s)){return false;}for(K in x["inParameters"]){n=K.startsWith("conditions/")?K.slice(11):K;if(!this._getPropertyByName(n)){return false;}}for(K in x["outParameters"]){n=K.startsWith("conditions/")?K.slice(11):K;if(!this._getPropertyByName(n)){return false;}}return true;};
j.prototype._removeCondition=function(s,x,o){var p=this._getPropertyByName(s);if(p){var i=this._toInternal(p,x);if(o.indexOf(s,i,_.call(this,p))>=0){o.removeCondition(s,i);}}};
j.prototype.removeCondition=function(s,x){return this.initialized().then(function(){var o=this._getConditionModel();if(o){if(!this._hasPropertyHelper()&&!this._isPathKnown(s,x)){return this._retrieveMetadata().then(function(){this._removeCondition(s,x,o);}.bind(this));}else{this._removeCondition(s,x,o);}}}.bind(this));};
j.prototype._addCondition=function(s,x,o){var p=this._getPropertyByName(s);if(p){var i=this._toInternal(p,x);if(o.indexOf(s,i,_.call(this,p))<0){var n={};n[s]=[i];F.checkConditionOperatorSanity(n);var q=n[s];if(q&&q.length>0){this._cleanUpFilterFieldInErrorStateByName(s);o.addCondition(s,i);}}}};
j.prototype.addCondition=function(s,x){return this.initialized().then(function(){var o=this._getConditionModel();if(o){if(!this._hasPropertyHelper()&&!this._isPathKnown(s,x)){return this._retrieveMetadata().then(function(){this._addCondition(s,x,o);}.bind(this));}else{this._addCondition(s,x,o);}}}.bind(this));};
j.prototype._setXConditions=function(i,r){var s,p,n,o=this._getConditionModel();var q=null;var t=new Promise(function(v,w){q=v;});var A=function(i){for(s in i){n=i[s];p=this._getPropertyByName(s);if(p){if(n.length===0){o.removeAllConditions(s);}else{if(p.maxConditions!==-1){o.removeAllConditions(s);}n.forEach(function(v){this._addCondition(s,v,o);}.bind(this));}}}q();}.bind(this);if(r){o.removeAllConditions();}if(i){var u=true;for(s in i){n=i[s];if(!this._isPathKnown(s,n)){u=false;break;}}if(!u&&!this._hasPropertyHelper()){this._retrieveMetadata().then(function(){A(i);});}else{A(i);}}return t;};
j.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false);};
j.prototype._getRequiredPropertyNames=function(){var r=[];this._getNonHiddenPropertyInfoSet().forEach(function(p){if(p.required){r.push(I.getPropertyKey(p));}});return r;};
j.prototype._getNonRequiredPropertyNames=function(){var n=[];this._getNonHiddenPropertyInfoSet().forEach(function(p){if(!p.required){n.push(I.getPropertyKey(p));}});return n;};
j.prototype._insertFilterFieldtoContent=function(o,n){if(!this._cLayoutItem){return;}var i=this._cLayoutItem;var p=new i();p.setFilterField(o);this._oFilterBarLayout.insertFilterField(p,n);};
j.prototype._filterItemInserted=function(o){if(!o.getVisible()){return;}if(o.setWidth){o.setWidth("");}this._applyFilterItemInserted(o);this._handleAssignedFilterNames(true);};
j.prototype._applyFilterItemInserted=function(o){var n,p;p=this.indexOfAggregation("filterItems",o);if(this.getAggregation("basicSearchField")){p++;}n=p;var q=this.getFilterItems();for(var i=0;i<n;i++){if(!q[i].getVisible()){p--;}}this._insertFilterFieldtoContent(o,p);if(!this._oObserver.isObserved(o,{properties:["visible"]})){this._oObserver.observe(o,{properties:["visible"]});}};
j.prototype._filterItemRemoved=function(o){this._applyFilterItemRemoved(o.getFieldPath());this._handleAssignedFilterNames(true);};
j.prototype._applyFilterItemRemoved=function(s){this._removeFilterFieldFromContentByName(s);};
j.prototype._removeFilterFieldFromContent=function(o){this._removeFilterFieldFromContentByName(o.getFieldPath());};
j.prototype._removeFilterFieldFromContentByName=function(s){var o=this._getFilterItemLayoutByName(s);if(o){this._oFilterBarLayout.removeFilterField(o);o.destroy();}};
j.prototype._observeChanges=function(o){if(o.type==="aggregation"){if(o.name==="filterItems"){switch(o.mutation){case"insert":o.child.attachChange(this._handleFilterItemChanges,this);o.child.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(o.child);break;case"remove":o.child.detachChange(this._handleFilterItemChanges,this);o.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(o.child);break;default:L.error("operation "+o.mutation+" not yet implemented");}}else if(o.name==="basicSearchField"){switch(o.mutation){case"insert":o.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(o.child,0);break;case"remove":o.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(o.child);break;default:L.error("operation "+o.mutation+" not yet implemented");}}}else if(o.type==="property"){var i;if(o.object.isA&&o.object.isA("sap.ui.mdc.FilterField")){i=o.object;if(i){if(o.current){this._filterItemInserted(i);}else{this._filterItemRemoved(i);}this._oFilterBarLayout.rerender();}}}};
j.prototype._getFilterItemLayout=function(o){return this._getFilterItemLayoutByName(o.getFieldPath());};
j.prototype._getFilterItemLayoutByName=function(s){var o=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(function(i){if(i._getFieldPath()===s){o=i;}return o!==null;});}return o;};
j.prototype._getFilterField=function(n){var o=null;this.getFilterItems().some(function(i){if(i&&i.getFieldPath&&(i.getFieldPath()===n)){o=i;}return o!==null;});return o;};
j.prototype._retrieveMetadata=function(){if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise;}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(r){this._fResolveMetadataApplied=r;}.bind(this));this.initControlDelegate().then(function(){if(!this._bIsBeingDestroyed){var r=function(){this._fResolveMetadataApplied();this._fResolveMetadataApplied=null;}.bind(this);if(this.bDelegateInitialized&&this.getControlDelegate().fetchProperties){this.initPropertyHelper(P).then(function(p){r();});}else{L.error("Provided delegate '"+this.getDelegate().path+"' not valid.");r();}}}.bind(this));return this._oMetadataAppliedPromise;};
j.prototype.setBasicSearchField=function(o){var O=this.getAggregation("basicSearchField");if(O){this.removeAggregation("basicSearchField",O);}this.setAggregation("basicSearchField",o);if(o){if(!this._oObserver.isObserved(o,{properties:["visible"]})){this._oObserver.observe(o,{properties:["visible"]});}}return this;};
j.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(p){if(!p.hiddenFilter){if(I.getPropertyKey(p)!=="$search"){v.push(p);}}return true;});return v;};
j.prototype._getNonHiddenPropertyByName=function(n){var p=null;this._getNonHiddenPropertyInfoSet().some(function(o){if(I.getPropertyKey(o)===n){p=o;}return p!=null;});return p;};
j.prototype._cleanUpFilterFieldInErrorStateByName=function(s){var o=null;var i=this.getFilterItems();i.some(function(n){if(n.getFieldPath()===s){o=n;}return o!=null;});if(o){this._cleanUpFilterFieldInErrorState(o);}};
j.prototype._cleanUpAllFilterFieldsInErrorState=function(){var i=this.getFilterItems();i.forEach(function(o){this._cleanUpFilterFieldInErrorState(o);}.bind(this));};
j.prototype._cleanUpFilterFieldInErrorState=function(o){if(o&&(o.getValueState()!==V.None)){o.setValueState(V.None);}};
j.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;this._oFlexPromise=this._getWaitForChangesPromise();Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise]).then(function(A){this._oFlexPromise=null;this._changesApplied();}.bind(this));};
j.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this);};
j.prototype._suspendBinding=function(o){if(o){var i=o.getBinding("conditions");if(i){if(!this._aBindings){this._aBindings=[];}i.suspend();this._aBindings.push(o);}}};
j.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(o){if(!o.bIsDestroyed){var i=o.getBinding("conditions");if(i){i.resume();}}});this._aBindings=null;}};
j.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};
j.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges().then(function(){this._changesApplied();this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null;}.bind(this));};
j.prototype._applyFilterConditionsChanges=function(){var s,i;s=this.getProperty("filterConditions");if(Object.keys(s).length>0){i=m({},s);return this._setXConditions(i,true);}return Promise.resolve();};
j.prototype.setVariantBackreference=function(v){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",v);g.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true});}else{L.error("the association 'variant' may only be assigned once and may not change afterwards.");}};
j.prototype._handleVariantSwitch=function(v){this._cleanUpAllFilterFieldsInErrorState();this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(v);this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;if(v.hasOwnProperty("createScenario")&&(v.createScenario==="saveAs")){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true;}if(!this._isChangeApplying()&&this._bInitialFiltersApplied){this._changesApplied();}};
j.prototype._getExecuteOnSelectionOnVariant=function(v){var i=false,o=this._getAssignedVariantManagement();if(o){i=o.getApplyAutomaticallyOnVariant(v);}return i;};
j.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false;};
j.prototype._getAssignedVariantManagement=function(){var v=this.getVariantBackreference();if(v){var o=sap.ui.getCore().byId(v);if(o&&o.isA("sap.ui.fl.variants.VariantManagement")){return o;}}return null;};
j.prototype._changesApplied=function(){if(!this._isChangeApplying()){this._bIgnoreChanges=false;}this._reportModelChange(this._bExecuteOnSelect,this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch);this._bExecuteOnSelect=undefined;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=undefined;};
j.prototype._getView=function(){return I.getView(this);};
j.prototype.getConditions=function(){var i=this._bPersistValues?this.getCurrentState().filter:this._getXConditions();if(i&&i["$search"]){delete i["$search"];}return i;};
j.prototype.getSearch=function(){var s=this._getConditionModel()?this._getConditionModel().getConditions("$search"):[];return s[0]?s[0].values[0]:"";};
j.prototype.exit=function(){if(this._hasAssignedVariantManagement()){g.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});}if(this.bDelegateInitialized&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this);}C.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._bPersistValues=null;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aCollectedChangePromises=null;};
return j;});
sap.ui.predefine('sap/ui/mdc/filterbar/IFilterContainer',['sap/ui/core/Element'],function(E){"use strict";
var I=E.extend("sap.ui.mdc.filterbar.IFilterContainer");
I.prototype.init=function(){E.prototype.init.apply(this,arguments);this.oLayout=null;};
I.prototype.getInner=function(){return this.oLayout;};
I.prototype.insertFilterField=function(c,i){};
I.prototype.removeFilterField=function(c){};
I.prototype.getFilterFields=function(){};
I.prototype.exit=function(){E.prototype.exit.apply(this,arguments);if(this.oLayout){this.oLayout.destroy();this.oLayout=null;}};
return I;});
sap.ui.predefine('sap/ui/mdc/filterbar/PropertyHelper',["../util/PropertyHelper"],function(P){"use strict";
var a=P.extend("sap.ui.mdc.filterbar.PropertyHelper",{constructor:function(p,e,o,E){var A=["required","hiddenFilter"];P.call(this,p,e,o,A,E);}});
return a;});
sap.ui.predefine('sap/ui/mdc/filterbar/aligned/FilterContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/ui/layout/AlignedFlowLayout'],function(I,A){"use strict";
var F=I.extend("sap.ui.mdc.filterbar.aligned.FilterContainer");
F.prototype.init=function(){I.prototype.init.apply(this,arguments);this.oLayout=new A();};
F.prototype.addButton=function(c){this.oLayout.addEndContent(c);};
F.prototype.insertFilterField=function(c,i){this.oLayout.insertContent(c,i);};
F.prototype.removeFilterField=function(c){this.oLayout.removeContent(c);};
F.prototype.getFilterFields=function(){return this.oLayout.getContent();};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/aligned/FilterItemLayout',['sap/ui/layout/VerticalLayout','sap/ui/layout/VerticalLayoutRenderer','sap/m/Label'],function(V,a,L){"use strict";
var F=V.extend("sap.ui.mdc.filterbar.aligned.FilterItemLayout",{
metadata:{library:"sap.ui.mdc"},
renderer:{apiVersion:2,render:a.render}
});
F.prototype._setLabel=function(f){this._oLabel=new L(f.getId()+"-label");this._oLabel.setParent(this);f.connectLabel(this._oLabel);if(f.getFieldPath()==="$search"){this._oLabel.setText("\u2008");}else{this._oLabel.addStyleClass("sapUiMdcFilterBarBaseLabel");}};
F.prototype._getFilterField=function(){return this._oFilterField;};
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._setLabel(f);this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getContent=function(){var c=[];c.push(this._oLabel);c.push(this._oFilterField);return c;};
F.prototype.exit=function(){this._oFilterField=null;this._sFieldPath=null;if(this._oLabel&&!this._oLabel.bIsDestroyed){this._oLabel.destroy();this._oLabel=undefined;}V.prototype.exit.apply(this,arguments);};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/AdaptationFilterBar',["sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer"],function(G,F,T,a,b,c){"use strict";
var A=b.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{
metadata:{library:"sap.ui.mdc",properties:{adaptationControl:{type:"object"}},events:{change:{}}},
renderer:c
});
A.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bPersistValues=true;};
A.prototype._initControlDelegate=function(){this._retrieveMetadata().then(function(){this._applyInitialFilterConditions();}.bind(this));};
A.prototype.setMessageStrip=function(s){this._oFilterBarLayout.setMessageStrip(s);};
A.prototype.setLiveMode=function(l,s){b.prototype.setLiveMode.apply(this,arguments);if(!l){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);}this._oConditionModel.attachPropertyChange(function(e){var k=e.getParameter("path").substring(12);if(this.oAdaptationModel){var i=this.oAdaptationModel.getProperty("/items");var I=i.find(function(o){return o.name==k;});if(I){I.isFiltered=this._getConditionModel().getConditions(k).length>0?true:false;this.oAdaptationModel.setProperty("/items",i);}}}.bind(this));return this;};
A.prototype.createConditionChanges=function(){var C=this._getModelConditions(this._getConditionModel(),false,true);if(this._bPersistValues){return this.getEngine().createChanges({control:this.getAdaptationControl(),key:"Filter",state:C,suppressAppliance:true});}else{this.getAdaptationControl()._setXConditions(C,true);return Promise.resolve(null);}};
A.prototype.setP13nModel=function(p){this.oAdaptationModel=p;this._oFilterBarLayout.update();};
A.prototype.getP13nModel=function(p){return this.oAdaptationModel;};
A.prototype._handleFilterItemSubmit=function(){return;};
A.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this.getAdaptationControl());};
A.prototype.applyConditionsAfterChangesApplied=function(){b.prototype.applyConditionsAfterChangesApplied.apply(this,arguments);this.triggerSearch();};
A.prototype.initPropertyHelper=function(){return this.getAdaptationControl().awaitPropertyHelper().then(function(p){this._oPropertyHelper=p;}.bind(this));};
A.prototype.createFilterFields=function(){return this.initialized().then(function(){var C=this._bPersistValues?this.getAdaptationControl().getFilterConditions():this.getAdaptationControl()._getXConditions();this._setXConditions(C,true);if(this._bFilterFieldsCreated){return this;}var o=this.getAdaptationControl();var d=o.getControlDelegate();var f=this._checkAdvancedParent(o)?d:d.getFilterDelegate();this._mOriginalsForClone={};var e=[];this.oAdaptationModel.getProperty("/items").forEach(function(i,I){var g;g=this._checkExisting(i,f);g.then(function(h){var j;if(this._checkAdvancedParent(o)){if(h._bTemporaryOriginal){delete g._bTemporaryOriginal;this._mOriginalsForClone[h.getFieldPath()]=h;}j=h.clone();}else{j=h;}i.filterfield=j;}.bind(this));e.push(g);}.bind(this));return Promise.all(e).then(function(){this.oAdaptationModel.getProperty("/items").forEach(function(i){this.addAggregation("filterItems",i.filterfield);delete i.filterfield;}.bind(this));if(this._oFilterBarLayout.getInner().setP13nModel){this._oFilterBarLayout.getInner().setP13nModel(this.oAdaptationModel);}this._bFilterFieldsCreated=true;return this;}.bind(this));}.bind(this));};
A.prototype._checkExisting=function(i,f){var o;var d=this.getAdaptationControl();var e=this._checkAdvancedParent(d)?d.getFilterItems():[];var E=e.reduce(function(m,g){m[g.getFieldPath()]=g;return m;},{});if(E[i.name]){o=Promise.resolve(E[i.name]);}else{o=f.addItem(i.name,this.getAdaptationControl());o=o.then(function(g){if(!g){throw new Error("No FilterField could be created for property: '"+i.name+"'.");}g._bTemporaryOriginal=true;return g;});}return o;};
A.prototype.executeRemoves=function(){var e=this._oFilterBarLayout.getInner().getSelectedFields();var o=[];Object.keys(this._mOriginalsForClone).forEach(function(k){var d=this.getAdaptationControl().getControlDelegate();if(e.indexOf(k)<0){var r=d.removeItem.call(d,k,this.getAdaptationControl()).then(function(C){if(C&&this._mOriginalsForClone[k]){this._mOriginalsForClone[k].destroy();delete this._mOriginalsForClone[k];}}.bind(this));o.push(r);}}.bind(this));return Promise.all(o);};
A.prototype._checkAdvancedParent=function(C){if(!C.isA("sap.ui.mdc.IFilterSource")&&!C.isA("sap.ui.mdc.IFilter")){throw new Error("The 'adaptationControl' needs to implement the IFilterSource or IFilter interface");}return C.isA("sap.ui.mdc.IFilter");};
A.prototype.setAdaptationControl=function(C,s){this.setProperty("adaptationControl",C,s);this._checkAdvancedParent(C);this._cLayoutItem=this._checkAdvancedParent(C)?F:a;this._oFilterBarLayout=this._checkAdvancedParent(C)?new G():new T();this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);this.addStyleClass("sapUIAdaptationFilterBar");if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(function(){this.fireChange();}.bind(this));}return this;};
A.prototype.exit=function(){b.prototype.exit.apply(this,arguments);for(var k in this._mOriginalsForClone){this._mOriginalsForClone[k].destroy();}this._mOriginalsForClone=null;this.oAdaptationModel=null;};
return A;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/FilterColumnLayout',['sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/Label'],function(C,a,L){"use strict";
var F=C.extend("sap.ui.mdc.filterbar.p13n.FilterColumnLayout",{
metadata:{library:"sap.ui.mdc"},
renderer:a
});
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._sLabel=f.getLabel();this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getCells=function(){var c=[];var l=new L({text:this._sLabel});l.setParent(this);c.push(l);c.push(this._oFilterField);return c;};
F.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oFilterField=null;this._sFieldPath=null;};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/FilterGroupLayout',['sap/ui/core/Control'],function(C){"use strict";
var F=C.extend("sap.ui.mdc.filterbar.p13n.FilterGroupLayout",{renderer:{apiVersion:2,render:function(r,c){r.openStart("div",c);r.style("height","100%");r.openEnd();r.renderControl(c.getItems()[0]);r.close("div");}}});
F.prototype._getFieldPath=function(){return this._sFieldPath;};
F.prototype.setFilterField=function(f){this._oFilterField=f;this._sFieldPath=f.getFieldPath();};
F.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
F.prototype.getItems=function(){var c=[];c.push(this._oFilterField);return c;};
F.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oFilterField=null;this._sFieldPath=null;};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/GroupContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/ui/mdc/p13n/panels/AdaptFiltersPanel'],function(I,A){"use strict";
var G=I.extend("sap.ui.mdc.filterbar.p13n.GroupContainer");
G.prototype.init=function(){I.prototype.init.apply(this,arguments);this.mFilterItems={};this.oLayout=new A();this.oLayout.setItemFactory(function(b){var k=this.oLayout.getModel(this.oLayout.P13N_MODEL).getProperty(b.sPath).name;var f=this.mFilterItems[k];return f;}.bind(this));};
G.prototype.setMessageStrip=function(s){this.oLayout.getCurrentViewContent().setMessageStrip(s);};
G.prototype.insertFilterField=function(c,i){this.mFilterItems[c._getFieldPath()]=c;};
G.prototype.removeFilterField=function(c){this.oLayout.removeItem(c);};
G.prototype.getFilterFields=function(){var f=[];Object.keys(this.mFilterItems).forEach(function(k){f.push(this.mFilterItems[k]);}.bind(this));return f;};
G.prototype.update=function(){this.oLayout.restoreDefaults();};
G.prototype.exit=function(){this.mFilterItems=null;this.mFilterFields=null;I.prototype.exit.apply(this,arguments);};
return G;});
sap.ui.predefine('sap/ui/mdc/filterbar/p13n/TableContainer',['sap/ui/mdc/filterbar/IFilterContainer','sap/m/Table','sap/m/Column','sap/m/Text','sap/m/VBox'],function(I,T,C,a,V){"use strict";
var b=I.extend("sap.ui.mdc.filterbar.p13n.TableContainer");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oTable=new T({sticky:["ColumnHeaders"],growing:true,columns:[new C({header:new a({text:r.getText("filter.AdaptationFilterBar_FIELD_COLUMN")})}),new C({header:new a({text:r.getText("filter.AdaptationFilterBar_FIELD_VALUE_COLUMN")})})]});this._oMessageStripContainer=new V(this.getId()+"-messageStripContainer");this.oLayout=new V({items:[this._oMessageStripContainer,this._oTable]});};
b.prototype.insertFilterField=function(c,i){this._oTable.insertItem(c,i);};
b.prototype.removeFilterField=function(c){this._oTable.removeItem(c);};
b.prototype.setMessageStrip=function(s){this._oMessageStripContainer.removeAllItems();this._oMessageStripContainer.addItem(s);};
b.prototype.getFilterFields=function(){return this._oTable.getItems();};
b.prototype.update=function(){};
b.prototype.exit=function(){this._oTable=null;this._oMessageStripContainer=null;};
return b;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/CollectiveSearchSelect',["sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Item","sap/ui/core/Control","sap/ui/layout/HorizontalLayout","sap/m/SearchField","sap/m/Page","sap/m/Toolbar","sap/m/ToggleButton","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/ui/events/KeyCodes","sap/m/library",'sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver'],function(F,a,D,I,b,C,H,S,P,T,c,d,R,e,K,m,M,f){"use strict";var B=m.ButtonType;var g=m.PlacementType;
var h=C.extend("sap.ui.mdc.filterbar.vh.CollectiveSearchSelect",{
metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Misc",defaultValue:null},selectedItemKey:{type:"string",group:"Misc",defaultValue:null},_currentItemText:{type:"string",group:"Misc",defaultValue:null,hidden:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},events:{select:{parameters:{key:{type:"string"}}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o).class("sapUiMdcCollectiveSearchSelect").attr("title",o.oRb.getText("COL_SEARCH_TRIGGER_TT")).openEnd();r.renderControl(o.oLayout);r.close("div");}}
});
h.prototype.init=function(){this._oManagedObjectModel=new M(this);this.setModel(this._oManagedObjectModel,"$mdcColSearch");this._oObserver=new f(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["selectedItemKey"],aggregations:["items"]});this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.oInvisibleText=new I();this.oText=new d(this.getId()+"-text",{text:"{$mdcColSearch>/_currentItemText}"}).addStyleClass("sapUiMdcCollectiveSearchSelectClickable").addStyleClass("sapUiMdcCollectiveSearchSelectTitle");if(D.system.phone){this.oText.addStyleClass("sapUiMdcCollectiveSearchSelectTextPhoneMaxWidth");}else{this.oText.addStyleClass("sapUiMdcCollectiveSearchSelectTextMaxWidth");}this.oPopoverTrigger=new c(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:B.Transparent,tooltip:this.oRb.getText("COL_SEARCH_TRIGGER_TT")}).addAriaLabelledBy(this.oInvisibleText).addStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtn").addStyleClass("sapMTitleStyleH4");this.oLayout=new H({content:[this.oText,this.oPopoverTrigger]}).addStyleClass("sapUiMdcCollectiveSearchSelectLayout");this.oInvisibleText.toStatic();this.addDependent(this.oLayout);};
h.prototype._observeChanges=function(o){if(["selectedItemKey","items"].indexOf(o.name)>=-1){this._updateCurrentItemText();}};
h.prototype._updateCurrentItemText=function(){var k=this.getSelectedItemKey();var i=this._getItemByKey(k);var t=i?i.getText():k;this.oInvisibleText.setText(this.oRb.getText("COL_SEARCH_SEL_INVISIBLETXT",[t]));this.setProperty("_currentItemText",t);};
h.prototype._getItemByKey=function(k){var i=null;var j=this.getItems();j.some(function(E){if(E.getKey()===k){i=E;}return(i!==null);});return i;};
h.prototype.handleOpenClosePopover=function(){if(!this.bPopoverOpen){this._openList();}else if(this.oPopover&&this.oPopover.isOpen()){this.oPopover.close();}};
h.prototype.getFocusDomRef=function(){if(this.oPopoverTrigger){return this.oPopoverTrigger.getFocusDomRef();}};
h.prototype.onclick=function(){if(this.oPopoverTrigger&&!this.bPopoverOpen){this.oPopoverTrigger.focus();}this.handleOpenClosePopover();};
h.prototype.onkeyup=function(E){if(E.which===K.F4||E.which===K.SPACE||E.altKey===true&&E.which===K.ARROW_UP||E.altKey===true&&E.which===K.ARROW_DOWN){this._openList();}};
h.prototype.onAfterRendering=function(){this.oText.$().off("mouseover").on("mouseover",function(){this.oPopoverTrigger.addStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtnHover");}.bind(this));this.oText.$().off("mouseout").on("mouseout",function(){this.oPopoverTrigger.removeStyleClass("sapUiMdcCollectiveSearchSelectTriggerBtnHover");}.bind(this));};
h.prototype._createList=function(){if(this.oPopover){return;}this.oList=new e(this.getId()+"-list",{selectedKey:{path:"$mdcColSearch>/selectedItemKey"},itemPress:function(E){var s=null;if(E&&E.getParameter("item")){var i=E.getParameter("item");if(i){s=i.getKey();}}this.oPopover.close();if(this.getSelectedItemKey()!==s){this.setSelectedItemKey(s);this.fireSelect({key:s});}}.bind(this)});this.oList.bindAggregation("items",{path:"/items",model:"$mdcColSearch",template:new b({key:"{$mdcColSearch>key}",text:"{$mdcColSearch>text}"})});this.oSearchField=new S(this.getId()+"-search");this.oSearchField.attachLiveChange(function(E){var v=E.getParameter("newValue")||"";this._triggerSearch(v,this.oList);}.bind(this));this.oPage=new P(this.getId()+"-selpage",{subHeader:new T({content:[this.oSearchField]}),content:[this.oList],showNavButton:false,showHeader:false});this.oPopover=new R(this.getId()+"-popover",{title:{path:"$mdcColSearch>/title"},titleAlignment:"Auto",contentWidth:"400px",placement:g.VerticalPreferredBottom,content:[this.oPage],afterOpen:function(){this.bPopoverOpen=true;this.oPopoverTrigger.setPressed(true);}.bind(this),afterClose:function(){this.oPopoverTrigger.setPressed(false);if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oPopover.addStyleClass("sapUiMdcCollectiveSearchSelectPopover");if(this.oLayout.$().closest(".sapUiSizeCompact").length>0){this.oPopover.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oPopover);};
h.prototype._openList=function(){if(this.bPopoverOpen){return;}this._createList();this.oSearchField.setValue("");this._triggerSearch("",this.oList);this.oPage.setShowSubHeader(this.oList.getItems().length>9);this.oPopover.openBy(this.oPopoverTrigger);};
h.prototype._triggerSearch=function(v,l){var i=[];if(v){var o=new F({path:"text",operator:a.Contains,value1:v});i.push(o);}l.getBinding("items").filter(i);};
h.prototype.exit=function(){if(this.oInvisibleText){this.oInvisibleText.destroy(true);this.oInvisibleText=undefined;}this.oRb=undefined;this.oList=undefined;this.oPage=undefined;this.oLayout=undefined;this.oText=undefined;this.oPopoverTrigger=undefined;this.oSearchField=undefined;this._oManagedObjectModel.destroy();this._oManagedObjectModel=undefined;this._oObserver.disconnect();this._oObserver=undefined;};
return h;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/FilterBar',["sap/m/library","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/vh/FilterContainer","sap/m/Button"],function(l,F,a,b,c,B){"use strict";
var d=F.extend("sap.ui.mdc.filterbar.vh.FilterBar",{
metadata:{properties:{expandFilterFields:{type:"boolean",defaultValue:true},filterFieldThreshold:{type:"int",defaultValue:8}},aggregations:{collectiveSearch:{type:"sap.ui.mdc.filterbar.vh.CollectiveSearchSelect",multiple:false}}},
renderer:a
});
var e=l.ButtonType;
d.prototype._createInnerLayout=function(){this._cLayoutItem=b;this._oFilterBarLayout=new c(this.getId()+"-innerLayout",{});this.setAggregation("layout",this._oFilterBarLayout,true);this._oBtnFilters=new B(this.getId()+"-btnShowFilters",{type:e.Transparent,press:this._onToggleFilters.bind(this)});this._oBtnFilters.bindProperty("text",{model:F.INNER_MODEL_NAME,path:"/expandFilterFields",formatter:function(E){return this._oRb.getText("valuehelp."+(E?"HIDE":"SHOW")+"ADVSEARCH");}.bind(this)});this._oBtnFilters.bindProperty("visible",{model:F.INNER_MODEL_NAME,path:"/filterItems",formatter:function(i){return i.length>0;}});this._oFilterBarLayout.addControl(this._getSearchButton().bindProperty("visible",{parts:[{path:'/showGoButton',model:F.INNER_MODEL_NAME},{path:"/liveMode",model:F.INNER_MODEL_NAME}],formatter:function(s,L){return s&&((this._isPhone())?true:!L);}.bind(this)}));this._oFilterBarLayout.addControl(this._oBtnFilters);this._oShowAllFiltersBtn=new B(this.getId()+"-btnShowAllFilters",{type:e.Transparent,press:this._onShowAllFilters.bind(this),text:this._oRb.getText("valuehelp.SHOWALLFILTERS")});this._oFilterBarLayout.addEndContent(this._oShowAllFiltersBtn);};
d.prototype.applySettings=function(s,S){this._applySettings(s,S);this._waitForMetadata();};
d.prototype.exit=function(){F.prototype.exit.apply(this,arguments);this._oBasicSearchField=null;this._oCollectiveSearch=null;this._oBtnFilters=null;this._oShowAllFiltersBtn=null;};
d.prototype._onToggleFilters=function(E){this.setExpandFilterFields(!this.getExpandFilterFields());};
d.prototype._onShowAllFilters=function(E){this._oFilterBarLayout._updateFilterBarLayout(true);};
d.prototype.setCollectiveSearch=function(C){if(this._oCollectiveSearch){if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);}}this._oCollectiveSearch=C;if(this._oFilterBarLayout&&this._oCollectiveSearch){this._oFilterBarLayout.insertControl(this._oCollectiveSearch,0);}return this;};
d.prototype.getCollectiveSearch=function(){return this._oCollectiveSearch;};
d.prototype.destroyCollectiveSearch=function(){if(this._oCollectiveSearch&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oCollectiveSearch);this._oCollectiveSearch.destroy();this._oCollectiveSearch=undefined;}return this;};
d.prototype.setBasicSearchField=function(o){if(this._oBasicSearchField){if(this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField);}this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this);}this._oBasicSearchField=o;if(o){this.setExpandFilterFields(false);if(this._oFilterBarLayout){this._oFilterBarLayout.insertControl(o,this._oCollectiveSearch?1:0);}o.attachSubmit(this._handleFilterItemSubmit,this);if(!this._oObserver.isObserved(o,{properties:["visible"]})){this._oObserver.observe(o,{properties:["visible"]});}}return this;};
d.prototype.getBasicSearchField=function(){return this._oBasicSearchField;};
d.prototype.destroyBasicSearchField=function(){if(this._oBasicSearchField&&this._oFilterBarLayout){this._oFilterBarLayout.removeControl(this._oBasicSearchField);this._oBasicSearchField.detachSubmit(this._handleFilterItemSubmit,this);if(this._oObserver.isObserved(this._oBasicSearchField,{properties:["visible"]})){this._oObserver.unobserve(this._oBasicSearchField);}this._oBasicSearchField.destroy();this._oBasicSearchField=undefined;}return this;};
return d;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/FilterContainer',["sap/ui/mdc/filterbar/IFilterContainer","sap/ui/layout/AlignedFlowLayout","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/VBox"],function(I,A,T,a,V){"use strict";
var F=I.extend("sap.ui.mdc.filterbar.vh.FilterContainer",{metadata:{aggregations:{_layout:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
F.prototype.init=function(){this.aLayoutItems=[];this.oToolbar=new T(this.getId()+"-tbr",{content:[new a()]});this.oAlgnLayout=new A(this.getId()+"-aflayout",{visible:"{$sap.ui.filterbar.mdc.FilterBarBase>/expandFilterFields}"}).addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.oLayout=new V(this.getId()+"-vbox",{items:[this.oToolbar,this.oAlgnLayout]});this.setAggregation("_layout",this.oLayout,true);};
F.prototype.exit=function(){this.aLayoutItems.forEach(function(i){i.destroy();});this.aLayoutItems=null;};
F.prototype.addControl=function(c){this.oToolbar.addContent(c);};
F.prototype.insertControl=function(c,i){this.oToolbar.insertContent(c,i);};
F.prototype.removeControl=function(c){this.oToolbar.removeContent(c);};
F.prototype.addEndContent=function(c){this.oAlgnLayout.addEndContent(c);};
F.prototype.insertFilterField=function(c,i){this.aLayoutItems.splice(i,0,c);this._updateFilterBarLayout();};
F.prototype.removeFilterField=function(c){var n=-1;this.aLayoutItems.some(function(l,i){if(c===l){n=i;return true;}return false;});if(n>=0){this.aLayoutItems.splice(n,1);this._updateFilterBarLayout();}};
F.prototype.getFilterFields=function(){return this.oAlgnLayout.getContent();};
F.prototype._updateFilterBarLayout=function(s){var n=this.aLayoutItems.length;var t=this.getParent().getFilterFieldThreshold();var u=s||n<=t+1;if(!u){var b=this.oAlgnLayout.getContent();b.some(function(o,i){if(o!=this.aLayoutItems[i]){u=true;return true;}return false;}.bind(this));}if(u){this.oAlgnLayout.removeAllContent();this.aLayoutItems.some(function(l,c){if(s||n<=t||c+1<t){this.oAlgnLayout.insertContent(l,c);return false;}return true;}.bind(this));}var S=this.oAlgnLayout.getEndContent()[0];S.setVisible(!s&&n>t);};
return F;});
sap.ui.predefine('sap/ui/mdc/filterbar/vh/GenericFilterBarDelegate',["sap/ui/mdc/odata/v4/FilterBarDelegate",'sap/ui/base/ManagedObjectObserver'],function(F,M){"use strict";var G=Object.assign({},F);
G.fetchProperties=function(f){if(!f.__oObserver){f.__oObserver=new M(_.bind(this));f.__oObserver.observe(f,{aggregations:["filterItems"]});}return new Promise(function(R){var b=f.getFilterItems();f.__aProperties=[];b.forEach(function(o){a.call(this,o,f.__aProperties);}.bind(this));R(f.__aProperties);}.bind(this));};
function a(f,p){var P=f.getBindingPath("conditions");if(!P){return;}var b=P.split("/");var s=b[b.length-1];p.push({name:s,label:f.getLabel()||s,type:f.getDataType(),formatOptions:f.getDataTypeFormatOptions(),constraints:f.getDataTypeConstraints(),typeConfig:this.getTypeUtil().getTypeConfig(f.getDataType(),f.getDataTypeFormatOptions(),f.getDataTypeConstraints()),required:f.getRequired(),hiddenFilter:false,visible:f.getVisible(),maxConditions:f.getMaxConditions(),fieldHelp:f.getFieldHelp()});}
function r(f,p){var P=f.getBindingPath("conditions");if(!P){return;}function b(n){var N=null;p.some(function(o){if(o.name===n){N=o;}return N!==null;});return N;}function c(n){var e=-1;p.some(function(o,i){if(o.name===n){e=i;}return e!==-1;});if(e>=0){p.splice(e,1);}return e;}var d=P.split("/");var s=d[d.length-1];if(b(s)){c(s);}}
function _(c){var f,p;if(c.name==="filterItems"){if(c.mutation==="insert"){var n=c.child;f=n.getParent();p=f.__aProperties;a.call(this,n,p);return;}if(c.mutation==="remove"){var R=c.child;f=R.getParent();p=f.__aProperties;r(R,p);return;}}}
G.cleanup=function(f){if(f.__oObserver){f.__oObserver.disconnect();delete f.__oObserver;delete f.__aProperties;}};
return G;});
sap.ui.predefine('sap/ui/mdc/flexibility/ActionToolbar.flexibility',['./ItemBaseFlex'],function(I){"use strict";var a=Object.assign({},I);
a.findItem=function(m,A,n){return sap.ui.getCore().byId(n);};
return{"moveControls":"default",moveAction:a.createMoveChangeHandler()};});
sap.ui.predefine('sap/ui/mdc/flexibility/ActionToolbarAction.flexibility',[],function(){"use strict";return{unhideControl:{changeHandler:"default"},hideControl:{changeHandler:"default"}};});
sap.ui.predefine('sap/ui/mdc/flexibility/AggregateFlex',["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F){"use strict";var r=function(c){var e=c&&c.isA&&c.isA("sap.ui.mdc.Table")&&c.isTableBound();var E=c&&c.isA&&(c.isA("sap.ui.mdc.Chart"));if(e||E){if(!c._bWaitForBindChanges){c._bWaitForBindChanges=true;F.waitForChanges({element:c}).then(function(){if(e){c.rebind();}else if(E){c.rebind();}delete c._bWaitForBindChanges;});}}};var f=function(c,C,o,i){if(i){c.resetRevertData();}else{c.setRevertData(o);}r(C);};var a=function(c,C,p,i){return new Promise(function(b,d){var m=p.modifier;var o=i?c.getRevertData():c.getContent();Promise.resolve().then(m.getProperty.bind(m,C,"aggregateConditions")).then(function(e){var g=e?e:{};g[o.name]={};var h={name:o.name};m.setProperty(C,"aggregateConditions",g);f(c,C,h,i);b();}).catch(function(e){d(e);});});};var R=function(c,C,p,i){return new Promise(function(b,d){var m=p.modifier;var o=i?c.getRevertData():c.getContent();Promise.resolve().then(m.getProperty.bind(m,C,"aggregateConditions")).then(function(e){var v=e?e:{};if(!v){d();}delete v[o.name];m.setProperty(C,"aggregateConditions",v);f(c,C,o,i);b();}).catch(function(e){d(e);});});};var A={};A.removeAggregate={"changeHandler":{applyChange:function(c,C,p){return R(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return a(c,C,p,true);}},"layers":{"USER":true}};A.addAggregate={"changeHandler":{applyChange:function(c,C,p){return a(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return R(c,C,p,true);}},"layers":{"USER":true}};return A;});
sap.ui.predefine('sap/ui/mdc/flexibility/AggregationConfigFlex',['sap/ui/mdc/p13n/Engine'],function(E){"use strict";var A={};var c=function(C){if(!C._bWaitForModificationChanges){C._bWaitForModificationChanges=true;E.getInstance().waitForChanges(C).then(function(){if(C._onModifications instanceof Function){C._onModifications();}delete C._bWaitForModificationChanges;});}};
A.createSetChangeHandler=function(m){if(!m||!m.hasOwnProperty("aggregation")||!m.hasOwnProperty("property")){throw new Error("Please provide a map containing the affected aggregation and property name!");}var a=m.aggregation;var s=m.property;return{"changeHandler":{applyChange:function(C,o,p){return E.getInstance().readXConfig(o,{propertyBag:p}).then(function(P){var O=null;if(P&&P.aggregations&&P.aggregations[a]&&P.aggregations[a][C.getContent().name]&&P.aggregations[a][C.getContent().name][s]){O=P.aggregations[a][C.getContent().name][s];}C.setRevertData({name:C.getContent().name,value:O});return E.getInstance().enhanceXConfig(o,{controlMeta:{aggregation:a,property:s},name:C.getContent().name,value:C.getContent().value,propertyBag:p});}).then(function(){c(o);});},completeChangeContent:function(C,b,p){},revertChange:function(C,o,p){return E.getInstance().enhanceXConfig(o,{controlMeta:{aggregation:a,property:s},name:C.getRevertData().name,value:C.getRevertData().value,propertyBag:p}).then(function(){C.resetRevertData();c(o);});}},"layers":{"USER":true}};};
return A;});
sap.ui.predefine('sap/ui/mdc/flexibility/Chart.flexibility',['./SortFlex','./ChartItemFlex'],function(S,C){"use strict";return{addItem:C.addItem,removeItem:C.removeItem,moveItem:C.moveItem,"setChartType":{layers:{USER:true},changeHandler:{createChange:function(p){if(!p.control){throw new Error("Invalid control. The existing control object is mandatory");}return{selectorElement:p.control,changeSpecificData:{changeType:"setChartType",content:{chartType:p.chartType}}};},completeChangeContent:function(c,s){},applyChange:function(c,o,p){var m=p.modifier;return Promise.resolve().then(m.getProperty.bind(m,o,"chartType")).then(function(O){c.setRevertData(O);m.setProperty(o,"chartType",c.getContent().chartType);});},revertChange:function(c,o,p){p.modifier.setProperty(o,"chartType",c.getRevertData());c.resetRevertData();}}},removeSort:S.removeSort,addSort:S.addSort,moveSort:S.moveSort};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/ChartItemFlex',['./ItemBaseFlex'],function(I){"use strict";var c=Object.assign({},I);
c.beforeAddItem=function(D,d,C,p,o){return D.addItem.call(D,d,C,p,o.role);};
c.findItem=function(m,i,n){return i.reduce(function(p,o){return p.then(function(f){if(!f){return Promise.all([m.getProperty(o,"key"),m.getProperty(o,"name")]).then(function(P){if(P[0]===n||P[1]===n){return o;}});}return f;});},Promise.resolve());};
c.addItem=c.createAddChangeHandler();c.removeItem=c.createRemoveChangeHandler();c.moveItem=c.createMoveChangeHandler();return c;});
sap.ui.predefine('sap/ui/mdc/flexibility/ColumnFlex',['sap/ui/mdc/p13n/Engine','./ItemBaseFlex'],function(E,I){"use strict";var C=Object.assign({},I);var r=function(c){if(c&&c.isA&&c.isA("sap.ui.mdc.Table")&&c.isTableBound()){if(!c._bWaitForBindChanges){c._bWaitForBindChanges=true;E.getInstance().waitForChanges(c).then(function(){c.rebind();delete c._bWaitForBindChanges;});}}};
C.findItem=function(m,c,n){return c.reduce(function(p,o){return p.then(function(f){if(!f){return Promise.resolve().then(m.getProperty.bind(m,o,"dataProperty")).then(function(d){if(d===n){return o;}});}return f;});},Promise.resolve());};
C.afterApply=function(c,t,i){r(t);};
C.addColumn=C.createAddChangeHandler();C.removeColumn=C.createRemoveChangeHandler();C.moveColumn=C.createMoveChangeHandler();return C;});
sap.ui.predefine('sap/ui/mdc/flexibility/ConditionFlex',['sap/base/util/merge','sap/ui/mdc/condition/FilterOperatorUtil'],function(m,F){"use strict";var q=function(C,t){var f=function(p){if(C._pQueue===p){delete C._pQueue;}};C._pQueue=C._pQueue instanceof Promise?C._pQueue.then(t):t();C._pQueue.then(f.bind(null,C._pQueue));return C._pQueue;};var d=function(C){var o=C&&C.getEngine?C.getEngine().getController(C,"Filter"):null;return o?o.getFilterControl():null;};var a=function(C,o,b,p,i){var f=d(b);if(f&&f.applyConditionsAfterChangesApplied){f.applyConditionsAfterChangesApplied();}return q(b,function(){var e,g=null,M=p.modifier;return M.getProperty(b,"filterConditions").then(function(h){e=m({},h);if(e){for(var s in e){if(s===o.name){g=e[s];break;}}}if(!g){e[o.name]=[];g=e[o.name];}var n=F.indexOfCondition(o.condition,g);if(n<0){g.push(o.condition);M.setProperty(b,"filterConditions",e);if(!i){C.setRevertData({name:o.name,condition:o.condition});}if(f&&f.addCondition){return f.addCondition(o.name,o.condition);}}});});};var r=function(C,o,b,p,i){var f=d(b);if(f&&f.applyConditionsAfterChangesApplied){f.applyConditionsAfterChangesApplied();}return q(b,function(){var e,g,n=-1,M=p.modifier;return M.getProperty(b,"filterConditions").then(function(h){e=m({},h);if(e){for(var s in e){if(s===o.name){g=e[s];break;}}}if(g&&(g.length>0)){n=F.indexOfCondition(o.condition,g);if(n>=0){g.splice(n,1);M.setProperty(b,"filterConditions",e);if(!i){C.setRevertData({name:o.name,condition:o.condition});}if(f&&f.removeCondition){return f.removeCondition(o.name,o.condition);}}}});});};var c={};c.addCondition={"changeHandler":{applyChange:function(C,o,p){return a(C,C.getContent(),o,p,false);},completeChangeContent:function(C,b,p){},revertChange:function(C,o,p){return r(C,C.getRevertData(),o,p,true).then(function(){C.resetRevertData();});}},"layers":{"USER":true}};c.removeCondition={"changeHandler":{applyChange:function(C,o,p){return r(C,C.getContent(),o,p,false);},completeChangeContent:function(C,b,p){},revertChange:function(C,o,p){return a(C,C.getRevertData(),o,p,true).then(function(){C.resetRevertData();});}},"layers":{"USER":true}};return c;});
sap.ui.predefine('sap/ui/mdc/flexibility/FilterBar.flexibility',['./FilterItemFlex','./ConditionFlex','./PropertyInfoFlex'],function(F,C,P){"use strict";return{"addFilter":F.createAddChangeHandler(),"removeFilter":F.createRemoveChangeHandler(),"moveFilter":F.createMoveChangeHandler(),"addCondition":C.addCondition,"removeCondition":C.removeCondition,"addPropertyInfo":P.addPropertyInfo};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/FilterItemFlex',['./ItemBaseFlex'],function(I){"use strict";var f=Object.assign({},I);
f.findItem=function(m,F,n){return F.find(function(o){var s;if(m.targets==="jsControlTree"){s=o.getFieldPath();}else{s=o.getAttribute("conditions");if(s){var e,S=s.indexOf("/conditions/");if(S>=0){s=s.slice(S+12);e=s.indexOf("}");if(e>=0){s=s.slice(0,e);}}}}return s===n;});};
f.beforeApply=function(c){if(c.applyConditionsAfterChangesApplied){c.applyConditionsAfterChangesApplied();}};
f.addFilter=f.createAddChangeHandler();f.removeFilter=f.createRemoveChangeHandler();f.moveFilter=f.createMoveChangeHandler();return f;},true);
sap.ui.predefine('sap/ui/mdc/flexibility/GroupFlex',["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F){"use strict";var r=function(c){var e=c&&c.isA&&c.isA("sap.ui.mdc.Table")&&c.isTableBound();var E=c&&c.isA&&c.isA("sap.ui.mdc.Chart");if(e||E){if(!c._bWaitForBindChanges){c._bWaitForBindChanges=true;F.waitForChanges({element:c}).then(function(){if(e){c.rebind();}else if(E){c.rebind();}delete c._bWaitForBindChanges;});}}};var f=function(c,C,g,i){if(i){c.resetRevertData();}else{c.setRevertData(g);}r(C);};var a=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var o=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"groupConditions")).then(function(g){var v=g?g.groupLevels:[];var e={name:o.name};v.splice(o.index,0,e);g={groupLevels:v};M.setProperty(C,"groupConditions",g);f(c,C,e,i);b();}).catch(function(e){d(e);});});};var R=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"groupConditions")).then(function(g){var v=g?g.groupLevels:[];if(!v){d();}var h=v.filter(function(o){return o.name===e.name;});var I=v.indexOf(h[0]);v.splice(I,1);g={groupLevels:v};M.setProperty(C,"groupConditions",g);f(c,C,e,i);b();}).catch(function(E){d(E);});});};var m=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"groupConditions")).then(function(g){var v=g?g.groupLevels:[];var h=v.filter(function(o){return o.name===e.name;});var O=v.indexOf(h[0]);v.splice(e.index,0,v.splice(O,1)[0]);g={groupLevels:v};M.setProperty(C,"groupConditions",g);f(c,C,e,i);b();}).catch(function(E){d(E);});});};var G={};G.removeGroup={"changeHandler":{applyChange:function(c,C,p){return R(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return a(c,C,p,true);}},"layers":{"USER":true}};G.addGroup={"changeHandler":{applyChange:function(c,C,p){return a(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return R(c,C,p,true);}},"layers":{"USER":true}};G.moveGroup={"changeHandler":{applyChange:function(c,C,p){return m(c,C,p);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return m(c,C,p,true);}},"layers":{"USER":true}};return G;});
sap.ui.predefine('sap/ui/mdc/flexibility/ItemBaseFlex',["sap/ui/fl/changeHandler/Base","sap/ui/mdc/p13n/Engine","sap/base/Log"],function(F,E,L){"use strict";var I={_bSupressFlickering:true,beforeAddItem:function(D,d,c,p){return D.addItem.call(D,d,c,p);},afterRemoveItem:function(D,i,c,p){return D.removeItem.call(D,i,c,p);},findItem:function(m,d,n){return Promise.resolve();},beforeApply:function(c,C,i){return;},afterApply:function(c,C,i){return;},determineAggregation:function(m,c){var d;return Promise.resolve().then(m.getControlMetadata.bind(m,c)).then(function(M){d=M.getDefaultAggregation().name;return m.getAggregation(c,d);}).then(function(D){return{name:d,items:D};});},_getExistingAggregationItem:function(c,p,C){var m=p.modifier;return this.determineAggregation(m,C).then(function(a){var e,A=a.items;if(A){e=this.findItem(m,A,c.name);}return e;}.bind(this));},_getDelegate:function(d){return new Promise(function(r,R){sap.ui.require([d],r,R);});},_getOperationText:function(i){return i?"reverted ":"applied ";},_getChangeTypeText:function(a){return a?"add":"remove";},_delayInvalidate:function(c){if(c&&c.isInvalidateSuppressed&&!c.isInvalidateSuppressed()){c.iSuppressInvalidate=1;E.getInstance().waitForChanges(c).then(function(){c.iSuppressInvalidate=0;c.invalidate();});}},_applyAdd:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}var m=p.modifier,o=i?c.getRevertData():c.getContent();var d=o.name;var a;var D;var A;var b=this.determineAggregation(m,C).then(function(r){A=r;D=A.items;a=o.index>-1?o.index:D.length;return this._getExistingAggregationItem(o,p,C);}.bind(this)).then(function(e){if(e){return e;}else{return m.getProperty(C,"delegate").then(function(f){return this._getDelegate(f.name);}.bind(this)).then(function(f){return this.beforeAddItem(f,d,C,p,o);}.bind(this)).then(function(r){return r;});}}.bind(this)).then(function(e){if(!e){throw new Error("No item in"+A.name+"  created. Change to "+this._getChangeTypeText(!i)+"cannot be "+this._getOperationText(i)+"at this moment");}if(D.indexOf(e)<0){m.insertAggregation(C,A.name,e,a);}else{L.warning("The specified change is already existing - change appliance ignored");}return e;}.bind(this)).then(function(){if(i){c.resetRevertData();}else{c.setRevertData({name:o.name,index:a});}this.afterApply(c.getChangeType(),C,i);}.bind(this));return b;},_applyRemove:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}var m=p.modifier,o=i?c.getRevertData():c.getContent();var a;var b;var d;var e=this.determineAggregation(m,C).then(function(D){a=D;return this._getExistingAggregationItem(o,p,C);}.bind(this)).then(function(r){d=r;if(!d){if(i){throw new Error("No item found in "+a.name+". Change to "+this._getChangeTypeText(i)+"cannot be "+this._getOperationText(i)+"at this moment");}else{L.warning("The specified change is already existing - change appliance ignored");}return-1;}return m.findIndexInParentAggregation(d);}.bind(this)).then(function(f){b=f;return m.removeAggregation(C,a.name,d);}).then(function(){return m.getProperty(C,"delegate").then(function(D){return this._getDelegate(D.name);}.bind(this)).then(function(D){return this.afterRemoveItem(D,d,C,p).then(function(f){if(f&&d){m.destroy(d);}this.afterApply(c.getChangeType(),C,i);}.bind(this));}.bind(this));}.bind(this)).then(function(){if(i){c.resetRevertData();}else{c.setRevertData({name:o.name,index:b});}});return e;},_applyMove:function(c,C,p,i){this.beforeApply(c.getChangeType(),C,i);if(this._bSupressFlickering){this._delayInvalidate(C);}var m=p.modifier;var o=i?c.getRevertData():c.getContent();var a;var A;var O;var b=this.determineAggregation(m,C).then(function(r){A=r;return this._getExistingAggregationItem(o,p,C);}.bind(this)).then(function(r){a=r;}).then(function(){if(!a){throw new Error("No corresponding item in "+A.name+" found. Change to move item cannot be "+this._getOperationText(i)+"at this moment");}return m.findIndexInParentAggregation(a);}.bind(this)).then(function(r){O=r;if(C.moveColumn){return C.moveColumn(a,o.index);}else{return m.removeAggregation(C,A.name,a).then(function(){return m.insertAggregation(C,A.name,a,o.index);});}}).then(function(){if(i){c.resetRevertData();}else{c.setRevertData({name:o.name,index:O});}this.afterApply(c.getChangeType(),C,i);}.bind(this));return b;},_removeIndexFromChange:function(c){delete c.getContent().index;},createChangeHandler:function(a,c,r){return{"changeHandler":{applyChange:function(C,o,p){return a(C,o,p);},completeChangeContent:function(C,m,p){c(C,m,p);},revertChange:function(C,o,p){return r(C,o,p,true);}},"layers":{"USER":true}};},createAddChangeHandler:function(){var a=this._applyAdd.bind(this);var c=function(){};var r=this._applyRemove.bind(this);return this.createChangeHandler(a,c,r);},createRemoveChangeHandler:function(){var a=this._applyRemove.bind(this);var c=this._removeIndexFromChange.bind(this);var r=this._applyAdd.bind(this);return this.createChangeHandler(a,c,r);},createMoveChangeHandler:function(){var a=this._applyMove.bind(this);var c=function(){};var r=a;return this.createChangeHandler(a,c,r);}};return I;});
sap.ui.predefine('sap/ui/mdc/flexibility/Panel.flexibility',['sap/ui/fl/changeHandler/Base','./ItemBaseFlex'],function(B,I){"use strict";var l=Object.assign({},I);
l.findItem=function(m,a,n){return Promise.resolve(sap.ui.getCore().byId(n));};
return{createChanges:function(p,d){var n=d.filter(function(D){return!sap.ui.getCore().byId(D.id);});var N={};return n.reduce(function(r,D){if(!N[D.id]){N[D.id]=true;r.push(D);}return r;},[]).map(function(D){return{selectorElement:p,changeSpecificData:{changeType:"createItem",content:{selector:D.id}}};});},createItem:{layers:{USER:true},changeHandler:{applyChange:function(c,p,P){var s=c.getContent().selector;return Promise.resolve().then(function(){p.getModel();return P.modifier.getProperty(p,"metadataHelperPath");}).then(function(m){return new Promise(function(r,a){sap.ui.require(['sap/ui/mdc/link/PanelItem',m],function(b,M){r(M);},function(e){a(e);});});}).then(function(M){var m=P.modifier;if(m.bySelector(s,P.appComponent,P.view)){return undefined;}var a=M.retrieveAllMetadata(p);var i;var f=function(b,d){var F=-1;d.some(function(o,e){if(o.getId()===b){F=e;return true;}});return F;};var b=m.getControlIdBySelector(s,P.appComponent);return Promise.resolve().then(m.getAggregation.bind(m,p,"items")).then(function(d){i=-1;var o=null;a.some(function(e){var g=f(e.id,d);if(g>-1){i=g;}if(e.id===b){o=e;return true;}});if(!o){return undefined;}return m.createControl("sap.ui.mdc.link.PanelItem",P.appComponent,P.view,o.id,{text:o.text,description:o.description,href:o.href,target:o.target,icon:o.icon,visible:true});}).then(function(o){return m.insertAggregation(p,"items",o,i+1);});});},revertChange:function(c,p,P){var m=P.modifier;if(c.getContent()&&c.getContent().selector){var i=c.getContent().selector.id;var o=m.bySelector(i,P.appComponent,P.view);if(!o){return B.markAsNotApplicable("revertChange of createItem: the item with id "+i+" is not existing and therefore can not be removed.",true);}return Promise.resolve().then(m.removeAggregation.bind(m,p,"items",o));}},completeChangeContent:function(c,s,p){if(s.content){var S=p.modifier.getSelector(s.content.selector,p.appComponent);var C=c.getDefinition();C.content={selector:S};}}}}};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/PanelItem.flexibility',["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl"],function(H,U){"use strict";return{createChanges:function(d){return d.map(function(D){var c=sap.ui.getCore().byId(D.id);if(!c){throw new Error("Invalid 'id'. For the id "+D.id+" no existing control could be found");}return{selectorElement:c,changeSpecificData:{changeType:D.visible?"revealItem":"hideItem"}};});},revealItem:{layers:{USER:true},changeHandler:U},hideItem:{layers:{USER:true},changeHandler:H}};},true);
sap.ui.predefine('sap/ui/mdc/flexibility/PropertyInfoFlex',['sap/base/util/merge'],function(m){"use strict";var q=function(c,t){var C=function(b){if(c._pQueue===b){delete c._pQueue;}};c._pQueue=c._pQueue instanceof Promise?c._pQueue.then(t):t();c._pQueue.then(C.bind(null,c._pQueue));return c._pQueue;};var a=function(c,C,o,P){return q(o,function(){var M=P.modifier;return M.getProperty(o,"propertyInfo").then(function(b){var d=m([],b);var n=d.findIndex(function(e){return e.name===C.name;});if(n<0){d.push({name:C.name,dataType:C.dataType,maxConditions:C.maxConditions,constraints:C.constraints,formatOptions:C.formatOptions,required:C.required,caseSensitive:C.caseSensitive,display:C.display});M.setProperty(o,"propertyInfo",d);c.setRevertData({name:C.name});}});});};var r=function(c,C,o,P){return q(o,function(){var M=P.modifier;return M.getProperty(o,"propertyInfo").then(function(b){var d=m([],b);var n=d.findIndex(function(e){return e.name===C.name;});if(n>=0){d.splice(n,1);M.setProperty(o,"propertyInfo",d);}});});};var p={};p.addPropertyInfo={"changeHandler":{applyChange:function(c,C,P){return a(c,c.getContent(),C,P);},completeChangeContent:function(c,C,P){},revertChange:function(c,C,P){return r(c,c.getRevertData(),C,P).then(function(){c.resetRevertData();});}},"layers":{"USER":true}};return p;});
sap.ui.predefine('sap/ui/mdc/flexibility/SortFlex',["sap/ui/mdc/p13n/Engine"],function(E){"use strict";var r=function(c){var e=c&&c.isA&&c.isA("sap.ui.mdc.Table")&&c.isTableBound();var b=c&&c.isA&&(c.isA("sap.ui.mdc.Chart"));if(e||b){if(!c._bWaitForBindChanges){c._bWaitForBindChanges=true;E.getInstance().waitForChanges(c).then(function(){if(e){c.rebind();}else if(b){c.rebind();}delete c._bWaitForBindChanges;});}}};var f=function(c,C,s,i){if(i){c.resetRevertData();}else{c.setRevertData(s);}r(C);};var a=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var o=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"sortConditions")).then(function(s){var v=s?s.sorters:[];var e={name:o.name,descending:o.descending};v.splice(o.index,0,e);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();}).catch(function(e){d(e);});});};var R=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"sortConditions")).then(function(s){var v=s?s.sorters:[];if(!v){d();}var F=v.filter(function(o){return o.name===e.name;});var I=v.indexOf(F[0]);v.splice(I,1);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();}).catch(function(o){d(o);});});};var m=function(c,C,p,i){return new Promise(function(b,d){var M=p.modifier;var e=i?c.getRevertData():c.getContent();Promise.resolve().then(M.getProperty.bind(M,C,"sortConditions")).then(function(s){var v=s?s.sorters:[];var F=v.filter(function(o){return o.name===e.name;});var O=v.indexOf(F[0]);v.splice(e.index,0,v.splice(O,1)[0]);s={sorters:v};M.setProperty(C,"sortConditions",s);f(c,C,e,i);b();}).catch(function(o){d(o);});});};var S={};S.removeSort={"changeHandler":{applyChange:function(c,C,p){return R(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return a(c,C,p,true);}},"layers":{"USER":true}};S.addSort={"changeHandler":{applyChange:function(c,C,p){return a(c,C,p,false);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return R(c,C,p,true);}},"layers":{"USER":true}};S.moveSort={"changeHandler":{applyChange:function(c,C,p){return m(c,C,p);},completeChangeContent:function(c,C,p){},revertChange:function(c,C,p){return m(c,C,p,true);}},"layers":{"USER":true}};return S;});
sap.ui.predefine('sap/ui/mdc/flexibility/Table.flexibility',['./SortFlex','./ColumnFlex','./ConditionFlex','./GroupFlex','./AggregateFlex','./AggregationConfigFlex'],function(S,C,a,G,A,b){"use strict";return{"hideControl":"default","unhideControl":"default",addColumn:C.createAddChangeHandler(),removeColumn:C.createRemoveChangeHandler(),moveColumn:C.createMoveChangeHandler(),removeSort:S.removeSort,addSort:S.addSort,moveSort:S.moveSort,addCondition:a.addCondition,removeCondition:a.removeCondition,removeGroup:G.removeGroup,addGroup:G.addGroup,moveGroup:G.moveGroup,removeAggregate:A.removeAggregate,addAggregate:A.addAggregate,setColumnWidth:b.createSetChangeHandler({aggregation:"columns",property:"width"})};});
sap.ui.predefine('sap/ui/mdc/flp/FlpLinkDelegate',["sap/ui/mdc/LinkDelegate","sap/ui/mdc/link/LinkItem","sap/ui/mdc/link/Factory","sap/ui/mdc/link/Log","sap/base/Log","sap/base/util/isPlainObject","sap/ui/mdc/link/SemanticObjectMapping","sap/ui/mdc/link/SemanticObjectMappingItem","sap/ui/mdc/link/SemanticObjectUnavailableAction"],function(L,a,F,b,S,i,c,d,e){"use strict";var f=Object.assign({},L);
f.fetchLinkItems=function(p,B,I){var C=B?B.getObject(B.getPath()):undefined;var g=[];if(I){I.initialize(f._getSemanticObjects(p));g.forEach(function(o){I.addIntent(b.IntentType.API,{text:o.getText(),intent:o.getHref()});});}var s=f._calculateSemanticAttributes(C,p,I);return f._retrieveNavigationTargets("",s,p,I).then(function(l,o){return Promise.resolve(l);});};
f.fetchLinkType=function(p){var s={};var P=null;var h=function(g){return g.filter(function(j){return!s[j];}).length===0;};var A=function(g){return g.some(function(j){return s[j]&&(s[j].exists===true);});};var r=function(){if(!P){P=new Promise(function(g){var C=F.getService("CrossApplicationNavigation");if(!C){S.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' could not be obtained");g({});return;}C.getDistinctSemanticObjects().then(function(D){D.forEach(function(j){s[j]={exists:true};});P=null;return g(s);},function(){S.error("FlpLinkDelegate: getDistinctSemanticObjects() of service 'CrossApplicationNavigation' failed");return g({});});});}return P;};var H=function(g){if(h(g)){return Promise.resolve(A(g));}return r().then(function(){return A(g);});};if(p&&p.semanticObjects){return H(p.semanticObjects).then(function(g){return Promise.resolve({type:g?2:0,directLink:undefined});});}else{throw new Error("no payload or semanticObjects found");}};
f._calculateSemanticAttributes=function(C,p,I){var s=f._getSemanticObjects(p);var m=f._convertSemanticObjectMapping(f._getSemanticObjectMappings(p));if(!s.length){s.push("");}var r={};s.forEach(function(g){if(I){I.addContextObject(g,C);}r[g]={};for(var A in C){var o=null,t=null;if(I){o=I.getSemanticObjectAttribute(g,A);if(!o){o=I.createAttributeStructure();I.addSemanticObjectAttribute(g,A,o);}}if(C[A]===undefined||C[A]===null){if(o){o.transformations.push({value:undefined,description:"\u2139 Undefined and null values have been removed in FlpLinkDelegate."});}continue;}if(i(C[A])){if(o){o.transformations.push({value:undefined,description:"\u2139 Plain objects has been removed in FlpLinkDelegate."});}continue;}var h=(m&&m[g]&&m[g][A])?m[g][A]:A;if(o&&A!==h){t={value:undefined,description:"\u2139 The attribute "+A+" has been renamed to "+h+" in FlpLinkDelegate.",reason:"\ud83d\udd34 A com.sap.vocabularies.Common.v1.SemanticObjectMapping annotation is defined for semantic object "+g+" with source attribute "+A+" and target attribute "+h+". You can modify the annotation if the mapping result is not what you expected."};}if(r[g][h]){S.error("FlpLinkDelegate: The attribute "+A+" can not be renamed to the attribute "+h+" due to a clash situation. This can lead to wrong navigation later on.");}r[g][h]=C[A];if(o){if(t){o.transformations.push(t);var j=I.createAttributeStructure();j.transformations.push({value:C[A],description:"\u2139 The attribute "+h+" with the value "+C[A]+" has been added due to a mapping rule regarding the attribute "+A+" in FlpLinkDelegate."});I.addSemanticObjectAttribute(g,h,j);}}}});return r;};
f._retrieveNavigationTargets=function(A,s,p,I){if(!p.semanticObjects){return new Promise(function(r){r([]);});}var g=p.semanticObjects;var h=p.sourceControl;var N={ownNavigation:undefined,availableActions:[]};return sap.ui.getCore().loadLibrary('sap.ui.fl',{async:true}).then(function(){return new Promise(function(r){sap.ui.require(['sap/ui/fl/Utils'],function(U){var C=F.getService("CrossApplicationNavigation");var u=F.getService("URLParsing");if(!C||!u){S.error("FlpLinkDelegate: Service 'CrossApplicationNavigation' or 'URLParsing' could not be obtained");return r(N.availableActions,N.ownNavigation);}var o=sap.ui.getCore().byId(h);var j=U.getAppComponentForControl(o);var P=g.map(function(k){return[{semanticObject:k,params:s?s[k]:undefined,appStateKey:A,ui5Component:j,sortResultsBy:"text"}];});return new Promise(function(){C.getLinks(P).then(function(l){if(!l||!l.length){return r(N.availableActions,N.ownNavigation);}var k=f._getSemanticObjectUnavailableActions(p);var m=f._convertSemanticObjectUnavailableAction(k);var q=C.hrefForExternal();if(q&&q.indexOf("?")!==-1){q=q.split("?")[0];}if(q){q+="?";}var t=function(w,x){return!!m&&!!m[w]&&m[w].indexOf(x)>-1;};var v=function(w){var x=u.parseShellHash(w.intent);if(t(x.semanticObject,x.action)){return;}var H=C.hrefForExternal({target:{shellHash:w.intent}},j);if(w.intent&&w.intent.indexOf(q)===0){N.ownNavigation=new a({href:H,text:w.text});return;}var y=new a({key:(x.semanticObject&&x.action)?(x.semanticObject+"-"+x.action):undefined,text:w.text,description:undefined,href:H,icon:undefined,initiallyVisible:(w.tags&&w.tags.indexOf("superiorAction")>-1)});N.availableActions.push(y);if(I){I.addSemanticObjectIntent(x.semanticObject,{intent:y.getHref(),text:y.getText()});}};for(var n=0;n<g.length;n++){l[n][0].forEach(v);}return r(N.availableActions,N.ownNavigation);},function(){S.error("FlpLinkDelegate: '_retrieveNavigationTargets' failed executing getLinks method");return r(N.availableActions,N.ownNavigation);});});});});});};
f._getSemanticObjects=function(p){return p.semanticObjects?p.semanticObjects:[];};
f._getSemanticObjectUnavailableActions=function(p){var s=[];if(p.semanticObjectUnavailableActions){p.semanticObjectUnavailableActions.forEach(function(o){s.push(new e({semanticObject:o.semanticObject,actions:o.actions}));});}return s;};
f._getSemanticObjectMappings=function(p){var s=[];var g=[];if(p.semanticObjectMappings){p.semanticObjectMappings.forEach(function(o){g=[];if(o.items){o.items.forEach(function(h){g.push(new d({key:h.key,value:h.value}));});}s.push(new c({semanticObject:o.semanticObject,items:g}));});}return s;};
f._convertSemanticObjectMapping=function(s){if(!s.length){return undefined;}var m={};s.forEach(function(o){if(!o.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+o.getSemanticObject()+"' is not valid");}m[o.getSemanticObject()]=o.getItems().reduce(function(M,I){M[I.getKey()]=I.getValue();return M;},{});});return m;};
f._convertSemanticObjectUnavailableAction=function(s){if(!s.length){return undefined;}var m={};s.forEach(function(o){if(!o.getSemanticObject()){throw Error("FlpLinkDelegate: 'semanticObject' property with value '"+o.getSemanticObject()+"' is not valid");}m[o.getSemanticObject()]=o.getActions();});return m;};
return f;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetails',['sap/ui/core/XMLComposite','sap/m/Text','sap/m/Link','sap/m/Label'],function(X,T,L,c){"use strict";
var C=X.extend("sap.ui.mdc.link.ContactDetails",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.ContactDetailsItem",multiple:true,singularName:"item"}}}});
C.prototype.applySettings=function(){X.prototype.applySettings.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var v=this._getCompositeAggregation();v.getItems().forEach(function(s,i){this._addEmailsToSimpleForm(this.getItems()[i],s,r);this._addPhonesToSimpleForm(this.getItems()[i],s,r);this._addAddressesToSimpleForm(this.getItems()[i],s,r);},this);};
C.prototype._addEmailsToSimpleForm=function(o,s,r){o.getEmails().filter(function(a){return!a.processed&&!!a.getTypes()&&(a.getTypes().indexOf("preferred")>-1||a.getTypes().indexOf("work")>-1);}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1&&b.getTypes().indexOf("preferred")<0){return-1;}if(b.getTypes().indexOf("preferred")>-1&&a.getTypes().indexOf("preferred")<0){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("email",r.getText("info.POPOVER_CONTACT_SECTION_EMAIL"),a,s);a.processed=true;},this);};
C.prototype._addPhonesToSimpleForm=function(o,s,r){o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("work")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_PHONE"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("cell")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_MOBILE"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("fax")>-1;}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1){return-1;}if(b.getTypes().indexOf("preferred")>-1){return 1;}return 0;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_FAX"),a,s);a.processed=true;},this);o.getPhones().filter(function(a){return!a.processed&&!!a.getTypes()&&a.getTypes().indexOf("preferred")>-1;}).forEach(function(a){this._addLabeledLink("phone",r.getText("info.POPOVER_CONTACT_SECTION_PHONE"),a,s);a.processed=true;},this);};
C.prototype._addAddressesToSimpleForm=function(o,s,r){o.getAddresses().filter(function(a){return!a.processed&&!!a.getTypes()&&(a.getTypes().indexOf("preferred")>-1||a.getTypes().indexOf("work")>-1);}).sort(function(a,b){if(a.getTypes().indexOf("preferred")>-1&&b.getTypes().indexOf("preferred")<0){return-1;}if(b.getTypes().indexOf("preferred")>-1&&a.getTypes().indexOf("preferred")<0){return 1;}return 0;}).forEach(function(a){this._addLabeledAddress(a,s,r);a.processed=true;},this);};
C.prototype._addLabeledAddress=function(o,s,r){var a=function(S,d,e,R,f){var v=[];if(S){v.push(S);}if(d&&e){v.push(d+" "+e);}else{if(d){v.push(d);}if(e){v.push(e);}}if(R){v.push(R);}if(f){v.push(f);}return v.join(', ');};var A=function(S,d,e,R,f){return!!(S||d||e||R||f);};var p;var b;if(o.getBindingPath("street")&&o.getBindingPath("code")&&o.getBindingPath("locality")&&o.getBindingPath("region")&&o.getBindingPath("country")){p=[{path:o.getBindingPath("street")?o.getBindingPath("street"):"$notExisting"},{path:o.getBindingPath("code")?o.getBindingPath("code"):"$notExisting"},{path:o.getBindingPath("locality")?o.getBindingPath("locality"):"$notExisting"},{path:o.getBindingPath("region")?o.getBindingPath("region"):"$notExisting"},{path:o.getBindingPath("country")?o.getBindingPath("country"):"$notExisting"}];b=new T();b.bindProperty("text",{parts:p,formatter:a});b.bindProperty("visible",{parts:p,formatter:A});}else{b=new T({text:a(o.getStreet(),o.getCode(),o.getLocality(),o.getRegion(),o.getCountry()),visible:A(o.getStreet(),o.getCode(),o.getLocality(),o.getRegion(),o.getCountry())});}var l=new c({text:r.getText("info.POPOVER_CONTACT_SECTION_ADR"),labelFor:b.getId()});s.addContent(l);s.addContent(b);};
C.prototype._addLabeledLink=function(l,s,o,S){var a;if(o.getBindingPath("uri")){a=new L();a.bindProperty("href",{path:o.getBindingPath("uri"),formatter:function(v){return(l==="email"?"mailto:":"tel:")+v;}});a.bindProperty("text",{path:o.getBindingPath("uri")});a.bindProperty("visible",{path:o.getBindingPath("uri"),formatter:function(v){return!!v;}});}else{a=new L({href:l==="email"?"mailto:":"tel:"+o.getUri(),text:o.getUri(),visible:!!o.getUri()});}var b=new c({text:s,labelFor:a.getId()});S.addContent(b);S.addContent(a);};
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsAddressItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsAddressItem",{metadata:{library:"sap.ui.mdc",properties:{street:{type:"string"},code:{type:"string"},locality:{type:"string"},region:{type:"string"},country:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsAddressType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsEmailItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsEmailItem",{metadata:{library:"sap.ui.mdc",properties:{uri:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsEmailType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsItem",{metadata:{library:"sap.ui.mdc",properties:{sectionTitle:{type:"string",defaultValue:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.POPOVER_CONTACT_SECTION_TITLE")},photo:{type:"string"},formattedName:{type:"string"},role:{type:"string"},title:{type:"string"},org:{type:"string"},parameters:{type:"object"}},defaultAggregation:"emails",aggregations:{emails:{type:"sap.ui.mdc.link.ContactDetailsEmailItem",multiple:true,singularName:"email"},phones:{type:"sap.ui.mdc.link.ContactDetailsPhoneItem",multiple:true,singularName:"phone"},addresses:{type:"sap.ui.mdc.link.ContactDetailsAddressItem",multiple:true,singularName:"address"}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/ContactDetailsPhoneItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.link.ContactDetailsPhoneItem",{metadata:{library:"sap.ui.mdc",properties:{uri:{type:"string"},types:{type:"sap.ui.mdc.ContactDetailsPhoneType[]",defaultValue:[]}}}});
return C;});
sap.ui.predefine('sap/ui/mdc/link/Factory',[],function(){"use strict";return{getService:function(s){switch(s){case"CrossApplicationNavigation":return sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("CrossApplicationNavigation");case"URLParsing":return sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("URLParsing");default:return null;}}};});
sap.ui.predefine('sap/ui/mdc/link/LinkItem',['sap/ui/core/Element'],function(E){"use strict";
var L=E.extend("sap.ui.mdc.link.LinkItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string"},target:{type:"string",defaultValue:"_self"},icon:{type:"string"},initiallyVisible:{type:"boolean",defaultValue:false}}}});
return L;});
sap.ui.predefine('sap/ui/mdc/link/Log',['sap/ui/base/Object','sap/base/util/isEmptyObject'],function(B,c){"use strict";
var L=B.extend("sap.ui.mdc.link.Log",{constructor:function(){this.reset();}});
L.prototype.reset=function(){this._oLog={semanticObjects:{},intents:{api:[],breakout:[]}};return this;};
L.prototype.isEmpty=function(){return!(!c(this._oLog.semanticObjects)||this._oLog.intents.breakout.length||this._oLog.intents.api.length);};
L.prototype.initialize=function(s){this.reset();s.forEach(function(S){this.createSemanticObjectStructure(S);}.bind(this));};
L.prototype.addContextObject=function(s,C){for(var a in C){var A=this.createAttributeStructure();this.addSemanticObjectAttribute(s,a,A);A.transformations.push({value:C[a],description:"\u2139 The attribute "+a+" with the value "+C[a]+" is initially taken from the binding context."});}};
L.prototype.createSemanticObjectStructure=function(s){this._oLog.semanticObjects[s]={attributes:{},intents:[]};};
L.prototype.createAttributeStructure=function(){return{transformations:[]};};
L.prototype.addSemanticObjectIntent=function(s,i){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].intents.push(i);return this;};
L.prototype.addSemanticObjectAttribute=function(s,a,A){if(!this._oLog.semanticObjects[s]){this.createSemanticObjectStructure(s);}this._oLog.semanticObjects[s].attributes[a]=A;return this;};
L.prototype.getSemanticObjectAttribute=function(s,a){return(this._oLog.semanticObjects[s]&&this._oLog.semanticObjects[s].attributes[a])?this._oLog.semanticObjects[s].attributes[a]:undefined;};
L.prototype.addIntent=function(t,i){switch(t){case L.IntentType.API:this._oLog.intents.api.push(i);break;case L.IntentType.BREAKOUT:this._oLog.intents.breakout.push(i);break;default:throw"Intent type "+t+" is not supported yet.";}return this;};
L.prototype.getFormattedText=function(){var g=function(v){return(typeof v==="string")?"'"+v+"'":v;};var r=function(a,A){var o={value:"\u2022\u0020"+A+" : ",description:""};a.forEach(function(b,I){o.value=o.value+(I>0?"\u0020 \u279c \u0020":"")+g(b["value"]);o.description=o.description+"\u2026 \u0020 "+b["description"]+"\n";if(b["reason"]){o.description=o.description+"\u2026 \u0020 "+b["reason"]+"\n";}});return o;};var R=function(I){var a="";I.forEach(function(o){a+="\u2022\u0020'"+o.text+"' : "+o.intent+"\n";});return a;};var s=function(e){try{var l=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){var C=window.Intl.Collator(l,{numeric:true});e.sort(function(a,b){return C.compare(a,b);});}else{e.sort(function(a,b){return a.localeCompare(b,l,{numeric:true});});}}catch(E){}};var t="";for(var S in this._oLog.semanticObjects){t=t+"\n\u2b24"+" "+S+"\n";if(c(this._oLog.semanticObjects[S].attributes)){t+="\u2026\u2026 \u0020\ud83d\udd34 No semantic attributes available for semantic object "+S+". Please be aware "+"that without semantic attributes no URL parameters can be created.\n";}else{var d=Object.keys(this._oLog.semanticObjects[S].attributes);s(d);for(var i=0;i<d.length;i++){var A=d[i];var T=r(this._oLog.semanticObjects[S].attributes[A].transformations,A);t+=T.value+"\n";t+=T.description;}}if(this._oLog.semanticObjects[S].intents.length){t+="\nIntents returned by FLP for semantic object "+S+":\n";t+=R(this._oLog.semanticObjects[S].intents);}}if(this._oLog.intents.api.length){t+="\nIntents defined in items aggregation:\n";t+=R(this._oLog.intents.api);}if(this._oLog.intents.breakout.length){t+="\nIntents returned by modifyItemsCallback callback:\n";t+=R(this._oLog.intents.breakout);}return t;};
L.prototype._getLogFormattedText=function(){return(!this.isEmpty())?"---------------------------------------------\nsap.ui.mdc.Link:\nBelow you can see detailed information regarding semantic attributes which have been calculated for one or more semantic objects defined in a Link control. Semantic attributes are used to create the URL parameters. Additionally you can see all links containing the URL parameters.\n"+this.getFormattedText():"No logging data available";};
L.IntentType={BREAKOUT:"Breakout",API:"Api"};return L;});
sap.ui.predefine('sap/ui/mdc/link/Panel',['sap/ui/core/XMLComposite','sap/base/Log','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/base/ManagedObjectObserver',"sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/ui/mdc/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem"],function(X,L,J,B,M,a,E,A,P){"use strict";
var b=X.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/link/Panel.designtime",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--idSectionAdditionalContent",aggregation:"items"}}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}}});
b.prototype.init=function(){X.prototype.init.call(this);E.getInstance().registerAdaptation(this,{controller:{LinkItems:a}});A.call(b.prototype);E.getInstance().defaultProviderRegistry.attach(this,"Global");sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(c){this._oMetadataHelper=c;}.bind(this));var m=new J({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,showResetEnabled:false,runtimeItems:[],contentTitle:""});m.setDefaultBindingMode(B.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapuimdclinkPanel");this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]});};
b.prototype.applySettings=function(){X.prototype.applySettings.apply(this,arguments);var m=this._getInternalModel();m.setProperty("/countAdditionalContent",this.getAdditionalContent().length);};
b.prototype.exit=function(c){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}if(this._oMetadataHelper){this._oMetadataHelper=null;}};
b.prototype.onPressLink=function(e){if(this.getBeforeNavigationCallback()&&e.getParameter("target")!=="_blank"){var h=e.getParameter("href");e.preventDefault();this.getBeforeNavigationCallback()(e).then(function(n){if(n){this.navigate(h);}}.bind(this));}};
b.prototype.navigate=function(h){if(h.indexOf("#")===0&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getServiceAsync){var t=this;if(!t.oNavigationPromise){t.oNavigationPromise=sap.ushell.Container.getServiceAsync("CrossApplicationNavigation").then(function(c){c.toExternal({target:{shellHash:h.substring(1)}});t.oNavigationPromise=undefined;});}}else{window.location.href=h;}};
b.prototype.onPressLinkPersonalization=function(){sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(c){var m=this._getInternalModel();var d=c.retrieveBaseline(this);var e=d;var u=function(s){var S=s._oListControl.getItems().filter(function(i){return i.getSelected();});S=S.map(function(o){var i=s._getP13nModel().getProperty(o.getBindingContext(s.P13N_MODEL).sPath);return{id:i.name,description:i.description,href:i.href,target:i.target,text:i.text,visible:i.visible};});var f=b._showResetButtonEnabled(e,S);this._getInternalModel().setProperty("/showResetEnabled",f);};var p=this.getParent();p.setModal(true);E.getInstance().uimanager.show(this,"LinkItems").then(function(D){var r=D.getCustomHeader().getContentRight()[0];var s=D.getContent()[0];r.setModel(m,"$sapuimdclinkPanel");r.bindProperty("enabled",{path:'$sapuimdclinkPanel>/showResetEnabled'});u.call(this,s);s.attachChange(function(o){u.call(this,s);}.bind(this));D.attachAfterClose(function(){p.setModal(false);});}.bind(this));}.bind(this));};
b._showResetButtonEnabled=function(m,s){var S=false;var c=b._getVisibleItems(s);var d=b._getVisibleItems(m);if(s.length!==m.length){S=true;}else if(d.length&&c.length){var e=b._allItemsIncludedInArray(d,c);var f=b._allItemsIncludedInArray(c,d);S=!e||!f;}return S;};
b._allItemsIncludedInArray=function(m,c){var d=true;m.forEach(function(i){var e=b._getItemsById(i.id,c);if(e.length===0){d=false;}});return d;};
b._getItemsById=function(i,m){return m.filter(function(I){return I.id===i;});};
b._getItemById=function(i,c){return b._getItemsById(i,c)[0];};
b._getVisibleItems=function(m){return m.filter(function(i){return i.id!==undefined&&i.visible;});};
b.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel");};
b.prototype._propagateDefaultIcon=function(s){if(!s){return;}var m=this._getInternalModel();m.getProperty("/runtimeItems").forEach(function(o,i){if(o.icon){return;}m.setProperty("/runtimeItems/"+i+"/icon","sap-icon://chain-link");});};
function _(c){var m=this._getInternalModel();if(c.object.isA("sap.ui.mdc.link.Panel")){switch(c.name){case"additionalContent":var d=c.child?[c.child]:c.children;m.setProperty("/countAdditionalContent",d.length);break;case"items":var i=c.child?[c.child]:c.children;i.forEach(function(p){var r=m.getProperty("/runtimeItems/");switch(c.mutation){case"insert":m.setProperty("/countItemsWithIcon",p.getIcon()?m.getProperty("/countItemsWithIcon")+1:m.getProperty("/countItemsWithIcon"));m.setProperty("/countItemsWithoutIcon",p.getIcon()?m.getProperty("/countItemsWithoutIcon"):m.getProperty("/countItemsWithoutIcon")+1);r.splice(this.indexOfItem(p),0,p.getJson());m.setProperty("/runtimeItems",r);this._propagateDefaultIcon(m.getProperty("/countItemsWithIcon")>0&&m.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(p,{properties:["visible"]});break;case"remove":m.setProperty("/countItemsWithIcon",p.getIcon()?m.getProperty("/countItemsWithIcon")-1:m.getProperty("/countItemsWithIcon"));m.setProperty("/countItemsWithoutIcon",p.getIcon()?m.getProperty("/countItemsWithoutIcon"):m.getProperty("/countItemsWithoutIcon")-1);var R=r.find(function(o){return o.id===p.getId();});r.splice(r.indexOf(R),1);m.setProperty("/runtimeItems",r);this._propagateDefaultIcon(m.getProperty("/countItemsWithIcon")>0&&m.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(p);p.destroy();this.invalidate();break;default:L.error("Mutation '"+c.mutation+"' is not supported yet.");}},this);break;case"enablePersonalization":this.byId("idSectionPersonalizationButton").setVisible(c.current);break;default:L.error("The property or aggregation '"+c.name+"' has not been registered.");}}else if(c.object.isA("sap.ui.mdc.link.PanelItem")){switch(c.name){case"visible":var p=c.object;var I=this.indexOfItem(p);if(p.getVisibleChangedByUser()){m.setProperty("/runtimeItems/"+I+"/visible",p.getVisible());}else{m.setProperty("/baselineItems/"+I+"/visible",p.getVisible());m.setProperty("/runtimeItems/"+I+"/visible",p.getVisible());}break;default:L.error("The '"+c.name+"' of PanelItem is not supported yet.");}}this._updateContentTitle();}
b.prototype.getContentTitle=function(){var m=this._getInternalModel();return m.getProperty("/contentTitle");};
b.prototype.getCurrentState=function(){var i=[],I;this.getItems().forEach(function(o,c){I=o&&o.getId();if(o.getVisible()){i.push({name:I});}});return{items:i};};
b.prototype.initPropertyHelper=function(){var c=this._oMetadataHelper.retrieveAllMetadata(this);return Promise.resolve({getProperties:function(){var i=[];c.forEach(function(I){i.push({name:I.id,getName:function(){return I.id;},getLabel:function(){return I.text;},text:I.text,href:I.href,description:I.description,target:I.target,visible:I.visible});});return i;}});};
b.prototype._updateContentTitle=function(){var m=this._getInternalModel();var c=this.getAdditionalContent();var C="idSectionPersonalizationButton";if(c.length>0){C=c[0];}else{var i=this.getItems();if(i.length>0){C=i[0];}}m.setProperty("/contentTitle",C);};
return b;});
sap.ui.predefine('sap/ui/mdc/link/PanelItem',['sap/ui/core/Element'],function(E){"use strict";
var P=E.extend("sap.ui.mdc.link.PanelItem",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/link/PanelItem.designtime",properties:{text:{type:"string"},description:{type:"string"},href:{type:"string"},target:{type:"string",defaultValue:undefined},icon:{type:"string"},visible:{type:"boolean",defaultValue:true},visibleChangedByUser:{type:"boolean"}}}});
P.prototype.getJson=function(){return{id:this.getId(),text:this.getText(),description:this.getDescription(),href:this.getHref(),icon:this.getIcon(),target:this.getTarget(),visible:this.getVisible(),visibleChangedByUser:this.getVisibleChangedByUser()};};
return P;});
sap.ui.predefine('sap/ui/mdc/link/PanelListItem',['sap/ui/core/XMLComposite'],function(X){"use strict";
var P=X.extend("sap.ui.mdc.link.PanelListItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},text:{type:"string"},description:{type:"string"},href:{type:"string"},icon:{type:"string"},target:{type:"string",defaultValue:undefined},visible:{type:"boolean",defaultValue:true}},events:{pressLink:{allowPreventDefault:true,parameters:{target:{type:"string"}}}}}});
P.prototype.onPress=function(e){if(!this.firePressLink({href:e.getSource().getHref(),target:e.getSource().getTarget()})){e.preventDefault();}};
return P;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectMapping',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectMapping",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.mdc.link.SemanticObjectMappingItem",multiple:true,singularName:"item"}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectMappingItem',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectMappingItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string"},value:{type:"any"}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/link/SemanticObjectUnavailableAction',['sap/ui/core/Element'],function(E){"use strict";
var S=E.extend("sap.ui.mdc.link.SemanticObjectUnavailableAction",{metadata:{library:"sap.ui.mdc",properties:{semanticObject:{type:"string"},actions:{type:"string[]",defaultValue:[]}}}});
return S;});
sap.ui.predefine('sap/ui/mdc/odata/json/FilterBarDelegate',["sap/ui/mdc/FilterBarDelegate",'sap/base/util/merge','sap/ui/mdc/util/IdentifierUtil'],function(F,m,I){"use strict";var J=Object.assign({},F);
J._createFilterField=function(p,f,P){var M=P.modifier;var n=p.path||p.name;var s={};if(f.getId){s.id=f.getId();}else{s.id=f.id;}var S=M.getControlIdBySelector(s,P.appComponent);var i=S+"--filter--"+I.replace(n);var o;return M.createControl("sap.ui.mdc.FilterField",P.appComponent,P.view,i,{dataType:p.typeConfig.className,conditions:"{$filters>/conditions/"+n+'}',required:p.required,label:p.label,maxConditions:p.maxConditions,delegate:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},true).then(function(c){o=c;if(p.fieldHelp){var a=p.fieldHelp;if(P.view.getId){a=P.view.getId()+"--"+p.fieldHelp;}else{a=P.viewId+"--"+p.fieldHelp;}M.setAssociation(o,"fieldHelp",a);}if(p.filterOperators){if(f.getId){return M.setProperty(o,"operators",p.filterOperators);}else{return M.setProperty(o,"operators",p.filterOperators.join(','));}}}).then(function(){if(p.tooltip){M.setProperty(o,"tooltip",p.tooltip);}if(p.constraints){M.setProperty(o,"dataTypeConstraints",p.constraints);}if(p.formatOptions){M.setProperty(o,"dataTypeFormatOptions",p.formatOptions);}if(p.display){M.setProperty(o,"display",p.display);}return o;});};
J.addItem=function(p,f,P){return J.fetchProperties().then(function(a){var o=null;a.some(function(b){if(p===I.getPropertyKey(b)){o=b;}return o!==null;});if(o){return J._createFilterField(o,f,P);}});};
J.removeItem=function(f,o,p){return Promise.resolve(true);};
J.fetchProperties=function(f){return new Promise(function(r,a){r([]);});};
return J;});
sap.ui.predefine('sap/ui/mdc/odata/v4/ChartDelegate',["../../ChartDelegate","../../util/loadModules","../../library","sap/ui/core/Core"],function(C,l,a,b){"use strict";var D=Object.assign({},C);return D;});
sap.ui.predefine('sap/ui/mdc/odata/v4/ChartPropertyHelper',["sap/ui/mdc/chart/PropertyHelper"],function(P){"use strict";
var a=P.extend("sap.ui.mdc.odata.v4.ChartPropertyHelper");
return a;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FieldBaseDelegate',["sap/ui/mdc/field/FieldBaseDelegate","sap/ui/mdc/odata/v4/TypeUtil"],function(F,T){"use strict";var O=Object.assign({},F);
O.getDataTypeClass=function(p,t){return T.getDataTypeClassName(t);};
O.getBaseType=function(p,t,f,c){return T.getBaseType(t,f,c);};
O.initializeTypeFromBinding=function(p,t,v){var r={};if(t&&(t.isA("sap.ui.model.odata.type.Unit")||t.isA("sap.ui.model.odata.type.Currency"))&&Array.isArray(v)&&v.length>2&&v[2]!==undefined){t.formatValue(v,"string");r.bTypeInitialized=true;r.mCustomUnits=v[2];}return r;};
O.initializeInternalUnitType=function(p,t,o){if(o&&o.mCustomUnits!==undefined){t.formatValue([null,null,o.mCustomUnits],"string");}};
O.enhanceValueForUnit=function(p,v,t){if(t&&t.bTypeInitialized&&v.length===2){v.push(t.mCustomUnits);return v;}};
O.getDefaultFieldValueHelpDelegate=function(p){return{name:"sap/ui/mdc/odata/v4/FieldValueHelpDelegate",payload:{}};};
O.getTypeUtil=function(p){return T;};
return O;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FieldValueHelpDelegate',['sap/ui/mdc/field/FieldValueHelpDelegate','sap/ui/model/FilterType','sap/ui/mdc/odata/v4/TypeUtil'],function(F,a,T){"use strict";var _=function(b){return new Promise(function(r){var c=false;var h=function(p){if(p.mParameters.detailedReason){return;}if(!c){c=true;b.detachEvent("change",h);r(p);}};b.attachEvent("change",h);b.attachEventOnce("dataReceived",h);});};var O=Object.assign({},F);
O.isSearchSupported=function(p,l){return!!l.changeParameters;};
O.executeSearch=function(p,l,s){if(s){l.changeParameters({$search:s});}else{l.changeParameters({$search:undefined});}return _(l);};
O.executeFilter=function(p,l,f,c,r){var b=_(l).then(function n(d){c();});l.initialize();l.filter(f,a.Application);l.getContexts(0,r);return b;};
O.checkBindingsPending=function(p,b){var P=[];for(var i=0;i<b.length;i++){var B=b[i];if(B&&B.requestValue){P.push(B.requestValue());}}if(P.length>0){return Promise.all(P);}return null;};
O.checkListBindingPending=function(p,l,L){if(!l||l.isSuspended()){return false;}return l.requestContexts(0,L&&L.length).then(function(c){return c.length>0;});};
O.getTypeUtil=function(p){return T;};
return O;});
sap.ui.predefine('sap/ui/mdc/odata/v4/FilterBarDelegate',['./ODataMetaModelUtil','sap/ui/mdc/enum/FieldDisplay',"sap/ui/fl/Utils","sap/ui/mdc/FilterBarDelegate",'sap/base/util/ObjectPath','sap/base/util/merge','sap/ui/mdc/odata/v4/TypeUtil','sap/ui/mdc/condition/FilterOperatorUtil',"sap/ui/model/FilterOperator","sap/ui/model/Filter",'sap/ui/mdc/util/IdentifierUtil','sap/ui/core/util/reflection/JsControlTreeModifier','sap/base/Log'],function(O,F,a,b,c,m,T,d,M,e,I,J,L){"use strict";var f=Object.assign({},b);var D={"Edm.Boolean":"Bool","Edm.Byte":"Int","Edm.DateTime":"Date","Edm.DateTimeOffset":"DateTimeOffset","Edm.Decimal":"Decimal","Edm.Double":"Float","Edm.Float":"Float","Edm.Guid":"Guid","Edm.Int16":"Int","Edm.Int32":"Int","Edm.Int64":"Int","Edm.SByte":"Int","Edm.Single":"Float","Edm.String":"String","Edm.Time":"TimeOfDay"};var g={};
f._fetchPropertiesByMetadata=function(C,p){var o,h,i,j,k;return Promise.resolve().then(function(){if(p){var l=p.modifier;return Promise.resolve().then(l.getProperty.bind(l,C,"delegate")).then(function(o){h=o.payload.modelName===null?undefined:o.payload.modelName;i=o.payload.collectionName;j=p.appComponent.getModel(h);});}o=C.getProperty("delegate");h=o.payload.modelName===null?undefined:o.payload.modelName;i=o.payload.collectionName;j=C.getModel(h);}).then(function(){k=C.getId?C.getId():C.id;var l={getDelegate:function(){return{payload:{modelName:h,collectionName:i}};},getModel:function(s){return j;},getId:function(){return k;}};return p?this.fetchProperties(l):C.getControlDelegate().fetchProperties(C);}.bind(this));};
f._ensureSingleRangeEQOperators=function(){var o;if(!d.getOperator("SINGLE_RANGE_EQ")){o=m({},d.getOperator("EQ"));o.name="SINGLE_RANGE_EQ";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GE,C.values[0]),new e(s,M.LE,C.values[0])],and:true});};d.addOperator(o);}if(!d.getOperator("SINGLE_RANGE_EQ")){o=m({},d.getOperator("EQ"));o.name="SINGLE_RANGE_EQ";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GE,C.values[0]),new e(s,M.LE,C.values[0])],and:true});};d.addOperator(o);}};
f._ensureMultiRangeBTEXOperator=function(){if(!d.getOperator("MULTI_RANGE_BTEX")){var o=m({},d.getOperator("BT"));o.name="MULTI_RANGE_BTEX";o.getModelFilter=function(C,s){return new e({filters:[new e(s,M.GT,C.values[0]),new e(s,M.LT,C.values[1])],and:true});};d.addOperator(o);}};
f._getFilterOperators=function(s){var o=null,h=null;switch(s){case"SingleValue":case"MultiValue":o="EQ";break;case"SingleRange":o="SINGLE_RANGE_EQ,SINGLE_RANGE_EQ,LE,GE";this._ensureSingleRangeEQOperators();break;case"MultiRange":o="EQ,LE,LT,GE,GT,BT,MULTI_RANGE_BTEX";this._ensureMultiRangeBTEXOperator();break;case"SearchExpression":o="StartsWith,EndsWith,Contains";break;case"MultiRangeOrSearchExpression":o="StartsWith,EndsWith,Contains,EQ,LE,LT,GE,GT,BT,MULTI_RANGE_BTEX";this._ensureMultiRangeBTEXOperator();break;default:break;}if(o){h=o.split(',');}return h;};
f._createFilterField=function(p,o,P){var h=P?P.modifier:J;var A=P?P.appComponent:a.getAppComponentForControl(o);var v=(P&&P.view)?P.view:a.getViewForControl(o);var V=P?P.viewId:null;var n=p.path||p.name;var s={};if(o.getId){s.id=o.getId();}else{s.id=o.id;}var S=h.getControlIdBySelector(s,A);var i=S+"--filter--"+I.replace(n);var E=sap.ui.getCore().byId(i);if(E){return Promise.resolve(E);}return Promise.resolve().then(h.createControl.bind(h,"sap.ui.mdc.FilterField",A,v,i,{dataType:p.typeConfig.className,conditions:"{$filters>/conditions/"+n+'}',required:p.required,label:p.label||p.name,maxConditions:p.maxConditions,delegate:{name:"sap/ui/mdc/odata/v4/FieldBaseDelegate",payload:{}}})).then(function(j){if(p.fieldHelp){var k=p.fieldHelp;if(!V){k=v.createId(p.fieldHelp);}else{k=V+"--"+p.fieldHelp;}h.setAssociation(j,"fieldHelp",k);}if(p.filterOperators){if(o.getId){h.setProperty(j,"operators",p.filterOperators);}else{h.setProperty(j,"operators",p.filterOperators.join(','));}}if(p.tooltip){h.setProperty(j,"tooltip",p.tooltip);}if(p.constraints){h.setProperty(j,"dataTypeConstraints",p.constraints);}if(p.formatOptions){h.setProperty(j,"dataTypeFormatOptions",p.formatOptions);}if(p.display){h.setProperty(j,"display",p.display);}return j;});};
f._createFilter=function(p,o,P){return this._fetchPropertiesByMetadata(o,P).then(function(h){var i=h.find(function(j){return(I.getPropertyKey(j)===p);});if(!i){return null;}return Promise.resolve(this._createFilterField(i,o,P));}.bind(this));};
f.addItem=function(p,o,P){return Promise.resolve(this._createFilter(p,o,P));};
f.removeItem=function(o,h,p){return Promise.resolve(true);};
f._getFieldGroupsByFilterFacetsAnnotation=function(o,E){};
f._getNavigationPropertyForParameter=function(E){var o;for(var k in E){o=E[k];if(o){if(o.$kind==="NavigationProperty"){return k;}}}return null;};
f._fetchPropertyInfo=function(o,E,n,h,k){var i=o.getObject(E+"/"+"@com.sap.vocabularies.UI.v1.TextArrangement");var H=false;if(o.getObject(E+"/"+k+"@com.sap.vocabularies.UI.v1.HiddenFilter")){H=true;}var j=false;if(o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.IsDigitSequence")){j=true;}var l=null;var p=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.FilterDefaultValue");if(p){var v=p["$"+D[h.$Type]];switch(h.$Type){case"Edm.DateTimeOffset":l=v;break;default:l=v;}}var q=false;if(o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.IsUpperCase")){q=true;}var s=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Label")||k;var t=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.QuickInfo")||null;var C={};if(h.$MaxLength||h.$Precision||h.$Scale||j){if(h.$MaxLength){C.maxLength=h.$MaxLength;}if(h.$Precision){C.precision=h.$Precision;}if(h.$Scale){C.scale=h.$Scale;}if(j){C.isDigitSequence=j;}}else{C=null;}var r,u=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Text");if(u){var w=o.getObject(E+"/"+k+"@com.sap.vocabularies.Common.v1.Text@com.sap.vocabularies.UI.v1.TextArrangement")||i;if(w){if(w.$EnumMember==="com.sap.vocabularies.UI.v1.TextArrangementType/TextOnly"){r=F.Description;}else if(w.$EnumMember==="com.sap.vocabularies.UI.v1.TextArrangementType/TextLast"){r=F.ValueDescription;}else{r=F.DescriptionValue;}}else{r=F.DescriptionValue;}}var P={name:k,label:s,tooltip:t,hiddenFilter:H,caseSensitive:!q};if(r){P.display=r;}if(C){P.constraints=C;}if(l){P.defaultFilterConditions=[{fieldPath:k,operator:"EQ",values:[l]}];}P.name=n?n+"/"+k:k;P.typeConfig=T.getTypeConfig(h.$Type,P.formatOptions,P.constraints);return P;};
f._fetchEntitySet=function(o,E,v,n,p){return Promise.all([o.requestObject(E+"/"),o.requestObject(E+"@")]).then(function(r){var h=r[0];var i=r[1]||{};if(!h){return Promise.resolve([]);}var j,P,k=[],l=[],N=[],R=[],s=[],A={},q={},t=false;var u=o.getObject(E);if(u&&u.$NavigationPropertyBinding){q=u.$NavigationPropertyBinding;}var w=i["@Org.OData.Capabilities.V1.FilterRestrictions"];if(w){if(w.NonFilterableProperties){N=w.NonFilterableProperties.map(function(C){return C.$PropertyPath;});}if(w.RequiredProperties){R=w.RequiredProperties.map(function(C){return C.$PropertyPath;});}if(w.FilterExpressionRestrictions){w.FilterExpressionRestrictions.forEach(function(C){A[C.Property.$PropertyPath]=C.AllowedExpressions;});}}w=o.getObject(E+"/"+"@com.sap.vocabularies.UI.v1.SelectionFields");if(w){s=w.map(function(C){return C.$PropertyPath;});}var x=o.getObject(E+"/@sapui.name");var G=x;var y=o.getObject(E+"@com.sap.vocabularies.Common.v1.Label");if(!y){y=G.split(".")[1];}v.push(x);w=o.getObject(E+"/"+"@com.sap.vocabularies.Common.v1.ResultContext");if(w){t=true;p.parameterNavigationName=f._getNavigationPropertyForParameter(h);}if(!n){var S=x.split('.');p.parameterEntityType=S[S.length-1];}for(var K in h){j=h[K];if(j){if(t&&(K==="$Key")){p.parameters=m([],j);}else if(j.$kind==="Property"){if(N.indexOf(K)>=0){continue;}if(o.getObject(E+"/"+K+"@com.sap.vocabularies.UI.v1.Hidden")){continue;}if(j.$isCollection){L.warning("Complex property with type "+j.$Type+" has been ignored");continue;}P=f._fetchPropertyInfo(o,E,n,j,K,p);if(P){P.group=G;P.groupLabel=y;P.required=R.indexOf(K)>=0;P.visible=s.indexOf(K)>=0;if(A[K]){var z=f._getFilterOperators(A[K]);if(z){P.filterOperators=z;}}P.maxConditions=O.isMultiValueFilterExpression(A[K])?-1:1;if(t&&p&&(p.parameters.indexOf(K)>-1)){P.path=null;P.name=K;P.required=true;p.parameterTypes[K]=j.$Type;k.push(P);}else if(!t){k.push(P);}}}else if(!t&&(j.$kind==="NavigationProperty")&&(!j.$isCollection)){var B=q[K];if(B&&(v.indexOf(j.$Type)===-1)){l.push(f._fetchEntitySet(o,'/'+B,v,K,p));}}}}return Promise.all(l).then(function(C){C.forEach(function(H){k=k.concat(H);});return k;});});};
f._waitForMetaModel=function(o,p){return new Promise(function(r,h){var i=function(){var s=p===null?undefined:p;var k=o.getModel(s);if(k){r(k);}return k;};var j=function(){if(i()){o.detachModelContextChange(j);}};if(!i()){if(!o.attachModelContextChange){h();return;}o.attachModelContextChange(j);}});};
f.fetchProperties=function(o){var s=o.getDelegate().payload.modelName;var E=o.getDelegate().payload.collectionName;return new Promise(function(r,h){var i;var C=o.getId()+'->'+E;if(g[C]){r(g[C]);return;}this._waitForMetaModel(o,s).then(function(j){if(!j||!E){h("model or entity set name not available");return;}i=j.getMetaModel();if(!i){h("metadata model not available");}else{var v=[];var p={parameterNavigationName:null,parameters:[],parameterTypes:{}};f._fetchEntitySet(i,'/'+E,v,null,p).then(function(P){if(p.parameterNavigationName&&(p.parameters.length>0)){window[o.getId()+'->'+E+"-Parameters"]=p;P.sort(function(l,n){var q=l.path||l.name;var t=n.path||n.name;if((!(p.parameters.indexOf(q)>-1)&&!(p.parameters.indexOf(t)>-1))||((p.parameters.indexOf(q)>-1)&&(p.parameters.indexOf(t)>-1))){return 0;}if((p.parameters.indexOf(q)>-1)&&!(p.parameters.indexOf(t)>-1)){return-1;}if(!(p.parameters.indexOf(q)>-1)&&(p.parameters.indexOf(t)>-1)){return 1;}});}var k=P.reduce(function(l,n){l[n.name]=n;return l;},{});P=Object.keys(k).map(function(n){return k[n];});g[C]=P;r(P);});}},function(){h("model not obtained");});}.bind(this));};
f.cleanup=function(o){var s=o.getId()+"->";Object.keys(g).forEach(function(k){if(k.indexOf(s)===0){delete window[s+k+"-Parameters"];delete g[k];}});};
f.getTypeUtil=function(p){return T;};
return f;});
sap.ui.predefine('sap/ui/mdc/odata/v4/TableDelegate',["../../TableDelegate","../../util/loadModules","../../library","sap/m/ColumnPopoverSelectListItem","sap/m/MessageBox","sap/ui/core/Item","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/format/ListFormat","sap/ui/base/ManagedObjectObserver"],function(T,l,a,C,M,I,b,c,L,d){"use strict";var f=a.TableType;var g=new window.WeakMap();var D=Object.assign({},T);
D.fetchPropertyHelper=function(e,P,F){return l("sap/ui/mdc/table/V4AnalyticsPropertyHelper").then(function(R){return R[0];});};
D.fetchPropertyExtensions=function(e,P){return Promise.resolve(null);};
D.fetchPropertiesForBinding=function(e){return this.fetchProperties(e);};
D.fetchPropertyExtensionsForBinding=function(e,P){return this.fetchPropertyExtensions(e,P);};
D.formatGroupHeader=function(e,F,P){};
D.preInit=function(e){if(!g.has(e)){g.set(e,{});}return y(e).then(function(){s(e);});};
D.validateState=function(e,S,K){var F=T.validateState.apply(this,arguments);var V;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(K=="Sort"&&S.sorters){if(x(e)&&!t(e,S.items,S.sorters)){V={validation:c.MessageType.Information,message:R.getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION")};}}else if(K=="Group"&&S.aggregations){var G=Object.keys(S.aggregations);var H=[];var J=L.getInstance();G.forEach(function(P){var O=e.getPropertyHelper().getProperty(P);if(O&&O.groupable){H.push(P);}});if(H.length){V={validation:c.MessageType.Information,message:R.getText("table.PERSONALIZATION_DIALOG_GROUP_RESTRICTION",[J.format(H)])};}}else if(K=="Column"){var N;var G=S.aggregations&&Object.keys(S.aggregations);if(!t(e,S.items,G)){N=R.getText("table.PERSONALIZATION_DIALOG_TOTAL_RESTRICTION");}if(x(e)&&!t(e,S.items,S.sorters)){N=N?N+"\n"+R.getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION"):R.getText("table.PERSONALIZATION_DIALOG_SORT_RESTRICTION");}if(N){V={validation:c.MessageType.Information,message:N};}}return u(F,V);};
D.updateBinding=function(F,G,H){if(!H||H.getPath()!=G.path){this.rebindTable(F,G);return;}var R=H.getRootBinding();var J=R&&!R.isSuspended();try{if(J){R.suspend();}s(F,G);H.changeParameters(G.parameters);H.filter(G.filters,"Application");H.sort(G.sorter);}catch(e){this.rebindTable(F,G);if(R==H){J=false;}}finally{if(J&&R.isSuspended()){R.resume();}}};
D.rebind=function(e,F){s(e,F);T.rebindTable(e,F);};
D.addColumnMenuItems=function(e,F){var P=e.getPropertyHelper();var G=P.getProperty(F.getDataProperty());var H=[];if(!G){return[];}if(e.isGroupingEnabled()&&v(e)){var J=G.getGroupableProperties();if(J.length>0){H.push(h(J,F));}}if(e.isAggregationEnabled()&&w(e)){var K=G.getAggregatableProperties();if(K.length>0){H.push(i(K,F));}}var N=e._oPopover;if(N){N.getItems().forEach(function(O,Q,H){var R=O.getLabel();var S=b.getLibraryResourceBundle("sap.ui.mdc");if(R===S.getText("table.SETTINGS_GROUP")||R===S.getText("table.SETTINGS_TOTALS")){H[Q].destroy();}if(H.length==0){N.destroy();}});}return H;};
function h(G,e){var F=G.map(function(H){return new I({text:H.label,key:H.name});});if(F.length>0){return new C({items:F,label:b.getLibraryResourceBundle("sap.ui.mdc").getText("table.SETTINGS_GROUP"),icon:"sap-icon://group-2",action:[{sName:"Group",oMDCColumn:e},j,this]});}}
function i(e,F){var G=e.map(function(H){return new I({text:H.label,key:H.name});});if(G.length>0){return new C({items:G,label:b.getLibraryResourceBundle("sap.ui.mdc").getText("table.SETTINGS_TOTALS"),icon:"sap-icon://sum",action:[{sName:"Aggregate",oMDCColumn:F},j,this]});}}
function j(e,F){var N=F.sName,G=F.oMDCColumn.getParent(),H=G.getCurrentState().groupLevels||[],J=G.getCurrentState().aggregations||{},K=Object.keys(J),O=false,P=e.getParameter("property"),Q=N==="Aggregate"?H:K,R=Q.filter(function(X){return N==="Aggregate"?X.name===P:X===P;}).length>0;if(R){var S=b.getLibraryResourceBundle("sap.ui.mdc");var U;var V;var W;if(N==="Aggregate"){U=S.getText("table.SETTINGS_WARNING_TITLE_TOTALS");V=S.getText("table.SETTINGS_MESSAGE2");W=S.getText("table.SETTINGS_WARNING_BUTTON_TOTALS");}else{U=S.getText("table.SETTINGS_WARNING_TITLE_GROUPS");V=S.getText("table.SETTINGS_MESSAGE1");W=S.getText("table.SETTINGS_WARNING_BUTTON_GROUP");}O=true;M.warning(V,{id:G.getId()+"-messageBox",title:U,actions:[W,S.getText("table.SETTINGS_WARNING_BUTTON_CANCEL")],onClose:function(X){if(X===W){k(N,G,P);}}});}if(N==="Aggregate"&&!O){o(N,G,P);}else if(N==="Group"&&!O){o(N,G,P);}}
function o(e,F,P){if(e==="Group"){F._onCustomGroup(P);}else{F._onCustomAggregate(P);}}
function k(N,e,P){if(N==="Aggregate"){e._onCustomGroup(P);e._onCustomAggregate(P);}else if(N==="Group"){e._onCustomAggregate(P);e._onCustomGroup(P);}}
function s(e,F){var P=g.get(e).plugin;if(!P||P.isDestroyed()){return;}var G=e._getGroupedProperties().map(function(K){return K.name;});var H=Object.keys(e._getAggregatedProperties());var S=F?F.parameters["$search"]:undefined;if(S){delete F.parameters["$search"];}var J={visible:m(e),groupLevels:G,grandTotal:H,subtotals:H,columnState:n(e,H),search:S};P.setAggregationInfo(J);}
function m(e){var V=new Set();var P=g.get(e).oPropertyHelperForBinding;e.getColumns().forEach(function(F){var G=P.getProperty(F.getDataProperty());if(!G){return;}if(G.isComplex()){G.getReferencedProperties().forEach(function(G){V.add(G.name);});}else{V.add(G.name);}});return Array.from(V);}
function n(e,F){var G={};e.getColumns().forEach(function(H){var J=H.getId()+"-innerColumn";var K=q(e,H,F);var N=K.length>0;if(J in G){G[J].subtotals=N||G[J].subtotals;G[J].grandTotal=N||G[J].grandTotal;return;}G[J]={subtotals:N,grandTotal:N};r(e,K).forEach(function(U){J=U.getId()+"-innerColumn";if(J in G){G[J].subtotals=N||G[J].subtotals;G[J].grandTotal=N||G[J].grandTotal;}else{G[J]={subtotals:N,grandTotal:N};}});});return G;}
function p(e,F){var P=e.getPropertyHelper().getProperty(F.getDataProperty());if(!P){return[];}else if(P.isComplex()){return P.getReferencedProperties();}else{return[P];}}
function q(e,F,G){return p(e,F).filter(function(P){return G.includes(P.name);});}
function r(e,P){var U=[];P.forEach(function(F){if(F.unitProperty){U.push(F.unitProperty);}});return e.getColumns().filter(function(F){return p(e,F).some(function(G){return U.includes(G);});});}
function t(e,F,S){var P,G=[];F&&F.forEach(function(H){P=e.getPropertyHelper().getProperty(H.name);if(!P.isComplex()){G.push(P.name);}else{P.getReferencedProperties().forEach(function(R){G.push(R.name);});}});var O=S?S.every(function(H){return G.find(function(J){return H.name?H.name===J:H===J;});}):true;return O;}
function u(e,V){var S={Error:1,Warning:2,Information:3,None:4};if(!V||S[V.validation]-S[e.validation]>0){return e;}else{return V;}}
function v(e){return e._isOfType(f.Table);}
function w(e){return e._isOfType(f.Table);}
function x(e){return(e.isGroupingEnabled()||e.isAggregationEnabled())&&e._isOfType(f.Table);}
function y(e){if(e._isOfType(f.Table)){return(x(e)?z(e):A(e)).then(function(){return E(e);});}return Promise.resolve();}
function z(e){var F=g.get(e);var P=F.plugin;if(P&&!P.isDestroyed()){P.activate();return Promise.resolve();}return Promise.all([e.awaitPropertyHelper(),l("sap/ui/table/plugins/V4Aggregation")]).then(function(R){var V=R[1][0];var G=e.getControlDelegate();P=new V({groupHeaderFormatter:function(H,J){return G.formatGroupHeader(e,H,J);}});e._oTable.addDependent(P);F.plugin=P;return B(e);}).then(function(G){P.setPropertyInfos(G.getProperties());});}
function A(e){var F=g.get(e);if(F.plugin){F.plugin.deactivate();}return Promise.resolve();}
function B(e){var F=g.get(e);if(F.oPropertyHelperForBinding){return Promise.resolve(F.oPropertyHelperForBinding);}var G=e.getControlDelegate();var P;var H;return G.fetchPropertiesForBinding(e).then(function(J){P=J;return G.fetchPropertyExtensionsForBinding(e,P);}).then(function(J){H=J;return G.fetchPropertyHelper(e,P,H);}).then(function(J){var K=J.constructor===J;F.oPropertyHelperForBinding=K?J:new J(P,H,e);return F.oPropertyHelperForBinding;});}
function E(e){var F=g.get(e);if(!F.observer){F.observer=new d(function(G){if(G.type==="destroy"){if(F.oPropertyHelperForBinding){F.oPropertyHelperForBinding.destroy();}}else{y(e);}});F.observer.observe(e,{properties:["p13nMode"],destroy:true});}}
return D;});
sap.ui.predefine('sap/ui/mdc/odata/v4/ValueHelpDelegate',["../../ValueHelpDelegate","sap/ui/model/FilterType"],function(V,F){"use strict";var O=Object.assign({},V);
O.isSearchSupported=function(p,l){return!!l.changeParameters;};
var _=function(b){return new Promise(function(r){var a=false;var h=function(p){if(p.mParameters.detailedReason){return;}if(!a){a=true;b.detachEvent("change",h);r(b);}};b.attachEvent("change",h);b.attachEventOnce("dataReceived",h);});};
O.executeSearch=function(p,l,s){if(s){l.changeParameters({$search:s});}else{l.changeParameters({$search:undefined});}return _(l);};
O.executeFilter=function(p,l,f,r){l.initialize();l.filter(f,F.Application);l.getContexts(0,r);return _(l);};
O.checkBindingsPending=function(p,b){var P=[];for(var i=0;i<b.length;i++){var B=b[i];if(B&&B.requestValue){P.push(B.requestValue());}}if(P.length>0){return Promise.all(P);}return null;};
O.checkListBindingPending=function(p,l,L){if(!l||l.isSuspended()){return false;}return l.requestContexts(0,L&&L.length).then(function(c){return c.length===0;});};
return O;});
sap.ui.predefine('sap/ui/mdc/odata/v4/util/DelegateUtil',['sap/ui/mdc/util/FilterUtil',"sap/ui/mdc/condition/ConditionConverter",'sap/base/Log','sap/base/util/merge',"sap/ui/model/FilterOperator","sap/ui/model/odata/v4/ODataUtils"],function(F,C,L,m,a,O){"use strict";var D={_getParameters:function(M){var p=null;if(M&&M.getDelegate()&&M.getDelegate().payload&&M.getDelegate().payload.collectionName){var e=M.getDelegate().payload.collectionName;if(window[M.getId()+'->'+e+"-Parameters"]){p=window[M.getId()+'->'+e+"-Parameters"];}}return p;},getParametersInfo:function(M){var p=D._getParameters(M);return D._getParameterPath(M,p);},_getParametersListUrl:function(M,p){var P=[];var c=F.getConditionsMap(M,p);var b=M.getPropertyInfoSet();p.forEach(function(s){var o=F.getPropertyByKey(b,s);if(o&&(o.maxConditions===1)){c[s].forEach(function(d){if(d.operator===a.EQ){P.push(s+'='+encodeURIComponent(O.formatLiteral(d.values[0],o.typeConfig.className)));}});}});return P;},_getParameterPath:function(M,p){if(!M||!M.isA("sap.ui.mdc.FilterBar")){return null;}if(!p||(p.parameters.length<=0)){return null;}var e=M.getDelegate().payload.collectionName;var P=D._getParametersListUrl(M,p.parameters);return'/'+e+'('+P.toString()+")/"+p.parameterNavigationName;},getParameterNames:function(M){var p=null,P=D._getParameters(M);if(P){p=P.parameters;}return p;}};return D;});
sap.ui.predefine('sap/ui/mdc/odata/v4/vizChart/ChartDelegate',["../ChartDelegate","../../../util/loadModules","sap/ui/core/Core","sap/m/library","sap/m/Text","sap/ui/mdc/library","sap/ui/mdc/odata/v4/ODataMetaModelUtil","sap/base/Log",'sap/ui/mdc/util/FilterUtil','sap/ui/mdc/odata/v4/util/DelegateUtil',"sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/m/VBox","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/MessageStrip"],function(V,l,C,m,T,M,O,L,F,D,c,d,S,f,g,R,h,n){"use strict";var o=Object.assign({},V);var p=m.FlexJustifyContent;var q=m.FlexAlignItems;var s=new window.WeakMap();var r;var t;var u;var v;
o._getState=function(a){if(s.has(a)){return s.get(a);}L.info("Couldn't get state for "+a.getId());};
o._setState=function(a,b){s.set(a,b);};
o._deleteState=function(a){if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}if(this._getState(a).observer){this._getState(a).observer.disconnect();this._getState(a).observer=null;}return s.delete(a);};
o._getChart=function(a){if(s.has(a)){return s.get(a).innerChart;}L.info("Couldn't get state for "+a.getId());return undefined;};
o._setChart=function(a,i){if(s.has(a)){s.get(a).innerChart=i;}else{s.set(a,{innerChart:i});}};
o._getInnerStructure=function(a){if(s.has(a)){return s.get(a).innerStructure;}L.info("Couldn't get state for "+a.getId());return undefined;};
o._setInnerStructure=function(a,i){if(s.has(a)){s.get(a).innerStructure=i;}else{s.set(a,{innerStructure:i});}};
o._getBindingInfoFromState=function(a){if(s.has(a)){return s.get(a).bindingInfo;}L.info("Couldn't get state for "+a.getId());return undefined;};
o._setBindingInfoForState=function(a,b){if(s.has(a)){s.get(a).bindingInfo=b;}else{s.set(a,{bindingInfo:b});}};
o._setUpChartObserver=function(a){var b=this._getState(a);if(!b.observer){b.observer=new g(function(e){if(e.type==="destroy"){this.exit(e.object);}}.bind(this));}b.observer.observe(a,{destroy:true});};
o.getFilterDelegate=function(){return{addItem:function(P,a){return Promise.resolve(null);}};};
o.exit=function(a){if(this._getInnerStructure(a)){this._getInnerStructure(a).destroy();}this._deleteState(a);};
o.zoomIn=function(a,i){this._getChart(a).zoom({direction:"in"});};
o.zoomOut=function(a,i){this._getChart(a).zoom({direction:"out"});};
o.getZoomState=function(a){if(this._getChart(a)){return this._getChart(a).getZoomInfo(this);}};
o.getInnerChartSelectionHandler=function(a){return{eventId:"_selectionDetails",listener:this._getChart(a)};};
o.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout;}var a=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var A=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.category,M.ChartItemRoleType.series];var b=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.category,M.ChartItemRoleType.category2];var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:a},{key:"bar",allowedLayoutOptions:a},{key:"line",allowedLayoutOptions:a},{key:"combination",allowedLayoutOptions:a},{key:"pie",allowedLayoutOptions:a},{key:"donut",allowedLayoutOptions:a},{key:"dual_column",allowedLayoutOptions:A},{key:"dual_bar",allowedLayoutOptions:A},{key:"dual_line",allowedLayoutOptions:A},{key:"stacked_bar",allowedLayoutOptions:a},{key:"scatter",allowedLayoutOptions:A},{key:"bubble",allowedLayoutOptions:e},{key:"heatmap",allowedLayoutOptions:b},{key:"bullet",allowedLayoutOptions:a},{key:"vertical_bullet",allowedLayoutOptions:a},{key:"dual_stacked_bar",allowedLayoutOptions:A},{key:"100_stacked_bar",allowedLayoutOptions:a},{key:"stacked_column",allowedLayoutOptions:a},{key:"dual_stacked_column",allowedLayoutOptions:A},{key:"100_stacked_column",allowedLayoutOptions:a},{key:"dual_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_horizontal_combination",allowedLayoutOptions:A},{key:"dual_stacked_combination",allowedLayoutOptions:A},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:A},{key:"stacked_combination",allowedLayoutOptions:a},{key:"100_dual_stacked_bar",allowedLayoutOptions:a},{key:"100_dual_stacked_column",allowedLayoutOptions:a},{key:"horizontal_stacked_combination",allowedLayoutOptions:a},{key:"waterfall",allowedLayoutOptions:b},{key:"horizontal_waterfall",allowedLayoutOptions:b}];return this._aChartTypeLayout;};
o.getAdaptionUI=function(a){var b=this.getChartTypeLayoutConfig().find(function(k){return k.key===a.getChartType();});if(!b){var e=[M.ChartItemRoleType.axis1,M.ChartItemRoleType.axis2,M.ChartItemRoleType.axis3,M.ChartItemRoleType.category,M.ChartItemRoleType.category2,M.ChartItemRoleType.series];b={key:a.getChartType(),allowedLayoutOptions:e};}var i=[{kind:"Groupable"},{kind:"Aggregatable"}];b.templateConfig=i;var A={panelConfig:b};var P=new h(A);if(a.getChartType()==="heatmap"){var j=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");P.setMessageStrip(new n({text:j.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}));}return Promise.resolve(P);};
o.setLegendVisible=function(a,b){if(this._getChart(a)){this._getChart(a).setVizProperties({'legend':{'visible':b},'sizeLegend':{'visible':b}});}else{L.error("Could not set legend visibility since inner chart is not yet initialized!");}};
o.getSorterForItem=function(a,b){if(a.getType()==="aggregatable"){return new S(this._getAggregatedMeasureNameForMDCItem(a),b.descending);}else if(a.getType()==="groupable"){return new S(this.getInternalChartNameFromPropertyNameAndKind(b.name,"groupable",a.getParent()),b.descending);}};
o.insertItemToInnerChart=function(a,b,i){if(b.getType()==="groupable"){var I=this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a);var e=this._getChart(a).getDimensionByName(I);if(!e){this.createInnerDimension(a,b);}else{e.setLabel(b.getLabel());e.setRole(b.getRole()?b.getRole():"category");}var j=this._getChart(a).getVisibleDimensions();j.splice(i,0,I);this._getChart(a).setVisibleDimensions(j);}else if(b.getType()==="aggregatable"){this.createInnerMeasure(a,b);var k=this._getChart(a).getVisibleMeasures();k.splice(i,0,this._getAggregatedMeasureNameForMDCItem(b));this._getChart(a).setVisibleMeasures(k);}this._prepareColoringForItem(b).then(function(){this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());}.bind(this));this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};
o.removeItemFromInnerChart=function(a,b){if(b.getType()==="groupable"&&this._getChart(a).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a))){var i=this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a);var N=this._getChart(a).getVisibleDimensions().filter(function(e){return e!==i;});if(this._getState(a).inResultDimensions.length>0){this._getChart(a).setInResultDimensions(this._getState(a).inResultDimensions);}this._getChart(a).setVisibleDimensions(N);}else if(b.getType()==="aggregatable"&&this._getChart(a).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(b))){var j=this._getChart(a).getVisibleMeasures().filter(function(e){return e!==this._getAggregatedMeasureNameForMDCItem(b);}.bind(this));this._getChart(a).setVisibleMeasures(j);this._getChart(a).removeMeasure(this._getChart(a).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(b)));}this._updateColoring(a,this._getChart(a).getVisibleDimensions(),this._getChart(a).getVisibleMeasures());this.fetchProperties(b.getParent()).then(function(P){this._updateSemanticalPattern(a,P);}.bind(this));};
o.addItem=function(P,a,b,e){if(a.getModel){return Promise.resolve(this._createMDCChartItem(P,a,e));}return Promise.resolve(null);};
o.removeItem=function(P,a){return Promise.resolve(true);};
o._createMDCChartItem=function(P,a,b){return this.fetchProperties(a).then(function(e){var i=e.find(function(j){return j.name===P;});if(!i){return null;}if(i.groupable){return new d(a.getId()+"--GroupableItem--"+i.name,{name:i.name,label:i.label,type:"groupable",role:b?b:"category"});}if(i.aggregatable){return new d(a.getId()+"--AggregatableItem--"+i.name,{name:i.name,label:i.label,type:"aggregatable",role:b?b:"axis1"});}});};
o.initializeInnerChart=function(a){return new Promise(function(b,e){this._loadChart().then(function(i){var j=this._calculateInnerChartHeight(a);this._setInnerStructure(a,new f({justifyContent:"Center",alignItems:"Center",height:j,width:"100%"}));var k=new T();k.setText(a.getNoDataText());this._getInnerStructure(a).addItem(k);this._setUpChartObserver(a);b(this._getInnerStructure(a));}.bind(this));}.bind(this));};
o.createInitialChartContent=function(a){};
o._createContentFromItems=function(a){this.fetchProperties(a).then(function(P){var b=[];var e=[];var i=[];a.getItems().forEach(function(I,j){var k=P.find(function(x){return x.name===I.getName();});if(!k){L.error("sap.ui.mdc.Chart: Item "+I.getName()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return;}switch(I.getType()){case"groupable":e.push(this.getInternalChartNameFromPropertyNameAndKind(I.getName(),"groupable",a));this._addInnerDimension(a,I,k);break;case"aggregatable":i.push(this._getAggregatedMeasureNameForMDCItem(I));this._addInnerMeasure(a,I,k);break;default:L.error("MDC Chart Item "+I.getId()+" with label "+I.getLabel()+" has no known type. Supported typed are: \"groupable\" & \"aggregatable\"");}b.push(this._prepareColoringForItem(I));}.bind(this));this._getState(a).aColMeasures.forEach(function(k){if(this._getState(a).aInSettings.indexOf(k)==-1){var j=a.getPropertyHelper().getProperty(k);var x=j.aggregationMethod;var y=j.propertyPath;var N=this.getInternalChartNameFromPropertyNameAndKind(k,"aggregatable",a);var z={name:N,label:j.label,role:"axis1"};if(x&&y){z.analyticalInfo={propertyPath:y,"with":x};}var A=new u(z);i.push(A);this._getChart(a).addMeasure(A);}}.bind(this));Promise.all(b).then(function(){this._getChart(a).setVisibleDimensions(e);this._getChart(a).setVisibleMeasures(i);var I=a.getDelegate().inResultDimensions;if(I&&I instanceof Array&&I.length!=0){var j=[];I.forEach(function(k){j.push(this._getPropertyInfosByName(k,a).then(function(x){var N=this.getInternalChartNameFromPropertyNameAndKind(x.name,"groupable",a);var y=new t({name:N,label:x.label});this._getState(a).inResultDimensions.push(N);this._getChart(a).addDimension(y);}.bind(this)));}.bind(this));Promise.all(j).then(function(){this._getChart(a).setInResultDimensions(this._getState(a).inResultDimensions);}.bind(this));}this._updateColoring(a,e,i);this._updateSemanticalPattern(a,P);}.bind(this));}.bind(this));};
o.getInnerChart=function(a){return this._getChart(a);};
o._prepareColoringForItem=function(i){return this._addCriticality(i).then(function(){this._getState(i.getParent()).aInSettings.push(i.getName());if(i.getType==="aggregatable"){this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){for(var j=0;j<this._getAdditionalColoringMeasuresForItem(P);j++){if(this._getState(i.getParent()).aColMeasures.indexOf(this._getAdditionalColoringMeasuresForItem(P)[j])==-1){this._getState(i.getParent()).aColMeasures.push(this._getAdditionalColoringMeasuresForItem(P)[j]);}}}.bind(this));}}.bind(this));};
o._getAdditionalColoringMeasuresForItem=function(P){var a=[];var b=P.datapoint?P.datapoint.criticality:null;if(b&&b.DynamicThresholds){a=b.DynamicThresholds.usedMeasures;}return a;};
o._addCriticality=function(i){return this._getPropertyInfosByName(i.getName(),i.getParent()).then(function(P){if(P.criticality||(P.datapoint&&P.datapoint.criticality)){var a=this._getState(i.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};var b={};if(i.getType()=="groupable"){var e=P.criticality?P.criticality:[];for(var k in e){b[k]={Values:e[k]};}var j=this.getInternalChartNameFromPropertyNameAndKind(i.getName(),"groupable",i.getParent());a.Criticality.DimensionValues[j]=b;}else{var e=P.datapoint&&P.datapoint.criticality?P.datapoint.criticality:[];for(var k in e){b[k]=e[k];}var x=this.getInternalChartNameFromPropertyNameAndKind(i.getName(),"aggregatable",i.getParent());a.Criticality.MeasureValues[x]=b;}var y=this._getState(i.getParent());y.oColorings=a;this._setState(i.getParent(),y);}}.bind(this));};
o._updateColoring=function(a,b,e){var i=jQuery.extend(true,{},this._getState(a).oColorings),k;if(i&&i.Criticality){var A;for(k=0;k<b.length;k++){if(this._getState(a).oColorings.Criticality.DimensionValues[b[k]]){A={coloring:"Criticality",parameters:{dimension:b[k]}};delete i.Criticality.MeasureValues;break;}}if(!A){delete i.Criticality.DimensionValues;for(var j in i.Criticality.MeasureValues){if(e.indexOf(j)==-1){delete i.Criticality.MeasureValues[j];}}A={coloring:"Criticality",parameters:{measure:e}};}if(A){this._getChart(a).setColorings(i);this._getChart(a).setActiveColoring(A);}}};
o._updateSemanticalPattern=function(a,P){var b=this._getChart(a).getVisibleMeasures();b.forEach(function(e){var i=this.getPropertyFromNameAndKind(e,"aggregatable",a);if(!i){return;}var j=i.datapoint;if(j){if(j.targetValue||j.foreCastValue){var A=this._getChart(a).getMeasureByName(e);A.setSemantics("actual");if(j.targetValue!=null){var k=this._getChart(a).getMeasureByName(j.targetValue);if(k){k.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+j.targetValue+" is not a valid measure");}}if(j.foreCastValue){var x=this._getChart(a).getMeasureByName(j.foreCastValue);if(x){x.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+j.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:j.targetValue,projectedValueMeasure:j.foreCastValue});}}}.bind(this));};
o.getChartTypeInfo=function(a){if(!this._getChart(a)){throw'inner chart is not bound';}var b=a.getChartType(),e=C.getLibraryResourceBundle("sap.ui.mdc");var i={icon:c.mMatchingIcon[b],text:e.getText("chart.CHART_TYPE_TOOLTIP",[b])};return i;};
o.getAvailableChartTypes=function(a){var b=[];if(this._getChart(a)){var A=this._getChart(a).getAvailableChartTypes().available;if(b){var e=C.getLibraryResourceBundle("sap.chart.messages");for(var i=0;i<A.length;i++){var j=A[i].chart;b.push({key:j,icon:c.mMatchingIcon[j],text:e.getText("info/"+j),selected:(j==a.getChartType())});}}}return b;};
o.getDrillStackInfo=function(){};
o.getDrillStack=function(a){var b=[];b=Object.assign(b,this._getChart(a).getDrillStack());b.forEach(function(e){e.dimension=e.dimension.map(function(i){var P=this.getPropertyFromNameAndKind(i,"groupable",a);if(P){return P.name;}else{L.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+i);return i;}}.bind(this));}.bind(this));return b;};
o.getSortedDimensions=function(e){return new Promise(function(i,j){this.fetchProperties(e).then(function(P){var k=P.filter(function(I){return I.groupable;});if(k){k.sort(function(a,b){if(a.label&&b.label){return a.label.localeCompare(b.label);}});}i(k);});}.bind(this));};
o.getDrillableItems=function(a){var b=a.getItems().filter(function(i){return i.getType()==="groupable";});return b;};
o.setChartType=function(a,b){this._getChart(a).setChartType(b);};
o.createInnerChartContent=function(a,b){this._setChart(a,new r({id:a.getId()+"--innerChart",chartType:"column",width:"100%",isAnalytical:true}));this._getState(a).inResultDimensions=[];if(a.getHeight()){this._getChart(a).setHeight(this._calculateInnerChartHeight(a));}R.register(a,function(){this.adjustChartHeight(a);}.bind(this));var e=this._getState(a);e.aColMeasures=[];e.aInSettings=[];this._setState(a,e);this._createContentFromItems(a);this._getChart(a).attachRenderComplete(function(){if(this._getState(a).toolbarUpdateRequested){a._updateToolbar();this._getState(a).toolbarUpdateRequested=false;}}.bind(this));this._getInnerStructure(a).removeAllItems();this._getInnerStructure(a).setJustifyContent(p.Start);this._getInnerStructure(a).setAlignItems(q.Stretch);this._getInnerStructure(a).addItem(this._getChart(a));e.dataLoadedCallback=b;this._setState(a,e);var B=this._getBindingInfo(a);this.updateBindingInfo(a,B);this.rebind(a,B);};
o._calculateInnerChartHeight=function(a){var i=jQuery(a.getDomRef()).height();var b=0;var e=a.getAggregation("_toolbar");var B=0;var j=a.getAggregation("_breadcrumbs");if(e){b=jQuery(e.getDomRef()).outerHeight(true);}if(j){B=jQuery(j.getDomRef()).outerHeight(true);}var k=B+b;if(!i){return"480px";}return i-k+"px";};
o.adjustChartHeight=function(a){if(a.getHeight()&&this._getChart(a)){var H=this._calculateInnerChartHeight(a);this._getInnerStructure(a).setHeight(H);this._getChart(a).setHeight(H);}};
o.requestToolbarUpdate=function(a){this._getState(a).toolbarUpdateRequested=true;};
o.createInnerDimension=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerDimension(a,b,e);}.bind(this));};
o.createInnerMeasure=function(a,b){this.fetchProperties(b.getParent()).then(function(P){var e=P.find(function(i){return i.name===b.getName();});this._addInnerMeasure(a,b,e);}.bind(this));};
o._addInnerDimension=function(a,b,P){var e=new t({name:this.getInternalChartNameFromPropertyNameAndKind(b.getName(),"groupable",a),role:b.getRole()?b.getRole():"category",label:b.getLabel()});if(P.textProperty){e.setTextProperty(P.textProperty);if(P.textFormatter){e.setTextFormatter(P.textFormatter);}e.setDisplayText(true);}this._getChart(a).addDimension(e);};
o._addInnerMeasure=function(a,b,P){var e=P.aggregationMethod;var i=P.propertyPath;var j={name:this._getAggregatedMeasureNameForMDCItem(b),label:b.getLabel(),role:b.getRole()?b.getRole():"axis1"};if(e&&i){j.analyticalInfo={propertyPath:i,"with":e};}var k=new u(j);this._getChart(a).addMeasure(k);};
o._getAggregatedMeasureNameForProperty=function(P){return P.aggregationMethod+P.name;};
o.rebindChart=function(a,b){this.rebind(a,b);};
o.rebind=function(a,b){if(a&&b&&this._getChart(a)){this._addBindingListener(b,"dataReceived",this._getState(a).dataLoadedCallback.bind(a));if(b.binding){b.binding.bHasAnalyticalInfo=true;}this._getChart(a).bindData(b);this._setBindingInfoForState(a,b);var e=this._getState(a);e.innerChartBound=true;}};
o._getBindingInfo=function(a){if(this._getBindingInfoFromState(a)){return this._getBindingInfoFromState(a);}var b=a.getDelegate().payload;var e="/"+b.collectionName;var B={path:e};return B;};
o.getInnerChartBound=function(a){var b=this._getState(a);if(!b){return false;}return b.innerChartBound?true:false;};
o.updateBindingInfo=function(a,b){var e=C.byId(a.getFilter());if(e){var i=e.getConditions();if(i){if(!b){b={};}var P=e.getPropertyInfoSet?e.getPropertyInfoSet():null;var j=D.getParameterNames(e);var k=F.getFilterInfo(o.getTypeUtil(),i,P,j);if(k){b.filters=k.filters;}var x=D.getParametersInfo(e);if(x){b.path=x;}}var y=e.getSearch instanceof Function?e.getSearch():"";if(y){if(!b){b={};}if(!b.parameters){b.parameters={};}b.parameters.$search=y;}else if(b.parameters&&b.parameters.$search){delete b.parameters.$search;}}};
o._getAggregatedMeasureNameForMDCItem=function(a){return this.getInternalChartNameFromPropertyNameAndKind(a.getName(),"aggregatable",a.getParent());};
o.getInternalChartNameFromPropertyNameAndKind=function(N,k,a){return N;};
o.getPropertyFromNameAndKind=function(N,k,a){return a.getPropertyHelper().getProperty(N);};
o._getLayoutOptionsForType=function(a){var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={groupable:[{key:M.ChartItemRoleType.category,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],aggregatable:[{key:M.ChartItemRoleType.axis1,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:b.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[a];};
o.addInnerItem=function(P,a,b){return Promise.resolve(null);};
o.insertInnerItem=function(P,a,b){};
o.removeInnerItem=function(P,a,b){return Promise.resolve(true);};
o.setChartTooltipVisibility=function(a,b){if(this._getChart(a)){if(b){if(!this._getState(a).vizTooltip){var e=this._getState(a);e.vizTooltip=new v();this._setState(a,e);}this._getState(a).vizTooltip.connect(this._getChart(a).getVizUid());}else if(this._getState(a).vizTooltip){this._getState(a).vizTooltip.destroy();}}else{L.error("Trying to set chart tooltip while inner chart was not yet initialized");}};
o._loadChart=function(){return new Promise(function(a){var N=['sap/chart/library','sap/chart/Chart','sap/chart/data/Dimension','sap/chart/data/HierarchyDimension','sap/chart/data/TimeDimension','sap/chart/data/Measure','sap/viz/ui5/controls/VizTooltip'];function b(e,i,j,H,k,x,y){r=i;t=j;u=x;v=y;a();}sap.ui.require(N,b);});};
o.initPropertyHelper=function(a){return Promise.all([this.fetchProperties(a),l("sap/ui/mdc/odata/v4/ChartPropertyHelper")]).then(function(b){return Promise.all(b.concat(this.fetchPropertyExtensions(a,b[0])));}.bind(this)).then(function(b){var P=b[0];var e=b[1][0];var E=b[2];var j=0;var k=[];for(var i=0;i<P.length;i++){k.push(Object.assign({},P[i],{extension:E[P[i].name]||{}}));if(P[i].name in E){j++;}}if(j!==Object.keys(E).length){throw new Error("At least one property extension does not point to an existing property");}return new e(k,a);});};
o.fetchProperties=function(a){var b=this._getModel(a);var e;if(!b){e=new Promise(function(i){a.attachModelContextChange({resolver:i},w,this);}.bind(this)).then(function(b){return this._createPropertyInfos(a,b);}.bind(this));}else{e=this._createPropertyInfos(a,b);}return e.then(function(P){if(a.data){a.data("$mdcChartPropertyInfo",P);}return P;});};
function w(e,a){var b=e.getSource();var i=this._getModel(b);if(i){b.detachModelContextChange(w);a.resolver(i);}}
o._createPropertyInfos=function(a,b){var e=a.getDelegate().payload;var P=[];var E="/"+e.collectionName;var i=b.getMetaModel();return Promise.all([i.requestObject(E+"/"),i.requestObject(E+"@")]).then(function(j){var k=j[0],x=j[1];var y=x["@Org.OData.Capabilities.V1.SortRestrictions"]||{};var z=O.getSortRestrictionsInfo(y);var A=x["@Org.OData.Capabilities.V1.FilterRestrictions"];var B=O.getFilterRestrictionsInfo(A);for(var K in k){var G=k[K];if(G&&G.$kind==="Property"){if(G.$isCollection){continue;}var H=i.getObject(E+"/"+K+"@");if(!H["@Org.OData.Aggregation.V1.Aggregatable"]&&!H["@Org.OData.Aggregation.V1.Groupable"]){continue;}if(H["@Org.OData.Aggregation.V1.Aggregatable"]){P=P.concat(this._createPropertyInfosForAggregatable(K,H,B,z));}if(H["@Org.OData.Aggregation.V1.Groupable"]){P.push({name:K,propertyPath:K,label:H["@com.sap.vocabularies.Common.v1.Label"]||K,sortable:z[K]?z[K].sortable:true,filterable:B[K]?B[K].filterable:true,groupable:true,aggregatable:false,maxConditions:O.isMultiValueFilterExpression(B.propertyInfo[K])?-1:1,sortKey:K,kind:"Groupable",availableRoles:this._getLayoutOptionsForType("groupable"),role:M.ChartItemRoleType.category,criticality:null,textProperty:H["@com.sap.vocabularies.Common.v1.Text"]?H["@com.sap.vocabularies.Common.v1.Text"].$Path:null});}}}return P;}.bind(this));};
o._createPropertyInfosForAggregatable=function(k,P,a,b){var e=[];if(P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"]){P["@Org.OData.Aggregation.V1.SupportedAggregationMethods"].forEach(function(A){e.push({name:A+k,propertyPath:k,label:P["@com.sap.vocabularies.Common.v1.Label"]+" ("+A+")"||k+" ("+A+")",sortable:b[k]?b[k].sortable:true,filterable:a[k]?a[k].filterable:true,groupable:false,aggregatable:P["@Org.OData.Aggregation.V1.Aggregatable"],aggregationMethod:A,maxConditions:O.isMultiValueFilterExpression(a.propertyInfo[k])?-1:1,sortKey:P["@Org.OData.Aggregation.V1.RecommendedAggregationMethod"]+k,kind:"Aggregatable",availableRoles:this._getLayoutOptionsForType("aggregatable"),role:M.ChartItemRoleType.axis1,datapoint:null});}.bind(this));}return e;};
o._getPropertyInfosByName=function(N,a){return new Promise(function(b){this.fetchProperties(a).then(function(P){var e=P.find(function(i){return i.name===N;});b(e);});}.bind(this));};
o._getModel=function(a){var b=a.getDelegate().payload;return a.getModel(b.model);};
o._addBindingListener=function(b,e,H){if(!b.events){b.events={};}if(!b.events[e]){b.events[e]=H;}else{var a=b.events[e];b.events[e]=function(){H.apply(this,arguments);a.apply(this,arguments);};}};
return o;});
sap.ui.predefine('sap/ui/mdc/p13n/AdaptationProvider',["sap/ui/base/Object"],function(B){"use strict";
var A=B.extend("sap.ui.mdc.p13n.AdaptationProvider",{metadata:{baseType:"sap.ui.mdc.p13n.AdaptationProvider"}});
A.prototype.initAdaptation=function(c,k,C){throw new Error("Please implement 'initAdaptation'");};
A.prototype.reset=function(c,k){throw new Error("Please implement 'reset'");};
A.prototype.handleP13n=function(c,k){throw new Error("Please implement 'handleP13n'");};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/Engine',["sap/ui/mdc/p13n/AdaptationProvider","sap/base/util/merge","sap/base/Log","sap/ui/mdc/util/PropertyHelper","sap/ui/mdc/p13n/modification/FlexModificationHandler","sap/m/MessageStrip","sap/ui/core/library","sap/ui/mdc/p13n/StateUtil","sap/ui/core/Element","sap/ui/mdc/p13n/modules/DefaultProviderRegistry","sap/ui/mdc/p13n/UIManager","sap/ui/mdc/p13n/modules/StateHandlerRegistry"],function(A,m,L,P,F,M,c,S,E,D,U,b){"use strict";var d="Engine: This class is a singleton. Please use the getInstance() method instead.";var e=c.MessageType;var _=new WeakMap();var o;
var f=A.extend("sap.ui.mdc.p13n.Engine",{constructor:function(){A.call(this);if(o){throw Error(d);}this._aRegistry=[];this._aStateHandlers=[];this.defaultProviderRegistry=D.getInstance();this.uimanager=U.getInstance(this);this.stateHandlerRegistry=b.getInstance();}});
f.prototype.registerAdaptation=function(C,a){if(!a.hasOwnProperty("controller")){throw new Error("Please provide atleast a configuration 'controller' containing a map of key-value pairs (key + Controller class) in order to register adaptation.");}if(this._getRegistryEntry(C)){this.deregisterAdaptation(C);}var g=Object.keys(a.controller);g.forEach(function(k){var h=a.controller[k];if(!this.getController(C,k)){if(this._aRegistry.indexOf(C.getId())<0){this._aRegistry.push(C.getId());}var i=new h(C);this.addController(i,k);}}.bind(this));};
f.prototype.deregisterAdaptation=function(C){var r=this._getRegistryEntry(C);Object.keys(r.controller).forEach(function(k){var a=r.controller[k];a.destroy();delete r.controller[k];});_.delete(C);var i=this._aRegistry.indexOf(C.getId());this._aRegistry.splice(i,1);};
f.prototype._setModificationHandler=function(C,a){if(!a.isA("sap.ui.mdc.p13n.modification.ModificationHandler")){throw new Error("Only sap.ui.mdc.p13n.modification.ModificationHandler derivations are allowed for modification");}var g=this._determineModification(C);g.handler=a;this._getRegistryEntry(C).modification=g;};
f.prototype.createChanges=function(g){var C=g.control;var k=g.key;var n=g.state;var h=!!g.applyAbsolute;var s=!!g.suppressAppliance;if(!k||!C||!n){throw new Error("To create changes via Engine, atleast a 1)Control 2)Key and 3)State needs to be provided.");}return this.initAdaptation(C,k).then(function(){var i=this.getController(C,k);var j=i.getChangeOperations();var r=this._getRegistryEntry(C);var l=i.getCurrentState();var p=m(l instanceof Array?[]:{},l);var q={existingState:p,applyAbsolute:h,changedState:n,control:i.getAdaptationControl(),changeOperations:j,deltaAttributes:["name"],propertyInfo:r.helper.getProperties().map(function(a){return{name:a.name};})};var t=i.getDelta(q);if(!s){this._processChanges(C,t);}return t||[];}.bind(this));};
f.prototype.reset=function(C,k){k=k instanceof Array?k:[k];var s=[];k.forEach(function(K){s=s.concat(this.getController(C,K).getSelectorForReset());}.bind(this));var r={selectors:s,selector:C};var a=this._determineModification(C);return a.handler.reset(r,a.payload).then(function(){this.stateHandlerRegistry.fireChange(C);return this.initAdaptation(C,k).then(function(p){k.forEach(function(K){var g=this.getController(C,K);g.update(p);}.bind(this));}.bind(this));}.bind(this));};
f.prototype.waitForChanges=function(C){var a=this._determineModification(C);return a.handler.waitForChanges({element:C},a.payload);};
f.prototype.isModificationSupported=function(C){var a=this._determineModification(C);return a.handler.isModificationSupported({element:C},a.payload);};
f.prototype._processChanges=function(C,a){if(a instanceof Array&&a.length>0){var g=this._determineModification(C);return g.handler.processChanges(a,g.payload).then(function(a){this.stateHandlerRegistry.fireChange(f.getControlInstance(C));return a;}.bind(this));}else{return Promise.resolve([]);}};
f.prototype.getRTASettingsActionHandler=function(C,p,k){var r;var a=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");if(a.length>0&&!C.isA("sap.ui.mdc.link.Panel")){return Promise.reject("Please do not use a PeristenceProvider in RTA.");}var g=this.getModificationHandler(C);var i=g.processChanges;var R=new Promise(function(h,j){r=h;});g.processChanges=function(h){r(h);return Promise.resolve(h);};this._setModificationHandler(C,g);this.uimanager.show(C,k).then(function(h){var j=h.getCustomHeader();if(j){j.getContentRight()[0].setVisible(false);}h.addStyleClass(p.styleClass);if(p.fnAfterClose instanceof Function){h.attachAfterClose(p.fnAfterClose);}});R.then(function(){g.processChanges=i;});return R;};
f.prototype.enhanceXConfig=function(C,a){var g=f.getControlInstance(C);var r=this._getRegistryEntry(C);return Promise.resolve().then(function(){if(r){var h=this.getModificationHandler(C);return h.enhanceConfig(g,a).then(function(i){r.xConfig=i;});}else{throw new Error("The control instance needs to be registered to use xConfig!");}}.bind(this));};
f.prototype.readXConfig=function(C,a,s){var g=f.getControlInstance(C);var h=this.getModificationHandler(C);return h.readConfig(g,a,s)||Promise.resolve({});};
f.prototype.applyState=function(C,s,a){return this.retrieveState(C).then(function(g){var h=[],i=[],I={};if(C.validateState instanceof Function){I=C.validateState(S._externalizeKeys(s));}if(I.validation===e.Error){L.error(I.message);}Object.keys(s).forEach(function(j){var k=this.getController(C,j);if(!k){return;}var l=this.createChanges({control:C,key:j,state:k.sanityCheck(s[j]),suppressAppliance:true,applyAbsolute:a});h.push(l);}.bind(this));return Promise.all(h).then(function(r){r.forEach(function(j){if(j&&j.length>0){i=i.concat(j);}});return this._processChanges(C,i);}.bind(this));}.bind(this));};
f.prototype.retrieveState=function(C){var v=this.checkXStateInterface(C);if(!v){throw new Error("The control needs to implement the interface IxState.");}return C.initialized().then(function(){return f.getInstance().waitForChanges(C).then(function(){var r={};f.getInstance().getRegisteredControllers(C).forEach(function(k){r[k]=f.getInstance().getController(C,k).getCurrentState();});return m({},r);});});};
f.prototype.checkXStateInterface=function(C){if(!C){return false;}if(!this.isModificationSupported(C)){return false;}if(!C.isA("sap.ui.mdc.IxState")){return false;}return true;};
f.prototype.initAdaptation=function(C,k,a){this.verifyController(C,k);return this._retrievePropertyHelper(C,a);};
f.prototype.addController=function(C,k,p){var r=this._createRegistryEntry(C.getAdaptationControl(),p);r.controller[k]=C;};
f.prototype.getController=function(C,k){var r=this._getRegistryEntry(C);if(r&&r.controller.hasOwnProperty(k)){return r.controller[k];}};
f.prototype.verifyController=function(C,k){var K=k instanceof Array?k:[k];K.forEach(function(s){if(!this.getController(C,s)){var a=f.getControlInstance(C);throw new Error("No controller registered yet for "+a.getId()+" and key: "+s);}}.bind(this));};
f.prototype.getUISettings=function(C,k){var K=Array.isArray(k)?k:[k];this.verifyController(C,K);var p=this._getRegistryEntry(C).helper;var u={};K.forEach(function(s){var a=this.getController(C,s);var g=a.getAdaptationUI(p);if(g instanceof Promise){u[s]={};u[s]={resetEnabled:a.getResetEnabled(),containerSettings:a.getUISettings(),adaptationUI:g};}}.bind(this));return u;};
f.prototype.isRegisteredForModification=function(C){var r=this._getRegistryEntry(C);return r&&!!r.modification;};
f.prototype.getRegisteredControllers=function(C){var r=this._getRegistryEntry(C);return Object.keys(r.controller);};
f.prototype._getRegistryEntry=function(C){var a=f.getControlInstance(C);return _.get(a);};
f.prototype.getModificationHandler=function(C){var a=this._determineModification(C);return a.handler;};
f.prototype._createRegistryEntry=function(C,p){var a=f.getControlInstance(C);if(!_.has(a)){_.set(a,{modification:p&&p.modification?p.modification:null,controller:{},activeP13n:null,helper:null,xConfig:null});}return _.get(a);};
f.prototype._determineModification=function(C){var r=this._getRegistryEntry(C);if(r&&r.modification){return r.modification;}var p=f.hasForReference(C,"sap.ui.mdc.p13n.PersistenceProvider");var v=f.hasForReference(C,"sap.ui.fl.variants.VariantManagement");var a=p.length?p:undefined;var h=a?a[0].getMode():"Standard";var H={Global:F,Transient:F,Standard:F,Auto:F};var g=H[h];if(!g){throw new Error("Please provide a valid ModificationHandler! - valid Modification handlers are:"+Object.keys(H));}var i={handler:g.getInstance(),payload:{hasVM:v&&v.length>0,hasPP:p&&p.length>0,mode:h}};if(r&&!r.modification){r.modification=i;}return i;};
f.hasForReference=function(C,s){var a=C&&C.getId?C.getId():C;var r=E.registry.filter(function(g){if(!g.isA(s)){return false;}var h=g.getFor();for(var n=0;n<h.length;n++){if(h[n]===a||f.hasControlAncestorWithId(a,h[n])){return true;}}return false;});return r;};
f.hasControlAncestorWithId=function(C,a){var g;if(C===a){return true;}g=sap.ui.getCore().byId(C);while(g){if(g.getId()===a){return true;}if(typeof g.getParent==="function"){g=g.getParent();}else{return false;}}return false;};
f.getControlInstance=function(C){return typeof C=="string"?sap.ui.getCore().byId(C):C;};
f.prototype.hasActiveP13n=function(C){return!!this._getRegistryEntry(C).activeP13n;};
f.prototype.setActiveP13n=function(C,k){this._getRegistryEntry(C).activeP13n=k;};
f.prototype.validateP13n=function(C,k,p){var a=this.getController(C,k);var g=f.getControlInstance(C);var h=this._getRegistryEntry(C).controller;var t={};Object.keys(h).forEach(function(s){t[s]=h[s].getCurrentState();});if(a.model2State instanceof Function){t[k]=a.model2State();var i=g.validateState(S._externalizeKeys(t),k);var j;if(i.validation!==e.None){j=new M({type:i.validation,text:i.message});}if(p.setMessageStrip instanceof Function){p.setMessageStrip(j);}else{L.warning("message strip could not be provided - the adaptation UI needs to implement 'setMessageStrip'");}}};
f.prototype.handleP13n=function(C,k){var a=[];k.forEach(function(s){var g=this.getController(C,s);var p=this.createChanges({control:C,key:s,state:g.getP13nData(),suppressAppliance:true,applyAbsolute:true}).then(function(i){return g.getBeforeApply().then(function(h){var j=h?h.concat(i):i;return j;});});a.push(p);}.bind(this));return Promise.all(a).then(function(g){var h=[];g.forEach(function(t){h=h.concat(t);});if(h.length>0){f.getInstance()._processChanges(C,h);}});};
f.prototype._retrievePropertyHelper=function(C,a){var r=this._getRegistryEntry(C);var g=f.getControlInstance(C);if(a){if(r.helper){r.helper.destroy();}r.helper=new P(a);return Promise.resolve(r.helper);}if(r.helper){return Promise.resolve(r.helper);}return g.initPropertyHelper().then(function(p){r.helper=p;return p;},function(h){throw new Error(h);});};
f.getInstance=function(){if(!o){o=new f();}return o;};
f.prototype._getRegistry=function(){var r={stateHandlerRegistry:this.stateHandlerRegistry,defaultProviderRegistry:this.defaultProviderRegistry,controlRegistry:{}};this._aRegistry.forEach(function(k){var C=sap.ui.getCore().byId(k);r.controlRegistry[k]=_.get(C);});return r;};
f.prototype.destroy=function(){A.prototype.destroy.apply(this,arguments);o=null;this._aRegistry=null;_.delete(this);this.defaultProviderRegistry.destroy();this.defaultProviderRegistry=null;this.stateHandlerRegistry.destroy();this.stateHandlerRegistry=null;this.uimanager.destroy();this.uimanager=null;};
return f;});
sap.ui.predefine('sap/ui/mdc/p13n/FlexUtil',['sap/base/util/array/diff','sap/base/util/deepEqual','sap/ui/mdc/condition/FilterOperatorUtil','sap/base/Log'],function(d,a,F,L){"use strict";var b={getPropertySetterChanges:function(D){var c=D.control;var e=D.existingState;var C=D.changedState;var o=D.operation;var s=D.deltaAttribute;var S=[];C.forEach(function(i){if(i.hasOwnProperty(s)){var E=e.find(function(f){return f.name==i.name;});var O=E&&E.hasOwnProperty(s)&&E[s];var n=i[s];var v=O!==n;if(v){S.push(this.createChange(c,o,{name:i.name,value:i[s]}));}}}.bind(this));return S;},_getChangeContent:function(p,D){var c={};if(p.index>=0){c.index=p.index;}D.forEach(function(A){if(p.hasOwnProperty(A)){c[A]=p[A];}});return c;},getConditionDeltaChanges:function(D){var c=[];var n=D.changedState;var p=D.existingState;var A=D.control;var P=D.propertyInfo;for(var f in n){var v=b._hasProperty(P,f);if(!v){L.warning("property '"+f+"' not supported");continue;}var e=b._diffConditionPath(f,n[f],p[f],A);if(A&&A.createPropertyInfoChanges&&(e.length>0)){e=A.createPropertyInfoChanges(f).concat(e);}c=c.concat(e);}return c;},_hasProperty:function(p,n){return p.some(function(P){var v=P.name===n||n=="$search";v=v?v:P.path===n;return v;});},_diffConditionPath:function(f,o,O,c){var C,e=[];var g=o;var s=O?O:[];if(a(g,s)){return e;}var r=function(g,s){var R;do{R=false;for(var i=0;i<g.length;i++){var n=F.indexOfCondition(g[i],s);if(n>-1){g.splice(i,1);s.splice(n,1);R=true;break;}}}while(R);};r(g,s);if((g.length>0)||(s.length>0)){s.forEach(function(h){C=b.createConditionChange("removeCondition",c,f,h);if(C){e.push(C);}});g.forEach(function(h){C=b.createConditionChange("addCondition",c,f,h);if(C){e.push(C);}});}return e;},createChange:function(c,o,C){var A={selectorElement:c,changeSpecificData:{changeType:o,content:C}};return A;},createConditionChange:function(c,C,f,o){var e={selectorElement:C,changeSpecificData:{changeType:c,content:{name:f,condition:o}}};return e;},handleChanges:function(c,i,u){return new Promise(function(r,e){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.add({changes:c,ignoreVariantManagement:i,useStaticArea:u}).then(function(D){r(D);},e);});});},saveChanges:function(c,D){return new Promise(function(r,e){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.save({selector:c,changes:D}).then(r);});});},restore:function(p){return new Promise(function(r,c){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.restore(p).then(function(){r();},c);});});},reset:function(p){return new Promise(function(r,c){sap.ui.require(["sap/ui/fl/write/api/ControlPersonalizationWriteAPI"],function(C){C.reset(p).then(function(){r();},c);});});}};return b;});
sap.ui.predefine('sap/ui/mdc/p13n/P13nBuilder',["./PropertyHelper","sap/m/Button","sap/m/Bar","sap/m/Title","sap/base/util/merge","sap/m/MessageBox","sap/ui/Device"],function(P,B,a,T,m,M,D){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var b={createP13nPopover:function(p,d){return new Promise(function(c,e){sap.ui.require(["sap/m/ResponsivePopover"],function(R){b["_checkSettings"](p,d,e);var o=new R({title:d.title,horizontalScrolling:d.hasOwnProperty("horizontalScrolling")?d.horizontalScrolling:false,verticalScrolling:d.hasOwnProperty("verticalScrolling")?d.verticalScrolling:false,contentWidth:d.contentWidth?d.contentWidth:"24rem",resizable:d.hasOwnProperty("resizable")?d.resizable:true,contentHeight:d.contentHeight?d.contentHeight:"35rem",placement:d.placement?d.placement:"Bottom",content:p,afterClose:d.afterClose?d.afterClose:function(){}});if(d.reset){var C=b._createResetHeader({title:d.title,reset:d.reset.onExecute,idResetButton:d.reset.idButton,warningText:d.reset.warningText});o.setCustomHeader(C);}c(o);},e);});},createP13nDialog:function(p,d){return new Promise(function(c,e){b["_checkSettings"](p,d,e);var i=d.id;sap.ui.require(["sap/m/Dialog","sap/m/Button"],function(f,B){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var C=new f(i,{title:d.title,horizontalScrolling:d.hasOwnProperty("horizontalScrolling")?d.horizontalScrolling:false,verticalScrolling:d.hasOwnProperty("verticalScrolling")?d.verticalScrolling:true,contentWidth:d.contentWidth?d.contentWidth:"40rem",contentHeight:d.contentHeight?d.contentHeight:"55rem",draggable:true,resizable:true,stretch:D.system.phone,content:p,afterClose:d.afterClose?d.afterClose:function(){},buttons:[new B(i?i+"-confirmBtn":undefined,{text:d.confirm&&d.confirm.text?d.confirm.text:R.getText("p13nDialog.OK"),type:"Emphasized",press:function(){if(d.confirm&&d.confirm.handler){d.confirm.handler.apply(C,arguments);}}}),new B(i?i+"-cancelBtn":undefined,{text:R.getText("p13nDialog.CANCEL"),press:function(){d.cancel.apply(C,arguments);}})]});if(d.reset){var o=b._createResetHeader({title:d.title,idResetButton:d.reset.idButton,reset:d.reset.onExecute,warningText:d.reset.warningText});C.setCustomHeader(o);}var A=d.additionalButtons;if(A instanceof Array){A.forEach(function(g){if(!g.isA("sap.m.Button")){e("Please only provide sap.m.Button instances as 'additionalButtons'");}C.addButton(g);});}c(C);},e);});},_createResetHeader:function(s){var o=new a({contentLeft:[new T({text:s.title})]});if(s.reset){var i=s.idResetButton;o.addContentRight(new B(i,{text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.RESET"),press:function(e){var d=e.getSource().getParent().getParent();var c=d.getParent();var R=s.warningText?s.warningText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_RESET_WARNING");M.warning(R,{actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK,onClose:function(A){if(A===M.Action.OK){d.getButtons()[0].focus();s.reset(c);}}});}}));}return o;},prepareAdaptationData:function(p,e,g){var o=p&&p.getProperties instanceof Function?p:new P(p);var i=[];var I=g?{}:null;var E=e instanceof Function;o.getProperties().forEach(function(c){var d={};if(E){var f=e(d,c);if(!f){return;}}d.name=c.name;d.label=c.label||c.name;d.tooltip=c.tooltip;if(I){d.group=c.group?c.group:"BASIC";d.groupLabel=c.groupLabel;I[d.group]=I[d.group]?I[d.group]:[];I[d.group].push(d);}i.push(d);});var A={items:i};if(I){A.itemsGrouped=this._buildGroupStructure(I);}return A;},sortP13nData:function(s,i){var p=s;var c=p.position;var S=p.visible;var l=sap.ui.getCore().getConfiguration().getLocale().toString();var C=window.Intl.Collator(l,{});i.sort(function(f,F){if(f[S]&&F[S]){return(f[c]||0)-(F[c]||0);}else if(f[S]){return-1;}else if(F[S]){return 1;}else if(!f[S]&&!F[S]){return C.compare(f.label,F.label);}});},_buildGroupStructure:function(i){var g=[];Object.keys(i).forEach(function(G){this.sortP13nData("generic",i[G]);g.push({group:G,groupLabel:i[G][0].groupLabel||r.getText("p13nDialog.FILTER_DEFAULT_GROUP"),groupVisible:true,items:i[G]});}.bind(this));return g;},_isExcludeProperty:function(p,i){return i.some(function(k){var I=k.ignoreKey;var v=k.ignoreValue;return p[I]===v;});},_checkSettings:function(p,d,o){if(!d){o("Please provide a settings object for p13n creation");}if(!d.title&&!d.customHeader){o("Please provide a title or customHeader in the settings object for p13n creation");}},arrayToMap:function(A){return A.reduce(function(c,p,i){c[p.name]=p;c[p.name].position=i;return c;},{});}};return b;});
sap.ui.predefine('sap/ui/mdc/p13n/PropertyHelper',["../util/PropertyHelper"],function(P){"use strict";
var a=P.extend("sap.ui.mdc.p13n.PropertyHelper",{constructor:function(p,e,o,E){var A=["filterable","sortable"];P.call(this,p,e,o,A,E);}});
a.prototype.validateProperties=function(){};
a.prototype.prepareProperty=function(p){P.prototype.prepareProperty.apply(this,arguments);p.label=p.label||p.name;};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/StateUtil',[],function(){"use strict";var S={applyExternalState:function(c,s){return c.getEngine().applyState(c,S._internalizeKeys(s));},retrieveExternalState:function(c){return c.getEngine().retrieveState(c).then(function(e){return S._externalizeKeys(e);});},attachStateChange:function(l){sap.ui.mdc.p13n.Engine.getInstance().stateHandlerRegistry.attachChange(l);},detachStateChange:function(l){sap.ui.mdc.p13n.Engine.getInstance().stateHandlerRegistry.detachChange(l);},_externalizeKeys:function(i){var k={Sort:"sorters",Group:"groupLevels",Aggregate:"aggregations",Filter:"filter",Item:"items",Column:"items",ColumnWidth:"supplementaryConfig"};var t={};Object.keys(i).forEach(function(p){var e=k[p];var T=e||p;t[T]=i[p];});return t;},_internalizeKeys:function(e){var k={sorters:["Sort"],groupLevels:["Group"],aggregations:["Aggregate"],filter:["Filter"],items:["Item","Column"],supplementaryConfig:["ColumnWidth"]};var t={};Object.keys(e).forEach(function(p){if(k[p]){k[p].forEach(function(T){t[T]=e[p];});}});return t;}};return S;});
sap.ui.predefine('sap/ui/mdc/p13n/UIManager',["sap/ui/base/Object","sap/ui/mdc/p13n/P13nBuilder","sap/m/p13n/Container","sap/m/p13n/AbstractContainerItem","sap/base/util/UriParameters","sap/base/Log"],function(B,P,a,A,S,L){"use strict";var E="UIManager: This class is a singleton and should not be used without an AdaptationProvider. Please use 'sap.ui.mdc.p13n.Engine.getInstance().uimanager' instead";var u;var U=new S(window.location.search);
var b=B.extend("sap.ui.mdc.p13n.UIManager",{constructor:function(o){if(u){throw Error(E);}this.oAdaptationProvider=o;B.call(this);}});
b.prototype.show=function(c,k,s){this.bLiveMode=false;if(U.getAll("sap-ui-xx-p13nLiveMode")[0]==="true"){this.bLiveMode=true;L.warning("Please note that the p13n liveMode is experimental");}if(!this.hasActiveP13n(c)){this.setActiveP13n(c,k);return this.create(c,k).then(function(p){this._openP13nControl(c,k,p,s);return p;}.bind(this),function(e){this.setActiveP13n(c,null);L.error("Engine UI failure:"+e.stack);}.bind(this));}else{return Promise.resolve();}};
b.prototype.create=function(c,k,C){var K=k instanceof Array?k:[k];var o=typeof c=="string"?sap.ui.getCore().byId(c):c;return this.oAdaptationProvider.initAdaptation(c,K,C).then(function(){return this._retrieveP13nContainer(o,K).then(function(d){o.addDependent(d);return d;});}.bind(this));};
b.prototype._openP13nControl=function(c,k,p,s){var K=k instanceof Array?k:[k];if(this.bLiveMode){p.openBy(s);delete this.bLiveMode;}else{p.open();}if(this.oAdaptationProvider&&this.oAdaptationProvider.validateP13n instanceof Function){K.forEach(function(d){var w=K.length>1;var o;var C=p.getContent()[0];if(w&&C.isA("sap.m.p13n.Container")&&C.getView(d)){o=C.getView(d).getContent();}else{o=C;}this.oAdaptationProvider.validateP13n(c,d,o);}.bind(this));}};
b.prototype._retrieveP13nContainer=function(c,k){var p=[];var d=k instanceof Array&&k.length>1;var o=this.oAdaptationProvider.getUISettings(c,k);k.forEach(function(r){if(!o[r]){k.splice(k.indexOf(r),1);return;}});k.forEach(function(r){var e=o[r].adaptationUI;e._key=r;var f=e.then(function(g){if(this.bLiveMode&&g&&g.attachChange){g.attachChange(function(){this.oAdaptationProvider.handleP13n(c,k);}.bind(this));}if(g&&g.attachChange){g.attachChange(function(h){var K=d?h.getSource().getParent().getParent().getCurrentViewKey():k[0];this.oAdaptationProvider.validateP13n(c,K,g);}.bind(this));}var s=o[e._key];return{key:e._key,tab:s.containerSettings&&s.containerSettings.tabText?s.containerSettings.tabText:e._key,panel:g};}.bind(this));p.push(f);}.bind(this));return Promise.all(p).then(function(e){var f=d?new a():e[0].panel;if(d){e.forEach(function(m){if(m.panel){f.addView(new A({key:m.key,text:m.tab,content:m.panel}));}});f.switchView(e[0].key);}return this._createUIContainer(c,k,f,o).then(function(D){return D;});}.bind(this));};
b.prototype._createUIContainer=function(c,k,p,o){var C;var m=k.length>1?this._getDefaultContainerConfig(o):o[k[0]];if(this.bLiveMode){C=this._createPopover(c,k,p,m);}else{C=this._createModalDialog(c,k,p,m);}return C.then(function(d){d.addStyleClass("sapUiMdcPersonalizationDialog");d.isPopupAdaptationAllowed=function(){return false;};if(this.bLiveMode===false){d.setEscapeHandler(function(D){this.setActiveP13n(c,null);k.forEach(function(K){if(o[K].containerSettings&&o[K].containerSettings.afterClose instanceof Function){o[K].containerSettings.afterClose({getSource:function(){return d;}});}});d.close();d.destroy();D.resolve();}.bind(this));}d.toggleStyleClass("sapUiSizeCompact",!!jQuery(c).closest(".sapUiSizeCompact").length);return d;}.bind(this));};
b.prototype._createPopover=function(c,k,p,m){var f=function(e){var o=e.getSource();this.setActiveP13n(c,null);o.destroy();}.bind(this);var s=Object.assign({verticalScrolling:true,reset:m.reset,afterClose:f},m.containerSettings);if(m.resetEnabled){s.reset={onExecute:function(){k.forEach(function(K){this.oAdaptationProvider.reset(c,K);}.bind(this));}};}return P.createP13nPopover(p,s);};
b.prototype._createModalDialog=function(c,k,p,m){var d=function(e){var o=e.getSource().getParent();var f=this._confirmContainer(c,k,p);f.then(function(){this.setActiveP13n(c,null);o.close();}.bind(this));}.bind(this);var D=function(e){var C=e.getSource().getParent();this.setActiveP13n(c,null);C.close();}.bind(this);var s=Object.assign({verticalScrolling:true,reset:m.reset||{},afterClose:function(e){var o=e.getSource();if(o){o.destroy();}},cancel:D},m.containerSettings);if(m.resetEnabled){s.reset.onExecute=function(){this.oAdaptationProvider.reset(c,k);}.bind(this);}s.confirm={handler:function(e){d(e);}};return P.createP13nDialog(p,s);};
b.prototype.setActiveP13n=function(c,k){if(this.oAdaptationProvider.setActiveP13n instanceof Function){this.oAdaptationProvider.setActiveP13n(c,k);}};
b.prototype.hasActiveP13n=function(c){var d=false;if(this.oAdaptationProvider.hasActiveP13n instanceof Function){d=this.oAdaptationProvider.hasActiveP13n(c);}return d;};
b.prototype._getDefaultContainerConfig=function(o){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var k=Object.keys(o);var c={containerSettings:{title:r.getText("p13nDialog.VIEW_SETTINGS"),verticalScrolling:false,contentHeight:o.contentHeight,contentWidth:o.contentWidth,afterClose:function(e){k.forEach(function(K){if(o[K]&&o[K].containerSettings&&o[K].containerSettings.afterClose instanceof Function){o[K].containerSettings.afterClose(e);}});e.getSource().destroy();}}};if(o.resetEnabled!==false){c.reset={onExecute:function(C){this.oAdaptationProvider.reset(C,k);}.bind(this),warningText:r.getText("p13nDialog.RESET_WARNING_TEXT")};}return c;};
b.prototype._confirmContainer=function(c,k){return this.oAdaptationProvider.handleP13n(c,k);};
b._checkValidInterface=function(o){if(!o||!o.isA("sap.ui.mdc.p13n.AdaptationProvider")){throw Error("The UIManager singleton must not be accessed without an AdaptationProvider interface!");}};
b.getInstance=function(o){if(!u){this._checkValidInterface(o);u=new b(o);}return u;};
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);u=null;};
return b;});
sap.ui.predefine('sap/ui/mdc/p13n/modification/FlexModificationHandler',["./ModificationHandler","sap/ui/mdc/p13n/FlexUtil","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/mdc/enum/PersistenceMode"],function(M,F,a,m){"use strict";var f;
var b=M.extend("sap.ui.mdc.p13n.modification.FlexModificationHandler");
b.prototype.processChanges=function(c,o){var C=c&&c[0]?c[0].selectorElement:undefined;var i=o.mode;var I=i===m.Auto;if(I){i=o.hasVM?"Standard":m.Global;}var d=i===m.Global;var e=i===m.Transient;var h=F.handleChanges.call(this,c,d,e);return d?h.then(function(D){return F.saveChanges.call(this,C,D);}):h;};
b.prototype.waitForChanges=function(p,o){return a.waitForChanges.apply(this,arguments);};
b.prototype.reset=function(p,o){var P=o.mode;var i=P===m.Global;var I=!o.hasVM&&o.hasPP&&P===m.Auto;return(i||I)?F.reset.call(this,p):F.restore.call(this,p);};
b.prototype.isModificationSupported=function(p,o){return a.isFlexSupported.apply(this,arguments);};
b.getInstance=function(){if(!f){f=new b();}return f;};
return b;});
sap.ui.predefine('sap/ui/mdc/p13n/modification/ModificationHandler',["sap/ui/base/Object","sap/base/util/merge","sap/ui/core/util/reflection/JsControlTreeModifier"],function(B,m,J){"use strict";var M;
var a=B.extend("sap.ui.mdc.p13n.modification.ModificationHandler");
a.prototype.processChanges=function(c,o){return Promise.resolve();};
a.prototype.waitForChanges=function(p,o){return Promise.resolve();};
a.prototype.reset=function(p,o){return Promise.resolve();};
a.prototype.isModificationSupported=function(p,o){return false;};
a.prototype.enhanceConfig=function(c,o){var p=o.propertyBag;var b=p?p.modifier:J;var P=o.name;var C=o.controlMeta;var A=C.aggregation;var s=C.property;var v=o.value;var d;var e;var x;return b.getControlMetadata(c).then(function(r){d=r;e=A?A:d.getDefaultAggregation().name;return b.getAggregation(c,"customData");}).then(function(f){return Promise.all(f.map(function(g){return b.getProperty(g,"key");})).then(function(g){return f.reduce(function(r,h,i){return g[i]==="xConfig"?h:r;},undefined);});}).then(function(r){x=r;if(x){return b.getProperty(x,"value");}return{aggregations:{}};}).then(function(f){if(!f.aggregations.hasOwnProperty(e)){if(d.hasAggregation(e)){f.aggregations[e]={};}else{throw new Error("The aggregation "+e+" does not exist for"+c);}}if(!f.aggregations.hasOwnProperty(P)){f.aggregations[e][P]={};}if(v!==null){f.aggregations[e][P][s]=v;}else{delete f.aggregations[e][P][s];if(Object.keys(f.aggregations[e][P]).length===0){delete f.aggregations[e][P];if(Object.keys(f.aggregations[e]).length===0){delete f.aggregations[e];}}}var g=p?p.appComponent:undefined;if(!c._pXConfigCreation){c._pXConfigCreation=b.createAndAddCustomData(c,"xConfig",f,g);return c._pXConfigCreation.then(function(){return f;});}else{c._pXConfigCreation.then(function(h){b.setProperty(h,"value",f);return f;});}});};
a.prototype.readConfig=function(c,o){var C,A;if(o){var b=o.propertyBag?o.propertyBag.modifier:J;return b.getAggregation(c,"customData").then(function(d){return Promise.all(d.map(function(e){return b.getProperty(e,"key");})).then(function(e){return d.reduce(function(r,f,i){return e[i]==="xConfig"?f:r;},undefined);});}).then(function(A){if(A){return b.getProperty(A,"value").then(function(v){return m({},v);});}return null;});}var g=function(p,s){var f=function(c,s){if(c){if(c.getMetadata){var e=c.getMetadata();var h=e.getAllAggregations();if(h){return h[s];}}}return undefined;};var d=f(p,s);if(d){return p[d._sGetter]();}return undefined;};var G=function(c,p){var d=c.getMetadata().getPropertyLikeSetting(p);if(d){var P=d._sGetter;return c[P]();}return undefined;};A=g(c,"customData").find(function(d){return G(d,"key")=="xConfig";});C=A?m({},G(A,"value")):null;return C;};
a.getInstance=function(){if(!M){M=new a();}return M;};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/modules/DefaultProviderRegistry',["sap/ui/base/Object","sap/ui/mdc/p13n/PersistenceProvider"],function(B,P){"use strict";var E="DefaultProviderRegistry: This class is a singleton and should not be used without an AdaptationProvider. Please use 'sap.ui.mdc.p13n.Engine.getInstance().defaultProviderRegistry' instead";var d;
var D=B.extend("sap.ui.mdc.p13n.modules.DefaultProviderRegistry",{constructor:function(){if(d){throw Error(E);}B.call(this);this._mDefaultProviders={};}});
D.prototype.destroy=function(){Object.keys(this._mDefaultProviders).forEach(function(p){this._mDefaultProviders[p].destroy();delete this._mDefaultProviders[p];}.bind(this));B.prototype.destroy.apply(this,arguments);};
D.prototype.attach=function(c,p){if(c.getEngine().isRegisteredForModification(c)){throw new Error("DefaultProviderRegistry: You must not change the modificationSettings for an already registered control");}var o=this._retrieveDefaultProvider(p);var C=typeof c==="string"?c:c.getId();if(o.getFor().indexOf(C)===-1){o.addFor(c);}return o;};
D.prototype.detach=function(c){Object.keys(this._mDefaultProviders).forEach(function(m){var o=this._mDefaultProviders[m];o.removeFor(c);}.bind(this));};
D.prototype._retrieveDefaultProvider=function(p){this._mDefaultProviders[p]=this._mDefaultProviders[p]||new P({mode:p});return this._mDefaultProviders[p];};
D.getInstance=function(){if(!d){d=new D();}return d;};
return D;});
sap.ui.predefine('sap/ui/mdc/p13n/modules/StateHandlerRegistry',["sap/ui/base/EventProvider"],function(E){"use strict";var a="StateHandlerRegistry: This class is a singleton and should not be used without an AdaptationProvider. Please use 'sap.ui.mdc.p13n.Engine.getInstance().stateHandlerRegistry' instead";var s;
var S=E.extend("sap.ui.mdc.p13n.modules.StateHandlerRegistry",{constructor:function(){if(s){throw Error(a);}E.call(this);}});
S.prototype.attachChange=function(f){return E.prototype.attachEvent.call(this,"stateChange",f);};
S.prototype.detachChange=function(f){return E.prototype.detachEvent.call(this,"stateChange",f);};
S.prototype.fireChange=function(c){return E.prototype.fireEvent.call(this,"stateChange",{control:c});};
S.getInstance=function(){if(!s){s=new S();}return s;};
return S;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/ActionToolbarPanel',["./ListView","sap/ui/model/Sorter"],function(L,S){"use strict";
var A=L.extend("sap.ui.mdc.p13n.panels.ActionToolbarPanel",{
metadata:{library:"sap.ui.mdc"},
renderer:{apiVersion:2}
});
A.prototype._bindListItems=function(b){var t=this.getTemplate();if(t){var g=function(c){return c.getProperty("alignment");};var s=new S({path:"alignment",descending:false,group:g});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",sorter:s,key:"name",templateShareable:false,template:this.getTemplate().clone()},b));}};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/AdaptFiltersPanel',["sap/ui/mdc/ui/Container","sap/ui/mdc/ui/ContainerItem","./ListView","./GroupView","sap/ui/model/Filter","sap/m/Button","sap/m/Bar","sap/m/ToolbarSpacer","sap/m/Select","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/SearchField","sap/m/OverflowToolbarLayoutData","sap/ui/core/Item","sap/base/util/UriParameters","sap/m/library"],function(C,a,L,G,F,B,b,T,S,c,d,e,O,I,f,l){"use strict";var g=l.BarDesign;
var A=C.extend("sap.ui.mdc.p13n.panels.AdaptFiltersPanel",{
metadata:{library:"sap.ui.mdc",properties:{itemFactory:{type:"function"},enableReorder:{type:"boolean",defaultValue:true}}},
renderer:{apiVersion:2}
});
A.prototype.GROUP_KEY="group";A.prototype.LIST_KEY="list";A.prototype.P13N_MODEL="$p13n";
A.prototype.applySettings=function(s){this.addView(new a({key:this.LIST_KEY,content:new L(this.getId()+"-listView")}));this.addView(new a({key:this.GROUP_KEY,content:new G(this.getId()+"-groupView",{})}));C.prototype.applySettings.apply(this,arguments);this.getView(this.LIST_KEY).getContent().setEnableReorder(this.getEnableReorder());var q=this._getQuickFilter();var v=this._getViewSwitch();var o=this._getShowHideBtn();var h=new b({contentMiddle:[q,new T(),o,v]});h.setDesign(g.SubHeader);this.setHeader(h);var i=new b({contentMiddle:[this._getSearchField()]});i.addStyleClass("sapUiMDCAdaptFiltersSearchBar");i.setDesign(g.SubHeader);this.setSubHeader(i);this.addStyleClass("sapUiMDCAdaptFiltersPanel");};
A.prototype.setItemFactory=function(i){this.setProperty("itemFactory",i);this.getViews().forEach(function(v){var p=v.getContent();p.setItemFactory(i);});return this;};
A.prototype.switchView=function(k){var s=k;C.prototype.switchView.call(this,s);this._getShowHideBtn().setVisible(!this._isCustomView());this._getViewSwitch().setSelectedKey(this.getCurrentViewKey());if(!this._isCustomView(k)){this.showFactory(this.getCurrentViewContent().getShowFactory());}this._filterByModeAndSearch();};
A.prototype.addCustomView=function(v){var i=v.item;var k=i.getKey();var o=v.content;var h=v.search;var s=v.selectionChange;var D=v.filterSelect;if(!k){throw new Error("Please provide an item of type sap.m.SegmentedButtonItem with a key");}if(this._oViewSwitch){this._oViewSwitch.attachSelectionChange(function(E){if(s){s(E.getParameter("item").getKey());}if(this._isCustomView()){if(h instanceof Function){h(this._getSearchField().getValue());}if(D instanceof Function){D(this._getQuickFilter().getSelectedKey());}}}.bind(this));}if(h instanceof Function){this._getSearchField().attachLiveChange(function(E){if(this._isCustomView()){h(this._getSearchField().getValue());}}.bind(this));}if(D instanceof Function){this._getQuickFilter().attachChange(function(E){if(this._isCustomView()){D(this._getQuickFilter().getSelectedKey());}}.bind(this));}this.addView(new a({key:k,content:o.addStyleClass("sapUiMDCPanelPadding")}));var V=this._getViewSwitch();V.addItem(i);};
A.prototype.showFactory=function(s){if(this.getCurrentViewContent().showFactory){this.getCurrentViewContent().showFactory(s);}};
A.prototype.getSelectedFields=function(){return this.getCurrentViewContent().getSelectedFields();};
A.prototype.setGroupExpanded=function(s,E){this.getView(this.GROUP_KEY).getContent().setGroupExpanded(s,E);};
A.prototype.setP13nModel=function(m){this.setModel(m,this.P13N_MODEL);this.getViews().forEach(function(o){var p=o.getContent();p.setP13nModel(m);});this._filterByModeAndSearch();};
A.prototype.restoreDefaults=function(){this._getSearchField().setValue("");this._filterByModeAndSearch();};
A.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL);};
A.prototype._getShowHideBtn=function(){var s=this._getResourceText("filterbar.ADAPT_SHOW_VALUE");var h=this._getResourceText("filterbar.ADAPT_HIDE_VALUE");if(!this._oShowHideBtn){this._oShowHideBtn=new B({press:function(E){this.showFactory(!this.getCurrentViewContent().getShowFactory());var o=E.oSource;var n=o.getText()===s?h:s;o.setText(n);}.bind(this)});}this._oShowHideBtn.setText(!this._isCustomView()&&this.getCurrentViewContent().getShowFactory()?h:s);return this._oShowHideBtn;};
A.prototype._getQuickFilter=function(){if(!this._oGroupModeSelect){this._oGroupModeSelect=new S({items:[new I({key:"all",text:this._getResourceText("p13nDialog.GROUPMODE_ALL")}),new I({key:"visible",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE")}),new I({key:"active",text:this._getResourceText("p13nDialog.GROUPMODE_ACTIVE")}),new I({key:"visibleactive",text:this._getResourceText("p13nDialog.GROUPMODE_VISIBLE_ACTIVE")}),new I({key:"mandatory",text:this._getResourceText("p13nDialog.GROUPMODE_MANDATORY")})],tooltip:this._getResourceText("p13nDialog.QUICK_FILTER"),change:this._onGroupModeChange.bind(this)});}return this._oGroupModeSelect;};
A.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new e(this.getId()+"-searchField",{liveChange:[this._filterByModeAndSearch,this],width:"100%",layoutData:new O({shrinkable:true,moveToOverflow:true,priority:"High",maxWidth:"16rem"})});this._oSearchField.setPlaceholder(this._getResourceText("p13nDialog.ADAPT_FILTER_SEARCH"));}return this._oSearchField;};
A.prototype._onGroupModeChange=function(E){this._sModeKey=E.getParameters().selectedItem.getKey();this._filterByModeAndSearch();};
A.prototype._getViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new c({items:[new d({tooltip:this._getResourceText("filterbar.ADAPT_LIST_VIEW"),icon:"sap-icon://list",key:this.LIST_KEY}),new d({tooltip:this._getResourceText("filterbar.ADAPT_GROUP_VIEW"),icon:"sap-icon://group-2",key:this.GROUP_KEY})],selectionChange:function(E){if(this.getCurrentViewKey()===this.LIST_KEY){this.getCurrentViewContent().removeMoveButtons();}var k=E.getParameter("item").getKey();this.switchView(k);}.bind(this)});}return this._oViewSwitch;};
A.prototype._isCustomView=function(){return this._sCurrentView!=this.GROUP_KEY&&this._sCurrentView!=this.LIST_KEY;};
A.prototype._filterByModeAndSearch=function(){if(this._isCustomView(this.getCurrentViewKey())){return;}this._sSearchString=this._getSearchField().getValue();var h=this._createFilterQuery();this._getSearchField().setValue(this._sSearchString);this.getCurrentViewContent().filterWithoutDestroy(h);return h;};
A.prototype._createFilterQuery=function(){var h=[],v=[],q=[];if(this._sSearchString){h=[new F("label","Contains",this._sSearchString),new F("tooltip","Contains",this._sSearchString)];q=new F(h,false);}switch(this._sModeKey){case"visible":v=new F("visible","EQ",true);break;case"active":v=new F("isFiltered","EQ",true);break;case"mandatory":v=new F("required","EQ",true);break;case"visibleactive":v=new F([new F("isFiltered","EQ",true),new F("visible","EQ",true)],true);break;default:}var V=new F("visibleInDialog","EQ",true);return new F([].concat(q,v,V),true);};
A.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._sModeKey=null;this._sSearchString=null;};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/BasePanel',['sap/m/VBox','sap/ui/core/Control','sap/m/Column','sap/m/Text','sap/ui/model/Filter',"sap/m/Table","sap/m/OverflowToolbar","sap/m/SearchField","sap/m/ToolbarSpacer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/core/dnd/DragDropInfo"],function(V,C,a,T,F,b,O,S,c,d,e,B,D){"use strict";
var f=C.extend("sap.ui.mdc.p13n.panels.BasePanel",{
metadata:{library:"sap.ui.mdc",associations:{},defaultAggregation:"items",properties:{enableReorder:{type:"boolean",defaultValue:true},itemFactory:{type:"function"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},template:{type:"sap.ui.core.Control",multiple:false},messageStrip:{type:"sap.m.MessageStrip",multiple:false}},events:{change:{reason:{type:"string"},item:{type:"object"}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.style("height","100%");r.openEnd();r.renderControl(o.getAggregation("_content"));r.close("div");}}
});
f.prototype.P13N_MODEL="$p13n";
f.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oListControl=this._createInnerListControl();this._oListControl.setMultiSelectMode("ClearAll");this._setInnerLayout();};
f.prototype._setInnerLayout=function(){this.setAggregation("_content",new V({items:[this._oListControl]}));};
f.prototype.setMessageStrip=function(s){if(!s){this.getAggregation("_content").removeItem(this._oMessageStrip);this._oMessageStrip=null;}else{if(this._oMessageStrip){this._oMessageStrip.destroy();}this._oMessageStrip=s;this.getAggregation("_content").insertItem(s,0);}return this;};
f.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){this._oDragDropInfo=new D({enabled:false,sourceAggregation:"items",targetAggregation:"items",dropPosition:"Between",drop:[this._onRearrange,this]});}return this._oDragDropInfo;};
f.prototype._getMoveTopButton=function(){if(!this._oMoveTopBtn){this._oMoveTopBtn=new d(this.getId()+"-moveTopBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_TOP"),icon:"sap-icon://collapse-group",press:[this._onPressButtonMoveToTop,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this.addDependent(this._oMoveTopBtn);}return this._oMoveTopBtn;};
f.prototype.getItems=function(){return this._oListControl.getItems();};
f.prototype._getMoveUpButton=function(){if(!this._oMoveUpButton){this._oMoveUpButton=new d(this.getId()+"-moveUpBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_UP"),icon:"sap-icon://navigation-up-arrow",press:[this._onPressButtonMoveUp,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this.addDependent(this._oMoveUpButton);}return this._oMoveUpButton;};
f.prototype._getMoveDownButton=function(){if(!this._oMoveDownButton){this._oMoveDownButton=new d(this.getId()+"-moveDownpBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_DOWN"),icon:"sap-icon://navigation-down-arrow",press:[this._onPressButtonMoveDown,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"High",group:1})});this.addDependent(this._oMoveDownButton);}return this._oMoveDownButton;};
f.prototype._getMoveBottomButton=function(){if(!this._oMoveBottomButton){this._oMoveBottomButton=new d(this.getId()+"-moveBottomBtn",{type:"Transparent",tooltip:this.getResourceText("p13nDialog.MOVE_TO_BOTTOM"),icon:"sap-icon://expand-group",press:[this._onPressButtonMoveToBottom,this],visible:false,layoutData:new e({moveToOverflow:true,priority:"Low",group:2})});this.addDependent(this._oMoveBottomButton);}return this._oMoveBottomButton;};
f.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerP13nList",Object.assign(this._getListControlConfig(),{headerToolbar:new O({content:[this._getSearchField(),new c(),this._getMoveTopButton(),this._getMoveUpButton(),this._getMoveDownButton(),this._getMoveBottomButton(),this._getReorderButton()]})}));};
f.prototype.setEnableReorder=function(E){var t=this.getTemplate();if(E){this._addHover(t);}else if(t&&t.aDelegates&&t.aDelegates.length>0){t.removeEventDelegate(t.aDelegates[0].oDelegate);}this._getDragDropConfig().setEnabled(E);this._setMoveButtonVisibility(E);this.setProperty("enableReorder",E);return this;};
f.prototype._addHover=function(r){if(r&&r.aDelegates.length<1){r.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this)});}};
f.prototype._focusHandler=function(E){if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};
f.prototype._hoverHandler=function(E){if(this._oSelectedItem&&!this._oSelectedItem.bIsDestroyed){return;}if(!this.getEnableReorder()){return;}var h=sap.ui.getCore().byId(E.currentTarget.id);this._handleActivated(h);};
f.prototype._handleActivated=function(h){this._oHoveredItem=h;};
f.prototype._getReorderButton=function(){if(!this.oReorderButton){this.oReorderButton=new B(this.getId()+"-showSelectedBtn",{text:{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?this.getResourceText("p13nDialog.SELECT"):this.getResourceText("p13nDialog.REORDER");}.bind(this)},press:[this._onPressToggleMode,this]});}return this.oReorderButton;};
f.prototype._getListControlConfig=function(){return{mode:"MultiSelect",rememberSelections:true,itemPress:[this._onItemPressed,this],selectionChange:[this._onSelectionChange,this],sticky:["HeaderToolbar","ColumnHeaders","InfoToolbar"],dragDropConfig:this._getDragDropConfig()};};
f.prototype._getSearchField=function(){if(!this._oSearchField){this._oSearchField=new S(this.getId()+"-searchField",{liveChange:[this._onSearchFieldLiveChange,this],width:"100%",layoutData:new e({shrinkable:true,moveToOverflow:true,priority:"High",maxWidth:"16rem"})});}return this._oSearchField;};
f.prototype.setTemplate=function(t){this.setAggregation("template",t);if(t){if(this.getEnableReorder()){this._addHover(t);}this._oSelectionBindingInfo=t.getBindingInfo("selected");if(this._oSelectionBindingInfo&&this._oSelectionBindingInfo.parts){this._oSelectionBindingInfo={parts:this._oSelectionBindingInfo.parts};}}this._bindListItems();return this;};
f.prototype.setPanelColumns=function(v){var g;if(v instanceof Array){g=v;}else{g=[v];}this._addTableColumns(g);};
f.prototype.setP13nModel=function(p){this.setModel(p,this.P13N_MODEL);this.setPanelMode(false);};
f.prototype.getP13nModel=function(){return this.getModel(this.P13N_MODEL);};
f.prototype.getP13nState=function(){return this.getP13nModel().getProperty("/items").filter(function(o){return o[this._getPresenceAttribute()]===true;}.bind(this));};
f.prototype.getResourceText=function(t,v){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundle.getText(t,v):this.oResourceBundle;};
f.prototype._addTableColumns=function(g){var r=this._oListControl.removeAllColumns();r.forEach(function(R){R.destroy();});g.forEach(function(v){var o;if(typeof v=="string"){o=new a({header:new T({text:v})});}else{o=v;}this._oListControl.addColumn(o);},this);};
f.prototype._getPresenceAttribute=function(){var p=this.getP13nModel().getProperty("/presenceAttribute")||"visible";return p;};
f.prototype._bindListItems=function(m){var t=this.getTemplate();if(t){t.bindProperty("type",{path:this.P13N_MODEL+">/reorderMode",formatter:function(r){return r?"Active":"Inactive";}});this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",templateShareable:false,template:this.getTemplate().clone()},m));}};
f.prototype._onSelectionChange=function(E){var l=E.getParameter("listItems");var s=E.getParameter("selectAll");var g=!s&&l.length>1;l.forEach(function(t){this._selectTableItem(t,s||g);},this);if(s||g){this.fireChange({reason:s?"SelectAll":"DeselectAll",item:undefined});}if(g){this._getMoveTopButton().setEnabled(false);this._getMoveUpButton().setEnabled(false);this._getMoveDownButton().setEnabled(false);this._getMoveBottomButton().setEnabled(false);}};
f.prototype._onItemPressed=function(E){var t=E.getParameter('listItem');this._oSelectedItem=t;var o=t.getBindingContext(this.P13N_MODEL);if(this.getEnableReorder()&&o&&o.getProperty(this._getPresenceAttribute())){this._handleActivated(t);this._updateEnableOfMoveButtons(t,true);}};
f.prototype._onSearchFieldLiveChange=function(E){this._oListControl.getBinding("items").filter(new F("label","Contains",E.getSource().getValue()));};
f.prototype._onPressButtonMoveToTop=function(){this._moveSelectedItem(0);};
f.prototype._onPressButtonMoveUp=function(){this._moveSelectedItem("Up");};
f.prototype._onPressButtonMoveDown=function(){this._moveSelectedItem("Down");};
f.prototype._onPressButtonMoveToBottom=function(){var i=this._oListControl.getItems().length-1;this._moveSelectedItem(i);};
f.prototype._onPressToggleMode=function(E){this._togglePanelMode();};
f.prototype.getPanelMode=function(){return this.getP13nModel()?this.getP13nModel().getProperty("/reorderMode"):false;};
f.prototype.setPanelMode=function(r){return this.getP13nModel().setProperty("/reorderMode",r);};
f.prototype._togglePanelMode=function(){var r=!this.getPanelMode();this.setPanelMode(r);if(r){this._updateModelItems();}this.switchListMode(r?"None":"MultiSelect");this._filterBySelected(r,this._oListControl);this._oSearchField.setVisible(!r);this._oSearchField.setValue("");this._setMoveButtonVisibility(r);this._getMoveTopButton().setEnabled(false);this._getMoveUpButton().setEnabled(false);this._getMoveDownButton().setEnabled(false);this._getMoveBottomButton().setEnabled(false);this._getDragDropConfig().setEnabled(r);};
f.prototype._setMoveButtonVisibility=function(v){this._getMoveTopButton().setVisible(v);this._getMoveUpButton().setVisible(v);this._getMoveDownButton().setVisible(v);this._getMoveBottomButton().setVisible(v);};
f.prototype._updateModelItems=function(){var g=this.getP13nModel().getProperty("/items");var s=[],o=[];g.forEach(function(h){if(h[this._getPresenceAttribute()]){s.push(h);}else{o.push(h);}}.bind(this));this.getP13nModel().setProperty("/items",s.concat(o));};
f.prototype._filterBySelected=function(s,l){l.getBinding("items").filter(s?new F(this._getPresenceAttribute(),"EQ",true):[]);};
f.prototype.switchListMode=function(m){if(this._oSelectionBindingInfo){if(m==="None"){this.getTemplate().unbindProperty("selected");}else{this.getTemplate().bindProperty("selected",this._oSelectionBindingInfo);}this._oListControl.unbindAggregation("items");}this._oListControl.setMode(m);if(this._oSelectionBindingInfo){this._bindListItems();}};
f.prototype._selectTableItem=function(t,s){this._updateEnableOfMoveButtons(t,s?false:true);this._oSelectedItem=t;if(!s){var i=this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath);var p=this.getModel(this.P13N_MODEL);if(p&&i){p.setProperty(t.getBindingContext(this.P13N_MODEL).sPath+"/selected",i.visible);}this.fireChange({reason:i[this._getPresenceAttribute()]?"Add":"Remove",item:i});}};
f.prototype._moveSelectedItem=function(n){var s=this._oSelectedItem;var i=this._oListControl.indexOfItem(s);if(i<0){return;}var N=(typeof n=="number")?n:i+(n=="Up"?-1:1);this._moveTableItem(s,N);};
f.prototype._moveTableItem=function(i,n){var I=this._oListControl.getItems();var g=this.getP13nModel().getProperty("/items");var o=g.indexOf(i.getBindingContext(this.P13N_MODEL).getObject());n=(n<=0)?0:Math.min(n,I.length-1);var N=g.indexOf(I[n].getBindingContext(this.P13N_MODEL).getObject());if(N==o){return;}g.splice(N,0,g.splice(o,1)[0]);this.getP13nModel().setProperty("/items",g);this._oSelectedItem=this._oListControl.getItems()[n];this._updateEnableOfMoveButtons(this._oSelectedItem,true);this._handleActivated(this._oSelectedItem);this.fireChange({reason:"Move",item:this.getP13nModel().getProperty(this._oSelectedItem.getBindingContext(this.P13N_MODEL).sPath)});};
f.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var g=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var i=this._oListControl.indexOfItem(o);var h=this._oListControl.indexOfItem(g);var A=h+(s=="Before"?0:1)+(i<h?-1:0);this._moveTableItem(o,A);};
f.prototype._updateEnableOfMoveButtons=function(t,g){var i=this._oListControl.getItems().indexOf(t);var l=this._oListControl.getItems().length-1;var u=true,h=true;if(i==0){u=false;}if(i==l){h=false;}this._getMoveTopButton().setEnabled(u);this._getMoveUpButton().setEnabled(u);this._getMoveDownButton().setEnabled(h);this._getMoveBottomButton().setEnabled(h);if(g){t.focus();}};
f.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._oSelectionBindingInfo=null;this._oSelectedItem=null;this._oListControl=null;this._oMoveTopBtn=null;this._oMoveUpButton=null;this._oMoveDownButton=null;this._oMoveBottomButton=null;this._oSearchField=null;};
return f;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/ChartItemPanel',["sap/m/p13n/BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/Select","sap/m/Text","sap/ui/core/Item","sap/ui/mdc/library","sap/m/Button",'sap/m/Column',"sap/m/Table","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/VBox","sap/m/HBox","sap/m/ComboBox","sap/ui/model/Sorter","sap/base/Log","sap/m/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/CustomData"],function(B,L,C,S,T,I,M,c,d,e,F,f,V,H,g,h,i,l,D,R,j){"use strict";var k=l.FlexJustifyContent;var m=sap.ui.getCore();
var n=B.extend("sap.ui.mdc.p13n.panels.ChartItemPanel",{
metadata:{library:"sap.ui.mdc",properties:{panelConfig:{type:"object"}},events:{changeItems:{}}},
init:function(){this._bMobileMode=D.system.phone;B.prototype.init.apply(this,arguments);this._bindListItems();},
renderer:{}
});
n.prototype._setInnerLayout=function(){this._oInnerControl=new V({items:[this._oListControl]});this.setAggregation("_content",this._oInnerControl);this._fnHandleResize=function(){if(this.getParent){var $=null;var p=this.getParent();if(p&&p.$){$=p.$("cont");if($.children().length>0){var s=this._oInnerControl.$()[0].clientWidth;var a=570;if(!this._bMobileMode&&s<=a){this._switchMobileMode(true);}else if(this._bMobileMode&&s>a){this._switchMobileMode(false);}}}}};if(D.system.desktop){this._sContainerResizeListener=R.register(this._oInnerControl,this._fnHandleResize.bind(this));}};
n.prototype._switchMobileMode=function(b){if(this._bMobileMode==b){return;}this._bMobileMode=b;if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}this._oListControl.destroy();this._oDragDropInfo=null;this._oListControl=this._createInnerListControl();this._oListControl.setMultiSelectMode("ClearAll");this._setInnerLayout();this._bindListItems();};
n.prototype._createInnerListControl=function(){var s=this._bMobileMode?this.getId()+"-innerP13nListMobile":this.getId()+"-innerP13nList";var t=new e(s,Object.assign(this._getListControlConfig(),{}));this.setEnableReorder(true);t.addEventDelegate({onAfterRendering:this._checkFocusAfterTableRerender.bind(this)});return t;};
n.prototype._checkFocusAfterTableRerender=function(){if(this._oFocusInfo&&this._oFocusInfo.tableItem){this._oFocusInfo.tableItem.focus();}this._oFocusInfo=null;};
n.prototype._bindListItems=function(o){var s;var p=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(this.getPanelConfig()&&this.getPanelConfig().sorter){s=this.getPanelConfig().sorter;}else{var q={text:p.getText('chart.PERSONALIZATION_DIALOG_MEASURE_GROUP_HEADER')};var r={text:p.getText('chart.PERSONALIZATION_DIALOG_DIMENSION_GROUP_HEADER')};var G={"Aggregatable":q,"Groupable":r,"Measure":q,"Dimension":r};var t=function(a){var b=a.getProperty("kind");return{key:b,text:G[b].text};};var u=function(a,b){if(a===b){return 0;}if(a==="MEASURE"||a==="AGGREGATABLE"){return 1;}return-1;};s=new h("kind",false,t,u);}var v;this._mTemplatesMap=new Map();if(this._bMobileMode){v=this._createListItemMobile;}else{v=this._createListItem;}this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/items",key:"name",filters:[new F({filters:[new F("visible",f.EQ,true),new F("template",f.EQ,true)],and:false})],factory:v.bind(this),sorter:s},o));};
n.prototype._getTemplateComboBox=function(K){var v=new F("visible",f.EQ,false);var o=new g({id:"p13nPanel-templateComboBox-"+K,width:"100%",placeholder:this._getPlaceholderTextForTemplate(K),items:{path:this.P13N_MODEL+">/items",template:new I({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[v,new F("kind",f.EQ,K)]},change:[this.onChangeOfTemplateName,this]});this._mTemplatesMap.set(K,o);return o;};
n.prototype._getPlaceholderTextForTemplate=function(K){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return a.getText('chart.PERSONALIZATION_DIALOG_TEMPLATE_PLACEHOLDER');};
n.prototype._getRoleSelect=function(){return new S({width:"100%",selectedKey:"{"+this.P13N_MODEL+">role}",change:[this.onChangeOfRole,this],forceSelection:false,items:{path:this.P13N_MODEL+">availableRoles",templateShareable:false,template:new I({key:"{"+this.P13N_MODEL+">key}",text:"{"+this.P13N_MODEL+">text}"})},visible:{path:this.P13N_MODEL+">availableRoles",formatter:function(r){if(!r){return false;}return r.length>1;}}});};
n.prototype._getNameComboBox=function(K,N){var o=new F({filters:[new F("visible",f.EQ,false),new F("name",f.EQ,N)],and:false});return new g({width:"100%",items:{path:this.P13N_MODEL+">/items",template:new I({key:"{"+this.P13N_MODEL+">name}",text:"{"+this.P13N_MODEL+">label}"}),templateShareable:false,filters:[o,new F("kind",f.EQ,K)]},change:[this.onChangeOfItemName,this],selectedKey:"{"+this.P13N_MODEL+">tempName}",customData:[new j({key:"prevName",value:N}),new j({key:"prevKind",value:K})]});};
n.prototype._createListItem=function(s,o){var r,a=[];if(o.getObject()&&o.getObject().template){a.push(this._getTemplateComboBox(o.getObject().kind));}else{a.push(this._getNameComboBox(o.getObject().kind,o.getObject().name));a.push(this._getRoleSelect());r=o.getObject().kind+"-RemoveBtn-"+o.getObject().name;a.push(new H({justifyContent:k.End,items:[new c({id:r,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",tooltip:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_REMOVE_ENTRY"),customData:[new j({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new j({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]}));}var b;if(o.getObject()&&o.getObject().template){var K=o.getObject().kind;b=new C({cells:a,visible:{path:this.P13N_MODEL+">/items",formatter:function(p){p=p.filter(function(q){return q.visible===false&&q.template===false&&q.kind===K;});return p.length!=0;}}});}else{b=new C({cells:a});}b.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._handleOnKeyDown.bind(this)});return b;};
n.prototype._createListItemMobile=function(s,o){var r,a=[];if(o.getObject()&&o.getObject().template){a.push(this._getTemplateComboBox(o.getObject().kind));}else{var v=new V({items:[this._getNameComboBox(o.getObject().kind,o.getObject().name),this._getRoleSelect()]});r=o.getObject().kind+"-RemoveBtn-"+o.getObject().name;a.push(v);}var b=new H({justifyContent:k.End,items:[new c({id:r,press:[this._onPressHide,this],type:"Transparent",icon:"sap-icon://decline",visible:{path:this.P13N_MODEL+">template",formatter:function(E){return!E;}},customData:[new j({key:"propertyName",value:"{"+this.P13N_MODEL+">name}"}),new j({key:"propertyKind",value:"{"+this.P13N_MODEL+">kind}"})]})]});a.push(b);var p;if(o.getObject()&&o.getObject().template){var K=o.getObject().kind;p=new C({cells:a,visible:{path:this.P13N_MODEL+">/items",formatter:function(q){q=q.filter(function(t){return t.visible===false&&t.template===false&&t.kind===K;});return q.length!=0;}}});}else{p=new C({cells:a});}p.addEventDelegate({onmouseover:this._hoverHandler.bind(this),onfocusin:this._focusHandler.bind(this),onkeydown:this._handleOnKeyDown.bind(this)});return p;};
n.prototype._handleOnKeyDown=function(E){if(E.keyCode===38&&E.ctrlKey){}else if(E.keyCode===40&&E.ctrlKey){}else if(E.keyCode===68&&E.ctrlKey){var r,o=m.byId(E.currentTarget.id);if(this._bMobileMode){r=o.getCells()[1].getItems()[o.getCells()[1].getItems().length-1];}else{r=o.getCells()[2].getItems()[o.getCells()[2].getItems().length-1];}if(r){this._onPressHide(E,r);E.preventDefault();}}};
n.prototype._focusHandler=function(E){var t=m.byId(E.target.id);if(t instanceof c){return;}B.prototype._focusHandler.apply(this,arguments);};
n.prototype._handleActivated=function(o){var a=this._getModelItemByTableItem(o);if(a&&a.template){this.removeMoveButtons();}this._oHoveredItem=o;this._updateEnableOfMoveButtons(o,false);this._addMoveButtons(o);this._setMoveButtonVisibility(true);};
n.prototype.onChangeOfItemName=function(E){var p=E.getSource().data().prevName;var K=E.getSource().data().prevKind;var N=E.getSource().getSelectedKey();var P=this._getP13nModel().getProperty("/items").find(function(a){return a.name===p&&a.kind===K;});var o=this._getP13nModel().getProperty("/items").find(function(a){return a.name===N&&a.kind===K;});this.removeMoveButtons();if(P&&o){P.visible=false;o.visible=true;P.tempName=P.name;o.role=P.role;this._moveItemsByIndex(this._getItemIndex(o),this._getItemIndex(P));this._getP13nModel().refresh(true);this._fireChangeItems();}};
n.prototype._getItemIndexByNameAndKind=function(N,K){var a=this._getP13nModel().getProperty("/items");var o=a.find(function(b){return(b.name===N&&b.kind===K&&!b.template);});return this._getItemIndex(o);};
n.prototype._getItemIndex=function(o){return this._getP13nModel().getProperty("/items").indexOf(o);};
n.prototype.removeMoveButtons=function(){var o=this._getMoveButtonContainer();if(o){o.removeItem(this._getMoveBottomButton());o.removeItem(this._getMoveDownButton());o.removeItem(this._getMoveUpButton());o.removeItem(this._getMoveTopButton());}};
n.prototype.getP13nData=function(){var a=this._getCleanP13nItems();this._getP13nModel().setProperty("/items",a);return a;};
n.prototype._getMoveButtonContainer=function(){if(this._oMoveUpButton&&this._oMoveUpButton.getParent()&&this._oMoveUpButton.getParent().isA("sap.m.FlexBox")){return this._oMoveUpButton.getParent();}return undefined;};
n.prototype._addMoveButtons=function(o){var t=o;if(!t){return;}var b=this._getP13nModel().getProperty(t.getBindingContextPath())?this._getP13nModel().getProperty(t.getBindingContextPath()).template:true;if(!b){if(this._bMobileMode){t.getCells()[1].insertItem(this._getMoveDownButton(),0);t.getCells()[1].insertItem(this._getMoveUpButton(),0);}else{t.getCells()[2].insertItem(this._getMoveBottomButton(),0);t.getCells()[2].insertItem(this._getMoveDownButton(),0);t.getCells()[2].insertItem(this._getMoveUpButton(),0);t.getCells()[2].insertItem(this._getMoveTopButton(),0);}}};
n.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};
n.prototype._updateAvailableRolesForItems=function(){var a=this._getP13nModel().getProperty("/items");var A=[];if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){A=this.getPanelConfig().allowedLayoutOptions;}else{i.warning("No allowedLayoutOptions configured for chart type. This will not show any p13n options!");}a.forEach(function(o){if(!o.availableRoles){return;}o.availableRoles=o.availableRoles.filter(function(b){return A.indexOf(b.key)!=-1;});});this._getP13nModel().setProperty("/items",a);this._getP13nModel().refresh(true);};
n.prototype._onPressHide=function(E,r){var p;if(r){p=r.data().propertyName;}else{p=E.getSource().data().propertyName;}var a=jQuery.extend([],this._getP13nModel().getProperty("/items"),true);a.filter(function(b){return b.name===p;}).forEach(function(o){o.visible=false;if(this._mTemplatesMap.has(o.kind)&&this._mTemplatesMap.get(o.kind).getVisible()){this._mTemplatesMap.get(o.kind).focus();}}.bind(this));this._getP13nModel().setProperty("/items",a);this._getP13nModel().refresh(true);this._fireChangeItems();this._updateVisibleIndexes();};
n.prototype.setP13nData=function(p){p=p.filter(function(b){return!b.template;});B.prototype.setP13nData.apply(this,arguments);var a=[];var A=[];this.getP13nData().forEach(function(o,b){if(!o.availableRoles){o.availableRoles=this._getChartItemTextByKey(o.kind);}if(this.getPanelConfig()&&this.getPanelConfig().allowedLayoutOptions){var q=this.getPanelConfig().allowedLayoutOptions;if(q&&q.length>=1){o.availableRoles=o.availableRoles.filter(function(r){return q.indexOf(r.key)!=-1;});if(q.indexOf(o.role)===-1){o.role=q[0];}}}o.template=false;o.tempName=o.name;if(!o.visible){A.push(o);}if(!o.index){o.index=b;}a.push(o);}.bind(this));a=a.concat(this._getTemplateItems());this._getP13nModel().setProperty("/items",a);this._updateVisibleIndexes();};
n.prototype._updateVisibleIndexes=function(){this._mVisibleIndexes=new Map();this._getP13nModel().getProperty("/items").forEach(function(o,_){if(o.template||!o.visible){return;}if(this._mVisibleIndexes.has(o.kind)){this._mVisibleIndexes.get(o.kind).push(_);}else{var a=[_];this._mVisibleIndexes.set(o.kind,a);}}.bind(this));};
n.prototype.onChangeOfTemplateName=function(E){var s=E.getSource().getSelectedKey();var o=this._getCleanP13nItems().find(function(b){return b.name===s;});if(o){o.visible=true;E.getSource().setSelectedKey(undefined);this._getP13nModel().refresh(true);var a=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];var O=this._getItemIndexByNameAndKind(o.name,o.kind);var N=a[a.length-1];if(O>N){N+=1;}if(N&&O!=N){this._moveItemsByIndex(O,N,true);}else{this._fireChangeItems();}this._updateVisibleIndexes();}else{E.getSource().setSelectedKey(undefined);}};
n.prototype._getTemplateItems=function(){var a=[];if(!this.getPanelConfig()||!this.getPanelConfig().templateConfig){return[];}this.getPanelConfig().templateConfig.forEach(function(t){var o={template:true,kind:t.kind};a.push(o);});return a;};
n.prototype._getListControlConfig=function(){var o=B.prototype._getListControlConfig.apply(this,arguments);if(this._bMobileMode){o.columns=[new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")+" / "+this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})}),new d()];}else{var a=new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION")})});var r=new d({header:new T({text:this._getResourceTextMDC("chart.PERSONALIZATION_DIALOG_COLUMN_ROLE")})});o.columns=[a,r,new d()];}o.mode="None";return o;};
n.prototype._getCleanP13nItems=function(){return this._getP13nModel().getProperty("/items").filter(function(a){return!a.template;});};
n.prototype._fireChangeItems=function(){this.fireChangeItems({items:this._getCleanP13nItems().map(function(o){return{columnKey:o.name,visible:o.visible,index:o.index,role:o.role};})});};
n.prototype.onChangeOfRole=function(E){var s=E.getParameter("selectedItem");if(s){var t;if(this._bMobileMode){t=E.getSource().getParent().getParent();}else{t=E.getSource().getParent();}this.fireChange();this._updateEnableOfMoveButtons(t);}this._fireChangeItems();};
n.prototype._updateEnableOfMoveButtons=function(t,b){if(!t){return;}var a,o=this._getModelItemByTableItem(t);var p=this._getP13nModel().getProperty("/items").indexOf(o);var u=true,q=true;if(!o||o.template){return;}a=this._mVisibleIndexes.has(o.kind)?this._mVisibleIndexes.get(o.kind):[];if(p==0||a.indexOf(p)===0){u=false;}if(a.indexOf(p)===a.length-1){q=false;}this._getMoveTopButton().setEnabled(u);this._getMoveUpButton().setEnabled(u);this._getMoveDownButton().setEnabled(q);this._getMoveBottomButton().setEnabled(q);if(b){this._oFocusInfo={tableItem:t};}};
n.prototype._getListItemFromMoveButton=function(b){if(b&&b.getParent()&&b.getParent().getParent()){return b.getParent().getParent();}return undefined;};
n.prototype._onPressButtonMoveToTop=function(E){var o=this._getListItemFromMoveButton(E.getSource());if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var t=this._mVisibleIndexes.get(a.kind)[0];this._oSelectedItem=o;this._moveSelectedItem(t);};
n.prototype._onPressButtonMoveUp=function(E,o){if(!o){o=this._getListItemFromMoveButton(E.getSource());}if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind);var t=this._getP13nModel().getProperty("/items").indexOf(a);this._oSelectedItem=o;var N=b[b.indexOf(t)-1];this._moveSelectedItem(N);};
n.prototype._onPressButtonMoveDown=function(E,o){if(!o){o=this._getListItemFromMoveButton(E.getSource());}if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind);var t=this._getP13nModel().getProperty("/items").indexOf(a);this._oSelectedItem=o;var N=b[b.indexOf(t)+1];this._moveSelectedItem(N);};
n.prototype._onPressButtonMoveToBottom=function(E){var o=this._getListItemFromMoveButton(E.getSource());if(!o){return;}var a=this._getP13nModel().getProperty(o.getBindingContextPath());var b=this._mVisibleIndexes.get(a.kind)[this._mVisibleIndexes.get(a.kind).length-1];this._oSelectedItem=o;this._moveSelectedItem(b);};
n.prototype._moveTableItem=function(o,N){var a=this._getP13nModel().getProperty("/items");var O=a.indexOf(o.getBindingContext(this.P13N_MODEL).getObject());this._moveItemsByIndex(O,N);};
n.prototype._moveItemsByIndex=function(o,N,p){var a=this._getP13nModel().getProperty("/items");N=(N<=0)?0:Math.min(N,a.length-1);if(N==o){return;}a.splice(N,0,a.splice(o,1)[0]);a.forEach(function(b,q){if(!b.template){b.index=q;}});this._getP13nModel().setProperty("/items",a);if(!p){this._oSelectedItem=this._oListControl.getItems().find(function(b){var q=this._getModelItemByTableItem(b);return q&&q===a[N];}.bind(this));this._updateEnableOfMoveButtons(this._oSelectedItem,!p);this._handleActivated(this._oSelectedItem);}this._fireChangeItems();};
n.prototype._getModelItemByTableItem=function(t){return this._getP13nModel().getProperty(t.getBindingContextPath());};
n.prototype._getMoveConfigForTableItem=function(t){var o=this._getModelItemByTableItem(t);if(!o){return undefined;}return{currentIndex:this._getP13nModel().getProperty("/items").indexOf(o),aggregationRole:o.kind,template:o.template};};
n.prototype._getDragDropConfig=function(){if(!this._oDragDropInfo){var o=B.prototype._getDragDropConfig.apply(this,arguments);o.attachDragStart(this._checkDragStart.bind(this));o.attachDragEnter(this._checkDrag.bind(this));o.attachDragEnd(function(){this._oDraggedItem=null;}.bind(this));return o;}return this._oDragDropInfo;};
n.prototype._checkDrag=function(E){var o=E.getParameter("target");var a=this._getMoveConfigForTableItem(o);var b=this._getMoveConfigForTableItem(this._oDraggedItem);if(!a||a.template||b.aggregationRole!=a.aggregationRole){E.preventDefault();return;}};
n.prototype._checkDragStart=function(E){this._oDraggedItem=E.getParameter("target");this._checkDrag(E);};
n.prototype._onRearrange=function(E){var o=E.getParameter("draggedControl");var a=E.getParameter("droppedControl");var s=E.getParameter("dropPosition");var b=this._getMoveConfigForTableItem(o);var p=this._getMoveConfigForTableItem(a);if(!b||b.template||!p){E.preventDefault();return;}var q=b.currentIndex;var r=p.currentIndex;if(p.template&&s=="After"){E.preventDefault();return;}if(!p.template&&(b.aggregationRole!=undefined&&b.aggregationRole!=p.aggregationRole)){E.preventDefault();return;}if(q<r){if(s=="Before"&&r!=0){r-=1;}}else if(s=="After"){r+=1;}this._moveItemsByIndex(q,r);this._getP13nModel().refresh(true);this._updateVisibleIndexes();};
n.prototype._getMoveTopButton=function(){if(this._oMoveTopBtn&&this._oMoveTopBtn.isDestroyed()){this._oMoveTopBtn=null;}return B.prototype._getMoveTopButton.apply(this,arguments);};
n.prototype._getMoveUpButton=function(){if(this._oMoveUpButton&&this._oMoveUpButton.isDestroyed()){this._oMoveUpButton=null;}return B.prototype._getMoveUpButton.apply(this,arguments);};
n.prototype._getMoveDownButton=function(){if(this._oMoveDownButton&&this._oMoveDownButton.isDestroyed()){this._oMoveDownButton=null;}return B.prototype._getMoveDownButton.apply(this,arguments);};
n.prototype._getMoveBottomButton=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.isDestroyed()){this._oMoveBottomButton=null;}return B.prototype._getMoveBottomButton.apply(this,arguments);};
n.prototype._getChartItemTextByKey=function(K){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var A={Dimension:[{key:M.ChartItemRoleType.category,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY')},{key:M.ChartItemRoleType.category2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_CATEGORY2')},{key:M.ChartItemRoleType.series,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_SERIES')}],Measure:[{key:M.ChartItemRoleType.axis1,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS1')},{key:M.ChartItemRoleType.axis2,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS2')},{key:M.ChartItemRoleType.axis3,text:a.getText('chart.PERSONALIZATION_DIALOG_CHARTROLE_AXIS3')}]};return A[K];};
n.prototype._getResourceTextMDC=function(t,v){this.oResourceBundleMDC=this.oResourceBundleMDC?this.oResourceBundleMDC:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundleMDC.getText(t,v):this.oResourceBundleMDC;};
return n;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/GroupView',["./BasePanel","sap/m/Label","sap/base/util/deepEqual","sap/m/CustomListItem","sap/m/List","sap/m/Panel","sap/m/Toolbar","sap/m/Text","sap/ui/core/Icon","sap/ui/core/library","sap/m/HBox","sap/m/library"],function(B,L,d,C,a,P,T,b,I,c,H,l){"use strict";var e=c.IconColor;var F=l.FlexJustifyContent;var f=l.ListKeyboardMode;
var G=B.extend("sap.ui.mdc.p13n.panels.GroupView",{
metadata:{library:"sap.ui.mdc"},
renderer:{apiVersion:2}
});
G.prototype.init=function(){B.prototype.init.apply(this,arguments);this.addStyleClass("sapUiMDCGroupView");var g=new C({visible:"{"+this.P13N_MODEL+">groupVisible}",accDescription:{path:this.P13N_MODEL+">groupLabel",formatter:function(s){return this.getResourceText("p13nDialog.FILTER_GROUP_DESCRIPTION",s);}.bind(this)},content:[this._createGroupPanelTemplate()]});this._bShowFactory=true;this.displayColumns();this._aInitializedLists=[];this.setTemplate(g);this._setMoveButtonVisibility(true);};
G.prototype.getShowFactory=function(){return this._bShowFactory;};
G.prototype.getPanels=function(){var p=[];this._oListControl.getItems().forEach(function(i){p.push(i.getContent()[0]);});return p;};
G.prototype._createGroupPanelTemplate=function(){var g=this.P13N_MODEL;return new P({expandable:true,expanded:{path:this.P13N_MODEL+">group",formatter:function(){if(this.getBindingContext(g)){var E=this.getBindingContext(g).sPath.split("/")[2]==="0";return E;}else{return false;}}},expand:function(E){var s=E.getSource();var i=s.getContent()[0];this._addInitializedList(i);if(this.getShowFactory()){this._addFactoryControl(i);this.filterWithoutDestroy(this._aCurrentFilters);}}.bind(this),width:"100%",headerToolbar:[new T({content:[new L({wrapping:true,text:"{"+this.P13N_MODEL+">groupLabel}",design:"Bold"})]})],content:[this._createGroupListTemplate()]});};
G.prototype._createGroupListTemplate=function(){var o=new a({keyboardMode:f.Navigation,selectionChange:function(g){var p=g.getParameter("listItem").getBindingContext(this.P13N_MODEL).sPath;var i=this.getP13nModel().getProperty(p);var h=this.getModel(this.P13N_MODEL);if(h&&i){h.setProperty(p+"/selected",i.visible);}this.fireChange({reason:i.visible?"Add":"Remove",item:i});}.bind(this),showSeparators:"None",mode:"MultiSelect"});o.bindItems(this._getItemsBinding());return o;};
G.prototype._addFactoryControl=function(o){if(o.getItems().length==0||o.getItems()[0].getContent().length<2){o.getItems().forEach(function(i){var g=i.getBindingContext(this.P13N_MODEL);var h=this.getItemFactory().call(this,g);if(h){i.addContent(h);i.getContent()[0].getItems()[0].setLabelFor(h.getId());}if(i.getContent()[0].getItems().length>1){i.getContent()[0].removeItem(1);}}.bind(this));}this.addStyleClass("sapUiMDCAFLabelMarking");};
G.prototype._createInnerListControl=function(){var o=new a(this.getId()+"-innerGroupViewList",Object.assign(this._getListControlConfig(),{mode:"None",infoToolbar:new T(),updateStarted:function(E){this._checkAllPanels();}.bind(this)}));return o;};
G.prototype._getItemsBinding=function(){var g=function(){var i=[new H({width:"100%",justifyContent:F.SpaceBetween,items:[new L({required:"{"+this.P13N_MODEL+">required}",text:"{"+this.P13N_MODEL+">label}"})]})];return new C({selected:"{"+this.P13N_MODEL+">visible}",tooltip:"{"+this.P13N_MODEL+">tooltip}",content:i});}.bind(this);return{path:this.P13N_MODEL+">items",templateShareable:false,template:g()};};
G.prototype._getIconTemplate=function(){return new H({width:"18.5%",justifyContent:F.Center,items:[new I({src:"sap-icon://circle-task-2",size:"0.5rem",color:e.Neutral,visible:{path:this.P13N_MODEL+">isFiltered",formatter:function(i){if(i){return true;}else{return false;}}}})]});};
G.prototype._loopGroupList=function(g){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var i=p.getContent()[0];this._loopItems(i,function(h,k){g(h,k);});}.bind(this));};
G.prototype._loopItems=function(o,i){o.getItems().forEach(function(g){var p=g.getBindingContextPath();var k=this.getP13nModel().getProperty(p).name;i.call(this,g,k);}.bind(this));};
G.prototype._removeFactoryControl=function(){this._loopGroupList(function(i,k){if(i.getContent()[1]){i.removeContent(i.getContent()[1]);var o=i.getParent();this._addInitializedList(o);var g=this._getIconTemplate();i.getContent()[0].addItem(g);}}.bind(this));this.removeStyleClass("sapUiMDCAFLabelMarking");return this._aInitializedLists||[];};
G.prototype._addInitializedList=function(o){var s=o.getId();if(this._aInitializedLists.indexOf(s)<0){this._aInitializedLists.push(s);}};
G.prototype._getInitializedLists=function(){var g=[];this._aInitializedLists.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){g.push(o);}});return g;};
G.prototype.getSelectedFields=function(){var s=[];this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var i=p.getContent()[0];this._loopItems(i,function(g,k){if(g.getSelected()){s.push(k);}});}.bind(this));return s;};
G.prototype.filterWithoutDestroy=function(g){if(!this._bInitialized||d(g,this._aCurrentFilters)){return;}var i=this._removeFactoryControl();this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var h=p.getContent()[0];if(h.getBinding("items")){h.getBinding("items").filter(g,true);this._togglePanelVisibility(p);}if(this.getShowFactory()&&i.indexOf(h.getId())>-1){this._addFactoryControl(h);}}.bind(this));this._aCurrentFilters=g;};
G.prototype.showFactory=function(s){this._bShowFactory=s;this.displayColumns();if(s){this._getInitializedLists().forEach(function(i){this._addFactoryControl(i);}.bind(this));}else{this._removeFactoryControl();}};
G.prototype._checkAllPanels=function(){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];this._togglePanelVisibility(p);}.bind(this));};
G.prototype.setGroupExpanded=function(g,E){this._oListControl.getItems().forEach(function(o){var p=o.getContent()[0];var s=p.getBindingContext(this.P13N_MODEL).sPath;var i=this.getP13nModel().getProperty(s);if(i.group===g){p.setExpanded(E);}},this);};
G.prototype._togglePanelVisibility=function(p){var i=p.getContent()[0];var o=p.getBindingContext(this.P13N_MODEL);if(o){var s=o.sPath;var g=this.getP13nModel().getProperty(s);g.groupVisible=i.getVisibleItems().length<1?false:true;this.getP13nModel().setProperty(s,g);}};
G.prototype._checkFirstGroup=function(){if(!this._bInitialized&&this._oListControl&&this._oListControl.getItems().length>0){this._bInitialized=true;var o=this._oListControl.getItems()[0].getContent()[0].getContent()[0];this._addFactoryControl(o);this._addInitializedList(o);}};
G.prototype.displayColumns=function(){var p=this._oListControl.getInfoToolbar().removeAllContent();p.forEach(function(o){o.destroy();});this._oListControl.getInfoToolbar().addContent(new b({width:"75%",text:this.getResourceText("p13nDialog.LIST_VIEW_COLUMN")}).addStyleClass("firstColumnPadding"));if(!this._bShowFactory){this._oListControl.getInfoToolbar().addContent(new b({textAlign:"Center",width:"25%",text:this.getResourceText("p13nDialog.LIST_VIEW_ACTIVE")}).addStyleClass("firstColumnPadding"));}};
G.prototype.setP13nModel=function(m){this.setModel(m,this.P13N_MODEL);this._bindListItems();this._checkFirstGroup();this._checkAllPanels();};
G.prototype._bindListItems=function(){this._oListControl.bindItems(Object.assign({path:this.P13N_MODEL+">/itemsGrouped",templateShareable:false,key:"group",template:this.getTemplate().clone()}));};
G.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._aInitializedLists=null;this._bShowFactory=false;this._bInitialized=false;};
return G;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/LinkSelectionPanel',["sap/m/p13n/SelectionPanel","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/m/Link","sap/m/Text","sap/ui/core/Icon","sap/m/library","sap/m/MessageBox"],function(S,C,H,V,L,T,I,l,M){"use strict";var a=l.ListType;
var b=S.extend("sap.ui.mdc.p13n.panels.LinkSelectionPanel",{
metadata:{library:"sap.ui.mdc",events:{linkPressed:{}}},
renderer:{apiVersion:2}
});
b.prototype._getListTemplate=function(){return new C({selected:"{"+this.P13N_MODEL+">"+this.PRESENCE_ATTRIBUTE+"}",type:a.Active,cells:[new V({items:[new L({tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">text}",href:"{"+this.P13N_MODEL+">href}",target:"{"+this.P13N_MODEL+">target}",press:this._onLinkPressed.bind(this)}),new T({text:"{"+this.P13N_MODEL+">description}",visible:"{= ${"+this.P13N_MODEL+">description} ? true:false}"})]})]});};
b.prototype._onLinkPressed=function(e){this.fireLinkPressed(e);};
b.prototype.setMultiSelectMode=function(m){this._oListControl.setMultiSelectMode(m);};
return b;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/ListView',["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text","sap/m/Column","sap/m/Table","sap/m/library","sap/m/ToolbarSpacer","sap/m/Button","sap/m/OverflowToolbar","sap/ui/model/Filter"],function(B,L,C,H,V,I,c,T,a,b,l,d,e,O,F){"use strict";var f=l.ListKeyboardMode;var g=l.FlexJustifyContent;var h=l.ListType;var i=c.IconColor;
var j=B.extend("sap.ui.mdc.p13n.panels.ListView",{
metadata:{library:"sap.ui.mdc",properties:{showHeader:{type:"boolean",defaultValue:false},enableCount:{type:"boolean",defaultValue:false}}},
renderer:{apiVersion:2}
});
j.prototype.applySettings=function(){this.setTemplate(this._getListTemplate());B.prototype.applySettings.apply(this,arguments);this.addStyleClass("sapUiMDCListView");this._aInitializedFields=[];this._bShowFactory=false;this.addStyleClass("listViewHover");this.displayColumns();this.setEnableReorder(true);};
j.prototype.setItemFactory=function(k){this.setProperty("itemFactory",k);this._oListControl.setGrowing(!!k);return this;};
j.prototype._getListTemplate=function(){return new C({selected:"{"+this.P13N_MODEL+">visible}",type:h.Active,cells:[new V({items:[new L({wrapping:true,required:"{"+this.P13N_MODEL+">required}",tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"})]}),new H({justifyContent:g.Center,items:[new I({src:"sap-icon://circle-task-2",size:"0.5rem",color:i.Neutral,visible:{path:this.P13N_MODEL+">isFiltered",formatter:function(k){if(k){return true;}else{return false;}}}})]})]});};
j.prototype.setShowHeader=function(s){if(s){var S=this.getResourceText("p13nDialog.SHOW_SELECTED");var k=this.getResourceText("p13nDialog.SHOW_ALL");this._oListControl.setHeaderToolbar(new O({content:[this._getSearchField(),new d(),new e({press:function(E){this._bShowSelected=E.getSource().getText()==S;this._filterList(this._bShowSelected,this._sSearch);E.getSource().setText(this._bShowSelected?k:S);}.bind(this),text:S})]}));}this.setProperty("showHeader",s);return this;};
j.prototype._filterList=function(s,S){var o=[],k=[];if(s){k=new F(this._getPresenceAttribute(),"EQ",true);}if(S){o=new F("label","Contains",S);}this._oListControl.getBinding("items").filter(new F([].concat(k,o),true));};
j.prototype._onSearchFieldLiveChange=function(E){this._sSearch=E.getSource().getValue();this._filterList(this._bShowSelected,this._sSearch);};
j.prototype._handleActivated=function(o){this.removeMoveButtons();if(this._oHoveredItem&&this._oHoveredItem.getBindingContextPath()){var v=!!this.getP13nModel().getProperty(this._oHoveredItem.getBindingContextPath()).isFiltered;var k=this._oHoveredItem.getCells()[1].getItems()[0];k.setVisible(v);}var m=o.getCells()[1].getItems()[0];m.setVisible(false);this._oHoveredItem=o;this._updateEnableOfMoveButtons(o,false);this._addMoveButtons(o);};
j.prototype.removeMoveButtons=function(){var m=this._getMoveButtonContainer();if(m){m.removeItem(this._getMoveTopButton());m.removeItem(this._getMoveUpButton());m.removeItem(this._getMoveDownButton());m.removeItem(this._getMoveBottomButton());}};
j.prototype._getMoveButtonContainer=function(){if(this._oMoveBottomButton&&this._oMoveBottomButton.getParent()&&this._oMoveBottomButton.getParent().isA("sap.m.FlexBox")){return this._oMoveBottomButton.getParent();}};
j.prototype.showFactory=function(s){this._bShowFactory=s;this.displayColumns();if(s){this.removeStyleClass("listViewHover");this._oListControl.setKeyboardMode(f.Edit);this._addFactoryControl();}else{this.addStyleClass("listViewHover");this._oListControl.setKeyboardMode(f.Navigation);this._removeFactoryControl();}};
j.prototype._updateCount=function(){this.getP13nModel().setProperty("/selectedItems",this._oListControl.getSelectedContexts(true).length);};
j.prototype._selectTableItem=function(t,s){B.prototype._selectTableItem.apply(this,arguments);this._updateCount();};
j.prototype.setP13nModel=function(m){this.setModel(m,"$p13n");this._updateCount();this.setPanelMode(true);this._getDragDropConfig().setEnabled(this.getEnableReorder());};
j.prototype._removeFactoryControl=function(){var k=this._oListControl.getItems().filter(function(o){return!o._bGroupHeader;});k.forEach(function(o){var m=o.getCells()[0];if(m.getItems().length>1){m.removeItem(m.getItems()[1]);}});this.removeStyleClass("sapUiMDCAFLabelMarkingList");return this._aInitializedFields;};
j.prototype._moveSelectedItem=function(){this._oSelectedItem=this._getMoveButtonContainer().getParent();B.prototype._moveSelectedItem.apply(this,arguments);};
j.prototype.getShowFactory=function(){return this._bShowFactory;};
j.prototype.displayColumns=function(){var k=[this.getResourceText("p13nDialog.LIST_VIEW_COLUMN")];if(!this._bShowFactory){k.push(new a({width:"25%",hAlign:"Center",vAlign:"Middle",header:new T({text:this.getResourceText("p13nDialog.LIST_VIEW_ACTIVE")})}));}this.setPanelColumns(k);};
j.prototype.setPanelColumns=function(k){this._sText=k[0];var E=this.getEnableCount();if(E){var o=new a({header:new T({text:{parts:[{path:this.P13N_MODEL+'>/selectedItems'},{path:this.P13N_MODEL+'>/items'}],formatter:function(s,A){return this._sText+" "+this.getResourceText('p13nDialog.HEADER_COUNT',[s,A.length]);}.bind(this)}})});k[0]=o;}B.prototype.setPanelColumns.apply(this,arguments);};
j.prototype._addFactoryControl=function(o){this._oListControl.getItems().forEach(function(k){var m=k.getBindingContext(this.P13N_MODEL);var n=this.getItemFactory().call(this,m);var p=k.getCells()[0];p.addItem(n);}.bind(this));this.addStyleClass("sapUiMDCAFLabelMarkingList");};
j.prototype._createInnerListControl=function(){return new b(this.getId()+"-innerListViewTable",Object.assign({growing:false,growingThreshold:25,growingScrollToLoad:true,updateStarted:function(){this.removeMoveButtons();this._removeFactoryControl();}.bind(this),updateFinished:function(){if(this.getShowFactory()){this._addFactoryControl();}}.bind(this)},this._getListControlConfig()));};
j.prototype.getSelectedFields=function(){var s=[];this._loopItems(this._oListControl,function(o,k){if(o.getSelected()){s.push(k);}});return s;};
j.prototype._loopItems=function(o,k){o.getItems().forEach(function(m){var p=m.getBindingContextPath();var K=this.getP13nModel().getProperty(p).name;k.call(this,m,K);}.bind(this));};
j.prototype.filterWithoutDestroy=function(k){if(this._oListControl.getBinding("items")){this._oListControl.getBinding("items").filter(k,true);}};
j.prototype._addMoveButtons=function(o){var t=o;if(!t){return;}var k=this.getP13nModel().getProperty(t.getBindingContextPath()).visible;if(k){t.getCells()[1].addItem(this._getMoveTopButton());t.getCells()[1].addItem(this._getMoveUpButton());t.getCells()[1].addItem(this._getMoveDownButton());t.getCells()[1].addItem(this._getMoveBottomButton());}};
j.prototype.exit=function(){B.prototype.exit.apply(this,arguments);this._aInitializedFields=null;this._oHoveredItem=null;this._bShowFactory=null;this._sSearch=null;this._bShowSelected=null;};
return j;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/SelectionPanel',["./BasePanel","sap/m/Label","sap/m/ColumnListItem","sap/m/HBox","sap/m/VBox","sap/ui/model/Filter"],function(B,L,C,H,V,F){"use strict";
var S=B.extend("sap.ui.mdc.p13n.panels.SelectionPanel",{
metadata:{library:"sap.ui.mdc"},
init:function(){B.prototype.init.apply(this,arguments);this.setPanelColumns(this.getResourceText("fieldsui.COLUMNS"));},
renderer:{}
});
S.prototype.setP13nModel=function(m){B.prototype.setP13nModel.apply(this,arguments);var s=new C({selected:"{"+this.P13N_MODEL+">"+this._getPresenceAttribute()+"}",cells:new V({items:[new L({design:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?"Bold":"Standard";}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new L({visible:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?true:false;}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">groupLabel}"})]})});this.setTemplate(s);};
S.prototype._onSearchFieldLiveChange=function(e){var f=new F([new F("label","Contains",e.getSource().getValue()),new F("groupLabel","Contains",e.getSource().getValue())]);this._oListControl.getBinding("items").filter(f,false);};
return S;});
sap.ui.predefine('sap/ui/mdc/p13n/panels/SortPanel',["./BasePanel","sap/m/ColumnListItem","sap/m/Label","sap/m/Select","sap/ui/core/Item","sap/m/HBox","sap/m/VBox","sap/ui/model/Filter"],function(B,C,L,S,I,H,V,F){"use strict";
var a=B.extend("sap.ui.mdc.p13n.panels.SortPanel",{
metadata:{library:"sap.ui.mdc"},
init:function(){B.prototype.init.apply(this,arguments);var s=new C({selected:"{"+this.P13N_MODEL+">sorted}",cells:[new V({items:[new L({design:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?"Bold":"Standard";}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">label}"}),new L({visible:{path:this.P13N_MODEL+">groupLabel",formatter:function(g){return g?true:false;}},wrapping:true,tooltip:"{"+this.P13N_MODEL+">tooltip}",text:"{"+this.P13N_MODEL+">groupLabel}"})]}),new S("IDsortOrderSelect",{width:"100%",selectedKey:"{"+this.P13N_MODEL+">descending}",change:[this.onChangeOfSortOrder,this],enabled:{path:this.P13N_MODEL+">sorted",formatter:function(e){return!!e;}},items:[new I({key:false,text:this.getResourceText("sort.PERSONALIZATION_DIALOG_OPTION_ASCENDING")}),new I({key:true,text:this.getResourceText("sort.PERSONALIZATION_DIALOG_OPTION_DESCENDING")})]})]});this.setTemplate(s);this.setPanelColumns([this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION"),this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_SORTORDER")]);},
renderer:{}
});
a.prototype._filterBySelected=function(s){this._oListControl.getBinding("items").filter(s?new F("sorted","EQ",true):[]);};
a.prototype._updateModelItems=function(){var f=this.getP13nModel().getProperty("/items");var s=[],o=[];f.forEach(function(b){if(b.sorted){s.push(b);}else{o.push(b);}});this.getP13nModel().setProperty("/items",s.concat(o));};
a.prototype.onChangeOfSortOrder=function(e){var s=e.getParameter("selectedItem");if(s){var b=s.getBindingContext(this.P13N_MODEL);if(b){var p=b.getPath();this.getP13nModel().setProperty(p+"/descending",s.getKey()==="true");}this.fireChange();}};
a.prototype._onSearchFieldLiveChange=function(e){var f=new F([new F("label","Contains",e.getSource().getValue()),new F("groupLabel","Contains",e.getSource().getValue())]);this._oListControl.getBinding("items").filter(f,false);};
a.prototype._onPressToggleMode=function(e){var p=this.getPanelMode()?[this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION"),this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_SORTORDER")]:this.getResourceText("sort.PERSONALIZATION_DIALOG_COLUMN_DESCRIPTION");this.setPanelColumns(p);this._togglePanelMode();};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/ActionToolbarController',["./BaseController","sap/ui/mdc/p13n/panels/ActionToolbarPanel","sap/m/Column","sap/ui/mdc/p13n/P13nBuilder"],function(B,A,C,P){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");
var a=B.extend("saps.ui.mdc.p13n.subcontroller.ActionToolbarController");
a.prototype.getUISettings=function(){return{title:r.getText("actiontoolbar.RTA_TITLE")};};
a.prototype.getAdaptationUI=function(p){var s=new A({showHeader:true});s.setEnableReorder(false);s.setPanelColumns([r.getText("actiontoolbar.RTA_COLUMN_HEADER"),new C({width:"25%",hAlign:"Center",vAlign:"Middle"})]);var o=this._getP13nModel(p);s.setP13nModel(o);return Promise.resolve(s);};
a.prototype.getDelta=function(p){var c=B.prototype.getDelta.apply(this,arguments);c.forEach(function(o){var s=o.changeSpecificData.changeType;if(s==="hideControl"||s==="unhideControl"){o.selectorElement=sap.ui.getCore().byId(o.changeSpecificData.content.name);delete o.changeSpecificData.content;}});return c;};
a.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var I=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(m,b){var e=I[b.name];m.visible=!!e;m.position=e?e.position:-1;m.alignment=b.alignment;return b.visible;});P.sortP13nData({visible:"visible",position:"position"},o.items);o.items.forEach(function(b){delete b.position;});return o;};
a.prototype.getChangeOperations=function(){return{add:"unhideControl",remove:"hideControl",move:"moveAction"};};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/AdaptFiltersController',["./BaseController","sap/ui/mdc/p13n/P13nBuilder","sap/base/util/merge"],function(B,P,m){"use strict";
var A=B.extend("sap.ui.mdc.p13n.subcontroller.AdaptFiltersController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
A.prototype.getUISettings=function(){return{verticalScrolling:false,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_TITLE"),afterClose:function(e){var d=e.getSource();if(d){d.getContent()[0].executeRemoves();d.removeAllContent();d.destroy();}}};};
A.prototype.getBeforeApply=function(){var a=this.getAdaptationControl().getInbuiltFilter();var p=a?a.createConditionChanges():Promise.resolve([]);return p;};
A.prototype.getFilterControl=function(){return this.getAdaptationControl();};
A.prototype.getChangeOperations=function(){return{add:"addFilter",remove:"removeFilter",move:"moveFilter"};};
A.prototype.getAdaptationUI=function(p){return this.getAdaptationControl().retrieveInbuiltFilter().then(function(a){var o=this._getP13nModel(p);a.setP13nModel(o);a.setLiveMode(false);return a.createFilterFields().then(function(){return a;});}.bind(this));};
A.prototype.update=function(){B.prototype.update.apply(this,arguments);this.getAdaptationControl().getInbuiltFilter().createFilterFields();};
A.prototype.mixInfoAndState=function(p){var e=this.getAdaptationControl().getCurrentState().filter||{};var i=this.getCurrentState();var E=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(I,a){var b=E[a.name];var c=e[a.name];I.visible=b?true:false;I.visibleInDialog=true;I.selected=I.visible;I.position=b?b.position:-1;I.isFiltered=c&&c.length>0?true:false;I.required=a.required;return!(a.hiddenFilter===true||a.name=="$search");},true);P.sortP13nData({visible:"visible",position:"position"},o.items);return o;};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/AggregateController',['./BaseController','sap/ui/mdc/p13n/P13nBuilder','sap/base/util/merge'],function(B,P,m){"use strict";
var A=B.extend("sap.ui.mdc.p13n.subcontroller.AggregateController");
A.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState().aggregations;};
A.prototype.sanityCheck=function(c){var a=[];Object.keys(c).forEach(function(i){var o={name:i};if(c[i].hasOwnProperty("aggregated")){o["aggregated"]=c[i].aggregated;}a.push(o);});return a;};
A.prototype.getDelta=function(p){p.existingState=this.sanityCheck(p.existingState);return B.prototype.getDelta.apply(this,arguments);};
A.prototype.getAdaptationUI=function(p){return null;};
A.prototype.getChangeOperations=function(){return{add:"addAggregate",remove:"removeAggregate"};};
A.prototype._getPresenceAttribute=function(){return"aggregated";};
A.prototype.mixInfoAndState=function(p){var e=this.getCurrentState();var o=P.prepareAdaptationData(p,function(i,a){var E=e[a.name];i.aggregated=!!E;return a.aggregatable;});return o;};
return A;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/BaseController',['sap/base/util/array/diff','sap/ui/base/Object','sap/ui/mdc/p13n/FlexUtil','sap/ui/mdc/p13n/P13nBuilder','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/model/json/JSONModel','sap/m/p13n/SelectionPanel'],function(d,B,F,P,m,a,J,S){"use strict";
var b=B.extend("sap.ui.mdc.p13n.subcontroller.BaseController",{constructor:function(c){B.call(this);this._oAdaptationControl=c;this._oP13nData=null;this._bLiveMode=false;this._bResetEnabled=false;}});
b.prototype.getUISettings=function(){return{title:"Adaptation Dialog"};};
b.prototype.getAdaptationControl=function(){return this._oAdaptationControl;};
b.prototype.getLiveMode=function(){return this._bLiveMode;};
b.prototype.getChangeOperations=function(){return{add:null,remove:null,move:null};};
b.prototype.getResetEnabled=function(){return this._bResetEnabled;};
b.prototype.getSelectorForReset=function(){return this._oAdaptationControl;};
b.prototype.sanityCheck=function(s){return s;};
b.prototype.getAdaptationUI=function(p){var s=new S();var A=this.mixInfoAndState(p);s.setP13nData(A.items);this._oPanel=s;return Promise.resolve(s);};
b.prototype.getCurrentState=function(){return this._oAdaptationControl.getCurrentState().items;};
b.prototype.getDelta=function(p){var s=this._getPresenceAttribute(p.externalAppliance);var n;var f=function(i){return i.hasOwnProperty(s)&&i[s]===false?false:true;};n=p.applyAbsolute?p.changedState.filter(f):this._getFilledArray(p.existingState,p.changedState,s).filter(f);p.changedState=n;if(a(p.existingState,n)){return[];}else{return this.getArrayDeltaChanges(p);}};
b.prototype.getArrayDeltaChanges=function(D){var e=D.existingState;var c=D.changedState;var C=D.control;var i=D.changeOperations.add;var r=D.changeOperations.remove;var M=D.changeOperations.move;var g=D.generator;var f=D.deltaAttributes||[];var s=function(o){var k="";f.forEach(function(A){k=k+o[A];});return k;};var R=d(e,c,s);var h=function(o,A){return A.filter(function(E){return E&&(E.name===o.name);})[0];};var j=[];var p=e.slice(0);R.forEach(function(o){if(o.type==="delete"&&p[o.index]===undefined){p.splice(o.index,1);return;}var k,E,l;if(o.type==="insert"){E=h(c[o.index],p);if(E){E.index=p.indexOf(E);p.splice(E.index,1,undefined);j=j.concat(this._createAddRemoveChange(C,r,F._getChangeContent(E,f),g));}}k=o.type==="delete"?p[o.index]:c[o.index];k.index=o.index;if(o.type==="delete"){p.splice(k.index,1);}else{p.splice(k.index,0,k);}if(M){l=j.length;if(l){E=j[l-1];E=E?E.changeSpecificData.content:undefined;}if(E&&E.name===k.name&&o.index!=E.index){j.pop();j=j.concat(this._createMoveChange(E.id,E.name,o.index,M,C,M!=="moveSort",g));return;}}j=j.concat(this._createAddRemoveChange(C,o.type==="delete"?r:i,F._getChangeContent(k,f),g));}.bind(this));return j;};
b.prototype._createAddRemoveChange=function(c,o,C){var A={selectorElement:c,changeSpecificData:{changeType:o,content:C}};return A;};
b.prototype._createMoveChange=function(i,p,n,M,c,e){var o={selectorElement:c,changeSpecificData:{changeType:M,content:{id:i,name:p,index:n}}};if(!e){delete o.changeSpecificData.content.id;}return o;};
b.prototype._getPresenceAttribute=function(c){return"visible";};
b.prototype.getBeforeApply=function(){return Promise.resolve();};
b.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var I=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(c,e){var E=I[e.name];c.visible=!!E;c.position=E?E.position:-1;return e.visible;});P.sortP13nData({visible:"visible",position:"position"},o.items);o.items.forEach(function(c){delete c.position;});return o;};
b.prototype.getP13nData=function(){return this._oPanel?this._oPanel.getP13nData():this._oAdaptationModel.getProperty("/items");};
b.prototype.model2State=false;
b.prototype.update=function(p){if(this._oPanel){var A=this.mixInfoAndState(p);this._oPanel.setP13nData(A.items);}else if(this._oAdaptationModel){var o=this.mixInfoAndState(p);this._oAdaptationModel.setProperty("/items",o.items);this._oAdaptationModel.setProperty("/itemsGrouped",o.itemsGrouped);}};
b.prototype._getFilledArray=function(p,n,r){var N=m([],p);var c=m([],n);var e=P.arrayToMap(p);c.forEach(function(i){var E=e[i.name];if(!i.hasOwnProperty(r)||i[r]){var f=i.position;if(E){f=f>-1?f:E.position;var o=E.position;N.splice(f,0,N.splice(o,1)[0]);}else{f=f>-1?f:N.length;N.splice(f,0,i);}N[f]=i;}else if(E){N[E.position][r]=false;}});return N;};
b.prototype._getP13nModel=function(p){if(!this._oAdaptationModel){this._oAdaptationModel=new J(this.mixInfoAndState(p));this._oP13nData=this._oAdaptationModel.getData();this._oAdaptationModel.setSizeLimit(10000);}else{this.update(p);}return this._oAdaptationModel;};
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);this._oAdaptationControl=null;this._bLiveMode=null;this._oPanel=null;this._bResetEnabled=null;this._oAdaptationModel=null;};
return b;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/ChartItemController',["./BaseController","sap/ui/mdc/p13n/P13nBuilder"],function(B,P){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");
var C=B.extend("sap.ui.mdc.p13n.subcontroller.ChartItemController");
C.prototype.getAdaptationUI=function(p){var R;this._oAdaptationControl.getAdaptationUI().then(function(o){this._oPanel=o;this._oPropHelper=p;var a=this.mixInfoAndState(p);o.setP13nData(a.items);R(o);}.bind(this));return new Promise(function(a,b){R=a;});};
C.prototype.update=function(){B.prototype.update.apply(this,arguments);this._oPanel.setP13nData(this.mixInfoAndState(this._oPropHelper).items);};
C.prototype.getDelta=function(p){p.deltaAttributes.push("role");return B.prototype.getDelta.apply(this,arguments);};
C.prototype.getUISettings=function(){return{title:r.getText("chart.PERSONALIZATION_DIALOG_TITLE"),tabText:r.getText("p13nDialog.TAB_Chart")};};
C.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var I=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(m,a){var e=I[a.name];m.visible=!!e;m.position=e?e.position:-1;m.role=e?e.role:a.role;m.kind=a.kind;if(a.availableRoles){m.availableRoles=a.availableRoles;}return a.visible;});P.sortP13nData({visible:"visible",position:"position"},o.items);o.items.forEach(function(a){delete a.position;});return o;};
C.prototype.getChangeOperations=function(){return{add:"addItem",remove:"removeItem",move:"moveItem"};};
return C;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/ColumnController',["./BaseController","sap/m/p13n/SelectionPanel"],function(B,S){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");
var C=B.extend("sap.ui.mdc.p13n.subcontroller.ColumnController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
C.prototype.getUISettings=function(){return{title:r.getText("table.SETTINGS_COLUMN"),tabText:r.getText("p13nDialog.TAB_Column")};};
C.prototype.model2State=function(){var i=[];this._oPanel.getP13nData(true).forEach(function(I){if(I.visible){i.push({name:I.name});}});return i;};
C.prototype.getAdaptationUI=function(p){var s=new S({enableReorder:true,showHeader:true,enableCount:true,fieldColumn:r.getText("fieldsui.COLUMNS")});var a=this.mixInfoAndState(p);s.setP13nData(a.items);this._oPanel=s;return Promise.resolve(s);};
C.prototype.getChangeOperations=function(){return{add:"addColumn",remove:"removeColumn",move:"moveColumn"};};
return C;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/ColumnWidthController',["./BaseController","sap/ui/mdc/p13n/FlexUtil"],function(B,F){"use strict";
var C=B.extend("sap.ui.mdc.p13n.subcontroller.ColumnWidthController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
C.prototype.sanityCheck=function(c){var a=[];if(c.hasOwnProperty("aggregations")&&c.aggregations.hasOwnProperty("columns")){Object.keys(c.aggregations.columns).forEach(function(i){var o={name:i,width:c.aggregations.columns[i].width};a.push(o);});}return a;};
C.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState().xConfig;};
C.prototype.getDelta=function(p){p.deltaAttribute="width";p.operation="setColumnWidth";p.existingState=this.sanityCheck(p.existingState);return F.getPropertySetterChanges(p);};
return C;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/FilterController',['sap/ui/mdc/condition/FilterOperatorUtil','./BaseController','sap/ui/mdc/p13n/P13nBuilder','sap/ui/mdc/p13n/FlexUtil','sap/base/Log'],function(F,B,P,a,L){"use strict";
var b=B.extend("sap.ui.mdc.p13n.subcontroller.FilterController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
b.prototype.getCurrentState=function(){var c=this.getAdaptationControl().getCurrentState();return c.hasOwnProperty("filter")?c.filter:{};};
b.prototype.getUISettings=function(){return{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filter.PERSONALIZATION_DIALOG_TITLE"),tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Filter"),afterClose:function(e){var d=e.getSource();if(d){d.removeAllContent();d.destroy();}}};};
b.prototype.getChangeOperations=function(){return{add:"addCondition",remove:"removeCondition"};};
b.prototype.getBeforeApply=function(){var A=this.getAdaptationControl().getInbuiltFilter();var p=A?A.createConditionChanges():Promise.resolve([]);return p;};
b.prototype.getFilterControl=function(){return this.getAdaptationControl().isA("sap.ui.mdc.IFilter")?this.getAdaptationControl():this.getAdaptationControl()._oP13nFilter;};
b.prototype.sanityCheck=function(s){b.checkConditionOperatorSanity(s);return s;};
b.checkConditionOperatorSanity=function(c){for(var f in c){var C=c[f];for(var i=0;i<C.length;i++){var o=C[i];var O=o.operator;if(!F.getOperator(O)){C.splice(i,1);if(c[f].length==0){delete c[f];}L.warning("The provided conditions for field '"+f+"' contain unsupported operators - these conditions will be neglected.");}}}};
b.prototype.getAdaptationUI=function(p,w){var A=this._getP13nModel(p);return this.getAdaptationControl().retrieveInbuiltFilter().then(function(o){o.setP13nModel(A);o.setLiveMode(false);this._oAdaptationFB=o;return o.createFilterFields().then(function(){return o;});}.bind(this));};
b.prototype.update=function(){B.prototype.update.apply(this,arguments);this.getAdaptationControl().getInbuiltFilter().createFilterFields();};
b.prototype.getDelta=function(p){return a.getConditionDeltaChanges(p);};
b.prototype.model2State=function(){var i={},f=this.getCurrentState();this._oAdaptationModel.getProperty("/items").forEach(function(I){if(I.isFiltered&&Object.keys(f).includes(I.name)){i[I.name]=f[I.name];}});return i;};
b.prototype.mixInfoAndState=function(p){var e=this.getCurrentState()||{};var o=P.prepareAdaptationData(p,function(i,c){var n=c.name;var E=e[n];i.isFiltered=E&&E.length>0?true:false;return!(c.filterable===false);});P.sortP13nData({visible:undefined,position:undefined},o.items);return o;};
return b;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/GroupController',['./BaseController','sap/ui/mdc/p13n/P13nBuilder','sap/m/p13n/GroupPanel'],function(B,P,G){"use strict";
var a=B.extend("sap.ui.mdc.p13n.subcontroller.GroupController");
a.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState().groupLevels;};
a.prototype.getUISettings=function(){return{tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Group"),title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("group.PERSONALIZATION_DIALOG_TITLE")};};
a.prototype.getDelta=function(p){return B.prototype.getDelta.apply(this,arguments);};
a.prototype.getAdaptationUI=function(p){var g=new G();var A=this.mixInfoAndState(p);g.setP13nData(A.items);this._oPanel=g;return Promise.resolve(g);};
a.prototype.model2State=function(){var i=[];this._oPanel.getP13nData(true).forEach(function(I){if(I.grouped){i.push({name:I.name});}});return i;};
a.prototype.getChangeOperations=function(){return{add:"addGroup",remove:"removeGroup",move:"moveGroup"};};
a.prototype._getPresenceAttribute=function(){return"grouped";};
a.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var I=P.arrayToMap(i);var c=this.getAdaptationControl();var A=c.getAggregateConditions?c.getAggregateConditions()||{}:{};var o=P.prepareAdaptationData(p,function(m,b){var e=I[b.name];m.grouped=!!e;m.position=e?e.position:-1;return!(b.groupable===false||A[b.name]);});P.sortP13nData({visible:"grouped",position:"position"},o.items);o.presenceAttribute=this._getPresenceAttribute();o.items.forEach(function(b){delete b.position;});return o;};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/LinkPanelController',["sap/ui/mdc/p13n/P13nBuilder","./BaseController","sap/ui/mdc/p13n/panels/LinkSelectionPanel","sap/m/library","sap/m/MessageBox"],function(P,B,S,l,M){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");var a=l.MultiSelectMode;
var L=B.extend("sap.ui.mdc.p13n.subcontroller.LinkPanelController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
L.prototype.getUISettings=function(){return{contentWidth:"28rem",contentHeight:"35rem",reset:{warningText:r.getText("info.SELECTION_DIALOG_RESET_WARNING")},title:r.getText("info.SELECTION_DIALOG_ALIGNEDTITLE")};};
L.prototype.getSelectorForReset=function(){return this.getAdaptationControl().getItems().concat(this.getAdaptationControl());};
L.prototype.getAdaptationUI=function(p){var s=new S({fieldColumn:r.getText("info.SELECTION_DIALOG_COLUMNHEADER_WITHOUT_COUNT"),enableCount:true,linkPressed:this._onLinkPressed.bind(this)});var A=this.mixInfoAndState(p);s.setP13nData(A.items);s.setEnableReorder(false);s.setMultiSelectMode(a.Default);this._oPanel=s;return Promise.resolve(s);};
L.prototype._onLinkPressed=function(e){var s=e.getParameter("oSource");var t=s.getTarget();if(t!=="_blank"){e.preventDefault();var p=this.getAdaptationControl();var h=s.getHref();if(p.getBeforeNavigationCallback){p.getBeforeNavigationCallback()(e).then(function(n){if(n){p.navigate(h);}});}else{M.show(sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_QUESTION"),{icon:M.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("info.SELECTION_DIALOG_LINK_VALIDATION_TITLE"),actions:[M.Action.YES,M.Action.NO],onClose:function(A){if(A===M.Action.YES){p.navigate(h);}},styleClass:this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}}};
L.prototype._createAddRemoveChange=function(c,o,C){var s=C.name;var b=sap.ui.getCore().byId(s);var d=[];if(!b){d.push({selectorElement:c,changeSpecificData:{changeType:"createItem",content:{selector:s}}});}else{d.push({selectorElement:b,changeSpecificData:{changeType:o==="hideItem"?"hideItem":"revealItem",content:{}}});}return d;};
L.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var e=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(I,b){var E=e[b.name];I.visible=E?true:false;I.position=E?E.position:-1;I.href=b.href;I.description=b.description;I.target=b.target;I.text=b.text;return true;});P.sortP13nData({visible:"visible",position:"position"},o.items);o.presenceAttribute=this._getPresenceAttribute();o.items.forEach(function(I){delete I.position;});return o;};
L.prototype._createMoveChange=function(i,p,n,m,c,b){return{selectorElement:c,changeSpecificData:{changeType:m,content:{index:n,name:p}}};};
L.prototype.getChangeOperations=function(){return{add:["createItem","revealItem"],remove:"hideItem",move:"moveItem"};};
return L;});
sap.ui.predefine('sap/ui/mdc/p13n/subcontroller/SortController',['./BaseController','sap/ui/mdc/p13n/P13nBuilder','sap/ui/mdc/p13n/panels/SortPanel','sap/m/p13n/SortPanel'],function(B,P,S,a){"use strict";
var b=B.extend("sap.ui.mdc.p13n.subcontroller.SortController",{constructor:function(){B.apply(this,arguments);this._bResetEnabled=true;}});
b.prototype.getCurrentState=function(){return this.getAdaptationControl().getCurrentState().sorters;};
b.prototype.getUISettings=function(){return{tabText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.TAB_Sort"),title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("sort.PERSONALIZATION_DIALOG_TITLE")};};
b.prototype.getDelta=function(p){p.deltaAttributes.push("descending");return B.prototype.getDelta.apply(this,arguments);};
b.prototype.getAdaptationUI=function(p){var s;s=new a();var A=this.mixInfoAndState(p);s.setP13nData(A.items);this._oPanel=s;return Promise.resolve(s);};
b.prototype.model2State=function(){var i=[];if(this._oPanel){this._oPanel.getP13nData(true).forEach(function(I){if(I.sorted){i.push({name:I.name});}});return i;}};
b.prototype.getChangeOperations=function(){return{add:"addSort",remove:"removeSort",move:"moveSort"};};
b.prototype._getPresenceAttribute=function(c){return"sorted";};
b.prototype.mixInfoAndState=function(p){var i=this.getCurrentState();var e=P.arrayToMap(i);var o=P.prepareAdaptationData(p,function(I,c){var E=e[c.name];I.sorted=E?true:false;I.sortPosition=E?E.position:-1;I.descending=E?!!E.descending:false;return!(c.sortable===false);});P.sortP13nData({visible:"sorted",position:"sortPosition"},o.items);o.presenceAttribute=this._getPresenceAttribute();o.items.forEach(function(I){delete I.sortPosition;});return o;};
return b;});
sap.ui.predefine('sap/ui/mdc/table/Column',["sap/ui/core/Element","sap/m/Label","sap/ui/core/Core"],function(E,L,C){"use strict";
var a=E.extend("sap.ui.mdc.table.Column",{metadata:{library:"sap.ui.mdc",defaultAggregation:"template",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"float",group:"Behavior",defaultValue:8},header:{type:"string"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",defaultValue:"Begin"},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},initialIndex:{type:"int",defaultValue:-1},dataProperty:{type:"string"}},events:{},aggregations:{template:{type:"sap.ui.core.Control",multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false}}}});
a.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};};
a.prototype.getTemplate=function(c){var t=this.getAggregation("template");if(c&&this._oTemplateClone&&this._oTemplateClone.bIsDestroyed){this._oTemplateClone=null;}if(!this._oTemplateClone&&t){this._oTemplateClone=t.clone();}return c?this._oTemplateClone:t;};
a.prototype.getCreationTemplate=function(c){var o=this.getAggregation("creationTemplate");if(c&&this._oCreationTemplateClone&&this._oCreationTemplateClone.bIsDestroyed){this._oCreationTemplateClone=null;}if(!this._oCreationTemplateClone&&o){this._oCreationTemplateClone=o.clone();}return c?this._oCreationTemplateClone:o;};
a.prototype.setHeaderVisible=function(h){if(this.getHeaderVisible()===h){return this;}this.setProperty("headerVisible",h,true);this._updateColumnHeaderControl();return this;};
a.prototype.setHeader=function(h){this.setProperty("header",h,true);this._updateColumnHeaderControl();var l=this.getDomRef();if(l){l.textContent=this.getHeader();}return this;};
a.prototype.setHAlign=function(h){this.setProperty("hAlign",h,true);this._updateColumnHeaderControl();return this;};
a.prototype._updateColumnWidth=function(w){var i=C.byId(this.getId()+"-innerColumn");if(!i||!this.getWidth()){this.setProperty("width",w);}if(i&&!i.getWidth()){i.setWidth(w);}};
a.prototype._updateColumnHeaderControl=function(){if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.setWidth(this.getHeaderVisible()?null:"0px");this._oColumnHeaderLabel.setWrapping(this._bMobileTable&&!this._bResizable&&this.getHeaderVisible());this._oColumnHeaderLabel.setText(this.getHeader());this._oColumnHeaderLabel.setTextAlign(this.getHAlign());}};
a.prototype.updateColumnResizing=function(e){this._bResizable=!!e;this._updateColumnHeaderControl();};
a.prototype.setParent=function(p){var P=this.getParent();E.prototype.setParent.apply(this,arguments);if(p&&p.isA("sap.ui.mdc.Table")){if(p.getDomRef()){this._addAriaStaticDom();}else{this.oAfterRenderingDelegate={onAfterRendering:function(){this._addAriaStaticDom();this.getParent().removeDelegate(this.oAfterRenderingDelegate);}};p.addDelegate(this.oAfterRenderingDelegate,this);}}else if(!p){P.removeDelegate(this.oAfterRenderingDelegate);this._removeAriaStaticDom();}};
a.prototype.getColumnHeaderControl=function(m,r){if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.destroy();}this._oColumnHeaderLabel=new L(this.getId()+"-innerColumnHeader",{wrappingType:m?"Hyphenated":null});this._bMobileTable=m;this.updateColumnResizing(r);return this._oColumnHeaderLabel;};
a.prototype._removeAriaStaticDom=function(){var d=this.getDomRef();if(d){d.parentNode.removeChild(d);}};
a.prototype._addAriaStaticDom=function(){var i=document.createElement("div");i.setAttribute("id",this.getId());i.setAttribute("class","sapUiInvisibleText");i.setAttribute("aria-hidden","true");var h=document.createTextNode(this.getHeader());i.appendChild(h);var s=C.getStaticAreaRef();if(i&&s){s.appendChild(i);}};
a.prototype.exit=function(){if(this._oTemplateClone){this._oTemplateClone.destroy();this._oTemplateClone=null;}if(this._oCreationTemplateClone){this._oCreationTemplateClone.destroy();this._oCreationTemplateClone=null;}if(this._oColumnHeaderLabel){this._oColumnHeaderLabel.destroy();this._oColumnHeaderLabel=null;}this._removeAriaStaticDom();};
return a;});
sap.ui.predefine('sap/ui/mdc/table/CreationRow',["../library","sap/ui/core/Element"],function(L,E){"use strict";var T=L.TableType;
var C=E.extend("sap.ui.mdc.table.CreationRow",{metadata:{library:"sap.ui.mdc",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true},busy:{type:"boolean",group:"Behavior",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{apply:{allowPreventDefault:true}}}});
C.prototype.init=function(){this._sTableType="";this._oInnerCreationRow=null;this._mBindingContexts={};};
C.prototype.exit=function(){if(this._oInnerCreationRow){this._oInnerCreationRow.destroy();this._oInnerCreationRow=null;}this._mBindingContexts=null;};
C.prototype.setBusy=function(b){this.setProperty('busy',b,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setBusy(b);}return this;};
C.prototype.setBindingContext=function(o,m){E.prototype.setBindingContext.call(this,o,m);this._mBindingContexts[m]={context:o,modelName:m};if(this._oInnerCreationRow){this._oInnerCreationRow.setBindingContext(o,m);}return this;};
C.prototype.setApplyEnabled=function(e){this.setProperty("applyEnabled",e,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setApplyEnabled(e);}return this;};
C.prototype.setVisible=function(v){this.setProperty("visible",v,true);if(this._oInnerCreationRow){this._oInnerCreationRow.setVisible(v);this._getTable()._oTable.getRowMode().setHideEmptyRows(v);}return this;};
C.prototype._onInnerApply=function(e){if(!this.fireApply()){e.preventDefault();}};
C.prototype.update=function(){return this._updateInnerCreationRow();};
C.prototype._updateInnerCreationRow=function(){var t=this._getTable();var n=t?t._getStringType():"";var p;if(this._sTableType===n||!t||!t._oTable){return Promise.resolve();}this._sTableType=n;if(n===T.Table){p=this._createGridTableCreationRow();t._oTable.getRowMode().setHideEmptyRows(this.getVisible());}else{p=this._createResponsiveTableCreationRow();}return p.then(function(I){i(t,I);});};
function g(m){return new Promise(function(r,a){sap.ui.require([m],function(M){r(M);},function(e){a(e);});});}
C.prototype._createGridTableCreationRow=function(){return g("sap/ui/table/CreationRow").then(function(C){c(this);this._oInnerCreationRow=new C(this.getId()+"-inner",{visible:this.getVisible(),applyEnabled:this.getApplyEnabled(),apply:[this._onInnerApply,this]});for(var m in this._mBindingContexts){var b=this._mBindingContexts[m];this._oInnerCreationRow.setBindingContext(b.context,b.modelName);}return this._oInnerCreationRow;}.bind(this));};
C.prototype._createResponsiveTableCreationRow=function(){c(this);return Promise.resolve();};
function i(m,I){if(m&&m._oTable&&I){m._oTable.setCreationRow(I);}}
function c(m){if(m&&m._oInnerCreationRow){m._oInnerCreationRow.destroy();m._oInnerCreationRow=null;}}
C.prototype._getTable=function(){var p=this.getParent();return p&&p.isA("sap.ui.mdc.Table")?p:null;};
return C;});
sap.ui.predefine('sap/ui/mdc/table/GridTableType',["./TableTypeBase","../library"],function(T,l){"use strict";var I,a,b,c,d,e,f,g;var R=l.RowCountMode;var h=l.RowAction;
var G=T.extend("sap.ui.mdc.table.GridTableType",{metadata:{library:"sap.ui.mdc",properties:{rowCountMode:{type:"sap.ui.mdc.RowCountMode",defaultValue:R.Auto},rowCount:{type:"int",defaultValue:10},selectionLimit:{type:"int",defaultValue:200},showHeaderSelector:{type:"boolean",defaultValue:true}}}});
G.prototype.updateRelevantTableProperty=function(t,p,v){if(!t||!t.isA("sap.ui.table.Table")){return;}if(p==="rowCountMode"){var r=t.getRowMode();var H=false;if(r&&(v===R.Fixed&&!r.isA("sap.ui.table.rowmodes.FixedRowMode")||v===R.Auto&&!r.isA("sap.ui.table.rowmodes.AutoRowMode"))){H=r.getHideEmptyRows();r.destroy();r=null;}if(!r){var i=v===R.Fixed?e:f;t.setRowMode(new i({hideEmptyRows:H}));}this._updateTableRowCount(t,v,this.getRowCount());}else if(p==="rowCount"){this._updateTableRowCount(t,this.getRowCountMode(),v);}else if(p==="selectionLimit"){t.getPlugins()[0].setLimit(v).setEnableNotification(v>0);}else if(p==="showHeaderSelector"){t.getPlugins()[0].setShowHeaderSelector(v);}};
G.prototype._updateTableRowCount=function(t,m,v){if(m===R.Fixed){t.getRowMode().setRowCount(v);}else{t.getRowMode().setMinRowCount(v);}};
G.updateDefault=function(t){if(t){t.setRowMode(new f({minRowCount:10}));}};
G.loadGridTableLib=function(){if(!this._oGridTableLibLoaded){this._oGridTableLibLoaded=sap.ui.getCore().loadLibrary("sap.ui.table",true);}return this._oGridTableLibLoaded;};
G.loadTableModules=function(){if(!I){return new Promise(function(r,i){this.loadGridTableLib().then(function(){sap.ui.require(["sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/RowAction","sap/ui/table/RowActionItem","sap/ui/table/plugins/MultiSelectionPlugin","sap/ui/table/rowmodes/FixedRowMode","sap/ui/table/rowmodes/AutoRowMode","sap/ui/table/RowSettings"],function(j,k,h,m,M,F,A,n){I=j;a=k;b=h;c=m;d=M;e=F;f=A;g=n;r();},function(){i("Failed to load some modules");});});}.bind(this));}else{return Promise.resolve();}};
G.createTable=function(i,s){return new I(i,s);};
G.createColumn=function(i,s){var C=new a(i,s);C.attachColumnMenuOpen(function(E){E.preventDefault();});C._menuHasItems=function(){return true;};return C;};
G.createNavigationRowAction=function(i,E){return new b(i+"--rowAction",{items:new c(i+"--rowActionItem",{type:h.Navigation,press:E})});};
G.createMultiSelectionPlugin=function(t,E){return new d(t.getId()+"--multiSelectPlugin",{selectionMode:T.getSelectionMode(t),selectionChange:E});};
G.enableColumnResizer=function(t,i){i.getColumns().forEach(function(C){C.setResizable(true);C.setAutoResizable(true);});i.detachColumnResize(t._onColumnResize,t);i.attachColumnResize(t._onColumnResize,t);};
G.disableColumnResizer=function(t,i){i.getColumns().forEach(function(C){C.setResizable(false);C.setAutoResizable(false);});i.detachColumnResize(t._onColumnResize,t);};
G.updateSelection=function(t){var s=T.getSelectionMode(t);t._oTable.getPlugins()[0].setSelectionMode(s);};
G.updateNavigation=function(t,r){t._oTable.setRowActionTemplate(this.createNavigationRowAction(t.getId(),[r,t]));t._oTable.setRowActionCount(1);};
G.clearNavigation=function(t){var i=t._oTable.getRowActionTemplate();if(i){i.destroy();}t._oTable.setRowActionTemplate();t._oTable.setRowActionCount();};
G.updateRowAction=function(t,n,r){this.clearNavigation(t);if(n){this.updateNavigation(t,r);}};
G.updateRowSettings=function(t,r){var i=new g(undefined,r.getAllSettings());t.getRowSettingsTemplate().destroy();t.setRowSettingsTemplate(i);};
return G;});
sap.ui.predefine('sap/ui/mdc/table/PropertyHelper',["../util/PropertyHelper","sap/ui/core/Core","sap/m/table/Util"],function(P,C,T){"use strict";
var a=P.extend("sap.ui.mdc.table.PropertyHelper",{constructor:function(p,e,o,E){var A=["filterable","sortable","groupable","key","unit","text","exportSettings","propertyInfos","visualSettings"];P.call(this,p,e,o,A,E);}});
function i(o){return!!(o&&o.isA&&o.isA("sap.ui.mdc.table.Column"));}
function g(w){if(w.indexOf("em")>0){return Math.round(parseFloat(w));}if(w.indexOf("px")>0){return Math.round(parseInt(w)/16);}return"";}
a.prototype.prepareProperty=function(p){P.prototype.prepareProperty.apply(this,arguments);p.aggregatable=false;};
a.prototype.getColumnExportSettings=function(o,s){if(!i(o)){return null;}var p=this.getProperty(o.getDataProperty());if(!p){return null;}s=s===true;var d=[];var e;var E=p.exportSettings;var f;var h=[];var A;var j;var k;var l;if(p.isComplex()){e=p.getReferencedProperties();if(!s&&E){f=c(o,p,E,s);e.forEach(function(p){h.push(p.path);});f.property=h;d.push(f);}else{e.forEach(function(p,I){var m=p.exportSettings,n=c(o,p,m,s);n.property=p.path;if(I>0){n.columnId=o.getId()+"-additionalProperty"+I;}if(m||n.property){d.push(n);}},this);}}else if(!s&&E){f=c(o,p,E,s);f.property=p.path;d.push(f);}else{f=c(o,p,E,s);f.property=p.path;if(f.property){d.push(f);}A=s&&E&&E.unitProperty?E.unitProperty:null;if(A){j=b(this,A);k=j.exportSettings;l=c(o,j,k,s);l.property=j.path;l.columnId=o.getId()+"-additionalProperty";if(k||l.property){d.push(l);}}}return d;};
function b(p,s){var o=p.getProperty(s);if(!o){o=p.getProperties().find(function(o){return s===o.path;});}if(o.isComplex()){throw new Error("The 'unitProperty' points to a complex property");}return o;}
function c(o,p,e,s){var E=Object.assign({columnId:o.getId(),label:p.label,width:g(o.getWidth()),textAlign:o.getHAlign(),type:"String"},e);if(s){E.displayUnit=false;}return E;}
a.prototype.setColumnWidth=function(m){var p=m.getDataProperty();var o=this.getProperty(p);if(!o){return;}var d=o.visualSettings;if(d&&d.widthCalculation===null){return;}var w=this._calcColumnWidth(o)+1;m._updateColumnWidth(w+"rem");};
a.prototype._calcColumnWidth=function(p,w){var W=0;var l=0;var m=p.visualSettings?p.visualSettings.widthCalculation:{};w=Object.assign({minWidth:2,maxWidth:19,defaultWidth:8,gap:0,includeLabel:true,excludeProperties:[],verticalArrangement:false},m,w||{});var M=Math.max(1,w.minWidth);var d=Math.max(M,w.maxWidth);if(p.isComplex()){var r=p.getReferencedProperties().filter(function(e){return![].concat(w.excludeProperties).includes(e.name);});r.forEach(function(R){var f=this._calcColumnWidth(R,{includeLabel:false});if(w.verticalArrangement||r.length==1){W=Math.max(f,W);}else{W=W+f+0.5;}},this);}else{var t=p.typeConfig;var o=t.typeInstance;if(o){W=T.calcTypeWidth(o,w);}if(p.unit){W+=2.5;}}W+=w.gap;if(w.includeLabel){l=T.calcHeaderWidth(p.label,W,d,M);}W=Math.max(M,W,l);W=Math.min(W,d);W=Math.round(W*100)/100;return W;};
return a;});
sap.ui.predefine('sap/ui/mdc/table/ResponsiveTableType',["sap/ui/core/Core","./TableTypeBase","../library","sap/m/Button","sap/ui/Device","sap/m/plugins/ColumnResizer"],function(C,T,l,B,D,a){"use strict";var I,b,c;var G=l.GrowingMode;var R=l.RowAction;
var d=T.extend("sap.ui.mdc.table.ResponsiveTableType",{metadata:{library:"sap.ui.mdc",properties:{growingMode:{type:"sap.ui.mdc.GrowingMode",defaultValue:G.Basic},showDetailsButton:{type:"boolean",group:"Misc",defaultValue:false},detailsButtonSetting:{type:"sap.ui.core.Priority[]",group:"Behavior"},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:"Block"}}}});
d.prototype.setDetailsButtonSetting=function(p){this.setProperty("detailsButtonSetting",p,true);return this;};
d.prototype.updateRelevantTableProperty=function(t,p,v){if(t&&t.isA("sap.m.Table")){if(p==="growingMode"){t.setGrowingScrollToLoad(v===G.Scroll);t.setGrowing(v!==G.None);}else if(p==="showDetailsButton"){this.updateShowDetailsButton(t,v);}else if(p==="popinLayout"){t.setPopinLayout(v);}}};
d.updateDefault=function(t){if(t){t.setGrowing(true);t.setGrowingScrollToLoad(false);}};
d.prototype.updateShowDetailsButton=function(t,v){if(v&&!this._oShowDetailsButton){t.getHeaderToolbar().insertEnd(this._getShowDetailsButton(),0);this._renderShowDetailsButton();t.attachEvent("popinChanged",this._onPopinChanged,this);t.setHiddenInPopin(this._getImportanceToHide());}else if(!v&&this._oShowDetailsButton){t.detachEvent("popinChanged",this._onPopinChanged,this);t.getHeaderToolbar().removeEnd(this._oShowDetailsButton);t.setHiddenInPopin([]);this._oShowDetailsButton.destroy();delete this._oShowDetailsButton;}};
d.loadTableModules=function(){if(!I){return new Promise(function(r,e){sap.ui.require(["sap/m/Table","sap/m/Column","sap/m/ColumnListItem"],function(f,g,h){I=f;b=g;c=h;r();},function(){e("Failed to load some modules");});});}else{return Promise.resolve();}};
d.createTable=function(i,s){return new I(i,s);};
d.createColumn=function(i,s){return new b(i,s);};
d.createTemplate=function(i,s){return new c(i,s);};
d.updateSelection=function(t){t._oTable.setMode(T.getSelectionMode(t));};
d.updateMultiSelectMode=function(t){t._oTable.setMultiSelectMode(t.getMultiSelectMode());};
d.updateNavigation=function(t){t._oTemplate.setType(R.Navigation);};
d.updateRowAction=function(t,n){var s=t.hasListeners("rowPress")?"Active":"Inactive";t._oTemplate.setType(s);if(n){this.updateNavigation(t);}};
d.updateRowSettings=function(r,o){r.unbindProperty("navigated");r.unbindProperty("highlight");r.unbindProperty("highlightText");r.applySettings(o.getAllSettings());};
d.disableColumnResizer=function(t,i){var o=a.getPlugin(i);if(o){o.setEnabled(false);o.detachColumnResize(t._onColumnResize,t);}};
d.enableColumnResizer=function(t,i){i.setFixedLayout("Strict");var o=a.getPlugin(i);if(!o){var e=new a();i.addDependent(e);e.attachColumnResize(t._onColumnResize,t);}else{o.setEnabled(true);o.detachColumnResize(t._onColumnResize,t);o.attachColumnResize(t._onColumnResize,t);}};
d.startColumnResize=function(i,o){var e=a.getPlugin(i);if(!e){return;}return e.getColumnResizeButton(o);};
d.prototype._renderShowDetailsButton=function(){var r=C.getLibraryResourceBundle("sap.ui.mdc"),t;t=this.bHideDetails?r.getText("table.SHOWDETAILS_TEXT"):r.getText("table.HIDEDETAILS_TEXT");this._oShowDetailsButton.setText(t);};
d.prototype._toggleShowDetails=function(v){if(!this._oShowDetailsButton||(v===this.bHideDetails)){return;}var t=this.getRelevantTable();this.bHideDetails=v;if(this.bHideDetails){t.setHiddenInPopin(this._getImportanceToHide());}else{t.setHiddenInPopin([]);}this._renderShowDetailsButton();};
d.prototype._getShowDetailsButton=function(){if(!this._oShowDetailsButton){this.bHideDetails=true;this._oShowDetailsButton=new B(this.getId()+"-showHideDetails",{visible:false,press:[function(){this._toggleShowDetails(!this.bHideDetails);},this]});}return this._oShowDetailsButton;};
d.prototype._getImportanceToHide=function(){var e=this.getDetailsButtonSetting()||[];var i=[];if(e.length){i=e;}else{i=D.system.phone?["Low","Medium"]:["Low"];}return i;};
d.prototype._onPopinChanged=function(e){var h=e.getParameter("hasPopin");var H=e.getParameter("hiddenInPopin");var v=e.getSource().getVisibleItems().length;if(v&&(H.length||(h&&!this.bHideDetails))){this._oShowDetailsButton.setVisible(true);}else{this._oShowDetailsButton.setVisible(false);}};
return d;});
sap.ui.predefine('sap/ui/mdc/table/TableSettings',["sap/m/OverflowToolbarButton","sap/m/library","sap/m/MenuButton","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin"],function(O,M,a,C,D,S){"use strict";var H=C.aria.HasPopup;var r;var T={createSettingsButton:function(i,e){if(!r){this._loadResourceBundle();}var b=this._createButton(i+"-settings",{icon:"sap-icon://action-settings",text:r.getText("table.SETTINGS"),press:e,tooltip:r.getText("table.SETTINGS"),ariaHasPopup:H.Dialog});S.addConfig(b,{addAccessibilityLabel:true,messageBundleKey:D.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT"},e[1]);return b;},createPasteButton:function(i){var p=this._createButton(i+"-paste");sap.ui.require(["sap/m/plugins/PasteProvider"],function(P){p.addDependent(new P({pasteFor:i+"-innerTable"}));});return p;},createExportButton:function(i,e){if(!r){this._loadResourceBundle();}var m=new a(i+"-export",{icon:"sap-icon://excel-attachment",tooltip:r.getText("table.EXPORT_BUTTON_TEXT"),type:M.ButtonType.Ghost,buttonMode:M.MenuButtonMode.Split,useDefaultActionOnly:true,defaultAction:e.default});sap.ui.getCore().loadLibrary("sap.ui.unified",{async:true}).then(function(){sap.ui.require(["sap/m/Menu","sap/m/MenuItem"],function(b,c){var o=new b({items:[new c({text:r.getText("table.QUICK_EXPORT"),press:e.default}),new c({text:r.getText("table.EXPORT_WITH_SETTINGS"),press:e.exportAs})]});m.setMenu(o);});});S.addConfig(m._getButtonControl(),{addAccessibilityLabel:true,messageBundleKey:D.os.macintosh?"table.SHORTCUT_EXPORT_TO_EXCEL_MAC":"table.SHORTCUT_EXPORT_TO_EXCEL"},e.exportAs[1]);return m;},_createButton:function(i,s){return new O(i,s);},_loadResourceBundle:function(){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");},showPanel:function(c,p,s,i){T["showUI"+p](c,s);},showUIColumns:function(c,s){c.getEngine().uimanager.show(c,c.getP13nMode(),s);},showUIFilter:function(c,s){c.getEngine().uimanager.show(c,"Filter",s);},createSort:function(c,p,d,R){var s={selected:true,name:p,descending:d,sorted:true};c.getCurrentState().sorters.forEach(function(P){if(P.name==p&&P.descending===d){s.sorted=false;}});var i=[s];c.getEngine().createChanges({control:c,key:"Sort",state:i,applyAbsolute:R});},createGroup:function(c,p){var g={grouped:true,name:p};var G=[g];c.getCurrentState().groupLevels.some(function(P){if(P.name==p){G[0].grouped=false;}});c.getEngine().createChanges({control:c,key:"Group",state:G,applyAbsolute:false});},createAggregation:function(c,p){var A={name:p,aggregated:true};var b=[A];if(c.getCurrentState().aggregations[p]){A.aggregated=false;}c.getEngine().createChanges({control:c,key:"Aggregate",state:b,applyAbsolute:false});},createColumnWidth:function(c,p,w){var o={name:p,width:w};var b=[o];c.getEngine().createChanges({control:c,key:"ColumnWidth",state:b,applyAbsolute:false});},moveColumn:function(c,d,n){if(d!=n){this._moveItem(c,d,n,"moveColumn");}},_moveItem:function(c,d,n,m){var v=c.getCurrentState(c).items||[];var o=v[d];c.getEngine().createChanges({control:c,key:"Column",state:[{name:o.name,position:n}]});}};return T;});
sap.ui.predefine('sap/ui/mdc/table/TableTypeBase',["sap/ui/core/Element"],function(E){"use strict";
var T=E.extend("sap.ui.mdc.table.TableTypeBase",{metadata:{library:"sap.ui.mdc",properties:{}}});
T.prototype.setProperty=function(p,v,s){E.prototype.setProperty.call(this,p,v,true);var t=this.getRelevantTable();if(t){this.updateRelevantTableProperty(t,p,v);}return this;};
T.prototype.updateRelevantTableProperty=function(t,p,v){};
T.prototype.getRelevantTable=function(){var t=this.getParent();if(t&&t.isA("sap.ui.mdc.Table")){t=t._oTable;}else{t=null;}return t;};
T.prototype.updateTableSettings=function(a){var p=Object.assign({},a,this.getMetadata().getProperties()),P,t=this.getRelevantTable();if(t){for(P in p){this.updateRelevantTableProperty(t,P,this.getProperty(P));}}};
T.getSelectionMode=function(t){var s=t.getSelectionMode();switch(s){case"Single":s=t._bMobileTable?"SingleSelectLeft":"Single";break;case"Multi":s=t._bMobileTable?"MultiSelect":"MultiToggle";break;default:s="None";}return s;};
return T;});
sap.ui.predefine('sap/ui/mdc/table/V4AnalyticsPropertyHelper',["./PropertyHelper"],function(T){"use strict";
var P=T.extend("sap.ui.mdc.table.V4AnalyticsPropertyHelper",{constructor:function(p,e,o){T.call(this,p,e,o,{defaultAggregate:{type:{contextDefiningProperties:{type:"PropertyReference[]"}}}});}});
P.prototype.prepareProperty=function(p){T.prototype.prepareProperty.apply(this,arguments);p.aggregatable=p.extension.defaultAggregate!=null;p.getAggregatableProperties=function(){var a=p.isComplex()?p.getReferencedProperties():[p];return a.filter(function(p){return p.aggregatable;});};};
P.prototype.getAggregatableProperties=function(){return this.getProperties().filter(function(p){return p.aggregatable;});};
return P;});
sap.ui.predefine('sap/ui/mdc/ui/Container',["sap/ui/core/Control","sap/m/Page"],function(C,P){"use strict";
var a=C.extend("sap.ui.mdc.ui.Container",{
metadata:{library:"sap.ui.mdc",defaultAggregation:"views",properties:{defaultView:{type:"string"}},aggregations:{header:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-container",aggregation:"customHeader",forwardBinding:true}},subHeader:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-container",aggregation:"subHeader",forwardBinding:true}},footer:{type:"sap.m.IBar",multiple:false,forwarding:{idSuffix:"-container",aggregation:"footer",forwardBinding:true}},views:{type:"sap.ui.mdc.ui.ContainerItem",multiple:true},_content:{type:"sap.ui.core.Control",multiple:false,hidden:true}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("div",c);r.style("height","100%");r.openEnd();r.renderControl(c.getAggregation("_content"));r.close("div");}}
});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this._initializeContent();};
a.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this.switchView(this.getDefaultView());return this;};
a.prototype._initializeContent=function(){this.oLayout=new P(this.getId()+"-container");this.setAggregation("_content",this.oLayout);};
a.prototype.removeView=function(c,s){var o=typeof c=="string"?this.getView(c):c;o=this.removeAggregation("views",o,s);if(o&&o.getKey()===this.getCurrentViewKey()){this.switchView();}return this;};
a.prototype.addView=function(v){if(v&&v.getContent()&&!v.getContent().hasStyleClass("sapUiMDCContainerContent")){v.getContent().addStyleClass("sapUiMDCContainerContent");}this.addAggregation("views",v);return this;};
a.prototype.getCurrentViewKey=function(){return this._sCurrentView?this._sCurrentView:this.getDefaultView();};
a.prototype.getCurrentViewContent=function(){return this.getView(this.getCurrentViewKey()).getContent();};
a.prototype.switchView=function(k){var n=this.getView(k);if(!n){n=this.getViews()[0];if(!n){return;}}this._sCurrentView=n.getKey();this.oLayout.removeAllContent();this.oLayout.addContent(n.getContent());};
a.prototype.getView=function(k){return this.getViews().find(function(v){if(v.getKey()===k){return v;}});};
a.prototype.getViewMap=function(){return this.getViews().map(function(o){return{key:o.getKey(),content:o.getContent()};});};
a.prototype._getResourceText=function(t){this.oResourceBundle=this.oResourceBundle?this.oResourceBundle:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");return t?this.oResourceBundle.getText(t):this.oResourceBundle;};
a.prototype.exit=function(){C.prototype.exit.apply(this,arguments);this._sCurrentView=null;this.oResourceBundle=null;};
return a;});
sap.ui.predefine('sap/ui/mdc/util/Common',[],function(){"use strict";var C={cleanup:function(t,f){f.forEach(function(F){var r=t[F];if(r){if(r.destroy&&!r.bIsDestroyed){r.destroy();}t[F]=null;}});}};return C;});
sap.ui.predefine('sap/ui/mdc/util/FilterUtil',['sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/enum/ConditionValidated',"sap/ui/mdc/condition/ConditionConverter",'sap/ui/mdc/condition/FilterConverter','sap/base/Log','sap/base/util/merge'],function(I,C,a,F,L,m){"use strict";var b={getPropertyByKey:function(p,k){var P=null;p.some(function(o){if(I.getPropertyKeyByPath(o)===k){P=o;}return P!=null;});if(!P){p.some(function(o){if(I.getPropertyKey(o)===k){P=o;}return P!=null;});}return P;},getConditionsMap:function(f,p){var P,o,r={};if(!f||!f.isA("sap.ui.mdc.FilterBar")){L.error("instance of sap.ui.mdc.FilterBar expected");return r;}var c=f.getInternalConditions();for(var s in c){if(p.indexOf(s)>=0){P=[];if(c[s]){for(var i=0;i<c[s].length;i++){o={};o.operator=c[s][i].operator;if((o.operator==="EQ")&&(c[s][i].validated===C.Validated)){o.values=[c[s][i].values[0]];}else{o.values=c[s][i].values;}P.push(o);}r[s]=P;}}}return r;},getFilterInfo:function(t,c,p,d){var f={};d=d?d:[];var i,s,e={},o;var g={};if(p&&p.length>0){for(s in c){if(d.indexOf(s)<0){var P=b.getPropertyByKey(p,s);if(P){g[s]={type:P.typeConfig.typeInstance,caseSensitive:P.caseSensitive};e[s]=[];for(i=0;i<c[s].length;i++){o=m({},c[s][i]);e[s].push(a.toType(o,P.typeConfig,t.getTypeUtil?t.getTypeUtil():t));}}else{L.error("no such property: "+s);}}}if(Object.keys(e).length>0){f.filters=F.createFilters(e,g);}}return f;}};return b;});
sap.ui.predefine('sap/ui/mdc/util/FormatUtil',[],function(){"use strict";var F={getWidth:function(p,m,M){var w=p.precision||p.maxLength,W;if(!m){m=20;}if(!M){M=3;}if(p.type==="Edm.DateTime"&&p.type==="Edm.Date"){w="9em";}else if(w){if(w==="Max"){w=m+"";}W=parseInt(w);if(!isNaN(W)){W+=0.75;if(W>m){W=m;}else if(W<M){W=M;}w=W+"em";}else{w=null;}}if(!w){if(p.type==="Edm.Boolean"){w=M+"em";}else{w=m+"em";}}return w;}};return F;});
sap.ui.predefine('sap/ui/mdc/util/IdentifierUtil',['sap/ui/base/DataType'],function(D){"use strict";var I={replace:function(n){var t=D.getType("sap.ui.core.ID");if(!t.isValid(n)){n=n.replace(/[^A-Za-z0-9_.:]+/g,"__mdc__");if(!t.isValid(n)){n="__mdc__"+n;}}return n;},getFilterFieldId:function(f,k){return f.getId()+"--filter--"+I.replace(k);},getPropertyKey:function(p){return p.name;},getPropertyKeyByPath:function(p){return p.path;},getView:function(c){var v=null;if(c){var o=c.getParent();while(o){if(o.isA("sap.ui.core.mvc.View")){v=o;break;}o=o.getParent();}}return v;}};return I;});
sap.ui.predefine('sap/ui/mdc/util/PropertyHelper',["sap/ui/base/Object","sap/ui/base/DataType","sap/base/util/merge","sap/base/util/isPlainObject","sap/base/Log"],function(B,D,m,a,L){"use strict";var A={name:{type:"string",mandatory:true,allowedForComplexProperty:true},label:{type:"string",mandatory:true,allowedForComplexProperty:true},visible:{type:"boolean",defaultValue:true,allowedForComplexProperty:true},path:{type:"string",valueForComplexProperty:null},typeConfig:{type:{className:{type:"string"},baseType:{type:"string"},typeInstance:{type:"object"}},valueForComplexProperty:null},maxConditions:{type:"int",defaultValue:-1,valueForComplexProperty:null},caseSensitive:{type:"boolean",defaultValue:true},group:{type:"string",allowedForComplexProperty:true},groupLabel:{type:"string",allowedForComplexProperty:true},filterable:{type:"boolean",defaultValue:true,valueForComplexProperty:false},sortable:{type:"boolean",defaultValue:true,valueForComplexProperty:false},key:{type:"boolean",valueForComplexProperty:false},groupable:{type:"boolean",valueForComplexProperty:false},propertyInfos:{type:"PropertyReference[]",allowedForComplexProperty:true},unit:{type:"PropertyReference"},text:{type:"PropertyReference"},exportSettings:{type:"object",allowedForComplexProperty:true},visualSettings:{type:"object"},required:{type:"boolean"},hiddenFilter:{type:"boolean"}};var p={isComplex:function(){return P.isPropertyComplex(this);},getReferencedProperties:function(){return this.propertyInfosProperties||[];},getSortableProperties:function(){return o(this,function(i){return i.sortable;});},getFilterableProperties:function(){return o(this,function(i){return i.filterable;});},getGroupableProperties:function(){return o(this,function(i){return i.groupable;});},getVisibleProperties:function(){return o(this,function(i){return i.visible;});}};var c=["name","label","visible","path","typeConfig","maxConditions","group","groupLabel","caseSensitive"];var _=new WeakMap();
function s(O){return JSON.stringify(O,function(K,V){return V===undefined?null:V;})||"";}
function r(M,i){var w=s(i);L.warning("Invalid property definition: "+M+(w?"\n"+w:""));}
function t(M,i){var w=i?s(i):null;throw new Error("Invalid property definition: "+M+(w?"\n"+w:""));}
function e(i,w){w.map(function(x){Object.keys(p).forEach(function(M){Object.defineProperty(x,M,{value:function(){return p[M].call(this);},writable:true});});});}
function d(O){var K=Object.getOwnPropertyNames(O);Object.freeze(O);for(var i=0;i<K.length;i++){var V=O[K[i]];if(typeof V==="function"){Object.freeze(V);}else if(a(V)&&!Object.isFrozen(V)){d(V);}else if(Array.isArray(V)){d(V);}}}
function b(O,i){if(!i){return O;}return i.split(".").reduce(function(C,S){return C&&C[S]?C[S]:null;},O);}
function g(i){var T;if(typeof i==="object"){T="object";}else{T=i.replace("PropertyReference","string");}return D.getType(T);}
function f(i){var w=g(i);if(w.isArrayType()){return w.getBaseType().getDefaultValue();}else{return w.getDefaultValue();}}
function h(i,w){w.forEach(function(x){i.prepareProperty(x);});d(w);}
function j(i,w,x,y,z,C){var T=y==null;var E=[];var I=P.isPropertyComplex(w);if(T){C=_.get(i).mAttributeMetadata;z=w;}if(!z){return[];}for(var F in C){var G=C[F];var H=T?F:y+"."+F;var V=z[F];if(I&&!G.allowedForComplexProperty){if("valueForComplexProperty"in G){z[F]=G.valueForComplexProperty;}continue;}if(V!=null&&typeof G.type==="string"&&G.type.startsWith("PropertyReference")||H==="propertyInfos"){if(I||H!=="propertyInfos"){k(z,F,x);}continue;}if(V==null){l(z,G,y,F,E);}if(typeof G.type==="object"){E=E.concat(j(i,w,x,H,z[F],G.type));}}return E;}
function k(i,w,x){var y=i[w];var z;var C=w;if(Array.isArray(y)){z=y.map(function(N){return x[N];});C+="Properties";}else{z=x[y];C+="Property";}Object.defineProperty(i,C,{value:z});}
function l(i,w,S,x,y){if("defaultValue"in w){if(typeof w.defaultValue==="string"&&w.defaultValue.startsWith("attribute:")){y.push({source:w.defaultValue.substring(w.defaultValue.indexOf(":")+1),targetPath:S,targetAttribute:x,targetType:w.type});}else if(typeof w.defaultValue==="object"&&w.defaultValue!==null){i[x]=m({},w.defaultValue);}else{i[x]=w.defaultValue;}}else{i[x]=f(w.type);}}
function n(i){return Object.freeze(i.reduce(function(M,w){M[w.name]=w;return M;},{}));}
function o(i,F){if(i.isComplex()){return i.getReferencedProperties().filter(F);}else if(F(i)){return[i];}else{return[];}}
function q(w,E){var M=0;E=E||{};for(var i=0;i<w.length;i++){if("extension"in w[i]){t("Property contains invalid attribute 'extension'.",w[i]);}if(w[i].name in E){w[i].extension=E[w[i].name];M++;}else{w[i].extension={};}}if(M!==Object.keys(E).length){throw new Error("At least one property extension does not point to an existing property.");}}
var P=B.extend("sap.ui.mdc.util.PropertyHelper",{constructor:function(i,E,w,x,y){B.call(this);if(!Array.isArray(i)){t("Property infos must be an array.");}if(E){if(!y){throw new Error("Property extensions are not supported.");}else if(!a(E)){throw new Error("Property extensions must be a plain object.");}}if(w&&!B.isA(w,"sap.ui.base.ManagedObject")){throw new Error("The type of the parent is invalid.");}if(this._mExperimentalAdditionalAttributes){Object.keys(A).concat("extension").forEach(function(G){if(G in this._mExperimentalAdditionalAttributes){throw new Error("The attribute '"+G+"' is reserved and cannot be overridden by additional attributes.");}}.bind(this));}var z={};var I=c.concat(x||[]).reduce(function(M,G){if(G in A){M[G]=A[G];}return M;},Object.assign({},this._mExperimentalAdditionalAttributes));if(y){z.mAttributeMetadata=Object.assign({extension:{type:y,mandatory:true,allowedForComplexProperty:true}},I);z.aMandatoryExtensionAttributes=Object.keys(y).filter(function(G){return y[G].mandatory;});}else{z.mAttributeMetadata=I;z.aMandatoryExtensionAttributes=[];}z.aMandatoryAttributes=Object.keys(z.mAttributeMetadata).filter(function(G){return z.mAttributeMetadata[G].mandatory;});var C=m([],i);var F=n(C);if(y){q(C,m({},E));}_.set(this,z);this.validateProperties(C);z.oParent=w||null;z.aProperties=C;z.mProperties=F;e(this,C);h(this,C);}});
P.prototype.validateProperties=function(w){var U=new Set();for(var i=0;i<w.length;i++){this.validateProperty(w[i],w);U.add(w[i].name);}if(U.size!==w.length){t("Properties do not have unique names.");}};
P.prototype.validateProperty=function(i,w){if(!a(i)){t("Property info must be a plain object.",i);}v(this,i,w);if(P.isPropertyComplex(i)){if(i.propertyInfos.length===0){t("Complex property does not reference existing properties.",i);}}_.get(this).aMandatoryAttributes.forEach(function(M){if(!(M in i)){r("Property does not contain mandatory attribute '"+M+"'.",i);}else if(i[M]==null){t("Property does not contain mandatory attribute '"+M+"'.",i);}});_.get(this).aMandatoryExtensionAttributes.forEach(function(M){if(!(M in i.extension)){r("Property does not contain mandatory attribute 'extension."+M+"'.",i);}else if(i.extension[M]==null){t("Property does not contain mandatory attribute 'extension."+M+"'.",i);}});};
function v(i,w,x,y,z,C){var T=y==null;if(T){C=_.get(i).mAttributeMetadata;z=w;}for(var E in z){var F=C[E];var G=T?E:y+"."+E;var V=z[E];if(!F){r("Property contains invalid attribute '"+G+"'.",w);}else if(P.isPropertyComplex(w)&&!F.allowedForComplexProperty){r("Complex property contains invalid attribute '"+G+"'.",w);}else if(typeof F.type==="object"&&V&&typeof V==="object"){v(i,w,x,G,V,F.type);}else if(V!=null&&!g(F.type).isValid(V)){t("The value of '"+G+"' is invalid.",w);}else if(V&&typeof F.type==="string"&&F.type.startsWith("PropertyReference")){u(i,w,x,G,V,F);}}}
function u(w,x,y,z,C,E){var F=E.type.endsWith("[]")?C:[C];var U=new Set(F);if(F.indexOf(x.name)>-1){t("Property references itself in the '"+z+"' attribute",x);}if(U.size!==F.length){t("Property contains duplicate names in the '"+z+"' attribute.",x);}for(var i=0;i<y.length;i++){if(U.has(y[i].name)){if(P.isPropertyComplex(y[i])){t("Property references complex properties in the '"+z+"' attribute.",x);}U.delete(y[i].name);}}if(U.size>0){t("Property references non-existing properties in the '"+z+"' attribute.",x);}}
P.prototype.prepareProperty=function(i){var w=this.getPropertyMap();var x=j(this,i,w);x.forEach(function(y){var z=b(i,y.targetPath);if(z){var V=b(i,y.source);if(V==null){V=f(y.targetType);}z[y.targetAttribute]=V;if(typeof y.targetType==="string"&&y.targetType.startsWith("PropertyReference")){k(z,y.targetAttribute,w);}}});};
P.prototype.getParent=function(){var i=_.get(this);return i?i.oParent:null;};
P.prototype.getProperties=function(){var i=_.get(this);return i?i.aProperties:[];};
P.prototype.getPropertyMap=function(){var i=_.get(this);return i?i.mProperties:{};};
P.prototype.getProperty=function(N){return this.getPropertyMap()[N]||null;};
P.prototype.hasProperty=function(N){return N in this.getPropertyMap();};
P.isPropertyComplex=function(i){return i!=null&&typeof i==="object"?"propertyInfos"in i:false;};
P.prototype.getSortableProperties=function(){return this.getProperties().filter(function(i){return i.sortable;});};
P.prototype.getFilterableProperties=function(){return this.getProperties().filter(function(i){return i.filterable;});};
P.prototype.getGroupableProperties=function(){return this.getProperties().filter(function(i){return i.groupable;});};
P.prototype.getKeyProperties=function(){return this.getProperties().filter(function(i){return i.key;});};
P.prototype.getVisibleProperties=function(){return this.getProperties().filter(function(i){return i.visible;});};
P.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);_.delete(this);};
return P;});
sap.ui.predefine('sap/ui/mdc/valuehelp/Dialog',['sap/ui/mdc/valuehelp/base/Container','sap/ui/mdc/valuehelp/base/DialogTab','sap/ui/mdc/util/loadModules','sap/ui/Device','sap/m/VBox','sap/m/FlexItemData','sap/ui/model/resource/ResourceModel','sap/ui/mdc/util/Common','sap/ui/mdc/enum/SelectType'],function(C,D,l,a,V,F,R,b,S){"use strict";var M,c,B,d,I,e;var P,H,T,f,g;
var h=C.extend("sap.ui.mdc.valuehelp.Dialog",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContainer"],properties:{_selectedContentKey:{type:"string",visibility:"hidden"},_quickSelectEnabled:{type:"boolean",visibility:"hidden",defaultValue:false}},defaultAggregation:"content"}});
function _(){if(a.system.desktop){return"700px";}if(a.system.tablet){return a.orientation.landscape?"600px":"600px";}}
function j(){if(a.system.desktop){return"1080px";}if(a.system.tablet){return a.orientation.landscape?"920px":"600px";}}
h.prototype.invalidate=function(o){if(o){var i=this.getContent();var k=i.indexOf(o);if(this._oIconTabBar&&k!==-1&&!this._bIsBeingDestroyed){var m=this._oIconTabBar.getItems();if(m[k]){m[k].invalidate(o);}}else{C.prototype.invalidate.apply(this,arguments);}}};
h.prototype._getUIAreaForContent=function(){var o=this.getAggregation("_container");if(o){return o.getUIArea();}return C.prototype._getUIAreaForContent.apply(this,arguments);};
h.prototype._handleConfirmed=function(E){this.fireConfirm({close:true});};
h.prototype._handleClosed=function(E){var i=this.getContent();var o=this._sSelectedKey&&i&&i.find(function(o){return o.getId()===this._sSelectedKey;}.bind(this));if(o){o.onHide();}C.prototype._handleClosed.apply(this,arguments);};
h.prototype._getContainer=function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}var o=this.getAggregation("_container");if(!o){return this._retrievePromise("dialog",function(){return l(["sap/m/Dialog","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/m/library"]).then(function(m){M=m[0];B=m[1];d=m[2];c=m[3];var i=c.ButtonType;if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}this.oButtonOK=new B(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:i.Emphasized,press:this._handleConfirmed.bind(this),visible:{parts:['$valueHelp>/_config/maxConditions','$help>/_quickSelectEnabled'],formatter:function(n,q){return n!==1||!q;}}});this.oButtonCancel=new B(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this._handleCanceled.bind(this)});this._oManagedObjectModel=new d(this);var o=new M(this.getId()+"-dialog",{contentHeight:_(),contentWidth:j(),horizontalScrolling:false,verticalScrolling:false,title:{parts:['$help>/title','$help>/content'],formatter:function(s,n){if(n.length==1){var p=n[0];var q=p.getFormattedShortTitle()?p.getFormattedShortTitle():p.getTitle();if(q){s=this._oResourceBundle.getText("valuehelp.DIALOGSHORTTITLECOLONTITLE",[q,s]);}}return s;}.bind(this)},stretch:a.system.phone,resizable:true,draggable:true,afterOpen:this._handleOpened.bind(this),afterClose:this._handleClosed.bind(this),buttons:[this.oButtonOK,this.oButtonCancel]});o.setModel(this._oManagedObjectModel,"$help");this.setAggregation("_container",o,true);o.isPopupAdaptationAllowed=function(){return false;};o.addStyleClass("sapMdcValueHelp");o.addStyleClass("sapMdcValueHelpTitle");o.addStyleClass("sapMdcValueHelpTitleShadow");var v=new V(this.getId()+"-Content",{fitContainer:true});v.addStyleClass("sapMdcValueHelpPanel");o.addContent(v);var k=this._getIconTabBar(o);var t=this._getTokenizerPanel();return Promise.all([k,t]).then(function(n){n.forEach(function(p){v.addItem(p);});return o;});}.bind(this));}.bind(this));}return o;};
h.prototype._handleSelect=function(E){C.prototype._handleSelect.apply(this,arguments);if(this.getProperty("_quickSelectEnabled")&&this._isSingleSelect()){this.fireConfirm({close:true});}};
h.prototype._observeChanges=function(o){if(o.name==="content"){var i=this.getContent();this.setProperty("_quickSelectEnabled",i&&i.every(function(k){return k.isQuickSelectSupported&&k.isQuickSelectSupported();}));}C.prototype._observeChanges.apply(this,arguments);};
h.prototype._onTabBarSelect=function(E){var i=this.getContent();var n=E&&E.getParameter("key");var p=this._sSelectedKey&&i&&i.find(function(k){return k.getId()===this._sSelectedKey;}.bind(this));if(p){p.onHide();}this._sSelectedKey=n||this._oIconTabBar&&this._oIconTabBar.getSelectedKey();if(!this._sSelectedKey){var o=this._oIconTabBar.getItems()[0];this._sSelectedKey=o&&o.getKey();if(this._sSelectedKey){this.setProperty("_selectedContentKey",this._sSelectedKey);}}var s=this._sSelectedKey?i&&i.find(function(k){return k.getId()===this._sSelectedKey;}.bind(this)):i[0];if(s){Promise.all([this._retrievePromise("open"),s.getContent()]).then(function(){s.onShow();});}};
h.prototype._getIconTabBar=function(o){if(!this._oIconTabBar){return l(["sap/m/IconTabBar","sap/m/IconTabFilter"]).then(function(m){I=m[0];e=m[1];var i=c.IconTabHeaderMode;this._oIconTabBar=new I(this.getId()+"-ITB",{expandable:false,upperCase:false,stretchContentHeight:true,headerMode:i.Inline,select:this._onTabBarSelect.bind(this),layoutData:new F({growFactor:1}),selectedKey:"{$help>/_selectedContentKey}",visible:{parts:['$help>/content'],formatter:function(n){if(n&&n.length==1){this.addStyleClass("sapMdcNoHeader");o.removeStyleClass("sapMdcValueHelpTitleShadow");}else{this.removeStyleClass("sapMdcNoHeader");o.addStyleClass("sapMdcValueHelpTitleShadow");}return true;}}});this._oIconTabBar.addStyleClass("sapUiNoContentPadding");var k=new e(this.getId()+"-ITF",{key:{path:"$help>id"},content:new D(this.getId()+"-DT",{content:{path:"$help>displayContent"}}),text:{parts:['$help>','$valueHelp>/conditions'],formatter:function(n,p){return n?n.getFormattedTitle(n.getCount(p)):"none";}}});this._oIconTabBar.bindAggregation("items",{path:"/content",model:"$help",templateShareable:false,template:k});return this._oIconTabBar;}.bind(this));}return this._oIconTabBar;};
h.prototype._getTokenizerPanel=function(o){if(!this.oTokenizerPanel){return l(['sap/m/Panel','sap/m/HBox','sap/m/VBox','sap/m/Tokenizer','sap/m/Token','sap/base/strings/formatMessage','sap/ui/model/Filter','sap/ui/mdc/field/ConditionType']).then(function(m){P=m[0];H=m[1];V=m[2];T=m[3];f=m[4];g=m[5];var k=m[6];var n=m[7];var p=c.BackgroundDesign;var q=c.ButtonType;this.oTokenizerPanel=new P(this.getId()+"-TokenPanel",{backgroundDesign:p.Transparent,expanded:true,visible:{parts:['$valueHelp>/_config/maxConditions','$help>/content'],formatter:function(i,y){var z=false;if(y&&y.some(function(A){return A.getRequiresTokenizer();})){z=true;}return z&&i===-1;}},headerText:{parts:['$i18n>valuehelp.TOKENIZERTITLE','$valueHelp>/conditions'],formatter:function(y,z){var A=0;for(var i=0;i<z.length;i++){var E=z[i];if(E.isEmpty!==true){A++;}}if(A===0){y=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER");}return g(y,A);}.bind(this)}});this.oTokenizerPanel.addStyleClass("sapMdcTokenizerPanel");var r=new H(this.getId()+"-TokenBox",{fitContainer:true,width:"100%"});var s=new k({path:'isEmpty',operator:'NE',value1:true});var v=this.getModel("$valueHelp");var t=v?v.getProperty("/_config"):{};var u=this.getParent();var w={maxConditions:-1,valueType:t.dataType,operators:t.operators,display:t.display,fieldHelpID:u&&u.getId()};var x=new f(this.getId()+"-Token",{text:{path:'$valueHelp>',type:new n(w)}});this.oTokenizer=new T(this.getId()+"-Tokenizer",{width:"100%",tokenDelete:function(E){if(E.getParameter("tokens")){var y=E.getParameter("tokens");var z=this.getModel("$valueHelp").getObject("/conditions");var A=[];y.forEach(function(G,i){var J=G.getBindingContext("$valueHelp").sPath;var K=parseInt(J.slice(J.lastIndexOf("/")+1));A.push(z[K]);});this.fireSelect({type:S.Remove,conditions:A});}}.bind(this),tokens:{path:'/conditions',model:"$valueHelp",templateShareable:false,template:x,filters:s},layoutData:new F({growFactor:1,maxWidth:"calc(100% - 2rem)"})});this.oTokenizer.addAriaDescribedBy(this.oTokenizer.getTokensInfoId());this.oTokenizer.addStyleClass("sapMdcTokenizer");this.oRemoveAllBtn=new B(this.getId()+"-TokenRemoveAll",{press:function(E){this.fireSelect({type:S.Set,conditions:[]});}.bind(this),type:q.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.REMOVEALLTOKEN}",layoutData:new F({growFactor:0,baseSize:"2rem"})});this.oRemoveAllBtn.addStyleClass("sapUiTinyMarginBegin");r.addItem(this.oTokenizer);r.addItem(this.oRemoveAllBtn);this.oTokenizerPanel.addContent(r);return this.oTokenizerPanel;}.bind(this));}return this.oTokenizerPanel;};
h.prototype._open=function(o){this._onTabBarSelect();if(o){o.open();}};
h.prototype._close=function(){var o=this.getAggregation("_container");if(o){o.close();}};
h.prototype.getValueHelpIcon=function(){return"sap-icon://value-help";};
h.prototype.getAriaAttributes=function(m){return{contentId:null,ariaHasPopup:"dialog",role:null,roleDescription:null};};
h.prototype.isMultiSelect=function(){return this.getMaxConditions()!==1;};
h.prototype.exit=function(){b.cleanup(this,["_oManagedObjectModel","_oResourceBundle","oButtonOK","oButtonCancel","oTokenizerPanel","oTokenizer","_oIconTabBar"]);};
return h;});
sap.ui.predefine('sap/ui/mdc/valuehelp/Popover',['sap/ui/mdc/valuehelp/base/Container','sap/ui/mdc/util/loadModules',"sap/ui/dom/units/Rem"],function(C,l,R){"use strict";var M,a,T,b;
var P=C.extend("sap.ui.mdc.valuehelp.Popover",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer"],properties:{},defaultAggregation:"content"}});
P.prototype.invalidate=function(o){if(o){var p=this.getAggregation("_container");var c=this._oCurrentContent;if(p&&c&&o===c&&!this._bIsBeingDestroyed){p.invalidate(o);}else{C.prototype.invalidate.apply(this,arguments);}}};
P.prototype._getUIAreaForContent=function(){var p=this.getAggregation("_container");if(p){return p.getUIArea();}return C.prototype._getUIAreaForContent.apply(this,arguments);};
P.prototype._getContent=function(){var c=this.getContent();return c&&c[0];};
P.prototype._getContainer=function(){var p=this.getAggregation("_container");if(!p){return l(["sap/m/Popover","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(function(L){M=L[0];a=L[1];T=L[2];b=L[3];p=new M(this.getId()+"-pop",{contentHeight:"auto",placement:a.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,title:this.getTitle(),titleAlignment:a.TitleAlignment.Center,afterOpen:this._handleOpened.bind(this),afterClose:this._handleClosed.bind(this)}).addStyleClass("sapMdcValueHelpPopover").addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");p.addStyleClass(this._isSingleSelect()?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");p.addDelegate({onsapshow:this._handleRequestSwitchToDialog.bind(this)});p._getAllContent=function(){var d=this.getParent();var e=[];if(d){if(this._oCurrentContent){e.push(this._oCurrentContent);}}return e;}.bind(this);var c=this._getContent();var o=this._getContainerConfig(c);if(o){p.setShowArrow(!!o.showArrow);p.setShowHeader(!!o.showHeader);p.setResizable(!!o.resizable);if(o.getContentWidth){p.setContentWidth(o.getContentWidth());}}this.setAggregation("_container",p,true);return p;}.bind(this));}return p;};
var _=function(){var c=this.getAggregation("_container");var o=this._getContent();var d=o&&this._getContainerConfig(o);if(c&&d&&d.getContentHeight){var h=d.getContentHeight();var i=c.$().find(".sapMPopoverCont").height();var e=i<R.toPx("30rem");c.setContentHeight(!h||e||i>=h?"auto":"30rem");c.invalidate();}};
P.prototype.providesScrolling=function(){return true;};
P.prototype._observeChanges=function(c){if(c.name==="content"){var o=c.child;if(c.mutation==="remove"){o.detachEvent("contentUpdated",_,this);o.detachNavigated(this._handleNavigated,this);}else{o.attachEvent("contentUpdated",_,this);}}C.prototype._observeChanges.apply(this,arguments);};
P.prototype._placeContent=function(p){var c=this._getContent();var o=c&&c.getContent();var d=this._getContainerConfig(c);var f=d&&d.getFooter&&d.getFooter();return Promise.all([o,f]).then(function(e){this._oCurrentContent=e[0];var F=e[1];if(F&&p.getFooter()!=F&&F.isA&&F.isA("sap.m.Toolbar")){p.setFooter(F);return p;}if(F){if(!p.getFooter()){var t=[new b(this.getId()+"-Spacer")].concat(F);var g=new T(this.getId()+"-TB",{content:t}).setModel(this._oManagedObjectModel,"$help");p.setFooter(g);}else{}}else if(p.getFooter()){p.setFooter();}return p;}.bind(this));};
P.prototype._open=function(p){if(p.isOpen()){return;}var c=this._getControl();var t=c&&c.getFocusElementForValueHelp?c.getFocusElementForValueHelp(this.isTypeahead()):c;if(t&&t.getDomRef()){p.setContentMinWidth(jQuery(t.getDomRef()).outerWidth()+"px");if(!this.isFocusInHelp()){p.setInitialFocus(t);}p.openBy(t);}};
P.prototype._close=function(){var p=this.getAggregation("_container");if(p){p.close();}};
P.prototype._handleOpened=function(){_.call(this);C.prototype._handleOpened.apply(this,arguments);var c=this._getContent();if(c){c.onShow();}};
P.prototype._handleConfirmed=function(e){this.fireConfirm({close:e.getParameter("close")||this._isSingleSelect()});};
P.prototype._handleClosed=function(e){var c=this._getContent();if(c){c.onHide();}var p=this.getAggregation("_container");if(p){p._oPreviousFocus=null;}C.prototype._handleClosed.apply(this,arguments);};
P.prototype.removeFocus=function(){var c=this._getContent();if(c){c.removeFocus();}};
P.prototype._navigate=function(s){var c=this._getContent();if(c){return c.navigate(s);}};
P.prototype.getItemForValue=function(c){var o=this._getContent();if(o){return o.getItemForValue(c);}};
P.prototype.isValidationSupported=function(c){var o=this._getContent();if(o){return o.isValidationSupported();}};
P.prototype.getUseAsValueHelp=function(){var c=this._getContent();return c&&c.getUseAsValueHelp&&c.getUseAsValueHelp();};
P.prototype.getValueHelpIcon=function(){var c=this._getContent();return c&&c.getValueHelpIcon();};
P.prototype.getAriaAttributes=function(m){var c=this._getContent();var o=c&&c.getAriaAttributes(m);if(o){return{contentId:o.contentId,ariaHasPopup:o.ariaHasPopup,role:this.getUseAsValueHelp()?"combobox":null,roleDescription:o.roleDescription};}return C.prototype.getAriaAttributes.apply(this,arguments);};
P.prototype.shouldOpenOnClick=function(){var c=this._getContent();return!!c&&c.shouldOpenOnClick();};
P.prototype.shouldOpenOnNavigate=function(){var c=this._getContent();return!!c&&c.shouldOpenOnNavigate();};
P.prototype.isFocusInHelp=function(){var c=this._getContent();return!!c&&c.isFocusInHelp();};
P.prototype.isMultiSelect=function(){var c=this._getContent();return!!c&&c.isMultiSelect();};
P.prototype.isTypeaheadSupported=function(){var c=this._getContent();return c&&c.isSearchSupported();};
P.prototype.exit=function(){if(this._oCurrentContent){if(!this._oCurrentContent.bIsDestroyed){this._oCurrentContent.destroy();}this._oCurrentContent=null;}};
return P;});
sap.ui.predefine('sap/ui/mdc/valuehelp/base/Container',['sap/ui/core/Element','sap/ui/mdc/mixin/PromiseMixin','sap/ui/model/BindingMode','sap/ui/base/ManagedObjectObserver'],function(E,P,B,M){"use strict";
var C=E.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enum.SelectType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{},closed:{},cancel:{},requestDelegateContent:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"}}},requestSwitchToDialog:{},navigated:{parameters:{bLeaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}}}}});
C.prototype.init=function(){this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]});};
C.prototype._observeChanges=function(c){if(c.name==="content"){var o=c.child;if(c.mutation==="remove"){o.unbindProperty("filterValue");o.unbindProperty("conditions");o.unbindProperty("config");o.detachConfirm(this._handleConfirmed,this);o.detachCancel(this._handleCanceled,this);o.detachSelect(this._handleSelect,this);o.detachRequestDelegateContent(this._handleRequestDelegateContent,this);if(o.detachNavigated){o.detachNavigated(this._handleNavigated,this);}if(o.detachRequestSwitchToDialog){o.detachRequestSwitchToDialog(this._handleRequestSwitchToDialog,this);}}else{o.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:B.OneWay});var b={path:"/conditions",model:"$valueHelp",mode:B.OneWay};if(o._formatConditions){b.formatter=o._formatConditions.bind(o);}o.bindProperty("conditions",b);o.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:B.OneWay});o.attachConfirm(this._handleConfirmed,this);o.attachCancel(this._handleCanceled,this);o.attachSelect(this._handleSelect,this);o.attachRequestDelegateContent(this._handleRequestDelegateContent,this);if(o.attachNavigated){o.attachNavigated(this._handleNavigated,this);}if(o.attachRequestSwitchToDialog){o.attachRequestSwitchToDialog(this._handleRequestSwitchToDialog,this);}}}};
C.prototype._handleNavigated=function(e){this.fireNavigated(e.mParameters);};
C.prototype._handleRequestSwitchToDialog=function(e){this.fireRequestSwitchToDialog({container:this});};
C.prototype._getContainer=function(){};
C.prototype._getControl=function(){var v=this.getParent();return v&&v.getControl();};
C.prototype.getMaxConditions=function(){var v=this.getModel("$valueHelp");return v&&v.getObject("/_config/maxConditions");};
C.prototype._isSingleSelect=function(){return this.getMaxConditions()===1;};
C.prototype.getDomRef=function(){var c=this.getAggregation("_container");return c&&c.getDomRef();};
C.prototype.getUIArea=function(){return null;};
C.prototype._getUIAreaForContent=function(){return this.getUIArea();};
C.prototype.open=function(v){if(!this.isOpening()){var o=this._addPromise("open");return Promise.all([this._getContainer(),v]).then(function(r){return this._placeContent(r[0]);}.bind(this)).then(function(c){if(!o.isCanceled()){this._open(c);}return o;}.bind(this));}return this._retrievePromise("open");};
C.prototype.close=function(){var p=this._retrievePromise("open");if(p){if(p.isSettled()){this._close();}else{this._cancelPromise(p);}}};
C.prototype._placeContent=function(c){return c;};
C.prototype._open=function(c){};
C.prototype._close=function(){};
C.prototype._handleOpened=function(){this._resolvePromise("open");this.fireOpened();};
C.prototype._handleClosed=function(e){this._removePromise("open");this.fireClosed();};
C.prototype._handleConfirmed=function(e){this.fireConfirm();};
C.prototype._handleCanceled=function(e){this.fireCancel();};
C.prototype._handleRequestDelegateContent=function(e){this.fireRequestDelegateContent({container:this});};
C.prototype._handleSelect=function(e){this.fireSelect({type:e.getParameter("type"),conditions:e.getParameter("conditions")});};
C.prototype.isOpen=function(){var p=this._retrievePromise("open");return p&&p.isSettled();};
C.prototype.isOpening=function(){var p=this._retrievePromise("open");return p&&!p.isCanceled()&&!p.isSettled();};
C.prototype.getItemForValue=function(c){};
C.prototype.isValidationSupported=function(){return false;};
C.prototype.navigate=function(s){return Promise.all([this._getContainer()]).then(function(r){return this._placeContent(r[0]);}.bind(this)).then(function(c){this._navigate(s);}.bind(this));};
C.prototype._navigate=function(s){};
C.prototype.removeFocus=function(){};
C.prototype.isTypeahead=function(){var v=this.getParent();return v&&v.getTypeahead()===this;};
C.prototype.isTypeaheadSupported=function(){return false;};
C.prototype.providesScrolling=function(){return false;};
C.prototype.getValueHelpDelegate=function(){var v=this.getParent();return v&&v.getControlDelegate();};
C.prototype.getValueHelpDelegatePayload=function(){var v=this.getParent();return v&&v.getPayload();};
C.prototype.awaitValueHelpDelegate=function(){var v=this.getParent();return v&&v.awaitControlDelegate();};
C.prototype.isValueHelpDelegateInitialized=function(){var v=this.getParent();return v&&v.bDelegateInitialized;};
C.prototype.getUseAsValueHelp=function(){return false;};
C.prototype.getValueHelpIcon=function(){};
C.prototype.getAriaAttributes=function(m){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null};};
C.prototype.getScrollDelegate=function(m){var c=this.getAggregation("_container");return c&&c.getScrollDelegate&&c.getScrollDelegate();};
C.prototype.shouldOpenOnClick=function(){return false;};
C.prototype.shouldOpenOnNavigate=function(){return false;};
C.prototype.isFocusInHelp=function(){return!this.isTypeahead();};
C.prototype.isMultiSelect=function(){return false;};
C.prototype._getContainerConfig=function(c){var o=c&&c.getContainerConfig();var r=o&&o[this.getMetadata().getName()];if(!r&&o){var t=Object.keys(o);var n=t.find(function(T){return this.isA(T);}.bind(this));if(n){r=o[n];}}return r;};
C.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined;};
P.call(C.prototype);return C;});
sap.ui.predefine('sap/ui/mdc/valuehelp/base/Content',['sap/ui/core/Element','sap/ui/mdc/mixin/PromiseMixin','sap/ui/base/ManagedObjectObserver','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/enum/ConditionValidated','sap/base/strings/formatMessage'],function(E,P,M,C,F,O,a,f){"use strict";
var b=E.extend("sap.ui.mdc.valuehelp.base.Content",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""},shortTitle:{type:"string",group:"Appearance",defaultValue:""},conditions:{type:"object[]",defaultValue:[],byValue:true},filterValue:{type:"string",defaultValue:""},config:{type:"object",defaultValue:{}}},aggregations:{displayContent:{type:"sap.ui.core.Control",multiple:false}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enum.SelectType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{},requestDelegateContent:{},requestSwitchToDialog:{},navigated:{parameters:{bLeaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}}}}});
b.prototype.init=function(){this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["filterValue","conditions","config"]});this._oOperator=F.getEQOperator();};
b.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined;};
b.prototype.setProperty=function(p,v,s){if(p==="conditions"||p==="filterValue"||p==="config"){s=true;}return E.prototype.setProperty.apply(this,[p,v,s]);};
b.prototype.getContent=function(){};
b.prototype.getContainerConfig=function(){};
b.prototype.onShow=function(){this._bVisible=true;this._handleConditionsUpdate();};
b.prototype.onHide=function(){this._bVisible=false;};
b.prototype.getItemForValue=function(o){};
b.prototype.isValidationSupported=function(){return false;};
b.prototype.getScrollDelegate=function(){var o=this.getParent();return o&&o.getScrollDelegate();};
b.prototype._observeChanges=function(o){if(o.name==="conditions"){this._handleConditionsUpdate(o);}if(o.name==="filterValue"){this._handleFilterValueUpdate(o);}if(o.name==="config"){_.call(this,o.current);}};
b.prototype._handleFilterValueUpdate=function(o){};
b.prototype._handleConditionsUpdate=function(o){};
b.prototype._createCondition=function(v,D,i,o){var e=d.call(this);var V=[v];if(e.valueTypes.length>1&&e.valueTypes[1]!==O.ValueType.Static&&D!==null&&D!==undefined){V.push(D);}return C.createCondition(e.name,V,i,o,a.Validated);};
b.prototype.removeFocus=function(){};
b.prototype.navigate=function(s){};
b.prototype.getUIArea=function(){var o=this.getParent();if(o&&o._getUIAreaForContent){return o._getUIAreaForContent();}return E.prototype.getUIArea.apply(this,arguments);};
b.prototype.isTypeahead=function(){var o=this.getParent();return o&&o.isTypeahead();};
b.prototype.isSearchSupported=function(){return false;};
b.prototype.provideScrolling=function(){var o=this.getParent();return!o||!o.providesScrolling();};
b.prototype.isContainerOpen=function(){var o=this.getParent();return o&&o.isOpen();};
b.prototype.isContainerOpening=function(){var o=this.getParent();return o&&o.isOpening();};
b.prototype._getValueHelpDelegate=function(){var o=this.getParent();return o&&o.getValueHelpDelegate();};
b.prototype._getValueHelpDelegatePayload=function(){var o=this.getParent();return o&&o.getValueHelpDelegatePayload();};
b.prototype._awaitValueHelpDelegate=function(){var o=this.getParent();return o&&o.awaitValueHelpDelegate();};
b.prototype._isValueHelpDelegateInitialized=function(){var o=this.getParent();return o&&o.isValueHelpDelegateInitialized();};
b.prototype.getCount=function(e){return 0;};
b.prototype.getValueHelpIcon=function(){};
b.prototype.getAriaAttributes=function(m){return{contentId:null,ariaHasPopup:"listbox",roleDescription:null};};
b.prototype._isSingleSelect=function(e){return this._getMaxConditions()===1;};
b.prototype.shouldOpenOnClick=function(){return false;};
b.prototype.shouldOpenOnNavigate=function(){return!this._isSingleSelect();};
b.prototype.isFocusInHelp=function(){return!this.isTypeahead();};
b.prototype.isMultiSelect=function(){return!this._isSingleSelect();};
b.prototype.getRequiresTokenizer=function(){return true;};
function _(o){c.call(this,o.operators);}
function c(o){this._oOperator=F.getEQOperator(o);}
function d(){return this._oOperator;}
b.prototype.getFormattedTitle=function(i){var t=this.getTitle();if(t){t=f(t,i?i:"");}return t;};
b.prototype.getFormattedShortTitle=function(){return this.getShortTitle();};
b.prototype._getMaxConditions=function(){var o=this.getConfig();return o&&o.maxConditions;};
P.call(b.prototype);return b;});
sap.ui.predefine('sap/ui/mdc/valuehelp/base/DialogTab',['sap/ui/core/Control'],function(C){"use strict";
var D=C.extend("sap.ui.mdc.valuehelp.base.DialogTab",{
metadata:{library:"sap.ui.mdc",properties:{content:{type:"object"}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enum.SelectType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},cancel:{}}},
renderer:{apiVersion:2,render:function(r,c){var o=c.getContent();if(o){r.renderControl(o);}}}
});
D.prototype.init=function(){C.prototype.init.apply(this,arguments);};
D.prototype.exit=function(){if(this._displayContent){this._displayContent=null;}return C.prototype.exit.apply(this,arguments);};
return D;});
sap.ui.predefine('sap/ui/mdc/valuehelp/base/FilterableListContent',['sap/ui/mdc/util/loadModules','sap/ui/mdc/valuehelp/base/ListContent','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterConverter','sap/ui/mdc/enum/ConditionValidated','sap/base/util/deepEqual','sap/ui/mdc/util/Common','sap/ui/model/base/ManagedObjectModel','sap/m/MessageToast'],function(l,L,C,F,a,d,b,M,c){"use strict";
var e=L.extend("sap.ui.mdc.valuehelp.base.FilterableListContent",{metadata:{library:"sap.ui.mdc",properties:{filterFields:{type:"string",defaultValue:""},keyPath:{type:"string",defaultValue:""},descriptionPath:{type:"string",defaultValue:""},inConditions:{type:"object",defaultValue:{},byValue:true},outParameterNames:{type:"string[]",defaultValue:[],byValue:true}},aggregations:{collectiveSearchItems:{type:"sap.ui.core.Item",multiple:true,singularName:"collectiveSearchItem"},filterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false},_defaultFilterBar:{type:"sap.ui.mdc.filterbar.FilterBarBase",multiple:false,visibility:"hidden"}},events:{}}});
e.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oObserver.observe(this,{aggregations:["_defaultFilterBar","filterBar"],properties:["inConditions"]});this.bindProperty("inConditions",{path:"/_inConditions",model:"$valueHelp"});this.bindProperty("outParameterNames",{path:"/_outParameters",model:"$valueHelp"});};
e.prototype._handleFilterValueUpdate=function(o){k.call(this,this._getPriorityFilterBar(),o.current);if(this.isContainerOpen()){this.applyFilters(o.current);}};
e.prototype.applyFilters=function(s){};
e.prototype._prettyPrintFilters=function(o){var r;if(!o){return"";}if(Array.isArray(o)){r="";o.forEach(function(o,i,m){r+=this._prettyPrintFilters(o);if(m.length-1!=i){r+=" or ";}},this);return"("+r+")";}else if(o._bMultiFilter){r="";var A=o.bAnd;o.aFilters.forEach(function(o,i,m){r+=this._prettyPrintFilters(o);if(m.length-1!=i){r+=A?" and ":" or ";}},this);return"("+r+")";}else{r=o.sPath+" "+o.sOperator+" '"+o.oValue1+"'";if(o.sOperator==="BT"){r+="...'"+o.oValue2+"'";}return r;}};
e.prototype._getItemFromContext=function(B,o){var K=(o&&o.keyPath)||this.getKeyPath();var D=(o&&o.descriptionPath)||this.getDescriptionPath();var v;var s;var p;if(!K){throw new Error("KeyPath missing");}var I=o&&o.inParameters||[];if(I.length===0){for(p in this.getProperty("inConditions")){I.push(p);}}var O=o&&o.outParameters||this.getProperty("outParameterNames");var m=I.length>0?{}:null;var n=O.length>0?{}:null;if(B){v=K?B.getProperty(K):undefined;s=D?B.getProperty(D):undefined;var i=0;for(i=0;i<I.length;i++){p=I[i];m[p]=B.getProperty(p);}for(i=0;i<O.length;i++){p=O[i];n[p]=B.getProperty(p);}}if(v===null||v===undefined){return false;}return{key:v,description:s,inParameters:m,outParameters:n};};
e.prototype._isItemSelected=function(I,m){var o=I&&I.getBindingContext();var n=this._getItemFromContext(o);for(var i=0;i<m.length;i++){var p=m[i];if(p.validated===a.Validated&&n.key===p.values[0]){if(p.inParameters&&n.inParameters&&!d(p.inParameters,n.inParameters)){continue;}if(p.outParameters&&n.outParameters&&!d(p.outParameters,n.outParameters)){continue;}return true;}}return false;};
e.prototype._createDefaultFilterBar=function(){return l(["sap/ui/mdc/filterbar/vh/FilterBar"]).then(function(m){var i=m[0];var o=new i(this.getId()+"-FB",{liveMode:false,showGoButton:false});this.setAggregation("_defaultFilterBar",o,true);return o;}.bind(this));};
e.prototype._assignCollectiveSearch=function(i){i=typeof i!=="undefined"?i:!this._oCollectiveSearchSelect;_.call(this,i).then(function(o){var m=this._getPriorityFilterBar();if(m.setCollectiveSearch){m.setCollectiveSearch(o);}}.bind(this));};
function _(i){return l(["sap/ui/mdc/filterbar/vh/CollectiveSearchSelect","sap/ui/core/Item"]).then(function(m){var n=m[0];var I=m[1];g.call(this,n,I);var o=this.getCollectiveSearchItems();if(o.length<=1){return null;}else{if(i){this._oCollectiveSearchSelect.setSelectedItemKey(o[0].getKey());}return this._oCollectiveSearchSelect;}}.bind(this));}
function f(E){var K=E.getParameter("key");c.show("ColSearch: "+K);this.fireRequestDelegateContent();}
function g(i,I){if(!this._oCollectiveSearchSelect){this._oObserver.observe(this,{properties:["filterFields"],aggregations:["collectiveSearchItems"]});this._oManagedObjectModel=new M(this);this.setModel(this._oManagedObjectModel,"$contenthelp");var o=new I(this.getId()+"-collSearchItem",{key:"{$contenthelp>key}",text:"{$contenthelp>text}",enabled:"{$contenthelp>enabled}",textDirection:"{$contenthelp>textDirection}"});this._oCollectiveSearchSelect=new i(this.getId()+"-collSearch",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$contenthelp>/collectiveSearchItems",template:o},select:f.bind(this)});}return this._oCollectiveSearchSelect;}
e.prototype.onShow=function(){L.prototype.onShow.apply(this,arguments);var o=this._getListBinding();var i=this._getListBindingInfo();var B=o&&o.isSuspended();var m=!o&&i&&i.suspended;if((B||m)&&!this.isTypeahead()){return;}this.applyFilters(this.getFilterValue());};
e.prototype._formatConditions=function(m){var I=this.getModel("$valueHelp").getProperty("/inParameters");var o=this.getModel("$valueHelp").getProperty("/outParameters");for(var i=0;i<m.length;i++){var n=m[i];if(n.inParameters){n.inParameters=h.call(this,n.inParameters,I);}if(n.outParameters){n.outParameters=h.call(this,n.outParameters,o);}}return m;};
function h(p,P){var H;if(P.length>0){for(var m in p){for(var i=0;i<P.length;i++){var o=P[i];var s=o.getHelpPath();var n=o.getFieldPath();if(n&&(n===m||n==="conditions/"+m)&&s){if(!H){H={};}H[s]=p[m];}}}}return H;}
e.prototype._getPriorityFilterBar=function(){return this.getFilterBar()||this.getAggregation("_defaultFilterBar");};
e.prototype._observeChanges=function(o){if(o.object==this){if(o.name==="collectiveSearchItems"){this._assignCollectiveSearch(true);}if(o.name==="inConditions"){j.call(this,this._getPriorityFilterBar(),o.current);}if(["_defaultFilterBar","filterBar"].indexOf(o.name)!==-1){var i=o.child;var E=i.getBasicSearchField();if(o.mutation==="insert"){var s=this.getFilterFields();if(!E&&s){return l(["sap/ui/mdc/FilterField"]).then(function(m){if(!i.bIsDestroyed){var n=m[0];var S=new n(this.getId()+"-search",{conditions:"{$filters>/conditions/"+s+"}",placeholder:"{$i18n>filterbar.SEARCH}",label:"{$i18n>filterbar.SEARCH}",maxConditions:1,width:"50%"});S._bCreatedByValueHelp=true;i.setBasicSearchField(S);}}.bind(this));}else if(E){E.setConditions([]);}this._assignCollectiveSearch();j.call(this,i,this.getProperty("inConditions"));k.call(this,i,this.getFilterValue());}else if(o.name==="filterBar"){if(E&&E._bCreatedByValueHelp){E.destroy();}this._createDefaultFilterBar();}}}L.prototype._observeChanges.apply(this,arguments);};
e.prototype.exit=function(){b.cleanup(this,["_oCollectiveSearchSelect","_oManagedObjectModel"]);L.prototype.exit.apply(this,arguments);};
e.prototype.getCollectiveSearchKey=function(){return this._oCollectiveSearchSelect&&this._oCollectiveSearchSelect.getSelectedItemKey();};
e.prototype._getFiltersForFilterBar=function(){var o=this._getPriorityFilterBar();var i=o.getConditions();var m=this._getTypesForConditions(i);var n=i&&m&&F.createFilters(i,m,undefined,this.getCaseSensitive());return n?[].concat(n):[];};
e.prototype._getListBinding=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.");};
e.prototype._getListBindingInfo=function(){throw new Error("FilterableListContent: Every filterable listcontent must implement this method.");};
e.prototype._getTypesForConditions=function(o){var m=this._getPriorityFilterBar();var I=this.getInParameters();var n;var s;if(m){n=F.createConditionTypesMapFromFilterBar(o,m);}else{n={};for(s in o){n[s]={type:null};}}for(s in n){if(!n[s].type){for(var i=0;i<I.length;i++){var p=I[i];if(p.getHelpPath()===s){n[s].type=p.getDataType();break;}}}}return n;};
function j(o,i){if(o){var m=o.getInternalConditions();for(var s in i){m[s]=i[s];}o.setInternalConditions(m);}}
function k(o,s){var i=this.getFilterFields();if(o&&i){var m=o.getInternalConditions();if(!m[i]||m[i].length!==1||m[i][0].values[0]!==s){var n=C.createCondition("Contains",[s],undefined,undefined,a.NotValidated);m[i]=[n];o.setInternalConditions(m);}}}
e.prototype.getFormattedTitle=function(i){var t=L.prototype.getFormattedTitle.apply(this,arguments);if(!t){t=this._oResourceBundle.getText(i?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",i);}return t;};
e.prototype.getFormattedShortTitle=function(){var s=this.getShortTitle();if(!s){s=this._oResourceBundle.getText("valuehelp.SELECTFROMLIST.Shorttitle");}return s;};
e.prototype.isSearchSupported=function(){var s=this.getFilterFields();var S=!!s;if(s==="$search"){var o=this._getListBinding();var D=this._getValueHelpDelegate();var i=this._getValueHelpDelegatePayload();S=D&&D.isSearchSupported(i,o);}return S;};
return e;});
sap.ui.predefine('sap/ui/mdc/valuehelp/base/ListContent',['sap/ui/mdc/valuehelp/base/Content','sap/ui/mdc/enum/ConditionValidated'],function(C,a){"use strict";
var L=C.extend("sap.ui.mdc.valuehelp.base.ListContent",{metadata:{library:"sap.ui.mdc",properties:{caseSensitive:{type:"boolean",defaultValue:false},useFirstMatch:{type:"boolean",group:"Behavior",defaultValue:true},useAsValueHelp:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{inParameters:{type:"sap.ui.mdc.field.InParameter",group:"Data",multiple:true},outParameters:{type:"sap.ui.mdc.field.OutParameter",group:"Data",multiple:true}},events:{}}});
L.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["caseSensitive"]});};
L.prototype._observeChanges=function(c){if(c.name==="caseSensitive"){this._handleFilterValueUpdate(c);}C.prototype._observeChanges.apply(this,arguments);};
L.prototype.getCount=function(c){var b=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true&&o.validated===a.Validated){b++;}}return b;};
return L;});
sap.ui.predefine('sap/ui/mdc/valuehelp/content/Bool',["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/util/loadModules","sap/ui/model/ParseException"],function(F,l,P){"use strict";
var B=F.extend("sap.ui.mdc.valuehelp.content.Bool",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent"]}});
B.prototype.init=function(){F.prototype.init.apply(this,arguments);this.setUseFirstMatch(true);this.setUseAsValueHelp(true);this.setFilterList(false);this.setCaseSensitive(false);this._oObserver.observe(this,{properties:["config"]});};
B.prototype.exit=function(){if(this._oModel){this._oModel.destroy();this._oModel=undefined;}F.prototype.exit.apply(this,arguments);};
B.prototype.getContent=function(){return this._retrievePromise("boolContent",function(){return l(["sap/ui/mdc/field/ListFieldHelpItem","sap/ui/model/json/JSONModel"]).then(function(m){var L=m[0];var J=m[1];this._oModel=new J({"type":"","items":[{"key":true,"text":"true"},{"key":false,"text":"false"}]});_.call(this,this.getConfig());var i=new L(this.getId()+"-Item",{key:{path:"$Bool>key"},text:{path:"$Bool>text"}});this.bindAggregation("items",{path:"$Bool>/items",template:i});this.setModel(this._oModel,"$Bool");return F.prototype.getContent.apply(this,arguments);}.bind(this));}.bind(this));};
B.prototype.getItemForValue=function(c){return Promise.resolve().then(function(){var g=this.getConfig();var t=g&&g.dataType;if(t){if(c.checkKey){if(c.parsedValue===true||c.parsedValue===false){return{key:c.parsedValue,description:t.formatValue(c.parsedValue,"string")};}else{c.checkDescription=true;}}if(c.checkDescription&&c.value){var T=t.formatValue(true,"string");if(T.toLowerCase().startsWith(c.value.toLowerCase())){return{key:true,description:T};}var f=t.formatValue(false,"string");if(f.toLowerCase().startsWith(c.value.toLowerCase())){return{key:false,description:f};}}var e=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[c.value]);var E=c.exception||P;throw new E(e);}else{throw new Error("Type missing");}}.bind(this));};
B.prototype.shouldOpenOnClick=function(){return false;};
B.prototype._observeChanges=function(c){if(c.type==="property"&&c.name==="config"){_.call(this,c.current);}F.prototype._observeChanges.apply(this,arguments);};
function _(c){if(this._oModel&&c){var t=c.dataType;var d=this._oModel.getData();if(t&&d["type"]!==t.getMetadata().getName()){d["type"]=t.getMetadata().getName();var I=d["items"];for(var i=0;i<I.length;i++){var o=I[i];o["text"]=t.formatValue(o["key"],"string");}this._oModel.checkUpdate(true);}}}
return B;});
sap.ui.predefine('sap/ui/mdc/valuehelp/content/Conditions',['sap/ui/mdc/valuehelp/base/Content','sap/ui/mdc/util/loadModules','sap/ui/mdc/enum/SelectType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/util/Common'],function(C,l,S,a,b){"use strict";
var c=C.extend("sap.ui.mdc.valuehelp.content.Conditions",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{label:{type:"string"}},aggregations:{},events:{}}});
c.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
c.prototype.exit=function(){b.cleanup(this,["_oScrollContainer","_oDefineConditionPanel"]);C.prototype.exit.apply(this,arguments);};
c.prototype.getContent=function(){return this._retrievePromise("content",function(){var m=["sap/ui/mdc/field/DefineConditionPanel","sap/ui/model/base/ManagedObjectModel"];if(this.provideScrolling()){m.push("sap/m/ScrollContainer");}return l(m).then(function(m){var D=m[0];var M=m[1];var f=m.length>2&&m[2];this._oManagedObjectModel=new M(this);this._oDefineConditionPanel=new D(this.getId()+"-DCP",{label:"{$help>/label}",conditions:"{$help>/conditions}",inputOK:"{$valueHelp>/_valid}",formatOptions:{path:"$help>/config",formatter:e},conditionProcessed:d.bind(this)}).setModel(this._oManagedObjectModel,"$help");if(f){this._oScrollContainer=new f(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true,content:[this._oDefineConditionPanel]});this.setAggregation("displayContent",this._oScrollContainer);return this._oScrollContainer;}else{this.setAggregation("displayContent",this._oDefineConditionPanel);return this._oDefineConditionPanel;}}.bind(this));}.bind(this));};
c.prototype.getCount=function(f){var g=0;for(var i=0;i<f.length;i++){var o=f[i];if(o.isEmpty!==true&&o.validated===a.NotValidated){g++;}}return g;};
c.prototype.getUseAsValueHelp=function(){return false;};
c.prototype.getValueHelpIcon=function(){return"sap-icon://value-help";};
c.prototype.isFocusInHelp=function(){return true;};
c.prototype.getRequiresTokenizer=function(){return false;};
c.prototype.getFormattedTitle=function(i){var t=C.prototype.getFormattedTitle.apply(this,arguments);if(!t){t=this._oResourceBundle.getText(i?"valuehelp.DEFINECONDITIONS":"valuehelp.DEFINECONDITIONSNONUMBER",i);}return t;};
c.prototype.getFormattedShortTitle=function(){var s=this.getShortTitle();if(!s){s=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONS.Shorttitle");}return s;};
c.prototype.getAriaAttributes=function(m){return{contentId:this.getId()+"-DCP",ariaHasPopup:"dialog",roleDescription:null};};
c.prototype.getContainerConfig=function(){return{'sap.ui.mdc.valuehelp.Popover':{showArrow:true,showHeader:true,getContentWidth:function(){return"500px";},getFooter:function(){return this._retrievePromise("footer",function(){return l(["sap/m/library","sap/m/Button"]).then(function(m){var M=m[0];var B=M.ButtonType;var f=m[1];var o=new f(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:B.Emphasized,press:_.bind(this)});var g=new f(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.fireCancel.bind(this)});return[o,g];}.bind(this));}.bind(this));}.bind(this)}};};
function _(E){this.fireConfirm({close:true});}
function d(E){var n=this.getConditions();if(this._getMaxConditions()===1){n=n.filter(function(o){return o.validated==="NotValidated";});}this.fireSelect({type:S.Set,conditions:n});}
function e(o){var f={};if(o){f.valueType=o.dataType;f.maxConditions=o.maxConditions;f.delegate=o.delegate;f.delegateName=o.delegateName;f.payload=o.payload;f.operators=o.operators;f.display=o.display;f.defaultOperatorName=o.defaultOperatorName;}return f;}
return c;});
sap.ui.predefine('sap/ui/mdc/valuehelp/content/FixedList',["sap/ui/mdc/valuehelp/base/ListContent","sap/ui/mdc/util/loadModules","sap/ui/mdc/enum/ConditionValidated","sap/ui/model/ParseException","sap/ui/mdc/enum/SelectType"],function(L,l,C,P,S){"use strict";
var F=L.extend("sap.ui.mdc.valuehelp.content.FixedList",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{groupable:{type:"boolean",group:"Appearance",defaultValue:false},filterList:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.field.ListFieldHelpItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{}}});
F.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");};
F.prototype.exit=function(){if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;}L.prototype.exit.apply(this,arguments);};
F.prototype.getContent=function(){return this._retrievePromise("content",function(){return l(["sap/m/List","sap/m/DisplayListItem","sap/m/library","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/base/ManagedObjectModel"]).then(function(m){var i=m[0];var D=m[1];var k=m[2];var n=m[3];var o=m[4];var M=m[5];this._oManagedObjectModel=new M(this);var I=new D(this.getId()+"-item",{type:k.ListType.Active,label:"{$help>text}",value:"{$help>additionalText}",valueTextDirection:"{$help>textDirection}"}).addStyleClass("sapMComboBoxNonInteractiveItem");var p=new n({path:"text",test:c.bind(this),caseSensitive:true});var s;if(this.getGroupable()){s=new o("groupKey",false,f.bind(this));}var q=new i(this.getId()+"-List",{width:"100%",showNoData:false,mode:k.ListMode.SingleSelectMaster,rememberSelections:false,items:{path:"$help>/items",template:I,filters:p,sorter:s,templateShareable:false},itemPress:a.bind(this)}).addStyleClass("sapMComboBoxBaseList").addStyleClass("sapMComboBoxList");q.setModel(this._oManagedObjectModel,"$help");this.setAggregation("displayContent",q,true);return q;}.bind(this));}.bind(this));};
function _(){return this.getAggregation("displayContent");}
function a(E){var i=E.getParameter("listItem");var s=i.getSelected();if(s){var o=h.call(this,i);var k=j.call(this,o);b.call(this,k,i.getLabel());this.fireSelect({type:S.Set,conditions:this.getConditions()});this.fireConfirm();}}
function b(k,v){var o=this._createCondition(k,v);this.setProperty("conditions",[o],true);return o;}
function c(t){var i=this.getFilterList();return!i||d.call(this,t,this.getFilterValue());}
function d(t,s){return!s||(typeof s==="string"&&(this.getCaseSensitive()?t.startsWith(s):t.toLowerCase().startsWith(s.toLowerCase())));}
function e(){var o=_.call(this);if(o){var B=o.getBinding("items");B.update();o.updateItems();o.invalidate();g.call(this);}}
function f(o){var k=o.getProperty('groupKey');var t=o.getProperty('groupText');return{key:k,text:t};}
function g(){var o=_.call(this);if(o){var k=this.getConditions();var s;var m=this.getFilterValue();var u=this.getUseFirstMatch();var n=false;if(k.length>0&&(k[0].validated===C.Validated||k[0].operator==="EQ")){s=k[0].values[0];}var I=o.getItems();for(var i=0;i<I.length;i++){var p=I[i];if(p.isA("sap.m.DisplayListItem")){var O=h.call(this,p);if(k.length>0&&j.call(this,O)===s){p.setSelected(true);}else if(k.length===0&&u&&m&&!n&&d.call(this,p.getLabel(),m)){p.setSelected(true);n=true;}else if(this.hasOwnProperty("_iNavigateIndex")&&i===this._iNavigateIndex){p.setSelected(true);}else{p.setSelected(false);}}}}}
function h(i){var p=i.getBindingContextPath();return this._oManagedObjectModel.getProperty(p);}
function j(i){var B=i.getBinding("key");if(B){return B.getInternalValue();}else{return i.getKey();}}
F.prototype.getItemForValue=function(o){return Promise.resolve().then(function(){if(o.value===null||o.value===undefined){return null;}else if(!o.value&&o.checkDescription){return null;}var I=this.getItems();var k;var i=0;var K;var t;for(i=0;i<I.length;i++){k=I[i];K=j.call(this,k);t=k.getText();if((o.checkKey&&K===o.parsedValue)||(o.checkDescription&&(t===o.value||K==o.value))){return{key:K,description:k.getText()};}}if(o.checkKey&&o.value===""){return null;}if(this.getUseFirstMatch()){for(i=0;i<I.length;i++){k=I[i];t=o.checkDescription?k.getText():k.getKey();if(d.call(this,t,o.value)){K=j.call(this,k);return{key:K,description:k.getText()};}}}var E=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[o.value]);var m=o.exception||P;throw new m(E);}.bind(this));};
F.prototype.isValidationSupported=function(o){return true;};
F.prototype.isSearchSupported=function(){return true;};
F.prototype._handleConditionsUpdate=function(o){g.call(this);};
F.prototype._handleFilterValueUpdate=function(o){e.call(this);};
F.prototype.removeFocus=function(){var o=_.call(this);if(o){o.removeStyleClass("sapMListFocus");}};
F.prototype.navigate=function(s){var o=_.call(this);if(!o){return;}o.addStyleClass("sapMListFocus");var k=o.getSelectedItem();var I=o.getItems();var m=I.length;var n=0;var p=this.getFilterList();var q=this.getFilterValue();var r=false;if(!p&&!k){var i=0;if(s>=0){for(i=0;i<I.length;i++){if(!I[i].isA("sap.m.GroupHeaderListItem")&&d.call(this,I[i].getLabel(),q)){n=i;break;}}}else{for(i=I.length-1;i>=0;i--){if(!I[i].isA("sap.m.GroupHeaderListItem")&&d.call(this,I[i].getLabel(),q)){n=i;break;}}}}else if(k){n=o.indexOfItem(k);n=n+s;}else if(s>=0){n=s-1;}else{n=m+s;}var t;if(n<0){n=0;t=true;r=true;}else if(n>=m-1){n=m-1;t=false;}else{t=s>=0;}while(I[n]&&I[n].isA("sap.m.GroupHeaderListItem")){if(t){n++;}else{n--;}}if(n<0||n>m-1){t=!t;r=n<0;n=n<0?0:m-1;while(I[n]&&I[n].isA("sap.m.GroupHeaderListItem")){if(t){n++;}else{n--;}}}var u=I[n];if(u){var U=this.getUseFirstMatch();if(u!==k||(U&&!r)){var O=h.call(this,u);var K=j.call(this,O);if(this.getParent().isOpen()){o.scrollToIndex(n);}else{this._iNavigateIndex=n;}u.setSelected(true);var v=b.call(this,K,u.getLabel());this.fireNavigated({condition:v,itemId:u.getId(),leaveFocus:false});}else if(r){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:r});}}};
F.prototype.onShow=function(){L.prototype.onShow.apply(this,arguments);var o=_.call(this);if(!o){return;}var s=o.getSelectedItem();if(s){var i=o.indexOfItem(s);o.scrollToIndex(i);}if(this.hasOwnProperty("_iNavigateIndex")){delete this._iNavigateIndex;}};
F.prototype.onHide=function(){this.removeFocus();};
F.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down";}else{return null;}};
F.prototype.getAriaAttributes=function(m){return{contentId:this.getId()+"-List",ariaHasPopup:"listbox",roleDescription:null};};
F.prototype.shouldOpenOnClick=function(){return!this.getFilterList();};
F.prototype.isFocusInHelp=function(){return false;};
F.prototype._isSingleSelect=function(E){return true;};
F.prototype.shouldOpenOnNavigate=function(){return!L.prototype._isSingleSelect.apply(this);};
return F;});
sap.ui.predefine('sap/ui/mdc/valuehelp/content/MDCTable',['sap/ui/mdc/valuehelp/base/FilterableListContent','sap/ui/mdc/util/loadModules','sap/base/util/deepEqual','sap/ui/mdc/enum/SelectType','sap/ui/mdc/library','sap/m/library',"sap/ui/table/library","sap/ui/mdc/p13n/Engine","sap/ui/mdc/enum/PersistenceMode"],function(F,l,d,S,a,L,u,E,P){"use strict";var b=L.ListMode;var c=L.Sticky;var M=a.SelectionMode;var U=u.VisibleRowCountMode;var e=u.SelectionMode;var f=u.SelectionBehavior;var _=function(t){var T,i=T=t&&t.getType();if(!i){T="Table";}else if(typeof i==="object"){if(i.isA("sap.ui.mdc.table.ResponsiveTableType")){T="ResponsiveTable";}else{T="Table";}}return T;};var g=function(){var t=this._getTable();var I=t&&t._oTable;var r=t.getRowBinding();var s=function(){return this._oUITableSelectionPlugin||I;}.bind(this);var v=function(i,x){var V=this._getItemFromContext(i.getBindingContext());var C=V&&this._createCondition(V.key,V.description,V.inParameters,V.outParameters);var A=x?S.Add:S.Remove;this.fireSelect({type:this._isSingleSelect()?S.Set:A,conditions:[C]});};var w={"ResponsiveTable":{getListBindingInfo:function(){return I&&I.getBindingInfo("items");},getItems:function(){return I.getItems();},getSelectedItems:function(){return I.getSelectedItems();},modifySelection:function(i,x){if(i.getSelected()!==x){i.setSelected(x);}},handleItemPress:function(i){var x=i.getParameter("listItem");if(!this.isTypeahead()||!this._isSingleSelect()){x.setSelected(!x.getSelected());}v.call(this,x,x.getSelected());},handleSelectionChange:function(i){if(!this.isTypeahead()||!this._isSingleSelect()){var x=i.getParameters();var y=x.listItems||x.listItem&&[x.listItem];var C=y.map(function(z){var V=this._getItemFromContext(z.getBindingContext());return V&&this._createCondition(V.key,V.description,V.inParameters,V.outParameters);}.bind(this));this.fireSelect({type:x.selected?S.Add:S.Remove,conditions:C});}},adjustTable:function(){var i=I.getSticky();if(!i||i.length===0){I.setSticky([c.ColumnHeaders]);}if(this._isSingleSelect()){I.setMode(b.SingleSelectLeft);}else{I.setMode(b.MultiSelect);}},handleScrolling:function(i){var x=this.getScrollDelegate();if(x){I.scrollToIndex(i).catch(function(y){});return true;}},handleListBinding:function(){}},"Table":{getListBindingInfo:function(){return I&&I.getBindingInfo("rows");},getItems:function(){return I.getRows().filter(function(R){var i=R.getBindingContext();return i&&i.getObject();});},getSelectedItems:function(){var i=s().getSelectedIndices();var x=i.reduce(function(R,C){var y=I.getContextByIndex(C);return y?R.concat(y):R;},[]);return w["Table"].getItems().filter(function(R){return x.indexOf(R.getBindingContext())>=0;});},modifySelection:function(i,x){var C=i.getBindingContext();var y=w["Table"].getContexts().indexOf(C);var z=s().getSelectedIndices().indexOf(y)>=0;if(x&&!z){return this._isSingleSelect()?s().setSelectedIndex(y):s().addSelectionInterval(y,y);}else if(!x&&z){return s().removeSelectionInterval(y,y);}},handleItemPress:function(i){},handleSelectionChange:function(x){if(this._bScrolling||this._bBusy){return;}var R=x.getParameter("rowIndices");var C=w["Table"].getContexts().filter(function(i,H){return R.indexOf(H)>=0;});var y=w["Table"].getItems().filter(function(i,H){return C.indexOf(i.getBindingContext())>=0;});var A=[],z=[];var B=w["Table"].getSelectedItems();var D=this.getConditions();y.forEach(function(H,i){var J=this._isItemSelected(H,D);var K=B.indexOf(H)!==-1;if(J!==K){var N=B.indexOf(H)!==-1?A:z;var V=this._getItemFromContext(H.getBindingContext());var O=V&&this._createCondition(V.key,V.description,V.inParameters,V.outParameters);N.push(O);}}.bind(this));var G=this._isSingleSelect();if(A.length){this.fireSelect({type:this._isSingleSelect()?S.Set:S.Add,conditions:A});if(G){return;}}if(z.length){this.fireSelect({type:this._isSingleSelect()?S.Set:S.Remove,conditions:z});}},adjustTable:function(){var R=I.getRowMode();if(!R){I.setVisibleRowCountMode(U.Auto);I.setMinAutoRowCount(3);}else if(R.isA("sap.ui.table.rowmodes.AutoRowMode")){R.setMinRowCount(3);}var i=this._isSingleSelect()?e.Single:e.MultiToggle;var x=this._isSingleSelect()?f.RowOnly:f.Row;I.setSelectionBehavior(x);s().setSelectionMode(i);},handleScrolling:function(i){var x=I.getFirstVisibleRow();if(typeof i==="undefined"||i<0){i=x-1;}if(i>=0&&i!=x){I.setFirstVisibleRow(i);return Promise.resolve();}return false;},getContexts:function(){return r&&(r.aContexts||(r.aIndices&&r.aIndices.map(function(i){return I.getContextByIndex(i);}))||r.getContexts());},handleListBinding:function(){r.attachEvent("change",this._handleUpdateFinished.bind(this));}}};return w[this._sTableType];};
function h(){if(this._oTableHelper){this._bSelectionIsUpdating=true;var i=this._oTableHelper.getItems();var C=this.getConditions();var r=[];for(var I in i){var s=i[I];var t=this._isItemSelected(s,C);r.push(this._oTableHelper.modifySelection.call(this,s,t));}Promise.all(r).then(function(){this._bSelectionIsUpdating=false;}.bind(this));}}
var j=F.extend("sap.ui.mdc.valuehelp.content.MDCTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContent"],properties:{},aggregations:{table:{type:"sap.ui.mdc.Table",multiple:false}},events:{},defaultAggregation:"table"}});
j.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._addPromise("listBinding");};
var k=function(){var i=this._getTable().getRowBinding();if(i){this._oTableHelper=g.call(this);this._oTableHelper.handleListBinding.call(this);q.call(this);this._resolvePromise("listBinding",i);}};var m=function(){if(this._oTable&&!this._oTable.getHeader()){this._oTable.setHeader(this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER"));}};
j.prototype._handleConditionsUpdate=function(){h.call(this);};
j.prototype._handleUpdateFinished=function(i){this._bScrolling=false;this._bSearchTriggered=false;h.call(this);};
j.prototype._handleFirstVisibleRowChanged=function(i){this._bScrolling=true;};
j.prototype._handleBusyStateChanged=function(i){this._bBusy=i.getParameter("busy");};
var n=function(i,s){if(!i){return;}if(s==="remove"){if(this._sTableType==="Table"){i.detachEvent("cellClick",this._handleItemPress,this);i.detachEvent("rowSelectionChange",this._handleSelectionChange,this);i.detachEvent("rowsUpdated",this._handleUpdateFinished,this);i.detachEvent("firstVisibleRowChanged",this._handleFirstVisibleRowChanged,this);i.detachEvent("busyStateChanged",this._handleBusyStateChanged,this);if(this._oUITableSelectionPlugin){this._oUITableSelectionPlugin.detachEvent("selectionChange",this._handleSelectionChange,this);}this._oUITableSelectionPlugin=undefined;}else if(this._sTableType==="ResponsiveTable"){i.detachEvent("itemPress",this._handleItemPress,this);i.detachEvent("selectionChange",this._handleSelectionChange,this);i.detachEvent("updateFinished",this._handleUpdateFinished,this);}this._oObserver.unobserve(i);}else{if(this._sTableType==="Table"){this._oObserver.observe(i,{bindings:["rows"],aggregations:["plugins"]});i.attachEvent("cellClick",this._handleItemPress,this);i.attachEvent("rowSelectionChange",this._handleSelectionChange,this);i.attachEvent("rowsUpdated",this._handleUpdateFinished,this);i.attachEvent("firstVisibleRowChanged",this._handleFirstVisibleRowChanged,this);i.attachEvent("busyStateChanged",this._handleBusyStateChanged,this);this._oUITableSelectionPlugin=i.getPlugins().find(function(r){return r.isA("sap.ui.table.plugins.SelectionPlugin");});if(this._oUITableSelectionPlugin){this._oUITableSelectionPlugin.attachEvent("selectionChange",this._handleSelectionChange,this);}}else if(this._sTableType==="ResponsiveTable"){this._oObserver.observe(i,{bindings:["items"]});i.attachEvent("itemPress",this._handleItemPress,this);i.attachEvent("selectionChange",this._handleSelectionChange,this);i.attachEvent("updateFinished",this._handleUpdateFinished,this);}}};var o=function(i){var s=this.getFilterFields();var r=i.getSource();var C=r.getInternalConditions();var t=s&&C[s]&&C[s][0];var v=t&&t.values[0];this.setFilterValue(v);};
j.prototype._observeChanges=function(C){var i,D;if(C.name==="_defaultFilterBar"){D=C.child;if(C.mutation==="insert"){i=this.getFilterBar();if(!i){D.attachSearch(o,this);}}else{D.detachSearch(o,this);}p.call(this);}if(C.name==="filterBar"){i=C.child;D=this.getAggregation("_defaultFilterBar");if(C.mutation==="insert"){if(D){D.detachSearch(o,this);}i.attachSearch(o,this);}else{if(D){D.attachSearch(o,this);}i.detachSearch(o,this);}p.call(this);}if(C.name==="table"){var t=C.child;if(C.mutation==="remove"){E.getInstance().defaultProviderRegistry.detach(t);this._oObserver.unobserve(t);this._oTable=null;this._oTableHelper=null;this._addPromise("listBinding");}else{this._oTable=t;E.getInstance().defaultProviderRegistry.attach(t,P.Transient);this._oObserver.observe(t,{aggregations:["_content"]});this._sTableType=_(t);t.addDelegate({onmouseover:function(r){var I=jQuery(r.target).control(0);if(I&&I.isA("sap.m.ColumnListItem")){I.setType("Active");}}});n.call(this,this._oTable._oTable,"insert");k.call(this);m.call(this);p.call(this);}return;}if(C.name==="_content"){n.call(this,C.child,C.mutation);return;}if(["rows","items"].indexOf(C.name)!==-1&&C.mutation==="ready"){k.call(this);return;}if(C.name==="config"){q.call(this);}if(C.name==="plugins"){this._oUITableSelectionPlugin=C.mutation==="remove"||!C.child.isA("sap.ui.table.plugins.SelectionPlugin")?undefined:C.child;if(this._oUITableSelectionPlugin){this._oUITableSelectionPlugin.attachEvent("selectionChange",this._handleSelectionChange,this);}}F.prototype._observeChanges.apply(this,arguments);};
j.prototype._getTable=function(){return this._oTable;};
function p(){var i=this._getPriorityFilterBar();if(this._oTable&&i&&this._oTable.getFilter()!==i.getId()){this._oTable.setFilter(i);}}
function q(){if(this._oTableHelper){this._oTableHelper.adjustTable.call(this);}}
j.prototype.getContent=function(){return this._retrievePromise("wrappedContent",function(){return l(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/ScrollContainer"]).then(function(i){var r=i[0];var V=i[1];var s=i[2];if(!this._oContentLayout){this._oFilterBarVBox=new V(this.getId()+"-FilterBarBox",{visible:"{$this>/_filterBarVisible}"});this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper._getPriorityFilterBar.call(this._oWrapper)];};this._oTableBox=new V(this.getId()+"-TB",{height:"100%"});this._oTableBox.addStyleClass("sapMdcValueHelpPanelTableBox");this._oTableBox._oWrapper=this;this._oTableBox.getItems=function(){return[this._oWrapper._sTableType==="ResponsiveTable"?this._oWrapper._oScrollContainer:this._oWrapper._oTable];};this._oContentLayout=new r(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTableBox});this._oScrollContainer=new s(this.getId()+"-SC",{height:"calc(100% - 0.5rem)",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){var C=[];var t=this._oWrapper&&this._oWrapper._oTable;if(t){C.push(t);}return C;};}this.setAggregation("displayContent",this._oContentLayout);if(!this._getPriorityFilterBar()){return this._createDefaultFilterBar().then(function(){return this._oContentLayout;}.bind(this));}return this._oContentLayout;}.bind(this));}.bind(this));};
j.prototype._getListBinding=function(){var t=this.getTable();return t&&t.getRowBinding();};
j.prototype._getListBindingInfo=function(){return this._oTableHelper&&this._oTableHelper.getListBindingInfo();};
j.prototype.onShow=function(){if(this._oTable){var s=F.prototype._isSingleSelect.apply(this)?M.Single:M.Multi;if(this._oTable.getSelectionMode()===M.None){this._oTable.setSelectionMode(s);}if(this._oTable.getSelectionMode()!==s){throw new Error("Table selectionMode needs to be "+s);}}F.prototype.onShow.apply(this,arguments);};
j.prototype.applyFilters=function(s){var t=this.getTable();var i=this._getPriorityFilterBar();if(t&&i){var r=this._getListBinding();var v=r&&r.isSuspended();if(r&&!v&&!this._bSearchTriggered){var w=i.getSearch()||"";var B=r.mParameters.$search||"";var x=this._getFiltersForFilterBar();var y=r.aApplicationFilters.reduce(function(R,C){return R.concat(C._bMultiFilter?C.aFilters:C);},[]);var z=!d(x,y);var A=w!==B;var T=t._oTable&&t._oTable.getShowOverlay&&t._oTable.getShowOverlay();if(z||A||T){this._handleScrolling();i.triggerSearch();this._bSearchTriggered=true;}}if(v){r.resume();}if(!r&&t.getAutoBindOnInit()){this._retrievePromise("listBinding").then(function(){this.applyFilters(s);}.bind(this));}}};
j.prototype._handleScrolling=function(i){return this._oTableHelper&&this._oTableHelper.handleScrolling.call(this,i);};
j.prototype.getScrollDelegate=function(){if(!this.isTypeahead()&&this._oScrollContainer){return this._oScrollContainer.getScrollDelegate();}return F.prototype.getScrollDelegate.apply(this,arguments);};
j.prototype._handleItemPress=function(i){this._oTableHelper.handleItemPress.call(this,i);};
j.prototype._handleSelectionChange=function(i){if(!this._bSelectionIsUpdating){this._oTableHelper.handleSelectionChange.call(this,i);}};
j.prototype.isQuickSelectSupported=function(){return true;};
j.prototype.setParent=function(i){F.prototype.setParent.apply(this,arguments);q.call(this);};
j.prototype._isSingleSelect=function(){if(this._oTable){if(this._oTable.getSelectionMode()===M.Multi){return false;}else{return true;}}else{return F.prototype._isSingleSelect.apply(this,arguments);}};
return j;});
sap.ui.predefine('sap/ui/mdc/valuehelp/content/MTable',['sap/ui/mdc/valuehelp/base/FilterableListContent','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterConverter','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/util/loadModules','sap/m/library','sap/ui/model/FilterType','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/mdc/util/Common','sap/base/strings/formatMessage','sap/base/util/merge','sap/ui/mdc/enum/SelectType','sap/base/Log'],function(F,C,a,b,l,c,d,e,f,g,h,k,m,S,L){"use strict";var n=c.ListMode;var o=c.Sticky;
var M=F.extend("sap.ui.mdc.valuehelp.content.MTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{},aggregations:{table:{type:"sap.m.Table",multiple:false}},events:{contentUpdated:{}},defaultAggregation:"table"}});
M.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._addPromise("listBinding");this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oMResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
M.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down";}else{return null;}};
function _(){if(this._oTable){var i=this._oTable.getItems();var j=this.getConditions();var H=this._isSingleSelect()&&!F.prototype._isSingleSelect.apply(this);for(var I in i){var u=i[I];var v=H?false:this._isItemSelected(u,j);u.setSelected(v);}}}
M.prototype.applyFilters=function(i){var j=this._getListBinding();var v=this._isValueHelpDelegateInitialized();if((!j||!v)&&(this.isContainerOpening()||this.isTypeahead())){Promise.all([this._retrievePromise("listBinding"),this._awaitValueHelpDelegate()]).then(function(){if(!this.bIsDestroyed){this.applyFilters(i);}}.bind(this));return;}if(!v||(!this.isTypeahead()&&!this.isContainerOpen()&&j.isSuspended())){return;}var D=this._getValueHelpDelegate();var u=this._getValueHelpDelegatePayload();var w=this.getFilterFields();var x=this._getPriorityFilterBar();var y=x?x.getInternalConditions():this.getProperty("inConditions");if(!x&&i&&w&&w!=="$search"){var z=C.createCondition("Contains",[i],undefined,undefined,b.NotValidated);y[w]=[z];}var A=y&&this._getTypesForConditions(y);var B=y&&a.createFilters(y,A,undefined,this.getCaseSensitive());var E=B&&[B];var G=this.isTypeahead()?i:x&&x.getSearch();var U=true;var H;try{H=j.getFilterInfo();}catch(I){L.info("ValueHelp-Filter: getFilterInfo threw error");}if(!E){E=[];}if(E.length===0&&!H){U=false;}if(w==="$search"&&D&&D.isSearchSupported(u,j)){if(!j.isSuspended()&&U){j.suspend();}G=D.adjustSearch(u,this.isTypeahead(),G);D.executeSearch(u,j,G);L.info("ValueHelp-Search: "+G);}if(U){j.filter(E,d.Application);L.info("ValueHelp-Filter: "+this._prettyPrintFilters.call(this,E));}if(j.isSuspended()){j.resume();}};
M.prototype._handleSelectionChange=function(E){var i=this.isTypeahead();if(!i||!this._isSingleSelect()){var P=E.getParameters();var j=P.listItems||P.listItem&&[P.listItem];var u=j.map(function(I){var v=this._getItemFromContext(I.getBindingContext());return v&&this._createCondition(v.key,v.description,v.inParameters,v.outParameters);}.bind(this));this.fireSelect({type:P.selected?S.Add:S.Remove,conditions:u});if(i){this.fireConfirm();}}};
M.prototype._handleItemPress=function(E){var i=E.getParameter("listItem");var v=this._getItemFromContext(i.getBindingContext());var I=this._isSingleSelect();var j=I?true:!i.getSelected();var u=S.Set;if(!I){i.setSelected(j);u=j?S.Add:S.Remove;}var w=this._createCondition(v.key,v.description,v.inParameters,v.outParameters);this.fireSelect({type:u,conditions:[w]});if(this.isTypeahead()){this.fireConfirm({close:true});}};
M.prototype._handleUpdateFinished=function(){_.apply(this);this.fireContentUpdated();};
M.prototype._getTable=function(){return this._oTable;};
M.prototype.onShow=function(){var T=this._getTable();if(T){if(!T.hasStyleClass("sapMComboBoxList")){T.addStyleClass("sapMComboBoxList");}var i=this.isTypeahead()?n.SingleSelectMaster:n.SingleSelectLeft;if(!F.prototype._isSingleSelect.apply(this)&&T.getMode()!==i){i=n.MultiSelect;}if(T.getMode()===n.None){T.setMode(i);}if(T.getMode()!==i){throw new Error("Table selection mode needs to be "+i);}}F.prototype.onShow.apply(this,arguments);};
M.prototype.onHide=function(){F.prototype.onHide.apply(this,arguments);var T=this.getTable();if(T){this.removeFocus();if(T.hasStyleClass("sapMComboBoxList")){T.removeStyleClass("sapMComboBoxList");}}};
M.prototype._handleConditionsUpdate=function(i){_.call(this);};
M.prototype.getContent=function(){if(!this.isTypeahead()){return this._retrievePromise("wrappedContent",function(){return l(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/Panel","sap/m/ScrollContainer","sap/ui/model/resource/ResourceModel"]).then(function(i){var j=i[0];var V=i[1];var P=i[2];var u=i[3];var R=i[4];if(!this._oContentLayout){this._oFilterBarVBox=new V(this.getId()+"-FilterBarBox");this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper._getPriorityFilterBar.call(this._oWrapper)];};this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");var v=function(T){var I=0;if(I===0){T=this.getModel("$i18n").getResourceBundle().getText("valuehelp.TABLETITLENONUMBER");}return k(T,I);};this._oTablePanel=new P(this.getId()+"-TablePanel",{expanded:true,height:"100%",headerText:{parts:['$i18n>valuehelp.TABLETITLE'],formatter:v}});this._oTablePanel.addStyleClass("sapMdcTablePanel");this._oContentLayout=new j(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTablePanel});this._oScrollContainer=new u(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){var x=[];var T=this._oWrapper&&this._oWrapper._oTable;if(T){x.push(T);}return x;};this._oTablePanel.addContent(this._oScrollContainer);}this.setAggregation("displayContent",this._oContentLayout);var w=this._getPriorityFilterBar();if(!w){return this._createDefaultFilterBar().then(function(){return this._oContentLayout;}.bind(this));}return this._oContentLayout;}.bind(this));}.bind(this));}return this._oTable;};
M.prototype.getItemForValue=function(i){if(!i.checkKey&&i.parsedValue&&!i.checkDescription){return null;}i.caseSensitive=i.caseSensitive||this.getCaseSensitive();return p.call(this).then(function(P){var R;if(!P){var T=this.getTable();R=q.call(this,i,T.getItems());}if(!R){R=this._loadItemForValue(i);}return R;}.bind(this));};
function p(){return this._retrievePromise("listBinding").then(function(i){var D=this._getValueHelpDelegate();var j=this._getValueHelpDelegatePayload();var u=this._getListBindingInfo();if(i&&D){return D.checkListBindingPending(j,i,u);}else{return true;}}.bind(this));}
function q(j,I){if(I.length===0){return;}var u=[];if(j.checkKey&&j.hasOwnProperty("parsedValue")){u.push({path:this.getKeyPath(),value:j.parsedValue});}if(j.checkDescription&&j.value){u.push({path:this.getDescriptionPath(),value:j.value});}var v=function(A,P){var B=A.isA("sap.ui.model.Context")?A:A.getBindingContext();return B.getProperty(P);};var w;var x=[];var y;var O;var i=0;for(i=0;i<u.length;i++){if(!u[i].path){throw new Error("path for filter missing");}x.push(new e({path:u[i].path,operator:f.EQ,value1:u[i].value,caseSensitive:j.caseSensitive}));}if(x.length===1){w=x[0];}else{w=new e({filters:x,and:false});}if(j.inParameters){x=[w];if(j.inParameters){x.push(j.inParameters);y=[];if(!j.inParameters.aFilters){y.push(j.inParameters.sPath);}else{for(i=0;i<j.inParameters.aFilters.length;i++){if(y.indexOf(j.inParameters.aFilters[i].sPath)<0){y.push(j.inParameters.aFilters[i].sPath);}}}}w=new e({filters:x,and:true});}var z=g.apply(I,w,v);if(z.length===1){var V=this._getItemFromContext(z[0].getBindingContext(),{inParameters:y,outParameters:O});return{key:V.key,description:V.description,inParameters:V.inParameters,outParameters:V.outParameters};}else if(z.length>1){if(!j.caseSensitive){var N=m({},j);N.caseSensitive=true;return q.call(this,N,I);}throw r.call(this,j.exception,true,u[0].value);}}
M.prototype._getListBinding=function(){var T=this._getTable();return T&&T.getBinding("items");};
M.prototype._getListBindingInfo=function(){var T=this._getTable();return T&&T.getBindingInfo("items");};
M.prototype._loadItemForValue=function(u){if(!u.checkKey&&u.parsedValue&&!u.checkDescription){return null;}var K=this.getKeyPath();var D=this.getDescriptionPath();var U=this.getUseFirstMatch();var v=u.caseSensitive;var T=this._getTable();var w=T&&T.getBinding("items");var B=w&&w.getContext();var x=w&&w.getModel();var P=w&&w.getPath();var y=this._getValueHelpDelegate();var z=this._getValueHelpDelegatePayload();var A=["loadItemForValue",P,K,u.parsedValue||u.value].join("_");return this._retrievePromise(A,function(){var E=[];if(u.checkKey&&u.hasOwnProperty("parsedValue")){E.push(new e({path:K,operator:f.EQ,value1:u.parsedValue,caseSensitive:v}));}if(u.checkDescription&&u.value){E.push(new e({path:D,operator:f.EQ,value1:u.value,caseSensitive:v}));}var G=E.length>1?new e({filters:E,and:false}):E[0];E=[G];var I;if(u.inParameters){E.push(u.inParameters);I=[];if(!u.inParameters.aFilters){I.push(u.inParameters.sPath);}else{for(var i=0;i<u.inParameters.aFilters.length;i++){var H=u.inParameters.aFilters[i];if(H.aFilters){for(var j=0;j<H.aFilters.length;j++){if(H.aFilters[j].sPath&&I.indexOf(H.aFilters[j].sPath)<0){I.push(H.aFilters[j].sPath);}}}else if(H.sPath&&I.indexOf(H.sPath)<0){I.push(H.sPath);}}}}G=E.length>1?new e({filters:E,and:true}):E[0];var J=x.bindList(P,B);return y.executeFilter(z,J,G,2).then(function(N){var O=N.getContexts();setTimeout(function(){J.destroy();},0);if(O.length&&(O.length<2||U)){return this._getItemFromContext(O[0],{keyPath:K,descriptionPath:D,inParameters:I});}else if(u.checkKey&&u.parsedValue===""&&O.length===0){return null;}else{var Q=r.call(this,u.exception,O.length>1,u.value);throw Q;}}.bind(this));}.bind(this));};
function r(E,N,v){var i;if(N){i=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[v]);}else{i=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[v]);}var j=new E(i);j._bNotUnique=N;return j;}
M.prototype.isValidationSupported=function(i){return true;};
M.prototype.navigate=function(i){var j=this._getListBinding();if(!j||!j.getLength()){return p.call(this).then(function(P){if(!P&&j.getLength()!==0){return this.navigate(i);}return false;}.bind(this));}var T=this._getTable();T.addStyleClass("sapMListFocus");var I=this._oTable.getItems();var u=T.getSelectedItem();var v=I.length;var w=0;var x=false;if(u){w=I.indexOf(u);w=w+i;}else if(i>=0){w=i-1;}else{w=v+i;}if(this._getMaxConditions()!==1){if(this.getParent().isOpen()){T.focus();return;}}var y;if(w<0){w=0;y=true;x=true;}else if(w>=v-1){w=v-1;y=false;}else{y=i>=0;}while(I[w]&&I[w].isA("sap.m.GroupHeaderListItem")){if(y){w++;}else{w--;}}if(w<0||w>v-1){y=!y;x=w<0;w=w<0?0:v-1;while(I[w]&&I[w].isA("sap.m.GroupHeaderListItem")){if(y){w++;}else{w--;}}}var z=I[w];if(z){var A;if(z!==u){z.setSelected(true);var V=this._getItemFromContext(z.getBindingContext());A=V&&this._createCondition(V.key,V.description,V.inParameters,V.outParameters);this.setProperty("conditions",[A],true);if(this._bVisible){this._handleScrolling(z);}this.fireNavigated({condition:A,itemId:z.getId(),leaveFocus:false});}else if(x){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:x});}}};
M.prototype._handleScrolling=function(i){var j=this.getScrollDelegate();if(j){var T=this._getTable();var I=!isNaN(i)?i:T.indexOfItem(i);T.scrollToIndex(I).catch(function(E){});return true;}return false;};
M.prototype.getScrollDelegate=function(){if(this._oScrollContainer){return this._oScrollContainer.getScrollDelegate();}return F.prototype.getScrollDelegate.apply(this,arguments);};
M.prototype.removeFocus=function(){var T=this.getTable();if(T){T.removeStyleClass("sapMListFocus");}};
M.prototype.getAriaAttributes=function(i){var T=this.getTable();return{contentId:T&&T.getId(),ariaHasPopup:"listbox",roleDescription:null};};
M.prototype.getContainerConfig=function(){return{'sap.ui.mdc.valuehelp.Popover':{getContentHeight:function(){var T=this._getTable();var D=T&&T.getDomRef();return D&&Math.round(D.getBoundingClientRect().height);}.bind(this),getFooter:function(){return this._retrievePromise("footer",function(){return this._retrievePromise("listBinding").then(function(i){var B=this._getListBindingInfo();if(B&&B.length){return l(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(function(j){var u=j[0];var T=j[1];var v=j[2];var w=new u(this.getId()+"-showAllItems",{text:this._oMResourceBundle.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){this.fireRequestSwitchToDialog();}.bind(this)});var x=[new v(this.getId()+"-Spacer")].concat(w);var y=new T(this.getId()+"-TB",{content:x});return y;}.bind(this));}}.bind(this));}.bind(this));}.bind(this)}};};
function s(){if(this._oTable&&this.getParent()){var i=this._oTable.getSticky();if(!i||i.length===0){this._oTable.setSticky([o.ColumnHeaders]);}}}
M.prototype.setParent=function(P){F.prototype.setParent.apply(this,arguments);s.call(this);};
var t=function(){return this.applyFilters(this.getFilterValue());};
M.prototype._observeChanges=function(i){var j,D;if(i.name==="_defaultFilterBar"){D=i.child;if(i.mutation==="insert"){j=this.getFilterBar();if(!j){D.attachSearch(t,this);}}else{D.detachSearch(t,this);}}if(i.name==="filterBar"){j=i.child;D=this.getAggregation("_defaultFilterBar");if(i.mutation==="insert"){if(D){D.detachSearch(t,this);}j.attachSearch(t,this);}else{if(D){D.attachSearch(t,this);}j.detachSearch(t,this);}}if(i.name==="config"){s.call(this);}if(i.name==="items"&&i.mutation==="ready"){this._resolvePromise("listBinding",i.bindingInfo.binding);}if(i.name==="table"){var T=i.child;if(i.mutation==="remove"){this._oObserver.unobserve(T);T.removeDelegate(this._oTableDelegate);this._oTable.detachItemPress(this._handleItemPress,this);this._oTable.detachSelectionChange(this._handleSelectionChange,this);this._oTable.detachUpdateFinished(this._handleUpdateFinished,this);this._oTable=null;this._removePromise("footer");this._addPromise("listBinding");}else{this._oTable=T;s.call(this);this._oTable.attachItemPress(this._handleItemPress,this);this._oTable.attachSelectionChange(this._handleSelectionChange,this);this._oTable.attachUpdateFinished(this._handleUpdateFinished,this);this._oTableDelegate=this._oTableDelegate||{onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};T.addDelegate(this._oTableDelegate,true,this);var u=T.getBinding("items");if(u){this._resolvePromise("listBinding",u);}else{this._oObserver.observe(i.child,{bindings:["items"]});}}}F.prototype._observeChanges.apply(this,arguments);};
M.prototype._handleTableEvent=function(E){if(!this.isTypeahead()){return;}var T=this._getTable();var i=jQuery(E.target).control(0);switch(E.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(T.indexOfItem(i)===0){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true});E.preventDefault();E.stopPropagation();E.stopImmediatePropagation(true);}}break;default:break;}};
M.prototype.isQuickSelectSupported=function(){return true;};
M.prototype.shouldOpenOnNavigate=function(){return true;};
M.prototype._isSingleSelect=function(){var T=this._getTable();if(T){if(T.getMode()===n.MultiSelect){return false;}else{return true;}}else{return F.prototype._isSingleSelect.apply(this,arguments);}};
M.prototype.exit=function(){h.cleanup(this,["_sTableWidth","_oTable","_oScrollContainer","_oContentLayout","_oTablePanel","_oFilterBarVBox","_oMResourceBundle","_oResourceBundle"]);F.prototype.exit.apply(this,arguments);};
return M;});
/*
 * !OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/chart/Item',["sap/ui/core/Element","sap/base/Log"],function(E,L){"use strict";
var I=E.extend("sap.ui.mdc.chart.Item",{metadata:{"abstract":false,library:"sap.ui.mdc",properties:{name:{type:"string"},label:{type:"string"},type:{type:"string",defaultValue:""},role:{type:"string"}}}});
return I;});
sap.ui.predefine('sap/ui/mdc/chart/SelectionDetailsActions',["sap/ui/core/Element"],function(E){"use strict";
var S=E.extend("sap.ui.mdc.chart.SelectionDetailsActions",{metadata:{library:"sap.ui.mdc",aggregations:{detailsItemActions:{type:"sap.ui.core.Item",multiple:true},detailsActions:{type:"sap.ui.core.Item",multiple:true},actionGroups:{type:"sap.ui.core.Item",multiple:true}}}});
return S;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/mdc/AggregationBaseDelegate',['sap/ui/mdc/BaseDelegate','sap/ui/core/library'],function(B,c){"use strict";var A=Object.assign(B,{fetchProperties:function(C){return Promise.resolve([]);},addItem:function(p,C,P){return Promise.resolve();},removeItem:function(i,C,p){return Promise.resolve(true);},validateState:function(C,s){var v=c.MessageType.None;return{validation:v,message:undefined};}});return A;});
sap.ui.predefine('sap/ui/mdc/BaseDelegate',['sap/ui/mdc/util/TypeUtil'],function(T){"use strict";var B={getTypeUtil:function(p){return T;}};return B;});
sap.ui.predefine('sap/ui/mdc/Chart',["sap/ui/core/Core","sap/ui/mdc/Control","./chart/ChartSettings","sap/ui/mdc/util/loadModules","./ChartRenderer","sap/ui/mdc/library","sap/m/Text","sap/m/VBox","sap/base/Log","./chart/ChartToolbar","./chart/PropertyHelper","sap/ui/mdc/mixin/FilterIntegrationMixin","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/p13n/subcontroller/ChartItemController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/chart/DrillBreadcrumbs","sap/ui/mdc/actiontoolbar/ActionToolbarAction"],function(C,a,b,l,c,M,T,V,L,d,P,F,f,g,S,h,B,A){"use strict";var D;
var i=a.extend("sap.ui.mdc.Chart",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/chart/Chart.designtime",interfaces:["sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate"}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string",defaultValue:"No data"},p13nMode:{type:"sap.ui.mdc.ChartP13nMode[]"},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"},showChartTooltip:{type:"boolean",group:"Misc",defaultValue:true},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},chartType:{type:"string",group:"Misc",defaultValue:"column"},showSelectionDetails:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"actions"}},_toolbar:{type:"sap.ui.mdc.chart.ChartToolbar",multiple:false,visibility:"hidden"},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},_innerChart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}},innerChartLoadedData:{parameters:{innerChart:{type:"sap.ui.core.Control"}}}}},
renderer:c
});
F.call(i.prototype);
i.prototype.init=function(){this._oManagedObjectModel=new f(this);this.setModel(this._oManagedObjectModel,"$mdcChart");this._bNewP13n=true;a.prototype.init.apply(this,arguments);};
i.prototype.setP13nMode=function(m){var s=null;if(m&&m.length>=1){s=[];var k=m.reduce(function(e,K,I){e[K]=true;return e;},{});if(k.Item){s.push("Item");}if(k.Sort){s.push("Sort");}if(k.Type){this._typeBtnActive=true;}else{this._typeBtnActive=false;}}else{s=m;}this.setProperty("p13nMode",s,true);this._updateAdaptation(this.getP13nMode());return this;};
i.prototype._updateAdaptation=function(m){var r={controller:{}};var R={Item:g,Sort:S};if(m&&m.length>0){m.forEach(function(s){var k=s;var o=R[s];if(o){r.controller[k]=o;}});this.getEngine().registerAdaptation(this,r);}};
i.prototype.applySettings=function(s,o){a.prototype.applySettings.apply(this,arguments);this.initializedPromise=new Promise(function(r,e){this._fnResolveInitialized=r;this._fnRejectInitialized=e;}.bind(this));this.innerChartBoundPromise=new Promise(function(r,e){this._fnResolveInnerChartBound=r;this._fnRejectInnerChartBound=e;}.bind(this));this._loadDelegate().then(function(e){this.initControlDelegate(e).then(function(){this._initInnerControls();}.bind(this)).catch(function(j){this._fnRejectInitialized(j);}.bind(this));}.bind(this)).catch(function(e){this._fnRejectInitialized(e);}.bind(this));};
i.prototype._initInnerControls=function(){this.getControlDelegate().initializeInnerChart(this).then(function(I){this.setBusyIndicatorDelay(0);this.getControlDelegate().createInitialChartContent(this);this._renderOverlay(true);if(this.getAutoBindOnInit()){this.setBusy(true);this._createContentfromPropertyInfos();}this.setAggregation("_innerChart",I);this._bInnerChartReady=true;this._fnResolveInitialized();this.invalidate();}.bind(this)).catch(function(e){this._fnRejectInitialized(e);}.bind(this));this._getToolbar().createToolbarContent(this);};
i.prototype._createContentfromPropertyInfos=function(){this.initPropertyHelper(P).then(function(){this.getControlDelegate().createInnerChartContent(this,this._innerChartDataLoadComplete.bind(this));this._createBreadcrumbs();this._oObserver=new h(this._propagateItemChangeToInnerChart.bind(this));this._oObserver.observe(this,{aggregations:["items"]});this._propagatePropertiesToInnerChart();this._fnResolveInnerChartBound();}.bind(this));};
i.prototype.setHeight=function(H){try{this.getControlDelegate().adjustChartHeight(this);}catch(e){}this.setProperty("height",H);return this;};
i.prototype._createBreadcrumbs=function(){this._oBreadcrumbs=new B(this.getId()+"--breadcrumbs");this._oBreadcrumbs.updateDrillBreadcrumbs(this,this.getControlDelegate().getDrillableItems(this));this.setAggregation("_breadcrumbs",this._oBreadcrumbs);this._oBreadcrumbs.addEventDelegate({onAfterRendering:function(){this.getControlDelegate().adjustChartHeight(this);}.bind(this)});};
i.prototype._loadDelegate=function(){return new Promise(function(r){var n=[this.getDelegate().name];function o(e){r(e);}sap.ui.require(n,o);}.bind(this));};
i.prototype.isFilteringEnabled=function(){};
i.prototype.getAdaptationUI=function(){return this.getControlDelegate().getAdaptionUI(this);};
i.prototype._propagateItemChangeToInnerChart=function(o){if(this._bIsDestroyed){return;}this.setBusy(true);switch(o.mutation){case"insert":var I;if(o.child&&o.child.getType()){I=this.getItems().filter(function(e){return e.getType()===o.child.getType();}).indexOf(o.child);}else{I=this.getItems().indexOf(o.child);}this.getControlDelegate().insertItemToInnerChart(this,o.child,I);break;case"remove":this.getControlDelegate().removeItemFromInnerChart(this,o.child);break;default:L.error("Unknown mutation on MDC Chart Item Aggregation. This will not sync to inner chart!");break;}this._rebind();this._oBreadcrumbs.updateDrillBreadcrumbs(this,this.getControlDelegate().getDrillableItems(this));};
i.prototype._rebind=function(){if(!this._bInnerChartReady){this.initialized().then(function(){this._rebind();}.bind(this));return;}this.setBusy(true);if(!this.getControlDelegate().getInnerChartBound(this)){this._createContentfromPropertyInfos();return;}var o=this.getControlDelegate()._getBindingInfo(this);if(o){o.sorter=this._getSorters();}this.getControlDelegate().updateBindingInfo(this,o);this.getControlDelegate().rebind(this,o);};
i.prototype._getToolbar=function(){if(this.getAggregation("_toolbar")){return this.getAggregation("_toolbar");}else{var t=new d(this.getId()+"--toolbar",{design:"Transparent"});this.setAggregation("_toolbar",t);return t;}};
i.prototype._updateToolbar=function(){if(this.getAggregation("_toolbar")){this.getAggregation("_toolbar").updateToolbar(this);}else{L.warning("Trying to uipdate Chart Toolbar, but toolbar is not yet initialized. This will not work!");}};
i.prototype._getInnerChart=function(){if(this._bInnerChartReady){return this.getControlDelegate().getInnerChart(this);}else{L.error("Trying to acces inner chart while inner chart is not yet initialized!");}};
i.prototype._addItems=function(){};
i.prototype.getCollectionModel=function(){var o=this.getBindingInfo("data");return o?this.getModel(o.model):null;};
i.prototype.initialized=function(){return this.initializedPromise;};
i.prototype.innerChartBound=function(){return this.innerChartBoundPromise;};
i.prototype.zoomIn=function(v){if(!v){v=10;}this.getControlDelegate().zoomIn(this,v);};
i.prototype.zoomOut=function(v){if(v){v=10;}this.getControlDelegate().zoomOut(this,v);};
i.prototype.getZoomState=function(){return this.getControlDelegate().getZoomState(this);};
i.prototype.getSelectionHandler=function(){return this.getControlDelegate().getInnerChartSelectionHandler(this);};
i.prototype.getChartTypeLayoutConfig=function(){return this.getControlDelegate().getChartTypeLayoutConfig();};
i.prototype.getAllowedRolesForKinds=function(){return this.getControlDelegate().getAllowedRolesForKinds();};
i.prototype.setLegendVisible=function(v){this.setProperty("legendVisible",v);try{this.getControlDelegate().setLegendVisible(this,v);}catch(e){L.info("Trying to set legend visiblity for Chart before delegate was initialized");}return this;};
i.prototype.setShowChartTooltip=function(v){this.setProperty("showChartTooltip",v);try{this.getControlDelegate().setChartTooltipVisibility(this,v);}catch(e){L.info("Trying to set tooltip visibility before delegate was initialized");}return this;};
i.prototype.destroy=function(){this._bIsDestroyed=true;a.prototype.destroy.apply(this,arguments);};
i.prototype._showDrillDown=function(o){if(D){D.createDrillDownPopover(this);return D.showDrillDownPopover(this,o);}return new Promise(function(r,e){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(j){D=j;D.createDrillDownPopover(this);D.showDrillDownPopover(this,o).then(function(k){r(k);});}.bind(this));}.bind(this));};
i.prototype._propagatePropertiesToInnerChart=function(){this.setLegendVisible(this.getLegendVisible());this.setShowChartTooltip(this.getShowChartTooltip());this.setChartType(this.getChartType());};
i.prototype.getChartTypeInfo=function(){var I;try{I=this.getControlDelegate().getChartTypeInfo(this);}catch(e){if(!I){I={icon:"sap-icon://vertical-bar-chart",text:"Selected Chart Type: Bar Chart"};}}return I;};
i.prototype.getAvailableChartTypes=function(){return this.getControlDelegate().getAvailableChartTypes(this);};
i.prototype.setChartType=function(s){this.setProperty("chartType",s);try{this.getControlDelegate().setChartType(this,s);}catch(e){L.info("Trying to set chart type for Chart before delegate was initialized");}return this;};
i.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel;};
i.prototype._innerChartDataLoadComplete=function(m){this.setBusy(false);this._renderOverlay(false);this.getControlDelegate().requestToolbarUpdate(this);this.fireEvent("innerChartLoadedData ",{innerChart:this.getControlDelegate().getInnerChart(this)});};
i.prototype.getCurrentState=function(){var s={};var p=this.getP13nMode();if(p){if(p.indexOf("Item")>-1){s.items=this._getVisibleProperties();}if(p.indexOf("Sort")>-1){s.sorters=this._getSortedProperties();}}return s;};
i.prototype._getVisibleProperties=function(){var p=[];this.getItems().forEach(function(I){p.push({name:I.getName(),role:I.getRole()});});return p;};
i.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[];};
i.prototype._getSorters=function(){var s;var e=this.getSortConditions()?this.getSortConditions().sorters:[];e.forEach(function(o){var m=this.getItems().find(function(p){return p.getName()===o.name;});if(!m){return;}var j=this.getControlDelegate().getSorterForItem(m,o);if(s){s.push(j);}else{s=[j];}}.bind(this));return s;};
i.prototype._getPropertyData=function(){if(!this.aFetchedProperties){this.aFetchedProperties=this.getControlDelegate().fetchProperties(this);}else{return this.aFetchedProperties;}};
i.prototype._getTypeBtnActive=function(){return!!this._typeBtnActive;};
i.prototype._onFiltersChanged=function(e){if(this._bInnerChartReady&&this.getControlDelegate()&&this.getControlDelegate().getInnerChartBound(this)&&e.getParameter("conditionsBased")){this._renderOverlay(true);}};
i.prototype._renderOverlay=function(s){if(this.getControlDelegate().getInnerChart(this)){var $=this.getControlDelegate().getInnerChart(this).$(),e=$.find(".sapUiMdcChartOverlay");if(s&&e.length===0){e=jQuery("<div>").addClass("sapUiOverlay sapUiMdcChartOverlay").css("z-index","1");$.append(e);}else if(!s){e.remove();}}};
i.prototype.addAction=function(o){if(o.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){o=new A(o.getId()+"-action",{action:o});}return a.prototype.addAggregation.apply(this,["actions",o]);};
return i;});
sap.ui.predefine('sap/ui/mdc/ChartRenderer',['./library'],function(l){"use strict";var C={apiVersion:2};C.CSS_CLASS="sapUiMDCChart";
C.render=function(r,m){r.openStart("div",m);r.attr("id",m.getId());r.class(C.CSS_CLASS);r.style("height",m.getHeight());r.style("width",m.getWidth());r.style("min-height",m.getMinHeight());r.style("min-width",m.getMinWidth());r.openEnd();this.renderToolbar(r,m.getAggregation("_toolbar"));this.renderBreadcrumbs(r,m.getAggregation("_breadcrumbs"));this.renderInnerStructure(r,m.getAggregation("_innerChart"));r.close("div");};
C.renderNoDataStruct=function(r,n){if(n){}};
C.renderToolbar=function(r,t){if(t){r.openStart("div");r.class("sapUiFixFlexFixed");r.openEnd();r.renderControl(t);r.close("div");}};
C.renderBreadcrumbs=function(r,d){if(d){r.renderControl(d);}};
C.renderInnerChart=function(r,i){if(i){r.renderControl(i);}};
C.renderInnerStructure=function(r,i){r.renderControl(i);};
return C;},true);
sap.ui.predefine('sap/ui/mdc/Control',["sap/ui/core/Control","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(C,D,A){"use strict";
var a=C.extend("sap.ui.mdc.Control",{
metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},
renderer:C.renderer
});
D.call(a.prototype);A.call(a.prototype);return a;});
sap.ui.predefine('sap/ui/mdc/Element',["sap/ui/core/Element","sap/ui/mdc/mixin/DelegateMixin","sap/ui/mdc/mixin/AdaptationMixin"],function(C,D,A){"use strict";
var E=C.extend("sap.ui.mdc.Element",{
metadata:{library:"sap.ui.mdc",properties:{delegate:{type:"object",group:"Data"}}},
renderer:C.renderer
});
D.call(E.prototype);A.call(E.prototype);return E;});
sap.ui.predefine('sap/ui/mdc/Field',['sap/ui/base/ManagedObjectObserver','sap/ui/mdc/field/FieldBase','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/base/util/deepEqual','sap/base/util/merge','sap/ui/model/BindingMode','sap/ui/model/Context'],function(M,F,a,b,C,c,B,d,e,m,f,g){"use strict";
var h=F.extend("sap.ui.mdc.Field",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/Field.designtime",properties:{value:{type:"any",defaultValue:null},additionalValue:{type:"any",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},promise:{type:"Promise"}}}},defaultProperty:"value"},
renderer:a
});
h.prototype.init=function(){this._vValue=null;this._vAdditionalValue=null;F.prototype.init.apply(this,arguments);this.setMaxConditions(1);this._oObserver.observe(this,{properties:["value","additionalValue"]});};
h.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;delete this._bPendingConditionUpdate;}this._oBindingContext=undefined;};
h.prototype.bindProperty=function(N,r){if(N==="value"&&!r.formatter){r.targetType="raw";var D=this._oContentFactory.getDataType();if(r.type&&(!D||D.getMetadata().getName()!==r.type.getMetadata().getName()||!e(D.getFormatOptions(),r.type.getFormatOptions())||!e(D.getConstraints(),r.type.getConstraints())||D._bCreatedByOperator!==r.type._bCreatedByOperator)){this._oContentFactory.setDataType(r.type);this._oContentFactory.updateConditionType();this.invalidate();}}F.prototype.bindProperty.apply(this,arguments);};
h.prototype._handleModelContextChange=function(E){F.prototype._handleModelContextChange.apply(this,arguments);var r=this.getBinding("value");if(r){var s=r.isA("sap.ui.model.CompositeBinding")?r.getBindings()[0].getContext():r.getContext();if(g.hasChanged(this._oBindingContext,s)){this._oBindingContext=s;this._oContentFactory.updateConditionType();if(this._bParseError||this.getFieldHelp()){this._oManagedObjectModel.checkUpdate(true,true);this._bParseError=false;}}if(!this._oContentFactory.getDataType()){this._oContentFactory.setDataType(r.getType());this.invalidate();}}};
h.prototype._initDataType=function(){F.prototype._initDataType.apply(this,arguments);var r=this.getBinding("value");if(r){this._oContentFactory.setDataType(r.getType());}};
h.prototype.setProperty=function(P,v,s){if(P==="value"&&this._bParseError&&e(this.getValue(),this.validateProperty(P,v))){this._oManagedObjectModel.checkUpdate(true,true);this._bParseError=false;}return F.prototype.setProperty.apply(this,arguments);};
h.prototype.setMaxConditions=function(r){if(r!==1){throw new Error("Only one condition allowed for Field "+this);}return this.setProperty("maxConditions",r,true);};
h.prototype._observeChanges=function(r){F.prototype._observeChanges.apply(this,arguments);if(r.name==="value"){var v=l.call(this,r.current,r.old);if(this._vAdditionalValue!==null&&q.call(this)&&!n.call(this,v,this._vValue,true)){this._vAdditionalValue=this.getAdditionalValue();}this._vValue=v;o.call(this,r.current);j.call(this);}if(r.name==="additionalValue"){this._vAdditionalValue=r.current;j.call(this);}if(r.name==="conditions"){if(this._getContent().length<=1){p.call(this,r.current);}}};
function _(){return this._vValue;}
function i(){return this._vAdditionalValue;}
function j(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){j.call(this);}}.bind(this));return;}if(this.getDisplay()===b.Value){k.call(this,_.call(this),i.call(this));}else if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){k.call(this,_.call(this),i.call(this));this._iConditionUpdateTimer=undefined;this._bPendingConditionUpdate=false;}.bind(this),0);this._bPendingConditionUpdate=true;}}
function k(v,A){var r=this.getConditions();if(this._checkValueInitial(v)&&!A){if(r.length>0){this.setConditions([]);}}else{var O=r[0]&&r[0].values[0];var s=r[0]&&r[0].values[1]?r[0].values[1]:null;if(!r[0]||r[0].operator!=="EQ"||!n.call(this,O,v)||s!==A){var t=C.createItemCondition(v,A);t.validated=d.Validated;this.setConditions([t]);}}}
function l(v,O){var D=this._oContentFactory.getDataType()?this._oContentFactory.getDataType().getMetadata().getName():this.getDataType();if(v&&O&&(D==="sap.ui.model.odata.type.Unit"||D==="sap.ui.model.odata.type.Currency")&&!v[2]&&O[2]!==undefined){v=m([],v);v[2]=O[2];if(this._bPendingChange){var r=this.getConditions()[0];if(r){if(v[0]===O[0]&&v[0]!==r.values[0][0]){v[0]=r.values[0][0];}if(v[1]===O[1]&&v[1]!==r.values[0][1]){v[1]=r.values[0][1];}}}}return v;}
function n(v,V,u){var E=v===V;var D=this._oContentFactory.getDataType()?this._oContentFactory.getDataType().getMetadata().getName():this.getDataType();if(!E&&this.getTypeUtil().getBaseType(D)===B.Unit&&Array.isArray(v)&&Array.isArray(V)){var N=v[0];var U=v[1];var r=v.length>=3?v[2]:null;var s=V[0];var t=V[1];var w=V.length>=3?V[2]:null;if(N===s&&U===t&&(((this._bUnitSet||u)&&(!r||!w))||e(r,w))){E=true;}if((r||w)&&!u){this._bUnitSet=true;}}return E;}
function o(v){if(!this._bTypeInitialized){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){o.call(this,v);}}.bind(this));return;}var r=this.getBinding("value");var D=r?r.getType():this._oContentFactory.getDataType();this._oTypeInitialization=this.getControlDelegate().initializeTypeFromBinding(this.getPayload(),D,v);this._bTypeInitialized=this._oTypeInitialization.bTypeInitialized;if(this._bTypeInitialized&&this._oContentFactory.getUnitOriginalType()){this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oContentFactory.getDataType(),this._oTypeInitialization);this.getControlDelegate().initializeInternalUnitType(this.getPayload(),this._oContentFactory.getUnitType(),this._oTypeInitialization);}}}
h.prototype._fireChange=function(r,v,w,P){var V;if(r){if(v){V=this._getResultForPromise(r);}else{V=w;}}if(this._getContent().length>1){if(r){p.call(this,this.getConditions());}else if(P){P=P.then(function(R){p.call(this,this.getConditions());return R;}.bind(this));}}this.fireChange({value:V,valid:v,promise:P});};
h.prototype._getResultForPromise=function(r){var v;if(r.length===0&&this._oContentFactory.getDataType()){v=this._oContentFactory.getDataType().parseValue("","string",[]);}else if(r.length===1){v=r[0].values[0];}return v;};
function p(r){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){p.call(this,r);}}.bind(this));return;}var v=null;var A=null;var O=this.getValue();var s=this.getAdditionalValue();if(r.length===0&&O===null&&s===null){return;}v=this._getResultForPromise(r);if(r.length===0&&!s){A=s;}else if(r.length===1&&r[0].values.length>1){A=r[0].values[1];}this._vValue=v;this._vAdditionalValue=A;if(!n.call(this,v,O,true)){this.setProperty("value",v,true);}if(A!==s&&!q.call(this)){this.setProperty("additionalValue",A,true);}}
h.prototype._getOperators=function(){return["EQ"];};
function q(){var r=this.getBinding("additionalValue");if(r&&r.getBindingMode()===f.OneWay){return true;}return false;}
return h;});
sap.ui.predefine('sap/ui/mdc/FilterField',['sap/ui/mdc/field/FieldBase','sap/ui/mdc/field/FieldBaseRenderer','sap/base/util/merge','sap/base/util/deepEqual'],function(F,a,m,d){"use strict";
var b=F.extend("sap.ui.mdc.FilterField",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/FilterField.designtime",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]},defaultOperator:{type:"string",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},
renderer:a
});
b.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["value","operators"]});};
b.prototype.exit=function(){F.prototype.exit.apply(this,arguments);};
b.prototype.setProperty=function(p,v,s){if(p==="conditions"&&this._bParseError&&d(this.getConditions(),this.validateProperty(p,v))){if(this._oContentFactory.getBoundProperty()){this._oManagedObjectModel.checkUpdate(true,true);}else{var c=this._getContent()[0];if(c&&c.setValue){c.setValue();}this._removeUIMessage();}this._bParseError=false;}return F.prototype.setProperty.apply(this,arguments);};
b.prototype._observeChanges=function(c){F.prototype._observeChanges.apply(this,arguments);if(c.name==="operators"){this._updateInternalContent();}};
b.prototype._fireChange=function(c,v,w,p){var V;if(c){if(v){if(c.length==1){V=c[0].values[0];}}else{V=w;}}this.fireChange({value:V,valid:v,conditions:m([],c),promise:p});};
b.prototype._getOperators=function(){var o=this.getOperators();if(o.length===0){o=F.prototype._getOperators.apply(this,arguments);}return o;};
b.prototype.setOperators=function(o){var O=[];if(!Array.isArray(o)){o=o.split(",");}o.forEach(function(c){if(typeof c==="string"){O.push(c);}else{O.push(c.name);}});this.setProperty("operators",O);return this;};
b.prototype.addOperator=function(o){var O=this._getOperators();var s=o;if(typeof o!=="string"){s=o.name;}if(O.indexOf(s)<0){O.push(s);this.setOperators(O);}return this;};
b.prototype.addOperators=function(o){if(!Array.isArray(o)){o=[o];}o.forEach(function(O){this.addOperator(O);}.bind(this));return this;};
b.prototype.removeOperator=function(o){var O=this.getOperators();var s=o;if(typeof o!=="string"){s=o.name;}if(O.indexOf(s)>-1){O.splice(O.indexOf(s),1);this.setOperators(O);}};
b.prototype.removeOperators=function(o){if(!Array.isArray(o)){o=[o];}o.forEach(function(O){this.removeOperator(O);}.bind(this));};
b.prototype.removeAllOperators=function(){this.setOperators([]);};
b.prototype.setDefaultOperator=function(o){var n=o;if(o&&typeof o!=="string"){n=o.name;}this.setProperty("defaultOperator",n);return this;};
return b;});
sap.ui.predefine('sap/ui/mdc/MultiValueField',['sap/ui/mdc/library','sap/ui/mdc/field/FieldBase','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated'],function(l,F,a,C,b){"use strict";
var c=F.extend("sap.ui.mdc.MultiValueField",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/MultiValueField.designtime",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/MultiValueFieldDelegate",payload:{}}}},aggregations:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem",multiple:true,singularName:"item"}},defaultAggregation:"items",events:{change:{parameters:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem[]"},valid:{type:"boolean"},promise:{type:"Promise"}}}}},
renderer:a
});
c.prototype.init=function(){F.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["items"]});};
c.prototype.exit=function(){F.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer;}};
c.prototype.bindAggregation=function(n,B){if(n==="items"&&!B.formatter){_.call(this,B);}F.prototype.bindAggregation.apply(this,arguments);};
function _(B){if(B.template&&B.template.mBindingInfos.key){var k=B.template.mBindingInfos.key;if(k.type&&(!this._oDataType||this._oDataType.getMetadata().getName()!==k.type.getMetadata().getName())){this._oContentFactory.setDataType(k.type);this.invalidate();}}}
c.prototype._handleModelContextChange=function(E){F.prototype._handleModelContextChange.apply(this,arguments);if(!this._oDataType){var B=this.getBinding("items");if(B){_.call(this,B);}}};
c.prototype._initDataType=function(){F.prototype._initDataType.apply(this,arguments);var B=this.getBindingInfo("items");if(B){_.call(this,B);}};
c.prototype.setMaxConditions=function(m){if(m===1){throw new Error("Multiple Conditions needed on MultiValueField "+this);}return this.setProperty("maxConditions",m,true);};
c.prototype._observeChanges=function(o){F.prototype._observeChanges.apply(this,arguments);if(o.name==="items"){d.call(this,o.child,o.mutation);}if(o.name==="key"){f.call(this);}if(o.name==="description"){f.call(this);}if(o.name==="conditions"){e.call(this,o.current);}};
function d(i,m){if(m==="insert"){this._oObserver.observe(i,{properties:true});}else{this._oObserver.unobserve(i);}if(!this._bMyItemUpdate){f.call(this);}}
function e(h){if(this._bConditionsUpdateFromItems){return;}if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){e.call(this.getConditions());}}.bind(this));return;}this.getControlDelegate().updateItems(this.getPayload(),h,this);}
function f(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){if(!this.bIsDestroyed){f.call(this);}}.bind(this));return;}if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(function(){g.call(this);this._iConditionUpdateTimer=undefined;}.bind(this),0);}}
function g(){var I=this.getItems();var h=[];for(var i=0;i<I.length;i++){var o=I[i];var j=C.createItemCondition(o.getKey(),o.getDescription());j.validated=b.Validated;h.push(j);}this._bConditionsUpdateFromItems=true;this.setConditions(h);this._bConditionsUpdateFromItems=false;}
c.prototype._fireChange=function(h,v,w,p){this.fireChange({items:this.getItems(),valid:v,promise:p});};
c.prototype._getResultForPromise=function(h){return this.getItems();};
c.prototype._getOperators=function(){return["EQ"];};
return c;});
sap.ui.predefine('sap/ui/mdc/actiontoolbar/ActionToolbarActionRenderer',[],function(){"use strict";var A={apiVersion:2};
A.render=function(r,a){var m={role:"form"};r.openStart("div",a);r.accessibilityState(a,m);r.openEnd();r.renderControl(a.getAction());r.close("div");};
return A;},true);
sap.ui.predefine('sap/ui/mdc/chart/ChartSelectionDetails',["sap/ui/core/Core","sap/ui/mdc/library","sap/m/SelectionDetails","sap/m/SelectionDetailsItem","sap/m/SelectionDetailsItemLine","sap/m/SelectionDetailsRenderer","./SelectionDetailsActions"],function(C,a,S,b,c,d,e){"use strict";
var f=S.extend("sap.ui.mdc.chart.ChartSelectionDetails",{
metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{},aggregations:{},associations:{},events:{}},
renderer:d
});
f.prototype.init=function(){S.prototype.init.apply(this,arguments);this._registerTemplate();this._attachEvents();};
f.prototype._registerTemplate=function(){this.registerSelectionDetailsItemFactory([],function(D,g,o,h){var l=[];for(var i=0;i<D.length;i++){l.push(new c({label:D[i].label,value:this._formatValue(D[i].value),unit:D[i].unit}));}return new b({enableNav:this._hasNavigationTargets(g),lines:l}).setBindingContext(o);}.bind(this));};
f.prototype._formatValue=function(v){if(v){return v instanceof Object?v:v.toString();}else{return v;}};
f.prototype._hasNavigationTargets=function(D){return false;};
f.prototype._attachEvents=function(){this.attachActionPress(function(E){var m=this.getParent().getParent();var i=[];E.getParameter("items").forEach(function(I){i.push(I.getBindingContext());});m.fireSelectionDetailsActionPressed({id:E.getParameter("id"),action:E.getParameter("action"),itemContexts:i,level:E.getParameter("level")});});};
return f;});
sap.ui.predefine('sap/ui/mdc/chart/ChartToolbar',["sap/ui/core/Core","sap/ui/mdc/library","sap/ui/mdc/ActionToolbar","sap/m/OverflowToolbarRenderer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/m/Title","sap/ui/mdc/library","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/ChartSettings","./ChartSelectionDetails"],function(C,a,A,O,b,c,T,M,d,e,f){"use strict";
var g=A.extend("sap.ui.mdc.chart.ChartToolbar",{
metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{},aggregations:{},associations:{},events:{}},
renderer:O
});
var h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");
g.prototype.init=function(){A.prototype.init.apply(this,arguments);};
g.prototype.createToolbarContent=function(m){this.setEnabled(false);var t=new T(m.getId()+"-title",{text:m.getHeader()});this.addBegin(t);this._oChartSelectionDetails=new f(m.getId()+"-selectionDetails",{});this._oChartSelectionDetails.attachBeforeOpen(function(E){this._updateSelectionDetailsActions(m);}.bind(this));this.addEnd(this._oChartSelectionDetails);var p=m.getP13nMode()||[];if(p.indexOf("Item")>-1&&(!m.getIgnoreToolbarActions().length||m.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.DrillDownUp)<0)){this._oDrillDownBtn=new b(m.getId()+"-drillDown",{icon:"sap-icon://drill-down",tooltip:h.getText("chart.CHART_DRILLDOWN_TITLE"),text:h.getText("chart.CHART_DRILLDOWN_TITLE"),press:function(E){m._showDrillDown(this._oDrillDownBtn);}.bind(this)});this.addEnd(this._oDrillDownBtn);}if(!m.getIgnoreToolbarActions().length||m.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.Legend)<0){this._oLegendBtn=new c(m.getId()+"btnLegend",{type:"Transparent",text:h.getText("chart.LEGENDBTN_TEXT"),tooltip:h.getText("chart.LEGENDBTN_TOOLTIP"),icon:"sap-icon://legend",pressed:"{$mdcChart>/legendVisible}"});this.addEnd(this._oLegendBtn);}if(!m.getIgnoreToolbarActions().length||m.getIgnoreToolbarActions().indexOf(M.ChartToolbarActionType.ZoomInOut)){this.oZoomInButton=new b(m.getId()+"btnZoomIn",{icon:"sap-icon://zoom-in",tooltip:h.getText("chart.TOOLBAR_ZOOM_IN"),text:h.getText("chart.TOOLBAR_ZOOM_IN"),press:function i(o){m.zoomIn();this.toggleZoomButtons(m);}.bind(this)});this.oZoomOutButton=new b(m.getId()+"btnZoomOut",{icon:"sap-icon://zoom-out",tooltip:h.getText("chart.TOOLBAR_ZOOM_OUT"),text:h.getText("chart.TOOLBAR_ZOOM_OUT"),press:function i(o){m.zoomOut();this.toggleZoomButtons(m);}.bind(this)});this.addEnd(this.oZoomInButton);this.addEnd(this.oZoomOutButton);}if(p.indexOf("Sort")>-1||p.indexOf("Item")>-1){this._oSettingsBtn=new b(m.getId()+"-chart_settings",{icon:"sap-icon://action-settings",tooltip:h.getText('chart.PERSONALIZATION_DIALOG_TITLE'),text:h.getText('chart.PERSONALIZATION_DIALOG_TITLE'),press:function(E){m.getEngine().uimanager.show(m,m.getP13nMode());}});this.addEnd(this._oSettingsBtn);}if(m._getTypeBtnActive()){this._oChartTypeBtn=new d(m);this.addEnd(this._oChartTypeBtn);}};
g.prototype.toggleZoomButtons=function(m){var z=this._getZoomEnablement(m);if(z.enabled){this.oZoomInButton.setEnabled(z.enabledZoomIn);this.oZoomOutButton.setEnabled(z.enabledZoomOut);}else{this.oZoomInButton.setEnabled(false);this.oZoomOutButton.setEnabled(false);}};
g.prototype.updateToolbar=function(m){this.toggleZoomButtons(m);if(!this._toolbarInitialUpdated){this.setEnabled(true);this._toolbarInitialUpdated=true;}var s=m.getSelectionHandler();if(s){this._oChartSelectionDetails.attachSelectionHandler(s.eventId,s.listener);}};
g.prototype._getZoomEnablement=function(m){var z;try{z=m.getZoomState();}catch(i){z={enabled:false};}if(z&&z.hasOwnProperty("currentZoomLevel")&&z.currentZoomLevel!=null&&z.enabled){var t={enabled:true};t.enabledZoomOut=z.currentZoomLevel>0;t.enabledZoomIn=z.currentZoomLevel<1;return t;}else{return{enabled:false};}};
g.prototype._updateSelectionDetailsActions=function(m){var s=m.getSelectionDetailsActions(),o;if(s){var S=this._oChartSelectionDetails.getItems();S.forEach(function(I){var j=s.getDetailsItemActions();j.forEach(function(k){o=k.clone();I.addAction(o);});});var D=s.getDetailsActions();this._oChartSelectionDetails.removeAllActions();D.forEach(function(j){o=j.clone();this._oChartSelectionDetails.addAction(o);}.bind(this));var i=s.getActionGroups();this._oChartSelectionDetails.removeAllActionGroups();i.forEach(function(j){o=j.clone();this._oChartSelectionDetails.addActionGroup(o);}.bind(this));}};
return g;});
sap.ui.predefine('sap/ui/mdc/chart/DrillBreadcrumbs',["sap/m/Breadcrumbs","sap/m/Link"],function(B,L){"use strict";
var D=B.extend("sap/m/Breadcrumbs",{});
D.prototype.init=function(){B.prototype.init.apply(this,arguments);};
D.prototype.updateDrillBreadcrumbs=function(m,d){var n=[];if(d){d.reverse();if(d.length>0){d.forEach(function(b,e,f){this.setVisible(true);var s=b.getLabel();var g=b.getName();if(e==0){this.setCurrentLocationText(s);}else{var C={dimensionKey:g,dimensionText:s};var o=this._createCrumb(m,C);n.push(o);}},this);}else{this.setVisible(false);}}var c=this.getLinks();n.reverse();var a=false;if(c.length!==n.length){a=true;}else{for(var i=0;i<n.length;i++){if(n[i].getText()!=c[i].getText()){a=true;break;}}}if(a){if(this.getLinks()){this.destroyLinks();}for(var i=0;i<n.length;i++){this.addLink(n[i]);}}return this;};
D.prototype._createCrumb=function(m,c){var C=new L({text:c.dimensionText,press:function b(o){var l=this.indexOfLink(o.getSource());var a=m.getControlDelegate().getDrillableItems(m),d=a.slice(l+1);var f=d.map(function(e){return{name:e.getName(),visible:false};});m.getEngine().createChanges({control:m,key:"Item",state:f});}.bind(this)});C.data("key",c.dimensionKey);return C;};
return D;});
sap.ui.predefine('sap/ui/mdc/chart/DrillStackHandler',["sap/ui/core/Core","sap/m/ResponsivePopover","sap/m/List","sap/m/Bar","sap/m/StandardListItem","sap/ui/core/InvisibleText","sap/m/library","sap/ui/Device","sap/base/Log"],function(C,R,L,B,S,I,M,D,a){"use strict";var P=M.PlacementType;var b=M.ListType;var c=M.ListMode;
function _(m){var e=m.getControlDelegate().getDrillStack(m);var s=[];e.forEach(function(o){o.dimension.forEach(function(f){if(f!=null&&f!=""&&s.indexOf(f)==-1){s.push(f);}});});return s;}
var d=function(){};
d.createDrillDownPopover=function(m){var s=new B();var p=new R({id:m.getId()+"-drilldownPopover",contentWidth:"25rem",contentHeight:"20rem",placement:P.Bottom,subHeader:s});var l=new L({mode:c.SingleSelectMaster,selectionChange:function(o){var e=o.getParameter("listItem");if(e){m.getEngine().createChanges({control:m,key:"Item",state:[{name:e.data("dim").name,position:m.getItems().length}]});}p.close();}});p.attachAfterClose(function(){p.destroy();});var r=C.getLibraryResourceBundle("sap.ui.mdc");if(D.system.desktop){var i=new I({text:r.getText("chart.CHART_DRILLDOWN_TITLE")});p.setShowHeader(false);p.addContent(i);p.addAriaLabelledBy(i);}else{p.setTitle(r.getText("chart.CHART_DRILLDOWN_TITLE"));}p.addContent(l);m._oDrillDownPopover=p;return p;};
d.showDrillDownPopover=function(m,o){var p=m.getControlDelegate().getSortedDimensions(m);return p.then(function(s){var e=m._oDrillDownPopover;var f,g,l;var F=e.getContent().filter(function(E){return E.getMetadata().getClass()==L;});var h=F.length>0?F[0]:null;if(!h){a.error("MDC Chart: Could not determine list to show drilldown. This should not happen. Did the application modify the drill-down popover?");return;}h.destroyItems();f=_(m);for(var i=0;i<s.length;i++){g=s[i];if(f.indexOf(g.name)>-1){continue;}l=new S({title:g.label,type:b.Active});l.data("dim",g);h.addItem(l);}return new Promise(function(r,j){e.attachEventOnce("afterOpen",function n(k){r(e);});e.openBy(o);});});};
return d;});
sap.ui.predefine('sap/ui/mdc/condition/Condition',['sap/base/Log','sap/ui/mdc/enum/ConditionValidated'],function(L,C){"use strict";var a={createItemCondition:function(k,d,i,o){var v=C.NotValidated;var V=[k,d];if(d===null||d===undefined){V.pop();}else{v=C.Validated;}return this.createCondition("EQ",V,i,o,v);},createCondition:function(o,v,i,O,V){var c={operator:o,values:v,isEmpty:null,validated:V};if(i){c.inParameters=i;}if(O){c.outParameters=O;}return c;},_removeEmptyConditions:function(c){for(var i=c.length-1;i>-1;i--){if(c[i].isEmpty){c.splice(parseInt(i),1);}}return c;},_removeInitialFlags:function(c){for(var i=c.length-1;i>-1;i--){if(c[i].isInitial){delete c[i].isInitial;}}return c;}};return a;},true);
sap.ui.predefine('sap/ui/mdc/condition/ConditionConverter',['sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/util/DateUtil','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/base/util/merge'],function(C,B,a,D,F,O,m){"use strict";var d="yyyy-MM-ddTHH:mm:ssZ";var s="yyyy-MM-dd";var t="HH:mm:ss";var b={toString:function(o,T,h){var i=F.getOperator(o.operator);var v=c(o.values,_(o,h,T,i)||T,i);var I;var j;if(o.inParameters){I=m({},o.inParameters);}if(o.outParameters){j=m({},o.outParameters);}var r=C.createCondition(o.operator,v,I,j,o.validated);return r;},toType:function(o,T,h){var i=F.getOperator(o.operator);var v=f(o.values,_(o,h,T,i)||T);var I;var j;if(o.inParameters){I=m({},o.inParameters);}if(o.outParameters){j=m({},o.outParameters);}var r=C.createCondition(o.operator,v,I,j,o.validated);if(r.validated!==a.Validated&&i.validateInput){i.checkValidated(r);}return r;}};
function _(o,T,h,i){if(i&&i.valueTypes[0]&&(i.valueTypes[0]!==O.ValueType.Self&&i.valueTypes[0]!==O.ValueType.Static)){return T.getTypeConfig(i._createLocalType(i.valueTypes[0],h&&h.typeInstance));}}
function c(v,T,o){var r=[];for(var i=0;i<v.length;i++){if(!o||(o.valueTypes[i]&&o.valueTypes[i]!==O.ValueType.Static)){var V=v[i];r.push(e(V,T));}}return r;}
function e(v,T){var h=T.baseType;var o=T.typeInstance;switch(h){case B.DateTime:return D.typeToString(v,o,d);case B.Date:return D.typeToString(v,o,s);case B.Time:return D.typeToString(v,o,t);case B.Boolean:return v;case B.Numeric:if(typeof v!=="string"&&(o.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||o.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return v.toString();}return v;default:return o.formatValue(v,"string");}}
function f(v,T){var r=[];for(var i=0;i<v.length;i++){var V=v[i];r.push(g(V,T));}return r;}
function g(v,T){var h=T.baseType;var o=T.typeInstance;switch(h){case B.DateTime:return D.stringToType(v,o,d);case B.Date:return D.stringToType(v,o,s);case B.Time:return D.stringToType(v,o,t);case B.Boolean:return v;case B.Numeric:if(typeof v!=="string"&&(o.getMetadata().getName()==="sap.ui.model.odata.type.Int64"||o.getMetadata().getName()==="sap.ui.model.odata.type.Decimal")){return v.toString();}return v;default:return o.parseValue(v,"string");}}
return b;},true);
sap.ui.predefine('sap/ui/mdc/condition/ConditionModel',['sap/ui/mdc/condition/ConditionModelPropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/model/ChangeReason','sap/ui/mdc/condition/FilterOperatorUtil','sap/base/util/merge','sap/base/util/deepEqual','sap/base/Log','sap/ui/mdc/condition/Condition',"sap/ui/mdc/condition/FilterConverter"],function(C,J,F,b,c,m,d,L,e,f){"use strict";
var g=J.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){J.apply(this,arguments);this.setSizeLimit(1000);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{});}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{});}}});
g.prototype.bindProperty=function(p,o,P){var E=p;if(p.startsWith("/conditions/")){var s=p.slice(12);this._getFieldPathProperty(s);s=h.call(this,s);E="/conditions/"+s;}var B=new C(this,E,o,P);B._sOriginapPath=p;return B;};
g.prototype.getContext=function(p){if(p.startsWith("/conditions/")){var s=p.slice(12);s=h.call(this,s);p="/conditions/"+s;}return J.prototype.getContext.apply(this,[p]);};
g.prototype.bindList=function(p,o,s,a,P){var B=J.prototype.bindList.apply(this,arguments);B.enableExtendedChangeDetection(true);return B;};
g.prototype.destroy=function(){J.prototype.destroy.apply(this,arguments);};
g.prototype.clone=function(s){var o=new g();o._sName=this._sName+"_clone";var a={};if(typeof s==="string"){var j=this.getConditions(s);for(var i=0;i<j.length;i++){var k=j[i];var M=h.call(this,s);if(!a[M]){a[M]=[];}a[M].push(m({},k));}}else{a=m({},this.getAllConditions());}o.setConditions(a);return o;};
g.prototype.merge=function(s,S,a){this.removeAllConditions(s);var o=m({},S.getAllConditions());for(var M in o){if(!(typeof a==="string")||M===a){var j=e._removeEmptyConditions(o[M]);for(var i=0;i<j.length;i++){var k=j[i];this.addCondition(M,k);}}}this.checkUpdate(true,true);};
g.prototype.getConditions=function(s){return _.call(this,s);};
function _(s,a){var o=this.getProperty("/conditions");var i;if(typeof s=="string"){s=h.call(this,s);if(!o[s]&&a){o[s]=[];}i=o[s]||[];}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!");}return i;}
g.prototype.getAllConditions=function(v){var o=this.getProperty("/conditions");var r={};for(var M in o){var a=this.getProperty("/fieldPath");var i=a[M];var s=i?i.fieldPath:M;if(v&&[].concat(v).indexOf(s)===-1){continue;}r[s]=m([],o[M]);}return r;};
g.prototype.indexOf=function(s,o,n){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var a=this.getConditions(s);var A=n?[n(o),a.map(n)]:[o,a];var i=c.indexOfCondition.apply(c,A);return i;};
g.prototype.exist=function(o,s){if(typeof s==="string"){return this.indexOf(s,o)>=0;}else{throw new Error("sFieldPath must be provided "+this);}};
g.prototype.setConditions=function(o){var i=0;var a;this.setProperty("/conditions",{},undefined,true);if(Array.isArray(o)){throw new Error("setConditions with an Array of condition is not supported! "+this);}else{this._bNoSingleEvent=true;for(var M in o){this._getFieldPathProperty(M);for(i=0;i<o[M].length;i++){a=o[M][i];this.insertCondition(M,-1,a,true);}this.firePropertyChange({reason:b.Add,path:"/conditions/"+M,context:undefined,value:o[M]});}this.checkUpdate(true,true);this._bNoSingleEvent=false;}return this;};
g.prototype.addCondition=function(s,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}return this.insertCondition(s,-1,o,a);};
g.prototype.insertCondition=function(s,I,o,a){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}if(!o){return this;}var j;c.checkConditionsEmpty(o);c.updateConditionsValues(o);this._getFieldPathProperty(s);if(!a){var i=this.indexOf(s,o);if(i>=0){return this;}}j=_.call(this,s,true);if(I==-1){j.push(o);}else{j.splice(I,0,o);}if(!this._bNoSingleEvent){this.checkUpdate(true,true);this.firePropertyChange({reason:b.Add,path:"/conditions/"+s,context:undefined,value:j});}return this;};
g.prototype.createItemCondition=function(s,k,D){L.error("ConditionModel","createItemCondition is deprecated");return e.createItemCondition(k,D);};
g.prototype.createCondition=function(s,o,v){L.error("ConditionModel","createCondition is deprecated");return e.createCondition(o,v);};
g.prototype.removeCondition=function(s,v){if(typeof s!=="string"){throw new Error("sFieldPath must be a string "+this);}var i=-1;if(typeof v==="object"){i=this.indexOf(s,v);}else if(typeof v==="number"){i=v;}if(i>=0){var a=this.getConditions(s);if(a.length>i){a.splice(i,1);this.checkUpdate(true,true);this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:a});return true;}}return false;};
g.prototype.removeAllConditions=function(s){var o=this.getProperty("/conditions");if(typeof s==="string"){var E=h.call(this,s);if(o[E]&&o[E].length>0){o[E]=[];this.firePropertyChange({reason:b.Remove,path:"/conditions/"+s,context:undefined,value:o[s]});}}else{for(var M in o){if(o[M]&&o[M].length>0){o[M]=[];var a=this.getProperty("/fieldPath");var O=a[M].fieldPath;this.firePropertyChange({reason:b.Remove,path:"/conditions/"+O,context:undefined,value:o[M]});}}}this.checkUpdate(true,true);return this;};
g.prototype._getFieldPathProperty=function(s){var E=h.call(this,s);var o=this.getProperty("/fieldPath");if(!o[E]){o[E]={fieldPath:s};}var a=this.getProperty("/conditions");if(!a[E]){a[E]=[];}return o[E];};
g.prototype.getFilters=function(s){L.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return f.createFilters(this.getAllConditions(),{});};
g.prototype.serialize=function(){var o=m({},this.getAllConditions());for(var M in o){var a=o[M];a.forEach(function(i){delete i.isEmpty;},this);if(a.length===0){delete o[M];}}return'{"conditions":'+JSON.stringify(o)+"}";};
g.prototype.parse=function(o){var i=function(k,v){var a;if(!isNaN(parseInt(k))&&(typeof v==='string')){a=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(v);if(a){return new Date(v);}}return v;};this.setConditions(JSON.parse(o,i).conditions);};
function h(s){if(s){var p=s.split("/");if(p.length>1){s="";for(var i=0;i<p.length;i++){var P=p[i];if(i>0){if(!isNaN(P)||!isNaN(p[i-1])){s=s+"/";}else{s=s+"\\";}}s=s+P;}}}return s;}
return g;});
sap.ui.predefine('sap/ui/mdc/condition/ConditionModelPropertyBinding',['sap/ui/model/ChangeReason','sap/ui/model/json/JSONPropertyBinding','sap/base/util/merge','sap/base/util/deepEqual'],function(C,J,m,d){"use strict";
var a=J.extend("sap.ui.mdc.condition.ConditionModelPropertyBinding",{constructor:function(M,p,c,P){J.apply(this,arguments);this.oValue=_.call(this,this._getValue());}});
a.prototype.getValue=function(){return _.call(this,this.oValue);};
a.prototype.setValue=function(v){if(this.bSuspended){return;}if(!d(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=_.call(this,v);this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this._sOriginapPath,context:this.oContext,value:v});}}};
a.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!d(v,this.oValue)||f){this.oValue=_.call(this,v);this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
function _(v){var c;if(!v){c=v;}else if(Array.isArray(v)){c=m([],v);}else if(v instanceof Date){c=new Date(v);}else if(typeof v==="object"){c=m({},v);}else{c=v;}return c;}
return a;});
sap.ui.predefine('sap/ui/mdc/condition/FilterConverter',["sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/Log"],function(F,a,b,L){"use strict";var c={createConditionTypesMapFromFilterBar:function(C,f){var r={};for(var s in C){if(f){var p=f._getPropertyByName(s);var d;if(p&&p.typeConfig){d=p.typeConfig.typeInstance;}else{var o=f._getFilterField(s);if(o){var e=o._getFormatOptions();if(e.originalDateType){d=e.originalDateType;}else{d=e.valueType;}}}r[s]={type:d};}}return r;},createFilters:function(C,o,f,d){var i,l,e,O=[],g,h,n,k,A;var m=function(h,v,P){var V="L1";var S,N,w;if(h.sPath&&h.sPath.indexOf(P)>-1){S=h.sPath.split(P);if(S.length===2){N=S[0];w=S[1];h.sPath=V+"/"+w;return{path:N,operator:v,variable:V};}else{throw new Error("FilterConverter: not supported binding "+h.sPath);}}return false;};var p=function(h){var v=m(h,b.Any,"*/");if(v){return v;}else{return m(h,b.All,"+/");}};for(var s in C){l=[];e=[];A=null;var q=C[s];if(s==="$search"){continue;}var D;var r=true;if(o){if(o[s]){D=o[s].type;r=o[s].caseSensitive;if(!D){L.warning("FilterConverter","Not able to retrieve the type of path '"+s+"!");}}}for(i=0;i<q.length;i++){k=q[i];g=F.getOperator(k.operator);if(!g){continue;}try{h=g.getModelFilter(k,s,D,r);}catch(t){L.error("FilterConverter","Not able to convert the condition for path '"+s+"' into a filter! The type is missing!");continue;}if(f){h=f(k,s,D,h);if(!h){continue;}}if(!g.exclude){if(h.sPath==="$search"){continue;}var $=/^\*(.+)\*$/.exec(h.sPath);if($){var u=$[1].split(',');for(var j=0;j<u.length;j++){l.push(new a({path:u[j],operator:h.sOperator,value1:h.oValue1,caseSensitive:d}));}continue;}A=p(h);l.push(h);}else{A=p(h);e.push(h);}}h=undefined;if(l.length===1){h=l[0];}else if(l.length>1){h=new a({filters:l,and:false});}if(h){e.unshift(h);}n=undefined;if(e.length===1){n=e[0];}else if(e.length>1){n=new a({filters:e,and:true});}if(A){A.condition=n;n=new a(A);}if(n){O.push(n);}}if(O.length===1){h=O[0];}else if(O.length>1){h=new a({filters:O,and:true});}else{h=null;}L.info("FilterConverter",c.prettyPrintFilters(h));return h;},prettyPrintFilters:function(f){var r;if(!f){return"no filters set";}if(f._bMultiFilter){r="";var A=f.bAnd;f.aFilters.forEach(function(f,i,d){r+=c.prettyPrintFilters(f);if(d.length-1!=i){r+=A?" and ":" or ";}},this);return"("+r+")";}else{if(f.sOperator===b.Any||f.sOperator===b.All){r=f.sPath+" "+f.sOperator+" "+c.prettyPrintFilters(f.oCondition);}else{if(f.bCaseSensitive===false){r="tolower("+f.sPath+") "+f.sOperator+" tolower('"+f.oValue1+"')";}else{r=f.sPath+" "+f.sOperator+" '"+f.oValue1+"'";}if([b.BT,b.NB].indexOf(f.sOperator)>=0){r+="...'"+f.oValue2+"'";}}return r;}}};return c;},true);
sap.ui.predefine('sap/ui/mdc/condition/FilterOperatorUtil',['sap/ui/model/FilterOperator','sap/ui/model/Filter','sap/ui/model/ValidateException','sap/base/Log','sap/base/util/merge','sap/ui/mdc/enum/FieldDisplay','./Operator','./RangeOperator','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/core/date/UniversalDate','sap/ui/core/date/UniversalDateUtils','sap/ui/core/format/DateFormat','sap/ui/model/json/JSONModel','sap/ui/model/type/Integer'],function(M,F,V,L,m,a,O,R,B,C,U,b,D,J,I){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var c={_mOperators:{equal:new O({name:"EQ",alias:"DATE",filterOperator:M.EQ,tokenParse:"^=([^=].*)$",tokenFormat:"{1} ({0})",valueTypes:[O.ValueType.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(f,t,s,h){s=s||a.DescriptionValue;var g=this.valueTypes.length;var v=f.values;var T=(f&&f.validated===C.Validated)||v.length===2||h?"":"=";var j=T+this.displayFormats[s];if(!v[1]){j=T+this.displayFormats["Value"];g=1;}for(var i=0;i<g;i++){var r,k=v[i];if(k===null||k===undefined){k="";}if(i==0&&t&&(typeof t.formatValue==="function")){r=t.formatValue(k,"string");}else{r=k;}j=r==null?null:j.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}return j;},parse:function(t,T,s,f){s=s||a.DescriptionValue;var r=O.prototype.parse.apply(this,[t,T,s,f]);if(f&&(!r||r[0]===null||r[0]===undefined)&&s!==a.Value){s=a.Value;r=O.prototype.parse.apply(this,[t,T,s,f]);}if(r&&(r[1]===null||r[1]===undefined)&&s===a.Value){r=[r[0]];}return r;},getValues:function(t,s,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){var h;var T=this.displayFormats[s];var k=T.indexOf("{0}");var i=T.indexOf("{1}");var K;var j;if(g){h=g[1];}else if(f){h=t;}if(k>=0&&i>=0){if(h.lastIndexOf("(")>0&&(h.lastIndexOf(")")===h.length-1||h.lastIndexOf(")")===-1)){var E=h.length;if(h[E-1]===")"){E--;}var l=h.substring(0,h.lastIndexOf("("));if(l[l.length-1]===" "){l=l.substring(0,l.length-1);}var n=h.substring(h.lastIndexOf("(")+1,E);if(k<i){K=l;j=n;}else{K=n;j=l;}}else if(k<i){K=h;}else{j=h;}}else if(k>=0){K=h;}else{j=h;}v=[K];if(i>=0){v.push(j);}}return v;},isEmpty:function(f,t){var i=false;var v=f.values[0];if((v===null||v===undefined||v==="")&&!f.values[1]){i=true;}return i;},getCheckValue:function(f){return{value:f.values[0]};},checkValidated:function(f){if(f.values.length===2&&f.values[0]!==undefined&&f.values[1]!==null&&f.values[1]!==undefined){f.validated=C.Validated;}else{f.validated=C.NotValidated;}},validateInput:true}),between:new O({name:"BT",alias:"DATERANGE",filterOperator:M.BT,tokenParse:"^([^!].*)\\.\\.\\.(.+)$",tokenFormat:"{0}...{1}",valueTypes:[O.ValueType.Self,O.ValueType.Self],validate:function(v,t){if(v.length===2){if(d(v[0])&&d(v[1])){return;}else if((d(v[0])||d(v[1]))){throw new V(o.getText("operator.between.validate.missingValue"));}else if(v[0]===v[1]){throw new V(o.getText("operator.between.validate.sameValues"));}}O.prototype.validate.apply(this,[v,t]);}}),notBetween:new O({name:"NOTBT",filterOperator:M.NB,tokenParse:"^!(.+)\\.\\.\\.(.+)$",tokenFormat:"!({0}...{1})",valueTypes:[O.ValueType.Self,O.ValueType.Self],exclude:true,validate:function(v,t){c._mOperators.between.validate(v,t);}}),lessThan:new O({name:"LT",filterOperator:M.LT,tokenParse:"^<([^=].*)$",tokenFormat:"<{0}",valueTypes:[O.ValueType.Self]}),notLessThan:new O({name:"NOTLT",filterOperator:M.GE,tokenParse:"^!<([^=].*)$",tokenFormat:"!(<{0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterThan:new O({name:"GT",filterOperator:M.GT,tokenParse:"^>([^=].*)$",tokenFormat:">{0}",valueTypes:[O.ValueType.Self]}),notGreaterThan:new O({name:"NOTGT",filterOperator:M.LE,tokenParse:"^!>([^=].*)$",tokenFormat:"!(>{0})",valueTypes:[O.ValueType.Self],exclude:true}),lessEqual:new O({name:"LE",alias:"TO",filterOperator:M.LE,tokenParse:"^<=(.+)$",tokenFormat:"<={0}",valueTypes:[O.ValueType.Self]}),notLessEqual:new O({name:"NOTLE",filterOperator:M.GT,tokenParse:"^!<=(.+)$",tokenFormat:"!(<={0})",valueTypes:[O.ValueType.Self],exclude:true}),greaterEqual:new O({name:"GE",alias:"FROM",filterOperator:M.GE,tokenParse:"^>=(.+)$",tokenFormat:">={0}",valueTypes:[O.ValueType.Self]}),notGreaterEqual:new O({name:"NOTGE",filterOperator:M.LT,tokenParse:"^!>=(.+)$",tokenFormat:"!(>={0})",valueTypes:[O.ValueType.Self],exclude:true}),startsWith:new O({name:"StartsWith",filterOperator:M.StartsWith,tokenParse:"^([^!\\*]+.*)\\*$",tokenFormat:"{0}*",valueTypes:[O.ValueType.SelfNoParse]}),notStartsWith:new O({name:"NotStartsWith",filterOperator:M.NotStartsWith,tokenParse:"^!([^\\*].*)\\*$",tokenFormat:"!({0}*)",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),endsWith:new O({name:"EndsWith",filterOperator:M.EndsWith,tokenParse:"^\\*(.*[^\\*])$",tokenFormat:"*{0}",valueTypes:[O.ValueType.SelfNoParse]}),notEndsWith:new O({name:"NotEndsWith",filterOperator:M.NotEndsWith,tokenParse:"^!\\*(.*[^\\*])$",tokenFormat:"!(*{0})",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),contains:new O({name:"Contains",filterOperator:M.Contains,tokenParse:"^\\*(.*)\\*$",tokenFormat:"*{0}*",valueTypes:[O.ValueType.SelfNoParse]}),notContains:new O({name:"NotContains",filterOperator:M.NotContains,tokenParse:"^!\\*(.*)\\*$",tokenFormat:"!(*{0}*)",valueTypes:[O.ValueType.SelfNoParse],exclude:true}),notEqual:new O({name:"NE",filterOperator:M.NE,tokenParse:"^!=(.+)$",tokenFormat:"!(={0})",valueTypes:[O.ValueType.Self],exclude:true}),empty:new O({name:"Empty",filterOperator:M.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",valueTypes:[],getModelFilter:function(f,s,t,g){var i=false;if(t){var r=t.parseValue("","string");try{t.validateValue(r);i=r===null;}catch(E){i=false;}}if(i){return new F({filters:[new F({path:s,operator:M.EQ,value1:""}),new F({path:s,operator:M.EQ,value1:null})],and:false});}else{return new F({path:s,operator:this.filterOperator,value1:""});}}}),notEmpty:new O({name:"NotEmpty",filterOperator:M.NE,tokenParse:"^!<#tokenText#>$",tokenFormat:"!(<#tokenText#>)",valueTypes:[],exclude:true,getModelFilter:function(f,s,t,g){var i=false;if(t){var r=t.parseValue("","string");try{t.validateValue(r);i=r===null;}catch(E){i=false;}}if(i){return new F({filters:[new F({path:s,operator:M.NE,value1:""}),new F({path:s,operator:M.NE,value1:null})],and:true});}else{return new F({path:s,operator:this.filterOperator,value1:""});}}}),yesterday:new R({name:"YESTERDAY",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.yesterday();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),today:new R({name:"TODAY",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.today();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),tomorrow:new R({name:"TOMORROW",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.tomorrow();},formatRange:function(r,f){return f.formatValue(r[0],"string");}}),lastDays:new R({name:"LASTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastDays(i);}}),todayFromTo:new R({alias:"TODAYXYDAYS",name:"TODAYFROMTO",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",calcRange:function(x,y){var s=x>=0?b.ranges.lastDays(x)[0]:b.ranges.nextDays(-x)[1];var E=y>=0?b.ranges.nextDays(y)[1]:b.ranges.lastDays(-y)[0];if(s.oDate.getTime()>E.oDate.getTime()){E=[s,s=E][0];}return[b.resetStartTime(s),b.resetEndTime(E)];}}),nextDays:new R({name:"NEXTDAYS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextDays(i);}}),lastWeek:new R({name:"LASTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastWeek();}}),thisWeek:new R({alias:"CURRENTWEEK",name:"THISWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentWeek();}}),nextWeek:new R({name:"NEXTWEEK",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextWeek();}}),lastWeeks:new R({name:"LASTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastWeeks(i);}}),nextWeeks:new R({name:"NEXTWEEKS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextWeeks(i);}}),lastMonth:new R({name:"LASTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastMonth();}}),thisMonth:new R({alias:"CURRENTMONTH",name:"THISMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentMonth();}}),nextMonth:new R({name:"NEXTMONTH",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextMonth();}}),lastMonths:new R({name:"LASTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastMonths(i);}}),nextMonths:new R({name:"NEXTMONTHS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextMonths(i);}}),lastQuarter:new R({name:"LASTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastQuarter();}}),thisQuarter:new R({alias:"CURRENTQUARTER",name:"THISQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentQuarter();}}),nextQuarter:new R({name:"NEXTQUARTER",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextQuarter();}}),lastQuarters:new R({name:"LASTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastQuarters(i);}}),nextQuarters:new R({name:"NEXTQUARTERS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextQuarters(i);}}),quarter1:new R({alias:"FIRSTQUARTER",name:"QUARTER1",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(1);}}),quarter2:new R({alias:"SECONDQUARTER",name:"QUARTER2",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(2);}}),quarter3:new R({alias:"THIRDQUARTER",name:"QUARTER3",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(3);}}),quarter4:new R({alias:"FOURTHQUARTER",name:"QUARTER4",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.quarter(4);}}),lastYear:new R({name:"LASTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.lastYear();}}),thisYear:new R({alias:"CURRENTYEAR",name:"THISYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.currentYear();}}),nextYear:new R({name:"NEXTYEAR",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.nextYear();}}),lastYears:new R({name:"LASTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.lastYears(i);}}),nextYears:new R({name:"NEXTYEARS",valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(i){return b.ranges.nextYears(i);}}),specificMonth:new R({name:"SPECIFICMONTH",valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:["(.+)"],additionalInfo:"",defaultValues:function(){var f=new U();return[f.getMonth()];},calcRange:function(i){var f=new U();f.setMonth(i);f=b.getMonthStartDate(f);return b.getRange(0,"MONTH",f);},format:function(f,t,s,h){var v=f.values[0];var T=this.tokenFormat;var r=e.apply(this)[v];if(h){return r;}else{return r==null?null:T.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),r);}},getValues:function(t,s,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){v=[];for(var i=0;i<this.valueTypes.length;i++){var h;if(g){h=g[i+1];}else if((f&&t)){h=t;}v.push(h);}return[e.apply(this).indexOf(v[0])];}return null;},createControl:function(t,p,f,s,g){var h=function(){if(!this._aMonthsItems){var q=e.apply(this);this._aMonthsItems=[];for(var i=0;i<12;i++){this._aMonthsItems.push({text:q[i],key:i});}}return this._aMonthsItems;}.bind(this);var j=sap.ui.require("sap/ui/mdc/field/ListFieldHelp");var k=sap.ui.require("sap/ui/core/ListItem");var l=sap.ui.require("sap/ui/mdc/Field");if(!j||!k||!l){L.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null;}if(!this._oListFieldHelp){this._oListFieldHelp=new j({id:"LFHForSpecificMonth",items:{path:"$items>/",template:new k({text:{path:"$items>text"},key:{path:"$items>key"}}),templateShareable:false}}).setModel(new J(h()),"$items");}var n=new l(s,{value:{path:p,type:t,mode:'TwoWay',targetType:'raw'},additionalValue:{path:p,formatter:function(v){return this._oListFieldHelp.getTextForKey(v);}.bind(this),mode:'OneWay'},display:'Description',width:"100%",fieldHelp:"LFHForSpecificMonth"});return n;}}),yearToDate:new R({name:"YEARTODATE",valueTypes:[O.ValueType.Static],calcRange:function(){return b.ranges.yearToDate();}})},_mDefaultOpsForType:{},addOperator:function(f){c._mOperators[f.name]=f;},addOperators:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){c.addOperator(g);});},removeOperators:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){c.removeOperator(g);});},removeOperator:function(v){if(typeof v==="string"){delete c._mOperators[v];}else{delete c._mOperators[v.name];}},setOperatorsForType:function(t,f,v){if(!Array.isArray(f)){f=[f];}if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={};}c._mDefaultOpsForType[t].operators=[];f.forEach(function(g){c.addOperatorForType(t,g);});if(v){c.setDefaultOperatorForType(t,v);}},setDefaultOperatorForType:function(t,v){if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={};}if(typeof v==="string"){v=c.getOperator(v);}c._mDefaultOpsForType[t].defaultOperator=v;},addOperatorForType:function(t,v){c.insertOperatorForType(t,v);},insertOperatorForType:function(t,v,i){if(!c._mDefaultOpsForType[t]){c._mDefaultOpsForType[t]={operators:[]};}i=i===undefined?c._mDefaultOpsForType[t].operators.length:i;if(typeof v==="string"){v=c.getOperator(v);}c._mDefaultOpsForType[t].operators.splice(i,0,v);},removeOperatorForType:function(t,v){var n;if(typeof v==="string"){n=v;}else{n=v.name;}for(var i=0;i<c._mDefaultOpsForType[t].operators.length;i++){if(c._mDefaultOpsForType[t].operators[i].name===n){c._mDefaultOpsForType[t].operators.splice(i,1);return;}}},getOperatorsForType:function(t){var f=[];for(var i=0;i<c._mDefaultOpsForType[t].operators.length;i++){f.push(c._mDefaultOpsForType[t].operators[i].name);}return f;},getDefaultOperator:function(t){return c._mDefaultOpsForType[t].defaultOperator||c._mOperators.equal;},getMatchingOperators:function(f,v){var g=[];for(var i=0;i<f.length;i++){var h=this.getOperator(f[i]);if(h){g.push(h);}}return _.call(this,g,v);},getOperator:function(s){for(var n in c._mOperators){var f=c._mOperators[n];if(f.name===s){return f;}}for(var n in c._mOperators){var f=c._mOperators[n];if(f.alias===s){return f;}}return undefined;},getEQOperator:function(f){if(f){for(var i=0;i<f.length;i++){var g=this.getOperator(f[i]);if(g&&g.validateInput&&!g.exclude&&g.valueTypes[0]&&g.valueTypes[0]!==O.ValueType.Static){return g;}}}return c._mOperators.equal;},onlyEQ:function(f){if(f.length===1&&f[0]==="EQ"){return true;}else{return false;}},checkConditionsEmpty:function(f){if(!Array.isArray(f)){f=[f];}f.forEach(function(g){var h=this.getOperator(g.operator);if(h){g.isEmpty=h.isEmpty(g);}}.bind(this));},updateConditionsValues:function(f){if(!Array.isArray(f)){f=[f];}for(var i=0;i<f.length;i++){this.updateConditionValues(f[i]);}},updateConditionValues:function(f){var g=this.getOperator(f.operator);if(g&&f.validated!==C.Validated){var v=g.valueTypes.length;if(g.valueTypes.length===2&&g.valueTypes[1]===null&&(f.values.length<2||f.values[1]===null||f.values[1]===undefined)){v=v-1;}if(g.valueTypes[0]==="static"){f.values=[];}else{while(f.values.length!=v){if(f.values.length<v){f.values.push(null);}if(f.values.length>v){f.values=f.values.slice(0,f.values.length-1);}}}}},indexOfCondition:function(f,g){var h=-1;for(var i=0;i<g.length;i++){if(this.compareConditions(f,g[i])){h=i;break;}}return h;},compareConditions:function(f,g){var E=false;if(f.operator===g.operator){var h=this.getOperator(f.operator);if(h){E=h.compareConditions(f,g);}}return E;},compareConditionsArray:function(f,g){var E=false;if(f.length===g.length){E=true;for(var i=0;i<f.length;i++){if(!this.compareConditions(f[i],g[i])){E=false;break;}}}return E;},checkConditionValidated:function(f){var g=this.getOperator(f.operator);if(!f.validated&&g&&g.checkValidated){g.checkValidated(f);}}};c.setOperatorsForType(B.String,[c._mOperators.contains,c._mOperators.equal,c._mOperators.between,c._mOperators.startsWith,c._mOperators.endsWith,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.empty,c._mOperators.notContains,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notStartsWith,c._mOperators.notEndsWith,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual,c._mOperators.notEmpty],c._mOperators.equal);c.setOperatorsForType(B.Date,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual,c._mOperators.today,c._mOperators.yesterday,c._mOperators.tomorrow,c._mOperators.todayFromTo,c._mOperators.lastDays,c._mOperators.nextDays,c._mOperators.thisWeek,c._mOperators.lastWeek,c._mOperators.lastWeeks,c._mOperators.nextWeek,c._mOperators.nextWeeks,c._mOperators.specificMonth,c._mOperators.thisMonth,c._mOperators.lastMonth,c._mOperators.lastMonths,c._mOperators.nextMonth,c._mOperators.nextMonths,c._mOperators.thisQuarter,c._mOperators.lastQuarter,c._mOperators.lastQuarters,c._mOperators.nextQuarter,c._mOperators.nextQuarters,c._mOperators.quarter1,c._mOperators.quarter2,c._mOperators.quarter3,c._mOperators.quarter4,c._mOperators.thisYear,c._mOperators.lastYear,c._mOperators.lastYears,c._mOperators.nextYear,c._mOperators.nextYears,c._mOperators.yearToDate]);c.setOperatorsForType(B.DateTime,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Numeric,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Time,[c._mOperators.equal,c._mOperators.between,c._mOperators.lessThan,c._mOperators.lessEqual,c._mOperators.greaterThan,c._mOperators.greaterEqual,c._mOperators.notEqual,c._mOperators.notBetween,c._mOperators.notLessThan,c._mOperators.notLessEqual,c._mOperators.notGreaterThan,c._mOperators.notGreaterEqual]);c.setOperatorsForType(B.Boolean,[c._mOperators.equal,c._mOperators.notEqual]);
function _(f,v){var r=[];for(var i=0;i<f.length;i++){var g=f[i];if(g&&g.test&&g.test(v)){r.push(g);}}return r;}
function d(v){return v===null||v===undefined||v==="";}
function e(){if(!this._aMonths){var f=new U(),g=D.getDateInstance({pattern:"LLLL"});f.setDate(15);f.setMonth(0);var h=[];for(var i=0;i<12;i++){h.push(g.format(f));f.setMonth(f.getMonth()+1);}this._aMonths=h;}return this._aMonths;}
return c;},true);
sap.ui.predefine('sap/ui/mdc/condition/Operator',['sap/ui/base/Object','sap/ui/model/Filter',"sap/ui/model/FilterOperator",'sap/ui/model/ParseException','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/merge','sap/base/util/deepEqual','./Condition','sap/ui/mdc/enum/ConditionValidated','sap/base/strings/escapeRegExp'],function(B,F,a,P,L,O,m,d,C,b,e){"use strict";var M=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){M=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});
var c=B.extend("sap.ui.mdc.condition.Operator",{constructor:function(o){B.apply(this,arguments);if(!o){throw new Error("Operator configuration missing");}if(!o.name){L.warning("Operator configuration expects a name property");}if(!o.filterOperator&&!o.getModelFilter){throw new Error("Operator configuration for "+o.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter");}this.name=o.name;if(o.alias){this.alias=o.alias;}this.filterOperator=o.filterOperator;this.valueTypes=o.valueTypes;this.paramTypes=o.paramTypes;this.displayFormats=o.displayFormats;var t="operators."+this.name;var l=t+".longText";var T=t+".tokenText";this.longText=o.longText||_(l)||"";this.tokenText=o.tokenText||_(T)||"";if(this.longText===l){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y");}if(this.tokenText===T){this.tokenText=this.longText;}if(this.tokenText){var r;var s;if(o.tokenParse){s=e(this.tokenText);this.tokenParse=o.tokenParse.replace(/#tokenText#/g,s);for(var i=0;i<this.valueTypes.length;i++){var R=this.paramTypes?this.paramTypes[i]:this.valueTypes[i];this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+i+"|"+i+"\\\\\\$"+"|"+"\\\\\\{"+i+"\\\\\\}","g"),R);}r=this.tokenParse;}else{r=e(this.tokenText);}this.tokenParseRegExp=new RegExp(r,"i");if(o.tokenFormat){s=this.tokenText;this.tokenFormat=o.tokenFormat.replace(/\#tokenText\#/g,s);}else{this.tokenFormat=this.tokenText;}}if(o.format){this.format=o.format;}if(o.parse){this.parse=o.parse;}if(o.validate){this.validate=o.validate;}if(o.getModelFilter){this.getModelFilter=o.getModelFilter;}if(o.isEmpty){this.isEmpty=o.isEmpty;}if(o.createControl){this.createControl=o.createControl;}if(o.getCheckValue){this.getCheckValue=o.getCheckValue;}if(o.getValues){this.getValues=o.getValues;}if(o.checkValidated){this.checkValidated=o.checkValidated;}if(o.additionalInfo!==undefined){this.additionalInfo=o.additionalInfo;}this.exclude=!!o.exclude;this.validateInput=!!o.validateInput;if(o.group){this.group=o.group;}else{this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=M.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id);}}}});
c.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};
function _(k,t){var f=k+(t?"."+t:""),T;T=M.getText(f,undefined,true);if(T===f||T===undefined){if(t){T=M.getText(k,undefined,true);if(T===f||T===undefined){T=k;}}else{T=f;}}return T;}
c.prototype.getTypeText=function(k,t){return _(k,t);};
c.prototype.getModelFilter=function(o,f,t,g){var v=o.values[0];var h;var i;var j=f.split(",");if(Array.isArray(v)&&j.length>1){v=v[0];f=j[0];i=new F({path:j[1],operator:a.EQ,value1:o.values[0][1]});}if(i&&v===undefined){h=i;i=undefined;}else if(!this.valueTypes[1]){if(!g&&o.validated===b.Validated){g=true;}h=new F({path:f,operator:this.filterOperator,value1:v,caseSensitive:g===false?false:undefined});}else{var V=o.values[1];if(Array.isArray(V)&&j.length>1){V=V[0];}h=new F({path:f,operator:this.filterOperator,value1:v,value2:V,caseSensitive:g===false?false:undefined});}if(i){h=new F({filters:[h,i],and:true});}if(o.inParameters){var k=[h];for(var I in o.inParameters){if(I.startsWith("conditions/")){k.push(new F({path:I.slice(11),operator:a.EQ,value1:o.inParameters[I]}));}}if(k.length>1){h=new F({filters:k,and:true});}}return h;};
c.prototype.isEmpty=function(o,t){var f=false;if(o){for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]!==c.ValueType.Static){var v=o.values[i];if(v===null||v===undefined||v===""){f=true;break;}}}}return f;};
c.prototype.format=function(o,t,D,h){var v=o.values;var f=this.valueTypes.length;var T=h&&f===1?"{0}":this.tokenFormat;for(var i=0;i<f;i++){if(this.valueTypes[i]!==c.ValueType.Static){if(this.valueTypes[i]!==c.ValueType.Self){t=this._createLocalType(this.valueTypes[i],t);}var V=v[i];if(V===undefined||V===null){V=t?t.parseValue("","string"):"";}var r=t?t.formatValue(V,"string"):V;T=T.replace(new RegExp("\\$"+i+"|"+i+"\\$"+"|"+"\\{"+i+"\\}","g"),r);}}return T;};
c.prototype.parse=function(t,T,D,f){var v=this.getValues(t,D,f);var r;if(v){r=[];for(var i=0;i<this.valueTypes.length;i++){if(this.valueTypes[i]&&[c.ValueType.Self,c.ValueType.Static].indexOf(this.valueTypes[i])===-1){T=this._createLocalType(this.valueTypes[i],T);}try{if(this.valueTypes[i]!==c.ValueType.Static){var V;if(this.valueTypes[i]){V=this._parseValue(v[i],T);}else{V=v[i];}r.push(V);}}catch(g){L.warning(g.message);throw g;}}}return r;};
c.prototype._parseValue=function(v,t){if(v===undefined){return v;}var f;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){f=t._aCurrentValue;}var V=t?t.parseValue(v,"string",f):v;if(t&&t._aCurrentValue&&Array.isArray(V)){for(var j=0;j<V.length;j++){if(V[j]===undefined){V[j]=t._aCurrentValue[j]===undefined?null:t._aCurrentValue[j];}}}return V;};
c.prototype.validate=function(v,t){var f=this.valueTypes.length;for(var i=0;i<f;i++){if(this.valueTypes[i]&&this.valueTypes[i]!==c.ValueType.Static){if([c.ValueType.Self,c.ValueType.Static].indexOf(this.valueTypes[i])===-1){t=this._createLocalType(this.valueTypes[i],t);}if(v.length<i+1){throw new Error("value "+i+" for operator "+this.getName()+" missing");}if(t){var V=v[i];if(V===undefined||V===null){V=t?t.parseValue("","string"):"";}t.validateValue(V);}}}};
c.prototype._createLocalType=function(t,T){if(!this._aTypes){this._aTypes=[];}var s;var f;var o;var u;if(t===c.ValueType.SelfNoParse){s=T.getMetadata().getName();f=m({},T.getFormatOptions());o=m(T.getConstraints());}else if(typeof t==="string"){s=t;}else if(t&&typeof t==="object"){s=t.name;f=t.formatOptions;o=t.constraints;}for(var i=0;i<this._aTypes.length;i++){var g=this._aTypes[i];if(g.name===s&&d(g.formatOptions,f)&&d(g.constraints,o)){u=g.type;break;}}if(!u){var h=O.get(s||"");u=new h(f,o);u._bCreatedByOperator=true;if(t===c.ValueType.SelfNoParse){u.parseValue=function(v,S){h.prototype.parseValue.apply(this,arguments);return v;};u.validateValue=function(v){var V=h.prototype.parseValue.apply(this,[v,"string"]);h.prototype.validateValue.apply(this,[V]);};u.formatValue=function(v,j){h.prototype.formatValue.apply(this,arguments);return v;};}this._aTypes.push({name:s,formatOptions:f,constraints:o,type:u});}return u;};
c.prototype.test=function(t){return this.tokenParseRegExp.test(t);};
c.prototype.getValues=function(t,D,f){var g=t.match(this.tokenParseRegExp);var v;if(g||(f&&t)){v=[];for(var i=0;i<this.valueTypes.length;i++){var V;if(g){V=g[i+1];}else if(f){if(i>0){break;}V=t;}v.push(V);}}return v;};
c.prototype.getCondition=function(t,T,D,f){if(this.test(t)||(f&&t&&this.hasRequiredValues())){var v=this.parse(t,T,D,f);if(v.length==this.valueTypes.length||this.valueTypes[0]===c.ValueType.Static||(v.length===1&&this.valueTypes.length===2&&!this.valueTypes[1])){var o=C.createCondition(this.name,v);this.checkValidated(o);return o;}else{throw new P("Parsed value don't meet operator");}}return null;};
c.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false;}return true;};
c.prototype.getCheckValue=function(o){if(this.valueTypes[0]&&this.valueTypes[0]===c.ValueType.Static){return{};}else{return{values:o.values};}};
c.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==c.ValueType.Static){return true;}else{return false;}};
c.prototype.compareConditions=function(o,f){var E=false;if(o.operator===this.name&&o.operator===f.operator){var g=this.getCheckValue(o);var h=this.getCheckValue(f);if(o.inParameters&&f.inParameters){g.inParameters=o.inParameters;h.inParameters=f.inParameters;}if(o.outParameters&&f.outParameters){g.outParameters=o.outParameters;h.outParameters=f.outParameters;}if(o.validated&&f.validated){g.validated=o.validated;h.validated=f.validated;}var s=JSON.stringify(g);var i=JSON.stringify(h);if(s===i){E=true;}}return E;};
c.prototype.checkValidated=function(o){o.validated=b.NotValidated;};
return c;});
sap.ui.predefine('sap/ui/mdc/condition/OperatorDynamicDateOption',['sap/m/DynamicDateOption','sap/m/DynamicDateValueHelpUIType','sap/m/Input','sap/m/DatePicker','sap/ui/mdc/condition/Operator','sap/ui/mdc/util/DateUtil','sap/ui/model/json/JSONModel','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/core/library'],function(D,a,I,b,O,c,J,F,P,V,d){"use strict";var e=d.ValueState;
var f=D.extend("sap.ui.mdc.condition.OperatorDynamicDateOption",{metadata:{library:"sap.ui.mdc",properties:{operator:{type:"object"},type:{type:"object"}}}});
f.prototype.exit=function(){if(this._oModel){this._oModel.destroy();this._oModel=undefined;this._mChangeHandler=undefined;}if(this._aUITypes){for(var i=0;i<this._aUITypes.length;i++){this._aUITypes[i].destroy();}this._aUITypes=undefined;}};
f.prototype.validateProperty=function(p,v){if(p==="operator"&&v&&(typeof v!=="object"||!v.isA||!v.isA("sap.ui.mdc.condition.Operator"))){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+"sap.ui.mdc.condition.Operator for property \""+p+"\" of "+this);}else if(p==="type"&&v&&(typeof v!=="object"||!v.isA||!v.isA("sap.ui.model.Type"))){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+"sap.ui.model.Type for property \""+p+"\" of "+this);}return D.prototype.validateProperty.apply(this,arguments);};
f.prototype.getKey=function(){var o=this.getOperator();return o.name;};
f.prototype.isRange=function(){var o=this.getOperator();return o.isA("sap.ui.mdc.condition.RangeOperator");};
f.prototype.getText=function(C){var o=this.getOperator();return o.longText;};
f.prototype.getValueHelpUITypes=function(C){if(!this._aUITypes){var o=this.getOperator();var t=this.getType();this._aUITypes=[];for(var i=0;i<o.valueTypes.length;i++){var T=o.valueTypes[i];if(T===O.ValueType.Self){this._aUITypes.push(new a({type:"date"}));}else if(T===O.ValueType.Static){continue;}else{t=o._createLocalType(T,t);if(t.isA("sap.ui.model.type.Integer")||t.isA("sap.ui.model.odata.type.Int")){this._aUITypes.push(new a({type:"int"}));}else{this._aUITypes.push(new a({type:"custom"}));}}}}return this._aUITypes;};
f.prototype.createValueHelpUI=function(C,g){var v=C.getValue();var o=this.getOperator();var t=this.getType();var k=this.getKey();var s=C.getId();if(!v||v.operator!==k){v={operator:k,values:[]};if(o.valueDefaults){v.values=o.valueDefaults;}}_.call(this,C);if(!C.aControlsByParameters){C.aControlsByParameters={};}C.aControlsByParameters[k]=[];var h=function(E){g(this);}.bind(this);for(var i=0;i<o.valueTypes.length;i++){var T=o.valueTypes[i];var j;if(!C.aControlsByParameters[k][i]){if(o.createControl){if(!this._oModel){h=function(E){var r=E.getParameter("path");var u=r.split("/");var s=u[0]||u[1];if(this._mChangeHandler&&this._mChangeHandler[s]){this._mChangeHandler[s](this);}}.bind(this);this._oModel=new J();this._oModel.attachPropertyChange({},h,this);this._mChangeHandler={};}var m=this._oModel.getData();m[s]={value0:v&&v.values[0],value1:v&&v.values[1]};this._mChangeHandler[s]=g;if(T!==O.ValueType.Self){t=o._createLocalType(T,t);}var l=o.createControl(t,"internal>/"+s+"/value"+i,i,s+"-"+i);l.setModel(this._oModel,"internal");C.aControlsByParameters[k].push(l);}else if(T===O.ValueType.Self){if(v&&v.values[i]){j=c.typeToUniversalDate(v.values[i],t);j=c.utcToLocal(j);}var n=t.getFormatOptions();var p=new b(s+"-"+i,{dateValue:j,displayFormat:n.style||n.pattern,displayFormatType:n.calendarType,change:h});C.aControlsByParameters[k].push(p);}else if(typeof T==="object"){var q=new I(s+"-"+i,{value:v&&v.values[i],change:h});C.aControlsByParameters[k].push(q);}}}return C.aControlsByParameters[k];};
f.prototype.validateValueHelpUI=function(C){var k=this.getKey();var o=this.getOperator();var t=this.getType();var g;var v=true;var s=e.None;var h;var i=0;try{g=this.getValueHelpOutput(C);for(i=0;i<g.values.length;i++){var j=g.values[i];if(j===undefined||j===null){v=false;}}o.validate(g.values,t);}catch(E){v=false;s=e.Error;h=E.message;if(E&&!(E instanceof P)&&!(E instanceof V)){throw E;}}if(!o.createControl){for(i=0;i<C.aControlsByParameters[k].length;i++){var l=C.aControlsByParameters[k][i];if(l.setValueState){l.setValueState(s);l.setValueStateText(h);}}}return v;};
f.prototype.getValueHelpOutput=function(C){var k=this.getKey();var r={operator:k,values:[]};var o=this.getOperator();var t=this.getType();var s=C.getId();for(var i=0;i<o.valueTypes.length;i++){var g=C.aControlsByParameters[k][i];if(g){var v;if(o.createControl){v=this._oModel?this._oModel.getProperty("/"+s+"/value"+i):null;}else if(o.valueTypes[i]===O.ValueType.Self){if(!g.isValidValue()){throw new P();}v=g.getDateValue();if(v){v=c.localToUtc(v);v=c.universalDateToType(v,t);}}else{v=g.getValue();t=o._createLocalType(o.valueTypes[i],t);v=t.parseValue(v,"string");}r.values.push(v);}}return r;};
f.prototype.getGroupHeader=function(){var o=this.getOperator();if(o.group&&o.group.text){return o.group.text;}return D.prototype.getGroupHeader.apply(this,arguments);};
f.prototype.getGroup=function(){var o=this.getOperator();if(o.group){return o.group.id;}return D.prototype.getGroup.apply(this,arguments);};
f.prototype.toDates=function(v){var o=this.getOperator();var t=this.getType();var r;var i=0;if(o.isA("sap.ui.mdc.condition.RangeOperator")){r=o._getRange(v&&v.values,t);for(i=0;i<r.length;i++){r[i]=c.typeToUniversalDate(r[i],t);r[i]=c.utcToLocal(r[i]);}}else if(o.valueTypes[0]===O.ValueType.Self){r=v.values;for(i=0;i<r.length;i++){if(r[i]){r[i]=c.typeToUniversalDate(r[i],t);r[i]=c.utcToLocal(r[i]);}}if(r.length===1){r.push(r[0]);}}else if([O.ValueType.Self,O.ValueType.Static].indexOf(o.valueTypes[0])===-1){throw new Error("Cannot convert to date, use RangeOperator");}return r;};
f.prototype.format=function(v){var o=this.getOperator();var t=this.getType();return o.format(v,t);};
f.prototype.parse=function(v){var o=this.getOperator();var t=this.getType();if(v&&o.parse(v)){var r={};r.operator=this.getKey();r.values=o.parse(v,t);return r;}};
f.prototype.enhanceFormattedValue=function(s,A){return false;};
function _(C){var k=this.getKey();if(C&&C.aControlsByParameters&&C.aControlsByParameters[k]){for(var i=0;i<C.aControlsByParameters[k].length;i++){var u=C.aControlsByParameters[k][i];if(!u.bIsDestroyed){u.destroy();}}delete C.aControlsByParameters[k];}}
return f;});
sap.ui.predefine('sap/ui/mdc/condition/RangeOperator',['sap/ui/mdc/condition/Operator','sap/ui/model/Filter','sap/ui/mdc/util/DateUtil','sap/base/Log'],function(O,F,D,L){"use strict";
var R=O.extend("sap.ui.mdc.condition.RangeOperator",{constructor:function(c){c.filterOperator="RANGE";c.tokenParse=c.tokenParse||"^#tokenText#$";c.tokenFormat=c.tokenFormat||"#tokenText#";O.apply(this,arguments);if(this.paramTypes){if(c.defaultValues!==undefined){if(Array.isArray(c.defaultValues)){this.valueDefaults=c.defaultValues;}else{this.valueDefaults=c.defaultValues();}}else{this.paramTypes.forEach(function(t){if(!this.valueDefaults){this.valueDefaults=[];}this.valueDefaults.push(1);}.bind(this));}}if(c.label!==undefined){this.aLabels=c.label;}if(c.calcRange){this.calcRange=c.calcRange;}if(c.formatRange){this.formatRange=c.formatRange;}else if(this.calcRange){this.formatRange=function(r,d){return d.formatValue(r[0],"string")+" - "+d.formatValue(r[1],"string");};}}});
R.prototype.getModelFilter=function(c,f,t,C){var r=this._getRange(c.values,t);return new F({path:f,operator:"BT",value1:r[0],value2:r[1]});};
R.prototype._getRange=function(v,t){var r;if(v){if(v.length===2){r=this.calcRange(v[0],v[1]);}else{r=this.calcRange(v[0]);}}else{r=this.calcRange();}for(var i=0;i<2;i++){r[i].oDate=D.localToUtc(r[i].oDate);r[i]=D.universalDateToType(r[i],t);}return r;};
R.prototype.getStaticText=function(t){var r=this._getRange(null,t);return this.formatRange(r,t);};
return R;},true);
sap.ui.predefine('sap/ui/mdc/enum/ActionToolbarActionAlignment',function(){"use strict";var A={Begin:"Begin",End:"End"};return A;},true);
sap.ui.predefine('sap/ui/mdc/enum/BaseType',function(){"use strict";var B={String:"String",Numeric:"Numeric",Boolean:"Boolean",Date:"Date",Time:"Time",DateTime:"DateTime",Unit:"Unit"};return B;},true);
sap.ui.predefine('sap/ui/mdc/enum/ConditionValidated',function(){"use strict";var C={NotValidated:"NotValidated",Validated:"Validated"};return C;},true);
sap.ui.predefine('sap/ui/mdc/enum/ContentMode',function(){"use strict";var C={Display:"Display",DisplayMultiValue:"DisplayMultiValue",DisplayMultiLine:"DisplayMultiLine",Edit:"Edit",EditMultiValue:"EditMultiValue",EditMultiLine:"EditMultiLine",EditOperator:"EditOperator",EditForHelp:"EditForHelp"};return C;},true);
sap.ui.predefine('sap/ui/mdc/enum/EditMode',function(){"use strict";var E={Display:"Display",Editable:"Editable",ReadOnly:"ReadOnly",Disabled:"Disabled",EditableReadOnly:"EditableReadOnly",EditableDisplay:"EditableDisplay"};return E;},true);
sap.ui.predefine('sap/ui/mdc/enum/FieldDisplay',function(){"use strict";var F={Value:"Value",Description:"Description",ValueDescription:"ValueDescription",DescriptionValue:"DescriptionValue"};return F;},true);
sap.ui.predefine('sap/ui/mdc/enum/OutParameterMode',function(){"use strict";var O={Always:"Always",WhenEmpty:"WhenEmpty"};return O;},true);
sap.ui.predefine('sap/ui/mdc/enum/PersistenceMode',function(){"use strict";var P={Global:"Global",Auto:"Auto",Transient:"Transient"};return P;},true);
sap.ui.predefine('sap/ui/mdc/enum/SelectType',function(){"use strict";var S={Set:"Set",Add:"Add",Remove:"Remove"};return S;},true);
sap.ui.predefine('sap/ui/mdc/field/ConditionType',['sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/type/String','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/base/util/merge','sap/ui/base/SyncPromise'],function(S,F,P,V,a,b,c,O,C,B,d,m,e){"use strict";
var f=S.extend("sap.ui.mdc.field.ConditionType",{constructor:function(i,J){S.apply(this,arguments);this.sName="Condition";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined};}});
f.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._bDestroyed=true;};
f.prototype.formatValue=function(i,J){if(i==undefined||i==null||this._bDestroyed){return null;}if(typeof i!=="object"||!i.operator||!i.values||!Array.isArray(i.values)){throw new F("No valid condition provided");}if(!J){J="string";}var T=o.call(this);var K=v(T);var L=this.oFormatOptions.preventGetDescription;w.call(this,i,T);switch(this.getPrimitiveType(J)){case"string":case"any":var M=n.call(this);var N=s.call(this);var Q=c.getEQOperator(N);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++;}var R=this._oCalls.last;if(!L&&M!==b.Value&&i.validated===d.Validated&&(K||(i.operator===Q.name&&!i.values[1]))){var U=this.oFormatOptions.bindingContext;var W=this.oFormatOptions.conditionModel;var X=this.oFormatOptions.conditionModelName;var Y=K?i.values[0][1]:i.values[0];return e.resolve().then(function(){return H.call(this,Y,i.inParameters,i.outParameters,U,W,X);}.bind(this)).then(function(Z){if(Z){i=m({},i);if(K){T=p.call(this);i.operator=Q.name;if(typeof Z!=="object"){Z={key:Y,description:Z};}}if(typeof Z==="object"){i=y.call(this,i,Z);}else if(i.values.length===1){i.values.push(Z);}else{i.values[1]=Z;}}return g.call(this,i,undefined,R,true,T);}.bind(this)).catch(function(Z){var $;if(!(Z instanceof F)||!E.call(this)){$=Z;}return g.call(this,i,$,R,true,T);}.bind(this)).unwrap();}return g.call(this,i,undefined,R,true,T);default:if(T&&i.values.length>=1){return T.formatValue(i.values[0],J);}throw new F("Don't know how to format Condition to "+J);}};
function _(i,T){var J=n.call(this);var K=v(T);if(K&&i.values.length>1&&i.values[0][1]===i.values[1][1]){i=m({},i);i.operator="EQ";i.values.splice(1);}var L=(this.oFormatOptions.hideOperator&&i.values.length===1)||K;var M=c.getOperator(i.operator);if(!M){throw new F("No valid condition provided, Operator wrong.");}return M.format(i,T,J,L);}
function g(i,J,K,L,T){if(this._oCalls.active>0){this._oCalls.active--;}if(K<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){i=this._oCalls.condition;J=this._oCalls.exception;}if(K===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=m({},i);this._oCalls.exception=J;}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined};}if(J){throw J;}var R;if(L){R=_.call(this,i,T);}else{R=h.call(this,i,T);}return R;}
f.prototype.parseValue=function(i,J){if(this._bDestroyed){return null;}if(!J){J="string";}else if(J==="any"&&typeof i==="string"){J="string";}var N=this.oFormatOptions.navigateCondition;if(N){var K=this.formatValue(N,J);if(K===i){return m({},N);}}var L=n.call(this);var M=D.call(this);var T=o.call(this);var Q=q.call(this);var R=s.call(this);var U=v(T);var W;if(i===null||i===undefined||(i===""&&!M)){if(!u.call(this,T)){return null;}}x.call(this,T);switch(this.getPrimitiveType(J)){case"string":var X;var Y=false;var Z=false;if(R.length===1){X=c.getOperator(R[0]);Z=true;}else{var $=c.getMatchingOperators(R,i);if($.length===0){X=I.call(this,R,T);if(M&&!u.call(this,T)){var a1=c.getEQOperator(R);if(R.indexOf(a1.name)>=0){Y=!!X&&X.name!==a1.name;X=a1;}}Z=true;}else{var b1=$.filter(function(X){return X.valueTypes.length===0;});if(b1.length>=1){X=b1[0];}else{X=$[0];}}}if(X){if(U&&X!==c.getEQOperator(R)){throw new P("unsupported operator");}var c1;var d1=u.call(this,T);this._oCalls.active++;this._oCalls.last++;var e1=this._oCalls.last;if((!d1||U)&&X.validateInput&&M){c1=j.call(this,X,i,T,Z,Y,R,L,true);if(c1 instanceof Promise){return z.call(this,c1);}else{return c1;}}else{try{if(i===""&&d1&&Z){c1=C.createCondition(X.name,[T.parseValue(i,"string",T._aCurrentValue)],undefined,undefined,d.NotValidated);}else{c1=X.getCondition(i,T,L,Z);}}catch(f1){var g1=f1;if(g1 instanceof P&&Q){try{Q.parseValue(i,"string",Q._aCurrentValue);}catch(h1){g1=h1;}}return g.call(this,undefined,g1,e1,false,T);}}if(c1){return g.call(this,c1,undefined,e1,false,T);}}throw new P("Cannot parse value "+i);default:if(T){if(R.length===1){W=R[0];}else{W=I.call(this,R,T).name;if(R.indexOf(W)<0){W=undefined;}}if(W){return C.createCondition(W,[T.parseValue(i,J)],undefined,undefined,d.NotValidated);}}throw new P("Don't know how to parse Condition from "+J);}};
function h(i,T){var J=v(T);if(i&&!J){var N=T.getMetadata().getName();var K=this.oFormatOptions.delegate;var L=this.oFormatOptions.payload;if(K&&K.getTypeUtil(L).getBaseType(N)===B.Unit&&!i.values[0][1]&&T._aCurrentValue){var U=T._aCurrentValue[1]?T._aCurrentValue[1]:null;i.values[0][1]=T._aCurrentValue[1]?T._aCurrentValue[1]:null;if(i.operator==="BT"){i.values[1][1]=U;}}}w.call(this,i,T);return i;}
function j(i,J,T,U,K,L,M,N){var Q;var R;var W=true;var X=true;var Y=false;var Z;var $;var a1=this.oFormatOptions.bindingContext;var b1=this.oFormatOptions.conditionModel;var c1=this.oFormatOptions.conditionModelName;var d1;if(J===""){d1=[];Q=J;Z=J;}else{d1=i.getValues(J,M,U);Q=N?d1[0]:d1[1];R=N?d1[1]:d1[0];Y=M!==b.Value;X=M===b.Value||M===b.ValueDescription;Z=X?Q||R:R||Q;}var e1=function(i1){if(i1&&!(i1 instanceof P)&&!(i1 instanceof F)){throw i1;}if(!i1._bNotUnique){if(J===""){return null;}if(N&&d1[0]&&d1[1]){return j.call(this,i,J,T,U,K,L,M,false);}if(K){return k.call(this,T,L,J,M);}}if(E.call(this)){return l.call(this,T,L,J,M);}throw new P(i1.message);};var f1=function(j1){if(j1){var d1=[j1.key];if(i.valueTypes.length>1&&i.valueTypes[1]!==O.ValueType.Static){d1.push(j1.description);}return C.createCondition(i.name,d1,j1.inParameters,j1.outParameters,d.Validated);}else if(J===""){return null;}else{return e1.call(this,new P(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[J])));}};var g1=this._oCalls.last;var h1=function(j1,k1){var l1;var m1;try{l1=k1.call(this,j1);if(v(T)){if(l1){if(l1.operator!=="EQ"){throw new P("unsupported operator");}var n1=T._aCurrentValue&&T._aCurrentValue[0]!==undefined?T._aCurrentValue[0]:null;var o1=l1.values[0];l1.values=[[n1,o1]];}else if(J===""){l1=C.createCondition(i.name,[T.parseValue(J,"string",T._aCurrentValue)],undefined,undefined,d.NotValidated);}}}catch(i1){m1=i1;}return g.call(this,l1,m1,g1,false,T);};try{if(v(T)){$=T.parseValue(Z,"string",T._aCurrentValue);T.validateValue($);$=$[1];}else{$=T.parseValue(Z,"string");T.validateValue($);}}catch(i1){if(i1&&!(i1 instanceof P)&&!(i1 instanceof V)){throw i1;}W=false;X=false;$=undefined;}return e.resolve().then(function(){return G.call(this,Z,$,a1,X,W,Y,b1,c1);}.bind(this)).then(function(j1){return h1.call(this,j1,f1);}.bind(this)).catch(function(i1){return h1.call(this,i1,e1);}.bind(this)).unwrap();}
function k(T,i,J,K){var L=I.call(this,i,T);var M;if(L&&i.indexOf(L.name)>=0){M=L.getCondition(J,T,b.Value,true);M.validated=d.NotValidated;}return M;}
function l(T,i,J,K){var L;if(v(T)){L=c.getEQOperator("EQ");}else if(i.length===1){L=c.getOperator(i[0]);}else{L=c.getEQOperator(i);if(i.indexOf(L.name)<0){L=undefined;}}if(!L){throw new P("Cannot parse value "+J);}var M=L.getCondition(J,T,b.Value,true);if(M){M.validated=d.NotValidated;if(v(T)&&Array.isArray(M.values[0])){M.values[0]=M.values[0][1];}}return M;}
f.prototype.validateValue=function(i){var T=o.call(this);var J=q.call(this);var K=s.call(this);var L=v(T);if(i===undefined||this._bDestroyed){return null;}else if(i===null){if(c.onlyEQ(K)){try{if(T.hasOwnProperty("_sParsedEmptyString")&&T._sParsedEmptyString!==null){T.validateValue(T._sParsedEmptyString);}else{T.validateValue(null);}}catch(M){if(M instanceof V){throw M;}else{return null;}}}return null;}if(typeof i!=="object"||!i.operator||!i.values||!Array.isArray(i.values)){throw new V(this._oResourceBundle.getText("field.VALUE_NOT_VALID"));}var N=c.getOperator(i.operator,K);if(L){N=c.getEQOperator();}if(!N){throw new V("No valid condition provided, Operator wrong.");}try{N.validate(i.values,T);}catch(Q){if(Q instanceof V&&J){N.validate(i.values,J);}throw Q;}};
function n(){var i=this.oFormatOptions.display;if(!i){i=b.Value;}return i;}
function o(){var T=this.oFormatOptions.valueType;if(!T){T=p.call(this);}return T;}
function p(){if(!this._oDefaultType){this._oDefaultType=new a();}return this._oDefaultType;}
function q(){return this.oFormatOptions.originalDateType;}
function r(){return this.oFormatOptions.additionalType;}
function s(){var i=this.oFormatOptions.operators;if(!i||i.length===0){i=c.getOperatorsForType(B.String);}return i;}
function t(){var i=this.oFormatOptions.fieldHelpID;if(i){var J=sap.ui.getCore().byId(i);if(J&&J.isValidationSupported()){return J;}}return null;}
function u(T){return T&&T.isA("sap.ui.model.CompositeType");}
function v(T){if(u(T)){var i=T.getFormatOptions();var J=!i||!i.hasOwnProperty("showMeasure")||i.showMeasure;var K=!i||!i.hasOwnProperty("showNumber")||i.showNumber;if(J&&!K){return true;}}return false;}
function w(i,T){if(u.call(this,T)&&i&&i.values[0]){T._aCurrentValue=i.values[0];var J=r.call(this);if(u.call(this,J)){J._aCurrentValue=i.values[0];}var K=q.call(this);if(u.call(this,K)){K._aCurrentValue=i.values[0];}}}
function x(T){if(u.call(this,T)){var i=r.call(this);if(u.call(this,i)){if(!i._aCurrentValue){i._aCurrentValue=[];}T._aCurrentValue=i._aCurrentValue;}}}
function y(i,R){i.values=[R.key,R.description];if(R.inParameters){i.inParameters=R.inParameters;}if(R.outParameters){i.outParameters=R.outParameters;}return i;}
function z(i){if(this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(i);}return i;}
function A(T){var i=T.getMetadata().getName();var J=T.getFormatOptions();var K=T.getConstraints();var L=this.oFormatOptions.delegate;var M=this.oFormatOptions.payload;var N=L?L.getTypeUtil(M).getBaseType(i,J,K):B.String;if(N===B.Unit){N=B.Numeric;}return N;}
function D(){var i=t.call(this);var J=this.oFormatOptions.delegate;var K=this.oFormatOptions.payload;if(J){return J.isInputValidationEnabled(K,i);}else{return!!i;}}
function E(){var i=t.call(this);var J=this.oFormatOptions.delegate;var K=this.oFormatOptions.payload;if(J){return J.isInvalidInputAllowed(K,i);}else if(i){return!i.getValidateInput();}else{return true;}}
function G(i,J,K,L,M,N,Q,R){var T=t.call(this);var U=this.oFormatOptions.delegate;var W=this.oFormatOptions.payload;var X={value:i,parsedValue:J,inParameters:undefined,outParameters:undefined,bindingContext:K,checkKeyFirst:L,checkKey:M,checkDescription:N,conditionModel:Q,conditionModelName:R,exception:P};if(U){return U.getItemForValue(W,T,X);}else if(T){return T.getItemForValue(X);}}
function H(K,i,J,L,M,N){var Q=t.call(this);var R=this.oFormatOptions.delegate;var T=this.oFormatOptions.payload;if(R){return R.getDescription(T,Q,K,i,J,L,M,N);}else if(Q){return Q.getTextForKey(K,i,J,L,M,N);}}
function I(J,T){var K=this.oFormatOptions.defaultOperatorName;var L;if(K){L=c.getOperator(K);}else{L=c.getDefaultOperator(A.call(this,T));}if(L&&J.indexOf(L.name)<0){for(var i=0;i<J.length;i++){L=c.getOperator(J[i]);if(L.exclude||!L.hasRequiredValues()){L=undefined;}else{break;}}}return L;}
return f;});
sap.ui.predefine('sap/ui/mdc/field/ConditionsType',['sap/ui/mdc/field/ConditionType','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/base/util/merge','sap/ui/base/SyncPromise'],function(C,S,F,P,V,m,a){"use strict";
var b=S.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(o,g){S.apply(this,arguments);this.sName="Conditions";o=_(o);this._oConditionType=new C(o,this.oConstraints);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}});
b.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined;}this._bDestroyed=true;};
b.prototype.setFormatOptions=function(o){S.prototype.setFormatOptions.apply(this,arguments);o=_(o);if(this._oConditionType){this._oConditionType.setFormatOptions(o);}};
function _(o){o=m({},o);if(o.asyncParsing){delete o.asyncParsing;}return o;}
b.prototype.setConstraints=function(o){S.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints);}};
b.prototype.formatValue=function(g,I){if(g==undefined||g==null||this._bDestroyed){return null;}if(!Array.isArray(g)){throw new F("No valid conditions provided");}var v;if(!I||I==="string"||I==="any"){v="";}else if(I==="float"||I==="int"){v=0;}var M=e.call(this);var s=[];var h=function(o,I){return a.resolve().then(function(){return this._oConditionType.formatValue(o,I);}.bind(this));};for(var i=0;i<g.length;i++){s.push(h.call(this,g[i],I));if(M>0&&i>=M-1){break;}}return a.all(s).then(function(j){return c.call(this,j,v);}.bind(this)).unwrap();};
function c(g,v){for(var i=0;i<g.length;i++){if(v){v=v+this._oResourceBundle.getText("field.SEPARATOR")+g[i];}else{v=g[i];}}return v;}
b.prototype.parseValue=function(v,i){if(this._bDestroyed){return null;}if(e.call(this)!==1){throw new P("Only one condition supported for parsing");}var o=a.resolve().then(function(){return this._oConditionType.parseValue(v,i);}.bind(this)).then(function(o){return d.call(this,o);}.bind(this)).unwrap();if(o instanceof Promise&&this.oFormatOptions.asyncParsing){this.oFormatOptions.asyncParsing(o);}return o;};
function d(o){var I=f(this.oFormatOptions.valueType);if(I&&this.oFormatOptions.getConditions){var u=o&&o.values[0][1];var g=o&&o.inParameters;var O=o&&o.outParameters;var h=this.oFormatOptions.getConditions();for(var i=0;i<h.length;i++){h[i].values[0][1]=u;if(u===undefined){h[i].values[0][0]=o.values[0][0];}h[i].values[0].splice(2);if(h[i].operator==="BT"){h[i].values[1][1]=u;if(u===undefined){h[i].values[1][0]=o.values[0][0];}h[i].values[1].splice(2);}if(g||h[i].inParameters){h[i].inParameters=g;}if(O||h[i].outParameters){h[i].outParameters=O;}}if(h.length===0){h.push(o);}return h;}else if(o){return[o];}else{return[];}}
b.prototype.validateValue=function(g){if(g===undefined||g===null||this._bDestroyed){return;}if(!Array.isArray(g)){throw new V("No valid conditions provided");}for(var i=0;i<g.length;i++){var o=g[i];this._oConditionType.validateValue(o);}var M=e.call(this);if(g.length===0&&M===1){this._oConditionType.validateValue(null);}};
function e(){var M=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){M=this.oFormatOptions.maxConditions;}return M;}
function f(t){if(t&&t.isA("sap.ui.model.CompositeType")){var o=t.getFormatOptions();var s=!o||!o.hasOwnProperty("showMeasure")||o.showMeasure;var g=!o||!o.hasOwnProperty("showNumber")||o.showNumber;if(s&&!g){return true;}}return false;}
return b;});
sap.ui.predefine('sap/ui/mdc/field/DefineConditionPanel',['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/field/ConditionType','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/Field','sap/ui/mdc/field/ListFieldHelp','sap/ui/mdc/field/ListFieldHelpItem','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/model/resource/ResourceModel','sap/ui/model/type/String','sap/ui/core/library','sap/ui/core/InvisibleText','sap/ui/core/ListItem','sap/ui/layout/Grid','sap/ui/layout/GridData','sap/m/library','sap/m/ScrollContainer','sap/m/Button','sap/m/Panel','sap/base/Log'],function(C,M,m,d,a,F,O,b,E,c,B,e,f,L,g,h,J,R,S,k,I,l,G,o,p,q,r,P,s){"use strict";var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var u=p.ButtonType;var V=k.ValueState;
var D=C.extend("sap.ui.mdc.field.DefineConditionPanel",{
metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},formatOptions:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{conditionProcessed:{}}},
_oManagedObjectModel:null,
renderer:{apiVersion:2,render:function(i,j){i.openStart("section",j);i.class("sapUiMdcDefineConditionPanel");i.openEnd();i.renderControl(j.getAggregation("_content"));i.close("section");}},
init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);C.prototype.init.apply(this,arguments);this._oManagedObjectModel=new h(this);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["conditions","formatOptions"]});X.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition");},
exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;},
byId:function(i){return sap.ui.getCore().byId(this.getId()+"--"+i);},
onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}if(this.getConditions().length===0){this.updateDefineConditions();}},
removeCondition:function(j){var n=j.oSource;var m1=n.getBindingContext("$this");var n1=this.getConditions();var o1=m1.getPath();var p1=o1.match(/^.*\/(\d+)\/$/);var q1;if(p1){q1=parseInt(p1[1]);}if(q1>0&&n1.length-1===q1){this._bFocusLastRemoveBtn=true;}var r1=this.byId("conditions");var s1=r1.getContent();var t1=0;for(var i=0;i<s1.length&&t1<=q1;i++){var u1=s1[i];if(t1===q1&&u1 instanceof f&&u1.hasOwnProperty("_iValueIndex")){if(u1._bParseError){u1.setValue(null);}}if(u1 instanceof r&&u1.getId().endsWith("-removeBtnLarge")){t1++;}}n1.splice(q1,1);this.setProperty("conditions",n1,true);l1.call(this,undefined);this.fireConditionProcessed();},
addCondition:function(i){var j=this.getConditions();var n=this.getFormatOptions();var m1=n.maxConditions;if(m1===-1||j.length<m1){this.addDummyCondition(j.length+1);if(this.getConditions().length===m1){this._bFocusLastCondition=true;}}},
addDummyCondition:function(i){var j=A.call(this);var n=z.call(this);var m1=n.name;var n1=a.createCondition(m1,n.valueDefaults?n.valueDefaults:[],undefined,undefined,e.NotValidated);if(n.valueTypes[0]&&n.valueTypes[0]!==O.ValueType.Static){n1.isInitial=true;}F.updateConditionValues(n1);F.checkConditionsEmpty(n1,j);var o1=this.getConditions();if(i!==undefined){o1.splice(i,0,n1);}else{o1.push(n1);}this.setProperty("conditions",o1,true);if(!n1.isInitial){this.fireConditionProcessed();}},
updateDefineConditions:function(){var i=this.getConditions().filter(function(j){var n=F.getOperator(j.operator);return j.validated!==e.Validated||n.exclude;});W.call(this,i,true,false);if(i.length===0){this.addDummyCondition();}},
onChange:function(i){var j=A.call(this);var n=this.getConditions();F.checkConditionsEmpty(n,j);F.updateConditionsValues(n,j);if(i){n.forEach(function(m1){if(!m1.isEmpty){delete m1.isInitial;}});}this.setProperty("conditions",n,true);},
onSelectChange:function(i){var j=i.getSource();var n=j.getBindingContext("$this").getObject();var m1=this.getConditions();var n1=F.indexOfCondition(n,m1);if(n1>=0){n=m1[n1];}if(!i.getParameter("valid")){n.invalid=true;this.setProperty("conditions",m1,true);j._sOldKey=j.getValue();l1.call(this,true);return;}var o1=j.getValue();var p1=j._sOldKey;var q1=F.getOperator(o1);var r1=p1&&F.getOperator(p1);if(q1&&r1){var s1=false;if(!d(q1.valueTypes[0],r1.valueTypes[0])&&q1.valueTypes[0]!==O.ValueType.Static){if(n1>=0){n.values.forEach(function(t1,u1){if(t1!==null){if((q1.valueTypes[u1]===O.ValueType.Self&&r1.valueTypes[u1]===O.ValueType.SelfNoParse)||(q1.valueTypes[u1]===O.ValueType.SelfNoParse&&r1.valueTypes[u1]===O.ValueType.Self)){var v1=x.call(this,q1.name,u1);var w1=x.call(this,r1.name,u1);var x1=w1.formatValue(n.values[u1],"string");var y1=v1.parseValue(x1,"string");if(y1!==n.values[u1]){n.values[u1]=v1.parseValue(x1,"string");s1=true;}}else{n.values[u1]=null;s1=true;}}}.bind(this));}}if(n1>=0&&q1.valueDefaults){n.values.forEach(function(t1,u1){if((n.isInitial&&t1!==q1.valueDefaults[u1])||(t1===null)){n.values[u1]=q1.valueDefaults[u1];n.isInitial=true;s1=true;}});}if(!q1.valueTypes[1]&&r1.valueTypes[1]){if(n1>=0){if(n.values.length>1&&n.values[1]){n.values=n.values.slice(0,1);s1=true;}}}if(n.invalid){delete n.invalid;s1=true;}if(s1){F.checkConditionsEmpty(n,A.call(this));this.setProperty("conditions",m1,true);l1.call(this,false);}}delete j._sOldKey;},
onPaste:function(n){var m1;var n1=n.srcControl;var o1=this.getFormatOptions();var p1=o1.hasOwnProperty("maxConditions")?o1.maxConditions:-1;var q1=n1.getBindingContext("$condition").getPath();var r1=parseInt(q1.split("/")[2]);if(window.clipboardData){m1=window.clipboardData.getData("Text");}else{m1=n.originalEvent.clipboardData.getData('text/plain');}var s1=m1.split(/\r\n|\r|\n/g);if(s1&&s1.length>1){setTimeout(function(){var o1=m({},this.getFormatOptions());delete o1.fieldHelpID;delete o1.conditionModelName;o1.maxConditions=1;o1.display=c.Value;var t1=new b(o1);var u1=s1.length;var v1=this.getConditions();for(var i=0;i<u1;i++){if(s1[i]){var w1=s1[i].trim();var x1=w1.split(/\t/g);if(x1.length==2&&x1[0]&&x1[1]){var y1=F.getOperator("BT");w1=y1.tokenFormat;for(var j=0;j<2;j++){w1=w1.replace(new RegExp("\\{"+j+"\\}","g"),x1[j]);}}try{var z1=t1.parseValue(w1,"string");t1.validateValue(z1);if(v1.length>r1){v1.splice(r1,1,z1);}else{v1.push(z1);}r1++;}catch(A1){s.error("Paste handling","the pasted value '"+w1+"' could not be handled! "+A1.message);}}}if(p1>=0&&v1.length>p1){v1.splice(p1,v1.length-p1);}if(n1.setDOMValue){n1.setDOMValue("");}F.checkConditionsEmpty(v1);this.setProperty("conditions",v1,true);this.fireConditionProcessed();}.bind(this),0);}},
cleanUp:function(){var j=this.byId("conditions");var n=j.getContent();for(var i=0;i<n.length;i++){var m1=n[i];if(m1 instanceof f&&m1.hasOwnProperty("_iValueIndex")){if(m1._bParseError){m1.setValue();}}}this.setProperty("inputOK",true,true);}
});
function _(i){if(i.name==="value"){v.call(this,i.object,i.current,i.old);}if(i.name==="formatOptions"){var j=this.getConditions();var n=i.current&&i.current.operators;var m1=i.old&&i.old.operators;var n1=false;if(!d(n,m1)){n1=true;K.call(this);}var o1=i.current&&i.current.valueType&&i.current.valueType.getMetadata().getName();var p1=i.old&&i.old.valueType&&i.old.valueType.getMetadata().getName();if(o1!==p1&&j.length>0){if(!n1){K.call(this);}this._bUpdateType=true;$.call(this);this._bUpdateType=false;W.call(this,j,true,true);}}if(i.name==="conditions"){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this.updateDefineConditions();$.call(this);}.bind(this),0);}}
function v(j,n,m1){j._sOldKey=m1;var n1=0;if(n&&m1){var o1=F.getOperator(n);var p1=F.getOperator(m1);var q1=j.getParent();var r1;var s1;n1=q1.indexOfContent(j);r1=q1.getContent()[n1+2];if(r1&&r1.hasOwnProperty("_iValueIndex")&&r1._iValueIndex===0){if(r1 instanceof f&&!r1._bParseError){r1.setValueState(V.None);r1.setValueStateText();}s1=q1.getContent()[n1+3];if(s1&&s1.hasOwnProperty("_iValueIndex")&&s1._iValueIndex===1){if(s1 instanceof f&&!s1._bParseError){s1.setValueState(V.None);s1.setValueStateText();}}else{s1=undefined;}}else{r1=undefined;}if(o1.createControl||p1.createControl){if(r1){r1.destroy();}if(s1){s1.destroy();}}else{if(r1&&o1.valueTypes[0]!==p1.valueTypes[0]){r1.unbindProperty("value");}if(s1&&o1.valueTypes[1]!==p1.valueTypes[1]&&p1.valueTypes[1]){s1.unbindProperty("value");}}}if(!n){var t1=j.getBindingContext("$this").getObject();if(t1){var u1=this.getConditions();n1=F.indexOfCondition(t1,u1);if(n1>=0){t1=u1[n1];t1.operator=m1;this.setProperty("conditions",u1,true);}}}var v1=this.oOperatorModel.getData();var w1;for(var i=0;i<v1.length;i++){var x1=v1[i];if(x1.key===n){w1=x1.text;break;}}j.setAdditionalValue(w1);this.onChange();}
function w(i,j,n,m1){var n1=F.getOperator(i.operator);if(!n1||!n1.valueTypes[j]){return null;}var o1=x.call(this,n1.name,j);var p1=this._oManagedObjectModel.getContext(m1.getPath()+"values/"+j+"/");var q1;if(n1.createControl){q1=n1.createControl(o1,"$this>",j,n);}if(!q1){q1=new f(n,{delegate:U.call(this),value:{path:"$this>",type:o1,mode:'TwoWay',targetType:'raw'},editMode:{parts:[{path:"$condition>operator"},{path:"$condition>invalid"}],formatter:c1},width:"100%"});}if(q1.getMetadata().hasProperty("placeholder")){if(j===0){q1.bindProperty("placeholder",{path:"$condition>operator",formatter:g1});}else{q1.bindProperty("placeholder",{path:"$condition>operator",formatter:h1});}}q1._iValueIndex=j;if(q1.attachChange){q1.attachChange(this.onChange.bind(this));}q1.onpaste=this.onPaste.bind(this);q1.setLayoutData(new o({span:{path:"$condition>",formatter:f1.bind(this)}}));q1.setBindingContext(p1,"$this");q1.setBindingContext(m1,"$condition");q1.setFieldGroupIds([m1.getPath()]);return q1;}
function x(i,j){var n=N.call(this);var m1=F.getOperator(i);if(m1.valueTypes[j]&&[O.ValueType.Self,O.ValueType.Static].indexOf(m1.valueTypes[j])===-1){n=m1._createLocalType(m1.valueTypes[j],n);}var n1=false;if(m1.valueTypes[j]===O.ValueType.Static){n1=true;n=Q.call(this);}var o1=n1?B.String:T.call(this,n);var p1;switch(o1){case B.Numeric:var q1=n.getFormatOptions();if(q1&&q1.hasOwnProperty("emptyString")&&q1.emptyString===null){p1=n;}else{p1=y(n,{emptyString:null});}break;case B.Date:case B.Time:case B.DateTime:p1=n;break;default:if(n.getConstraints()&&n.getConstraints().hasOwnProperty("nullable")&&n.getConstraints().nullable===false){p1=y(n);if(n._bCreatedByOperator){p1=m1._createLocalType(m1.valueTypes[j],n);}}else{p1=n;}break;}return p1;}
function y(i,n,j){var m1=sap.ui.require(i.getMetadata().getName().replace(/\./g,"/"));var n1=m(i.getFormatOptions(),n||{});var o1=m(i.getConstraints(),j||{});if(o1.hasOwnProperty("nullable")&&o1.nullable===false){o1.nullable=true;}return new m1(n1,o1);}
function z(){var j=A.call(this);var n;var m1=this.getFormatOptions().defaultOperatorName;if(m1){n=F.getOperator(m1);}else{var n1=N.call(this);var o1=T.call(this,n1);n=F.getDefaultOperator(o1);}if(n&&j.indexOf(n.name)<0){for(var i=0;i<j.length;i++){n=F.getOperator(j[i]);if(!n||n.exclude||!n.hasRequiredValues()){n=undefined;}else{break;}}}if(!n){n=F.getOperator(j[0]);}return n;}
function A(){var i=this.getFormatOptions();var j=i&&i.operators;if(!j||j.length===0){j=F.getOperatorsForType(B.String);}return j;}
function H(){var j;var n=A.call(this);for(var i=0;i<n.length;i++){var m1=n[i];var n1=F.getOperator(m1);if(!j){j=n1.group.id;}else if(j!==n1.group.id){return true;}}return false;}
function K(){if(!this.oOperatorModel){return;}var j=N.call(this);var n=A.call(this);var m1=[];var n1=H.call(this);var o1=this.getId()+"--rowSelect-help";var p1=sap.ui.getCore().byId(o1);var q1;if(n1){q1=new g({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"});}else{q1=new l({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"});}p1.bindAggregation("items",{path:'om>/',templateShareable:false,template:q1});for(var i=0;i<n.length;i++){var r1=n[i];var s1=F.getOperator(r1);if(!s1||(s1.showInSuggest!==undefined&&s1.showInSuggest==false)){continue;}var t1=s1.textKey||"operators."+s1.name+".longText";var u1=s1.getTypeText(t1,T.call(this,j).toLowerCase());if(u1===t1){u1=s1.longText;}var v1=s1.additionalInfo;if(v1===undefined){if(v1!==""&&s1.formatRange){v1=s1.formatRange(s1._getRange(undefined,j),j);}else if(!n1){v1=s1.group.text;}}m1.push({key:s1.name,text:u1,additionalText:v1,groupId:s1.group.id,groupText:s1.group.text});}this.oOperatorModel.setData(m1);}
function N(){var i=this.getFormatOptions();var j=i&&i.valueType;if(!j){j=Q.call(this);}return j;}
function Q(){if(!this._oDefaultType){this._oDefaultType=new S();}return this._oDefaultType;}
function T(i){var j=i.getMetadata().getName();var n=i.getFormatOptions();var m1=i.getConstraints();var n1=this.getFormatOptions().delegate;var o1=this.getFormatOptions().payload;var p1=n1?n1.getTypeUtil(o1).getBaseType(j,n,m1):B.String;if(p1===B.Unit){p1=B.Numeric;}return p1;}
function U(){var i=this.getFormatOptions();var n=i.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";var j=i.payload;return{name:n,payload:j};}
function W(j,n,m1){var n1=N.call(this);var o1=[];var i=0;for(i=0;i<j.length;i++){var p1=j[i];var q1=F.getOperator(p1.operator);if(q1&&q1.valueTypes[0]===O.ValueType.Static&&(p1.values.length===0||m1)){if(q1.getStaticText){var r1=q1.getStaticText(n1);if(p1.values.length>0){p1.values[0]=r1;}else{p1.values.push(r1);}o1.push(i);}}}if(o1.length>0){this.setProperty("conditions",j,true);}}
function X(){var i=new I(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});var j=new P({headerText:"{$this>/label}",expanded:true,height:"100%",backgroundDesign:"Transparent"}).addStyleClass("sapMdcDefineconditionPanel");j.addDependent(new L(this.getId()+"--rowSelect-help",{filterList:false,useFirstMatch:true}));var n=new G(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");b1.call(this,undefined,n,0,null,0);j.addContent(i);j.addContent(n);var m1=new r(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:u.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new o({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{path:"$this>/conditions",formatter:Y.bind(this)},visibleM:{path:"$this>/conditions",formatter:Y.bind(this)},visibleL:{path:"$this>/conditions",formatter:Y.bind(this)},visibleXL:{path:"$this>/conditions",formatter:Y.bind(this)}})});n.addContent(m1);n.attachValidateFieldGroup(j1,this);this.setAggregation("_content",j);}
function Y(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;return n===-1||i.length<n;}
function Z(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;return n!==1;}
function $(){var j=this.getConditions();var n=this.byId("conditions");var m1;var n1=-1;var o1=0;for(var i=0;i<j.length;i++){var p1=j[i];var q1=F.getOperator(p1.operator);if(p1.validated!==e.Validated||q1.exclude){var r1=this._oManagedObjectModel.getContext("/conditions/"+i+"/");n1++;if(!this.oOperatorModel){this.oOperatorModel=new J();this.setModel(this.oOperatorModel,"om");K.call(this);}m1=n.getContent();if(m1[o1]&&m1[o1].isA("sap.ui.mdc.Field")){o1=i1.call(this,p1,n,o1,r1,n1);}else{o1=b1.call(this,p1,n,o1,r1,n1);}}}m1=n.getContent();while(m1[o1]&&m1[o1]!==this.byId("addBtn")){m1[o1].destroy();o1++;}if(this._bFocusLastCondition){m1[0].focus();this._bFocusLastCondition=false;}if(this._bFocusLastRemoveBtn){o1=a1.call(this,["-removeBtnLarge","-removeBtnSmall"]);m1[o1].focus();this._bFocusLastRemoveBtn=false;}}
function a1(j){var m1=this.byId("conditions");var n1=m1.getContent();var n=n1.length-1;if(!Array.isArray(j)){j=[j];}var i=0;var o1=j[i];while(n>=0&&o1!==undefined){var p1=n1[n];if(p1.getId().endsWith(o1)){var q1=jQuery(p1.getDomRef());if(q1.is(":visible")){return n;}else{i++;o1=j[i];}}n--;}return 0;}
function b1(j,n,m1,n1,o1){var p1=this.getId()+"--"+o1;if(!this._oOperatorFieldType){this._oOperatorFieldType=new S({},{minLength:1});}var q1=new f(p1+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:"Description",fieldHelp:this.getId()+"--rowSelect-help",change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new o({span:{path:"$this>/conditions",formatter:e1.bind(this)},linebreak:true})).setBindingContext(n1,"$this");if(n1){q1.setFieldGroupIds([n1.getPath()]);}this._oObserver.observe(q1,{properties:["value"]});n.insertContent(q1,m1);m1++;var r1=new r(p1+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:u.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new o({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:d1},visibleS:{path:"$this>/conditions",formatter:Z.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n1,"$this");if(n1){r1.setFieldGroupIds([n1.getPath()]);}n.insertContent(r1,m1);m1++;if(j){for(var i=0;i<j.values.length;i++){var s1=w.call(this,j,i,p1+"-values"+i,n1);if(s1){n.insertContent(s1,m1);m1++;}}}var t1=new r(p1+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:u.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new o({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:d1},visibleS:false,visibleM:{path:"$this>/conditions",formatter:Z.bind(this)},visibleL:{path:"$this>/conditions",formatter:Z.bind(this)},visibleXL:{path:"$this>/conditions",formatter:Z.bind(this)}})).setBindingContext(n1,"$this");n.insertContent(t1,m1);m1++;return m1;}
function c1(i,j){if(!i){return E.Display;}else if(j){return E.ReadOnly;}var n=F.getOperator(i);var m1=false;if(n&&n.valueTypes[0]===O.ValueType.Static){m1=true;}return m1?E.Display:E.Editable;}
function d1(i){var j=i&&F.getOperator(i);if(!j||!j.valueTypes[0]||(j.valueTypes[0]===O.ValueType.Static&&!j.getStaticText)){return"XL8 L8 M8 S0";}else{return"";}}
function e1(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;var m1="XL3 L3 M3 ";if(n===1){m1+="S12";}else{m1+="S10";}return m1;}
function f1(i){var j=this.getFormatOptions();var n=j.hasOwnProperty("maxConditions")?j.maxConditions:-1;var m1=i&&F.getOperator(i.operator);var n1="";if(m1&&m1.valueTypes[1]){n1="XL4 L4 M4 ";}else{n1="XL8 L8 M8 ";}if(n===1){n1+="S12";}else{n1+="S10";}return n1;}
function g1(i){var j=i&&F.getOperator(i);if(j&&j.aLabels){return j.aLabels[0];}else if(j&&j.valueTypes[1]){return t.getText("valuehelp.DEFINECONDITIONS_FROM");}else{return t.getText("valuehelp.DEFINECONDITIONS_VALUE");}}
function h1(i){var j=i&&F.getOperator(i);if(j&&j.aLabels){return j.aLabels[1];}else if(j&&j.valueTypes[1]){return t.getText("valuehelp.DEFINECONDITIONS_TO");}}
function i1(j,n,m1,n1,o1){var p1=this.getId()+"--"+o1;var q1=n.getContent();var r1;var s1=q1[m1];s1.setBindingContext(n1,"$this");if(n1){s1.setFieldGroupIds([n1.getPath()]);}if(s1.getValueState()===V.Error&&!j.invalid){s1.setValue(s1.getValue());}m1++;var t1=q1[m1];t1.setBindingContext(n1,"$this");if(n1){t1.setFieldGroupIds([n1.getPath()]);}m1++;var u1;var v1=q1[m1];var w1;if(v1.hasOwnProperty("_iValueIndex")&&v1._iValueIndex===0){if(j.values.length>0){u1=this._oManagedObjectModel.getContext(n1.getPath()+"values/0/");v1.setBindingContext(u1,"$this");v1.setBindingContext(n1,"$condition");if(v1.getMetadata().hasProperty("value")&&(this._bUpdateType||!v1.getBindingInfo("value"))){r1=x.call(this,j.operator,0);v1.bindProperty("value",{path:"$this>",type:r1});}m1++;w1=q1[m1];if(w1.hasOwnProperty("_iValueIndex")&&w1._iValueIndex===1){if(j.values.length>1){u1=this._oManagedObjectModel.getContext(n1.getPath()+"values/1/");w1.setBindingContext(u1,"$this");if(w1.getMetadata().hasProperty("value")&&(this._bUpdateType||!w1.getBindingInfo("value"))){r1=x.call(this,j.operator,1);w1.bindProperty("value",{path:"$this>",type:r1});}m1++;}else{w1.destroy();}}else if(j.values.length>1){w1=w.call(this,j,1,p1+"-values1",n1);if(w1){n.insertContent(w1,m1);m1++;}}}else{v1.destroy();v1=undefined;w1=q1[m1+1];if(w1&&w1.hasOwnProperty("_iValueIndex")&&w1._iValueIndex===1){w1.destroy();}}}else if(j.values.length>0){for(var i=0;i<j.values.length;i++){var x1=w.call(this,j,i,p1+"-values"+i,n1);if(x1){n.insertContent(x1,m1);m1++;}}}q1=n.getContent();var y1=q1[m1];y1.setBindingContext(n1,"$this");m1++;return m1;}
function j1(i){var j=i.getSource();while(!(j.getParent()instanceof G)){j=j.getParent();}k1.call(this,j);}
function k1(i){var j=i.getParent();var n=j.indexOfContent(i);var m1;if(i.getId().endsWith("-operator")){m1=i.getBindingContext("$this");n=n+2;i=j.getContent()[n];}else if(i.getId().endsWith("-removeBtnSmall")){m1=i.getBindingContext("$this");n=n+1;i=j.getContent()[n];}else{m1=i.getBindingContext("$condition");}var n1;var o1=m1.getObject();var p1=F.getOperator(o1.operator);var q1=!!o1.invalid;if(!q1&&p1.valueTypes.length>0&&p1.valueTypes[0]!==O.ValueType.Static){if(p1.valueTypes.length>1&&p1.valueTypes[1]){if(i.hasOwnProperty("_iValueIndex")&&i._iValueIndex===0){n1=j.getContent()[n+1];}else if(i.hasOwnProperty("_iValueIndex")&&i._iValueIndex===1){n1=j.getContent()[n-1];}}if(i.getMetadata().getAllProperties().valueState&&!i._bParseError&&(!n1||!n1._bParseError)){var r1=i.getBinding("value").getType();try{p1.validate(o1.values,r1);i.setValueState(V.None);i.setValueStateText();if(n1&&n1.getMetadata().getAllProperties().valueState){n1.setValueState(V.None);n1.setValueStateText();}}catch(s1){q1=true;i.setValueState(V.Error);i.setValueStateText(s1.message);if(n1&&n1.getMetadata().getAllProperties().valueState){n1.setValueState(V.Error);n1.setValueStateText(s1.message);}}}}l1.call(this,q1);this.fireConditionProcessed();}
function l1(j){var i=0;if(j!==true){var n=this.getConditions();for(i=0;i<n.length;i++){if(n[i].invalid){j=true;break;}}}if(j!==true){var m1=this.byId("conditions");var n1=m1.getContent();j=false;for(i=0;i<n1.length;i++){var o1=n1[i];if(o1.hasOwnProperty("_iValueIndex")&&o1.getValueState&&o1.getValueState()===V.Error){j=true;break;}}}this.setProperty("inputOK",!j,true);}
return D;});
sap.ui.predefine('sap/ui/mdc/field/DynamicDateRangeConditionsType',['sap/ui/mdc/field/ConditionsType','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/condition/Condition','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/enum/BaseType',"sap/ui/mdc/util/DateUtil",'sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/m/DynamicDate','sap/m/library'],function(C,F,O,a,b,B,D,S,c,P,V,d,l){"use strict";
var e=C.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(o,i){S.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");}});
e.prototype.destroy=function(){S.prototype.destroy.apply(this,arguments);this._bDestroyed=true;};
e.prototype.formatValue=function(n,I){if(n==undefined||n==null||this._bDestroyed){return null;}if(!Array.isArray(n)){throw new c("No valid conditions provided");}var M=j.call(this);var r;if(M!==1){throw new c("MaxConditions must be 1");}if(n.length===1){var o=n[0];var p=F.getOperator(o.operator);if(!o.operator||!p){throw new c("No valid condition provided, Operator wrong.");}var v=[];var s=p.name;if(!l.StandardDynamicDateRangeKeys[s]){s=p.alias||s;}for(var i=0;i<p.valueTypes.length;i++){if(l.StandardDynamicDateRangeKeys[s]&&p.valueTypes[i]===O.ValueType.Self){v.push(f.call(this,o.values[i]));}else if(p.valueTypes[i]&&p.valueTypes[i]!==O.ValueType.Static){v.push(o.values[i]);}}var q=_.call(this,p);r=q.formatValue({operator:s,values:v},I);}return r;};
function _(o){if(!this._oDynamicDateType){var i={date:{source:{pattern:"timestamp"}},"int":{}};this._oDynamicDateType=new d(i);}return this._oDynamicDateType;}
function f(v){var t=h.call(this);var s=t.formatValue(v,"string");var i=s.split("-");var y=parseInt(i[0]);var M=parseInt(i[1])-1;var n=parseInt(i[2]);var T=new Date(y,M,n).getTime();return T;}
function g(t){var T=h.call(this);var o=new Date(t);var y=o.getFullYear();var M=o.getMonth()+1;var i=o.getDate();var s=y.toString()+"-"+((M<10)?"0":"")+M.toString()+"-"+((i<10)?"0":"")+i.toString();var v=T.parseValue(s,"string");return v;}
function h(){if(!this._oInternalType){var t=k.call(this);this._oInternalType=D.createInternalType(t,"yyyy-MM-dd");}return this._oInternalType;}
e.prototype.parseValue=function(v,I){if(this._bDestroyed){return null;}if(j.call(this)!==1){throw new P("Only one condition supported for parsing");}var o=m.call(this);var n=[];if(v&&v.operator){if(v.operator==="PARSEERROR"){throw new P(v.values[0]);}var s=v.operator;var p=F.getOperator(s);s=p.name;if(p){var q=_.call(this,p);var r=q.parseValue(v,I);var t=[];for(var i=0;i<p.valueTypes.length;i++){if(l.StandardDynamicDateRangeKeys[v.operator]&&p.valueTypes[i]===O.ValueType.Self){t.push(g.call(this,r.values[i]));}else if(p.valueTypes[i]&&p.valueTypes[i]!==O.ValueType.Static){t.push(r.values[i]);}}var u=a.createCondition(p.name,t,undefined,undefined,b.NotValidated);F.updateConditionValues(u);F.checkConditionsEmpty(u,o);n.push(u);}}return n;};
e.prototype.validateValue=function(n){if(n===undefined||n===null||this._bDestroyed){return;}if(!Array.isArray(n)){throw new V("No valid conditions provided");}var t=k.call(this);var o=m.call(this);for(var i=0;i<n.length;i++){var p=n[i];if(typeof p!=="object"||!p.operator||!p.values||!Array.isArray(p.values)){throw new V(this._oResourceBundle.getText("field.VALUE_NOT_VALID"));}var q=F.getOperator(p.operator,o);if(!q){throw new V("No valid condition provided, Operator wrong.");}q.validate(p.values,t);}};
function j(){var M=1;if(this.oFormatOptions.hasOwnProperty("maxConditions")){M=this.oFormatOptions.maxConditions;}return M;}
function k(){var t=this.oFormatOptions.valueType;if(!t){throw new Error("Type missing");}return t;}
function m(){var o=this.oFormatOptions.operators;if(!o||o.length===0){o=F.getOperatorsForType(B.Date);}return o;}
return e;});
sap.ui.predefine('sap/ui/mdc/field/FieldBase',['sap/ui/thirdparty/jquery','sap/ui/Device','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/field/FieldBaseRenderer','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Condition','sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType','sap/ui/mdc/enum/BaseType','sap/ui/mdc/field/content/ContentFactory','sap/ui/mdc/Control','sap/ui/core/library','sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/ui/dom/containsOrEquals','sap/ui/model/Filter','sap/ui/model/BindingMode','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/ui/base/SyncPromise','sap/base/util/restricted/_debounce','sap/ui/events/KeyCodes'],function(q,D,E,F,C,a,b,c,d,e,B,f,g,h,L,M,k,m,l,n,o,p,r,P,V,s,t,S,u,K){"use strict";var v=h.ValueState;var T=h.TextAlign;var w=h.TextDirection;
var x=g.extend("sap.ui.mdc.field.FieldBase",{
metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent"],designtime:"sap/ui/mdc/designtime/field/FieldBase.designtime",library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:'sap.ui.model.type.String'},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enum.EditMode",group:"Data",defaultValue:E.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enum.FieldDisplay",defaultValue:F.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:w.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:v.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_fieldHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},
renderer:a,
_oManagedObjectModel:null
});
M.call(x.prototype);var y={onsapprevious:e1,onsapnext:e1,onsapup:e1,onsapdown:e1,onsapbackspace:e1};var z={onsapenter:I};var A;
x._init=function(){if(A&&A.bool&&A.bool.control){A.bool.control.destroy();}if(A&&A.defineConditions&&A.defineConditions.control){A.defineConditions.control.destroy();}A={bool:{name:"sap/ui/mdc/field/BoolFieldHelp",id:"BoolDefaultHelp",getDelegate:"getDefaultFieldHelpBaseDelegate",properties:{},control:undefined},defineConditions:{name:"sap/ui/mdc/field/FieldValueHelp",id:"Field-DefineConditions-Help",getDelegate:"getDefaultFieldValueHelpDelegate",properties:{showConditionPanel:true},control:undefined}};};
x._init();
x.prototype.init=function(){g.prototype.init.apply(this,arguments);this._oManagedObjectModel=new s(this);this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","ariaLabelledBy"]});this._oDatePickerRequested={};this.attachEvent("modelContextChange",this._handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=new f(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:w1.bind(this),handleContentChange:q1.bind(this),handleContentLiveChange:t1.bind(this),handleValueHelpRequest:B1.bind(this),handleEnter:I.bind(this),handleContentPress:v1.bind(this)});this._oCreateContentPromise=undefined;this._sFilterValue="";};
x.prototype.exit=function(){var i=this.getFieldInfo();if(i){i.detachEvent("dataUpdate",L1,this);}var j=this.getContent();if(j){$.call(this,j);}var S1=this.getContentEdit();if(S1){$.call(this,S1);}var T1=this.getContentDisplay();if(T1){$.call(this,T1);}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;var U1=z1.call(this);if(U1){U1.detachEvent("dataUpdate",G1,this);if(this._bConnected){H1.call(this);U1.connect();}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined;}u1.call(this);delete this._fnLiveChangeTimer;};
x.prototype.applySettings=function(){g.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate();}return this;};
x.prototype.setProperty=function(i,j,S1){if(i==="editMode"){var T1=this.getEditMode();if(T1!==E.Display&&T1!==E.EditableDisplay&&j!==E.Display&&j!==E.EditableDisplay){S1=true;}}else if(i!=="width"&&i!=="multipleLines"&&i!=="showEmptyIndicator"){S1=true;}return g.prototype.setProperty.apply(this,[i,j,S1]);};
x.prototype.onBeforeRendering=function(){a1.call(this);};
x.prototype.onAfterRendering=function(){};
x.prototype.onfocusin=function(i){I1.call(this);};
x.prototype.onsapfocusleave=function(i){u1.call(this);};
function _(i){var j=i.indexOf(this.getId());if(j>-1){if(this._bPendingChange){var S1=document.activeElement;var T1=z1.call(this);if(!(S1&&T1&&n(T1.getDomRef(),S1))){var U1=N1.call(this);if(U1){H.call(this,undefined,undefined,undefined,U1);}else{H.call(this,this.getConditions(),!this._bParseError);}}}if(i.length>1){i.splice(j,1);this.fireValidateFieldGroup({fieldGroupIds:i});}}}
x.prototype.onsapup=function(i){if(this.getEditMode()===E.Editable){var j=z1.call(this);var S1=i.srcControl;if(j&&(!j.valueHelpEnabled||j.valueHelpEnabled()||j.isOpen())&&(!this._oContentFactory.isMeasure()||S1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.setFilterValue(this._sFilterValue);j.navigate(-1);}}};
x.prototype.onsapdown=function(i){if(this.getEditMode()===E.Editable){var j=z1.call(this);var S1=i.srcControl;if(j&&(!j.valueHelpEnabled||j.valueHelpEnabled()||j.isOpen())&&(!this._oContentFactory.isMeasure()||S1.getShowValueHelp())){i.preventDefault();i.stopPropagation();j.setFilterValue(this._sFilterValue);j.navigate(1);}}};
x.prototype.onsapenter=function(i){var j=z1.call(this);if(j&&j.isOpen(true)){j.close();}this._sFilterValue="";};
x.prototype.onsapescape=function(i){this.onsapenter(i);};
x.prototype.ontap=function(i){var j=z1.call(this);if(j){if(j.shouldOpenOnClick()&&!j.isOpen(true)){j.open(true);}var S1=i.srcControl;if(j.isOpen(true)&&(!this._oContentFactory.isMeasure()||(S1.getShowValueHelp&&S1.getShowValueHelp()))){S1.addStyleClass("sapMFocus");j.removeFocus();}}};
x.prototype.clone=function(i,j){this.detachEvent("modelContextChange",this._handleModelContextChange,this);var S1=this.getContent();if(S1){$.call(this,S1);}var T1=this.getContentEdit();if(T1){$.call(this,T1);}var U1=this.getContentDisplay();if(U1){$.call(this,U1);}var V1=this.getFieldInfo();if(V1){V1.detachEvent("dataUpdate",L1,this);}var W1=g.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this._handleModelContextChange,this);if(S1){Z.call(this,S1);}if(T1){Z.call(this,T1);}if(U1){Z.call(this,U1);}if(V1){V1.attachEvent("dataUpdate",L1,this);}if(this._bTriggerable){W1._bTriggerable=this._bTriggerable;}return W1;};
x.prototype.getFieldPath=function(){var i=this.getBindingPath("conditions");if(i&&i.startsWith("/conditions/")){return i.slice(12);}else{return"";}};
function G(i,j,S1,T1){if(this._getContent().length>1){this._bPendingChange=true;}else{H.call(this,i,j,S1,T1);}}
function H(i,j,S1,T1){if(!T1){if(j){T1=Promise.resolve(this._getResultForPromise(i));}else{T1=Promise.reject(S1);}}this._fireChange(i,j,S1,T1);this._bPendingChange=false;}
x.prototype._fireChange=function(i,j,S1,T1){};
function I(i){var j=this.getEditMode();if(f._getEditable(j)&&(this.hasListeners("submit")||this._bPendingChange)){var S1=N1.call(this);var T1=false;if(S1){T1=true;}else if(this._bParseError){S1=Promise.reject();}else{S1=Promise.resolve(this._getResultForPromise(this.getConditions()));}if(this._bPendingChange){if(T1){H.call(this,undefined,undefined,undefined,S1);}else{H.call(this,this.getConditions(),!this._bParseError,undefined,S1);}}this.fireSubmit({promise:S1});}}
x.prototype._initDataType=function(){if(this._oContentFactory.getDataType()){this._oContentFactory.getDataType().destroy();this._oContentFactory.setDataType(undefined);}if(this._oContentFactory.getDateOriginalType()){if(this._oContentFactory.getDateOriginalType()._bCreatedByField){this._oContentFactory.getDateOriginalType().destroy();}this._oContentFactory.setDateOriginalType(undefined);}if(this._oContentFactory.getUnitOriginalType()){if(this._oContentFactory.getUnitOriginalType()._bCreatedByField){this._oContentFactory.getUnitOriginalType().destroy();}this._oContentFactory.getUnitOriginalType(undefined);}};
function J(){if(this._oContentFactory.getDataType()&&typeof this._oContentFactory.getDataType()==="object"){return this._oContentFactory.getDataType().getMetadata().getName();}else if(this.bDelegateInitialized){return this.getControlDelegate().getDataTypeClass(this.getPayload(),this.getDataType());}else{return this.getDataType();}}
function N(){var i=this._oContentFactory.getDataType();if(i&&typeof i==="object"&&i.getConstraints()){return i.getConstraints();}else{return this.getDataTypeConstraints();}}
function O(){var i=this._oContentFactory.getDataType();if(i&&typeof i==="object"&&i.getFormatOptions()){return i.getFormatOptions();}else{return this.getDataTypeFormatOptions();}}
x.prototype.getBaseType=function(){var i=J.call(this);var j=N.call(this);var S1=O.call(this);var T1=this.getTypeUtil().getBaseType(i,S1,j);return T1;};
function Q(i,j){var S1=z1.call(this);if(S1&&this._bConnected){A1.call(this,i,S1);}}
x.prototype._getContent=function(){var i=this.getContent();if(!i){if(this.getEditMode()===E.Display){i=this.getContentDisplay();}else{i=this.getContentEdit();}}if(i){return[i];}else{return this.getAggregation("_content",[]);}};
x.prototype._handleModelContextChange=function(i){};
function R(i){this.setValueState(v.Error);this.setValueStateText(i);}
x.prototype._removeUIMessage=function(){this.setValueState(v.None);this.setValueStateText();};
x.prototype._observeChanges=function(j){if(j.name==="dataType"){if(this._oContentFactory.getDataType()){var S1=function(V1){var W1=this.getTypeUtil().getDataTypeClass(j.current);if(!(this._oContentFactory.getDataType()instanceof W1)){this._initDataType();this.destroyAggregation("_content");this._oContentFactory.updateConditionType();}}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){S1.call(this,j.current);}.bind(this));return;}S1.call(this,j.current);}}if(j.name==="dataTypeFormatOptions"||j.name==="dataTypeConstraints"){if(this._oContentFactory.getDataType()){this._initDataType();this.destroyAggregation("_content");this._oContentFactory.updateConditionType();}}if(j.name==="maxConditions"){this._updateInternalContent();}if(j.name==="conditions"){this._bParseError=false;Q.call(this,j.current,j.old);var T1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var U1=this._aAsyncChanges[i];if(U1.waitForUpdate&&k(U1.result,j.current)){r1.call(this,U1);T1=true;break;}}if(T1){this._aAsyncChanges.splice(i,1);}if((j.current.length===0||j.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===E.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate();}}if(j.name==="display"){this._destroyInternalContent();this._oContentFactory.updateConditionType();}if(j.name==="fieldHelp"&&j.ids){x1.call(this,j.ids,j.mutation);this._oContentFactory.updateConditionType();}if(j.name==="fieldInfo"&&j.child){K1.call(this,j.child,j.mutation);}if(j.name==="content"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="contentEdit"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="contentDisplay"&&j.child){Y.call(this,j.child,j.mutation,j.name);}if(j.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this);}if(j.name==="ariaLabelledBy"&&j.ids){U.call(this,j.ids,j.mutation);}if(j.name==="editMode"){X.call(this);}};
x.prototype._updateInternalContent=function(){if(this.getAggregation("_content",[]).length>0){a1.call(this);this._oContentFactory.updateConditionType();}};
x.prototype.getFocusDomRef=function(){var i=this._getContent();if(i.length>0){return i[0].getFocusDomRef();}else{return this.getDomRef();}};
x.prototype.getIdForLabel=function(){var i;var j=this._getContent();if(j.length>0){i=j[0].getIdForLabel();}else{i=c1.call(this);}return i;};
x.prototype.getEditable=function(){return f._getEditable(this.getEditMode());};
x.prototype.getControlForSuggestion=function(){var i=this._getContent();if(i.length>0){if(this._oContentFactory.isMeasure()){return i[1];}else{return i[0];}}else{return this;}};
x.prototype.getFocusElementForValueHelp=function(j){var S1=this.getControlForSuggestion();var T1=S1&&S1.getMetadata().getAllPrivateAggregations()._endIcon&&S1.getAggregation("_endIcon",[]);var U1;for(var i=0;i<T1.length;i++){if(T1[i].getVisible()){U1=T1[i];break;}}return j||!U1?S1:U1;};
x.prototype.getMaxConditionsForHelp=function(){if(this._oContentFactory.isMeasure()){return 1;}else{return this.getMaxConditions();}};
x.prototype.getFormFormattedValue=function(){var i=this.getConditions();var j=this.getShowEmptyIndicator()&&i.length===0&&!this.getContent()&&!this.getContentDisplay();if(j){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m");}return this._oResourceBundleM.getText("EMPTY_INDICATOR");}else if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitOriginalType()){var S1=i.length>0?i[0].values[0]:[0,null];return this._oContentFactory.getUnitOriginalType().formatValue(S1,"string");}else if(this._oContentFactory.getDateOriginalType()){var T1=i.length>0?i[0].values[0]:null;return this._oContentFactory.getDateOriginalType().formatValue(T1,"string");}else{var U1=this._oContentFactory.getConditionsType();return U1.formatValue(i);}};
x.prototype.getFormValueProperty=function(){return"conditions";};
x.prototype.enhanceAccessibilityState=function(i,j){var S1=this.getParent();if(S1&&S1.enhanceAccessibilityState){S1.enhanceAccessibilityState(this,j);}};
x.prototype.getAccessibilityInfo=function(){var i=this._getContent();if(i.length>0&&i[0].getAccessibilityInfo){return i[0].getAccessibilityInfo();}else{return{};}};
function U(j,S1){var T1=this.getAggregation("_content",[]);var U1=this.getContent();if(U1){T1.push(U1);}U1=this.getContentDisplay();if(U1){T1.push(U1);}U1=this.getContentEdit();if(U1){T1.push(U1);}for(var i=0;i<T1.length;i++){U1=T1[i];if(U1.getMetadata().getAllAssociations().ariaLabelledBy){if(S1==="remove"){U1.removeAriaLabelledBy(j);}else if(S1==="insert"){U1.addAriaLabelledBy(j);}}}}
function W(i,j){var S1={aria:{}};var T1=z1.call(this);if(T1){var U1=T1.getAriaAttributes(this.getMaxConditionsForHelp());var V1=U1.roleDescription;S1["role"]=U1.role;if(V1){S1.aria["roledescription"]=V1;}S1.aria["haspopup"]=U1.ariaHasPopup;S1["autocomplete"]="off";if(i){S1.aria["expanded"]="true";S1.aria["controls"]=U1.contentId;if(j){S1.aria["activedescendant"]=j;}}else{S1.aria["expanded"]="false";}S1["valueHelpEnabled"]=U1.valueHelpEnabled;}this.setProperty("_ariaAttributes",S1,true);}
x.prototype.connectLabel=function(i){d1.call(this,i);i.bindProperty("text",{path:"$field>/label"});i.setLabelFor(this);return this;};
function X(){var j=L.getReferencingLabels(this);for(var i=0;i<j.length;i++){var S1=sap.ui.getCore().byId(j[i]);S1.invalidate();}}
function Y(i,j,S1){if(j==="remove"){$.call(this,i);g1.call(this,i);i1.call(this,i);if(this._oContentFactory.getContentConditionTypes()){delete this._oContentFactory.getContentConditionTypes()[S1];}i.setModel(null,"$field");}else if(j==="insert"){if(!i.isA("sap.ui.core.IFormContent")){throw new Error(i+" is not a valid content! Only use valid content in "+this);}f1.call(this,i,true);Z.call(this,i);h1.call(this,i,true);if(this.getAggregation("_content",[]).length>0){this._destroyInternalContent();}if(!this._oContentFactory.getContentConditionTypes()){this._oContentFactory.setContentConditionTypes({});}if(!this._oContentFactory.getContentConditionTypes()[S1]){this._oContentFactory.getContentConditionTypes()[S1]={};}var T1;var U1;for(U1 in i.getMetadata().getAllProperties()){if(i.getBindingPath(U1)==="/conditions"){T1=i.getBindingInfo(U1);if(T1&&T1.type&&T1.type instanceof e){this._oContentFactory.getContentConditionTypes()[S1].oConditionsType=T1.type;}this._oContentFactory.setBoundProperty(U1);}if(U1==="editable"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getEditable});}if(U1==="enabled"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getEnabled});}if(U1==="displayOnly"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/editMode",formatter:f._getDisplayOnly});}if(U1==="required"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/required"});}if(U1==="textAlign"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/textAlign"});}if(U1==="textDirection"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/textDirection"});}if(U1==="valueState"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/valueState"});}if(U1==="valueStateText"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/valueStateText"});}if(U1==="placeholder"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/placeholder"});}if(U1==="showValueHelp"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.bindProperty(U1,{path:"$field>/_fieldHelpEnabled"});}if(U1==="valueHelpIconSrc"&&!i.getBindingPath(U1)&&i.isPropertyInitial(U1)){i.setValueHelpIconSrc(this._getFieldHelpIcon());}}for(var V1 in i.getMetadata().getAllAggregations()){if(i.getBindingPath(V1)==="/conditions"){T1=i.getBindingInfo(V1);if(T1&&T1.template){for(U1 in T1.template.getMetadata().getAllProperties()){var W1=T1.template.getBindingInfo(U1);if(W1&&W1.type&&W1.type instanceof d){this._oContentFactory.getContentConditionTypes()[S1].oConditionType=W1.type;break;}}}}if(V1==="tooltip"&&!i.getBindingPath(V1)&&!i.getAggregation(V1)){i.bindProperty(V1,{path:"$field>/tooltip"});}}if(i.getMetadata().getAllAssociations().ariaLabelledBy){this._oContentFactory.setAriaLabelledBy(i);}}}
function Z(i){if(i.getMetadata().getEvents().change){i.attachEvent("change",q1,this);}if(i.getMetadata().getEvents().liveChange){i.attachEvent("liveChange",t1,this);}if(i.getMetadata().getEvents().press){i.attachEvent("press",v1,this);}if(i.getMetadata().getEvents().valueHelpRequest){i.attachEvent("valueHelpRequest",B1,this);}}
function $(i){if(i.getMetadata().getEvents().change){i.detachEvent("change",q1,this);}if(i.getMetadata().getEvents().liveChange){i.detachEvent("liveChange",t1,this);}if(i.getMetadata().getEvents().press){i.detachEvent("press",v1,this);}if(i.getMetadata().getEvents().valueHelpRequest){i.detachEvent("valueHelpRequest",B1,this);}}
function a1(){var i=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){a1.call(this);}.bind(this));}else{b1.call(this);}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(function(){i.call(this);}.bind(this));}else{i.call(this);}}
function b1(){var i=this.getEditMode();var j=this.getContent();this._oContentFactory._setUsedConditionType(j,i);y1.call(this,this.getFieldHelp());W.call(this,false);if(j||this._bIsBeingDestroyed||(i===E.Display&&this.getContentDisplay())||(i!==E.Display&&this.getContentEdit())){this._destroyInternalContent();var S1=this._getContent();if(S1.length===1){d1.call(this,S1[0]);}return;}var T1=this.getMaxConditions();var U1=this._getOperators();var V1;var W1=this.getAggregation("_content",[]);var X1;var Y1;var Z1=this.getMultipleLines();var $1=this._bTriggerable;var _1=this._oContentFactory.getContentType(this.getBaseType(),this.getMaxConditions(),$1);if(W1.length>0){X1=W1[0];Y1=X1.getMetadata().getName().replace(/\./g,"/");}var a2=this._oContentFactory.getContentMode(_1,i,T1,Z1,U1);var b2=_1.getControlNames(a2,U1[0]);V1=b2[0];if(V1!==Y1){this._oContentFactory.setHideOperator(m1.call(this,U1));if(X1){this._destroyInternalContent();if(X1.isA("sap.m.DateTimeField")){this._initDataType();}this._oContentFactory.updateConditionType();}if(l1.call(this,_1,U1,i,T1)){j1.call(this,_1.getUseDefaultFieldHelp().name);}else if(this._sDefaultFieldHelp){delete this._sDefaultFieldHelp;}var c2=c1.call(this);this._oCreateContentPromise=this._oContentFactory.createContent(_1,a2,c2);this._oCreateContentPromise.then(function(d2){for(var e2=0;e2<d2.length;e2++){var f2=d2[e2];f2.attachEvent("parseError",n1,this);f2.attachEvent("validationError",o1,this);f2.attachEvent("validationSuccess",p1,this);f1.call(this,f2,_1.getUseDefaultEnterHandler());h1.call(this,f2,false);d1.call(this,f2);if(this._bConnected&&((e2===0&&!this._oContentFactory.isMeasure())||(e2===1&&this._oContentFactory.isMeasure()))){J1.call(this,f2);}this.addAggregation("_content",f2);}X.call(this);}.bind(this));}}
function c1(){return this.getId()+"-inner";}
x.prototype._destroyInternalContent=function(){this.destroyAggregation("_content");if(this._oContentFactory.getDateOriginalType()){this._oContentFactory.setDataType(this._oContentFactory.getDateOriginalType());this._oContentFactory.setDateOriginalType(undefined);}else if(this._oContentFactory.getUnitOriginalType()){this._oContentFactory.setDataType(this._oContentFactory.getUnitOriginalType());this._oContentFactory.setUnitOriginalType(undefined);}if(this._bParseError){this._bParseError=false;this._removeUIMessage();}if(this._oContentFactory.isMeasure()){this._oContentFactory.setIsMeasure(false);}};
function d1(i){i.setModel(this._oManagedObjectModel,"$field");}
function e1(i){var j=false;var S1=z1.call(this);if(!S1){return;}else if(S1.isOpen()){j=true;}else{switch(i.type){case"sapprevious":case"sapup":if(i.keyCode===K.ARROW_UP){j=true;}break;case"sapnext":case"sapdown":if(i.keyCode===K.ARROW_DOWN){j=true;}break;default:break;}}if(j){i.stopPropagation();i.stopImmediatePropagation(true);switch(i.type){case"sapup":this.onsapup(i);break;case"sapdown":this.onsapdown(i);break;default:break;}}}
function f1(i,j){i.addDelegate(y,true,this);if(j){i.addDelegate(z,false,this);}}
function g1(i){i.removeDelegate(y);i.removeDelegate(z);}
function h1(i,j){if(j){i._OriginalGetFieldGroupIds=i._getFieldGroupIds;i._OriginalTriggerValidateFieldGroup=i.triggerValidateFieldGroup;}i._getFieldGroupIds=function(){var S1=this.getFieldGroupIds();var T1=this.getParent();if(T1){S1=S1.concat(T1._getFieldGroupIds());}return S1;};i.triggerValidateFieldGroup=function(S1){var T1=this.getParent();if(T1){var U1=S1.indexOf(T1.getId());if(U1>-1){_.call(T1,S1);}else{T1.fireValidateFieldGroup({fieldGroupIds:S1});}}};}
function i1(i){if(i._OriginalGetFieldGroupIds&&i._OriginalTriggerValidateFieldGroup){i._getFieldGroupIds=i._OriginalGetFieldGroupIds;delete i._OriginalGetFieldGroupIds;i.triggerValidateFieldGroup=i._OriginalTriggerValidateFieldGroup;delete i._OriginalTriggerValidateFieldGroup;}}
function j1(i){this.setProperty("_fieldHelpEnabled",true,true);this._sDefaultFieldHelp=A[i].id;var j=A[i].control;if(j&&j.bIsDestroyed){A[i].control=undefined;j=undefined;}if(!j){if(A[i].promise){A[i].promise.then(k1.bind(this,A[i].id));}var S1=sap.ui.require(A[i].name);if(!S1&&!A[i].promise){A[i].promise=new Promise(function(V1){A[i].resolve=V1;sap.ui.require([A[i].name],function(W1){j1.call(this,i);}.bind(this));}.bind(this)).then(k1.bind(this,A[i].id));}if(S1){var T1=this.bDelegateInitialized&&this.getControlDelegate()[A[i].getDelegate]();var U1=m({delegate:T1},A[i].properties);j=new S1(A[i].id,U1);j._bIsDefaultHelp=true;A[i].control=j;j.connect(this);if(A[i].resolve){A[i].resolve();delete A[i].resolve;}if(!A[i].promise){k1.call(this,A[i].id);}}}else{k1.call(this,A[i].id);}W.call(this,false);}
function k1(i){x1.call(this,i,"insert");}
function l1(i,j,S1,T1){var U1=i.getUseDefaultFieldHelp();if(U1&&!this.getFieldHelp()&&S1!==E.Display){if((T1===1&&U1.single)||(T1!==1&&U1.multi)){if(j.length===1){var V1=m1.call(this,j);if(T1===1){if(!(i.getEditOperator()&&i.getEditOperator()[j[0]])&&(U1.oneOperatorSingle||!V1)){return true;}}else if(U1.oneOperatorMulti||!V1){return true;}}else{return true;}}}return false;}
function m1(i){if(i.length===1){var j=b.getOperator(i[0]);return!j||j.isSingleValue();}else{return false;}}
function n1(i){this._bParseError=true;this._sFilterValue="";}
function o1(S1){this._bParseError=true;this._sFilterValue="";var T1=S1.getParameter("newValue");var U1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){var V1=this._aAsyncChanges[i];if(V1.waitForUpdate&&Array.isArray(V1.result)){if(V1.result.length===0&&T1===""){V1.reject(S1.getParameter("exception"));U1=true;}else{for(var j=0;j<V1.result.length;j++){var W1=V1.result[j];if(k(W1.values[0],T1)||(W1.operator==="BT"&&k(W1.values[1],T1))){V1.reject(S1.getParameter("exception"));U1=true;break;}}}if(U1){break;}}}if(U1){this._aAsyncChanges.splice(i,1);}}
function p1(i){this._bParseError=false;}
function q1(i){var j={parameters:m({},i.getParameters()),source:i.getSource()};var S1=this._aAsyncChanges.length;if(S1>0&&!this._aAsyncChanges[S1-1].changeFired){this._aAsyncChanges[S1-1].changeFired=true;this._aAsyncChanges[S1-1].changeEvent=j;G.call(this,undefined,undefined,undefined,this._aAsyncChanges[S1-1].promise);return;}var T1={changeEvent:j};r1.call(this,T1);}
function r1(i){var j=this.getConditions();var S1;var T1=true;var U1;var V1;var W1=i.changeEvent.source;var X1=false;var Y1=true;var Z1=false;if(i.changeEvent.parameters.hasOwnProperty("valid")){T1=i.changeEvent.parameters["valid"];if(!T1&&i.changeEvent.parameters.hasOwnProperty("value")){U1=i.changeEvent.parameters["value"];}}var $1=false;var _1=this._oContentFactory.getBoundProperty();var a2=_1&&W1.getBinding(_1);if(a2&&a2.getBindingMode()!==p.OneWay&&a2.getPath()==="/conditions"&&T1){V1=j[0];S1=j[0]&&j[0].values[0];}else if(i.changeEvent.parameters.hasOwnProperty("value")){S1=i.changeEvent.parameters["value"];if(T1){$1=true;}}else{V1=j[0];S1=j[0]&&j[0].values[0];}if($1){this._removeUIMessage();var b2;var c2;if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;W1.setDOMValue("");if(W1.getMetadata().hasProperty("value")){W1.setValue();}return;}V1=S.resolve().then(function(){var e2=this.getMaxConditions();if(this._oNavigateCondition){T1=true;return this._oNavigateCondition;}else if(S1===""&&e2!==1){return null;}else{b2=this._oContentFactory.getConditionType();var f2=b2.parseValue(S1);var g2=this._aAsyncChanges.length;if(g2>0&&!this._aAsyncChanges[g2-1].changeFired){c2=this._aAsyncChanges[g2-1];c2.changeFired=true;c2.changeEvent=i.changeEvent;G.call(this,undefined,undefined,undefined,c2.promise);}return f2;}}.bind(this)).then(function(V1){Y1=s1.call(this,V1,j,b2,T1,S1,W1,c2||i);Y1=Y1||Z1;return V1;}.bind(this)).catch(function(e2){if(e2&&!(e2 instanceof P)&&!(e2 instanceof r)&&!(e2 instanceof V)){throw e2;}T1=false;U1=S1;this._bParseError=true;this._sFilterValue="";R.call(this,e2.message);if(c2&&c2.reject){if(P1.call(this,c2)){c2.reject(e2);}}else if(X1){G.call(this,j,T1,U1);}}.bind(this)).unwrap();if(V1 instanceof Promise){X1=true;}}else if(!i.changeEvent.parameters.hasOwnProperty("valid")&&this._bParseError){U1=i.changeEvent.parameters["value"];T1=false;}var d2=z1.call(this);if(d2&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===W1.getId()){d2.close();}this._sFilterValue="";if(!X1&&T1){A1.call(this,j,d2);d2.onControlChange();}u1.call(this);}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();}if(i.resolve){O1.call(this,i);}else if(!X1&&Y1){G.call(this,j,T1,U1);}}
function s1(i,j,S1,T1,U1,V1,W1){var X1=this.getMaxConditions();var Y1=false;if(i===null&&X1!==1){return true;}if(S1){S1.validateValue(i);}if(T1){if(i){if(this._oContentFactory.isMeasure()&&j.length===1&&j[0].values[0][0]===undefined){j=[];}if(X1!==1&&b.indexOfCondition(i,j)>=0){throw new P(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[U1]));}else{if(X1>0&&X1<=j.length){j.splice(0,j.length-X1+1);}j.push(i);}}else if(X1===1){j=[];}if(!k(j,this.getConditions())){this.setProperty("conditions",j,true);Y1=true;}if(X1!==1){V1.setValue("");}}if(W1.resolve){var Z1=z1.call(this);if(Z1&&this._bConnected){A1.call(this,j,Z1);Z1.onControlChange();}W1.result=j;O1.call(this,W1);P1.call(this,W1);}return Y1;}
function t1(j){var S1;var T1;var U1=false;var V1=j.getSource();this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();if("value"in j.getParameters()){S1=j.getParameter("value");}else if("newValue"in j.getParameters()){S1=j.getParameter("newValue");}if("escPressed"in j.getParameters()){U1=j.getParameter("escPressed");}if("previousValue"in j.getParameters()){T1=j.getParameter("previousValue");}else{var W1=this.getConditions();T1=W1[0]&&W1[0].values[0];}var X1=z1.call(this);if(X1&&(!this._oContentFactory.isMeasure()||V1.getShowValueHelp())){if(U1){if(X1.isOpen(true)){X1.close();A1.call(this,this.getConditions(),X1);u1.call(this);this._sFilterValue="";}}else{var Y1=this._getOperators();var Z1=false;for(var i=0;i<Y1.length;i++){var $1=b.getOperator(Y1[i]);if($1.validateInput){Z1=true;break;}}if(Z1){this._bIgnoreInputValue=false;this._vLiveChangeValue=S1;if(!this._fnLiveChangeTimer){this._fnLiveChangeTimer=u(function(){var a2=this.getDisplay();this._sFilterValue="";if(this._vLiveChangeValue){var $1=b.getEQOperator();var b2=$1.getValues(this._vLiveChangeValue,a2,true);if(b2[0]){this._sFilterValue=b2[0];if(b2[1]){this._sFilterValue=this._sFilterValue+" ";}}if(b2[1]){this._sFilterValue=this._sFilterValue+b2[1];}}var _1=this.hasOwnProperty("_bOpenByTyping")?this._bOpenByTyping:X1.isTypeaheadSupported();if(this._bConnected&&this._getContent()[0]&&_1&&(sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId()||(this._getContent()[1]&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[1].getId()))){X1.setFilterValue(this._sFilterValue);if(this.getMaxConditionsForHelp()===1&&X1.getConditions().length>0){X1.setConditions([]);}X1.open(true);W.call(this,true);delete this._vLiveChangeValue;}}.bind(this),300,{leading:false,trailing:true});X1.initBeforeOpen(true);}var _1=X1.isTypeaheadSupported();if(_1 instanceof Promise){_1.then(function(a2){var b2=document.activeElement;if(b2&&(n(this.getDomRef(),b2))&&this._fnLiveChangeTimer){this._fnLiveChangeTimer();}this._bOpenByTyping=a2;}.bind(this));}this._fnLiveChangeTimer();}}}this.fireLiveChange({value:S1,escPressed:U1,previousValue:T1});}
function u1(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue;}}
function v1(i){var j=this.getFieldInfo();if(j){j.getTriggerHref().then(function(S1){if(!S1){j.open(this._getContent()[0]);W.call(this,true);}}.bind(this));}this.firePress();}
function w1(j){if(j.getParameter("type")==="removed"){var S1=j.getParameter("removedTokens");var T1=this.getConditions();var U1;var i;for(i=0;i<S1.length;i++){var V1=S1[i];var W1=V1.getBindingContext("$field").sPath;var X1=parseInt(W1.slice(W1.lastIndexOf("/")+1));T1[X1].delete=true;}for(i=T1.length-1;i>=0;i--){if(T1[i].delete){if(this._oContentFactory.isMeasure()){U1=T1[i].values[0][1];}T1.splice(i,1);}}if(this._oContentFactory.isMeasure()&&U1&&T1.length===0){T1=[c.createItemCondition([undefined,U1],undefined)];}this.setProperty("conditions",T1,true);H.call(this,T1,true);j.preventDefault(true);}}
function x1(i,j){if(j==="remove"){var S1=sap.ui.getCore().byId(i);if(S1){S1.detachEvent("select",C1,this);S1.detachEvent("navigated",D1,this);S1.detachEvent("dataUpdate",G1,this);S1.detachEvent("disconnect",H1,this);S1.detachEvent("afterClose",E1,this);S1.detachEvent("switchToValueHelp",F1,this);}this.setProperty("_fieldHelpEnabled",false,true);this._bConnected=false;}else if(j==="insert"){y1.call(this,i);}var T1=this._getContent()[0];if(T1&&T1.setValueHelpIconSrc){T1.setValueHelpIconSrc(this._getFieldHelpIcon());}Q.call(this,this.getConditions());}
function y1(i){if(i&&!this.getProperty("_fieldHelpEnabled")){var j=sap.ui.getCore().byId(i);if(j){j.attachEvent("dataUpdate",G1,this);if(!j.valueHelpEnabled||j.valueHelpEnabled()){this.setProperty("_fieldHelpEnabled",true,true);}}}}
function z1(){var i=this.getFieldHelp();var j;if(!i&&this._sDefaultFieldHelp){i=this._sDefaultFieldHelp;}if(i){j=sap.ui.getCore().byId(i);}return j;}
function A1(j,S1){if(!S1){S1=z1.call(this);}if(this._oContentFactory.isMeasure()){var T1=[];for(var i=0;i<j.length;i++){var U1=j[i];if(U1.values[0]&&U1.values[0][1]){var V1=c.createItemCondition(U1.values[0][1],undefined,U1.inParameters,U1.outParameters);T1.push(V1);}}S1.setConditions(T1);}else{S1.setConditions(j);}}
function B1(i){var j=z1.call(this);if(j){j.setFilterValue(this._sFilterValue);var S1=this.getConditions();A1.call(this,S1,j);j.toggleOpen(false);W.call(this,true);if(!j.isFocusInHelp()){var T1=i.getSource();if(T1.bValueHelpRequested){T1.bValueHelpRequested=false;}}}}
function C1(j){var S1=this.getConditions();var T1=j.getParameter("conditions");var U1=j.getParameter("add");var V1=j.getParameter("close");var W1=j.oSource;var X1=this.getMaxConditions();var Y1;var Z1=this.getControlForSuggestion();var $1;var i=0;if(this._oContentFactory.isMeasure()){if(T1.length>1){throw new Error("Only one item must be selected! "+this);}if(T1[0].operator!=="EQ"){throw new Error("Only EQ allowed! "+this);}if(S1.length>0){for(i=0;i<S1.length;i++){S1[i].values[0][1]=T1[0].values[0];if(S1[i].operator==="BT"){S1[i].values[1][1]=T1[0].values[0];}if(T1[0].inParameters){S1[i].inParameters=T1[0].inParameters;}if(T1[0].outParameters){S1[i].outParameters=T1[0].outParameters;}}}else{var _1=b.getEQOperator(this._getOperators());var a2=this.getControlDelegate().enhanceValueForUnit(this.getPayload(),[null,T1[0].values[0]],this._oTypeInitialization);Y1=c.createCondition(_1.name,[a2],T1[0].inParameters,T1[0].outParameters,C.NotValidated);S1.push(Y1);var b2=this._oContentFactory.getConditionType(true);var c2=this._oContentFactory.getUnitConditionsType(true);if(b2){$1=b2.formatValue(Y1);}else if(c2){$1=c2.formatValue(S1);}}}else{if(!U1){S1=[];}for(i=0;i<T1.length;i++){Y1=T1[i];if(!Q1.call(this,Y1.operator)){continue;}var d2=U1?-1:b.indexOfCondition(Y1,S1);if(d2===-1){S1.push(Y1);}else if(Y1.values[1]!==S1[d2].values[1]&&S1[d2].values[1]){S1[d2].values[1]=Y1.values[1];}}}if(X1>0&&X1<S1.length){S1.splice(0,S1.length-X1);}var e2=false;if(Z1&&Z1.setDOMValue){if(this.getMaxConditionsForHelp()===1&&S1.length>0){if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitConditionsType()){$1=this._oContentFactory.getUnitConditionsType().formatValue(S1);}else if(this._oContentFactory.getConditionType(true)){$1=this._oContentFactory.getConditionType().formatValue(S1[0]);}else if(this._oContentFactory.getConditionsType(true)){$1=this._oContentFactory.getConditionsType().formatValue(S1);}if($1 instanceof Promise){$1.then(function(g2){Z1.setDOMValue("");Z1.setDOMValue(g2);});}else{Z1.setDOMValue("");Z1.setDOMValue($1);}this._sFilterValue="";}else if(V1){if(this.getMaxConditions()!==1&&!this._oContentFactory.getBoundProperty()&&Z1.getMetadata().hasProperty("value")&&Z1.getProperty("value")){Z1.setValue();}Z1.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false;}else{this._bIgnoreInputValue=true;}if(this._bParseError){this._bParseError=false;this._removeUIMessage();e2=true;}}var f2=this.getConditions();if(!k(S1,f2)){this._oNavigateCondition=undefined;this._oContentFactory.updateConditionType();this.setProperty("conditions",S1,true);if(!b.compareConditionsArray(S1,f2)){W1.onControlChange();G.call(this,S1,true);}}else if(e2){G.call(this,S1,true);}}
function D1(i){var j=i.getParameter("value");var S1=i.getParameter("key");var T1=i.getParameter("condition");var U1=i.getParameter("itemId");var V1=i.getParameter("leaveFocus");if(!T1&&S1){T1=c.createItemCondition(S1,j);}var W1;var X1;var Y1=this.getControlForSuggestion();var Z1=b.getEQOperator(this._getOperators());var $1=z1.call(this);if(V1){Y1.addStyleClass("sapMFocus");Y1.focus();$1.removeFocus();return;}if(T1){this._oNavigateCondition=m({},T1);this._oNavigateCondition.operator=Z1.name;S1=T1.values[0];j=T1.values[1];}else{this._oNavigateCondition=c.createCondition(Z1.name,[S1,j],undefined,undefined,C.Validated);}if(this._oContentFactory.isMeasure()){var _1=this.getConditions();if(_1.length>0){this._oNavigateCondition.operator=_1[0].operator;this._oNavigateCondition.values[0]=[_1[0].values[0][0],S1];if(_1[0].operator==="BT"){this._oNavigateCondition.values[1]=[_1[0].values[1][0],this._oNavigateCondition.values[0][1]];}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1);}}else{this._oNavigateCondition.values=[this.getControlDelegate().enhanceValueForUnit(this.getPayload(),[null,S1],this._oTypeInitialization)];}}this._bPreventGetDescription=true;this._oContentFactory.updateConditionType();if(this.getDisplay()!==F.Value){W1=S1;}else if(j){W1=j;}else{W1=S1;}if(Y1&&Y1.setDOMValue){if(!X1){if(this._oContentFactory.isMeasure()&&this._oContentFactory.getUnitConditionsType()&&this._oNavigateCondition){X1=this._oContentFactory.getUnitConditionsType().formatValue([this._oNavigateCondition]);}else if(this._oContentFactory.getConditionType(true)&&this._oNavigateCondition){X1=this._oContentFactory.getConditionType().formatValue(this._oNavigateCondition);}else if(this._oContentFactory.getConditionsType(true)&&this._oNavigateCondition){X1=this._oContentFactory.getConditionsType().formatValue([this._oNavigateCondition]);}else{X1=j||S1;}}Y1.setDOMValue(X1);Y1._doSelect();if($1.isOpen()){Y1.removeStyleClass("sapMFocus");}}this._bPreventGetDescription=false;this._oContentFactory.updateConditionType();W.call(this,true,U1);this._bIgnoreInputValue=false;this.fireLiveChange({value:W1});}
function E1(i){if(this._bIgnoreInputValue){var j=this.getControlForSuggestion();this._bIgnoreInputValue=false;j.setDOMValue("");this._sFilterValue="";if(this.getMaxConditions()!==1&&!this._oContentFactory.getBoundProperty()&&j.getMetadata().hasProperty("value")&&j.getProperty("value")){j.setValue();}}W.call(this,false);var S1=i.getSource();var T1=this.getConditions();A1.call(this,T1,S1);}
function F1(i){var j=this.getControlForSuggestion();j.focus();if(j.fireValueHelpRequest){j.bValueHelpRequested=true;j.fireValueHelpRequest();}}
function G1(i){var j=this.getEditMode()===E.Editable&&this._getContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this._getContent()[0].getId();if(!j&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||(this.getDisplay()!==F.Value&&!this._bParseError))){this._oManagedObjectModel.checkUpdate(true);}}
function H1(i){var j=z1.call(this);j.detachEvent("select",C1,this);j.detachEvent("navigated",D1,this);j.detachEvent("disconnect",H1,this);j.detachEvent("afterClose",E1,this);j.detachEvent("switchToValueHelp",F1,this);j.detachEvent("closed",E1,this);this._bConnected=false;}
function I1(){var i=z1.call(this);if(i&&!this._bConnected){var j=R1.call(this);var S1={maxConditions:this.getMaxConditions(),dataType:this._oContentFactory.getDataType(),operators:this._getOperators(),display:this._oContentFactory.isMeasure()?F.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),conditionModel:j.model,conditionModelName:j.name,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};i.connect(this,S1);this._bConnected=true;i.attachEvent("select",C1,this);i.attachEvent("navigated",D1,this);i.attachEvent("disconnect",H1,this);i.attachEvent("afterClose",E1,this);i.attachEvent("switchToValueHelp",F1,this);i.attachEvent("closed",E1,this);var T1=this.getConditions();A1.call(this,T1,i);var U1=this.getControlForSuggestion();J1.call(this,U1);if(i._bIsDefaultHelp&&i.setTitle){i.setTitle(this.getLabel());}}}
function J1(i){if(i&&!i.orgOnsapfocusleave&&i.onsapfocusleave){i.orgOnsapfocusleave=i.onsapfocusleave;i.onsapfocusleave=function(j){var S1=z1.call(this.getParent());if(S1){var T1=sap.ui.getCore().byId(j.relatedControlId);if(T1){if(n(S1.getDomRef(),T1.getFocusDomRef())){j.stopPropagation();return;}else{S1.skipOpening();}}}this.orgOnsapfocusleave(j);};}}
x.prototype._getFieldHelpIcon=function(){var i=z1.call(this);if(i){return i.getIcon();}};
function K1(i,j){if(j==="remove"){i.detachEvent("dataUpdate",L1,this);}else if(j==="insert"){i.attachEvent("dataUpdate",L1,this);L1.call(this);}}
function L1(){var i=this.getFieldInfo();var j=this;i.isTriggerable().then(function(S1){j._bTriggerable=S1;var T1=j.getAggregation("_content",[]);if(T1.length>0&&j.getEditMode()===E.Display){a1.call(j);if(j._bTriggerable){T1=j.getAggregation("_content",[]);var U1=T1[0];i.getDirectLinkHrefAndTarget().then(function(V1){f._updateLink(U1,V1);});}}});}
x.prototype._getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=M1.bind(this);}var i=R1.call(this);return{valueType:this._oContentFactory.retrieveDataType(),originalDateType:this._oContentFactory.getDateOriginalType()||this._oContentFactory.getUnitOriginalType(),additionalType:this._oContentFactory.getUnitType(),display:this._oContentFactory.isMeasure()?F.Value:this.getDisplay(),fieldHelpID:this._oContentFactory.isMeasure()?undefined:this.getFieldHelp()||this._sDefaultFieldHelp,operators:this._getOperators(),hideOperator:this._oContentFactory.getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,conditionModel:i.model,conditionModelName:i.name,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};};
x.prototype._checkValueInitial=function(i){if(i===null||i===undefined){return true;}if(i===""||(typeof(i)==="string"&&i.match(/^0+$/))){var j=this._oContentFactory.retrieveDataType();var S1=j.parseValue("","string");if(S1===i){return true;}else{try{j.validateValue(S1);}catch(T1){return true;}}}else{var U1=J.call(this);if(this.getTypeUtil().getBaseType(U1)===B.Unit&&Array.isArray(i)&&i.length>1&&(i[0]===undefined||i[0]===null)&&!i[1]){return true;}}return false;};
x.prototype._getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=M1.bind(this);}var i=R1.call(this);return{valueType:this._oContentFactory.getUnitType(),originalDateType:this._oContentFactory.getDateOriginalType()||this._oContentFactory.getUnitOriginalType(),additionalType:this._oContentFactory.retrieveDataType(),display:this.getDisplay(),fieldHelpID:this.getFieldHelp()||this._sDefaultFieldHelp,operators:["EQ"],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,conditionModel:i.model,conditionModelName:i.name,getConditions:this.getConditions.bind(this)};};
function M1(i){var j=z1.call(this);if(j&&j.isOpen()){var S1=document.activeElement;if(S1&&(n(this.getDomRef(),S1)||n(j.getDomRef(),S1))){j.close();}}var T1={};var U1=new Promise(function(V1,W1){T1.resolve=V1;T1.reject=W1;i.then(function(X1){T1.result=X1;this._bParseError=false;var Y1=this.getConditions();if(k(X1,Y1)){O1.call(this,T1);P1.call(this,T1);}else{T1.waitForUpdate=true;}}.bind(this)).catch(function(X1){if(X1&&!(X1 instanceof P)&&!(X1 instanceof r)&&!(X1 instanceof V)){throw X1;}this._bParseError=true;W1(X1);P1.call(this,T1);}.bind(this));}.bind(this));T1.promise=U1;this._aAsyncChanges.push(T1);}
function N1(){var j=[];for(var i=0;i<this._aAsyncChanges.length;i++){j.push(this._aAsyncChanges[i].promise);}if(j.length>0){return Promise.all(j).then(function(){return this._getResultForPromise(this.getConditions());}.bind(this));}return null;}
x.prototype._getResultForPromise=function(i){return i;};
function O1(i){i.resolve(this._getResultForPromise(i.result));}
function P1(j){var S1=false;var i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(j===this._aAsyncChanges[i]){S1=true;break;}}if(S1){this._aAsyncChanges.splice(i,1);}return S1;}
x.prototype._getOperators=function(){var i=new RegExp("^\\*(.*)\\*|\\$search$");if(i.test(this.getFieldPath())&&this.getMaxConditions()===1){return["Contains"];}var j=this.getBaseType();if(j===B.Unit){j=B.Numeric;}return b.getOperatorsForType(j);};
function Q1(j){var S1=this._getOperators();for(var i=0;i<S1.length;i++){if(j===S1[i]){return true;}}return false;}
function R1(){var i;var j;var S1=this.getBinding("conditions");if(S1){var T1=S1.getModel();if(T1&&T1.isA("sap.ui.mdc.condition.ConditionModel")){i=T1;var U1=this.getBindingInfo("conditions");if(U1.model){j=U1.model;}else if(U1.parts&&U1.parts.length===1){j=U1.parts[0].model;}}}return{name:j,model:i};}
return x;});
sap.ui.predefine('sap/ui/mdc/field/FieldBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/mdc/enum/EditMode'],function(R,I,E){"use strict";
var F=R.extend("sap.ui.mdc.field.FieldBaseRenderer");
F=Object.assign(F,{apiVersion:2});
F.render=function(r,f){var c=f._getContent();var w=f.getWidth();var C=f.getConditions();var e=f.getEditMode();var s=f.getShowEmptyIndicator()&&C.length===0&&e===E.Display&&!f.getContent()&&!f.getContentDisplay();r.openStart("div",f);r.class("sapUiMdcFieldBase");if(c.length>1){r.class("sapUiMdcFieldBaseMoreFields");}if(s){r.class("sapMShowEmpty-CTX");}r.style("width",w);r.openEnd();for(var i=0;i<c.length;i++){var o=c[i];r.renderControl(o);}r.close("div");};
return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInputRenderUtil',['sap/ui/core/InvisibleText'],function(I){"use strict";var F={getAriaRole:function(i,r){var a=i.getAriaAttributes();if(a.role){return a.role;}else{return r.getAriaRole.apply(this,arguments);}},getAccessibilityState:function(o,r){var a=o.getAriaAttributes();var A=r.getAccessibilityState.apply(this,arguments);if(a.aria){for(var s in a.aria){A[s]=a.aria[s];}}if(!a.valueHelpEnabled&&A.describedby){var v=I.getStaticId("sap.m","INPUT_VALUEHELP");var b=A.describedby.value.split(" ");var c="";for(var i=0;i<b.length;i++){var d=b[i];if(d!==v){c=c?c+" "+d:d;}}if(c){A.describedby.value=c;}else{delete A.describedby;}}return A;},writeInnerAttributes:function(r,i,R){R.writeInnerAttributes.apply(this,arguments);var a=i.getAriaAttributes();for(var A in a){if(A!=="aria"&&A!=="role"&&A!=="valueHelpEnabled"){r.attr(A,a[A]);}}}};return F;});
sap.ui.predefine('sap/ui/mdc/field/FieldInputRenderer',['sap/ui/core/Renderer','sap/m/InputRenderer','sap/ui/mdc/field/FieldInputRenderUtil'],function(R,I,F){"use strict";var a=R.extend(I);a.apiVersion=2;
a.addOuterClasses=function(r,i){I.addOuterClasses.apply(this,arguments);r.class("sapUiMdcFieldInput");};
a.getAriaRole=function(i){return F.getAriaRole.call(this,i,I);};
a.getAccessibilityState=function(i){return F.getAccessibilityState.call(this,i,I);};
a.writeInnerAttributes=function(r,i){return F.writeInnerAttributes.call(this,r,i,I);};
return a;});
sap.ui.predefine('sap/ui/mdc/field/FieldMultiInputRenderer',['sap/ui/core/Renderer','sap/m/MultiInputRenderer','sap/ui/mdc/field/FieldInputRenderUtil'],function(R,M,F){"use strict";var a=R.extend(M);a.apiVersion=2;
a.addOuterClasses=function(r,m){M.addOuterClasses.apply(this,arguments);r.class("sapUiMdcFieldMultiInput");};
a.getAriaRole=function(m){return F.getAriaRole.call(this,m,M);};
a.getAccessibilityState=function(m){return F.getAccessibilityState.call(this,m,M);};
a.writeInnerAttributes=function(r,m){return F.writeInnerAttributes.call(this,r,m,M);};
return a;});
sap.ui.predefine('sap/ui/mdc/field/ListFieldHelpItem',['sap/ui/core/ListItem'],function(L){"use strict";
var a=L.extend("sap.ui.mdc.field.ListFieldHelpItem",{metadata:{library:"sap.ui.mdc",properties:{groupKey:{type:"any",group:"Appearance",defaultValue:null},groupText:{type:"string",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/mdc/field/ValueHelpPanel',['sap/ui/core/XMLComposite','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/base/ManagedObjectObserver','sap/base/strings/formatMessage','sap/ui/model/resource/ResourceModel','sap/m/Tokenizer','sap/ui/mdc/enum/ConditionValidated'],function(X,J,F,M,f,R,T,C){"use strict";
var V=X.extend("sap.ui.mdc.field.ValueHelpPanel",{
metadata:{library:"sap.ui.mdc",properties:{showTokenizer:{type:"boolean",group:"Data",defaultValue:true},showFilterbar:{type:"boolean",group:"Data",defaultValue:true},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},formatOptions:{type:"object",defaultValue:{}},inputOK:{type:"boolean",defaultValue:true},_filterBarVisible:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"}}},
fragment:"sap.ui.mdc.field.ValueHelpPanel",
init:function(){var m=this._getManagedObjectModel();m.setSizeLimit(1000000);if(!this._oTokenizer){this._oTokenizer=this.byId("VHPTokenizer");this._oTokenizer.addAriaDescribedBy(this._oTokenizer.getTokensInfoId());this._oTokenizer._oScroller.setHorizontal(true);}this._oTokenizerPanel=this.byId("VHPTokenizerPanel");this._oFilterVBox=this.byId("filterbarVBox");this._oFilterVBox._oValueHelpPanel=this;this._oFilterVBox.getItemsOriginal=this._oFilterVBox.getItems;this._oFilterVBox.getItems=function(){var i=this.getItemsOriginal();if(this._oValueHelpPanel._oFilterbar&&this._oValueHelpPanel.getProperty("_filterBarVisible")){i.push(this._oValueHelpPanel._oFilterbar);}return i;};this._oTablePanel=this.byId("tablePanel");this._oTablePanel._oValueHelpPanel=this;this._oTablePanel.getContentOriginal=this._oTablePanel.getContent;this._oTablePanel.getContent=function(){var c=this.getContentOriginal();if(this._oValueHelpPanel._oTable){c.push(this._oValueHelpPanel._oTable);}return c;};this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["formatOptions","showFilterbar","showTokenizer","_filterBarVisible"]});this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");},
exit:function(){if(!this.getShowTokenizer()){this._oTokenizerPanel.destroy();}if(this._oDefineConditionPanel&&!this._oDefineConditionPanel.getParent()){this._oDefineConditionPanel.destroy();}this._oObserver.disconnect();this._oObserver=undefined;this._oTablePanel=null;this._oFilterVBox=null;this._oResourceBundle=null;},
onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}},
setFilterbar:function(o){var s=this.getShowFilterbar();if(this._oFilterbar){if(this._bFilterbarParentSet){this._oFilterbar.setParent();delete this._bFilterbarParentSet;}}this._oFilterbar=o;if(o){if(!o.getParent()){o.setParent(this);this._bFilterbarParentSet=true;}o.getParent().getDirection=this._oFilterVBox.getDirection.bind(this._oFilterVBox);}var i=this.byId("iconTabBar");i.getItems()[0].setVisible(i.getItems()[0].getContent().length>0);i.setSelectedKey("selectFromList");this._updateITBHeaderVisiblity();this.setProperty("_filterBarVisible",s&&!!this._oFilterbar,true);},
setTable:function(t){if(this._oTable){if(this._bTableParentSet&&this._oTable.getParent()){this._oTable.setParent();}delete this._bTableParentSet;}this._oTable=t;if(t){if(!t.getParent()){t.setParent(this);this._bTableParentSet=true;}}this._oTablePanel.invalidate();var i=this.byId("iconTabBar");i.getItems()[0].setVisible(i.getItems()[0].getContent().length>0);i.setSelectedKey("selectFromList");this._updateITBHeaderVisiblity();},
getTable:function(){if(this._oTable){return this._oTable;}else{return undefined;}},
setDefineConditions:function(d){var i=this.byId("iconTabBar");var p=this.byId("defineConditionPanel");if(this._oDefineConditionPanel){p.removeContent(this._oDefineConditionPanel);this._oDefineConditionPanel.destroy();}this._oDefineConditionPanel=d;i.getItems()[1].setVisible(!!this._oDefineConditionPanel);this._updateITBHeaderVisiblity();},
_updateITBHeaderVisiblity:function(){var i=this.byId("iconTabBar");if(i.getItems()[0].getVisible()&&i.getItems()[1].getVisible()){i.removeStyleClass("sapMdcNoHeader");}else{i.addStyleClass("sapMdcNoHeader");}if(i.getItems()[1].getVisible()&&i.getSelectedKey()!=="selectFromList"){a.call(this);}},
_handleTokenDelete:function(e){if(e.getParameter("tokens")){var r=e.getParameter("tokens");var c=this.getConditions();var i;for(i=0;i<r.length;i++){var o=r[i];var p=o.getBindingContext("$this").sPath;var I=parseInt(p.slice(p.lastIndexOf("/")+1));c[I].delete=true;}for(i=c.length-1;i>=0;i--){if(c[i].delete){c.splice(i,1);}}this.setProperty("conditions",c,true);}},
_onRemoveAllConditions:function(e){this.setProperty("conditions",[],true);},
iconTabSelect:function(e){var k=e.getParameter("key");if(k==="defineCondition"){a.call(this);}},
_formatListTabTitle:function(t,c){var b=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true&&o.validated===C.Validated){b++;}}if(b===0){t=this._oResourceBundle.getText("valuehelp.SELECTFROMLISTNONUMBER");}return f(t,b);},
_formatDefineTabTitle:function(t,c){var b=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true&&o.validated!==C.Validated){b++;}}if(b===0){t=this._oResourceBundle.getText("valuehelp.DEFINECONDITIONSNONUMBER");}return f(t,b);},
_formatTableTitle:function(t){var i=0;t=this._oResourceBundle.getText("valuehelp.TABLETITLENONUMBER");return f(t,i);},
_formatTokenizerTitle:function(t,c){var b=0;for(var i=0;i<c.length;i++){var o=c[i];if(o.isEmpty!==true){b++;}}if(b===0){t=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER");}return f(t,b);}
});
function _(c){if(c.name==="formatOptions"){var b=this._oTokenizer.getBindingInfo("tokens");if(b&&b.template){b=b.template.getBindingInfo("text");if(b&&b.type){b.type.setFormatOptions(c.current);}}}if(c.name==="showTokenizer"){var v=this.byId("rootVBox");var l=this._oTokenizer.getBinding("tokens");if(c.current){if(l){l.resume();}v.insertItem(this._oTokenizerPanel,1);}else{if(l){l.suspend();}v.removeItem(this._oTokenizerPanel);}}if(c.name==="showFilterbar"){this.setProperty("_filterBarVisible",c.current&&!!this._oFilterbar,true);}if(c.name==="_filterBarVisible"){this._oTablePanel.invalidate();}}
function a(){if(this._oDefineConditionPanel){if(!this._oDefineConditionPanel.getModel("$VHP")){var m=this._getManagedObjectModel();this._oDefineConditionPanel.setModel(m,"$VHP");var o=this._oDefineConditionPanel.getMetadata();if(o.hasProperty("formatOptions")&&!this._oDefineConditionPanel.getBindingPath("formatOptions")&&this._oDefineConditionPanel.isPropertyInitial("formatOptions")){this._oDefineConditionPanel.bindProperty("formatOptions",{path:"$VHP>/formatOptions"});}if(o.hasProperty("conditions")&&!this._oDefineConditionPanel.getBindingPath("conditions")&&this._oDefineConditionPanel.isPropertyInitial("conditions")){this._oDefineConditionPanel.bindProperty("conditions",{path:"$VHP>/conditions"});}if(o.hasProperty("inputOK")&&!this._oDefineConditionPanel.getBindingPath("inputOK")&&this._oDefineConditionPanel.isPropertyInitial("inputOK")){this._oDefineConditionPanel.bindProperty("inputOK",{path:"$VHP>/inputOK"});}}var p=this.byId("defineConditionPanel");p.addContent(this._oDefineConditionPanel);}}
return V;});
sap.ui.predefine('sap/ui/mdc/field/content/ContentFactory',["sap/ui/base/Object","sap/ui/mdc/enum/EditMode","sap/ui/mdc/enum/ContentMode","sap/ui/mdc/util/loadModules","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/SearchContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/field/content/TimeContent","sap/ui/mdc/field/content/DateTimeContent","sap/ui/mdc/field/content/LinkContent","sap/ui/mdc/field/content/BooleanContent","sap/ui/mdc/field/content/UnitContent",'sap/ui/mdc/field/ConditionType','sap/ui/mdc/field/ConditionsType',"sap/ui/base/SyncPromise"],function(B,E,C,l,D,S,a,T,b,L,c,U,d,e,f){"use strict";
var g=B.extend("sap.ui.mdc.field.content.ContentFactory",{
metadata:{library:"sap.ui.mdc"},
constructor:function(i,s){this._oField=s?s.field:null;this._fnHandleTokenUpdate=s?s.handleTokenUpdate:null;this._fnHandleContentChange=s?s.handleContentChange:null;this._fnHandleContentLiveChange=s?s.handleContentLiveChange:null;this._fnHandleValueHelpRequest=s?s.handleValueHelpRequest:null;this._fnHandleEnter=s?s.handleEnter:null;this._fnHandleContentPress=s?s.handleContentPress:null;B.prototype.constructor.apply(this,arguments);}
});
var m={Default:D,Search:S,Date:a,Time:T,DateTime:b,Link:L,Boolean:c,Unit:U};
g.prototype.init=function(){this._oContentTypeClass;this._sOperator;};
g.prototype.exit=function(){this._oField=undefined;this._fnHandleTokenUpdate=undefined;this._fnHandleContentChange=undefined;this._fnHandleContentLiveChange=undefined;this._fnHandleValueHelpRequest=undefined;this._fnHandleEnter=undefined;this._fnHandleContentPress=undefined;this._oContentTypeClass=undefined;this._sOperator=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined;}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined;}};
g.prototype.createContent=function(o,s,i){var h=o.getControlNames(s,this._sOperator);var j;if(h.every(function(n){return!n;})){return Promise.resolve([]);}try{j=l(h).catch(function(k){throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:createContent function call - could not load controls "+JSON.stringify(h));}).then(function(n){return o.create(this,s,this._sOperator,n,i);}.bind(this)).unwrap();}catch(k){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+k.message+"'");}if(j.then){j.catch(function(k){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+k.message+"'");});return j;}return f.resolve(j);};
g.prototype.getContentMode=function(o,s,M,h,O){var i=C.Edit;if(s===E.Display){if(M!==1){i=C.DisplayMultiValue;}else if(h){i=C.DisplayMultiLine;}else{i=C.Display;}}else if(M!==1){i=C.EditMultiValue;}else if(h){i=C.EditMultiLine;}else if(O.length===1&&o.getEditOperator()&&o.getEditOperator()[O[0]]){this._sOperator=O[0];i=C.EditOperator;}else if(this.getField().getFieldHelp()){i=C.EditForHelp;}return i;};
g.prototype.getContentType=function(s,M,i){var F=this.getField();var o=m[s]?m[s]:null;if(!o){if(F.getFieldInfo()&&i){o=m.Link;}else{var r=new RegExp("^\\*(.*)\\*|\\$search$");if(r.test(F.getFieldPath())&&M===1){o=m.Search;}else{o=m.Default;}}}return o;};
g._updateLink=function(o,h){if(h){o.setHref(h.href);o.setTarget(h.target);}};
g._getEnabled=function(s){return(s&&s!==E.Disabled);};
g._getEditable=function(s){return(s===E.Editable||s===E.EditableReadOnly||s===E.EditableDisplay);};
g._getDisplayOnly=function(s){return s&&s!==E.Editable;};
g._getEditableUnit=function(s){return s===E.Editable;};
g.prototype.getField=function(){return this._oField;};
g.prototype.getFieldHelpIcon=function(){return this.getField()._getFieldHelpIcon();};
g.prototype.getHandleTokenUpdate=function(){return this._fnHandleTokenUpdate;};
g.prototype.getHandleContentChange=function(){return this._fnHandleContentChange;};
g.prototype.getHandleContentLiveChange=function(){return this._fnHandleContentLiveChange;};
g.prototype.getHandleValueHelpRequest=function(){return this._fnHandleValueHelpRequest;};
g.prototype.getHandleEnter=function(){return this._fnHandleEnter;};
g.prototype.getHandleContentPress=function(){return this._fnHandleContentPress;};
g.prototype.setBoundProperty=function(s){this._sBoundProperty=s;};
g.prototype.getBoundProperty=function(){return this._sBoundProperty;};
g.prototype.setAriaLabelledBy=function(o){if(o.addAriaLabelledBy){var A=this.getField().getAriaLabelledBy();for(var i=0;i<A.length;i++){var I=A[i];o.addAriaLabelledBy(I);}}};
g.prototype.setHideOperator=function(h){this._bHideOperator=h;};
g.prototype.getHideOperator=function(){return this._bHideOperator;};
function _(s,h,G,i){if(!i){if(this[s]&&this[s].getMetadata().getName()!==h.getMetadata().getName()){this[s].destroy();this[s]=undefined;}if(!this[s]){var F=G();this[s]=new h(F);this[s]._bCreatedByField=true;}}return this[s];}
g.prototype.getConditionType=function(s){return _.call(this,"_oConditionType",d,this.getField()._getFormatOptions.bind(this.getField()),s);};
g.prototype.setConditionType=function(o){this._oConditionType=o;};
g.prototype.getConditionsType=function(s,h){var i=h||e;return _.call(this,"_oConditionsType",i,this.getField()._getFormatOptions.bind(this.getField()),s);};
g.prototype.setConditionsType=function(o){this._oConditionsType=o;};
g.prototype.getUnitConditionsType=function(s){return _.call(this,"_oUnitConditionsType",e,this.getField()._getUnitFormatOptions.bind(this.getField()),s);};
g.prototype.getContentConditionTypes=function(){return this._oContentConditionTypes;};
g.prototype.setContentConditionTypes=function(o){this._oContentConditionTypes=o;};
g.prototype._setUsedConditionType=function(o,s){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined;}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined;}var h;var i;if(o){if(this._oContentConditionTypes.content){h=this._oContentConditionTypes.content.oConditionType;i=this._oContentConditionTypes.content.oConditionsType;}}else if(s===E.Display&&this.getField().getContentDisplay()){if(this._oContentConditionTypes.contentDisplay){h=this._oContentConditionTypes.contentDisplay.oConditionType;i=this._oContentConditionTypes.contentDisplay.oConditionsType;}}else if(s!==E.Display&&this.getField().getContentEdit()){if(this._oContentConditionTypes.contentEdit){h=this._oContentConditionTypes.contentEdit.oConditionType;i=this._oContentConditionTypes.contentEdit.oConditionsType;}}if(h){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();}this._oConditionType=h;}if(i){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();}this._oConditionsType=i;}this.updateConditionType();};
g.prototype.getDataType=function(){return this._oDataType;};
g.prototype.setDataType=function(o){this._oDataType=o;};
g.prototype.retrieveDataType=function(){if(!this._oDataType){var s=this.getField().getDataType();if(typeof s==="string"){this._oDataType=this.getField().getTypeUtil().getDataTypeInstance(s,this.getField().getDataTypeFormatOptions(),this.getField().getDataTypeConstraints());this._oDataType._bCreatedByField=true;}}return this._oDataType;};
g.prototype.getDateOriginalType=function(){return this._oDateOriginalType;};
g.prototype.setDateOriginalType=function(o){this._oDateOriginalType=o;};
g.prototype.getUnitOriginalType=function(){return this._oUnitOriginalType;};
g.prototype.setUnitOriginalType=function(u){this._oUnitOriginalType=u;};
g.prototype.getUnitType=function(){return this._oUnitType;};
g.prototype.setUnitType=function(u){this._oUnitType=u;};
g.prototype.isMeasure=function(){return this._bIsMeasure;};
g.prototype.setIsMeasure=function(i){this._bIsMeasure=i;};
g.prototype.getDisplayFormat=function(){return this._sDisplayFormat;};
g.prototype.setDisplayFormat=function(s){this._sDisplayFormat=s;};
g.prototype.getValueFormat=function(){return this._sValueFormat;};
g.prototype.setValueFormat=function(v){this._sValueFormat=v;};
g.prototype.getCalendarType=function(){return this._sCalendarType;};
g.prototype.setCalendarType=function(s){this._sCalendarType=s;};
g.prototype.getFieldTypeInitialization=function(){return this.getField()._oTypeInitialization;};
g.prototype.updateConditionType=function(){var o=this._oConditionType;var h=this._oConditionsType;if(o||h){var F=this.getField()._getFormatOptions();if(o){o.setFormatOptions(F);}if(h){h.setFormatOptions(F);}if(this._oUnitConditionsType){F=this.getField()._getUnitFormatOptions();this._oUnitConditionsType.setFormatOptions(F);}}};
return g;});
sap.ui.predefine('sap/ui/mdc/filterbar/FilterBarBaseRenderer',[],function(){"use strict";var F={apiVersion:2};F.CSS_CLASS="sapUiMdcFilterBarBase";
F.render=function(r,c){r.openStart("div",c);r.class(F.CSS_CLASS);r.openEnd();var i=c.getAggregation("layout")?c.getAggregation("layout").getInner():null;r.renderControl(i);r.close("div");};
return F;},true);
sap.ui.predefine('sap/ui/mdc/library',["sap/ui/core/Core","sap/ui/core/library","sap/m/library"],function(){"use strict";sap.ui.getCore().initLibrary({version:"1.98.0",name:"sap.ui.mdc",dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/mdc/designtime/library.designtime",types:["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.TableRowAction","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent","sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer"],controls:["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.field.ValueHelpPanel","sap.ui.mdc.field.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.link.ContactDetails","sap.ui.mdc.ui.Container","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],elements:["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.ChartToolbar","sap.ui.mdc.chart.ChartTypeButton","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldHelp","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldHelpBase","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.FieldValueHelp","sap.ui.mdc.field.FieldValueHelpContentWrapperBase","sap.ui.mdc.field.FieldValueHelpTableWrapperBase","sap.ui.mdc.field.FieldValueHelpMdcTableWrapper","sap.ui.mdc.field.FieldValueHelpMTableWrapper","sap.ui.mdc.field.FieldValueHelpUITableWrapper","sap.ui.mdc.field.ListFieldHelp","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.field.BoolFieldHelp","sap.ui.mdc.field.ConditionFieldHelp","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.link.ContactDetailsAddressItem","sap.ui.mdc.link.ContactDetailsEmailItem","sap.ui.mdc.link.ContactDetailsItem","sap.ui.mdc.link.ContactDetailsPhoneItem","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.InParameter","sap.ui.mdc.field.OutParameter","sap.ui.mdc.ui.ContainerItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],extensions:{flChangeHandlers:{"sap.ui.mdc.Table":"sap/ui/mdc/flexibility/Table","sap.ui.mdc.Chart":"sap/ui/mdc/flexibility/Chart","sap.ui.mdc.FilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.filterbar.p13n.AdaptationFilterBar":"sap/ui/mdc/flexibility/FilterBar","sap.ui.mdc.link.PanelItem":"sap/ui/mdc/flexibility/PanelItem","sap.ui.mdc.link.Panel":"sap/ui/mdc/flexibility/Panel","sap.ui.mdc.ActionToolbar":"sap/ui/mdc/flexibility/ActionToolbar","sap.ui.mdc.actiontoolbar.ActionToolbarAction":"sap/ui/mdc/flexibility/ActionToolbarAction","sap.ui.mdc.chart.ChartToolbar":"sap/ui/mdc/flexibility/ActionToolbar"}},noLibraryCSS:false});var t=sap.ui.mdc;t.FilterBarP13nMode={Item:"Item",Value:"Value"};t.TableType={Table:"Table",ResponsiveTable:"ResponsiveTable"};t.TableP13nMode={Column:"Column",Sort:"Sort",Filter:"Filter",Group:"Group",Aggregate:"Aggregate"};t.GrowingMode={None:"None",Basic:"Basic",Scroll:"Scroll"};t.RowCountMode={Auto:"Auto",Fixed:"Fixed"};t.ChartToolbarActionType={ZoomInOut:"ZoomInOut",DrillDownUp:"DrillDownUp",Legend:"Legend",FullScreen:"FullScreen"};t.ChartP13nMode={Item:"Item",Sort:"Sort",Type:"Type"};t.SelectionMode={None:"None",Single:"Single",Multi:"Multi"};t.RowAction={Navigation:"Navigation"};t.FilterExpression={Interval:"Interval",Single:"Single",Multi:"Multi"};t.ChartItemType={Dimension:"Dimension",Measure:"Measure"};t.ChartItemRoleType={category:"category",series:"series",category2:"category2",axis1:"axis1",axis2:"axis2",axis3:"axis3"};t.ContactDetailsAddressType={work:"work",home:"home",preferred:"preferred"};t.ContactDetailsEmailType={work:"work",home:"home",preferred:"preferred"};t.ContactDetailsPhoneType={work:"work",home:"home",cell:"cell",fax:"fax",preferred:"preferred"};t.MultiSelectMode={Default:"Default",ClearAll:"ClearAll"};return t;});
sap.ui.predefine('sap/ui/mdc/link/FakeFlpConnector',["sap/ui/thirdparty/jquery",'sap/ui/mdc/link/Factory'],function(q,F){"use strict";
function a(){}
a.enableFakeConnector=function(s){if(a.getServiceReal){return;}a.getServiceReal=F.getService;F.getService=a._createFakeService(s);};
a.enableFakeConnectorForTesting=function(s,t){if(a.getServiceReal){return;}a.getServiceReal=F.getService;F.getService=a._createFakeService(s,t);};
a._createFakeService=function(s,t){return function(S){switch(S){case"CrossApplicationNavigation":return{hrefForExternal:function(T,c){if(t){t.hrefForExternal=t.hrefForExternal||{calls:[]};t.hrefForExternal.calls.push({target:T,comp:c});}if(!T){return null;}return T.target.shellHash;},getDistinctSemanticObjects:function(){var b=[];for(var c in s){b.push(c);}var d=q.Deferred();setTimeout(function(){d.resolve(b);},0);return d.promise();},getLinks:function(p){var l=[];if(!Array.isArray(p)){s[p.semanticObject]?l=s[p.semanticObject].links:l=[];}else{p.forEach(function(P){s[P[0].semanticObject]?l.push([s[P[0].semanticObject].links]):l.push([[]]);});}var d=q.Deferred();setTimeout(function(){d.resolve(l);},0);return d.promise();}};case"URLParsing":return{parseShellHash:function(i){var f=function(L){var c=L.filter(function(l){return l.intent===i;});return c[0];};for(var b in s){var l=f(s[b].links);if(l){return{semanticObject:b,action:l.action};}}return{semanticObject:null,action:null};}};default:return a.getServiceReal(S);}};};
a.disableFakeConnector=function(){if(a.getServiceReal){F.getService=a.getServiceReal;a.getServiceReal=undefined;}};
return a;},true);
sap.ui.predefine('sap/ui/mdc/mixin/AdaptationMixin',["sap/ui/mdc/p13n/Engine"],function(E){"use strict";var A={};
A.getEngine=function(){return E.getInstance();};
A._onModifications=function(){};
A.retrieveInbuiltFilter=function(){if(!this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=new Promise(function(r,a){sap.ui.require(["sap/ui/mdc/filterbar/p13n/AdaptationFilterBar"],function(b){if(this.bIsDestroyed){a("exit");return;}if(!this._oP13nFilter){this._oP13nFilter=new b(this.getId()+"-p13nFilter",{adaptationControl:this,filterConditions:this.getFilterConditions()});if(this._registerInnerFilter){this._registerInnerFilter.call(this,this._oP13nFilter);}this.addDependent(this._oP13nFilter);r(this._oP13nFilter);}else{r(this._oP13nFilter);}}.bind(this));}.bind(this));}return this._oInbuiltFilterPromise;};
A.validateState=function(t,k){return this.getControlDelegate().validateState(this,t,k);};
A.getInbuiltFilter=function(){return this._oP13nFilter;};
A.exit=function(e){return function(){if(this._oP13nFilter){this._oP13nFilter.destroy();this._oP13nFilter=null;}if(this._oInbuiltFilterPromise){this._oInbuiltFilterPromise=null;}if(e){e.apply(this,arguments);}};};
return function(){this.retrieveInbuiltFilter=A.retrieveInbuiltFilter;this.getInbuiltFilter=A.getInbuiltFilter;this.validateState=A.validateState;this._onModifications=A._onModifications;this.getEngine=A.getEngine;this.exit=A.exit(this.exit);};});
sap.ui.predefine('sap/ui/mdc/mixin/DelegateMixin',["sap/ui/mdc/util/loadModules","sap/base/Log"],function(l,L){"use strict";var _=function(c){if(!c||!c.name){throw new Error("Delegate configuration '"+(c&&JSON.stringify(c))+"' invalid");}};var a=function(r){if(!this.bIsDestroyed){if(r instanceof Error){this.fnRejectDelegate(r);}else{this._oDelegate=r[0];this.fnResolveDelegate(this._oDelegate);this.bDelegateInitialized=true;}}this.bDelegateLoading=false;delete this.fnResolveDelegate;delete this.fnRejectDelegate;};var D={};
D.init=function(I){return function(){this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=new Promise(function(r,b){this.fnResolveDelegate=r;this.fnRejectDelegate=b;}.bind(this));this._oPropertyHelper=null;this._bPropertyHelperIsBeingInitialized=false;this._pInitPropertyHelper=new Promise(function(r,b){this._fnResolveInitPropertyHelper=r;this._fnRejectInitPropertyHelper=b;}.bind(this));if(I){I.apply(this,arguments);}};};
D.applySettings=function(A){return function(s){A.apply(this,arguments);this._bDelegateLocked=true;return this;};};
D.setDelegate=function(s){return function(c){if(this._bDelegateLocked){throw new Error("Runtime delegate configuration is not permitted.");}_(c);s.call(this,c);this._oPayload=c&&c.payload;return this;};};
D.initControlDelegate=function(p){if(this.bIsDestroyed){L.warning("Delegate module initialization omitted as control is being destroyed.");}else if(!this._oDelegate&&!this.bDelegateLoading){if(p){a.call(this,[p]);}else{var d=this.getDelegate();_(d);this.bDelegateLoading=true;l(d.name).then(a.bind(this)).catch(a.bind(this));}}return this._oDelegateInitialized;};
D.getPayload=function(){if(!this._oPayload){var d=this.getDelegate();this._oPayload=d&&d.payload;}return this._oPayload;};
D.getTypeUtil=function(){if(!this._oTypeUtil){if(!this._oDelegate){throw new Error("A delegate instance providing typeUtil is not (yet) available.");}this._oTypeUtil=this._oDelegate.getTypeUtil&&this._oDelegate.getTypeUtil(this._oPayload);}return this._oTypeUtil;};
D.getControlDelegate=function(){if(!this._oDelegate){throw new Error("A delegate instance is not (yet) available. You must call initControlDelegate before calling getControlDelegate.");}return this._oDelegate;};
D.awaitControlDelegate=function(){return this._oDelegateInitialized;};
D.initPropertyHelper=function(C){if(C&&(!C.getMetadata||!C.getMetadata().isA("sap.ui.mdc.util.PropertyHelper"))){throw new Error("The custom property helper class must be sap.ui.mdc.util.PropertyHelper or a subclass of it.");}if(!this.bIsDestroyed&&!this._oPropertyHelper&&!this._bPropertyHelperIsBeingInitialized){this._bPropertyHelperIsBeingInitialized=true;this.awaitControlDelegate().then(function(d){if(this.bIsDestroyed){return null;}return i(this,d,C);}.bind(this)).catch(function(e){this._fnRejectInitPropertyHelper(e);}.bind(this));}return this._pInitPropertyHelper;};
function i(c,d,C){return Promise.all([d.fetchProperties(c)]).then(function(r){if(c.bIsDestroyed){return[];}if(typeof d.fetchPropertyExtensions==="function"){return d.fetchPropertyExtensions(c,r[0]).then(function(e){return r.concat(e);});}return r.concat(undefined);}).then(function(r){if(c.bIsDestroyed){return[];}return f(c,d,C,r[0],r[1]).then(function(P){return r.concat(P);});}).then(function(r){if(c.bIsDestroyed){return;}var p=r[0];var e=r[1];var P=r[2];var b=!!P.isA;c._oPropertyHelper=b?P:new P(p,e,c);c._bPropertyHelperIsBeingInitialized=false;c._fnResolveInitPropertyHelper(c._oPropertyHelper);});}
function f(c,d,C,p,e){if(typeof d.fetchPropertyHelper==="function"){return d.fetchPropertyHelper(c,p,e).then(function(P){var b=C?C.getMetadata().getName():"sap.ui.mdc.util.PropertyHelper";if(!P||!P.getMetadata||!P.getMetadata().isA(b)){throw new Error("The property helper must be a class or instance of type "+b+" or a subclass of it.");}return P;});}if(C){return Promise.resolve(C);}return l("sap/ui/mdc/util/PropertyHelper").then(function(r){return r[0];});}
D.awaitPropertyHelper=function(){return this._pInitPropertyHelper;};
D.getPropertyHelper=function(){if(!this._oPropertyHelper){throw new Error("A property helper is not (yet) available. You must first initialize the delegate and the property helper.");}return this._oPropertyHelper;};
D.exit=function(e){return function(){this.fnResolveDelegate=null;this.fnRejectDelegate=null;this.bDelegateInitialized=false;this.bDelegateLoading=false;this._oDelegateInitialized=null;this._oDelegate=null;this._oPayload=null;this._oTypeUtil=null;if(this._oPropertyHelper&&!this._oPropertyHelper.bIsDestroyed){this._oPropertyHelper.destroy();}this._oPropertyHelper=null;this._fnResolveInitPropertyHelper=null;this._fnRejectInitPropertyHelper=null;this._bPropertyHelperIsBeingInitialized=false;this._pInitPropertyHelper=null;if(e){e.apply(this,arguments);}};};
return function(){this.applySettings=D.applySettings(this.applySettings);this.exit=D.exit(this.exit);this.init=D.init(this.init);this.setDelegate=D.setDelegate(this.setDelegate);this.awaitControlDelegate=D.awaitControlDelegate;this.getControlDelegate=D.getControlDelegate;this.getPayload=D.getPayload;this.getTypeUtil=D.getTypeUtil;this.initControlDelegate=D.initControlDelegate;this.initPropertyHelper=D.initPropertyHelper;this.awaitPropertyHelper=D.awaitPropertyHelper;this.getPropertyHelper=D.getPropertyHelper;};});
sap.ui.predefine('sap/ui/mdc/mixin/FilterIntegrationMixin',["sap/ui/core/Core"],function(C){"use strict";var F={};var I="sap.ui.mdc.IFilter";
F.setFilter=function(f){var n=typeof f==="object"?f.getId():f;var O=this.getFilter();if(O!==n){this._validateFilter(f);var b=C.byId(this.getFilter());if(b){d(this,b);}this.setAssociation("filter",f,true);var N=C.byId(this.getFilter());if(N){r(this,N);}}return this;};
function o(e){this._rebind();if(this._onFilterSearch){this._onFilterSearch(e);}}
function a(e){if(this._onFiltersChanged){this._onFiltersChanged(e);}}
function r(c,f){f.attachSearch(o,c);if(f.attachFiltersChanged instanceof Function){f.attachFiltersChanged(a,c);}if(c._onFilterProvided instanceof Function){c._onFilterProvided(f);}}
function d(c,f){f.detachSearch(o,c);if(f.detachFiltersChanged instanceof Function){f.detachFiltersChanged(a,c);}if(c._onFilterRemoved instanceof Function){c._onFilterRemoved(f);}}
function _(c){if(!(c&&c.getMetadata()&&c.getMetadata().hasAssociation("filter"))){throw new Error("Please add the 'filter' association to your control metadata"+c);}if(!(c.rebind instanceof Function)){throw new Error("Please implement the method 'rebind' for the control "+c);}if(!(c.isFilteringEnabled instanceof Function)){throw new Error("Please implement the method isFilteringEnabled for the control "+c);}}
F._validateFilter=function(f){_(this);var b=typeof f==="object"?f:C.byId(f);if(b&&!b.isA(I)){throw new Error("\""+f+"\" is not valid for association \"filter\"."+" Please use an object that implements the \""+I+"\" interface");}};
F.rebind=function(){if(this.bIsDestroyed){return;}var p;var b;var f=C.byId(this.getFilter()),i=this.isFilteringEnabled();if(i||f){if(f){p=f.validate(true);}if(i){b=this.retrieveInbuiltFilter().then(function(c){return c.validate(true);});}Promise.all([p,b]).then(function(){this._rebind();}.bind(this),function(){});}else{this._rebind();}};
return function(){this.setFilter=F.setFilter;this._validateFilter=F._validateFilter;this.rebind=F.rebind;};});
sap.ui.predefine('sap/ui/mdc/mixin/PromiseMixin',["sap/ui/mdc/util/PromiseCache"],function(P){"use strict";var a={};
a.addPromise=function(n,c){return this.promiseCache.add(n,c);};
a.cancelPromise=function(n,r){return this.promiseCache.cancel(n,r);};
a.retrievePromise=function(n,c){return this.promiseCache.retrieve(n,c);};
a.retrievePromises=function(){return this.promiseCache.retrieveMany.apply(this.promiseCache,arguments);};
a.removePromise=function(n){return this.promiseCache.remove(n);};
a.resolvePromise=function(n,v){return this.promiseCache.resolve(n,v);};
a.rejectPromise=function(n,v){return this.promiseCache.reject(n,v);};
a.exit=function(e){return function(){if(this.promiseCache){this.promiseCache.destroy();this.promiseCache=null;}if(e){e.apply(this,arguments);}};};
return function(){var _=function(m){return function(){if(this.bIsDestroyed){return undefined;}if(!this.promiseCache){this.promiseCache=new P();}return m.apply(this,arguments);};};this._addPromise=_(a.addPromise);this._cancelPromise=_(a.cancelPromise);this._removePromise=_(a.removePromise);this._resolvePromise=_(a.resolvePromise);this._rejectPromise=_(a.rejectPromise);this._retrievePromise=_(a.retrievePromise);this._retrievePromises=_(a.retrievePromises);this.exit=a.exit(this.exit);};});
sap.ui.predefine('sap/ui/mdc/odata/TypeUtil',['sap/ui/mdc/util/TypeUtil','sap/ui/mdc/enum/BaseType','sap/base/util/ObjectPath'],function(B,a,O){"use strict";var T=Object.assign({},B,{getPrimitiveType:function(d){var t={"Edm.Binary":"boolean","Edm.Boolean":"boolean","Edm.Byte":"boolean","Edm.Date":"date","Edm.DateTimeOffset":"dateTime","Edm.Decimal":"int","Edm.Double":"boolean","Edm.Duration":"float","Edm.Guid":"string","Edm.Int16":"int","Edm.Int32":"int","Edm.Int64":"int","Edm.SByte":"boolean","Edm.Single":"float","Edm.String":"string","Edm.TimeOfDay":"time"};return t[d]||"object";},getDataTypeClassName:function(t){var e={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};if(e[t]){t=e[t];}else if(t&&t.startsWith("Edm.")){throw new Error("Invalid data type "+t);}else{t=B.getDataTypeClassName(t);}return t;},getBaseType:function(t,f,c){switch(t){case"sap.ui.model.odata.type.DateTime":if(c&&c.displayFormat==="Date"){return a.Date;}else{return a.DateTime;}case"sap.ui.model.odata.type.DateTimeOffset":return a.DateTime;case"sap.ui.model.odata.type.Time":return a.Time;case"sap.ui.model.odata.type.Boolean":return a.Boolean;case"sap.ui.model.odata.type.Byte":case"sap.ui.model.odata.type.SByte":case"sap.ui.model.odata.type.Decimal":case"sap.ui.model.odata.type.Int16":case"sap.ui.model.odata.type.Int32":case"sap.ui.model.odata.type.Int64":case"sap.ui.model.odata.type.Single":case"sap.ui.model.odata.type.Double":return a.Numeric;default:return B.getBaseType(t,f,c);}}});return T;});
sap.ui.predefine('sap/ui/mdc/odata/v4/ODataMetaModelUtil',["sap/ui/mdc/util/TypeUtil"],function(T){"use strict";var u=function(){};
u.fetchAllAnnotations=function(m,e){var c=m.getMetaContext(e);return m.requestObject("@",c).then(function(a){return a;});};
u.getAllCustomAggregates=function(a){var c={},A;for(var s in a){if(s.startsWith("@Org.OData.Aggregation.V1.CustomAggregate")){A=s.replace("@Org.OData.Aggregation.V1.CustomAggregate#","");var b=A.split("@");if(b.length==2){if(b[1]=="Org.OData.Aggregation.V1.ContextDefiningProperties"){c[b[0]].contextDefiningProperties=a[s];}if(b[1]=="com.sap.vocabularies.Common.v1.Label"){c[b[0]].label=a[s];}}else if(b.length==1){c[b[0]]={name:b[0],propertyPath:b[0],label:"Custom Aggregate ("+A+")",sortable:true,sortOrder:"both",custom:true};}}}return c;};
u.getAllAggregatableProperties=function(a){var A={},p,P;if(a["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"]){p=a["@com.sap.vocabularies.Analytics.v1.AggregatedProperties"];for(var i=0;i<p.length;i++){P=p[i];A[P.Value]={name:P.Value,propertyPath:P.AggregatableProperty.$PropertyPath,aggregationMethod:P.AggregationMethod,label:P["@com.sap.vocabularies.Common.v1.Label"]||"Aggregatable property ("+P.Value+")",sortable:true,sortOrder:"both",custom:false};}}return A;};
u.getAllDataPoints=function(a){var d={};for(var A in a){if(A.startsWith("@com.sap.vocabularies.UI.v1.DataPoint")){var q=A.replace("@com.sap.vocabularies.UI.v1.DataPoint#","");var v=a[A].Value.$Path;d[v]=d[v]||{};d[v][q]=u.createDataPointProperty(a[A]);}}return d;};
u.createDataPointProperty=function(d){var D={};if(d.TargetValue){D.targetValue=d.TargetValue.$Path;}if(d.ForeCastValue){D.foreCastValue=d.ForeCastValue.$Path;}var c=null;if(d.Criticality){if(d.Criticality.$Path){c={Calculated:d.Criticality.$Path};}else{c={Static:d.Criticality.$EnumMember.replace("com.sap.vocabularies.UI.v1.CriticalityType/","")};}}else if(d.CriticalityCalculation){var t={};var C=u._buildThresholds(t,d.CriticalityCalculation);if(C){c={ConstantThresholds:t};}else{c={DynamicThresholds:t};}}if(c){D.criticality=c;}return D;};
u._buildThresholds=function(t,c){var k=["AcceptanceRangeLowValue","AcceptanceRangeHighValue","ToleranceRangeLowValue","ToleranceRangeHighValue","DeviationRangeLowValue","DeviationRangeHighValue"];var C=true,K;t.ImprovementDirection=c.ImprovementDirection.$EnumMember.replace("com.sap.vocabularies.UI.v1.ImprovementDirectionType/","");var d={oneSupplied:false,usedMeasures:[]};var o={oneSupplied:false};for(var i=0;i<k.length;i++){K=k[i];d[K]=c[K]?c[K].$Path:undefined;d.oneSupplied=d.oneSupplied||d[K];if(!d.oneSupplied){o[K]=c[K];o.oneSupplied=o.oneSupplied||o[K];}else if(d[K]){d.usedMeasures.push((d[K]));}}if(d.oneSupplied){C=false;for(var i=0;i<k.length;i++){if(d[k[i]]){t[k[i]]=d[k[i]];}}t.usedMeasures=d.usedMeasures;}else{var a;t.AggregationLevels=[];if(o.oneSupplied){a={VisibleDimensions:null};for(var i=0;i<k.length;i++){if(o[k[i]]){a[k[i]]=o[k[i]];}}t.AggregationLevels.push(a);}if(c.ConstantThresholds&&c.ConstantThresholds.length>0){for(var i=0;i<c.ConstantThresholds.length;i++){var A=c.ConstantThresholds[i];var v=A.AggregationLevel?[]:null;if(A.AggregationLevel&&A.AggregationLevel.length>0){for(var j=0;j<A.AggregationLevel.length;j++){v.push(A.AggregationLevel[j].$PropertyPath);}}a={VisibleDimensions:v};for(var j=0;j<k.length;j++){var n=A[k[j]];if(n){a[k[j]]=n;}}t.AggregationLevels.push(a);}}}return C;};
u.getSortRestrictionsInfo=function(s){var i,p,S={sortable:true,propertyInfo:{}};if(s){S.sortable=(s.Sortable!=null)?s.Sortable:true;if(s.NonSortableProperties){for(i=0;i<s.NonSortableProperties.length;i++){p=s.NonSortableProperties[i].$PropertyPath;S[p]={sortable:false};}}if(s.AscendingOnlyProperties){for(i=0;i<s.AscendingOnlyProperties;i++){p=s.AscendingOnlyProperties[i].$PropertyPath;S[p]={sortable:true,sortDirection:"asc"};}}if(s.AscendingOnlyProperties){for(i=0;i<s.DescendingOnlyProperties;i++){p=s.DescendingOnlyProperties[i].$PropertyPath;S[p]={sortable:true,sortDirection:"desc"};}}}return S;};
u.addSortInfoForProperty=function(p,s){var P=s[p.name];p.sortable=s.sortable&&P?P.sortable:true;if(p.sortable){p.sortDirection=P?P.sortDirection:"both";}};
u.getFilterRestrictionsInfo=function(f){var i,p,F={filterable:true,propertyInfo:{}};if(f){F.filterable=(f.Filterable!=null)?f.Filterable:true;F.requiresFilter=(f.RequiresFilter!=null)?f.RequiresFilter:false;F.requiredProperties=[];if(F.RequiredProperties){for(i=0;i<f.NonFilterableProperties;i++){p=f.NonFilterableProperties[i].$PropertyPath;F.requiredProperties.push(p);}}if(f.NonFilterableProperties){for(i=0;i<f.NonFilterableProperties.length;i++){p=f.NonFilterableProperties[i].$PropertyPath;F[p]={filterable:false};}}if(f.FilterExpressionRestrictions){for(i=0;i<f.FilterExpressionRestrictions;i++){p=f.FilterExpressionRestrictions[i].$PropertyPath;F[p]={filterable:true,allowedExpressions:f.FilterExpressionRestrictions[i].AllowedExpressions};}}}return F;};
u.isMultiValueFilterExpression=function(f){var i=true;switch(f){case"SearchExpression":case"SingleRange":case"SingleValue":i=false;break;default:break;}return i;};
u.addFilterInfoForProperty=function(p,f){var P=f[p.name];p.filterable=f.filterable&&P?P.filterable:true;if(p.filterable){p.allowedExpressions=P?P.allowedExpressions:null;}};
u.fetchCalendarTag=function(m,c){var C="@com.sap.vocabularies.Common.v1.";return Promise.all([m.requestObject(C+"IsCalendarYear",c),m.requestObject(C+"IsCalendarHalfyear",c),m.requestObject(C+"IsCalendarQuarter",c),m.requestObject(C+"IsCalendarMonth",c),m.requestObject(C+"IsCalendarWeek",c),m.requestObject(C+"IsDayOfCalendarMonth",c),m.requestObject(C+"IsDayOfCalendarYear",c),m.requestObject(C+"IsCalendarYearHalfyear",c),m.requestObject(C+"IsCalendarYearQuarter",c),m.requestObject(C+"IsCalendarYearMonth",c),m.requestObject(C+"IsCalendarYearWeek",c),m.requestObject(C+"IsCalendarDate",c)]).then(function(t){if(t[0]){return"year";}if(t[1]){return"halfYear";}if(t[2]){return"quarter";}if(t[3]){return"month";}if(t[4]){return"week";}if(t[5]){return"dayOfMonth";}if(t[6]){return"dayOfYear";}if(t[7]){return"yearHalfYear";}if(t[8]){return"yearQuarter";}if(t[9]){return"yearMonth";}if(t[10]){return"yearWeek";}if(t[11]){return"date";}return undefined;});};
u.fetchFiscalTag=function(m,c){var C="@com.sap.vocabularies.Common.v1.";return Promise.all([m.requestObject(C+"IsFiscalYear",c),m.requestObject(C+"IsFiscalPeriod",c),m.requestObject(C+"IsFiscalYearPeriod",c),m.requestObject(C+"IsFiscalQuarter",c),m.requestObject(C+"IsFiscalYearQuarter",c),m.requestObject(C+"IsFiscalWeek",c),m.requestObject(C+"IsFiscalYearWeek",c),m.requestObject(C+"IsDayOfFiscalYear",c),m.requestObject(C+"IsFiscalYearVariant",c)]).then(function(t){if(t[0]){return"year";}if(t[1]){return"period";}if(t[2]){return"yearPeriod";}if(t[3]){return"quarter";}if(t[4]){return"yearQuarter";}if(t[5]){return"week";}if(t[6]){return"yearWeek";}if(t[7]){return"dayOfYear";}if(t[8]){return"yearVariant";}return undefined;});};
u.fetchCriticality=function(m,c){var U="@com.sap.vocabularies.UI.v1";return m.requestObject(U+".ValueCriticality",c).then(function(v){var C,V;if(v){C={VeryPositive:[],Positive:[],Critical:[],VeryNegative:[],Negative:[],Neutral:[]};for(var i=0;i<v.length;i++){V=v[i];if(V.Criticality.$EnumMember.endsWith("VeryPositive")){C.VeryPositive.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Positive")){C.Positive.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Critical")){C.Critical.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("VeryNegative")){C.VeryNegative.push(V.Value);}else if(V.Criticality.$EnumMember.endsWith("Negative")){C.Negative.push(V.Value);}else{C.Neutral.push(V.Value);}}for(var k in C){if(C[k].length==0){delete C[k];}}}return C;});};
return u;});
sap.ui.predefine('sap/ui/mdc/odata/v4/TypeUtil',['sap/ui/mdc/odata/TypeUtil','sap/ui/mdc/enum/BaseType'],function(O,B){"use strict";var a=Object.assign({},O);
a.getBaseType=function(t,f,c){switch(t){case"sap.ui.model.odata.type.Date":return B.Date;case"sap.ui.model.odata.type.TimeOfDay":return B.Time;case"sap.ui.model.odata.type.Unit":case"sap.ui.model.odata.type.Currency":if(!f||((!f.hasOwnProperty("showMeasure")||f.showMeasure)&&(!f.hasOwnProperty("showNumber")||f.showNumber))){return B.Unit;}else if(!f.hasOwnProperty("showNumber")||f.showNumber){return B.Numeric;}else{return B.String;}default:return O.getBaseType(t,f,c);}};
a.getDataTypeClassName=function(t){var e={"Edm.Date":"sap.ui.model.odata.type.Date","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};if(e[t]){t=e[t];}else{t=O.getDataTypeClassName(t);}return t;};
a.getDataTypeInstance=function(d,f,c){switch(d){case"sap.ui.model.odata.type.DateTimeOffset":case"Edm.DateTimeOffset":if(!c){c={};}c.V4=true;break;default:}var T=this.getDataTypeClass(d);return new T(f,c);};
return a;});
sap.ui.predefine('sap/ui/mdc/p13n/PersistenceProvider',["sap/ui/core/Control","sap/ui/fl/variants/VariantManagement","sap/ui/fl/Utils","sap/ui/mdc/enum/PersistenceMode","sap/ui/layout/VerticalLayout"],function(C,V,U,m,a){"use strict";
var P=C.extend("sap.ui.mdc.p13n.PersistenceProvider",{
metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/p13n/PersistenceProvider.designtime",properties:{mode:{type:"sap.ui.mdc.enum.PersistenceMode",group:"Data",defaultValue:m.Auto}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("div",c);r.openEnd();r.close("div");}}
});
P.prototype.init=function(){C.prototype.init.apply(this,arguments);this.attachModelContextChange(this._setModel,this);this._oModelPromise=new Promise(function(r,b){this._fnResolveModel=r;}.bind(this));};
P.prototype._setModel=function(){var M=this.getModel(U.VARIANT_MODEL_NAME);if(M){this._fnResolveModel(M);}};
P.prototype.applySettings=function(){C.prototype.applySettings.apply(this,arguments);this._bmodeLocked=true;if(this.getMode()===m.Transient){var v=new V(this.getId()+"--vm",{"for":this.getAssociation("for")});this._oModelPromise.then(function(M){v.setModel(M,U.VARIANT_MODEL_NAME);});this._oWrapper=new a(this.getId()+"--accWrapper",{content:[v]});this._oWrapper.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);this.getDomRef().setAttribute("aria-hidden",true);};var s=sap.ui.getCore().getUIArea(sap.ui.getCore().getStaticAreaRef());s.addContent(this._oWrapper);}return this;};
P.prototype.setMode=function(v){if(this._bmodeLocked&&v!==this.getMode()){throw new Error("mode is a final property.");}this.setProperty("mode",v);return this;};
P.prototype.exit=function(){if(this._oWrapper){var s=sap.ui.getCore().getUIArea(sap.ui.getCore().getStaticAreaRef());s.removeContent(this._oWrapper);this._oWrapper.destroy();this._oWrapper=null;}this._oModelPromise=null;this._fnResolveModel=null;this._bmodeLocked=null;C.prototype.exit.apply(this,arguments);};
return P;});
sap.ui.predefine('sap/ui/mdc/table/RowSettings',['sap/ui/core/Element'],function(E){"use strict";
var R=E.extend("sap.ui.mdc.table.RowSettings",{metadata:{library:"sap.ui.mdc",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});
R.prototype.getAllSettings=function(){var s={},t=this.clone();if(this.isBound("navigated")){s.navigated=t.getBindingInfo("navigated");}else{s.navigated=this.getNavigated();}if(this.isBound("highlight")){s.highlight=t.getBindingInfo("highlight");}else{s.highlight=this.getHighlight();}if(this.isBound("highlightText")){s.highlightText=t.getBindingInfo("highlightText");}else{s.highlightText=this.getHighlightText();}return s;};
return R;});
sap.ui.predefine('sap/ui/mdc/ui/ContainerItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.ui.mdc.ui.ContainerItem",{metadata:{library:"sap.ui.mdc",properties:{key:{type:"string",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
C.prototype.setContent=function(c){this.setAggregation("content",c);if(c){this._oContent=c;}return this;};
C.prototype.getContent=function(){return this._oContent;};
C.prototype.destroy=function(){E.prototype.destroy.apply(this,arguments);if(this._oContent){this._oContent.destroy();this._oContent=null;}};
return C;});
sap.ui.predefine('sap/ui/mdc/util/DateUtil',['sap/ui/core/library','sap/ui/core/date/UniversalDate','sap/base/util/merge'],function(c,U,m){"use strict";var C=c.CalendarType;var D={typeToUniversalDate:function(d,t){var s=this.typeToString(d,t,"yyyyMMdd");var y=parseInt(s.slice(0,4));var M=parseInt(s.slice(4,6))-1;var i=parseInt(s.slice(6,8));var u=new U(U.UTC(y,M,i));return u;},universalDateToType:function(d,t){var y=d.getUTCFullYear();var M=d.getUTCMonth()+1;var i=d.getUTCDate();var s=y.toString()+((M<10)?"0":"")+M.toString()+((i<10)?"0":"")+i.toString();var v=this.stringToType(s,t,"yyyyMMdd");return v;},createInternalType:function(t,p){var T=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));var o=m({},t.getConstraints());var f=m({},t.getFormatOptions());if(f.style){delete f.style;}f.pattern=p;f.calendarType=C.Gregorian;return new T(f,o);},typeToString:function(d,t,p){var i=this.createInternalType(t,p);var s=i.formatValue(d,"string");return s;},stringToType:function(d,t,p){var i=this.createInternalType(t,p);var v=i.parseValue(d,"string");return v;},localToUtc:function(d){return new Date(Date.UTC(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes(),d.getSeconds(),d.getMilliseconds()));},utcToLocal:function(d){return new Date(d.getUTCFullYear(),d.getUTCMonth(),d.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds(),d.getUTCMilliseconds());}};return D;});
sap.ui.predefine('sap/ui/mdc/util/PromiseCache',["sap/ui/base/Object"],function(B){"use strict";var _=function(n){if(!n){throw new Error("PromiseCache: Please provide an identifier!");}if(this._oCache&&this._oCache[n]){this.remove.call(this,n);}};var a=function(p){if(typeof p==="object"&&this._oCache){for(var k in this._oCache){if(this._oCache[k].promise===p){return k;}}}};var b=function(p,t){var k=typeof p==="string"?p:a.call(this,p);var c=k&&this._oCache&&this._oCache[k];if(t&&!c){throw new Error("PromiseCache: Promise not found!");}return c;};
var P=B.extend("sap.ui.mdc.util.PromiseCache",{
constructor:function(){this._oCache={};},
add:function(n,c){_.call(this,n);var p={};this._oCache[n]=p;p.promise=new Promise(function(r,e){p.resolve=function(R){if(!p._isCanceled){p._isSettled=true;r(R);}};p.reject=function(E){if(!p._isCanceled){p._isSettled=true;e(E);}};});p.promise.isSettled=function(){return!!p._isSettled;};p.promise.isCanceled=function(){return!!p._isCanceled;};p.promise.getInternalPromise=function(){return p._promise;};if(c){var i=typeof c==="function";var I=!i&&typeof c.then==="function";if(!i&&!I){throw new Error("PromiseCache: fnCreate must be a promise or function");}var C=i?c():c;var d=C&&typeof C.then==="function";if(d){p._promise=C;p._promise.then(function(r){if(!p._isCanceled){p._isSettled=true;p.resolve(r);}return r;},function(e){if(!p._isCanceled){p._isSettled=true;p.reject(e);}});}else{p.resolve(C);}}return this._oCache[n].promise;},
cancel:function(p){var o=b.call(this,p,true);if(!o._isSettled){o._isCanceled=true;}return o.promise;},
retrieve:function(n,c){var p=this._oCache&&this._oCache[n];if(!p&&c){return this.add.apply(this,[n,c]);}return p&&p.promise;},
retrieveMany:function(){var r=[];var k=arguments.length?[].slice.call(arguments):Object.keys(this._oCache);for(var i=0;i<k.length;i++){r.push(this.retrieve(k[i].toString()));}return r;},
remove:function(p){var k=typeof p==="string"?p:a.call(this,p);var c=k&&this._oCache&&this._oCache[k];if(c){c._isCanceled=true;delete this._oCache[k];}},
resolve:function(p,v){var c=b.call(this,p,true);c.resolve(v);return c.promise;},
reject:function(p,v){var c=b.call(this,p,true);c.reject(v);return c.promise;},
clear:function(){Object.keys(this._oCache).forEach(function(k){this.remove(k);}.bind(this));},
destroy:function(){this.clear();this._oCache=null;}
});
return P;});
sap.ui.predefine('sap/ui/mdc/util/TypeUtil',['sap/ui/mdc/enum/BaseType','sap/base/util/ObjectPath','sap/ui/model/SimpleType'],function(B,O,S){"use strict";var T={getDataTypeClassName:function(t){var m={"Boolean":"sap.ui.model.type.Boolean","Currency":"sap.ui.model.type.Currency","Date":"sap.ui.model.type.Date","DateTime":"sap.ui.model.type.DateTime","Float":"sap.ui.model.type.Float","Integer":"sap.ui.model.type.Integer","String":"sap.ui.model.type.String","Time":"sap.ui.model.type.Time","Unit":"sap.ui.model.type.Unit"};if(m[t]){t=m[t];}return t;},getBaseType:function(t,f,c){switch(t){case"sap.ui.model.type.Date":return B.Date;case"sap.ui.model.type.DateTime":return B.DateTime;case"sap.ui.model.type.Time":return B.Time;case"sap.ui.model.type.Boolean":return B.Boolean;case"sap.ui.model.type.Unit":case"sap.ui.model.type.Currency":if(!f||((!f.hasOwnProperty("showMeasure")||f.showMeasure)&&(!f.hasOwnProperty("showNumber")||f.showNumber))){return B.Unit;}else if(!f.hasOwnProperty("showNumber")||f.showNumber){return B.Numeric;}else{return B.String;}case"sap.ui.model.type.Integer":case"sap.ui.model.type.Float":return B.Numeric;default:return B.String;}},getBaseTypeForType:function(t){return this.getBaseType(t.getMetadata&&t.getMetadata().getName(),t.getFormatOptions(),t.getConstraints());},getDataTypeClass:function(d){var a=O.get(this.getDataTypeClassName(d)||"");if(!a){throw new Error("DataType '"+d+"' cannot be determined");}return a;},getDataTypeInstance:function(d,f,c){var a=this.getDataTypeClass(d);return new a(f,c);},getTypeConfig:function(t,f,c){var o,d;if(t instanceof S){o=t;}else{var D=this.getDataTypeClassName(t);d=D?t:undefined;o=this.getDataTypeInstance(D||t,f,c);}return{className:d,typeInstance:o,baseType:this.getBaseTypeForType(o)};}};return T;});
sap.ui.predefine('sap/ui/mdc/util/loadModules',["sap/ui/base/SyncPromise","sap/base/assert"],function(S,a){"use strict";return function l(m){a(typeof m==="string"||Array.isArray(m),"vModulePaths"+" param either must be a single string or an array of strings. - sap.ui.mdc.util.loadModules");var M;if(typeof m==="string"){M=[m];}else{M=m;}var o=new Map();M.forEach(function(s){var v=sap.ui.require(s);o.set(s,v);});var n=M.filter(function(s){return o.get(s)===undefined;});if(n.length===0){var b=Array.from(o.values());return S.resolve(b);}return new S(function(r,c){function d(){var N=Array.from(arguments);n.forEach(function(s,i){o.set(s,N[i]);});var b=Array.from(o.values());r(b);}sap.ui.require(n,d,c);});};});
sap.ui.require.preload({
	"sap/ui/mdc/field/ValueHelpPanel.control.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:fl="sap.ui.fl.variants" xmlns:mvc="sap.ui.core.mvc" xmlns:mdc="sap.ui.mdc" xmlns:l="sap.ui.layout"><VBox id="rootVBox" fitContainer="true" class="sapMdcValueHelpPanel"><IconTabBar id="iconTabBar" expandable="false" upperCase="false" stretchContentHeight="true" class="sapUiNoContentPadding" select="iconTabSelect"><layoutData><FlexItemData growFactor="1" shrinkFactor="1"/></layoutData><items><IconTabFilter id="fromList" text="{parts:[\'$i18n&gt;valuehelp.SELECTFROMLIST\',\'$this&gt;/conditions\'],formatter:\'._formatListTabTitle\'}" key="selectFromList" visible="false"><l:FixFlex minFlexSize="200px"><l:fixContent><VBox id="filterbarVBox" visible="{$this&gt;/_filterBarVisible}" class="sapMdcValueHelpPanelFilterbar"/></l:fixContent><l:flexContent><Panel id="tablePanel" headerText="{parts:[\'$i18n&gt;valuehelp.TABLETITLE\'],formatter:\'._formatTableTitle\'}" class="sapMdcTablePanel" expanded="true" height="100%"><layoutData><FlexItemData growFactor="1" shrinkFactor="1"/></layoutData></Panel></l:flexContent></l:FixFlex></IconTabFilter><IconTabFilter id="defineCondition" text="{parts:[\'$i18n&gt;valuehelp.DEFINECONDITIONS\',\'$this&gt;/conditions\'],formatter:\'._formatDefineTabTitle\'}" key="defineCondition" visible="false"><ScrollContainer id="defineConditionPanel" height="100%" horizontal="false" vertical="true"/></IconTabFilter></items></IconTabBar><Panel id="VHPTokenizerPanel" class="sapMdcTokenizerPanel" backgroundDesign="Transparent" expanded="true" headerText="{parts:[\'$i18n&gt;valuehelp.TOKENIZERTITLE\',\'$this&gt;/conditions\'],formatter:\'._formatTokenizerTitle\'}"><HBox fitContainer="true" width="100%"><items><Tokenizer id="VHPTokenizer" class="sapMdcTokenizer" width="100%" visible="{path:\'$this&gt;/showTokenizer\'}" tokenDelete="_handleTokenDelete" tokens="{path:\'$this&gt;/conditions\',filters:[{path:\'isEmpty\',operator:\'NE\',value1:true}],templateShareable:false}"><Token id="VHPToken" text="{path:\'$this&gt;\',type:\'sap.ui.mdc.field.ConditionType\'}"/><layoutData><FlexItemData growFactor="1" maxWidth="calc(100% - 2rem)"/></layoutData></Tokenizer><Button id="removeAllBtn" press="_onRemoveAllConditions" type="Transparent" icon="sap-icon://decline" tooltip="{$i18n&gt;valuehelp.REMOVEALLTOKEN}" class="sapUiTinyMarginBegin"><layoutData><FlexItemData growFactor="0" baseSize="2rem"/></layoutData></Button></items></HBox></Panel></VBox></core:FragmentDefinition>',
	"sap/ui/mdc/link/ContactDetails.control.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:f="sap.ui.layout.form"><m:VBox items="{path:\'$this&gt;/items\',templateShareable:false}" aria-labelledby="IDContactDetailsTitle"><f:SimpleForm id="IDSimpleForm" editable="false" layout="ResponsiveGridLayout"><core:Title id="IDContactDetailsTitle" text="{$this&gt;sectionTitle}"/><m:Label text="" labelFor="IDImage" visible="{= !!${$this&gt;photo}}"/><m:Image id="IDImage" src="{$this&gt;photo}" decorative="false" width="5rem" height="5rem" visible="{= !!${$this&gt;photo}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_NAME}" labelFor="IDName" visible="{= !!${$this&gt;formattedName}}"/><m:Text id="IDName" text="{$this&gt;formattedName}" visible="{= !!${$this&gt;formattedName}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_ROLE}" labelFor="IDRole" visible="{= !!${$this&gt;role}}"/><m:Text id="IDRole" text="{$this&gt;role}" visible="{= !!${$this&gt;role}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_JOBTITLE}" labelFor="IDTitle" visible="{= !!${$this&gt;title}}"/><m:Text id="IDTitle" text="{$this&gt;title}" visible="{= !!${$this&gt;title}}"/><m:Label text="{$this.i18n&gt;info.POPOVER_CONTACT_SECTION_DEPARTMENT}" labelFor="IDOrg" visible="{= !!${$this&gt;org}}"/><m:Text id="IDOrg" text="{$this&gt;org}" visible="{= !!${$this&gt;org}}"/></f:SimpleForm></m:VBox></core:FragmentDefinition>',
	"sap/ui/mdc/link/Panel.control.xml":'<core:FragmentDefinition xmlns:mdcLink="sap.ui.mdc.link" xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout"><l:VerticalLayout width="calc(100% - 2rem)" class="mdcbaseinfoPanel"><m:VBox id="idSectionAdditionalContent" fitContainer="false"/><m:VBox fitContainer="false" class="mdcbaseinfoPanelSeparator" visible="{= ${$sapuimdclinkPanel&gt;/countAdditionalContent} &gt; 0 &amp;&amp; ${$sapuimdcLink&gt;/metadata}.length &gt; 0}"/><m:VBox id="idSectionLinks" fitContainer="false" class="mdcbaseinfoPanelSectionLinks" items="{path:\'$sapuimdclinkPanel&gt;/runtimeItems\',templateShareable:false}"><mdcLink:PanelListItem key="{$sapuimdclinkPanel&gt;id}" visible="{$sapuimdclinkPanel&gt;visible}" text="{$sapuimdclinkPanel&gt;text}" description="{$sapuimdclinkPanel&gt;description}" href="{$sapuimdclinkPanel&gt;href}" icon="{$sapuimdclinkPanel&gt;icon}" target="{$sapuimdclinkPanel&gt;target}" pressLink="onPressLink"/></m:VBox><m:HBox visible="{= ${$sapuimdcLink&gt;/metadata}.length &gt; 0}" id="idSectionPersonalizationButton" justifyContent="End" class="mdcbaseinfoPanelPersonalizationButton"><m:Button id="idPersonalizationButton" type="Transparent" text="{$this.i18n&gt;info.POPOVER_DEFINE_LINKS}" press="onPressLinkPersonalization"/></m:HBox></l:VerticalLayout></core:FragmentDefinition>',
	"sap/ui/mdc/link/PanelListItem.control.xml":'<core:FragmentDefinition xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout"><l:HorizontalLayout id="idLayout" class="mdcbaseinfoPanelListItem"><m:HBox id="idContainer" visible="{$this&gt;visible}"><m:layoutData><m:FlexItemData styleClass="{= ${$this&gt;description} ? \'mdcbaseinfoPanelItemsGroup\' : \'mdcbaseinfoPanelItemsWithoutGroup\'}"/></m:layoutData><m:ImageContent src="{$this&gt;icon}" visible="{= ${$this&gt;icon} ? true:false}"/><m:VBox><m:Link text="{$this&gt;text}" href="{$this&gt;href}" target="{$this&gt;target}" visible="{= ${$this&gt;href} ? true:false}" press="onPress" wrapping="true"/><m:Label text="{$this&gt;text}" visible="{= ${$this&gt;href} ? false:true}" wrapping="true"/><m:Text text="{$this&gt;description}" visible="{= ${$this&gt;description} ? true:false}" wrapping="true"/></m:VBox></m:HBox></l:HorizontalLayout></core:FragmentDefinition>',
	"sap/ui/mdc/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.mdc","type":"library","embeds":[],"applicationVersion":{"version":"1.98.0"},"title":"UI5 library: sap.ui.mdc","description":"UI5 library: sap.ui.mdc","ach":"CA-UI5-MDC","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"BooleanExpressionEvaluator","packagedWithMySelf":true,"version":"master-18530acbf3"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.98","libs":{"sap.ui.core":{"minVersion":"1.98.0"},"sap.m":{"minVersion":"1.98.0"},"sap.ui.layout":{"minVersion":"1.98.0","lazy":true}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.mdc.Table","sap.ui.mdc.FilterBar","sap.ui.mdc.field.FieldBase","sap.ui.mdc.field.FieldInput","sap.ui.mdc.field.FieldMultiInput","sap.ui.mdc.field.ValueHelpPanel","sap.ui.mdc.field.DefineConditionPanel","sap.ui.mdc.Field","sap.ui.mdc.FilterField","sap.ui.mdc.MultiValueField","sap.ui.mdc.link.Panel","sap.ui.mdc.link.ContactDetails","sap.ui.mdc.ui.Container","sap.ui.mdc.Chart","sap.ui.mdc.p13n.PersistenceProvider"],"elements":["sap.ui.mdc.table.Column","sap.ui.mdc.table.CreationRow","sap.ui.mdc.table.TableTypeBase","sap.ui.mdc.table.GridTableType","sap.ui.mdc.table.ResponsiveTableType","sap.ui.mdc.table.RowSettings","sap.ui.mdc.chart.Item","sap.ui.mdc.chart.ChartSelectionDetails","sap.ui.mdc.chart.ChartToolbar","sap.ui.mdc.chart.ChartTypeButton","sap.ui.mdc.chart.DrillBreadcrumbs","sap.ui.mdc.chart.SelectionDetailsActions","sap.ui.mdc.field.CustomFieldHelp","sap.ui.mdc.field.CustomFieldInfo","sap.ui.mdc.field.FieldHelpBase","sap.ui.mdc.field.FieldInfoBase","sap.ui.mdc.field.FieldValueHelp","sap.ui.mdc.field.FieldValueHelpContentWrapperBase","sap.ui.mdc.field.FieldValueHelpTableWrapperBase","sap.ui.mdc.field.FieldValueHelpMdcTableWrapper","sap.ui.mdc.field.FieldValueHelpMTableWrapper","sap.ui.mdc.field.FieldValueHelpUITableWrapper","sap.ui.mdc.field.ListFieldHelp","sap.ui.mdc.field.ListFieldHelpItem","sap.ui.mdc.field.BoolFieldHelp","sap.ui.mdc.field.ConditionFieldHelp","sap.ui.mdc.filterbar.aligned.FilterItemLayout","sap.ui.mdc.link.ContactDetailsAddressItem","sap.ui.mdc.link.ContactDetailsEmailItem","sap.ui.mdc.link.ContactDetailsItem","sap.ui.mdc.link.ContactDetailsPhoneItem","sap.ui.mdc.link.LinkItem","sap.ui.mdc.link.PanelItem","sap.ui.mdc.link.SemanticObjectUnavailableAction","sap.ui.mdc.link.SemanticObjectMapping","sap.ui.mdc.link.SemanticObjectMappingItem","sap.ui.mdc.field.InParameter","sap.ui.mdc.field.OutParameter","sap.ui.mdc.ui.ContainerItem","sap.ui.mdc.field.MultiValueFieldItem","sap.ui.mdc.ValueHelp","sap.ui.mdc.valuehelp.Popover","sap.ui.mdc.valuehelp.Dialog","sap.ui.mdc.valuehelp.content.Bool","sap.ui.mdc.valuehelp.content.Conditions","sap.ui.mdc.valuehelp.content.FixedList","sap.ui.mdc.valuehelp.content.MDCTable","sap.ui.mdc.valuehelp.content.MTable"],"types":["sap.ui.mdc.TableType","sap.ui.mdc.TableP13Mode","sap.ui.mdc.GrowingMode","sap.ui.mdc.RowCountMode","sap.ui.mdc.SelectionMode","sap.ui.mdc.TableRowAction","sap.ui.mdc.FilterExpression","sap.ui.mdc.MultiSelectMode"],"interfaces":["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState","sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent","sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer"]}}}}'
},"sap/ui/mdc/library-preload"
);
//# sourceMappingURL=library-preload.js.map