/*
 * ! OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element','sap/ui/mdc/mixin/PromiseMixin','sap/ui/model/BindingMode','sap/ui/base/ManagedObjectObserver'],function(E,P,B,M){"use strict";var C=E.extend("sap.ui.mdc.valuehelp.base.Container",{metadata:{library:"sap.ui.mdc",properties:{title:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{_container:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},content:{type:"sap.ui.mdc.valuehelp.base.Content",multiple:true}},events:{select:{parameters:{type:{type:"sap.ui.mdc.enum.SelectType"},conditions:{type:"object[]"}}},confirm:{parameters:{close:{type:"boolean"}}},opened:{},closed:{},cancel:{},requestDelegateContent:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"}}},requestSwitchToDialog:{},navigated:{parameters:{bLeaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"}}}}}});C.prototype.init=function(){this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]});};C.prototype._observeChanges=function(c){if(c.name==="content"){var o=c.child;if(c.mutation==="remove"){o.unbindProperty("filterValue");o.unbindProperty("conditions");o.unbindProperty("config");o.detachConfirm(this._handleConfirmed,this);o.detachCancel(this._handleCanceled,this);o.detachSelect(this._handleSelect,this);o.detachRequestDelegateContent(this._handleRequestDelegateContent,this);if(o.detachNavigated){o.detachNavigated(this._handleNavigated,this);}if(o.detachRequestSwitchToDialog){o.detachRequestSwitchToDialog(this._handleRequestSwitchToDialog,this);}}else{o.bindProperty("filterValue",{path:"/filterValue",model:"$valueHelp",mode:B.OneWay});var b={path:"/conditions",model:"$valueHelp",mode:B.OneWay};if(o._formatConditions){b.formatter=o._formatConditions.bind(o);}o.bindProperty("conditions",b);o.bindProperty("config",{path:"/_config",model:"$valueHelp",mode:B.OneWay});o.attachConfirm(this._handleConfirmed,this);o.attachCancel(this._handleCanceled,this);o.attachSelect(this._handleSelect,this);o.attachRequestDelegateContent(this._handleRequestDelegateContent,this);if(o.attachNavigated){o.attachNavigated(this._handleNavigated,this);}if(o.attachRequestSwitchToDialog){o.attachRequestSwitchToDialog(this._handleRequestSwitchToDialog,this);}}}};C.prototype._handleNavigated=function(e){this.fireNavigated(e.mParameters);};C.prototype._handleRequestSwitchToDialog=function(e){this.fireRequestSwitchToDialog({container:this});};C.prototype._getContainer=function(){};C.prototype._getControl=function(){var v=this.getParent();return v&&v.getControl();};C.prototype.getMaxConditions=function(){var v=this.getModel("$valueHelp");return v&&v.getObject("/_config/maxConditions");};C.prototype._isSingleSelect=function(){return this.getMaxConditions()===1;};C.prototype.getDomRef=function(){var c=this.getAggregation("_container");return c&&c.getDomRef();};C.prototype.getUIArea=function(){return null;};C.prototype._getUIAreaForContent=function(){return this.getUIArea();};C.prototype.open=function(v){if(!this.isOpening()){var o=this._addPromise("open");return Promise.all([this._getContainer(),v]).then(function(r){return this._placeContent(r[0]);}.bind(this)).then(function(c){if(!o.isCanceled()){this._open(c);}return o;}.bind(this));}return this._retrievePromise("open");};C.prototype.close=function(){var p=this._retrievePromise("open");if(p){if(p.isSettled()){this._close();}else{this._cancelPromise(p);}}};C.prototype._placeContent=function(c){return c;};C.prototype._open=function(c){};C.prototype._close=function(){};C.prototype._handleOpened=function(){this._resolvePromise("open");this.fireOpened();};C.prototype._handleClosed=function(e){this._removePromise("open");this.fireClosed();};C.prototype._handleConfirmed=function(e){this.fireConfirm();};C.prototype._handleCanceled=function(e){this.fireCancel();};C.prototype._handleRequestDelegateContent=function(e){this.fireRequestDelegateContent({container:this});};C.prototype._handleSelect=function(e){this.fireSelect({type:e.getParameter("type"),conditions:e.getParameter("conditions")});};C.prototype.isOpen=function(){var p=this._retrievePromise("open");return p&&p.isSettled();};C.prototype.isOpening=function(){var p=this._retrievePromise("open");return p&&!p.isCanceled()&&!p.isSettled();};C.prototype.getItemForValue=function(c){};C.prototype.isValidationSupported=function(){return false;};C.prototype.navigate=function(s){return Promise.all([this._getContainer()]).then(function(r){return this._placeContent(r[0]);}.bind(this)).then(function(c){this._navigate(s);}.bind(this));};C.prototype._navigate=function(s){};C.prototype.removeFocus=function(){};C.prototype.isTypeahead=function(){var v=this.getParent();return v&&v.getTypeahead()===this;};C.prototype.isTypeaheadSupported=function(){return false;};C.prototype.providesScrolling=function(){return false;};C.prototype.getValueHelpDelegate=function(){var v=this.getParent();return v&&v.getControlDelegate();};C.prototype.getValueHelpDelegatePayload=function(){var v=this.getParent();return v&&v.getPayload();};C.prototype.awaitValueHelpDelegate=function(){var v=this.getParent();return v&&v.awaitControlDelegate();};C.prototype.isValueHelpDelegateInitialized=function(){var v=this.getParent();return v&&v.bDelegateInitialized;};C.prototype.getUseAsValueHelp=function(){return false;};C.prototype.getValueHelpIcon=function(){};C.prototype.getAriaAttributes=function(m){return{contentId:null,ariaHasPopup:"listbox",role:"combobox",roleDescription:null};};C.prototype.getScrollDelegate=function(m){var c=this.getAggregation("_container");return c&&c.getScrollDelegate&&c.getScrollDelegate();};C.prototype.shouldOpenOnClick=function(){return false;};C.prototype.shouldOpenOnNavigate=function(){return false;};C.prototype.isFocusInHelp=function(){return!this.isTypeahead();};C.prototype.isMultiSelect=function(){return false;};C.prototype._getContainerConfig=function(c){var o=c&&c.getContainerConfig();var r=o&&o[this.getMetadata().getName()];if(!r&&o){var t=Object.keys(o);var n=t.find(function(T){return this.isA(T);}.bind(this));if(n){r=o[n];}}return r;};C.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined;};P.call(C.prototype);return C;});
