/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/message/MessageProcessor','./BindingMode','./Context','./Filter',"sap/base/util/deepEqual","sap/base/util/each"],function(M,B,C,F,d,e){"use strict";var a=M.extend("sap.ui.model.Model",{constructor:function(){M.apply(this,arguments);this.aBindings=[];this.oBindingsToRemove=new Set();this.mContexts={};this.oData={};this.sDefaultBindingMode=B.TwoWay;this.bDestroyed=false;this.bForceUpdate=undefined;this.bLegacySyntax=false;this.mMessages={};this.sRemoveTimer=null;this.iSizeLimit=100;this.mSupportedBindingModes={"OneWay":true,"TwoWay":true,"OneTime":true};this.mUnsupportedFilterOperators={};this.sUpdateTimer=null;},metadata:{"abstract":true,publicMethods:["bindProperty","bindList","bindTree","bindContext","createBindingContext","destroyBindingContext","getProperty","getDefaultBindingMode","setDefaultBindingMode","isBindingModeSupported","attachParseError","detachParseError","attachRequestCompleted","detachRequestCompleted","attachRequestFailed","detachRequestFailed","attachRequestSent","detachRequestSent","attachPropertyChange","detachPropertyChange","setSizeLimit","refresh","isList","getObject"]}});a.M_EVENTS={ParseError:"parseError",RequestFailed:"requestFailed",RequestSent:"requestSent",RequestCompleted:"requestCompleted",PropertyChange:"propertyChange"};a.prototype.attachRequestFailed=function(D,f,l){this.attachEvent("requestFailed",D,f,l);return this;};a.prototype.detachRequestFailed=function(f,l){this.detachEvent("requestFailed",f,l);return this;};a.prototype.fireRequestFailed=function(p){this.fireEvent("requestFailed",p);return this;};a.prototype.attachParseError=function(D,f,l){this.attachEvent("parseError",D,f,l);return this;};a.prototype.detachParseError=function(f,l){this.detachEvent("parseError",f,l);return this;};a.prototype.fireParseError=function(p){this.fireEvent("parseError",p);return this;};a.prototype.attachRequestSent=function(D,f,l){this.attachEvent("requestSent",D,f,l);return this;};a.prototype.detachRequestSent=function(f,l){this.detachEvent("requestSent",f,l);return this;};a.prototype.fireRequestSent=function(p){this.fireEvent("requestSent",p);return this;};a.prototype.attachRequestCompleted=function(D,f,l){this.attachEvent("requestCompleted",D,f,l);return this;};a.prototype.detachRequestCompleted=function(f,l){this.detachEvent("requestCompleted",f,l);return this;};a.prototype.fireRequestCompleted=function(p){this.fireEvent("requestCompleted",p);return this;};a.prototype.attachMessageChange=function(D,f,l){this.attachEvent("messageChange",D,f,l);return this;};a.prototype.detachMessageChange=function(f,l){this.detachEvent("messageChange",f,l);return this;};a.prototype.firePropertyChange=function(p){this.fireEvent("propertyChange",p);return this;};a.prototype.attachPropertyChange=function(D,f,l){this.attachEvent("propertyChange",D,f,l);return this;};a.prototype.detachPropertyChange=function(f,l){this.detachEvent("propertyChange",f,l);return this;};a.prototype.getObject=function(p,c,P){return this.getProperty(p,c,P);};a.prototype.getContext=function(p){if(!p.startsWith("/")){throw new Error("Path "+p+" must start with a / ");}var c=this.mContexts[p];if(!c){c=new C(this,p);this.mContexts[p]=c;}return c;};a.prototype.resolve=function(p,c){var i=typeof p=="string"&&!p.startsWith("/"),r=p,s;if(i){if(c){s=c.getPath();r=s+(s.endsWith("/")?"":"/")+p;}else{r=this.isLegacySyntax()?"/"+p:undefined;}}if(!p&&c){r=c.getPath();}if(r&&r!=="/"&&r.endsWith("/")){r=r.substr(0,r.length-1);}return r;};a.prototype._cleanUpBindings=function(){var b=this.oBindingsToRemove;if(b.size>0){this.aBindings=this.aBindings.filter(function(o){return!b.has(o);});b.clear();}};a.prototype.addBinding=function(b){this._cleanUpBindings();this.aBindings.push(b);};a.prototype.getBindings=function(){this._cleanUpBindings();return this.aBindings.slice();};a.prototype.removeBinding=function(b){this.oBindingsToRemove.add(b);if(!this.sRemoveTimer){this.sRemoveTimer=setTimeout(function(){this.sRemoveTimer=null;this._cleanUpBindings();}.bind(this),0);}};a.prototype.getDefaultBindingMode=function(){return this.sDefaultBindingMode;};a.prototype.setDefaultBindingMode=function(m){if(this.isBindingModeSupported(m)){this.sDefaultBindingMode=m;return this;}throw new Error("Binding mode "+m+" is not supported by this model.",this);};a.prototype.isBindingModeSupported=function(m){return(m in this.mSupportedBindingModes);};a.prototype.setLegacySyntax=function(l){this.bLegacySyntax=l;};a.prototype.isLegacySyntax=function(){return this.bLegacySyntax;};a.prototype.setSizeLimit=function(s){this.iSizeLimit=s;};a.prototype.getInterface=function(){return this;};a.prototype.refresh=function(f){this.checkUpdate(f);if(f){var m=[];for(var k in this.mMessages){m=m.concat(this.mMessages[k]);}this.fireMessageChange({oldMessages:m});}};a.prototype.checkUpdate=function(f,A){if(A){this.bForceUpdate=this.bForceUpdate||f;if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(this.bForceUpdate);}.bind(this),0);}return;}f=this.bForceUpdate||f;if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;this.bForceUpdate=undefined;}var b=this.getBindings();e(b,function(i,o){o.checkUpdate(f);});};a.prototype.setMessages=function(m){m=m||{};if(!d(this.mMessages,m)){this.mMessages=m;this.checkMessages();}};a.prototype.getMessagesByPath=function(p,P){var m=new Set(),t=this;if(!P){return this.mMessages[p]||[];}Object.keys(this.mMessages).forEach(function(s){t.filterMatchingMessages(s,p).forEach(function(o){m.add(o);});});return Array.from(m);};a.prototype.filterMatchingMessages=function(m,p){if(m===p||m.startsWith(p==="/"?p:p+"/")){return this.mMessages[m];}return[];};a.prototype.checkMessages=function(){e(this.getBindings(),function(i,b){if(b.checkDataState){b.checkDataState();}});};a.prototype.destroy=function(){M.prototype.destroy.apply(this,arguments);this.oData={};this.aBindings=[];this.mContexts={};if(this.sRemoveTimer){clearTimeout(this.sRemoveTimer);this.sRemoveTimer=null;this.oBindingsToRemove.clear();}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;}this.bDestroyed=true;};a.prototype.getMetaModel=function(){return undefined;};a.prototype.getOriginalProperty=function(p,c){return this.getProperty(p,c);};a.prototype.isLaundering=function(p,c){return false;};a.prototype.checkFilterOperation=function(f){_(f,function(o){if(this.mUnsupportedFilterOperators[o.sOperator]){throw new Error("Filter instances contain an unsupported FilterOperator: "+o.sOperator);}}.bind(this));};function _(f,c){f=f||[];if(f instanceof F){f=[f];}for(var i=0;i<f.length;i++){var o=f[i];c(o);_(o.oCondition,c);_(o.aFilters,c);}}return a;});
